/*
 * Decompiled with CFR 0.152.
 */
package kr.co.shineware.nlp.komoran.core.analyzer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kr.co.shineware.ds.trie.TrieDictionary;
import kr.co.shineware.ds.trie.model.TrieNode;
import kr.co.shineware.nlp.komoran.b.b;
import kr.co.shineware.nlp.komoran.c.a;
import kr.co.shineware.nlp.komoran.core.analyzer.model.PrevNodes;
import kr.co.shineware.nlp.komoran.core.lattice.Lattice;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularNode;
import kr.co.shineware.nlp.komoran.modeler.model.IrregularTrie;
import kr.co.shineware.nlp.komoran.modeler.model.Observation;
import kr.co.shineware.nlp.komoran.modeler.model.PosTable;
import kr.co.shineware.nlp.komoran.modeler.model.Transition;
import kr.co.shineware.util.common.model.Pair;
import kr.co.shineware.util.common.string.StringUtil;

public class Komoran {
    private Observation observation;
    private IrregularTrie irrTrie;
    private Transition transition;
    private PosTable table;
    private PrevNodes prevNodesRegular;
    private PrevNodes prevNodesIrregular;
    private List prevNodesExpand;
    private b unitParser;
    private Lattice lattice;
    private String ruleMorph;
    private String rulePos;
    private int ruleBeginIdx;
    private HashMap fwd;

    public Komoran(String string) {
        this.init();
        this.load(string);
    }

    private void init() {
        this.table = null;
        this.observation = null;
        this.transition = null;
        this.unitParser = null;
        this.irrTrie = null;
        this.table = new PosTable();
        this.observation = new Observation();
        this.transition = new Transition();
        this.unitParser = new a();
        this.irrTrie = new IrregularTrie();
    }

    private void load(String string) {
        this.table.load(String.valueOf(string) + File.separator + "pos.table");
        this.observation.load(String.valueOf(string) + File.separator + "observation.model");
        this.transition.load(String.valueOf(string) + File.separator + "transition.model");
        this.irrTrie.load(String.valueOf(string) + File.separator + "irregular.model");
    }

    public List analyzeWithoutSpace(String object) {
        ArrayList arrayList = new ArrayList();
        String[] stringArray = object = object.split("[ ]+");
        int n = ((String[])object).length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray[n2];
            arrayList.addAll(this.analyze((String)object));
            ++n2;
        }
        return arrayList;
    }

    public List analyze(String string, int n) {
        if (n <= 0) {
            return new ArrayList();
        }
        if (string.trim().length() == 0) {
            return new ArrayList();
        }
        this.lattice = null;
        this.lattice = new Lattice(this.table);
        this.lattice.setTransition(this.transition);
        this.lattice.setNbest(n);
        this.prevNodesRegular = null;
        this.prevNodesRegular = new PrevNodes();
        this.prevNodesIrregular = null;
        this.prevNodesIrregular = new PrevNodes();
        this.prevNodesExpand = null;
        this.prevNodesExpand = new ArrayList();
        this.ruleMorph = "";
        this.rulePos = "";
        this.ruleBeginIdx = 0;
        string = this.unitParser.a(string.trim());
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = this.lookupFwd(string, n2);
            if (n3 != -1) {
                n2 = n3 - 1;
            } else {
                this.ruleParsing(string, n2);
                this.symbolParsing(string, n2);
                this.irregularExpandParsing(string, n2, this.observation.getTrieDictionary());
                this.regularParsing(string, n2, this.observation.getTrieDictionary());
                this.irregularParsing(string, n2, this.irrTrie.getTrieDictionary());
                if (string.charAt(n2) == ' ') {
                    this.lattice.bridgingSpace(string, n2);
                    this.lattice.setPrevStartIdx(n2 + 1);
                }
            }
            ++n2;
        }
        this.consumeRuleParserBuffer(string);
        this.lattice.setEndIdx(string.length());
        if (n > 1) {
            return this.lattice.getNbest(string);
        }
        ArrayList<List> arrayList = new ArrayList<List>();
        arrayList.add(this.lattice.getMax(string));
        return arrayList;
    }

    public List analyze(String string) {
        if (string.trim().length() == 0) {
            return new ArrayList();
        }
        this.lattice = null;
        this.lattice = new Lattice(this.table);
        this.lattice.setTransition(this.transition);
        this.prevNodesRegular = null;
        this.prevNodesRegular = new PrevNodes();
        this.prevNodesIrregular = null;
        this.prevNodesIrregular = new PrevNodes();
        this.prevNodesExpand = null;
        this.prevNodesExpand = new ArrayList();
        this.ruleMorph = "";
        this.rulePos = "";
        this.ruleBeginIdx = 0;
        string = this.unitParser.a(string.trim());
        int n = 0;
        while (n < string.length()) {
            int n2 = this.lookupFwd(string, n);
            if (n2 != -1) {
                n = n2 - 1;
            } else {
                this.ruleParsing(string, n);
                this.symbolParsing(string, n);
                this.irregularExpandParsing(string, n, this.observation.getTrieDictionary());
                this.regularParsing(string, n, this.observation.getTrieDictionary());
                this.irregularParsing(string, n, this.irrTrie.getTrieDictionary());
                if (string.charAt(n) == ' ') {
                    this.lattice.bridgingSpace(string, n);
                    this.lattice.setPrevStartIdx(n + 1);
                }
            }
            ++n;
        }
        this.consumeRuleParserBuffer(string);
        this.lattice.setEndIdx(string.length());
        return this.lattice.getMax(string);
    }

    private void symbolParsing(String string, int n) {
        char c = string.charAt(n);
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        if (!Character.isDigit(c)) {
            if (unicodeBlock == Character.UnicodeBlock.BASIC_LATIN) {
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || this.observation.getTrieDictionary().get(c) != null)) {
                    this.lattice.put(n, n + 1, String.valueOf(c), this.table.getId("SW"), -10000.0);
                    return;
                }
            } else if (!(unicodeBlock == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_A || unicodeBlock == Character.UnicodeBlock.HANGUL_JAMO_EXTENDED_B || unicodeBlock == Character.UnicodeBlock.HANGUL_SYLLABLES || unicodeBlock == Character.UnicodeBlock.KATAKANA || unicodeBlock == Character.UnicodeBlock.KATAKANA_PHONETIC_EXTENSIONS || Character.UnicodeBlock.CJK_COMPATIBILITY.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A.equals(unicodeBlock) || Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B.equals(unicodeBlock) || Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS.equals(unicodeBlock))) {
                this.lattice.put(n, n + 1, String.valueOf(c), this.table.getId("SW"), -10000.0);
            }
        }
    }

    private void consumeRuleParserBuffer(String string) {
        if (this.rulePos.trim().length() != 0) {
            if (this.rulePos.equals("SL")) {
                this.lattice.put(this.ruleBeginIdx, string.length(), this.ruleMorph, this.table.getId(this.rulePos), -1.0);
                return;
            }
            if (this.rulePos.equals("SH")) {
                this.lattice.put(this.ruleBeginIdx, string.length(), this.ruleMorph, this.table.getId(this.rulePos), -1.0);
                return;
            }
            if (this.rulePos.equals("SN")) {
                this.lattice.put(this.ruleBeginIdx, string.length(), this.ruleMorph, this.table.getId(this.rulePos), -1.0);
            }
        }
    }

    private void ruleParsing(String string, int n) {
        char c = string.charAt(n);
        String string2 = "";
        if (StringUtil.isEnglish((char)c)) {
            string2 = "SL";
        } else if (StringUtil.isNumeric((char)c)) {
            string2 = "SN";
        } else if (StringUtil.isChinese((char)c)) {
            string2 = "SH";
        } else if (StringUtil.isForeign((char)c)) {
            string2 = "SL";
        }
        if (string2.equals(this.rulePos)) {
            this.ruleMorph = String.valueOf(this.ruleMorph) + c;
            return;
        }
        if (this.rulePos.equals("SL")) {
            this.lattice.put(this.ruleBeginIdx, n, this.ruleMorph, this.table.getId(this.rulePos), -1.0);
        } else if (this.rulePos.equals("SN")) {
            this.lattice.put(this.ruleBeginIdx, n, this.ruleMorph, this.table.getId(this.rulePos), -1.0);
        } else if (this.rulePos.equals("SH")) {
            this.lattice.put(this.ruleBeginIdx, n, this.ruleMorph, this.table.getId(this.rulePos), -1.0);
        }
        this.ruleBeginIdx = n;
        this.ruleMorph = String.valueOf(c);
        this.rulePos = string2;
    }

    private int lookupFwd(String string, int n) {
        if (this.fwd == null) {
            return -1;
        }
        if (n == 0 || string.charAt(n - 1) == ' ') {
            Object object;
            int n2 = string.indexOf(" ", n);
            if (n2 == -1) {
                object = string.substring(n);
                n2 = string.length();
            } else {
                object = string.substring(n, n2);
            }
            if (((String)object).trim().length() == 0) {
                return -1;
            }
            if ((object = (List)this.fwd.get(object)) != null) {
                String string2 = "";
                int n3 = -1;
                int n4 = -1;
                int n5 = 0;
                while (n5 < object.size()) {
                    Pair pair = (Pair)object.get(n5);
                    string2 = String.valueOf(string2) + (String)pair.getFirst();
                    if (n5 == 0) {
                        n3 = (Integer)pair.getSecond();
                    }
                    if (n5 == object.size() - 1) {
                        n4 = (Integer)pair.getSecond();
                        break;
                    }
                    string2 = String.valueOf(string2) + "/" + this.table.getPos((Integer)pair.getSecond()) + " ";
                    ++n5;
                }
                string2 = string2.trim();
                this.lattice.put(n, n2, string2, n3, n4, 0.0);
                this.lattice.bridgingSpace(string, n2);
                this.lattice.setPrevStartIdx(n2 + 1);
                return n2 + 1;
            }
            return -1;
        }
        return -1;
    }

    private void irregularExpandParsing(String string, int n, TrieDictionary trieDictionary) {
        char c = string.charAt(n);
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Pair pair : this.prevNodesExpand) {
            int n2 = (Integer)pair.getFirst();
            int n3 = n + 1;
            Object object = (List)trieDictionary.get(String.valueOf(((IrregularNode)pair.getSecond()).getLastMorph()) + c);
            boolean bl = trieDictionary.hasChildren();
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (Pair)iterator.next();
                    Double d = this.calIrregularScore(((IrregularNode)pair.getSecond()).getTokens(), (Integer)object.getFirst());
                    if (d == null) continue;
                    double d2 = (Double)object.getSecond() + d;
                    this.lattice.put(n2, n3, String.valueOf(((IrregularNode)pair.getSecond()).getMorphFormat()) + c, ((IrregularNode)pair.getSecond()).getFirstPosId(), (Integer)object.getFirst(), d2);
                }
            }
            if (!bl) continue;
            object = new IrregularNode();
            ((IrregularNode)object).setFirstPosId(((IrregularNode)pair.getSecond()).getFirstPosId());
            ((IrregularNode)object).setLastMorph(String.valueOf(((IrregularNode)pair.getSecond()).getLastMorph()) + c);
            ((IrregularNode)object).setMorphFormat(String.valueOf(((IrregularNode)pair.getSecond()).getMorphFormat()) + c);
            ((IrregularNode)object).setTokens(((IrregularNode)pair.getSecond()).getTokens());
            arrayList.add(new Pair((Object)n2, object));
        }
        this.prevNodesExpand = arrayList;
    }

    private Double calIrregularScore(List list, Integer n) {
        double d = 0.0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < list.size() - 1) {
            Pair pair = (Pair)list.get(n3);
            Object object = (String)pair.getFirst();
            int n4 = (Integer)pair.getSecond();
            object = (List)this.observation.getTrieDictionary().get((String)object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                object = (Pair)iterator.next();
                if ((Integer)object.getFirst() != n4) continue;
                d += ((Double)object.getSecond()).doubleValue();
                break;
            }
            if (n2 != -1) {
                Double d2 = this.transition.get(n2, n4);
                if (d2 == null) {
                    return null;
                }
                d += d2.doubleValue();
            }
            n2 = n4;
            ++n3;
        }
        Double d3 = n2 != -1 ? this.transition.get(n2, n) : null;
        if (d3 == null) {
            return null;
        }
        return d + d3;
    }

    private void irregularParsing(String string, int n, TrieDictionary trieDictionary) {
        Object object;
        char c = string.charAt(n);
        Object object2 = this.prevNodesIrregular.getNodeMap().keySet();
        HashSet<Object> hashSet = new HashSet<Object>();
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            object2 = (Integer)object3.next();
            trieDictionary.setCurrentNode((TrieNode)this.prevNodesIrregular.get((Integer)object2));
            object = (List)trieDictionary.get(c);
            if (object != null) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (IrregularNode)iterator.next();
                    this.lattice.put((Integer)object2, n + 1, ((IrregularNode)object).getMorphFormat(), ((IrregularNode)object).getFirstPosId(), ((IrregularNode)object).getLastPosId(), ((IrregularNode)object).getInnerScore());
                    this.prevNodesExpand.add(new Pair(object2, object));
                    if (((IrregularNode)object).getLastPosId() != this.table.getId("EC")) continue;
                    this.lattice.put((Integer)object2, n + 1, ((IrregularNode)object).getMorphFormat(), ((IrregularNode)object).getFirstPosId(), this.table.getId("EF"), ((IrregularNode)object).getInnerScore());
                }
            }
            if (trieDictionary.hasChildren()) {
                this.prevNodesIrregular.insert((Integer)object2, trieDictionary.getCurrentNode());
                continue;
            }
            hashSet.add(object2);
        }
        this.prevNodesIrregular.remove(hashSet);
        trieDictionary.setCurrentNode(null);
        object2 = (List)trieDictionary.get(c);
        if (object2 != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                object3 = (IrregularNode)object.next();
                this.lattice.put(n, n + 1, ((IrregularNode)object3).getMorphFormat(), ((IrregularNode)object3).getFirstPosId(), ((IrregularNode)object3).getLastPosId(), ((IrregularNode)object3).getInnerScore());
                this.prevNodesExpand.add(new Pair((Object)n, object3));
            }
        }
        if (trieDictionary.hasChildren()) {
            this.prevNodesIrregular.insert(n, trieDictionary.getCurrentNode());
        }
    }

    private void regularParsing(String string, int n, TrieDictionary trieDictionary) {
        char c = string.charAt(n);
        Object object = this.prevNodesRegular.getNodeMap().keySet();
        HashSet<Object> hashSet = new HashSet<Object>();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (Integer)iterator.next();
            trieDictionary.setCurrentNode((TrieNode)this.prevNodesRegular.get((Integer)object));
            List list2 = (List)trieDictionary.get(c);
            if (list2 != null) {
                this.lattice.put((Integer)object, n + 1, list2, string.substring((Integer)object, n + 1));
                if (((Integer)((Pair)list2.get(list2.size() - 1)).getFirst()).intValue() == this.table.getId("EC")) {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    for (List list2 : list2) {
                        arrayList.add(new Pair((Object)((Integer)list2.getFirst()), (Object)((Double)list2.getSecond())));
                    }
                    list2 = (Pair)arrayList.get(arrayList.size() - 1);
                    list2.setFirst(this.table.getId("EF"));
                    arrayList.set(arrayList.size() - 1, list2);
                    this.lattice.put((Integer)object, n + 1, arrayList, string.substring((Integer)object, n + 1));
                }
            }
            if (trieDictionary.hasChildren()) {
                this.prevNodesRegular.insert((Integer)object, trieDictionary.getCurrentNode());
                continue;
            }
            hashSet.add(object);
        }
        this.prevNodesRegular.remove(hashSet);
        trieDictionary.setCurrentNode(null);
        object = (List)trieDictionary.get(c);
        if (object != null) {
            this.lattice.put(n, n + 1, (List)object, string.substring(n, n + 1));
        }
        if (trieDictionary.hasChildren()) {
            this.prevNodesRegular.insert(n, trieDictionary.getCurrentNode());
        }
    }

    public void addUserDic(String object) {
        try {
            String string;
            object = new BufferedReader(new FileReader((String)object));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                String string2;
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                int n = string.lastIndexOf("\t");
                if (n == -1) {
                    string2 = string.trim();
                    string = "NNP";
                } else {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                this.observation.put(string2, this.table.getId(string), 0.0);
            }
            ((BufferedReader)object).close();
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void setUserDic(String object) {
        try {
            String string;
            object = new BufferedReader(new FileReader((String)object));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                String string2;
                if ((string = string.trim()).length() == 0 || string.charAt(0) == '#') continue;
                int n = string.lastIndexOf("\t");
                if (n == -1) {
                    string2 = string.trim();
                    string = "NNP";
                } else {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                }
                this.observation.put(string2, this.table.getId(string), 0.0);
            }
            ((BufferedReader)object).close();
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    public void setFWDic(String object) {
        try {
            Object object2;
            kr.co.shineware.nlp.komoran.corpus.a.a a2 = new kr.co.shineware.nlp.komoran.corpus.a.a();
            object = new BufferedReader(new FileReader((String)object));
            this.fwd = new HashMap();
            while ((object2 = ((BufferedReader)object).readLine()) != null) {
                Object object3 = ((String)object2).split("\t");
                if (((String[])object3).length != 2 || object3[0].charAt(0) == '#') continue;
                object2 = a2.a((String)object2);
                object3 = new ArrayList();
                for (Pair pair : ((kr.co.shineware.nlp.komoran.corpus.a.a.a)object2).b()) {
                    object3.add(new Pair((Object)this.unitParser.a((String)pair.getFirst()), (Object)this.table.getId((String)pair.getSecond())));
                }
                this.fwd.put(this.unitParser.a(((kr.co.shineware.nlp.komoran.corpus.a.a.a)object2).a()), object3);
            }
            ((BufferedReader)object).close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

