/*
 * Decompiled with CFR 0.152.
 */
package com.twitter;

import com.twitter.Extractor;
import java.text.Normalizer;

public class Validator {
    public static final int MAX_TWEET_LENGTH = 140;
    protected int shortUrlLength = 22;
    protected int shortUrlLengthHttps = 23;
    private Extractor extractor = new Extractor();

    public int getTweetLength(String text) {
        text = Normalizer.normalize(text, Normalizer.Form.NFC);
        int length = text.codePointCount(0, text.length());
        for (Extractor.Entity urlEntity : this.extractor.extractURLsWithIndices(text)) {
            length += urlEntity.start - urlEntity.end;
            length += urlEntity.value.toLowerCase().startsWith("https://") ? this.shortUrlLengthHttps : this.shortUrlLength;
        }
        return length;
    }

    public boolean isValidTweet(String text) {
        if (text == null || text.length() == 0) {
            return false;
        }
        for (char c : text.toCharArray()) {
            if (c != '\ufffe' && c != '\ufeff' && c != '\uffff' && (c < '\u202a' || c > '\u202e')) continue;
            return false;
        }
        return this.getTweetLength(text) <= 140;
    }

    public int getShortUrlLength() {
        return this.shortUrlLength;
    }

    public void setShortUrlLength(int shortUrlLength) {
        this.shortUrlLength = shortUrlLength;
    }

    public int getShortUrlLengthHttps() {
        return this.shortUrlLengthHttps;
    }

    public void setShortUrlLengthHttps(int shortUrlLengthHttps) {
        this.shortUrlLengthHttps = shortUrlLengthHttps;
    }
}

