import ctypes
from OpenGL.platform import ctypesloader
OSMESA = ctypesloader.loadLibrary( ctypes.cdll, 'OSMesa32' )
# BEGIN GENERATED CONTENT (do not edit below this line)

# This content is generated by gengl.py.
# Wrapper for /usr/include/GL/osmesa.h
from OpenGL import platform, constant
from ctypes import *
c_void = None


# H (/usr/include/GL/osmesa.h:51)
OSMESA_MAJOR_VERSION = constant.Constant( 'OSMESA_MAJOR_VERSION', 6 )
OSMESA_MINOR_VERSION = constant.Constant( 'OSMESA_MINOR_VERSION', 5 )
OSMESA_PATCH_VERSION = constant.Constant( 'OSMESA_PATCH_VERSION', 0 )
OSMESA_COLOR_INDEX = constant.Constant( 'OSMESA_COLOR_INDEX', 6400 )
OSMESA_RGBA = constant.Constant( 'OSMESA_RGBA', 6408 )
OSMESA_BGRA = constant.Constant( 'OSMESA_BGRA', 1 )
OSMESA_ARGB = constant.Constant( 'OSMESA_ARGB', 2 )
OSMESA_RGB = constant.Constant( 'OSMESA_RGB', 6407 )
OSMESA_BGR = constant.Constant( 'OSMESA_BGR', 4 )
OSMESA_RGB_565 = constant.Constant( 'OSMESA_RGB_565', 5 )
OSMESA_ROW_LENGTH = constant.Constant( 'OSMESA_ROW_LENGTH', 16 )
OSMESA_Y_UP = constant.Constant( 'OSMESA_Y_UP', 17 )
OSMESA_WIDTH = constant.Constant( 'OSMESA_WIDTH', 32 )
OSMESA_HEIGHT = constant.Constant( 'OSMESA_HEIGHT', 33 )
OSMESA_FORMAT = constant.Constant( 'OSMESA_FORMAT', 34 )
OSMESA_TYPE = constant.Constant( 'OSMESA_TYPE', 35 )
OSMESA_MAX_WIDTH = constant.Constant( 'OSMESA_MAX_WIDTH', 36 )
OSMESA_MAX_HEIGHT = constant.Constant( 'OSMESA_MAX_HEIGHT', 37 )
class struct_osmesa_context(Structure):
    __slots__ = [
    ]
struct_osmesa_context._fields_ = [
    ('_opaque_struct', c_int)
]

class struct_osmesa_context(Structure):
    __slots__ = [
    ]
struct_osmesa_context._fields_ = [
    ('_opaque_struct', c_int)
]

OSMesaContext = POINTER(struct_osmesa_context) 	# /usr/include/GL/osmesa.h:101
GLenum = c_uint 	# /usr/include/GL/gl.h:153
OSMesaCreateContext = platform.createBaseFunction(
    'OSMesaCreateContext', dll=OSMESA, resultType=OSMesaContext,
    argTypes=[GLenum, OSMesaContext],
    doc='OSMesaCreateContext( GLenum(format), OSMesaContext(sharelist) ) -> OSMesaContext',
    argNames=['format', 'sharelist'],
)

GLint = c_int 	# /usr/include/GL/gl.h:159
OSMesaCreateContextExt = platform.createBaseFunction(
    'OSMesaCreateContextExt', dll=OSMESA, resultType=OSMesaContext,
    argTypes=[GLenum, GLint, GLint, GLint, OSMesaContext],
    doc='OSMesaCreateContextExt( GLenum(format), GLint(depthBits), GLint(stencilBits), GLint(accumBits), OSMesaContext(sharelist) ) -> OSMesaContext',
    argNames=['format', 'depthBits', 'stencilBits', 'accumBits', 'sharelist'],
)

OSMesaDestroyContext = platform.createBaseFunction(
    'OSMesaDestroyContext', dll=OSMESA, resultType=None,
    argTypes=[OSMesaContext],
    doc='OSMesaDestroyContext( OSMesaContext(ctx) ) -> None',
    argNames=['ctx'],
)

GLboolean = c_ubyte 	# /usr/include/GL/gl.h:154
GLsizei = c_int 	# /usr/include/GL/gl.h:163
OSMesaMakeCurrent = platform.createBaseFunction(
    'OSMesaMakeCurrent', dll=OSMESA, resultType=GLboolean,
    argTypes=[OSMesaContext, POINTER(None), GLenum, GLsizei, GLsizei],
    doc='OSMesaMakeCurrent( OSMesaContext(ctx), POINTER(None)(buffer), GLenum(type), GLsizei(width), GLsizei(height) ) -> GLboolean',
    argNames=['ctx', 'buffer', 'type', 'width', 'height'],
)

OSMesaGetCurrentContext = platform.createBaseFunction(
    'OSMesaGetCurrentContext', dll=OSMESA, resultType=OSMesaContext,
    argTypes=[],
    doc='OSMesaGetCurrentContext(  ) -> OSMesaContext',
    argNames=[],
)

OSMesaPixelStore = platform.createBaseFunction(
    'OSMesaPixelStore', dll=OSMESA, resultType=None,
    argTypes=[GLint, GLint],
    doc='OSMesaPixelStore( GLint(pname), GLint(value) ) -> None',
    argNames=['pname', 'value'],
)

OSMesaGetIntegerv = platform.createBaseFunction(
    'OSMesaGetIntegerv', dll=OSMESA, resultType=None,
    argTypes=[GLint, POINTER(GLint)],
    doc='OSMesaGetIntegerv( GLint(pname), POINTER(GLint)(value) ) -> None',
    argNames=['pname', 'value'],
)

OSMesaGetDepthBuffer = platform.createBaseFunction(
    'OSMesaGetDepthBuffer', dll=OSMESA, resultType=GLboolean,
    argTypes=[OSMesaContext, POINTER(GLint), POINTER(GLint), POINTER(GLint), POINTER(POINTER(None))],
    doc='OSMesaGetDepthBuffer( OSMesaContext(c), POINTER(GLint)(width), POINTER(GLint)(height), POINTER(GLint)(bytesPerValue), POINTER(POINTER(None))(buffer) ) -> GLboolean',
    argNames=['c', 'width', 'height', 'bytesPerValue', 'buffer'],
)

OSMesaGetColorBuffer = platform.createBaseFunction(
    'OSMesaGetColorBuffer', dll=OSMESA, resultType=GLboolean,
    argTypes=[OSMesaContext, POINTER(GLint), POINTER(GLint), POINTER(GLint), POINTER(POINTER(None))],
    doc='OSMesaGetColorBuffer( OSMesaContext(c), POINTER(GLint)(width), POINTER(GLint)(height), POINTER(GLint)(format), POINTER(POINTER(None))(buffer) ) -> GLboolean',
    argNames=['c', 'width', 'height', 'format', 'buffer'],
)

OSMESAproc = CFUNCTYPE(None) 	# /usr/include/GL/osmesa.h:258
OSMesaGetProcAddress = platform.createBaseFunction(
    'OSMesaGetProcAddress', dll=OSMESA, resultType=OSMESAproc,
    argTypes=[c_char_p],
    doc='OSMesaGetProcAddress( c_char_p(funcName) ) -> OSMESAproc',
    argNames=['funcName'],
)

OSMesaColorClamp = platform.createBaseFunction(
    'OSMesaColorClamp', dll=OSMESA, resultType=None,
    argTypes=[GLboolean],
    doc='OSMesaColorClamp( GLboolean(enable) ) -> None',
    argNames=['enable'],
)


__all__ = ['OSMESA_MAJOR_VERSION', 'OSMESA_MINOR_VERSION',
'OSMESA_PATCH_VERSION', 'OSMESA_COLOR_INDEX', 'OSMESA_RGBA', 'OSMESA_BGRA',
'OSMESA_ARGB', 'OSMESA_RGB', 'OSMESA_BGR', 'OSMESA_RGB_565',
'OSMESA_ROW_LENGTH', 'OSMESA_Y_UP', 'OSMESA_WIDTH', 'OSMESA_HEIGHT',
'OSMESA_FORMAT', 'OSMESA_TYPE', 'OSMESA_MAX_WIDTH', 'OSMESA_MAX_HEIGHT',
'OSMesaContext', 'OSMesaCreateContext', 'OSMesaCreateContextExt',
'OSMesaDestroyContext', 'OSMesaMakeCurrent', 'OSMesaGetCurrentContext',
'OSMesaPixelStore', 'OSMesaGetIntegerv', 'OSMesaGetDepthBuffer',
'OSMesaGetColorBuffer', 'OSMESAproc', 'OSMesaGetProcAddress',
'OSMesaColorClamp']
# END GENERATED CONTENT (do not edit above this line)




