/* Generated by re2c 3.0 on Fri Sep 27 13:38:07 2024 */
#line 1 "lib/parse_date.re"
/*
 * The MIT License (MIT)
 *
 * Copyright (c) 2015-2019 Derick Rethans
 * Copyright (c) 2018 MongoDB, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "timelib.h"
#include "timelib_private.h"

#include <ctype.h>
#include <math.h>
#include <assert.h>

#if defined(_MSC_VER)
# define strtoll(s, f, b) _atoi64(s)
#elif !defined(HAVE_STRTOLL)
# if defined(HAVE_ATOLL)
#  define strtoll(s, f, b) atoll(s)
# else
#  define strtoll(s, f, b) strtol(s, f, b)
# endif
#endif

#define EOI      257
#define TIME     258
#define DATE     259

#define TIMELIB_XMLRPC_SOAP    260
#define TIMELIB_TIME12         261
#define TIMELIB_TIME24         262
#define TIMELIB_GNU_NOCOLON    263
#define TIMELIB_GNU_NOCOLON_TZ 264
#define TIMELIB_ISO_NOCOLON    265

#define TIMELIB_AMERICAN       266
#define TIMELIB_ISO_DATE       267
#define TIMELIB_DATE_FULL      268
#define TIMELIB_DATE_TEXT      269
#define TIMELIB_DATE_NOCOLON   270
#define TIMELIB_PG_YEARDAY     271
#define TIMELIB_PG_TEXT        272
#define TIMELIB_PG_REVERSE     273
#define TIMELIB_CLF            274
#define TIMELIB_DATE_NO_DAY    275
#define TIMELIB_SHORTDATE_WITH_TIME 276
#define TIMELIB_DATE_FULL_POINTED 277
#define TIMELIB_TIME24_WITH_ZONE 278
#define TIMELIB_ISO_WEEK       279
#define TIMELIB_LF_DAY_OF_MONTH 280
#define TIMELIB_WEEK_DAY_OF_MONTH 281

#define TIMELIB_TIMEZONE       300
#define TIMELIB_AGO            301

#define TIMELIB_RELATIVE       310

#define TIMELIB_ERROR          999

/* Some compilers like AIX, defines uchar in sys/types.h */
#undef uchar
typedef unsigned char uchar;

#define   BSIZE	   8192

#define   YYCTYPE      uchar
#define   YYCURSOR     cursor
#define   YYLIMIT      s->lim
#define   YYMARKER     s->ptr
#define   YYFILL(n)    return EOI;

#define   RET(i)       {s->cur = cursor; return i;}

#define timelib_string_free timelib_free

#define TIMELIB_HAVE_TIME() { if (s->time->have_time) { add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_time = 1; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; } }
#define TIMELIB_UNHAVE_TIME() { s->time->have_time = 0; s->time->h = 0; s->time->i = 0; s->time->s = 0; s->time->us = 0; }
#define TIMELIB_HAVE_DATE() { if (s->time->have_date) { add_error(s, TIMELIB_ERR_DOUBLE_DATE, "Double date specification"); timelib_string_free(str); return TIMELIB_ERROR; } else { s->time->have_date = 1; } }
#define TIMELIB_UNHAVE_DATE() { s->time->have_date = 0; s->time->d = 0; s->time->m = 0; s->time->y = 0; }
#define TIMELIB_HAVE_RELATIVE() { s->time->have_relative = 1; }
#define TIMELIB_HAVE_WEEKDAY_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_weekday_relative = 1; }
#define TIMELIB_HAVE_SPECIAL_RELATIVE() { s->time->have_relative = 1; s->time->relative.have_special_relative = 1; }
#define TIMELIB_HAVE_TZ() { s->cur = cursor; if (s->time->have_zone) { s->time->have_zone > 1 ? add_error(s, TIMELIB_ERR_DOUBLE_TZ, "Double timezone specification") : add_warning(s, TIMELIB_WARN_DOUBLE_TZ, "Double timezone specification"); timelib_string_free(str); s->time->have_zone++; return TIMELIB_ERROR; } else { s->time->have_zone++; } }

#define TIMELIB_INIT  s->cur = cursor; str = timelib_string(s); ptr = str
#define TIMELIB_DEINIT timelib_string_free(str)
#define TIMELIB_ADJUST_RELATIVE_WEEKDAY() if (in->time.have_weekday_relative && (in.rel.d > 0)) { in.rel.d -= 7; }

#define TIMELIB_PROCESS_YEAR(x, l) { \
	if (((x) == TIMELIB_UNSET) || ((l) >= 4)) { \
	/*	(x) = 0; */          \
	} else if ((x) < 100) {  \
		if ((x) < 70) {      \
			(x) += 2000;     \
		} else {             \
			(x) += 1900;     \
		}                    \
	}                        \
}

#ifdef DEBUG_PARSER
#define DEBUG_OUTPUT(s) printf("%s\n", s);
#define YYDEBUG(s,c) { if (s != -1) { printf("state: %d ", s); printf("[%c]\n", c); } }
#else
#define DEBUG_OUTPUT(s)
#define YYDEBUG(s,c)
#endif

typedef struct _timelib_elems {
	unsigned int   c; /* Number of elements */
	char         **v; /* Values */
} timelib_elems;

typedef struct _Scanner {
	int           fd;
	uchar        *lim, *str, *ptr, *cur, *tok, *pos;
	unsigned int  line, len;
	timelib_error_container *errors;

	timelib_time        *time;
	const timelib_tzdb  *tzdb;
} Scanner;

typedef struct _timelib_lookup_table {
	const char *name;
	int         type;
	int         value;
} timelib_lookup_table;

typedef struct _timelib_relunit {
	const char *name;
	int         unit;
	int         multiplier;
} timelib_relunit;

/* The timezone table. */
static const timelib_tz_lookup_table timelib_timezone_lookup[] = {
#include "timezonemap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_fallbackmap[] = {
#include "fallbackmap.h"
	{ NULL, 0, 0, NULL },
};

static const timelib_tz_lookup_table timelib_timezone_utc[] = {
	{ "utc", 0, 0, "UTC" },
};

static timelib_relunit const timelib_relunit_lookup[] = {
	{ "ms",           TIMELIB_MICROSEC, 1000 },
	{ "msec",         TIMELIB_MICROSEC, 1000 },
	{ "msecs",        TIMELIB_MICROSEC, 1000 },
	{ "millisecond",  TIMELIB_MICROSEC, 1000 },
	{ "milliseconds", TIMELIB_MICROSEC, 1000 },
	{ "µs",           TIMELIB_MICROSEC,    1 },
	{ "usec",         TIMELIB_MICROSEC,    1 },
	{ "usecs",        TIMELIB_MICROSEC,    1 },
	{ "µsec",         TIMELIB_MICROSEC,    1 },
	{ "µsecs",        TIMELIB_MICROSEC,    1 },
	{ "microsecond",  TIMELIB_MICROSEC,    1 },
	{ "microseconds", TIMELIB_MICROSEC,    1 },
	{ "sec",         TIMELIB_SECOND,  1 },
	{ "secs",        TIMELIB_SECOND,  1 },
	{ "second",      TIMELIB_SECOND,  1 },
	{ "seconds",     TIMELIB_SECOND,  1 },
	{ "min",         TIMELIB_MINUTE,  1 },
	{ "mins",        TIMELIB_MINUTE,  1 },
	{ "minute",      TIMELIB_MINUTE,  1 },
	{ "minutes",     TIMELIB_MINUTE,  1 },
	{ "hour",        TIMELIB_HOUR,    1 },
	{ "hours",       TIMELIB_HOUR,    1 },
	{ "day",         TIMELIB_DAY,     1 },
	{ "days",        TIMELIB_DAY,     1 },
	{ "week",        TIMELIB_DAY,     7 },
	{ "weeks",       TIMELIB_DAY,     7 },
	{ "fortnight",   TIMELIB_DAY,    14 },
	{ "fortnights",  TIMELIB_DAY,    14 },
	{ "forthnight",  TIMELIB_DAY,    14 },
	{ "forthnights", TIMELIB_DAY,    14 },
	{ "month",       TIMELIB_MONTH,   1 },
	{ "months",      TIMELIB_MONTH,   1 },
	{ "year",        TIMELIB_YEAR,    1 },
	{ "years",       TIMELIB_YEAR,    1 },

	{ "monday",      TIMELIB_WEEKDAY, 1 },
	{ "mon",         TIMELIB_WEEKDAY, 1 },
	{ "tuesday",     TIMELIB_WEEKDAY, 2 },
	{ "tue",         TIMELIB_WEEKDAY, 2 },
	{ "wednesday",   TIMELIB_WEEKDAY, 3 },
	{ "wed",         TIMELIB_WEEKDAY, 3 },
	{ "thursday",    TIMELIB_WEEKDAY, 4 },
	{ "thu",         TIMELIB_WEEKDAY, 4 },
	{ "friday",      TIMELIB_WEEKDAY, 5 },
	{ "fri",         TIMELIB_WEEKDAY, 5 },
	{ "saturday",    TIMELIB_WEEKDAY, 6 },
	{ "sat",         TIMELIB_WEEKDAY, 6 },
	{ "sunday",      TIMELIB_WEEKDAY, 0 },
	{ "sun",         TIMELIB_WEEKDAY, 0 },

	{ "weekday",     TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ "weekdays",    TIMELIB_SPECIAL, TIMELIB_SPECIAL_WEEKDAY },
	{ NULL,          0,          0 }
};

/* The relative text table. */
static timelib_lookup_table const timelib_reltext_lookup[] = {
	{ "first",    0,  1 },
	{ "next",     0,  1 },
	{ "second",   0,  2 },
	{ "third",    0,  3 },
	{ "fourth",   0,  4 },
	{ "fifth",    0,  5 },
	{ "sixth",    0,  6 },
	{ "seventh",  0,  7 },
	{ "eight",    0,  8 },
	{ "eighth",   0,  8 },
	{ "ninth",    0,  9 },
	{ "tenth",    0, 10 },
	{ "eleventh", 0, 11 },
	{ "twelfth",  0, 12 },
	{ "last",     0, -1 },
	{ "previous", 0, -1 },
	{ "this",     1,  0 },
	{ NULL,       1,  0 }
};

/* The month table. */
static timelib_lookup_table const timelib_month_lookup[] = {
	{ "jan",  0,  1 },
	{ "feb",  0,  2 },
	{ "mar",  0,  3 },
	{ "apr",  0,  4 },
	{ "may",  0,  5 },
	{ "jun",  0,  6 },
	{ "jul",  0,  7 },
	{ "aug",  0,  8 },
	{ "sep",  0,  9 },
	{ "sept", 0,  9 },
	{ "oct",  0, 10 },
	{ "nov",  0, 11 },
	{ "dec",  0, 12 },
	{ "i",    0,  1 },
	{ "ii",   0,  2 },
	{ "iii",  0,  3 },
	{ "iv",   0,  4 },
	{ "v",    0,  5 },
	{ "vi",   0,  6 },
	{ "vii",  0,  7 },
	{ "viii", 0,  8 },
	{ "ix",   0,  9 },
	{ "x",    0, 10 },
	{ "xi",   0, 11 },
	{ "xii",  0, 12 },

	{ "january",   0,  1 },
	{ "february",  0,  2 },
	{ "march",     0,  3 },
	{ "april",     0,  4 },
	{ "may",       0,  5 },
	{ "june",      0,  6 },
	{ "july",      0,  7 },
	{ "august",    0,  8 },
	{ "september", 0,  9 },
	{ "october",   0, 10 },
	{ "november",  0, 11 },
	{ "december",  0, 12 },
	{  NULL,       0,  0 }
};

#if 0
static char* timelib_ltrim(char *s)
{
	char *ptr = s;
	while (ptr[0] == ' ' || ptr[0] == '\t') {
		ptr++;
	}
	return ptr;
}
#endif

#if 0
uchar *fill(Scanner *s, uchar *cursor){
	if(!s->eof){
		unsigned int cnt = s->tok - s->bot;
		if(cnt){
			memcpy(s->bot, s->tok, s->lim - s->tok);
			s->tok = s->bot;
			s->ptr -= cnt;
			cursor -= cnt;
			s->pos -= cnt;
			s->lim -= cnt;
		}
		if((s->top - s->lim) < BSIZE){
			uchar *buf = (uchar*) timelib_malloc(((s->lim - s->bot) + BSIZE)*sizeof(uchar));
			memcpy(buf, s->tok, s->lim - s->tok);
			s->tok = buf;
			s->ptr = &buf[s->ptr - s->bot];
			cursor = &buf[cursor - s->bot];
			s->pos = &buf[s->pos - s->bot];
			s->lim = &buf[s->lim - s->bot];
			s->top = &s->lim[BSIZE];
			timelib_free(s->bot);
			s->bot = buf;
		}
		if((cnt = read(s->fd, (char*) s->lim, BSIZE)) != BSIZE){
			s->eof = &s->lim[cnt]; *(s->eof)++ = '\n';
		}
		s->lim += cnt;
	}
	return cursor;
}
#endif

static void add_warning(Scanner *s, int error_code, char *error)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_error(Scanner *s, int error_code, char *error)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = s->tok ? s->tok - s->str : 0;
	s->errors->error_messages[s->errors->error_count - 1].character = s->tok ? *s->tok : 0;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static void add_pbf_warning(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->warning_count++;
	s->errors->warning_messages = timelib_realloc(s->errors->warning_messages, s->errors->warning_count * sizeof(timelib_error_message));
	s->errors->warning_messages[s->errors->warning_count - 1].error_code = error_code;
	s->errors->warning_messages[s->errors->warning_count - 1].position = cptr - sptr;
	s->errors->warning_messages[s->errors->warning_count - 1].character = *cptr;
	s->errors->warning_messages[s->errors->warning_count - 1].message = timelib_strdup(error);
}

static void add_pbf_error(Scanner *s, int error_code, char *error, char *sptr, char *cptr)
{
	s->errors->error_count++;
	s->errors->error_messages = timelib_realloc(s->errors->error_messages, s->errors->error_count * sizeof(timelib_error_message));
	s->errors->error_messages[s->errors->error_count - 1].error_code = error_code;
	s->errors->error_messages[s->errors->error_count - 1].position = cptr - sptr;
	s->errors->error_messages[s->errors->error_count - 1].character = *cptr;
	s->errors->error_messages[s->errors->error_count - 1].message = timelib_strdup(error);
}

static timelib_sll timelib_meridian(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (!strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
	}
	if (**ptr == 'M' || **ptr == 'm') {
		++*ptr;
	}
	if (**ptr == '.') {
		++*ptr;
	}
	return retval;
}

static timelib_sll timelib_meridian_with_check(char **ptr, timelib_sll h)
{
	timelib_sll retval = 0;

	while (**ptr && !strchr("AaPp", **ptr)) {
		++*ptr;
	}
	if(!**ptr) {
		return TIMELIB_UNSET;
	}
	if (**ptr == 'a' || **ptr == 'A') {
		if (h == 12) {
			retval = -12;
		}
	} else if (h != 12) {
		retval = 12;
	}
	++*ptr;
	if (**ptr == '.') {
		++*ptr;
		if (**ptr != 'm' && **ptr != 'M') {
			return TIMELIB_UNSET;
		}
		++*ptr;
		if (**ptr != '.' ) {
			return TIMELIB_UNSET;
		}
		++*ptr;
	} else if (**ptr == 'm' || **ptr == 'M') {
		++*ptr;
	} else {
		return TIMELIB_UNSET;
	}
	return retval;
}

static char *timelib_string(Scanner *s)
{
	char *tmp = timelib_calloc(1, s->cur - s->tok + 1);
	memcpy(tmp, s->tok, s->cur - s->tok);

	return tmp;
}

static timelib_sll timelib_get_nr_ex(char **ptr, int max_length, int *scanned_length)
{
	char *begin, *end, *str;
	timelib_sll tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr < '0') || (**ptr > '9')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while ((**ptr >= '0') && (**ptr <= '9') && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	if (scanned_length) {
		*scanned_length = end - begin;
	}
	str = timelib_calloc(1, end - begin + 1);
	memcpy(str, begin, end - begin);
	tmp_nr = strtoll(str, NULL, 10);
	timelib_free(str);
	return tmp_nr;
}

static timelib_sll timelib_get_nr(char **ptr, int max_length)
{
	return timelib_get_nr_ex(ptr, max_length, NULL);
}

static void timelib_skip_day_suffix(char **ptr)
{
	if (isspace(**ptr)) {
		return;
	}
	if (!timelib_strncasecmp(*ptr, "nd", 2) || !timelib_strncasecmp(*ptr, "rd", 2) ||!timelib_strncasecmp(*ptr, "st", 2) || !timelib_strncasecmp(*ptr, "th", 2)) {
		*ptr += 2;
	}
}

static timelib_sll timelib_get_frac_nr(char **ptr, int max_length)
{
	char *begin, *end, *str;
	double tmp_nr = TIMELIB_UNSET;
	int len = 0;

	while ((**ptr != '.') && (**ptr != ':') && ((**ptr < '0') || (**ptr > '9'))) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}
	begin = *ptr;
	while (((**ptr == '.') || (**ptr == ':') || ((**ptr >= '0') && (**ptr <= '9'))) && len < max_length) {
		++*ptr;
		++len;
	}
	end = *ptr;
	str = timelib_calloc(1, end - begin);
	memcpy(str, begin + 1, end - begin - 1);
	tmp_nr = strtod(str, NULL) * pow(10, 7 - (end - begin));
	timelib_free(str);
	return tmp_nr;
}

static timelib_ull timelib_get_unsigned_nr(char **ptr, int max_length)
{
	timelib_ull dir = 1;

	while (((**ptr < '0') || (**ptr > '9')) && (**ptr != '+') && (**ptr != '-')) {
		if (**ptr == '\0') {
			return TIMELIB_UNSET;
		}
		++*ptr;
	}

	while (**ptr == '+' || **ptr == '-')
	{
		if (**ptr == '-') {
			dir *= -1;
		}
		++*ptr;
	}
	return dir * timelib_get_nr(ptr, max_length);
}

static timelib_sll timelib_lookup_relative_text(char **ptr, int *behavior)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_sll  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_reltext_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
			*behavior = tp->type;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_sll timelib_get_relative_text(char **ptr, int *behavior)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_relative_text(ptr, behavior);
}

static timelib_long timelib_lookup_month(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_lookup_table *tp;

	while ((**ptr >= 'A' && **ptr <= 'Z') || (**ptr >= 'a' && **ptr <= 'z')) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_month_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp->value;
		}
	}

	timelib_free(word);
	return value;
}

static timelib_long timelib_get_month(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t' || **ptr == '-' || **ptr == '.' || **ptr == '/') {
		++*ptr;
	}
	return timelib_lookup_month(ptr);
}

static void timelib_eat_spaces(char **ptr)
{
	while (**ptr == ' ' || **ptr == '\t') {
		++*ptr;
	}
}

static void timelib_eat_until_separator(char **ptr)
{
	++*ptr;
	while (strchr(" \t.,:;/-0123456789", **ptr) == NULL) {
		++*ptr;
	}
}

static const timelib_relunit* timelib_lookup_relunit(char **ptr)
{
	char *word;
	char *begin = *ptr, *end;
	const timelib_relunit *tp, *value = NULL;

	while (**ptr != '\0' && **ptr != ' ' && **ptr != ',' && **ptr != '\t' && **ptr != ';' && **ptr != ':' &&
		**ptr != '/' && **ptr != '.' && **ptr != '-' && **ptr != '(' && **ptr != ')' ) {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	for (tp = timelib_relunit_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			value = tp;
			break;
		}
	}

	timelib_free(word);
	return value;
}

static void timelib_set_relative(char **ptr, timelib_sll amount, int behavior, Scanner *s)
{
	const timelib_relunit* relunit;

	if (!(relunit = timelib_lookup_relunit(ptr))) {
		return;
	}

	switch (relunit->unit) {
		case TIMELIB_MICROSEC: s->time->relative.us += amount * relunit->multiplier; break;
		case TIMELIB_SECOND:   s->time->relative.s += amount * relunit->multiplier; break;
		case TIMELIB_MINUTE:   s->time->relative.i += amount * relunit->multiplier; break;
		case TIMELIB_HOUR:     s->time->relative.h += amount * relunit->multiplier; break;
		case TIMELIB_DAY:      s->time->relative.d += amount * relunit->multiplier; break;
		case TIMELIB_MONTH:    s->time->relative.m += amount * relunit->multiplier; break;
		case TIMELIB_YEAR:     s->time->relative.y += amount * relunit->multiplier; break;

		case TIMELIB_WEEKDAY:
			TIMELIB_HAVE_WEEKDAY_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.d += (amount > 0 ? amount - 1 : amount) * 7;
			s->time->relative.weekday = relunit->multiplier;
			s->time->relative.weekday_behavior = behavior;
			break;

		case TIMELIB_SPECIAL:
			TIMELIB_HAVE_SPECIAL_RELATIVE();
			TIMELIB_UNHAVE_TIME();
			s->time->relative.special.type = relunit->multiplier;
			s->time->relative.special.amount = amount;
	}
}

static const timelib_tz_lookup_table* abbr_search(const char *word, timelib_long gmtoffset, int isdst)
{
	int first_found = 0;
	const timelib_tz_lookup_table  *tp, *first_found_elem = NULL;
	const timelib_tz_lookup_table  *fmp;

	if (timelib_strcasecmp("utc", word) == 0 || timelib_strcasecmp("gmt", word) == 0) {
		return timelib_timezone_utc;
	}

	for (tp = timelib_timezone_lookup; tp->name; tp++) {
		if (timelib_strcasecmp(word, tp->name) == 0) {
			if (!first_found) {
				first_found = 1;
				first_found_elem = tp;
				if (gmtoffset == -1) {
					return tp;
				}
			}
			if (tp->gmtoffset == gmtoffset) {
				return tp;
			}
		}
	}
	if (first_found) {
		return first_found_elem;
	}

	/* Still didn't find anything, let's find the zone solely based on
	 * offset/isdst then */
	for (fmp = timelib_timezone_fallbackmap; fmp->name; fmp++) {
		if (fmp->gmtoffset == gmtoffset && fmp->type == isdst) {
			return fmp;
		}
	}
	return NULL;
}

static timelib_long timelib_lookup_abbr(char **ptr, int *dst, char **tz_abbr, int *found)
{
	char *word;
	char *begin = *ptr, *end;
	timelib_long  value = 0;
	const timelib_tz_lookup_table *tp;

	while (**ptr != '\0' && **ptr != ')' && **ptr != ' ') {
		++*ptr;
	}
	end = *ptr;
	word = timelib_calloc(1, end - begin + 1);
	memcpy(word, begin, end - begin);

	if ((tp = abbr_search(word, -1, 0))) {
		value = tp->gmtoffset;
		*dst = tp->type;
		value -= tp->type * 3600;
		*found = 1;
	} else {
		*found = 0;
	}

	*tz_abbr = word;
	return value;
}

#define sHOUR(a) (int)(a * 3600)
#define sMIN(a) (int)(a * 60)

static timelib_long timelib_parse_tz_cor(char **ptr)
{
	char *begin = *ptr, *end;
	timelib_long  tmp;

	while (isdigit(**ptr) || **ptr == ':') {
		++*ptr;
	}
	end = *ptr;
	switch (end - begin) {
		case 1: /* H */
		case 2: /* HH */
			return sHOUR(strtol(begin, NULL, 10));
			break;
		case 3: /* H:M */
		case 4: /* H:MM, HH:M, HHMM */
			if (begin[1] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 2, NULL, 10));
				return tmp;
			} else if (begin[2] == ':') {
				tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
				return tmp;
			} else {
				tmp = strtol(begin, NULL, 10);
				return sHOUR(tmp / 100) + sMIN(tmp % 100);
			}
		case 5: /* HH:MM */
			tmp = sHOUR(strtol(begin, NULL, 10)) + sMIN(strtol(begin + 3, NULL, 10));
			return tmp;
	}
	return 0;
}

static timelib_long timelib_parse_tz_minutes(char **ptr, timelib_time *t)
{
	timelib_long retval = TIMELIB_UNSET;
	char *begin = *ptr;

	/* First character must be +/- */
	if (**ptr != '+' && **ptr != '-') {
		return retval;
	}

	++*ptr;
	while (isdigit(**ptr)) {
		++*ptr;
	}

	if (*begin == '+') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = sMIN(strtol(begin + 1, NULL, 10));
	} else if (*begin == '-') {
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		t->dst = 0;

		retval = -1 * sMIN(strtol(begin + 1, NULL, 10));
	}
	return retval;
}

timelib_long timelib_parse_zone(char **ptr, int *dst, timelib_time *t, int *tz_not_found, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_wrapper)
{
	timelib_tzinfo *res;
	timelib_long            retval = 0;

	*tz_not_found = 0;

	while (**ptr == ' ' || **ptr == '\t' || **ptr == '(') {
		++*ptr;
	}
	if ((*ptr)[0] == 'G' && (*ptr)[1] == 'M' && (*ptr)[2] == 'T' && ((*ptr)[3] == '+' || (*ptr)[3] == '-')) {
		*ptr += 3;
	}
	if (**ptr == '+') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = timelib_parse_tz_cor(ptr);
	} else if (**ptr == '-') {
		++*ptr;
		t->is_localtime = 1;
		t->zone_type = TIMELIB_ZONETYPE_OFFSET;
		*tz_not_found = 0;
		t->dst = 0;

		retval = -1 * timelib_parse_tz_cor(ptr);
	} else {
		int found = 0;
		timelib_long offset = 0;
		char *tz_abbr;

		t->is_localtime = 1;

		/* First, we lookup by abbreviation only */
		offset = timelib_lookup_abbr(ptr, dst, &tz_abbr, &found);
		if (found) {
			t->zone_type = TIMELIB_ZONETYPE_ABBR;
			timelib_time_tz_abbr_update(t, tz_abbr);
		}

		/* Otherwise, we look if we have a TimeZone identifier */
		if (!found || strcmp("UTC", tz_abbr) == 0) {
			int dummy_error_code;

			if ((res = tz_wrapper(tz_abbr, tzdb, &dummy_error_code)) != NULL) {
				t->tz_info = res;
				t->zone_type = TIMELIB_ZONETYPE_ID;
				found++;
			}
		}
		timelib_free(tz_abbr);
		*tz_not_found = (found == 0);
		retval = offset;
	}
	while (**ptr == ')') {
		++*ptr;
	}
	return retval;
}

#define timelib_split_free(arg) {       \
	int i;                         \
	for (i = 0; i < arg.c; i++) {  \
		timelib_free(arg.v[i]);    \
	}                              \
	if (arg.v) {                   \
		timelib_free(arg.v);       \
	}                              \
}

static int scan(Scanner *s, timelib_tz_get_wrapper tz_get_wrapper)
{
	uchar *cursor = s->cur;
	char *str, *ptr = NULL;

std:
	s->tok = cursor;
	s->len = 0;
#line 1013 "lib/parse_date.re"



#line 892 "lib/parse_date.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[] = {
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,  50,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		 50,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   8,  32,  24,  48,   0, 
		  4,   4,   4,   4,   4,   4,   4,   4, 
		  4,   4,   0,   0,   0,   0,   0,   0, 
		  0,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,  64,  64,  64,  64,  64, 
		 64,  64,  64,   0,   0,   0,   0,   0, 
		  0, 192, 192, 192, 224, 192, 192, 192, 
		224, 192, 192, 192, 192, 192, 224, 192, 
		192, 192, 224, 224, 224, 192, 192, 192, 
		192, 192, 192,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
		  0,   0,   0,   0,   0,   0,   0,   0, 
	};
	YYDEBUG(0, *YYCURSOR);
	if ((YYLIMIT - YYCURSOR) < 33) YYFILL(33);
	yych = *YYCURSOR;
	switch (yych) {
		case 0x00:
		case '\n': goto yy1;
		case '\t':
		case ' ': goto yy4;
		case '(': goto yy6;
		case '+':
		case '-': goto yy7;
		case ',':
		case '.': goto yy8;
		case '0': goto yy9;
		case '1': goto yy10;
		case '2': goto yy11;
		case '3': goto yy12;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy13;
		case '@': goto yy14;
		case 'A': goto yy15;
		case 'B': goto yy17;
		case 'C':
		case 'H':
		case 'K':
		case 'Q':
		case 'R':
		case 'U':
		case 'Z': goto yy18;
		case 'D': goto yy19;
		case 'E': goto yy20;
		case 'F': goto yy21;
		case 'G': goto yy22;
		case 'I': goto yy23;
		case 'J': goto yy24;
		case 'L': goto yy25;
		case 'M': goto yy26;
		case 'N': goto yy27;
		case 'O': goto yy28;
		case 'P': goto yy29;
		case 'S': goto yy30;
		case 'T': goto yy31;
		case 'V': goto yy32;
		case 'W': goto yy33;
		case 'X': goto yy34;
		case 'Y': goto yy35;
		case 'a': goto yy36;
		case 'b': goto yy37;
		case 'c':
		case 'g':
		case 'h':
		case 'i':
		case 'k':
		case 'q':
		case 'r':
		case 'u':
		case 'v':
		case 'x':
		case 'z': goto yy38;
		case 'd': goto yy39;
		case 'e': goto yy40;
		case 'f': goto yy41;
		case 'j': goto yy42;
		case 'l': goto yy43;
		case 'm': goto yy44;
		case 'n': goto yy45;
		case 'o': goto yy46;
		case 'p': goto yy47;
		case 's': goto yy48;
		case 't': goto yy49;
		case 'w': goto yy50;
		case 'y': goto yy51;
		default: goto yy2;
	}
yy1:
	YYDEBUG(1, *YYCURSOR);
	++YYCURSOR;
#line 1822 "lib/parse_date.re"
	{
		s->pos = cursor; s->line++;
		goto std;
	}
#line 1016 "lib/parse_date.c"
yy2:
	YYDEBUG(2, *YYCURSOR);
	++YYCURSOR;
yy3:
	YYDEBUG(3, *YYCURSOR);
#line 1828 "lib/parse_date.re"
	{
		add_error(s, TIMELIB_ERR_UNEXPECTED_CHARACTER, "Unexpected character");
		goto std;
	}
#line 1027 "lib/parse_date.c"
yy4:
	YYDEBUG(4, *YYCURSOR);
	yyaccept = 0;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy52;
	}
	if (yych <= '/') goto yy5;
	if (yych <= '9') goto yy54;
yy5:
	YYDEBUG(5, *YYCURSOR);
#line 1817 "lib/parse_date.re"
	{
		goto std;
	}
#line 1043 "lib/parse_date.c"
yy6:
	YYDEBUG(6, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy3;
	if (yych <= 'Z') goto yy38;
	if (yych <= '`') goto yy3;
	if (yych <= 'z') goto yy38;
	goto yy3;
yy7:
	YYDEBUG(7, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 2) {
		goto yy52;
	}
	switch (yych) {
		case '+':
		case '-': goto yy55;
		case '0':
		case '1': goto yy56;
		case '2': goto yy57;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy58;
		default: goto yy3;
	}
yy8:
	YYDEBUG(8, *YYCURSOR);
	++YYCURSOR;
	goto yy5;
yy9:
	YYDEBUG(9, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy59;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy61;
					if (yych <= ',') goto yy3;
					goto yy62;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy63;
					if (yych <= '/') goto yy64;
					goto yy65;
				} else {
					if (yych <= '9') goto yy66;
					if (yych <= ':') goto yy67;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy61;
					if (yych <= 'C') goto yy3;
					goto yy61;
				} else {
					if (yych == 'F') goto yy61;
					goto yy3;
				}
			} else {
				if (yych <= 'O') {
					if (yych <= 'J') goto yy61;
					if (yych <= 'L') goto yy3;
					goto yy61;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy61;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy61;
					if (yych <= 'c') goto yy3;
					goto yy61;
				} else {
					if (yych == 'f') goto yy61;
					goto yy3;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy3;
					goto yy61;
				} else {
					if (yych <= 'l') goto yy3;
					if (yych <= 'm') goto yy61;
					goto yy85;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'o') goto yy61;
					if (yych <= 'q') goto yy3;
					goto yy86;
				} else {
					if (yych <= 's') goto yy87;
					if (yych <= 't') goto yy88;
					goto yy61;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy61;
					goto yy3;
				} else {
					if (yych <= 'y') goto yy61;
					if (yych == 0xC2) goto yy61;
					goto yy3;
				}
			}
		}
	}
yy10:
	YYDEBUG(10, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy90;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy92;
					if (yych <= ',') goto yy3;
					goto yy62;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '.') goto yy93;
					if (yych <= '/') goto yy64;
					goto yy66;
				} else {
					if (yych <= '9') goto yy94;
					if (yych <= ':') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy92;
					if (yych <= 'C') goto yy3;
					goto yy92;
				} else {
					if (yych == 'F') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy92;
					if (yych <= 'L') goto yy3;
					goto yy92;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy92;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy92;
					if (yych <= 'c') goto yy3;
					goto yy92;
				} else {
					if (yych == 'f') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy3;
					goto yy92;
				} else {
					if (yych <= 'l') goto yy3;
					if (yych <= 'm') goto yy92;
					goto yy85;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy92;
					if (yych <= 'q') goto yy3;
					goto yy86;
				} else {
					if (yych <= 's') goto yy87;
					if (yych <= 't') goto yy88;
					goto yy92;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy92;
					goto yy3;
				} else {
					if (yych <= 'y') goto yy92;
					if (yych == 0xC2) goto yy92;
					goto yy3;
				}
			}
		}
	}
yy11:
	YYDEBUG(11, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy90;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy92;
					if (yych <= ',') goto yy3;
					goto yy62;
				}
			} else {
				if (yych <= '4') {
					if (yych <= '.') goto yy93;
					if (yych <= '/') goto yy64;
					goto yy94;
				} else {
					if (yych <= '9') goto yy98;
					if (yych <= ':') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy92;
					if (yych <= 'C') goto yy3;
					goto yy92;
				} else {
					if (yych == 'F') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy92;
					if (yych <= 'L') goto yy3;
					goto yy92;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy92;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy92;
					if (yych <= 'c') goto yy3;
					goto yy92;
				} else {
					if (yych == 'f') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy3;
					goto yy92;
				} else {
					if (yych <= 'l') goto yy3;
					if (yych <= 'm') goto yy92;
					goto yy85;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy92;
					if (yych <= 'q') goto yy3;
					goto yy86;
				} else {
					if (yych <= 's') goto yy87;
					if (yych <= 't') goto yy88;
					goto yy92;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy92;
					goto yy3;
				} else {
					if (yych <= 'y') goto yy92;
					if (yych == 0xC2) goto yy92;
					goto yy3;
				}
			}
		}
	}
yy12:
	YYDEBUG(12, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '`') {
		if (yych <= '@') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy90;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy92;
					if (yych <= ',') goto yy3;
					goto yy62;
				}
			} else {
				if (yych <= '1') {
					if (yych <= '.') goto yy93;
					if (yych <= '/') goto yy64;
					goto yy98;
				} else {
					if (yych <= '9') goto yy99;
					if (yych <= ':') goto yy95;
					goto yy3;
				}
			}
		} else {
			if (yych <= 'G') {
				if (yych <= 'D') {
					if (yych <= 'A') goto yy92;
					if (yych <= 'C') goto yy3;
					goto yy92;
				} else {
					if (yych == 'F') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'P') {
					if (yych <= 'J') goto yy92;
					if (yych <= 'L') goto yy3;
					goto yy92;
				} else {
					if (yych <= 'R') goto yy3;
					if (yych <= 'Y') goto yy92;
					goto yy3;
				}
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'g') {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy92;
					if (yych <= 'c') goto yy3;
					goto yy92;
				} else {
					if (yych == 'f') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'j') {
					if (yych == 'i') goto yy3;
					goto yy92;
				} else {
					if (yych <= 'l') goto yy3;
					if (yych <= 'm') goto yy92;
					goto yy85;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'r') {
					if (yych <= 'p') goto yy92;
					if (yych <= 'q') goto yy3;
					goto yy86;
				} else {
					if (yych <= 's') goto yy87;
					if (yych <= 't') goto yy88;
					goto yy92;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy92;
					goto yy3;
				} else {
					if (yych <= 'y') goto yy92;
					if (yych == 0xC2) goto yy92;
					goto yy3;
				}
			}
		}
	}
yy13:
	YYDEBUG(13, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'a') {
		if (yych <= 'A') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy90;
					goto yy3;
				} else {
					if (yych <= ' ') goto yy92;
					if (yych <= ',') goto yy3;
					goto yy62;
				}
			} else {
				if (yych <= '9') {
					if (yych <= '.') goto yy93;
					if (yych <= '/') goto yy64;
					goto yy99;
				} else {
					if (yych <= ':') goto yy95;
					if (yych <= '@') goto yy3;
					goto yy92;
				}
			}
		} else {
			if (yych <= 'J') {
				if (yych <= 'E') {
					if (yych == 'D') goto yy92;
					goto yy3;
				} else {
					if (yych == 'G') goto yy3;
					goto yy92;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'L') goto yy3;
					if (yych <= 'P') goto yy92;
					goto yy3;
				} else {
					if (yych <= 'Y') goto yy92;
					if (yych <= '`') goto yy3;
					goto yy92;
				}
			}
		}
	} else {
		if (yych <= 'p') {
			if (yych <= 'h') {
				if (yych <= 'e') {
					if (yych == 'd') goto yy92;
					goto yy3;
				} else {
					if (yych == 'g') goto yy3;
					goto yy92;
				}
			} else {
				if (yych <= 'l') {
					if (yych == 'j') goto yy92;
					goto yy3;
				} else {
					if (yych == 'n') goto yy85;
					goto yy92;
				}
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 's') {
					if (yych <= 'q') goto yy3;
					if (yych <= 'r') goto yy86;
					goto yy87;
				} else {
					if (yych <= 't') goto yy88;
					if (yych <= 'u') goto yy92;
					goto yy3;
				}
			} else {
				if (yych <= 'y') {
					if (yych == 'x') goto yy3;
					goto yy92;
				} else {
					if (yych == 0xC2) goto yy92;
					goto yy3;
				}
			}
		}
	}
yy14:
	YYDEBUG(14, *YYCURSOR);
	yyaccept = 1;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy100;
	if (yych <= '/') goto yy3;
	if (yych <= '9') goto yy101;
	goto yy3;
yy15:
	YYDEBUG(15, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy103;
			if (yych >= 'A') goto yy104;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy105;
				goto yy104;
			} else {
				if (yych <= 'P') goto yy106;
				if (yych <= 'T') goto yy104;
				goto yy107;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy104;
			} else {
				if (yych == 'g') goto yy109;
				goto yy108;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy110;
				goto yy108;
			} else {
				if (yych <= 'u') goto yy111;
				if (yych <= 'z') goto yy108;
			}
		}
	}
yy16:
	YYDEBUG(16, *YYCURSOR);
#line 1733 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("tzcorrection | tz");
		TIMELIB_INIT;
		TIMELIB_HAVE_TZ();
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIMEZONE;
	}
#line 1592 "lib/parse_date.c"
yy17:
	YYDEBUG(17, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy112;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy104;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy113;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy18:
	YYDEBUG(18, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy104;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy108;
		goto yy16;
	}
yy19:
	YYDEBUG(19, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy104;
			goto yy114;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'e') goto yy115;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy20:
	YYDEBUG(20, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'I') goto yy116;
			if (yych <= 'K') goto yy104;
			goto yy117;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy108;
			goto yy118;
		} else {
			if (yych == 'l') goto yy119;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy21:
	YYDEBUG(21, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy104;
				goto yy120;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy121;
				goto yy104;
			} else {
				if (yych <= 'O') goto yy122;
				if (yych <= 'Q') goto yy104;
				goto yy123;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy104;
				if (yych <= '`') goto yy16;
				goto yy108;
			} else {
				if (yych <= 'e') goto yy124;
				if (yych <= 'h') goto yy108;
				goto yy125;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy126;
				goto yy108;
			} else {
				if (yych <= 'r') goto yy127;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy22:
	YYDEBUG(22, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy104;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy128;
			goto yy104;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy23:
	YYDEBUG(23, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy16;
			} else {
				if (yych == '/') goto yy16;
				goto yy130;
			}
		}
	} else {
		if (yych <= 'V') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy16;
				goto yy104;
			} else {
				if (yych <= 'I') goto yy134;
				if (yych <= 'U') goto yy104;
				goto yy135;
			}
		} else {
			if (yych <= 'Z') {
				if (yych == 'X') goto yy135;
				goto yy104;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy24:
	YYDEBUG(24, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy136;
			if (yych <= 'T') goto yy104;
			goto yy137;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy138;
		} else {
			if (yych == 'u') goto yy139;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy25:
	YYDEBUG(25, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy140;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy104;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy141;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy26:
	YYDEBUG(26, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy142;
		} else {
			if (yych == 'I') goto yy143;
			if (yych <= 'N') goto yy104;
			goto yy144;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy145;
			goto yy108;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy146;
				goto yy108;
			} else {
				if (yych <= 'o') goto yy147;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy27:
	YYDEBUG(27, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy148;
				goto yy104;
			} else {
				if (yych <= 'I') goto yy149;
				if (yych <= 'N') goto yy104;
				goto yy150;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy104;
				goto yy16;
			} else {
				if (yych == 'e') goto yy151;
				goto yy108;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy152;
				goto yy108;
			} else {
				if (yych <= 'o') goto yy153;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy28:
	YYDEBUG(28, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy104;
			goto yy154;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'c') goto yy155;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy29:
	YYDEBUG(29, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy104;
			goto yy156;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'r') goto yy157;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy30:
	YYDEBUG(30, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy158;
				goto yy104;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy159;
				goto yy104;
			} else {
				if (yych <= 'I') goto yy160;
				if (yych <= 'T') goto yy104;
				goto yy144;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy104;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy161;
				if (yych <= 'd') goto yy108;
				goto yy162;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy163;
				goto yy108;
			} else {
				if (yych <= 'u') goto yy147;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy31:
	YYDEBUG(31, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy103;
		case '0':
		case '1': goto yy164;
		case '2': goto yy165;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy166;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z': goto yy104;
		case 'E': goto yy149;
		case 'H': goto yy167;
		case 'O': goto yy168;
		case 'U': goto yy169;
		case 'W': goto yy170;
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy108;
		case 'e': goto yy152;
		case 'h': goto yy171;
		case 'o': goto yy172;
		case 'u': goto yy173;
		case 'w': goto yy174;
		default: goto yy16;
	}
yy32:
	YYDEBUG(32, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy16;
			goto yy130;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy175;
				goto yy104;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy33:
	YYDEBUG(33, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy104;
			goto yy176;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'e') goto yy177;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy34:
	YYDEBUG(34, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy16;
			goto yy130;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy134;
				goto yy104;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy108;
				goto yy16;
			}
		}
	}
yy35:
	YYDEBUG(35, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy104;
			goto yy178;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy108;
		} else {
			if (yych <= 'e') goto yy179;
			if (yych <= 'z') goto yy108;
			goto yy16;
		}
	}
yy36:
	YYDEBUG(36, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'F') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'O') {
				if (yych <= 'G') goto yy105;
				goto yy104;
			} else {
				if (yych <= 'P') goto yy106;
				if (yych <= 'T') goto yy104;
				goto yy107;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy104;
				goto yy16;
			} else {
				if (yych == 'g') goto yy105;
				goto yy104;
			}
		} else {
			if (yych <= 't') {
				if (yych <= 'p') goto yy106;
				goto yy104;
			} else {
				if (yych <= 'u') goto yy107;
				if (yych <= 'z') goto yy104;
				goto yy16;
			}
		}
	}
yy37:
	YYDEBUG(37, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy112;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy104;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy112;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy38:
	YYDEBUG(38, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy104;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy104;
		goto yy16;
	}
yy39:
	YYDEBUG(39, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy104;
			goto yy114;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'e') goto yy114;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy40:
	YYDEBUG(40, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'I') goto yy116;
			if (yych <= 'K') goto yy104;
			goto yy117;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy104;
			goto yy116;
		} else {
			if (yych == 'l') goto yy117;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy41:
	YYDEBUG(41, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'E') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'D') goto yy104;
				goto yy120;
			}
		} else {
			if (yych <= 'N') {
				if (yych == 'I') goto yy121;
				goto yy104;
			} else {
				if (yych <= 'O') goto yy122;
				if (yych <= 'Q') goto yy104;
				goto yy123;
			}
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'd') {
				if (yych <= 'Z') goto yy104;
				if (yych <= '`') goto yy16;
				goto yy104;
			} else {
				if (yych <= 'e') goto yy120;
				if (yych <= 'h') goto yy104;
				goto yy121;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'o') goto yy122;
				goto yy104;
			} else {
				if (yych <= 'r') goto yy123;
				if (yych <= 'z') goto yy104;
				goto yy16;
			}
		}
	}
yy42:
	YYDEBUG(42, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych <= 'A') goto yy136;
			if (yych <= 'T') goto yy104;
			goto yy137;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy136;
		} else {
			if (yych == 'u') goto yy137;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy43:
	YYDEBUG(43, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy140;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy104;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy140;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy44:
	YYDEBUG(44, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'A') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy142;
		} else {
			if (yych == 'I') goto yy143;
			if (yych <= 'N') goto yy104;
			goto yy144;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy142;
			goto yy104;
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy143;
				goto yy104;
			} else {
				if (yych <= 'o') goto yy144;
				if (yych <= 'z') goto yy104;
				goto yy16;
			}
		}
	}
yy45:
	YYDEBUG(45, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= 'D') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy148;
				goto yy104;
			} else {
				if (yych <= 'I') goto yy149;
				if (yych <= 'N') goto yy104;
				goto yy150;
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy104;
				goto yy16;
			} else {
				if (yych == 'e') goto yy148;
				goto yy104;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= 'i') goto yy149;
				goto yy104;
			} else {
				if (yych <= 'o') goto yy150;
				if (yych <= 'z') goto yy104;
				goto yy16;
			}
		}
	}
yy46:
	YYDEBUG(46, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy104;
			goto yy154;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'c') goto yy154;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy47:
	YYDEBUG(47, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy104;
			goto yy156;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'r') goto yy156;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy48:
	YYDEBUG(48, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'A') goto yy158;
				goto yy104;
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') goto yy159;
				goto yy104;
			} else {
				if (yych <= 'I') goto yy160;
				if (yych <= 'T') goto yy104;
				goto yy144;
			}
		}
	} else {
		if (yych <= 'e') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy104;
				goto yy16;
			} else {
				if (yych <= 'a') goto yy158;
				if (yych <= 'd') goto yy104;
				goto yy159;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy160;
				goto yy104;
			} else {
				if (yych <= 'u') goto yy144;
				if (yych <= 'z') goto yy104;
				goto yy16;
			}
		}
	}
yy49:
	YYDEBUG(49, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	switch (yych) {
		case ')': goto yy103;
		case '0':
		case '1': goto yy164;
		case '2': goto yy165;
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy166;
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'F':
		case 'G':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'V':
		case 'X':
		case 'Y':
		case 'Z':
		case 'a':
		case 'b':
		case 'c':
		case 'd':
		case 'f':
		case 'g':
		case 'i':
		case 'j':
		case 'k':
		case 'l':
		case 'm':
		case 'n':
		case 'p':
		case 'q':
		case 'r':
		case 's':
		case 't':
		case 'v':
		case 'x':
		case 'y':
		case 'z': goto yy104;
		case 'E':
		case 'e': goto yy149;
		case 'H':
		case 'h': goto yy167;
		case 'O':
		case 'o': goto yy168;
		case 'U':
		case 'u': goto yy169;
		case 'W':
		case 'w': goto yy170;
		default: goto yy16;
	}
yy50:
	YYDEBUG(50, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy104;
			goto yy176;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'e') goto yy176;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy51:
	YYDEBUG(51, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy104;
			goto yy178;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy104;
			if (yych <= '`') goto yy16;
			goto yy104;
		} else {
			if (yych <= 'e') goto yy178;
			if (yych <= 'z') goto yy104;
			goto yy16;
		}
	}
yy52:
	YYDEBUG(52, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy52;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy54;
yy53:
	YYDEBUG(53, *YYCURSOR);
	YYCURSOR = YYMARKER;
	if (yyaccept <= 16) {
		if (yyaccept <= 8) {
			if (yyaccept <= 4) {
				if (yyaccept <= 2) {
					if (yyaccept <= 1) {
						if (yyaccept == 0) {
							goto yy5;
						} else {
							goto yy3;
						}
					} else {
						goto yy16;
					}
				} else {
					if (yyaccept == 3) {
						goto yy73;
					} else {
						goto yy102;
					}
				}
			} else {
				if (yyaccept <= 6) {
					if (yyaccept == 5) {
						goto yy203;
					} else {
						goto yy208;
					}
				} else {
					if (yyaccept == 7) {
						goto yy243;
					} else {
						goto yy273;
					}
				}
			}
		} else {
			if (yyaccept <= 12) {
				if (yyaccept <= 10) {
					if (yyaccept == 9) {
						goto yy271;
					} else {
						goto yy293;
					}
				} else {
					if (yyaccept == 11) {
						goto yy303;
					} else {
						goto yy329;
					}
				}
			} else {
				if (yyaccept <= 14) {
					if (yyaccept == 13) {
						goto yy394;
					} else {
						goto yy396;
					}
				} else {
					if (yyaccept == 15) {
						goto yy496;
					} else {
						goto yy536;
					}
				}
			}
		}
	} else {
		if (yyaccept <= 25) {
			if (yyaccept <= 21) {
				if (yyaccept <= 19) {
					if (yyaccept <= 18) {
						if (yyaccept == 17) {
							goto yy685;
						} else {
							goto yy701;
						}
					} else {
						goto yy714;
					}
				} else {
					if (yyaccept == 20) {
						goto yy737;
					} else {
						goto yy804;
					}
				}
			} else {
				if (yyaccept <= 23) {
					if (yyaccept == 22) {
						goto yy877;
					} else {
						goto yy568;
					}
				} else {
					if (yyaccept == 24) {
						goto yy892;
					} else {
						goto yy926;
					}
				}
			}
		} else {
			if (yyaccept <= 29) {
				if (yyaccept <= 27) {
					if (yyaccept == 26) {
						goto yy966;
					} else {
						goto yy984;
					}
				} else {
					if (yyaccept == 28) {
						goto yy989;
					} else {
						goto yy1040;
					}
				}
			} else {
				if (yyaccept <= 31) {
					if (yyaccept == 30) {
						goto yy1074;
					} else {
						goto yy1096;
					}
				} else {
					if (yyaccept == 32) {
						goto yy1099;
					} else {
						goto yy1219;
					}
				}
			}
		}
	}
yy54:
	YYDEBUG(54, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy180;
				if (yych <= 0x1F) goto yy53;
				goto yy180;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy53;
					goto yy182;
				} else {
					if (yych == 'F') goto yy183;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy71;
					goto yy53;
				} else {
					if (yych <= 'M') goto yy184;
					if (yych <= 'R') goto yy53;
					goto yy185;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy79;
					goto yy80;
				} else {
					if (yych == 'W') goto yy82;
					goto yy53;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy84;
					goto yy53;
				} else {
					if (yych <= 'd') goto yy182;
					if (yych <= 'e') goto yy53;
					goto yy183;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy53;
					goto yy71;
				} else {
					if (yych == 'm') goto yy184;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy185;
					goto yy79;
				} else {
					if (yych <= 'u') goto yy80;
					if (yych <= 'v') goto yy53;
					goto yy82;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy53;
					goto yy84;
				} else {
					if (yych == 0xC2) goto yy89;
					goto yy53;
				}
			}
		}
	}
yy55:
	YYDEBUG(55, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 2) {
		goto yy52;
	}
	if (yych <= ',') {
		if (yych == '+') goto yy55;
		goto yy53;
	} else {
		if (yych <= '-') goto yy55;
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy54;
		goto yy53;
	}
yy56:
	YYDEBUG(56, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy186;
				} else {
					if (yych <= ':') goto yy187;
					if (yych <= 'C') goto yy16;
					goto yy181;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy16;
					goto yy181;
				} else {
					if (yych == 'H') goto yy181;
					goto yy16;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy16;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy57:
	YYDEBUG(57, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych <= 0x08) goto yy16;
					goto yy181;
				} else {
					if (yych == ' ') goto yy181;
					goto yy16;
				}
			} else {
				if (yych <= '5') {
					if (yych <= '4') goto yy186;
					goto yy188;
				} else {
					if (yych <= '9') goto yy189;
					if (yych <= ':') goto yy187;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy181;
					goto yy16;
				} else {
					if (yych == 'G') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy181;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'U') goto yy181;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy181;
					goto yy16;
				} else {
					if (yych <= 'Y') goto yy181;
					if (yych <= 'c') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy58:
	YYDEBUG(58, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy16;
					goto yy188;
				} else {
					if (yych <= '9') goto yy189;
					if (yych <= ':') goto yy187;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy181;
					goto yy16;
				} else {
					if (yych == 'G') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy181;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'U') goto yy181;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy181;
					goto yy16;
				} else {
					if (yych <= 'Y') goto yy181;
					if (yych <= 'c') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy59:
	YYDEBUG(59, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy61;
	if (yych <= '0') goto yy192;
	if (yych <= '1') goto yy193;
	if (yych <= '9') goto yy194;
	goto yy61;
yy60:
	YYDEBUG(60, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy61:
	YYDEBUG(61, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy60;
					goto yy53;
				} else {
					if (yych <= ' ') goto yy60;
					if (yych <= ',') goto yy53;
					goto yy190;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy68;
					goto yy53;
				} else {
					if (yych <= 'D') goto yy69;
					if (yych == 'F') goto yy70;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy71;
					if (yych <= 'I') goto yy72;
					goto yy74;
				} else {
					if (yych <= 'L') goto yy53;
					if (yych <= 'M') goto yy75;
					goto yy76;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy77;
					if (yych <= 'R') goto yy53;
					goto yy78;
				} else {
					if (yych <= 'T') goto yy79;
					if (yych <= 'U') goto yy80;
					if (yych <= 'V') goto yy81;
					goto yy82;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy83;
					if (yych <= 'Y') goto yy84;
					goto yy53;
				} else {
					if (yych <= 'a') goto yy68;
					if (yych <= 'c') goto yy53;
					goto yy69;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy70;
					goto yy53;
				} else {
					if (yych <= 'h') goto yy71;
					if (yych == 'j') goto yy74;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy75;
					if (yych <= 'n') goto yy76;
					goto yy77;
				} else {
					if (yych <= 'r') goto yy53;
					if (yych <= 's') goto yy78;
					if (yych <= 't') goto yy79;
					goto yy80;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy82;
					goto yy53;
				} else {
					if (yych <= 'y') goto yy84;
					if (yych == 0xC2) goto yy89;
					goto yy53;
				}
			}
		}
	}
yy62:
	YYDEBUG(62, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy191;
	if (yych <= '0') goto yy195;
	if (yych <= '1') goto yy196;
	if (yych <= '9') goto yy197;
	goto yy191;
yy63:
	YYDEBUG(63, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy191;
		if (yych <= '0') goto yy202;
		goto yy204;
	} else {
		if (yych <= '5') goto yy205;
		if (yych <= '9') goto yy206;
		goto yy191;
	}
yy64:
	YYDEBUG(64, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0':
		case '1':
		case '2': goto yy207;
		case '3': goto yy209;
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy210;
		case 'A':
		case 'a': goto yy211;
		case 'D':
		case 'd': goto yy212;
		case 'F':
		case 'f': goto yy213;
		case 'J':
		case 'j': goto yy214;
		case 'M':
		case 'm': goto yy215;
		case 'N':
		case 'n': goto yy216;
		case 'O':
		case 'o': goto yy217;
		case 'S':
		case 's': goto yy218;
		default: goto yy53;
	}
yy65:
	YYDEBUG(65, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy59;
			if (yych <= ',') goto yy61;
			goto yy219;
		} else {
			if (yych <= '.') goto yy63;
			if (yych <= '/') goto yy64;
			if (yych <= '5') goto yy220;
			goto yy221;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy67;
			if (yych == 'n') goto yy85;
			goto yy61;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy61;
		}
	}
yy66:
	YYDEBUG(66, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy90;
			if (yych <= ',') goto yy92;
			goto yy219;
		} else {
			if (yych <= '.') goto yy93;
			if (yych <= '/') goto yy64;
			if (yych <= '5') goto yy220;
			goto yy221;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy95;
			if (yych == 'n') goto yy85;
			goto yy92;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy92;
		}
	}
yy67:
	YYDEBUG(67, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy222;
	if (yych <= '9') goto yy223;
	goto yy53;
yy68:
	YYDEBUG(68, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy224;
		if (yych <= 'T') goto yy53;
		goto yy225;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy224;
		} else {
			if (yych == 'u') goto yy225;
			goto yy53;
		}
	}
yy69:
	YYDEBUG(69, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy226;
		if (yych <= 'D') goto yy53;
		goto yy227;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy226;
		} else {
			if (yych == 'e') goto yy227;
			goto yy53;
		}
	}
yy70:
	YYDEBUG(70, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy228;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy229;
			if (yych <= 'Q') goto yy53;
			goto yy230;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy228;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy229;
			if (yych == 'r') goto yy230;
			goto yy53;
		}
	}
yy71:
	YYDEBUG(71, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy231;
	if (yych == 'o') goto yy231;
	goto yy53;
yy72:
	YYDEBUG(72, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			if (yych <= '.') goto yy232;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '9') goto yy233;
			if (yych == 'I') goto yy235;
		} else {
			if (yych == 'W') goto yy73;
			if (yych <= 'X') goto yy236;
		}
	}
yy73:
	YYDEBUG(73, *YYCURSOR);
#line 1483 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenoyearrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 3419 "lib/parse_date.c"
yy74:
	YYDEBUG(74, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy237;
		if (yych <= 'T') goto yy53;
		goto yy238;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy237;
		} else {
			if (yych == 'u') goto yy238;
			goto yy53;
		}
	}
yy75:
	YYDEBUG(75, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy239;
			if (yych <= 'H') goto yy53;
			goto yy240;
		} else {
			if (yych == 'O') goto yy241;
			if (yych <= 'R') goto yy53;
			goto yy242;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy239;
			if (yych <= 'h') goto yy53;
			goto yy240;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy53;
				goto yy241;
			} else {
				if (yych == 's') goto yy242;
				goto yy53;
			}
		}
	}
yy76:
	YYDEBUG(76, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy244;
	if (yych == 'o') goto yy244;
	goto yy53;
yy77:
	YYDEBUG(77, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy245;
	if (yych == 'c') goto yy245;
	goto yy53;
yy78:
	YYDEBUG(78, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy247;
			if (yych <= 'T') goto yy53;
			goto yy248;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy247;
			if (yych == 'u') goto yy248;
			goto yy53;
		}
	}
yy79:
	YYDEBUG(79, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy249;
		if (yych <= 'T') goto yy53;
		goto yy250;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy249;
		} else {
			if (yych == 'u') goto yy250;
			goto yy53;
		}
	}
yy80:
	YYDEBUG(80, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy251;
	if (yych == 's') goto yy251;
	goto yy53;
yy81:
	YYDEBUG(81, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy73;
			goto yy232;
		} else {
			if (yych == ' ') goto yy232;
			goto yy73;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy232;
			if (yych <= '/') goto yy73;
			goto yy233;
		} else {
			if (yych == 'I') goto yy83;
			goto yy73;
		}
	}
yy82:
	YYDEBUG(82, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy252;
	if (yych == 'e') goto yy252;
	goto yy53;
yy83:
	YYDEBUG(83, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy73;
			goto yy232;
		} else {
			if (yych == ' ') goto yy232;
			goto yy73;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy232;
			if (yych <= '/') goto yy73;
			goto yy233;
		} else {
			if (yych == 'I') goto yy235;
			goto yy73;
		}
	}
yy84:
	YYDEBUG(84, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy253;
	if (yych == 'e') goto yy253;
	goto yy53;
yy85:
	YYDEBUG(85, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'c') {
		if (yych == 'O') goto yy244;
		goto yy53;
	} else {
		if (yych <= 'd') goto yy254;
		if (yych == 'o') goto yy244;
		goto yy53;
	}
yy86:
	YYDEBUG(86, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy254;
	goto yy53;
yy87:
	YYDEBUG(87, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '`') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy247;
			if (yych == 'U') goto yy248;
			goto yy53;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'a') goto yy246;
			if (yych <= 'd') goto yy53;
			goto yy247;
		} else {
			if (yych <= 's') goto yy53;
			if (yych <= 't') goto yy254;
			if (yych <= 'u') goto yy248;
			goto yy53;
		}
	}
yy88:
	YYDEBUG(88, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy249;
		if (yych <= 'T') goto yy53;
		goto yy250;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy255;
		} else {
			if (yych == 'u') goto yy250;
			goto yy53;
		}
	}
yy89:
	YYDEBUG(89, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy256;
	goto yy53;
yy90:
	YYDEBUG(90, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy92;
	if (yych <= '0') goto yy192;
	if (yych <= '1') goto yy193;
	if (yych <= '9') goto yy194;
	goto yy92;
yy91:
	YYDEBUG(91, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy92:
	YYDEBUG(92, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy91;
					goto yy53;
				} else {
					if (yych <= ' ') goto yy91;
					if (yych <= ',') goto yy53;
					goto yy190;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy96;
					goto yy53;
				} else {
					if (yych <= 'D') goto yy69;
					if (yych == 'F') goto yy70;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy71;
					if (yych <= 'I') goto yy72;
					goto yy74;
				} else {
					if (yych <= 'L') goto yy53;
					if (yych <= 'M') goto yy75;
					if (yych <= 'N') goto yy76;
					goto yy77;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'P') goto yy97;
					if (yych <= 'R') goto yy53;
					goto yy78;
				} else {
					if (yych <= 'T') goto yy79;
					if (yych <= 'U') goto yy80;
					if (yych <= 'V') goto yy81;
					goto yy82;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy83;
					if (yych <= 'Y') goto yy84;
					goto yy53;
				} else {
					if (yych <= 'a') goto yy96;
					if (yych == 'd') goto yy69;
					goto yy53;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'f') goto yy70;
					if (yych <= 'g') goto yy53;
					goto yy71;
				} else {
					if (yych == 'j') goto yy74;
					if (yych <= 'l') goto yy53;
					goto yy75;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') {
					if (yych <= 'n') goto yy76;
					if (yych <= 'o') goto yy77;
					goto yy97;
				} else {
					if (yych <= 'r') goto yy53;
					if (yych <= 's') goto yy78;
					if (yych <= 't') goto yy79;
					goto yy80;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy82;
					goto yy53;
				} else {
					if (yych <= 'y') goto yy84;
					if (yych == 0xC2) goto yy89;
					goto yy53;
				}
			}
		}
	}
yy93:
	YYDEBUG(93, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= '/') goto yy191;
		if (yych <= '0') goto yy257;
		goto yy258;
	} else {
		if (yych <= '5') goto yy259;
		if (yych <= '9') goto yy260;
		goto yy191;
	}
yy94:
	YYDEBUG(94, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= '-') {
			if (yych == '\t') goto yy59;
			if (yych <= ',') goto yy61;
			goto yy219;
		} else {
			if (yych <= '.') goto yy63;
			if (yych <= '/') goto yy261;
			if (yych <= '5') goto yy220;
			goto yy221;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= ':') goto yy67;
			if (yych == 'n') goto yy85;
			goto yy61;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy61;
		}
	}
yy95:
	YYDEBUG(95, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy262;
	if (yych <= '9') goto yy263;
	goto yy53;
yy96:
	YYDEBUG(96, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= 'L') {
			if (yych == '.') goto yy264;
			goto yy53;
		} else {
			if (yych <= 'M') goto yy265;
			if (yych == 'P') goto yy224;
			goto yy53;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'U') goto yy225;
			if (yych == 'm') goto yy265;
			goto yy53;
		} else {
			if (yych <= 'p') goto yy224;
			if (yych == 'u') goto yy225;
			goto yy53;
		}
	}
yy97:
	YYDEBUG(97, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy264;
		goto yy53;
	} else {
		if (yych <= 'M') goto yy265;
		if (yych == 'm') goto yy265;
		goto yy53;
	}
yy98:
	YYDEBUG(98, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ',') {
			if (yych == '\t') goto yy59;
			goto yy61;
		} else {
			if (yych <= '-') goto yy219;
			if (yych <= '.') goto yy266;
			if (yych <= '/') goto yy261;
			goto yy221;
		}
	} else {
		if (yych <= 'q') {
			if (yych == 'n') goto yy85;
			goto yy61;
		} else {
			if (yych <= 'r') goto yy86;
			if (yych <= 's') goto yy87;
			if (yych <= 't') goto yy88;
			goto yy61;
		}
	}
yy99:
	YYDEBUG(99, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy267;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy221;
	goto yy181;
yy100:
	YYDEBUG(100, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= ':') goto yy53;
yy101:
	YYDEBUG(101, *YYCURSOR);
	yyaccept = 4;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 7) YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '.') goto yy268;
	if (yych <= '/') goto yy102;
	if (yych <= '9') goto yy101;
yy102:
	YYDEBUG(102, *YYCURSOR);
#line 1073 "lib/parse_date.re"
	{
		timelib_ull i;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 3896 "lib/parse_date.c"
yy103:
	YYDEBUG(103, *YYCURSOR);
	++YYCURSOR;
	goto yy16;
yy104:
	YYDEBUG(104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy269;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy269;
		goto yy16;
	}
yy105:
	YYDEBUG(105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy269;
			goto yy270;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'o') goto yy270;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy106:
	YYDEBUG(106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy269;
			goto yy272;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'r') goto yy272;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy107:
	YYDEBUG(107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy269;
			goto yy274;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'g') goto yy274;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy108:
	YYDEBUG(108, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy269;
			goto yy16;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy276;
			goto yy16;
		}
	}
yy109:
	YYDEBUG(109, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy270;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'o') goto yy277;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy110:
	YYDEBUG(110, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy272;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'r') goto yy278;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy111:
	YYDEBUG(111, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy274;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'g') goto yy279;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy112:
	YYDEBUG(112, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy269;
			goto yy280;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'c') goto yy280;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy113:
	YYDEBUG(113, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy280;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'c') goto yy281;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy114:
	YYDEBUG(114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'C') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'B') goto yy269;
			goto yy282;
		}
	} else {
		if (yych <= 'b') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'c') goto yy282;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy115:
	YYDEBUG(115, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'C') goto yy282;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'c') goto yy283;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy116:
	YYDEBUG(116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy269;
			goto yy284;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'g') goto yy284;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy117:
	YYDEBUG(117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy269;
			goto yy285;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'e') goto yy285;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy118:
	YYDEBUG(118, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy284;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'g') goto yy286;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy119:
	YYDEBUG(119, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy285;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'e') goto yy287;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy120:
	YYDEBUG(120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy269;
			goto yy288;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'b') goto yy288;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy121:
	YYDEBUG(121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'F') goto yy289;
			if (yych <= 'Q') goto yy269;
			goto yy290;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'e') goto yy269;
			goto yy289;
		} else {
			if (yych == 'r') goto yy290;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy122:
	YYDEBUG(122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy269;
			goto yy291;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'u') goto yy291;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy123:
	YYDEBUG(123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'I') goto yy292;
			if (yych <= 'N') goto yy269;
			goto yy294;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy269;
			goto yy292;
		} else {
			if (yych == 'o') goto yy294;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy124:
	YYDEBUG(124, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy288;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'b') goto yy295;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy125:
	YYDEBUG(125, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy275;
				goto yy16;
			} else {
				if (yych == 'F') goto yy289;
				goto yy269;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'R') goto yy290;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'q') {
				if (yych == 'f') goto yy296;
				goto yy276;
			} else {
				if (yych <= 'r') goto yy297;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy126:
	YYDEBUG(126, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy291;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'u') goto yy298;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy127:
	YYDEBUG(127, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy275;
				goto yy16;
			} else {
				if (yych == 'I') goto yy292;
				goto yy269;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'O') goto yy294;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy299;
				goto yy276;
			} else {
				if (yych <= 'o') goto yy300;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy128:
	YYDEBUG(128, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy269;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy301;
			goto yy269;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy129:
	YYDEBUG(129, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 23) YYFILL(23);
	yych = *YYCURSOR;
yy130:
	YYDEBUG(130, *YYCURSOR);
	if (yybm[0+yych] & 16) {
		goto yy129;
	}
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy131;
	if (yych <= '3') goto yy132;
	if (yych <= '9') goto yy133;
	goto yy53;
yy131:
	YYDEBUG(131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy304;
				goto yy53;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy306;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
				goto yy307;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy132:
	YYDEBUG(132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy304;
				goto yy53;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy306;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy310;
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
				goto yy307;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy133:
	YYDEBUG(133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy304;
				goto yy53;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy310;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
				goto yy307;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy134:
	YYDEBUG(134, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy16;
			goto yy130;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy311;
				goto yy269;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy269;
				goto yy16;
			}
		}
	}
yy135:
	YYDEBUG(135, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy103;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy130;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy136:
	YYDEBUG(136, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy269;
			goto yy312;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'n') goto yy312;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy137:
	YYDEBUG(137, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'L') goto yy313;
			if (yych <= 'M') goto yy269;
			goto yy314;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'k') goto yy269;
			goto yy313;
		} else {
			if (yych == 'n') goto yy314;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy138:
	YYDEBUG(138, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy312;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'n') goto yy315;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy139:
	YYDEBUG(139, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy275;
				goto yy16;
			} else {
				if (yych == 'L') goto yy313;
				goto yy269;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'N') goto yy314;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'l') goto yy316;
				goto yy276;
			} else {
				if (yych <= 'n') goto yy317;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy140:
	YYDEBUG(140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy269;
			goto yy318;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 's') goto yy318;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy141:
	YYDEBUG(141, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy318;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 's') goto yy319;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy142:
	YYDEBUG(142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'R') goto yy320;
			if (yych <= 'X') goto yy269;
			goto yy321;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'q') goto yy269;
			goto yy320;
		} else {
			if (yych == 'y') goto yy321;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy143:
	YYDEBUG(143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy269;
			goto yy322;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'd') goto yy322;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy144:
	YYDEBUG(144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy269;
			goto yy292;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'n') goto yy292;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy145:
	YYDEBUG(145, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy275;
				goto yy16;
			} else {
				if (yych == 'R') goto yy320;
				goto yy269;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'Y') goto yy321;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'x') {
				if (yych == 'r') goto yy323;
				goto yy276;
			} else {
				if (yych <= 'y') goto yy324;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy146:
	YYDEBUG(146, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy322;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'd') goto yy325;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy147:
	YYDEBUG(147, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy292;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'n') goto yy299;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy148:
	YYDEBUG(148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy269;
			goto yy326;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'x') goto yy326;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy149:
	YYDEBUG(149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy269;
			goto yy289;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'n') goto yy289;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy150:
	YYDEBUG(150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'W') {
		if (yych <= 'N') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'O') goto yy327;
			if (yych <= 'U') goto yy269;
			if (yych <= 'V') goto yy282;
			goto yy328;
		}
	} else {
		if (yych <= 'o') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'n') goto yy269;
			goto yy327;
		} else {
			if (yych <= 'v') {
				if (yych <= 'u') goto yy269;
				goto yy282;
			} else {
				if (yych <= 'w') goto yy328;
				if (yych <= 'z') goto yy269;
				goto yy16;
			}
		}
	}
yy151:
	YYDEBUG(151, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy326;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'x') goto yy330;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy152:
	YYDEBUG(152, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy289;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'n') goto yy296;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy153:
	YYDEBUG(153, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '/') goto yy275;
				if (yych <= '@') goto yy16;
				goto yy269;
			} else {
				if (yych <= 'O') goto yy327;
				if (yych <= 'U') goto yy269;
				goto yy282;
			}
		}
	} else {
		if (yych <= 'n') {
			if (yych <= '^') {
				if (yych <= 'W') goto yy328;
				if (yych <= 'Z') goto yy269;
				goto yy16;
			} else {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy16;
				goto yy276;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 'o') goto yy331;
				if (yych <= 'u') goto yy276;
				goto yy283;
			} else {
				if (yych <= 'w') goto yy332;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy154:
	YYDEBUG(154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy269;
			goto yy333;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 't') goto yy333;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy155:
	YYDEBUG(155, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy333;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 't') goto yy334;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy156:
	YYDEBUG(156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy269;
			goto yy335;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'e') goto yy335;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy157:
	YYDEBUG(157, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy335;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'e') goto yy336;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy158:
	YYDEBUG(158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy269;
			goto yy337;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 't') goto yy337;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy159:
	YYDEBUG(159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= 'B') {
			if (yych == ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'O') {
				if (yych <= 'C') goto yy338;
				goto yy269;
			} else {
				if (yych <= 'P') goto yy339;
				if (yych <= 'U') goto yy269;
				goto yy340;
			}
		}
	} else {
		if (yych <= 'o') {
			if (yych <= '`') {
				if (yych <= 'Z') goto yy269;
				goto yy16;
			} else {
				if (yych == 'c') goto yy338;
				goto yy269;
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'p') goto yy339;
				goto yy269;
			} else {
				if (yych <= 'v') goto yy340;
				if (yych <= 'z') goto yy269;
				goto yy16;
			}
		}
	}
yy160:
	YYDEBUG(160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'W') goto yy269;
			goto yy289;
		}
	} else {
		if (yych <= 'w') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'x') goto yy289;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy161:
	YYDEBUG(161, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy337;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 't') goto yy341;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy162:
	YYDEBUG(162, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '/') {
			if (yych <= ',') {
				if (yych == ')') goto yy103;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy275;
			}
		} else {
			if (yych <= 'C') {
				if (yych <= '@') goto yy16;
				if (yych <= 'B') goto yy269;
				goto yy338;
			} else {
				if (yych == 'P') goto yy339;
				goto yy269;
			}
		}
	} else {
		if (yych <= 'b') {
			if (yych <= '^') {
				if (yych <= 'V') goto yy340;
				if (yych <= 'Z') goto yy269;
				goto yy16;
			} else {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy16;
				goto yy276;
			}
		} else {
			if (yych <= 'p') {
				if (yych <= 'c') goto yy342;
				if (yych <= 'o') goto yy276;
				goto yy343;
			} else {
				if (yych == 'v') goto yy344;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy163:
	YYDEBUG(163, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'X') goto yy289;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'w') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'x') goto yy296;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy164:
	YYDEBUG(164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy67;
		goto yy53;
	} else {
		if (yych <= '9') goto yy345;
		if (yych <= ':') goto yy67;
		goto yy53;
	}
yy165:
	YYDEBUG(165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy67;
		goto yy53;
	} else {
		if (yych <= '4') goto yy345;
		if (yych == ':') goto yy67;
		goto yy53;
	}
yy166:
	YYDEBUG(166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy67;
	if (yych == ':') goto yy67;
	goto yy53;
yy167:
	YYDEBUG(167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'I') goto yy346;
			if (yych <= 'T') goto yy269;
			goto yy347;
		}
	} else {
		if (yych <= 'i') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'h') goto yy269;
			goto yy346;
		} else {
			if (yych == 'u') goto yy347;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy168:
	YYDEBUG(168, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == 'D') goto yy348;
			if (yych <= 'L') goto yy269;
			goto yy349;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			if (yych <= 'c') goto yy269;
			goto yy348;
		} else {
			if (yych == 'm') goto yy349;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy169:
	YYDEBUG(169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy269;
			goto yy350;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'e') goto yy350;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy170:
	YYDEBUG(170, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy269;
			goto yy351;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'e') goto yy351;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy171:
	YYDEBUG(171, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy275;
				goto yy16;
			} else {
				if (yych == 'I') goto yy346;
				goto yy269;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'U') goto yy347;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 't') {
				if (yych == 'i') goto yy352;
				goto yy276;
			} else {
				if (yych <= 'u') goto yy353;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy172:
	YYDEBUG(172, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '.') {
			if (yych <= ')') {
				if (yych <= '(') goto yy16;
				goto yy103;
			} else {
				if (yych == '-') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= '@') {
				if (yych <= '/') goto yy275;
				goto yy16;
			} else {
				if (yych == 'D') goto yy348;
				goto yy269;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'M') goto yy349;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'l') {
				if (yych == 'd') goto yy354;
				goto yy276;
			} else {
				if (yych <= 'm') goto yy355;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy173:
	YYDEBUG(173, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy350;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'e') goto yy356;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy174:
	YYDEBUG(174, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy351;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 'e') goto yy357;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy175:
	YYDEBUG(175, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy16;
			goto yy130;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy358;
				goto yy269;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy269;
				goto yy16;
			}
		}
	}
yy176:
	YYDEBUG(176, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych <= 'C') goto yy269;
			if (yych <= 'D') goto yy359;
			goto yy360;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 'd') goto yy359;
			if (yych <= 'e') goto yy360;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy177:
	YYDEBUG(177, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy16;
				goto yy275;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'C') goto yy269;
				goto yy359;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'E') goto yy360;
				goto yy269;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy276;
				goto yy361;
			} else {
				if (yych <= 'e') goto yy362;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy178:
	YYDEBUG(178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy269;
			goto yy363;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy269;
			if (yych <= '`') goto yy16;
			goto yy269;
		} else {
			if (yych <= 's') goto yy363;
			if (yych <= 'z') goto yy269;
			goto yy16;
		}
	}
yy179:
	YYDEBUG(179, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy269;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy363;
			if (yych <= 'Z') goto yy269;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy276;
			} else {
				if (yych <= 's') goto yy364;
				if (yych <= 'z') goto yy276;
				goto yy16;
			}
		}
	}
yy180:
	YYDEBUG(180, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy181:
	YYDEBUG(181, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy180;
				if (yych <= 0x1F) goto yy53;
				goto yy180;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy53;
				} else {
					if (yych == 'F') goto yy183;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy71;
					goto yy53;
				} else {
					if (yych <= 'M') goto yy184;
					if (yych <= 'R') goto yy53;
					goto yy185;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy79;
					goto yy80;
				} else {
					if (yych == 'W') goto yy82;
					goto yy53;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy84;
					goto yy53;
				} else {
					if (yych <= 'd') goto yy182;
					if (yych <= 'e') goto yy53;
					goto yy183;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy53;
					goto yy71;
				} else {
					if (yych == 'm') goto yy184;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy185;
					goto yy79;
				} else {
					if (yych <= 'u') goto yy80;
					if (yych <= 'v') goto yy53;
					goto yy82;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy53;
					goto yy84;
				} else {
					if (yych == 0xC2) goto yy89;
					goto yy53;
				}
			}
		}
	}
yy182:
	YYDEBUG(182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy226;
	if (yych == 'a') goto yy226;
	goto yy53;
yy183:
	YYDEBUG(183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy229;
		if (yych <= 'Q') goto yy53;
		goto yy230;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy229;
		} else {
			if (yych == 'r') goto yy230;
			goto yy53;
		}
	}
yy184:
	YYDEBUG(184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy241;
			if (yych <= 'R') goto yy53;
			goto yy242;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy240;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy241;
			if (yych == 's') goto yy242;
			goto yy53;
		}
	}
yy185:
	YYDEBUG(185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy365;
			if (yych <= 'T') goto yy53;
			goto yy248;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy365;
			if (yych == 'u') goto yy248;
			goto yy53;
		}
	}
yy186:
	YYDEBUG(186, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '5') {
					if (yych <= '/') goto yy16;
					goto yy366;
				} else {
					if (yych <= '9') goto yy367;
					if (yych >= ';') goto yy16;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy181;
					goto yy16;
				} else {
					if (yych == 'G') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy181;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'U') goto yy181;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy181;
					goto yy16;
				} else {
					if (yych <= 'Y') goto yy181;
					if (yych <= 'c') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy187:
	YYDEBUG(187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy368;
	if (yych <= '9') goto yy103;
	goto yy16;
yy188:
	YYDEBUG(188, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy367;
				} else {
					if (yych == 'D') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy16;
				if (yych <= 'H') goto yy181;
				goto yy16;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy16;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy189:
	YYDEBUG(189, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy369;
				} else {
					if (yych == 'D') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy16;
				if (yych <= 'H') goto yy181;
				goto yy16;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy16;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy190:
	YYDEBUG(190, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 13) YYFILL(13);
	yych = *YYCURSOR;
yy191:
	YYDEBUG(191, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case '-':
		case '.': goto yy190;
		case 'A':
		case 'a': goto yy68;
		case 'D':
		case 'd': goto yy198;
		case 'F':
		case 'f': goto yy199;
		case 'I': goto yy72;
		case 'J':
		case 'j': goto yy74;
		case 'M':
		case 'm': goto yy200;
		case 'N':
		case 'n': goto yy76;
		case 'O':
		case 'o': goto yy77;
		case 'S':
		case 's': goto yy201;
		case 'V': goto yy81;
		case 'X': goto yy83;
		default: goto yy53;
	}
yy192:
	YYDEBUG(192, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy370;
		goto yy371;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy194;
		goto yy53;
	}
yy193:
	YYDEBUG(193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy370;
		goto yy371;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy194:
	YYDEBUG(194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy370;
	if (yych <= '.') goto yy371;
	goto yy53;
yy195:
	YYDEBUG(195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy372;
		goto yy370;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy197;
		goto yy53;
	}
yy196:
	YYDEBUG(196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy372;
		goto yy370;
	} else {
		if (yych <= '/') goto yy53;
		if (yych >= '3') goto yy53;
	}
yy197:
	YYDEBUG(197, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy372;
	if (yych <= '.') goto yy370;
	goto yy53;
yy198:
	YYDEBUG(198, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy227;
	if (yych == 'e') goto yy227;
	goto yy53;
yy199:
	YYDEBUG(199, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy228;
	if (yych == 'e') goto yy228;
	goto yy53;
yy200:
	YYDEBUG(200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy239;
	if (yych == 'a') goto yy239;
	goto yy53;
yy201:
	YYDEBUG(201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy373;
	if (yych == 'e') goto yy373;
	goto yy53;
yy202:
	YYDEBUG(202, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		goto yy374;
	} else {
		if (yych <= '/') goto yy203;
		if (yych <= '9') goto yy206;
		if (yych <= ':') goto yy375;
	}
yy203:
	YYDEBUG(203, *YYCURSOR);
#line 1226 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("timeshort24 | timelong24 | iso8601long");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 6555 "lib/parse_date.c"
yy204:
	YYDEBUG(204, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		if (yych <= '.') goto yy374;
		goto yy203;
	} else {
		if (yych <= '2') goto yy206;
		if (yych <= '9') goto yy223;
		if (yych <= ':') goto yy375;
		goto yy203;
	}
yy205:
	YYDEBUG(205, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		goto yy374;
	} else {
		if (yych <= '/') goto yy203;
		if (yych <= '9') goto yy223;
		if (yych <= ':') goto yy375;
		goto yy203;
	}
yy206:
	YYDEBUG(206, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		goto yy374;
	} else {
		if (yych == ':') goto yy375;
		goto yy203;
	}
yy207:
	YYDEBUG(207, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych >= '/') goto yy376;
		} else {
			if (yych <= '9') goto yy210;
			if (yych >= 'n') goto yy377;
		}
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy377;
		} else {
			if (yych <= 's') goto yy378;
			if (yych <= 't') goto yy379;
		}
	}
yy208:
	YYDEBUG(208, *YYCURSOR);
#line 1318 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("americanshort | american");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '/') {
			s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
			TIMELIB_PROCESS_YEAR(s->time->y, length);
		}
		TIMELIB_DEINIT;
		return TIMELIB_AMERICAN;
	}
#line 6633 "lib/parse_date.c"
yy209:
	YYDEBUG(209, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') {
			if (yych <= '.') goto yy208;
			goto yy376;
		} else {
			if (yych <= '1') goto yy210;
			if (yych <= 'm') goto yy208;
			goto yy377;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy208;
			goto yy377;
		} else {
			if (yych <= 's') goto yy378;
			if (yych <= 't') goto yy379;
			goto yy208;
		}
	}
yy210:
	YYDEBUG(210, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy376;
		if (yych <= 'm') goto yy208;
		goto yy377;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy208;
			goto yy377;
		} else {
			if (yych <= 's') goto yy378;
			if (yych <= 't') goto yy379;
			goto yy208;
		}
	}
yy211:
	YYDEBUG(211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy380;
		if (yych <= 'T') goto yy53;
		goto yy381;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy380;
		} else {
			if (yych == 'u') goto yy381;
			goto yy53;
		}
	}
yy212:
	YYDEBUG(212, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy382;
	if (yych == 'e') goto yy382;
	goto yy53;
yy213:
	YYDEBUG(213, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy383;
	if (yych == 'e') goto yy383;
	goto yy53;
yy214:
	YYDEBUG(214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy384;
		if (yych <= 'T') goto yy53;
		goto yy385;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy384;
		} else {
			if (yych == 'u') goto yy385;
			goto yy53;
		}
	}
yy215:
	YYDEBUG(215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy386;
	if (yych == 'a') goto yy386;
	goto yy53;
yy216:
	YYDEBUG(216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy387;
	if (yych == 'o') goto yy387;
	goto yy53;
yy217:
	YYDEBUG(217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy388;
	if (yych == 'c') goto yy388;
	goto yy53;
yy218:
	YYDEBUG(218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy389;
	if (yych == 'e') goto yy389;
	goto yy53;
yy219:
	YYDEBUG(219, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy191;
	if (yych <= '0') goto yy390;
	if (yych <= '1') goto yy391;
	if (yych <= '9') goto yy197;
	goto yy191;
yy220:
	YYDEBUG(220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy392;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy393;
	goto yy181;
yy221:
	YYDEBUG(221, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy392;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy395;
	goto yy181;
yy222:
	YYDEBUG(222, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy375;
		goto yy203;
	} else {
		if (yych <= '9') goto yy223;
		if (yych <= ':') goto yy375;
		goto yy203;
	}
yy223:
	YYDEBUG(223, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy375;
	if (yych == ':') goto yy375;
	goto yy203;
yy224:
	YYDEBUG(224, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy397;
	if (yych == 'r') goto yy397;
	goto yy53;
yy225:
	YYDEBUG(225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy398;
	if (yych == 'g') goto yy398;
	goto yy53;
yy226:
	YYDEBUG(226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy399;
	if (yych == 'y') goto yy399;
	goto yy53;
yy227:
	YYDEBUG(227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy400;
	if (yych == 'c') goto yy400;
	goto yy53;
yy228:
	YYDEBUG(228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy401;
	if (yych == 'b') goto yy401;
	goto yy53;
yy229:
	YYDEBUG(229, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy402;
	if (yych == 'r') goto yy402;
	goto yy53;
yy230:
	YYDEBUG(230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy403;
	if (yych == 'i') goto yy403;
	goto yy53;
yy231:
	YYDEBUG(231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy404;
	if (yych == 'u') goto yy404;
	goto yy53;
yy232:
	YYDEBUG(232, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 4) YYFILL(4);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy232;
		if (yych <= 0x1F) goto yy53;
		goto yy232;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy53;
			goto yy232;
		} else {
			if (yych <= '/') goto yy53;
			if (yych >= ':') goto yy53;
		}
	}
yy233:
	YYDEBUG(233, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy234;
	if (yych <= '9') goto yy405;
yy234:
	YYDEBUG(234, *YYCURSOR);
#line 1400 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datefull");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		timelib_skip_day_suffix((char **) &ptr);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL;
	}
#line 6871 "lib/parse_date.c"
yy235:
	YYDEBUG(235, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy73;
			goto yy232;
		} else {
			if (yych == ' ') goto yy232;
			goto yy73;
		}
	} else {
		if (yych <= '9') {
			if (yych <= '.') goto yy232;
			if (yych <= '/') goto yy73;
			goto yy233;
		} else {
			if (yych != 'I') goto yy73;
		}
	}
yy236:
	YYDEBUG(236, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy232;
		if (yych <= 0x1F) goto yy73;
		goto yy232;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy73;
			goto yy232;
		} else {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		}
	}
yy237:
	YYDEBUG(237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy406;
	if (yych == 'n') goto yy406;
	goto yy53;
yy238:
	YYDEBUG(238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy407;
		if (yych <= 'M') goto yy53;
		goto yy408;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy407;
		} else {
			if (yych == 'n') goto yy408;
			goto yy53;
		}
	}
yy239:
	YYDEBUG(239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy409;
		if (yych <= 'X') goto yy53;
		goto yy236;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy409;
		} else {
			if (yych == 'y') goto yy236;
			goto yy53;
		}
	}
yy240:
	YYDEBUG(240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy410;
			goto yy53;
		} else {
			if (yych <= 'L') goto yy411;
			if (yych <= 'M') goto yy53;
			goto yy412;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy410;
			goto yy53;
		} else {
			if (yych <= 'l') goto yy411;
			if (yych == 'n') goto yy412;
			goto yy53;
		}
	}
yy241:
	YYDEBUG(241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy413;
	if (yych == 'n') goto yy413;
	goto yy53;
yy242:
	YYDEBUG(242, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy414;
	if (yych == 'e') goto yy414;
yy243:
	YYDEBUG(243, *YYCURSOR);
#line 1801 "lib/parse_date.re"
	{
		timelib_ull i;
		DEBUG_OUTPUT("relative");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_unsigned_nr((char **) &ptr, 24);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, 1, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 7000 "lib/parse_date.c"
yy244:
	YYDEBUG(244, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy400;
	if (yych == 'v') goto yy400;
	goto yy53;
yy245:
	YYDEBUG(245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy415;
	if (yych == 't') goto yy415;
	goto yy53;
yy246:
	YYDEBUG(246, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy416;
	if (yych == 't') goto yy416;
	goto yy53;
yy247:
	YYDEBUG(247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy417;
		if (yych <= 'O') goto yy53;
		goto yy418;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy417;
		} else {
			if (yych == 'p') goto yy418;
			goto yy53;
		}
	}
yy248:
	YYDEBUG(248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy403;
	if (yych == 'n') goto yy403;
	goto yy53;
yy249:
	YYDEBUG(249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy419;
	if (yych == 'u') goto yy419;
	goto yy53;
yy250:
	YYDEBUG(250, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy420;
	if (yych == 'e') goto yy420;
	goto yy53;
yy251:
	YYDEBUG(251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy414;
	if (yych == 'e') goto yy414;
	goto yy53;
yy252:
	YYDEBUG(252, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy421;
		goto yy422;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy421;
		if (yych <= 'e') goto yy422;
		goto yy53;
	}
yy253:
	YYDEBUG(253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy404;
	if (yych == 'a') goto yy404;
	goto yy53;
yy254:
	YYDEBUG(254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') {
		if (yych == '\t') goto yy266;
		goto yy191;
	} else {
		if (yych <= '-') goto yy423;
		if (yych <= '.') goto yy266;
		if (yych <= '/') goto yy261;
		goto yy191;
	}
yy255:
	YYDEBUG(255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy191;
			goto yy266;
		} else {
			if (yych <= ',') goto yy191;
			if (yych <= '-') goto yy423;
			goto yy266;
		}
	} else {
		if (yych <= 'U') {
			if (yych <= '/') goto yy261;
			if (yych <= 'T') goto yy191;
			goto yy419;
		} else {
			if (yych == 'u') goto yy419;
			goto yy191;
		}
	}
yy256:
	YYDEBUG(256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy242;
	if (yych == 's') goto yy242;
	goto yy53;
yy257:
	YYDEBUG(257, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		goto yy424;
	} else {
		if (yych <= '/') goto yy203;
		if (yych <= '9') goto yy425;
		if (yych <= ':') goto yy426;
		goto yy203;
	}
yy258:
	YYDEBUG(258, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		if (yych <= '.') goto yy424;
		goto yy203;
	} else {
		if (yych <= '2') goto yy425;
		if (yych <= '9') goto yy427;
		if (yych <= ':') goto yy426;
		goto yy203;
	}
yy259:
	YYDEBUG(259, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		goto yy424;
	} else {
		if (yych <= '/') goto yy203;
		if (yych <= '9') goto yy427;
		if (yych <= ':') goto yy426;
		goto yy203;
	}
yy260:
	YYDEBUG(260, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ',') goto yy203;
		if (yych <= '-') goto yy370;
		goto yy424;
	} else {
		if (yych == ':') goto yy426;
		goto yy203;
	}
yy261:
	YYDEBUG(261, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case 'A':
		case 'a': goto yy211;
		case 'D':
		case 'd': goto yy212;
		case 'F':
		case 'f': goto yy213;
		case 'J':
		case 'j': goto yy214;
		case 'M':
		case 'm': goto yy215;
		case 'N':
		case 'n': goto yy216;
		case 'O':
		case 'o': goto yy217;
		case 'S':
		case 's': goto yy218;
		default: goto yy53;
	}
yy262:
	YYDEBUG(262, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy426;
		goto yy203;
	} else {
		if (yych <= '9') goto yy428;
		if (yych <= ':') goto yy426;
		goto yy203;
	}
yy263:
	YYDEBUG(263, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy426;
	if (yych == ':') goto yy426;
	goto yy203;
yy264:
	YYDEBUG(264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy265;
	if (yych != 'm') goto yy53;
yy265:
	YYDEBUG(265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy429;
		if (yych == '\t') goto yy429;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy429;
		if (yych == '.') goto yy430;
		goto yy53;
	}
yy266:
	YYDEBUG(266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy191;
	if (yych <= '0') goto yy192;
	if (yych <= '1') goto yy193;
	if (yych <= '9') goto yy194;
	goto yy191;
yy267:
	YYDEBUG(267, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy431;
		case '1': goto yy432;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy433;
		case 'A':
		case 'a': goto yy434;
		case 'D':
		case 'd': goto yy435;
		case 'F':
		case 'f': goto yy436;
		case 'J':
		case 'j': goto yy437;
		case 'M':
		case 'm': goto yy438;
		case 'N':
		case 'n': goto yy439;
		case 'O':
		case 'o': goto yy440;
		case 'S':
		case 's': goto yy441;
		default: goto yy53;
	}
yy268:
	YYDEBUG(268, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy442;
	goto yy53;
yy269:
	YYDEBUG(269, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy443;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy443;
		goto yy16;
	}
yy270:
	YYDEBUG(270, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
	} else {
		if (yych <= 'Z') goto yy443;
		if (yych <= '`') goto yy271;
		if (yych <= 'z') goto yy443;
	}
yy271:
	YYDEBUG(271, *YYCURSOR);
#line 1643 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("ago");
		TIMELIB_INIT;
		s->time->relative.y = 0 - s->time->relative.y;
		s->time->relative.m = 0 - s->time->relative.m;
		s->time->relative.d = 0 - s->time->relative.d;
		s->time->relative.h = 0 - s->time->relative.h;
		s->time->relative.i = 0 - s->time->relative.i;
		s->time->relative.s = 0 - s->time->relative.s;
		s->time->relative.weekday = 0 - s->time->relative.weekday;
		if (s->time->relative.weekday == 0) {
			s->time->relative.weekday = -7;
		}
		if (s->time->relative.have_special_relative && s->time->relative.special.type == TIMELIB_SPECIAL_WEEKDAY) {
			s->time->relative.special.amount = 0 - s->time->relative.special.amount;
		}
		TIMELIB_DEINIT;
		return TIMELIB_AGO;
	}
#line 7321 "lib/parse_date.c"
yy272:
	YYDEBUG(272, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych >= '\t') goto yy130;
			} else {
				if (yych == ' ') goto yy130;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
			} else {
				if (yych == 'I') goto yy445;
				goto yy443;
			}
		} else {
			if (yych <= 'h') {
				if (yych >= 'a') goto yy443;
			} else {
				if (yych <= 'i') goto yy445;
				if (yych <= 'z') goto yy443;
			}
		}
	}
yy273:
	YYDEBUG(273, *YYCURSOR);
#line 1723 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("monthtext");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_lookup_month((char **) &ptr);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 7369 "lib/parse_date.c"
yy274:
	YYDEBUG(274, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'U') goto yy446;
				goto yy443;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'u') goto yy446;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy275:
	YYDEBUG(275, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy447;
	}
	goto yy53;
yy276:
	YYDEBUG(276, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy443;
			goto yy16;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy448;
			goto yy16;
		}
	}
yy277:
	YYDEBUG(277, *YYCURSOR);
	yyaccept = 9;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy271;
		} else {
			if (yych == '.') goto yy271;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy271;
			if (yych <= 'Z') goto yy443;
			goto yy271;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy271;
			if (yych <= 'z') goto yy448;
			goto yy271;
		}
	}
yy278:
	YYDEBUG(278, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'H') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'I') goto yy445;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'h') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'i') goto yy450;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy279:
	YYDEBUG(279, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'U') goto yy446;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'u') goto yy451;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy280:
	YYDEBUG(280, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'J') goto yy443;
			goto yy452;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'k') goto yy452;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy281:
	YYDEBUG(281, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy452;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'k') goto yy453;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy282:
	YYDEBUG(282, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'E') goto yy454;
				goto yy443;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'e') goto yy454;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy283:
	YYDEBUG(283, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'E') goto yy454;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'e') goto yy455;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy284:
	YYDEBUG(284, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy443;
			goto yy456;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'h') goto yy456;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy285:
	YYDEBUG(285, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy443;
			goto yy457;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'v') goto yy457;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy286:
	YYDEBUG(286, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy456;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'h') goto yy458;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy287:
	YYDEBUG(287, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy457;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'v') goto yy459;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy288:
	YYDEBUG(288, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'R') goto yy460;
				goto yy443;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'r') goto yy460;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy289:
	YYDEBUG(289, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy443;
			goto yy461;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 't') goto yy461;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy290:
	YYDEBUG(290, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy443;
			goto yy462;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 's') goto yy462;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy291:
	YYDEBUG(291, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy443;
			goto yy463;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'r') goto yy463;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy292:
	YYDEBUG(292, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych >= ')') goto yy103;
		} else {
			if (yych <= '@') goto yy293;
			if (yych <= 'C') goto yy443;
			goto yy464;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy443;
			if (yych >= 'a') goto yy443;
		} else {
			if (yych <= 'd') goto yy464;
			if (yych <= 'z') goto yy443;
		}
	}
yy293:
	YYDEBUG(293, *YYCURSOR);
#line 1664 "lib/parse_date.re"
	{
		const timelib_relunit* relunit;
		DEBUG_OUTPUT("daytext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_WEEKDAY_RELATIVE();
		TIMELIB_UNHAVE_TIME();
		relunit = timelib_lookup_relunit((char**) &ptr);
		s->time->relative.weekday = relunit->multiplier;
		if (s->time->relative.weekday_behavior != 2) {
			s->time->relative.weekday_behavior = 1;
		}

		TIMELIB_DEINIT;
		return TIMELIB_WEEKDAY;
	}
#line 7961 "lib/parse_date.c"
yy294:
	YYDEBUG(294, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy443;
			goto yy465;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'n') goto yy465;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy295:
	YYDEBUG(295, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'Q') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'R') goto yy460;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'q') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'r') goto yy466;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy296:
	YYDEBUG(296, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy461;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 't') goto yy467;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy297:
	YYDEBUG(297, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy462;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 's') goto yy468;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy298:
	YYDEBUG(298, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy463;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'r') goto yy469;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy299:
	YYDEBUG(299, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy293;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy293;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy464;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy293;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy293;
				goto yy448;
			} else {
				if (yych <= 'd') goto yy470;
				if (yych <= 'z') goto yy448;
				goto yy293;
			}
		}
	}
yy300:
	YYDEBUG(300, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy465;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'n') goto yy471;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy301:
	YYDEBUG(301, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych == '+') goto yy472;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy472;
			if (yych <= '@') goto yy16;
			goto yy443;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy302:
	YYDEBUG(302, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '0') {
			if (yych >= '0') goto yy473;
		} else {
			if (yych <= '1') goto yy474;
			if (yych <= '2') goto yy475;
			goto yy476;
		}
	} else {
		if (yych <= 'T') {
			if (yych >= 'T') goto yy477;
		} else {
			if (yych == 't') goto yy477;
		}
	}
yy303:
	YYDEBUG(303, *YYCURSOR);
#line 1469 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datetextual | datenoyear");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_TEXT;
	}
#line 8242 "lib/parse_date.c"
yy304:
	YYDEBUG(304, *YYCURSOR);
	yyaccept = 11;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 18) YYFILL(18);
	yych = *YYCURSOR;
yy305:
	YYDEBUG(305, *YYCURSOR);
	if (yybm[0+yych] & 32) {
		goto yy304;
	}
	if (yych <= '2') {
		if (yych <= '/') goto yy303;
		if (yych <= '0') goto yy478;
		if (yych <= '1') goto yy479;
		goto yy480;
	} else {
		if (yych <= '9') goto yy481;
		if (yych == 'T') goto yy477;
		goto yy303;
	}
yy306:
	YYDEBUG(306, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy304;
				goto yy53;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy482;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy307:
	YYDEBUG(307, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'd') goto yy483;
	goto yy305;
yy308:
	YYDEBUG(308, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 't') goto yy483;
	goto yy305;
yy309:
	YYDEBUG(309, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'h') goto yy483;
	goto yy305;
yy310:
	YYDEBUG(310, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy482;
	goto yy53;
yy311:
	YYDEBUG(311, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy103;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy130;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy312:
	YYDEBUG(312, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'U') goto yy484;
				goto yy443;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'u') goto yy484;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy313:
	YYDEBUG(313, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'Y') goto yy485;
				goto yy443;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'y') goto yy485;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy314:
	YYDEBUG(314, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'E') goto yy485;
				goto yy443;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'e') goto yy485;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy315:
	YYDEBUG(315, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'T') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'U') goto yy484;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 't') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'u') goto yy486;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy316:
	YYDEBUG(316, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'X') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'Y') goto yy485;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'x') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'y') goto yy487;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy317:
	YYDEBUG(317, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'E') goto yy485;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'e') goto yy487;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy318:
	YYDEBUG(318, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy443;
			goto yy488;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 't') goto yy488;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy319:
	YYDEBUG(319, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy488;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 't') goto yy489;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy320:
	YYDEBUG(320, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'C') goto yy490;
				goto yy443;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'c') goto yy490;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy321:
	YYDEBUG(321, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy273;
			goto yy130;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy273;
			goto yy444;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy273;
			if (yych <= '9') goto yy130;
			goto yy273;
		} else {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy273;
			if (yych <= 'z') goto yy443;
			goto yy273;
		}
	}
yy322:
	YYDEBUG(322, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy443;
			goto yy491;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'n') goto yy491;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy323:
	YYDEBUG(323, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'B') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'C') goto yy490;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'c') goto yy492;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy324:
	YYDEBUG(324, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy273;
			goto yy130;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy273;
				goto yy103;
			} else {
				if (yych <= ',') goto yy273;
				if (yych <= '-') goto yy449;
				goto yy130;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy275;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy273;
			goto yy443;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy273;
				goto yy275;
			} else {
				if (yych <= '`') goto yy273;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy325:
	YYDEBUG(325, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy491;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'n') goto yy493;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy326:
	YYDEBUG(326, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy443;
			goto yy494;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 't') goto yy494;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy327:
	YYDEBUG(327, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy443;
			goto yy495;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'n') goto yy495;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy328:
	YYDEBUG(328, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
	} else {
		if (yych <= 'Z') goto yy443;
		if (yych <= '`') goto yy329;
		if (yych <= 'z') goto yy443;
	}
yy329:
	YYDEBUG(329, *YYCURSOR);
#line 1030 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("now");
		TIMELIB_INIT;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 8944 "lib/parse_date.c"
yy330:
	YYDEBUG(330, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy494;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 't') goto yy497;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy331:
	YYDEBUG(331, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy495;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'n') goto yy498;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy332:
	YYDEBUG(332, *YYCURSOR);
	yyaccept = 12;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy329;
		} else {
			if (yych == '.') goto yy329;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy329;
			if (yych <= 'Z') goto yy443;
			goto yy329;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy329;
			if (yych <= 'z') goto yy448;
			goto yy329;
		}
	}
yy333:
	YYDEBUG(333, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'O') goto yy499;
				goto yy443;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'o') goto yy499;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy334:
	YYDEBUG(334, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'N') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'O') goto yy499;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 'n') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 'o') goto yy500;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy335:
	YYDEBUG(335, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'V') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'U') goto yy443;
			goto yy501;
		}
	} else {
		if (yych <= 'u') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'v') goto yy501;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy336:
	YYDEBUG(336, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'V') goto yy501;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'u') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'v') goto yy502;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy337:
	YYDEBUG(337, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy293;
			goto yy103;
		} else {
			if (yych <= '@') goto yy293;
			if (yych <= 'T') goto yy443;
			goto yy503;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy293;
			goto yy443;
		} else {
			if (yych <= 'u') goto yy503;
			if (yych <= 'z') goto yy443;
			goto yy293;
		}
	}
yy338:
	YYDEBUG(338, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy443;
			goto yy504;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'o') goto yy504;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy339:
	YYDEBUG(339, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'T') goto yy505;
				goto yy443;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy273;
				goto yy443;
			} else {
				if (yych <= 't') goto yy505;
				if (yych <= 'z') goto yy443;
				goto yy273;
			}
		}
	}
yy340:
	YYDEBUG(340, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy443;
			goto yy506;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'e') goto yy506;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy341:
	YYDEBUG(341, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy293;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy293;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy503;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy293;
			goto yy275;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy293;
				goto yy448;
			} else {
				if (yych <= 'u') goto yy507;
				if (yych <= 'z') goto yy448;
				goto yy293;
			}
		}
	}
yy342:
	YYDEBUG(342, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy504;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'o') goto yy508;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy343:
	YYDEBUG(343, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'S') {
				if (yych <= '@') goto yy273;
				goto yy443;
			} else {
				if (yych <= 'T') goto yy505;
				if (yych <= 'Z') goto yy443;
				goto yy273;
			}
		} else {
			if (yych <= 's') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy448;
			} else {
				if (yych <= 't') goto yy509;
				if (yych <= 'z') goto yy448;
				goto yy273;
			}
		}
	}
yy344:
	YYDEBUG(344, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy506;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'e') goto yy510;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy345:
	YYDEBUG(345, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy67;
		goto yy53;
	} else {
		if (yych <= '5') goto yy511;
		if (yych == ':') goto yy67;
		goto yy53;
	}
yy346:
	YYDEBUG(346, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= '@') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych <= 'Q') goto yy443;
			if (yych <= 'R') goto yy512;
			goto yy494;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'r') goto yy512;
			if (yych <= 's') goto yy494;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy347:
	YYDEBUG(347, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy293;
			goto yy103;
		} else {
			if (yych <= '@') goto yy293;
			if (yych <= 'Q') goto yy443;
			goto yy513;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy293;
			goto yy443;
		} else {
			if (yych <= 'r') goto yy513;
			if (yych <= 'z') goto yy443;
			goto yy293;
		}
	}
yy348:
	YYDEBUG(348, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy514;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy443;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy514;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy349:
	YYDEBUG(349, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy443;
			goto yy515;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'o') goto yy515;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy350:
	YYDEBUG(350, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy293;
			goto yy103;
		} else {
			if (yych <= '@') goto yy293;
			if (yych <= 'R') goto yy443;
			goto yy516;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy293;
			goto yy443;
		} else {
			if (yych <= 's') goto yy516;
			if (yych <= 'z') goto yy443;
			goto yy293;
		}
	}
yy351:
	YYDEBUG(351, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy443;
			goto yy517;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'l') goto yy517;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy352:
	YYDEBUG(352, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych <= '/') {
				if (yych <= '.') goto yy16;
				goto yy275;
			} else {
				if (yych <= '@') goto yy16;
				if (yych <= 'Q') goto yy443;
				goto yy512;
			}
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') {
				if (yych <= 'S') goto yy494;
				goto yy443;
			} else {
				if (yych == '_') goto yy275;
				goto yy16;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy448;
				goto yy518;
			} else {
				if (yych <= 's') goto yy497;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy353:
	YYDEBUG(353, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy293;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy293;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy513;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy293;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy293;
				goto yy448;
			} else {
				if (yych <= 'r') goto yy519;
				if (yych <= 'z') goto yy448;
				goto yy293;
			}
		}
	}
yy354:
	YYDEBUG(354, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy514;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy520;
			if (yych <= 'z') goto yy448;
			goto yy16;
		}
	}
yy355:
	YYDEBUG(355, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy515;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'o') goto yy521;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy356:
	YYDEBUG(356, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy293;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy293;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy516;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy293;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy293;
				goto yy448;
			} else {
				if (yych <= 's') goto yy522;
				if (yych <= 'z') goto yy448;
				goto yy293;
			}
		}
	}
yy357:
	YYDEBUG(357, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy517;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'l') goto yy523;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy358:
	YYDEBUG(358, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy16;
			goto yy130;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy130;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy16;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'I') goto yy524;
				goto yy443;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy443;
				goto yy16;
			}
		}
	}
yy359:
	YYDEBUG(359, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy293;
			goto yy103;
		} else {
			if (yych <= '@') goto yy293;
			if (yych <= 'M') goto yy443;
			goto yy525;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy293;
			goto yy443;
		} else {
			if (yych <= 'n') goto yy525;
			if (yych <= 'z') goto yy443;
			goto yy293;
		}
	}
yy360:
	YYDEBUG(360, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'K') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'J') goto yy443;
			goto yy526;
		}
	} else {
		if (yych <= 'j') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 'k') goto yy526;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy361:
	YYDEBUG(361, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy293;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy293;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy525;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy293;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy293;
				goto yy448;
			} else {
				if (yych <= 'n') goto yy527;
				if (yych <= 'z') goto yy448;
				goto yy293;
			}
		}
	}
yy362:
	YYDEBUG(362, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'J') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'K') goto yy526;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'j') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 'k') goto yy528;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy363:
	YYDEBUG(363, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy443;
			goto yy529;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy443;
			if (yych <= '`') goto yy16;
			goto yy443;
		} else {
			if (yych <= 't') goto yy529;
			if (yych <= 'z') goto yy443;
			goto yy16;
		}
	}
yy364:
	YYDEBUG(364, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy443;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy529;
			if (yych <= 'Z') goto yy443;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy448;
			} else {
				if (yych <= 't') goto yy530;
				if (yych <= 'z') goto yy448;
				goto yy16;
			}
		}
	}
yy365:
	YYDEBUG(365, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy417;
	if (yych == 'c') goto yy417;
	goto yy53;
yy366:
	YYDEBUG(366, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy531;
				} else {
					if (yych == 'D') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy16;
				if (yych <= 'H') goto yy181;
				goto yy16;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy16;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy367:
	YYDEBUG(367, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy16;
					goto yy532;
				} else {
					if (yych == 'D') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy16;
				if (yych <= 'H') goto yy181;
				goto yy16;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy16;
				} else {
					if (yych == 'V') goto yy16;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy16;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy368:
	YYDEBUG(368, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy103;
	goto yy16;
yy369:
	YYDEBUG(369, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy532;
	goto yy181;
yy370:
	YYDEBUG(370, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy533;
	goto yy53;
yy371:
	YYDEBUG(371, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy534;
	goto yy53;
yy372:
	YYDEBUG(372, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy535;
	if (yych <= '3') goto yy537;
	if (yych <= '9') goto yy538;
	goto yy53;
yy373:
	YYDEBUG(373, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy418;
	if (yych == 'p') goto yy418;
	goto yy53;
yy374:
	YYDEBUG(374, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy539;
	if (yych <= '6') goto yy540;
	if (yych <= '9') goto yy541;
	goto yy53;
yy375:
	YYDEBUG(375, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy542;
	if (yych <= '6') goto yy543;
	if (yych <= '9') goto yy544;
	goto yy53;
yy376:
	YYDEBUG(376, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy545;
	goto yy53;
yy377:
	YYDEBUG(377, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy546;
	goto yy53;
yy378:
	YYDEBUG(378, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy546;
	goto yy53;
yy379:
	YYDEBUG(379, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy546;
	goto yy53;
yy380:
	YYDEBUG(380, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy547;
	if (yych == 'r') goto yy547;
	goto yy53;
yy381:
	YYDEBUG(381, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy547;
	if (yych == 'g') goto yy547;
	goto yy53;
yy382:
	YYDEBUG(382, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy547;
	if (yych == 'c') goto yy547;
	goto yy53;
yy383:
	YYDEBUG(383, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy547;
	if (yych == 'b') goto yy547;
	goto yy53;
yy384:
	YYDEBUG(384, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy547;
	if (yych == 'n') goto yy547;
	goto yy53;
yy385:
	YYDEBUG(385, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy547;
		if (yych <= 'M') goto yy53;
		goto yy547;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy547;
		} else {
			if (yych == 'n') goto yy547;
			goto yy53;
		}
	}
yy386:
	YYDEBUG(386, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy547;
		if (yych <= 'X') goto yy53;
		goto yy547;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy547;
		} else {
			if (yych == 'y') goto yy547;
			goto yy53;
		}
	}
yy387:
	YYDEBUG(387, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy547;
	if (yych == 'v') goto yy547;
	goto yy53;
yy388:
	YYDEBUG(388, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy547;
	if (yych == 't') goto yy547;
	goto yy53;
yy389:
	YYDEBUG(389, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy548;
	if (yych == 'p') goto yy548;
	goto yy53;
yy390:
	YYDEBUG(390, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy372;
		goto yy370;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '9') goto yy549;
		goto yy53;
	}
yy391:
	YYDEBUG(391, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') {
		if (yych <= ',') goto yy53;
		if (yych <= '-') goto yy372;
		goto yy370;
	} else {
		if (yych <= '/') goto yy53;
		if (yych <= '2') goto yy549;
		goto yy53;
	}
yy392:
	YYDEBUG(392, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy550;
		case '1': goto yy551;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy433;
		case 'A':
		case 'a': goto yy434;
		case 'D':
		case 'd': goto yy435;
		case 'F':
		case 'f': goto yy436;
		case 'J':
		case 'j': goto yy437;
		case 'M':
		case 'm': goto yy438;
		case 'N':
		case 'n': goto yy439;
		case 'O':
		case 'o': goto yy440;
		case 'S':
		case 's': goto yy441;
		default: goto yy53;
	}
yy393:
	YYDEBUG(393, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy553;
				} else {
					if (yych <= ' ') goto yy553;
					if (yych >= '-') goto yy554;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy555;
					if (yych <= '/') goto yy556;
					goto yy557;
				} else {
					if (yych <= '1') goto yy558;
					if (yych <= '2') goto yy559;
					goto yy560;
				}
			}
		} else {
			if (yych <= 'A') {
				if (yych <= '9') {
					if (yych <= '5') goto yy561;
					if (yych <= '6') goto yy562;
					goto yy54;
				} else {
					if (yych <= ':') goto yy563;
					if (yych >= 'A') goto yy553;
				}
			} else {
				if (yych <= 'E') {
					if (yych == 'D') goto yy553;
				} else {
					if (yych == 'G') goto yy394;
					if (yych <= 'J') goto yy553;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= '`') {
				if (yych <= 'V') {
					if (yych <= 'O') goto yy553;
					if (yych >= 'S') goto yy553;
				} else {
					if (yych <= 'W') goto yy575;
					if (yych <= 'Y') goto yy553;
				}
			} else {
				if (yych <= 'd') {
					if (yych <= 'a') goto yy553;
					if (yych >= 'd') goto yy553;
				} else {
					if (yych == 'f') goto yy553;
					if (yych >= 'h') goto yy553;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy553;
				} else {
					if (yych <= 'o') goto yy553;
					if (yych >= 's') goto yy553;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy553;
				} else {
					if (yych <= 'y') goto yy553;
					if (yych == 0xC2) goto yy553;
				}
			}
		}
	}
yy394:
	YYDEBUG(394, *YYCURSOR);
#line 1252 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("gnunocolon");
		TIMELIB_INIT;
		switch (s->time->have_time) {
			case 0:
				s->time->h = timelib_get_nr((char **) &ptr, 2);
				s->time->i = timelib_get_nr((char **) &ptr, 2);
				s->time->s = 0;
				break;
			case 1:
				s->time->y = timelib_get_nr((char **) &ptr, 4);
				break;
			default:
				TIMELIB_DEINIT;
				add_error(s, TIMELIB_ERR_DOUBLE_TIME, "Double time specification");
				return TIMELIB_ERROR;
		}
		s->time->have_time++;
		TIMELIB_DEINIT;
		return TIMELIB_GNU_NOCOLON;
	}
#line 10408 "lib/parse_date.c"
yy395:
	YYDEBUG(395, *YYCURSOR);
	yyaccept = 14;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych <= '3') {
			if (yych <= '-') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy553;
				} else {
					if (yych <= ' ') goto yy553;
					if (yych >= '-') goto yy554;
				}
			} else {
				if (yych <= '0') {
					if (yych <= '.') goto yy555;
					if (yych <= '/') goto yy556;
					goto yy577;
				} else {
					if (yych <= '1') goto yy578;
					if (yych <= '2') goto yy579;
					goto yy580;
				}
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '@') {
					if (yych <= '9') goto yy54;
					if (yych <= ':') goto yy563;
				} else {
					if (yych <= 'A') goto yy553;
					if (yych >= 'D') goto yy553;
				}
			} else {
				if (yych <= 'G') {
					if (yych == 'F') goto yy553;
				} else {
					if (yych <= 'J') goto yy553;
					if (yych >= 'M') goto yy553;
				}
			}
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'a') {
				if (yych <= 'W') {
					if (yych <= 'R') goto yy396;
					if (yych <= 'V') goto yy553;
					goto yy575;
				} else {
					if (yych <= 'Y') goto yy553;
					if (yych >= 'a') goto yy553;
				}
			} else {
				if (yych <= 'e') {
					if (yych == 'd') goto yy553;
				} else {
					if (yych != 'g') goto yy553;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'l') {
					if (yych == 'j') goto yy553;
				} else {
					if (yych <= 'o') goto yy553;
					if (yych >= 's') goto yy553;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy553;
				} else {
					if (yych <= 'y') goto yy553;
					if (yych == 0xC2) goto yy553;
				}
			}
		}
	}
yy396:
	YYDEBUG(396, *YYCURSOR);
#line 1634 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("year4");
		TIMELIB_INIT;
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 10497 "lib/parse_date.c"
yy397:
	YYDEBUG(397, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'H') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'I') goto yy581;
			if (yych == 'i') goto yy581;
			goto yy73;
		}
	}
yy398:
	YYDEBUG(398, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'U') goto yy582;
			if (yych == 'u') goto yy582;
			goto yy73;
		}
	}
yy399:
	YYDEBUG(399, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy583;
	if (yych == 's') goto yy583;
	goto yy243;
yy400:
	YYDEBUG(400, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'E') goto yy584;
			if (yych == 'e') goto yy584;
			goto yy73;
		}
	}
yy401:
	YYDEBUG(401, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'Q') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'R') goto yy585;
			if (yych == 'r') goto yy585;
			goto yy73;
		}
	}
yy402:
	YYDEBUG(402, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy586;
	if (yych == 't') goto yy586;
	goto yy53;
yy403:
	YYDEBUG(403, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'D') goto yy587;
	if (yych == 'd') goto yy587;
	goto yy243;
yy404:
	YYDEBUG(404, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy399;
	if (yych == 'r') goto yy399;
	goto yy53;
yy405:
	YYDEBUG(405, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy234;
	if (yych <= '9') goto yy588;
	goto yy234;
yy406:
	YYDEBUG(406, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'T') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'U') goto yy589;
			if (yych == 'u') goto yy589;
			goto yy73;
		}
	}
yy407:
	YYDEBUG(407, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'X') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'Y') goto yy236;
			if (yych == 'y') goto yy236;
			goto yy73;
		}
	}
yy408:
	YYDEBUG(408, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'D') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'E') goto yy236;
			if (yych == 'e') goto yy236;
			goto yy73;
		}
	}
yy409:
	YYDEBUG(409, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'B') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'C') goto yy590;
			if (yych == 'c') goto yy590;
			goto yy73;
		}
	}
yy410:
	YYDEBUG(410, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy591;
	if (yych == 'r') goto yy591;
	goto yy53;
yy411:
	YYDEBUG(411, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy592;
	if (yych == 'l') goto yy592;
	goto yy53;
yy412:
	YYDEBUG(412, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy583;
		if (yych <= 'T') goto yy243;
		goto yy593;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy243;
			goto yy583;
		} else {
			if (yych == 'u') goto yy593;
			goto yy243;
		}
	}
yy413:
	YYDEBUG(413, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == 'D') goto yy587;
		if (yych <= 'S') goto yy243;
		goto yy594;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy243;
			goto yy587;
		} else {
			if (yych == 't') goto yy594;
			goto yy243;
		}
	}
yy414:
	YYDEBUG(414, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy399;
	if (yych == 'c') goto yy399;
	goto yy53;
yy415:
	YYDEBUG(415, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'N') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'O') goto yy595;
			if (yych == 'o') goto yy595;
			goto yy73;
		}
	}
yy416:
	YYDEBUG(416, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy596;
	if (yych == 'u') goto yy596;
	goto yy243;
yy417:
	YYDEBUG(417, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy597;
		if (yych <= 'R') goto yy243;
		goto yy583;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy243;
			goto yy597;
		} else {
			if (yych == 's') goto yy583;
			goto yy243;
		}
	}
yy418:
	YYDEBUG(418, *YYCURSOR);
	yyaccept = 3;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy232;
			goto yy73;
		} else {
			if (yych <= ' ') goto yy232;
			if (yych <= ',') goto yy73;
			goto yy232;
		}
	} else {
		if (yych <= 'S') {
			if (yych <= '/') goto yy73;
			if (yych <= '9') goto yy233;
			goto yy73;
		} else {
			if (yych <= 'T') goto yy400;
			if (yych == 't') goto yy400;
			goto yy73;
		}
	}
yy419:
	YYDEBUG(419, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy598;
	if (yych == 'r') goto yy598;
	goto yy243;
yy420:
	YYDEBUG(420, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'S') goto yy599;
	if (yych == 's') goto yy599;
	goto yy243;
yy421:
	YYDEBUG(421, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'N') goto yy600;
	if (yych == 'n') goto yy600;
	goto yy243;
yy422:
	YYDEBUG(422, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy601;
	if (yych == 'k') goto yy601;
	goto yy53;
yy423:
	YYDEBUG(423, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy191;
	if (yych <= '0') goto yy602;
	if (yych <= '1') goto yy603;
	if (yych <= '9') goto yy604;
	goto yy191;
yy424:
	YYDEBUG(424, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy605;
	if (yych <= '6') goto yy606;
	if (yych <= '9') goto yy541;
	goto yy53;
yy425:
	YYDEBUG(425, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy607;
			if (yych <= 0x1F) goto yy203;
			goto yy607;
		} else {
			if (yych <= '-') {
				if (yych <= ',') goto yy203;
				goto yy370;
			} else {
				if (yych <= '.') goto yy424;
				if (yych <= '9') goto yy203;
			}
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy97;
			if (yych <= 'O') goto yy203;
			goto yy97;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy203;
				goto yy97;
			} else {
				if (yych == 'p') goto yy97;
				goto yy203;
			}
		}
	}
yy426:
	YYDEBUG(426, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy608;
	if (yych <= '6') goto yy609;
	if (yych <= '9') goto yy544;
	goto yy53;
yy427:
	YYDEBUG(427, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy607;
			if (yych <= 0x1F) goto yy203;
			goto yy607;
		} else {
			if (yych == '.') goto yy426;
			if (yych <= '9') goto yy203;
			goto yy426;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy97;
			if (yych <= 'O') goto yy203;
			goto yy97;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy203;
				goto yy97;
			} else {
				if (yych == 'p') goto yy97;
				goto yy203;
			}
		}
	}
yy428:
	YYDEBUG(428, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy607;
			if (yych <= 0x1F) goto yy203;
			goto yy607;
		} else {
			if (yych == '.') goto yy426;
			if (yych <= '9') goto yy203;
			goto yy610;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy97;
			if (yych <= 'O') goto yy203;
			goto yy97;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy203;
				goto yy97;
			} else {
				if (yych == 'p') goto yy97;
				goto yy203;
			}
		}
	}
yy429:
	YYDEBUG(429, *YYCURSOR);
	++YYCURSOR;
#line 1189 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("timetiny12 | timeshort12 | timelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->i = timelib_get_nr((char **) &ptr, 2);
			if (*ptr == ':' || *ptr == '.') {
				s->time->s = timelib_get_nr((char **) &ptr, 2);
			}
		}
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME12;
	}
#line 11006 "lib/parse_date.c"
yy430:
	YYDEBUG(430, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy429;
		if (yych <= 0x08) goto yy53;
		goto yy429;
	} else {
		if (yych == ' ') goto yy429;
		goto yy53;
	}
yy431:
	YYDEBUG(431, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy611;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy612;
	goto yy53;
yy432:
	YYDEBUG(432, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy611;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy612;
	goto yy53;
yy433:
	YYDEBUG(433, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy611;
	goto yy53;
yy434:
	YYDEBUG(434, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy613;
		if (yych <= 'T') goto yy53;
		goto yy614;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy613;
		} else {
			if (yych == 'u') goto yy614;
			goto yy53;
		}
	}
yy435:
	YYDEBUG(435, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy615;
	if (yych == 'e') goto yy615;
	goto yy53;
yy436:
	YYDEBUG(436, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy616;
	if (yych == 'e') goto yy616;
	goto yy53;
yy437:
	YYDEBUG(437, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy617;
		if (yych <= 'T') goto yy53;
		goto yy618;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy617;
		} else {
			if (yych == 'u') goto yy618;
			goto yy53;
		}
	}
yy438:
	YYDEBUG(438, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy619;
	if (yych == 'a') goto yy619;
	goto yy53;
yy439:
	YYDEBUG(439, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy620;
	if (yych == 'o') goto yy620;
	goto yy53;
yy440:
	YYDEBUG(440, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy621;
	if (yych == 'c') goto yy621;
	goto yy53;
yy441:
	YYDEBUG(441, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy622;
	if (yych == 'e') goto yy622;
	goto yy53;
yy442:
	YYDEBUG(442, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy623;
	goto yy53;
yy443:
	YYDEBUG(443, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy624;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy624;
		goto yy16;
	}
yy444:
	YYDEBUG(444, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy130;
	if (yych <= '2') goto yy625;
	if (yych <= '3') goto yy626;
	goto yy130;
yy445:
	YYDEBUG(445, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'K') goto yy624;
			goto yy627;
		}
	} else {
		if (yych <= 'k') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'l') goto yy627;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy446:
	YYDEBUG(446, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy624;
			goto yy628;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 's') goto yy628;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy447:
	YYDEBUG(447, *YYCURSOR);
	yyaccept = 2;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy447;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy275;
		goto yy16;
	} else {
		if (yych <= '/') goto yy275;
		if (yych == '_') goto yy275;
		goto yy16;
	}
yy448:
	YYDEBUG(448, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy624;
			goto yy16;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy629;
			goto yy16;
		}
	}
yy449:
	YYDEBUG(449, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy447;
	}
	if (yych <= '/') goto yy130;
	if (yych <= '2') goto yy625;
	if (yych <= '3') goto yy626;
	goto yy130;
yy450:
	YYDEBUG(450, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'K') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'L') goto yy627;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'k') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'l') goto yy630;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy451:
	YYDEBUG(451, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy628;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 's') goto yy631;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy452:
	YYDEBUG(452, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy632;
		if (yych <= '(') goto yy16;
		goto yy103;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			goto yy624;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy453:
	YYDEBUG(453, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy632;
			goto yy16;
		} else {
			if (yych <= ')') goto yy103;
			if (yych == '-') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy275;
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy624;
			goto yy16;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy629;
			goto yy16;
		}
	}
yy454:
	YYDEBUG(454, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy624;
			goto yy633;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'm') goto yy633;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy455:
	YYDEBUG(455, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy633;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'm') goto yy634;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy456:
	YYDEBUG(456, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy624;
			goto yy635;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 't') goto yy635;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy457:
	YYDEBUG(457, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy624;
			goto yy636;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'e') goto yy636;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy458:
	YYDEBUG(458, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy635;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 't') goto yy637;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy459:
	YYDEBUG(459, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy636;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'e') goto yy638;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy460:
	YYDEBUG(460, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'T') goto yy624;
			goto yy639;
		}
	} else {
		if (yych <= 't') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'u') goto yy639;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy461:
	YYDEBUG(461, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy624;
			goto yy640;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'h') goto yy640;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy462:
	YYDEBUG(462, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy624;
			goto yy641;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 't') goto yy641;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy463:
	YYDEBUG(463, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy624;
			goto yy642;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 't') goto yy642;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy464:
	YYDEBUG(464, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy643;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy624;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy643;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy465:
	YYDEBUG(465, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy624;
			goto yy644;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 't') goto yy644;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy466:
	YYDEBUG(466, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'U') goto yy639;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 't') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'u') goto yy645;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy467:
	YYDEBUG(467, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy640;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'h') goto yy646;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy468:
	YYDEBUG(468, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy641;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 't') goto yy647;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy469:
	YYDEBUG(469, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy642;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 't') goto yy648;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy470:
	YYDEBUG(470, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy643;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy649;
			if (yych <= 'z') goto yy629;
			goto yy16;
		}
	}
yy471:
	YYDEBUG(471, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy644;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 't') goto yy650;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy472:
	YYDEBUG(472, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy651;
	if (yych <= '2') goto yy652;
	if (yych <= '9') goto yy653;
	goto yy53;
yy473:
	YYDEBUG(473, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy654;
		goto yy53;
	} else {
		if (yych <= '0') goto yy655;
		if (yych <= '9') goto yy476;
		if (yych <= ':') goto yy654;
		goto yy53;
	}
yy474:
	YYDEBUG(474, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy656;
		goto yy53;
	} else {
		if (yych <= '2') goto yy476;
		if (yych <= '9') goto yy655;
		if (yych <= ':') goto yy656;
		goto yy53;
	}
yy475:
	YYDEBUG(475, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy656;
		goto yy53;
	} else {
		if (yych <= '4') goto yy655;
		if (yych == ':') goto yy656;
		goto yy53;
	}
yy476:
	YYDEBUG(476, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy656;
	if (yych == ':') goto yy656;
	goto yy53;
yy477:
	YYDEBUG(477, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy657;
	if (yych <= '2') goto yy658;
	if (yych <= '9') goto yy655;
	goto yy53;
yy478:
	YYDEBUG(478, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy654;
		goto yy303;
	} else {
		if (yych <= '0') goto yy659;
		if (yych <= '9') goto yy660;
		if (yych <= ':') goto yy654;
		goto yy303;
	}
yy479:
	YYDEBUG(479, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy656;
		goto yy303;
	} else {
		if (yych <= '2') goto yy660;
		if (yych <= '9') goto yy659;
		if (yych <= ':') goto yy656;
		goto yy303;
	}
yy480:
	YYDEBUG(480, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy656;
		goto yy303;
	} else {
		if (yych <= '4') goto yy659;
		if (yych <= '9') goto yy661;
		if (yych <= ':') goto yy656;
		goto yy303;
	}
yy481:
	YYDEBUG(481, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy656;
		goto yy303;
	} else {
		if (yych <= '9') goto yy661;
		if (yych <= ':') goto yy656;
		goto yy303;
	}
yy482:
	YYDEBUG(482, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy662;
	goto yy53;
yy483:
	YYDEBUG(483, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x00) goto yy302;
	goto yy305;
yy484:
	YYDEBUG(484, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy663;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy624;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy663;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy485:
	YYDEBUG(485, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy273;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy103;
			goto yy273;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy273;
			if (yych <= '9') goto yy130;
			goto yy273;
		} else {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy273;
			if (yych <= 'z') goto yy624;
			goto yy273;
		}
	}
yy486:
	YYDEBUG(486, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy663;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy664;
			if (yych <= 'z') goto yy629;
			goto yy16;
		}
	}
yy487:
	YYDEBUG(487, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy273;
			goto yy130;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy273;
				goto yy103;
			} else {
				if (yych <= ',') goto yy273;
				if (yych <= '-') goto yy665;
				goto yy130;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy275;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy273;
			goto yy624;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy273;
				goto yy275;
			} else {
				if (yych <= '`') goto yy273;
				if (yych <= 'z') goto yy629;
				goto yy273;
			}
		}
	}
yy488:
	YYDEBUG(488, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy16;
			goto yy666;
		} else {
			if (yych == ' ') goto yy668;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy624;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy489:
	YYDEBUG(489, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy666;
			if (yych <= 0x1F) goto yy16;
			goto yy668;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy275;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy490:
	YYDEBUG(490, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy624;
			goto yy627;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'h') goto yy627;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy491:
	YYDEBUG(491, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy624;
			goto yy669;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'i') goto yy669;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy492:
	YYDEBUG(492, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy627;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'h') goto yy630;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy493:
	YYDEBUG(493, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy669;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'i') goto yy670;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy494:
	YYDEBUG(494, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy16;
			goto yy666;
		} else {
			if (yych == ' ') goto yy666;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy624;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy495:
	YYDEBUG(495, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
	} else {
		if (yych <= 'Z') goto yy624;
		if (yych <= '`') goto yy496;
		if (yych <= 'z') goto yy624;
	}
yy496:
	YYDEBUG(496, *YYCURSOR);
#line 1039 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("noon");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();
		s->time->h = 12;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 12239 "lib/parse_date.c"
yy497:
	YYDEBUG(497, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy666;
			if (yych <= 0x1F) goto yy16;
			goto yy666;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy275;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy498:
	YYDEBUG(498, *YYCURSOR);
	yyaccept = 15;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy496;
		} else {
			if (yych == '.') goto yy496;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy496;
			if (yych <= 'Z') goto yy624;
			goto yy496;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy496;
			if (yych <= 'z') goto yy629;
			goto yy496;
		}
	}
yy499:
	YYDEBUG(499, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy624;
			goto yy671;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'b') goto yy671;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy500:
	YYDEBUG(500, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy671;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'b') goto yy672;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy501:
	YYDEBUG(501, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'I') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'H') goto yy624;
			goto yy673;
		}
	} else {
		if (yych <= 'h') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'i') goto yy673;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy502:
	YYDEBUG(502, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'I') goto yy673;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'h') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'i') goto yy674;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy503:
	YYDEBUG(503, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy624;
			goto yy675;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'r') goto yy675;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy504:
	YYDEBUG(504, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy624;
			goto yy676;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'n') goto yy676;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy505:
	YYDEBUG(505, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy273;
			} else {
				if (yych <= '-') goto yy444;
				if (yych <= '.') goto yy130;
				goto yy273;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') {
				if (yych <= '9') goto yy130;
				goto yy273;
			} else {
				if (yych == 'E') goto yy677;
				goto yy624;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy273;
				goto yy624;
			} else {
				if (yych <= 'e') goto yy677;
				if (yych <= 'z') goto yy624;
				goto yy273;
			}
		}
	}
yy506:
	YYDEBUG(506, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy624;
			goto yy678;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'n') goto yy678;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy507:
	YYDEBUG(507, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy675;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'r') goto yy679;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy508:
	YYDEBUG(508, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy676;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'n') goto yy680;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy509:
	YYDEBUG(509, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy273;
				goto yy130;
			} else {
				if (yych == ' ') goto yy130;
				goto yy273;
			}
		} else {
			if (yych <= '-') {
				if (yych <= ')') goto yy103;
				if (yych <= ',') goto yy273;
				goto yy449;
			} else {
				if (yych == '/') goto yy275;
				goto yy130;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'D') {
				if (yych <= '@') goto yy273;
				goto yy624;
			} else {
				if (yych <= 'E') goto yy677;
				if (yych <= 'Z') goto yy624;
				goto yy273;
			}
		} else {
			if (yych <= 'd') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy273;
				goto yy629;
			} else {
				if (yych <= 'e') goto yy681;
				if (yych <= 'z') goto yy629;
				goto yy273;
			}
		}
	}
yy510:
	YYDEBUG(510, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy678;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'n') goto yy682;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy511:
	YYDEBUG(511, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy683;
	goto yy53;
yy512:
	YYDEBUG(512, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy624;
			goto yy640;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'd') goto yy640;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy513:
	YYDEBUG(513, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy624;
			goto yy675;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 's') goto yy675;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy514:
	YYDEBUG(514, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy624;
			goto yy684;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'y') goto yy684;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy515:
	YYDEBUG(515, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy624;
			goto yy686;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'r') goto yy686;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy516:
	YYDEBUG(516, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy624;
			goto yy687;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'd') goto yy687;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy517:
	YYDEBUG(517, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'F') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'E') goto yy624;
			goto yy678;
		}
	} else {
		if (yych <= 'e') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'f') goto yy678;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy518:
	YYDEBUG(518, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy640;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'd') goto yy646;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy519:
	YYDEBUG(519, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy675;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 's') goto yy679;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy520:
	YYDEBUG(520, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy684;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'y') goto yy688;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy521:
	YYDEBUG(521, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy686;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'r') goto yy689;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy522:
	YYDEBUG(522, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy687;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'd') goto yy690;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy523:
	YYDEBUG(523, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'E') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'F') goto yy678;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'e') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'f') goto yy682;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy524:
	YYDEBUG(524, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy103;
			goto yy16;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy16;
			if (yych <= '9') goto yy130;
			goto yy16;
		} else {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy525:
	YYDEBUG(525, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy624;
			goto yy691;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'e') goto yy691;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy526:
	YYDEBUG(526, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy624;
			goto yy692;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'd') goto yy692;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy527:
	YYDEBUG(527, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy691;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'e') goto yy693;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy528:
	YYDEBUG(528, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy692;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'd') goto yy694;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy529:
	YYDEBUG(529, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy624;
			goto yy695;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy624;
			if (yych <= '`') goto yy16;
			goto yy624;
		} else {
			if (yych <= 'e') goto yy695;
			if (yych <= 'z') goto yy624;
			goto yy16;
		}
	}
yy530:
	YYDEBUG(530, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy624;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy695;
			if (yych <= 'Z') goto yy624;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy629;
			} else {
				if (yych <= 'e') goto yy696;
				if (yych <= 'z') goto yy629;
				goto yy16;
			}
		}
	}
yy531:
	YYDEBUG(531, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy16;
				goto yy181;
			} else {
				if (yych <= '-') {
					if (yych <= ',') goto yy16;
					goto yy697;
				} else {
					if (yych <= '/') goto yy16;
					if (yych <= '9') goto yy698;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy181;
					goto yy16;
				} else {
					if (yych == 'G') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy16;
					goto yy181;
				} else {
					if (yych <= 'R') goto yy16;
					if (yych <= 'U') goto yy181;
					goto yy16;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy181;
					goto yy16;
				} else {
					if (yych <= 'Y') goto yy181;
					if (yych <= 'c') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy16;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy16;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy16;
				} else {
					if (yych == 'v') goto yy16;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy16;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy16;
				}
			}
		}
	}
yy532:
	YYDEBUG(532, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy697;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy698;
	goto yy181;
yy533:
	YYDEBUG(533, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy699;
	goto yy53;
yy534:
	YYDEBUG(534, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy700;
	goto yy53;
yy535:
	YYDEBUG(535, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '9') goto yy702;
		if (yych >= 'n') goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
		}
	}
yy536:
	YYDEBUG(536, *YYCURSOR);
#line 1386 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 13299 "lib/parse_date.c"
yy537:
	YYDEBUG(537, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy536;
			goto yy702;
		} else {
			if (yych <= '9') goto yy699;
			if (yych <= 'm') goto yy536;
			goto yy703;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy538:
	YYDEBUG(538, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '9') goto yy699;
		if (yych <= 'm') goto yy536;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy539:
	YYDEBUG(539, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy707;
	goto yy203;
yy540:
	YYDEBUG(540, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy706;
		goto yy203;
	} else {
		if (yych <= '0') goto yy707;
		if (yych <= '9') goto yy700;
		goto yy203;
	}
yy541:
	YYDEBUG(541, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy700;
	goto yy203;
yy542:
	YYDEBUG(542, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy544;
	goto yy203;
yy543:
	YYDEBUG(543, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych != '0') goto yy203;
yy544:
	YYDEBUG(544, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	goto yy203;
yy545:
	YYDEBUG(545, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy208;
	if (yych <= '9') goto yy708;
	goto yy208;
yy546:
	YYDEBUG(546, *YYCURSOR);
	yyaccept = 6;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '/') goto yy376;
	goto yy208;
yy547:
	YYDEBUG(547, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy709;
	goto yy53;
yy548:
	YYDEBUG(548, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '/') goto yy709;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy547;
		if (yych == 't') goto yy547;
		goto yy53;
	}
yy549:
	YYDEBUG(549, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '-') goto yy710;
	if (yych <= '.') goto yy370;
	goto yy53;
yy550:
	YYDEBUG(550, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy611;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy433;
	goto yy53;
yy551:
	YYDEBUG(551, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy611;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy433;
	goto yy53;
yy552:
	YYDEBUG(552, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy553:
	YYDEBUG(553, *YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'G') {
			if (yych <= '.') {
				if (yych <= 0x1F) {
					if (yych == '\t') goto yy552;
					goto yy53;
				} else {
					if (yych <= ' ') goto yy552;
					if (yych <= ',') goto yy53;
					goto yy711;
				}
			} else {
				if (yych <= 'C') {
					if (yych == 'A') goto yy564;
					goto yy53;
				} else {
					if (yych <= 'D') goto yy565;
					if (yych == 'F') goto yy566;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'J') {
					if (yych <= 'H') goto yy71;
					if (yych <= 'I') goto yy567;
					goto yy569;
				} else {
					if (yych <= 'L') goto yy53;
					if (yych <= 'M') goto yy570;
					goto yy571;
				}
			} else {
				if (yych <= 'S') {
					if (yych <= 'O') goto yy572;
					if (yych <= 'R') goto yy53;
					goto yy573;
				} else {
					if (yych <= 'T') goto yy79;
					if (yych <= 'U') goto yy80;
					if (yych <= 'V') goto yy574;
					goto yy82;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= '`') {
					if (yych <= 'X') goto yy576;
					if (yych <= 'Y') goto yy84;
					goto yy53;
				} else {
					if (yych <= 'a') goto yy564;
					if (yych <= 'c') goto yy53;
					goto yy565;
				}
			} else {
				if (yych <= 'g') {
					if (yych == 'f') goto yy566;
					goto yy53;
				} else {
					if (yych <= 'h') goto yy71;
					if (yych == 'j') goto yy569;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'u') {
				if (yych <= 'o') {
					if (yych <= 'm') goto yy570;
					if (yych <= 'n') goto yy571;
					goto yy572;
				} else {
					if (yych <= 'r') goto yy53;
					if (yych <= 's') goto yy573;
					if (yych <= 't') goto yy79;
					goto yy80;
				}
			} else {
				if (yych <= 'x') {
					if (yych == 'w') goto yy82;
					goto yy53;
				} else {
					if (yych <= 'y') goto yy84;
					if (yych == 0xC2) goto yy89;
					goto yy53;
				}
			}
		}
	}
yy554:
	YYDEBUG(554, *YYCURSOR);
	yych = *++YYCURSOR;
	switch (yych) {
		case '0': goto yy713;
		case '1': goto yy715;
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy716;
		case 'A':
		case 'a': goto yy717;
		case 'D':
		case 'd': goto yy718;
		case 'F':
		case 'f': goto yy719;
		case 'J':
		case 'j': goto yy720;
		case 'M':
		case 'm': goto yy721;
		case 'N':
		case 'n': goto yy722;
		case 'O':
		case 'o': goto yy723;
		case 'S':
		case 's': goto yy724;
		case 'W': goto yy725;
		default: goto yy712;
	}
yy555:
	YYDEBUG(555, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy712;
	if (yych <= '0') goto yy726;
	if (yych <= '2') goto yy727;
	if (yych <= '3') goto yy728;
	goto yy712;
yy556:
	YYDEBUG(556, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy733;
	if (yych <= '1') goto yy734;
	if (yych <= '9') goto yy735;
	goto yy53;
yy557:
	YYDEBUG(557, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '0') goto yy736;
	if (yych <= '9') goto yy738;
	goto yy181;
yy558:
	YYDEBUG(558, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '2') goto yy738;
	if (yych <= '9') goto yy739;
	goto yy181;
yy559:
	YYDEBUG(559, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy739;
	goto yy181;
yy560:
	YYDEBUG(560, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '5') goto yy739;
	if (yych <= '6') goto yy740;
	if (yych <= '9') goto yy741;
	goto yy181;
yy561:
	YYDEBUG(561, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy741;
	goto yy181;
yy562:
	YYDEBUG(562, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '0') goto yy741;
	if (yych <= '9') goto yy54;
	goto yy181;
yy563:
	YYDEBUG(563, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy742;
	if (yych <= '1') goto yy743;
	goto yy53;
yy564:
	YYDEBUG(564, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy744;
		if (yych <= 'T') goto yy53;
		goto yy745;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy744;
		} else {
			if (yych == 'u') goto yy745;
			goto yy53;
		}
	}
yy565:
	YYDEBUG(565, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych == 'A') goto yy226;
		if (yych <= 'D') goto yy53;
		goto yy746;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy226;
		} else {
			if (yych == 'e') goto yy746;
			goto yy53;
		}
	}
yy566:
	YYDEBUG(566, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= 'N') {
			if (yych == 'E') goto yy747;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy229;
			if (yych <= 'Q') goto yy53;
			goto yy230;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'e') goto yy747;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy229;
			if (yych == 'r') goto yy230;
			goto yy53;
		}
	}
yy567:
	YYDEBUG(567, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'I') goto yy748;
	} else {
		if (yych == 'W') goto yy568;
		if (yych <= 'X') goto yy749;
	}
yy568:
	YYDEBUG(568, *YYCURSOR);
#line 1455 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenodayrev");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 13712 "lib/parse_date.c"
yy569:
	YYDEBUG(569, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy750;
		if (yych <= 'T') goto yy53;
		goto yy751;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy750;
		} else {
			if (yych == 'u') goto yy751;
			goto yy53;
		}
	}
yy570:
	YYDEBUG(570, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'I') {
			if (yych == 'A') goto yy752;
			if (yych <= 'H') goto yy53;
			goto yy240;
		} else {
			if (yych == 'O') goto yy241;
			if (yych <= 'R') goto yy53;
			goto yy242;
		}
	} else {
		if (yych <= 'i') {
			if (yych == 'a') goto yy752;
			if (yych <= 'h') goto yy53;
			goto yy240;
		} else {
			if (yych <= 'o') {
				if (yych <= 'n') goto yy53;
				goto yy241;
			} else {
				if (yych == 's') goto yy242;
				goto yy53;
			}
		}
	}
yy571:
	YYDEBUG(571, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy753;
	if (yych == 'o') goto yy753;
	goto yy53;
yy572:
	YYDEBUG(572, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy754;
	if (yych == 'c') goto yy754;
	goto yy53;
yy573:
	YYDEBUG(573, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy755;
			if (yych <= 'T') goto yy53;
			goto yy248;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy246;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy755;
			if (yych == 'u') goto yy248;
			goto yy53;
		}
	}
yy574:
	YYDEBUG(574, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy576;
	goto yy568;
yy575:
	YYDEBUG(575, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '0') goto yy756;
		if (yych <= '4') goto yy757;
		goto yy758;
	} else {
		if (yych <= 'E') {
			if (yych <= 'D') goto yy53;
			goto yy252;
		} else {
			if (yych == 'e') goto yy252;
			goto yy53;
		}
	}
yy576:
	YYDEBUG(576, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy748;
	goto yy568;
yy577:
	YYDEBUG(577, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '0') goto yy759;
	if (yych <= '9') goto yy760;
	goto yy181;
yy578:
	YYDEBUG(578, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '2') goto yy760;
	if (yych <= '9') goto yy761;
	goto yy181;
yy579:
	YYDEBUG(579, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy761;
	goto yy181;
yy580:
	YYDEBUG(580, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '5') goto yy761;
	if (yych <= '6') goto yy762;
	if (yych <= '9') goto yy54;
	goto yy181;
yy581:
	YYDEBUG(581, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy236;
	if (yych == 'l') goto yy236;
	goto yy53;
yy582:
	YYDEBUG(582, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy763;
	if (yych == 's') goto yy763;
	goto yy53;
yy583:
	YYDEBUG(583, *YYCURSOR);
	++YYCURSOR;
	goto yy243;
yy584:
	YYDEBUG(584, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy595;
	if (yych == 'm') goto yy595;
	goto yy53;
yy585:
	YYDEBUG(585, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy589;
	if (yych == 'u') goto yy589;
	goto yy53;
yy586:
	YYDEBUG(586, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy764;
		if (yych <= 'M') goto yy53;
		goto yy765;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy764;
		} else {
			if (yych == 'n') goto yy765;
			goto yy53;
		}
	}
yy587:
	YYDEBUG(587, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy766;
	if (yych == 'a') goto yy766;
	goto yy53;
yy588:
	YYDEBUG(588, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy234;
	if (yych <= '9') goto yy767;
	goto yy234;
yy589:
	YYDEBUG(589, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy768;
	if (yych == 'a') goto yy768;
	goto yy53;
yy590:
	YYDEBUG(590, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy236;
	if (yych == 'h') goto yy236;
	goto yy53;
yy591:
	YYDEBUG(591, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy769;
	if (yych == 'o') goto yy769;
	goto yy53;
yy592:
	YYDEBUG(592, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy769;
	if (yych == 'i') goto yy769;
	goto yy53;
yy593:
	YYDEBUG(593, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy770;
	if (yych == 't') goto yy770;
	goto yy53;
yy594:
	YYDEBUG(594, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy399;
	if (yych == 'h') goto yy399;
	goto yy53;
yy595:
	YYDEBUG(595, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy771;
	if (yych == 'b') goto yy771;
	goto yy53;
yy596:
	YYDEBUG(596, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy599;
	if (yych == 'r') goto yy599;
	goto yy53;
yy597:
	YYDEBUG(597, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy772;
	if (yych == 'n') goto yy772;
	goto yy53;
yy598:
	YYDEBUG(598, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy599;
	if (yych != 's') goto yy53;
yy599:
	YYDEBUG(599, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy587;
	if (yych == 'd') goto yy587;
	goto yy53;
yy600:
	YYDEBUG(600, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy598;
	if (yych == 'e') goto yy598;
	goto yy53;
yy601:
	YYDEBUG(601, *YYCURSOR);
	yyaccept = 7;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy182;
		if (yych <= 'R') goto yy243;
		goto yy583;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy243;
			goto yy182;
		} else {
			if (yych == 's') goto yy583;
			goto yy243;
		}
	}
yy602:
	YYDEBUG(602, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy370;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy604;
	goto yy53;
yy603:
	YYDEBUG(603, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy370;
	if (yych <= '/') goto yy53;
	if (yych >= '3') goto yy53;
yy604:
	YYDEBUG(604, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= ',') goto yy53;
	if (yych <= '.') goto yy370;
	goto yy53;
yy605:
	YYDEBUG(605, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy773;
	goto yy203;
yy606:
	YYDEBUG(606, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy706;
		goto yy203;
	} else {
		if (yych <= '0') goto yy773;
		if (yych <= '9') goto yy700;
		goto yy203;
	}
yy607:
	YYDEBUG(607, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy607;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy607;
			if (yych <= '@') goto yy53;
			goto yy97;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy97;
			goto yy53;
		} else {
			if (yych <= 'a') goto yy97;
			if (yych == 'p') goto yy97;
			goto yy53;
		}
	}
yy608:
	YYDEBUG(608, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy774;
	goto yy203;
yy609:
	YYDEBUG(609, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych == '0') goto yy774;
	goto yy203;
yy610:
	YYDEBUG(610, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy775;
	if (yych <= '6') goto yy776;
	if (yych <= '9') goto yy544;
	goto yy53;
yy611:
	YYDEBUG(611, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy777;
	if (yych <= '3') goto yy778;
	if (yych <= '9') goto yy779;
	goto yy53;
yy612:
	YYDEBUG(612, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy780;
	goto yy53;
yy613:
	YYDEBUG(613, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy781;
	if (yych == 'r') goto yy781;
	goto yy53;
yy614:
	YYDEBUG(614, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy781;
	if (yych == 'g') goto yy781;
	goto yy53;
yy615:
	YYDEBUG(615, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy781;
	if (yych == 'c') goto yy781;
	goto yy53;
yy616:
	YYDEBUG(616, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy781;
	if (yych == 'b') goto yy781;
	goto yy53;
yy617:
	YYDEBUG(617, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy781;
	if (yych == 'n') goto yy781;
	goto yy53;
yy618:
	YYDEBUG(618, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy781;
		if (yych <= 'M') goto yy53;
		goto yy781;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy781;
		} else {
			if (yych == 'n') goto yy781;
			goto yy53;
		}
	}
yy619:
	YYDEBUG(619, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy781;
		if (yych <= 'X') goto yy53;
		goto yy781;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy781;
		} else {
			if (yych == 'y') goto yy781;
			goto yy53;
		}
	}
yy620:
	YYDEBUG(620, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy781;
	if (yych == 'v') goto yy781;
	goto yy53;
yy621:
	YYDEBUG(621, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy781;
	if (yych == 't') goto yy781;
	goto yy53;
yy622:
	YYDEBUG(622, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy782;
	if (yych == 'p') goto yy782;
	goto yy53;
yy623:
	YYDEBUG(623, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy783;
	goto yy53;
yy624:
	YYDEBUG(624, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Z') goto yy784;
		if (yych <= '`') goto yy16;
		if (yych <= 'z') goto yy784;
		goto yy16;
	}
yy625:
	YYDEBUG(625, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy304;
				goto yy53;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy785;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
				goto yy307;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy626:
	YYDEBUG(626, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '1') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych == ',') goto yy304;
				goto yy53;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy785;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= '9') goto yy310;
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
				goto yy307;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy627:
	YYDEBUG(627, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy273;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy103;
			goto yy273;
		}
	} else {
		if (yych <= '@') {
			if (yych == '/') goto yy273;
			if (yych <= '9') goto yy130;
			goto yy273;
		} else {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy273;
			if (yych <= 'z') goto yy784;
			goto yy273;
		}
	}
yy628:
	YYDEBUG(628, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy784;
			goto yy786;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 't') goto yy786;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy629:
	YYDEBUG(629, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy784;
			goto yy16;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy787;
			goto yy16;
		}
	}
yy630:
	YYDEBUG(630, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy130;
			if (yych <= 0x1F) goto yy273;
			goto yy130;
		} else {
			if (yych <= ')') {
				if (yych <= '(') goto yy273;
				goto yy103;
			} else {
				if (yych <= ',') goto yy273;
				if (yych <= '-') goto yy665;
				goto yy130;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '/') goto yy275;
			if (yych <= '9') goto yy130;
			if (yych <= '@') goto yy273;
			goto yy784;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy273;
				goto yy275;
			} else {
				if (yych <= '`') goto yy273;
				if (yych <= 'z') goto yy787;
				goto yy273;
			}
		}
	}
yy631:
	YYDEBUG(631, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy786;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 't') goto yy788;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy632:
	YYDEBUG(632, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy789;
	if (yych == 'o') goto yy789;
	goto yy53;
yy633:
	YYDEBUG(633, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'B') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'A') goto yy784;
			goto yy790;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'b') goto yy790;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy634:
	YYDEBUG(634, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'B') goto yy790;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'b') goto yy791;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy635:
	YYDEBUG(635, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy792;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy792;
			if (yych == ')') goto yy103;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'H') goto yy794;
			if (yych <= 'Z') goto yy784;
			goto yy16;
		} else {
			if (yych == 'h') goto yy794;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy636:
	YYDEBUG(636, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'M') goto yy784;
			goto yy795;
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'n') goto yy795;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy637:
	YYDEBUG(637, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= '(') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy16;
				goto yy792;
			} else {
				if (yych == ' ') goto yy792;
				goto yy16;
			}
		} else {
			if (yych <= ',') {
				if (yych <= ')') goto yy103;
				goto yy16;
			} else {
				if (yych == '.') goto yy16;
				goto yy275;
			}
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'G') {
				if (yych <= '@') goto yy16;
				goto yy784;
			} else {
				if (yych <= 'H') goto yy794;
				if (yych <= 'Z') goto yy784;
				goto yy16;
			}
		} else {
			if (yych <= 'g') {
				if (yych <= '_') goto yy275;
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'h') goto yy796;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy638:
	YYDEBUG(638, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'M') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'N') goto yy795;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'm') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'n') goto yy797;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy639:
	YYDEBUG(639, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy798;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy784;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy798;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy640:
	YYDEBUG(640, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy16;
			goto yy792;
		} else {
			if (yych == ' ') goto yy792;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy784;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy641:
	YYDEBUG(641, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy16;
			goto yy792;
		} else {
			if (yych == ' ') goto yy799;
			goto yy16;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= ')') goto yy103;
			if (yych <= '@') goto yy16;
			goto yy784;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy642:
	YYDEBUG(642, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'G') goto yy784;
			goto yy794;
		}
	} else {
		if (yych <= 'g') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'h') goto yy794;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy643:
	YYDEBUG(643, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'X') goto yy784;
			goto yy800;
		}
	} else {
		if (yych <= 'x') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'y') goto yy800;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy644:
	YYDEBUG(644, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych == ' ') goto yy632;
		if (yych <= '(') goto yy16;
		goto yy103;
	} else {
		if (yych <= 'Z') {
			if (yych <= '@') goto yy16;
			goto yy784;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy645:
	YYDEBUG(645, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy798;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy801;
			if (yych <= 'z') goto yy787;
			goto yy16;
		}
	}
yy646:
	YYDEBUG(646, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy792;
			if (yych <= 0x1F) goto yy16;
			goto yy792;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy275;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy647:
	YYDEBUG(647, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy792;
			if (yych <= 0x1F) goto yy16;
			goto yy799;
		} else {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		}
	} else {
		if (yych <= 'Z') {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy16;
				goto yy275;
			} else {
				if (yych <= '`') goto yy16;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy648:
	YYDEBUG(648, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'H') goto yy794;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'g') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'h') goto yy796;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy649:
	YYDEBUG(649, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Y') goto yy800;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'x') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'y') goto yy802;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy650:
	YYDEBUG(650, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= '(') {
			if (yych == ' ') goto yy632;
			goto yy16;
		} else {
			if (yych <= ')') goto yy103;
			if (yych == '-') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '/') goto yy275;
			if (yych <= '@') goto yy16;
			if (yych <= 'Z') goto yy784;
			goto yy16;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy16;
			if (yych <= 'z') goto yy787;
			goto yy16;
		}
	}
yy651:
	YYDEBUG(651, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '9') goto yy653;
	if (yych <= ':') goto yy187;
	goto yy16;
yy652:
	YYDEBUG(652, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy16;
		if (yych >= '5') goto yy368;
	} else {
		if (yych <= '9') goto yy103;
		if (yych <= ':') goto yy187;
		goto yy16;
	}
yy653:
	YYDEBUG(653, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy16;
	if (yych <= '5') goto yy368;
	if (yych <= '9') goto yy103;
	if (yych <= ':') goto yy187;
	goto yy16;
yy654:
	YYDEBUG(654, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy803;
	if (yych <= '9') goto yy805;
	goto yy53;
yy655:
	YYDEBUG(655, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '.') goto yy654;
	if (yych == ':') goto yy654;
	goto yy53;
yy656:
	YYDEBUG(656, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy806;
	if (yych <= '9') goto yy807;
	goto yy53;
yy657:
	YYDEBUG(657, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy654;
		goto yy53;
	} else {
		if (yych <= '9') goto yy655;
		if (yych <= ':') goto yy654;
		goto yy53;
	}
yy658:
	YYDEBUG(658, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') {
		if (yych == '.') goto yy654;
		goto yy53;
	} else {
		if (yych <= '4') goto yy655;
		if (yych == ':') goto yy654;
		goto yy53;
	}
yy659:
	YYDEBUG(659, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy654;
		goto yy303;
	} else {
		if (yych <= '9') goto yy808;
		if (yych <= ':') goto yy654;
		goto yy303;
	}
yy660:
	YYDEBUG(660, *YYCURSOR);
	yyaccept = 11;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy656;
		goto yy303;
	} else {
		if (yych <= '9') goto yy808;
		if (yych <= ':') goto yy656;
		goto yy303;
	}
yy661:
	YYDEBUG(661, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy303;
	if (yych <= '9') goto yy808;
	goto yy303;
yy662:
	YYDEBUG(662, *YYCURSOR);
	++YYCURSOR;
#line 1441 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("datenoday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NO_DAY;
	}
#line 15014 "lib/parse_date.c"
yy663:
	YYDEBUG(663, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy784;
			goto yy809;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'r') goto yy809;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy664:
	YYDEBUG(664, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy809;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'r') goto yy810;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy665:
	YYDEBUG(665, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 64) {
		goto yy447;
	}
	goto yy130;
yy666:
	YYDEBUG(666, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy667:
	YYDEBUG(667, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy666;
				if (yych <= 0x1F) goto yy53;
				goto yy666;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy53;
					goto yy811;
				} else {
					if (yych == 'F') goto yy812;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy813;
					goto yy53;
				} else {
					if (yych <= 'M') goto yy814;
					if (yych <= 'R') goto yy53;
					goto yy815;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy816;
					goto yy817;
				} else {
					if (yych == 'W') goto yy818;
					goto yy53;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy819;
					goto yy53;
				} else {
					if (yych <= 'd') goto yy811;
					if (yych <= 'e') goto yy53;
					goto yy812;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy53;
					goto yy813;
				} else {
					if (yych == 'm') goto yy814;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy815;
					goto yy816;
				} else {
					if (yych <= 'u') goto yy817;
					if (yych <= 'v') goto yy53;
					goto yy818;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy53;
					goto yy819;
				} else {
					if (yych == 0xC2) goto yy820;
					goto yy53;
				}
			}
		}
	}
yy668:
	YYDEBUG(668, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy821;
	if (yych == 'd') goto yy821;
	goto yy667;
yy669:
	YYDEBUG(669, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'G') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'F') goto yy784;
			goto yy822;
		}
	} else {
		if (yych <= 'f') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'g') goto yy822;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy670:
	YYDEBUG(670, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'F') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'G') goto yy822;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'f') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'g') goto yy823;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy671:
	YYDEBUG(671, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'D') goto yy784;
			goto yy824;
		}
	} else {
		if (yych <= 'd') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'e') goto yy824;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy672:
	YYDEBUG(672, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'E') goto yy824;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'd') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'e') goto yy825;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy673:
	YYDEBUG(673, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'O') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'N') goto yy784;
			goto yy826;
		}
	} else {
		if (yych <= 'n') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'o') goto yy826;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy674:
	YYDEBUG(674, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'O') goto yy826;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'n') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'o') goto yy827;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy675:
	YYDEBUG(675, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy784;
			goto yy828;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'd') goto yy828;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy676:
	YYDEBUG(676, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'D') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'C') goto yy784;
			goto yy794;
		}
	} else {
		if (yych <= 'c') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'd') goto yy794;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy677:
	YYDEBUG(677, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'M') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'L') goto yy784;
			goto yy829;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'm') goto yy829;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy678:
	YYDEBUG(678, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'T') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'S') goto yy784;
			goto yy830;
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 't') goto yy830;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy679:
	YYDEBUG(679, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy828;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'd') goto yy831;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy680:
	YYDEBUG(680, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'D') goto yy794;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'c') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'd') goto yy796;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy681:
	YYDEBUG(681, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'M') goto yy829;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'l') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'm') goto yy832;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy682:
	YYDEBUG(682, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'T') goto yy830;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 's') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 't') goto yy833;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy683:
	YYDEBUG(683, *YYCURSOR);
	yyaccept = 13;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy394;
	if (yych <= '5') goto yy834;
	if (yych <= '6') goto yy835;
	goto yy394;
yy684:
	YYDEBUG(684, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy103;
	} else {
		if (yych <= 'Z') goto yy784;
		if (yych <= '`') goto yy685;
		if (yych <= 'z') goto yy784;
	}
yy685:
	YYDEBUG(685, *YYCURSOR);
#line 1051 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("midnight | today");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 15572 "lib/parse_date.c"
yy686:
	YYDEBUG(686, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy784;
			goto yy836;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'r') goto yy836;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy687:
	YYDEBUG(687, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy837;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy784;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy837;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy688:
	YYDEBUG(688, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy685;
		} else {
			if (yych == '.') goto yy685;
			goto yy275;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy685;
			if (yych <= 'Z') goto yy784;
			goto yy685;
		} else {
			if (yych <= '_') goto yy275;
			if (yych <= '`') goto yy685;
			if (yych <= 'z') goto yy787;
			goto yy685;
		}
	}
yy689:
	YYDEBUG(689, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy836;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'r') goto yy838;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy690:
	YYDEBUG(690, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy837;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy839;
			if (yych <= 'z') goto yy787;
			goto yy16;
		}
	}
yy691:
	YYDEBUG(691, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'R') goto yy784;
			goto yy840;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 's') goto yy840;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy692:
	YYDEBUG(692, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		if (yych <= '@') goto yy16;
		goto yy841;
	} else {
		if (yych <= '`') {
			if (yych <= 'Z') goto yy784;
			goto yy16;
		} else {
			if (yych <= 'a') goto yy841;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy693:
	YYDEBUG(693, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'S') goto yy840;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'r') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 's') goto yy842;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy694:
	YYDEBUG(694, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy841;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy843;
			if (yych <= 'z') goto yy787;
			goto yy16;
		}
	}
yy695:
	YYDEBUG(695, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych <= ')') {
			if (yych <= '(') goto yy16;
			goto yy103;
		} else {
			if (yych <= '@') goto yy16;
			if (yych <= 'Q') goto yy784;
			goto yy844;
		}
	} else {
		if (yych <= 'q') {
			if (yych <= 'Z') goto yy784;
			if (yych <= '`') goto yy16;
			goto yy784;
		} else {
			if (yych <= 'r') goto yy844;
			if (yych <= 'z') goto yy784;
			goto yy16;
		}
	}
yy696:
	YYDEBUG(696, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= '-') {
			if (yych == ')') goto yy103;
			if (yych <= ',') goto yy16;
			goto yy275;
		} else {
			if (yych == '/') goto yy275;
			if (yych <= '@') goto yy16;
			goto yy784;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'R') goto yy844;
			if (yych <= 'Z') goto yy784;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= 'q') {
				if (yych <= '`') goto yy16;
				goto yy787;
			} else {
				if (yych <= 'r') goto yy845;
				if (yych <= 'z') goto yy787;
				goto yy16;
			}
		}
	}
yy697:
	YYDEBUG(697, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy846;
	if (yych <= '1') goto yy847;
	goto yy53;
yy698:
	YYDEBUG(698, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy849;
	goto yy181;
yy699:
	YYDEBUG(699, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy850;
	goto yy53;
yy700:
	YYDEBUG(700, *YYCURSOR);
	yyaccept = 18;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') goto yy701;
	if (yych <= '9') goto yy850;
yy701:
	YYDEBUG(701, *YYCURSOR);
#line 1427 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pointed date YY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 15886 "lib/parse_date.c"
yy702:
	YYDEBUG(702, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '9') goto yy850;
		if (yych <= 'm') goto yy536;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy703:
	YYDEBUG(703, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy851;
	goto yy53;
yy704:
	YYDEBUG(704, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy851;
	goto yy53;
yy705:
	YYDEBUG(705, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy851;
	goto yy53;
yy706:
	YYDEBUG(706, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy852;
	goto yy53;
yy707:
	YYDEBUG(707, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy850;
	goto yy203;
yy708:
	YYDEBUG(708, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy208;
	if (yych <= '9') goto yy853;
	goto yy208;
yy709:
	YYDEBUG(709, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy854;
	goto yy53;
yy710:
	YYDEBUG(710, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy855;
	if (yych <= '3') goto yy856;
	if (yych <= '9') goto yy538;
	goto yy53;
yy711:
	YYDEBUG(711, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy712:
	YYDEBUG(712, *YYCURSOR);
	switch (yych) {
		case '\t':
		case ' ':
		case '-':
		case '.': goto yy711;
		case 'A':
		case 'a': goto yy564;
		case 'D':
		case 'd': goto yy729;
		case 'F':
		case 'f': goto yy730;
		case 'I': goto yy567;
		case 'J':
		case 'j': goto yy569;
		case 'M':
		case 'm': goto yy731;
		case 'N':
		case 'n': goto yy571;
		case 'O':
		case 'o': goto yy572;
		case 'S':
		case 's': goto yy732;
		case 'V': goto yy574;
		case 'X': goto yy576;
		default: goto yy53;
	}
yy713:
	YYDEBUG(713, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy857;
	if (yych <= '/') goto yy714;
	if (yych <= '9') goto yy858;
yy714:
	YYDEBUG(714, *YYCURSOR);
#line 1372 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("gnudateshorter");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 16008 "lib/parse_date.c"
yy715:
	YYDEBUG(715, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy857;
	if (yych <= '/') goto yy714;
	if (yych <= '2') goto yy858;
	goto yy714;
yy716:
	YYDEBUG(716, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy857;
	goto yy714;
yy717:
	YYDEBUG(717, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'P') goto yy859;
		if (yych <= 'T') goto yy53;
		goto yy860;
	} else {
		if (yych <= 'p') {
			if (yych <= 'o') goto yy53;
			goto yy859;
		} else {
			if (yych == 'u') goto yy860;
			goto yy53;
		}
	}
yy718:
	YYDEBUG(718, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy861;
	if (yych == 'e') goto yy861;
	goto yy53;
yy719:
	YYDEBUG(719, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy862;
	if (yych == 'e') goto yy862;
	goto yy53;
yy720:
	YYDEBUG(720, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'A') goto yy863;
		if (yych <= 'T') goto yy53;
		goto yy864;
	} else {
		if (yych <= 'a') {
			if (yych <= '`') goto yy53;
			goto yy863;
		} else {
			if (yych == 'u') goto yy864;
			goto yy53;
		}
	}
yy721:
	YYDEBUG(721, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy865;
	if (yych == 'a') goto yy865;
	goto yy53;
yy722:
	YYDEBUG(722, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy866;
	if (yych == 'o') goto yy866;
	goto yy53;
yy723:
	YYDEBUG(723, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy867;
	if (yych == 'c') goto yy867;
	goto yy53;
yy724:
	YYDEBUG(724, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy868;
	if (yych == 'e') goto yy868;
	goto yy53;
yy725:
	YYDEBUG(725, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy756;
	if (yych <= '4') goto yy757;
	if (yych <= '5') goto yy758;
	goto yy53;
yy726:
	YYDEBUG(726, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy869;
	if (yych <= '9') goto yy870;
	goto yy53;
yy727:
	YYDEBUG(727, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy870;
	goto yy53;
yy728:
	YYDEBUG(728, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy870;
	if (yych <= '6') goto yy871;
	goto yy53;
yy729:
	YYDEBUG(729, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy746;
	if (yych == 'e') goto yy746;
	goto yy53;
yy730:
	YYDEBUG(730, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy747;
	if (yych == 'e') goto yy747;
	goto yy53;
yy731:
	YYDEBUG(731, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy752;
	if (yych == 'a') goto yy752;
	goto yy53;
yy732:
	YYDEBUG(732, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy872;
	if (yych == 'e') goto yy872;
	goto yy53;
yy733:
	YYDEBUG(733, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy873;
	if (yych <= '9') goto yy874;
	goto yy53;
yy734:
	YYDEBUG(734, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '.') goto yy53;
	if (yych <= '/') goto yy873;
	if (yych <= '2') goto yy874;
	goto yy53;
yy735:
	YYDEBUG(735, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy873;
	goto yy53;
yy736:
	YYDEBUG(736, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= '/') {
				if (yych <= '\t') {
					if (yych >= '\t') goto yy181;
				} else {
					if (yych == ' ') goto yy181;
				}
			} else {
				if (yych <= '2') {
					if (yych <= '0') goto yy875;
					goto yy876;
				} else {
					if (yych <= '3') goto yy878;
					if (yych <= '9') goto yy879;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy181;
				} else {
					if (yych != 'G') goto yy181;
				}
			} else {
				if (yych <= 'M') {
					if (yych >= 'M') goto yy181;
				} else {
					if (yych <= 'R') goto yy737;
					if (yych <= 'U') goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy181;
				} else {
					if (yych <= 'Y') goto yy181;
					if (yych >= 'd') goto yy181;
				}
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy181;
				} else {
					if (yych == 'h') goto yy181;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
				} else {
					if (yych != 'v') goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
				}
			}
		}
	}
yy737:
	YYDEBUG(737, *YYCURSOR);
#line 1298 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("iso8601nocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_ISO_NOCOLON;
	}
#line 16252 "lib/parse_date.c"
yy738:
	YYDEBUG(738, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'V') {
		if (yych <= 'C') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy737;
				goto yy181;
			} else {
				if (yych <= '2') {
					if (yych <= '/') goto yy737;
					goto yy876;
				} else {
					if (yych <= '3') goto yy878;
					if (yych <= '9') goto yy879;
					goto yy737;
				}
			}
		} else {
			if (yych <= 'H') {
				if (yych <= 'E') {
					if (yych <= 'D') goto yy181;
					goto yy737;
				} else {
					if (yych == 'G') goto yy737;
					goto yy181;
				}
			} else {
				if (yych <= 'M') {
					if (yych <= 'L') goto yy737;
					goto yy181;
				} else {
					if (yych <= 'R') goto yy737;
					if (yych <= 'U') goto yy181;
					goto yy737;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych <= 'X') {
					if (yych <= 'W') goto yy181;
					goto yy737;
				} else {
					if (yych <= 'Y') goto yy181;
					if (yych <= 'c') goto yy737;
					goto yy181;
				}
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy737;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy737;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy737;
				} else {
					if (yych == 'v') goto yy737;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy737;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy737;
				}
			}
		}
	}
yy739:
	YYDEBUG(739, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy737;
				goto yy181;
			} else {
				if (yych <= '9') {
					if (yych <= '/') goto yy737;
					goto yy879;
				} else {
					if (yych == 'D') goto yy181;
					goto yy737;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy737;
				if (yych <= 'H') goto yy181;
				goto yy737;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy737;
				} else {
					if (yych == 'V') goto yy737;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy737;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy737;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy737;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy737;
				} else {
					if (yych == 'v') goto yy737;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy737;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy737;
				}
			}
		}
	}
yy740:
	YYDEBUG(740, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy737;
				goto yy181;
			} else {
				if (yych <= '6') {
					if (yych <= '/') goto yy737;
					goto yy879;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy737;
					goto yy181;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy737;
					goto yy181;
				} else {
					if (yych == 'H') goto yy181;
					goto yy737;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy737;
				} else {
					if (yych == 'V') goto yy737;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy737;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy737;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy737;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy737;
				} else {
					if (yych == 'v') goto yy737;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy737;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy737;
				}
			}
		}
	}
yy741:
	YYDEBUG(741, *YYCURSOR);
	yyaccept = 20;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy737;
				goto yy181;
			} else {
				if (yych == 'D') goto yy181;
				if (yych <= 'E') goto yy737;
				goto yy181;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy181;
				if (yych <= 'L') goto yy737;
				goto yy181;
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy737;
					goto yy181;
				} else {
					if (yych == 'W') goto yy181;
					goto yy737;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy181;
				if (yych == 'd') goto yy181;
				goto yy737;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy181;
					goto yy737;
				} else {
					if (yych <= 'h') goto yy181;
					if (yych <= 'l') goto yy737;
					goto yy181;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy737;
				if (yych == 'v') goto yy737;
				goto yy181;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy737;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy737;
				}
			}
		}
	}
yy742:
	YYDEBUG(742, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy880;
	goto yy53;
yy743:
	YYDEBUG(743, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy880;
	goto yy53;
yy744:
	YYDEBUG(744, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy881;
	if (yych == 'r') goto yy881;
	goto yy53;
yy745:
	YYDEBUG(745, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy882;
	if (yych == 'g') goto yy882;
	goto yy53;
yy746:
	YYDEBUG(746, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy883;
	if (yych == 'c') goto yy883;
	goto yy53;
yy747:
	YYDEBUG(747, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy884;
	if (yych == 'b') goto yy884;
	goto yy53;
yy748:
	YYDEBUG(748, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != 'I') goto yy568;
yy749:
	YYDEBUG(749, *YYCURSOR);
	++YYCURSOR;
	goto yy568;
yy750:
	YYDEBUG(750, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy885;
	if (yych == 'n') goto yy885;
	goto yy53;
yy751:
	YYDEBUG(751, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy886;
		if (yych <= 'M') goto yy53;
		goto yy887;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy886;
		} else {
			if (yych == 'n') goto yy887;
			goto yy53;
		}
	}
yy752:
	YYDEBUG(752, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy888;
		if (yych <= 'X') goto yy53;
		goto yy749;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy888;
		} else {
			if (yych == 'y') goto yy749;
			goto yy53;
		}
	}
yy753:
	YYDEBUG(753, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy883;
	if (yych == 'v') goto yy883;
	goto yy53;
yy754:
	YYDEBUG(754, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy889;
	if (yych == 't') goto yy889;
	goto yy53;
yy755:
	YYDEBUG(755, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'P') {
		if (yych == 'C') goto yy417;
		if (yych <= 'O') goto yy53;
		goto yy890;
	} else {
		if (yych <= 'c') {
			if (yych <= 'b') goto yy53;
			goto yy417;
		} else {
			if (yych == 'p') goto yy890;
			goto yy53;
		}
	}
yy756:
	YYDEBUG(756, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy891;
	goto yy53;
yy757:
	YYDEBUG(757, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy891;
	goto yy53;
yy758:
	YYDEBUG(758, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '3') goto yy891;
	goto yy53;
yy759:
	YYDEBUG(759, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '2') {
		if (yych <= '/') goto yy181;
		if (yych <= '0') goto yy875;
		goto yy876;
	} else {
		if (yych <= '3') goto yy878;
		if (yych <= '9') goto yy879;
		goto yy181;
	}
yy760:
	YYDEBUG(760, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '2') goto yy876;
	if (yych <= '3') goto yy878;
	if (yych <= '9') goto yy879;
	goto yy181;
yy761:
	YYDEBUG(761, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy879;
	goto yy181;
yy762:
	YYDEBUG(762, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '6') goto yy879;
	if (yych <= '9') goto yy54;
	goto yy181;
yy763:
	YYDEBUG(763, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy236;
	if (yych == 't') goto yy236;
	goto yy53;
yy764:
	YYDEBUG(764, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy765;
	if (yych != 'n') goto yy53;
yy765:
	YYDEBUG(765, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy893;
	if (yych == 'i') goto yy893;
	goto yy53;
yy766:
	YYDEBUG(766, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy583;
	if (yych == 'y') goto yy583;
	goto yy53;
yy767:
	YYDEBUG(767, *YYCURSOR);
	++YYCURSOR;
	goto yy234;
yy768:
	YYDEBUG(768, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy894;
	if (yych == 'r') goto yy894;
	goto yy53;
yy769:
	YYDEBUG(769, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy895;
	if (yych == 's') goto yy895;
	goto yy53;
yy770:
	YYDEBUG(770, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy399;
	if (yych == 'e') goto yy399;
	goto yy53;
yy771:
	YYDEBUG(771, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy896;
	if (yych == 'e') goto yy896;
	goto yy53;
yy772:
	YYDEBUG(772, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy399;
	if (yych == 'd') goto yy399;
	goto yy53;
yy773:
	YYDEBUG(773, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy607;
			if (yych <= 0x1F) goto yy203;
			goto yy607;
		} else {
			if (yych == '.') goto yy706;
			if (yych <= '/') goto yy203;
			goto yy850;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy97;
			if (yych <= 'O') goto yy203;
			goto yy97;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy203;
				goto yy97;
			} else {
				if (yych == 'p') goto yy97;
				goto yy203;
			}
		}
	}
yy774:
	YYDEBUG(774, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy607;
			goto yy203;
		} else {
			if (yych <= ' ') goto yy607;
			if (yych == '.') goto yy706;
			goto yy203;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy97;
			if (yych == 'P') goto yy97;
			goto yy203;
		} else {
			if (yych <= 'a') goto yy97;
			if (yych == 'p') goto yy97;
			goto yy203;
		}
	}
yy775:
	YYDEBUG(775, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy897;
	goto yy203;
yy776:
	YYDEBUG(776, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy706;
	if (yych == '0') goto yy897;
	goto yy203;
yy777:
	YYDEBUG(777, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '9') goto yy779;
		if (yych <= 'm') goto yy536;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy778:
	YYDEBUG(778, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '1') goto yy779;
		if (yych <= 'm') goto yy536;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy779:
	YYDEBUG(779, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy703;
		goto yy536;
	} else {
		if (yych <= 'r') goto yy703;
		if (yych <= 's') goto yy704;
		if (yych <= 't') goto yy705;
		goto yy536;
	}
yy780:
	YYDEBUG(780, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy898;
	if (yych <= '3') goto yy899;
	if (yych <= '9') goto yy779;
	goto yy53;
yy781:
	YYDEBUG(781, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy900;
	goto yy53;
yy782:
	YYDEBUG(782, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == '-') goto yy900;
		goto yy53;
	} else {
		if (yych <= 'T') goto yy781;
		if (yych == 't') goto yy781;
		goto yy53;
	}
yy783:
	YYDEBUG(783, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy901;
	goto yy53;
yy784:
	YYDEBUG(784, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy103;
	goto yy16;
yy785:
	YYDEBUG(785, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '9') {
		if (yych <= ' ') {
			if (yych <= 0x08) {
				if (yych <= 0x00) goto yy302;
				goto yy53;
			} else {
				if (yych <= '\t') goto yy304;
				if (yych <= 0x1F) goto yy53;
				goto yy304;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '+') goto yy53;
				if (yych <= ',') goto yy304;
				goto yy902;
			} else {
				if (yych <= '.') goto yy304;
				if (yych <= '/') goto yy53;
				goto yy482;
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy53;
				goto yy304;
			} else {
				if (yych == 'h') goto yy304;
				goto yy53;
			}
		} else {
			if (yych <= 'r') {
				if (yych <= 'n') goto yy307;
				if (yych <= 'q') goto yy53;
				goto yy307;
			} else {
				if (yych <= 's') goto yy308;
				if (yych <= 't') goto yy309;
				goto yy53;
			}
		}
	}
yy786:
	YYDEBUG(786, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '(') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy273;
			goto yy130;
		} else {
			if (yych == ' ') goto yy130;
			goto yy273;
		}
	} else {
		if (yych <= '.') {
			if (yych <= ')') goto yy103;
			if (yych <= ',') goto yy273;
			goto yy130;
		} else {
			if (yych <= '/') goto yy273;
			if (yych <= '9') goto yy130;
			goto yy273;
		}
	}
yy787:
	YYDEBUG(787, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy103;
		if (yych <= ',') goto yy16;
		goto yy275;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy16;
			goto yy275;
		} else {
			if (yych == '_') goto yy275;
			goto yy16;
		}
	}
yy788:
	YYDEBUG(788, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= ',') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy273;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych == ')') goto yy103;
			goto yy273;
		}
	} else {
		if (yych <= '/') {
			if (yych <= '-') goto yy665;
			if (yych <= '.') goto yy130;
			goto yy275;
		} else {
			if (yych <= '9') goto yy130;
			if (yych == '_') goto yy275;
			goto yy273;
		}
	}
yy789:
	YYDEBUG(789, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy905;
	if (yych == 'f') goto yy905;
	goto yy53;
yy790:
	YYDEBUG(790, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'E') goto yy906;
		if (yych == 'e') goto yy906;
		goto yy16;
	}
yy791:
	YYDEBUG(791, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'E') goto yy906;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'e') goto yy907;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy792:
	YYDEBUG(792, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 12) YYFILL(12);
	yych = *YYCURSOR;
yy793:
	YYDEBUG(793, *YYCURSOR);
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy792;
				if (yych <= 0x1F) goto yy53;
				goto yy792;
			} else {
				if (yych <= 'D') {
					if (yych <= 'C') goto yy53;
					goto yy811;
				} else {
					if (yych == 'F') goto yy812;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy813;
					goto yy53;
				} else {
					if (yych <= 'M') goto yy814;
					if (yych <= 'R') goto yy53;
					goto yy815;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy816;
					goto yy817;
				} else {
					if (yych == 'W') goto yy908;
					goto yy53;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy819;
					goto yy53;
				} else {
					if (yych <= 'd') goto yy811;
					if (yych <= 'e') goto yy53;
					goto yy812;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= 'g') goto yy53;
					goto yy813;
				} else {
					if (yych == 'm') goto yy814;
					goto yy53;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy815;
					goto yy816;
				} else {
					if (yych <= 'u') goto yy817;
					if (yych <= 'v') goto yy53;
					goto yy908;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy53;
					goto yy819;
				} else {
					if (yych == 0xC2) goto yy820;
					goto yy53;
				}
			}
		}
	}
yy794:
	YYDEBUG(794, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 0x1F) {
		if (yych == '\t') goto yy792;
		goto yy16;
	} else {
		if (yych <= ' ') goto yy792;
		if (yych == ')') goto yy103;
		goto yy16;
	}
yy795:
	YYDEBUG(795, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'T') goto yy909;
		if (yych == 't') goto yy909;
		goto yy16;
	}
yy796:
	YYDEBUG(796, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= ')') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy792;
			goto yy16;
		} else {
			if (yych <= ' ') goto yy792;
			if (yych <= '(') goto yy16;
			goto yy103;
		}
	} else {
		if (yych <= '.') {
			if (yych == '-') goto yy275;
			goto yy16;
		} else {
			if (yych <= '/') goto yy275;
			if (yych == '_') goto yy275;
			goto yy16;
		}
	}
yy797:
	YYDEBUG(797, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'T') goto yy909;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 't') goto yy910;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy798:
	YYDEBUG(798, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy911;
		if (yych == 'r') goto yy911;
		goto yy16;
	}
yy799:
	YYDEBUG(799, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy821;
	if (yych == 'd') goto yy821;
	goto yy793;
yy800:
	YYDEBUG(800, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy103;
	goto yy293;
yy801:
	YYDEBUG(801, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy911;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'r') goto yy912;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy802:
	YYDEBUG(802, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '-') {
		if (yych == ')') goto yy103;
		if (yych <= ',') goto yy293;
		goto yy275;
	} else {
		if (yych <= '/') {
			if (yych <= '.') goto yy293;
			goto yy275;
		} else {
			if (yych == '_') goto yy275;
			goto yy293;
		}
	}
yy803:
	YYDEBUG(803, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy913;
	} else {
		if (yych <= '9') goto yy805;
		if (yych <= ':') goto yy913;
	}
yy804:
	YYDEBUG(804, *YYCURSOR);
#line 1771 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("dateshortwithtimeshort | dateshortwithtimelong | dateshortwithtimelongtz");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		if (*ptr != '\0') {
			s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
			if (tz_not_found) {
				add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 17335 "lib/parse_date.c"
yy805:
	YYDEBUG(805, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy913;
	if (yych == ':') goto yy913;
	goto yy804;
yy806:
	YYDEBUG(806, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych == '.') goto yy914;
		goto yy804;
	} else {
		if (yych <= '9') goto yy915;
		if (yych <= ':') goto yy914;
		goto yy804;
	}
yy807:
	YYDEBUG(807, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy914;
	if (yych == ':') goto yy914;
	goto yy804;
yy808:
	YYDEBUG(808, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy303;
	if (yych <= '9') goto yy916;
	goto yy303;
yy809:
	YYDEBUG(809, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy917;
		if (yych == 'y') goto yy917;
		goto yy16;
	}
yy810:
	YYDEBUG(810, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy917;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'y') goto yy918;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy811:
	YYDEBUG(811, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy919;
	if (yych == 'a') goto yy919;
	goto yy53;
yy812:
	YYDEBUG(812, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'R') {
		if (yych == 'O') goto yy920;
		if (yych <= 'Q') goto yy53;
		goto yy921;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy53;
			goto yy920;
		} else {
			if (yych == 'r') goto yy921;
			goto yy53;
		}
	}
yy813:
	YYDEBUG(813, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy922;
	if (yych == 'o') goto yy922;
	goto yy53;
yy814:
	YYDEBUG(814, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych <= 'N') {
			if (yych == 'I') goto yy923;
			goto yy53;
		} else {
			if (yych <= 'O') goto yy924;
			if (yych <= 'R') goto yy53;
			goto yy925;
		}
	} else {
		if (yych <= 'n') {
			if (yych == 'i') goto yy923;
			goto yy53;
		} else {
			if (yych <= 'o') goto yy924;
			if (yych == 's') goto yy925;
			goto yy53;
		}
	}
yy815:
	YYDEBUG(815, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych <= 'D') {
			if (yych == 'A') goto yy927;
			goto yy53;
		} else {
			if (yych <= 'E') goto yy928;
			if (yych <= 'T') goto yy53;
			goto yy929;
		}
	} else {
		if (yych <= 'd') {
			if (yych == 'a') goto yy927;
			goto yy53;
		} else {
			if (yych <= 'e') goto yy928;
			if (yych == 'u') goto yy929;
			goto yy53;
		}
	}
yy816:
	YYDEBUG(816, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'U') {
		if (yych == 'H') goto yy930;
		if (yych <= 'T') goto yy53;
		goto yy931;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy930;
		} else {
			if (yych == 'u') goto yy931;
			goto yy53;
		}
	}
yy817:
	YYDEBUG(817, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy932;
	if (yych == 's') goto yy932;
	goto yy53;
yy818:
	YYDEBUG(818, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy933;
	if (yych == 'e') goto yy933;
	goto yy53;
yy819:
	YYDEBUG(819, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy934;
	if (yych == 'e') goto yy934;
	goto yy53;
yy820:
	YYDEBUG(820, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 0xB5) goto yy935;
	goto yy53;
yy821:
	YYDEBUG(821, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy936;
	if (yych == 'a') goto yy936;
	goto yy53;
yy822:
	YYDEBUG(822, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy937;
		if (yych == 'h') goto yy937;
		goto yy16;
	}
yy823:
	YYDEBUG(823, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy937;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'h') goto yy938;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy824:
	YYDEBUG(824, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Q') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'R') goto yy917;
		if (yych == 'r') goto yy917;
		goto yy16;
	}
yy825:
	YYDEBUG(825, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'R') goto yy917;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'r') goto yy918;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy826:
	YYDEBUG(826, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'U') goto yy939;
		if (yych == 'u') goto yy939;
		goto yy16;
	}
yy827:
	YYDEBUG(827, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'U') goto yy939;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'u') goto yy940;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy828:
	YYDEBUG(828, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'A') goto yy941;
		if (yych == 'a') goto yy941;
		goto yy16;
	}
yy829:
	YYDEBUG(829, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'B') goto yy942;
		if (yych == 'b') goto yy942;
		goto yy16;
	}
yy830:
	YYDEBUG(830, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'H') goto yy943;
		if (yych == 'h') goto yy943;
		goto yy16;
	}
yy831:
	YYDEBUG(831, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'A') goto yy941;
			if (yych <= '^') goto yy16;
			goto yy275;
		} else {
			if (yych <= '`') goto yy16;
			if (yych <= 'a') goto yy944;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy832:
	YYDEBUG(832, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'B') goto yy942;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'b') goto yy945;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy833:
	YYDEBUG(833, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'G') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'H') goto yy943;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'h') goto yy946;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy834:
	YYDEBUG(834, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy947;
	goto yy53;
yy835:
	YYDEBUG(835, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy947;
	goto yy53;
yy836:
	YYDEBUG(836, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'O') goto yy948;
		if (yych == 'o') goto yy948;
		goto yy16;
	}
yy837:
	YYDEBUG(837, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy949;
		if (yych == 'y') goto yy949;
		goto yy16;
	}
yy838:
	YYDEBUG(838, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'O') goto yy948;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'o') goto yy950;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy839:
	YYDEBUG(839, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy949;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'y') goto yy951;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy840:
	YYDEBUG(840, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy952;
		if (yych == 'd') goto yy952;
		goto yy16;
	}
yy841:
	YYDEBUG(841, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'X') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'Y') goto yy953;
		if (yych == 'y') goto yy953;
		goto yy16;
	}
yy842:
	YYDEBUG(842, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy952;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'd') goto yy954;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy843:
	YYDEBUG(843, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'Y') goto yy953;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'y') goto yy955;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy844:
	YYDEBUG(844, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych == ')') goto yy103;
		goto yy16;
	} else {
		if (yych <= 'D') goto yy956;
		if (yych == 'd') goto yy956;
		goto yy16;
	}
yy845:
	YYDEBUG(845, *YYCURSOR);
	yyaccept = 2;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'C') {
		if (yych <= ',') {
			if (yych == ')') goto yy103;
			goto yy16;
		} else {
			if (yych == '.') goto yy16;
			if (yych <= '/') goto yy275;
			goto yy16;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'D') goto yy956;
			if (yych == '_') goto yy275;
			goto yy16;
		} else {
			if (yych == 'd') goto yy957;
			if (yych <= 'z') goto yy903;
			goto yy16;
		}
	}
yy846:
	YYDEBUG(846, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy958;
	goto yy53;
yy847:
	YYDEBUG(847, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy958;
	goto yy53;
yy848:
	YYDEBUG(848, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy959;
	if (yych <= '1') goto yy960;
	goto yy53;
yy849:
	YYDEBUG(849, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy961;
	goto yy181;
yy850:
	YYDEBUG(850, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy962;
	goto yy53;
yy851:
	YYDEBUG(851, *YYCURSOR);
	++YYCURSOR;
	goto yy536;
yy852:
	YYDEBUG(852, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') goto yy203;
	if (yych <= '9') goto yy852;
	goto yy203;
yy853:
	YYDEBUG(853, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy208;
	if (yych <= '9') goto yy963;
	goto yy208;
yy854:
	YYDEBUG(854, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy964;
	goto yy53;
yy855:
	YYDEBUG(855, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '9') goto yy965;
		if (yych <= 'm') goto yy536;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy856:
	YYDEBUG(856, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '1') {
			if (yych <= '/') goto yy536;
			goto yy965;
		} else {
			if (yych <= '9') goto yy699;
			if (yych <= 'm') goto yy536;
			goto yy703;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy857:
	YYDEBUG(857, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy967;
	if (yych <= '3') goto yy968;
	if (yych <= '9') goto yy969;
	goto yy53;
yy858:
	YYDEBUG(858, *YYCURSOR);
	yyaccept = 19;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy970;
	goto yy714;
yy859:
	YYDEBUG(859, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy971;
	if (yych == 'r') goto yy971;
	goto yy53;
yy860:
	YYDEBUG(860, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy972;
	if (yych == 'g') goto yy972;
	goto yy53;
yy861:
	YYDEBUG(861, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy973;
	if (yych == 'c') goto yy973;
	goto yy53;
yy862:
	YYDEBUG(862, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy974;
	if (yych == 'b') goto yy974;
	goto yy53;
yy863:
	YYDEBUG(863, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy975;
	if (yych == 'n') goto yy975;
	goto yy53;
yy864:
	YYDEBUG(864, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'L') goto yy976;
		if (yych <= 'M') goto yy53;
		goto yy977;
	} else {
		if (yych <= 'l') {
			if (yych <= 'k') goto yy53;
			goto yy976;
		} else {
			if (yych == 'n') goto yy977;
			goto yy53;
		}
	}
yy865:
	YYDEBUG(865, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'Y') {
		if (yych == 'R') goto yy978;
		if (yych <= 'X') goto yy53;
		goto yy979;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy53;
			goto yy978;
		} else {
			if (yych == 'y') goto yy979;
			goto yy53;
		}
	}
yy866:
	YYDEBUG(866, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'V') goto yy973;
	if (yych == 'v') goto yy973;
	goto yy53;
yy867:
	YYDEBUG(867, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy980;
	if (yych == 't') goto yy980;
	goto yy53;
yy868:
	YYDEBUG(868, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy981;
	if (yych == 'p') goto yy981;
	goto yy53;
yy869:
	YYDEBUG(869, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '0') goto yy53;
	if (yych <= '9') goto yy982;
	goto yy53;
yy870:
	YYDEBUG(870, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy982;
	goto yy53;
yy871:
	YYDEBUG(871, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '6') goto yy982;
	goto yy53;
yy872:
	YYDEBUG(872, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy890;
	if (yych == 'p') goto yy890;
	goto yy53;
yy873:
	YYDEBUG(873, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy983;
	if (yych <= '3') goto yy985;
	if (yych <= '9') goto yy986;
	goto yy53;
yy874:
	YYDEBUG(874, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '/') goto yy987;
	goto yy53;
yy875:
	YYDEBUG(875, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy988;
	goto yy181;
yy876:
	YYDEBUG(876, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych >= ' ') goto yy181;
			} else {
				if (yych <= '9') {
					if (yych >= '0') goto yy988;
				} else {
					if (yych == 'D') goto yy181;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych == 'G') goto yy877;
				if (yych <= 'H') goto yy181;
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
				} else {
					if (yych != 'V') goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych >= 'd') goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych >= 'f') goto yy181;
				} else {
					if (yych == 'h') goto yy181;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
				} else {
					if (yych != 'v') goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
				}
			}
		}
	}
yy877:
	YYDEBUG(877, *YYCURSOR);
#line 1533 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgydotd");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->d = timelib_get_nr((char **) &ptr, 3);
		s->time->m = 1;
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_YEARDAY;
	}
#line 18231 "lib/parse_date.c"
yy878:
	YYDEBUG(878, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'W') {
		if (yych <= 'D') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy877;
				goto yy181;
			} else {
				if (yych <= '1') {
					if (yych <= '/') goto yy877;
					goto yy988;
				} else {
					if (yych <= '9') goto yy54;
					if (yych <= 'C') goto yy877;
					goto yy181;
				}
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy877;
					goto yy181;
				} else {
					if (yych == 'H') goto yy181;
					goto yy877;
				}
			} else {
				if (yych <= 'R') {
					if (yych <= 'M') goto yy181;
					goto yy877;
				} else {
					if (yych == 'V') goto yy877;
					goto yy181;
				}
			}
		}
	} else {
		if (yych <= 'l') {
			if (yych <= 'd') {
				if (yych == 'Y') goto yy181;
				if (yych <= 'c') goto yy877;
				goto yy181;
			} else {
				if (yych <= 'f') {
					if (yych <= 'e') goto yy877;
					goto yy181;
				} else {
					if (yych == 'h') goto yy181;
					goto yy877;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') {
					if (yych <= 'm') goto yy181;
					goto yy877;
				} else {
					if (yych == 'v') goto yy877;
					goto yy181;
				}
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy877;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy877;
				}
			}
		}
	}
yy879:
	YYDEBUG(879, *YYCURSOR);
	yyaccept = 22;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'F') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy181;
				if (yych <= 0x1F) goto yy877;
				goto yy181;
			} else {
				if (yych == 'D') goto yy181;
				if (yych <= 'E') goto yy877;
				goto yy181;
			}
		} else {
			if (yych <= 'M') {
				if (yych == 'H') goto yy181;
				if (yych <= 'L') goto yy877;
				goto yy181;
			} else {
				if (yych <= 'U') {
					if (yych <= 'R') goto yy877;
					goto yy181;
				} else {
					if (yych == 'W') goto yy181;
					goto yy877;
				}
			}
		}
	} else {
		if (yych <= 'm') {
			if (yych <= 'e') {
				if (yych <= 'Y') goto yy181;
				if (yych == 'd') goto yy181;
				goto yy877;
			} else {
				if (yych <= 'g') {
					if (yych <= 'f') goto yy181;
					goto yy877;
				} else {
					if (yych <= 'h') goto yy181;
					if (yych <= 'l') goto yy877;
					goto yy181;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 'r') goto yy877;
				if (yych == 'v') goto yy877;
				goto yy181;
			} else {
				if (yych <= 'y') {
					if (yych <= 'x') goto yy877;
					goto yy181;
				} else {
					if (yych == 0xC2) goto yy181;
					goto yy877;
				}
			}
		}
	}
yy880:
	YYDEBUG(880, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy990;
	goto yy53;
yy881:
	YYDEBUG(881, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'I') goto yy991;
	if (yych == 'i') goto yy991;
	goto yy568;
yy882:
	YYDEBUG(882, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy992;
	if (yych == 'u') goto yy992;
	goto yy568;
yy883:
	YYDEBUG(883, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy993;
	if (yych == 'e') goto yy993;
	goto yy568;
yy884:
	YYDEBUG(884, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'R') goto yy994;
	if (yych == 'r') goto yy994;
	goto yy568;
yy885:
	YYDEBUG(885, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'U') goto yy995;
	if (yych == 'u') goto yy995;
	goto yy568;
yy886:
	YYDEBUG(886, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy749;
	if (yych == 'y') goto yy749;
	goto yy568;
yy887:
	YYDEBUG(887, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy749;
	if (yych == 'e') goto yy749;
	goto yy568;
yy888:
	YYDEBUG(888, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'C') goto yy996;
	if (yych == 'c') goto yy996;
	goto yy568;
yy889:
	YYDEBUG(889, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'O') goto yy997;
	if (yych == 'o') goto yy997;
	goto yy568;
yy890:
	YYDEBUG(890, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy883;
	if (yych == 't') goto yy883;
	goto yy568;
yy891:
	YYDEBUG(891, *YYCURSOR);
	yyaccept = 24;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy998;
	if (yych <= '/') goto yy892;
	if (yych <= '7') goto yy999;
yy892:
	YYDEBUG(892, *YYCURSOR);
#line 1566 "lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = 1;
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 18470 "lib/parse_date.c"
yy893:
	YYDEBUG(893, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1000;
	if (yych == 'g') goto yy1000;
	goto yy53;
yy894:
	YYDEBUG(894, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy236;
	if (yych == 'y') goto yy236;
	goto yy53;
yy895:
	YYDEBUG(895, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1001;
	if (yych == 'e') goto yy1001;
	goto yy53;
yy896:
	YYDEBUG(896, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy236;
	if (yych == 'r') goto yy236;
	goto yy53;
yy897:
	YYDEBUG(897, *YYCURSOR);
	yyaccept = 5;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy607;
			if (yych <= 0x1F) goto yy203;
			goto yy607;
		} else {
			if (yych == '.') goto yy1002;
			if (yych <= '9') goto yy203;
			goto yy1003;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy97;
			if (yych <= 'O') goto yy203;
			goto yy97;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy203;
				goto yy97;
			} else {
				if (yych == 'p') goto yy97;
				goto yy203;
			}
		}
	}
yy898:
	YYDEBUG(898, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '9') goto yy1004;
		if (yych <= 'm') goto yy536;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy899:
	YYDEBUG(899, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy536;
		if (yych <= '1') goto yy1004;
		if (yych <= 'm') goto yy536;
		goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
			goto yy536;
		}
	}
yy900:
	YYDEBUG(900, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1005;
	if (yych <= '3') goto yy1006;
	goto yy53;
yy901:
	YYDEBUG(901, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1007;
	goto yy53;
yy902:
	YYDEBUG(902, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1008;
	goto yy53;
yy903:
	YYDEBUG(903, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
yy904:
	YYDEBUG(904, *YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy275;
		goto yy53;
	} else {
		if (yych <= '/') goto yy275;
		if (yych == '_') goto yy275;
		goto yy53;
	}
yy905:
	YYDEBUG(905, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1010;
	goto yy53;
yy906:
	YYDEBUG(906, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych == 'r') goto yy917;
	goto yy53;
yy907:
	YYDEBUG(907, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy917;
	if (yych == 'r') goto yy918;
	goto yy904;
yy908:
	YYDEBUG(908, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1011;
	if (yych == 'e') goto yy1011;
	goto yy53;
yy909:
	YYDEBUG(909, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy943;
	if (yych == 'h') goto yy943;
	goto yy53;
yy910:
	YYDEBUG(910, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy943;
	if (yych == 'h') goto yy946;
	goto yy904;
yy911:
	YYDEBUG(911, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy917;
	if (yych == 'y') goto yy917;
	goto yy53;
yy912:
	YYDEBUG(912, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy917;
	if (yych == 'y') goto yy918;
	goto yy904;
yy913:
	YYDEBUG(913, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1012;
	if (yych <= '6') goto yy1013;
	if (yych <= '9') goto yy1014;
	goto yy53;
yy914:
	YYDEBUG(914, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1015;
	if (yych <= '6') goto yy1016;
	if (yych <= '9') goto yy1014;
	goto yy53;
yy915:
	YYDEBUG(915, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ':') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1017;
			if (yych <= 0x1F) goto yy804;
			goto yy1017;
		} else {
			if (yych == '.') goto yy914;
			if (yych <= '9') goto yy804;
			goto yy914;
		}
	} else {
		if (yych <= 'P') {
			if (yych == 'A') goto yy1018;
			if (yych <= 'O') goto yy804;
			goto yy1018;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy804;
				goto yy1018;
			} else {
				if (yych == 'p') goto yy1018;
				goto yy804;
			}
		}
	}
yy916:
	YYDEBUG(916, *YYCURSOR);
	++YYCURSOR;
	goto yy303;
yy917:
	YYDEBUG(917, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy130;
		if (yych <= 0x1F) goto yy273;
		goto yy130;
	} else {
		if (yych <= '.') {
			if (yych <= ',') goto yy273;
			goto yy130;
		} else {
			if (yych <= '/') goto yy273;
			if (yych <= '9') goto yy130;
			goto yy273;
		}
	}
yy918:
	YYDEBUG(918, *YYCURSOR);
	yyaccept = 8;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy130;
			goto yy273;
		} else {
			if (yych <= ' ') goto yy130;
			if (yych <= ',') goto yy273;
			goto yy665;
		}
	} else {
		if (yych <= '9') {
			if (yych == '/') goto yy275;
			goto yy130;
		} else {
			if (yych == '_') goto yy275;
			goto yy273;
		}
	}
yy919:
	YYDEBUG(919, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1019;
	if (yych == 'y') goto yy1019;
	goto yy53;
yy920:
	YYDEBUG(920, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1020;
	if (yych == 'r') goto yy1020;
	goto yy53;
yy921:
	YYDEBUG(921, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1021;
	if (yych == 'i') goto yy1021;
	goto yy53;
yy922:
	YYDEBUG(922, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1022;
	if (yych == 'u') goto yy1022;
	goto yy53;
yy923:
	YYDEBUG(923, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych <= 'K') {
			if (yych == 'C') goto yy1023;
			goto yy53;
		} else {
			if (yych <= 'L') goto yy1024;
			if (yych <= 'M') goto yy53;
			goto yy1025;
		}
	} else {
		if (yych <= 'k') {
			if (yych == 'c') goto yy1023;
			goto yy53;
		} else {
			if (yych <= 'l') goto yy1024;
			if (yych == 'n') goto yy1025;
			goto yy53;
		}
	}
yy924:
	YYDEBUG(924, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1026;
	if (yych == 'n') goto yy1026;
	goto yy53;
yy925:
	YYDEBUG(925, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'E') goto yy1027;
	if (yych == 'e') goto yy1027;
yy926:
	YYDEBUG(926, *YYCURSOR);
#line 1706 "lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetext");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 18814 "lib/parse_date.c"
yy927:
	YYDEBUG(927, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1028;
	if (yych == 't') goto yy1028;
	goto yy53;
yy928:
	YYDEBUG(928, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1029;
	if (yych == 'c') goto yy1029;
	goto yy53;
yy929:
	YYDEBUG(929, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1021;
	if (yych == 'n') goto yy1021;
	goto yy53;
yy930:
	YYDEBUG(930, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy1030;
	if (yych == 'u') goto yy1030;
	goto yy53;
yy931:
	YYDEBUG(931, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1031;
	if (yych == 'e') goto yy1031;
	goto yy53;
yy932:
	YYDEBUG(932, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1027;
	if (yych == 'e') goto yy1027;
	goto yy53;
yy933:
	YYDEBUG(933, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy1032;
		goto yy1033;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy1032;
		if (yych <= 'e') goto yy1033;
		goto yy53;
	}
yy934:
	YYDEBUG(934, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1022;
	if (yych == 'a') goto yy1022;
	goto yy53;
yy935:
	YYDEBUG(935, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy925;
	if (yych == 's') goto yy925;
	goto yy53;
yy936:
	YYDEBUG(936, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1034;
	if (yych == 'y') goto yy1034;
	goto yy53;
yy937:
	YYDEBUG(937, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1035;
	if (yych == 't') goto yy1035;
	goto yy53;
yy938:
	YYDEBUG(938, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1035;
	if (yych == 't') goto yy1036;
	goto yy904;
yy939:
	YYDEBUG(939, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1037;
	if (yych == 's') goto yy1037;
	goto yy53;
yy940:
	YYDEBUG(940, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1037;
	if (yych == 's') goto yy1038;
	goto yy904;
yy941:
	YYDEBUG(941, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy949;
	if (yych == 'y') goto yy949;
	goto yy53;
yy942:
	YYDEBUG(942, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy906;
	if (yych == 'e') goto yy906;
	goto yy53;
yy943:
	YYDEBUG(943, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy792;
	if (yych == ' ') goto yy792;
	goto yy53;
yy944:
	YYDEBUG(944, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy949;
	if (yych == 'y') goto yy951;
	goto yy904;
yy945:
	YYDEBUG(945, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy906;
	if (yych == 'e') goto yy907;
	goto yy904;
yy946:
	YYDEBUG(946, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy792;
	if (yych == ' ') goto yy792;
	goto yy904;
yy947:
	YYDEBUG(947, *YYCURSOR);
	++YYCURSOR;
	goto yy737;
yy948:
	YYDEBUG(948, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1039;
	if (yych == 'w') goto yy1039;
	goto yy53;
yy949:
	YYDEBUG(949, *YYCURSOR);
	++YYCURSOR;
	goto yy293;
yy950:
	YYDEBUG(950, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'W') goto yy1039;
	if (yych == 'w') goto yy1041;
	goto yy904;
yy951:
	YYDEBUG(951, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy275;
		goto yy293;
	} else {
		if (yych <= '/') goto yy275;
		if (yych == '_') goto yy275;
		goto yy293;
	}
yy952:
	YYDEBUG(952, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy941;
	if (yych == 'a') goto yy941;
	goto yy53;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy949;
	if (yych == 's') goto yy949;
	goto yy293;
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy941;
	if (yych == 'a') goto yy944;
	goto yy904;
yy955:
	YYDEBUG(955, *YYCURSOR);
	yyaccept = 10;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych <= '.') {
			if (yych == '-') goto yy275;
			goto yy293;
		} else {
			if (yych <= '/') goto yy275;
			if (yych <= 'R') goto yy293;
			goto yy949;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy275;
			goto yy293;
		} else {
			if (yych == 's') goto yy951;
			if (yych <= 'z') goto yy903;
			goto yy293;
		}
	}
yy956:
	YYDEBUG(956, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1042;
	if (yych == 'a') goto yy1042;
	goto yy53;
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1042;
	if (yych == 'a') goto yy1043;
	goto yy904;
yy958:
	YYDEBUG(958, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1044;
	goto yy53;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1045;
	goto yy53;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1045;
	goto yy53;
yy961:
	YYDEBUG(961, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1046;
	goto yy181;
yy962:
	YYDEBUG(962, *YYCURSOR);
	++YYCURSOR;
#line 1415 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("pointed date YYYY");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_FULL_POINTED;
	}
#line 19068 "lib/parse_date.c"
yy963:
	YYDEBUG(963, *YYCURSOR);
	++YYCURSOR;
	goto yy208;
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1047;
	goto yy53;
yy965:
	YYDEBUG(965, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy966;
		if (yych <= '9') goto yy850;
		if (yych >= 'n') goto yy703;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy703;
		} else {
			if (yych <= 's') goto yy704;
			if (yych <= 't') goto yy705;
		}
	}
yy966:
	YYDEBUG(966, *YYCURSOR);
#line 1346 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("iso8601date2");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 19110 "lib/parse_date.c"
yy967:
	YYDEBUG(967, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy536;
			goto yy969;
		} else {
			if (yych == 'T') goto yy1048;
			goto yy536;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1049;
			if (yych <= 'q') goto yy536;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy1050;
			if (yych <= 't') goto yy1051;
			goto yy536;
		}
	}
yy968:
	YYDEBUG(968, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy536;
		} else {
			if (yych == 'T') goto yy1048;
			goto yy536;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1049;
			if (yych <= 'q') goto yy536;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy1050;
			if (yych <= 't') goto yy1051;
			goto yy536;
		}
	}
yy969:
	YYDEBUG(969, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1048;
		if (yych <= 'm') goto yy536;
		goto yy1049;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy536;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy1050;
			if (yych <= 't') goto yy1051;
			goto yy536;
		}
	}
yy970:
	YYDEBUG(970, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1052;
	if (yych <= '3') goto yy1053;
	if (yych <= '9') goto yy969;
	goto yy53;
yy971:
	YYDEBUG(971, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'H') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'I') goto yy991;
		if (yych == 'i') goto yy991;
		goto yy568;
	}
yy972:
	YYDEBUG(972, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'U') goto yy992;
		if (yych == 'u') goto yy992;
		goto yy568;
	}
yy973:
	YYDEBUG(973, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'E') goto yy993;
		if (yych == 'e') goto yy993;
		goto yy568;
	}
yy974:
	YYDEBUG(974, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'Q') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'R') goto yy994;
		if (yych == 'r') goto yy994;
		goto yy568;
	}
yy975:
	YYDEBUG(975, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'T') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'U') goto yy995;
		if (yych == 'u') goto yy995;
		goto yy568;
	}
yy976:
	YYDEBUG(976, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'X') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'Y') goto yy749;
		if (yych == 'y') goto yy749;
		goto yy568;
	}
yy977:
	YYDEBUG(977, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'E') goto yy749;
		if (yych == 'e') goto yy749;
		goto yy568;
	}
yy978:
	YYDEBUG(978, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'B') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'C') goto yy996;
		if (yych == 'c') goto yy996;
		goto yy568;
	}
yy979:
	YYDEBUG(979, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '-') goto yy900;
	goto yy568;
yy980:
	YYDEBUG(980, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'N') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'O') goto yy997;
		if (yych == 'o') goto yy997;
		goto yy568;
	}
yy981:
	YYDEBUG(981, *YYCURSOR);
	yyaccept = 23;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == '-') goto yy900;
		goto yy568;
	} else {
		if (yych <= 'T') goto yy973;
		if (yych == 't') goto yy973;
		goto yy568;
	}
yy982:
	YYDEBUG(982, *YYCURSOR);
	++YYCURSOR;
	goto yy877;
yy983:
	YYDEBUG(983, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy984;
		if (yych <= '9') goto yy986;
		if (yych >= 'n') goto yy1054;
	} else {
		if (yych <= 'r') {
			if (yych >= 'r') goto yy1054;
		} else {
			if (yych <= 's') goto yy1055;
			if (yych <= 't') goto yy1056;
		}
	}
yy984:
	YYDEBUG(984, *YYCURSOR);
#line 1334 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601date4 | iso8601date2 | iso8601dateslash | dateslash");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 19341 "lib/parse_date.c"
yy985:
	YYDEBUG(985, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy984;
		if (yych <= '1') goto yy986;
		if (yych <= 'm') goto yy984;
		goto yy1054;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy984;
			goto yy1054;
		} else {
			if (yych <= 's') goto yy1055;
			if (yych <= 't') goto yy1056;
			goto yy984;
		}
	}
yy986:
	YYDEBUG(986, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy1054;
		goto yy984;
	} else {
		if (yych <= 'r') goto yy1054;
		if (yych <= 's') goto yy1055;
		if (yych <= 't') goto yy1056;
		goto yy984;
	}
yy987:
	YYDEBUG(987, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1057;
	if (yych <= '3') goto yy1058;
	if (yych <= '9') goto yy986;
	goto yy53;
yy988:
	YYDEBUG(988, *YYCURSOR);
	yyaccept = 28;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych <= 'X') {
		if (yych <= 'G') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy180;
				if (yych >= ' ') goto yy180;
			} else {
				if (yych <= 'D') {
					if (yych >= 'D') goto yy182;
				} else {
					if (yych == 'F') goto yy183;
				}
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'L') {
					if (yych <= 'H') goto yy71;
				} else {
					if (yych <= 'M') goto yy184;
					if (yych >= 'S') goto yy185;
				}
			} else {
				if (yych <= 'U') {
					if (yych <= 'T') goto yy1059;
					goto yy80;
				} else {
					if (yych == 'W') goto yy82;
				}
			}
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'f') {
				if (yych <= 'c') {
					if (yych <= 'Y') goto yy84;
				} else {
					if (yych <= 'd') goto yy182;
					if (yych >= 'f') goto yy183;
				}
			} else {
				if (yych <= 'h') {
					if (yych >= 'h') goto yy71;
				} else {
					if (yych == 'm') goto yy184;
				}
			}
		} else {
			if (yych <= 'w') {
				if (yych <= 't') {
					if (yych <= 's') goto yy185;
					goto yy1060;
				} else {
					if (yych <= 'u') goto yy80;
					if (yych >= 'w') goto yy82;
				}
			} else {
				if (yych <= 'y') {
					if (yych >= 'y') goto yy84;
				} else {
					if (yych == 0xC2) goto yy89;
				}
			}
		}
	}
yy989:
	YYDEBUG(989, *YYCURSOR);
#line 1495 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("datenocolon");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_DATE_NOCOLON;
	}
#line 19465 "lib/parse_date.c"
yy990:
	YYDEBUG(990, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1061;
	if (yych <= '3') goto yy1062;
	goto yy53;
yy991:
	YYDEBUG(991, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy749;
	if (yych == 'l') goto yy749;
	goto yy53;
yy992:
	YYDEBUG(992, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1063;
	if (yych == 's') goto yy1063;
	goto yy53;
yy993:
	YYDEBUG(993, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy997;
	if (yych == 'm') goto yy997;
	goto yy53;
yy994:
	YYDEBUG(994, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'U') goto yy995;
	if (yych != 'u') goto yy53;
yy995:
	YYDEBUG(995, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1064;
	if (yych == 'a') goto yy1064;
	goto yy53;
yy996:
	YYDEBUG(996, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy749;
	if (yych == 'h') goto yy749;
	goto yy53;
yy997:
	YYDEBUG(997, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'B') goto yy1065;
	if (yych == 'b') goto yy1065;
	goto yy53;
yy998:
	YYDEBUG(998, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych >= '8') goto yy53;
yy999:
	YYDEBUG(999, *YYCURSOR);
	++YYCURSOR;
#line 1547 "lib/parse_date.re"
	{
		timelib_sll w, d;
		DEBUG_OUTPUT("isoweekday");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		TIMELIB_HAVE_RELATIVE();

		s->time->y = timelib_get_nr((char **) &ptr, 4);
		w = timelib_get_nr((char **) &ptr, 2);
		d = timelib_get_nr((char **) &ptr, 1);
		s->time->m = 1;
		s->time->d = 1;
		s->time->relative.d = timelib_daynr_from_weeknr(s->time->y, w, d);

		TIMELIB_DEINIT;
		return TIMELIB_ISO_WEEK;
	}
#line 19540 "lib/parse_date.c"
yy1000:
	YYDEBUG(1000, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1066;
	if (yych == 'h') goto yy1066;
	goto yy53;
yy1001:
	YYDEBUG(1001, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1067;
	if (yych == 'c') goto yy1067;
	goto yy53;
yy1002:
	YYDEBUG(1002, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1068;
	goto yy53;
yy1003:
	YYDEBUG(1003, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1069;
	goto yy53;
yy1004:
	YYDEBUG(1004, *YYCURSOR);
	yyaccept = 26;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'q') {
		if (yych == 'n') goto yy703;
		goto yy966;
	} else {
		if (yych <= 'r') goto yy703;
		if (yych <= 's') goto yy704;
		if (yych <= 't') goto yy705;
		goto yy966;
	}
yy1005:
	YYDEBUG(1005, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1070;
	goto yy53;
yy1006:
	YYDEBUG(1006, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1070;
	goto yy53;
yy1007:
	YYDEBUG(1007, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1071;
	goto yy53;
yy1008:
	YYDEBUG(1008, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1009;
	if (yych <= '9') goto yy1072;
yy1009:
	YYDEBUG(1009, *YYCURSOR);
#line 1585 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextshort");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 19616 "lib/parse_date.c"
yy1010:
	YYDEBUG(1010, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1073;
	if (yych <= '2') goto yy1075;
	if (yych <= '9') goto yy1076;
	goto yy53;
yy1011:
	YYDEBUG(1011, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'E') {
		if (yych <= 'C') goto yy53;
		if (yych <= 'D') goto yy1032;
		goto yy1077;
	} else {
		if (yych <= 'c') goto yy53;
		if (yych <= 'd') goto yy1032;
		if (yych <= 'e') goto yy1077;
		goto yy53;
	}
yy1012:
	YYDEBUG(1012, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy804;
	if (yych <= '9') goto yy1078;
	goto yy804;
yy1013:
	YYDEBUG(1013, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1078;
	goto yy804;
yy1014:
	YYDEBUG(1014, *YYCURSOR);
	++YYCURSOR;
	goto yy804;
yy1015:
	YYDEBUG(1015, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy804;
	if (yych <= '9') goto yy1079;
	goto yy804;
yy1016:
	YYDEBUG(1016, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1079;
	goto yy804;
yy1017:
	YYDEBUG(1017, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1017;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy1017;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy1018;
			if (yych != 'p') goto yy53;
		}
	}
yy1018:
	YYDEBUG(1018, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1080;
		goto yy53;
	} else {
		if (yych <= 'M') goto yy1081;
		if (yych == 'm') goto yy1081;
		goto yy53;
	}
yy1019:
	YYDEBUG(1019, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1082;
	if (yych == 's') goto yy1082;
	goto yy926;
yy1020:
	YYDEBUG(1020, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1083;
	if (yych == 't') goto yy1083;
	goto yy53;
yy1021:
	YYDEBUG(1021, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1084;
		if (yych <= 0x1F) goto yy926;
		goto yy1084;
	} else {
		if (yych <= 'D') {
			if (yych <= 'C') goto yy926;
			goto yy1085;
		} else {
			if (yych == 'd') goto yy1085;
			goto yy926;
		}
	}
yy1022:
	YYDEBUG(1022, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1019;
	if (yych == 'r') goto yy1019;
	goto yy53;
yy1023:
	YYDEBUG(1023, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1086;
	if (yych == 'r') goto yy1086;
	goto yy53;
yy1024:
	YYDEBUG(1024, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'L') goto yy1087;
	if (yych == 'l') goto yy1087;
	goto yy53;
yy1025:
	YYDEBUG(1025, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'U') {
		if (yych == 'S') goto yy1082;
		if (yych <= 'T') goto yy926;
		goto yy1088;
	} else {
		if (yych <= 's') {
			if (yych <= 'r') goto yy926;
			goto yy1082;
		} else {
			if (yych == 'u') goto yy1088;
			goto yy926;
		}
	}
yy1026:
	YYDEBUG(1026, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'D') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1084;
			goto yy926;
		} else {
			if (yych <= ' ') goto yy1084;
			if (yych <= 'C') goto yy926;
			goto yy1085;
		}
	} else {
		if (yych <= 'c') {
			if (yych == 'T') goto yy1089;
			goto yy926;
		} else {
			if (yych <= 'd') goto yy1085;
			if (yych == 't') goto yy1089;
			goto yy926;
		}
	}
yy1027:
	YYDEBUG(1027, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1019;
	if (yych == 'c') goto yy1019;
	goto yy53;
yy1028:
	YYDEBUG(1028, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1084;
		if (yych <= 0x1F) goto yy926;
		goto yy1084;
	} else {
		if (yych <= 'U') {
			if (yych <= 'T') goto yy926;
			goto yy1090;
		} else {
			if (yych == 'u') goto yy1090;
			goto yy926;
		}
	}
yy1029:
	YYDEBUG(1029, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'O') goto yy1091;
		if (yych <= 'R') goto yy926;
		goto yy1082;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy926;
			goto yy1091;
		} else {
			if (yych == 's') goto yy1082;
			goto yy926;
		}
	}
yy1030:
	YYDEBUG(1030, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1084;
		if (yych <= 0x1F) goto yy926;
		goto yy1084;
	} else {
		if (yych <= 'R') {
			if (yych <= 'Q') goto yy926;
			goto yy1092;
		} else {
			if (yych == 'r') goto yy1092;
			goto yy926;
		}
	}
yy1031:
	YYDEBUG(1031, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1084;
		if (yych <= 0x1F) goto yy926;
		goto yy1084;
	} else {
		if (yych <= 'S') {
			if (yych <= 'R') goto yy926;
			goto yy1093;
		} else {
			if (yych == 's') goto yy1093;
			goto yy926;
		}
	}
yy1032:
	YYDEBUG(1032, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ' ') {
		if (yych == '\t') goto yy1084;
		if (yych <= 0x1F) goto yy926;
		goto yy1084;
	} else {
		if (yych <= 'N') {
			if (yych <= 'M') goto yy926;
			goto yy1094;
		} else {
			if (yych == 'n') goto yy1094;
			goto yy926;
		}
	}
yy1033:
	YYDEBUG(1033, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1095;
	if (yych == 'k') goto yy1095;
	goto yy53;
yy1034:
	YYDEBUG(1034, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'R') {
		if (yych == ' ') goto yy1097;
		goto yy926;
	} else {
		if (yych <= 'S') goto yy1082;
		if (yych == 's') goto yy1082;
		goto yy926;
	}
yy1035:
	YYDEBUG(1035, *YYCURSOR);
	++YYCURSOR;
	goto yy685;
yy1036:
	YYDEBUG(1036, *YYCURSOR);
	yyaccept = 17;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy275;
		goto yy685;
	} else {
		if (yych <= '/') goto yy275;
		if (yych == '_') goto yy275;
		goto yy685;
	}
yy1037:
	YYDEBUG(1037, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy666;
	if (yych == ' ') goto yy666;
	goto yy53;
yy1038:
	YYDEBUG(1038, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy666;
	if (yych == ' ') goto yy666;
	goto yy904;
yy1039:
	YYDEBUG(1039, *YYCURSOR);
	++YYCURSOR;
yy1040:
	YYDEBUG(1040, *YYCURSOR);
#line 1061 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("tomorrow");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = 1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 19939 "lib/parse_date.c"
yy1041:
	YYDEBUG(1041, *YYCURSOR);
	yyaccept = 29;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy275;
		goto yy1040;
	} else {
		if (yych <= '/') goto yy275;
		if (yych == '_') goto yy275;
		goto yy1040;
	}
yy1042:
	YYDEBUG(1042, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1098;
	if (yych == 'y') goto yy1098;
	goto yy53;
yy1043:
	YYDEBUG(1043, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1098;
	if (yych == 'y') goto yy1100;
	goto yy904;
yy1044:
	YYDEBUG(1044, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1101;
	if (yych <= '3') goto yy1102;
	goto yy53;
yy1045:
	YYDEBUG(1045, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy1103;
	goto yy53;
yy1046:
	YYDEBUG(1046, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1104;
	goto yy181;
yy1047:
	YYDEBUG(1047, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1105;
	goto yy53;
yy1048:
	YYDEBUG(1048, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1106;
	if (yych <= '2') goto yy1107;
	if (yych <= '9') goto yy1108;
	goto yy53;
yy1049:
	YYDEBUG(1049, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1109;
	goto yy53;
yy1050:
	YYDEBUG(1050, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1109;
	goto yy53;
yy1051:
	YYDEBUG(1051, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1109;
	goto yy53;
yy1052:
	YYDEBUG(1052, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '9') {
			if (yych <= '/') goto yy536;
			goto yy1110;
		} else {
			if (yych == 'T') goto yy1048;
			goto yy536;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1049;
			if (yych <= 'q') goto yy536;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy1050;
			if (yych <= 't') goto yy1051;
			goto yy536;
		}
	}
yy1053:
	YYDEBUG(1053, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'm') {
		if (yych <= '1') {
			if (yych <= '/') goto yy536;
			goto yy1110;
		} else {
			if (yych == 'T') goto yy1048;
			goto yy536;
		}
	} else {
		if (yych <= 'r') {
			if (yych <= 'n') goto yy1049;
			if (yych <= 'q') goto yy536;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy1050;
			if (yych <= 't') goto yy1051;
			goto yy536;
		}
	}
yy1054:
	YYDEBUG(1054, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'd') goto yy1111;
	goto yy53;
yy1055:
	YYDEBUG(1055, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 't') goto yy1111;
	goto yy53;
yy1056:
	YYDEBUG(1056, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'h') goto yy1111;
	goto yy53;
yy1057:
	YYDEBUG(1057, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy984;
		if (yych <= '9') goto yy1112;
		if (yych <= 'm') goto yy984;
		goto yy1054;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy984;
			goto yy1054;
		} else {
			if (yych <= 's') goto yy1055;
			if (yych <= 't') goto yy1056;
			goto yy984;
		}
	}
yy1058:
	YYDEBUG(1058, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych <= '/') goto yy984;
		if (yych <= '1') goto yy1112;
		if (yych <= 'm') goto yy984;
		goto yy1054;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy984;
			goto yy1054;
		} else {
			if (yych <= 's') goto yy1055;
			if (yych <= 't') goto yy1056;
			goto yy984;
		}
	}
yy1059:
	YYDEBUG(1059, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1113;
			goto yy1114;
		} else {
			if (yych <= '9') goto yy1115;
			if (yych <= 'G') goto yy53;
			goto yy249;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy250;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy249;
			if (yych == 'u') goto yy250;
			goto yy53;
		}
	}
yy1060:
	YYDEBUG(1060, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'H') {
		if (yych <= '2') {
			if (yych <= '/') goto yy53;
			if (yych <= '1') goto yy1116;
			goto yy1117;
		} else {
			if (yych <= '9') goto yy1118;
			if (yych <= 'G') goto yy53;
			goto yy249;
		}
	} else {
		if (yych <= 'g') {
			if (yych == 'U') goto yy250;
			goto yy53;
		} else {
			if (yych <= 'h') goto yy249;
			if (yych == 'u') goto yy250;
			goto yy53;
		}
	}
yy1061:
	YYDEBUG(1061, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1119;
	goto yy53;
yy1062:
	YYDEBUG(1062, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1119;
	goto yy53;
yy1063:
	YYDEBUG(1063, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy749;
	if (yych == 't') goto yy749;
	goto yy53;
yy1064:
	YYDEBUG(1064, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1120;
	if (yych == 'r') goto yy1120;
	goto yy53;
yy1065:
	YYDEBUG(1065, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1121;
	if (yych == 'e') goto yy1121;
	goto yy53;
yy1066:
	YYDEBUG(1066, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy399;
	if (yych == 't') goto yy399;
	goto yy53;
yy1067:
	YYDEBUG(1067, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy597;
	if (yych == 'o') goto yy597;
	goto yy53;
yy1068:
	YYDEBUG(1068, *YYCURSOR);
	yyaccept = 5;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy203;
			goto yy1068;
		} else {
			if (yych == 'A') goto yy1122;
			goto yy203;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1122;
			if (yych <= '`') goto yy203;
			goto yy1122;
		} else {
			if (yych == 'p') goto yy1122;
			goto yy203;
		}
	}
yy1069:
	YYDEBUG(1069, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'O') {
		if (yych <= '9') {
			if (yych <= '/') goto yy53;
			goto yy1069;
		} else {
			if (yych == 'A') goto yy1122;
			goto yy53;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= 'P') goto yy1122;
			if (yych <= '`') goto yy53;
			goto yy1122;
		} else {
			if (yych == 'p') goto yy1122;
			goto yy53;
		}
	}
yy1070:
	YYDEBUG(1070, *YYCURSOR);
	++YYCURSOR;
#line 1599 "lib/parse_date.re"
	{
		int length = 0;
		DEBUG_OUTPUT("pgtextreverse");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr_ex((char **) &ptr, 4, &length);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_PROCESS_YEAR(s->time->y, length);
		TIMELIB_DEINIT;
		return TIMELIB_PG_TEXT;
	}
#line 20265 "lib/parse_date.c"
yy1071:
	YYDEBUG(1071, *YYCURSOR);
	++YYCURSOR;
#line 1099 "lib/parse_date.re"
	{
		timelib_ull i, us;

		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_DATE();
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TZ();

		i = timelib_get_unsigned_nr((char **) &ptr, 24);
		us = timelib_get_unsigned_nr((char **) &ptr, 24);
		s->time->y = 1970;
		s->time->m = 1;
		s->time->d = 1;
		s->time->h = s->time->i = s->time->s = 0;
		s->time->us = 0;
		s->time->relative.s += i;
		s->time->relative.us = us;
		s->time->is_localtime = 1;
		s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
		s->time->z = 0;
		s->time->dst = 0;

		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20296 "lib/parse_date.c"
yy1072:
	YYDEBUG(1072, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1009;
	if (yych <= '9') goto yy1123;
	goto yy1009;
yy1073:
	YYDEBUG(1073, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1124;
		} else {
			if (yych <= ' ') goto yy1124;
			if (yych <= '/') goto yy1074;
			if (yych <= '9') goto yy1076;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1125;
			if (yych == 'P') goto yy1125;
		} else {
			if (yych <= 'a') goto yy1125;
			if (yych == 'p') goto yy1125;
		}
	}
yy1074:
	YYDEBUG(1074, *YYCURSOR);
#line 1144 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("backof | frontof");
		TIMELIB_INIT;
		TIMELIB_UNHAVE_TIME();
		TIMELIB_HAVE_TIME();

		if (*ptr == 'b') {
			s->time->h = timelib_get_nr((char **) &ptr, 2);
			s->time->i = 15;
		} else {
			s->time->h = timelib_get_nr((char **) &ptr, 2) - 1;
			s->time->i = 45;
		}
		if (*ptr != '\0' ) {
			timelib_eat_spaces((char **) &ptr);
			s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 20348 "lib/parse_date.c"
yy1075:
	YYDEBUG(1075, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '@') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1124;
			goto yy1074;
		} else {
			if (yych <= ' ') goto yy1124;
			if (yych <= '/') goto yy1074;
			if (yych >= '5') goto yy1074;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'A') goto yy1125;
			if (yych == 'P') goto yy1125;
			goto yy1074;
		} else {
			if (yych <= 'a') goto yy1125;
			if (yych == 'p') goto yy1125;
			goto yy1074;
		}
	}
yy1076:
	YYDEBUG(1076, *YYCURSOR);
	yyaccept = 30;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1124;
			goto yy1074;
		} else {
			if (yych <= ' ') goto yy1124;
			if (yych <= '@') goto yy1074;
			goto yy1125;
		}
	} else {
		if (yych <= '`') {
			if (yych == 'P') goto yy1125;
			goto yy1074;
		} else {
			if (yych <= 'a') goto yy1125;
			if (yych == 'p') goto yy1125;
			goto yy1074;
		}
	}
yy1077:
	YYDEBUG(1077, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'K') goto yy1126;
	if (yych == 'k') goto yy1126;
	goto yy53;
yy1078:
	YYDEBUG(1078, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1128;
			goto yy804;
		} else {
			if (yych <= ' ') goto yy1128;
			if (yych == '(') goto yy1128;
			goto yy804;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy804;
			if (yych <= '-') goto yy1128;
			goto yy804;
		} else {
			if (yych <= 'Z') goto yy1128;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1128;
			goto yy804;
		}
	}
yy1079:
	YYDEBUG(1079, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '*') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1135;
			goto yy804;
		} else {
			if (yych <= ' ') goto yy1135;
			if (yych == '(') goto yy1135;
			goto yy804;
		}
	} else {
		if (yych <= '@') {
			if (yych == ',') goto yy804;
			if (yych <= '-') goto yy1135;
			goto yy804;
		} else {
			if (yych <= 'Z') goto yy1135;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1135;
			goto yy804;
		}
	}
yy1080:
	YYDEBUG(1080, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1081;
	if (yych != 'm') goto yy53;
yy1081:
	YYDEBUG(1081, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1138;
		if (yych == '\t') goto yy1138;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy1138;
		if (yych == '.') goto yy1139;
		goto yy53;
	}
yy1082:
	YYDEBUG(1082, *YYCURSOR);
	++YYCURSOR;
	goto yy926;
yy1083:
	YYDEBUG(1083, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'N') {
		if (yych == 'H') goto yy1140;
		if (yych <= 'M') goto yy53;
		goto yy1141;
	} else {
		if (yych <= 'h') {
			if (yych <= 'g') goto yy53;
			goto yy1140;
		} else {
			if (yych == 'n') goto yy1141;
			goto yy53;
		}
	}
yy1084:
	YYDEBUG(1084, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 2) YYFILL(2);
	yych = *YYCURSOR;
	if (yych <= ' ') {
		if (yych == '\t') goto yy1084;
		if (yych <= 0x1F) goto yy53;
		goto yy1084;
	} else {
		if (yych <= 'O') {
			if (yych <= 'N') goto yy53;
			goto yy1142;
		} else {
			if (yych == 'o') goto yy1142;
			goto yy53;
		}
	}
yy1085:
	YYDEBUG(1085, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'A') goto yy1143;
	if (yych == 'a') goto yy1143;
	goto yy53;
yy1086:
	YYDEBUG(1086, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1144;
	if (yych == 'o') goto yy1144;
	goto yy53;
yy1087:
	YYDEBUG(1087, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1144;
	if (yych == 'i') goto yy1144;
	goto yy53;
yy1088:
	YYDEBUG(1088, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1145;
	if (yych == 't') goto yy1145;
	goto yy53;
yy1089:
	YYDEBUG(1089, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1019;
	if (yych == 'h') goto yy1019;
	goto yy53;
yy1090:
	YYDEBUG(1090, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy1093;
	if (yych == 'r') goto yy1093;
	goto yy53;
yy1091:
	YYDEBUG(1091, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1146;
	if (yych == 'n') goto yy1146;
	goto yy53;
yy1092:
	YYDEBUG(1092, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1093;
	if (yych != 's') goto yy53;
yy1093:
	YYDEBUG(1093, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1085;
	if (yych == 'd') goto yy1085;
	goto yy53;
yy1094:
	YYDEBUG(1094, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1092;
	if (yych == 'e') goto yy1092;
	goto yy53;
yy1095:
	YYDEBUG(1095, *YYCURSOR);
	yyaccept = 31;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'S') {
		if (yych == 'D') goto yy811;
		if (yych >= 'S') goto yy1082;
	} else {
		if (yych <= 'd') {
			if (yych >= 'd') goto yy811;
		} else {
			if (yych == 's') goto yy1082;
		}
	}
yy1096:
	YYDEBUG(1096, *YYCURSOR);
#line 1682 "lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("relativetextweek");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		while(*ptr) {
			i = timelib_get_relative_text((char **) &ptr, &behavior);
			timelib_eat_spaces((char **) &ptr);
			timelib_set_relative((char **) &ptr, i, behavior, s);
			s->time->relative.weekday_behavior = 2;

			/* to handle the format weekday + last/this/next week */
			if (s->time->relative.have_weekday_relative == 0) {
				TIMELIB_HAVE_WEEKDAY_RELATIVE();
				s->time->relative.weekday = 1;
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20605 "lib/parse_date.c"
yy1097:
	YYDEBUG(1097, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1147;
	if (yych == 'o') goto yy1147;
	goto yy53;
yy1098:
	YYDEBUG(1098, *YYCURSOR);
	++YYCURSOR;
yy1099:
	YYDEBUG(1099, *YYCURSOR);
#line 1018 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("yesterday");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_UNHAVE_TIME();

		s->time->relative.d = -1;
		TIMELIB_DEINIT;
		return TIMELIB_RELATIVE;
	}
#line 20628 "lib/parse_date.c"
yy1100:
	YYDEBUG(1100, *YYCURSOR);
	yyaccept = 32;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yybm[0+yych] & 128) {
		goto yy903;
	}
	if (yych <= '.') {
		if (yych == '-') goto yy275;
		goto yy1099;
	} else {
		if (yych <= '/') goto yy275;
		if (yych == '_') goto yy275;
		goto yy1099;
	}
yy1101:
	YYDEBUG(1101, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1111;
	goto yy53;
yy1102:
	YYDEBUG(1102, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1111;
	goto yy53;
yy1103:
	YYDEBUG(1103, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '2') goto yy1148;
	if (yych <= '3') goto yy1149;
	goto yy53;
yy1104:
	YYDEBUG(1104, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1150;
	goto yy181;
yy1105:
	YYDEBUG(1105, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1151;
	goto yy53;
yy1106:
	YYDEBUG(1106, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1108;
	if (yych <= ':') goto yy1152;
	goto yy53;
yy1107:
	YYDEBUG(1107, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '4') goto yy1108;
	if (yych == ':') goto yy1152;
	goto yy53;
yy1108:
	YYDEBUG(1108, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1152;
	goto yy53;
yy1109:
	YYDEBUG(1109, *YYCURSOR);
	yyaccept = 16;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == 'T') goto yy1048;
	goto yy536;
yy1110:
	YYDEBUG(1110, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == 'T') goto yy1153;
		if (yych <= 'm') goto yy984;
		goto yy1049;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy984;
			goto yy1049;
		} else {
			if (yych <= 's') goto yy1050;
			if (yych <= 't') goto yy1051;
			goto yy984;
		}
	}
yy1111:
	YYDEBUG(1111, *YYCURSOR);
	++YYCURSOR;
	goto yy984;
yy1112:
	YYDEBUG(1112, *YYCURSOR);
	yyaccept = 27;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'n') {
		if (yych == '/') goto yy1111;
		if (yych <= 'm') goto yy984;
		goto yy1054;
	} else {
		if (yych <= 'r') {
			if (yych <= 'q') goto yy984;
			goto yy1054;
		} else {
			if (yych <= 's') goto yy1055;
			if (yych <= 't') goto yy1056;
			goto yy984;
		}
	}
yy1113:
	YYDEBUG(1113, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1154;
	if (yych <= '9') goto yy1115;
	if (yych <= ':') goto yy1155;
	goto yy53;
yy1114:
	YYDEBUG(1114, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy53;
		if (yych <= '4') goto yy1154;
		goto yy1156;
	} else {
		if (yych == ':') goto yy1155;
		goto yy53;
	}
yy1115:
	YYDEBUG(1115, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1156;
	if (yych == ':') goto yy1155;
	goto yy53;
yy1116:
	YYDEBUG(1116, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1157;
	if (yych <= '9') goto yy1118;
	goto yy53;
yy1117:
	YYDEBUG(1117, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '4') goto yy1157;
	if (yych <= '5') goto yy1156;
	goto yy53;
yy1118:
	YYDEBUG(1118, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1156;
	goto yy53;
yy1119:
	YYDEBUG(1119, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ' ') goto yy1158;
	goto yy53;
yy1120:
	YYDEBUG(1120, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy749;
	if (yych == 'y') goto yy749;
	goto yy53;
yy1121:
	YYDEBUG(1121, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'R') goto yy749;
	if (yych == 'r') goto yy749;
	goto yy53;
yy1122:
	YYDEBUG(1122, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1159;
		goto yy53;
	} else {
		if (yych <= 'M') goto yy1160;
		if (yych == 'm') goto yy1160;
		goto yy53;
	}
yy1123:
	YYDEBUG(1123, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1009;
	if (yych <= '9') goto yy1161;
	goto yy1009;
yy1124:
	YYDEBUG(1124, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 5) YYFILL(5);
	yych = *YYCURSOR;
	if (yych <= 'A') {
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy1124;
			goto yy53;
		} else {
			if (yych <= ' ') goto yy1124;
			if (yych <= '@') goto yy53;
		}
	} else {
		if (yych <= '`') {
			if (yych != 'P') goto yy53;
		} else {
			if (yych <= 'a') goto yy1125;
			if (yych != 'p') goto yy53;
		}
	}
yy1125:
	YYDEBUG(1125, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == '.') goto yy1162;
		goto yy53;
	} else {
		if (yych <= 'M') goto yy1163;
		if (yych == 'm') goto yy1163;
		goto yy53;
	}
yy1126:
	YYDEBUG(1126, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == 'D') goto yy811;
		if (yych <= 'R') goto yy53;
		goto yy1082;
	} else {
		if (yych <= 'd') {
			if (yych <= 'c') goto yy53;
			goto yy811;
		} else {
			if (yych == 's') goto yy1082;
			goto yy53;
		}
	}
yy1127:
	YYDEBUG(1127, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1128:
	YYDEBUG(1128, *YYCURSOR);
	if (yych <= '+') {
		if (yych <= ' ') {
			if (yych == '\t') goto yy1127;
			if (yych <= 0x1F) goto yy53;
			goto yy1127;
		} else {
			if (yych == '(') goto yy1129;
			if (yych <= '*') goto yy53;
			goto yy1130;
		}
	} else {
		if (yych <= 'F') {
			if (yych == '-') goto yy1130;
			if (yych <= '@') goto yy53;
			goto yy1131;
		} else {
			if (yych <= 'Z') {
				if (yych <= 'G') goto yy1132;
				goto yy1131;
			} else {
				if (yych <= '`') goto yy53;
				if (yych <= 'z') goto yy1133;
				goto yy53;
			}
		}
	}
yy1129:
	YYDEBUG(1129, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy1133;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy1133;
	goto yy53;
yy1130:
	YYDEBUG(1130, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1164;
	if (yych <= '2') goto yy1165;
	if (yych <= '9') goto yy1166;
	goto yy53;
yy1131:
	YYDEBUG(1131, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1014;
		goto yy804;
	} else {
		if (yych <= 'Z') goto yy1167;
		if (yych <= '`') goto yy804;
		if (yych <= 'z') goto yy1168;
		goto yy804;
	}
yy1132:
	YYDEBUG(1132, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'L') {
		if (yych == ')') goto yy1014;
		if (yych <= '@') goto yy804;
		goto yy1167;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'M') goto yy1169;
			goto yy1167;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1168;
			goto yy804;
		}
	}
yy1133:
	YYDEBUG(1133, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1014;
		goto yy804;
	} else {
		if (yych <= 'Z') goto yy1167;
		if (yych <= '`') goto yy804;
		if (yych <= 'z') goto yy1167;
		goto yy804;
	}
yy1134:
	YYDEBUG(1134, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
yy1135:
	YYDEBUG(1135, *YYCURSOR);
	if (yych <= '@') {
		if (yych <= '\'') {
			if (yych <= '\t') {
				if (yych <= 0x08) goto yy53;
				goto yy1134;
			} else {
				if (yych == ' ') goto yy1134;
				goto yy53;
			}
		} else {
			if (yych <= '+') {
				if (yych <= '(') goto yy1129;
				if (yych <= '*') goto yy53;
				goto yy1130;
			} else {
				if (yych == '-') goto yy1130;
				goto yy53;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= 'G') {
				if (yych <= 'A') goto yy1136;
				if (yych <= 'F') goto yy1131;
				goto yy1132;
			} else {
				if (yych != 'P') goto yy1131;
			}
		} else {
			if (yych <= 'o') {
				if (yych <= '`') goto yy53;
				if (yych <= 'a') goto yy1137;
				goto yy1133;
			} else {
				if (yych <= 'p') goto yy1137;
				if (yych <= 'z') goto yy1133;
				goto yy53;
			}
		}
	}
yy1136:
	YYDEBUG(1136, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1014;
			goto yy804;
		} else {
			if (yych <= '.') goto yy1080;
			if (yych <= '@') goto yy804;
			goto yy1167;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1170;
			if (yych <= 'Z') goto yy1167;
			goto yy804;
		} else {
			if (yych == 'm') goto yy1171;
			if (yych <= 'z') goto yy1168;
			goto yy804;
		}
	}
yy1137:
	YYDEBUG(1137, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'L') {
		if (yych <= '-') {
			if (yych == ')') goto yy1014;
			goto yy804;
		} else {
			if (yych <= '.') goto yy1080;
			if (yych <= '@') goto yy804;
			goto yy1167;
		}
	} else {
		if (yych <= '`') {
			if (yych <= 'M') goto yy1170;
			if (yych <= 'Z') goto yy1167;
			goto yy804;
		} else {
			if (yych == 'm') goto yy1170;
			if (yych <= 'z') goto yy1167;
			goto yy804;
		}
	}
yy1138:
	YYDEBUG(1138, *YYCURSOR);
	++YYCURSOR;
#line 1747 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("dateshortwithtimeshort12 | dateshortwithtimelong12");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->d = timelib_get_nr((char **) &ptr, 2);

		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}

		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_SHORTDATE_WITH_TIME;
	}
#line 21079 "lib/parse_date.c"
yy1139:
	YYDEBUG(1139, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1138;
		if (yych <= 0x08) goto yy53;
		goto yy1138;
	} else {
		if (yych == ' ') goto yy1138;
		goto yy53;
	}
yy1140:
	YYDEBUG(1140, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'N') goto yy1141;
	if (yych != 'n') goto yy53;
yy1141:
	YYDEBUG(1141, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'I') goto yy1172;
	if (yych == 'i') goto yy1172;
	goto yy53;
yy1142:
	YYDEBUG(1142, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1173;
	if (yych == 'f') goto yy1173;
	goto yy53;
yy1143:
	YYDEBUG(1143, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'Y') goto yy1174;
	if (yych == 'y') goto yy1174;
	goto yy53;
yy1144:
	YYDEBUG(1144, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'S') goto yy1175;
	if (yych == 's') goto yy1175;
	goto yy53;
yy1145:
	YYDEBUG(1145, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1019;
	if (yych == 'e') goto yy1019;
	goto yy53;
yy1146:
	YYDEBUG(1146, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'D') goto yy1019;
	if (yych == 'd') goto yy1019;
	goto yy53;
yy1147:
	YYDEBUG(1147, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'F') goto yy1176;
	if (yych == 'f') goto yy1176;
	goto yy53;
yy1148:
	YYDEBUG(1148, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1177;
	goto yy53;
yy1149:
	YYDEBUG(1149, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1177;
	goto yy53;
yy1150:
	YYDEBUG(1150, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1178;
	goto yy181;
yy1151:
	YYDEBUG(1151, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1179;
	if (yych <= '2') goto yy1180;
	goto yy53;
yy1152:
	YYDEBUG(1152, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1181;
	if (yych <= '9') goto yy1182;
	goto yy53;
yy1153:
	YYDEBUG(1153, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1183;
	if (yych <= '2') goto yy1184;
	if (yych <= '9') goto yy1108;
	goto yy53;
yy1154:
	YYDEBUG(1154, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1185;
	if (yych <= '9') goto yy1186;
	if (yych >= ';') goto yy53;
yy1155:
	YYDEBUG(1155, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1187;
	goto yy53;
yy1156:
	YYDEBUG(1156, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1186;
	goto yy53;
yy1157:
	YYDEBUG(1157, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1185;
	if (yych <= '9') goto yy1186;
	goto yy53;
yy1158:
	YYDEBUG(1158, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1188;
	if (yych <= '2') goto yy1189;
	goto yy53;
yy1159:
	YYDEBUG(1159, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1160;
	if (yych != 'm') goto yy53;
yy1160:
	YYDEBUG(1160, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1190;
		if (yych == '\t') goto yy1190;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy1190;
		if (yych == '.') goto yy1191;
		goto yy53;
	}
yy1161:
	YYDEBUG(1161, *YYCURSOR);
	++YYCURSOR;
	goto yy1009;
yy1162:
	YYDEBUG(1162, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1163;
	if (yych != 'm') goto yy53;
yy1163:
	YYDEBUG(1163, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 0x1F) {
		if (yych <= 0x00) goto yy1192;
		if (yych == '\t') goto yy1192;
		goto yy53;
	} else {
		if (yych <= ' ') goto yy1192;
		if (yych == '.') goto yy1193;
		goto yy53;
	}
yy1164:
	YYDEBUG(1164, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy804;
	if (yych <= '9') goto yy1166;
	if (yych <= ':') goto yy1194;
	goto yy804;
yy1165:
	YYDEBUG(1165, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy804;
		if (yych >= '5') goto yy1195;
	} else {
		if (yych <= '9') goto yy1014;
		if (yych <= ':') goto yy1194;
		goto yy804;
	}
yy1166:
	YYDEBUG(1166, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy804;
	if (yych <= '5') goto yy1195;
	if (yych <= '9') goto yy1014;
	if (yych <= ':') goto yy1194;
	goto yy804;
yy1167:
	YYDEBUG(1167, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1014;
		goto yy804;
	} else {
		if (yych <= 'Z') goto yy1196;
		if (yych <= '`') goto yy804;
		if (yych <= 'z') goto yy1196;
		goto yy804;
	}
yy1168:
	YYDEBUG(1168, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1014;
			goto yy804;
		} else {
			if (yych == '.') goto yy804;
			goto yy1197;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy1196;
			goto yy804;
		} else {
			if (yych <= '_') goto yy1197;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1198;
			goto yy804;
		}
	}
yy1169:
	YYDEBUG(1169, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= 'S') {
		if (yych == ')') goto yy1014;
		if (yych <= '@') goto yy804;
		goto yy1196;
	} else {
		if (yych <= 'Z') {
			if (yych <= 'T') goto yy1199;
			goto yy1196;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1196;
			goto yy804;
		}
	}
yy1170:
	YYDEBUG(1170, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ')') {
		if (yych <= '\t') {
			if (yych <= 0x00) goto yy1138;
			if (yych <= 0x08) goto yy804;
			goto yy1138;
		} else {
			if (yych == ' ') goto yy1138;
			if (yych <= '(') goto yy804;
			goto yy1014;
		}
	} else {
		if (yych <= '@') {
			if (yych == '.') goto yy1139;
			goto yy804;
		} else {
			if (yych <= 'Z') goto yy1196;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1196;
			goto yy804;
		}
	}
yy1171:
	YYDEBUG(1171, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '-') {
		if (yych <= 0x1F) {
			if (yych <= 0x00) goto yy1138;
			if (yych == '\t') goto yy1138;
			goto yy804;
		} else {
			if (yych <= '(') {
				if (yych <= ' ') goto yy1138;
				goto yy804;
			} else {
				if (yych <= ')') goto yy1014;
				if (yych <= ',') goto yy804;
				goto yy1197;
			}
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '.') goto yy1139;
			if (yych <= '/') goto yy1197;
			if (yych <= '@') goto yy804;
			goto yy1196;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy804;
				goto yy1197;
			} else {
				if (yych <= '`') goto yy804;
				if (yych <= 'z') goto yy1198;
				goto yy804;
			}
		}
	}
yy1172:
	YYDEBUG(1172, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'G') goto yy1200;
	if (yych == 'g') goto yy1200;
	goto yy53;
yy1173:
	YYDEBUG(1173, *YYCURSOR);
	++YYCURSOR;
#line 1167 "lib/parse_date.re"
	{
		timelib_sll i;
		int         behavior = 0;
		DEBUG_OUTPUT("weekdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();
		TIMELIB_HAVE_SPECIAL_RELATIVE();

		i = timelib_get_relative_text((char **) &ptr, &behavior);
		timelib_eat_spaces((char **) &ptr);
		if (i > 0) { /* first, second... etc */
			s->time->relative.special.type = TIMELIB_SPECIAL_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, 1, s);
		} else { /* last */
			s->time->relative.special.type = TIMELIB_SPECIAL_LAST_DAY_OF_WEEK_IN_MONTH;
			timelib_set_relative((char **) &ptr, i, behavior, s);
		}
		TIMELIB_DEINIT;
		return TIMELIB_WEEK_DAY_OF_MONTH;
	}
#line 21420 "lib/parse_date.c"
yy1174:
	YYDEBUG(1174, *YYCURSOR);
	yyaccept = 25;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '\t') goto yy1084;
	if (yych == ' ') goto yy1084;
	goto yy926;
yy1175:
	YYDEBUG(1175, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'E') goto yy1201;
	if (yych == 'e') goto yy1201;
	goto yy53;
yy1176:
	YYDEBUG(1176, *YYCURSOR);
	++YYCURSOR;
#line 1127 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("firstdayof | lastdayof");
		TIMELIB_INIT;
		TIMELIB_HAVE_RELATIVE();

		/* skip "last day of" or "first day of" */
		if (*ptr == 'l' || *ptr == 'L') {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_LAST_DAY_OF_MONTH;
		} else {
			s->time->relative.first_last_day_of = TIMELIB_SPECIAL_FIRST_DAY_OF_MONTH;
		}

		TIMELIB_DEINIT;
		return TIMELIB_LF_DAY_OF_MONTH;
	}
#line 21453 "lib/parse_date.c"
yy1177:
	YYDEBUG(1177, *YYCURSOR);
	++YYCURSOR;
#line 1360 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("iso8601datex");
		TIMELIB_INIT;
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_unsigned_nr((char **) &ptr, 19);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		TIMELIB_DEINIT;
		return TIMELIB_ISO_DATE;
	}
#line 21468 "lib/parse_date.c"
yy1178:
	YYDEBUG(1178, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1202;
	goto yy181;
yy1179:
	YYDEBUG(1179, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1203;
	goto yy53;
yy1180:
	YYDEBUG(1180, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '4') goto yy1203;
	goto yy53;
yy1181:
	YYDEBUG(1181, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1182;
	if (yych <= ':') goto yy1204;
	goto yy53;
yy1182:
	YYDEBUG(1182, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1204;
	goto yy53;
yy1183:
	YYDEBUG(1183, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1205;
	if (yych <= ':') goto yy1152;
	goto yy53;
yy1184:
	YYDEBUG(1184, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '4') goto yy1205;
	if (yych == ':') goto yy1152;
	goto yy53;
yy1185:
	YYDEBUG(1185, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1204;
	if (yych <= '6') goto yy1206;
	if (yych >= ':') goto yy53;
yy1186:
	YYDEBUG(1186, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1207;
	if (yych <= '6') goto yy1208;
	goto yy53;
yy1187:
	YYDEBUG(1187, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1209;
	goto yy53;
yy1188:
	YYDEBUG(1188, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1210;
	goto yy53;
yy1189:
	YYDEBUG(1189, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '4') goto yy1210;
	goto yy53;
yy1190:
	YYDEBUG(1190, *YYCURSOR);
	++YYCURSOR;
#line 1206 "lib/parse_date.re"
	{
		DEBUG_OUTPUT("mssqltime");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == ':' || *ptr == '.') {
			s->time->s = timelib_get_nr((char **) &ptr, 2);

			if (*ptr == ':' || *ptr == '.') {
				s->time->us = timelib_get_frac_nr((char **) &ptr, 8);
			}
		}
		timelib_eat_spaces((char **) &ptr);
		s->time->h += timelib_meridian((char **) &ptr, s->time->h);
		TIMELIB_DEINIT;
		return TIMELIB_TIME24_WITH_ZONE;
	}
#line 21568 "lib/parse_date.c"
yy1191:
	YYDEBUG(1191, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1190;
		if (yych <= 0x08) goto yy53;
		goto yy1190;
	} else {
		if (yych == ' ') goto yy1190;
		goto yy53;
	}
yy1192:
	YYDEBUG(1192, *YYCURSOR);
	++YYCURSOR;
	goto yy1074;
yy1193:
	YYDEBUG(1193, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\t') {
		if (yych <= 0x00) goto yy1192;
		if (yych <= 0x08) goto yy53;
		goto yy1192;
	} else {
		if (yych == ' ') goto yy1192;
		goto yy53;
	}
yy1194:
	YYDEBUG(1194, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy804;
	if (yych <= '5') goto yy1195;
	if (yych <= '9') goto yy1014;
	goto yy804;
yy1195:
	YYDEBUG(1195, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy804;
	if (yych <= '9') goto yy1014;
	goto yy804;
yy1196:
	YYDEBUG(1196, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1014;
		goto yy804;
	} else {
		if (yych <= 'Z') goto yy1211;
		if (yych <= '`') goto yy804;
		if (yych <= 'z') goto yy1211;
		goto yy804;
	}
yy1197:
	YYDEBUG(1197, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') goto yy53;
	if (yych <= 'Z') goto yy1212;
	if (yych <= '`') goto yy53;
	if (yych <= 'z') goto yy1212;
	goto yy53;
yy1198:
	YYDEBUG(1198, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1014;
			goto yy804;
		} else {
			if (yych == '.') goto yy804;
			goto yy1197;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy1211;
			goto yy804;
		} else {
			if (yych <= '_') goto yy1197;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1213;
			goto yy804;
		}
	}
yy1199:
	YYDEBUG(1199, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= ',') {
		if (yych <= ')') {
			if (yych <= '(') goto yy804;
			goto yy1014;
		} else {
			if (yych == '+') goto yy1130;
			goto yy804;
		}
	} else {
		if (yych <= 'Z') {
			if (yych <= '-') goto yy1130;
			if (yych <= '@') goto yy804;
			goto yy1211;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1211;
			goto yy804;
		}
	}
yy1200:
	YYDEBUG(1200, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy1214;
	if (yych == 'h') goto yy1214;
	goto yy53;
yy1201:
	YYDEBUG(1201, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'C') goto yy1215;
	if (yych == 'c') goto yy1215;
	goto yy53;
yy1202:
	YYDEBUG(1202, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1216;
	goto yy181;
yy1203:
	YYDEBUG(1203, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1217;
	goto yy53;
yy1204:
	YYDEBUG(1204, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1218;
	if (yych <= '6') goto yy1220;
	if (yych <= '9') goto yy1221;
	goto yy53;
yy1205:
	YYDEBUG(1205, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1222;
	goto yy53;
yy1206:
	YYDEBUG(1206, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '0') goto yy1218;
	if (yych <= '5') goto yy1207;
	if (yych <= '6') goto yy1208;
	goto yy53;
yy1207:
	YYDEBUG(1207, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1221;
	goto yy53;
yy1208:
	YYDEBUG(1208, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1221;
	goto yy53;
yy1209:
	YYDEBUG(1209, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1186;
	goto yy53;
yy1210:
	YYDEBUG(1210, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1155;
	goto yy53;
yy1211:
	YYDEBUG(1211, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1014;
		goto yy804;
	} else {
		if (yych <= 'Z') goto yy1223;
		if (yych <= '`') goto yy804;
		if (yych <= 'z') goto yy1223;
		goto yy804;
	}
yy1212:
	YYDEBUG(1212, *YYCURSOR);
	yyaccept = 21;
	YYMARKER = ++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '@') {
		if (yych <= '-') {
			if (yych <= ',') goto yy804;
			goto yy1197;
		} else {
			if (yych == '/') goto yy1197;
			goto yy804;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy1212;
			if (yych <= '^') goto yy804;
			goto yy1197;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1212;
			goto yy804;
		}
	}
yy1213:
	YYDEBUG(1213, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1014;
			goto yy804;
		} else {
			if (yych == '.') goto yy804;
			goto yy1197;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy1223;
			goto yy804;
		} else {
			if (yych <= '_') goto yy1197;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1224;
			goto yy804;
		}
	}
yy1214:
	YYDEBUG(1214, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1019;
	if (yych == 't') goto yy1019;
	goto yy53;
yy1215:
	YYDEBUG(1215, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'O') goto yy1091;
	if (yych == 'o') goto yy1091;
	goto yy53;
yy1216:
	YYDEBUG(1216, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1225;
	goto yy181;
yy1217:
	YYDEBUG(1217, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1226;
	goto yy53;
yy1218:
	YYDEBUG(1218, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1219;
	if (yych <= '9') goto yy1221;
yy1219:
	YYDEBUG(1219, *YYCURSOR);
#line 1507 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("xmlrpc | xmlrpcnocolon | soap | wddx | exif");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->m = timelib_get_nr((char **) &ptr, 2);
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		if (*ptr == '.') {
			s->time->us = timelib_get_frac_nr((char **) &ptr, 9);
			if (*ptr) { /* timezone is optional */
				s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
				if (tz_not_found) {
					add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
				}
			}
		}
		TIMELIB_DEINIT;
		return TIMELIB_XMLRPC_SOAP;
	}
#line 21861 "lib/parse_date.c"
yy1220:
	YYDEBUG(1220, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '0') goto yy1219;
yy1221:
	YYDEBUG(1221, *YYCURSOR);
	++YYCURSOR;
	goto yy1219;
yy1222:
	YYDEBUG(1222, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1227;
	if (yych <= '9') goto yy1182;
	goto yy53;
yy1223:
	YYDEBUG(1223, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '@') {
		if (yych == ')') goto yy1014;
		goto yy804;
	} else {
		if (yych <= 'Z') goto yy1228;
		if (yych <= '`') goto yy804;
		if (yych <= 'z') goto yy1228;
		goto yy804;
	}
yy1224:
	YYDEBUG(1224, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '/') {
		if (yych <= ',') {
			if (yych == ')') goto yy1014;
			goto yy804;
		} else {
			if (yych == '.') goto yy804;
			goto yy1197;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy804;
			if (yych <= 'Z') goto yy1228;
			goto yy804;
		} else {
			if (yych <= '_') goto yy1197;
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1229;
			goto yy804;
		}
	}
yy1225:
	YYDEBUG(1225, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1230;
	goto yy181;
yy1226:
	YYDEBUG(1226, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1231;
	goto yy53;
yy1227:
	YYDEBUG(1227, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1232;
	if (yych <= ':') goto yy1204;
	goto yy53;
yy1228:
	YYDEBUG(1228, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ')') goto yy1014;
	goto yy804;
yy1229:
	YYDEBUG(1229, *YYCURSOR);
	yyaccept = 21;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= '.') {
		if (yych <= ')') {
			if (yych <= '(') goto yy804;
			goto yy1014;
		} else {
			if (yych == '-') goto yy1197;
			goto yy804;
		}
	} else {
		if (yych <= '_') {
			if (yych <= '/') goto yy1197;
			if (yych <= '^') goto yy804;
			goto yy1197;
		} else {
			if (yych <= '`') goto yy804;
			if (yych <= 'z') goto yy1233;
			goto yy804;
		}
	}
yy1230:
	YYDEBUG(1230, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1234;
	goto yy181;
yy1231:
	YYDEBUG(1231, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1235;
	goto yy53;
yy1232:
	YYDEBUG(1232, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == ':') goto yy1236;
	goto yy53;
yy1233:
	YYDEBUG(1233, *YYCURSOR);
	++YYCURSOR;
	if (YYLIMIT <= YYCURSOR) YYFILL(1);
	yych = *YYCURSOR;
	if (yych <= '/') {
		if (yych == '-') goto yy1197;
		if (yych <= '.') goto yy53;
		goto yy1197;
	} else {
		if (yych <= '_') {
			if (yych <= '^') goto yy53;
			goto yy1197;
		} else {
			if (yych <= '`') goto yy53;
			if (yych <= 'z') goto yy1233;
			goto yy53;
		}
	}
yy1234:
	YYDEBUG(1234, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1237;
	goto yy181;
yy1235:
	YYDEBUG(1235, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1238;
	if (yych <= '6') goto yy1239;
	goto yy53;
yy1236:
	YYDEBUG(1236, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '5') goto yy1240;
	if (yych <= '6') goto yy1241;
	if (yych <= '9') goto yy1221;
	goto yy53;
yy1237:
	YYDEBUG(1237, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1242;
	goto yy181;
yy1238:
	YYDEBUG(1238, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1243;
	goto yy53;
yy1239:
	YYDEBUG(1239, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1243;
	goto yy53;
yy1240:
	YYDEBUG(1240, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1219;
	if (yych <= '9') goto yy1244;
	goto yy1219;
yy1241:
	YYDEBUG(1241, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '0') goto yy1244;
	goto yy1219;
yy1242:
	YYDEBUG(1242, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '-') goto yy848;
	if (yych <= '/') goto yy181;
	if (yych <= '9') goto yy1245;
	goto yy181;
yy1243:
	YYDEBUG(1243, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\t') goto yy1246;
	if (yych == ' ') goto yy1246;
	goto yy53;
yy1244:
	YYDEBUG(1244, *YYCURSOR);
	yyaccept = 33;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych == '.') goto yy1247;
	goto yy1219;
yy1245:
	YYDEBUG(1245, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yybm[0+yych] & 4) {
		goto yy54;
	}
	if (yych == '-') goto yy848;
	goto yy181;
yy1246:
	YYDEBUG(1246, *YYCURSOR);
	++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '*') {
		if (yych <= '\t') {
			if (yych <= 0x08) goto yy53;
			goto yy1246;
		} else {
			if (yych == ' ') goto yy1246;
			goto yy53;
		}
	} else {
		if (yych <= '-') {
			if (yych == ',') goto yy53;
			goto yy1248;
		} else {
			if (yych == 'G') goto yy1249;
			goto yy53;
		}
	}
yy1247:
	YYDEBUG(1247, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '9') goto yy1250;
	goto yy53;
yy1248:
	YYDEBUG(1248, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1251;
	if (yych <= '2') goto yy1253;
	if (yych <= '9') goto yy1254;
	goto yy53;
yy1249:
	YYDEBUG(1249, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1255;
	goto yy53;
yy1250:
	YYDEBUG(1250, *YYCURSOR);
	yyaccept = 33;
	YYMARKER = ++YYCURSOR;
	if ((YYLIMIT - YYCURSOR) < 9) YYFILL(9);
	yych = *YYCURSOR;
	if (yych <= '-') {
		if (yych == '+') goto yy1256;
		if (yych <= ',') goto yy1219;
		goto yy1256;
	} else {
		if (yych <= '9') {
			if (yych <= '/') goto yy1219;
			goto yy1250;
		} else {
			if (yych == 'G') goto yy1257;
			goto yy1219;
		}
	}
yy1251:
	YYDEBUG(1251, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1252;
	if (yych <= '9') goto yy1254;
	if (yych <= ':') goto yy1258;
yy1252:
	YYDEBUG(1252, *YYCURSOR);
#line 1613 "lib/parse_date.re"
	{
		int tz_not_found;
		DEBUG_OUTPUT("clf");
		TIMELIB_INIT;
		TIMELIB_HAVE_TIME();
		TIMELIB_HAVE_DATE();
		s->time->d = timelib_get_nr((char **) &ptr, 2);
		s->time->m = timelib_get_month((char **) &ptr);
		s->time->y = timelib_get_nr((char **) &ptr, 4);
		s->time->h = timelib_get_nr((char **) &ptr, 2);
		s->time->i = timelib_get_nr((char **) &ptr, 2);
		s->time->s = timelib_get_nr((char **) &ptr, 2);
		s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
		if (tz_not_found) {
			add_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database");
		}
		TIMELIB_DEINIT;
		return TIMELIB_CLF;
	}
#line 22163 "lib/parse_date.c"
yy1253:
	YYDEBUG(1253, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1252;
		if (yych >= '5') goto yy1259;
	} else {
		if (yych <= '9') goto yy1260;
		if (yych <= ':') goto yy1258;
		goto yy1252;
	}
yy1254:
	YYDEBUG(1254, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1252;
	if (yych <= '5') goto yy1259;
	if (yych <= '9') goto yy1260;
	if (yych <= ':') goto yy1258;
	goto yy1252;
yy1255:
	YYDEBUG(1255, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1261;
	goto yy53;
yy1256:
	YYDEBUG(1256, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy53;
	if (yych <= '1') goto yy1262;
	if (yych <= '2') goto yy1263;
	if (yych <= '9') goto yy1264;
	goto yy53;
yy1257:
	YYDEBUG(1257, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'M') goto yy1265;
	goto yy53;
yy1258:
	YYDEBUG(1258, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1252;
	if (yych <= '5') goto yy1259;
	if (yych <= '9') goto yy1260;
	goto yy1252;
yy1259:
	YYDEBUG(1259, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1252;
	if (yych >= ':') goto yy1252;
yy1260:
	YYDEBUG(1260, *YYCURSOR);
	++YYCURSOR;
	goto yy1252;
yy1261:
	YYDEBUG(1261, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1248;
	if (yych == '-') goto yy1248;
	goto yy53;
yy1262:
	YYDEBUG(1262, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1219;
	if (yych <= '9') goto yy1264;
	if (yych <= ':') goto yy1266;
	goto yy1219;
yy1263:
	YYDEBUG(1263, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '5') {
		if (yych <= '/') goto yy1219;
		if (yych >= '5') goto yy1218;
	} else {
		if (yych <= '9') goto yy1221;
		if (yych <= ':') goto yy1266;
		goto yy1219;
	}
yy1264:
	YYDEBUG(1264, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1219;
	if (yych <= '5') goto yy1218;
	if (yych <= '9') goto yy1221;
	if (yych <= ':') goto yy1266;
	goto yy1219;
yy1265:
	YYDEBUG(1265, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'T') goto yy1267;
	goto yy53;
yy1266:
	YYDEBUG(1266, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '/') goto yy1219;
	if (yych <= '5') goto yy1218;
	if (yych <= '9') goto yy1221;
	goto yy1219;
yy1267:
	YYDEBUG(1267, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '+') goto yy1256;
	if (yych == '-') goto yy1256;
	goto yy53;
}
#line 1832 "lib/parse_date.re"

}

#line 22272 "lib/parse_date.c"
#define YYMAXFILL 33
#line 1835 "lib/parse_date.re"


timelib_time* timelib_strtotime(char *s, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	Scanner in;
	int t;
	char *e = s + len - 1;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	if (len > 0) {
		while (isspace(*s) && s < e) {
			s++;
		}
		while (isspace(*e) && e > s) {
			e--;
		}
	}
	if (e - s < 0) {
		in.time = timelib_time_ctor();
		add_error(&in, TIMELIB_ERR_EMPTY_STRING, "Empty string");
		if (errors) {
			*errors = in.errors;
		} else {
			timelib_error_container_dtor(in.errors);
		}
		in.time->y = in.time->d = in.time->m = in.time->h = in.time->i = in.time->s = in.time->us = in.time->dst = in.time->z = TIMELIB_UNSET;
		in.time->is_localtime = in.time->zone_type = 0;
		return in.time;
	}
	e++;

	in.str = timelib_malloc((e - s) + YYMAXFILL);
	memset(in.str, 0, (e - s) + YYMAXFILL);
	memcpy(in.str, s, (e - s));
	in.lim = in.str + (e - s) + YYMAXFILL;
	in.cur = in.str;
	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;
	in.time->relative.days = TIMELIB_UNSET;

	do {
		t = scan(&in, tz_get_wrapper);
#ifdef DEBUG_PARSER
		printf("%d\n", t);
#endif
	} while(t != EOI);

	/* do funky checking whether the parsed time was valid time */
	if (in.time->have_time && !timelib_valid_time( in.time->h, in.time->i, in.time->s)) {
		add_warning(&in, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid");
	}
	/* do funky checking whether the parsed date was valid date */
	if (in.time->have_date && !timelib_valid_date( in.time->y, in.time->m, in.time->d)) {
		add_warning(&in, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid");
	}

	timelib_free(in.str);
	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

#define TIMELIB_CHECK_NUMBER                                           \
		if (strchr("0123456789", *ptr) == NULL)                        \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}
#define TIMELIB_CHECK_SIGNED_NUMBER                                    \
		if (strchr("-0123456789", *ptr) == NULL)                       \
		{                                                              \
			add_pbf_error(s, TIMELIB_ERR_UNEXPECTED_DATA, "Unexpected data found.", string, begin); \
		}

static void timelib_time_reset_fields(timelib_time *time)
{
	assert(time != NULL);

	time->y = 1970;
	time->m = 1;
	time->d = 1;
	time->h = time->i = time->s = 0;
	time->us = 0;
	time->tz_info = NULL;
}

static void timelib_time_reset_unset_fields(timelib_time *time)
{
	assert(time != NULL);

	if (time->y == TIMELIB_UNSET ) time->y = 1970;
	if (time->m == TIMELIB_UNSET ) time->m = 1;
	if (time->d == TIMELIB_UNSET ) time->d = 1;
	if (time->h == TIMELIB_UNSET ) time->h = 0;
	if (time->i == TIMELIB_UNSET ) time->i = 0;
	if (time->s == TIMELIB_UNSET ) time->s = 0;
	if (time->us == TIMELIB_UNSET ) time->us = 0;
}

static const timelib_format_specifier default_format_map[] = {
	{'+', TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS},
	{'#', TIMELIB_FORMAT_ANY_SEPARATOR},
	{'j', TIMELIB_FORMAT_DAY_TWO_DIGIT},
	{'d', TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED},
	{'z', TIMELIB_FORMAT_DAY_OF_YEAR},
	{'S', TIMELIB_FORMAT_DAY_SUFFIX},
	{'U', TIMELIB_FORMAT_EPOCH_SECONDS},
	{'\\', TIMELIB_FORMAT_ESCAPE},
	{'h', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX},
	{'g', TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED},
	{'H', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX},
	{'G', TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED},
	{'a', TIMELIB_FORMAT_MERIDIAN},
	{'A', TIMELIB_FORMAT_MERIDIAN},
	{'u', TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT},
	{'v', TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT},
	{'i', TIMELIB_FORMAT_MINUTE_TWO_DIGIT},
	{'n', TIMELIB_FORMAT_MONTH_TWO_DIGIT},
	{'m', TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED},
	{'?', TIMELIB_FORMAT_RANDOM_CHAR},
	{'!', TIMELIB_FORMAT_RESET_ALL},
	{'|', TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET},
	{'s', TIMELIB_FORMAT_SECOND_TWO_DIGIT},
	{';', TIMELIB_FORMAT_SEPARATOR},
	{':', TIMELIB_FORMAT_SEPARATOR},
	{'/', TIMELIB_FORMAT_SEPARATOR},
	{'.', TIMELIB_FORMAT_SEPARATOR},
	{',', TIMELIB_FORMAT_SEPARATOR},
	{'-', TIMELIB_FORMAT_SEPARATOR},
	{'(', TIMELIB_FORMAT_SEPARATOR},
	{')', TIMELIB_FORMAT_SEPARATOR},
	{'*', TIMELIB_FORMAT_SKIP_TO_SEPARATOR},
	{'D', TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER},
	{'l', TIMELIB_FORMAT_TEXTUAL_DAY_FULL},
	{'M', TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER},
	{'F', TIMELIB_FORMAT_TEXTUAL_MONTH_FULL},
	{'e', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'P', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'T', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{'O', TIMELIB_FORMAT_TIMEZONE_OFFSET},
	{' ', TIMELIB_FORMAT_WHITESPACE},
	{'y', TIMELIB_FORMAT_YEAR_TWO_DIGIT},
	{'Y', TIMELIB_FORMAT_YEAR_FOUR_DIGIT},
	{'\0', TIMELIB_FORMAT_END}
};

static const timelib_format_config default_format_config = {
	default_format_map,
	// No prefix required by default.
	'\0'
};

static timelib_format_specifier_code timelib_lookup_format(char input, const timelib_format_specifier* format_map)
{
	while (format_map && format_map->specifier != '\0') {
		if (format_map->specifier == input) {
			return format_map->code;
		}
		format_map++;
	}
	return TIMELIB_FORMAT_LITERAL;
}

timelib_time *timelib_parse_from_format(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper)
{
	return timelib_parse_from_format_with_map(format, string, len, errors, tzdb, tz_get_wrapper, &default_format_config);
}

timelib_time *timelib_parse_from_format_with_map(char *format, char *string, size_t len, timelib_error_container **errors, const timelib_tzdb *tzdb, timelib_tz_get_wrapper tz_get_wrapper, const timelib_format_config* format_config)
{
	char        *fptr = format;
	char        *ptr = string;
	char        *begin;
	timelib_sll  tmp;
	Scanner      in;
	Scanner     *s = &in;
	bool         allow_extra = false;
	bool         prefix_found = false;
	int          iso_year = TIMELIB_UNSET;
	int          iso_week_of_year = TIMELIB_UNSET;
	int          iso_day_of_week = TIMELIB_UNSET;
	char         prefix_char = format_config->prefix_char;
	const timelib_format_specifier *format_map = format_config->format_map;

	memset(&in, 0, sizeof(in));
	in.errors = timelib_malloc(sizeof(timelib_error_container));
	in.errors->warning_count = 0;
	in.errors->warning_messages = NULL;
	in.errors->error_count = 0;
	in.errors->error_messages = NULL;

	in.time = timelib_time_ctor();
	in.time->y = TIMELIB_UNSET;
	in.time->d = TIMELIB_UNSET;
	in.time->m = TIMELIB_UNSET;
	in.time->h = TIMELIB_UNSET;
	in.time->i = TIMELIB_UNSET;
	in.time->s = TIMELIB_UNSET;
	in.time->us = TIMELIB_UNSET;
	in.time->z = TIMELIB_UNSET;
	in.time->dst = TIMELIB_UNSET;
	in.tzdb = tzdb;
	in.time->is_localtime = 0;
	in.time->zone_type = 0;

	/* Loop over the format string */
	while (*fptr && *ptr) {
		begin = ptr;

		if (prefix_char) {
			/* There are 2 cases where the input string and format string
			 * should match the next literal:
			 *
			 * 1. No prefix has been specified yet in the format, so expect 1:1
			 *    match.
			 * 2. Sequential prefix characters indicating that the second
			 *    prefix is escaped. (e.g. "%%" is expecting literal "%")
			 */
			if ((!prefix_found && *fptr != prefix_char) ||
				(prefix_found && *fptr == prefix_char)) {
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_FORMAT_LITERAL_MISMATCH, "Format literal not found", string, begin);
				}
				ptr++;
				fptr++;
				prefix_found = false;
				continue;
			}

			if (*fptr == prefix_char) {
				fptr++;
				prefix_found = true;
				continue;
			}

			/* Fall through case is that the prefix has been found and the next
			 * character is the format specifier. */
			prefix_found = false;
		}

		switch (timelib_lookup_format(*fptr, format_map)) {
			case TIMELIB_FORMAT_TEXTUAL_DAY_3_LETTER: /* three letter day */
			case TIMELIB_FORMAT_TEXTUAL_DAY_FULL: /* full day */
				{
					const timelib_relunit* tmprel = 0;

					tmprel = timelib_lookup_relunit((char **) &ptr);
					if (!tmprel) {
						add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_DAY, "A textual day could not be found", string, begin);
						break;
					} else {
						in.time->have_relative = 1;
						in.time->relative.have_weekday_relative = 1;
						in.time->relative.weekday = tmprel->multiplier;
						in.time->relative.weekday_behavior = 1;
					}
				}
				break;
			case TIMELIB_FORMAT_DAY_TWO_DIGIT: /* two digit day, without leading zero */
			case TIMELIB_FORMAT_DAY_TWO_DIGIT_PADDED: /* two digit day, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->d = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_DAY, "A two digit day could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_DAY_SUFFIX: /* day suffix, ignored, nor checked */
				timelib_skip_day_suffix((char **) &ptr);
				break;
			case TIMELIB_FORMAT_DAY_OF_YEAR: /* day of year - resets month (0 based) - also initializes everything else to !TIMELIB_UNSET */
				TIMELIB_CHECK_NUMBER;
				if ((tmp = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_DAY_OF_YEAR, "A three digit day-of-year could not be found", string, begin);
				} else {
					s->time->m = 1;
					s->time->d = tmp + 1;
					timelib_do_normalize(s->time);
				}
				break;

			case TIMELIB_FORMAT_MONTH_TWO_DIGIT: /* two digit month, without leading zero */
			case TIMELIB_FORMAT_MONTH_TWO_DIGIT_PADDED: /* two digit month, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->m = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MONTH, "A two digit month could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_TEXTUAL_MONTH_3_LETTER: /* three letter month */
			case TIMELIB_FORMAT_TEXTUAL_MONTH_FULL: /* full month */
				tmp = timelib_lookup_month((char **) &ptr);
				if (!tmp) {
					add_pbf_error(s, TIMELIB_ERR_NO_TEXTUAL_MONTH, "A textual month could not be found", string, begin);
				} else {
					s->time->m = tmp;
				}
				break;
			case TIMELIB_FORMAT_YEAR_TWO_DIGIT: /* two digit year */
				{
					int length = 0;
					TIMELIB_CHECK_NUMBER;
					if ((s->time->y = timelib_get_nr_ex((char **) &ptr, 2, &length)) == TIMELIB_UNSET) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_YEAR, "A two digit year could not be found", string, begin);
					}
					TIMELIB_PROCESS_YEAR(s->time->y, length);
				}
				break;
			case TIMELIB_FORMAT_YEAR_FOUR_DIGIT: /* four digit year */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->y = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR, "A four digit year could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX: /* two digit hour, without leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_12_MAX_PADDED: /* two digit hour, with leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				if (s->time->h > 12) {
					add_pbf_error(s, TIMELIB_ERR_HOUR_LARGER_THAN_12, "Hour can not be higher than 12", string, begin);
				}
				break;
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX_PADDED: /* two digit hour, with leading zero */
			case TIMELIB_FORMAT_HOUR_TWO_DIGIT_24_MAX: /* two digit hour, without leading zero */
				TIMELIB_CHECK_NUMBER;
				if ((s->time->h = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_HOUR, "A two digit hour could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_MERIDIAN: /* am/pm/a.m./p.m. AM/PM/A.M./P.M. */
				if (s->time->h == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_MERIDIAN_BEFORE_HOUR, "Meridian can only come after an hour has been found", string, begin);
				} else if ((tmp = timelib_meridian_with_check((char **) &ptr, s->time->h)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_MERIDIAN, "A meridian could not be found", string, begin);
				} else {
					s->time->h += tmp;
				}
				break;
			case TIMELIB_FORMAT_MINUTE_TWO_DIGIT: /* two digit minute, with leading zero */
				{
					int length;
					timelib_sll min;

					TIMELIB_CHECK_NUMBER;
					min = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (min == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_MINUTE, "A two digit minute could not be found", string, begin);
					} else {
						s->time->i = min;
					}
				}
				break;
			case TIMELIB_FORMAT_SECOND_TWO_DIGIT: /* two digit second, with leading zero */
				{
					int length;
					timelib_sll sec;

					TIMELIB_CHECK_NUMBER;
					sec = timelib_get_nr_ex((char **) &ptr, 2, &length);
					if (sec == TIMELIB_UNSET || length != 2) {
						add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_SECOND, "A two digit second could not be found", string, begin);
					} else {
						s->time->s = sec;
					}
				}
				break;
			case TIMELIB_FORMAT_MICROSECOND_SIX_DIGIT: /* up to six digit microsecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 6)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_SIX_DIGIT_MICROSECOND, "A six digit microsecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 6 - (ptr - tptr)));
					}
				}
				break;
			case TIMELIB_FORMAT_MILLISECOND_THREE_DIGIT: /* up to three digit millisecond */
				{
					double f;
					char *tptr;

					TIMELIB_CHECK_NUMBER;
					tptr = ptr;
					if ((f = timelib_get_nr((char **) &ptr, 3)) == TIMELIB_UNSET || (ptr - tptr < 1)) {
						add_pbf_error(s, TIMELIB_ERR_NO_THREE_DIGIT_MILLISECOND, "A three digit millisecond could not be found", string, begin);
					} else {
						s->time->us = (f * pow(10, 3 - (ptr - tptr)) * 1000);
					}
				}
				break;
			case TIMELIB_FORMAT_WHITESPACE: /* any sort of whitespace (' ' and \t) */
				timelib_eat_spaces((char **) &ptr);
				break;
			case TIMELIB_FORMAT_EPOCH_SECONDS: /* epoch seconds */
				TIMELIB_CHECK_SIGNED_NUMBER;
				tmp = timelib_get_unsigned_nr((char **) &ptr, 24);
				s->time->sse = tmp;
				s->time->is_localtime = 1;
				s->time->zone_type = TIMELIB_ZONETYPE_OFFSET;
				s->time->z = 0;
				s->time->dst = 0;
				timelib_update_from_sse(s->time);
				break;

			case TIMELIB_FORMAT_ANY_SEPARATOR: /* separation symbol */
				if (timelib_lookup_format(*ptr, format_map) == TIMELIB_FORMAT_SEPARATOR) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol ([;:/.,-]) could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_SEPARATOR:
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_SEP_SYMBOL, "The separation symbol could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
				timelib_time_reset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
				timelib_time_reset_unset_fields(s->time);
				break; /* break intentionally not missing */

			case TIMELIB_FORMAT_RANDOM_CHAR: /* random char */
				++ptr;
				break;

			case TIMELIB_FORMAT_ESCAPE: /* escaped char */
				if(!fptr[1]) {
					add_pbf_error(s, TIMELIB_ERR_EXPECTED_ESCAPE_CHAR, "Escaped character expected", string, begin);
					break;
				}
				fptr++;
				if (*ptr == *fptr) {
					++ptr;
				} else {
					add_pbf_error(s, TIMELIB_ERR_NO_ESCAPED_CHAR, "The escaped character could not be found", string, begin);
				}
				break;

			case TIMELIB_FORMAT_SKIP_TO_SEPARATOR: /* random chars until a separator or number ([ \t.,:;/-0123456789]) */
				timelib_eat_until_separator((char **) &ptr);
				break;

			case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS: /* allow extra chars in the format */
				allow_extra = true;
				break;
			case TIMELIB_FORMAT_YEAR_ISO:
				if ((iso_year = timelib_get_nr((char **) &ptr, 4)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_FOUR_DIGIT_YEAR_ISO, "A four digit ISO year could not be found", string, begin);
				}
				break;
			case TIMELIB_FORMAT_WEEK_OF_YEAR_ISO:
				if ((iso_week_of_year = timelib_get_nr((char **) &ptr, 2)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_TWO_DIGIT_WEEK, "A two digit ISO week could not be found", string, begin);
				}
				/* Range is 1 - 53  for ISO week of year */
				if (iso_week_of_year < 1 || iso_week_of_year > 53) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_WEEK, "ISO Week must be between 1 and 53", string, begin);
				}
				break;
			case TIMELIB_FORMAT_DAY_OF_WEEK_ISO:
				if ((iso_day_of_week = timelib_get_nr((char **) &ptr, 1)) == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_NO_DAY_OF_WEEK, "A single digit day of week could not be found", string, begin);
				}
				if (iso_day_of_week < 1 || iso_day_of_week > 7) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_DAY_OF_WEEK, "Day of week must be between 1 and 7", string, begin);
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET: /* timezone */
				{
					int tz_not_found;

					s->time->z = timelib_parse_zone((char **) &ptr, &s->time->dst, s->time, &tz_not_found, s->tzdb, tz_get_wrapper);
					if (tz_not_found) {
						add_pbf_error(s, TIMELIB_ERR_TZID_NOT_FOUND, "The timezone could not be found in the database", string, begin);
					}
				}
				break;
			case TIMELIB_FORMAT_TIMEZONE_OFFSET_MINUTES: /* timezone format +/-mmm */
				s->time->z = timelib_parse_tz_minutes((char **) &ptr, s->time);
				if (s->time->z == TIMELIB_UNSET) {
					add_pbf_error(s, TIMELIB_ERR_INVALID_TZ_OFFSET, "Invalid timezone offset in minutes", string, begin);
				}
				break;
			case TIMELIB_FORMAT_LITERAL:
			default:
				if (*fptr != *ptr) {
					add_pbf_error(s, TIMELIB_ERR_WRONG_FORMAT_SEP, "The format separator does not match", string, begin);
				}
				ptr++;
		}
		fptr++;
	}
	if (*ptr) {
		if (allow_extra) {
			add_pbf_warning(s, TIMELIB_WARN_TRAILING_DATA, "Trailing data", string, ptr);
		} else {
			add_pbf_error(s, TIMELIB_ERR_TRAILING_DATA, "Trailing data", string, ptr);
		}
	}

	if (*fptr) {
		/* Trailing reset specifiers are valid. */
		int done = 0;
		while (*fptr && !done) {
			switch (timelib_lookup_format(*fptr, format_map)) {
				case TIMELIB_FORMAT_RESET_ALL: /* reset all fields to default */
					timelib_time_reset_fields(s->time);
					break;

				case TIMELIB_FORMAT_RESET_ALL_WHEN_NOT_SET: /* reset all fields to default when not set */
					timelib_time_reset_unset_fields(s->time);
					break;
				case TIMELIB_FORMAT_ALLOW_EXTRA_CHARACTERS:
					break;

				default:
					add_pbf_error(s, TIMELIB_ERR_DATA_MISSING, "Data missing", string, ptr);
					done = 1;
			}
			fptr++;
		}
	}

	/* clean up a bit */
	if (s->time->h != TIMELIB_UNSET || s->time->i != TIMELIB_UNSET || s->time->s != TIMELIB_UNSET || s->time->us != TIMELIB_UNSET) {
		if (s->time->h == TIMELIB_UNSET ) {
			s->time->h = 0;
		}
		if (s->time->i == TIMELIB_UNSET ) {
			s->time->i = 0;
		}
		if (s->time->s == TIMELIB_UNSET ) {
			s->time->s = 0;
		}
		if (s->time->us == TIMELIB_UNSET ) {
			s->time->us = 0;
		}
	}

	/* Check for mixing of ISO dates with natural dates. */
	if (s->time->y != TIMELIB_UNSET && (iso_week_of_year != TIMELIB_UNSET || iso_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}
	if (iso_year != TIMELIB_UNSET && (s->time->y != TIMELIB_UNSET || s->time->m != TIMELIB_UNSET || s->time->d != TIMELIB_UNSET)) {
		add_pbf_error(s, TIMELIB_ERR_MIX_ISO_WITH_NATURAL, "Mixing of ISO dates with natural dates is not allowed", string, ptr);
	}

	/* Convert ISO values */
	if (iso_year != TIMELIB_UNSET) {
		/* Default week of year and day of week to 1. */
		if (iso_week_of_year == TIMELIB_UNSET) {
			iso_week_of_year = 1;
		}
		if (iso_day_of_week == TIMELIB_UNSET) {
			iso_day_of_week = 1;
		}
		timelib_date_from_isodate(iso_year, iso_week_of_year, iso_day_of_week, &s->time->y, &s->time->m, &s->time->d);
	} else if (iso_week_of_year != TIMELIB_UNSET || iso_day_of_week != TIMELIB_UNSET) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	/* do funky checking whether the parsed time was valid time */
	if (s->time->h != TIMELIB_UNSET && s->time->i != TIMELIB_UNSET &&
		s->time->s != TIMELIB_UNSET &&
		!timelib_valid_time( s->time->h, s->time->i, s->time->s)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_TIME, "The parsed time was invalid", string, ptr);
	}
	/* do funky checking whether the parsed date was valid date */
	if (s->time->y != TIMELIB_UNSET && s->time->m != TIMELIB_UNSET &&
		s->time->d != TIMELIB_UNSET &&
		!timelib_valid_date( s->time->y, s->time->m, s->time->d)) {
		add_pbf_warning(s, TIMELIB_WARN_INVALID_DATE, "The parsed date was invalid", string, ptr);
	}

	if (errors) {
		*errors = in.errors;
	} else {
		timelib_error_container_dtor(in.errors);
	}
	return in.time;
}

void timelib_fill_holes(timelib_time *parsed, timelib_time *now, int options)
{
	if (!(options & TIMELIB_OVERRIDE_TIME) && parsed->have_date && !parsed->have_time) {
		parsed->h = 0;
		parsed->i = 0;
		parsed->s = 0;
		parsed->us = 0;
	}
	if (
		parsed->y != TIMELIB_UNSET || parsed->m != TIMELIB_UNSET || parsed->d != TIMELIB_UNSET ||
		parsed->h != TIMELIB_UNSET || parsed->i != TIMELIB_UNSET || parsed->s != TIMELIB_UNSET
	) {
		if (parsed->us == TIMELIB_UNSET) parsed->us = 0;
	} else {
		if (parsed->us == TIMELIB_UNSET) parsed->us = now->us != TIMELIB_UNSET ? now->us : 0;
	}
	if (parsed->y == TIMELIB_UNSET) parsed->y = now->y != TIMELIB_UNSET ? now->y : 0;
	if (parsed->m == TIMELIB_UNSET) parsed->m = now->m != TIMELIB_UNSET ? now->m : 0;
	if (parsed->d == TIMELIB_UNSET) parsed->d = now->d != TIMELIB_UNSET ? now->d : 0;
	if (parsed->h == TIMELIB_UNSET) parsed->h = now->h != TIMELIB_UNSET ? now->h : 0;
	if (parsed->i == TIMELIB_UNSET) parsed->i = now->i != TIMELIB_UNSET ? now->i : 0;
	if (parsed->s == TIMELIB_UNSET) parsed->s = now->s != TIMELIB_UNSET ? now->s : 0;
	if (parsed->z == TIMELIB_UNSET) parsed->z = now->z != TIMELIB_UNSET ? now->z : 0;
	if (parsed->dst == TIMELIB_UNSET) parsed->dst = now->dst != TIMELIB_UNSET ? now->dst : 0;

	if (!parsed->tz_abbr) {
		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
	}
	if (!parsed->tz_info) {
		parsed->tz_info = now->tz_info ? (!(options & TIMELIB_NO_CLONE) ? timelib_tzinfo_clone(now->tz_info) : now->tz_info) : NULL;
	}
	if (parsed->zone_type == 0 && now->zone_type != 0) {
		parsed->zone_type = now->zone_type;
/*		parsed->tz_abbr = now->tz_abbr ? timelib_strdup(now->tz_abbr) : NULL;
		parsed->tz_info = now->tz_info ? timelib_tzinfo_clone(now->tz_info) : NULL;
*/		parsed->is_localtime = 1;
	}
/*	timelib_dump_date(parsed, 2);
	timelib_dump_date(now, 2);
*/
}

char *timelib_timezone_id_from_abbr(const char *abbr, timelib_long gmtoffset, int isdst)
{
	const timelib_tz_lookup_table *tp;

	tp = abbr_search(abbr, gmtoffset, isdst);
	if (tp) {
		return (tp->full_tz_name);
	} else {
		return NULL;
	}
}

const timelib_tz_lookup_table *timelib_timezone_abbreviations_list(void)
{
	return timelib_timezone_lookup;
}

#ifdef DEBUG_PARSER_STUB
int main(void)
{
	timelib_time time = timelib_strtotime("May 12");

	printf ("%04d-%02d-%02d %02d:%02d:%02d.%-5d %+04d %1d",
		time.y, time.m, time.d, time.h, time.i, time.s, time.f, time.z, time.dst);
	if (time.have_relative) {
		printf ("%3dY %3dM %3dD / %3dH %3dM %3dS",
			time.relative.y, time.relative.m, time.relative.d, time.relative.h, time.relative.i, time.relative.s);
	}
	if (time.have_weekday_relative) {
		printf (" / %d", time.relative.weekday);
	}
	if (time.have_weeknr_day) {
		printf(" / %dW%d", time.relative.weeknr_day.weeknr, time.relative.weeknr_day.dayofweek);
	}
	return 0;
}
#endif

/*
 * vim: syntax=c
 */
