/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.ArrayCommand;
import py4j.CallCommand;
import py4j.Command;
import py4j.ConstructorCommand;
import py4j.FieldCommand;
import py4j.Gateway;
import py4j.HelpPageCommand;
import py4j.ListCommand;
import py4j.MemoryCommand;
import py4j.NetworkUtil;
import py4j.ReflectionCommand;
import py4j.ShutdownGatewayServerCommand;

public class GatewayConnection
implements Runnable {
    private static final List<Class<? extends Command>> baseCommands = new ArrayList<Class<? extends Command>>();
    private final Gateway gateway;
    private final Socket socket;
    private final BufferedWriter writer;
    private final BufferedReader reader;
    private final Map<String, Command> commands;
    private final Logger logger = Logger.getLogger(GatewayConnection.class.getName());

    public GatewayConnection(Gateway gateway, Socket socket, List<Class<? extends Command>> customCommands) throws IOException {
        this.gateway = gateway;
        this.socket = socket;
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), Charset.forName("UTF-8")));
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), Charset.forName("UTF-8")));
        this.commands = new HashMap<String, Command>();
        this.initCommands(gateway, baseCommands);
        if (customCommands != null) {
            this.initCommands(gateway, customCommands);
        }
        Thread t = new Thread(this);
        t.start();
    }

    public GatewayConnection(Gateway gateway, Socket socket) throws IOException {
        this(gateway, socket, null);
    }

    public static List<Class<? extends Command>> getBaseCommands() {
        return baseCommands;
    }

    protected void initCommands(Gateway gateway, List<Class<? extends Command>> commandsClazz) {
        for (Class<? extends Command> clazz : commandsClazz) {
            try {
                Command cmd = clazz.newInstance();
                cmd.init(gateway);
                this.commands.put(cmd.getCommandName(), cmd);
            }
            catch (Exception e) {
                String name = "null";
                if (clazz != null) {
                    name = clazz.getName();
                }
                this.logger.log(Level.SEVERE, "Could not initialize command " + name, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.logger.info("Gateway Connection ready to receive messages");
            String commandLine = null;
            do {
                commandLine = this.reader.readLine();
                this.logger.info("Received command: " + commandLine);
                Command command = this.commands.get(commandLine);
                if (command != null) {
                    command.execute(commandLine, this.reader, this.writer);
                    continue;
                }
                this.logger.log(Level.WARNING, "Unknown command " + commandLine);
            } while (commandLine != null && !commandLine.equals("q"));
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Error occurred while waiting for a command.", e);
        }
        finally {
            this.logger.log(Level.INFO, "Closing connection.");
            NetworkUtil.quietlyClose(this.socket);
            this.gateway.closeConnection();
        }
    }

    static {
        baseCommands.add(ArrayCommand.class);
        baseCommands.add(CallCommand.class);
        baseCommands.add(ConstructorCommand.class);
        baseCommands.add(FieldCommand.class);
        baseCommands.add(HelpPageCommand.class);
        baseCommands.add(ListCommand.class);
        baseCommands.add(MemoryCommand.class);
        baseCommands.add(ReflectionCommand.class);
        baseCommands.add(ShutdownGatewayServerCommand.class);
    }
}

