# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class ManagedLabVmSize(str, Enum):

    basic = "Basic"  #: The base VM size
    standard = "Standard"  #: The standard or default VM size
    performance = "Performance"  #: The most performant VM size


class PublishingState(str, Enum):

    draft = "Draft"  #: Initial state of an environment setting.
    publishing = "Publishing"  #: Currently provisioning resources.
    published = "Published"  #: All resources are currently provisioned.
    publish_failed = "PublishFailed"  #: Failed to provision all the necessary resources.
    scaling = "Scaling"  #: Currently provisioning resources without recreating VM image.


class ConfigurationState(str, Enum):

    not_applicable = "NotApplicable"  #: User either hasn't started configuring their template
or they haven't started the configuration process.
    completed = "Completed"  #: User is finished modifying the template.


class LabUserAccessMode(str, Enum):

    restricted = "Restricted"  #: Only users registered with the lab can access VMs.
    open = "Open"  #: Any user can register with the lab and access its VMs.


class AddRemove(str, Enum):

    add = "Add"  #: Indicates that a user is adding a favorite lab
    remove = "Remove"  #: Indicates that a user is removing a favorite lab
