from unittest import TestCase
from rum import Repository, RepositoryFactory, exceptions, app
from rum.util import safe_issubclass
from inspect import isclass
from rum.tests.model import *
# To register field declarations...
import rum.tests.test_fieldfactory

class ModelRepository(Repository):
    def __init__(self, resource, factory=None, **kw):
        self.resource = resource
        self.factory = factory

    def get(self, id):
        try:
            return self.resource.get(id)
        except KeyError:
            raise exceptions.ObjectNotFound("No object found with id %r"%(id,))
        
    def get_id(self, obj):
        return obj.id
        
    def select(self, query):
        return self.resource.select(query)

    def delete(self, obj):
        obj.delete()

    def update(self, obj, data):
        self._set(obj, data)
        obj.save()

    def create(self, data):
        obj = self.resource()
        self._set(obj, data)
        return obj

    def save(self, obj):
        obj.save()
        return obj

    @staticmethod
    def _set(obj, data):
        for k, v in data.iteritems():
            setattr(obj, k, v)


get = RepositoryFactory.get.im_func

class DummyRepositoryFactory(RepositoryFactory):
    #
    # explicit get rules
    #
    @get.when(
        "isclass(resource) and issubclass(resource, Model)"
        )
    def _repo_for_Model(self, resource, parent, remote_name, action, args):
        args['resource'] = resource
        return ModelRepository

#
# autogenerated rules
#
class AddressRepository(ModelRepository):
    pass

DummyRepositoryFactory.register(AddressRepository, Address)

# but also type based
class DummyAddress(Address): pass
class DummyAddressRepository(ModelRepository):
    pass
DummyRepositoryFactory.register(DummyAddressRepository, DummyAddress)

class ADummy(object): pass
DummyRepositoryFactory.set_names(ADummy, "a", "aes")

class TestRepository(TestCase):
    def setUp(self):
        clear_all()
        self.factory = DummyRepositoryFactory(
            scan_modules=['rum.tests.model'],
            )

    def test_can_handle(self):
        self.failUnless(self.factory.can_handle(Address))
        self.failUnless(self.factory.can_handle(DummyAddress))


    def test_set_names_class(self):
        self.failUnlessEqual(self.factory.names_for_resource(ADummy),
                             ("a", "aes"))

    def test_set_names_instance(self):
        self.failUnlessEqual(self.factory.names_for_resource(ADummy()),
                             ("a", "aes"))

    def test_resources_have_been_gathered(self):
        resources = self.factory.load_resources()
        self.failUnless(Model in resources)
        self.failUnless(Person in resources)
        self.failUnless(Address in resources)

    def test_custom_rule(self):
        repo = self.factory(Model)
        self.failUnless(isinstance(repo, ModelRepository), repo)

    def test_registered_with_register_full_pred(self):
        repo = self.factory(Address)
        self.failUnless(isinstance(repo, AddressRepository), repo)

    def test_registered_with_register_type_pred(self):
        repo = self.factory(DummyAddress)
        self.failUnless(isinstance(repo, DummyAddressRepository), repo)

    def test_sortKey(self):
        repo = self.factory(Model)
        self.failUnless(isinstance(repo.sortKey(), basestring), repo)
