# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AccumulatedType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Show costs accumulated over time.
    """

    TRUE = "true"
    FALSE = "false"

class AlertCategory(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Alert category
    """

    COST = "Cost"
    USAGE = "Usage"
    BILLING = "Billing"
    SYSTEM = "System"

class AlertCriteria(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Criteria that triggered alert
    """

    COST_THRESHOLD_EXCEEDED = "CostThresholdExceeded"
    USAGE_THRESHOLD_EXCEEDED = "UsageThresholdExceeded"
    CREDIT_THRESHOLD_APPROACHING = "CreditThresholdApproaching"
    CREDIT_THRESHOLD_REACHED = "CreditThresholdReached"
    QUOTA_THRESHOLD_APPROACHING = "QuotaThresholdApproaching"
    QUOTA_THRESHOLD_REACHED = "QuotaThresholdReached"
    MULTI_CURRENCY = "MultiCurrency"
    FORECAST_COST_THRESHOLD_EXCEEDED = "ForecastCostThresholdExceeded"
    FORECAST_USAGE_THRESHOLD_EXCEEDED = "ForecastUsageThresholdExceeded"
    INVOICE_DUE_DATE_APPROACHING = "InvoiceDueDateApproaching"
    INVOICE_DUE_DATE_REACHED = "InvoiceDueDateReached"
    CROSS_CLOUD_NEW_DATA_AVAILABLE = "CrossCloudNewDataAvailable"
    CROSS_CLOUD_COLLECTION_ERROR = "CrossCloudCollectionError"
    GENERAL_THRESHOLD_ERROR = "GeneralThresholdError"

class AlertOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """operator used to compare currentSpend with amount
    """

    NONE = "None"
    EQUAL_TO = "EqualTo"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL_TO = "LessThanOrEqualTo"

class AlertSource(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Source of alert
    """

    PRESET = "Preset"
    USER = "User"

class AlertStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """alert status
    """

    NONE = "None"
    ACTIVE = "Active"
    OVERRIDDEN = "Overridden"
    RESOLVED = "Resolved"
    DISMISSED = "Dismissed"

class AlertTimeGrainType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of timegrain cadence
    """

    NONE = "None"
    MONTHLY = "Monthly"
    QUARTERLY = "Quarterly"
    ANNUALLY = "Annually"
    BILLING_MONTH = "BillingMonth"
    BILLING_QUARTER = "BillingQuarter"
    BILLING_ANNUAL = "BillingAnnual"

class AlertType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """type of alert
    """

    BUDGET = "Budget"
    INVOICE = "Invoice"
    CREDIT = "Credit"
    QUOTA = "Quota"
    GENERAL = "General"
    X_CLOUD = "xCloud"
    BUDGET_FORECAST = "BudgetForecast"

class ChartType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Chart type of the main view in Cost Analysis. Required.
    """

    AREA = "Area"
    LINE = "Line"
    STACKED_COLUMN = "StackedColumn"
    GROUPED_COLUMN = "GroupedColumn"
    TABLE = "Table"

class ExecutionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The last known status of the export execution.
    """

    QUEUED = "Queued"
    IN_PROGRESS = "InProgress"
    COMPLETED = "Completed"
    FAILED = "Failed"
    TIMEOUT = "Timeout"
    NEW_DATA_NOT_AVAILABLE = "NewDataNotAvailable"
    DATA_NOT_AVAILABLE = "DataNotAvailable"

class ExecutionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the export execution.
    """

    ON_DEMAND = "OnDemand"
    SCHEDULED = "Scheduled"

class ExportType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the query.
    """

    USAGE = "Usage"
    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"

class ExternalCloudProviderType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    EXTERNAL_SUBSCRIPTIONS = "externalSubscriptions"
    EXTERNAL_BILLING_ACCOUNTS = "externalBillingAccounts"

class ForecastTimeframeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The time frame for pulling data for the forecast. If custom, then a specific time period must
    be provided.
    """

    MONTH_TO_DATE = "MonthToDate"
    BILLING_MONTH_TO_DATE = "BillingMonthToDate"
    THE_LAST_MONTH = "TheLastMonth"
    THE_LAST_BILLING_MONTH = "TheLastBillingMonth"
    WEEK_TO_DATE = "WeekToDate"
    CUSTOM = "Custom"

class ForecastType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the forecast.
    """

    USAGE = "Usage"
    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"

class FormatType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The format of the export being delivered. Currently only 'Csv' is supported.
    """

    CSV = "Csv"

class FunctionType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The name of the aggregation function to use.
    """

    SUM = "Sum"

class GranularityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The granularity of rows in the forecast.
    """

    DAILY = "Daily"

class KpiType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """KPI type (Forecast, Budget).
    """

    FORECAST = "Forecast"
    BUDGET = "Budget"

class MetricType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Metric to use when displaying costs.
    """

    ACTUAL_COST = "ActualCost"
    AMORTIZED_COST = "AmortizedCost"
    AHUB = "AHUB"

class OperatorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The operator to use for comparison.
    """

    IN_ENUM = "In"
    CONTAINS = "Contains"

class PivotType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Data type to show in view.
    """

    DIMENSION = "Dimension"
    TAG_KEY = "TagKey"

class QueryColumnType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the column in the export.
    """

    TAG = "Tag"
    DIMENSION = "Dimension"

class RecurrenceType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The schedule recurrence.
    """

    DAILY = "Daily"
    WEEKLY = "Weekly"
    MONTHLY = "Monthly"
    ANNUALLY = "Annually"

class ReportConfigColumnType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the column in the report.
    """

    TAG = "Tag"
    DIMENSION = "Dimension"

class ReportConfigSortingDirection(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Direction of sort.
    """

    ASCENDING = "Ascending"
    DESCENDING = "Descending"

class ReportGranularityType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The granularity of rows in the report.
    """

    DAILY = "Daily"
    MONTHLY = "Monthly"

class ReportTimeframeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The time frame for pulling data for the report. If custom, then a specific time period must be
    provided.
    """

    WEEK_TO_DATE = "WeekToDate"
    MONTH_TO_DATE = "MonthToDate"
    YEAR_TO_DATE = "YearToDate"
    CUSTOM = "Custom"

class ReportType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the report. Usage represents actual usage, forecast represents forecasted data and
    UsageAndForecast represents both usage and forecasted data. Actual usage and forecasted data
    can be differentiated based on dates.
    """

    USAGE = "Usage"

class StatusType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the export's schedule. If 'Inactive', the export's schedule is paused.
    """

    ACTIVE = "Active"
    INACTIVE = "Inactive"

class TimeframeType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The time frame for pulling data for the query. If custom, then a specific time period must be
    provided.
    """

    MONTH_TO_DATE = "MonthToDate"
    BILLING_MONTH_TO_DATE = "BillingMonthToDate"
    THE_LAST_MONTH = "TheLastMonth"
    THE_LAST_BILLING_MONTH = "TheLastBillingMonth"
    WEEK_TO_DATE = "WeekToDate"
    CUSTOM = "Custom"
