# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import proxy_cluster_keys_pb2 as proxy__cluster__keys__pb2


class ProxyClusterKeysStub(object):
    """Proxy Cluster Keys are authentication keys for all proxies within a cluster.
    The proxies within a cluster share the same key. One cluster can have
    multiple keys in order to facilitate key rotation.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.ProxyClusterKeys/Create',
                request_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyCreateRequest.SerializeToString,
                response_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.ProxyClusterKeys/Get',
                request_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyGetRequest.SerializeToString,
                response_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyGetResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.ProxyClusterKeys/Delete',
                request_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyDeleteRequest.SerializeToString,
                response_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.ProxyClusterKeys/List',
                request_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyListRequest.SerializeToString,
                response_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyListResponse.FromString,
                )


class ProxyClusterKeysServicer(object):
    """Proxy Cluster Keys are authentication keys for all proxies within a cluster.
    The proxies within a cluster share the same key. One cluster can have
    multiple keys in order to facilitate key rotation.
    """

    def Create(self, request, context):
        """Create registers a new ProxyClusterKey.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one ProxyClusterKey by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a ProxyClusterKey by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of ProxyClusterKeys matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ProxyClusterKeysServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyCreateRequest.FromString,
                    response_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyGetRequest.FromString,
                    response_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyGetResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyDeleteRequest.FromString,
                    response_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=proxy__cluster__keys__pb2.ProxyClusterKeyListRequest.FromString,
                    response_serializer=proxy__cluster__keys__pb2.ProxyClusterKeyListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.ProxyClusterKeys', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class ProxyClusterKeys(object):
    """Proxy Cluster Keys are authentication keys for all proxies within a cluster.
    The proxies within a cluster share the same key. One cluster can have
    multiple keys in order to facilitate key rotation.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ProxyClusterKeys/Create',
            proxy__cluster__keys__pb2.ProxyClusterKeyCreateRequest.SerializeToString,
            proxy__cluster__keys__pb2.ProxyClusterKeyCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ProxyClusterKeys/Get',
            proxy__cluster__keys__pb2.ProxyClusterKeyGetRequest.SerializeToString,
            proxy__cluster__keys__pb2.ProxyClusterKeyGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ProxyClusterKeys/Delete',
            proxy__cluster__keys__pb2.ProxyClusterKeyDeleteRequest.SerializeToString,
            proxy__cluster__keys__pb2.ProxyClusterKeyDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.ProxyClusterKeys/List',
            proxy__cluster__keys__pb2.ProxyClusterKeyListRequest.SerializeToString,
            proxy__cluster__keys__pb2.ProxyClusterKeyListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
