# This file was automatically generated by SWIG (http://www.swig.org).
# Version 4.0.2
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info < (2, 7, 0):
    raise RuntimeError("Python 2.7 or later required")

# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _v8eval
else:
    import _v8eval

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "thisown":
            self.this.own(value)
        elif name == "this":
            set(self, name, value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def set_flags(flags):
    return _v8eval.set_flags(flags)

def initialize():
    return _v8eval.initialize()

def dispose():
    return _v8eval.dispose()
class _V8(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _v8eval._V8_swiginit(self, _v8eval.new__V8())
    __swig_destroy__ = _v8eval.delete__V8

    def eval(self, src):
        return _v8eval._V8_eval(self, src)

    def call(self, func, args):
        return _v8eval._V8_call(self, func, args)

# Register _V8 in _v8eval:
_v8eval._V8_swigregister(_V8)

class _PythonV8(_V8):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self):
        _v8eval._PythonV8_swiginit(self, _v8eval.new__PythonV8())
    __swig_destroy__ = _v8eval.delete__PythonV8

# Register _PythonV8 in _v8eval:
_v8eval._PythonV8_swigregister(_PythonV8)



# the following is appended to swig-generated file including _PythonV8
import json, sys


PY3 = sys.version_info[0] == 3
if PY3:
    string_type = str
else:
    string_type = basestring


class V8Error(Exception):
    """Represents a V8 exception.

    Args:
        message (str): The message of a V8 exception.
    """
    def __init__(self, message):
        self.message = message

    def __str__(self):
        return self.message


class V8:
    """Represents a V8 instance."""
    def __init__(self):
        self._v8 = _PythonV8()

    def eval(self, src):
        """Evaluates JavaScript code.

        Args:
            src (str): JavaScript code.

        Returns:
            The result of the JavaScript code.
            The result is marshalled/unmarshalled by using JSON.

        Raises:
            TypeError: If src is not a string.

            V8Error: If some JavaScript exception happens.
        """
        if not isinstance(src, string_type):
            raise TypeError('source code not string')

        res = self._v8.eval(src)
        if res == 'undefined':
            return None
        else:
            try:
                return json.loads(res)
            except ValueError:
                raise V8Error(res)

    def call(self, func, args):
        """Calls a JavaScript function.

        Args:
            func (str): Name of a JavaScript function.

            args (list): Argument list to pass.

        Returns:
            The result of the JavaScript function.
            The result is marshalled/unmarshalled by using JSON.

        Raises:
            TypeError: If either func is not a string or args is not a list.

            V8Error: If some JavaScript exception happens.
        """
        if not isinstance(func, string_type):
            raise TypeError('function name not string')
        if not isinstance(args, list):
            raise TypeError('arguments not list')

        args_str = json.dumps(args)
        res = self._v8.call(func, args_str)
        if res == 'undefined':
            return None
        else:
            try:
                return json.loads(res)
            except ValueError:
                raise V8Error(res)


# initialize the V8 runtime environment
initialize()
