# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class AvailableContacts(msrest.serialization.Model):
    """Customer retrieves list of Available Contacts for a spacecraft resource. Later, one of the available contact can be selected to create a contact.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param spacecraft: The reference to the spacecraft resource.
    :type spacecraft: ~azure_orbital.models.ResourceReference
    :ivar ground_station_name: Name of Azure Ground Station.
    :vartype ground_station_name: str
    :ivar maximum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal
     degrees.
    :vartype maximum_elevation_degrees: float
    :ivar tx_start_time: Time at which antenna transmit will be enabled.
    :vartype tx_start_time: ~datetime.datetime
    :ivar tx_end_time: Time at which antenna transmit will be disabled.
    :vartype tx_end_time: ~datetime.datetime
    :ivar rx_start_time: Earliest time to receive a signal.
    :vartype rx_start_time: ~datetime.datetime
    :ivar rx_end_time: Time to lost receiving a signal.
    :vartype rx_end_time: ~datetime.datetime
    :ivar start_azimuth_degrees: Azimuth of the antenna at the start of the contact in decimal
     degrees.
    :vartype start_azimuth_degrees: float
    :ivar end_azimuth_degrees: Azimuth of the antenna at the end of the contact in decimal degrees.
    :vartype end_azimuth_degrees: float
    :ivar start_elevation_degrees: Spacecraft elevation above the horizon at contact start.
    :vartype start_elevation_degrees: float
    :ivar end_elevation_degrees: Spacecraft elevation above the horizon at contact end.
    :vartype end_elevation_degrees: float
    """

    _validation = {
        'ground_station_name': {'readonly': True},
        'maximum_elevation_degrees': {'readonly': True},
        'tx_start_time': {'readonly': True},
        'tx_end_time': {'readonly': True},
        'rx_start_time': {'readonly': True},
        'rx_end_time': {'readonly': True},
        'start_azimuth_degrees': {'readonly': True},
        'end_azimuth_degrees': {'readonly': True},
        'start_elevation_degrees': {'readonly': True},
        'end_elevation_degrees': {'readonly': True},
    }

    _attribute_map = {
        'spacecraft': {'key': 'spacecraft', 'type': 'ResourceReference'},
        'ground_station_name': {'key': 'groundStationName', 'type': 'str'},
        'maximum_elevation_degrees': {'key': 'properties.maximumElevationDegrees', 'type': 'float'},
        'tx_start_time': {'key': 'properties.txStartTime', 'type': 'iso-8601'},
        'tx_end_time': {'key': 'properties.txEndTime', 'type': 'iso-8601'},
        'rx_start_time': {'key': 'properties.rxStartTime', 'type': 'iso-8601'},
        'rx_end_time': {'key': 'properties.rxEndTime', 'type': 'iso-8601'},
        'start_azimuth_degrees': {'key': 'properties.startAzimuthDegrees', 'type': 'float'},
        'end_azimuth_degrees': {'key': 'properties.endAzimuthDegrees', 'type': 'float'},
        'start_elevation_degrees': {'key': 'properties.startElevationDegrees', 'type': 'float'},
        'end_elevation_degrees': {'key': 'properties.endElevationDegrees', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableContacts, self).__init__(**kwargs)
        self.spacecraft = kwargs.get('spacecraft', None)
        self.ground_station_name = None
        self.maximum_elevation_degrees = None
        self.tx_start_time = None
        self.tx_end_time = None
        self.rx_start_time = None
        self.rx_end_time = None
        self.start_azimuth_degrees = None
        self.end_azimuth_degrees = None
        self.start_elevation_degrees = None
        self.end_elevation_degrees = None


class AvailableContactsListResult(msrest.serialization.Model):
    """Response for the ListAvailableContacts API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of available contacts.
    :type value: list[~azure_orbital.models.AvailableContacts]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableContacts]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableContactsListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class AvailableGroundStation(msrest.serialization.Model):
    """GroundStations available to schedule Contacts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of groundStation.
    :vartype id: str
    :ivar name: Name of the ground station.
    :vartype name: str
    :param location: Azure region.
    :type location: str
    :ivar type: Resource type.
    :vartype type: str
    :param city: City of ground station.
    :type city: str
    :param provider_name: Ground station provider name.
    :type provider_name: str
    :param longitude_degrees: Longitude of the ground station in decimal degrees.
    :type longitude_degrees: float
    :param latitude_degrees: Latitude of the ground station in decimal degrees.
    :type latitude_degrees: float
    :param altitude_meters: Altitude of the ground station.
    :type altitude_meters: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'city': {'key': 'properties.city', 'type': 'str'},
        'provider_name': {'key': 'properties.providerName', 'type': 'str'},
        'longitude_degrees': {'key': 'properties.longitudeDegrees', 'type': 'float'},
        'latitude_degrees': {'key': 'properties.latitudeDegrees', 'type': 'float'},
        'altitude_meters': {'key': 'properties.altitudeMeters', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableGroundStation, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.location = kwargs.get('location', None)
        self.type = None
        self.city = kwargs.get('city', None)
        self.provider_name = kwargs.get('provider_name', None)
        self.longitude_degrees = kwargs.get('longitude_degrees', None)
        self.latitude_degrees = kwargs.get('latitude_degrees', None)
        self.altitude_meters = kwargs.get('altitude_meters', None)


class AvailableGroundStationListResult(msrest.serialization.Model):
    """Response for the AvailableGroundStations API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of ground station resources.
    :type value: list[~azure_orbital.models.AvailableGroundStation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailableGroundStation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AvailableGroundStationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param target: The target of the particular error. For example, the name of the property in
     error.
    :type target: str
    :param details: A list of additional details about the error.
    :type details: list[~azure_orbital.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure_orbital.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure_orbital.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class Contact(ProxyResource):
    """Customer creates a contact resource for a spacecraft resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure_orbital.models.SystemData
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar status: Status of a contact. Possible values include: "scheduled", "cancelled",
     "succeeded", "failed", "providerCancelled".
    :vartype status: str or ~azure_orbital.models.Status
    :param reservation_start_time: Reservation start time of a contact.
    :type reservation_start_time: ~datetime.datetime
    :param reservation_end_time: Reservation end time of a contact.
    :type reservation_end_time: ~datetime.datetime
    :ivar rx_start_time: Receive start time of a contact.
    :vartype rx_start_time: ~datetime.datetime
    :ivar rx_end_time: Receive end time of a contact.
    :vartype rx_end_time: ~datetime.datetime
    :ivar tx_start_time: Transmit start time of a contact.
    :vartype tx_start_time: ~datetime.datetime
    :ivar tx_end_time: Transmit end time of a contact.
    :vartype tx_end_time: ~datetime.datetime
    :ivar error_message: Any error message while scheduling a contact.
    :vartype error_message: str
    :ivar maximum_elevation_degrees: Maximum elevation of the antenna during the contact in decimal
     degrees.
    :vartype maximum_elevation_degrees: float
    :ivar start_azimuth_degrees: Azimuth of the antenna at the start of the contact in decimal
     degrees.
    :vartype start_azimuth_degrees: float
    :ivar end_azimuth_degrees: Azimuth of the antenna at the end of the contact in decimal degrees.
    :vartype end_azimuth_degrees: float
    :param ground_station_name: Azure Ground Station name.
    :type ground_station_name: str
    :ivar start_elevation_degrees: Spacecraft elevation above the horizon at contact start.
    :vartype start_elevation_degrees: float
    :ivar end_elevation_degrees: Spacecraft elevation above the horizon at contact end.
    :vartype end_elevation_degrees: float
    :param contact_profile: The reference to the contact profile resource.
    :type contact_profile: ~azure_orbital.models.ResourceReference
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'etag': {'readonly': True},
        'status': {'readonly': True},
        'rx_start_time': {'readonly': True},
        'rx_end_time': {'readonly': True},
        'tx_start_time': {'readonly': True},
        'tx_end_time': {'readonly': True},
        'error_message': {'readonly': True},
        'maximum_elevation_degrees': {'readonly': True},
        'start_azimuth_degrees': {'readonly': True},
        'end_azimuth_degrees': {'readonly': True},
        'start_elevation_degrees': {'readonly': True},
        'end_elevation_degrees': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'etag': {'key': 'etag', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'reservation_start_time': {'key': 'properties.reservationStartTime', 'type': 'iso-8601'},
        'reservation_end_time': {'key': 'properties.reservationEndTime', 'type': 'iso-8601'},
        'rx_start_time': {'key': 'properties.rxStartTime', 'type': 'iso-8601'},
        'rx_end_time': {'key': 'properties.rxEndTime', 'type': 'iso-8601'},
        'tx_start_time': {'key': 'properties.txStartTime', 'type': 'iso-8601'},
        'tx_end_time': {'key': 'properties.txEndTime', 'type': 'iso-8601'},
        'error_message': {'key': 'properties.errorMessage', 'type': 'str'},
        'maximum_elevation_degrees': {'key': 'properties.maximumElevationDegrees', 'type': 'float'},
        'start_azimuth_degrees': {'key': 'properties.startAzimuthDegrees', 'type': 'float'},
        'end_azimuth_degrees': {'key': 'properties.endAzimuthDegrees', 'type': 'float'},
        'ground_station_name': {'key': 'properties.groundStationName', 'type': 'str'},
        'start_elevation_degrees': {'key': 'properties.startElevationDegrees', 'type': 'float'},
        'end_elevation_degrees': {'key': 'properties.endElevationDegrees', 'type': 'float'},
        'contact_profile': {'key': 'properties.contactProfile', 'type': 'ResourceReference'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Contact, self).__init__(**kwargs)
        self.etag = None
        self.status = None
        self.reservation_start_time = kwargs.get('reservation_start_time', None)
        self.reservation_end_time = kwargs.get('reservation_end_time', None)
        self.rx_start_time = None
        self.rx_end_time = None
        self.tx_start_time = None
        self.tx_end_time = None
        self.error_message = None
        self.maximum_elevation_degrees = None
        self.start_azimuth_degrees = None
        self.end_azimuth_degrees = None
        self.ground_station_name = kwargs.get('ground_station_name', None)
        self.start_elevation_degrees = None
        self.end_elevation_degrees = None
        self.contact_profile = kwargs.get('contact_profile', None)


class ContactListResult(msrest.serialization.Model):
    """Response for the ListContacts API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of contact resources in a resource group.
    :type value: list[~azure_orbital.models.Contact]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Contact]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ContactParameters(msrest.serialization.Model):
    """Parameters that define the contact resource.

    All required parameters must be populated in order to send to Azure.

    :param contact_profile: Required. The reference to the contact profile resource.
    :type contact_profile: ~azure_orbital.models.ResourceReference
    :param ground_station_name: Required. Name of Azure Ground Station.
    :type ground_station_name: str
    :param start_time: Required. Start time of a contact.
    :type start_time: ~datetime.datetime
    :param end_time: Required. End time of a contact.
    :type end_time: ~datetime.datetime
    """

    _validation = {
        'contact_profile': {'required': True},
        'ground_station_name': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'contact_profile': {'key': 'contactProfile', 'type': 'ResourceReference'},
        'ground_station_name': {'key': 'groundStationName', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactParameters, self).__init__(**kwargs)
        self.contact_profile = kwargs['contact_profile']
        self.ground_station_name = kwargs['ground_station_name']
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure_orbital.models.SystemData
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs['location']


class ContactProfile(TrackedResource):
    """Customer creates a Contact Profile Resource, which will contain all of the configurations required for scheduling a contact.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure_orbital.models.SystemData
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param minimum_viable_contact_duration: Minimum viable contact duration in ISO 8601 format.
    :type minimum_viable_contact_duration: str
    :param minimum_elevation_degrees: Minimum viable elevation for the contact in decimal degrees.
    :type minimum_elevation_degrees: float
    :param auto_tracking_configuration: Auto track configuration. Possible values include:
     "disabled", "xBand", "sBand".
    :type auto_tracking_configuration: str or ~azure_orbital.models.AutoTrackingConfiguration
    :param links: Links of the Contact Profile.
    :type links: list[~azure_orbital.models.ContactProfileLink]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'minimum_viable_contact_duration': {'key': 'properties.minimumViableContactDuration', 'type': 'str'},
        'minimum_elevation_degrees': {'key': 'properties.minimumElevationDegrees', 'type': 'float'},
        'auto_tracking_configuration': {'key': 'properties.autoTrackingConfiguration', 'type': 'str'},
        'links': {'key': 'properties.links', 'type': '[ContactProfileLink]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactProfile, self).__init__(**kwargs)
        self.etag = None
        self.minimum_viable_contact_duration = kwargs.get('minimum_viable_contact_duration', None)
        self.minimum_elevation_degrees = kwargs.get('minimum_elevation_degrees', None)
        self.auto_tracking_configuration = kwargs.get('auto_tracking_configuration', None)
        self.links = kwargs.get('links', None)


class ContactProfileLink(msrest.serialization.Model):
    """Contact Profile link.

    All required parameters must be populated in order to send to Azure.

    :param polarization: Required. polarization. eg (RHCP, LHCP). Possible values include: "RHCP",
     "LHCP", "dualRhcpLhcp", "linearVertical", "linearHorizontal".
    :type polarization: str or ~azure_orbital.models.Polarization
    :param direction: Required. Direction (uplink or downlink). Possible values include: "uplink",
     "downlink".
    :type direction: str or ~azure_orbital.models.Direction
    :param gain_over_temperature: Gain To Noise Temperature in db/K.
    :type gain_over_temperature: float
    :param eirpd_bw: Effective Isotropic Radiated Power (EIRP) in dBW.
    :type eirpd_bw: float
    :param channels: Required. Contact Profile Link Channel.
    :type channels: list[~azure_orbital.models.ContactProfileLinkChannel]
    """

    _validation = {
        'polarization': {'required': True},
        'direction': {'required': True},
        'channels': {'required': True},
    }

    _attribute_map = {
        'polarization': {'key': 'polarization', 'type': 'str'},
        'direction': {'key': 'direction', 'type': 'str'},
        'gain_over_temperature': {'key': 'gainOverTemperature', 'type': 'float'},
        'eirpd_bw': {'key': 'eirpdBW', 'type': 'float'},
        'channels': {'key': 'channels', 'type': '[ContactProfileLinkChannel]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactProfileLink, self).__init__(**kwargs)
        self.polarization = kwargs['polarization']
        self.direction = kwargs['direction']
        self.gain_over_temperature = kwargs.get('gain_over_temperature', None)
        self.eirpd_bw = kwargs.get('eirpd_bw', None)
        self.channels = kwargs['channels']


class ContactProfileLinkChannel(msrest.serialization.Model):
    """Contact Profile Link Channel.

    All required parameters must be populated in order to send to Azure.

    :param center_frequency_m_hz: Required. Center Frequency in MHz.
    :type center_frequency_m_hz: float
    :param bandwidth_m_hz: Required. Bandwidth in MHz.
    :type bandwidth_m_hz: float
    :param end_point: Required. Customer End point to store/retrieve data during a contact.
    :type end_point: ~azure_orbital.models.EndPoint
    :param modulation_configuration: Configuration for modulation.
    :type modulation_configuration: str
    :param demodulation_configuration: Configuration for demodulation.
    :type demodulation_configuration: str
    :param encoding_configuration: Configuration for encoding.
    :type encoding_configuration: str
    :param decoding_configuration: Configuration for decoding.
    :type decoding_configuration: str
    """

    _validation = {
        'center_frequency_m_hz': {'required': True},
        'bandwidth_m_hz': {'required': True},
        'end_point': {'required': True},
    }

    _attribute_map = {
        'center_frequency_m_hz': {'key': 'centerFrequencyMHz', 'type': 'float'},
        'bandwidth_m_hz': {'key': 'bandwidthMHz', 'type': 'float'},
        'end_point': {'key': 'endPoint', 'type': 'EndPoint'},
        'modulation_configuration': {'key': 'modulationConfiguration', 'type': 'str'},
        'demodulation_configuration': {'key': 'demodulationConfiguration', 'type': 'str'},
        'encoding_configuration': {'key': 'encodingConfiguration', 'type': 'str'},
        'decoding_configuration': {'key': 'decodingConfiguration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactProfileLinkChannel, self).__init__(**kwargs)
        self.center_frequency_m_hz = kwargs['center_frequency_m_hz']
        self.bandwidth_m_hz = kwargs['bandwidth_m_hz']
        self.end_point = kwargs['end_point']
        self.modulation_configuration = kwargs.get('modulation_configuration', None)
        self.demodulation_configuration = kwargs.get('demodulation_configuration', None)
        self.encoding_configuration = kwargs.get('encoding_configuration', None)
        self.decoding_configuration = kwargs.get('decoding_configuration', None)


class ContactProfileListResult(msrest.serialization.Model):
    """Response for the ListContactProfiles API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of contact profile resources in a resource group.
    :type value: list[~azure_orbital.models.ContactProfile]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContactProfile]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContactProfileListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class EndPoint(msrest.serialization.Model):
    """Customer End point to store/retrieve data during a contact.

    All required parameters must be populated in order to send to Azure.

    :param ip_address: Required. IP Address.
    :type ip_address: str
    :param end_point_name: Required. Name of an end point.
    :type end_point_name: str
    :param port: Required. TCP port to listen on to receive data.
    :type port: str
    :param protocol: Required. Protocol either UDP or TCP. Possible values include: "TCP", "UDP".
    :type protocol: str or ~azure_orbital.models.Protocol
    """

    _validation = {
        'ip_address': {'required': True},
        'end_point_name': {'required': True},
        'port': {'required': True},
        'protocol': {'required': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'end_point_name': {'key': 'endPointName', 'type': 'str'},
        'port': {'key': 'port', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EndPoint, self).__init__(**kwargs)
        self.ip_address = kwargs['ip_address']
        self.end_point_name = kwargs['end_point_name']
        self.port = kwargs['port']
        self.protocol = kwargs['protocol']


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :param display: Localized display information for this particular operation.
    :type display: ~azure_orbital.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Possible values include: "user",
     "system", "user,system".
    :vartype origin: str or ~azure_orbital.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Possible values include: "Internal".
    :vartype action_type: str or ~azure_orbital.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = kwargs.get('display', None)
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure_orbital.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ResourceIdListResult(msrest.serialization.Model):
    """Response for an API service call that lists the resource IDs of resources associated with another resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of Azure Resource IDs.
    :type value: list[~azure_orbital.models.ResourceIdListResultValueItem]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceIdListResultValueItem]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ResourceIdListResultValueItem(msrest.serialization.Model):
    """ResourceIdListResultValueItem.

    :param id: The Azure Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceIdListResultValueItem, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ResourceReference(msrest.serialization.Model):
    """Resource Reference.

    :param id: Resource ID.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceReference, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class Spacecraft(TrackedResource):
    """Customer creates a spacecraft resource to schedule a contact.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure_orbital.models.SystemData
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :param norad_id: NORAD ID of the spacecraft.
    :type norad_id: str
    :ivar authorization_status: Authorization status of spacecraft. Possible values include:
     "Allowed", "Pending", "Denied".
    :vartype authorization_status: str or ~azure_orbital.models.AuthorizationStatus
    :ivar authorization_status_extended: Details of the authorization status.
    :vartype authorization_status_extended: str
    :param title_line: Title line of Two Line Element (TLE).
    :type title_line: str
    :param tle_line1: Line 1 of Two Line Element (TLE).
    :type tle_line1: str
    :param tle_line2: Line 2 of Two Line Element (TLE).
    :type tle_line2: str
    :param links: Links of the Spacecraft.
    :type links: list[~azure_orbital.models.SpacecraftLink]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'location': {'required': True},
        'etag': {'readonly': True},
        'authorization_status': {'readonly': True},
        'authorization_status_extended': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'norad_id': {'key': 'properties.noradId', 'type': 'str'},
        'authorization_status': {'key': 'properties.authorizationStatus', 'type': 'str'},
        'authorization_status_extended': {'key': 'properties.authorizationStatusExtended', 'type': 'str'},
        'title_line': {'key': 'properties.titleLine', 'type': 'str'},
        'tle_line1': {'key': 'properties.tleLine1', 'type': 'str'},
        'tle_line2': {'key': 'properties.tleLine2', 'type': 'str'},
        'links': {'key': 'properties.links', 'type': '[SpacecraftLink]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Spacecraft, self).__init__(**kwargs)
        self.etag = None
        self.norad_id = kwargs.get('norad_id', None)
        self.authorization_status = None
        self.authorization_status_extended = None
        self.title_line = kwargs.get('title_line', None)
        self.tle_line1 = kwargs.get('tle_line1', None)
        self.tle_line2 = kwargs.get('tle_line2', None)
        self.links = kwargs.get('links', None)


class SpacecraftLink(msrest.serialization.Model):
    """Spacecraft Link.

    All required parameters must be populated in order to send to Azure.

    :param center_frequency_m_hz: Required. Center Frequency in MHz.
    :type center_frequency_m_hz: float
    :param bandwidth_m_hz: Required. Bandwidth in MHz.
    :type bandwidth_m_hz: float
    :param direction: Required. Direction (uplink or downlink). Possible values include: "uplink",
     "downlink".
    :type direction: str or ~azure_orbital.models.Direction
    :param polarization: Required. polarization. eg (RHCP, LHCP). Possible values include: "RHCP",
     "LHCP", "dualRhcpLhcp", "linearVertical", "linearHorizontal".
    :type polarization: str or ~azure_orbital.models.Polarization
    """

    _validation = {
        'center_frequency_m_hz': {'required': True},
        'bandwidth_m_hz': {'required': True},
        'direction': {'required': True},
        'polarization': {'required': True},
    }

    _attribute_map = {
        'center_frequency_m_hz': {'key': 'centerFrequencyMHz', 'type': 'float'},
        'bandwidth_m_hz': {'key': 'bandwidthMHz', 'type': 'float'},
        'direction': {'key': 'direction', 'type': 'str'},
        'polarization': {'key': 'polarization', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SpacecraftLink, self).__init__(**kwargs)
        self.center_frequency_m_hz = kwargs['center_frequency_m_hz']
        self.bandwidth_m_hz = kwargs['bandwidth_m_hz']
        self.direction = kwargs['direction']
        self.polarization = kwargs['polarization']


class SpacecraftListResult(msrest.serialization.Model):
    """Response for the ListSpacecrafts API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: A list of spacecraft resources in a resource group.
    :type value: list[~azure_orbital.models.Spacecraft]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Spacecraft]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SpacecraftListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure_orbital.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure_orbital.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TagsObject(msrest.serialization.Model):
    """Tags object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TagsObject, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
