/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import java.io.File;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.ModelValidator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;

public class DefaultModelJobValidatorServiceProvider
implements JobValidatorService {
    @Override
    public File validateJob(File jobFile) throws JobValidationException {
        return jobFile;
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job) throws JobValidationException {
        ModelValidatorContext context = new ModelValidatorContext(job);
        for (JobVariable jobVariable : job.getVariables().values()) {
            this.checkVariableFormat(null, jobVariable, context);
            context.updateJobWithContext(job);
        }
        for (Task task : job.getTasks()) {
            context = new ModelValidatorContext(task);
            for (TaskVariable taskVariable : task.getVariables().values()) {
                this.checkVariableFormat(task, taskVariable, context);
                context.updateTaskWithContext(task);
            }
        }
        return job;
    }

    protected void checkVariableFormat(Task task, JobVariable variable, ModelValidatorContext context) throws JobValidationException {
        if (variable.getModel() != null && !variable.getModel().trim().isEmpty()) {
            String model = variable.getModel().trim();
            try {
                new ModelValidator(model).validate(variable.getValue(), context);
            }
            catch (Exception e) {
                throw new JobValidationException((task != null ? "Task '" + task.getName() + "': " : "") + "Variable '" + variable.getName() + "': Model " + variable.getModel() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

