/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.utils;

import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.log4j.Logger;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.utils.ObjectArrayFormatter;

@PublicAPI
public class Tools {
    public static String formatNChar(int toFormat, int nbChar, char replacement) {
        String formatted = toFormat + "";
        while (formatted.length() < nbChar) {
            formatted = replacement + formatted;
        }
        return formatted;
    }

    public static String getFormattedDuration(long start, long end) {
        if (start < 0L || end < 0L) {
            return "Not yet";
        }
        long duration = Math.abs(start - end);
        String formatted = "";
        int tmp = (int)duration % 1000;
        formatted = Tools.formatNChar(tmp, 3, ' ') + "ms" + formatted;
        tmp = (int)(duration /= 1000L) % 60;
        duration /= 60L;
        if (tmp > 0) {
            formatted = Tools.formatNChar(tmp, 2, ' ') + "s " + formatted;
        }
        tmp = (int)duration % 60;
        duration /= 60L;
        if (tmp > 0) {
            formatted = Tools.formatNChar(tmp, 2, ' ') + "m " + formatted;
        }
        tmp = (int)duration % 24;
        duration /= 24L;
        if (tmp > 0) {
            formatted = Tools.formatNChar(tmp, 2, ' ') + "h " + formatted;
        }
        if ((tmp = (int)duration) > 0) {
            formatted = tmp + " day" + (tmp > 1 ? "s" : "") + " - " + formatted;
        }
        return formatted;
    }

    public static String getFormattedDate(long time) {
        if (time < 0L) {
            return "Not yet";
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        return sdf.format(new Date(time));
    }

    public static String getElapsedTime(long time) {
        long seconds = (System.currentTimeMillis() - time) / 1000L;
        StringBuilder ret = new StringBuilder();
        long day = seconds / 86400L;
        long hou = (seconds -= day * 86400L) / 3600L;
        long min = (seconds -= hou * 3600L) / 60L;
        long sec = seconds % 60L;
        if (day > 0L) {
            ret.append(day + "d ");
            ret.append(hou + "h ");
        } else if (hou > 0L) {
            ret.append(hou + "h");
            ret.append(min + "mn ");
        } else if (min > 0L) {
            ret.append(min + "mn ");
        } else {
            ret.append(sec + "s ");
        }
        ret.append("ago");
        return ret.toString();
    }

    public static long formatDate(String pattern) {
        String[] splitted = pattern.split(":");
        int[] factor = new int[]{3600000, 60000, 1000};
        if (splitted.length < 0 || splitted.length > 3) {
            return 0L;
        }
        long date = 0L;
        try {
            for (int i = splitted.length - 1; i >= 0; --i) {
                date += (long)(Integer.parseInt(splitted[i]) * factor[i + 3 - splitted.length]);
            }
            return date;
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static String getHostURL(String url) {
        URI uri = URI.create(url);
        String scheme = uri.getScheme() == null ? "rmi" : uri.getScheme();
        String host = uri.getHost() == null ? "localhost" : uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            return scheme + "://" + host + "/";
        }
        return scheme + "://" + host + ":" + port + "/";
    }

    public static String[] parseCommandLine(String cmdLine) {
        int specialToken = 37;
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder tmp = new StringBuilder();
        char[] cs = cmdLine.toCharArray();
        block4: for (int i = 0; i < cs.length; ++i) {
            switch (cs[i]) {
                case '%': {
                    if (i + 1 >= cs.length) continue block4;
                    tmp.append(cs[i + 1]);
                    ++i;
                    continue block4;
                }
                case ' ': {
                    tokens.add(tmp.toString());
                    tmp = new StringBuilder();
                    continue block4;
                }
                default: {
                    tmp.append(cs[i]);
                }
            }
        }
        if (tmp.length() > 0) {
            tokens.add(tmp.toString());
        }
        return tokens.toArray(new String[0]);
    }

    public static String shellExtension() {
        if (System.getProperty("os.name").contains("Windows")) {
            return ".bat";
        }
        return "";
    }

    public static String getStringAsArray(ObjectArrayFormatter oaf) {
        return oaf.getAsString();
    }

    public static long parsePeriod(String periodString) {
        if ((periodString = periodString.trim()).isEmpty()) {
            throw new IllegalArgumentException("Period string is empty");
        }
        long total = 0L;
        StringBuilder numberStr = new StringBuilder();
        for (int i = 0; i < periodString.length(); ++i) {
            long millis;
            char ch = periodString.charAt(i);
            if (Character.isSpaceChar(ch)) continue;
            if (Character.isDigit(ch)) {
                numberStr.append(ch);
                continue;
            }
            if (ch == 's') {
                millis = 1000L;
            } else if (ch == 'm') {
                millis = 60000L;
            } else if (ch == 'h') {
                millis = 3600000L;
            } else if (ch == 'd') {
                millis = 86400000L;
            } else {
                throw new IllegalArgumentException("Invalid period string: " + ch);
            }
            if (numberStr.length() == 0) {
                throw new IllegalArgumentException("Period length isn't specified");
            }
            total += Long.valueOf(numberStr.toString()) * millis;
            numberStr = new StringBuilder();
        }
        if (numberStr.length() != 0) {
            throw new IllegalArgumentException("Period string isn't specified");
        }
        return total;
    }

    public static void logAvailableScriptEngines(Logger logger) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> engineFactories = scriptEngineManager.getEngineFactories();
        StringBuilder buffer = new StringBuilder();
        buffer.append("Available script engines: ");
        int engineFactoriesCount = engineFactories.size();
        for (int i = 0; i < engineFactoriesCount; ++i) {
            ScriptEngineFactory scriptEngineFactory = engineFactories.get(i);
            buffer.append(scriptEngineFactory.getEngineName());
            buffer.append(" (");
            buffer.append(scriptEngineFactory.getEngineVersion());
            buffer.append(")");
            if (i >= engineFactoriesCount - 1) continue;
            buffer.append(", ");
        }
        logger.info((Object)buffer.toString());
    }
}

