/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scripting.helper.progress;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ProgressFile {
    public static int getProgress(String progressFilePath) {
        return ProgressFile.getProgress(Paths.get(progressFilePath, new String[0]));
    }

    public static int getProgress(Path progressFile) {
        if (!Files.exists(progressFile, new LinkOption[0])) {
            return 0;
        }
        try {
            String line = com.google.common.io.Files.readFirstLine((File)progressFile.toFile(), (Charset)Charset.defaultCharset());
            if (line == null) {
                return 0;
            }
            try {
                int value = (int)Double.parseDouble(line);
                if (!ProgressFile.isValidProgressValue(value)) {
                    ProgressFile.logError("Invalid progress value: " + value);
                    return -1;
                }
                return value;
            }
            catch (NumberFormatException e) {
                ProgressFile.logError("Progress value is a not a numeric value: " + line);
                return -1;
            }
        }
        catch (IOException e) {
            ProgressFile.logError("Error while reading the first line of " + progressFile);
            return -1;
        }
    }

    public static boolean isValidProgressValue(int value) {
        return value >= 0 && value <= 100;
    }

    public static boolean setProgress(String progressFilePath, int value) {
        return ProgressFile.setProgress(Paths.get(progressFilePath, new String[0]), value);
    }

    public static boolean setProgress(Path progressFile, int value) {
        if (!ProgressFile.isValidProgressValue(value)) {
            return false;
        }
        return ProgressFile.setProgress(progressFile, Integer.toString(value));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean setProgress(Path progressFile, String value) {
        try (OutputStream outputStream = Files.newOutputStream(progressFile, new OpenOption[0]);){
            outputStream.write(value.getBytes(Charset.defaultCharset()));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            ProgressFile.logError("Writing progress to file '" + progressFile + "' with value '" + value + "' failed");
            return false;
        }
    }

    private static void logError(String msg) {
        System.err.println(msg);
    }
}

