/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.validator;

import com.google.common.base.Strings;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ModelSyntaxException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.exceptions.ValidationException;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ModelType;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.OptionalParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.factory.ParserValidator;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.Validator;

public class ModelValidator
implements Validator<String> {
    private String model;
    public static final String PREFIX = "PA:";
    public static final String OPTIONAL_VARIABLE_SUFFIX = "?";
    public static final List<ModelType> NEVER_OPTIONAL_MODEL = Arrays.asList(ModelType.NOT_EMPTY_STRING);

    public ModelValidator(String model) {
        if (Strings.isNullOrEmpty((String)model)) {
            throw new IllegalArgumentException("Model cannot be empty");
        }
        this.model = model.trim();
    }

    @Override
    public String validate(String parameterValue, ModelValidatorContext context, boolean isVariableHidden) throws ValidationException {
        try {
            ParserValidator<?> validator = this.createParserValidator();
            if (validator != null) {
                validator.parseAndValidate(parameterValue, context, isVariableHidden);
            }
            return parameterValue;
        }
        catch (ValidationException e) {
            throw new ValidationException(e.getMessage(), e.isHideModel(), e);
        }
        catch (Exception e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    protected ParserValidator<?> createParserValidator() throws ModelSyntaxException {
        String uppercaseModel = this.model.toUpperCase();
        if (!uppercaseModel.startsWith(PREFIX)) {
            return null;
        }
        uppercaseModel = this.removePrefix(uppercaseModel);
        for (ModelType type : ModelType.values()) {
            if (!uppercaseModel.startsWith(type.name())) continue;
            String modelNoPrefix = this.removePrefix(this.model);
            if (uppercaseModel.endsWith(OPTIONAL_VARIABLE_SUFFIX)) {
                if (NEVER_OPTIONAL_MODEL.contains((Object)type)) {
                    throw new ModelSyntaxException(String.format("Invalid model '%s': The type '%s' is disallowed to be optional", new Object[]{this.model, type}));
                }
                return new OptionalParserValidator(modelNoPrefix, type);
            }
            return ModelValidator.newParserValidator(type, modelNoPrefix);
        }
        throw new ModelSyntaxException("Unrecognized type in model '" + this.model + "'");
    }

    public static ParserValidator<?> newParserValidator(ModelType type, String model) throws ModelSyntaxException {
        try {
            return (ParserValidator)type.getTypeParserValidator().getDeclaredConstructor(String.class).newInstance(model);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Throwable exceptionCause;
            if (e instanceof InvocationTargetException && (exceptionCause = e.getCause()) instanceof ModelSyntaxException) {
                throw (ModelSyntaxException)exceptionCause;
            }
            throw new ModelSyntaxException(String.format("Error during create the parser [%s] for the model [%s].", type.getTypeParserValidator().getSimpleName(), model), e);
        }
    }

    private String removePrefix(String model) {
        return model.substring(PREFIX.length());
    }
}

