/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.rest.ds;

import com.google.common.base.Strings;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.ow2.proactive.scheduler.rest.ds.IDataSpaceClient;
import org.ow2.proactive_grid_cloud_portal.scheduler.client.utils.Zipper;

public class LocalDestination
implements IDataSpaceClient.ILocalDestination {
    private File dest;

    public LocalDestination(File dest) {
        this.dest = dest;
    }

    @Override
    public void readFrom(InputStream is, String encoding) throws IOException {
        if (Strings.isNullOrEmpty((String)encoding) || "identity".equals(encoding)) {
            Files.asByteSink((File)this.dest, (FileWriteMode[])new FileWriteMode[0]).writeFrom(is);
        } else if ("gzip".equals(encoding)) {
            Zipper.GZIP.unzip((InputStream)is, (File)this.dest);
        } else if ("zip".equals(encoding)) {
            Zipper.ZIP.unzip((InputStream)is, (File)this.dest);
        } else {
            throw new RuntimeException("Unkonwn content encoding type: " + encoding);
        }
    }

    public String toString() {
        return "LocalDestination{dest=" + this.dest + '}';
    }
}

