"""
The MIT License (MIT)

Copyright (c) Serenity Software, LLC

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
"""
# pylint: disable=too-many-arguments


class ParseResult(object):
    """Represents a single result from the parsing process"""

    type = "Unknown"
    subtype = "Unknown"
    confidence = 0
    result_value = None
    data = {}

    def __init__(
            self,
            p_type="Unknown",
            subtype="Unknown",
            confidence=0,
            value=None,
            additional_data=None
    ):
        """
        Sets up the parse result object with result data

        :param p_type: Parse result type
        :type p_type: str
        :param subtype: Parse result subtype
        :type subtype: str
        :param confidence: How confidence we are in this result, 1-100
        :type confidence: int
        :param value: representation of the parsed data
        :type value: mixed
        :param additional_data: any additional data a parser wants to provide
        :type additional_data: mixed
        """
        if additional_data is None:
            additional_data = {}

        self.type = p_type
        self.subtype = subtype
        self.confidence = confidence
        self.result_value = value
        self.data = additional_data
