#!/usr/bin/env python

# Project skeleton maintained at https://github.com/jaraco/skeleton

import io
import sys

import setuptools

with io.open('README.rst', encoding='utf-8') as readme:
	long_description = readme.read()

needs_pytest = {'pytest', 'test'}.intersection(sys.argv)
pytest_runner = ['pytest_runner'] if needs_pytest else []
needs_sphinx = {'release', 'build_sphinx', 'upload_docs'}.intersection(sys.argv)
sphinx = ['sphinx', 'rst.linker'] if needs_sphinx else []
needs_wheel = {'release', 'bdist_wheel'}.intersection(sys.argv)
wheel = ['wheel'] if needs_wheel else []

name = 'jaraco.windows'
description = 'Windows Routines by Jason R. Coombs'

setup_params = dict(
	name=name,
	use_scm_version=True,
	author="Jason R. Coombs",
	author_email="jaraco@jaraco.com",
	description=description or name,
	long_description=long_description,
	url="https://github.com/jaraco/" + name,
	packages=setuptools.find_packages(),
	include_package_data=True,
	namespace_packages=name.split('.')[:-1],
	install_requires=[
		'more_itertools',
		'six',
		'jaraco.ui',
		'jaraco.collections',
		'jaraco.text',
		'jaraco.structures>=1.1.1',
		'path.py',
	],
	extras_require={
	},
	setup_requires=[
		'setuptools_scm>=1.9',
	] + pytest_runner + sphinx + wheel,
	tests_require=[
		'pytest>=2.8',
	],
	classifiers=[
		"Development Status :: 5 - Production/Stable",
		"Intended Audience :: Developers",
		"License :: OSI Approved :: MIT License",
		"Programming Language :: Python :: 2.7",
		"Programming Language :: Python :: 3",
		"Operating System :: Microsoft :: Windows",
	],
	entry_points={
		'console_scripts': [
			'xmouse = jaraco.windows.xmouse:Command.invoke',
			'mklink = jaraco.windows.filesystem:mklink',
			'find-symlinks = jaraco.windows.filesystem:find_symlinks_cmd',
			'enver = jaraco.windows.environ:enver',
			'pclip = jaraco.windows.clipboard:paste_stdout',
			'gclip = jaraco.windows.clipboard:stdin_copy',
		],
	},
)
if __name__ == '__main__':
	setuptools.setup(**setup_params)
