# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import access_rules_pb2 as access__rules__pb2


class AccessRulesStub(object):
    """AccessRules allows the use of tags and other attributes to grant resources
    to roles. Each Role may have several access rules.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Plan = channel.unary_unary(
                '/v1.AccessRules/Plan',
                request_serializer=access__rules__pb2.AccessRulePlanRequest.SerializeToString,
                response_deserializer=access__rules__pb2.AccessRulePlanResponse.FromString,
                )
        self.Create = channel.unary_unary(
                '/v1.AccessRules/Create',
                request_serializer=access__rules__pb2.AccessRuleCreateRequest.SerializeToString,
                response_deserializer=access__rules__pb2.AccessRuleCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.AccessRules/Get',
                request_serializer=access__rules__pb2.AccessRuleGetRequest.SerializeToString,
                response_deserializer=access__rules__pb2.AccessRuleGetResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.AccessRules/Update',
                request_serializer=access__rules__pb2.AccessRuleUpdateRequest.SerializeToString,
                response_deserializer=access__rules__pb2.AccessRuleUpdateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.AccessRules/Delete',
                request_serializer=access__rules__pb2.AccessRuleDeleteRequest.SerializeToString,
                response_deserializer=access__rules__pb2.AccessRuleDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.AccessRules/List',
                request_serializer=access__rules__pb2.AccessRuleListRequest.SerializeToString,
                response_deserializer=access__rules__pb2.AccessRuleListResponse.FromString,
                )
        self.Apply = channel.unary_unary(
                '/v1.AccessRules/Apply',
                request_serializer=access__rules__pb2.ApplyAccessRuleRequest.SerializeToString,
                response_deserializer=access__rules__pb2.ApplyAccessRuleResponse.FromString,
                )


class AccessRulesServicer(object):
    """AccessRules allows the use of tags and other attributes to grant resources
    to roles. Each Role may have several access rules.
    """

    def Plan(self, request, context):
        """Plan registers a new AccessRule.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Create(self, request, context):
        """Create registers a new AccessRule.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one AccessRule by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update patches a AccessRule by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a AccessRule by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of Access Rules matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Apply(self, request, context):
        """Apply resets a role and apply all given access rules.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_AccessRulesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Plan': grpc.unary_unary_rpc_method_handler(
                    servicer.Plan,
                    request_deserializer=access__rules__pb2.AccessRulePlanRequest.FromString,
                    response_serializer=access__rules__pb2.AccessRulePlanResponse.SerializeToString,
            ),
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=access__rules__pb2.AccessRuleCreateRequest.FromString,
                    response_serializer=access__rules__pb2.AccessRuleCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=access__rules__pb2.AccessRuleGetRequest.FromString,
                    response_serializer=access__rules__pb2.AccessRuleGetResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=access__rules__pb2.AccessRuleUpdateRequest.FromString,
                    response_serializer=access__rules__pb2.AccessRuleUpdateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=access__rules__pb2.AccessRuleDeleteRequest.FromString,
                    response_serializer=access__rules__pb2.AccessRuleDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=access__rules__pb2.AccessRuleListRequest.FromString,
                    response_serializer=access__rules__pb2.AccessRuleListResponse.SerializeToString,
            ),
            'Apply': grpc.unary_unary_rpc_method_handler(
                    servicer.Apply,
                    request_deserializer=access__rules__pb2.ApplyAccessRuleRequest.FromString,
                    response_serializer=access__rules__pb2.ApplyAccessRuleResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.AccessRules', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class AccessRules(object):
    """AccessRules allows the use of tags and other attributes to grant resources
    to roles. Each Role may have several access rules.
    """

    @staticmethod
    def Plan(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/Plan',
            access__rules__pb2.AccessRulePlanRequest.SerializeToString,
            access__rules__pb2.AccessRulePlanResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/Create',
            access__rules__pb2.AccessRuleCreateRequest.SerializeToString,
            access__rules__pb2.AccessRuleCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/Get',
            access__rules__pb2.AccessRuleGetRequest.SerializeToString,
            access__rules__pb2.AccessRuleGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/Update',
            access__rules__pb2.AccessRuleUpdateRequest.SerializeToString,
            access__rules__pb2.AccessRuleUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/Delete',
            access__rules__pb2.AccessRuleDeleteRequest.SerializeToString,
            access__rules__pb2.AccessRuleDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/List',
            access__rules__pb2.AccessRuleListRequest.SerializeToString,
            access__rules__pb2.AccessRuleListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Apply(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccessRules/Apply',
            access__rules__pb2.ApplyAccessRuleRequest.SerializeToString,
            access__rules__pb2.ApplyAccessRuleResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
