# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .migrate_sql_server_sql_db_task_output import MigrateSqlServerSqlDbTaskOutput


class MigrateSqlServerSqlDbTaskOutputTableLevel(MigrateSqlServerSqlDbTaskOutput):
    """MigrateSqlServerSqlDbTaskOutputTableLevel.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Result identifier
    :vartype id: str
    :param result_type: Required. Constant filled by server.
    :type result_type: str
    :ivar object_name: Name of the item
    :vartype object_name: str
    :ivar started_on: Migration start time
    :vartype started_on: datetime
    :ivar ended_on: Migration end time
    :vartype ended_on: datetime
    :ivar state: Current state of migration. Possible values include: 'None',
     'InProgress', 'Failed', 'Warning', 'Completed', 'Skipped', 'Stopped'
    :vartype state: str or ~azure.mgmt.datamigration.models.MigrationState
    :ivar status_message: Status message
    :vartype status_message: str
    :ivar items_count: Number of items
    :vartype items_count: long
    :ivar items_completed_count: Number of successfully completed items
    :vartype items_completed_count: long
    :ivar error_prefix: Wildcard string prefix to use for querying all errors
     of the item
    :vartype error_prefix: str
    :ivar result_prefix: Wildcard string prefix to use for querying all
     sub-tem results of the item
    :vartype result_prefix: str
    """

    _validation = {
        'id': {'readonly': True},
        'result_type': {'required': True},
        'object_name': {'readonly': True},
        'started_on': {'readonly': True},
        'ended_on': {'readonly': True},
        'state': {'readonly': True},
        'status_message': {'readonly': True},
        'items_count': {'readonly': True},
        'items_completed_count': {'readonly': True},
        'error_prefix': {'readonly': True},
        'result_prefix': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'object_name': {'key': 'objectName', 'type': 'str'},
        'started_on': {'key': 'startedOn', 'type': 'iso-8601'},
        'ended_on': {'key': 'endedOn', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'items_count': {'key': 'itemsCount', 'type': 'long'},
        'items_completed_count': {'key': 'itemsCompletedCount', 'type': 'long'},
        'error_prefix': {'key': 'errorPrefix', 'type': 'str'},
        'result_prefix': {'key': 'resultPrefix', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(MigrateSqlServerSqlDbTaskOutputTableLevel, self).__init__(**kwargs)
        self.object_name = None
        self.started_on = None
        self.ended_on = None
        self.state = None
        self.status_message = None
        self.items_count = None
        self.items_completed_count = None
        self.error_prefix = None
        self.result_prefix = None
        self.result_type = 'TableLevelOutput'
