# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from enum import Enum


class AuthenticationType(str, Enum):

    none = "None"
    windows_authentication = "WindowsAuthentication"
    sql_authentication = "SqlAuthentication"
    active_directory_integrated = "ActiveDirectoryIntegrated"
    active_directory_password = "ActiveDirectoryPassword"


class ValidationStatus(str, Enum):

    default = "Default"
    not_started = "NotStarted"
    initialized = "Initialized"
    in_progress = "InProgress"
    completed = "Completed"
    completed_with_issues = "CompletedWithIssues"
    failed = "Failed"
    stopped = "Stopped"


class Severity(str, Enum):

    message = "Message"
    warning = "Warning"
    error = "Error"


class UpdateActionType(str, Enum):

    deleted_on_target = "DeletedOnTarget"
    changed_on_target = "ChangedOnTarget"
    added_on_target = "AddedOnTarget"


class ObjectType(str, Enum):

    stored_procedures = "StoredProcedures"
    table = "Table"
    user = "User"
    view = "View"
    function = "Function"


class MigrationState(str, Enum):

    none = "None"
    in_progress = "InProgress"
    failed = "Failed"
    warning = "Warning"
    completed = "Completed"
    skipped = "Skipped"
    stopped = "Stopped"


class DatabaseMigrationStage(str, Enum):

    none = "None"
    initialize = "Initialize"
    backup = "Backup"
    file_copy = "FileCopy"
    restore = "Restore"
    completed = "Completed"


class MigrationStatus(str, Enum):

    default = "Default"
    connecting = "Connecting"
    source_and_target_selected = "SourceAndTargetSelected"
    select_logins = "SelectLogins"
    configured = "Configured"
    running = "Running"
    error = "Error"
    stopped = "Stopped"
    completed = "Completed"
    completed_with_warnings = "CompletedWithWarnings"


class LoginMigrationStage(str, Enum):

    none = "None"
    initialize = "Initialize"
    login_migration = "LoginMigration"
    establish_user_mapping = "EstablishUserMapping"
    assign_role_membership = "AssignRoleMembership"
    assign_role_ownership = "AssignRoleOwnership"
    establish_server_permissions = "EstablishServerPermissions"
    establish_object_permissions = "EstablishObjectPermissions"
    completed = "Completed"


class LoginType(str, Enum):

    windows_user = "WindowsUser"
    windows_group = "WindowsGroup"
    sql_login = "SqlLogin"
    certificate = "Certificate"
    asymmetric_key = "AsymmetricKey"
    external_user = "ExternalUser"
    external_group = "ExternalGroup"


class DatabaseState(str, Enum):

    online = "Online"
    restoring = "Restoring"
    recovering = "Recovering"
    recovery_pending = "RecoveryPending"
    suspect = "Suspect"
    emergency = "Emergency"
    offline = "Offline"
    copying = "Copying"
    offline_secondary = "OfflineSecondary"


class DatabaseCompatLevel(str, Enum):

    compat_level80 = "CompatLevel80"
    compat_level90 = "CompatLevel90"
    compat_level100 = "CompatLevel100"
    compat_level110 = "CompatLevel110"
    compat_level120 = "CompatLevel120"
    compat_level130 = "CompatLevel130"
    compat_level140 = "CompatLevel140"


class DatabaseFileType(str, Enum):

    rows = "Rows"
    log = "Log"
    filestream = "Filestream"
    not_supported = "NotSupported"
    fulltext = "Fulltext"


class ServerLevelPermissionsGroup(str, Enum):

    default = "Default"
    migration_from_sql_server_to_azure_db = "MigrationFromSqlServerToAzureDB"


class TaskState(str, Enum):

    unknown = "Unknown"
    queued = "Queued"
    running = "Running"
    canceled = "Canceled"
    succeeded = "Succeeded"
    failed = "Failed"
    failed_input_validation = "FailedInputValidation"
    faulted = "Faulted"


class ServiceProvisioningState(str, Enum):

    accepted = "Accepted"
    deleting = "Deleting"
    deploying = "Deploying"
    stopped = "Stopped"
    stopping = "Stopping"
    starting = "Starting"
    failed_to_start = "FailedToStart"
    failed_to_stop = "FailedToStop"
    succeeded = "Succeeded"
    failed = "Failed"


class ProjectTargetPlatform(str, Enum):

    sqldb = "SQLDB"
    sqlmi = "SQLMI"
    unknown = "Unknown"


class ProjectSourcePlatform(str, Enum):

    sql = "SQL"
    unknown = "Unknown"


class ProjectProvisioningState(str, Enum):

    deleting = "Deleting"
    succeeded = "Succeeded"


class NameCheckFailureReason(str, Enum):

    already_exists = "AlreadyExists"
    invalid = "Invalid"


class ServiceScalability(str, Enum):

    none = "none"
    manual = "manual"
    automatic = "automatic"


class ResourceSkuRestrictionsType(str, Enum):

    location = "location"


class ResourceSkuRestrictionsReasonCode(str, Enum):

    quota_id = "QuotaId"
    not_available_for_subscription = "NotAvailableForSubscription"


class ResourceSkuCapacityScaleType(str, Enum):

    automatic = "Automatic"
    manual = "Manual"
    none = "None"


class ErrorType(str, Enum):

    default = "Default"
    warning = "Warning"
    error = "Error"
