#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals

# 有些通假字，单字本身没有这个读音，但是通假字可以有。
# 如：阿家阿翁 [["ā"], ["gū"], ["ā"], ["wēng"]]，家通姑。
phrases_dict = {
    "阿Ｑ": [["ā"], ["Ｑ"]],
    "阿爸": [["ā"], ["bà"]],
    "阿鼻": [["ā"], ["bí"]],
    "阿呆": [["ā"], ["dāi"]],
    "阿弟": [["ā"], ["dì"]],
    "阿爹": [["ā"], ["diē"]],
    "阿斗": [["ā"], ["dǒu"]],
    "阿飞": [["ā"], ["fēi"]],
    "阿哥": [["ā"], ["gē"]],
    "阿公": [["ā"], ["gōng"]],
    "阿訇": [["ā"], ["hōng"]],
    "阿胶": [["ē"], ["jiāo"]],
    "阿姐": [["ā"], ["jiě"]],
    "阿拉": [["ā"], ["lā"]],
    "阿妈": [["ā"], ["mā"]],
    "阿妹": [["ā"], ["mèi"]],
    "阿曼": [["ā"], ["màn"]],
    "阿门": [["ā"], ["mēn"]],
    "阿蒙": [["ā"], ["méng"]],
    "阿片": [["ā"], ["piàn"]],
    "阿婆": [["ā"], ["pó"]],
    "哎呀": [["āi"], ["yā"]],
    "哎哟": [["āi"], ["yō"]],
    "哀号": [["āi"], ["háo"]],
    "哀家": [["āi"], ["jiā"]],
    "哀矜": [["āi"], ["jīn"]],
    "哀乐": [["āi"], ["yuè"]],
    "哀思": [["āi"], ["sī"]],
    "嗳气": [["ài"], ["qì"]],
    "癌症": [["ái"], ["zhèng"]],
    "嗳酸": [["ǎi"], ["suān"]],
    "矮个": [["ǎi"], ["gè"]],
    "爱称": [["ài"], ["chēng"]],
    "爱好": [["ài"], ["hào"]],
    "隘巷": [["ài"], ["xiàng"]],
    "碍难": [["ài"], ["nán"]],
    "安度": [["ān"], ["dù"]],
    "安打": [["ān"], ["dǎ"]],
    "安分": [["ān"], ["fèn"]],
    "安好": [["ān"], ["hǎo"]],
    "安家": [["ān"], ["jiā"]],
    "安拉": [["ān"], ["lā"]],
    "安乐": [["ān"], ["lè"]],
    "安排": [["ān"], ["pái"]],
    "安宁": [["ān"], ["níng"]],
    "安上": [["ān"], ["shàng"]],
    "安详": [["ān"], ["xiáng"]],
    "俺家": [["ǎn"], ["jiā"]],
    "按脉": [["àn"], ["mài"]],
    "按摩": [["àn"], ["mó"]],
    "按期": [["àn"], ["qī"]],
    "按说": [["àn"], ["shuō"]],
    "按压": [["àn"], ["yā"]],
    "按语": [["àn"], ["yǔ"]],
    "暗藏": [["àn"], ["cáng"]],
    "暗处": [["àn"], ["chù"]],
    "暗场": [["àn"], ["chǎng"]],
    "暗地": [["àn"], ["dì"]],
    "暗号": [["àn"], ["hào"]],
    "暗合": [["àn"], ["hé"]],
    "暗语": [["àn"], ["yǔ"]],
    "暗中": [["àn"], ["zhōng"]],
    "昂藏": [["áng"], ["cáng"]],
    "暗转": [["àn"], ["zhuǎn"]],
    "凹版": [["āo"], ["bǎn"]],
    "凹洞": [["āo"], ["dòng"]],
    "凹度": [["āo"], ["dù"]],
    "凹镜": [["āo"], ["jìng"]],
    "凹凸": [["āo"], ["tū"]],
    "凹洼": [["āo"], ["wā"]],
    "凹陷": [["āo"], ["xiàn"]],
    "熬熬": [["áo"], ["áo"]],
    "熬心": [["áo"], ["xīn"]],
    "熬煎": [["áo"], ["jiān"]],
    "熬夜": [["áo"], ["yè"]],
    "鳌头": [["áo"], ["tóu"]],
    "拗断": [["ǎo"], ["duàn"]],
    "拗口": [["ào"], ["kǒu"]],
    "傲骨": [["ào"], ["gǔ"]],
    "奥博": [["ào"], ["bó"]],
    "奥兰": [["ào"], ["lán"]],
    "奥秘": [["ào"], ["mì"]],
    "奥义": [["ào"], ["yì"]],
    "奥妙": [["ào"], ["miào"]],
    "奥援": [["ào"], ["yuán"]],
    "懊丧": [["ào"], ["sàng"]],
    "奥旨": [["ào"], ["zhǐ"]],
    "八风": [["bā"], ["fēng"]],
    "八节": [["bā"], ["jié"]],
    "八角": [["bā"], ["jiǎo"]],
    "八邪": [["bā"], ["xié"]],
    "巴结": [["bā"], ["jì"]],
    "扒车": [["bā"], ["chē"]],
    "扒糕": [["pá"], ["gāo"]],
    "扒灰": [["pá"], ["huī"]],
    "扒开": [["bā"], ["kāi"]],
    "扒拉": [["bā"], ["lā"]],
    "扒皮": [["bā"], ["pí"]],
    "扒窃": [["pá"], ["qiè"]],
    "扒手": [["pá"], ["shǒu"]],
    "吧嗒": [["bā"], ["dā"]],
    "吧唧": [["bā"], ["jī"]],
    "吧女": [["bā"], ["nǚ"]],
    "吧台": [["bā"], ["tái"]],
    "笆斗": [["bā"], ["dǒu"]],
    "拔地": [["bá"], ["dì"]],
    "拔毒": [["bá"], ["dú"]],
    "拔节": [["bá"], ["jié"]],
    "把柄": [["bǎ"], ["bǐng"]],
    "把持": [["bǎ"], ["chí"]],
    "把舵": [["bǎ"], ["duò"]],
    "把风": [["bǎ"], ["fēng"]],
    "把关": [["bǎ"], ["guān"]],
    "把家": [["bǎ"], ["jiā"]],
    "把酒": [["bǎ"], ["jiǔ"]],
    "把揽": [["bǎ"], ["lǎn"]],
    "把牢": [["bǎ"], ["láo"]],
    "把门": [["bǎ"], ["mén"]],
    "把脉": [["bǎ"], ["mài"]],
    "把式": [["bǎ"], ["shì"]],
    "把势": [["bǎ"], ["shì"]],
    "把手": [["bǎ"], ["shǒu"]],
    "把守": [["bǎ"], ["shǒu"]],
    "把头": [["bǎ"], ["tóu"]],
    "把玩": [["bǎ"], ["wán"]],
    "把稳": [["bǎ"], ["wěn"]],
    "把握": [["bǎ"], ["wò"]],
    "把晤": [["bǎ"], ["wù"]],
    "把盏": [["bǎ"], ["zhǎn"]],
    "把戏": [["bǎ"], ["xì"]],
    "把住": [["bǎ"], ["zhù"]],
    "把子": [["bà"], ["zi"]],
    "靶场": [["bǎ"], ["chǎng"]],
    "靶台": [["bǎ"], ["tái"]],
    "坝地": [["bà"], ["dì"]],
    "白地": [["bái"], ["dì"]],
    "白发": [["bái"], ["fà"]],
    "白丁": [["bái"], ["dīng"]],
    "白干": [["bái"], ["qián"]],
    "白骨": [["bái"], ["gǔ"]],
    "白净": [["bái"], ["jìng"]],
    "白卷": [["bái"], ["juàn"]],
    "白露": [["bái"], ["lù"]],
    "白票": [["bái"], ["piào"]],
    "白区": [["bái"], ["qū"]],
    "白食": [["bái"], ["shí"]],
    "白蛇": [["bái"], ["shé"]],
    "白术": [["bái"], ["zhú"]],
    "白苏": [["bái"], ["sū"]],
    "白汤": [["bái"], ["tāng"]],
    "白体": [["bái"], ["tǐ"]],
    "白头": [["bái"], ["tóu"]],
    "白条": [["bái"], ["tiáo"]],
    "白相": [["bái"], ["xiàng"]],
    "白血": [["bái"], ["xuè"]],
    "白种": [["bái"], ["zhǒng"]],
    "百分": [["bǎi"], ["fēn"]],
    "百度": [["bǎi"], ["dù"]],
    "百合": [["bǎi"], ["hé"]],
    "百会": [["bǎi"], ["huì"]],
    "百万": [["bǎi"], ["wàn"]],
    "百戏": [["bǎi"], ["xì"]],
    "百叶": [["bǎi"], ["yè"]],
    "柏林": [["bó"], ["lín"]],
    "柏乡": [["bǎi"], ["xiāng"]],
    "柏油": [["bǎi"], ["yóu"]],
    "摆弄": [["bǎi"], ["nòng"]],
    "摆正": [["bǎi"], ["zhèng"]],
    "败北": [["bài"], ["běi"]],
    "败毒": [["bài"], ["dú"]],
    "败坏": [["bài"], ["huài"]],
    "败家": [["bài"], ["jiā"]],
    "败将": [["bài"], ["jiàng"]],
    "败露": [["bài"], ["lù"]],
    "败落": [["bài"], ["luò"]],
    "败兴": [["bài"], ["xìng"]],
    "败血": [["bài"], ["xuè"]],
    "败亡": [["bài"], ["wáng"]],
    "拜别": [["bài"], ["bié"]],
    "拜读": [["bài"], ["dú"]],
    "拜倒": [["bài"], ["dǎo"]],
    "拜佛": [["bài"], ["fó"]],
    "拜服": [["bài"], ["fú"]],
    "拜见": [["bài"], ["jiàn"]],
    "拜祭": [["bài"], ["jì"]],
    "拜会": [["bài"], ["huì"]],
    "拜节": [["bài"], ["jié"]],
    "扳倒": [["bān"], ["dǎo"]],
    "班禅": [["bān"], ["chán"]],
    "班车": [["bān"], ["chē"]],
    "班长": [["bān"], ["zhǎng"]],
    "班期": [["bān"], ["qī"]],
    "斑纹": [["bān"], ["wén"]],
    "搬家": [["bān"], ["jiā"]],
    "板车": [["bǎn"], ["chē"]],
    "搬弄": [["bān"], ["nòng"]],
    "板结": [["bǎn"], ["jié"]],
    "板刷": [["bǎn"], ["shuā"]],
    "板正": [["bǎn"], ["zhèng"]],
    "板铺": [["bǎn"], ["pù"]],
    "办差": [["bàn"], ["chāi"]],
    "版筑": [["bǎn"], ["zhù"]],
    "办好": [["bàn"], ["hǎo"]],
    "半大": [["bàn"], ["dà"]],
    "半价": [["bàn"], ["jià"]],
    "半空": [["bàn"], ["kōng"]],
    "半票": [["bàn"], ["piào"]],
    "半数": [["bàn"], ["shù"]],
    "半拉": [["bàn"], ["lǎ"]],
    "半休": [["bàn"], ["xiū"]],
    "半载": [["bàn"], ["zǎi"]],
    "伴读": [["bàn"], ["dú"]],
    "伴同": [["bàn"], ["tóng"]],
    "伴郎": [["bàn"], ["láng"]],
    "拌和": [["bàn"], ["huò"]],
    "扮戏": [["bàn"], ["xì"]],
    "扮相": [["bàn"], ["xiàng"]],
    "拌蒜": [["bàn"], ["suàn"]],
    "拌匀": [["bàn"], ["yún"]],
    "绊倒": [["bàn"], ["dǎo"]],
    "拌嘴": [["bàn"], ["zuǐ"]],
    "拌种": [["bàn"], ["zhǒng"]],
    "帮会": [["bāng"], ["huì"]],
    "帮教": [["bāng"], ["jiào"]],
    "帮同": [["bāng"], ["tóng"]],
    "帮佣": [["bāng"], ["yōng"]],
    "帮助": [["bāng"], ["zhù"]],
    "绑票": [["bǎng"], ["piào"]],
    "绑扎": [["bǎng"], ["zhā"]],
    "榜额": [["bǎng"], ["é"]],
    "榜首": [["bǎng"], ["shǒu"]],
    "榜书": [["bǎng"], ["shū"]],
    "榜文": [["bǎng"], ["wén"]],
    "榜眼": [["bǎng"], ["yǎn"]],
    "榜样": [["bǎng"], ["yàng"]],
    "膀臂": [["bǎng"], ["bì"]],
    "棒喝": [["bàng"], ["hè"]],
    "棒头": [["bàng"], ["tóu"]],
    "磅礴": [["páng"], ["bó"]],
    "磅秤": [["bàng"], ["chèng"]],
    "包藏": [["bāo"], ["cáng"]],
    "包被": [["bāo"], ["bèi"]],
    "包场": [["bāo"], ["chǎng"]],
    "包车": [["bāo"], ["chē"]],
    "包乘": [["bāo"], ["chéng"]],
    "包干": [["bāo"], ["gān"]],
    "包间": [["bāo"], ["jiān"]],
    "包括": [["bāo"], ["kuò"]],
    "包络": [["bāo"], ["luò"]],
    "包囊": [["bāo"], ["náng"]],
    "包票": [["bāo"], ["piào"]],
    "包头": [["bāo"], ["tóu"]],
    "包扎": [["bāo"], ["zā"]],
    "宝藏": [["bǎo"], ["zàng"]],
    "宝号": [["bǎo"], ["hào"]],
    "宝地": [["bǎo"], ["dì"]],
    "宝刹": [["bǎo"], ["chà"]],
    "宝石": [["bǎo"], ["shí"]],
    "宝应": [["bǎo"], ["yìng"]],
    "饱读": [["bǎo"], ["dú"]],
    "饱和": [["bǎo"], ["hé"]],
    "饱食": [["bǎo"], ["shí"]],
    "保长": [["bǎo"], ["cháng"]],
    "保藏": [["bǎo"], ["cáng"]],
    "保单": [["bǎo"], ["dān"]],
    "保底": [["bǎo"], ["dǐ"]],
    "保价": [["bǎo"], ["jià"]],
    "保票": [["bǎo"], ["piào"]],
    "保鲜": [["bǎo"], ["xiān"]],
    "保有": [["bǎo"], ["yǒu"]],
    "保重": [["bǎo"], ["zhòng"]],
    "堡垒": [["bǎo"], ["lěi"]],
    "堡寨": [["bǎo"], ["zhài"]],
    "堡子": [["bǔ"], ["zi"]],
    "报答": [["bào"], ["dá"]],
    "报单": [["bào"], ["dān"]],
    "报仇": [["bào"], ["chóu"]],
    "报价": [["bào"], ["jià"]],
    "报丧": [["bào"], ["sāng"]],
    "报数": [["bào"], ["shù"]],
    "报头": [["bào"], ["tóu"]],
    "报信": [["bào"], ["xìn"]],
    "报应": [["bào"], ["yìng"]],
    "报知": [["bào"], ["zhī"]],
    "暴毙": [["bào"], ["bì"]],
    "暴病": [["bào"], ["bìng"]],
    "暴跌": [["bào"], ["diē"]],
    "暴动": [["bào"], ["dòng"]],
    "暴发": [["bào"], ["fā"]],
    "暴风": [["bào"], ["fēng"]],
    "暴光": [["bào"], ["guāng"]],
    "暴富": [["bào"], ["fù"]],
    "暴客": [["bào"], ["kè"]],
    "暴君": [["bào"], ["jūn"]],
    "暴力": [["bào"], ["lì"]],
    "暴吏": [["bào"], ["lì"]],
    "暴戾": [["bào"], ["lì"]],
    "暴利": [["bào"], ["lì"]],
    "暴敛": [["bào"], ["liǎn"]],
    "暴烈": [["bào"], ["liè"]],
    "暴露": [["bào"], ["lù"]],
    "暴乱": [["bào"], ["luàn"]],
    "暴民": [["bào"], ["mín"]],
    "暴怒": [["bào"], ["nù"]],
    "暴虐": [["bào"], ["nüè"]],
    "暴晒": [["pù"], ["shài"]],
    "暴尸": [["bào"], ["shī"]],
    "暴死": [["bào"], ["sǐ"]],
    "暴跳": [["bào"], ["tiào"]],
    "暴突": [["bào"], ["tū"]],
    "暴徒": [["bào"], ["tú"]],
    "暴行": [["bào"], ["xíng"]],
    "暴躁": [["bào"], ["zào"]],
    "暴雨": [["bào"], ["yǔ"]],
    "暴卒": [["bào"], ["zú"]],
    "暴政": [["bào"], ["zhèng"]],
    "暴涨": [["bào"], ["zhǎng"]],
    "爆发": [["bào"], ["fā"]],
    "爆裂": [["bào"], ["liè"]],
    "爆炸": [["bào"], ["zhà"]],
    "陂塘": [["bēi"], ["táng"]],
    "陂陀": [["pō"], ["tuó"]],
    "悲观": [["bēi"], ["guān"]],
    "悲号": [["bēi"], ["hào"]],
    "悲凉": [["bēi"], ["liáng"]],
    "悲切": [["bēi"], ["qiè"]],
    "悲思": [["bēi"], ["sī"]],
    "碑碣": [["bēi"], ["jié"]],
    "悲咽": [["bēi"], ["yān"]],
    "碑石": [["bēi"], ["shí"]],
    "碑帖": [["bēi"], ["tiè"]],
    "碑拓": [["bēi"], ["tuò"]],
    "北边": [["běi"], ["biān"]],
    "北部": [["běi"], ["bù"]],
    "北辰": [["běi"], ["chén"]],
    "北朝": [["běi"], ["cháo"]],
    "北斗": [["běi"], ["dǒu"]],
    "北伐": [["běi"], ["fá"]],
    "北风": [["běi"], ["fēng"]],
    "北非": [["běi"], ["fēi"]],
    "北房": [["běi"], ["fáng"]],
    "北方": [["běi"], ["fāng"]],
    "北国": [["běi"], ["guó"]],
    "北瓜": [["běi"], ["guā"]],
    "北海": [["běi"], ["hǎi"]],
    "北极": [["běi"], ["jí"]],
    "北疆": [["běi"], ["jiāng"]],
    "北江": [["běi"], ["jiāng"]],
    "北郊": [["běi"], ["jiāo"]],
    "北京": [["běi"], ["jīng"]],
    "北门": [["běi"], ["mén"]],
    "北面": [["běi"], ["miàn"]],
    "北欧": [["běi"], ["ōu"]],
    "北平": [["běi"], ["píng"]],
    "北齐": [["běi"], ["qí"]],
    "北曲": [["běi"], ["qǔ"]],
    "北宋": [["běi"], ["sòng"]],
    "北上": [["běi"], ["shàng"]],
    "北纬": [["běi"], ["wěi"]],
    "北魏": [["běi"], ["wèi"]],
    "北洋": [["běi"], ["yáng"]],
    "北岳": [["běi"], ["yuè"]],
    "北越": [["běi"], ["yuè"]],
    "北周": [["běi"], ["zhōu"]],
    "贝壳": [["bèi"], ["ké"]],
    "贝勒": [["bèi"], ["lè"]],
    "备查": [["bèi"], ["zhā"]],
    "备份": [["bèi"], ["fèn"]],
    "备员": [["bèi"], ["yuán"]],
    "背榜": [["bēi"], ["bǎng"]],
    "背包": [["bēi"], ["bāo"]],
    "背部": [["bèi"], ["bù"]],
    "背地": [["bèi"], ["dì"]],
    "背带": [["bēi"], ["dài"]],
    "背袋": [["bèi"], ["dài"]],
    "背篼": [["bèi"], ["dōu"]],
    "背负": [["bēi"], ["fù"]],
    "背风": [["bèi"], ["fēng"]],
    "背光": [["bèi"], ["guāng"]],
    "背脊": [["bèi"], ["jǐ"]],
    "背后": [["bèi"], ["hòu"]],
    "背街": [["bèi"], ["jiē"]],
    "背景": [["bèi"], ["jǐng"]],
    "背静": [["bèi"], ["jìng"]],
    "背靠": [["bèi"], ["kào"]],
    "背筐": [["bēi"], ["kuāng"]],
    "背篓": [["bēi"], ["lǒu"]],
    "背离": [["bèi"], ["lí"]],
    "背谬": [["bèi"], ["miù"]],
    "背面": [["bèi"], ["miàn"]],
    "背囊": [["bèi"], ["náng"]],
    "背鳍": [["bèi"], ["qí"]],
    "背叛": [["bèi"], ["pàn"]],
    "背气": [["bèi"], ["qì"]],
    "背弃": [["bèi"], ["qì"]],
    "背人": [["bèi"], ["rén"]],
    "背时": [["bèi"], ["shí"]],
    "背书": [["bèi"], ["shū"]],
    "背熟": [["bèi"], ["shú"]],
    "背诵": [["bèi"], ["sòng"]],
    "背向": [["bèi"], ["xiàng"]],
    "背心": [["bèi"], ["xīn"]],
    "背信": [["bèi"], ["xìn"]],
    "背阴": [["bèi"], ["yīn"]],
    "背影": [["bèi"], ["yǐng"]],
    "背约": [["bèi"], ["yuē"]],
    "背运": [["bèi"], ["yùn"]],
    "背债": [["bēi"], ["zhài"]],
    "背子": [["bēi"], ["zi"]],
    "倍率": [["bèi"], ["lǜ"]],
    "倍频": [["bèi"], ["pín"]],
    "倍数": [["bèi"], ["shù"]],
    "被单": [["bèi"], ["dān"]],
    "被袋": [["bèi"], ["dài"]],
    "被动": [["bèi"], ["dòng"]],
    "被服": [["bèi"], ["fú"]],
    "被覆": [["bèi"], ["fù"]],
    "被害": [["bèi"], ["hài"]],
    "被告": [["bèi"], ["gào"]],
    "被里": [["bèi"], ["lǐ"]],
    "被面": [["bèi"], ["miàn"]],
    "被难": [["bèi"], ["nàn"]],
    "被套": [["bèi"], ["tào"]],
    "被头": [["bèi"], ["tóu"]],
    "被卧": [["bèi"], ["wò"]],
    "被罩": [["bèi"], ["zhào"]],
    "被子": [["bèi"], ["zi"]],
    "焙干": [["bèi"], ["gān"]],
    "辈分": [["bèi"], ["fēn"]],
    "辈数": [["bèi"], ["shù"]],
    "奔波": [["bēn"], ["bō"]],
    "奔驰": [["bēn"], ["chí"]],
    "奔窜": [["bēn"], ["cuàn"]],
    "奔放": [["bēn"], ["fàng"]],
    "奔赴": [["bēn"], ["fù"]],
    "奔劳": [["bēn"], ["láo"]],
    "奔流": [["bēn"], ["liú"]],
    "奔马": [["bēn"], ["mǎ"]],
    "奔忙": [["bēn"], ["máng"]],
    "奔跑": [["bēn"], ["pǎo"]],
    "奔命": [["bèn"], ["mìng"]],
    "奔丧": [["bēn"], ["sāng"]],
    "奔腾": [["bēn"], ["téng"]],
    "奔逃": [["bēn"], ["táo"]],
    "奔驶": [["bēn"], ["shǐ"]],
    "奔头": [["bèn"], ["tóu"]],
    "奔突": [["bēn"], ["tū"]],
    "奔袭": [["bēn"], ["xí"]],
    "奔泻": [["bēn"], ["xiè"]],
    "奔涌": [["bēn"], ["yǒng"]],
    "奔逐": [["bēn"], ["zhú"]],
    "奔走": [["bēn"], ["zǒu"]],
    "贲门": [["bēn"], ["mén"]],
    "贲临": [["bì"], ["lín"]],
    "本底": [["běn"], ["dǐ"]],
    "本地": [["běn"], ["dì"]],
    "本分": [["běn"], ["fèn"]],
    "本纪": [["běn"], ["jì"]],
    "本家": [["běn"], ["jiā"]],
    "本能": [["běn"], ["néng"]],
    "本票": [["běn"], ["piào"]],
    "本体": [["běn"], ["tǐ"]],
    "本戏": [["běn"], ["xì"]],
    "本条": [["běn"], ["tiáo"]],
    "本县": [["běn"], ["xiàn"]],
    "本相": [["běn"], ["xiàng"]],
    "本行": [["běn"], ["háng"]],
    "本着": [["běn"], ["zhe"]],
    "畚斗": [["běn"], ["dòu"]],
    "笨伯": [["bèn"], ["bó"]],
    "笨重": [["bèn"], ["zhòng"]],
    "崩坏": [["bēng"], ["huài"]],
    "崩解": [["bēng"], ["jiě"]],
    "崩溃": [["bēng"], ["kuì"]],
    "崩裂": [["bēng"], ["liè"]],
    "绷带": [["bēng"], ["dài"]],
    "绷簧": [["bēng"], ["huáng"]],
    "绷脸": [["běng"], ["liǎn"]],
    "绷子": [["bēng"], ["zǐ"]],
    "迸发": [["bèng"], ["fā"]],
    "迸溅": [["bèng"], ["jiàn"]],
    "迸裂": [["bèng"], ["liè"]],
    "迸射": [["bèng"], ["shè"]],
    "蹦跳": [["bèng"], ["tiào"]],
    "逼供": [["bī"], ["gòng"]],
    "逼和": [["bī"], ["hé"]],
    "逼迫": [["bī"], ["pò"]],
    "逼肖": [["bī"], ["xiào"]],
    "鼻塞": [["bí"], ["sāi"]],
    "鼻头": [["bí"], ["tóu"]],
    "比分": [["bǐ"], ["fēn"]],
    "比干": [["bǐ"], ["gàn"]],
    "比划": [["bǐ"], ["huà"]],
    "比价": [["bǐ"], ["jià"]],
    "比率": [["bǐ"], ["lǜ"]],
    "比量": [["bǐ"], ["liáng"]],
    "比兴": [["bǐ"], ["xīng"]],
    "比重": [["bǐ"], ["zhòng"]],
    "吡啶": [["bǐ"], ["dìng"]],
    "吡咯": [["bǐ"], ["gē"]],
    "笔答": [["bǐ"], ["dá"]],
    "笔调": [["bǐ"], ["diào"]],
    "笔供": [["bǐ"], ["gòng"]],
    "笔划": [["bǐ"], ["huà"]],
    "笔会": [["bǐ"], ["huì"]],
    "笔体": [["bǐ"], ["tǐ"]],
    "笔削": [["bǐ"], ["xuē"]],
    "笔洗": [["bǐ"], ["xǐ"]],
    "鄙薄": [["bǐ"], ["bó"]],
    "鄙夫": [["bǐ"], ["fū"]],
    "鄙称": [["bǐ"], ["chēng"]],
    "鄙见": [["bǐ"], ["jiàn"]],
    "必得": [["bì"], ["děi"]],
    "必将": [["bì"], ["jiāng"]],
    "必要": [["bì"], ["yào"]],
    "毕剥": [["bì"], ["bāo"]],
    "毕肖": [["bì"], ["xiào"]],
    "毕露": [["bì"], ["lù"]],
    "闭合": [["bì"], ["hé"]],
    "闭会": [["bì"], ["huì"]],
    "闭卷": [["bì"], ["juàn"]],
    "闭塞": [["bì"], ["sè"]],
    "狴犴": [["bì"], ["àn"]],
    "痹症": [["bì"], ["zhèng"]],
    "庇荫": [["bì"], ["yìn"]],
    "婢女": [["bì"], ["nǚ"]],
    "裨将": [["pí"], ["jiàng"]],
    "裨益": [["bì"], ["yì"]],
    "辟地": [["pì"], ["dì"]],
    "辟谷": [["bì"], ["gǔ"]],
    "辟邪": [["bì"], ["xié"]],
    "辟谣": [["pì"], ["yáo"]],
    "碧绿": [["bì"], ["lǜ"]],
    "碧空": [["bì"], ["kōng"]],
    "蔽塞": [["bì"], ["sāi"]],
    "碧血": [["bì"], ["xuè"]],
    "壁柜": [["bì"], ["guì"]],
    "避风": [["bì"], ["fēng"]],
    "避难": [["bì"], ["nàn"]],
    "避邪": [["bì"], ["xié"]],
    "避雨": [["bì"], ["yǔ"]],
    "臂膀": [["bì"], ["bǎng"]],
    "臂膊": [["bì"], ["bó"]],
    "臂力": [["bì"], ["lì"]],
    "臂弯": [["bì"], ["wān"]],
    "臂章": [["bì"], ["zhāng"]],
    "臂腕": [["bì"], ["wàn"]],
    "臂助": [["bì"], ["zhù"]],
    "璧还": [["bì"], ["huán"]],
    "边疆": [["biān"], ["jiāng"]],
    "边角": [["biān"], ["jiǎo"]],
    "边地": [["biān"], ["dì"]],
    "边卡": [["biān"], ["qiǎ"]],
    "边区": [["biān"], ["qū"]],
    "边上": [["biān"], ["shàng"]],
    "边塞": [["biān"], ["sài"]],
    "边远": [["biān"], ["yuǎn"]],
    "砭骨": [["biān"], ["gǔ"]],
    "编发": [["biān"], ["fā"]],
    "砭石": [["biān"], ["shí"]],
    "编号": [["biān"], ["hào"]],
    "编内": [["biān"], ["nèi"]],
    "编结": [["biān"], ["jié"]],
    "编排": [["biān"], ["pái"]],
    "编校": [["biān"], ["xiào"]],
    "编织": [["biān"], ["zhī"]],
    "编著": [["biān"], ["zhù"]],
    "鞭打": [["biān"], ["dǎ"]],
    "鞭炮": [["biān"], ["pào"]],
    "鞭梢": [["biān"], ["shāo"]],
    "贬称": [["biǎn"], ["chēng"]],
    "贬价": [["biǎn"], ["jià"]],
    "扁柏": [["biǎn"], ["bǎi"]],
    "扁扁": [["biǎn"], ["biǎn"]],
    "扁锉": [["biǎn"], ["cuò"]],
    "扁豆": [["biǎn"], ["dòu"]],
    "扁担": [["biǎn"], ["dàn"]],
    "扁骨": [["biǎn"], ["gǔ"]],
    "扁鹊": [["biǎn"], ["què"]],
    "扁食": [["biǎn"], ["shí"]],
    "扁桃": [["biǎn"], ["táo"]],
    "扁圆": [["biǎn"], ["yuán"]],
    "扁舟": [["piān"], ["zhōu"]],
    "拚命": [["pàn"], ["mìng"]],
    "便步": [["biàn"], ["bù"]],
    "便餐": [["biàn"], ["cān"]],
    "便车": [["biàn"], ["chē"]],
    "便池": [["biàn"], ["chí"]],
    "便当": [["biàn"], ["dāng"]],
    "便道": [["biàn"], ["dào"]],
    "便服": [["biàn"], ["fú"]],
    "便饭": [["biàn"], ["fàn"]],
    "便函": [["biàn"], ["hán"]],
    "便壶": [["biàn"], ["hú"]],
    "便笺": [["biàn"], ["jiān"]],
    "便捷": [["biàn"], ["jié"]],
    "便览": [["biàn"], ["lǎn"]],
    "便利": [["biàn"], ["lì"]],
    "便了": [["biàn"], ["liǎo"]],
    "便路": [["biàn"], ["lù"]],
    "便帽": [["biàn"], ["mào"]],
    "便门": [["biàn"], ["mén"]],
    "便民": [["biàn"], ["mín"]],
    "便秘": [["biàn"], ["mì"]],
    "便溺": [["biàn"], ["niào"]],
    "便盆": [["biàn"], ["pén"]],
    "便签": [["biàn"], ["qiān"]],
    "便人": [["pián"], ["rén"]],
    "便桥": [["biàn"], ["qiáo"]],
    "便士": [["biàn"], ["shì"]],
    "便是": [["biàn"], ["shì"]],
    "便所": [["biàn"], ["suǒ"]],
    "便条": [["biàn"], ["tiáo"]],
    "便桶": [["biàn"], ["tǒng"]],
    "便鞋": [["biàn"], ["xié"]],
    "便血": [["biàn"], ["xuè"]],
    "便宴": [["biàn"], ["yàn"]],
    "便衣": [["biàn"], ["yī"]],
    "便宜": [["biàn"], ["yí"]],
    "便中": [["biàn"], ["zhōng"]],
    "便于": [["biàn"], ["yú"]],
    "便装": [["biàn"], ["zhuāng"]],
    "变调": [["biàn"], ["diào"]],
    "变更": [["biàn"], ["gēng"]],
    "变化": [["biàn"], ["huà"]],
    "变坏": [["biàn"], ["huài"]],
    "变价": [["biàn"], ["jià"]],
    "变节": [["biàn"], ["jié"]],
    "变量": [["biàn"], ["liàng"]],
    "变数": [["biàn"], ["shù"]],
    "变体": [["biàn"], ["tǐ"]],
    "变相": [["biàn"], ["xiàng"]],
    "变压": [["biàn"], ["yā"]],
    "变种": [["biàn"], ["zhǒng"]],
    "遍体": [["biàn"], ["tǐ"]],
    "遍地": [["biàn"], ["dì"]],
    "辨别": [["biàn"], ["bié"]],
    "辨识": [["biàn"], ["shí"]],
    "辨正": [["biàn"], ["zhèng"]],
    "辩解": [["biàn"], ["jiě"]],
    "辩论": [["biàn"], ["lùn"]],
    "辩难": [["biàn"], ["nàn"]],
    "辩说": [["biàn"], ["shuō"]],
    "标榜": [["biāo"], ["bǎng"]],
    "辩正": [["biàn"], ["zhèng"]],
    "标称": [["biāo"], ["chēng"]],
    "标尺": [["biāo"], ["chǐ"]],
    "标的": [["biāo"], ["dì"]],
    "标底": [["biāo"], ["dǐ"]],
    "标度": [["biāo"], ["dù"]],
    "标杆": [["biāo"], ["gān"]],
    "标号": [["biāo"], ["hào"]],
    "标价": [["biāo"], ["jià"]],
    "标量": [["biāo"], ["liàng"]],
    "标识": [["biāo"], ["zhì"]],
    "标语": [["biāo"], ["yǔ"]],
    "骠骑": [["piào"], ["qí"]],
    "镖头": [["biāo"], ["tóu"]],
    "飙车": [["biāo"], ["chē"]],
    "表尺": [["biǎo"], ["chǐ"]],
    "表弟": [["biǎo"], ["dì"]],
    "表观": [["biǎo"], ["guān"]],
    "表解": [["biǎo"], ["jiě"]],
    "表露": [["biǎo"], ["lù"]],
    "表率": [["biǎo"], ["shuài"]],
    "表亲": [["biǎo"], ["qīn"]],
    "表头": [["biǎo"], ["tóu"]],
    "表徵": [["biǎo "], ["zhǐ"]],
    "表语": [["biǎo"], ["yǔ"]],
    "裱糊": [["biǎo"], ["hú"]],
    "憋闷": [["biē"], ["mèn"]],
    "别本": [["bié"], ["běn"]],
    "别称": [["bié"], ["chēng"]],
    "别处": [["bié"], ["chù"]],
    "别传": [["bié"], ["zhuàn"]],
    "别个": [["bié"], ["gè"]],
    "别馆": [["bié"], ["guǎn"]],
    "别管": [["bié"], ["guǎn"]],
    "别国": [["bié"], ["guó"]],
    "别号": [["bié"], ["hào"]],
    "别集": [["bié"], ["jí"]],
    "别家": [["bié"], ["jiā"]],
    "别价": [["bié"], ["jià"]],
    "别离": [["bié"], ["lí"]],
    "别论": [["bié"], ["lùn"]],
    "别忙": [["bié"], ["máng"]],
    "别名": [["bié"], ["míng"]],
    "别扭": [["biè"], ["niǔ"]],
    "别情": [["bié"], ["qíng"]],
    "别趣": [["bié"], ["qù"]],
    "别人": [["bié"], ["rén"]],
    "别史": [["bié"], ["shǐ"]],
    "别是": [["bié"], ["shì"]],
    "别墅": [["bié"], ["shù"]],
    "别说": [["bié"], ["shuō"]],
    "别提": [["bié"], ["tí"]],
    "别体": [["bié"], ["tǐ"]],
    "别样": [["bié"], ["yàng"]],
    "别绪": [["bié"], ["xù"]],
    "别业": [["bié"], ["yè"]],
    "别致": [["bié"], ["zhì"]],
    "别针": [["bié"], ["zhēn"]],
    "别字": [["bié"], ["zì"]],
    "别嘴": [["bié"], ["zuǐ"]],
    "瘪三": [["biē"], ["sān"]],
    "宾从": [["bīn"], ["cóng"]],
    "宾服": [["bīn"], ["fú"]],
    "傧相": [["bīn"], ["xiàng"]],
    "槟榔": [["bīng"], ["láng"]],
    "槟子": [["bīn"], ["zǐ"]],
    "殡车": [["bìn"], ["chē"]],
    "鬓发": [["bìn"], ["fà"]],
    "髌骨": [["bìn"], ["gǔ"]],
    "鬓角": [["bìn"], ["jiǎo"]],
    "冰场": [["bīng"], ["chǎng"]],
    "冰斗": [["bīng"], ["dǒu"]],
    "冰棍": [["bīng"], ["gùn"]],
    "冰凉": [["bīng"], ["liáng"]],
    "冰溜": [["bīng"], ["liū"]],
    "冰排": [["bīng"], ["pái"]],
    "冰片": [["bīng"], ["piàn"]],
    "冰期": [["bīng"], ["qī"]],
    "兵差": [["bīng"], ["chāi"]],
    "兵车": [["bīng"], ["chē"]],
    "兵丁": [["bīng"], ["dīng"]],
    "兵家": [["bīng"], ["jiā"]],
    "兵员": [["bīng"], ["yuán"]],
    "兵卒": [["bīng"], ["zú"]],
    "兵种": [["bīng"], ["zhǒng"]],
    "丙丁": [["bǐng"], ["dīng"]],
    "丙纶": [["bǐng"], ["lún"]],
    "秉正": [["bǐng"], ["zhèng"]],
    "饼铛": [["bǐng"], ["chēng"]],
    "饼干": [["bǐng"], ["gān"]],
    "禀帖": [["bǐng"], ["tiě"]],
    "并称": [["bìng"], ["chēng"]],
    "并存": [["bìng"], ["cún"]],
    "并处": [["bìng"], ["chǔ"]],
    "并蒂": [["bìng"], ["dì"]],
    "并发": [["bìng"], ["fā"]],
    "并轨": [["bìng"], ["guǐ"]],
    "并合": [["bìng"], ["hé"]],
    "并肩": [["bìng"], ["jiān"]],
    "并进": [["bìng"], ["jìn"]],
    "并举": [["bìng"], ["jǔ"]],
    "并立": [["bìng"], ["lì"]],
    "并力": [["bìng"], ["lì"]],
    "并联": [["bìng"], ["lián"]],
    "并列": [["bìng"], ["liè"]],
    "并拢": [["bìng"], ["lǒng"]],
    "并排": [["bìng"], ["pái"]],
    "并且": [["bìng"], ["qiě"]],
    "并入": [["bìng"], ["rù"]],
    "并吞": [["bìng"], ["tūn"]],
    "并网": [["bìng"], ["wǎng"]],
    "并行": [["bìng"], ["xíng"]],
    "并用": [["bìng"], ["yòng"]],
    "并置": [["bìng"], ["zhì"]],
    "并重": [["bìng"], ["zhòng"]],
    "病毒": [["bìng"], ["dú"]],
    "病体": [["bìng"], ["tǐ"]],
    "病员": [["bìng"], ["yuán"]],
    "病症": [["bìng"], ["zhèng"]],
    "病重": [["bìng"], ["zhòng"]],
    "拨发": [["bō"], ["fā"]],
    "拨给": [["bō"], ["gěi"]],
    "拨号": [["bō"], ["hào"]],
    "拨拉": [["bō"], ["lā"]],
    "拨弄": [["bō"], ["nòng"]],
    "拨转": [["bō"], ["zhuǎn"]],
    "波长": [["bō"], ["cháng"]],
    "波纹": [["bō"], ["wén"]],
    "波折": [["bō"], ["zhé"]],
    "剥除": [["bāo"], ["chú"]],
    "剥剥": [["bāo"], ["bāo"]],
    "剥夺": [["bō"], ["duó"]],
    "剥壳": [["bāo"], ["ké"]],
    "剥离": [["bō"], ["lí"]],
    "剥取": [["bāo"], ["qǔ"]],
    "剥皮": [["bāo"], ["pí"]],
    "剥落": [["bō"], ["luò"]],
    "剥蚀": [["bō"], ["shí"]],
    "剥脱": [["bāo"], ["tuō"]],
    "剥削": [["bō"], ["xuē"]],
    "脖颈": [["bó"], ["gěng"]],
    "播发": [["bō"], ["fā"]],
    "播弄": [["bō"], ["nòng"]],
    "播散": [["bō"], ["sàn"]],
    "播种": [["bō"], ["zhǒng"]],
    "伯伯": [["bó"], ["bo"]],
    "伯德": [["bó"], ["dé"]],
    "伯公": [["bó"], ["gōng"]],
    "伯父": [["bó"], ["fù"]],
    "伯爵": [["bó"], ["jué"]],
    "伯劳": [["bó"], ["láo"]],
    "伯乐": [["bó"], ["lè"]],
    "伯母": [["bó"], ["mǔ"]],
    "伯婆": [["bó"], ["pó"]],
    "伯仲": [["bó"], ["zhòng"]],
    "伯祖": [["bó"], ["zǔ"]],
    "驳倒": [["bó"], ["dǎo"]],
    "驳论": [["bó"], ["lùn"]],
    "泊车": [["bó"], ["chē"]],
    "泊地": [["pō"], ["dì"]],
    "泊位": [["bó"], ["wèi"]],
    "勃勃": [["bó"], ["bó"]],
    "勃发": [["bó"], ["fā"]],
    "勃起": [["bó"], ["qǐ"]],
    "勃然": [["bó"], ["rán"]],
    "勃兴": [["bó"], ["xīng"]],
    "博采": [["bó"], ["cǎi"]],
    "博大": [["bó"], ["dà"]],
    "博得": [["bó"], ["de"]],
    "博识": [["bó"], ["shí"]],
    "搏斗": [["bó"], ["dòu"]],
    "薄板": [["báo"], ["bǎn"]],
    "薄饼": [["báo"], ["bǐng"]],
    "薄薄": [["báo"], ["báo"]],
    "薄层": [["báo"], ["céng"]],
    "薄产": [["bó"], ["chǎn"]],
    "薄脆": [["báo"], ["cuì"]],
    "薄待": [["bó"], ["dài"]],
    "薄荷": [["bò"], ["he"]],
    "薄技": [["bó"], ["jì"]],
    "薄酒": [["bó"], ["jiǔ"]],
    "薄利": [["bó"], ["lì"]],
    "薄面": [["báo"], ["miàn"]],
    "薄命": [["bó"], ["mìng"]],
    "薄暮": [["bó"], ["mù"]],
    "薄情": [["bó"], ["qíng"]],
    "薄片": [["báo"], ["piàn"]],
    "薄膜": [["báo"], ["mó"]],
    "薄弱": [["bó"], ["ruò"]],
    "薄纱": [["báo"], ["shā"]],
    "薄田": [["bó"], ["tián"]],
    "薄雾": [["bó"], ["wù"]],
    "薄晓": [["bó"], ["xiǎo"]],
    "薄幸": [["bó"], ["xìng"]],
    "薄葬": [["báo"], ["zàng"]],
    "跛行": [["bǒ"], ["xíng"]],
    "簸箕": [["bò"], ["ji"]],
    "簸荡": [["bǒ"], ["dàng"]],
    "簸动": [["bǒ"], ["dòng"]],
    "簸弄": [["bǒ"], ["nòng"]],
    "擘划": [["bò"], ["huà"]],
    "簸箩": [["bǒ"], ["luó"]],
    "擘画": [["bò"], ["huà"]],
    "卜辞": [["bǔ"], ["cí"]],
    "卜卦": [["bǔ"], ["guà"]],
    "卜居": [["bǔ"], ["jū"]],
    "卜骨": [["bǔ"], ["gǔ"]],
    "卜筮": [["bǔ"], ["shì"]],
    "补差": [["bǔ"], ["chà"]],
    "补钉": [["bǔ"], ["dīng"]],
    "补丁": [["bǔ"], ["dīng"]],
    "补发": [["bǔ"], ["fā"]],
    "补给": [["bǔ"], ["jǐ"]],
    "补过": [["bǔ"], ["guò"]],
    "补角": [["bǔ"], ["jiǎo"]],
    "补假": [["bǔ"], ["jià"]],
    "补票": [["bǔ"], ["piào"]],
    "补台": [["bǔ"], ["tái"]],
    "补血": [["bǔ"], ["xuè"]],
    "补休": [["bǔ"], ["xiū"]],
    "补语": [["bǔ"], ["yǔ"]],
    "补正": [["bǔ"], ["zhèng"]],
    "补种": [["bǔ"], ["zhòng"]],
    "补助": [["bǔ"], ["zhù"]],
    "捕食": [["bǔ"], ["shí"]],
    "捕头": [["bǔ"], ["tóu"]],
    "不碍": [["bù"], ["ài"]],
    "不安": [["bù"], ["ān"]],
    "不备": [["bù"], ["bèi"]],
    "不比": [["bù"], ["bǐ"]],
    "不报": [["bù"], ["bào"]],
    "不必": [["bù"], ["bì"]],
    "不便": [["bù"], ["biàn"]],
    "不避": [["bù"], ["bì"]],
    "不变": [["bù"], ["biàn"]],
    "不才": [["bù"], ["cái"]],
    "不测": [["bù"], ["cè"]],
    "不常": [["bù"], ["cháng"]],
    "不差": [["bù"], ["chà"]],
    "不成": [["bù"], ["chéng"]],
    "不逞": [["bù"], ["chěng"]],
    "不吃": [["bù"], ["chī"]],
    "不齿": [["bù"], ["chǐ"]],
    "不啻": [["bù"], ["chì"]],
    "不耻": [["bù"], ["chǐ"]],
    "不纯": [["bù"], ["chún"]],
    "不辍": [["bù"], ["chuò"]],
    "不辞": [["bù"], ["cí"]],
    "不错": [["bù"], ["cuò"]],
    "不大": [["bù"], ["dà"]],
    "不待": [["bù"], ["dài"]],
    "不丹": [["bù"], ["dān"]],
    "不单": [["bù"], ["dān"]],
    "不当": [["bù"], ["dàng"]],
    "不但": [["bù"], ["dàn"]],
    "不到": [["bú"], ["dào"]],
    "不得": [["bù"], ["dé"]],
    "不等": [["bù"], ["děng"]],
    "不敌": [["bù"], ["dí"]],
    "不迭": [["bù"], ["dié"]],
    "不定": [["bù"], ["dìng"]],
    "不端": [["bù"], ["duān"]],
    "不独": [["bù"], ["dú"]],
    "不断": [["bù"], ["duàn"]],
    "不对": [["bú"], ["duì"]],
    "不二": [["bù"], ["èr"]],
    "不乏": [["bù"], ["fá"]],
    "不法": [["bù"], ["fǎ"]],
    "不犯": [["bù"], ["fàn"]],
    "不凡": [["bù"], ["fán"]],
    "不妨": [["bù"], ["fáng"]],
    "不分": [["bù"], ["fēn"]],
    "不忿": [["bù"], ["fèn"]],
    "不服": [["bù"], ["fú"]],
    "不符": [["bù"], ["fú"]],
    "不甘": [["bù"], ["gān"]],
    "不该": [["bù"], ["gāi"]],
    "不干": [["bù"], ["gàn"]],
    "不敢": [["bù"], ["gǎn"]],
    "不公": [["bù"], ["gōng"]],
    "不恭": [["bù"], ["gōng"]],
    "不苟": [["bù"], ["gǒu"]],
    "不够": [["bù"], ["gòu"]],
    "不顾": [["bù"], ["gù"]],
    "不关": [["bù"], ["guān"]],
    "不管": [["bù"], ["guǎn"]],
    "不轨": [["bù"], ["guǐ"]],
    "不光": [["bù"], ["guāng"]],
    "不果": [["bù"], ["guǒ"]],
    "不过": [["bù"], ["guò"]],
    "不好": [["bù"], ["hǎo"]],
    "不合": [["bù"], ["hé"]],
    "不和": [["bù"], ["hé"]],
    "不遑": [["bù"], ["huáng"]],
    "不会": [["bú"], ["huì"]],
    "不讳": [["bù"], ["huì"]],
    "不惑": [["bù"], ["huò"]],
    "不羁": [["bù"], ["jī"]],
    "不计": [["bù"], ["jì"]],
    "不及": [["bù"], ["jí"]],
    "不济": [["bù"], ["jì"]],
    "不佳": [["bù"], ["jiā"]],
    "不假": [["bù"], ["jiǎ"]],
    "不减": [["bù"], ["jiǎn"]],
    "不检": [["bù"], ["jiǎn"]],
    "不见": [["bú"], ["jiàn"]],
    "不洁": [["bù"], ["jié"]],
    "不解": [["bù"], ["jiě"]],
    "不仅": [["bù"], ["jǐn"]],
    "不尽": [["bù"], ["jìn"]],
    "不禁": [["bù"], ["jīn"]],
    "不敬": [["bù"], ["jìng"]],
    "不拘": [["bù"], ["jū"]],
    "不久": [["bù"], ["jiǔ"]],
    "不具": [["bù"], ["jù"]],
    "不倦": [["bù"], ["juàn"]],
    "不觉": [["bù"], ["jué"]],
    "不均": [["bù"], ["jūn"]],
    "不堪": [["bù"], ["kān"]],
    "不可": [["bù"], ["kě"]],
    "不克": [["bù"], ["kè"]],
    "不肯": [["bù"], ["kěn"]],
    "不快": [["bù"], ["kuài"]],
    "不愧": [["bù"], ["kuì"]],
    "不赖": [["bù"], ["lài"]],
    "不理": [["bù"], ["lǐ"]],
    "不力": [["bù"], ["lì"]],
    "不利": [["bù"], ["lì"]],
    "不良": [["bù"], ["liáng"]],
    "不了": [["bù"], ["liǎo"]],
    "不料": [["bù"], ["liào"]],
    "不吝": [["bù"], ["lìn"]],
    "不灵": [["bù"], ["líng"]],
    "不论": [["bù"], ["lùn"]],
    "不满": [["bù"], ["mǎn"]],
    "不毛": [["bù"], ["máo"]],
    "不免": [["bù"], ["miǎn"]],
    "不妙": [["bù"], ["miào"]],
    "不敏": [["bù"], ["mǐn"]],
    "不明": [["bù"], ["míng"]],
    "不耐": [["bù"], ["nài"]],
    "不能": [["bù"], ["néng"]],
    "不宁": [["bù"], ["níng"]],
    "不佞": [["bù"], ["nìng"]],
    "不怕": [["bù"], ["pà"]],
    "不配": [["bù"], ["pèi"]],
    "不平": [["bù"], ["píng"]],
    "不期": [["bù"], ["qī"]],
    "不齐": [["bù"], ["qí"]],
    "不起": [["bù"], ["qǐ"]],
    "不巧": [["bù"], ["qiǎo"]],
    "不屈": [["bù"], ["qū"]],
    "不然": [["bù"], ["rán"]],
    "不让": [["bù"], ["ràng"]],
    "不仁": [["bù"], ["rén"]],
    "不忍": [["bù"], ["rěn"]],
    "不容": [["bù"], ["róng"]],
    "不日": [["bù"], ["rì"]],
    "不如": [["bù"], ["rú"]],
    "不若": [["bù"], ["ruò"]],
    "不少": [["bù"], ["shǎo"]],
    "不善": [["bù"], ["shàn"]],
    "不舍": [["bù"], ["shě"]],
    "不甚": [["bù"], ["shèn"]],
    "不慎": [["bù"], ["shèn"]],
    "不胜": [["bù"], ["shèng"]],
    "不时": [["bù"], ["shí"]],
    "不实": [["bù"], ["shí"]],
    "不是": [["bú"], ["shì"]],
    "不适": [["bù"], ["shì"]],
    "不熟": [["bù"], ["shú"]],
    "不衰": [["bù"], ["shuāi"]],
    "不爽": [["bù"], ["shuǎng"]],
    "不俗": [["bù"], ["sú"]],
    "不算": [["bù"], ["suàn"]],
    "不遂": [["bù"], ["suí"]],
    "不听": [["bù"], ["tīng"]],
    "不通": [["bù"], ["tōng"]],
    "不同": [["bù"], ["tóng"]],
    "不妥": [["bù"], ["tuǒ"]],
    "不图": [["bù"], ["tú"]],
    "不外": [["bù"], ["wài"]],
    "不枉": [["bù"], ["wǎng"]],
    "不韪": [["bù"], ["wěi"]],
    "不惟": [["bù"], ["wéi"]],
    "不文": [["bù"], ["wén"]],
    "不问": [["bù"], ["wèn"]],
    "不稳": [["bù"], ["wěn"]],
    "不无": [["bù"], ["wú"]],
    "不息": [["bù"], ["xī"]],
    "不惜": [["bù"], ["xī"]],
    "不暇": [["bù"], ["xiá"]],
    "不下": [["bù"], ["xià"]],
    "不详": [["bù"], ["xiáng"]],
    "不祥": [["bù"], ["xiáng"]],
    "不想": [["bù"], ["xiǎng"]],
    "不象": [["bù"], ["xiàng"]],
    "不像": [["bù"], ["xiàng"]],
    "不消": [["bù"], ["xiāo"]],
    "不孝": [["bù"], ["xiào"]],
    "不肖": [["bù"], ["xiào"]],
    "不懈": [["bù"], ["xiè"]],
    "不屑": [["bù"], ["xiè"]],
    "不信": [["bù"], ["xìn"]],
    "不兴": [["bù"], ["xīng"]],
    "不行": [["bù"], ["xíng"]],
    "不幸": [["bù"], ["xìng"]],
    "不休": [["bù"], ["xiū"]],
    "不朽": [["bù"], ["xiǔ"]],
    "不修": [["bù"], ["xiū"]],
    "不须": [["bù"], ["xū"]],
    "不许": [["bù"], ["xǔ"]],
    "不恤": [["bù"], ["xù"]],
    "不逊": [["bù"], ["xùn"]],
    "不雅": [["bù"], ["yǎ"]],
    "不厌": [["bù"], ["yàn"]],
    "不扬": [["bù"], ["yáng"]],
    "不要": [["bú"], ["yào"]],
    "不一": [["bù"], ["yī"]],
    "不依": [["bù"], ["yī"]],
    "不宜": [["bù"], ["yí"]],
    "不已": [["bù"], ["yǐ"]],
    "不义": [["bú"], ["yì"]],
    "不亦": [["bù"], ["yì"]],
    "不易": [["bù"], ["yì"]],
    "不意": [["bù"], ["yì"]],
    "不用": [["bù"], ["yòng"]],
    "不由": [["bù"], ["yóu"]],
    "不虞": [["bù"], ["yú"]],
    "不育": [["bù"], ["yù"]],
    "不遇": [["bù"], ["yù"]],
    "不再": [["bù"], ["zài"]],
    "不孕": [["bù"], ["yùn"]],
    "不曾": [["bù"], ["céng"]],
    "不在": [["bù"], ["zài"]],
    "不振": [["bù"], ["zhèn"]],
    "不争": [["bù"], ["zhēng"]],
    "不支": [["bù"], ["zhī"]],
    "不正": [["bù"], ["zhèng"]],
    "不值": [["bù"], ["zhí"]],
    "不止": [["bù"], ["zhǐ"]],
    "不只": [["bù"], ["zhǐ"]],
    "不治": [["bù"], ["zhì"]],
    "不致": [["bù"], ["zhì"]],
    "不智": [["bù"], ["zhì"]],
    "不中": [["bù"], ["zhōng"]],
    "不周": [["bù"], ["zhōu"]],
    "不足": [["bù"], ["zú"]],
    "不住": [["bú"], ["zhù"]],
    "不准": [["bù"], ["zhǔn"]],
    "布丁": [["bù"], ["dīng"]],
    "布景": [["bù"], ["jǐng"]],
    "布头": [["bù"], ["tóu"]],
    "步调": [["bù"], ["diào"]],
    "步行": [["bù"], ["xíng"]],
    "部长": [["bù"], ["zhǎng"]],
    "部分": [["bù"], ["fèn"]],
    "部将": [["bù"], ["jiàng"]],
    "部落": [["bù"], ["luò"]],
    "部头": [["bù"], ["tóu"]],
    "部属": [["bù"], ["shǔ"]],
    "部委": [["bù"], ["wěi"]],
    "簿册": [["bù"], ["cè"]],
    "簿籍": [["bù"], ["jí"]],
    "簿记": [["bù"], ["jì"]],
    "簿子": [["bù"], ["zǐ"]],
    "擦背": [["cā"], ["bèi"]],
    "猜度": [["cāi"], ["duó"]],
    "擦洗": [["cā"], ["xǐ"]],
    "才分": [["cái"], ["fèn"]],
    "才华": [["cái"], ["huá"]],
    "才干": [["cái"], ["gàn"]],
    "才能": [["cái"], ["néng"]],
    "才女": [["cái"], ["nǚ"]],
    "才识": [["cái"], ["shí"]],
    "才思": [["cái"], ["sī"]],
    "财会": [["cái"], ["kuài"]],
    "裁并": [["cái"], ["bìng"]],
    "裁度": [["cái"], ["duó"]],
    "裁处": [["cái"], ["chǔ"]],
    "裁缝": [["cái"], ["féng"]],
    "裁量": [["cái"], ["liàng"]],
    "采办": [["cǎi"], ["bàn"]],
    "裁员": [["cái"], ["yuán"]],
    "采采": [["cǎi"], ["cǎi"]],
    "采茶": [["cǎi"], ["chá"]],
    "采访": [["cǎi"], ["fǎng"]],
    "采伐": [["cǎi"], ["fá"]],
    "采风": [["cǎi"], ["fēng"]],
    "采购": [["cǎi"], ["gòu"]],
    "采集": [["cǎi"], ["jí"]],
    "采花": [["cǎi"], ["huā"]],
    "采光": [["cǎi"], ["guāng"]],
    "采掘": [["cǎi"], ["jué"]],
    "采矿": [["cǎi"], ["kuàng"]],
    "采买": [["cǎi"], ["mǎi"]],
    "采录": [["cǎi"], ["lù"]],
    "采煤": [["cǎi"], ["méi"]],
    "采纳": [["cǎi"], ["nà"]],
    "采暖": [["cǎi"], ["nuǎn"]],
    "采区": [["cǎi"], ["qū"]],
    "采取": [["cǎi"], ["qǔ"]],
    "采桑": [["cǎi"], ["sāng"]],
    "采石": [["cǎi"], ["shí"]],
    "采食": [["cǎi"], ["shí"]],
    "采收": [["cǎi"], ["shōu"]],
    "采撷": [["cǎi"], ["xié"]],
    "采写": [["cǎi"], ["xiě"]],
    "采样": [["cǎi"], ["yàng"]],
    "采药": [["cǎi"], ["yào"]],
    "采邑": [["cài"], ["yì"]],
    "采用": [["cǎi"], ["yòng"]],
    "采油": [["cǎi"], ["yóu"]],
    "采运": [["cǎi"], ["yùn"]],
    "采择": [["cǎi"], ["zé"]],
    "采制": [["cǎi"], ["zhì"]],
    "采种": [["cǎi"], ["zhǒng"]],
    "采摘": [["cǎi"], ["zhāi"]],
    "彩排": [["cǎi"], ["pái"]],
    "菜单": [["cài"], ["dān"]],
    "菜羊": [["cài"], ["yáng"]],
    "参拜": [["cān"], ["bài"]],
    "参半": [["cān"], ["bàn"]],
    "参差": [["cēn"], ["cī"]],
    "参禅": [["cān"], ["chán"]],
    "参错": [["cēn"], ["cuò"]],
    "参访": [["cān"], ["fǎng"]],
    "参观": [["cān"], ["guān"]],
    "参劾": [["cān"], ["hé"]],
    "参加": [["cān"], ["jiā"]],
    "参合": [["cān"], ["hé"]],
    "参检": [["cān"], ["jiǎn"]],
    "参见": [["cān"], ["jiàn"]],
    "参军": [["cān"], ["jūn"]],
    "参看": [["cān"], ["kàn"]],
    "参考": [["cān"], ["kǎo"]],
    "参量": [["cān"], ["liàng"]],
    "参谋": [["cān"], ["móu"]],
    "参赛": [["cān"], ["sài"]],
    "参商": [["shēn"], ["shāng"]],
    "参事": [["cān"], ["shì"]],
    "参数": [["cān"], ["shù"]],
    "参天": [["cān"], ["tiān"]],
    "参透": [["cān"], ["tòu"]],
    "参悟": [["cān"], ["wù"]],
    "参校": [["cān"], ["jiào"]],
    "参选": [["cān"], ["xuǎn"]],
    "参谒": [["cān"], ["yè"]],
    "参议": [["cān"], ["yì"]],
    "参预": [["cān"], ["yù"]],
    "参与": [["cān"], ["yù"]],
    "参阅": [["cān"], ["yuè"]],
    "参赞": [["cān"], ["zàn"]],
    "参杂": [["cān"], ["zá"]],
    "参战": [["cān"], ["zhàn"]],
    "参展": [["cān"], ["zhǎn"]],
    "参照": [["cān"], ["zhào"]],
    "参酌": [["cān"], ["zhuó"]],
    "参政": [["cān"], ["zhèng"]],
    "餐车": [["cān"], ["chē"]],
    "残暴": [["cán"], ["bào"]],
    "残卷": [["cán"], ["juàn"]],
    "残毒": [["cán"], ["dú"]],
    "残片": [["cán"], ["piàn"]],
    "蚕蛾": [["cán"], ["é"]],
    "蚕沙": [["cán"], ["shā"]],
    "蚕食": [["cán"], ["shí"]],
    "蚕种": [["cán"], ["zhǒng"]],
    "惭怍": [["cán"], ["zuò"]],
    "仓颉": [["cāng"], ["jié"]],
    "仓卒": [["cāng"], ["cù"]],
    "伧俗": [["cāng"], ["sú"]],
    "苍劲": [["cāng"], ["jìng"]],
    "苍凉": [["cāng"], ["liáng"]],
    "苍头": [["cāng"], ["tóu"]],
    "苍术": [["cāng"], ["zhú"]],
    "苍哑": [["cāng"], ["yǎ"]],
    "藏躲": [["cáng"], ["duǒ"]],
    "藏锋": [["cáng"], ["fēng"]],
    "藏奸": [["cáng"], ["jiān"]],
    "藏蓝": [["zàng"], ["lán"]],
    "藏历": [["zàng"], ["lì"]],
    "藏匿": [["cáng"], ["nì"]],
    "藏青": [["zàng"], ["qīng"]],
    "藏身": [["cáng"], ["shēn"]],
    "藏书": [["cáng"], ["shū"]],
    "藏戏": [["zàng"], ["xì"]],
    "藏香": [["cáng"], ["xiāng"]],
    "藏掖": [["cáng"], ["yè"]],
    "藏拙": [["cáng"], ["zhuō"]],
    "藏踪": [["cáng"], ["zōng"]],
    "藏族": [["zàng"], ["zú"]],
    "操场": [["cāo"], ["chǎng"]],
    "操切": [["cāo"], ["qiè"]],
    "操纵": [["cāo"], ["zòng"]],
    "操行": [["cāo"], ["xíng"]],
    "槽车": [["cáo"], ["chē"]],
    "槽坊": [["cáo"], ["fāng"]],
    "槽钢": [["cáo"], ["gāng"]],
    "槽头": [["cáo"], ["tóu"]],
    "草场": [["cǎo"], ["chǎng"]],
    "草创": [["cǎo"], ["chuàng"]],
    "草地": [["cǎo"], ["dì"]],
    "草垛": [["cǎo"], ["duǒ"]],
    "草芥": [["cǎo"], ["jiè"]],
    "草率": [["cǎo"], ["shuài"]],
    "草绿": [["cǎo"], ["lǜ"]],
    "草体": [["cǎo"], ["tǐ"]],
    "草约": [["cǎo"], ["yuē"]],
    "草泽": [["cǎo"], ["zé"]],
    "侧柏": [["cè"], ["bǎi"]],
    "侧边": [["cè"], ["biān"]],
    "侧耳": [["cè"], ["ěr"]],
    "侧根": [["cè"], ["gēn"]],
    "侧击": [["cè"], ["jī"]],
    "侧记": [["cè"], ["jì"]],
    "侧近": [["cè"], ["jìn"]],
    "侧门": [["cè"], ["mén"]],
    "侧面": [["cè"], ["miàn"]],
    "侧目": [["cè"], ["mù"]],
    "侧身": [["cè"], ["shēn"]],
    "侧视": [["cè"], ["shì"]],
    "侧室": [["cè"], ["shì"]],
    "侧卧": [["cè"], ["wò"]],
    "侧向": [["cè"], ["xiàng"]],
    "侧芽": [["cè"], ["yá"]],
    "侧翼": [["cè"], ["yì"]],
    "侧影": [["cè"], ["yǐng"]],
    "侧泳": [["cè"], ["yǒng"]],
    "侧重": [["cè"], ["zhòng"]],
    "侧枝": [["cè"], ["zhī"]],
    "恻隐": [["cè"], ["yǐn"]],
    "测度": [["cè"], ["duó"]],
    "测量": [["cè"], ["liáng"]],
    "策划": [["cè"], ["huà"]],
    "策论": [["cè"], ["lùn"]],
    "策应": [["cè"], ["yìng"]],
    "叉烧": [["chā"], ["shāo"]],
    "叉车": [["chā"], ["chē"]],
    "叉路": [["chā"], ["lù"]],
    "叉手": [["chā"], ["shǒu"]],
    "杈子": [["chā"], ["zǐ"]],
    "叉腰": [["chā"], ["yāo"]],
    "叉子": [["chā"], ["zǐ"]],
    "插屏": [["chā"], ["píng"]],
    "插曲": [["chā"], ["qǔ"]],
    "插条": [["chā"], ["tiáo"]],
    "查案": [["chá"], ["àn"]],
    "插头": [["chā"], ["tóu"]],
    "查办": [["chá"], ["bàn"]],
    "查查": [["zhā"], ["zhā"]],
    "查抄": [["chá"], ["chāo"]],
    "查处": [["chá"], ["chǔ"]],
    "查点": [["chá"], ["diǎn"]],
    "查对": [["chá"], ["duì"]],
    "查房": [["chá"], ["fáng"]],
    "查访": [["chá"], ["fǎng"]],
    "查封": [["chá"], ["fēng"]],
    "查岗": [["zhā"], ["gǎng"]],
    "查核": [["zhā"], ["hé"]],
    "查获": [["chá"], ["huò"]],
    "查缉": [["zhā"], ["jī"]],
    "查检": [["zhā"], ["jiǎn"]],
    "查禁": [["chá"], ["jìn"]],
    "查究": [["chá"], ["jiū"]],
    "查勘": [["chá"], ["kān"]],
    "查看": [["zhā"], ["kàn"]],
    "查考": [["chá"], ["kǎo"]],
    "查扣": [["chá"], ["kòu"]],
    "查明": [["chá"], ["míng"]],
    "查铺": [["chá"], ["pù"]],
    "查勤": [["zhā"], ["qín"]],
    "查哨": [["chá"], ["shào"]],
    "查清": [["chá"], ["qīng"]],
    "查实": [["chá"], ["shí"]],
    "查收": [["chá"], ["shōu"]],
    "查私": [["chá"], ["sī"]],
    "查问": [["chá"], ["wèn"]],
    "查询": [["chá"], ["xún"]],
    "查验": [["chá"], ["yàn"]],
    "查夜": [["chá"], ["yè"]],
    "查阅": [["chá"], ["yuè"]],
    "查帐": [["zhā"], ["zhàng"]],
    "查账": [["chá"], ["zhàng"]],
    "查找": [["chá"], ["zhǎo"]],
    "查证": [["chá"], ["zhèng"]],
    "查照": [["zhā"], ["zhào"]],
    "茶场": [["chá"], ["chǎng"]],
    "茶匙": [["chá"], ["chí"]],
    "茶坊": [["chá"], ["fāng"]],
    "茶会": [["chá"], ["huì"]],
    "茶几": [["chá"], ["jī"]],
    "茶食": [["chá"], ["shí"]],
    "茶汤": [["chá"], ["tāng"]],
    "察觉": [["chá"], ["jué"]],
    "茶叶": [["chá"], ["yè"]],
    "察看": [["chá"], ["kàn"]],
    "碴儿": [["chá"], ["ér"]],
    "汊港": [["chà"], ["gǎng"]],
    "差别": [["chā"], ["bié"]],
    "差池": [["chā"], ["chí"]],
    "差错": [["chā"], ["cuò"]],
    "差等": [["chà"], ["děng"]],
    "差点": [["chà"], ["diǎn"]],
    "差官": [["chà"], ["guān"]],
    "差额": [["chā"], ["é"]],
    "差价": [["chā"], ["jià"]],
    "差可": [["chā"], ["kě"]],
    "差劲": [["chà"], ["jìn"]],
    "差距": [["chā"], ["jù"]],
    "差使": [["chāi"], ["shǐ"]],
    "差遣": [["chāi"], ["qiǎn"]],
    "差失": [["chà"], ["shī"]],
    "差事": [["chāi"], ["shì"]],
    "差数": [["chā"], ["shù"]],
    "差误": [["chà"], ["wù"]],
    "差异": [["chā"], ["yì"]],
    "差役": [["chāi"], ["yì"]],
    "拆穿": [["chāi"], ["chuān"]],
    "拆除": [["chāi"], ["chú"]],
    "拆毁": [["chāi"], ["huǐ"]],
    "拆伙": [["chāi"], ["huǒ"]],
    "拆建": [["chāi"], ["jiàn"]],
    "拆借": [["chāi"], ["jiè"]],
    "拆开": [["chāi"], ["kāi"]],
    "拆散": [["chāi"], ["sàn"]],
    "拆迁": [["chāi"], ["qiān"]],
    "拆卖": [["chāi"], ["mài"]],
    "拆台": [["chāi"], ["tái"]],
    "拆息": [["chāi"], ["xī"]],
    "拆洗": [["chāi"], ["xǐ"]],
    "拆线": [["chāi"], ["xiàn"]],
    "拆卸": [["chāi"], ["xiè"]],
    "拆字": [["chāi"], ["zì"]],
    "柴垛": [["chái"], ["duǒ"]],
    "掺和": [["chān"], ["huo"]],
    "搀兑": [["chān"], ["duì"]],
    "搀和": [["chān"], ["huo"]],
    "搀假": [["chān"], ["jiǎ"]],
    "婵媛": [["chán"], ["yuán"]],
    "孱弱": [["chán"], ["ruò"]],
    "禅定": [["chán"], ["dìng"]],
    "禅房": [["chán"], ["fáng"]],
    "禅机": [["chán"], ["jī"]],
    "禅林": [["chán"], ["lín"]],
    "禅门": [["chán"], ["mén"]],
    "禅让": [["shàn"], ["ràng"]],
    "禅师": [["chán"], ["shī"]],
    "禅堂": [["chán"], ["táng"]],
    "禅悟": [["chán"], ["wù"]],
    "禅心": [["chán"], ["xīn"]],
    "禅学": [["chán"], ["xué"]],
    "禅意": [["chán"], ["yì"]],
    "禅院": [["chán"], ["yuàn"]],
    "禅杖": [["chán"], ["zhàng"]],
    "禅宗": [["chán"], ["zōng"]],
    "缠结": [["chán"], ["jié"]],
    "缠磨": [["chán"], ["mó"]],
    "产地": [["chǎn"], ["dì"]],
    "产假": [["chǎn"], ["jià"]],
    "产量": [["chǎn"], ["liàng"]],
    "产期": [["chǎn"], ["qī"]],
    "颤颤": [["chàn"], ["chàn"]],
    "颤动": [["chàn"], ["dòng"]],
    "颤抖": [["chàn"], ["dǒu"]],
    "颤栗": [["zhàn"], ["lì"]],
    "颤声": [["chàn"], ["shēng"]],
    "颤音": [["chàn"], ["yīn"]],
    "颤悠": [["chàn"], ["yōu"]],
    "昌乐": [["chāng"], ["lè"]],
    "昌盛": [["chāng"], ["shèng"]],
    "长安": [["cháng"], ["ān"]],
    "长辈": [["zhǎng"], ["bèi"]],
    "长坂": [["cháng"], ["bǎn"]],
    "长编": [["cháng"], ["biān"]],
    "长膘": [["zhǎng"], ["biāo"]],
    "长波": [["cháng"], ["bō"]],
    "长策": [["cháng"], ["cè"]],
    "长长": [["cháng"], ["cháng"]],
    "长成": [["cháng"], ["chéng"]],
    "长城": [["cháng"], ["chéng"]],
    "长虫": [["cháng"], ["chóng"]],
    "长处": [["cháng"], ["chù"]],
    "长川": [["cháng"], ["chuān"]],
    "长春": [["cháng"], ["chūn"]],
    "长辞": [["cháng"], ["cí"]],
    "长存": [["cháng"], ["cún"]],
    "长大": [["zhǎng"], ["dà"]],
    "长笛": [["cháng"], ["dí"]],
    "长调": [["cháng"], ["diào"]],
    "长度": [["cháng"], ["dù"]],
    "长短": [["cháng"], ["duǎn"]],
    "长队": [["cháng"], ["duì"]],
    "长发": [["cháng"], ["fà"]],
    "长法": [["cháng"], ["fǎ"]],
    "长房": [["zhǎng"], ["fáng"]],
    "长工": [["cháng"], ["gōng"]],
    "长庚": [["cháng"], ["gēng"]],
    "长鼓": [["cháng"], ["gǔ"]],
    "长褂": [["cháng"], ["guà"]],
    "长官": [["zhǎng"], ["guān"]],
    "长跪": [["cháng"], ["guì"]],
    "长号": [["cháng"], ["hào"]],
    "长河": [["cháng"], ["hé"]],
    "长话": [["cháng"], ["huà"]],
    "长虹": [["cháng"], ["hóng"]],
    "长活": [["cháng"], ["huó"]],
    "长假": [["cháng"], ["jià"]],
    "长机": [["cháng"], ["jī"]],
    "长剑": [["cháng"], ["jiàn"]],
    "长江": [["cháng"], ["jiāng"]],
    "长街": [["cháng"], ["jiē"]],
    "长进": [["zhǎng"], ["jìn"]],
    "长久": [["cháng"], ["jiǔ"]],
    "长局": [["cháng"], ["jú"]],
    "长句": [["cháng"], ["jù"]],
    "长卷": [["cháng"], ["juàn"]],
    "长空": [["cháng"], ["kōng"]],
    "长裤": [["cháng"], ["kù"]],
    "长廊": [["cháng"], ["láng"]],
    "长老": [["zhǎng"], ["lǎo"]],
    "长乐": [["cháng"], ["lè"]],
    "长吏": [["zhǎng"], ["lì"]],
    "长流": [["cháng"], ["liú"]],
    "长龙": [["cháng"], ["lóng"]],
    "长毛": [["cháng"], ["máo"]],
    "长矛": [["cháng"], ["máo"]],
    "长门": [["cháng"], ["mén"]],
    "长眠": [["cháng"], ["mián"]],
    "长鸣": [["cháng"], ["míng"]],
    "长命": [["cháng"], ["mìng"]],
    "长男": [["cháng"], ["nán"]],
    "长年": [["cháng"], ["nián"]],
    "长女": [["cháng"], ["nǚ"]],
    "长袍": [["cháng"], ["páo"]],
    "长跑": [["cháng"], ["pǎo"]],
    "长篇": [["cháng"], ["piān"]],
    "长期": [["cháng"], ["qī"]],
    "长崎": [["cháng"], ["qí"]],
    "长枪": [["cháng"], ["qiāng"]],
    "长亲": [["zhǎng"], ["qīn"]],
    "长青": [["cháng"], ["qīng"]],
    "长驱": [["cháng"], ["qū"]],
    "长拳": [["cháng"], ["quán"]],
    "长沙": [["cháng"], ["shā"]],
    "长衫": [["cháng"], ["shān"]],
    "长上": [["zhǎng"], ["shàng"]],
    "长生": [["cháng"], ["shēng"]],
    "长舌": [["cháng"], ["shé"]],
    "长诗": [["cháng"], ["shī"]],
    "长石": [["cháng"], ["shí"]],
    "长势": [["zhǎng"], ["shì"]],
    "长逝": [["cháng"], ["shì"]],
    "长寿": [["cháng"], ["shòu"]],
    "长随": [["cháng"], ["suí"]],
    "长孙": [["zhǎng"], ["sūn"]],
    "长谈": [["cháng"], ["tán"]],
    "长叹": [["cháng"], ["tàn"]],
    "长天": [["cháng"], ["tiān"]],
    "长条": [["cháng"], ["tiáo"]],
    "长汀": [["cháng"], ["tīng"]],
    "长亭": [["cháng"], ["tíng"]],
    "长途": [["cháng"], ["tú"]],
    "长统": [["cháng"], ["tǒng"]],
    "长袜": [["cháng"], ["wà"]],
    "长物": [["zhàng"], ["wù"]],
    "长夏": [["cháng"], ["xià"]],
    "长线": [["cháng"], ["xiàn"]],
    "长相": [["zhǎng"], ["xiàng"]],
    "长啸": [["cháng"], ["xiào"]],
    "长兴": [["cháng"], ["xīng"]],
    "长兄": [["zhǎng"], ["xiōng"]],
    "长性": [["cháng"], ["xìng"]],
    "长袖": [["cháng"], ["xiù"]],
    "长夜": [["cháng"], ["yè"]],
    "长衣": [["cháng"], ["yī"]],
    "长揖": [["cháng"], ["yī"]],
    "长音": [["cháng"], ["yīn"]],
    "长吟": [["cháng"], ["yín"]],
    "长缨": [["cháng"], ["yīng"]],
    "长幼": [["cháng"], ["yòu"]],
    "长于": [["cháng"], ["yú"]],
    "长圆": [["cháng"], ["yuán"]],
    "长远": [["cháng"], ["yuǎn"]],
    "长斋": [["cháng"], ["zhāi"]],
    "长征": [["cháng"], ["zhēng"]],
    "长者": [["zhǎng"], ["zhě"]],
    "长子": [["zhǎng"], ["zǐ"]],
    "长足": [["cháng"], ["zú"]],
    "尝鲜": [["cháng"], ["xiān"]],
    "偿还": [["cháng"], ["huán"]],
    "常服": [["cháng"], ["fú"]],
    "厂长": [["chǎng"], ["zhǎng"]],
    "厂房": [["chǎng"], ["fáng"]],
    "厂规": [["chǎng"], ["guī"]],
    "厂家": [["chǎng"], ["jiā"]],
    "厂矿": [["chǎng"], ["kuàng"]],
    "厂商": [["chǎng"], ["shāng"]],
    "厂史": [["chǎng"], ["shǐ"]],
    "厂休": [["chǎng"], ["xiū"]],
    "厂子": [["chǎng"], ["zǐ"]],
    "场次": [["chǎng"], ["cì"]],
    "场地": [["chǎng"], ["dì"]],
    "场记": [["chǎng"], ["jì"]],
    "场合": [["chǎng"], ["hé"]],
    "场景": [["chǎng"], ["jǐng"]],
    "场面": [["chǎng"], ["miàn"]],
    "场所": [["chǎng"], ["suǒ"]],
    "场屋": [["chǎng"], ["wū"]],
    "场子": [["chǎng"], ["zi"]],
    "场院": [["cháng"], ["yuàn"]],
    "敞车": [["chǎng"], ["chē"]],
    "畅行": [["chàng"], ["xíng"]],
    "倡导": [["chàng"], ["dǎo"]],
    "倡言": [["chàng"], ["yán"]],
    "倡议": [["chàng"], ["yì"]],
    "倡优": [["chàng"], ["yōu"]],
    "唱和": [["chàng"], ["hè"]],
    "唱头": [["chàng"], ["tóu"]],
    "抄查": [["chāo"], ["zhā"]],
    "抄家": [["chāo"], ["jiā"]],
    "钞票": [["chāo"], ["piào"]],
    "抄没": [["chāo"], ["méi"]],
    "超车": [["chāo"], ["chē"]],
    "超度": [["chāo"], ["dù"]],
    "超过": [["chāo"], ["guò"]],
    "超假": [["chāo"], ["jiǎ"]],
    "超员": [["chāo"], ["yuán"]],
    "超载": [["chāo"], ["zài"]],
    "超重": [["chāo"], ["zhòng"]],
    "朝拜": [["cháo"], ["bài"]],
    "朝代": [["cháo"], ["dài"]],
    "朝臣": [["cháo"], ["chén"]],
    "朝服": [["cháo"], ["fú"]],
    "朝纲": [["cháo"], ["gāng"]],
    "朝贡": [["cháo"], ["gòng"]],
    "朝晖": [["zhāo"], ["huī"]],
    "朝见": [["cháo"], ["jiàn"]],
    "朝觐": [["cháo"], ["jìn"]],
    "朝露": [["zhāo"], ["lù"]],
    "朝暮": [["zhāo"], ["mù"]],
    "朝气": [["zhāo"], ["qì"]],
    "朝日": [["cháo"], ["rì"]],
    "朝上": [["cháo"], ["shàng"]],
    "朝圣": [["cháo"], ["shèng"]],
    "朝天": [["cháo"], ["tiān"]],
    "朝廷": [["cháo"], ["tíng"]],
    "朝夕": [["zhāo"], ["xī"]],
    "朝霞": [["zhāo"], ["xiá"]],
    "朝阳": [["zhāo"], ["yáng"]],
    "朝向": [["cháo"], ["xiàng"]],
    "朝野": [["cháo"], ["yě"]],
    "朝政": [["cháo"], ["zhèng"]],
    "朝着": [["cháo"], ["zhe"]],
    "嘲讽": [["cháo"], ["fěng"]],
    "嘲笑": [["cháo"], ["xiào"]],
    "嘲弄": [["cháo"], ["nòng"]],
    "嘲谑": [["cháo"], ["xuè"]],
    "嘲哳": [["zhāo"], ["zhā"]],
    "潮红": [["cháo"], ["hóng"]],
    "潮解": [["cháo"], ["jiě"]],
    "潮头": [["cháo"], ["tóu"]],
    "潮涌": [["cháo"], ["yǒng"]],
    "吵吵": [["chāo"], ["chao"]],
    "吵翻": [["chǎo"], ["fān"]],
    "吵架": [["chǎo"], ["jià"]],
    "吵闹": [["chǎo"], ["nào"]],
    "吵嚷": [["chǎo"], ["rǎng"]],
    "吵扰": [["chǎo"], ["rǎo"]],
    "吵嘴": [["chǎo"], ["zuǐ"]],
    "车把": [["chē"], ["bǎ"]],
    "车帮": [["chē"], ["bāng"]],
    "车场": [["chē"], ["chǎng"]],
    "车船": [["chē"], ["chuán"]],
    "车床": [["chē"], ["chuáng"]],
    "车窗": [["chē"], ["chuāng"]],
    "车次": [["chē"], ["cì"]],
    "车刀": [["chē"], ["dāo"]],
    "车道": [["chē"], ["dào"]],
    "车灯": [["chē"], ["dēng"]],
    "车队": [["chē"], ["duì"]],
    "车费": [["chē"], ["fèi"]],
    "车夫": [["chē"], ["fū"]],
    "车辐": [["chē"], ["fú"]],
    "车盖": [["chē"], ["gài"]],
    "车工": [["chē"], ["gōng"]],
    "车钩": [["chē"], ["gōu"]],
    "车技": [["chē"], ["jì"]],
    "车祸": [["chē"], ["huò"]],
    "车价": [["chē"], ["jià"]],
    "车驾": [["chē"], ["jià"]],
    "车间": [["chē"], ["jiān"]],
    "车架": [["chē"], ["jià"]],
    "车库": [["chē"], ["kù"]],
    "车辆": [["chē"], ["liàng"]],
    "车裂": [["chē"], ["liè"]],
    "车流": [["chē"], ["liú"]],
    "车铃": [["chē"], ["líng"]],
    "车轮": [["chē"], ["lún"]],
    "车马": [["chē"], ["mǎ"]],
    "车门": [["chē"], ["mén"]],
    "车盘": [["chē"], ["pán"]],
    "车皮": [["chē"], ["pí"]],
    "车票": [["chē"], ["piào"]],
    "车前": [["chē"], ["qián"]],
    "车钱": [["chē"], ["qián"]],
    "车身": [["chē"], ["shēn"]],
    "车手": [["chē"], ["shǒu"]],
    "车速": [["chē"], ["sù"]],
    "车胎": [["chē"], ["tāi"]],
    "车条": [["chē"], ["tiáo"]],
    "车头": [["chē"], ["tóu"]],
    "车尾": [["chē"], ["wěi"]],
    "车辖": [["chē"], ["xiá"]],
    "车厢": [["chē"], ["xiāng"]],
    "车箱": [["chē"], ["xiāng"]],
    "车削": [["chē"], ["xiāo"]],
    "车行": [["chē"], ["xíng"]],
    "车辕": [["chē"], ["yuán"]],
    "车载": [["chē"], ["zài"]],
    "车站": [["chē"], ["zhàn"]],
    "车掌": [["chē"], ["zhǎng"]],
    "车照": [["chē"], ["zhào"]],
    "车辙": [["chē"], ["zhé"]],
    "车轴": [["chē"], ["zhóu"]],
    "车主": [["chē"], ["zhǔ"]],
    "车子": [["chē"], ["zi"]],
    "车座": [["chē"], ["zuò"]],
    "彻查": [["chè"], ["zhā"]],
    "彻底": [["chè"], ["dǐ"]],
    "彻骨": [["chè"], ["gǔ"]],
    "坼裂": [["chè"], ["liè"]],
    "撤差": [["chè"], ["chāi"]],
    "撤佃": [["chè"], ["diàn"]],
    "尘芥": [["chén"], ["jiè"]],
    "尘沙": [["chén"], ["shā"]],
    "臣仆": [["chén"], ["pú"]],
    "臣服": [["chén"], ["fú"]],
    "沉没": [["chén"], ["mò"]],
    "沉闷": [["chén"], ["mèn"]],
    "沉溺": [["chén"], ["nì"]],
    "沉思": [["chén"], ["sī"]],
    "沉重": [["chén"], ["zhòng"]],
    "沉着": [["chén"], ["zhuó"]],
    "陈说": [["chén"], ["shuō"]],
    "晨风": [["chén"], ["fēng"]],
    "闯将": [["chuǎng"], ["jiàng"]],
    "闯劲": [["chuǎng"], ["jìn"]],
    "闯王": [["chuǎng"], ["wáng"]],
    "称便": [["chēng"], ["biàn"]],
    "称霸": [["chēng"], ["bà"]],
    "称兵": [["chēng"], ["bīng"]],
    "称病": [["chēng"], ["bìng"]],
    "称臣": [["chēng"], ["chén"]],
    "称贷": [["chēng"], ["dài"]],
    "称道": [["chēng"], ["dào"]],
    "称帝": [["chēng"], ["dì"]],
    "称号": [["chēng"], ["hào"]],
    "称贺": [["chēng"], ["hè"]],
    "称呼": [["chēng"], ["hū"]],
    "称快": [["chēng"], ["kuài"]],
    "称量": [["chēng"], ["liáng"]],
    "称赏": [["chēng"], ["shǎng"]],
    "称身": [["chèn"], ["shēn"]],
    "称述": [["chēng"], ["shù"]],
    "称说": [["chēng"], ["shuō"]],
    "称叹": [["chēng"], ["tàn"]],
    "称颂": [["chēng"], ["sòng"]],
    "称为": [["chēng"], ["wéi"]],
    "称羡": [["chēng"], ["xiàn"]],
    "称谓": [["chēng"], ["wèi"]],
    "称谢": [["chēng"], ["xiè"]],
    "称心": [["chèn"], ["xīn"]],
    "称许": [["chēng"], ["xǔ"]],
    "称雄": [["chēng"], ["xióng"]],
    "称扬": [["chēng"], ["yáng"]],
    "称引": [["chēng"], ["yǐn"]],
    "称意": [["chēng"], ["yì"]],
    "称誉": [["chēng"], ["yù"]],
    "称愿": [["chèn"], ["yuàn"]],
    "称赞": [["chēng"], ["zàn"]],
    "称重": [["chēng"], ["zhòng"]],
    "称职": [["chèn"], ["zhí"]],
    "称作": [["chēng"], ["zuò"]],
    "趁便": [["chèn"], ["biàn"]],
    "趁空": [["chèn"], ["kòng"]],
    "谶语": [["chèn"], ["yǔ"]],
    "撑杆": [["chēng"], ["gān"]],
    "丞相": [["chéng"], ["xiàng"]],
    "成长": [["chéng"], ["zhǎng"]],
    "成仇": [["chéng"], ["chóu"]],
    "成丁": [["chéng"], ["dīng"]],
    "成分": [["chéng"], ["fèn"]],
    "成都": [["chéng"], ["dū"]],
    "成份": [["chéng"], ["fèn"]],
    "成风": [["chéng"], ["fēng"]],
    "成服": [["chéng"], ["fú"]],
    "成化": [["chéng"], ["huà"]],
    "成家": [["chéng"], ["jiā"]],
    "成见": [["chéng"], ["jiàn"]],
    "成亲": [["chéng"], ["qīn"]],
    "成趣": [["chéng"], ["qù"]],
    "成数": [["chéng"], ["shù"]],
    "成说": [["chéng"], ["shuō"]],
    "成体": [["chéng"], ["tǐ"]],
    "成为": [["chéng"], ["wéi"]],
    "成语": [["chéng"], ["yǔ"]],
    "成行": [["chéng"], ["háng"]],
    "成员": [["chéng"], ["yuán"]],
    "成约": [["chéng"], ["yuē"]],
    "呈露": [["chéng"], ["lù"]],
    "呈上": [["chéng"], ["shàng"]],
    "呈正": [["chéng"], ["zhèng"]],
    "承担": [["chéng"], ["dān"]],
    "承当": [["chéng"], ["dāng"]],
    "承兑": [["chéng"], ["duì"]],
    "承浆": [["chéng"], ["jiāng"]],
    "承蒙": [["chéng"], ["méng"]],
    "承应": [["chéng"], ["yìng"]],
    "承载": [["chéng"], ["zài"]],
    "承重": [["chéng"], ["zhòng"]],
    "承转": [["chéng"], ["zhuǎn"]],
    "诚服": [["chéng"], ["fú"]],
    "诚朴": [["chéng"], ["piáo"]],
    "诚信": [["chéng"], ["xìn"]],
    "城堡": [["chéng"], ["bǎo"]],
    "城垛": [["chéng"], ["duǒ"]],
    "城区": [["chéng"], ["qū"]],
    "城阙": [["chéng"], ["què"]],
    "城头": [["chéng"], ["tóu"]],
    "乘便": [["chéng"], ["biàn"]],
    "乘乘": [["chéng"], ["chéng"]],
    "乘车": [["chéng"], ["chē"]],
    "乘除": [["chéng"], ["chú"]],
    "乘法": [["chéng"], ["fǎ"]],
    "乘风": [["chéng"], ["fēng"]],
    "乘方": [["chéng"], ["fāng"]],
    "乘号": [["chéng"], ["hào"]],
    "乘机": [["chéng"], ["jī"]],
    "乘积": [["chéng"], ["jī"]],
    "乘警": [["chéng"], ["jǐng"]],
    "乘客": [["chéng"], ["kè"]],
    "乘马": [["chéng"], ["mǎ"]],
    "乘凉": [["chéng"], ["liáng"]],
    "乘幂": [["chéng"], ["mì"]],
    "乘胜": [["chéng"], ["shèng"]],
    "乘势": [["chéng"], ["shì"]],
    "乘数": [["chéng"], ["shù"]],
    "乘隙": [["chéng"], ["xì"]],
    "乘兴": [["chéng"], ["xìng"]],
    "乘虚": [["chéng"], ["xū"]],
    "乘坐": [["chéng"], ["zuò"]],
    "程度": [["chéng"], ["dù"]],
    "惩处": [["chéng"], ["chǔ"]],
    "澄碧": [["chéng"], ["bì"]],
    "澄澈": [["chéng"], ["chè"]],
    "澄净": [["chéng"], ["jìng"]],
    "澄江": [["chéng"], ["jiāng"]],
    "澄明": [["chéng"], ["míng"]],
    "澄清": [["chéng"], ["qīng"]],
    "澄沙": [["dèng"], ["shā"]],
    "澄莹": [["chéng"], ["yíng"]],
    "橙红": [["chéng"], ["hóng"]],
    "逞能": [["chěng"], ["néng"]],
    "逞强": [["chěng"], ["qiáng"]],
    "秤杆": [["chèng"], ["gǎn"]],
    "吃喝": [["chī"], ["hē"]],
    "吃劲": [["chī"], ["jìn"]],
    "吃食": [["chī"], ["shí"]],
    "吃相": [["chī"], ["xiàng"]],
    "吃重": [["chī"], ["zhòng"]],
    "哧溜": [["chī"], ["liū"]],
    "鸱尾": [["chī"], ["wěi"]],
    "迟疑": [["chí"], ["yí"]],
    "持家": [["chí"], ["jiā"]],
    "持节": [["chí"], ["jié"]],
    "持论": [["chí"], ["lùn"]],
    "持有": [["chí"], ["yǒu"]],
    "持重": [["chí"], ["zhòng"]],
    "持正": [["chí"], ["zhèng"]],
    "匙子": [["chí"], ["zi"]],
    "尺寸": [["chǐ"], ["cùn"]],
    "尺幅": [["chǐ"], ["fú"]],
    "尺度": [["chǐ"], ["dù"]],
    "尺牍": [["chǐ"], ["dú"]],
    "尺骨": [["chǐ"], ["gǔ"]],
    "尺蠖": [["chǐ"], ["huò"]],
    "尺码": [["chǐ"], ["mǎ"]],
    "尺泽": [["chǐ"], ["zé"]],
    "尺子": [["chǐ"], ["zi"]],
    "齿冠": [["chǐ"], ["guān"]],
    "齿条": [["chǐ"], ["tiáo"]],
    "齿龈": [["chǐ"], ["yín"]],
    "耻骨": [["chǐ"], ["gǔ"]],
    "叱喝": [["chì"], ["hè"]],
    "叱令": [["chì"], ["lìng"]],
    "赤背": [["chì"], ["bèi"]],
    "赤地": [["chì"], ["dì"]],
    "赤红": [["chì"], ["hóng"]],
    "赤露": [["chì"], ["lù"]],
    "饬令": [["chì"], ["lìng"]],
    "炽盛": [["chì"], ["shèng"]],
    "翅鞘": [["chì"], ["qiào"]],
    "充当": [["chōng"], ["dāng"]],
    "充任": [["chōng"], ["rèn"]],
    "充分": [["chōng"], ["fèn"]],
    "充塞": [["chōng"], ["sè"]],
    "充数": [["chōng"], ["shù"]],
    "充填": [["chōng"], ["tián"]],
    "充血": [["chōng"], ["xuè"]],
    "冲冲": [["chōng"], ["chōng"]],
    "冲刺": [["chōng"], ["cì"]],
    "冲床": [["chòng"], ["chuáng"]],
    "冲淡": [["chōng"], ["dàn"]],
    "冲动": [["chōng"], ["dòng"]],
    "冲锋": [["chōng"], ["fēng"]],
    "冲犯": [["chōng"], ["fàn"]],
    "冲服": [["chōng"], ["fú"]],
    "冲击": [["chōng"], ["jī"]],
    "冲积": [["chōng"], ["jī"]],
    "冲激": [["chōng"], ["jī"]],
    "冲剂": [["chōng"], ["jì"]],
    "冲劲": [["chòng"], ["jìn"]],
    "冲决": [["chōng"], ["jué"]],
    "冲克": [["chōng"], ["kè"]],
    "冲孔": [["chòng"], ["kǒng"]],
    "冲口": [["chōng"], ["kǒu"]],
    "冲扩": [["chōng"], ["kuò"]],
    "冲浪": [["chōng"], ["làng"]],
    "冲力": [["chōng"], ["lì"]],
    "冲凉": [["chōng"], ["liáng"]],
    "冲量": [["chōng"], ["liàng"]],
    "冲脉": [["chōng"], ["mài"]],
    "冲破": [["chōng"], ["pò"]],
    "冲散": [["chōng"], ["sàn"]],
    "冲杀": [["chōng"], ["shā"]],
    "冲刷": [["chōng"], ["shuā"]],
    "冲水": [["chōng"], ["shuǐ"]],
    "冲塌": [["chōng"], ["tā"]],
    "冲腾": [["chōng"], ["téng"]],
    "冲天": [["chōng"], ["tiān"]],
    "冲突": [["chōng"], ["tū"]],
    "冲洗": [["chōng"], ["xǐ"]],
    "冲喜": [["chōng"], ["xǐ"]],
    "冲销": [["chōng"], ["xiāo"]],
    "冲压": [["chòng"], ["yā"]],
    "冲阳": [["chōng"], ["yáng"]],
    "冲要": [["chōng"], ["yào"]],
    "冲账": [["chōng"], ["zhàng"]],
    "冲帐": [["chōng"], ["zhàng"]],
    "冲撞": [["chōng"], ["zhuàng"]],
    "冲子": [["chòng"], ["zi"]],
    "宠信": [["chǒng"], ["xìn"]],
    "抽查": [["chōu"], ["zhā"]],
    "抽打": [["chōu"], ["dǎ"]],
    "抽调": [["chōu"], ["diào"]],
    "抽丁": [["chōu"], ["dīng"]],
    "抽斗": [["chōu"], ["dǒu"]],
    "抽风": [["chōu"], ["fēng"]],
    "抽空": [["chōu"], ["kōng"]],
    "抽缩": [["chōu"], ["suō"]],
    "抽苔": [["chōu"], ["tái"]],
    "抽头": [["chōu"], ["tóu"]],
    "抽咽": [["chōu"], ["yè"]],
    "仇敌": [["chóu"], ["dí"]],
    "仇恨": [["chóu"], ["hèn"]],
    "仇家": [["chóu"], ["jiā"]],
    "仇人": [["chóu"], ["rén"]],
    "仇视": [["chóu"], ["shì"]],
    "仇杀": [["chóu"], ["shā"]],
    "仇外": [["chóu"], ["wài"]],
    "仇隙": [["chóu"], ["xì"]],
    "仇怨": [["chóu"], ["yuàn"]],
    "绸缪": [["chóu"], ["móu"]],
    "愁闷": [["chóu"], ["mèn"]],
    "愁思": [["chóu"], ["sī"]],
    "稠度": [["chóu"], ["dù"]],
    "筹划": [["chóu"], ["huà"]],
    "稠糊": [["chóu"], ["hū"]],
    "酬答": [["chóu"], ["dá"]],
    "酬和": [["chóu"], ["hè"]],
    "酬应": [["chóu"], ["yìng"]],
    "丑恶": [["chǒu"], ["è"]],
    "丑化": [["chǒu"], ["huà"]],
    "丑角": [["chǒu"], ["jué"]],
    "丑相": [["chǒu"], ["xiàng"]],
    "丑行": [["chǒu"], ["xíng"]],
    "瞅见": [["chǒu"], ["jiàn"]],
    "臭虫": [["chòu"], ["chóng"]],
    "臭椿": [["chòu"], ["chūn"]],
    "臭骂": [["chòu"], ["mà"]],
    "臭美": [["chòu"], ["měi"]],
    "臭棋": [["chòu"], ["qí"]],
    "臭气": [["chòu"], ["qì"]],
    "臭味": [["chòu"], ["wèi"]],
    "臭氧": [["chòu"], ["yǎng"]],
    "出榜": [["chū"], ["bǎng"]],
    "出奔": [["chū"], ["bēn"]],
    "出差": [["chū"], ["chāi"]],
    "出厂": [["chū"], ["chǎng"]],
    "出场": [["chū"], ["chǎng"]],
    "出车": [["chū"], ["chē"]],
    "出乘": [["chū"], ["chéng"]],
    "出处": [["chū"], ["chù"]],
    "出发": [["chū"], ["fā"]],
    "出港": [["chū"], ["gǎng"]],
    "出汗": [["chū"], ["hàn"]],
    "出价": [["chū"], ["jià"]],
    "出家": [["chū"], ["jiā"]],
    "出溜": [["chū"], ["liū"]],
    "出笼": [["chū"], ["lóng"]],
    "出落": [["chū"], ["là"]],
    "出没": [["chū"], ["mò"]],
    "出奇": [["chū"], ["qí"]],
    "出任": [["chū"], ["rèn"]],
    "出圈": [["chū"], ["quān"]],
    "出塞": [["chū"], ["sài"]],
    "出丧": [["chū"], ["sāng"]],
    "出头": [["chū"], ["tóu"]],
    "出台": [["chū"], ["tái"]],
    "出亡": [["chū"], ["wáng"]],
    "出行": [["chū"], ["xíng"]],
    "初创": [["chū"], ["chuàng"]],
    "出血": [["chū"], ["xuè"]],
    "初度": [["chū"], ["dù"]],
    "初会": [["chū"], ["huì"]],
    "初见": [["chū"], ["jiàn"]],
    "初露": [["chū"], ["lù"]],
    "初期": [["chū"], ["qī"]],
    "初中": [["chū"], ["zhōng"]],
    "初叶": [["chū"], ["yè"]],
    "除服": [["chú"], ["fú"]],
    "除号": [["chú"], ["hào"]],
    "除了": [["chú"], ["le"]],
    "除丧": [["chú"], ["sàng"]],
    "除数": [["chú"], ["shù"]],
    "锄地": [["chú"], ["dì"]],
    "锄头": [["chú"], ["tou"]],
    "雏燕": [["chú"], ["yàn"]],
    "础石": [["chǔ"], ["shí"]],
    "橱柜": [["chú"], ["guì"]],
    "储藏": [["chǔ"], ["cáng"]],
    "储量": [["chǔ"], ["liàng"]],
    "楚王": [["chǔ"], ["wáng"]],
    "处罚": [["chǔ"], ["fá"]],
    "处处": [["chǔ"], ["chù"]],
    "处方": [["chǔ"], ["fāng"]],
    "处分": [["chǔ"], ["fèn"]],
    "处境": [["chǔ"], ["jìng"]],
    "处理": [["chǔ"], ["lǐ"]],
    "处决": [["chǔ"], ["jué"]],
    "处女": [["chǔ"], ["nǚ"]],
    "处士": [["chǔ"], ["shì"]],
    "处身": [["chǔ"], ["shēn"]],
    "处世": [["chǔ"], ["shì"]],
    "处事": [["chǔ"], ["shì"]],
    "处暑": [["chǔ"], ["shǔ"]],
    "处死": [["chǔ"], ["sǐ"]],
    "处所": [["chù"], ["suǒ"]],
    "处刑": [["chǔ"], ["xíng"]],
    "处于": [["chǔ"], ["yú"]],
    "处治": [["chǔ"], ["zhì"]],
    "处置": [["chǔ"], ["zhì"]],
    "处子": [["chǔ"], ["zǐ"]],
    "怵头": [["chù"], ["tóu"]],
    "搐缩": [["chù"], ["suō"]],
    "触发": [["chù"], ["fā"]],
    "触角": [["chù"], ["jiǎo"]],
    "触觉": [["chù"], ["jué"]],
    "憷头": [["chù"], ["tóu"]],
    "揣测": [["chuǎi"], ["cè"]],
    "揣度": [["chuǎi"], ["duó"]],
    "揣摸": [["chuǎi"], ["mō"]],
    "揣摩": [["chuǎi"], ["mó"]],
    "揣想": [["chuǎi"], ["xiǎng"]],
    "穿刺": [["chuān"], ["cì"]],
    "穿行": [["chuān"], ["xíng"]],
    "穿着": [["chuān"], ["zhe"]],
    "传本": [["chuán"], ["běn"]],
    "传播": [["chuán"], ["bō"]],
    "传布": [["chuán"], ["bù"]],
    "传抄": [["chuán"], ["chāo"]],
    "传承": [["chuán"], ["chéng"]],
    "传唱": [["chuán"], ["chàng"]],
    "传达": [["chuán"], ["dá"]],
    "传代": [["chuán"], ["dài"]],
    "传单": [["chuán"], ["dān"]],
    "传导": [["chuán"], ["dǎo"]],
    "传道": [["chuán"], ["dào"]],
    "传动": [["chuán"], ["dòng"]],
    "传递": [["chuán"], ["dì"]],
    "传粉": [["chuán"], ["fěn"]],
    "传感": [["chuán"], ["gǎn"]],
    "传告": [["chuán"], ["gào"]],
    "传呼": [["chuán"], ["hū"]],
    "传话": [["chuán"], ["huà"]],
    "传唤": [["chuán"], ["huàn"]],
    "传记": [["zhuàn"], ["jì"]],
    "传家": [["chuán"], ["jiā"]],
    "传教": [["chuán"], ["jiào"]],
    "传经": [["chuán"], ["jīng"]],
    "传令": [["chuán"], ["lìng"]],
    "传略": [["zhuàn"], ["lüè"]],
    "传媒": [["chuán"], ["méi"]],
    "传名": [["chuán"], ["míng"]],
    "传票": [["chuán"], ["piào"]],
    "传奇": [["chuán"], ["qí"]],
    "传球": [["chuán"], ["qiú"]],
    "传情": [["chuán"], ["qíng"]],
    "传染": [["chuán"], ["rǎn"]],
    "传热": [["chuán"], ["rè"]],
    "传人": [["chuán"], ["rén"]],
    "传神": [["chuán"], ["shén"]],
    "传声": [["chuán"], ["shēng"]],
    "传入": [["chuán"], ["rù"]],
    "传世": [["chuán"], ["shì"]],
    "传输": [["chuán"], ["shū"]],
    "传授": [["chuán"], ["shòu"]],
    "传送": [["chuán"], ["sòng"]],
    "传说": [["chuán"], ["shuō"]],
    "传诵": [["chuán"], ["sòng"]],
    "传颂": [["chuán"], ["sòng"]],
    "传统": [["chuán"], ["tǒng"]],
    "传闻": [["chuán"], ["wén"]],
    "传习": [["chuán"], ["xí"]],
    "传讯": [["chuán"], ["xùn"]],
    "传扬": [["chuán"], ["yáng"]],
    "传言": [["chuán"], ["yán"]],
    "传译": [["chuán"], ["yì"]],
    "传阅": [["chuán"], ["yuè"]],
    "传真": [["chuán"], ["zhēn"]],
    "传质": [["chuán"], ["zhì"]],
    "传旨": [["chuán"], ["zhǐ"]],
    "传种": [["chuán"], ["zhǒng"]],
    "船夫": [["chuán"], ["fū"]],
    "串供": [["chuàn"], ["gòng"]],
    "串戏": [["chuàn"], ["xì"]],
    "窗扇": [["chuāng"], ["shàn"]],
    "窗台": [["chuāng"], ["tái"]],
    "床单": [["chuáng"], ["dān"]],
    "床铺": [["chuáng"], ["pù"]],
    "床头": [["chuáng"], ["tóu"]],
    "创办": [["chuàng"], ["bàn"]],
    "创汇": [["chuàng"], ["huì"]],
    "创出": [["chuàng"], ["chū"]],
    "创痕": [["chuāng"], ["hén"]],
    "创建": [["chuàng"], ["jiàn"]],
    "创见": [["chuàng"], ["jiàn"]],
    "创刊": [["chuàng"], ["kān"]],
    "创口": [["chuāng"], ["kǒu"]],
    "创立": [["chuàng"], ["lì"]],
    "创利": [["chuàng"], ["lì"]],
    "创面": [["chuāng"], ["miàn"]],
    "创伤": [["chuāng"], ["shāng"]],
    "创始": [["chuàng"], ["shǐ"]],
    "创设": [["chuàng"], ["shè"]],
    "创痛": [["chuāng"], ["tòng"]],
    "创收": [["chuàng"], ["shōu"]],
    "创新": [["chuàng"], ["xīn"]],
    "创议": [["chuàng"], ["yì"]],
    "创业": [["chuàng"], ["yè"]],
    "创意": [["chuàng"], ["yì"]],
    "创优": [["chuàng"], ["yōu"]],
    "创制": [["chuàng"], ["zhì"]],
    "创造": [["chuàng"], ["zào"]],
    "创作": [["chuàng"], ["zuò"]],
    "吹打": [["chuī"], ["dǎ"]],
    "吹弹": [["chuī"], ["tán"]],
    "吹风": [["chuī"], ["fēng"]],
    "吹拂": [["chuī"], ["fú"]],
    "吹散": [["chuī"], ["sàn"]],
    "吹沙": [["chuī"], ["shā"]],
    "吹台": [["chuī"], ["tái"]],
    "吹嘘": [["chuī"], ["xū"]],
    "垂落": [["chuí"], ["luò"]],
    "垂体": [["chuí"], ["tǐ"]],
    "垂头": [["chuí"], ["tóu"]],
    "锤打": [["chuí"], ["dǎ"]],
    "锤骨": [["chuí"], ["gǔ"]],
    "春分": [["chūn"], ["fēn"]],
    "春风": [["chūn"], ["fēng"]],
    "春化": [["chūn"], ["huà"]],
    "春假": [["chūn"], ["jià"]],
    "春节": [["chūn"], ["jié"]],
    "春景": [["chūn"], ["jǐng"]],
    "春卷": [["chūn"], ["juǎn"]],
    "春雨": [["chūn"], ["yǔ"]],
    "春令": [["chūn"], ["lìng"]],
    "春上": [["chūn"], ["shàng"]],
    "春种": [["chūn"], ["zhòng"]],
    "纯度": [["chún"], ["dù"]],
    "纯钢": [["chún"], ["gāng"]],
    "纯化": [["chún"], ["huà"]],
    "纯净": [["chún"], ["jìng"]],
    "纯朴": [["chún"], ["piáo"]],
    "纯正": [["chún"], ["zhèng"]],
    "纯种": [["chún"], ["zhǒng"]],
    "唇膏": [["chún"], ["gāo"]],
    "唇裂": [["chún"], ["liè"]],
    "淳厚": [["chún"], ["hòu"]],
    "淳美": [["chún"], ["měi"]],
    "淳化": [["chún"], ["huà"]],
    "淳于": [["chún"], ["yú"]],
    "醇和": [["chún"], ["hé"]],
    "醇化": [["chún"], ["huà"]],
    "醇朴": [["chún"], ["piáo"]],
    "醇正": [["chún"], ["zhèng"]],
    "绰绰": [["chuò"], ["chuò"]],
    "绰号": [["chuò"], ["hào"]],
    "绰约": [["chuò"], ["yuē"]],
    "呲牙": [["zī"], ["yá"]],
    "词调": [["cí"], ["diào"]],
    "词令": [["cí"], ["lìng"]],
    "词句": [["cí"], ["jù"]],
    "词曲": [["cí"], ["qǔ"]],
    "词条": [["cí"], ["tiáo"]],
    "词头": [["cí"], ["tóu"]],
    "词尾": [["cí"], ["wěi"]],
    "词语": [["cí"], ["yǔ"]],
    "慈父": [["cí"], ["fù"]],
    "辞别": [["cí"], ["bié"]],
    "慈和": [["cí"], ["hé"]],
    "辞句": [["cí"], ["jù"]],
    "辞令": [["cí"], ["lìng"]],
    "辞条": [["cí"], ["tiáo"]],
    "辞行": [["cí"], ["xíng"]],
    "磁场": [["cí"], ["chǎng"]],
    "磁化": [["cí"], ["huà"]],
    "磁石": [["cí"], ["shí"]],
    "磁体": [["cí"], ["tǐ"]],
    "磁头": [["cí"], ["tóu"]],
    "此地": [["cǐ"], ["dì"]],
    "此间": [["cǐ"], ["jiān"]],
    "次长": [["cì"], ["zhǎng"]],
    "次数": [["cì"], ["shù"]],
    "次要": [["cì"], ["yào"]],
    "刺柏": [["cì"], ["bǎi"]],
    "刺鼻": [["cì"], ["bí"]],
    "刺儿": [["cì"], ["ér"]],
    "刺刀": [["cì"], ["dāo"]],
    "刺耳": [["cì"], ["ěr"]],
    "刺骨": [["cì"], ["gǔ"]],
    "刺槐": [["cì"], ["huái"]],
    "刺客": [["cì"], ["kè"]],
    "刺激": [["cì"], ["jī"]],
    "刺啦": [["cī"], ["lā"]],
    "刺溜": [["cī"], ["liū"]],
    "刺目": [["cì"], ["mù"]],
    "刺配": [["cì"], ["pèi"]],
    "刺破": [["cì"], ["pò"]],
    "刺杀": [["cì"], ["shā"]],
    "刺伤": [["cì"], ["shāng"]],
    "刺史": [["cì"], ["shǐ"]],
    "刺探": [["cì"], ["tàn"]],
    "刺桐": [["cì"], ["tóng"]],
    "刺痛": [["cì"], ["tòng"]],
    "刺头": [["cì"], ["tóu"]],
    "刺网": [["cì"], ["wǎng"]],
    "刺猬": [["cì"], ["wèi"]],
    "刺绣": [["cì"], ["xiù"]],
    "刺眼": [["cì"], ["yǎn"]],
    "刺痒": [["cì"], ["yáng"]],
    "刺针": [["cì"], ["zhēn"]],
    "刺字": [["cì"], ["zì"]],
    "赐教": [["cì"], ["jiào"]],
    "赐给": [["cì"], ["gěi"]],
    "赐予": [["cì"], ["yǔ"]],
    "从不": [["cóng"], ["bù"]],
    "从此": [["cóng"], ["cǐ"]],
    "从动": [["cóng"], ["dòng"]],
    "从而": [["cóng"], ["ér"]],
    "从化": [["cóng"], ["huà"]],
    "从犯": [["cóng"], ["fàn"]],
    "从今": [["cóng"], ["jīn"]],
    "从教": [["cóng"], ["jiào"]],
    "从句": [["cóng"], ["jù"]],
    "从军": [["cóng"], ["jūn"]],
    "从来": [["cóng"], ["lái"]],
    "从良": [["cóng"], ["liáng"]],
    "从略": [["cóng"], ["lüè"]],
    "从命": [["cóng"], ["mìng"]],
    "从前": [["cóng"], ["qián"]],
    "从权": [["cóng"], ["quán"]],
    "从戎": [["cóng"], ["róng"]],
    "从容": [["cóng"], ["róng"]],
    "从师": [["cóng"], ["shī"]],
    "从实": [["cóng"], ["shí"]],
    "从事": [["cóng"], ["shì"]],
    "从俗": [["cóng"], ["sú"]],
    "从速": [["cóng"], ["sù"]],
    "从头": [["cóng"], ["tóu"]],
    "从先": [["cóng"], ["xiān"]],
    "从小": [["cóng"], ["xiǎo"]],
    "从新": [["cóng"], ["xīn"]],
    "从刑": [["cóng"], ["xíng"]],
    "从业": [["cóng"], ["yè"]],
    "从征": [["cóng"], ["zhēng"]],
    "从优": [["cóng"], ["yōu"]],
    "从政": [["cóng"], ["zhèng"]],
    "从中": [["cóng"], ["zhōng"]],
    "从众": [["cóng"], ["zhòng"]],
    "从属": [["cóng"], ["shǔ"]],
    "枞阳": [["zōng"], ["yáng"]],
    "葱头": [["cōng"], ["tóu"]],
    "葱绿": [["cōng"], ["lǜ"]],
    "凑趣": [["còu"], ["qù"]],
    "粗暴": [["cū"], ["bào"]],
    "凑数": [["còu"], ["shù"]],
    "粗浅": [["cū"], ["qiǎn"]],
    "撺弄": [["cuān"], ["nòng"]],
    "催发": [["cuī"], ["fā"]],
    "蹿跳": [["cuān"], ["tiào"]],
    "催化": [["cuī"], ["huà"]],
    "催迫": [["cuī"], ["pò"]],
    "摧折": [["cuī"], ["shé"]],
    "脆骨": [["cuì"], ["gǔ"]],
    "翠柏": [["cuì"], ["bǎi"]],
    "翠绿": [["cuì"], ["lǜ"]],
    "村长": [["cūn"], ["zhǎng"]],
    "村夫": [["cūn"], ["fū"]],
    "村落": [["cūn"], ["luò"]],
    "村上": [["cūn"], ["shàng"]],
    "村头": [["cūn"], ["tóu"]],
    "皴裂": [["cūn"], ["liè"]],
    "存查": [["cún"], ["zhā"]],
    "存单": [["cún"], ["dān"]],
    "存食": [["cún"], ["shí"]],
    "存疑": [["cún"], ["yí"]],
    "存亡": [["cún"], ["wáng"]],
    "存折": [["cún"], ["zhé"]],
    "忖度": [["cǔn"], ["duó"]],
    "寸楷": [["cùn"], ["kǎi"]],
    "忖量": [["cǔn"], ["liàng"]],
    "寸头": [["cùn"], ["tóu"]],
    "搓洗": [["cuō"], ["xǐ"]],
    "搓弄": [["cuō"], ["nòng"]],
    "撮合": [["cuō"], ["hé"]],
    "撮箕": [["cuō"], ["jī"]],
    "撮弄": [["cuō"], ["nòng"]],
    "撮要": [["cuō"], ["yào"]],
    "挫折": [["cuò"], ["zhé"]],
    "错车": [["cuò"], ["chē"]],
    "错处": [["cuò"], ["chǔ"]],
    "错过": [["cuò"], ["guò"]],
    "错觉": [["cuò"], ["jué"]],
    "错落": [["cuò"], ["luò"]],
    "错综": [["cuò"], ["zōng"]],
    "耷拉": [["dā"], ["lā"]],
    "搭便": [["dā"], ["biàn"]],
    "搭车": [["dā"], ["chē"]],
    "搭乘": [["dā"], ["chéng"]],
    "搭盖": [["dā"], ["gài"]],
    "搭载": [["dā"], ["zài"]],
    "搭拉": [["dā"], ["lā"]],
    "嗒嗒": [["dā"], ["dā"]],
    "嗒丧": [["tà"], ["sàng"]],
    "嗒然": [["tà"], ["rán"]],
    "达观": [["dá"], ["guān"]],
    "达摩": [["dá"], ["mó"]],
    "答案": [["dá"], ["àn"]],
    "答拜": [["dá"], ["bài"]],
    "答辩": [["dá"], ["biàn"]],
    "答词": [["dá"], ["cí"]],
    "答对": [["dá"], ["duì"]],
    "答复": [["dá"], ["fù"]],
    "答卷": [["dá"], ["juàn"]],
    "答话": [["dá"], ["huà"]],
    "答礼": [["dá"], ["lǐ"]],
    "答理": [["dā"], ["lǐ"]],
    "答腔": [["dā"], ["qiāng"]],
    "答数": [["dá"], ["shù"]],
    "答问": [["dá"], ["wèn"]],
    "答谢": [["dá"], ["xiè"]],
    "答言": [["dá"], ["yán"]],
    "答疑": [["dá"], ["yí"]],
    "答应": [["dā"], ["yìng"]],
    "答语": [["dá"], ["yǔ"]],
    "答允": [["dā"], ["yǔn"]],
    "打扮": [["dǎ"], ["bàn"]],
    "打靶": [["dǎ"], ["bǎ"]],
    "打败": [["dǎ"], ["bài"]],
    "打包": [["dǎ"], ["bāo"]],
    "打比": [["dǎ"], ["bǐ"]],
    "打草": [["dǎ"], ["cǎo"]],
    "打杈": [["dǎ"], ["chà"]],
    "打颤": [["dǎ"], ["zhàn"]],
    "打岔": [["dǎ"], ["chà"]],
    "打场": [["dǎ"], ["cháng"]],
    "打春": [["dǎ"], ["chūn"]],
    "打从": [["dǎ"], ["cóng"]],
    "打倒": [["dǎ"], ["dǎo"]],
    "打底": [["dǎ"], ["dǐ"]],
    "打点": [["dǎ"], ["diǎn"]],
    "打掉": [["dǎ"], ["diào"]],
    "打顶": [["dǎ"], ["dǐng"]],
    "打动": [["dǎ"], ["dòng"]],
    "打洞": [["dǎ"], ["dòng"]],
    "打斗": [["dǎ"], ["dòu"]],
    "打赌": [["dǎ"], ["dǔ"]],
    "打断": [["dǎ"], ["duàn"]],
    "打盹": [["dǎ"], ["dǔn"]],
    "打呃": [["dǎ"], ["e"]],
    "打发": [["dǎ"], ["fā"]],
    "打法": [["dǎ"], ["fǎ"]],
    "打翻": [["dǎ"], ["fān"]],
    "打分": [["dǎ"], ["fēn"]],
    "打嗝": [["dǎ"], ["gé"]],
    "打更": [["dǎ"], ["gēng"]],
    "打工": [["dǎ"], ["gōng"]],
    "打拱": [["dǎ"], ["gǒng"]],
    "打钩": [["dǎ"], ["gōu"]],
    "打谷": [["dǎ"], ["gǔ"]],
    "打鼓": [["dǎ"], ["gǔ"]],
    "打卦": [["dǎ"], ["guà"]],
    "打鬼": [["dǎ"], ["guǐ"]],
    "打滚": [["dǎ"], ["gǔn"]],
    "打鼾": [["dǎ"], ["hān"]],
    "打夯": [["dǎ"], ["hāng"]],
    "打横": [["dǎ"], ["héng"]],
    "打呼": [["dǎ"], ["hū"]],
    "打滑": [["dǎ"], ["huá"]],
    "打火": [["dǎ"], ["huǒ"]],
    "打诨": [["dǎ"], ["hùn"]],
    "打击": [["dǎ"], ["jī"]],
    "打架": [["dǎ"], ["jià"]],
    "打尖": [["dǎ"], ["jiān"]],
    "打浆": [["dǎ"], ["jiāng"]],
    "打搅": [["dǎ"], ["jiǎo"]],
    "打醮": [["dǎ"], ["jiào"]],
    "打劫": [["dǎ"], ["jié"]],
    "打结": [["dǎ"], ["jié"]],
    "打紧": [["dǎ"], ["jǐn"]],
    "打开": [["dǎ"], ["kāi"]],
    "打孔": [["dǎ"], ["kǒng"]],
    "打垮": [["dǎ"], ["kuǎ"]],
    "打捞": [["dǎ"], ["lāo"]],
    "打雷": [["dǎ"], ["léi"]],
    "打擂": [["dǎ"], ["lèi"]],
    "打理": [["dǎ"], ["lǐ"]],
    "打量": [["dǎ"], ["liang"]],
    "打猎": [["dǎ"], ["liè"]],
    "打乱": [["dǎ"], ["luàn"]],
    "打落": [["dǎ"], ["luò"]],
    "打骂": [["dǎ"], ["mà"]],
    "打门": [["dǎ"], ["mén"]],
    "打磨": [["dǎ"], ["mó"]],
    "打闹": [["dǎ"], ["nào"]],
    "打牌": [["dǎ"], ["pái"]],
    "打炮": [["dǎ"], ["pào"]],
    "打泡": [["dǎ"], ["pào"]],
    "打拼": [["dǎ"], ["pīn"]],
    "打破": [["dǎ"], ["pò"]],
    "打平": [["dǎ"], ["píng"]],
    "打谱": [["dǎ"], ["pǔ"]],
    "打气": [["dǎ"], ["qì"]],
    "打枪": [["dǎ"], ["qiāng"]],
    "打球": [["dǎ"], ["qiú"]],
    "打趣": [["dǎ"], ["qù"]],
    "打拳": [["dǎ"], ["quán"]],
    "打扰": [["dǎ"], ["rǎo"]],
    "打散": [["dǎ"], ["sàn"]],
    "打杀": [["dǎ"], ["shā"]],
    "打扫": [["dǎ"], ["sǎo"]],
    "打闪": [["dǎ"], ["shǎn"]],
    "打伤": [["dǎ"], ["shāng"]],
    "打手": [["dǎ"], ["shǒu"]],
    "打食": [["dǎ"], ["shí"]],
    "打水": [["dǎ"], ["shuǐ"]],
    "打算": [["dǎ"], ["suàn"]],
    "打胎": [["dǎ"], ["tāi"]],
    "打铁": [["dǎ"], ["tiě"]],
    "打探": [["dǎ"], ["tàn"]],
    "打听": [["dǎ"], ["tīng"]],
    "打通": [["dǎ"], ["tōng"]],
    "打头": [["dǎ"], ["tóu"]],
    "打退": [["dǎ"], ["tuì"]],
    "打弯": [["dǎ"], ["wān"]],
    "打问": [["dǎ"], ["wèn"]],
    "打响": [["dǎ"], ["xiǎng"]],
    "打下": [["dǎ"], ["xià"]],
    "打消": [["dǎ"], ["xiāo"]],
    "打旋": [["dǎ"], ["xuán"]],
    "打斜": [["dǎ"], ["xié"]],
    "打眼": [["dǎ"], ["yǎn"]],
    "打烊": [["dǎ"], ["yàng"]],
    "打样": [["dǎ"], ["yàng"]],
    "打药": [["dǎ"], ["yào"]],
    "打印": [["dǎ"], ["yìn"]],
    "打油": [["dǎ"], ["yóu"]],
    "打鱼": [["dǎ"], ["yú"]],
    "打援": [["dǎ"], ["yuán"]],
    "打杂": [["dǎ"], ["zá"]],
    "打造": [["dǎ"], ["zào"]],
    "打战": [["dǎ"], ["zhàn"]],
    "打仗": [["dǎ"], ["zhàng"]],
    "打针": [["dǎ"], ["zhēn"]],
    "打中": [["dǎ"], ["zhòng"]],
    "打皱": [["dǎ"], ["zhòu"]],
    "打住": [["dǎ"], ["zhù"]],
    "打转": [["dǎ"], ["zhuǎn"]],
    "打桩": [["dǎ"], ["zhuāng"]],
    "打字": [["dǎ"], ["zì"]],
    "打总": [["dǎ"], ["zǒng"]],
    "打坐": [["dǎ"], ["zuò"]],
    "打嘴": [["dǎ"], ["zuǐ"]],
    "大安": [["dà"], ["ān"]],
    "大案": [["dà"], ["àn"]],
    "大巴": [["dà"], ["bā"]],
    "大坝": [["dà"], ["bà"]],
    "大把": [["dà"], ["bǎ"]],
    "大白": [["dà"], ["bái"]],
    "大败": [["dà"], ["bài"]],
    "大班": [["dà"], ["bān"]],
    "大半": [["dà"], ["bàn"]],
    "大包": [["dà"], ["bāo"]],
    "大报": [["dà"], ["bào"]],
    "大杯": [["dà"], ["bēi"]],
    "大悲": [["dà"], ["bēi"]],
    "大北": [["dà"], ["běi"]],
    "大本": [["dà"], ["běn"]],
    "大笔": [["dà"], ["bǐ"]],
    "大便": [["dà"], ["biàn"]],
    "大兵": [["dà"], ["bīng"]],
    "大饼": [["dà"], ["bǐng"]],
    "大病": [["dà"], ["bìng"]],
    "大波": [["dà"], ["bō"]],
    "大伯": [["dà"], ["bó"]],
    "大部": [["dà"], ["bù"]],
    "大菜": [["dà"], ["cài"]],
    "大藏": [["dà"], ["zàng"]],
    "大餐": [["dà"], ["cān"]],
    "大肠": [["dà"], ["cháng"]],
    "大氅": [["dà"], ["chǎng"]],
    "大钞": [["dà"], ["chāo"]],
    "大潮": [["dà"], ["cháo"]],
    "大车": [["dà"], ["chē"]],
    "大臣": [["dà"], ["chén"]],
    "大成": [["dà"], ["chéng"]],
    "大城": [["dài"], ["chéng"]],
    "大乘": [["dà"], ["chéng"]],
    "大虫": [["dà"], ["chóng"]],
    "大处": [["dà"], ["chù"]],
    "大错": [["dà"], ["cuò"]],
    "大葱": [["dà"], ["cōng"]],
    "大大": [["dà"], ["dà"]],
    "大胆": [["dà"], ["dǎn"]],
    "大刀": [["dà"], ["dāo"]],
    "大道": [["dà"], ["dào"]],
    "大德": [["dà"], ["dé"]],
    "大堤": [["dà"], ["dī"]],
    "大敌": [["dà"], ["dí"]],
    "大抵": [["dà"], ["dǐ"]],
    "大帝": [["dà"], ["dì"]],
    "大地": [["dà"], ["dì"]],
    "大典": [["dà"], ["diǎn"]],
    "大殿": [["dà"], ["diàn"]],
    "大调": [["dà"], ["diào"]],
    "大都": [["dà"], ["dū"]],
    "大豆": [["dà"], ["dòu"]],
    "大度": [["dà"], ["dù"]],
    "大端": [["dà"], ["duān"]],
    "大队": [["dà"], ["duì"]],
    "大多": [["dà"], ["duō"]],
    "大发": [["dà"], ["fā"]],
    "大法": [["dà"], ["fǎ"]],
    "大凡": [["dà"], ["fán"]],
    "大方": [["dà"], ["fāng"]],
    "大分": [["dà"], ["fēn"]],
    "大粪": [["dà"], ["fèn"]],
    "大风": [["dà"], ["fēng"]],
    "大夫": [["dài"], ["fū"]],
    "大副": [["dà"], ["fù"]],
    "大纲": [["dà"], ["gāng"]],
    "大概": [["dà"], ["gài"]],
    "大干": [["dà"], ["gàn"]],
    "大哥": [["dà"], ["gē"]],
    "大工": [["dà"], ["gōng"]],
    "大公": [["dà"], ["gōng"]],
    "大功": [["dà"], ["gōng"]],
    "大姑": [["dà"], ["gū"]],
    "大鼓": [["dà"], ["gǔ"]],
    "大故": [["dà"], ["gù"]],
    "大褂": [["dà"], ["guà"]],
    "大观": [["dà"], ["guān"]],
    "大关": [["dà"], ["guān"]],
    "大官": [["dà"], ["guān"]],
    "大国": [["dà"], ["guó"]],
    "大过": [["dà"], ["guò"]],
    "大海": [["dà"], ["hǎi"]],
    "大寒": [["dà"], ["hán"]],
    "大汉": [["dà"], ["hàn"]],
    "大好": [["dà"], ["hǎo"]],
    "大号": [["dà"], ["hào"]],
    "大河": [["dà"], ["hé"]],
    "大红": [["dà"], ["hóng"]],
    "大亨": [["dà"], ["hēng"]],
    "大户": [["dà"], ["hù"]],
    "大话": [["dà"], ["huà"]],
    "大黄": [["dài"], ["huáng"]],
    "大会": [["dà"], ["huì"]],
    "大火": [["dà"], ["huǒ"]],
    "大吉": [["dà"], ["jí"]],
    "大伙": [["dà"], ["huǒ"]],
    "大计": [["dà"], ["jì"]],
    "大忌": [["dà"], ["jì"]],
    "大家": [["dà"], ["jiā"]],
    "大蓟": [["dà"], ["jì"]],
    "大驾": [["dà"], ["jià"]],
    "大江": [["dà"], ["jiāng"]],
    "大将": [["dà"], ["jiàng"]],
    "大脚": [["dà"], ["jiǎo"]],
    "大角": [["dà"], ["jiǎo"]],
    "大叫": [["dà"], ["jiào"]],
    "大街": [["dà"], ["jiē"]],
    "大节": [["dà"], ["jié"]],
    "大捷": [["dà"], ["jié"]],
    "大姐": [["dà"], ["jiě"]],
    "大解": [["dà"], ["jiě"]],
    "大襟": [["dà"], ["jīn"]],
    "大舅": [["dà"], ["jiù"]],
    "大举": [["dà"], ["jǔ"]],
    "大局": [["dà"], ["jú"]],
    "大嚼": [["dà"], ["jué"]],
    "大军": [["dà"], ["jūn"]],
    "大卡": [["dà"], ["kǎ"]],
    "大君": [["dà"], ["jūn"]],
    "大楷": [["dà"], ["kǎi"]],
    "大考": [["dà"], ["kǎo"]],
    "大课": [["dà"], ["kè"]],
    "大口": [["dà"], ["kǒu"]],
    "大块": [["dà"], ["kuài"]],
    "大款": [["dà"], ["kuǎn"]],
    "大老": [["dà"], ["lǎo"]],
    "大牢": [["dà"], ["láo"]],
    "大浪": [["dà"], ["làng"]],
    "大礼": [["dà"], ["lǐ"]],
    "大理": [["dà"], ["lǐ"]],
    "大吏": [["dà"], ["lì"]],
    "大历": [["dà"], ["lì"]],
    "大荔": [["dà"], ["lì"]],
    "大力": [["dà"], ["lì"]],
    "大连": [["dà"], ["lián"]],
    "大殓": [["dà"], ["liàn"]],
    "大梁": [["dà"], ["liáng"]],
    "大量": [["dà"], ["liàng"]],
    "大料": [["dà"], ["liào"]],
    "大陵": [["dà"], ["líng"]],
    "大龄": [["dà"], ["líng"]],
    "大溜": [["dà"], ["liù"]],
    "大陆": [["dà"], ["lù"]],
    "大路": [["dà"], ["lù"]],
    "大吕": [["dà"], ["lǚ"]],
    "大略": [["dà"], ["lüè"]],
    "大率": [["dà"], ["shuài"]],
    "大锣": [["dà"], ["luó"]],
    "大妈": [["dà"], ["mā"]],
    "大麻": [["dà"], ["má"]],
    "大麦": [["dà"], ["mài"]],
    "大忙": [["dà"], ["máng"]],
    "大毛": [["dà"], ["máo"]],
    "大媒": [["dà"], ["méi"]],
    "大门": [["dà"], ["mén"]],
    "大米": [["dà"], ["mǐ"]],
    "大面": [["dà"], ["miàn"]],
    "大名": [["dà"], ["míng"]],
    "大明": [["dà"], ["míng"]],
    "大漠": [["dà"], ["mò"]],
    "大拿": [["dà"], ["ná"]],
    "大内": [["dà"], ["nèi"]],
    "大难": [["dà"], ["nàn"]],
    "大脑": [["dà"], ["nǎo"]],
    "大鲵": [["dà"], ["ní"]],
    "大逆": [["dà"], ["nì"]],
    "大年": [["dà"], ["nián"]],
    "大娘": [["dà"], ["niáng"]],
    "大宁": [["dà"], ["níng"]],
    "大炮": [["dà"], ["pào"]],
    "大批": [["dà"], ["pī"]],
    "大片": [["dà"], ["piàn"]],
    "大气": [["dà"], ["qì"]],
    "大器": [["dà"], ["qì"]],
    "大钱": [["dà"], ["qián"]],
    "大桥": [["dà"], ["qiáo"]],
    "大墙": [["dà"], ["qiáng"]],
    "大青": [["dà"], ["qīng"]],
    "大庆": [["dà"], ["qìng"]],
    "大秋": [["dà"], ["qiū"]],
    "大曲": [["dà"], ["qū"]],
    "大区": [["dà"], ["qū"]],
    "大权": [["dà"], ["quán"]],
    "大全": [["dà"], ["quán"]],
    "大群": [["dà"], ["qún"]],
    "大人": [["dà"], ["rén"]],
    "大任": [["dà"], ["rèn"]],
    "大肉": [["dà"], ["ròu"]],
    "大儒": [["dà"], ["rú"]],
    "大赛": [["dà"], ["sài"]],
    "大嫂": [["dà"], ["sǎo"]],
    "大赦": [["dà"], ["shè"]],
    "大身": [["dà"], ["shēn"]],
    "大神": [["dà"], ["shén"]],
    "大婶": [["dà"], ["shěn"]],
    "大声": [["dà"], ["shēng"]],
    "大圣": [["dà"], ["shèng"]],
    "大使": [["dà"], ["shǐ"]],
    "大师": [["dà"], ["shī"]],
    "大市": [["dà"], ["shì"]],
    "大事": [["dà"], ["shì"]],
    "大寿": [["dà"], ["shòu"]],
    "大势": [["dà"], ["shì"]],
    "大书": [["dà"], ["shū"]],
    "大叔": [["dà"], ["shū"]],
    "大暑": [["dà"], ["shǔ"]],
    "大数": [["dà"], ["shù"]],
    "大树": [["dà"], ["shù"]],
    "大帅": [["dà"], ["shuài"]],
    "大顺": [["dà"], ["shùn"]],
    "大水": [["dà"], ["shuǐ"]],
    "大肆": [["dà"], ["sì"]],
    "大蒜": [["dà"], ["suàn"]],
    "大谈": [["dà"], ["tán"]],
    "大堂": [["dà"], ["táng"]],
    "大体": [["dà"], ["tǐ"]],
    "大田": [["dà"], ["tián"]],
    "大厅": [["dà"], ["tīng"]],
    "大通": [["dà"], ["tōng"]],
    "大同": [["dà"], ["tóng"]],
    "大统": [["dà"], ["tǒng"]],
    "大头": [["dà"], ["tóu"]],
    "大腿": [["dà"], ["tuǐ"]],
    "大腕": [["dà"], ["wàn"]],
    "大王": [["dài"], ["wáng"]],
    "大卫": [["dà"], ["wèi"]],
    "大尉": [["dà"], ["wèi"]],
    "大我": [["dà"], ["wǒ"]],
    "大悟": [["dà"], ["wù"]],
    "大戏": [["dà"], ["xì"]],
    "大喜": [["dà"], ["xǐ"]],
    "大系": [["dà"], ["xì"]],
    "大侠": [["dà"], ["xiá"]],
    "大厦": [["dà"], ["shà"]],
    "大限": [["dà"], ["xiàn"]],
    "大项": [["dà"], ["xiàng"]],
    "大象": [["dà"], ["xiàng"]],
    "大小": [["dà"], ["xiǎo"]],
    "大校": [["dà"], ["xiào"]],
    "大笑": [["dà"], ["xiào"]],
    "大写": [["dà"], ["xiě"]],
    "大兴": [["dà"], ["xīng"]],
    "大刑": [["dà"], ["xíng"]],
    "大型": [["dà"], ["xíng"]],
    "大姓": [["dà"], ["xìng"]],
    "大幸": [["dà"], ["xìng"]],
    "大修": [["dà"], ["xiū"]],
    "大选": [["dà"], ["xuǎn"]],
    "大学": [["dà"], ["xué"]],
    "大雪": [["dà"], ["xuě"]],
    "大牙": [["dà"], ["yá"]],
    "大雅": [["dà"], ["yá"]],
    "大烟": [["dà"], ["yān"]],
    "大盐": [["dà"], ["yán"]],
    "大雁": [["dà"], ["yàn"]],
    "大洋": [["dà"], ["yáng"]],
    "大样": [["dà"], ["yàng"]],
    "大爷": [["dà"], ["yé"]],
    "大要": [["dà"], ["yào"]],
    "大冶": [["dà"], ["yě"]],
    "大一": [["dà"], ["yī"]],
    "大业": [["dà"], ["yè"]],
    "大衣": [["dà"], ["yī"]],
    "大姨": [["dà"], ["yí"]],
    "大义": [["dà"], ["yì"]],
    "大意": [["dà"], ["yì"]],
    "大邑": [["dà"], ["yì"]],
    "大印": [["dà"], ["yìn"]],
    "大油": [["dà"], ["yóu"]],
    "大有": [["dà"], ["yǒu"]],
    "大余": [["dà"], ["yú"]],
    "大宇": [["dà"], ["yǔ"]],
    "大禹": [["dà"], ["yǔ"]],
    "大雨": [["dà"], ["yǔ"]],
    "大员": [["dà"], ["yuán"]],
    "大圆": [["dà"], ["yuán"]],
    "大院": [["dà"], ["yuàn"]],
    "大月": [["dà"], ["yuè"]],
    "大早": [["dà"], ["zǎo"]],
    "大约": [["dà"], ["yuē"]],
    "大枣": [["dà"], ["zǎo"]],
    "大灶": [["dà"], ["zào"]],
    "大战": [["dà"], ["zhàn"]],
    "大政": [["dà"], ["zhèng"]],
    "大指": [["dà"], ["zhǐ"]],
    "大志": [["dà"], ["zhì"]],
    "大治": [["dà"], ["zhì"]],
    "大致": [["dà"], ["zhì"]],
    "大智": [["dà"], ["zhì"]],
    "大钟": [["dà"], ["zhōng"]],
    "大众": [["dà"], ["zhòng"]],
    "大洲": [["dà"], ["zhōu"]],
    "大专": [["dà"], ["zhuān"]],
    "大壮": [["dà"], ["zhuàng"]],
    "大篆": [["dà"], ["zhuàn"]],
    "大子": [["tài"], ["zǐ"]],
    "大字": [["dà"], ["zì"]],
    "大宗": [["dà"], ["zōng"]],
    "大族": [["dà"], ["zú"]],
    "大足": [["dà"], ["zú"]],
    "呆头": [["dāi"], ["tóu"]],
    "大作": [["dà"], ["zuò"]],
    "代称": [["dài"], ["chēng"]],
    "歹毒": [["dǎi"], ["dú"]],
    "代号": [["dài"], ["hào"]],
    "代价": [["dài"], ["jià"]],
    "代数": [["dài"], ["shù"]],
    "代为": [["dài"], ["wéi"]],
    "代行": [["dài"], ["xíng"]],
    "带钢": [["dài"], ["gāng"]],
    "带劲": [["dài"], ["jìn"]],
    "带菌": [["dài"], ["jūn"]],
    "带累": [["dài"], ["lèi"]],
    "带脉": [["dài"], ["mài"]],
    "带头": [["dài"], ["tóu"]],
    "待办": [["dài"], ["bàn"]],
    "待查": [["dài"], ["zhā"]],
    "待承": [["dài"], ["chéng"]],
    "待到": [["dài"], ["dào"]],
    "待机": [["dài"], ["jī"]],
    "待考": [["dài"], ["kǎo"]],
    "待命": [["dài"], ["mìng"]],
    "待客": [["dài"], ["kè"]],
    "待聘": [["dài"], ["pìn"]],
    "待人": [["dài"], ["rén"]],
    "待续": [["dài"], ["xù"]],
    "待业": [["dài"], ["yè"]],
    "待用": [["dài"], ["yòng"]],
    "待遇": [["dài"], ["yù"]],
    "待制": [["dài"], ["zhì"]],
    "殆尽": [["dài"], ["jìn"]],
    "黛绿": [["dài"], ["lǜ"]],
    "丹参": [["dān"], ["shēn"]],
    "丹毒": [["dān"], ["dú"]],
    "单摆": [["dān"], ["bǎi"]],
    "单帮": [["dān"], ["bāng"]],
    "单兵": [["dān"], ["bīng"]],
    "单薄": [["dān"], ["bó"]],
    "单程": [["dān"], ["chéng"]],
    "单产": [["dān"], ["chǎn"]],
    "单车": [["dān"], ["chē"]],
    "单传": [["dān"], ["chuán"]],
    "单纯": [["dān"], ["chún"]],
    "单词": [["dān"], ["cí"]],
    "单打": [["dān"], ["dǎ"]],
    "单单": [["dān"], ["dān"]],
    "单刀": [["dān"], ["dāo"]],
    "单调": [["dān"], ["diào"]],
    "单独": [["dān"], ["dú"]],
    "单发": [["dān"], ["fā"]],
    "单方": [["dān"], ["fāng"]],
    "单幅": [["dān"], ["fú"]],
    "单干": [["dān"], ["gàn"]],
    "单杠": [["dān"], ["gàng"]],
    "单轨": [["dān"], ["guǐ"]],
    "单寒": [["dān"], ["hán"]],
    "单机": [["dān"], ["jī"]],
    "单极": [["dān"], ["jí"]],
    "单价": [["dān"], ["jià"]],
    "单间": [["dān"], ["jiān"]],
    "单句": [["dān"], ["jù"]],
    "单据": [["dān"], ["jù"]],
    "单口": [["dān"], ["kǒu"]],
    "单裤": [["dān"], ["kù"]],
    "单利": [["dān"], ["lì"]],
    "单恋": [["dān"], ["liàn"]],
    "单列": [["dān"], ["liè"]],
    "单另": [["dān"], ["lìng"]],
    "单门": [["dān"], ["mén"]],
    "单篇": [["dān"], ["piān"]],
    "单骑": [["dān"], ["qí"]],
    "单弱": [["dān"], ["ruò"]],
    "单身": [["dān"], ["shēn"]],
    "单数": [["dān"], ["shù"]],
    "单瘫": [["dān"], ["tān"]],
    "单糖": [["dān"], ["táng"]],
    "单位": [["dān"], ["wèi"]],
    "单弦": [["dān"], ["xián"]],
    "单线": [["dān"], ["xiàn"]],
    "单向": [["dān"], ["xiàng"]],
    "单行": [["dān"], ["xíng"]],
    "单姓": [["shàn"], ["xìng"]],
    "单衣": [["dān"], ["yī"]],
    "单一": [["dān"], ["yī"]],
    "单用": [["dān"], ["yòng"]],
    "单于": [["chán"], ["yú"]],
    "单元": [["dān"], ["yuán"]],
    "单子": [["dān"], ["zi"]],
    "单字": [["dān"], ["zì"]],
    "单作": [["dān"], ["zuò"]],
    "担保": [["dān"], ["bǎo"]],
    "担承": [["dān"], ["chéng"]],
    "担待": [["dān"], ["dài"]],
    "担当": [["dān"], ["dāng"]],
    "担负": [["dān"], ["fù"]],
    "担搁": [["dān"], ["gē"]],
    "担任": [["dān"], ["rèn"]],
    "担架": [["dān"], ["jià"]],
    "担心": [["dān"], ["xīn"]],
    "担忧": [["dān"], ["yōu"]],
    "担子": [["dàn"], ["zi"]],
    "耽溺": [["dān"], ["nì"]],
    "耽搁": [["dān"], ["gē"]],
    "胆量": [["dǎn"], ["liàng"]],
    "胆囊": [["dǎn"], ["náng"]],
    "胆识": [["dǎn"], ["shí"]],
    "旦角": [["dàn"], ["jué"]],
    "弹词": [["tán"], ["cí"]],
    "弹射": [["tán"], ["shè"]],
    "弹腿": [["dàn"], ["tuǐ"]],
    "弹丸": [["dàn"], ["wán"]],
    "弹性": [["tán"], ["xìng"]],
    "弹药": [["dàn"], ["yào"]],
    "弹子": [["dàn"], ["zǐ"]],
    "淡化": [["dàn"], ["huà"]],
    "澹澹": [["dàn"], ["dàn"]],
    "澹台": [["tán"], ["tái"]],
    "当兵": [["dāng"], ["bīng"]],
    "当班": [["dāng"], ["bān"]],
    "当差": [["dāng"], ["chāi"]],
    "当场": [["dāng"], ["chǎng"]],
    "当朝": [["dāng"], ["cháo"]],
    "当成": [["dàng"], ["chéng"]],
    "当初": [["dāng"], ["chū"]],
    "当代": [["dāng"], ["dài"]],
    "当当": [["dāng"], ["dāng"]],
    "当道": [["dāng"], ["dào"]],
    "当地": [["dāng"], ["dì"]],
    "当儿": [["dāng"], ["ér"]],
    "当官": [["dāng"], ["guān"]],
    "当归": [["dāng"], ["guī"]],
    "当即": [["dāng"], ["jí"]],
    "当家": [["dāng"], ["jiā"]],
    "当街": [["dāng"], ["jiē"]],
    "当今": [["dāng"], ["jīn"]],
    "当紧": [["dāng"], ["jǐn"]],
    "当局": [["dāng"], ["jú"]],
    "当空": [["dāng"], ["kōng"]],
    "当口": [["dāng"], ["kǒu"]],
    "当啷": [["dāng"], ["lāng"]],
    "当量": [["dāng"], ["liàng"]],
    "当令": [["dāng"], ["lìng"]],
    "当路": [["dāng"], ["lù"]],
    "当年": [["dāng"], ["nián"]],
    "当面": [["dāng"], ["miàn"]],
    "当票": [["dàng"], ["piào"]],
    "当铺": [["dàng"], ["pù"]],
    "当期": [["dāng"], ["qī"]],
    "当前": [["dāng"], ["qián"]],
    "当然": [["dāng"], ["rán"]],
    "当权": [["dāng"], ["quán"]],
    "当日": [["dāng"], ["rì"]],
    "当时": [["dāng"], ["shí"]],
    "当事": [["dāng"], ["shì"]],
    "当世": [["dāng"], ["shì"]],
    "当堂": [["dāng"], ["táng"]],
    "当天": [["dàng"], ["tiān"]],
    "当庭": [["dāng"], ["tíng"]],
    "当头": [["dāng"], ["tóu"]],
    "当涂": [["dāng"], ["tú"]],
    "当晚": [["dàng"], ["wǎn"]],
    "当午": [["dāng"], ["wǔ"]],
    "当下": [["dāng"], ["xià"]],
    "当先": [["dāng"], ["xiān"]],
    "当心": [["dāng"], ["xīn"]],
    "当胸": [["dāng"], ["xiōng"]],
    "当选": [["dāng"], ["xuǎn"]],
    "当阳": [["dāng"], ["yáng"]],
    "当腰": [["dāng"], ["yāo"]],
    "当夜": [["dàng"], ["yè"]],
    "当月": [["dàng"], ["yuè"]],
    "当真": [["dàng"], ["zhēn"]],
    "当政": [["dāng"], ["zhèng"]],
    "当值": [["dāng"], ["zhí"]],
    "当中": [["dāng"], ["zhōng"]],
    "当众": [["dāng"], ["zhòng"]],
    "当子": [["dāng"], ["zǐ"]],
    "当作": [["dàng"], ["zuò"]],
    "当做": [["dàng"], ["zuò"]],
    "挡板": [["dǎng"], ["bǎn"]],
    "挡车": [["dǎng"], ["chē"]],
    "挡驾": [["dǎng"], ["jià"]],
    "挡路": [["dǎng"], ["lù"]],
    "挡子": [["dǎng"], ["zǐ"]],
    "党风": [["dǎng"], ["fēng"]],
    "党参": [["dǎng"], ["shēn"]],
    "党棍": [["dǎng"], ["gùn"]],
    "党纪": [["dǎng"], ["jì"]],
    "党禁": [["dǎng"], ["jìn"]],
    "党票": [["dǎng"], ["piào"]],
    "党校": [["dǎng"], ["xiào"]],
    "党委": [["dǎng"], ["wěi"]],
    "党员": [["dǎng"], ["yuán"]],
    "刀把": [["dāo"], ["bà"]],
    "刀背": [["dāo"], ["bèi"]],
    "刀叉": [["dāo"], ["chā"]],
    "刀片": [["dāo"], ["piàn"]],
    "刀鞘": [["dāo"], ["qiào"]],
    "刀头": [["dāo"], ["tóu"]],
    "刀削": [["dāo"], ["xiāo"]],
    "叨叨": [["dāo"], ["dao"]],
    "叨咕": [["dáo"], ["gu"]],
    "叨唠": [["dāo"], ["lao"]],
    "叨光": [["tāo"], ["guāng"]],
    "叨念": [["dāo"], ["niàn"]],
    "叨扰": [["tāo"], ["rǎo"]],
    "导弹": [["dǎo"], ["dàn"]],
    "导读": [["dǎo"], ["dú"]],
    "导论": [["dǎo"], ["lùn"]],
    "导语": [["dǎo"], ["yǔ"]],
    "导体": [["dǎo"], ["tǐ"]],
    "倒把": [["dǎo"], ["bǎ"]],
    "倒班": [["dǎo"], ["bān"]],
    "倒包": [["dǎo"], ["bāo"]],
    "倒闭": [["dǎo"], ["bì"]],
    "倒毙": [["dǎo"], ["bì"]],
    "倒彩": [["dào"], ["cǎi"]],
    "倒仓": [["dǎo"], ["cāng"]],
    "倒插": [["dào"], ["chā"]],
    "倒茬": [["dǎo"], ["chá"]],
    "倒车": [["dào"], ["chē"]],
    "倒垂": [["dǎo"], ["chuí"]],
    "倒刺": [["dào"], ["cì"]],
    "倒错": [["dǎo"], ["cuò"]],
    "倒地": [["dǎo"], ["dì"]],
    "倒反": [["dǎo"], ["fǎn"]],
    "倒伏": [["dǎo"], ["fú"]],
    "倒放": [["dào"], ["fàng"]],
    "倒戈": [["dǎo"], ["gē"]],
    "倒阁": [["dǎo"], ["gé"]],
    "倒挂": [["dào"], ["guà"]],
    "倒灌": [["dào"], ["guàn"]],
    "倒换": [["dǎo"], ["huàn"]],
    "倒嚼": [["dǎo"], ["jiào"]],
    "倒睫": [["dào"], ["jié"]],
    "倒空": [["dào"], ["kōng"]],
    "倒立": [["dào"], ["lì"]],
    "倒流": [["dào"], ["liú"]],
    "倒卖": [["dǎo"], ["mài"]],
    "倒霉": [["dǎo"], ["méi"]],
    "倒弄": [["dǎo"], ["nòng"]],
    "倒赔": [["dào"], ["péi"]],
    "倒嗓": [["dǎo"], ["sǎng"]],
    "倒是": [["dǎo"], ["shì"]],
    "倒手": [["dǎo"], ["shǒu"]],
    "倒数": [["dào"], ["shǔ"]],
    "倒算": [["dǎo"], ["suàn"]],
    "倒塌": [["dǎo"], ["tā"]],
    "倒锁": [["dào"], ["suǒ"]],
    "倒台": [["dǎo"], ["tái"]],
    "倒坍": [["dǎo"], ["tān"]],
    "倒腾": [["dǎo"], ["téng"]],
    "倒替": [["dǎo"], ["tì"]],
    "倒贴": [["dào"], ["tiē"]],
    "倒头": [["dǎo"], ["tóu"]],
    "倒退": [["dào"], ["tuì"]],
    "倒下": [["dǎo"], ["xià"]],
    "倒休": [["dǎo"], ["xiū"]],
    "倒序": [["dǎo"], ["xù"]],
    "倒叙": [["dào"], ["xù"]],
    "倒悬": [["dào"], ["xuán"]],
    "倒牙": [["dǎo"], ["yá"]],
    "倒影": [["dào"], ["yǐng"]],
    "倒爷": [["dǎo"], ["yé"]],
    "倒映": [["dào"], ["yìng"]],
    "倒运": [["dǎo"], ["yùn"]],
    "倒灶": [["dǎo"], ["zào"]],
    "倒账": [["dǎo"], ["zhàng"]],
    "倒找": [["dǎo"], ["zhǎo"]],
    "倒置": [["dào"], ["zhì"]],
    "倒转": [["dào"], ["zhuǎn"]],
    "倒装": [["dào"], ["zhuāng"]],
    "倒座": [["dǎo"], ["zuò"]],
    "到场": [["dào"], ["chǎng"]],
    "到处": [["dào"], ["chù"]],
    "到底": [["dào"], ["dǐ"]],
    "到家": [["dào"], ["jiā"]],
    "到了": [["dào"], ["le"]],
    "到期": [["dào"], ["qī"]],
    "到任": [["dào"], ["rèn"]],
    "到头": [["dào"], ["tóu"]],
    "悼亡": [["dào"], ["wáng"]],
    "道藏": [["dào"], ["zàng"]],
    "道别": [["dào"], ["bié"]],
    "道长": [["dào"], ["cháng"]],
    "道场": [["dào"], ["chǎng"]],
    "道地": [["dào"], ["dì"]],
    "道钉": [["dào"], ["dīng"]],
    "道观": [["dào"], ["guàn"]],
    "道号": [["dào"], ["hào"]],
    "道家": [["dào"], ["jiā"]],
    "道术": [["dào"], ["shù"]],
    "道教": [["dào"], ["jiào"]],
    "道行": [["dào"], ["héng"]],
    "得逞": [["dé"], ["chěng"]],
    "得当": [["dé"], ["dàng"]],
    "得道": [["dé"], ["dào"]],
    "得法": [["dé"], ["fǎ"]],
    "得劲": [["dé"], ["jìn"]],
    "得力": [["dé"], ["lì"]],
    "得胜": [["dé"], ["shèng"]],
    "得手": [["dé"], ["shǒu"]],
    "得体": [["dé"], ["tǐ"]],
    "得意": [["dé"], ["yì"]],
    "得益": [["dé"], ["yì"]],
    "得知": [["dé"], ["zhī"]],
    "得志": [["dé"], ["zhì"]],
    "得罪": [["dé"], ["zuì"]],
    "德化": [["dé"], ["huà"]],
    "德行": [["dé"], ["xíng"]],
    "德语": [["dé"], ["yǔ"]],
    "的当": [["dí"], ["dàng"]],
    "的确": [["dí"], ["què"]],
    "的士": [["dí"], ["shì"]],
    "灯会": [["dēng"], ["huì"]],
    "灯节": [["dēng"], ["jié"]],
    "灯笼": [["dēng"], ["lóng"]],
    "灯捻": [["dēng"], ["niǎn"]],
    "灯泡": [["dēng"], ["pào"]],
    "灯台": [["dēng"], ["tái"]],
    "灯芯": [["dēng"], ["xīn"]],
    "灯头": [["dēng"], ["tóu"]],
    "灯语": [["dēng"], ["yǔ"]],
    "登场": [["dēng"], ["chǎng"]],
    "登台": [["dēng"], ["tái"]],
    "登载": [["dēng"], ["zǎi"]],
    "等差": [["děng"], ["chà"]],
    "等待": [["děng"], ["dài"]],
    "等份": [["děng"], ["fèn"]],
    "等号": [["děng"], ["hào"]],
    "等分": [["děng"], ["fēn"]],
    "等价": [["děng"], ["jià"]],
    "等量": [["děng"], ["liàng"]],
    "等同": [["děng"], ["tóng"]],
    "低凹": [["dī"], ["āo"]],
    "低地": [["dī"], ["dì"]],
    "低调": [["dī"], ["diào"]],
    "低估": [["dī"], ["gū"]],
    "低空": [["dī"], ["kōng"]],
    "低落": [["dī"], ["luò"]],
    "低能": [["dī"], ["néng"]],
    "低频": [["dī"], ["pín"]],
    "低头": [["dī"], ["tóu"]],
    "低压": [["dī"], ["yā"]],
    "低哑": [["dī"], ["yǎ"]],
    "低语": [["dī"], ["yǔ"]],
    "嘀嗒": [["dī"], ["dā"]],
    "滴答": [["dī"], ["dá"]],
    "敌忾": [["dí"], ["kài"]],
    "敌台": [["dí"], ["tái"]],
    "敌区": [["dí"], ["qū"]],
    "涤卡": [["dí"], ["kǎ"]],
    "涤纶": [["dí"], ["lún"]],
    "嫡传": [["dí"], ["chuán"]],
    "嫡亲": [["dí"], ["qīn"]],
    "嫡孙": [["dí"], ["sūn"]],
    "嫡系": [["dí"], ["xì"]],
    "底版": [["dǐ"], ["bǎn"]],
    "底本": [["dǐ"], ["běn"]],
    "底边": [["dǐ"], ["biān"]],
    "底册": [["dǐ"], ["cè"]],
    "底层": [["dǐ"], ["céng"]],
    "底定": [["dǐ"], ["dìng"]],
    "底肥": [["dǐ"], ["féi"]],
    "底工": [["dǐ"], ["gōng"]],
    "底稿": [["dǐ"], ["gǎo"]],
    "底火": [["dǐ"], ["huǒ"]],
    "底襟": [["dǐ"], ["jīn"]],
    "底角": [["dǐ"], ["jiǎo"]],
    "底孔": [["dǐ"], ["kǒng"]],
    "底里": [["dǐ"], ["lǐ"]],
    "底牌": [["dǐ"], ["pái"]],
    "底盘": [["dǐ"], ["pán"]],
    "底片": [["dǐ"], ["piàn"]],
    "底漆": [["dǐ"], ["qī"]],
    "底气": [["dǐ"], ["qì"]],
    "底色": [["dǐ"], ["sè"]],
    "底墒": [["dǐ"], ["shāng"]],
    "底数": [["dǐ"], ["shù"]],
    "底土": [["dǐ"], ["tǔ"]],
    "底细": [["dǐ"], ["xì"]],
    "底下": [["dǐ"], ["xià"]],
    "底线": [["dǐ"], ["xiàn"]],
    "底薪": [["dǐ"], ["xīn"]],
    "底样": [["dǐ"], ["yàng"]],
    "底账": [["dǐ"], ["zhàng"]],
    "底蕴": [["dǐ"], ["yùn"]],
    "底止": [["dǐ"], ["zhǐ"]],
    "底子": [["dǐ"], ["zi"]],
    "抵挡": [["dǐ"], ["dǎng"]],
    "底座": [["dǐ"], ["zuò"]],
    "抵还": [["dǐ"], ["hái"]],
    "砥石": [["dǐ"], ["shí"]],
    "骶骨": [["dǐ"], ["gǔ"]],
    "骶椎": [["dǐ"], ["zhuī"]],
    "地板": [["dì"], ["bǎn"]],
    "地磅": [["dì"], ["bàng"]],
    "地保": [["dì"], ["bǎo"]],
    "地堡": [["dì"], ["pù"]],
    "地边": [["dì"], ["biān"]],
    "地表": [["dì"], ["biǎo"]],
    "地波": [["dì"], ["bō"]],
    "地步": [["dì"], ["bù"]],
    "地产": [["dì"], ["chǎn"]],
    "地秤": [["dì"], ["chèng"]],
    "地层": [["dì"], ["céng"]],
    "地处": [["dì"], ["chǔ"]],
    "地磁": [["dì"], ["cí"]],
    "地点": [["dì"], ["diǎn"]],
    "地带": [["dì"], ["dài"]],
    "地道": [["dì"], ["dào"]],
    "地电": [["dì"], ["diàn"]],
    "地丁": [["dì"], ["dīng"]],
    "地动": [["dì"], ["dòng"]],
    "地洞": [["dì"], ["dòng"]],
    "地段": [["dì"], ["duàn"]],
    "地方": [["dì"], ["fāng"]],
    "地府": [["dì"], ["fǔ"]],
    "地宫": [["dì"], ["gōng"]],
    "地沟": [["dì"], ["gōu"]],
    "地核": [["dì"], ["hé"]],
    "地黄": [["dì"], ["huáng"]],
    "地瓜": [["dì"], ["guā"]],
    "地机": [["dì"], ["jī"]],
    "地积": [["dì"], ["jī"]],
    "地极": [["dì"], ["jí"]],
    "地基": [["dì"], ["jī"]],
    "地价": [["dì"], ["jià"]],
    "地角": [["dì"], ["jiǎo"]],
    "地脚": [["dì"], ["jiǎo"]],
    "地窖": [["dì"], ["jiào"]],
    "地精": [["dì"], ["jīng"]],
    "地界": [["dì"], ["jiè"]],
    "地炕": [["dì"], ["kàng"]],
    "地壳": [["dì"], ["qiào"]],
    "地窟": [["dì"], ["kū"]],
    "地块": [["dì"], ["kuài"]],
    "地牢": [["dì"], ["láo"]],
    "地雷": [["dì"], ["léi"]],
    "地垒": [["dì"], ["lěi"]],
    "地梨": [["dì"], ["lí"]],
    "地理": [["dì"], ["lǐ"]],
    "地力": [["dì"], ["lì"]],
    "地利": [["dì"], ["lì"]],
    "地栗": [["dì"], ["lì"]],
    "地邻": [["dì"], ["lín"]],
    "地龙": [["dì"], ["lóng"]],
    "地垄": [["dì"], ["lǒng"]],
    "地漏": [["dì"], ["lòu"]],
    "地貌": [["dì"], ["mào"]],
    "地幔": [["dì"], ["màn"]],
    "地脉": [["dì"], ["mài"]],
    "地面": [["dì"], ["miàn"]],
    "地名": [["dì"], ["míng"]],
    "地盘": [["dì"], ["pán"]],
    "地皮": [["dì"], ["pí"]],
    "地亩": [["dì"], ["mǔ"]],
    "地痞": [["dì"], ["pǐ"]],
    "地平": [["dì"], ["píng"]],
    "地坪": [["dì"], ["píng"]],
    "地气": [["dì"], ["qì"]],
    "地铺": [["dì"], ["pù"]],
    "地契": [["dì"], ["qì"]],
    "地勤": [["dì"], ["qín"]],
    "地球": [["dì"], ["qiú"]],
    "地区": [["dì"], ["qū"]],
    "地权": [["dì"], ["quán"]],
    "地热": [["dì"], ["rè"]],
    "地上": [["dì"], ["shàng"]],
    "地势": [["dì"], ["shì"]],
    "地市": [["dì"], ["shì"]],
    "地税": [["dì"], ["shuì"]],
    "地摊": [["dì"], ["tān"]],
    "地毯": [["dì"], ["tǎn"]],
    "地铁": [["dì"], ["tiě"]],
    "地头": [["dì"], ["tóu"]],
    "地图": [["dì"], ["tú"]],
    "地委": [["dì"], ["wěi"]],
    "地温": [["dì"], ["wēn"]],
    "地位": [["dì"], ["wèi"]],
    "地物": [["dì"], ["wù"]],
    "地峡": [["dì"], ["xiá"]],
    "地下": [["dì"], ["xià"]],
    "地线": [["dì"], ["xiàn"]],
    "地心": [["dì"], ["xīn"]],
    "地形": [["dì"], ["xíng"]],
    "地穴": [["dì"], ["xué"]],
    "地学": [["dì"], ["xué"]],
    "地衣": [["dì"], ["yī"]],
    "地榆": [["dì"], ["yú"]],
    "地狱": [["dì"], ["yù"]],
    "地域": [["dì"], ["yù"]],
    "地毡": [["dì"], ["zhān"]],
    "地政": [["dì"], ["zhèng"]],
    "地震": [["dì"], ["zhèn"]],
    "地支": [["dì"], ["zhī"]],
    "地志": [["dì"], ["zhì"]],
    "地址": [["dì"], ["zhǐ"]],
    "地质": [["dì"], ["zhì"]],
    "地轴": [["dì"], ["zhóu"]],
    "地租": [["dì"], ["zū"]],
    "地主": [["dì"], ["zhǔ"]],
    "地砖": [["dì"], ["zhuān"]],
    "弟弟": [["dì"], ["di"]],
    "弟妇": [["dì"], ["fù"]],
    "弟妹": [["dì"], ["mèi"]],
    "弟媳": [["dì"], ["xí"]],
    "弟兄": [["dì"], ["xiōng"]],
    "弟子": [["dì"], ["zǐ"]],
    "帝号": [["dì"], ["hào"]],
    "帝都": [["dì"], ["dū"]],
    "帝王": [["dì"], ["wáng"]],
    "递降": [["dì"], ["jiàng"]],
    "递解": [["dì"], ["jiè"]],
    "棣棠": [["dì"], ["táng"]],
    "缔合": [["dì"], ["hé"]],
    "缔结": [["dì"], ["jié"]],
    "缔约": [["dì"], ["yuē"]],
    "颠簸": [["diān"], ["bǒ"]],
    "颠倒": [["diān"], ["dǎo"]],
    "典当": [["diǎn"], ["dàng"]],
    "点发": [["diǎn"], ["fā"]],
    "点化": [["diǎn"], ["huà"]],
    "点号": [["diǎn"], ["hào"]],
    "点将": [["diǎn"], ["jiàng"]],
    "点数": [["diǎn"], ["shù"]],
    "点射": [["diǎn"], ["shè"]],
    "点头": [["diǎn"], ["tóu"]],
    "点种": [["diǎn"], ["zhòng"]],
    "点着": [["diǎn"], ["zháo"]],
    "碘酊": [["diǎn"], ["dǐng"]],
    "电厂": [["diàn"], ["chǎng"]],
    "电场": [["diàn"], ["chǎng"]],
    "电车": [["diàn"], ["chē"]],
    "电大": [["diàn"], ["dà"]],
    "电传": [["diàn"], ["chuán"]],
    "电杆": [["diàn"], ["gān"]],
    "电价": [["diàn"], ["jià"]],
    "电教": [["diàn"], ["jiào"]],
    "电解": [["diàn"], ["jiě"]],
    "电量": [["diàn"], ["liàng"]],
    "电能": [["diàn"], ["néng"]],
    "电扇": [["diàn"], ["shàn"]],
    "电石": [["diàn"], ["shí"]],
    "电台": [["diàn"], ["tái"]],
    "电信": [["diàn"], ["xìn"]],
    "电压": [["diàn"], ["yā"]],
    "电椅": [["diàn"], ["yǐ"]],
    "电晕": [["diàn"], ["yūn"]],
    "佃户": [["diàn"], ["hù"]],
    "电钻": [["diàn"], ["zuàn"]],
    "佃客": [["diàn"], ["kè"]],
    "佃农": [["diàn"], ["nóng"]],
    "佃租": [["diàn"], ["zū"]],
    "甸子": [["diàn"], ["zǐ"]],
    "店家": [["diàn"], ["jiā"]],
    "店铺": [["diàn"], ["pù"]],
    "店员": [["diàn"], ["yuán"]],
    "垫背": [["diàn"], ["bèi"]],
    "垫被": [["diàn"], ["bèi"]],
    "垫片": [["diàn"], ["piàn"]],
    "奠都": [["diàn"], ["dū"]],
    "垫圈": [["diàn"], ["juàn"]],
    "刁横": [["diāo"], ["hèng"]],
    "刁难": [["diāo"], ["nàn"]],
    "刁钻": [["diāo"], ["zuān"]],
    "凋落": [["diāo"], ["luò"]],
    "碉堡": [["diāo"], ["bǎo"]],
    "雕砌": [["diāo"], ["qì"]],
    "雕琢": [["diāo"], ["zhuó"]],
    "吊车": [["diào"], ["chē"]],
    "吊打": [["diào"], ["dǎ"]],
    "吊杆": [["diào"], ["gān"]],
    "吊祭": [["diào"], ["jì"]],
    "吊卷": [["diào"], ["juàn"]],
    "吊铺": [["diào"], ["pù"]],
    "吊丧": [["diào"], ["sāng"]],
    "吊扇": [["diào"], ["shàn"]],
    "调包": [["diào"], ["bāo"]],
    "调拨": [["tiáo"], ["bō"]],
    "调查": [["diào"], ["chá"]],
    "调处": [["tiáo"], ["chǔ"]],
    "调档": [["tiáo"], ["dàng"]],
    "调调": [["tiáo"], ["diào"]],
    "调动": [["diào"], ["dòng"]],
    "调度": [["diào"], ["dù"]],
    "调防": [["diào"], ["fáng"]],
    "调幅": [["tiáo"], ["fú"]],
    "调干": [["diào"], ["gàn"]],
    "调羹": [["tiáo"], ["gēng"]],
    "调光": [["tiáo"], ["guāng"]],
    "调函": [["diào"], ["hán"]],
    "调号": [["diào"], ["hào"]],
    "调合": [["tiáo"], ["hé"]],
    "调和": [["tiáo"], ["hé"]],
    "调护": [["tiáo"], ["hù"]],
    "调回": [["diào"], ["huí"]],
    "调换": [["diào"], ["huàn"]],
    "调级": [["tiáo"], ["jí"]],
    "调集": [["diào"], ["jí"]],
    "调剂": [["tiáo"], ["jì"]],
    "调焦": [["tiáo"], ["jiāo"]],
    "调价": [["tiáo"], ["jià"]],
    "调教": [["tiáo"], ["jiào"]],
    "调节": [["tiáo"], ["jié"]],
    "调解": [["tiáo"], ["jiě"]],
    "调经": [["diào"], ["jīng"]],
    "调卷": [["diào"], ["juàn"]],
    "调控": [["tiáo"], ["kòng"]],
    "调侃": [["tiáo"], ["kǎn"]],
    "调离": [["diào"], ["lí"]],
    "调理": [["tiáo"], ["lǐ"]],
    "调料": [["tiáo"], ["liào"]],
    "调令": [["diào"], ["lìng"]],
    "调弄": [["tiáo"], ["nòng"]],
    "调门": [["diào"], ["mén"]],
    "调派": [["diào"], ["pài"]],
    "调配": [["diào"], ["pèi"]],
    "调皮": [["tiáo"], ["pí"]],
    "调频": [["tiáo"], ["pín"]],
    "调遣": [["diào"], ["qiǎn"]],
    "调情": [["tiáo"], ["qíng"]],
    "调取": [["diào"], ["qǔ"]],
    "调人": [["diào"], ["rén"]],
    "调任": [["diào"], ["rèn"]],
    "调色": [["tiáo"], ["sè"]],
    "调摄": [["tiáo"], ["shè"]],
    "调式": [["diào"], ["shì"]],
    "调试": [["tiáo"], ["shì"]],
    "调适": [["tiáo"], ["shì"]],
    "调唆": [["tiáo"], ["suō"]],
    "调停": [["tiáo"], ["tíng"]],
    "调头": [["diào"], ["tóu"]],
    "调味": [["tiáo"], ["wèi"]],
    "调温": [["diào"], ["wēn"]],
    "调息": [["tiáo"], ["xī"]],
    "调戏": [["tiáo"], ["xì"]],
    "调笑": [["tiáo"], ["xiào"]],
    "调协": [["tiáo"], ["xié"]],
    "调谐": [["tiáo"], ["xié"]],
    "调谑": [["tiáo"], ["xuè"]],
    "调研": [["diào"], ["yán"]],
    "调演": [["diào"], ["yǎn"]],
    "调音": [["tiáo"], ["yīn"]],
    "调养": [["tiáo"], ["yǎng"]],
    "调用": [["diào"], ["yòng"]],
    "调阅": [["diào"], ["yuè"]],
    "调匀": [["tiáo"], ["yún"]],
    "调整": [["tiáo"], ["zhěng"]],
    "调运": [["diào"], ["yùn"]],
    "调正": [["diào"], ["zhèng"]],
    "调值": [["diào"], ["zhí"]],
    "调职": [["diào"], ["zhí"]],
    "调制": [["tiáo"], ["zhì"]],
    "调治": [["tiáo"], ["zhì"]],
    "调转": [["diào"], ["zhuǎn"]],
    "调准": [["tiáo"], ["zhǔn"]],
    "调资": [["tiáo"], ["zī"]],
    "调子": [["diào"], ["zi"]],
    "掉价": [["diào"], ["jià"]],
    "掉头": [["diào"], ["tóu"]],
    "掉转": [["diào"], ["zhuǎn"]],
    "跌倒": [["diē"], ["dǎo"]],
    "跌价": [["diē"], ["jià"]],
    "喋喋": [["dié"], ["dié"]],
    "跌落": [["diē"], ["luò"]],
    "喋血": [["dié"], ["xuè"]],
    "蝶骨": [["dié"], ["gǔ"]],
    "丁坝": [["dīng"], ["bà"]],
    "丁丑": [["dīng"], ["chǒu"]],
    "丁当": [["dīng"], ["dāng"]],
    "丁丁": [["dīng"], ["dīng"]],
    "丁东": [["dīng"], ["dōng"]],
    "丁亥": [["dīng"], ["hài"]],
    "丁冬": [["dīng"], ["dōng"]],
    "丁艰": [["dīng"], ["jiān"]],
    "丁零": [["dīng"], ["líng"]],
    "丁卯": [["dīng"], ["mǎo"]],
    "丁宁": [["dīng"], ["níng"]],
    "丁未": [["dīng"], ["wèi"]],
    "丁香": [["dīng"], ["xiāng"]],
    "丁忧": [["dīng"], ["yōu"]],
    "丁字": [["dīng"], ["zì"]],
    "叮当": [["dīng"], ["dāng"]],
    "疔毒": [["dīng"], ["dú"]],
    "盯梢": [["dīng"], ["shāo"]],
    "钉锤": [["dīng"], ["chuí"]],
    "钉牢": [["dīng"], ["láo"]],
    "钉螺": [["dīng"], ["luó"]],
    "钉耙": [["dīng"], ["pá"]],
    "钉帽": [["dīng"], ["mào"]],
    "钉头": [["dīng"], ["tóu"]],
    "钉鞋": [["dīng"], ["xié"]],
    "钉子": [["dīng"], ["zi"]],
    "酊剂": [["dīng"], ["jì"]],
    "顶风": [["dǐng"], ["fēng"]],
    "顶盖": [["dǐng"], ["gài"]],
    "顶骨": [["dǐng"], ["gǔ"]],
    "顶角": [["dǐng"], ["jiǎo"]],
    "顶上": [["dǐng"], ["shàng"]],
    "顶数": [["dǐng"], ["shù"]],
    "顶头": [["dǐng"], ["tóu"]],
    "鼎盛": [["dǐng"], ["shèng"]],
    "鼎峙": [["dǐng"], ["zhì"]],
    "订单": [["dìng"], ["dān"]],
    "订约": [["dìng"], ["yuē"]],
    "订正": [["dìng"], ["zhèng"]],
    "定单": [["dìng"], ["dān"]],
    "定当": [["dìng"], ["dàng"]],
    "定调": [["dìng"], ["diào"]],
    "定价": [["dìng"], ["jià"]],
    "定都": [["dìng"], ["dū"]],
    "定见": [["dìng"], ["jiàn"]],
    "定量": [["dìng"], ["liàng"]],
    "定论": [["dìng"], ["lùn"]],
    "定期": [["dìng"], ["qī"]],
    "定亲": [["dìng"], ["qīn"]],
    "定数": [["dìng"], ["shù"]],
    "定说": [["dìng"], ["shuō"]],
    "定语": [["dìng"], ["yǔ"]],
    "定员": [["dìng"], ["yuán"]],
    "碇泊": [["dìng"], ["bó"]],
    "定远": [["dìng"], ["yuǎn"]],
    "东阿": [["dōng"], ["ē"]],
    "东北": [["dōng"], ["běi"]],
    "东风": [["dōng"], ["fēng"]],
    "东华": [["dōng"], ["huá"]],
    "东家": [["dōng"], ["jiā"]],
    "东南": [["dōng"], ["nán"]],
    "东台": [["dōng"], ["tái"]],
    "东区": [["dōng"], ["qū"]],
    "东头": [["dōng"], ["tóu"]],
    "冬藏": [["dōng"], ["cáng"]],
    "冬节": [["dōng"], ["jié"]],
    "冬令": [["dōng"], ["lìng"]],
    "懂得": [["dǒng"], ["de"]],
    "懂行": [["dǒng"], ["háng"]],
    "动弹": [["dòng"], ["dàn"]],
    "动觉": [["dòng"], ["jué"]],
    "动量": [["dòng"], ["liàng"]],
    "动能": [["dòng"], ["néng"]],
    "动脉": [["dòng"], ["mài"]],
    "动员": [["dòng"], ["yuán"]],
    "冻裂": [["dòng"], ["liè"]],
    "冻结": [["dòng"], ["jié"]],
    "冻雨": [["dòng"], ["yǔ"]],
    "侗族": [["dòng"], ["zú"]],
    "恫吓": [["dòng"], ["hè"]],
    "洞见": [["dòng"], ["jiàn"]],
    "胴体": [["dòng"], ["tǐ"]],
    "都督": [["dū"], ["du"]],
    "都城": [["dū"], ["chéng"]],
    "都会": [["dōu"], ["huì"]],
    "都市": [["dū"], ["shì"]],
    "都统": [["dū"], ["tǒng"]],
    "都尉": [["dū"], ["wèi"]],
    "兜肚": [["dōu"], ["dù"]],
    "兜风": [["dōu"], ["fēng"]],
    "斗车": [["dǒu"], ["chē"]],
    "斗法": [["dòu"], ["fǎ"]],
    "斗胆": [["dǒu"], ["dǎn"]],
    "斗方": [["dǒu"], ["fāng"]],
    "斗富": [["dòu"], ["fù"]],
    "斗拱": [["dǒu"], ["gǒng"]],
    "斗鸡": [["dòu"], ["jī"]],
    "斗箕": [["dòu"], ["ji"]],
    "斗笠": [["dǒu"], ["lì"]],
    "斗门": [["dǒu"], ["mén"]],
    "斗牛": [["dòu"], ["niú"]],
    "斗殴": [["dòu"], ["ōu"]],
    "斗牌": [["dòu"], ["pái"]],
    "斗篷": [["dǒu"], ["péng"]],
    "斗气": [["dòu"], ["qì"]],
    "斗渠": [["dǒu"], ["qú"]],
    "斗士": [["dòu"], ["shì"]],
    "斗室": [["dǒu"], ["shì"]],
    "斗眼": [["dòu"], ["yǎn"]],
    "斗勇": [["dòu"], ["yǒng"]],
    "斗艳": [["dòu"], ["yàn"]],
    "斗争": [["dòu"], ["zhēng"]],
    "斗志": [["dòu"], ["zhì"]],
    "斗智": [["dòu"], ["zhì"]],
    "斗子": [["dǒu"], ["zi"]],
    "斗嘴": [["dòu"], ["zuǐ"]],
    "抖颤": [["dǒu"], ["chàn"]],
    "抖搂": [["dǒu"], ["lōu"]],
    "抖落": [["dǒu"], ["luò"]],
    "陡度": [["dǒu"], ["dù"]],
    "抖擞": [["dǒu"], ["sǒu"]],
    "豆浆": [["dòu"], ["jiāng"]],
    "豆角": [["dòu"], ["jiǎo"]],
    "豆绿": [["dòu"], ["lǜ"]],
    "逗哏": [["dòu"], ["gén"]],
    "豆沙": [["dòu"], ["shā"]],
    "逗号": [["dòu"], ["hào"]],
    "逗乐": [["dòu"], ["lè"]],
    "逗弄": [["dòu"], ["nòng"]],
    "逗趣": [["dòu"], ["qù"]],
    "督率": [["dū"], ["shuài"]],
    "督脉": [["dū"], ["mài"]],
    "毒草": [["dú"], ["cǎo"]],
    "毒虫": [["dú"], ["chóng"]],
    "毒刺": [["dú"], ["cì"]],
    "毒打": [["dú"], ["dǎ"]],
    "毒蛾": [["dú"], ["é"]],
    "毒饵": [["dú"], ["ěr"]],
    "毒害": [["dú"], ["hài"]],
    "毒化": [["dú"], ["huà"]],
    "毒计": [["dú"], ["jì"]],
    "毒剂": [["dú"], ["jì"]],
    "毒箭": [["dú"], ["jiàn"]],
    "毒酒": [["dú"], ["jiǔ"]],
    "毒菌": [["dú"], ["jūn"]],
    "毒辣": [["dú"], ["là"]],
    "毒龙": [["dú"], ["lóng"]],
    "毒瘤": [["dú"], ["liú"]],
    "毒谋": [["dú"], ["móu"]],
    "毒品": [["dú"], ["pǐn"]],
    "毒气": [["dú"], ["qì"]],
    "毒杀": [["dú"], ["shā"]],
    "毒手": [["dú"], ["shǒu"]],
    "毒蛇": [["dú"], ["shé"]],
    "毒死": [["dú"], ["sǐ"]],
    "毒素": [["dú"], ["sù"]],
    "毒物": [["dú"], ["wù"]],
    "毒雾": [["dú"], ["wù"]],
    "毒腺": [["dú"], ["xiàn"]],
    "毒刑": [["dú"], ["xíng"]],
    "毒性": [["dú"], ["xìng"]],
    "毒蕈": [["dú"], ["xùn"]],
    "毒焰": [["dú"], ["yàn"]],
    "毒牙": [["dú"], ["yá"]],
    "毒药": [["dú"], ["yào"]],
    "毒液": [["dú"], ["yè"]],
    "毒瘾": [["dú"], ["yǐn"]],
    "毒汁": [["dú"], ["zhī"]],
    "读本": [["dú"], ["běn"]],
    "读经": [["dú"], ["jīng"]],
    "读法": [["dú"], ["fǎ"]],
    "读秒": [["dú"], ["miǎo"]],
    "读破": [["dú"], ["pò"]],
    "读若": [["dú"], ["ruò"]],
    "读书": [["dú"], ["shū"]],
    "读数": [["dú"], ["shù"]],
    "读物": [["dú"], ["wù"]],
    "读音": [["dú"], ["yīn"]],
    "读者": [["dú"], ["zhě"]],
    "渎职": [["dú"], ["zhí"]],
    "独处": [["dú"], ["chǔ"]],
    "独夫": [["dú"], ["fū"]],
    "独个": [["dú"], ["gè"]],
    "独创": [["dú"], ["chuàng"]],
    "独角": [["dú"], ["jiǎo"]],
    "独家": [["dú"], ["jiā"]],
    "独女": [["dú"], ["nǚ"]],
    "独体": [["dú"], ["tǐ"]],
    "独行": [["dú"], ["xíng"]],
    "独有": [["dú"], ["yǒu"]],
    "独占": [["dú"], ["zhàn"]],
    "笃行": [["dǔ"], ["xíng"]],
    "笃信": [["dǔ"], ["xìn"]],
    "堵车": [["dǔ"], ["chē"]],
    "赌场": [["dǔ"], ["chǎng"]],
    "堵塞": [["dǔ"], ["sè"]],
    "赌风": [["dǔ"], ["fēng"]],
    "赌棍": [["dǔ"], ["gùn"]],
    "肚带": [["dù"], ["dài"]],
    "肚肠": [["dù"], ["cháng"]],
    "肚量": [["dù"], ["liàng"]],
    "肚兜": [["dù"], ["dōu"]],
    "肚皮": [["dù"], ["pí"]],
    "肚脐": [["dù"], ["qí"]],
    "肚子": [["dǔ"], ["zi"]],
    "度牒": [["dù"], ["dié"]],
    "度过": [["dù"], ["guò"]],
    "度荒": [["dù"], ["huāng"]],
    "度量": [["dù"], ["liàng"]],
    "度假": [["dù"], ["jià"]],
    "度命": [["dù"], ["mìng"]],
    "度曲": [["dù"], ["qǔ"]],
    "度日": [["dù"], ["rì"]],
    "度数": [["dù"], ["shù"]],
    "度外": [["dù"], ["wài"]],
    "渡头": [["dù"], ["tóu"]],
    "端节": [["duān"], ["jié"]],
    "端丽": [["duān"], ["lì"]],
    "端量": [["duān"], ["liáng"]],
    "端相": [["duān"], ["xiāng"]],
    "端正": [["duān"], ["zhèng"]],
    "端详": [["duān"], ["xiáng"]],
    "端重": [["duān"], ["zhòng"]],
    "短长": [["duǎn"], ["cháng"]],
    "短处": [["duǎn"], ["chù"]],
    "短传": [["duǎn"], ["chuán"]],
    "短发": [["duǎn"], ["fā"]],
    "短打": [["duǎn"], ["dǎ"]],
    "短骨": [["duǎn"], ["gǔ"]],
    "短号": [["duǎn"], ["hào"]],
    "短见": [["duǎn"], ["jiàn"]],
    "短句": [["duǎn"], ["jù"]],
    "短跑": [["duǎn"], ["pǎo"]],
    "短片": [["duǎn"], ["piàn"]],
    "短期": [["duǎn"], ["qī"]],
    "短浅": [["duǎn"], ["qiǎn"]],
    "短少": [["duǎn"], ["shǎo"]],
    "短语": [["duǎn"], ["yǔ"]],
    "段落": [["duàn"], ["luò"]],
    "断臂": [["duàn"], ["bì"]],
    "断句": [["duàn"], ["jù"]],
    "断片": [["duàn"], ["piàn"]],
    "断语": [["duàn"], ["yǔ"]],
    "断种": [["duàn"], ["zhǒng"]],
    "锻打": [["duàn"], ["dǎ"]],
    "锻模": [["duàn"], ["mú"]],
    "锻压": [["duàn"], ["yā"]],
    "队长": [["duì"], ["zhǎng"]],
    "队副": [["duì"], ["fù"]],
    "队员": [["duì"], ["yuán"]],
    "对簿": [["duì"], ["bù"]],
    "对称": [["duì"], ["chèn"]],
    "对答": [["duì"], ["dá"]],
    "对打": [["duì"], ["dǎ"]],
    "对待": [["duì"], ["dài"]],
    "对调": [["duì"], ["diào"]],
    "对号": [["duì"], ["hào"]],
    "对过": [["duì"], ["guò"]],
    "对家": [["duì"], ["jiā"]],
    "对角": [["duì"], ["jiǎo"]],
    "对劲": [["duì"], ["jìn"]],
    "对内": [["duì"], ["nèi"]],
    "对齐": [["duì"], ["qí"]],
    "对头": [["duì"], ["tóu"]],
    "对数": [["duì"], ["shù"]],
    "对应": [["duì"], ["yìng"]],
    "对折": [["duì"], ["zhé"]],
    "对症": [["duì"], ["zhèng"]],
    "对峙": [["duì"], ["zhì"]],
    "兑付": [["duì"], ["fù"]],
    "兑换": [["duì"], ["huàn"]],
    "兑奖": [["duì"], ["jiǎng"]],
    "兑款": [["duì"], ["kuǎn"]],
    "兑现": [["duì"], ["xiàn"]],
    "敦促": [["dūn"], ["cù"]],
    "敦厚": [["dūn"], ["hòu"]],
    "敦化": [["dūn"], ["huà"]],
    "敦煌": [["dūn"], ["huáng"]],
    "敦聘": [["dūn"], ["pìn"]],
    "敦睦": [["dūn"], ["mù"]],
    "敦朴": [["dūn"], ["piáo"]],
    "敦请": [["dūn"], ["qǐng"]],
    "敦劝": [["dūn"], ["quàn"]],
    "敦实": [["dūn"], ["shí"]],
    "囤积": [["tún"], ["jī"]],
    "囤聚": [["tún"], ["jù"]],
    "钝化": [["dùn"], ["huà"]],
    "顿号": [["dùn"], ["hào"]],
    "钝角": [["dùn"], ["jiǎo"]],
    "顿觉": [["dùn"], ["jué"]],
    "多大": [["duō"], ["dà"]],
    "多发": [["duō"], ["fā"]],
    "多么": [["duō"], ["me"]],
    "多少": [["duō"], ["shǎo"]],
    "多能": [["duō"], ["néng"]],
    "多数": [["duō"], ["shù"]],
    "多头": [["duō"], ["tóu"]],
    "多疑": [["duō"], ["yí"]],
    "多咱": [["duō"], ["zá"]],
    "夺得": [["duó"], ["de"]],
    "夺冠": [["duó"], ["guàn"]],
    "掇拾": [["duō"], ["shí"]],
    "垛口": [["duǒ"], ["kǒu"]],
    "垛子": [["duǒ"], ["zi"]],
    "躲藏": [["duǒ"], ["cáng"]],
    "躲风": [["duǒ"], ["fēng"]],
    "堕地": [["duò"], ["dì"]],
    "堕马": [["duò"], ["mǎ"]],
    "堕胎": [["duò"], ["tāi"]],
    "屙尿": [["ē"], ["niào"]],
    "讹传": [["é"], ["chuán"]],
    "俄语": [["é"], ["yǔ"]],
    "蛾眉": [["é"], ["méi"]],
    "蛾子": [["é"], ["zi"]],
    "额度": [["é"], ["dù"]],
    "额枋": [["é"], ["fāng"]],
    "额骨": [["é"], ["gǔ"]],
    "额数": [["é"], ["shù"]],
    "额角": [["é"], ["jiǎo"]],
    "额头": [["é"], ["tóu"]],
    "婀娜": [["ē"], ["nuó"]],
    "厄难": [["è"], ["nàn"]],
    "扼要": [["è"], ["yào"]],
    "恶霸": [["è"], ["bà"]],
    "恶报": [["è"], ["bào"]],
    "恶变": [["è"], ["biàn"]],
    "恶补": [["è"], ["bǔ"]],
    "恶臭": [["è"], ["chòu"]],
    "恶斗": [["è"], ["dòu"]],
    "恶妇": [["è"], ["fù"]],
    "恶毒": [["è"], ["dú"]],
    "恶感": [["è"], ["gǎn"]],
    "恶狗": [["è"], ["gǒu"]],
    "恶鬼": [["è"], ["guǐ"]],
    "恶棍": [["è"], ["gùn"]],
    "恶果": [["è"], ["guǒ"]],
    "恶狠": [["è"], ["hěn"]],
    "恶迹": [["è"], ["jì"]],
    "恶化": [["è"], ["huà"]],
    "恶疾": [["è"], ["jí"]],
    "恶浪": [["è"], ["làng"]],
    "恶劣": [["è"], ["liè"]],
    "恶露": [["è"], ["lù"]],
    "恶骂": [["è"], ["mà"]],
    "恶梦": [["è"], ["mèng"]],
    "恶名": [["è"], ["míng"]],
    "恶魔": [["è"], ["mó"]],
    "恶念": [["è"], ["niàn"]],
    "恶癖": [["è"], ["pǐ"]],
    "恶煞": [["è"], ["shà"]],
    "恶气": [["è"], ["qì"]],
    "恶人": [["è"], ["rén"]],
    "恶少": [["è"], ["shào"]],
    "恶声": [["è"], ["shēng"]],
    "恶事": [["è"], ["shì"]],
    "恶俗": [["è"], ["sú"]],
    "恶徒": [["è"], ["tú"]],
    "恶习": [["è"], ["xí"]],
    "恶相": [["è"], ["xiàng"]],
    "恶心": [["ě"], ["xīn"]],
    "恶行": [["è"], ["xíng"]],
    "恶性": [["è"], ["xìng"]],
    "恶意": [["è"], ["yì"]],
    "恶语": [["è"], ["yǔ"]],
    "恶言": [["è"], ["yán"]],
    "恶运": [["è"], ["yùn"]],
    "恶战": [["è"], ["zhàn"]],
    "恶仗": [["è"], ["zhàng"]],
    "恶兆": [["è"], ["zhào"]],
    "恶浊": [["è"], ["zhuó"]],
    "萼片": [["è"], ["piàn"]],
    "腭裂": [["è"], ["liè"]],
    "颚骨": [["è"], ["gǔ"]],
    "恩仇": [["ēn"], ["chóu"]],
    "恩泽": [["ēn"], ["zé"]],
    "儿化": [["ér"], ["huà"]],
    "儿郎": [["ér"], ["láng"]],
    "儿女": [["ér"], ["nǚ"]],
    "儿孙": [["ér"], ["sūn"]],
    "儿戏": [["ér"], ["xì"]],
    "耳背": [["ěr"], ["bèi"]],
    "而且": [["ér"], ["qiě"]],
    "耳塞": [["ěr"], ["sāi"]],
    "耳石": [["ěr"], ["shí"]],
    "耳语": [["ěr"], ["yǔ"]],
    "耳食": [["ěr"], ["shí"]],
    "二分": [["èr"], ["fēn"]],
    "二副": [["èr"], ["fù"]],
    "二价": [["èr"], ["jià"]],
    "发案": [["fā"], ["àn"]],
    "二重": [["èr"], ["chóng"]],
    "发白": [["fā"], ["bái"]],
    "发榜": [["fā"], ["bǎng"]],
    "发包": [["fā"], ["bāo"]],
    "发报": [["fā"], ["bào"]],
    "发辫": [["fà"], ["biàn"]],
    "发标": [["fā"], ["biāo"]],
    "发表": [["fā"], ["biǎo"]],
    "发鬓": [["fà"], ["bìn"]],
    "发兵": [["fā"], ["bīng"]],
    "发布": [["fā"], ["bù"]],
    "发病": [["fā"], ["bìng"]],
    "发财": [["fā"], ["cái"]],
    "发菜": [["fà"], ["cài"]],
    "发颤": [["fā"], ["chàn"]],
    "发车": [["fā"], ["chē"]],
    "发痴": [["fā"], ["chī"]],
    "发愁": [["fā"], ["chóu"]],
    "发出": [["fā"], ["chū"]],
    "发怵": [["fā"], ["chù"]],
    "发憷": [["fā"], ["chù"]],
    "发喘": [["fā"], ["chuǎn"]],
    "发达": [["fā"], ["dá"]],
    "发呆": [["fā"], ["dāi"]],
    "发单": [["fā"], ["dān"]],
    "发嗲": [["fā"], ["diǎ"]],
    "发点": [["fā"], ["diǎn"]],
    "发电": [["fā"], ["diàn"]],
    "发动": [["fā"], ["dòng"]],
    "发端": [["fā"], ["duān"]],
    "发抖": [["fā"], ["dǒu"]],
    "发发": [["fā"], ["fā"]],
    "发凡": [["fā"], ["fán"]],
    "发放": [["fā"], ["fàng"]],
    "发粉": [["fā"], ["fěn"]],
    "发愤": [["fā"], ["fèn"]],
    "发奋": [["fā"], ["fèn"]],
    "发疯": [["fā"], ["fēng"]],
    "发付": [["fā"], ["fù"]],
    "发福": [["fā"], ["fú"]],
    "发糕": [["fā"], ["gāo"]],
    "发稿": [["fā"], ["gǎo"]],
    "发给": [["fā"], ["gěi"]],
    "发根": [["fā"], ["gēn"]],
    "发光": [["fā"], ["guāng"]],
    "发函": [["fā"], ["hán"]],
    "发汗": [["fā"], ["hàn"]],
    "发狠": [["fā"], ["hěn"]],
    "发横": [["fā"], ["héng"]],
    "发红": [["fā"], ["hóng"]],
    "发话": [["fā"], ["huà"]],
    "发花": [["fā"], ["huā"]],
    "发坏": [["fā"], ["huài"]],
    "发还": [["fā"], ["huán"]],
    "发慌": [["fā"], ["huāng"]],
    "发挥": [["fā"], ["huī"]],
    "发昏": [["fā"], ["hūn"]],
    "发火": [["fā"], ["huǒ"]],
    "发货": [["fā"], ["huò"]],
    "发迹": [["fā"], ["jì"]],
    "发急": [["fā"], ["jí"]],
    "发髻": [["fà"], ["jì"]],
    "发际": [["fà"], ["jì"]],
    "发夹": [["fā"], ["jiā"]],
    "发家": [["fā"], ["jiā"]],
    "发胶": [["fā"], ["jiāo"]],
    "发奖": [["fā"], ["jiǎng"]],
    "发酵": [["fā"], ["jiào"]],
    "发窘": [["fā"], ["jiǒng"]],
    "发觉": [["fā"], ["jué"]],
    "发掘": [["fā"], ["jué"]],
    "发卡": [["fà"], ["qiǎ"]],
    "发刊": [["fā"], ["kān"]],
    "发狂": [["fā"], ["kuáng"]],
    "发困": [["fā"], ["kùn"]],
    "发蜡": [["fā"], ["là"]],
    "发懒": [["fā"], ["lǎn"]],
    "发廊": [["fà"], ["láng"]],
    "发楞": [["fā"], ["léng"]],
    "发愣": [["fā"], ["lèng"]],
    "发冷": [["fā"], ["lěng"]],
    "发亮": [["fā"], ["liàng"]],
    "发令": [["fā"], ["lìng"]],
    "发露": [["fā"], ["lù"]],
    "发落": [["fā"], ["luò"]],
    "发麻": [["fā"], ["má"]],
    "发毛": [["fā"], ["máo"]],
    "发霉": [["fā"], ["méi"]],
    "发闷": [["fā"], ["mèn"]],
    "发蒙": [["fā"], ["mēng"]],
    "发懵": [["fā"], ["měng"]],
    "发面": [["fā"], ["miàn"]],
    "发明": [["fā"], ["míng"]],
    "发木": [["fā"], ["mù"]],
    "发难": [["fā"], ["nàn"]],
    "发怒": [["fā"], ["nù"]],
    "发牌": [["fā"], ["pái"]],
    "发排": [["fā"], ["pái"]],
    "发胖": [["fā"], ["pàng"]],
    "发配": [["fā"], ["pèi"]],
    "发飘": [["fā"], ["piāo"]],
    "发票": [["fā"], ["piào"]],
    "发妻": [["fà"], ["qī"]],
    "发起": [["fā"], ["qǐ"]],
    "发青": [["fā"], ["qīng"]],
    "发情": [["fā"], ["qíng"]],
    "发气": [["fā"], ["qì"]],
    "发球": [["fā"], ["qiú"]],
    "发热": [["fā"], ["rè"]],
    "发软": [["fā"], ["ruǎn"]],
    "发乳": [["fà"], ["rǔ"]],
    "发轫": [["fā"], ["rèn"]],
    "发散": [["fā"], ["sàn"]],
    "发丧": [["fā"], ["sāng"]],
    "发涩": [["fā"], ["sè"]],
    "发傻": [["fā"], ["shǎ"]],
    "发痧": [["fā"], ["shā"]],
    "发烧": [["fā"], ["shāo"]],
    "发射": [["fā"], ["shè"]],
    "发生": [["fā"], ["shēng"]],
    "发声": [["fā"], ["shēng"]],
    "发市": [["fā"], ["shì"]],
    "发誓": [["fā"], ["shì"]],
    "发式": [["fà"], ["shì"]],
    "发售": [["fā"], ["shòu"]],
    "发水": [["fā"], ["shuǐ"]],
    "发送": [["fā"], ["sòng"]],
    "发酸": [["fā"], ["suān"]],
    "发烫": [["fā"], ["tàng"]],
    "发网": [["fā"], ["wǎng"]],
    "发条": [["fā"], ["tiáo"]],
    "发威": [["fā"], ["wēi"]],
    "发文": [["fā"], ["wén"]],
    "发屋": [["fà"], ["wū"]],
    "发问": [["fā"], ["wèn"]],
    "发物": [["fā"], ["wù"]],
    "发现": [["fā"], ["xiàn"]],
    "发祥": [["fā"], ["xiáng"]],
    "发饷": [["fā"], ["xiǎng"]],
    "发笑": [["fā"], ["xiào"]],
    "发泄": [["fā"], ["xiè"]],
    "发行": [["fā"], ["xíng"]],
    "发薪": [["fā"], ["xīn"]],
    "发信": [["fā"], ["xìn"]],
    "发型": [["fà"], ["xíng"]],
    "发虚": [["fā"], ["xū"]],
    "发蔫": [["fā"], ["niān"]],
    "发芽": [["fā"], ["yá"]],
    "发言": [["fā"], ["yán"]],
    "发炎": [["fā"], ["yán"]],
    "发痒": [["fā"], ["yǎng"]],
    "发扬": [["fā"], ["yáng"]],
    "发音": [["fā"], ["yīn"]],
    "发引": [["fā"], ["yǐn"]],
    "发育": [["fā"], ["yù"]],
    "发源": [["fā"], ["yuán"]],
    "发愿": [["fā"], ["yuàn"]],
    "发运": [["fā"], ["yùn"]],
    "发晕": [["fā"], ["yūn"]],
    "发躁": [["fā"], ["zào"]],
    "发展": [["fā"], ["zhǎn"]],
    "发胀": [["fā"], ["zhàng"]],
    "发怔": [["fā"], ["zhèng"]],
    "发指": [["fà"], ["zhǐ"]],
    "发作": [["fā"], ["zuò"]],
    "法场": [["fǎ"], ["chǎng"]],
    "法度": [["fǎ"], ["dù"]],
    "法号": [["fǎ"], ["hào"]],
    "法纪": [["fǎ"], ["jì"]],
    "法会": [["fǎ"], ["huì"]],
    "法家": [["fǎ"], ["jiā"]],
    "法拉": [["fǎ"], ["lā"]],
    "法郎": [["fǎ"], ["láng"]],
    "法令": [["fǎ"], ["lìng"]],
    "法术": [["fǎ"], ["shù"]],
    "法帖": [["fǎ"], ["tiè"]],
    "法王": [["fǎ"], ["wáng"]],
    "法相": [["fǎ"], ["xiāng"]],
    "法语": [["fǎ"], ["yǔ"]],
    "番瓜": [["fān"], ["guā"]],
    "番邦": [["fān"], ["bāng"]],
    "番菜": [["fān"], ["cài"]],
    "番号": [["fān"], ["hào"]],
    "番椒": [["fān"], ["jiāo"]],
    "番茄": [["fān"], ["qié"]],
    "番薯": [["fān"], ["shǔ"]],
    "番禺": [["pān"], ["yú"]],
    "翻查": [["fān"], ["zhā"]],
    "翻车": [["fān"], ["chē"]],
    "翻倒": [["fān"], ["dǎo"]],
    "翻地": [["fān"], ["dì"]],
    "翻斗": [["fān"], ["dǒu"]],
    "翻番": [["fān"], ["fān"]],
    "翻盖": [["fān"], ["gài"]],
    "翻供": [["fān"], ["gòng"]],
    "翻浆": [["fān"], ["jiāng"]],
    "翻卷": [["fān"], ["juǎn"]],
    "翻弄": [["fān"], ["nòng"]],
    "翻涌": [["fān"], ["yǒng"]],
    "翻转": [["fān"], ["zhuǎn"]],
    "藩属": [["fān"], ["shǔ"]],
    "凡夫": [["fán"], ["fū"]],
    "凡间": [["fán"], ["jiān"]],
    "矾石": [["fán"], ["shí"]],
    "烦渎": [["fán"], ["dú"]],
    "烦闷": [["fán"], ["mèn"]],
    "烦难": [["fán"], ["nán"]],
    "繁博": [["fán"], ["bó"]],
    "樊笼": [["fán"], ["lóng"]],
    "繁复": [["fán"], ["fù"]],
    "繁昌": [["fán"], ["chāng"]],
    "繁多": [["fán"], ["duō"]],
    "繁花": [["fán"], ["huā"]],
    "繁华": [["fán"], ["huá"]],
    "繁简": [["fán"], ["jiǎn"]],
    "繁苛": [["fán"], ["kē"]],
    "繁丽": [["fán"], ["lì"]],
    "繁忙": [["fán"], ["máng"]],
    "繁乱": [["fán"], ["luàn"]],
    "繁茂": [["fán"], ["mào"]],
    "繁密": [["fán"], ["mì"]],
    "繁荣": [["fán"], ["róng"]],
    "繁冗": [["fán"], ["rǒng"]],
    "繁难": [["fán"], ["nán"]],
    "繁缛": [["fán"], ["rù"]],
    "繁盛": [["fán"], ["shèng"]],
    "繁琐": [["fán"], ["suǒ"]],
    "繁体": [["fán"], ["tǐ"]],
    "繁文": [["fán"], ["wén"]],
    "繁芜": [["fán"], ["wú"]],
    "繁星": [["fán"], ["xīng"]],
    "繁衍": [["fán"], ["yǎn"]],
    "繁育": [["fán"], ["yù"]],
    "繁杂": [["fán"], ["zá"]],
    "繁殖": [["fán"], ["zhí"]],
    "繁重": [["fán"], ["zhòng"]],
    "反把": [["fǎn"], ["bǎ"]],
    "反侧": [["fǎn"], ["cè"]],
    "反冲": [["fǎn"], ["chōng"]],
    "反差": [["fǎn"], ["chà"]],
    "反弹": [["fǎn"], ["dàn"]],
    "反倒": [["fǎn"], ["dào"]],
    "反调": [["fǎn"], ["diào"]],
    "反骨": [["fǎn"], ["gǔ"]],
    "反观": [["fǎn"], ["guān"]],
    "反间": [["fǎn"], ["jiàn"]],
    "反诘": [["fǎn"], ["jié"]],
    "反切": [["fǎn"], ["qiè"]],
    "反省": [["fǎn"], ["xǐng"]],
    "反射": [["fǎn"], ["shè"]],
    "反思": [["fǎn"], ["sī"]],
    "反应": [["fǎn"], ["yìng"]],
    "反语": [["fǎn"], ["yǔ"]],
    "反正": [["fǎn"], ["zhèng"]],
    "反转": [["fǎn"], ["zhuǎn"]],
    "返还": [["fǎn"], ["huán"]],
    "犯禁": [["fàn"], ["jìn"]],
    "犯难": [["fàn"], ["nán"]],
    "犯上": [["fàn"], ["shàng"]],
    "犯疑": [["fàn"], ["yí"]],
    "泛称": [["fàn"], ["chēng"]],
    "泛读": [["fàn"], ["dú"]],
    "泛论": [["fàn"], ["lùn"]],
    "饭量": [["fàn"], ["liàng"]],
    "饭囊": [["fàn"], ["náng"]],
    "饭票": [["fàn"], ["piào"]],
    "饭铺": [["fàn"], ["pù"]],
    "饭食": [["fàn"], ["shí"]],
    "贩毒": [["fàn"], ["dú"]],
    "贩夫": [["fàn"], ["fū"]],
    "梵刹": [["fàn"], ["chà"]],
    "方便": [["fāng"], ["biàn"]],
    "方差": [["fāng"], ["chà"]],
    "方尺": [["fāng"], ["chǐ"]],
    "方家": [["fāng"], ["jiā"]],
    "方术": [["fāng"], ["shù"]],
    "方头": [["fāng"], ["tóu"]],
    "坊间": [["fāng"], ["jiān"]],
    "坊本": [["fāng"], ["běn"]],
    "方正": [["fāng"], ["zhèng"]],
    "芳菲": [["fāng"], ["fēi"]],
    "芳华": [["fāng"], ["huá"]],
    "芳泽": [["fāng"], ["zé"]],
    "防暴": [["fáng"], ["bào"]],
    "防弹": [["fáng"], ["dàn"]],
    "防地": [["fáng"], ["dì"]],
    "防毒": [["fáng"], ["dú"]],
    "防风": [["fáng"], ["fēng"]],
    "防空": [["fáng"], ["kōng"]],
    "防区": [["fáng"], ["qū"]],
    "房地": [["fáng"], ["dì"]],
    "房间": [["fáng"], ["jiān"]],
    "房契": [["fáng"], ["qì"]],
    "仿单": [["fǎng"], ["dān"]],
    "仿佛": [["fǎng"], ["fú"]],
    "仿冒": [["fǎng"], ["mào"]],
    "仿行": [["fǎng"], ["xíng"]],
    "访查": [["fǎng"], ["zhā"]],
    "彷佛": [["páng"], ["fó"]],
    "彷徨": [["pánghuáng"]],
    "纺车": [["fǎng"], ["chē"]],
    "放榜": [["fàng"], ["bǎng"]],
    "纺织": [["fǎng"], ["zhī"]],
    "放大": [["fàng"], ["dà"]],
    "放倒": [["fàng"], ["dǎo"]],
    "放风": [["fàng"], ["fēng"]],
    "放毒": [["fàng"], ["dú"]],
    "放过": [["fàng"], ["guò"]],
    "放还": [["fàng"], ["hái"]],
    "放空": [["fàng"], ["kōng"]],
    "放假": [["fàng"], ["jià"]],
    "放量": [["fàng"], ["liàng"]],
    "放排": [["fàng"], ["pái"]],
    "放任": [["fàng"], ["rèn"]],
    "放炮": [["fàng"], ["pào"]],
    "放散": [["fàng"], ["sàn"]],
    "放射": [["fàng"], ["shè"]],
    "放行": [["fàng"], ["xíng"]],
    "放血": [["fàng"], ["xuè"]],
    "放纵": [["fàng"], ["zòng"]],
    "飞奔": [["fēi"], ["bēn"]],
    "飞弹": [["fēi"], ["dàn"]],
    "飞车": [["fēi"], ["chē"]],
    "飞地": [["fēi"], ["dì"]],
    "飞蛾": [["fēi"], ["é"]],
    "飞红": [["fēi"], ["hóng"]],
    "飞溅": [["fēi"], ["jiàn"]],
    "飞跑": [["fēi"], ["pǎo"]],
    "飞瀑": [["fēi"], ["pù"]],
    "飞洒": [["fēi"], ["sǎ"]],
    "飞散": [["fēi"], ["sàn"]],
    "飞石": [["fēi"], ["shí"]],
    "飞行": [["fēi"], ["xíng"]],
    "飞燕": [["fēi"], ["yàn"]],
    "飞旋": [["fēi"], ["xuán"]],
    "飞雨": [["fēi"], ["yǔ"]],
    "飞语": [["fēi"], ["yǔ"]],
    "飞涨": [["fēi"], ["zhǎng"]],
    "飞转": [["fēi"], ["zhuàn"]],
    "妃嫔": [["fēi"], ["pín"]],
    "妃子": [["fēi"], ["zǐ"]],
    "非得": [["fēi"], ["děi"]],
    "非分": [["fēi"], ["fèn"]],
    "非难": [["fēi"], ["nàn"]],
    "菲菲": [["fēi"], ["fēi"]],
    "菲仪": [["fěi"], ["yí"]],
    "菲薄": [["fěi"], ["bó"]],
    "蜚语": [["fēi"], ["yǔ"]],
    "肥差": [["féi"], ["chà"]],
    "肥大": [["féi"], ["dà"]],
    "肥硕": [["féi"], ["shuò"]],
    "腓骨": [["féi"], ["gǔ"]],
    "斐然": [["fěi"], ["rán"]],
    "肺泡": [["fèi"], ["pào"]],
    "费解": [["fèi"], ["jiě"]],
    "肺叶": [["fèi"], ["yè"]],
    "费劲": [["fèi"], ["jìn"]],
    "费难": [["fèi"], ["nán"]],
    "痱子": [["fèi"], ["zǐ"]],
    "分贝": [["fēn"], ["bèi"]],
    "分辨": [["fēn"], ["biàn"]],
    "分辩": [["fēn"], ["biàn"]],
    "分别": [["fēn"], ["bié"]],
    "分兵": [["fēn"], ["bīng"]],
    "分拨": [["fēn"], ["bō"]],
    "分布": [["fēn"], ["bù"]],
    "分部": [["fēn"], ["bù"]],
    "分餐": [["fēn"], ["cān"]],
    "分册": [["fēn"], ["cè"]],
    "分叉": [["fēn"], ["chà"]],
    "分岔": [["fēn"], ["chà"]],
    "分成": [["fēn"], ["chéng"]],
    "分词": [["fēn"], ["cí"]],
    "分爨": [["fēn"], ["cuàn"]],
    "分寸": [["fēn"], ["cùn"]],
    "分担": [["fēn"], ["dān"]],
    "分当": [["fèn"], ["dāng"]],
    "分档": [["fēn"], ["dàng"]],
    "分得": [["fēn"], ["de"]],
    "分道": [["fēn"], ["dào"]],
    "分店": [["fēn"], ["diàn"]],
    "分段": [["fēn"], ["duàn"]],
    "分队": [["fēn"], ["duì"]],
    "分发": [["fēn"], ["fā"]],
    "分房": [["fēn"], ["fáng"]],
    "分飞": [["fēn"], ["fēi"]],
    "分分": [["fēn"], ["fēn"]],
    "分肥": [["fēn"], ["féi"]],
    "分赴": [["fēn"], ["fù"]],
    "分封": [["fēn"], ["fēng"]],
    "分割": [["fēn"], ["gē"]],
    "分隔": [["fēn"], ["gé"]],
    "分给": [["fēn"], ["gěi"]],
    "分工": [["fēn"], ["gōng"]],
    "分管": [["fēn"], ["guǎn"]],
    "分毫": [["fēn"], ["háo"]],
    "分光": [["fēn"], ["guāng"]],
    "分号": [["fēn"], ["hào"]],
    "分合": [["fēn"], ["hé"]],
    "分红": [["fēn"], ["hóng"]],
    "分洪": [["fēn"], ["hóng"]],
    "分会": [["fēn"], ["huì"]],
    "分化": [["fēn"], ["huà"]],
    "分机": [["fēn"], ["jī"]],
    "分级": [["fēn"], ["jí"]],
    "分际": [["fēn"], ["jì"]],
    "分家": [["fēn"], ["jiā"]],
    "分拣": [["fēn"], ["jiǎn"]],
    "分节": [["fēn"], ["jié"]],
    "分解": [["fēn"], ["jiě"]],
    "分界": [["fēn"], ["jiè"]],
    "分居": [["fēn"], ["jū"]],
    "分局": [["fēn"], ["jú"]],
    "分科": [["fēn"], ["kē"]],
    "分开": [["fēn"], ["kāi"]],
    "分类": [["fēn"], ["lèi"]],
    "分厘": [["fēn"], ["lí"]],
    "分离": [["fēn"], ["lí"]],
    "分理": [["fēn"], ["lǐ"]],
    "分立": [["fēn"], ["lì"]],
    "分力": [["fēn"], ["lì"]],
    "分利": [["fēn"], ["lì"]],
    "分量": [["fèn"], ["liàng"]],
    "分流": [["fēn"], ["liú"]],
    "分裂": [["fēn"], ["liè"]],
    "分列": [["fēn"], ["liè"]],
    "分馏": [["fēn"], ["liú"]],
    "分米": [["fēn"], ["mǐ"]],
    "分路": [["fēn"], ["lù"]],
    "分娩": [["fēn"], ["miǎn"]],
    "分泌": [["fēn"], ["mì"]],
    "分秒": [["fēn"], ["miǎo"]],
    "分明": [["fēn"], ["míng"]],
    "分母": [["fēn"], ["mǔ"]],
    "分内": [["fèn"], ["nèi"]],
    "分蘖": [["fēn"], ["niè"]],
    "分派": [["fēn"], ["pài"]],
    "分配": [["fēn"], ["pèi"]],
    "分片": [["fēn"], ["piàn"]],
    "分批": [["fēn"], ["pī"]],
    "分频": [["fēn"], ["pín"]],
    "分期": [["fēn"], ["qī"]],
    "分岐": [["fēn"], ["qí"]],
    "分歧": [["fēn"], ["qí"]],
    "分清": [["fēn"], ["qīng"]],
    "分区": [["fēn"], ["qū"]],
    "分权": [["fēn"], ["quán"]],
    "分润": [["fēn"], ["rùn"]],
    "分散": [["fēn"], ["sǎn"]],
    "分色": [["fēn"], ["sè"]],
    "分设": [["fēn"], ["shè"]],
    "分身": [["fēn"], ["shēn"]],
    "分神": [["fēn"], ["shén"]],
    "分时": [["fēn"], ["shí"]],
    "分式": [["fēn"], ["shì"]],
    "分手": [["fēn"], ["shǒu"]],
    "分数": [["fēn"], ["shù"]],
    "分水": [["fēn"], ["shuǐ"]],
    "分说": [["fēn"], ["shuō"]],
    "分送": [["fēn"], ["sòng"]],
    "分摊": [["fēn"], ["tān"]],
    "分体": [["fēn"], ["tǐ"]],
    "分头": [["fēn"], ["tóu"]],
    "分外": [["fèn"], ["wài"]],
    "分为": [["fēn"], ["wéi"]],
    "分文": [["fēn"], ["wén"]],
    "分析": [["fēn"], ["xī"]],
    "分享": [["fēn"], ["xiǎng"]],
    "分晓": [["fēn"], ["xiǎo"]],
    "分校": [["fēn"], ["xiào"]],
    "分心": [["fēn"], ["xīn"]],
    "分行": [["fēn"], ["háng"]],
    "分野": [["fēn"], ["yě"]],
    "分宜": [["fēn"], ["yí"]],
    "分阴": [["fēn"], ["yīn"]],
    "分忧": [["fēn"], ["yōu"]],
    "分赃": [["fēn"], ["zāng"]],
    "分账": [["fēn"], ["zhàng"]],
    "分针": [["fēn"], ["zhēn"]],
    "分支": [["fēn"], ["zhī"]],
    "分枝": [["fēn"], ["zhī"]],
    "分治": [["fēn"], ["zhì"]],
    "分装": [["fēn"], ["zhuāng"]],
    "分子": [["fèn"], ["zǐ"]],
    "分组": [["fēn"], ["zǔ"]],
    "纷繁": [["fēn"], ["fán"]],
    "坟场": [["fén"], ["chǎng"]],
    "坟地": [["fén"], ["dì"]],
    "坟头": [["fén"], ["tóu"]],
    "焚风": [["fén"], ["fēng"]],
    "焚化": [["fén"], ["huà"]],
    "粉刺": [["fěn"], ["cì"]],
    "粉坊": [["fěn"], ["fáng"]],
    "粉沙": [["fěn"], ["shā"]],
    "粉红": [["fěn"], ["hóng"]],
    "粉刷": [["fěn"], ["shuā"]],
    "粉条": [["fěn"], ["tiáo"]],
    "份地": [["fèn"], ["dì"]],
    "份额": [["fèn"], ["é"]],
    "份儿": [["fèn"], ["ér"]],
    "份量": [["fèn"], ["liàng"]],
    "份子": [["fèn"], ["zi"]],
    "奋臂": [["fèn"], ["bì"]],
    "粪便": [["fèn"], ["biàn"]],
    "奋斗": [["fèn"], ["dòu"]],
    "奋发": [["fèn"], ["fā"]],
    "粪车": [["fèn"], ["chē"]],
    "丰采": [["fēng"], ["cǎi"]],
    "丰盛": [["fēng"], ["shèng"]],
    "丰硕": [["fēng"], ["shuò"]],
    "风暴": [["fēng"], ["bào"]],
    "风标": [["fēng"], ["biāo"]],
    "风波": [["fēng"], ["bō"]],
    "风采": [["fēng"], ["cǎi"]],
    "风铲": [["fēng"], ["chǎn"]],
    "风潮": [["fēng"], ["cháo"]],
    "风车": [["fēng"], ["chē"]],
    "风尘": [["fēng"], ["chén"]],
    "风池": [["fēng"], ["chí"]],
    "风传": [["fēng"], ["chuán"]],
    "风锤": [["fēng"], ["chuí"]],
    "风带": [["fēng"], ["dài"]],
    "风挡": [["fēng"], ["dǎng"]],
    "风灯": [["fēng"], ["dēng"]],
    "风道": [["fēng"], ["dào"]],
    "风笛": [["fēng"], ["dí"]],
    "风动": [["fēng"], ["dòng"]],
    "风洞": [["fēng"], ["dòng"]],
    "风度": [["fēng"], ["dù"]],
    "风斗": [["fēng"], ["dǒu"]],
    "风发": [["fēng"], ["fā"]],
    "风帆": [["fēng"], ["fān"]],
    "风范": [["fēng"], ["fàn"]],
    "风府": [["fēng"], ["fǔ"]],
    "风干": [["fēng"], ["gān"]],
    "风镐": [["fēng"], ["hào"]],
    "风格": [["fēng"], ["gé"]],
    "风骨": [["fēng"], ["gǔ"]],
    "风管": [["fēng"], ["guǎn"]],
    "风光": [["fēng"], ["guāng"]],
    "风害": [["fēng"], ["hài"]],
    "风寒": [["fēng"], ["hán"]],
    "风华": [["fēng"], ["huá"]],
    "风化": [["fēng"], ["huà"]],
    "风机": [["fēng"], ["jī"]],
    "风纪": [["fēng"], ["jì"]],
    "风景": [["fēng"], ["jǐng"]],
    "风镜": [["fēng"], ["jìng"]],
    "风口": [["fēng"], ["kǒu"]],
    "风浪": [["fēng"], ["làng"]],
    "风雷": [["fēng"], ["léi"]],
    "风力": [["fēng"], ["lì"]],
    "风凉": [["fēng"], ["liáng"]],
    "风量": [["fēng"], ["liàng"]],
    "风铃": [["fēng"], ["líng"]],
    "风流": [["fēng"], ["liú"]],
    "风轮": [["fēng"], ["lún"]],
    "风帽": [["fēng"], ["mào"]],
    "风貌": [["fēng"], ["mào"]],
    "风门": [["fēng"], ["mén"]],
    "风靡": [["fēng"], ["mǐ"]],
    "风磨": [["fēng"], ["mó"]],
    "风魔": [["fēng"], ["mó"]],
    "风能": [["fēng"], ["néng"]],
    "风鸟": [["fēng"], ["niǎo"]],
    "风派": [["fēng"], ["pài"]],
    "风气": [["fēng"], ["qì"]],
    "风琴": [["fēng"], ["qín"]],
    "风趣": [["fēng"], ["qù"]],
    "风情": [["fēng"], ["qíng"]],
    "风骚": [["fēng"], ["sāo"]],
    "风色": [["fēng"], ["sè"]],
    "风沙": [["fēng"], ["shā"]],
    "风扇": [["fēng"], ["shàn"]],
    "风尚": [["fēng"], ["shàng"]],
    "风神": [["fēng"], ["shén"]],
    "风声": [["fēng"], ["shēng"]],
    "风湿": [["fēng"], ["shī"]],
    "风蚀": [["fēng"], ["shí"]],
    "风势": [["fēng"], ["shì"]],
    "风水": [["fēng"], ["shuǐ"]],
    "风霜": [["fēng"], ["shuāng"]],
    "风俗": [["fēng"], ["sú"]],
    "风速": [["fēng"], ["sù"]],
    "风瘫": [["fēng"], ["tān"]],
    "风头": [["fēng"], ["tou"]],
    "风涛": [["fēng"], ["tāo"]],
    "风土": [["fēng"], ["tǔ"]],
    "风味": [["fēng"], ["wèi"]],
    "风闻": [["fēng"], ["wén"]],
    "风物": [["fēng"], ["wù"]],
    "风习": [["fēng"], ["xí"]],
    "风险": [["fēng"], ["xiǎn"]],
    "风箱": [["fēng"], ["xiāng"]],
    "风向": [["fēng"], ["xiàng"]],
    "风邪": [["fēng"], ["xié"]],
    "风行": [["fēng"], ["xíng"]],
    "风雅": [["fēng"], ["yǎ"]],
    "风烟": [["fēng"], ["yān"]],
    "风衣": [["fēng"], ["yī"]],
    "风仪": [["fēng"], ["yí"]],
    "风雨": [["fēng"], ["yǔ"]],
    "风源": [["fēng"], ["yuán"]],
    "风月": [["fēng"], ["yuè"]],
    "风韵": [["fēng"], ["yùn"]],
    "风闸": [["fēng"], ["zhá"]],
    "风灾": [["fēng"], ["zāi"]],
    "风障": [["fēng"], ["zhàng"]],
    "风疹": [["fēng"], ["zhěn"]],
    "风筝": [["fēng"], ["zhēng"]],
    "风致": [["fēng"], ["zhì"]],
    "风姿": [["fēng"], ["zī"]],
    "枫叶": [["fēng"], ["yè"]],
    "风钻": [["fēng"], ["zuàn"]],
    "封禅": [["fēng"], ["shàn"]],
    "封底": [["fēng"], ["dǐ"]],
    "封地": [["fēng"], ["dì"]],
    "封港": [["fēng"], ["gǎng"]],
    "封号": [["fēng"], ["hào"]],
    "封疆": [["fēng"], ["jiāng"]],
    "封禁": [["fēng"], ["jìn"]],
    "封泥": [["fēng"], ["ní"]],
    "封条": [["fēng"], ["tiáo"]],
    "封王": [["fēng"], ["wáng"]],
    "疯长": [["fēng"], ["cháng"]],
    "疯枝": [["fēng"], ["zhī"]],
    "蜂毒": [["fēng"], ["dú"]],
    "蜂王": [["fēng"], ["wáng"]],
    "缝补": [["féng"], ["bǔ"]],
    "缝合": [["féng"], ["hé"]],
    "缝工": [["fèng"], ["gōng"]],
    "缝际": [["fèng"], ["jì"]],
    "缝穷": [["fèng"], ["qióng"]],
    "缝纫": [["féng"], ["rèn"]],
    "缝隙": [["fèng"], ["xì"]],
    "缝衣": [["féng"], ["yī"]],
    "缝线": [["fèng"], ["xiàn"]],
    "缝制": [["féng"], ["zhì"]],
    "缝缀": [["féng"], ["zhuì"]],
    "讽刺": [["fěng"], ["cì"]],
    "缝子": [["fèng"], ["zi"]],
    "凤冠": [["fèng"], ["guān"]],
    "凤台": [["fèng"], ["tái"]],
    "凤尾": [["fèng"], ["wěi"]],
    "凤爪": [["fèng"], ["zhǎo"]],
    "奉还": [["fèng"], ["huán"]],
    "奉节": [["fèng"], ["jié"]],
    "奉上": [["fèng"], ["shàng"]],
    "奉令": [["fèng"], ["lìng"]],
    "奉行": [["fèng"], ["xíng"]],
    "奉召": [["fèng"], ["zhào"]],
    "佛典": [["fó"], ["diǎn"]],
    "佛殿": [["fó"], ["diàn"]],
    "佛法": [["fó"], ["fǎ"]],
    "佛号": [["fó"], ["hào"]],
    "佛光": [["fó"], ["guāng"]],
    "佛会": [["fó"], ["huì"]],
    "佛家": [["fó"], ["jiā"]],
    "佛教": [["fó"], ["jiào"]],
    "佛龛": [["fó"], ["kān"]],
    "佛门": [["fó"], ["mén"]],
    "佛经": [["fó"], ["jīng"]],
    "佛山": [["fó"], ["shān"]],
    "佛事": [["fó"], ["shì"]],
    "佛寺": [["fó"], ["sì"]],
    "佛手": [["fó"], ["shǒu"]],
    "佛塔": [["fó"], ["tǎ"]],
    "佛堂": [["fó"], ["táng"]],
    "佛陀": [["fó"], ["tuó"]],
    "佛像": [["fó"], ["xiàng"]],
    "佛性": [["fó"], ["xìng"]],
    "佛学": [["fó"], ["xué"]],
    "佛爷": [["fó"], ["yé"]],
    "佛牙": [["fó"], ["yá"]],
    "佛珠": [["fó"], ["zhū"]],
    "佛祖": [["fó"], ["zǔ"]],
    "否定": [["fǒu"], ["dìng"]],
    "否决": [["fǒu"], ["jué"]],
    "否认": [["fǒu"], ["rèn"]],
    "否则": [["fǒu"], ["zé"]],
    "夫妇": [["fū"], ["fù"]],
    "夫君": [["fū"], ["jūn"]],
    "夫妻": [["fū"], ["qī"]],
    "夫权": [["fū"], ["quán"]],
    "夫人": [["fū"], ["rén"]],
    "夫婿": [["fū"], ["xù"]],
    "夫子": [["fū"], ["zǐ"]],
    "肤觉": [["fū"], ["jué"]],
    "肤浅": [["fū"], ["qiǎn"]],
    "伏地": [["fú"], ["dì"]],
    "孵化": [["fū"], ["huà"]],
    "伏帖": [["fú"], ["tiē"]],
    "扶掖": [["fú"], ["yè"]],
    "扶风": [["fú"], ["fēng"]],
    "扶正": [["fú"], ["zhèng"]],
    "扶助": [["fú"], ["zhù"]],
    "拂尘": [["fú"], ["chén"]],
    "拂拂": [["fú"], ["fú"]],
    "拂逆": [["fú"], ["nì"]],
    "拂晓": [["fú"], ["xiǎo"]],
    "拂袖": [["fú"], ["xiù"]],
    "拂拭": [["fú"], ["shì"]],
    "服从": [["fú"], ["cóng"]],
    "服毒": [["fú"], ["dú"]],
    "服法": [["fú"], ["fǎ"]],
    "服老": [["fú"], ["lǎo"]],
    "服满": [["fú"], ["mǎn"]],
    "服气": [["fú"], ["qì"]],
    "服勤": [["fú"], ["qín"]],
    "服软": [["fú"], ["ruǎn"]],
    "服丧": [["fú"], ["sāng"]],
    "服色": [["fú"], ["sè"]],
    "服式": [["fú"], ["shì"]],
    "服饰": [["fú"], ["shì"]],
    "服侍": [["fú"], ["shì"]],
    "服输": [["fú"], ["shū"]],
    "服贴": [["fú"], ["tiē"]],
    "服帖": [["fú"], ["tiē"]],
    "服务": [["fú"], ["wù"]],
    "服药": [["fú"], ["yào"]],
    "服刑": [["fú"], ["xíng"]],
    "服役": [["fú"], ["yì"]],
    "服膺": [["fú"], ["yīng"]],
    "服用": [["fú"], ["yòng"]],
    "服众": [["fú"], ["zhòng"]],
    "服装": [["fú"], ["zhuāng"]],
    "服罪": [["fú"], ["zuì"]],
    "浮夸": [["fú"], ["kuā"]],
    "浮华": [["fú"], ["huá"]],
    "浮漂": [["fú"], ["piāo"]],
    "浮浅": [["fú"], ["qiǎn"]],
    "浮石": [["fú"], ["shí"]],
    "符合": [["fú"], ["hé"]],
    "符节": [["fú"], ["jié"]],
    "幅度": [["fú"], ["dù"]],
    "幅员": [["fú"], ["yuán"]],
    "福地": [["fú"], ["dì"]],
    "福分": [["fú"], ["fēn"]],
    "福将": [["fú"], ["jiāng"]],
    "辐射": [["fú"], ["shè"]],
    "福相": [["fú"], ["xiàng"]],
    "辐条": [["fú"], ["tiáo"]],
    "抚宁": [["fǔ"], ["níng"]],
    "抚摩": [["fǔ"], ["mó"]],
    "抚弄": [["fǔ"], ["nòng"]],
    "府上": [["fǔ"], ["shàng"]],
    "斧正": [["fǔ"], ["zhèng"]],
    "俯冲": [["fǔ"], ["chōng"]],
    "斧头": [["fǔ"], ["tóu"]],
    "俯角": [["fǔ"], ["jiǎo"]],
    "俯仰": [["fǔ"], ["yǎng"]],
    "腐臭": [["fǔ"], ["chòu"]],
    "辅助": [["fǔ"], ["zhù"]],
    "腐恶": [["fǔ"], ["è"]],
    "腐化": [["fǔ"], ["huà"]],
    "腐坏": [["fǔ"], ["huài"]],
    "父辈": [["fù"], ["bèi"]],
    "父本": [["fù"], ["běn"]],
    "父母": [["fù"], ["mǔ"]],
    "父老": [["fù"], ["lǎo"]],
    "父亲": [["fù"], ["qīn"]],
    "父权": [["fù"], ["quán"]],
    "父系": [["fù"], ["xì"]],
    "父兄": [["fù"], ["xiōng"]],
    "父执": [["fù"], ["zhí"]],
    "父业": [["fù"], ["yè"]],
    "父子": [["fù"], ["zǐ"]],
    "付与": [["fù"], ["yǔ"]],
    "妇女": [["fù"], ["nǚ"]],
    "妇弟": [["fù"], ["dì"]],
    "负担": [["fù"], ["dān"]],
    "负号": [["fù"], ["hào"]],
    "负累": [["fù"], ["lèi"]],
    "负片": [["fù"], ["piàn"]],
    "负数": [["fù"], ["shù"]],
    "负约": [["fù"], ["yuē"]],
    "负载": [["fù"], ["zài"]],
    "附和": [["fù"], ["hè"]],
    "负重": [["fù"], ["zhòng"]],
    "附会": [["fù"], ["huì"]],
    "附丽": [["fù"], ["lì"]],
    "附上": [["fù"], ["shàng"]],
    "附识": [["fù"], ["zhì"]],
    "附载": [["fù"], ["zǎi"]],
    "附中": [["fù"], ["zhōng"]],
    "附属": [["fù"], ["shǔ"]],
    "附着": [["fù"], ["zhuó"]],
    "复辟": [["fù"], ["bì"]],
    "复仇": [["fù"], ["chóu"]],
    "复查": [["fù"], ["zhā"]],
    "复读": [["fù"], ["dú"]],
    "复合": [["fù"], ["hé"]],
    "复核": [["fù"], ["hé"]],
    "复发": [["fù"], ["fā"]],
    "复数": [["fù"], ["shù"]],
    "复会": [["fù"], ["huì"]],
    "复句": [["fù"], ["jù"]],
    "复苏": [["fù"], ["sū"]],
    "复信": [["fù"], ["xìn"]],
    "复兴": [["fù"], ["xīng"]],
    "复叶": [["fù"], ["yè"]],
    "复员": [["fù"], ["yuán"]],
    "复种": [["fù"], ["zhǒng"]],
    "复转": [["fù"], ["zhuǎn"]],
    "赴会": [["fù"], ["huì"]],
    "赴难": [["fù"], ["nàn"]],
    "赴任": [["fù"], ["rèn"]],
    "赴约": [["fù"], ["yuē"]],
    "副本": [["fù"], ["běn"]],
    "副词": [["fù"], ["cí"]],
    "副歌": [["fù"], ["gē"]],
    "副官": [["fù"], ["guān"]],
    "副刊": [["fù"], ["kān"]],
    "副品": [["fù"], ["pǐn"]],
    "副肾": [["fù"], ["shèn"]],
    "副食": [["fù"], ["shí"]],
    "副手": [["fù"], ["shǒu"]],
    "副署": [["fù"], ["shǔ"]],
    "副职": [["fù"], ["zhí"]],
    "富家": [["fù"], ["jiā"]],
    "富贾": [["fù"], ["jiǎ"]],
    "富丽": [["fù"], ["lì"]],
    "富强": [["fù"], ["qiáng"]],
    "富有": [["fù"], ["yǒu"]],
    "赋有": [["fù"], ["yǒu"]],
    "赋予": [["fù"], ["yǔ"]],
    "腹地": [["fù"], ["dì"]],
    "腹内": [["fù"], ["nèi"]],
    "蝮蛇": [["fù"], ["shé"]],
    "覆被": [["fù"], ["bèi"]],
    "覆盖": [["fù"], ["gài"]],
    "覆核": [["fù"], ["hé"]],
    "覆没": [["fù"], ["mò"]],
    "覆亡": [["fù"], ["wáng"]],
    "伽蓝": [["qié"], ["lán"]],
    "嘎巴": [["gā"], ["bā"]],
    "嘎噔": [["gā"], ["dēng"]],
    "嘎嘎": [["gā"], ["gā"]],
    "嘎啦": [["gā"], ["lā"]],
    "嘎然": [["gā"], ["rán"]],
    "嘎吱": [["gā"], ["zhī"]],
    "嘎子": [["gǎ"], ["zǐ"]],
    "该当": [["gāi"], ["dāng"]],
    "该着": [["gāi"], ["zháo"]],
    "赅括": [["gāi"], ["kuò"]],
    "改称": [["gǎi"], ["chēng"]],
    "改调": [["gǎi"], ["diào"]],
    "改观": [["gǎi"], ["guān"]],
    "改过": [["gǎi"], ["guò"]],
    "改任": [["gǎi"], ["rèn"]],
    "改期": [["gǎi"], ["qī"]],
    "改为": [["gǎi"], ["wéi"]],
    "改行": [["gǎi"], ["háng"]],
    "改正": [["gǎi"], ["zhèng"]],
    "钙化": [["gài"], ["huà"]],
    "盖饭": [["gài"], ["fàn"]],
    "盖帘": [["gài"], ["lián"]],
    "盖世": [["gài"], ["shì"]],
    "盖头": [["gài"], ["tóu"]],
    "盖造": [["gài"], ["zào"]],
    "盖子": [["gài"], ["zi"]],
    "概观": [["gài"], ["guān"]],
    "概括": [["gài"], ["kuò"]],
    "概率": [["gài"], ["lǜ"]],
    "概论": [["gài"], ["lùn"]],
    "概数": [["gài"], ["shù"]],
    "概要": [["gài"], ["yào"]],
    "干碍": [["gān"], ["ài"]],
    "干巴": [["gān"], ["bā"]],
    "干白": [["gàn"], ["bái"]],
    "干杯": [["gān"], ["bēi"]],
    "干贝": [["gān"], ["bèi"]],
    "干瘪": [["gān"], ["biě"]],
    "干冰": [["gān"], ["bīng"]],
    "干部": [["gàn"], ["bù"]],
    "干才": [["gàn"], ["cái"]],
    "干菜": [["gān"], ["cài"]],
    "干草": [["gān"], ["cǎo"]],
    "干柴": [["gān"], ["chái"]],
    "干脆": [["gān"], ["cuì"]],
    "干城": [["gān"], ["chéng"]],
    "干道": [["gàn"], ["dào"]],
    "干点": [["gàn"], ["diǎn"]],
    "干掉": [["gàn"], ["diào"]],
    "干爹": [["gān"], ["diē"]],
    "干儿": [["gān"], ["ér"]],
    "干犯": [["gān"], ["fàn"]],
    "干粉": [["gàn"], ["fěn"]],
    "干饭": [["gān"], ["fàn"]],
    "干干": [["gàn"], ["gàn"]],
    "干戈": [["gān"], ["gē"]],
    "干股": [["gān"], ["gǔ"]],
    "干果": [["gān"], ["guǒ"]],
    "干旱": [["gān"], ["hàn"]],
    "干嚎": [["gān"], ["háo"]],
    "干号": [["gān"], ["háo"]],
    "干涸": [["gān"], ["hé"]],
    "干花": [["gān"], ["huā"]],
    "干哕": [["gān"], ["yuě"]],
    "干活": [["gàn"], ["huó"]],
    "干货": [["gān"], ["huò"]],
    "干架": [["gàn"], ["jià"]],
    "干急": [["gān"], ["jí"]],
    "干姜": [["gān"], ["jiāng"]],
    "干将": [["gàn"], ["jiàng"]],
    "干结": [["gàn"], ["jié"]],
    "干劲": [["gàn"], ["jìn"]],
    "干警": [["gàn"], ["jǐng"]],
    "干净": [["gān"], ["jìng"]],
    "干咳": [["gān"], ["hāi"]],
    "干枯": [["gān"], ["kū"]],
    "干渴": [["gān"], ["kě"]],
    "干哭": [["gān"], ["kū"]],
    "干冷": [["gān"], ["lěng"]],
    "干酪": [["gān"], ["lào"]],
    "干连": [["gān"], ["lián"]],
    "干练": [["gàn"], ["liàn"]],
    "干粮": [["gān"], ["liáng"]],
    "干裂": [["gān"], ["liè"]],
    "干流": [["gàn"], ["liú"]],
    "干路": [["gàn"], ["lù"]],
    "干馏": [["gān"], ["liú"]],
    "干吗": [["gàn"], ["má"]],
    "干嘛": [["gàn"], ["mɑ"]],
    "干么": [["gàn"], ["mǒ"]],
    "干娘": [["gān"], ["niáng"]],
    "干呕": [["gān"], ["ǒu"]],
    "干亲": [["gān"], ["qīn"]],
    "干渠": [["gàn"], ["qú"]],
    "干扰": [["gān"], ["rǎo"]],
    "干涩": [["gān"], ["sè"]],
    "干涉": [["gān"], ["shè"]],
    "干尸": [["gān"], ["shī"]],
    "干瘦": [["gān"], ["shòu"]],
    "干事": [["gàn"], ["shì"]],
    "干松": [["gàn"], ["sōng"]],
    "干爽": [["gān"], ["shuǎng"]],
    "干系": [["gān"], ["xì"]],
    "干洗": [["gān"], ["xǐ"]],
    "干线": [["gàn"], ["xiàn"]],
    "干校": [["gàn"], ["xiào"]],
    "干薪": [["gān"], ["xīn"]],
    "干笑": [["gān"], ["xiào"]],
    "干谒": [["gān"], ["yè"]],
    "干硬": [["gàn"], ["yìng"]],
    "干预": [["gàn"], ["yù"]],
    "干员": [["gàn"], ["yuán"]],
    "干燥": [["gān"], ["zào"]],
    "干政": [["gàn"], ["zhèng"]],
    "干支": [["gān"], ["zhī"]],
    "干仗": [["gàn"], ["zhàng"]],
    "甘当": [["gān"], ["dāng"]],
    "甘结": [["gān"], ["jié"]],
    "甘露": [["gān"], ["lù"]],
    "杆秤": [["gǎn"], ["chèng"]],
    "甘休": [["gān"], ["xiū"]],
    "甘雨": [["gān"], ["yǔ"]],
    "杆菌": [["gǎn"], ["jūn"]],
    "杆塔": [["gǎn"], ["tǎ"]],
    "杆子": [["gān"], ["zi"]],
    "肝风": [["gān"], ["fēng"]],
    "赶车": [["gǎn"], ["chē"]],
    "赶场": [["gǎn"], ["chǎng"]],
    "赶会": [["gǎn"], ["huì"]],
    "赶跑": [["gǎn"], ["pǎo"]],
    "赶上": [["gǎn"], ["shàng"]],
    "赶趟": [["gǎn"], ["tàng"]],
    "赶着": [["gǎn"], ["zhe"]],
    "感发": [["gǎn"], ["fā"]],
    "感化": [["gǎn"], ["huà"]],
    "敢当": [["gǎn"], ["dāng"]],
    "感冒": [["gǎn"], ["mào"]],
    "感应": [["gǎn"], ["yìng"]],
    "感觉": [["gǎn"], ["jué"]],
    "感召": [["gǎn"], ["zhào"]],
    "感知": [["gǎn"], ["zhī"]],
    "矸石": [["gān"], ["shí"]],
    "刚度": [["gāng"], ["dù"]],
    "刚好": [["gāng"], ["hǎo"]],
    "刚劲": [["gāng"], ["jìng"]],
    "刚强": [["gāng"], ["qiáng"]],
    "刚石": [["gāng"], ["shí"]],
    "刚体": [["gāng"], ["tǐ"]],
    "岗地": [["gǎng"], ["dì"]],
    "刚正": [["gāng"], ["zhèng"]],
    "岗卡": [["gǎng"], ["kǎ"]],
    "纲纪": [["gāng"], ["jì"]],
    "纲要": [["gāng"], ["yào"]],
    "缸瓦": [["gāng"], ["wǎ"]],
    "钢板": [["gāng"], ["bǎn"]],
    "钢笔": [["gāng"], ["bǐ"]],
    "钢包": [["gāng"], ["bāo"]],
    "钢鞭": [["gāng"], ["biān"]],
    "钢材": [["gāng"], ["cái"]],
    "钢尺": [["gāng"], ["chǐ"]],
    "钢刀": [["gāng"], ["dāo"]],
    "钢锭": [["gāng"], ["dìng"]],
    "钢骨": [["gāng"], ["gǔ"]],
    "钢管": [["gāng"], ["guǎn"]],
    "钢轨": [["gāng"], ["guǐ"]],
    "钢花": [["gāng"], ["huā"]],
    "钢筋": [["gāng"], ["jīn"]],
    "钢精": [["gāng"], ["jīng"]],
    "钢锯": [["gāng"], ["jù"]],
    "钢缆": [["gāng"], ["lǎn"]],
    "钢盔": [["gāng"], ["kuī"]],
    "钢坯": [["gāng"], ["pī"]],
    "钢瓶": [["gāng"], ["píng"]],
    "钢钎": [["gāng"], ["qiān"]],
    "钢枪": [["gāng"], ["qiāng"]],
    "钢琴": [["gāng"], ["qín"]],
    "钢砂": [["gāng"], ["shā"]],
    "钢水": [["gāng"], ["shuǐ"]],
    "钢丝": [["gāng"], ["sī"]],
    "钢索": [["gāng"], ["suǒ"]],
    "钢铁": [["gāng"], ["tiě"]],
    "钢条": [["gāng"], ["tiáo"]],
    "钢印": [["gāng"], ["yìn"]],
    "钢硬": [["gāng"], ["yìng"]],
    "钢渣": [["gāng"], ["zhā"]],
    "钢针": [["gāng"], ["zhēn"]],
    "钢种": [["gāng"], ["zhǒng"]],
    "钢珠": [["gāng"], ["zhū"]],
    "罡风": [["gāng"], ["fēng"]],
    "港澳": [["gǎng"], ["ào"]],
    "港币": [["gǎng"], ["bì"]],
    "港汊": [["gǎng"], ["chà"]],
    "港警": [["gǎng"], ["jǐng"]],
    "港客": [["gǎng"], ["kè"]],
    "港口": [["gǎng"], ["kǒu"]],
    "港商": [["gǎng"], ["shāng"]],
    "港湾": [["gǎng"], ["wān"]],
    "港务": [["gǎng"], ["wù"]],
    "港元": [["gǎng"], ["yuán"]],
    "杠夫": [["gàng"], ["fū"]],
    "杠杠": [["gàng"], ["gàng"]],
    "杠杆": [["gàng"], ["gǎn"]],
    "杠铃": [["gàng"], ["líng"]],
    "杠子": [["gàng"], ["zi"]],
    "杠头": [["gàng"], ["tóu"]],
    "羔羊": [["gāo"], ["yáng"]],
    "皋兰": [["gāo"], ["lán"]],
    "高参": [["gāo"], ["cān"]],
    "高处": [["gāo"], ["chù"]],
    "高差": [["gāo"], ["chà"]],
    "高大": [["gāo"], ["dà"]],
    "高地": [["gāo"], ["dì"]],
    "高调": [["gāo"], ["diào"]],
    "高发": [["gāo"], ["fā"]],
    "高度": [["gāo"], ["dù"]],
    "高干": [["gāo"], ["gàn"]],
    "高估": [["gāo"], ["gū"]],
    "高个": [["gāo"], ["gè"]],
    "高见": [["gāo"], ["jiàn"]],
    "高价": [["gāo"], ["jià"]],
    "高教": [["gāo"], ["jiào"]],
    "高看": [["gāo"], ["kàn"]],
    "高空": [["gāo"], ["kōng"]],
    "高丽": [["gāo"], ["lí"]],
    "高论": [["gāo"], ["lùn"]],
    "高难": [["gāo"], ["nán"]],
    "高能": [["gāo"], ["néng"]],
    "高频": [["gāo"], ["pín"]],
    "高强": [["gāo"], ["qiáng"]],
    "高台": [["gāo"], ["tái"]],
    "高汤": [["gāo"], ["tāng"]],
    "高挑": [["gāo"], ["tiǎo"]],
    "高兴": [["gāo"], ["xìng"]],
    "高校": [["gāo"], ["xiào"]],
    "高压": [["gāo"], ["yā"]],
    "高远": [["gāo"], ["yuǎn"]],
    "高涨": [["gāo"], ["zhǎng"]],
    "高枝": [["gāo"], ["zhī"]],
    "高知": [["gāo"], ["zhì"]],
    "高中": [["gāo"], ["zhōng"]],
    "膏肓": [["gāo"], ["huāng"]],
    "膏剂": [["gāo"], ["jì"]],
    "膏粱": [["gāo"], ["liáng"]],
    "膏血": [["gāo"], ["xuè"]],
    "膏药": [["gāo"], ["yào"]],
    "膏腴": [["gāo"], ["yú"]],
    "膏泽": [["gào"], ["zé"]],
    "篙头": [["gāo"], ["tou"]],
    "膏子": [["gāo"], ["zǐ"]],
    "糕干": [["gāo"], ["gān"]],
    "搞好": [["gǎo"], ["hǎo"]],
    "稿约": [["gǎo"], ["yuē"]],
    "镐头": [["gǎo"], ["tóu"]],
    "告便": [["gào"], ["biàn"]],
    "告别": [["gào"], ["bié"]],
    "告倒": [["gào"], ["dǎo"]],
    "告发": [["gào"], ["fā"]],
    "告假": [["gào"], ["jià"]],
    "告知": [["gào"], ["zhī"]],
    "告语": [["gào"], ["yǔ"]],
    "疙疤": [["gē"], ["bā"]],
    "疙瘩": [["gē"], ["dā"]],
    "胳臂": [["gē"], ["bei"]],
    "胳膊": [["gē"], ["bo"]],
    "胳肢": [["gē"], ["zhī"]],
    "鸽笼": [["gē"], ["lóng"]],
    "割据": [["gē"], ["jù"]],
    "割地": [["gē"], ["dì"]],
    "割裂": [["gē"], ["liè"]],
    "割切": [["gē"], ["qiē"]],
    "搁笔": [["gē"], ["bǐ"]],
    "搁板": [["gē"], ["bǎn"]],
    "搁浅": [["gē"], ["qiǎn"]],
    "搁置": [["gē"], ["zhì"]],
    "歌女": [["gē"], ["nǚ"]],
    "歌曲": [["gē"], ["qǔ"]],
    "歌行": [["gē"], ["xíng"]],
    "革囊": [["gé"], ["náng"]],
    "阁员": [["gé"], ["yuán"]],
    "格调": [["gé"], ["diào"]],
    "格斗": [["gé"], ["dòu"]],
    "葛布": [["gé"], ["bù"]],
    "葛粉": [["gé"], ["fěn"]],
    "葛根": [["gé"], ["gēn"]],
    "葛藤": [["gé"], ["téng"]],
    "蛤粉": [["gé"], ["fěn"]],
    "蛤蚧": [["gé"], ["jiè"]],
    "蛤蜊": [["gé"], ["lí"]],
    "隔别": [["gé"], ["bié"]],
    "蛤蟆": [["há"], ["má"]],
    "隔间": [["gé"], ["jiān"]],
    "隔扇": [["gé"], ["shān"]],
    "隔行": [["gé"], ["háng"]],
    "隔宿": [["gé"], ["sù"]],
    "隔栅": [["gé"], ["zhà"]],
    "个把": [["gè"], ["bǎ"]],
    "个案": [["gè"], ["àn"]],
    "个别": [["gè"], ["bié"]],
    "个儿": [["gè"], ["ér"]],
    "个个": [["gè"], ["gè"]],
    "个旧": [["gè"], ["jiù"]],
    "个人": [["gè"], ["rén"]],
    "个体": [["gè"], ["tǐ"]],
    "个头": [["gè"], ["tóu"]],
    "个位": [["gè"], ["wèi"]],
    "个性": [["gè"], ["xìng"]],
    "个中": [["gè"], ["zhōng"]],
    "个子": [["gè"], ["zi"]],
    "各半": [["gè"], ["bàn"]],
    "各别": [["gè"], ["bié"]],
    "各处": [["gè"], ["chù"]],
    "各个": [["gè"], ["gè"]],
    "各级": [["gè"], ["jí"]],
    "各界": [["gè"], ["jiè"]],
    "各人": [["gè"], ["rén"]],
    "各色": [["gè"], ["sè"]],
    "各位": [["gè"], ["wèi"]],
    "各样": [["gè"], ["yàng"]],
    "各种": [["gè"], ["zhǒng"]],
    "各自": [["gè"], ["zì"]],
    "给定": [["gěi"], ["dìng"]],
    "给钱": [["gěi"], ["qián"]],
    "给付": [["gěi"], ["fù"]],
    "给水": [["jǐ"], ["shuǐ"]],
    "给养": [["jǐ"], ["yǎng"]],
    "给以": [["gěi"], ["yǐ"]],
    "给与": [["gěi"], ["yǔ"]],
    "给予": [["jǐ"], ["yǔ"]],
    "根底": [["gēn"], ["dǐ"]],
    "根号": [["gēn"], ["hào"]],
    "根据": [["gēn"], ["jù"]],
    "根系": [["gēn"], ["xì"]],
    "跟差": [["gēn"], ["chāi"]],
    "跟从": [["gēn"], ["cóng"]],
    "跟斗": [["gēn"], ["dǒu"]],
    "跟上": [["gēn"], ["shàng"]],
    "跟着": [["gēn"], ["zhe"]],
    "跟头": [["gēn"], ["tou"]],
    "更次": [["gēng"], ["cì"]],
    "更迭": [["gēng"], ["dié"]],
    "更动": [["gēng"], ["dòng"]],
    "更番": [["gēng"], ["fān"]],
    "更夫": [["gēng"], ["fū"]],
    "更改": [["gēng"], ["gǎi"]],
    "更鼓": [["gēng"], ["gǔ"]],
    "更换": [["gēng"], ["huàn"]],
    "更加": [["gèng"], ["jiā"]],
    "更名": [["gēng"], ["míng"]],
    "更其": [["gèng"], ["qí"]],
    "更深": [["gēng"], ["shēn"]],
    "更生": [["gēng"], ["shēng"]],
    "更始": [["gēng"], ["shǐ"]],
    "更替": [["gēng"], ["tì"]],
    "更为": [["gèng"], ["wéi"]],
    "更新": [["gēng"], ["xīn"]],
    "更衣": [["gēng"], ["yī"]],
    "更易": [["gēng"], ["yì"]],
    "更张": [["gēng"], ["zhāng"]],
    "更正": [["gēng"], ["zhèng"]],
    "更卒": [["gēng"], ["zú"]],
    "庚帖": [["gēng"], ["tiě"]],
    "耕读": [["gēng"], ["dú"]],
    "耕地": [["gēng"], ["dì"]],
    "耕畜": [["gēng"], ["chù"]],
    "耕织": [["gēng"], ["zhī"]],
    "耕种": [["gēng"], ["zhòng"]],
    "羹匙": [["gēng"], ["chí"]],
    "羹汤": [["gēng"], ["tāng"]],
    "哽塞": [["gěng"], ["sè"]],
    "哽咽": [["gěng"], ["yè"]],
    "梗塞": [["gěng"], ["sè"]],
    "工厂": [["gōng"], ["chǎng"]],
    "工长": [["gōng"], ["cháng"]],
    "工场": [["gōng"], ["chǎng"]],
    "工地": [["gōng"], ["dì"]],
    "工尺": [["gōng"], ["chě"]],
    "工读": [["gōng"], ["dú"]],
    "工分": [["gōng"], ["fēn"]],
    "工夫": [["gōng"], ["fū"]],
    "工价": [["gōng"], ["jià"]],
    "工会": [["gōng"], ["huì"]],
    "工间": [["gōng"], ["jiān"]],
    "工楷": [["gōng"], ["kǎi"]],
    "工区": [["gōng"], ["qū"]],
    "工期": [["gōng"], ["qī"]],
    "工头": [["gōng"], ["tóu"]],
    "工休": [["gōng"], ["xiū"]],
    "工种": [["gōng"], ["zhǒng"]],
    "弓背": [["gōng"], ["bèi"]],
    "公差": [["gōng"], ["chāi"]],
    "公车": [["gōng"], ["chē"]],
    "公称": [["gōng"], ["chēng"]],
    "公尺": [["gōng"], ["chǐ"]],
    "公担": [["gōng"], ["dān"]],
    "公地": [["gōng"], ["dì"]],
    "公分": [["gōng"], ["fēn"]],
    "公干": [["gōng"], ["gàn"]],
    "公共": [["gōng"], ["gòng"]],
    "公侯": [["gōng"], ["hóu"]],
    "公祭": [["gōng"], ["jì"]],
    "公会": [["gōng"], ["huì"]],
    "公家": [["gōng"], ["jiā"]],
    "公假": [["gōng"], ["jià"]],
    "公了": [["gōng"], ["le"]],
    "公论": [["gōng"], ["lùn"]],
    "公猫": [["gōng"], ["māo"]],
    "公仆": [["gōng"], ["pú"]],
    "公帑": [["gōng"], ["tǎng"]],
    "公孙": [["gōng"], ["sūn"]],
    "公休": [["gōng"], ["xiū"]],
    "公畜": [["gōng"], ["chù"]],
    "公羊": [["gōng"], ["yáng"]],
    "公有": [["gōng"], ["yǒu"]],
    "公约": [["gōng"], ["yuē"]],
    "公正": [["gōng"], ["zhèng"]],
    "公助": [["gōng"], ["zhù"]],
    "公转": [["gōng"], ["zhuàn"]],
    "功底": [["gōng"], ["dǐ"]],
    "功夫": [["gōng"], ["fū"]],
    "功过": [["gōng"], ["guò"]],
    "功令": [["gōng"], ["lìng"]],
    "功率": [["gōng"], ["lǜ"]],
    "攻打": [["gōng"], ["dǎ"]],
    "功能": [["gōng"], ["néng"]],
    "攻读": [["gōng"], ["dú"]],
    "供案": [["gòng"], ["àn"]],
    "攻占": [["gōng"], ["zhàn"]],
    "供称": [["gòng"], ["chēng"]],
    "供词": [["gòng"], ["cí"]],
    "供电": [["gōng"], ["diàn"]],
    "供奉": [["gòng"], ["fèng"]],
    "供稿": [["gòng"], ["gǎo"]],
    "供给": [["gōng"], ["jǐ"]],
    "供果": [["gòng"], ["guǒ"]],
    "供料": [["gōng"], ["liào"]],
    "供暖": [["gòng"], ["nuǎn"]],
    "供品": [["gòng"], ["pǐn"]],
    "供气": [["gōng"], ["qì"]],
    "供求": [["gōng"], ["qiú"]],
    "供认": [["gòng"], ["rèn"]],
    "供事": [["gòng"], ["shì"]],
    "供销": [["gōng"], ["xiāo"]],
    "供需": [["gōng"], ["xū"]],
    "供养": [["gòng"], ["yǎng"]],
    "供应": [["gōng"], ["yìng"]],
    "供状": [["gòng"], ["zhuàng"]],
    "供职": [["gòng"], ["zhí"]],
    "供桌": [["gòng"], ["zhuō"]],
    "肱骨": [["gōng"], ["gǔ"]],
    "宫调": [["gōng"], ["diào"]],
    "宫禁": [["gōng"], ["jìn"]],
    "宫颈": [["gōng"], ["jǐng"]],
    "宫女": [["gōng"], ["nǚ"]],
    "宫扇": [["gōng"], ["shàn"]],
    "宫阙": [["gōng"], ["què"]],
    "宫掖": [["gōng"], ["yè"]],
    "躬亲": [["gōng"], ["qīn"]],
    "拱圈": [["gǒng"], ["quān"]],
    "躬行": [["gōng"], ["xíng"]],
    "拱券": [["gǒng"], ["xuàn"]],
    "共餐": [["gòng"], ["cān"]],
    "共处": [["gòng"], ["chǔ"]],
    "共存": [["gòng"], ["cún"]],
    "共度": [["gòng"], ["dù"]],
    "共犯": [["gòng"], ["fàn"]],
    "共管": [["gòng"], ["guǎn"]],
    "共和": [["gòng"], ["hé"]],
    "共话": [["gòng"], ["huà"]],
    "共计": [["gòng"], ["jì"]],
    "共济": [["gòng"], ["jì"]],
    "共价": [["gòng"], ["jià"]],
    "共聚": [["gòng"], ["jù"]],
    "共居": [["gòng"], ["jū"]],
    "共勉": [["gòng"], ["miǎn"]],
    "共鸣": [["gòng"], ["míng"]],
    "共谋": [["gòng"], ["móu"]],
    "共栖": [["gòng"], ["qī"]],
    "共生": [["gòng"], ["shēng"]],
    "共识": [["gòng"], ["shí"]],
    "共通": [["gòng"], ["tōng"]],
    "共事": [["gòng"], ["shì"]],
    "共同": [["gòng"], ["tóng"]],
    "共线": [["gòng"], ["xiàn"]],
    "共相": [["gòng"], ["xiāng"]],
    "共享": [["gòng"], ["xiǎng"]],
    "共性": [["gòng"], ["xìng"]],
    "共议": [["gòng"], ["yì"]],
    "共用": [["gòng"], ["yòng"]],
    "共有": [["gòng"], ["yǒu"]],
    "共总": [["gòng"], ["zǒng"]],
    "共振": [["gòng"], ["zhèn"]],
    "勾搭": [["gōu"], ["dā"]],
    "勾除": [["gōu"], ["chú"]],
    "勾当": [["gòu"], ["dàng"]],
    "勾兑": [["gōu"], ["duì"]],
    "勾画": [["gōu"], ["huà"]],
    "勾绘": [["gōu"], ["huì"]],
    "勾魂": [["gōu"], ["hún"]],
    "勾践": [["gōu"], ["jiàn"]],
    "勾栏": [["gōu"], ["lán"]],
    "勾结": [["gōu"], ["jié"]],
    "勾勒": [["gōu"], ["lè"]],
    "勾连": [["gōu"], ["lián"]],
    "勾脸": [["gōu"], ["liǎn"]],
    "勾留": [["gōu"], ["liú"]],
    "勾描": [["gōu"], ["miáo"]],
    "勾起": [["gōu"], ["qǐ"]],
    "勾芡": [["gōu"], ["qiàn"]],
    "勾通": [["gōu"], ["tōng"]],
    "勾消": [["gōu"], ["xiāo"]],
    "勾销": [["gōu"], ["xiāo"]],
    "勾引": [["gōu"], ["yǐn"]],
    "佝偻": [["gōu"], ["lóu"]],
    "沟渠": [["gōu"], ["qú"]],
    "沟堑": [["gōu"], ["qiàn"]],
    "苟合": [["gǒu"], ["hé"]],
    "狗头": [["gǒu"], ["tóu"]],
    "苟且": [["gǒu"], ["qiě"]],
    "枸橘": [["gōu"], ["jú"]],
    "苟同": [["gǒu"], ["tóng"]],
    "枸杞": [["gǒu"], ["qǐ"]],
    "构思": [["gòu"], ["sī"]],
    "枸橼": [["jǔ"], ["yuán"]],
    "构筑": [["gòu"], ["zhù"]],
    "购得": [["gòu"], ["de"]],
    "垢泥": [["gòu"], ["ní"]],
    "够呛": [["gòu"], ["qiāng"]],
    "媾和": [["gòu"], ["hé"]],
    "媾合": [["gòu"], ["hé"]],
    "彀中": [["gòu"], ["zhōng"]],
    "估产": [["gū"], ["chǎn"]],
    "估计": [["gū"], ["jì"]],
    "估价": [["gū"], ["jià"]],
    "估量": [["gū"], ["liang"]],
    "估摸": [["gū"], ["mō"]],
    "估算": [["gū"], ["suàn"]],
    "估衣": [["gù"], ["yī"]],
    "姑夫": [["gū"], ["fū"]],
    "姑父": [["gū"], ["fù"]],
    "姑且": [["gū"], ["qiě"]],
    "姑苏": [["gū"], ["sū"]],
    "姑洗": [["gū"], ["xǐ"]],
    "孤单": [["gū"], ["dān"]],
    "孤女": [["gū"], ["nǚ"]],
    "孤行": [["gū"], ["xíng"]],
    "古奥": [["gǔ"], ["ào"]],
    "古风": [["gǔ"], ["fēng"]],
    "古都": [["gǔ"], ["dū"]],
    "古朴": [["gǔ"], ["piáo"]],
    "古刹": [["gǔ"], ["chà"]],
    "古体": [["gǔ"], ["tǐ"]],
    "古语": [["gǔ"], ["yǔ"]],
    "古远": [["gǔ"], ["yuǎn"]],
    "汩汩": [["gǔ"], ["gǔ"]],
    "汩没": [["gǔ"], ["mò"]],
    "谷底": [["gǔ"], ["dǐ"]],
    "谷地": [["gǔ"], ["dì"]],
    "谷坊": [["gǔ"], ["fáng"]],
    "谷雨": [["gǔ"], ["yǔ"]],
    "股长": [["gǔ"], ["zhǎng"]],
    "股分": [["gǔ"], ["fēn"]],
    "股份": [["gǔ"], ["fèn"]],
    "股骨": [["gǔ"], ["gǔ"]],
    "股票": [["gǔ"], ["piào"]],
    "骨刺": [["gǔ"], ["cì"]],
    "骨董": [["gǔ"], ["dǒng"]],
    "骨朵": [["gū"], ["duǒ"]],
    "骨粉": [["gǔ"], ["fěn"]],
    "骨干": [["gǔ"], ["gàn"]],
    "骨鲠": [["gǔ"], ["gěng"]],
    "骨骼": [["gǔ"], ["gé"]],
    "骨化": [["gǔ"], ["huà"]],
    "骨灰": [["gǔ"], ["huī"]],
    "骨胶": [["gǔ"], ["jiāo"]],
    "骨架": [["gǔ"], ["jià"]],
    "骨节": [["gǔ"], ["jié"]],
    "骨科": [["gǔ"], ["kē"]],
    "骨库": [["gǔ"], ["kù"]],
    "骨痨": [["gǔ"], ["láo"]],
    "骨力": [["gǔ"], ["lì"]],
    "骨料": [["gǔ"], ["liào"]],
    "骨碌": [["gū"], ["lù"]],
    "骨膜": [["gǔ"], ["mó"]],
    "骨盆": [["gǔ"], ["pén"]],
    "骨牌": [["gǔ"], ["pái"]],
    "骨气": [["gǔ"], ["qì"]],
    "骨肉": [["gǔ"], ["ròu"]],
    "骨髓": [["gǔ"], ["suǐ"]],
    "骨炭": [["gǔ"], ["tàn"]],
    "骨头": [["gú"], ["tou"]],
    "骨学": [["gǔ"], ["xué"]],
    "骨血": [["gǔ"], ["xuè"]],
    "骨殖": [["gǔ"], ["shi"]],
    "骨折": [["gǔ"], ["zhé"]],
    "骨子": [["gǔ"], ["zi"]],
    "榾柮": [["gǔ"], ["duò"]],
    "鼓风": [["gǔ"], ["fēng"]],
    "鼓角": [["gǔ"], ["jiǎo"]],
    "鼓劲": [["gǔ"], ["jìn"]],
    "鼓弄": [["gǔ"], ["nòng"]],
    "鼓乐": [["gǔ"], ["yuè"]],
    "固结": [["gù"], ["jié"]],
    "固体": [["gù"], ["tǐ"]],
    "固有": [["gù"], ["yǒu"]],
    "故地": [["gù"], ["dì"]],
    "故伎": [["gù"], ["jì"]],
    "固着": [["gù"], ["zhuó"]],
    "故都": [["gù"], ["dū"]],
    "故知": [["gù"], ["zhī"]],
    "故纵": [["gù"], ["zòng"]],
    "顾家": [["gù"], ["jiā"]],
    "雇佣": [["gù"], ["yōng"]],
    "雇员": [["gù"], ["yuán"]],
    "瓜分": [["guā"], ["fēn"]],
    "瓜蔓": [["guā"], ["wàn"]],
    "瓜葛": [["guā"], ["gé"]],
    "瓜片": [["guā"], ["piàn"]],
    "瓜期": [["guā"], ["qī"]],
    "刮风": [["guā"], ["fēng"]],
    "刮削": [["guā"], ["xiāo"]],
    "呱嗒": [["guā"], ["dā"]],
    "呱唧": [["guā"], ["jī"]],
    "呱呱": [["ɡū"], ["ɡū"]],
    "寡合": [["guǎ"], ["hé"]],
    "寡妻": [["guǎ"], ["qī"]],
    "挂车": [["guà"], ["chē"]],
    "寡头": [["guǎ"], ["tóu"]],
    "挂单": [["guà"], ["dān"]],
    "挂斗": [["guà"], ["dǒu"]],
    "挂冠": [["guà"], ["guān"]],
    "挂红": [["guà"], ["hóng"]],
    "挂号": [["guà"], ["hào"]],
    "挂累": [["guà"], ["lèi"]],
    "挂屏": [["guà"], ["píng"]],
    "乖觉": [["guāi"], ["jué"]],
    "挂轴": [["guà"], ["zhóu"]],
    "拐棍": [["guǎi"], ["gùn"]],
    "拐角": [["guǎi"], ["jiǎo"]],
    "怪论": [["guài"], ["lùn"]],
    "怪石": [["guài"], ["shí"]],
    "怪相": [["guài"], ["xiàng"]],
    "关节": [["guān"], ["jié"]],
    "关卡": [["guān"], ["qiǎ"]],
    "关内": [["guān"], ["nèi"]],
    "关切": [["guān"], ["qiè"]],
    "关塞": [["guān"], ["sāi"]],
    "关上": [["guān"], ["shàng"]],
    "关头": [["guān"], ["tóu"]],
    "关系": [["guān"], ["xì"]],
    "关中": [["guān"], ["zhōng"]],
    "观测": [["guān"], ["cè"]],
    "观察": [["guān"], ["chá"]],
    "观潮": [["guān"], ["cháo"]],
    "观点": [["guān"], ["diǎn"]],
    "观感": [["guān"], ["gǎn"]],
    "观风": [["guān"], ["fēng"]],
    "观光": [["guān"], ["guāng"]],
    "观火": [["guān"], ["huǒ"]],
    "观看": [["guān"], ["kàn"]],
    "观览": [["guān"], ["lǎn"]],
    "观礼": [["guān"], ["lǐ"]],
    "观摩": [["guān"], ["mó"]],
    "观念": [["guān"], ["niàn"]],
    "观赏": [["guān"], ["shǎng"]],
    "观望": [["guān"], ["wàng"]],
    "观音": [["guān"], ["yīn"]],
    "观瞻": [["guān"], ["zhān"]],
    "观战": [["guān"], ["zhàn"]],
    "观照": [["guān"], ["zhào"]],
    "观阵": [["guān"], ["zhèn"]],
    "观众": [["guān"], ["zhòng"]],
    "观止": [["guān"], ["zhǐ"]],
    "官差": [["guān"], ["chāi"]],
    "官长": [["guān"], ["zhǎng"]],
    "官场": [["guān"], ["chǎng"]],
    "官称": [["guān"], ["chēng"]],
    "官倒": [["guān"], ["dǎo"]],
    "官地": [["guān"], ["dì"]],
    "官服": [["guān"], ["fú"]],
    "官家": [["guān"], ["jiā"]],
    "官价": [["guān"], ["jià"]],
    "官校": [["guān"], ["xiào"]],
    "官能": [["guān"], ["néng"]],
    "官员": [["guān"], ["yuán"]],
    "冠盖": [["guān"], ["gài"]],
    "冠军": [["guàn"], ["jūn"]],
    "冠礼": [["guàn"], ["lǐ"]],
    "冠冕": [["guān"], ["miǎn"]],
    "冠玉": [["guān"], ["yù"]],
    "冠子": [["guàn"], ["zi"]],
    "鳏夫": [["guān"], ["fū"]],
    "管家": [["guǎn"], ["jiā"]],
    "管见": [["guǎn"], ["jiàn"]],
    "管教": [["guǎn"], ["jiào"]],
    "管乐": [["guǎn"], ["yuè"]],
    "管区": [["guǎn"], ["qū"]],
    "管片": [["guǎn"], ["piàn"]],
    "盥洗": [["guàn"], ["xǐ"]],
    "灌浆": [["guàn"], ["jiāng"]],
    "灌区": [["guàn"], ["qū"]],
    "灌渠": [["guàn"], ["qú"]],
    "灌洗": [["guàn"], ["xǐ"]],
    "光大": [["guāng"], ["dà"]],
    "光杆": [["guāng"], ["gǎn"]],
    "光度": [["guāng"], ["dù"]],
    "光棍": [["guāng"], ["gùn"]],
    "光华": [["guāng"], ["huá"]],
    "光化": [["guāng"], ["huà"]],
    "光解": [["guāng"], ["jiě"]],
    "光景": [["guāng"], ["jǐng"]],
    "光溜": [["guāng"], ["liū"]],
    "光能": [["guāng"], ["néng"]],
    "光圈": [["guāng"], ["quān"]],
    "光头": [["guāng"], ["tóu"]],
    "光纤": [["guāng"], ["xiān"]],
    "光鲜": [["guāng"], ["xiān"]],
    "光晕": [["guāng"], ["yùn"]],
    "光压": [["guāng"], ["yā"]],
    "光泽": [["guāng"], ["zé"]],
    "光栅": [["guāng"], ["shān"]],
    "咣当": [["guāng"], ["dāng"]],
    "桄榔": [["guāng"], ["láng"]],
    "广播": [["guǎng"], ["bō"]],
    "广博": [["guǎng"], ["bó"]],
    "广场": [["guǎng"], ["chǎng"]],
    "广大": [["guǎng"], ["dà"]],
    "广岛": [["guǎng"], ["dǎo"]],
    "广东": [["guǎng"], ["dōng"]],
    "广度": [["guǎng"], ["dù"]],
    "广泛": [["guǎng"], ["fàn"]],
    "广告": [["guǎng"], ["gào"]],
    "广货": [["guǎng"], ["huò"]],
    "广阔": [["guǎng"], ["kuò"]],
    "广袤": [["guǎng"], ["mào"]],
    "广漠": [["guǎng"], ["mò"]],
    "广谱": [["guǎng"], ["pǔ"]],
    "广平": [["guǎng"], ["píng"]],
    "广求": [["guǎng"], ["qiú"]],
    "广饶": [["guǎng"], ["ráo"]],
    "广西": [["guǎng"], ["xī"]],
    "广厦": [["guǎng"], ["shà"]],
    "广义": [["guǎng"], ["yì"]],
    "广远": [["guǎng"], ["yuǎn"]],
    "广众": [["guǎng"], ["zhòng"]],
    "广州": [["guǎng"], ["zhōu"]],
    "归还": [["guī"], ["huán"]],
    "归并": [["guī"], ["bìng"]],
    "归结": [["guī"], ["jié"]],
    "归化": [["guī"], ["huà"]],
    "归降": [["guī"], ["xiáng"]],
    "归宁": [["guī"], ["níng"]],
    "归期": [["guī"], ["qī"]],
    "归齐": [["guī"], ["qí"]],
    "归省": [["guī"], ["xǐng"]],
    "归宿": [["guī"], ["sù"]],
    "归隐": [["guī"], ["yǐn"]],
    "归属": [["guī"], ["shǔ"]],
    "圭角": [["guī"], ["jiǎo"]],
    "龟背": [["guī"], ["bèi"]],
    "龟板": [["guī"], ["bǎn"]],
    "龟甲": [["guī"], ["jiá"]],
    "龟鉴": [["guī"], ["jiàn"]],
    "龟裂": [["jūn"], ["liè"]],
    "龟缩": [["guī"], ["suō"]],
    "龟头": [["guī"], ["tóu"]],
    "规划": [["guī"], ["huà"]],
    "规模": [["guī"], ["mó"]],
    "规约": [["guī"], ["yuē"]],
    "规正": [["guī"], ["zhèng"]],
    "闺女": [["guī"], ["nǚ"]],
    "瑰奇": [["guī"], ["qí"]],
    "瑰丽": [["guī"], ["lì"]],
    "鲑鱼": [["guī"], ["yú"]],
    "轨度": [["guǐ"], ["dù"]],
    "诡称": [["guǐ"], ["chēng"]],
    "诡秘": [["guǐ"], ["mì"]],
    "诡奇": [["guǐ"], ["qí"]],
    "鬼混": [["guǐ"], ["hùn"]],
    "柜房": [["guì"], ["fáng"]],
    "柜橱": [["guì"], ["chú"]],
    "柜上": [["guì"], ["shàng"]],
    "柜台": [["guì"], ["tái"]],
    "柜子": [["guì"], ["zi"]],
    "贵处": [["guì"], ["chǔ"]],
    "贵妃": [["guì"], ["fēi"]],
    "贵干": [["guì"], ["gàn"]],
    "贵体": [["guì"], ["tǐ"]],
    "贵重": [["guì"], ["zhòng"]],
    "桂冠": [["guì"], ["guān"]],
    "桂枝": [["guì"], ["zhī"]],
    "跪倒": [["guì"], ["dǎo"]],
    "辊轴": [["gǔn"], ["zhóu"]],
    "滚落": [["gǔn"], ["luò"]],
    "棍棒": [["gùn"], ["bàng"]],
    "棍子": [["gùn"], ["zi"]],
    "锅底": [["guō"], ["dǐ"]],
    "锅台": [["guō"], ["tái"]],
    "国别": [["guó"], ["bié"]],
    "国仇": [["guó"], ["chóu"]],
    "国都": [["guó"], ["dū"]],
    "国度": [["guó"], ["dù"]],
    "国风": [["guó"], ["fēng"]],
    "国共": [["guó"], ["gòng"]],
    "国号": [["guó"], ["hào"]],
    "国华": [["guó"], ["huá"]],
    "国会": [["guó"], ["huì"]],
    "国家": [["guó"], ["jiā"]],
    "国教": [["guó"], ["jiào"]],
    "国乐": [["guó"], ["lè"]],
    "国脉": [["guó"], ["mài"]],
    "国内": [["guó"], ["nèi"]],
    "国术": [["guó"], ["shù"]],
    "国难": [["guó"], ["nàn"]],
    "国丧": [["guó"], ["sāng"]],
    "国帑": [["guó"], ["tǎng"]],
    "国体": [["guó"], ["tǐ"]],
    "国信": [["guó"], ["xìn"]],
    "国王": [["guó"], ["wáng"]],
    "国有": [["guó"], ["yǒu"]],
    "国语": [["guó"], ["yǔ"]],
    "果干": [["guǒ"], ["gàn"]],
    "果核": [["guǒ"], ["hé"]],
    "果枝": [["guǒ"], ["zhī"]],
    "裹挟": [["guǒ"], ["xié"]],
    "过半": [["guò"], ["bàn"]],
    "过磅": [["guò"], ["bàng"]],
    "过长": [["guò"], ["cháng"]],
    "过程": [["guò"], ["chéng"]],
    "过场": [["guò"], ["chǎng"]],
    "过秤": [["guò"], ["chèng"]],
    "过从": [["guò"], ["cóng"]],
    "过错": [["guò"], ["cuò"]],
    "过当": [["guò"], ["dāng"]],
    "过道": [["guò"], ["dào"]],
    "过电": [["guò"], ["diàn"]],
    "过冬": [["guò"], ["dōng"]],
    "过度": [["guò"], ["dù"]],
    "过渡": [["guò"], ["dù"]],
    "过多": [["guò"], ["duō"]],
    "过访": [["guò"], ["fǎng"]],
    "过房": [["guò"], ["fáng"]],
    "过费": [["guò"], ["fèi"]],
    "过分": [["guò"], ["fèn"]],
    "过份": [["guò"], ["fèn"]],
    "过付": [["guò"], ["fù"]],
    "过关": [["guò"], ["guān"]],
    "过后": [["guò"], ["hòu"]],
    "过话": [["guò"], ["huà"]],
    "过户": [["guò"], ["hù"]],
    "过活": [["guò"], ["huó"]],
    "过火": [["guò"], ["huǒ"]],
    "过激": [["guò"], ["jī"]],
    "过继": [["guò"], ["jì"]],
    "过奖": [["guò"], ["jiǎng"]],
    "过节": [["guò"], ["jié"]],
    "过劲": [["guò"], ["jìn"]],
    "过境": [["guò"], ["jìng"]],
    "过客": [["guò"], ["kè"]],
    "过来": [["guò"], ["lái"]],
    "过梁": [["guò"], ["liáng"]],
    "过礼": [["guò"], ["lǐ"]],
    "过量": [["guò"], ["liàng"]],
    "过滤": [["guò"], ["lǜ"]],
    "过路": [["guò"], ["lù"]],
    "过虑": [["guò"], ["lǜ"]],
    "过门": [["guò"], ["mén"]],
    "过敏": [["guò"], ["mǐn"]],
    "过目": [["guò"], ["mù"]],
    "过年": [["guò"], ["nián"]],
    "过期": [["guò"], ["qī"]],
    "过谦": [["guò"], ["qiān"]],
    "过桥": [["guò"], ["qiáo"]],
    "过去": [["guò"], ["qù"]],
    "过热": [["guò"], ["rè"]],
    "过筛": [["guò"], ["shāi"]],
    "过人": [["guò"], ["rén"]],
    "过剩": [["guò"], ["shèng"]],
    "过甚": [["guò"], ["shèn"]],
    "过失": [["guò"], ["shī"]],
    "过时": [["guò"], ["shí"]],
    "过世": [["guò"], ["shì"]],
    "过熟": [["guò"], ["shú"]],
    "过手": [["guò"], ["shǒu"]],
    "过堂": [["guò"], ["táng"]],
    "过厅": [["guò"], ["tīng"]],
    "过望": [["guò"], ["wàng"]],
    "过往": [["guò"], ["wǎng"]],
    "过问": [["guò"], ["wèn"]],
    "过头": [["guò"], ["tóu"]],
    "过午": [["guò"], ["wǔ"]],
    "过细": [["guò"], ["xì"]],
    "过夏": [["guò"], ["xià"]],
    "过心": [["guò"], ["xīn"]],
    "过眼": [["guò"], ["yǎn"]],
    "过氧": [["guò"], ["yǎng"]],
    "过夜": [["guò"], ["yè"]],
    "过瘾": [["guò"], ["yǐn"]],
    "过硬": [["guò"], ["yìng"]],
    "过于": [["guò"], ["yú"]],
    "过誉": [["guò"], ["yù"]],
    "过载": [["guò"], ["zài"]],
    "过早": [["guò"], ["zǎo"]],
    "过账": [["guò"], ["zhàng"]],
    "过重": [["guò"], ["zhòng"]],
    "哈达": [["hǎ"], ["dá"]],
    "哈哈": [["hā"], ["hā"]],
    "哈喇": [["hā"], ["lǎ"]],
    "哈罗": [["hā"], ["luo"]],
    "哈密": [["hā"], ["mì"]],
    "哈气": [["hā"], ["qì"]],
    "哈欠": [["hā"], ["qiàn"]],
    "哈腰": [["hā"], ["yāo"]],
    "嗨哟": [["hāi"], ["yō"]],
    "孩提": [["hái"], ["tí"]],
    "骸骨": [["hái"], ["gǔ"]],
    "海参": [["hǎi"], ["shēn"]],
    "海底": [["hǎi"], ["dǐ"]],
    "海地": [["hǎi"], ["dì"]],
    "海风": [["hǎi"], ["fēng"]],
    "海港": [["hǎi"], ["gǎng"]],
    "海龟": [["hǎi"], ["guī"]],
    "海疆": [["hǎi"], ["jiāng"]],
    "海角": [["hǎi"], ["jiǎo"]],
    "海禁": [["hǎi"], ["jìn"]],
    "海量": [["hǎi"], ["liàng"]],
    "海岭": [["hǎi"], ["lǐng"]],
    "海内": [["hǎi"], ["nèi"]],
    "海南": [["hǎi"], ["nán"]],
    "海难": [["hǎi"], ["nàn"]],
    "海扇": [["hǎi"], ["shàn"]],
    "海上": [["hǎi"], ["shàng"]],
    "海蛇": [["hǎi"], ["shé"]],
    "海苔": [["hǎi"], ["tái"]],
    "海鲜": [["hǎi"], ["xiān"]],
    "海燕": [["hǎi"], ["yàn"]],
    "海员": [["hǎi"], ["yuán"]],
    "害处": [["hài"], ["chù"]],
    "害臊": [["hài"], ["sào"]],
    "含糊": [["hán"], ["hu"]],
    "含混": [["hán"], ["hùn"]],
    "含量": [["hán"], ["liàng"]],
    "含沙": [["hán"], ["shā"]],
    "含血": [["hán"], ["xuè"]],
    "函大": [["hán"], ["dà"]],
    "含有": [["hán"], ["yǒu"]],
    "函数": [["hán"], ["shù"]],
    "寒伧": [["hán"], ["chen"]],
    "寒颤": [["hán"], ["zhàn"]],
    "寒风": [["hán"], ["fēng"]],
    "寒假": [["hán"], ["jià"]],
    "寒凉": [["hán"], ["liáng"]],
    "寒露": [["hán"], ["lù"]],
    "寒食": [["hán"], ["shí"]],
    "寒症": [["hán"], ["zhèng"]],
    "罕见": [["hǎn"], ["jiàn"]],
    "罕有": [["hǎn"], ["yǒu"]],
    "汉家": [["hàn"], ["jiā"]],
    "汉王": [["hàn"], ["wáng"]],
    "汉语": [["hàn"], ["yǔ"]],
    "汉中": [["hàn"], ["zhōng"]],
    "汗斑": [["hàn"], ["bān"]],
    "汗褂": [["hàn"], ["guà"]],
    "汗碱": [["hàn"], ["jiǎn"]],
    "汗脚": [["hàn"], ["jiǎo"]],
    "汗毛": [["hàn"], ["máo"]],
    "汗青": [["hàn"], ["qīng"]],
    "汗衫": [["hàn"], ["shān"]],
    "汗水": [["hàn"], ["shuǐ"]],
    "汗腺": [["hàn"], ["xiàn"]],
    "汗颜": [["hàn"], ["yán"]],
    "汗液": [["hàn"], ["yè"]],
    "汗珠": [["hàn"], ["zhū"]],
    "汗渍": [["hàn"], ["zì"]],
    "旱地": [["hàn"], ["dì"]],
    "悍将": [["hàn"], ["jiàng"]],
    "夯歌": [["hāng"], ["gē"]],
    "夯实": [["hāng"], ["shí"]],
    "航空": [["háng"], ["kōng"]],
    "航模": [["háng"], ["mó"]],
    "航行": [["háng"], ["xíng"]],
    "豪横": [["háo"], ["hèng"]],
    "豪华": [["háo"], ["huá"]],
    "豪强": [["háo"], ["qiáng"]],
    "豪兴": [["háo"], ["xìng"]],
    "豪雨": [["háo"], ["yǔ"]],
    "豪语": [["háo"], ["yǔ"]],
    "壕堑": [["háo"], ["qiàn"]],
    "好办": [["hǎo"], ["bàn"]],
    "好比": [["hǎo"], ["bǐ"]],
    "好辩": [["hǎo"], ["biàn"]],
    "好不": [["hǎo"], ["bù"]],
    "好吃": [["hǎo"], ["chī"]],
    "好丑": [["hǎo"], ["chǒu"]],
    "好处": [["hǎo"], ["chù"]],
    "好歹": [["hǎo"], ["dǎi"]],
    "好动": [["hào"], ["dòng"]],
    "好斗": [["hào"], ["dòu"]],
    "好多": [["hǎo"], ["duō"]],
    "好恶": [["hào"], ["wù"]],
    "好感": [["hǎo"], ["gǎn"]],
    "好儿": [["hǎo"], ["ér"]],
    "好古": [["hào"], ["gǔ"]],
    "好过": [["hǎo"], ["guò"]],
    "好汉": [["hǎo"], ["hàn"]],
    "好好": [["hǎo"], ["hǎo"]],
    "好话": [["hǎo"], ["huà"]],
    "好景": [["hǎo"], ["jǐng"]],
    "好酒": [["hǎo"], ["jiǔ"]],
    "好久": [["hǎo"], ["jiǔ"]],
    "好看": [["hǎo"], ["kàn"]],
    "好客": [["hào"], ["kè"]],
    "好赖": [["hǎo"], ["lài"]],
    "好脸": [["hǎo"], ["liǎn"]],
    "好评": [["hǎo"], ["píng"]],
    "好奇": [["hào"], ["qí"]],
    "好气": [["hǎo"], ["qì"]],
    "好强": [["hào"], ["qiáng"]],
    "好惹": [["hǎo"], ["rě"]],
    "好人": [["hǎo"], ["rén"]],
    "好色": [["hào"], ["sè"]],
    "好生": [["hǎo"], ["shēng"]],
    "好胜": [["hào"], ["shèng"]],
    "好事": [["hǎo"], ["shì"]],
    "好手": [["hǎo"], ["shǒu"]],
    "好受": [["hǎo"], ["shòu"]],
    "好书": [["hǎo"], ["shū"]],
    "好说": [["hǎo"], ["shuō"]],
    "好似": [["hǎo"], ["sì"]],
    "好听": [["hǎo"], ["tīng"]],
    "好头": [["hǎo"], ["tóu"]],
    "好玩": [["hǎo"], ["wán"]],
    "好闻": [["hǎo"], ["wén"]],
    "好戏": [["hǎo"], ["xì"]],
    "好问": [["hǎo"], ["wèn"]],
    "好象": [["hǎo"], ["xiàng"]],
    "好像": [["hǎo"], ["xiàng"]],
    "好笑": [["hǎo"], ["xiào"]],
    "好些": [["hǎo"], ["xiē"]],
    "好心": [["hǎo"], ["xīn"]],
    "好学": [["hào"], ["xué"]],
    "好言": [["hǎo"], ["yán"]],
    "好意": [["hǎo"], ["yì"]],
    "好运": [["hǎo"], ["yùn"]],
    "好在": [["hǎo"], ["zài"]],
    "好战": [["hào"], ["zhàn"]],
    "好转": [["hǎo"], ["zhuǎn"]],
    "好走": [["hǎo"], ["zǒu"]],
    "号兵": [["hào"], ["bīng"]],
    "号灯": [["hào"], ["dēng"]],
    "号称": [["hào"], ["chēng"]],
    "号角": [["hào"], ["jiǎo"]],
    "号房": [["hào"], ["fáng"]],
    "号叫": [["háo"], ["jiào"]],
    "号令": [["hào"], ["lìng"]],
    "号哭": [["hào"], ["kū"]],
    "号码": [["hào"], ["mǎ"]],
    "号脉": [["hào"], ["mài"]],
    "号牌": [["hào"], ["pái"]],
    "号炮": [["hào"], ["pào"]],
    "号丧": [["háo"], ["sāng"]],
    "号手": [["hào"], ["shǒu"]],
    "号数": [["hào"], ["shù"]],
    "号啕": [["háo"], ["táo"]],
    "号筒": [["hào"], ["tǒng"]],
    "号型": [["hào"], ["xíng"]],
    "号头": [["hào"], ["tóu"]],
    "号外": [["hào"], ["wài"]],
    "号衣": [["hào"], ["yī"]],
    "号召": [["hào"], ["zhào"]],
    "号子": [["hào"], ["zǐ"]],
    "浩大": [["hào"], ["dà"]],
    "浩繁": [["hào"], ["fán"]],
    "耗尽": [["hào"], ["jìn"]],
    "耗散": [["hào"], ["sàn"]],
    "呵叱": [["hē"], ["chì"]],
    "呵斥": [["hē"], ["chì"]],
    "呵呵": [["hē"], ["hē"]],
    "呵喝": [["hē"], ["hè"]],
    "呵护": [["hē"], ["hù"]],
    "呵欠": [["hē"], ["qiàn"]],
    "呵痒": [["hē"], ["yǎng"]],
    "呵责": [["hē"], ["zé"]],
    "喝采": [["hè"], ["cǎi"]],
    "喝彩": [["hè"], ["cǎi"]],
    "喝道": [["hè"], ["dào"]],
    "喝令": [["hè"], ["lìng"]],
    "喝水": [["hē"], ["shuǐ"]],
    "喝问": [["hè"], ["wèn"]],
    "喝醉": [["hē"], ["zuì"], [",hē"], ["zuì"], ["jiǔ"]],
    "禾场": [["hé"], ["cháng"]],
    "合办": [["hé"], ["bàn"]],
    "合抱": [["hé"], ["bào"]],
    "合璧": [["hé"], ["bì"]],
    "合编": [["hé"], ["biān"]],
    "合并": [["hé"], ["bìng"]],
    "合唱": [["hé"], ["chàng"]],
    "合成": [["hé"], ["chéng"]],
    "合当": [["hé"], ["dāng"]],
    "合度": [["hé"], ["dù"]],
    "合法": [["hé"], ["fǎ"]],
    "合肥": [["hé"], ["féi"]],
    "合缝": [["hé"], ["fèng"]],
    "合该": [["hé"], ["gāi"]],
    "合格": [["hé"], ["gé"]],
    "合共": [["hé"], ["gòng"]],
    "合股": [["hé"], ["gǔ"]],
    "合乎": [["hé"], ["hū"]],
    "合欢": [["hé"], ["huān"]],
    "合伙": [["hé"], ["huǒ"]],
    "合击": [["hé"], ["jī"]],
    "合计": [["hé"], ["jì"]],
    "合家": [["hé"], ["jiā"]],
    "合脚": [["hé"], ["jiǎo"]],
    "合刊": [["hé"], ["kān"]],
    "合金": [["hé"], ["jīn"]],
    "合口": [["hé"], ["kǒu"]],
    "合理": [["hé"], ["lǐ"]],
    "合力": [["hé"], ["lì"]],
    "合流": [["hé"], ["liú"]],
    "合龙": [["hé"], ["lóng"]],
    "合拢": [["hé"], ["lǒng"]],
    "合谋": [["hé"], ["móu"]],
    "合拍": [["hé"], ["pāi"]],
    "合浦": [["hé"], ["pǔ"]],
    "合情": [["hé"], ["qíng"]],
    "合群": [["hé"], ["qún"]],
    "合声": [["hé"], ["shēng"]],
    "合身": [["hé"], ["shēn"]],
    "合十": [["hé"], ["shí"]],
    "合时": [["hé"], ["shí"]],
    "合式": [["hé"], ["shì"]],
    "合手": [["hé"], ["shǒu"]],
    "合适": [["hé"], ["shì"]],
    "合署": [["hé"], ["shǔ"]],
    "合数": [["hé"], ["shù"]],
    "合同": [["hé"], ["tóng"]],
    "合算": [["hé"], ["suàn"]],
    "合体": [["hé"], ["tǐ"]],
    "合围": [["hé"], ["wéi"]],
    "合心": [["hé"], ["xīn"]],
    "合眼": [["hé"], ["yǎn"]],
    "合演": [["hé"], ["yǎn"]],
    "合叶": [["hé"], ["yè"]],
    "合页": [["hé"], ["yè"]],
    "合宜": [["hé"], ["yí"]],
    "合一": [["hé"], ["yī"]],
    "合议": [["hé"], ["yì"]],
    "合意": [["hé"], ["yì"]],
    "合营": [["hé"], ["yíng"]],
    "合影": [["hé"], ["yǐng"]],
    "合用": [["hé"], ["yòng"]],
    "合于": [["hé"], ["yú"]],
    "合约": [["hé"], ["yuē"]],
    "合葬": [["hé"], ["zàng"]],
    "合掌": [["hé"], ["zhǎng"]],
    "合照": [["hé"], ["zhào"]],
    "合辙": [["hé"], ["zhé"]],
    "合资": [["hé"], ["zī"]],
    "合子": [["hé"], ["zǐ"]],
    "合着": [["hé"], ["zhe"]],
    "合著": [["hé"], ["zhù"]],
    "合奏": [["hé"], ["zòu"]],
    "何必": [["hé"], ["bì"]],
    "合作": [["hé"], ["zuò"]],
    "何不": [["hé"], ["bù"]],
    "何尝": [["hé"], ["cháng"]],
    "何处": [["hé"], ["chǔ"]],
    "何等": [["hé"], ["děng"]],
    "何妨": [["hé"], ["fáng"]],
    "何干": [["hé"], ["gān"]],
    "何故": [["hé"], ["gù"]],
    "何苦": [["hé"], ["kǔ"]],
    "何况": [["hé"], ["kuàng"]],
    "何其": [["hé"], ["qí"]],
    "何日": [["hé"], ["rì"]],
    "何如": [["hé"], ["rú"]],
    "何时": [["hé"], ["shí"]],
    "何事": [["hé"], ["shì"]],
    "何谓": [["hé"], ["wèi"]],
    "何物": [["hé"], ["wù"]],
    "何须": [["hé"], ["xū"]],
    "何许": [["hé"], ["xǔ"]],
    "何以": [["hé"], ["yǐ"]],
    "何用": [["hé"], ["yòng"]],
    "何在": [["hé"], ["zài"]],
    "何曾": [["hé"], ["zēng"]],
    "何者": [["hé"], ["zhě"]],
    "何止": [["hé"], ["zhǐ"]],
    "和蔼": [["hé"], ["ǎi"]],
    "和风": [["hé"], ["fēng"]],
    "和畅": [["hé"], ["chàng"]],
    "和服": [["hé"], ["fú"]],
    "和好": [["hé"], ["hǎo"]],
    "和合": [["hé"], ["hé"]],
    "和缓": [["hé"], ["huǎn"]],
    "和会": [["hé"], ["huì"]],
    "和解": [["hé"], ["jiě"]],
    "和静": [["hé"], ["jìng"]],
    "和局": [["hé"], ["jú"]],
    "和乐": [["hé"], ["lè"]],
    "和美": [["hé"], ["měi"]],
    "和面": [["huó"], ["miàn"]],
    "和鸣": [["hé"], ["míng"]],
    "和睦": [["hé"], ["mù"]],
    "和弄": [["huò"], ["nòng"]],
    "和暖": [["hé"], ["nuǎn"]],
    "和平": [["hé"], ["píng"]],
    "和气": [["hé"], ["qì"]],
    "和棋": [["hé"], ["qí"]],
    "和洽": [["hé"], ["qià"]],
    "和亲": [["hé"], ["qīn"]],
    "和善": [["hé"], ["shàn"]],
    "和尚": [["hé"], ["shàng"]],
    "和声": [["hé"], ["shēng"]],
    "和诗": [["hè"], ["shī"]],
    "和数": [["hé"], ["shù"]],
    "和顺": [["hé"], ["shùn"]],
    "和硕": [["hé"], ["shuò"]],
    "和谈": [["hé"], ["tán"]],
    "和婉": [["hé"], ["wǎn"]],
    "和弦": [["hé"], ["xián"]],
    "和文": [["hé"], ["wén"]],
    "和协": [["hé"], ["xié"]],
    "和谐": [["hé"], ["xié"]],
    "和衣": [["hé"], ["yī"]],
    "和煦": [["hé"], ["xù"]],
    "和议": [["hé"], ["yì"]],
    "和易": [["hé"], ["yì"]],
    "和约": [["hé"], ["yuē"]],
    "和悦": [["hé"], ["yuè"]],
    "和衷": [["hé"], ["zhōng"]],
    "河蚌": [["hé"], ["bàng"]],
    "河北": [["hé"], ["běi"]],
    "河间": [["hé"], ["jiān"]],
    "河底": [["hé"], ["dǐ"]],
    "河港": [["hé"], ["gǎng"]],
    "河内": [["hé"], ["nèi"]],
    "河南": [["hé"], ["nán"]],
    "河泥": [["hé"], ["ní"]],
    "河曲": [["hé"], ["qū"]],
    "河渠": [["hé"], ["qú"]],
    "河沙": [["hé"], ["shā"]],
    "河系": [["hé"], ["xì"]],
    "河鲜": [["hé"], ["xiān"]],
    "核查": [["hé"], ["zhā"]],
    "核弹": [["hé"], ["dàn"]],
    "核定": [["hé"], ["dìng"]],
    "核对": [["hé"], ["duì"]],
    "核儿": [["hú"], ["ér"]],
    "核计": [["hé"], ["jì"]],
    "核果": [["hé"], ["guǒ"]],
    "核减": [["hé"], ["jiǎn"]],
    "核膜": [["hé"], ["mó"]],
    "核能": [["hé"], ["néng"]],
    "核仁": [["hé"], ["rén"]],
    "核实": [["hé"], ["shí"]],
    "核酸": [["hé"], ["suān"]],
    "核算": [["hé"], ["suàn"]],
    "核桃": [["hé"], ["táo"]],
    "核销": [["hé"], ["xiāo"]],
    "核心": [["hé"], ["xīn"]],
    "核验": [["hé"], ["yàn"]],
    "核准": [["hé"], ["zhǔn"]],
    "核资": [["hé"], ["zī"]],
    "核子": [["hé"], ["zǐ"]],
    "荷载": [["hè"], ["zǎi"]],
    "貉绒": [["háo"], ["róng"]],
    "貉子": [["háo"], ["zi"]],
    "贺卡": [["hè"], ["kǎ"]],
    "阖家": [["hé"], ["jiā"]],
    "贺信": [["hè"], ["xìn"]],
    "赫兹": [["hè"], ["zī"]],
    "黑车": [["hēi"], ["chē"]],
    "黑底": [["hēi"], ["dǐ"]],
    "黑地": [["hēi"], ["dì"]],
    "黑发": [["hēi"], ["fā"]],
    "黑风": [["hēi"], ["fēng"]],
    "黑红": [["hēi"], ["hóng"]],
    "黑铅": [["hēi"], ["qiān"]],
    "黑蛇": [["hēi"], ["shé"]],
    "黑体": [["hēi"], ["tǐ"]],
    "黑头": [["hēi"], ["tóu"]],
    "黑信": [["hēi"], ["xìn"]],
    "黑雨": [["hēi"], ["yǔ"]],
    "嘿嘿": [["hēi"], ["hēi"]],
    "黑种": [["hēi"], ["zhǒng"]],
    "很毒": [["hěn"], ["dú"]],
    "狠劲": [["hěn"], ["jìn"]],
    "狠毒": [["hěn"], ["dú"]],
    "恒量": [["héng"], ["liàng"]],
    "亨通": [["hēng"], ["tōng"]],
    "桁架": [["héng"], ["jià"]],
    "横暴": [["hèng"], ["bào"]],
    "横匾": [["héng"], ["biǎn"]],
    "横标": [["héng"], ["biāo"]],
    "横财": [["hèng"], ["cái"]],
    "横穿": [["héng"], ["chuān"]],
    "横渡": [["héng"], ["dù"]],
    "横笛": [["héng"], ["dí"]],
    "横断": [["héng"], ["duàn"]],
    "横额": [["héng"], ["é"]],
    "横队": [["héng"], ["duì"]],
    "横幅": [["héng"], ["fú"]],
    "横隔": [["héng"], ["gé"]],
    "横亘": [["héng"], ["gèn"]],
    "横贯": [["héng"], ["guàn"]],
    "横祸": [["hèng"], ["huò"]],
    "横过": [["héng"], ["guò"]],
    "横加": [["héng"], ["jiā"]],
    "横街": [["héng"], ["jiē"]],
    "横空": [["héng"], ["kōng"]],
    "横跨": [["héng"], ["kuà"]],
    "横梁": [["héng"], ["liáng"]],
    "横列": [["héng"], ["liè"]],
    "横木": [["héng"], ["mù"]],
    "横逆": [["hèng"], ["nì"]],
    "横蛮": [["hèng"], ["mán"]],
    "横眉": [["héng"], ["méi"]],
    "横排": [["héng"], ["pái"]],
    "横批": [["héng"], ["pī"]],
    "横披": [["héng"], ["pī"]],
    "横肉": [["héng"], ["ròu"]],
    "横扫": [["héng"], ["sǎo"]],
    "横事": [["hèng"], ["shì"]],
    "横生": [["héng"], ["shēng"]],
    "横尸": [["héng"], ["shī"]],
    "横是": [["héng"], ["shì"]],
    "横竖": [["héng"], ["shù"]],
    "横死": [["hèng"], ["sǐ"]],
    "横向": [["héng"], ["xiàng"]],
    "横心": [["héng"], ["xīn"]],
    "横行": [["héng"], ["xíng"]],
    "横越": [["héng"], ["yuè"]],
    "横溢": [["héng"], ["yì"]],
    "横遭": [["héng"], ["zāo"]],
    "横直": [["héng"], ["zhí"]],
    "衡量": [["héng"], ["liáng"]],
    "轰炸": [["hōng"], ["zhà"]],
    "哄传": [["hōng"], ["chuán"]],
    "哄动": [["hōng"], ["dòng"]],
    "哄哄": [["hǒng"], ["hǒng"]],
    "哄闹": [["hōng"], ["nào"]],
    "哄骗": [["hǒng"], ["piàn"]],
    "哄弄": [["hǒng"], ["nòng"]],
    "哄抢": [["hōng"], ["qiǎng"]],
    "哄劝": [["hǒng"], ["quàn"]],
    "哄然": [["hōng"], ["rán"]],
    "哄抬": [["hōng"], ["tái"]],
    "哄堂": [["hōng"], ["táng"]],
    "哄诱": [["hǒng"], ["yòu"]],
    "哄笑": [["hōng"], ["xiào"]],
    "烘干": [["hōng"], ["gān"]],
    "烘笼": [["hōng"], ["lóng"]],
    "弘大": [["hóng"], ["dà"]],
    "红案": [["hóng"], ["àn"]],
    "红榜": [["hóng"], ["bǎng"]],
    "红包": [["hóng"], ["bāo"]],
    "红布": [["hóng"], ["bù"]],
    "红参": [["hóng"], ["cān"]],
    "红茶": [["hóng"], ["chá"]],
    "红潮": [["hóng"], ["cháo"]],
    "红场": [["hóng"], ["chǎng"]],
    "红尘": [["hóng"], ["chén"]],
    "红虫": [["hóng"], ["chóng"]],
    "红蛋": [["hóng"], ["dàn"]],
    "红灯": [["hóng"], ["dēng"]],
    "红豆": [["hóng"], ["dòu"]],
    "红粉": [["hóng"], ["fěn"]],
    "红汞": [["hóng"], ["gǒng"]],
    "红河": [["hóng"], ["hé"]],
    "红海": [["hóng"], ["hǎi"]],
    "红花": [["hóng"], ["huā"]],
    "红红": [["hóng"], ["hóng"]],
    "红火": [["hóng"], ["huǒ"]],
    "红货": [["hóng"], ["huò"]],
    "红教": [["hóng"], ["jiào"]],
    "红军": [["hóng"], ["jūn"]],
    "红利": [["hóng"], ["lì"]],
    "红莲": [["hóng"], ["lián"]],
    "红脸": [["hóng"], ["liǎn"]],
    "红楼": [["hóng"], ["lóu"]],
    "红螺": [["hóng"], ["luó"]],
    "红棉": [["hóng"], ["mián"]],
    "红木": [["hóng"], ["mù"]],
    "红娘": [["hóng"], ["niáng"]],
    "红女": [["hóng"], ["nǚ"]],
    "红盘": [["hóng"], ["pán"]],
    "红牌": [["hóng"], ["pái"]],
    "红票": [["hóng"], ["piào"]],
    "红皮": [["hóng"], ["pí"]],
    "红旗": [["hóng"], ["qí"]],
    "红桥": [["hóng"], ["qiáo"]],
    "红曲": [["hóng"], ["qǔ"]],
    "红区": [["hóng"], ["qū"]],
    "红壤": [["hóng"], ["rǎng"]],
    "红人": [["hóng"], ["rén"]],
    "红日": [["hóng"], ["rì"]],
    "红润": [["hóng"], ["rùn"]],
    "红色": [["hóng"], ["sè"]],
    "红烧": [["hóng"], ["shāo"]],
    "红苕": [["hóng"], ["sháo"]],
    "红生": [["hóng"], ["shēng"]],
    "红薯": [["hóng"], ["shǔ"]],
    "红树": [["hóng"], ["shù"]],
    "红糖": [["hóng"], ["táng"]],
    "红桃": [["hóng"], ["táo"]],
    "红藤": [["hóng"], ["téng"]],
    "红铜": [["hóng"], ["tóng"]],
    "红土": [["hóng"], ["tǔ"]],
    "红头": [["hóng"], ["tóu"]],
    "红线": [["hóng"], ["xiàn"]],
    "红心": [["hóng"], ["xīn"]],
    "红星": [["hóng"], ["xīng"]],
    "红袖": [["hóng"], ["xiù"]],
    "红学": [["hóng"], ["xué"]],
    "红岩": [["hóng"], ["yán"]],
    "红颜": [["hóng"], ["yán"]],
    "红眼": [["hóng"], ["yǎn"]],
    "红艳": [["hóng"], ["yàn"]],
    "红衣": [["hóng"], ["yī"]],
    "红叶": [["hóng"], ["yè"]],
    "红鱼": [["hóng"], ["yú"]],
    "红玉": [["hóng"], ["yù"]],
    "红运": [["hóng"], ["yùn"]],
    "红云": [["hóng"], ["yún"]],
    "红晕": [["hóng"], ["yùn"]],
    "红枣": [["hóng"], ["zǎo"]],
    "红肿": [["hóng"], ["zhǒng"]],
    "红妆": [["hóng"], ["zhuāng"]],
    "红专": [["hóng"], ["zhuān"]],
    "红装": [["hóng"], ["zhuāng"]],
    "宏大": [["hóng"], ["dà"]],
    "宏观": [["hóng"], ["guān"]],
    "宏丽": [["hóng"], ["lì"]],
    "宏量": [["hóng"], ["liàng"]],
    "宏论": [["hóng"], ["lùn"]],
    "宏远": [["hóng"], ["yuǎn"]],
    "洪大": [["hóng"], ["dà"]],
    "洪量": [["hóng"], ["liàng"]],
    "洪泽": [["hóng"], ["zé"]],
    "鸿蒙": [["hóng"], ["méng"]],
    "鸿爪": [["hóng"], ["zhǎo"]],
    "侯爵": [["hóu"], ["jué"]],
    "侯门": [["hóu"], ["mén"]],
    "喉结": [["hóu"], ["jié"]],
    "喉头": [["hóu"], ["tóu"]],
    "猴头": [["hóu"], ["tóu"]],
    "猴王": [["hóu"], ["wáng"]],
    "猴戏": [["hóu"], ["xì"]],
    "后场": [["hòu"], ["chǎng"]],
    "后传": [["hòu"], ["chuán"]],
    "后妃": [["hòu"], ["fēi"]],
    "后父": [["hòu"], ["fù"]],
    "后劲": [["hòu"], ["jìn"]],
    "后景": [["hòu"], ["jǐng"]],
    "后凉": [["hòu"], ["liáng"]],
    "后排": [["hòu"], ["pái"]],
    "后妻": [["hòu"], ["qī"]],
    "后期": [["hòu"], ["qī"]],
    "后任": [["hòu"], ["rèn"]],
    "后台": [["hòu"], ["tái"]],
    "后头": [["hòu"], ["tou"]],
    "后燕": [["hòu"], ["yàn"]],
    "厚薄": [["hòu"], ["báo"]],
    "厚待": [["hòu"], ["dài"]],
    "厚度": [["hòu"], ["dù"]],
    "厚片": [["hòu"], ["piàn"]],
    "厚朴": [["hòu"], ["pò"]],
    "厚重": [["hòu"], ["zhòng"]],
    "候场": [["hòu"], ["chǎng"]],
    "候教": [["hòu"], ["jiào"]],
    "候车": [["hòu"], ["chē"]],
    "呼号": [["hū"], ["háo"]],
    "呼喝": [["hū"], ["hè"]],
    "呼扇": [["hū"], ["shàn"]],
    "呼应": [["hū"], ["yìng"]],
    "呼啦": [["hū"], ["lā"]],
    "呼语": [["hū"], ["yǔ"]],
    "呼吁": [["hū"], ["yù"]],
    "忽地": [["hū"], ["dì"]],
    "弧度": [["hú"], ["dù"]],
    "弧菌": [["hú"], ["jūn"]],
    "狐臭": [["hú"], ["chòu"]],
    "狐臊": [["hú"], ["sāo"]],
    "狐疑": [["hú"], ["yí"]],
    "胡同": [["hú"], ["tòng"]],
    "胡说": [["hú"], ["shuō"]],
    "湖北": [["hú"], ["běi"]],
    "湖泊": [["hú"], ["pō"]],
    "湖广": [["hú"], ["guǎng"]],
    "湖南": [["hú"], ["nán"]],
    "湖泽": [["hú"], ["zé"]],
    "糊糊": [["hū"], ["hū"]],
    "糊口": [["hú"], ["kǒu"]],
    "糊精": [["hú"], ["jīng"]],
    "糊弄": [["hù"], ["nòng"]],
    "糊涂": [["hú"], ["tú"]],
    "虎贲": [["hǔ"], ["bēn"]],
    "虎骨": [["hǔ"], ["gǔ"]],
    "虎将": [["hǔ"], ["jiàng"]],
    "虎劲": [["hǔ"], ["jìn"]],
    "虎尾": [["hǔ"], ["wěi"]],
    "互济": [["hù"], ["jì"]],
    "互见": [["hù"], ["xiàn"]],
    "互相": [["hù"], ["xiāng"]],
    "互助": [["hù"], ["zhù"]],
    "户长": [["hù"], ["cháng"]],
    "户调": [["hù"], ["diào"]],
    "户头": [["hù"], ["tóu"]],
    "护校": [["hù"], ["xiào"]],
    "护从": [["hù"], ["cóng"]],
    "戽斗": [["hù"], ["dǒu"]],
    "花被": [["huā"], ["bèi"]],
    "花车": [["huā"], ["chē"]],
    "花冠": [["huā"], ["guān"]],
    "花会": [["huā"], ["huì"]],
    "花红": [["huā"], ["hóng"]],
    "花卷": [["huā"], ["juǎn"]],
    "花露": [["huā"], ["lù"]],
    "花呢": [["huā"], ["ní"]],
    "花炮": [["huā"], ["pào"]],
    "花期": [["huā"], ["qī"]],
    "花俏": [["huā"], ["qiào"]],
    "华北": [["huá"], ["běi"]],
    "华表": [["huá"], ["biǎo"]],
    "华彩": [["huá"], ["cǎi"]],
    "华诞": [["huá"], ["dàn"]],
    "华池": [["huá"], ["chí"]],
    "华灯": [["huá"], ["dēng"]],
    "华发": [["huá"], ["fà"]],
    "华东": [["huá"], ["dōng"]],
    "华盖": [["huá"], ["gài"]],
    "华府": [["huá"], ["fǔ"]],
    "华工": [["huá"], ["gōng"]],
    "华贵": [["huá"], ["guì"]],
    "华翰": [["huá"], ["hàn"]],
    "华里": [["huá"], ["lǐ"]],
    "华丽": [["huá"], ["lì"]],
    "华美": [["huá"], ["měi"]],
    "华纳": [["huá"], ["nà"]],
    "华南": [["huá"], ["nán"]],
    "华年": [["huá"], ["nián"]],
    "华侨": [["huá"], ["qiáo"]],
    "华人": [["huá"], ["rén"]],
    "华容": [["huá"], ["róng"]],
    "华润": [["huá"], ["rùn"]],
    "华山": [["huà"], ["shān"]],
    "华佗": [["huà"], ["tuó"]],
    "华夏": [["huá"], ["xià"]],
    "华西": [["huá"], ["xī"]],
    "华严": [["huá"], ["yán"]],
    "华裔": [["huá"], ["yì"]],
    "华语": [["huá"], ["yǔ"]],
    "华章": [["huá"], ["zhāng"]],
    "华中": [["huá"], ["zhōng"]],
    "华胄": [["huá"], ["zhòu"]],
    "华族": [["huá"], ["zú"]],
    "哗变": [["huá"], ["biàn"]],
    "哗啦": [["huā"], ["lā"]],
    "哗哗": [["huā"], ["huā"]],
    "哗然": [["huá"], ["rán"]],
    "哗笑": [["huá"], ["xiào"]],
    "哗众": [["huá"], ["zhòng"]],
    "滑车": [["huá"], ["chē"]],
    "滑稽": [["huá"], ["jī"]],
    "滑溜": [["huá"], ["liū"]],
    "滑落": [["huá"], ["luò"]],
    "滑头": [["huá"], ["tóu"]],
    "滑石": [["huá"], ["shí"]],
    "滑行": [["huá"], ["xíng"]],
    "化成": [["huà"], ["chéng"]],
    "化冻": [["huà"], ["dòng"]],
    "化肥": [["huà"], ["féi"]],
    "化分": [["huà"], ["fēn"]],
    "化工": [["huà"], ["gōng"]],
    "化合": [["huà"], ["hé"]],
    "化化": [["huà"], ["huà"]],
    "化解": [["huà"], ["jiě"]],
    "化境": [["huà"], ["jìng"]],
    "化疗": [["huà"], ["liáo"]],
    "化名": [["huà"], ["míng"]],
    "化钱": [["huà"], ["qián"]],
    "化脓": [["huà"], ["nóng"]],
    "化身": [["huà"], ["shēn"]],
    "化生": [["huà"], ["shēng"]],
    "化石": [["huà"], ["shí"]],
    "化痰": [["huà"], ["tán"]],
    "化外": [["huà"], ["wài"]],
    "化纤": [["huà"], ["xiān"]],
    "化学": [["huà"], ["xué"]],
    "化验": [["huà"], ["yàn"]],
    "化缘": [["huà"], ["yuán"]],
    "化斋": [["huà"], ["zhāi"]],
    "化妆": [["huà"], ["zhuāng"]],
    "化装": [["huà"], ["zhuāng"]],
    "化作": [["huà"], ["zuò"]],
    "划拨": [["huà"], ["bō"]],
    "划船": [["huá"], ["chuán"]],
    "划定": [["huà"], ["dìng"]],
    "划分": [["huà"], ["fēn"]],
    "划归": [["huà"], ["guī"]],
    "划过": [["huá"], ["guò"]],
    "划划": [["huá"], ["huá"]],
    "划价": [["huà"], ["jià"]],
    "划桨": [["huá"], ["jiǎng"]],
    "划拉": [["huá"], ["lā"]],
    "划清": [["huà"], ["qīng"]],
    "划拳": [["huá"], ["quán"]],
    "划算": [["huá"], ["suàn"]],
    "划艇": [["huá"], ["tǐng"]],
    "划线": [["huà"], ["xiàn"]],
    "划行": [["huá"], ["xíng"]],
    "划一": [["huà"], ["yī"]],
    "划子": [["huá"], ["zǐ"]],
    "画夹": [["huà"], ["jiā"]],
    "画家": [["huà"], ["jiā"]],
    "画卷": [["huà"], ["juàn"]],
    "画论": [["huà"], ["lùn"]],
    "画片": [["huà"], ["piān"]],
    "画屏": [["huà"], ["píng"]],
    "画帖": [["huà"], ["tiè"]],
    "画轴": [["huà"], ["zhóu"]],
    "话别": [["huà"], ["bié"]],
    "话头": [["huà"], ["tóu"]],
    "话说": [["huà"], ["shuō"]],
    "话语": [["huà"], ["yǔ"]],
    "怀化": [["huái"], ["huà"]],
    "怀疑": [["huái"], ["yí"]],
    "怀远": [["huái"], ["yuǎn"]],
    "坏处": [["huài"], ["chù"]],
    "踝骨": [["huái"], ["gǔ"]],
    "坏蛋": [["huài"], ["dàn"]],
    "坏话": [["huài"], ["huà"]],
    "坏人": [["huài"], ["rén"]],
    "坏事": [["huài"], ["shì"]],
    "坏水": [["huài"], ["shuǐ"]],
    "坏死": [["huài"], ["sǐ"]],
    "欢场": [["huān"], ["chǎng"]],
    "坏种": [["huài"], ["zhǒng"]],
    "欢度": [["huān"], ["dù"]],
    "欢好": [["huān"], ["hǎo"]],
    "欢乐": [["huān"], ["lè"]],
    "欢愉": [["huān"], ["yú"]],
    "还报": [["hái"], ["bào"]],
    "还本": [["huán"], ["běn"]],
    "还好": [["hái"], ["hǎo"]],
    "还击": [["huán"], ["jī"]],
    "还魂": [["huán"], ["hún"]],
    "还价": [["huán"], ["jià"]],
    "还口": [["huán"], ["kǒu"]],
    "还款": [["hái"], ["kuǎn"]],
    "还清": [["huán"], ["qīng"]],
    "还礼": [["huán"], ["lǐ"]],
    "还情": [["hái"], ["qíng"]],
    "还是": [["hái"], ["shì"]],
    "还手": [["huán"], ["shǒu"]],
    "还俗": [["huán"], ["sú"]],
    "还田": [["hái"], ["tián"]],
    "还席": [["huán"], ["xí"]],
    "还乡": [["huán"], ["xiāng"]],
    "还阳": [["huán"], ["yáng"]],
    "还原": [["huán"], ["yuán"]],
    "还愿": [["huán"], ["yuàn"]],
    "还债": [["huán"], ["zhài"]],
    "还帐": [["hái"], ["zhàng"]],
    "还账": [["huán"], ["zhàng"]],
    "还政": [["hái"], ["zhèng"]],
    "还嘴": [["huán"], ["zuǐ"]],
    "环合": [["huán"], ["hé"]],
    "环节": [["huán"], ["jié"]],
    "环食": [["huán"], ["shí"]],
    "环伺": [["huán"], ["sì"]],
    "环行": [["huán"], ["xíng"]],
    "环中": [["huán"], ["zhōng"]],
    "缓冲": [["huǎn"], ["chōng"]],
    "缓和": [["huǎn"], ["hé"]],
    "缓解": [["huǎn"], ["jiě"]],
    "缓期": [["huǎn"], ["qī"]],
    "缓行": [["huǎn"], ["xíng"]],
    "幻化": [["huàn"], ["huà"]],
    "幻景": [["huàn"], ["jǐng"]],
    "幻觉": [["huàn"], ["jué"]],
    "幻术": [["huàn"], ["shù"]],
    "唤头": [["huàn"], ["tou"]],
    "幻数": [["huàn"], ["shù"]],
    "换亲": [["huàn"], ["qīn"]],
    "换帖": [["huàn"], ["tiě"]],
    "换洗": [["huàn"], ["xǐ"]],
    "换约": [["huàn"], ["yuē"]],
    "涣散": [["huàn"], ["sàn"]],
    "荒地": [["huāng"], ["dì"]],
    "荒凉": [["huāng"], ["liáng"]],
    "荒落": [["huāng"], ["luò"]],
    "皇朝": [["huáng"], ["cháo"]],
    "皇妃": [["huáng"], ["fēi"]],
    "皇家": [["huáng"], ["jiā"]],
    "皇冠": [["huáng"], ["guān"]],
    "皇上": [["huáng"], ["shàng"]],
    "皇亲": [["huáng"], ["qīn"]],
    "黄泥": [["huáng"], ["ní"]],
    "黄雀": [["huáng"], ["què"]],
    "黄沙": [["huáng"], ["shā"]],
    "黄石": [["huáng"], ["shí"]],
    "黄羊": [["huáng"], ["yáng"]],
    "黄叶": [["huáng"], ["yè"]],
    "恍若": [["huǎng"], ["ruò"]],
    "晃荡": [["huàng"], ["dàng"]],
    "晃动": [["huàng"], ["dòng"]],
    "晃眼": [["huǎng"], ["yǎn"]],
    "晃晃": [["huàng"], ["huǎng"]],
    "晃摇": [["huàng"], ["yáo"]],
    "晃悠": [["huàng"], ["yōu"]],
    "灰分": [["huī"], ["fēn"]],
    "灰化": [["huī"], ["huà"]],
    "灰浆": [["huī"], ["jiāng"]],
    "灰沙": [["huī"], ["shā"]],
    "挥发": [["huī"], ["fā"]],
    "挥洒": [["huī"], ["sǎ"]],
    "徽调": [["huī"], ["diào"]],
    "辉石": [["huī"], ["shí"]],
    "徽号": [["huī"], ["hào"]],
    "回车": [["huí"], ["chē"]],
    "回采": [["huí"], ["cǎi"]],
    "回答": [["huí"], ["dá"]],
    "回单": [["huí"], ["dān"]],
    "回弹": [["huí"], ["tán"]],
    "回纥": [["huí"], ["hé"]],
    "回风": [["huí"], ["fēng"]],
    "回合": [["huí"], ["hé"]],
    "回还": [["huí"], ["huán"]],
    "回见": [["huí"], ["jiàn"]],
    "回教": [["huí"], ["jiào"]],
    "回笼": [["huí"], ["lóng"]],
    "回空": [["huí"], ["kōng"]],
    "回落": [["huí"], ["luò"]],
    "回填": [["huí"], ["tián"]],
    "回条": [["huí"], ["tiáo"]],
    "回帖": [["huí"], ["tiē"]],
    "回头": [["huí"], ["tóu"]],
    "回旋": [["huí"], ["xuán"]],
    "回信": [["huí"], ["xìn"]],
    "回应": [["huí"], ["yìng"]],
    "回转": [["huí"], ["zhuǎn"]],
    "回涨": [["huí"], ["zhǎng"]],
    "悔过": [["huǐ"], ["guò"]],
    "汇兑": [["huì"], ["duì"]],
    "汇合": [["huì"], ["hé"]],
    "汇价": [["huì"], ["jià"]],
    "汇率": [["huì"], ["lǜ"]],
    "汇票": [["huì"], ["piào"]],
    "会报": [["huì"], ["bào"]],
    "会餐": [["huì"], ["cān"]],
    "会标": [["huì"], ["biāo"]],
    "会操": [["huì"], ["cāo"]],
    "会长": [["huì"], ["cháng"]],
    "会昌": [["huì"], ["chāng"]],
    "会钞": [["huì"], ["chāo"]],
    "会场": [["huì"], ["chǎng"]],
    "会车": [["huì"], ["chē"]],
    "会党": [["huì"], ["dǎng"]],
    "会典": [["huì"], ["diǎn"]],
    "会儿": [["huì"], ["er"]],
    "会费": [["huì"], ["fèi"]],
    "会风": [["huì"], ["fēng"]],
    "会馆": [["huì"], ["guǎn"]],
    "会合": [["huì"], ["hé"]],
    "会话": [["huì"], ["huà"]],
    "会徽": [["huì"], ["huī"]],
    "会集": [["huì"], ["jí"]],
    "会籍": [["huì"], ["jí"]],
    "会计": [["kuài"], ["jì"]],
    "会见": [["huì"], ["jiàn"]],
    "会剿": [["huì"], ["jiǎo"]],
    "会聚": [["huì"], ["jù"]],
    "会刊": [["huì"], ["kān"]],
    "会考": [["huì"], ["kǎo"]],
    "会客": [["huì"], ["kè"]],
    "会理": [["huì"], ["lǐ"]],
    "会面": [["huì"], ["miàn"]],
    "会宁": [["huì"], ["níng"]],
    "会齐": [["huì"], ["qí"]],
    "会期": [["huì"], ["qī"]],
    "会签": [["huì"], ["qiān"]],
    "会商": [["huì"], ["shāng"]],
    "会上": [["huì"], ["shàng"]],
    "会社": [["huì"], ["shè"]],
    "会审": [["huì"], ["shěn"]],
    "会师": [["huì"], ["shī"]],
    "会试": [["huì"], ["shì"]],
    "会水": [["huì"], ["shuǐ"]],
    "会首": [["huì"], ["shǒu"]],
    "会所": [["huì"], ["suǒ"]],
    "会谈": [["huì"], ["tán"]],
    "会堂": [["huì"], ["táng"]],
    "会通": [["huì"], ["tōng"]],
    "会同": [["huì"], ["tóng"]],
    "会务": [["huì"], ["wù"]],
    "会晤": [["huì"], ["wù"]],
    "会演": [["huì"], ["yǎn"]],
    "会心": [["huì"], ["xīn"]],
    "会厌": [["huì"], ["yàn"]],
    "会议": [["huì"], ["yì"]],
    "会阴": [["huì"], ["yīn"]],
    "会友": [["huì"], ["yǒu"]],
    "会意": [["huì"], ["yì"]],
    "会元": [["huì"], ["yuán"]],
    "会员": [["huì"], ["yuán"]],
    "会战": [["huì"], ["zhàn"]],
    "会章": [["huì"], ["zhāng"]],
    "会账": [["huì"], ["zhàng"]],
    "会诊": [["huì"], ["zhěn"]],
    "会址": [["huì"], ["zhǐ"]],
    "会众": [["huì"], ["zhòng"]],
    "惠风": [["huì"], ["fēng"]],
    "毁坏": [["huǐ"], ["huài"]],
    "毁约": [["huǐ"], ["yuē"]],
    "昏晕": [["hūn"], ["yūn"]],
    "浑家": [["hún"], ["jiā"]],
    "浑朴": [["hún"], ["piáo"]],
    "浑似": [["hún"], ["sì"]],
    "诨号": [["hùn"], ["hào"]],
    "混饭": [["hùn"], ["fàn"]],
    "混和": [["hùn"], ["hé"]],
    "混混": [["hùn"], ["hùn"]],
    "混血": [["hùn"], ["xuè"]],
    "混帐": [["hùn"], ["zhàng"]],
    "混子": [["hùn"], ["zǐ"]],
    "豁出": [["huō"], ["chū"]],
    "豁口": [["huō"], ["kǒu"]],
    "豁达": [["huò"], ["dá"]],
    "豁朗": [["huò"], ["lǎng"]],
    "豁亮": [["huò"], ["liàng"]],
    "豁免": [["huò"], ["miǎn"]],
    "豁拳": [["huó"], ["quán"]],
    "豁子": [["huō"], ["zǐ"]],
    "豁然": [["huò"], ["rán"]],
    "豁嘴": [["huō"], ["zuǐ"]],
    "活便": [["huó"], ["biàn"]],
    "活分": [["huó"], ["fēn"]],
    "活佛": [["huó"], ["fó"]],
    "活化": [["huó"], ["huà"]],
    "活结": [["huó"], ["jié"]],
    "活络": [["huó"], ["luò"]],
    "活期": [["huó"], ["qī"]],
    "活埋": [["huó"], ["mái"]],
    "活塞": [["huó"], ["sāi"]],
    "活食": [["huó"], ["shí"]],
    "活似": [["huó"], ["sì"]],
    "活体": [["huó"], ["tǐ"]],
    "活着": [["huó"], ["zhe"]],
    "活血": [["huó"], ["xuè"]],
    "火把": [["huǒ"], ["bǎ"]],
    "火并": [["huǒ"], ["bìng"]],
    "火场": [["huǒ"], ["chǎng"]],
    "火车": [["huǒ"], ["chē"]],
    "火夫": [["huǒ"], ["fū"]],
    "火红": [["huǒ"], ["hóng"]],
    "火化": [["huǒ"], ["huà"]],
    "火笼": [["huǒ"], ["lóng"]],
    "火炮": [["huǒ"], ["pào"]],
    "火捻": [["huǒ"], ["niǎn"]],
    "火石": [["huǒ"], ["shí"]],
    "火头": [["huǒ"], ["tóu"]],
    "火种": [["huǒ"], ["zhǒng"]],
    "伙夫": [["huǒ"], ["fū"]],
    "伙食": [["huǒ"], ["shí"]],
    "伙同": [["huǒ"], ["tóng"]],
    "或体": [["huò"], ["tǐ"]],
    "或许": [["huò"], ["xǔ"]],
    "货场": [["huò"], ["chǎng"]],
    "货车": [["huò"], ["chē"]],
    "货单": [["huò"], ["dān"]],
    "货柜": [["huò"], ["guì"]],
    "货价": [["huò"], ["jià"]],
    "货郎": [["huò"], ["láng"]],
    "货票": [["huò"], ["piào"]],
    "货殖": [["huò"], ["zhí"]],
    "获得": [["huò"], ["dé"]],
    "获知": [["huò"], ["zhī"]],
    "霍地": [["huò"], ["dì"]],
    "讥嘲": [["jī"], ["cháo"]],
    "讥刺": [["jī"], ["cì"]],
    "击打": [["jī"], ["dǎ"]],
    "击发": [["jī"], ["fā"]],
    "击节": [["jī"], ["jié"]],
    "击溃": [["jī"], ["kuì"]],
    "击落": [["jī"], ["luò"]],
    "击中": [["jī"], ["zhòng"]],
    "机长": [["jī"], ["zhǎng"]],
    "机场": [["jī"], ["chǎng"]],
    "机车": [["jī"], ["chē"]],
    "机化": [["jī"], ["huà"]],
    "机会": [["jī"], ["huì"]],
    "机降": [["jī"], ["jiàng"]],
    "机能": [["jī"], ["néng"]],
    "机体": [["jī"], ["tǐ"]],
    "机要": [["jī"], ["yào"]],
    "机织": [["jī"], ["zhī"]],
    "机轴": [["jī"], ["zhóu"]],
    "肌骨": [["jī"], ["gǔ"]],
    "肌体": [["jī"], ["tǐ"]],
    "鸡冠": [["jī"], ["guān"]],
    "鸡丁": [["jī"], ["dīng"]],
    "鸡肋": [["jī"], ["lèi"]],
    "鸡笼": [["jī"], ["lóng"]],
    "鸡头": [["jī"], ["tóu"]],
    "迹地": [["jì"], ["dì"]],
    "积分": [["jī"], ["fēn"]],
    "积累": [["jī"], ["lěi"]],
    "积压": [["jī"], ["yā"]],
    "积食": [["jī"], ["shí"]],
    "积数": [["jī"], ["shù"]],
    "积雨": [["jī"], ["yǔ"]],
    "积攒": [["jī"], ["zǎn"]],
    "缉捕": [["jī"], ["bǔ"]],
    "犄角": [["jī"], ["jiǎo"]],
    "缉查": [["jī"], ["zhā"]],
    "缉获": [["jī"], ["huò"]],
    "缉拿": [["jī"], ["ná"]],
    "缉凶": [["jī"], ["xiōng"]],
    "缉私": [["jī"], ["sī"]],
    "箕斗": [["jī"], ["dòu"]],
    "稽查": [["jī"], ["zhā"]],
    "稽察": [["jī"], ["chá"]],
    "稽核": [["jī"], ["hé"]],
    "稽考": [["jī"], ["kǎo"]],
    "稽留": [["jī"], ["liú"]],
    "稽首": [["qǐ"], ["shǒu"]],
    "稽征": [["jī"], ["zhēng"]],
    "稽延": [["jī"], ["yán"]],
    "激发": [["jī"], ["fā"]],
    "激化": [["jī"], ["huà"]],
    "激将": [["jī"], ["jiàng"]],
    "激切": [["jī"], ["qiè"]],
    "吉期": [["jí"], ["qī"]],
    "级别": [["jí"], ["bié"]],
    "级差": [["jí"], ["chà"]],
    "级任": [["jí"], ["rèn"]],
    "级数": [["jí"], ["shù"]],
    "即便": [["jí"], ["biàn"]],
    "即将": [["jí"], ["jiāng"]],
    "即景": [["jí"], ["jǐng"]],
    "即令": [["jí"], ["lìng"]],
    "即期": [["jí"], ["qī"]],
    "即若": [["jí"], ["ruò"]],
    "即兴": [["jí"], ["xìng"]],
    "即行": [["jí"], ["xíng"]],
    "极大": [["jí"], ["dà"]],
    "极地": [["jí"], ["dì"]],
    "极度": [["jí"], ["dù"]],
    "极恶": [["jí"], ["è"]],
    "极好": [["jí"], ["hǎo"]],
    "极化": [["jí"], ["huà"]],
    "极乐": [["jí"], ["lè"]],
    "极量": [["jí"], ["liàng"]],
    "极其": [["jí"], ["qí"]],
    "极圈": [["jí"], ["quān"]],
    "极为": [["jí"], ["wéi"]],
    "极盛": [["jí"], ["shèng"]],
    "亟亟": [["jí"], ["jí"]],
    "急风": [["jí"], ["fēng"]],
    "急难": [["jí"], ["nàn"]],
    "急迫": [["jí"], ["pò"]],
    "急切": [["jí"], ["qiè"]],
    "急要": [["jí"], ["yào"]],
    "疾风": [["jí"], ["fēng"]],
    "急转": [["jí"], ["zhuǎn"]],
    "疾行": [["jí"], ["xíng"]],
    "棘刺": [["jí"], ["cì"]],
    "集合": [["jí"], ["hé"]],
    "集会": [["jí"], ["huì"]],
    "集结": [["jí"], ["jié"]],
    "集宁": [["jí"], ["níng"]],
    "集散": [["jí"], ["sàn"]],
    "集体": [["jí"], ["tǐ"]],
    "集约": [["jí"], ["yuē"]],
    "集中": [["jí"], ["zhōng"]],
    "辑佚": [["jí"], ["yì"]],
    "辑要": [["jí"], ["yào"]],
    "瘠薄": [["jí"], ["báo"]],
    "籍没": [["jí"], ["mò"]],
    "几案": [["jī"], ["àn"]],
    "几多": [["jǐ"], ["duō"]],
    "几儿": [["jǐ"], ["ér"]],
    "几分": [["jǐ"], ["fēn"]],
    "几个": [["jǐ"], ["gè"]],
    "几何": [["jǐ"], ["hé"]],
    "几乎": [["jī"], ["hū"]],
    "几率": [["jī"], ["lǜ"]],
    "几经": [["jǐ"], ["jīng"]],
    "几时": [["jǐ"], ["shí"]],
    "几微": [["jī"], ["wēi"]],
    "几希": [["jī"], ["xī"]],
    "几样": [["jǐ"], ["yàng"]],
    "几许": [["jǐ"], ["xǔ"]],
    "几曾": [["jǐ"], ["zēng"]],
    "几至": [["jī"], ["zhì"]],
    "己任": [["jǐ"], ["rèn"]],
    "己见": [["jǐ"], ["jiàn"]],
    "挤兑": [["jǐ"], ["duì"]],
    "挤落": [["jǐ"], ["luò"]],
    "挤压": [["jǐ"], ["yā"]],
    "挤占": [["jǐ"], ["zhàn"]],
    "脊背": [["jǐ"], ["bèi"]],
    "脊骨": [["jǐ"], ["gǔ"]],
    "脊椎": [["jǐ"], ["zhuī"]],
    "记仇": [["jì"], ["chóu"]],
    "记得": [["jì"], ["de"]],
    "记分": [["jì"], ["fēn"]],
    "记过": [["jì"], ["guò"]],
    "记号": [["jì"], ["hào"]],
    "记要": [["jì"], ["yào"]],
    "记载": [["jì"], ["zǎi"]],
    "伎俩": [["jì"], ["liǎng"]],
    "纪纲": [["jì"], ["gāng"]],
    "纪检": [["jì"], ["jiǎn"]],
    "纪录": [["jì"], ["lù"]],
    "纪律": [["jì"], ["lǜ"]],
    "纪年": [["jì"], ["nián"]],
    "纪念": [["jì"], ["niàn"]],
    "纪实": [["jì"], ["shí"]],
    "纪事": [["jì"], ["shì"]],
    "纪委": [["jì"], ["wěi"]],
    "纪行": [["jì"], ["xíng"]],
    "纪要": [["jì"], ["yào"]],
    "纪元": [["jì"], ["yuán"]],
    "妓女": [["jì"], ["nǚ"]],
    "忌惮": [["jì"], ["dàn"]],
    "忌食": [["jì"], ["shí"]],
    "技能": [["jì"], ["néng"]],
    "技术": [["jì"], ["shù"]],
    "际会": [["jì"], ["huì"]],
    "剂量": [["jì"], ["liàng"]],
    "季度": [["jì"], ["dù"]],
    "季父": [["jì"], ["fù"]],
    "季风": [["jì"], ["fēng"]],
    "季节": [["jì"], ["jié"]],
    "济公": [["jì"], ["gōng"]],
    "济济": [["jì"], ["jì"]],
    "济南": [["jǐ"], ["nán"]],
    "济贫": [["jì"], ["pín"]],
    "济世": [["jì"], ["shì"]],
    "济事": [["jì"], ["shì"]],
    "济私": [["jì"], ["sī"]],
    "济助": [["jì"], ["zhù"]],
    "继父": [["jì"], ["fù"]],
    "继任": [["jì"], ["rèn"]],
    "偈语": [["jì"], ["yǔ"]],
    "祭品": [["jì"], ["pǐn"]],
    "加车": [["jiā"], ["chē"]],
    "加盖": [["jiā"], ["gài"]],
    "加号": [["jiā"], ["hào"]],
    "加价": [["jiā"], ["jià"]],
    "加劲": [["jiā"], ["jìn"]],
    "加强": [["jiā"], ["qiáng"]],
    "加数": [["jiā"], ["shù"]],
    "加压": [["jiā"], ["yā"]],
    "加重": [["jiā"], ["zhòng"]],
    "夹袄": [["jiá"], ["ǎo"]],
    "夹板": [["jiā"], ["bǎn"]],
    "夹被": [["jiá"], ["bèi"]],
    "夹层": [["jiā"], ["céng"]],
    "夹持": [["jiā"], ["chí"]],
    "夹带": [["jiā"], ["dài"]],
    "夹道": [["jiā"], ["dào"]],
    "夹缝": [["jiā"], ["fèng"]],
    "夹攻": [["jiā"], ["gōng"]],
    "夹棍": [["jiā"], ["gùn"]],
    "夹击": [["jiā"], ["jī"]],
    "夹剪": [["jiā"], ["jiǎn"]],
    "夹角": [["jiā"], ["jiǎo"]],
    "夹紧": [["jiā"], ["jǐn"]],
    "夹具": [["jiā"], ["jù"]],
    "夹批": [["jiā"], ["pī"]],
    "夹克": [["jiá"], ["kè"]],
    "夹钳": [["jiā"], ["qián"]],
    "夹墙": [["jiā"], ["qiáng"]],
    "夹生": [["jiā"], ["shēng"]],
    "夹馅": [["jiā"], ["xiàn"]],
    "夹衣": [["jiá"], ["yī"]],
    "夹心": [["jiā"], ["xīn"]],
    "夹杂": [["jiā"], ["zá"]],
    "夹峙": [["jiā"], ["zhì"]],
    "夹子": [["jiā"], ["zi"]],
    "佳节": [["jiā"], ["jié"]],
    "夹注": [["jiā"], ["zhù"]],
    "佳句": [["jiā"], ["jù"]],
    "佳丽": [["jiā"], ["lì"]],
    "佳期": [["jiā"], ["qī"]],
    "家财": [["jiā"], ["cái"]],
    "家蚕": [["jiā"], ["cán"]],
    "家产": [["jiā"], ["chǎn"]],
    "家长": [["jiā"], ["zhǎng"]],
    "家常": [["jiā"], ["cháng"]],
    "家臣": [["jiā"], ["chén"]],
    "家仇": [["jiā"], ["chóu"]],
    "家丑": [["jiā"], ["chǒu"]],
    "家传": [["jiā"], ["chuán"]],
    "家慈": [["jiā"], ["cí"]],
    "家祠": [["jiā"], ["cí"]],
    "家道": [["jiā"], ["dào"]],
    "家当": [["jiā"], ["dàng"]],
    "家底": [["jiā"], ["dǐ"]],
    "家弟": [["jiā"], ["dì"]],
    "家电": [["jiā"], ["diàn"]],
    "家法": [["jiā"], ["fǎ"]],
    "家丁": [["jiā"], ["dīng"]],
    "家访": [["jiā"], ["fǎng"]],
    "家风": [["jiā"], ["fēng"]],
    "家父": [["jiā"], ["fù"]],
    "家鸽": [["jiā"], ["gē"]],
    "家姑": [["jiā"], ["gū"]],
    "家规": [["jiā"], ["guī"]],
    "家伙": [["jiā"], ["huo"]],
    "家鸡": [["jiā"], ["jī"]],
    "家祭": [["jiā"], ["jì"]],
    "家计": [["jiā"], ["jì"]],
    "家家": [["jiā"], ["jiā"]],
    "家教": [["jiā"], ["jiào"]],
    "家景": [["jiā"], ["jǐng"]],
    "家境": [["jiā"], ["jìng"]],
    "家居": [["jiā"], ["jū"]],
    "家具": [["jiā"], ["jù"]],
    "家俱": [["jiā"], ["jù"]],
    "家眷": [["jiā"], ["juàn"]],
    "家口": [["jiā"], ["kǒu"]],
    "家累": [["jiā"], ["lěi"]],
    "家里": [["jiā"], ["lǐ"]],
    "家门": [["jiā"], ["mén"]],
    "家母": [["jiā"], ["mǔ"]],
    "家酿": [["jiā"], ["niàng"]],
    "家奴": [["jiā"], ["nú"]],
    "家仆": [["jiā"], ["pú"]],
    "家谱": [["jiā"], ["pǔ"]],
    "家禽": [["jiā"], ["qín"]],
    "家雀": [["jiā"], ["qiǎo"]],
    "家人": [["jiā"], ["rén"]],
    "家什": [["jiā"], ["shí"]],
    "家史": [["jiā"], ["shǐ"]],
    "家世": [["jiā"], ["shì"]],
    "家事": [["jiā"], ["shì"]],
    "家室": [["jiā"], ["shì"]],
    "家塾": [["jiā"], ["shú"]],
    "家鼠": [["jiā"], ["shǔ"]],
    "家书": [["jiā"], ["shū"]],
    "家私": [["jiā"], ["sī"]],
    "家庭": [["jiā"], ["tíng"]],
    "家童": [["jiā"], ["tóng"]],
    "家兔": [["jiā"], ["tù"]],
    "家翁": [["jiā"], ["wēng"]],
    "家务": [["jiā"], ["wù"]],
    "家系": [["jiā"], ["xì"]],
    "家乡": [["jiā"], ["xiāng"]],
    "家小": [["jiā"], ["xiǎo"]],
    "家信": [["jiā"], ["xìn"]],
    "家兄": [["jiā"], ["xiōng"]],
    "家学": [["jiā"], ["xué"]],
    "家训": [["jiā"], ["xùn"]],
    "家严": [["jiā"], ["yán"]],
    "家宴": [["jiā"], ["yàn"]],
    "家畜": [["jiā"], ["chù"]],
    "家养": [["jiā"], ["yǎng"]],
    "家燕": [["jiā"], ["yàn"]],
    "家业": [["jiā"], ["yè"]],
    "家蝇": [["jiā"], ["yíng"]],
    "家用": [["jiā"], ["yòng"]],
    "家园": [["jiā"], ["yuán"]],
    "家院": [["jiā"], ["yuàn"]],
    "家贼": [["jiā"], ["zéi"]],
    "家珍": [["jiā"], ["zhēn"]],
    "家宅": [["jiā"], ["zhái"]],
    "家政": [["jiā"], ["zhèng"]],
    "家种": [["jiā"], ["zhòng"]],
    "家属": [["jiā"], ["shǔ"]],
    "家资": [["jiā"], ["zī"]],
    "家姊": [["jiā"], ["zǐ"]],
    "家族": [["jiā"], ["zú"]],
    "嘉许": [["jiā"], ["xǔ"]],
    "嘉应": [["jiā"], ["yìng"]],
    "岬角": [["jiǎ"], ["jiǎo"]],
    "颊车": [["jiá"], ["chē"]],
    "颊囊": [["jiá"], ["náng"]],
    "甲骨": [["jiǎ"], ["gǔ"]],
    "甲壳": [["jiǎ"], ["qiào"]],
    "贾祸": [["gǔ"], ["huò"]],
    "贾人": [["gǔ"], ["rén"]],
    "价格": [["jià"], ["gé"]],
    "价码": [["jià"], ["mǎ"]],
    "价目": [["jià"], ["mù"]],
    "价钱": [["jià"], ["qián"]],
    "价值": [["jià"], ["zhí"]],
    "驾车": [["jià"], ["chē"]],
    "架空": [["jià"], ["kōng"]],
    "假道": [["jiǎ"], ["dào"]],
    "假话": [["jiǎ"], ["huà"]],
    "假髻": [["jiǎ"], ["jì"]],
    "假面": [["jiǎ"], ["miàn"]],
    "假言": [["jiǎ"], ["yán"]],
    "假植": [["jiǎ"], ["zhí"]],
    "奸恶": [["jiān"], ["è"]],
    "奸夫": [["jiān"], ["fū"]],
    "奸邪": [["jiān"], ["xié"]],
    "尖头": [["jiān"], ["tóu"]],
    "尖削": [["jiān"], ["xiāo"]],
    "坚称": [["jiān"], ["chēng"]],
    "坚强": [["jiān"], ["qiáng"]],
    "坚信": [["jiān"], ["xìn"]],
    "间谍": [["jiàn"], ["dié"]],
    "间断": [["jiàn"], ["duàn"]],
    "间隔": [["jiàn"], ["gé"]],
    "间或": [["jiàn"], ["huò"]],
    "间架": [["jiān"], ["jià"]],
    "间接": [["jiàn"], ["jiē"]],
    "间距": [["jiān"], ["jù"]],
    "间量": [["jiān"], ["liàng"]],
    "间苗": [["jiàn"], ["miáo"]],
    "间色": [["jiàn"], ["sè"]],
    "间隙": [["jiàn"], ["xì"]],
    "间歇": [["jiàn"], ["xiē"]],
    "间种": [["jiàn"], ["zhòng"]],
    "间奏": [["jiàn"], ["zòu"]],
    "间作": [["jiàn"], ["zuò"]],
    "肩背": [["jiān"], ["bèi"]],
    "肩头": [["jiān"], ["tóu"]],
    "肩挑": [["jiān"], ["tiāo"]],
    "艰难": [["jiān"], ["nán"]],
    "兼并": [["jiān"], ["bìng"]],
    "兼差": [["jiān"], ["chāi"]],
    "兼任": [["jiān"], ["rèn"]],
    "监测": [["jiān"], ["cè"]],
    "监察": [["jiān"], ["chá"]],
    "监场": [["jiān"], ["chǎng"]],
    "监督": [["jiān"], ["dū"]],
    "监犯": [["jiān"], ["fàn"]],
    "监房": [["jiān"], ["fáng"]],
    "监工": [["jiān"], ["gōng"]],
    "监管": [["jiān"], ["guǎn"]],
    "监规": [["jiān"], ["guī"]],
    "监护": [["jiān"], ["hù"]],
    "监禁": [["jiān"], ["jìn"]],
    "监考": [["jiān"], ["kǎo"]],
    "监控": [["jiān"], ["kòng"]],
    "监牢": [["jiān"], ["láo"]],
    "监理": [["jiān"], ["lǐ"]],
    "监票": [["jiān"], ["piào"]],
    "监事": [["jiān"], ["shì"]],
    "监视": [["jiān"], ["shì"]],
    "监守": [["jiān"], ["shǒu"]],
    "监听": [["jiān"], ["tīng"]],
    "监押": [["jiān"], ["yā"]],
    "监狱": [["jiān"], ["yù"]],
    "监造": [["jiān"], ["zào"]],
    "监院": [["jiān"], ["yuàn"]],
    "湔洗": [["jiān"], ["xǐ"]],
    "犍牛": [["jiān"], ["niú"]],
    "监制": [["jiān"], ["zhì"]],
    "犍为": [["qián"], ["wéi"]],
    "煎熬": [["jiān"], ["áo"]],
    "拣择": [["jiǎn"], ["zé"]],
    "俭省": [["jiǎn"], ["shěng"]],
    "俭朴": [["jiǎn"], ["pǔ"]],
    "柬帖": [["jiǎn"], ["tiě"]],
    "俭约": [["jiǎn"], ["yuē"]],
    "捡拾": [["jiǎn"], ["shí"]],
    "减价": [["jiǎn"], ["jià"]],
    "减省": [["jiǎn"], ["shěng"]],
    "剪发": [["jiǎn"], ["fà"]],
    "剪枝": [["jiǎn"], ["zhī"]],
    "简称": [["jiǎn"], ["chēng"]],
    "简便": [["jiǎn"], ["biàn"]],
    "简单": [["jiǎn"], ["dān"]],
    "简化": [["jiǎn"], ["huà"]],
    "简括": [["jiǎn"], ["kuò"]],
    "简朴": [["jiǎn"], ["piáo"]],
    "简任": [["jiǎn"], ["rèn"]],
    "简省": [["jiǎn"], ["shěng"]],
    "简缩": [["jiǎn"], ["suō"]],
    "简帖": [["jiǎn"], ["tiē"]],
    "简要": [["jiǎn"], ["yào"]],
    "简约": [["jiǎn"], ["yuē"]],
    "碱地": [["jiǎn"], ["dì"]],
    "见爱": [["jiàn"], ["ài"]],
    "见报": [["jiàn"], ["bào"]],
    "见背": [["jiàn"], ["bèi"]],
    "见称": [["jiàn"], ["chēng"]],
    "见长": [["jiàn"], ["zhǎng"]],
    "见到": [["jiàn"], ["dào"]],
    "见得": [["jiàn"], ["de"]],
    "见地": [["jiàn"], ["dì"]],
    "见方": [["jiàn"], ["fāng"]],
    "见告": [["jiàn"], ["gào"]],
    "见怪": [["jiàn"], ["guài"]],
    "见好": [["jiàn"], ["hǎo"]],
    "见鬼": [["jiàn"], ["guǐ"]],
    "见机": [["jiàn"], ["jī"]],
    "见教": [["jiàn"], ["jiào"]],
    "见解": [["jiàn"], ["jiě"]],
    "见老": [["jiàn"], ["lǎo"]],
    "见礼": [["jiàn"], ["lǐ"]],
    "见谅": [["jiàn"], ["liàng"]],
    "见面": [["jiàn"], ["miàn"]],
    "见识": [["jiàn"], ["shí"]],
    "见天": [["jiàn"], ["tiān"]],
    "见外": [["jiàn"], ["wài"]],
    "见闻": [["jiàn"], ["wén"]],
    "见效": [["jiàn"], ["xiào"]],
    "见习": [["jiàn"], ["xí"]],
    "见笑": [["jiàn"], ["xiào"]],
    "见新": [["jiàn"], ["xīn"]],
    "见于": [["jiàn"], ["yú"]],
    "见证": [["jiàn"], ["zhèng"]],
    "见罪": [["jiàn"], ["zuì"]],
    "件数": [["jiàn"], ["shù"]],
    "件头": [["jiàn"], ["tóu"]],
    "建都": [["jiàn"], ["dū"]],
    "建中": [["jiàn"], ["zhōng"]],
    "建筑": [["jiàn"], ["zhù"]],
    "饯别": [["jiàn"], ["bié"]],
    "饯行": [["jiàn"], ["xíng"]],
    "剑术": [["jiàn"], ["shù"]],
    "贱价": [["jiàn"], ["jià"]],
    "贱内": [["jiàn"], ["nèi"]],
    "健将": [["jiàn"], ["jiàng"]],
    "舰炮": [["jiàn"], ["pào"]],
    "舰只": [["jiàn"], ["zhī"]],
    "溅射": [["jiàn"], ["shè"]],
    "溅落": [["jiàn"], ["luò"]],
    "溅湿": [["jiàn"], ["shī"]],
    "溅污": [["jiàn"], ["wū"]],
    "溅水": [["jiàn"], ["shuǐ"]],
    "践行": [["jiàn"], ["xíng"]],
    "腱鞘": [["jiàn"], ["qiào"]],
    "践约": [["jiàn"], ["yuē"]],
    "鉴别": [["jiàn"], ["bié"]],
    "箭垛": [["jiàn"], ["duǒ"]],
    "鉴识": [["jiàn"], ["shí"]],
    "箭头": [["jiàn"], ["tóu"]],
    "江北": [["jiāng"], ["běi"]],
    "江都": [["jiāng"], ["dū"]],
    "江南": [["jiāng"], ["nán"]],
    "江苏": [["jiāng"], ["sū"]],
    "江宁": [["jiāng"], ["níng"]],
    "将才": [["jiāng"], ["cái"]],
    "将次": [["jiāng"], ["cì"]],
    "将官": [["jiàng"], ["guān"]],
    "将将": [["qiāng"], ["qiāng"]],
    "将近": [["jiāng"], ["jìn"]],
    "将就": [["jiāng"], ["jiù"]],
    "将军": [["jiāng"], ["jūn"]],
    "将来": [["jiāng"], ["lái"]],
    "将令": [["jiàng"], ["lìng"]],
    "将领": [["jiàng"], ["lǐng"]],
    "将门": [["jiàng"], ["mén"]],
    "将士": [["jiàng"], ["shì"]],
    "将帅": [["jiàng"], ["shuài"]],
    "将息": [["jiāng"], ["xī"]],
    "将尉": [["jiàng"], ["wèi"]],
    "将校": [["jiàng"], ["xiào"]],
    "将养": [["jiāng"], ["yǎng"]],
    "将要": [["jiāng"], ["yào"]],
    "浆果": [["jiāng"], ["guǒ"]],
    "浆糊": [["jiāng"], ["hú"]],
    "浆洗": [["jiāng"], ["xǐ"]],
    "浆汁": [["jiāng"], ["zhī"]],
    "浆液": [["jiāng"], ["yè"]],
    "僵化": [["jiāng"], ["huà"]],
    "疆场": [["jiāng"], ["chǎng"]],
    "疆界": [["jiāng"], ["jiè"]],
    "疆土": [["jiāng"], ["tǔ"]],
    "疆域": [["jiāng"], ["yù"]],
    "讲好": [["jiǎng"], ["hǎo"]],
    "讲价": [["jiǎng"], ["jià"]],
    "讲和": [["jiǎng"], ["hé"]],
    "讲解": [["jiǎng"], ["jiě"]],
    "讲台": [["jiǎng"], ["tái"]],
    "奖券": [["jiǎng"], ["quàn"]],
    "奖掖": [["jiǎng"], ["yè"]],
    "桨叶": [["jiǎng"], ["yè"]],
    "降表": [["jiàng"], ["biǎo"]],
    "降等": [["jiàng"], ["děng"]],
    "降低": [["jiàng"], ["dī"]],
    "降调": [["jiàng"], ["diào"]],
    "降伏": [["xiáng"], ["fú"]],
    "降格": [["jiàng"], ["gé"]],
    "降服": [["jiàng"], ["fú"]],
    "降价": [["jiàng"], ["jià"]],
    "降火": [["jiàng"], ["huǒ"]],
    "降级": [["jiàng"], ["jí"]],
    "降临": [["jiàng"], ["lín"]],
    "降解": [["jiàng"], ["jiě"]],
    "降落": [["jiàng"], ["luò"]],
    "降旗": [["jiàng"], ["qí"]],
    "降气": [["jiàng"], ["qì"]],
    "降生": [["jiàng"], ["shēng"]],
    "降世": [["jiàng"], ["shì"]],
    "降顺": [["jiàng"], ["shùn"]],
    "降水": [["jiàng"], ["shuǐ"]],
    "降温": [["jiàng"], ["wēn"]],
    "降下": [["jiàng"], ["xià"]],
    "降香": [["jiàng"], ["xiāng"]],
    "降雪": [["jiàng"], ["xuě"]],
    "降压": [["jiàng"], ["yā"]],
    "降雨": [["jiàng"], ["yǔ"]],
    "降职": [["jiàng"], ["zhí"]],
    "犟劲": [["jiàng"], ["jìn"]],
    "糨糊": [["jiàng"], ["hù"]],
    "交臂": [["jiāo"], ["bì"]],
    "交并": [["jiāo"], ["bìng"]],
    "交叉": [["jiāo"], ["chā"]],
    "交差": [["jiāo"], ["chāi"]],
    "交底": [["jiāo"], ["dǐ"]],
    "交待": [["jiāo"], ["dài"]],
    "交恶": [["jiāo"], ["wù"]],
    "交给": [["jiāo"], ["gěi"]],
    "交好": [["jiāo"], ["hǎo"]],
    "交合": [["jiāo"], ["hé"]],
    "交还": [["jiāo"], ["huán"]],
    "交会": [["jiāo"], ["huì"]],
    "交角": [["jiāo"], ["jiǎo"]],
    "交迫": [["jiāo"], ["pò"]],
    "交卷": [["jiāo"], ["juàn"]],
    "交结": [["jiāo"], ["jié"]],
    "交尾": [["jiāo"], ["wěi"]],
    "交相": [["jiāo"], ["xiāng"]],
    "交椅": [["jiāo"], ["yǐ"]],
    "交织": [["jiāo"], ["zhī"]],
    "郊县": [["jiāo"], ["xiàn"]],
    "郊区": [["jiāo"], ["qū"]],
    "姣好": [["jiāo"], ["hǎo"]],
    "姣丽": [["jiāo"], ["lì"]],
    "姣美": [["jiāo"], ["měi"]],
    "娇妻": [["jiāo"], ["qī"]],
    "娇好": [["jiāo"], ["hǎo"]],
    "娇娆": [["jiāo"], ["ráo"]],
    "娇纵": [["jiāo"], ["zòng"]],
    "浇薄": [["jiāo"], ["bó"]],
    "浇洒": [["jiāo"], ["sǎ"]],
    "骄横": [["jiāo"], ["hèng"]],
    "浇头": [["jiāo"], ["tou"]],
    "骄矜": [["jiāo"], ["jīn"]],
    "骄纵": [["jiāo"], ["zòng"]],
    "胶合": [["jiāo"], ["hé"]],
    "胶结": [["jiāo"], ["jié"]],
    "胶卷": [["jiāo"], ["juǎn"]],
    "胶囊": [["jiāo"], ["náng"]],
    "胶泥": [["jiāo"], ["ní"]],
    "胶片": [["jiāo"], ["piàn"]],
    "胶体": [["jiāo"], ["tǐ"]],
    "胶着": [["jiāo"], ["zhe"]],
    "焦干": [["jiāo"], ["gān"]],
    "焦糊": [["jiāo"], ["hú"]],
    "焦化": [["jiāo"], ["huà"]],
    "焦思": [["jiāo"], ["sī"]],
    "礁石": [["jiāo"], ["shí"]],
    "角尺": [["jiǎo"], ["chǐ"]],
    "角斗": [["jué"], ["dòu"]],
    "角度": [["jiǎo"], ["dù"]],
    "角钢": [["jiǎo"], ["gāng"]],
    "角化": [["jiǎo"], ["huà"]],
    "角力": [["jué"], ["lì"]],
    "角落": [["jiǎo"], ["luò"]],
    "角楼": [["jiǎo"], ["lóu"]],
    "角膜": [["jiǎo"], ["mó"]],
    "角门": [["jiǎo"], ["mén"]],
    "角票": [["jiǎo"], ["piào"]],
    "角球": [["jiǎo"], ["qiú"]],
    "角色": [["jué"], ["sè"]],
    "角铁": [["jiǎo"], ["tiě"]],
    "角质": [["jiǎo"], ["zhì"]],
    "角逐": [["jué"], ["zhú"]],
    "角子": [["jiǎo"], ["zǐ"]],
    "绞车": [["jiǎo"], ["chē"]],
    "侥幸": [["jiǎo"], ["xìng"]],
    "搅拌": [["jiǎo"], ["bàn"]],
    "搅和": [["jiǎo"], ["huo"]],
    "搅混": [["jiǎo"], ["gǔn"]],
    "湫隘": [["jiǎo"], ["ài"]],
    "剿除": [["jiǎo"], ["chú"]],
    "剿匪": [["jiǎo"], ["fěi"]],
    "剿灭": [["jiǎo"], ["miè"]],
    "剿袭": [["chāo"], ["xí"]],
    "剿杀": [["jiǎo"], ["shā"]],
    "徼幸": [["jiǎo"], ["xìng"]],
    "缴付": [["jiǎo"], ["fù"]],
    "缴获": [["jiǎo"], ["huò"]],
    "缴纳": [["jiǎo"], ["nà"]],
    "缴枪": [["jiǎo"], ["qiāng"]],
    "缴销": [["jiǎo"], ["xiāo"]],
    "缴税": [["jiǎo"], ["shuì"]],
    "缴械": [["jiǎo"], ["xiè"]],
    "叫好": [["jiào"], ["hǎo"]],
    "叫化": [["jiào"], ["huà"]],
    "叫号": [["jiào"], ["hào"]],
    "叫价": [["jiào"], ["jià"]],
    "叫劲": [["jiào"], ["jìn"]],
    "叫嚷": [["jiào"], ["rǎng"]],
    "轿车": [["jiào"], ["chē"]],
    "轿夫": [["jiào"], ["fū"]],
    "较场": [["jiào"], ["chǎng"]],
    "较差": [["jiào"], ["chà"]],
    "较大": [["jiào"], ["dà"]],
    "较好": [["jiào"], ["hǎo"]],
    "较劲": [["jiào"], ["jìn"]],
    "较量": [["jiào"], ["liàng"]],
    "较为": [["jiào"], ["wéi"]],
    "较著": [["jiào"], ["zhù"]],
    "教法": [["jiào"], ["fǎ"]],
    "教理": [["jiào"], ["lǐ"]],
    "教民": [["jiào"], ["mín"]],
    "教旨": [["jiào"], ["zhǐ"]],
    "窖藏": [["jiào"], ["cáng"]],
    "阶地": [["jiē"], ["dì"]],
    "揭穿": [["jiē"], ["chuān"]],
    "揭榜": [["jiē"], ["bǎng"]],
    "揭底": [["jiē"], ["dǐ"]],
    "揭短": [["jiē"], ["duǎn"]],
    "揭发": [["jiē"], ["fā"]],
    "揭锅": [["jiē"], ["guō"]],
    "揭揭": [["jiē"], ["jiē"]],
    "揭开": [["jiē"], ["kāi"]],
    "揭露": [["jiē"], ["lù"]],
    "揭幕": [["jiē"], ["mù"]],
    "揭批": [["jiē"], ["pī"]],
    "揭破": [["jiē"], ["pò"]],
    "揭帖": [["jiē"], ["tiě"]],
    "揭示": [["jiē"], ["shì"]],
    "揭晓": [["jiē"], ["xiǎo"]],
    "揭阳": [["jiē"], ["yáng"]],
    "揭橥": [["jiē"], ["zhū"]],
    "街坊": [["jiē"], ["fāng"]],
    "街区": [["jiē"], ["qū"]],
    "街景": [["jiē"], ["jǐng"]],
    "街上": [["jiē"], ["shàng"]],
    "街头": [["jiē"], ["tóu"]],
    "街巷": [["jiē"], ["xiàng"]],
    "节哀": [["jié"], ["āi"]],
    "节本": [["jié"], ["běn"]],
    "节操": [["jié"], ["cāo"]],
    "节度": [["jié"], ["dù"]],
    "节妇": [["jié"], ["fù"]],
    "节假": [["jié"], ["jiǎ"]],
    "节间": [["jié"], ["jiān"]],
    "节俭": [["jié"], ["jiǎn"]],
    "节减": [["jié"], ["jiǎn"]],
    "节节": [["jié"], ["jié"]],
    "节理": [["jié"], ["lǐ"]],
    "节礼": [["jié"], ["lǐ"]],
    "节流": [["jié"], ["liú"]],
    "节烈": [["ji&eacute;li&egrave;"]],
    "节令": [["jié"], ["lìng"]],
    "节录": [["jié"], ["lù"]],
    "节律": [["jié"], ["lǜ"]],
    "节略": [["jié"], ["lüè"]],
    "节能": [["jié"], ["néng"]],
    "节目": [["jié"], ["mù"]],
    "节拍": [["jié"], ["pāi"]],
    "节片": [["jié"], ["piàn"]],
    "节庆": [["jié"], ["qìng"]],
    "节气": [["jié"], ["qì"]],
    "节日": [["jié"], ["rì"]],
    "节省": [["jié"], ["shěng"]],
    "节食": [["jié"], ["shí"]],
    "节水": [["jié"], ["shuǐ"]],
    "节下": [["jié"], ["xià"]],
    "节选": [["jié"], ["xuǎn"]],
    "节用": [["jié"], ["yòng"]],
    "节油": [["jié"], ["yóu"]],
    "节余": [["jié"], ["yú"]],
    "节育": [["jié"], ["yù"]],
    "节欲": [["jié"], ["yù"]],
    "节约": [["jié"], ["yuē"]],
    "节支": [["jié"], ["zhī"]],
    "节制": [["jié"], ["zhì"]],
    "节子": [["jiē"], ["zǐ"]],
    "节奏": [["jié"], ["zòu"]],
    "劫难": [["jié"], ["nàn"]],
    "劫数": [["jié"], ["shù"]],
    "诘难": [["jié"], ["nán"]],
    "诘问": [["jié"], ["wèn"]],
    "诘责": [["jié"], ["zé"]],
    "拮抗": [["jié"], ["kàng"]],
    "拮据": [["jié"], ["jū"]],
    "洁净": [["jié"], ["jìng"]],
    "结案": [["jié"], ["àn"]],
    "结巴": [["jiē"], ["bā"]],
    "结疤": [["jié"], ["bā"]],
    "结拜": [["jié"], ["bài"]],
    "结伴": [["jié"], ["bàn"]],
    "结冰": [["jié"], ["bīng"]],
    "结彩": [["jié"], ["cǎi"]],
    "结肠": [["jié"], ["cháng"]],
    "结仇": [["jié"], ["chóu"]],
    "结成": [["jié"], ["chéng"]],
    "结存": [["jié"], ["cún"]],
    "结点": [["jié"], ["diǎn"]],
    "结队": [["jié"], ["duì"]],
    "结发": [["jié"], ["fà"]],
    "结构": [["jié"], ["gòu"]],
    "结合": [["jié"], ["hé"]],
    "结果": [["jié"], ["guǒ"]],
    "结核": [["jié"], ["hé"]],
    "结喉": [["jié"], ["hóu"]],
    "结婚": [["jié"], ["hūn"]],
    "结汇": [["jié"], ["huì"]],
    "结伙": [["jié"], ["huǒ"]],
    "结集": [["jié"], ["jí"]],
    "结痂": [["jié"], ["jiā"]],
    "结交": [["jié"], ["jiāo"]],
    "结节": [["jié"], ["jié"]],
    "结晶": [["jié"], ["jīng"]],
    "结局": [["jié"], ["jú"]],
    "结庐": [["jié"], ["lú"]],
    "结论": [["jié"], ["lùn"]],
    "结盟": [["jié"], ["méng"]],
    "结膜": [["jié"], ["mó"]],
    "结幕": [["jié"], ["mù"]],
    "结清": [["jié"], ["qīng"]],
    "结亲": [["jié"], ["qīn"]],
    "结舌": [["jié"], ["shé"]],
    "结石": [["jié"], ["shí"]],
    "结社": [["jié"], ["shè"]],
    "结识": [["jié"], ["shí"]],
    "结实": [["jiē"], ["shi"]],
    "结束": [["jié"], ["shù"]],
    "结算": [["jié"], ["suàn"]],
    "结网": [["jié"], ["wǎng"]],
    "结尾": [["jié"], ["wěi"]],
    "结义": [["jié"], ["yì"]],
    "结业": [["jié"], ["yè"]],
    "结余": [["jié"], ["yú"]],
    "结语": [["jié"], ["yǔ"]],
    "结缘": [["jié"], ["yuán"]],
    "结怨": [["jié"], ["yuàn"]],
    "结扎": [["jié"], ["zā"]],
    "结帐": [["jié"], ["zhàng"]],
    "结账": [["jié"], ["zhàng"]],
    "结子": [["jié"], ["zǐ"]],
    "颉颃": [["xié"], ["háng"]],
    "碣石": [["jié"], ["shí"]],
    "竭尽": [["jié"], ["jìn"]],
    "羯羊": [["jié"], ["yáng"]],
    "她们": [["tā"], ["men"]],
    "姐夫": [["jiě"], ["fū"]],
    "解表": [["jiě"], ["biǎo"]],
    "解差": [["jiè"], ["chāi"]],
    "解馋": [["jiě"], ["chán"]],
    "解嘲": [["jiě"], ["cháo"]],
    "解愁": [["jiě"], ["chóu"]],
    "解除": [["jiě"], ["chú"]],
    "解答": [["jiě"], ["dá"]],
    "解调": [["jiě"], ["tiáo"]],
    "解冻": [["jiě"], ["dòng"]],
    "解毒": [["jiě"], ["dú"]],
    "解饿": [["jiě"], ["è"]],
    "解乏": [["jiě"], ["fá"]],
    "解法": [["xiè"], ["fǎ"]],
    "解放": [["jiě"], ["fàng"]],
    "解构": [["jiě"], ["gòu"]],
    "解雇": [["jiě"], ["gù"]],
    "解恨": [["jiě"], ["hèn"]],
    "解惑": [["jiě"], ["huò"]],
    "解甲": [["jiě"], ["jiǎ"]],
    "解解": [["jiě"], ["jiě"]],
    "解禁": [["jiě"], ["jìn"]],
    "解酒": [["jiě"], ["jiǔ"]],
    "解救": [["jiě"], ["jiù"]],
    "解开": [["jiě"], ["kāi"]],
    "解决": [["jiě"], ["jué"]],
    "解渴": [["jiě"], ["kě"]],
    "解款": [["jiè"], ["kuǎn"]],
    "解困": [["jiě"], ["kùn"]],
    "解缆": [["jiě"], ["lǎn"]],
    "解离": [["jiě"], ["lí"]],
    "解码": [["jiě"], ["mǎ"]],
    "解闷": [["jiě"], ["mèn"]],
    "解梦": [["jiě"], ["mèng"]],
    "解谜": [["jiě"], ["mí"]],
    "解密": [["jiě"], ["mì"]],
    "解难": [["jiě"], ["nán"]],
    "解囊": [["jiě"], ["náng"]],
    "解聘": [["jiě"], ["pìn"]],
    "解剖": [["jiě"], ["pōu"]],
    "解气": [["jiě"], ["qì"]],
    "解热": [["jiě"], ["rè"]],
    "解劝": [["jiě"], ["quàn"]],
    "解任": [["jiě"], ["rèn"]],
    "解散": [["jiě"], ["sàn"]],
    "解事": [["jiě"], ["shì"]],
    "解手": [["jiě"], ["shǒu"]],
    "解释": [["jiě"], ["shì"]],
    "解暑": [["jiě"], ["shǔ"]],
    "解数": [["xiè"], ["shù"]],
    "解说": [["jiě"], ["shuō"]],
    "解送": [["jiè"], ["sòng"]],
    "解题": [["jiě"], ["tí"]],
    "解脱": [["jiě"], ["tuō"]],
    "解体": [["jiě"], ["tǐ"]],
    "解危": [["jiě"], ["wēi"]],
    "解悟": [["jiě"], ["wù"]],
    "解围": [["jiě"], ["wéi"]],
    "解吸": [["jiě"], ["xī"]],
    "解析": [["jiě"], ["xī"]],
    "解下": [["jiě"], ["xià"]],
    "解严": [["jiě"], ["yán"]],
    "解药": [["jiě"], ["yào"]],
    "解颐": [["jiě"], ["yí"]],
    "解疑": [["jiě"], ["yí"]],
    "解忧": [["jiě"], ["yōu"]],
    "解郁": [["jiě"], ["yù"]],
    "解约": [["jiě"], ["yuē"]],
    "解元": [["jiè"], ["yuán"]],
    "解运": [["jiě"], ["yùn"]],
    "解职": [["jiě"], ["zhí"]],
    "戒尺": [["jiè"], ["chǐ"]],
    "戒条": [["jiè"], ["tiáo"]],
    "芥蓝": [["gài"], ["lán"]],
    "芥蒂": [["jiè"], ["dì"]],
    "芥末": [["jiè"], ["mò"]],
    "届期": [["jiè"], ["qī"]],
    "芥子": [["jiè"], ["zǐ"]],
    "界尺": [["jiè"], ["chǐ"]],
    "界石": [["jiè"], ["shí"]],
    "界约": [["jiè"], ["yuē"]],
    "界说": [["jiè"], ["shuō"]],
    "借调": [["jiè"], ["diào"]],
    "借读": [["jiè"], ["dú"]],
    "借据": [["jiè"], ["jù"]],
    "借宿": [["jiè"], ["sù"]],
    "借条": [["jiè"], ["tiáo"]],
    "借重": [["jiè"], ["zhòng"]],
    "借助": [["jiè"], ["zhù"]],
    "藉口": [["jiè"], ["kǒu"]],
    "藉以": [["jiè"], ["yǐ"]],
    "今番": [["jīn"], ["fān"]],
    "今朝": [["jīn"], ["zhāo"]],
    "斤斗": [["jīn"], ["dǒu"]],
    "金榜": [["jīn"], ["bǎng"]],
    "金弹": [["jīn"], ["dàn"]],
    "金冠": [["jīn"], ["guān"]],
    "金龟": [["jīn"], ["guī"]],
    "金华": [["jīn"], ["huá"]],
    "金沙": [["jīn"], ["shā"]],
    "金石": [["jīn"], ["shí"]],
    "金蛇": [["jīn"], ["shé"]],
    "金汤": [["jīn"], ["tāng"]],
    "金条": [["jīn"], ["tiáo"]],
    "金叶": [["jīn"], ["yè"]],
    "金相": [["jīn"], ["xiàng"]],
    "金正": [["jīn"], ["zhèng"]],
    "金枝": [["jīn"], ["zhī"]],
    "金属": [["jīn"], ["shǔ"]],
    "津要": [["jīn"], ["yào"]],
    "矜持": [["jīn"], ["chí"]],
    "矜贵": [["jīn"], ["guì"]],
    "矜夸": [["jīn"], ["kuā"]],
    "筋斗": [["jīn"], ["dǒu"]],
    "筋骨": [["jīn"], ["gǔ"]],
    "筋节": [["jīn"], ["jié"]],
    "筋络": [["jīn"], ["luò"]],
    "筋脉": [["jīn"], ["mài"]],
    "仅见": [["jǐn"], ["jiàn"]],
    "仅仅": [["jǐn"], ["jǐn"]],
    "紧迫": [["jǐn"], ["pò"]],
    "紧俏": [["jǐn"], ["qiào"]],
    "紧缩": [["jǐn"], ["suō"]],
    "紧要": [["jǐn"], ["yào"]],
    "紧着": [["jǐn"], ["zhe"]],
    "谨上": [["jǐn"], ["shàng"]],
    "锦纶": [["jǐn"], ["lún"]],
    "锦囊": [["jǐn"], ["náng"]],
    "锦屏": [["jǐn"], ["píng"]],
    "尽瘁": [["jìn"], ["cuì"]],
    "尽欢": [["jìn"], ["huān"]],
    "尽管": [["jǐn"], ["guǎn"]],
    "尽快": [["jǐn"], ["kuài"]],
    "尽力": [["jìn"], ["lì"]],
    "尽量": [["jǐn"], ["liàng"]],
    "尽情": [["jìn"], ["qíng"]],
    "尽让": [["jìn"], ["ràng"]],
    "尽然": [["jìn"], ["rán"]],
    "尽是": [["jìn"], ["shì"]],
    "尽数": [["jìn"], ["shù"]],
    "尽先": [["jǐn"], ["xiān"]],
    "尽头": [["jìn"], ["tóu"]],
    "尽孝": [["jìn"], ["xiào"]],
    "尽心": [["jìn"], ["xīn"]],
    "尽兴": [["jìn"], ["xìng"]],
    "尽性": [["jìn"], ["xìng"]],
    "尽意": [["jìn"], ["yì"]],
    "尽职": [["jìn"], ["zhí"]],
    "尽责": [["jìn"], ["zé"]],
    "尽致": [["jìn"], ["zhì"]],
    "尽忠": [["jìn"], ["zhōng"]],
    "尽自": [["jǐn"], ["zì"]],
    "劲草": [["jìng"], ["cǎo"]],
    "劲吹": [["jìng"], ["chuī"]],
    "劲道": [["jìn"], ["dào"]],
    "劲敌": [["jìng"], ["dí"]],
    "劲风": [["jìng"], ["fēng"]],
    "劲健": [["jìn"], ["jiàn"]],
    "劲力": [["jìn"], ["lì"]],
    "劲旅": [["jìng"], ["lǚ"]],
    "劲射": [["jìng"], ["shè"]],
    "劲头": [["jìn"], ["tóu"]],
    "劲直": [["jìng"], ["zhí"]],
    "近便": [["jìn"], ["biàn"]],
    "近处": [["jìn"], ["chù"]],
    "近旁": [["jìn"], ["páng"]],
    "近景": [["jìn"], ["jǐng"]],
    "近场": [["jìn"], ["chǎng"]],
    "近期": [["jìn"], ["qī"]],
    "进场": [["jìn"], ["chǎng"]],
    "近亲": [["jìn"], ["qīn"]],
    "近似": [["jìn"], ["sì"]],
    "进尺": [["jìn"], ["chǐ"]],
    "进度": [["jìn"], ["dù"]],
    "进发": [["jìn"], ["fā"]],
    "进给": [["jìn"], ["jǐ"]],
    "进港": [["jìn"], ["gǎng"]],
    "进化": [["jìn"], ["huà"]],
    "进见": [["jìn"], ["jiàn"]],
    "进剿": [["jìn"], ["jiǎo"]],
    "进食": [["jìn"], ["shí"]],
    "晋见": [["jìn"], ["jiàn"]],
    "浸泡": [["jìn"], ["pào"]],
    "浸洗": [["jìn"], ["xǐ"]],
    "浸没": [["jìn"], ["mò"]],
    "浸种": [["jìn"], ["zhǒng"]],
    "禁闭": [["jìn"], ["bì"]],
    "禁地": [["jìn"], ["dì"]],
    "禁锢": [["jìn"], ["gù"]],
    "禁果": [["jìn"], ["guǒ"]],
    "禁毁": [["jìn"], ["huǐ"]],
    "禁火": [["jìn"], ["huǒ"]],
    "禁忌": [["jìn"], ["jì"]],
    "禁酒": [["jìn"], ["jiǔ"]],
    "禁军": [["jìn"], ["jūn"]],
    "禁绝": [["jìn"], ["jué"]],
    "禁例": [["jìn"], ["lì"]],
    "禁猎": [["jìn"], ["liè"]],
    "禁令": [["jìn"], ["lìng"]],
    "禁律": [["jìn"], ["lǜ"]],
    "禁脔": [["jìn"], ["jī"]],
    "禁区": [["jìn"], ["qū"]],
    "禁食": [["jìn"], ["shí"]],
    "禁受": [["jīn"], ["shòu"]],
    "禁书": [["jìn"], ["shū"]],
    "禁条": [["jìn"], ["tiáo"]],
    "禁卫": [["jìn"], ["wèi"]],
    "禁物": [["jìn"], ["wù"]],
    "禁烟": [["jìn"], ["yān"]],
    "禁用": [["jīn"], ["yòng"]],
    "禁欲": [["jìn"], ["yù"]],
    "禁渔": [["jìn"], ["yú"]],
    "禁运": [["jìn"], ["yùn"]],
    "禁止": [["jìn"], ["zhǐ"]],
    "禁足": [["jìn"], ["zú"]],
    "禁制": [["jìn"], ["zhì"]],
    "禁子": [["jìn"], ["zǐ"]],
    "禁阻": [["jìn"], ["zǔ"]],
    "觐见": [["jìn"], ["jiàn"]],
    "京都": [["jīng"], ["dū"]],
    "京华": [["jīng"], ["huá"]],
    "京戏": [["jīng"], ["xì"]],
    "经传": [["jīng"], ["zhuàn"]],
    "经度": [["jīng"], ["dù"]],
    "经过": [["jīng"], ["guò"]],
    "经纪": [["jīng"], ["jì"]],
    "经卷": [["jīng"], ["juàn"]],
    "经济": [["jīngj&igrave;"]],
    "经络": [["jīng"], ["luò"]],
    "经纶": [["jīng"], ["lún"]],
    "经脉": [["jīng"], ["mài"]],
    "经期": [["jīng"], ["qī"]],
    "经血": [["jīng"], ["xuè"]],
    "茎干": [["jīng"], ["gàn"]],
    "荆芥": [["jīng"], ["jiè"]],
    "荆条": [["jīng"], ["tiáo"]],
    "惊倒": [["jīng"], ["dǎo"]],
    "惊风": [["jīng"], ["fēng"]],
    "惊觉": [["jīng"], ["jué"]],
    "惊跳": [["jīng"], ["tiào"]],
    "晶体": [["jīng"], ["tǐ"]],
    "腈纶": [["jīng"], ["lún"]],
    "精辟": [["jīng"], ["pì"]],
    "精当": [["jīng"], ["dàng"]],
    "精采": [["jīng"], ["cǎi"]],
    "精读": [["jīng"], ["dú"]],
    "精度": [["jīng"], ["dù"]],
    "精干": [["jīng"], ["gàn"]],
    "精华": [["jīng"], ["huá"]],
    "精馏": [["jīng"], ["liú"]],
    "精血": [["jīng"], ["xuè"]],
    "精要": [["jīng"], ["yào"]],
    "井场": [["jǐng"], ["chǎng"]],
    "井底": [["jǐng"], ["dǐ"]],
    "井台": [["jǐng"], ["tái"]],
    "井喷": [["jǐng"], ["pēn"]],
    "景观": [["jǐng"], ["guān"]],
    "景点": [["jǐng"], ["diǎn"]],
    "景教": [["jǐng"], ["jiào"]],
    "景况": [["jǐng"], ["kuàng"]],
    "景慕": [["jǐng"], ["mù"]],
    "景片": [["jǐng"], ["piàn"]],
    "景气": [["jǐng"], ["qì"]],
    "景区": [["jǐng"], ["qū"]],
    "景色": [["jǐng"], ["sè"]],
    "景深": [["jǐng"], ["shēn"]],
    "景天": [["jǐng"], ["tiān"]],
    "景物": [["jǐng"], ["wù"]],
    "景象": [["jǐng"], ["xiàng"]],
    "景行": [["jǐng"], ["xíng"]],
    "景仰": [["jǐng"], ["yǎng"]],
    "景致": [["jǐng"], ["zhì"]],
    "景遇": [["jǐng"], ["yù"]],
    "警长": [["jǐng"], ["cháng"]],
    "警车": [["jǐng"], ["chē"]],
    "警服": [["jǐng"], ["fú"]],
    "警棍": [["jǐng"], ["gùn"]],
    "警号": [["jǐng"], ["hào"]],
    "警句": [["jǐng"], ["jù"]],
    "警觉": [["jǐng"], ["jué"]],
    "警语": [["jǐng"], ["yǔ"]],
    "警员": [["jǐng"], ["yuán"]],
    "警种": [["jǐng"], ["zhǒng"]],
    "净得": [["jìng"], ["de"]],
    "净高": [["jìng"], ["gāo"]],
    "净化": [["jìng"], ["huà"]],
    "净价": [["jìng"], ["jià"]],
    "净口": [["jìng"], ["kǒu"]],
    "净尽": [["jìng"], ["jìn"]],
    "净空": [["jìng"], ["kōng"]],
    "净利": [["jìng"], ["lì"]],
    "净身": [["jìng"], ["shēn"]],
    "净室": [["jìng"], ["shì"]],
    "净手": [["jìng"], ["shǒu"]],
    "净水": [["jìng"], ["shuǐ"]],
    "净桶": [["jìng"], ["tǒng"]],
    "净土": [["jìng"], ["tǔ"]],
    "净心": [["jìng"], ["xīn"]],
    "净余": [["jìng"], ["yú"]],
    "净重": [["jìng"], ["zhòng"]],
    "净赚": [["jìng"], ["zhuàn"]],
    "径行": [["jìng"], ["xíng"]],
    "胫骨": [["jìng"], ["gǔ"]],
    "敬仰": [["jìng"], ["yǎng"]],
    "敬服": [["jìng"], ["fú"]],
    "敬语": [["jìng"], ["yǔ"]],
    "靓丽": [["liàng"], ["lì"]],
    "敬重": [["jìng"], ["zhòng"]],
    "靓女": [["liàng"], ["nǚ"]],
    "靓妆": [["jìng"], ["zhuāng"]],
    "靓仔": [["liàng"], ["zǎi"]],
    "境地": [["jìng"], ["dì"]],
    "静场": [["jìng"], ["chǎng"]],
    "静脉": [["jìng"], ["mài"]],
    "静乐": [["jìng"], ["lè"]],
    "静观": [["jìng"], ["guān"]],
    "静宁": [["jìng"], ["níng"]],
    "静思": [["jìng"], ["sī"]],
    "镜台": [["jìng"], ["tái"]],
    "镜头": [["jìng"], ["tóu"]],
    "镜片": [["jìng"], ["piàn"]],
    "窘迫": [["jiǒng"], ["pò"]],
    "纠葛": [["jiū"], ["gé"]],
    "窘相": [["jiǒng"], ["xiàng"]],
    "纠合": [["jiū"], ["hé"]],
    "纠结": [["jiū"], ["jié"]],
    "纠正": [["jiū"], ["zhèng"]],
    "究诘": [["jiū"], ["jié"]],
    "鸠尾": [["jiū"], ["wěi"]],
    "揪斗": [["jiū"], ["dòu"]],
    "九重": [["jiǔ"], ["zhòng"]],
    "久别": [["jiǔ"], ["bié"]],
    "久长": [["jiǔ"], ["cháng"]],
    "久仰": [["jiǔ"], ["yǎng"]],
    "久远": [["jiǔ"], ["yuǎn"]],
    "酒吧": [["jiǔ"], ["bā"]],
    "酒场": [["jiǔ"], ["chǎng"]],
    "酒坊": [["jiǔ"], ["fāng"]],
    "酒刺": [["jiǔ"], ["cì"]],
    "酒会": [["jiǔ"], ["huì"]],
    "酒家": [["jiǔ"], ["jiā"]],
    "酒浆": [["jiǔ"], ["jiāng"]],
    "酒量": [["jiǔ"], ["liàng"]],
    "酒劲": [["jiǔ"], ["jìn"]],
    "酒令": [["jiǔ"], ["lìng"]],
    "酒铺": [["jiǔ"], ["pù"]],
    "酒曲": [["jiǔ"], ["qū"]],
    "酒食": [["jiǔ"], ["shí"]],
    "酒涡": [["jiǔ"], ["wō"]],
    "酒兴": [["jiǔ"], ["xìng"]],
    "旧地": [["jiù"], ["dì"]],
    "旧都": [["jiù"], ["dū"]],
    "旧恶": [["jiù"], ["è"]],
    "旧观": [["jiù"], ["guān"]],
    "旧好": [["jiù"], ["hǎo"]],
    "旧家": [["jiù"], ["jiā"]],
    "旧教": [["jiù"], ["jiào"]],
    "旧识": [["jiù"], ["shí"]],
    "旧体": [["jiù"], ["tǐ"]],
    "旧雨": [["jiù"], ["yǔ"]],
    "旧约": [["jiù"], ["yuē"]],
    "柩车": [["jiù"], ["chē"]],
    "旧知": [["jiù"], ["zhī"]],
    "就便": [["jiù"], ["biàn"]],
    "就地": [["jiù"], ["dì"]],
    "就合": [["jiù"], ["hé"]],
    "就教": [["jiù"], ["jiào"]],
    "就任": [["jiù"], ["rèn"]],
    "就食": [["jiù"], ["shí"]],
    "就要": [["jiù"], ["yào"]],
    "就正": [["jiù"], ["zhèng"]],
    "舅父": [["jiù"], ["fù"]],
    "居家": [["jū"], ["jiā"]],
    "居处": [["jū"], ["chǔ"]],
    "居间": [["jū"], ["jiān"]],
    "居丧": [["jū"], ["sāng"]],
    "居奇": [["jū"], ["qí"]],
    "居中": [["jū"], ["zhōng"]],
    "拘捕": [["jū"], ["bǔ"]],
    "拘传": [["jū"], ["chuán"]],
    "拘管": [["jū"], ["guǎn"]],
    "拘谨": [["jū"], ["jǐn"]],
    "拘礼": [["jū"], ["lǐ"]],
    "拘禁": [["jū"], ["jìn"]],
    "拘留": [["jū"], ["liú"]],
    "拘挛": [["jū"], ["luán"]],
    "拘拿": [["jū"], ["ná"]],
    "拘泥": [["jū"], ["nì"]],
    "拘票": [["jū"], ["piào"]],
    "拘束": [["jū"], ["shù"]],
    "拘押": [["jū"], ["yā"]],
    "拘牵": [["jū"], ["qiān"]],
    "拘役": [["jū"], ["yì"]],
    "拘执": [["jū"], ["zhí"]],
    "局度": [["jú"], ["dù"]],
    "局量": [["jú"], ["liàng"]],
    "桔槔": [["jié"], ["gāo"]],
    "桔梗": [["jié"], ["gěng"]],
    "橘红": [["jú"], ["hóng"]],
    "橘络": [["jú"], ["luò"]],
    "咀嚼": [["jǔ"], ["jué"]],
    "沮丧": [["jǔ"], ["sàng"]],
    "沮洳": [["jù"], ["rù"]],
    "举发": [["jǔ"], ["fā"]],
    "举家": [["jǔ"], ["jiā"]],
    "举要": [["jǔ"], ["yào"]],
    "举行": [["jǔ"], ["xíng"]],
    "举重": [["jǔ"], ["zhòng"]],
    "矩尺": [["jǔ"], ["chǐ"]],
    "句点": [["jù"], ["diǎn"]],
    "句读": [["jù"], ["dòu"]],
    "句法": [["jù"], ["fǎ"]],
    "句号": [["jù"], ["hào"]],
    "句型": [["jù"], ["xíng"]],
    "句式": [["jù"], ["shì"]],
    "句子": [["jù"], ["zi"]],
    "巨擘": [["jù"], ["bò"]],
    "巨大": [["jù"], ["dà"]],
    "巨量": [["jù"], ["liàng"]],
    "巨贾": [["jù"], ["gǔ"]],
    "巨头": [["jù"], ["tóu"]],
    "巨阙": [["jù"], ["quē"]],
    "巨著": [["jù"], ["zhù"]],
    "具体": [["jù"], ["tǐ"]],
    "具结": [["jù"], ["jié"]],
    "剧场": [["jù"], ["chǎng"]],
    "剧曲": [["jù"], ["qǔ"]],
    "剧毒": [["jù"], ["dú"]],
    "具有": [["jù"], ["yǒu"]],
    "剧种": [["jù"], ["zhǒng"]],
    "飓风": [["jù"], ["fēng"]],
    "锯条": [["jù"], ["tiáo"]],
    "聚合": [["jù"], ["hé"]],
    "聚会": [["jù"], ["huì"]],
    "聚结": [["jù"], ["jié"]],
    "聚落": [["jù"], ["luò"]],
    "聚头": [["jù"], ["tóu"]],
    "聚齐": [["jù"], ["qí"]],
    "聚散": [["jù"], ["sàn"]],
    "瞿麦": [["qú"], ["mài"]],
    "捐助": [["juān"], ["zhù"]],
    "卷柏": [["juàn"], ["bǎi"]],
    "卷尺": [["juǎn"], ["chǐ"]],
    "卷发": [["juǎn"], ["fà"]],
    "卷卷": [["juàn"], ["juàn"]],
    "卷帘": [["juàn"], ["lián"]],
    "卷面": [["juàn"], ["miàn"]],
    "卷曲": [["juǎn"], ["qū"]],
    "卷舌": [["juǎn"], ["shé"]],
    "卷缩": [["juàn"], ["suō"]],
    "卷逃": [["juǎn"], ["táo"]],
    "卷须": [["juàn"], ["xū"]],
    "卷烟": [["juǎn"], ["yān"]],
    "卷云": [["juǎn"], ["yún"]],
    "卷扬": [["juǎn"], ["yáng"]],
    "卷帙": [["juàn"], ["zhì"]],
    "卷轴": [["juàn"], ["zhóu"]],
    "卷子": [["juǎn"], ["zi"]],
    "卷宗": [["juàn"], ["zōng"]],
    "绢扇": [["juàn"], ["shàn"]],
    "隽永": [["juàn"], ["yǒng"]],
    "隽语": [["jùn"], ["yǔ"]],
    "撅嘴": [["juē"], ["zuǐ"]],
    "决别": [["jué"], ["bié"]],
    "决不": [["jué"], ["bù"]],
    "决斗": [["jué"], ["dòu"]],
    "决裂": [["jué"], ["liè"]],
    "诀别": [["jué"], ["bié"]],
    "抉择": [["jué"], ["zé"]],
    "绝倒": [["jué"], ["dǎo"]],
    "绝景": [["jué"], ["jǐng"]],
    "绝地": [["jué"], ["dì"]],
    "绝症": [["jué"], ["zhèng"]],
    "绝食": [["jué"], ["shí"]],
    "绝种": [["jué"], ["zhǒng"]],
    "觉察": [["jué"], ["chá"]],
    "觉得": [["jué"], ["de"]],
    "觉醒": [["jué"], ["xǐng"]],
    "觉悟": [["jué"], ["wù"]],
    "倔犟": [["juè"], ["jiàng"]],
    "倔强": [["jué"], ["jiàng"]],
    "噱头": [["xué"], ["tou"]],
    "镢头": [["jué"], ["tóu"]],
    "嚼子": [["jiáo"], ["zǐ"]],
    "嚼舌": [["jiáo"], ["shé"]],
    "军长": [["jūn"], ["zhǎng"]],
    "军车": [["jūn"], ["chē"]],
    "军风": [["jūn"], ["fēng"]],
    "军服": [["jūn"], ["fú"]],
    "军号": [["jūn"], ["hào"]],
    "军港": [["jūn"], ["gǎng"]],
    "军纪": [["jūn"], ["jì"]],
    "军乐": [["jūn"], ["yuè"]],
    "军令": [["jūn"], ["lìng"]],
    "军区": [["jūn"], ["qū"]],
    "军帖": [["jūn"], ["tiě"]],
    "军委": [["jūn"], ["wěi"]],
    "军属": [["jūn"], ["shǔ"]],
    "军校": [["jūn"], ["xiào"]],
    "军种": [["jūn"], ["zhǒng"]],
    "均差": [["jūn"], ["chà"]],
    "君王": [["jūn"], ["wáng"]],
    "均分": [["jūn"], ["fēn"]],
    "俊俏": [["jùn"], ["qiào"]],
    "郡王": [["jùn"], ["wáng"]],
    "郡县": [["jùn"], ["xiàn"]],
    "峻岭": [["jùn"], ["lǐng"]],
    "咔嚓": [["kā"], ["chā"]],
    "咔嗒": [["kā"], ["dā"]],
    "咖啡": [["kā"], ["fēi"]],
    "咖喱": [["gā"], ["lí"]],
    "喀吧": [["kā"], ["bɑ"]],
    "喀嚓": [["kā"], ["chā"]],
    "卡尺": [["kǎ"], ["chǐ"]],
    "卡车": [["kǎ"], ["chē"]],
    "卡带": [["kǎ"], ["dài"]],
    "卡规": [["kǎ"], ["guī"]],
    "卡具": [["qiǎ"], ["jù"]],
    "卡壳": [["qiǎ"], ["ké"]],
    "卡口": [["kǎ"], ["kǒu"]],
    "卡诺": [["kǎ"], ["nuò"]],
    "卡片": [["kǎ"], ["piàn"]],
    "卡其": [["kǎ"], ["qí"]],
    "卡钳": [["kǎ"], ["qián"]],
    "卡通": [["kǎ"], ["tōng"]],
    "卡纸": [["kǎ"], ["zhǐ"]],
    "卡子": [["qiǎ"], ["zi"]],
    "卡座": [["kǎ"], ["zuò"]],
    "开辟": [["kāi"], ["pì"]],
    "开采": [["kāi"], ["cǎi"]],
    "开叉": [["kāi"], ["chā"]],
    "开场": [["kāi"], ["chǎng"]],
    "开车": [["kāi"], ["chē"]],
    "开创": [["kāi"], ["chuàng"]],
    "开打": [["kāi"], ["dǎ"]],
    "开单": [["kāi"], ["dān"]],
    "开发": [["kāi"], ["fā"]],
    "开会": [["kāi"], ["huì"]],
    "开化": [["kāi"], ["huà"]],
    "开豁": [["kāi"], ["huō"]],
    "开价": [["kāi"], ["jià"]],
    "开疆": [["kāi"], ["jiāng"]],
    "开间": [["kāi"], ["jiān"]],
    "开解": [["kāi"], ["jiě"]],
    "开卷": [["kāi"], ["juàn"]],
    "开禁": [["kāi"], ["jìn"]],
    "开裂": [["kāi"], ["liè"]],
    "开溜": [["kāi"], ["liū"]],
    "开蒙": [["kāi"], ["méng"]],
    "开炮": [["kāi"], ["pào"]],
    "开票": [["kāi"], ["piào"]],
    "开屏": [["kāi"], ["píng"]],
    "开台": [["kāi"], ["tái"]],
    "开头": [["kāi"], ["tóu"]],
    "开拓": [["kāi"], ["tuò"]],
    "开戏": [["kāi"], ["xì"]],
    "开行": [["kāi"], ["xíng"]],
    "开远": [["kāi"], ["yuǎn"]],
    "剀切": [["kǎi"], ["qiē"]],
    "凯旋": [["kǎi"], ["xuán"]],
    "楷模": [["kǎi"], ["mó"]],
    "楷体": [["kǎi"], ["tǐ"]],
    "楷书": [["kǎi"], ["shū"]],
    "刊发": [["kān"], ["fā"]],
    "刊头": [["kān"], ["tóu"]],
    "刊行": [["kān"], ["xíng"]],
    "刊载": [["kān"], ["zǎi"]],
    "勘查": [["kān"], ["zhā"]],
    "勘校": [["kān"], ["jiào"]],
    "坎坷": [["kǎn"], ["kě"]],
    "看板": [["kàn"], ["bǎn"]],
    "看扁": [["kàn"], ["biǎn"]],
    "看病": [["kàn"], ["bìng"]],
    "看茶": [["kàn"], ["chá"]],
    "看成": [["kàn"], ["chéng"]],
    "看出": [["kàn"], ["chū"]],
    "看穿": [["kàn"], ["chuān"]],
    "看待": [["kàn"], ["dài"]],
    "看跌": [["kàn"], ["diē"]],
    "看法": [["kàn"], ["fǎ"]],
    "看官": [["kàn"], ["guān"]],
    "看管": [["kān"], ["guǎn"]],
    "看顾": [["kàn"], ["gù"]],
    "看好": [["kàn"], ["hǎo"]],
    "看护": [["kān"], ["hù"]],
    "看家": [["kān"], ["jiā"]],
    "看见": [["kàn"], ["jiàn"]],
    "看开": [["kàn"], ["kāi"]],
    "看看": [["kàn"], ["kàn"]],
    "看客": [["kàn"], ["kè"]],
    "看来": [["kàn"], ["lái"]],
    "看漏": [["kàn"], ["lòu"]],
    "看门": [["kān"], ["mén"]],
    "看盘": [["kàn"], ["pán"]],
    "看破": [["kàn"], ["pò"]],
    "看齐": [["kàn"], ["qí"]],
    "看青": [["kàn"], ["qīng"]],
    "看轻": [["kàn"], ["qīng"]],
    "看清": [["kàn"], ["qīng"]],
    "看上": [["kàn"], ["shàng"]],
    "看守": [["kān"], ["shǒu"]],
    "看书": [["kàn"], ["shū"]],
    "看死": [["kàn"], ["sǐ"]],
    "看台": [["kàn"], ["tái"]],
    "看头": [["kàn"], ["tou"]],
    "看透": [["kàn"], ["tòu"]],
    "看望": [["kàn"], ["wàng"]],
    "看戏": [["kàn"], ["xì"]],
    "看相": [["kàn"], ["xiàng"]],
    "看押": [["kān"], ["yā"]],
    "看涨": [["kàn"], ["zhǎng"]],
    "看中": [["kàn"], ["zhòng"]],
    "看重": [["kàn"], ["zhòng"]],
    "看作": [["kàn"], ["zuò"]],
    "看座": [["kàn"], ["zuò"]],
    "看做": [["kàn"], ["zuò"]],
    "扛鼎": [["gāng"], ["dǐng"]],
    "扛活": [["káng"], ["huó"]],
    "抗暴": [["kàng"], ["bào"]],
    "抗体": [["kàng"], ["tǐ"]],
    "炕几": [["kàng"], ["jǐ"]],
    "炕梢": [["kàng"], ["shāo"]],
    "炕头": [["kàng"], ["tóu"]],
    "考查": [["kǎo"], ["zhā"]],
    "考场": [["kǎo"], ["chǎng"]],
    "考分": [["kǎo"], ["fēn"]],
    "考风": [["kǎo"], ["fēng"]],
    "考核": [["kǎo"], ["hé"]],
    "考据": [["kǎo"], ["jù"]],
    "考卷": [["kǎo"], ["juàn"]],
    "考量": [["kǎo"], ["liáng"]],
    "考期": [["kǎo"], ["qī"]],
    "考区": [["kǎo"], ["qū"]],
    "考中": [["kǎo"], ["zhōng"]],
    "拷打": [["kǎo"], ["dǎ"]],
    "靠背": [["kào"], ["bèi"]],
    "靠泊": [["kào"], ["bó"]],
    "苛待": [["kē"], ["dài"]],
    "坷垃": [["kē"], ["lā"]],
    "苛刻": [["kē"], ["kè"]],
    "苛求": [["kē"], ["qiú"]],
    "苛细": [["kē"], ["xì"]],
    "苛责": [["kē"], ["zé"]],
    "苛政": [["kē"], ["zhèng"]],
    "科教": [["kē"], ["jiào"]],
    "科长": [["kē"], ["zhǎng"]],
    "科员": [["kē"], ["yuán"]],
    "科研": [["kē"], ["yán"]],
    "磕头": [["kē"], ["tóu"]],
    "磕打": [["kē"], ["dǎ"]],
    "壳子": [["ké"], ["zǐ"]],
    "咳喘": [["ké"], ["chuǎn"]],
    "咳咳": [["hāi"], ["hāi"]],
    "咳嗽": [["ké"], ["sòu"]],
    "咳血": [["ké"], ["xuè"]],
    "可爱": [["kě"], ["ài"]],
    "可悲": [["kě"], ["bēi"]],
    "可鄙": [["kě"], ["bǐ"]],
    "可变": [["kě"], ["biàn"]],
    "可不": [["kě"], ["bù"]],
    "可怖": [["kě"], ["bù"]],
    "可耻": [["kě"], ["chǐ"]],
    "可乘": [["kě"], ["chéng"]],
    "可恶": [["kě"], ["wù"]],
    "可否": [["kě"], ["fǒu"]],
    "可观": [["kě"], ["guān"]],
    "可汗": [["kè"], ["hán"]],
    "可贵": [["kě"], ["guì"]],
    "可好": [["kě"], ["hǎo"]],
    "可恨": [["kě"], ["hèn"]],
    "可嘉": [["kě"], ["jiā"]],
    "可见": [["kě"], ["jiàn"]],
    "可敬": [["kě"], ["jìng"]],
    "可鉴": [["kě"], ["jiàn"]],
    "可靠": [["kě"], ["kào"]],
    "可可": [["kě"], ["kě"]],
    "可口": [["kě"], ["kǒu"]],
    "可乐": [["kě"], ["lè"]],
    "可怜": [["kě"], ["lián"]],
    "可能": [["kě"], ["néng"]],
    "可恼": [["kě"], ["nǎo"]],
    "可逆": [["kě"], ["nì"]],
    "可怕": [["kě"], ["pà"]],
    "可欺": [["kě"], ["qī"]],
    "可气": [["kě"], ["qì"]],
    "可亲": [["kě"], ["qīn"]],
    "可巧": [["kě"], ["qiǎo"]],
    "可取": [["kě"], ["qǔ"]],
    "可人": [["kě"], ["rén"]],
    "可是": [["kě"], ["shì"]],
    "可叹": [["kě"], ["tàn"]],
    "可听": [["kě"], ["tīng"]],
    "可望": [["kě"], ["wàng"]],
    "可谓": [["kě"], ["wèi"]],
    "可惜": [["kě"], ["xī"]],
    "可喜": [["kě"], ["xǐ"]],
    "可笑": [["kě"], ["xiào"]],
    "可心": [["kě"], ["xīn"]],
    "可信": [["kě"], ["xìn"]],
    "可行": [["kě"], ["xíng"]],
    "可疑": [["kě"], ["yí"]],
    "可以": [["kě"], ["yǐ"]],
    "可意": [["kě"], ["yì"]],
    "可曾": [["kě"], ["zēng"]],
    "可憎": [["kě"], ["zēng"]],
    "可知": [["kě"], ["zhī"]],
    "可着": [["kě"], ["zhe"]],
    "克服": [["kè"], ["fú"]],
    "克拉": [["kè"], ["lā"]],
    "克期": [["kè"], ["qī"]],
    "克食": [["kè"], ["shí"]],
    "刻薄": [["kè"], ["bó"]],
    "刻毒": [["kè"], ["dú"]],
    "刻度": [["kè"], ["dù"]],
    "刻骨": [["kè"], ["gǔ"]],
    "刻划": [["kè"], ["huá"]],
    "客车": [["kè"], ["chē"]],
    "客家": [["kè"], ["jiā"]],
    "客观": [["kè"], ["guān"]],
    "客票": [["kè"], ["piào"]],
    "客体": [["kè"], ["tǐ"]],
    "课长": [["kè"], ["cháng"]],
    "课间": [["kè"], ["jiān"]],
    "课卷": [["kè"], ["juàn"]],
    "肯綮": [["kěn"], ["qìng"]],
    "垦殖": [["kěn"], ["zhí"]],
    "垦区": [["kěn"], ["qū"]],
    "垦种": [["kěn"], ["zhòng"]],
    "恳切": [["kěn"], ["qiè"]],
    "吭哧": [["kēng"], ["chī"]],
    "吭气": [["kēng"], ["qì"]],
    "吭声": [["kēng"], ["shēng"]],
    "坑蒙": [["kēng"], ["méng"]],
    "空白": [["kòng"], ["bái"]],
    "空瘪": [["kōng"], ["biě"]],
    "空肠": [["kōng"], ["cháng"]],
    "空场": [["kōng"], ["chǎng"]],
    "空城": [["kōng"], ["chéng"]],
    "空当": [["kōng"], ["dāng"]],
    "空挡": [["kōng"], ["dǎng"]],
    "空档": [["kōng"], ["dàng"]],
    "空地": [["kòng"], ["dì"]],
    "空调": [["kōng"], ["tiáo"]],
    "空洞": [["kōng"], ["dòng"]],
    "空儿": [["kòng"], ["ér"]],
    "空额": [["kòng"], ["é"]],
    "空乏": [["kōng"], ["fá"]],
    "空泛": [["kōng"], ["fàn"]],
    "空防": [["kōng"], ["fáng"]],
    "空腹": [["kōng"], ["fù"]],
    "空房": [["kōng"], ["fáng"]],
    "空格": [["kōng"], ["gé"]],
    "空谷": [["kōng"], ["gǔ"]],
    "空海": [["kōng"], ["hǎi"]],
    "空耗": [["kōng"], ["hào"]],
    "空喊": [["kōng"], ["hǎn"]],
    "空话": [["kōng"], ["huà"]],
    "空怀": [["kōng"], ["huái"]],
    "空幻": [["kōng"], ["huàn"]],
    "空际": [["kōng"], ["jì"]],
    "空寂": [["kōng"], ["jì"]],
    "空间": [["kōng"], ["jiān"]],
    "空姐": [["kōng"], ["jiě"]],
    "空降": [["kōng"], ["jiàng"]],
    "空军": [["kōng"], ["jūn"]],
    "空壳": [["kōng"], ["ké"]],
    "空空": [["kōng"], ["kōng"]],
    "空口": [["kōng"], ["kǒu"]],
    "空旷": [["kōng"], ["kuàng"]],
    "空阔": [["kōng"], ["kuò"]],
    "空廓": [["kōng"], ["kuò"]],
    "空灵": [["kōng"], ["líng"]],
    "空论": [["kōng"], ["lùn"]],
    "空落": [["kōng"], ["luò"]],
    "空门": [["kōng"], ["mén"]],
    "空名": [["kōng"], ["míng"]],
    "空明": [["kōng"], ["míng"]],
    "空难": [["kōng"], ["nàn"]],
    "空炮": [["kōng"], ["pào"]],
    "空气": [["kōng"], ["qì"]],
    "空腔": [["kōng"], ["qiāng"]],
    "空前": [["kōng"], ["qián"]],
    "空勤": [["kōng"], ["qín"]],
    "空拳": [["kōng"], ["quán"]],
    "空缺": [["kòng"], ["quē"]],
    "空身": [["kōng"], ["shēn"]],
    "空手": [["kōng"], ["shǒu"]],
    "空疏": [["kōng"], ["shū"]],
    "空速": [["kōng"], ["sù"]],
    "空谈": [["kōng"], ["tán"]],
    "空头": [["kōng"], ["tóu"]],
    "空投": [["kōng"], ["tóu"]],
    "空位": [["kōng"], ["wèi"]],
    "空文": [["kōng"], ["wén"]],
    "空袭": [["kōng"], ["xí"]],
    "空无": [["kōng"], ["wú"]],
    "空隙": [["kòng"], ["xì"]],
    "空暇": [["kòng"], ["xiá"]],
    "空闲": [["kòng"], ["xián"]],
    "空想": [["kōng"], ["xiǎng"]],
    "空心": [["kōng"], ["xīn"]],
    "空穴": [["kōng"], ["xué"]],
    "空虚": [["kōng"], ["xū"]],
    "空言": [["kōng"], ["yán"]],
    "空余": [["kòng"], ["yú"]],
    "空有": [["kōng"], ["yǒu"]],
    "空运": [["kōng"], ["yùn"]],
    "空中": [["kōng"], ["zhōng"]],
    "空战": [["kōng"], ["zhàn"]],
    "空竹": [["kōng"], ["zhú"]],
    "空转": [["kōng"], ["zhuàn"]],
    "空子": [["kòng"], ["zi"]],
    "倥侗": [["kōng"], ["tóng"]],
    "孔教": [["kǒng"], ["jiào"]],
    "孔雀": [["kǒng"], ["què"]],
    "恐吓": [["kǒng"], ["hè"]],
    "芤脉": [["kōu"], ["mài"]],
    "口北": [["kǒu"], ["běi"]],
    "口称": [["kǒu"], ["chēng"]],
    "口臭": [["kǒu"], ["chòu"]],
    "口传": [["kǒu"], ["chuán"]],
    "口风": [["kǒu"], ["fēng"]],
    "口服": [["kǒu"], ["fú"]],
    "口供": [["kǒu"], ["gòng"]],
    "口号": [["kǒu"], ["hào"]],
    "口红": [["kǒu"], ["hóng"]],
    "口角": [["kǒu"], ["jué"]],
    "口令": [["kǒu"], ["lìng"]],
    "口条": [["kǒu"], ["tiáo"]],
    "口头": [["kǒu"], ["tóu"]],
    "口信": [["kǒu"], ["xìn"]],
    "口语": [["kǒu"], ["yǔ"]],
    "口重": [["kǒu"], ["zhòng"]],
    "叩见": [["kòu"], ["jiàn"]],
    "叩头": [["kòu"], ["tóu"]],
    "扣发": [["kòu"], ["fā"]],
    "扣分": [["kòu"], ["fēn"]],
    "扣头": [["kòu"], ["tóu"]],
    "扣压": [["kòu"], ["yā"]],
    "枯干": [["kū"], ["gān"]],
    "枯骨": [["kū"], ["gǔ"]],
    "枯叶": [["kū"], ["yè"]],
    "枯枝": [["kū"], ["zhī"]],
    "哭丧": [["kū"], ["sang"]],
    "苦熬": [["kǔ"], ["áo"]],
    "苦参": [["kǔ"], ["shēn"]],
    "苦差": [["kǔ"], ["chāi"]],
    "苦斗": [["kǔ"], ["dòu"]],
    "苦处": [["kǔ"], ["chǔ"]],
    "苦干": [["kǔ"], ["gàn"]],
    "苦闷": [["kǔ"], ["mèn"]],
    "苦思": [["kǔ"], ["sī"]],
    "苦难": [["kǔ"], ["nàn"]],
    "苦头": [["kǔ"], ["tóu"]],
    "苦相": [["kǔ"], ["xiāng"]],
    "苦行": [["kǔ"], ["xíng"]],
    "库藏": [["kù"], ["cáng"]],
    "苦雨": [["kǔ"], ["yǔ"]],
    "库券": [["kù"], ["quàn"]],
    "裤头": [["kù"], ["tóu"]],
    "酷似": [["kù"], ["sì"]],
    "酷肖": [["kù"], ["xiāo"]],
    "夸大": [["kuā"], ["dà"]],
    "夸奖": [["kuā"], ["jiǎng"]],
    "夸诞": [["kuā"], ["dàn"]],
    "夸口": [["kuā"], ["kǒu"]],
    "夸示": [["kuā"], ["shì"]],
    "夸饰": [["kuā"], ["shì"]],
    "夸说": [["kuā"], ["shuō"]],
    "夸特": [["kuā"], ["tè"]],
    "夸耀": [["kuā"], ["yào"]],
    "夸脱": [["kuā"], ["tuō"]],
    "夸张": [["kuā"], ["zhāng"]],
    "夸赞": [["kuā"], ["zàn"]],
    "夸嘴": [["kuā"], ["zuǐ"]],
    "垮台": [["kuǎ"], ["tái"]],
    "挎包": [["kuà"], ["bāo"]],
    "挎斗": [["kuà"], ["dǒu"]],
    "胯骨": [["kuà"], ["gǔ"]],
    "跨度": [["kuà"], ["dù"]],
    "块头": [["kuài"], ["tóu"]],
    "块体": [["kuài"], ["tǐ"]],
    "快车": [["kuài"], ["chē"]],
    "快当": [["kuài"], ["dāng"]],
    "快乐": [["kuài"], ["lè"]],
    "快信": [["kuài"], ["xìn"]],
    "快行": [["kuài"], ["xíng"]],
    "快要": [["kuài"], ["yào"]],
    "宽绰": [["kuān"], ["chuo"]],
    "快语": [["kuài"], ["yǔ"]],
    "宽大": [["kuān"], ["dà"]],
    "宽待": [["kuān"], ["dài"]],
    "宽度": [["kuān"], ["dù"]],
    "宽广": [["kuān"], ["guǎng"]],
    "宽和": [["kuān"], ["hé"]],
    "宽解": [["kuān"], ["jiě"]],
    "宽假": [["kuān"], ["jiǎ"]],
    "髋骨": [["kuān"], ["gǔ"]],
    "款待": [["kuǎn"], ["dài"]],
    "款曲": [["kuǎn"], ["qǔ"]],
    "款识": [["kuǎn"], ["zhì"]],
    "匡济": [["kuāng"], ["jì"]],
    "匡正": [["kuāng"], ["zhèng"]],
    "匡助": [["kuāng"], ["zhù"]],
    "狂暴": [["kuáng"], ["bào"]],
    "狂奔": [["kuáng"], ["bēn"]],
    "狂风": [["kuáng"], ["fēng"]],
    "诳语": [["kuáng"], ["yǔ"]],
    "况且": [["kuàng"], ["qiě"]],
    "旷远": [["kuàng"], ["yuǎn"]],
    "矿藏": [["kuàng"], ["cáng"]],
    "矿车": [["kuàng"], ["chē"]],
    "矿脉": [["kuàng"], ["mài"]],
    "矿区": [["kuàng"], ["qū"]],
    "矿体": [["kuàng"], ["tǐ"]],
    "矿石": [["kuàng"], ["shí"]],
    "亏待": [["kuī"], ["dài"]],
    "亏得": [["kuī"], ["de"]],
    "亏累": [["kuī"], ["lèi"]],
    "亏空": [["kuī"], ["kōng"]],
    "亏折": [["kuī"], ["zhé"]],
    "窥度": [["kuī"], ["duó"]],
    "窥见": [["kuī"], ["jiàn"]],
    "窥看": [["kuī"], ["kàn"]],
    "窥伺": [["kuī"], ["sì"]],
    "奎宁": [["kuí"], ["níng"]],
    "喹啉": [["kuí"], ["lín"]],
    "葵扇": [["kuí"], ["shàn"]],
    "蝰蛇": [["kuí"], ["shé"]],
    "傀儡": [["kuǐ"], ["lěi"]],
    "愧汗": [["kuì"], ["hàn"]],
    "愧怍": [["kuì"], ["zuò"]],
    "溃败": [["kuì"], ["bài"]],
    "溃兵": [["kuì"], ["bīng"]],
    "溃决": [["kuì"], ["jué"]],
    "溃军": [["kuì"], ["jūn"]],
    "溃烂": [["kuì"], ["làn"]],
    "溃乱": [["kuì"], ["luàn"]],
    "溃灭": [["kuì"], ["miè"]],
    "溃散": [["kuì"], ["sàn"]],
    "溃逃": [["kuì"], ["táo"]],
    "溃围": [["kuì"], ["wéi"]],
    "溃退": [["kuì"], ["tuì"]],
    "溃疡": [["kuì"], ["yáng"]],
    "昆曲": [["kūn"], ["qǔ"]],
    "捆扎": [["kǔn"], ["zhā"]],
    "困处": [["kùn"], ["chǔ"]],
    "困觉": [["kùn"], ["jiào"]],
    "困难": [["kùn"], ["nán"]],
    "扩散": [["kuò"], ["sàn"]],
    "扩大": [["kuò"], ["dà"]],
    "括号": [["kuò"], ["hào"]],
    "括弧": [["kuò"], ["hú"]],
    "阔别": [["kuò"], ["bié"]],
    "阔绰": [["kuò"], ["chuò"]],
    "阔少": [["kuò"], ["shào"]],
    "廓落": [["kuò"], ["luò"]],
    "拉巴": [["lā"], ["bā"]],
    "拉拔": [["lā"], ["bá"]],
    "拉长": [["lā"], ["cháng"]],
    "拉扯": [["lā"], ["chě"]],
    "拉倒": [["lā"], ["dǎo"]],
    "拉德": [["lā"], ["dé"]],
    "拉丁": [["lā"], ["dīng"]],
    "拉杆": [["lā"], ["gǎn"]],
    "拉架": [["lā"], ["jià"]],
    "拉脚": [["lā"], ["jiǎo"]],
    "拉锯": [["lā"], ["jù"]],
    "拉开": [["lā"], ["kāi"]],
    "拉客": [["lā"], ["kè"]],
    "拉拉": [["lā"], ["lā"]],
    "拉力": [["lā"], ["lì"]],
    "拉练": [["lā"], ["liàn"]],
    "拉链": [["lā"], ["liàn"]],
    "拉拢": [["lā"], ["lǒng"]],
    "拉面": [["lā"], ["miàn"]],
    "拉平": [["lā"], ["píng"]],
    "拉人": [["lā"], ["rén"]],
    "拉萨": [["lā"], ["sà"]],
    "拉伸": [["lā"], ["shēn"]],
    "拉手": [["lā"], ["shǒu"]],
    "拉丝": [["lā"], ["sī"]],
    "拉套": [["lā"], ["tào"]],
    "拉网": [["lā"], ["wǎng"]],
    "拉稀": [["lā"], ["xī"]],
    "拉纤": [["lā"], ["qiàn"]],
    "拉线": [["lā"], ["xiàn"]],
    "拉杂": [["lā"], ["zá"]],
    "拉账": [["lā"], ["zhàng"]],
    "喇嘛": [["lǎ"], ["mɑ"]],
    "腊八": [["là"], ["bā"]],
    "腊肠": [["là"], ["cháng"]],
    "腊梅": [["là"], ["méi"]],
    "腊日": [["là"], ["rì"]],
    "腊肉": [["là"], ["ròu"]],
    "腊味": [["là"], ["wèi"]],
    "腊月": [["là"], ["yuè"]],
    "蜡台": [["là"], ["tái"]],
    "来得": [["lái"], ["de"]],
    "来劲": [["lái"], ["jìn"]],
    "来苏": [["lái"], ["sū"]],
    "来头": [["lái"], ["tou"]],
    "来信": [["lái"], ["xìn"]],
    "来着": [["lái"], ["zhe"]],
    "兰若": [["lán"], ["rě"]],
    "拦挡": [["lán"], ["dǎng"]],
    "拦柜": [["lán"], ["guì"]],
    "栏干": [["lán"], ["gàn"]],
    "栏杆": [["lán"], ["gān"]],
    "栏柜": [["lán"], ["guì"]],
    "栏栅": [["lán"], ["shān"]],
    "阑尾": [["lán"], ["wěi"]],
    "阑干": [["lán"], ["gān"]],
    "缆车": [["lǎn"], ["chē"]],
    "懒得": [["lǎn"], ["de"]],
    "懒散": [["lǎn"], ["sǎn"]],
    "烂糊": [["làn"], ["hú"]],
    "烂泥": [["làn"], ["ní"]],
    "滥调": [["làn"], ["diào"]],
    "郎君": [["láng"], ["jūn"]],
    "郎当": [["láng"], ["dāng"]],
    "郎舅": [["láng"], ["jiù"]],
    "郎中": [["láng"], ["zhōng"]],
    "狼毒": [["láng"], ["dú"]],
    "狼藉": [["láng"], ["jí"]],
    "狼头": [["láng"], ["tóu"]],
    "莨菪": [["làng"], ["dàng"]],
    "锒铛": [["láng"], ["dāng"]],
    "榔头": [["láng"], ["tou"]],
    "朗读": [["lǎng"], ["dú"]],
    "浪头": [["làng"], ["tou"]],
    "劳教": [["láo"], ["jiào"]],
    "劳累": [["láo"], ["lèi"]],
    "劳碌": [["láo"], ["lù"]],
    "劳模": [["láo"], ["mó"]],
    "牢度": [["láo"], ["dù"]],
    "牢笼": [["láo"], ["lóng"]],
    "牢骚": [["láo"], ["sāo"]],
    "唠扯": [["lào"], ["chě"]],
    "唠叨": [["láo"], ["dāo"]],
    "唠嗑": [["lào"], ["kè"]],
    "唠唠": [["lào"], ["lào"]],
    "老伯": [["lǎo"], ["bó"]],
    "老大": [["lǎo"], ["dà"]],
    "老底": [["lǎo"], ["dǐ"]],
    "老弟": [["lǎo"], ["dì"]],
    "老调": [["lǎo"], ["diào"]],
    "老夫": [["lǎo"], ["fū"]],
    "老父": [["lǎo"], ["fù"]],
    "老化": [["lǎo"], ["huà"]],
    "老几": [["lǎo"], ["jǐ"]],
    "老家": [["lǎo"], ["jiā"]],
    "老将": [["lǎo"], ["jiàng"]],
    "老亲": [["lǎo"], ["qīn"]],
    "老景": [["lǎo"], ["jǐng"]],
    "老区": [["lǎo"], ["ōu"]],
    "老少": [["lǎo"], ["shào"]],
    "老汤": [["lǎo"], ["tāng"]],
    "老头": [["lǎo"], ["tóu"]],
    "老相": [["lǎo"], ["xiāng"]],
    "姥姥": [["lǎo"], ["lao"]],
    "潦草": [["liáo"], ["cǎo"]],
    "潦倒": [["liáo"], ["dǎo"]],
    "烙饼": [["lào"], ["bǐng"]],
    "烙痕": [["lào"], ["hén"]],
    "烙花": [["lào"], ["huā"]],
    "乐安": [["lè"], ["ān"]],
    "烙铁": [["lào"], ["tiě"]],
    "烙印": [["lào"], ["yìn"]],
    "乐池": [["yuè"], ["chí"]],
    "乐道": [["lè"], ["dào"]],
    "乐得": [["lè"], ["de"]],
    "乐都": [["lè"], ["dōu"]],
    "乐队": [["yuè"], ["duì"]],
    "乐儿": [["lè"], ["ér"]],
    "乐府": [["yuè"], ["fǔ"]],
    "乐感": [["yuè"], ["gǎn"]],
    "乐歌": [["yuè"], ["gē"]],
    "乐工": [["yuè"], ["gōng"]],
    "乐观": [["lè"], ["guān"]],
    "乐官": [["yuè"], ["guān"]],
    "乐果": [["lè"], ["guǒ"]],
    "乐户": [["yuè"], ["hù"]],
    "乐句": [["lè"], ["jù"]],
    "乐理": [["lè"], ["lǐ"]],
    "乐律": [["yuè"], ["lǜ"]],
    "乐迷": [["yuè"], ["mí"]],
    "乐谱": [["yuè"], ["pǔ"]],
    "乐器": [["yuè"], ["qì"]],
    "乐曲": [["yuè"], ["qǔ"]],
    "乐趣": [["lè"], ["qù"]],
    "乐山": [["lè"], ["shān"]],
    "乐师": [["yuè"], ["shī"]],
    "乐事": [["lè"], ["shì"]],
    "乐手": [["lè"], ["shǒu"]],
    "乐坛": [["yuè"], ["tán"]],
    "乐天": [["lè"], ["tiān"]],
    "乐团": [["yuè"], ["tuán"]],
    "乐土": [["lè"], ["tǔ"]],
    "乐舞": [["yuè"], ["wǔ"]],
    "乐业": [["lè"], ["yè"]],
    "乐意": [["lè"], ["yì"]],
    "乐音": [["yuè"], ["yīn"]],
    "乐于": [["lè"], ["yú"]],
    "乐园": [["lè"], ["yuán"]],
    "乐章": [["yuè"], ["zhāng"]],
    "乐子": [["lè"], ["zǐ"]],
    "雷暴": [["léi"], ["bào"]],
    "雷同": [["léi"], ["tóng"]],
    "雷雨": [["léi"], ["yǔ"]],
    "磊落": [["lěi"], ["luò"]],
    "肋骨": [["lèi"], ["gǔ"]],
    "肋木": [["lèi"], ["mù"]],
    "肋条": [["lèi"], ["tiáo"]],
    "类别": [["lèi"], ["bié"]],
    "类同": [["lèi"], ["tóng"]],
    "类似": [["lèi"], ["sì"]],
    "擂鼓": [["léi"], ["gǔ"]],
    "擂台": [["lèi"], ["tái"]],
    "擂主": [["lèi"], ["zhǔ"]],
    "棱角": [["léng"], ["jiǎo"]],
    "棱镜": [["léng"], ["jìng"]],
    "棱线": [["léng"], ["xiàn"]],
    "棱锥": [["léng"], ["zhuī"]],
    "棱柱": [["léng"], ["zhù"]],
    "楞场": [["léng"], ["chǎng"]],
    "楞伽": [["léng"], ["jiā"]],
    "冷藏": [["lěng"], ["cáng"]],
    "冷颤": [["lěng"], ["zhàn"]],
    "冷场": [["lěng"], ["chǎng"]],
    "冷嘲": [["lěng"], ["cháo"]],
    "冷风": [["lěng"], ["fēng"]],
    "冷汗": [["lěng"], ["hàn"]],
    "冷落": [["lěng"], ["luò"]],
    "冷食": [["lěng"], ["shí"]],
    "冷语": [["lěng"], ["yǔ"]],
    "厘正": [["lí"], ["zhèng"]],
    "狸猫": [["lí"], ["māo"]],
    "离合": [["lí"], ["hé"]],
    "离别": [["lí"], ["bié"]],
    "离间": [["lí"], ["jiàn"]],
    "离解": [["lí"], ["jiě"]],
    "离奇": [["lí"], ["qí"]],
    "离任": [["lí"], ["rèn"]],
    "离散": [["lí"], ["sàn"]],
    "离骚": [["lí"], ["sāo"]],
    "离休": [["lí"], ["xiū"]],
    "篱落": [["lí"], ["luò"]],
    "篱栅": [["lí"], ["zhà"]],
    "罹难": [["lí"], ["nàn"]],
    "礼单": [["lǐ"], ["dān"]],
    "礼服": [["lǐ"], ["fú"]],
    "礼佛": [["lǐ"], ["fó"]],
    "礼教": [["lǐ"], ["jiào"]],
    "礼乐": [["lǐ"], ["yuè"]],
    "礼节": [["lǐ"], ["jié"]],
    "礼炮": [["lǐ"], ["pào"]],
    "礼券": [["lǐ"], ["quàn"]],
    "礼数": [["lǐ"], ["shù"]],
    "礼帖": [["lǐ"], ["tiě"]],
    "里间": [["lǐ"], ["jiān"]],
    "里拉": [["lǐ"], ["lā"]],
    "里弄": [["lǐ"], ["lòng"]],
    "里头": [["lǐ"], ["tou"]],
    "里巷": [["lǐ"], ["xiàng"]],
    "俚曲": [["lǐ"], ["qǔ"]],
    "俚语": [["lǐ"], ["yǔ"]],
    "逦迤": [["lǐ"], ["yǐ"]],
    "力场": [["lì"], ["chǎng"]],
    "力臂": [["lì"], ["bì"]],
    "力度": [["lì"], ["dù"]],
    "力尽": [["lì"], ["jìn"]],
    "力量": [["lì"], ["liàng"]],
    "历朝": [["lì"], ["cháo"]],
    "力行": [["lì"], ["xíng"]],
    "历尽": [["lì"], ["jìn"]],
    "历任": [["lì"], ["rèn"]],
    "历数": [["lì"], ["shǔ"]],
    "厉行": [["lì"], ["xíng"]],
    "立场": [["lì"], ["chǎng"]],
    "立地": [["lì"], ["dì"]],
    "立柜": [["lì"], ["guì"]],
    "立论": [["lì"], ["lùn"]],
    "立射": [["lì"], ["shè"]],
    "立体": [["lì"], ["tǐ"]],
    "立约": [["lì"], ["yuē"]],
    "立正": [["lì"], ["zhèng"]],
    "立轴": [["lì"], ["zhóu"]],
    "丽都": [["lì"], ["dū"]],
    "丽人": [["lì"], ["rén"]],
    "丽日": [["lì"], ["rì"]],
    "丽水": [["lí"], ["shuǐ"]],
    "利得": [["lì"], ["de"]],
    "丽质": [["lì"], ["zhì"]],
    "利率": [["lì"], ["lǜ"]],
    "利落": [["lì"], ["luò"]],
    "利尿": [["lì"], ["niào"]],
    "励行": [["lì"], ["xíng"]],
    "例会": [["lì"], ["huì"]],
    "例假": [["lì"], ["jià"]],
    "例句": [["lì"], ["jù"]],
    "例行": [["lì"], ["xíng"]],
    "隶农": [["lì"], ["nóng"]],
    "隶书": [["lì"], ["shū"]],
    "隶属": [["lì"], ["shǔ"]],
    "隶字": [["lì"], ["zì"]],
    "隶卒": [["lì"], ["zú"]],
    "俐落": [["lì"], ["luò"]],
    "栎木": [["lì"], ["mù"]],
    "栎树": [["lì"], ["shù"]],
    "荔枝": [["lì"], ["zhī"]],
    "栗暴": [["lì"], ["bào"]],
    "砺石": [["lì"], ["shí"]],
    "砾石": [["lì"], ["shí"]],
    "连长": [["lián"], ["cháng"]],
    "连发": [["lián"], ["fā"]],
    "连番": [["lián"], ["fān"]],
    "连杆": [["lián"], ["gǎn"]],
    "连合": [["lián"], ["hé"]],
    "连横": [["lián"], ["héng"]],
    "连累": [["lián"], ["lěi"]],
    "连结": [["lián"], ["jié"]],
    "莲台": [["lián"], ["tái"]],
    "联大": [["lián"], ["dà"]],
    "联合": [["lián"], ["hé"]],
    "联华": [["lián"], ["huá"]],
    "联结": [["lián"], ["jié"]],
    "联句": [["lián"], ["jù"]],
    "联络": [["lián"], ["luò"]],
    "联票": [["lián"], ["piào"]],
    "联体": [["lián"], ["tǐ"]],
    "联系": [["lián"], ["xì"]],
    "廉价": [["lián"], ["jià"]],
    "廉正": [["lián"], ["zhèng"]],
    "练漂": [["liàn"], ["piāo"]],
    "炼钢": [["liàn"], ["gāng"]],
    "炼句": [["liàn"], ["jù"]],
    "恋家": [["liàn"], ["jiā"]],
    "链结": [["liàn"], ["jié"]],
    "链条": [["liàn"], ["tiáo"]],
    "良好": [["liáng"], ["hǎo"]],
    "良家": [["liáng"], ["jiā"]],
    "良能": [["liáng"], ["néng"]],
    "良将": [["liáng"], ["jiàng"]],
    "良知": [["liáng"], ["zhī"]],
    "良种": [["liáng"], ["zhǒng"]],
    "凉拌": [["liáng"], ["bàn"]],
    "凉菜": [["liáng"], ["cài"]],
    "凉粉": [["liáng"], ["fěn"]],
    "凉快": [["liáng"], ["kuài"]],
    "凉风": [["liáng"], ["fēng"]],
    "凉帽": [["liáng"], ["mào"]],
    "凉面": [["liáng"], ["miàn"]],
    "凉棚": [["liáng"], ["péng"]],
    "凉气": [["liáng"], ["qì"]],
    "凉爽": [["liáng"], ["shuǎng"]],
    "凉水": [["liáng"], ["shuǐ"]],
    "凉台": [["liáng"], ["tái"]],
    "凉亭": [["liáng"], ["tíng"]],
    "凉席": [["liáng"], ["xí"]],
    "凉鞋": [["liáng"], ["xié"]],
    "凉药": [["liáng"], ["yào"]],
    "凉意": [["liáng"], ["yì"]],
    "粮票": [["liáng"], ["piào"]],
    "粮食": [["liáng"], ["shí"]],
    "粮行": [["liáng"], ["háng"]],
    "踉跄": [["liàng"], ["qiàng"]],
    "两便": [["liǎng"], ["biàn"]],
    "两侧": [["liǎng"], ["cè"]],
    "两当": [["liǎng"], ["dāng"]],
    "两地": [["liǎng"], ["dì"]],
    "两个": [["liǎng"], ["gè"]],
    "两广": [["liǎng"], ["guǎng"]],
    "两可": [["liǎng"], ["kě"]],
    "两旁": [["liǎng"], ["páng"]],
    "两难": [["liǎng"], ["nán"]],
    "两栖": [["liǎng"], ["qī"]],
    "两头": [["liǎng"], ["tóu"]],
    "亮底": [["liàng"], ["dǐ"]],
    "亮度": [["liàng"], ["dù"]],
    "亮相": [["liàng"], ["xiàng"]],
    "谅解": [["liàng"], ["jiě"]],
    "晾干": [["liàng"], ["gān"]],
    "晾台": [["liàng"], ["tái"]],
    "量杯": [["liáng"], ["bēi"]],
    "量变": [["liàng"], ["biàn"]],
    "量程": [["liáng"], ["chéng"]],
    "量词": [["liàng"], ["cí"]],
    "量度": [["liáng"], ["dù"]],
    "量纲": [["liàng"], ["gāng"]],
    "量规": [["liáng"], ["guī"]],
    "量计": [["liáng"], ["jì"]],
    "量具": [["liáng"], ["jù"]],
    "量力": [["liàng"], ["lì"]],
    "量能": [["liàng"], ["néng"]],
    "量瓶": [["liáng"], ["píng"]],
    "量筒": [["liáng"], ["tǒng"]],
    "量器": [["liáng"], ["qì"]],
    "量刑": [["liàng"], ["xíng"]],
    "量子": [["liàng"], ["zǐ"]],
    "辽远": [["liáo"], ["yuǎn"]],
    "僚属": [["liáo"], ["shǔ"]],
    "寥落": [["liáo"], ["luò"]],
    "撩拨": [["liáo"], ["bō"]],
    "撩动": [["liáo"], ["dòng"]],
    "撩开": [["liáo"], ["kāi"]],
    "撩逗": [["liáo"], ["dòu"]],
    "撩乱": [["liáo"], ["luàn"]],
    "燎泡": [["liáo"], ["pào"]],
    "燎原": [["liáo"], ["yuán"]],
    "了当": [["liǎo"], ["dàng"]],
    "了得": [["liǎo"], ["de"]],
    "了断": [["liǎo"], ["duàn"]],
    "了结": [["liǎo"], ["jié"]],
    "了解": [["liǎo"], ["jiě"]],
    "了局": [["liǎo"], ["jú"]],
    "了了": [["liǎo"], ["liǎo"]],
    "了却": [["liǎo"], ["què"]],
    "了然": [["liǎo"], ["rán"]],
    "了事": [["liǎo"], ["shì"]],
    "了无": [["liǎo"], ["wú"]],
    "了悟": [["liǎo"], ["wù"]],
    "了账": [["liǎo"], ["zhàng"]],
    "料斗": [["liào"], ["dǒu"]],
    "料量": [["liào"], ["liàng"]],
    "料石": [["liào"], ["shí"]],
    "瞭望": [["liào"], ["wàng"]],
    "咧嘴": [["liě"], ["zuǐ"]],
    "咧咧": [["liē"], ["liē"]],
    "列车": [["liè"], ["chē"]],
    "列传": [["liè"], ["zhuàn"]],
    "列强": [["liè"], ["qiáng"]],
    "劣种": [["liè"], ["zhǒng"]],
    "烈度": [["liè"], ["dù"]],
    "烈风": [["liè"], ["fēng"]],
    "烈女": [["liè"], ["nǚ"]],
    "烈属": [["liè"], ["shǔ"]],
    "裂变": [["liè"], ["biàn"]],
    "裂帛": [["liè"], ["bó"]],
    "裂缝": [["liè"], ["fèng"]],
    "裂谷": [["liè"], ["gǔ"]],
    "裂果": [["liè"], ["guǒ"]],
    "裂痕": [["liè"], ["hén"]],
    "裂开": [["liè"], ["kāi"]],
    "裂口": [["liè"], ["kǒu"]],
    "裂片": [["liè"], ["piàn"]],
    "裂纹": [["liè"], ["wén"]],
    "裂璺": [["liè"], ["wèn"]],
    "趔趄": [["liè"], ["qie"]],
    "裂隙": [["liè"], ["xì"]],
    "邻角": [["lín"], ["jiǎo"]],
    "邻家": [["lín"], ["jiā"]],
    "林场": [["lín"], ["chǎng"]],
    "林地": [["lín"], ["dì"]],
    "林甸": [["lín"], ["diàn"]],
    "林冠": [["lín"], ["guān"]],
    "林区": [["lín"], ["qū"]],
    "临别": [["lín"], ["bié"]],
    "临场": [["lín"], ["chǎng"]],
    "临朝": [["lín"], ["cháo"]],
    "临风": [["lín"], ["fēng"]],
    "临了": [["lín"], ["le"]],
    "临难": [["lín"], ["nàn"]],
    "临帖": [["lín"], ["tiè"]],
    "临头": [["lín"], ["tóu"]],
    "临行": [["lín"], ["xíng"]],
    "淋病": [["lìn"], ["bìng"]],
    "淋淋": [["lín"], ["lín"]],
    "淋雨": [["lín"], ["yǔ"]],
    "淋浴": [["lín"], ["yù"]],
    "霖雨": [["lín"], ["yǔ"]],
    "鳞片": [["lín"], ["piàn"]],
    "鳞爪": [["lín"], ["zhǎo"]],
    "檩条": [["lǐn"], ["tiáo"]],
    "灵便": [["líng"], ["biàn"]],
    "灵车": [["líng"], ["chē"]],
    "灵猫": [["líng"], ["māo"]],
    "灵蛇": [["líng"], ["shé"]],
    "岭南": [["lǐng"], ["nán"]],
    "凌空": [["líng"], ["kōng"]],
    "铃铛": [["líng"], ["dang"]],
    "零度": [["líng"], ["dù"]],
    "零落": [["líng"], ["luò"]],
    "零散": [["líng"], ["sǎn"]],
    "零食": [["líng"], ["shí"]],
    "零数": [["líng"], ["shù"]],
    "零头": [["líng"], ["tóu"]],
    "领教": [["lǐng"], ["jiào"]],
    "令爱": [["lìng"], ["ài"]],
    "令嫒": [["lìng"], ["ài"]],
    "令狐": [["líng"], ["hú"]],
    "令弟": [["lìng"], ["dì"]],
    "令箭": [["lìng"], ["jiàn"]],
    "令节": [["lìng"], ["jié"]],
    "令郎": [["lìng"], ["láng"]],
    "令牌": [["lìng"], ["pái"]],
    "令妹": [["lìng"], ["mèi"]],
    "令亲": [["lìng"], ["qīn"]],
    "令旗": [["lìng"], ["qí"]],
    "令人": [["lìng"], ["rén"]],
    "令兄": [["lìng"], ["xiōng"]],
    "令堂": [["lìng"], ["táng"]],
    "令媛": [["lìng"], ["yuàn"]],
    "令誉": [["lìng"], ["yù"]],
    "令状": [["lìng"], ["zhuàng"]],
    "令尊": [["lìng"], ["zūn"]],
    "另行": [["lìng"], ["xíng"]],
    "溜边": [["liū"], ["biān"]],
    "溜冰": [["liū"], ["bīng"]],
    "溜槽": [["liū"], ["cáo"]],
    "溜掉": [["liū"], ["diào"]],
    "溜达": [["liū"], ["dá"]],
    "溜光": [["liū"], ["guāng"]],
    "溜号": [["liū"], ["hào"]],
    "溜滑": [["liū"], ["huá"]],
    "溜开": [["liū"], ["kāi"]],
    "溜溜": [["liū"], ["liū"]],
    "溜索": [["liū"], ["suǒ"]],
    "溜圆": [["liū"], ["yuán"]],
    "溜子": [["liū"], ["zǐ"]],
    "溜走": [["liū"], ["zǒu"]],
    "流别": [["liú"], ["bié"]],
    "流传": [["liú"], ["chuán"]],
    "流弹": [["liú"], ["dàn"]],
    "流毒": [["liú"], ["dú"]],
    "流风": [["liú"], ["fēng"]],
    "流汗": [["liú"], ["hàn"]],
    "流化": [["liú"], ["huà"]],
    "流量": [["liú"], ["liàng"]],
    "流丽": [["liú"], ["lì"]],
    "流露": [["liú"], ["lù"]],
    "流氓": [["liú"], ["máng"]],
    "流落": [["liú"], ["luò"]],
    "流沙": [["liú"], ["shā"]],
    "流散": [["liú"], ["sàn"]],
    "流食": [["liú"], ["shí"]],
    "流苏": [["liú"], ["sū"]],
    "流淌": [["liú"], ["tǎng"]],
    "流体": [["liú"], ["tǐ"]],
    "流亡": [["liú"], ["wáng"]],
    "流行": [["liú"], ["xíng"]],
    "流转": [["liú"], ["zhuǎn"]],
    "流血": [["liú"], ["xiě"]],
    "留别": [["liú"], ["bié"]],
    "留传": [["liú"], ["chuán"]],
    "留待": [["liú"], ["dài"]],
    "留空": [["liú"], ["kòng"]],
    "留落": [["liú"], ["luò"]],
    "留难": [["liú"], ["nàn"]],
    "留任": [["liú"], ["rèn"]],
    "留宿": [["liú"], ["sù"]],
    "留种": [["liú"], ["zhǒng"]],
    "硫化": [["liú"], ["huà"]],
    "榴弹": [["liú"], ["dàn"]],
    "馏分": [["liú"], ["fèn"]],
    "柳梢": [["liǔ"], ["shāo"]],
    "柳体": [["liǔ"], ["tǐ"]],
    "柳条": [["liǔ"], ["tiáo"]],
    "柳巷": [["liǔ"], ["xiàng"]],
    "柳叶": [["liǔ"], ["yè"]],
    "柳荫": [["liǔ"], ["yīn"]],
    "柳枝": [["liǔ"], ["zhī"]],
    "六朝": [["liù"], ["cháo"]],
    "六大": [["liù"], ["dà"]],
    "六腑": [["liù"], ["fǔ"]],
    "六根": [["liù"], ["gēn"]],
    "六号": [["liù"], ["hào"]],
    "六合": [["liù"], ["hé"]],
    "六甲": [["liù"], ["jiǎ"]],
    "六角": [["liù"], ["jiǎo"]],
    "六经": [["liù"], ["jīng"]],
    "六礼": [["liù"], ["lǐ"]],
    "六亲": [["liù"], ["qīn"]],
    "六神": [["liù"], ["shén"]],
    "六师": [["liù"], ["shī"]],
    "六世": [["liù"], ["shì"]],
    "六书": [["liù"], ["shū"]],
    "六畜": [["liù"], ["chù"]],
    "六一": [["liù"], ["yī"]],
    "六艺": [["liù"], ["yì"]],
    "六欲": [["liù"], ["yù"]],
    "六月": [["liù"], ["yuè"]],
    "六祖": [["liù"], ["zǔ"]],
    "六指": [["liù"], ["zhǐ"]],
    "咯噔": [["gē"], ["dēng"]],
    "咯咯": [["gē"], ["gē"]],
    "咯血": [["kǎ"], ["xiě"]],
    "咯吱": [["gē"], ["zhī"]],
    "龙柏": [["lóng"], ["bǎi"]],
    "龙骨": [["lóng"], ["gǔ"]],
    "龙华": [["lóng"], ["huá"]],
    "龙卷": [["lóng"], ["juǎn"]],
    "龙体": [["lóng"], ["tǐ"]],
    "龙头": [["lóng"], ["tóu"]],
    "龙王": [["lóng"], ["wáng"]],
    "拢共": [["lǒng"], ["gòng"]],
    "喽罗": [["lóu"], ["luó"]],
    "喽啰": [["lóu"], ["luō"]],
    "楼上": [["lóu"], ["shàng"]],
    "搂抱": [["lǒu"], ["bào"]],
    "楼台": [["lóu"], ["tái"]],
    "陋巷": [["lòu"], ["xiàng"]],
    "漏斗": [["lòu"], ["dǒu"]],
    "漏风": [["lòu"], ["fēng"]],
    "漏泄": [["lòu"], ["xiè"]],
    "露白": [["lòu"], ["bái"]],
    "镂空": [["lòu"], ["kōng"]],
    "露布": [["lù"], ["bù"]],
    "露齿": [["lù"], ["chǐ"]],
    "露丑": [["lòu"], ["chǒu"]],
    "露底": [["lòu"], ["dǐ"]],
    "露风": [["lòu"], ["fēng"]],
    "露点": [["lù"], ["diǎn"]],
    "露富": [["lòu"], ["fù"]],
    "露骨": [["lòu"], ["gǔ"]],
    "露光": [["lù"], ["guāng"]],
    "露酒": [["lù"], ["jiǔ"]],
    "露脸": [["lòu"], ["liǎn"]],
    "露面": [["lòu"], ["miàn"]],
    "露苗": [["lòu"], ["miáo"]],
    "露怯": [["lòu"], ["qiè"]],
    "露水": [["lù"], ["shuǐ"]],
    "露宿": [["lù"], ["sù"]],
    "露台": [["lù"], ["tái"]],
    "露天": [["lù"], ["tiān"]],
    "露头": [["lù"], ["tóu"]],
    "露馅": [["lòu"], ["xiàn"]],
    "噜苏": [["lū"], ["sū"]],
    "露相": [["lòu"], ["xiàng"]],
    "露营": [["lù"], ["yíng"]],
    "露珠": [["lù"], ["zhū"]],
    "炉台": [["lú"], ["tái"]],
    "芦丁": [["lú"], ["dīng"]],
    "卤化": [["lǔ"], ["huà"]],
    "陆地": [["lù"], ["dì"]],
    "陆风": [["lù"], ["fēng"]],
    "陆上": [["lù"], ["shàng"]],
    "鹿尾": [["lù"], ["wěi"]],
    "碌碡": [["liù"], ["zhou"]],
    "滤过": [["lǜ"], ["guò"]],
    "碌碌": [["lù"], ["lù"]],
    "路过": [["lù"], ["guò"]],
    "路风": [["lù"], ["fēng"]],
    "路祭": [["lù"], ["jì"]],
    "路卡": [["lù"], ["qiǎ"]],
    "路旁": [["lù"], ["páng"]],
    "路上": [["lù"], ["shàng"]],
    "路数": [["lù"], ["shù"]],
    "路条": [["lù"], ["tiáo"]],
    "路头": [["lù"], ["tóu"]],
    "闾巷": [["lǘ"], ["xiàng"]],
    "履行": [["lǚ"], ["xíng"]],
    "旅行": [["lǚ"], ["xíng"]],
    "履约": [["lǚ"], ["yuē"]],
    "律令": [["lǜ"], ["lìng"]],
    "律条": [["lǜ"], ["tiáo"]],
    "率领": [["shuài"], ["lǐng"]],
    "率然": [["shuài"], ["rán"]],
    "率性": [["shuài"], ["xìng"]],
    "率真": [["shuài"], ["zhēn"]],
    "率直": [["shuài"], ["zhí"]],
    "绿化": [["lǜ"], ["huà"]],
    "挛缩": [["luán"], ["suō"]],
    "卵壳": [["luǎn"], ["ké"]],
    "卵裂": [["luǎn"], ["liè"]],
    "卵石": [["luǎn"], ["shí"]],
    "乱打": [["luàn"], ["dǎ"]],
    "乱弹": [["luàn"], ["tán"]],
    "乱发": [["luàn"], ["fā"]],
    "乱说": [["luàn"], ["shuō"]],
    "伦敦": [["lún"], ["dūn"]],
    "沦落": [["lún"], ["luò"]],
    "沦没": [["lún"], ["mò"]],
    "沦丧": [["lún"], ["sàng"]],
    "沦亡": [["lún"], ["wáng"]],
    "纶巾": [["guān"], ["jīn"]],
    "轮番": [["lún"], ["fān"]],
    "轮圈": [["lún"], ["quān"]],
    "轮台": [["lún"], ["tái"]],
    "轮休": [["lún"], ["xiū"]],
    "轮椅": [["lún"], ["yǐ"]],
    "轮种": [["lún"], ["zhòng"]],
    "轮轴": [["lún"], ["zhóu"]],
    "轮转": [["lún"], ["zhuàn"]],
    "论辩": [["lùn"], ["biàn"]],
    "论处": [["lùn"], ["chǔ"]],
    "论道": [["lùn"], ["dào"]],
    "论敌": [["lùn"], ["dí"]],
    "论点": [["lùn"], ["diǎn"]],
    "论调": [["lùn"], ["diào"]],
    "论断": [["lùn"], ["duàn"]],
    "论及": [["lùn"], ["jí"]],
    "论集": [["lùn"], ["jí"]],
    "论价": [["lùn"], ["jià"]],
    "论剑": [["lùn"], ["jiàn"]],
    "论交": [["lùn"], ["jiāo"]],
    "论据": [["lùn"], ["jù"]],
    "论理": [["lùn"], ["lǐ"]],
    "论列": [["lùn"], ["liè"]],
    "论难": [["lùn"], ["nàn"]],
    "论述": [["lùn"], ["shù"]],
    "论坛": [["lùn"], ["tán"]],
    "论说": [["lùn"], ["shuō"]],
    "论题": [["lùn"], ["tí"]],
    "论文": [["lùn"], ["wén"]],
    "论语": [["lún"], ["yǔ"]],
    "论战": [["lùn"], ["zhàn"]],
    "论争": [["lùn"], ["zhēng"]],
    "论证": [["lùn"], ["zhèng"]],
    "论著": [["lùn"], ["zhù"]],
    "论罪": [["lùn"], ["zuì"]],
    "罗甸": [["luó"], ["diàn"]],
    "罗拉": [["luó"], ["lā"]],
    "罗勒": [["luó"], ["lè"]],
    "罗刹": [["luó"], ["chà"]],
    "罗圈": [["luó"], ["quān"]],
    "罗纹": [["luó"], ["wén"]],
    "罗织": [["luó"], ["zhī"]],
    "螺钉": [["luó"], ["dīng"]],
    "螺杆": [["luó"], ["gǎn"]],
    "螺号": [["luó"], ["hào"]],
    "螺纹": [["luó"], ["wén"]],
    "螺旋": [["luó"], ["xuán"]],
    "裸露": [["luǒ"], ["lù"]],
    "裸体": [["luǒ"], ["tǐ"]],
    "洛夫": [["luò"], ["fū"]],
    "络脉": [["luò"], ["mài"]],
    "络绎": [["luò"], ["yì"]],
    "络子": [["lào"], ["zi"]],
    "落榜": [["luò"], ["bǎng"]],
    "落笔": [["luò"], ["bǐ"]],
    "落膘": [["luò"], ["biāo"]],
    "落草": [["luò"], ["cǎo"]],
    "落泊": [["luò"], ["bó"]],
    "落差": [["luò"], ["chà"]],
    "落潮": [["luò"], ["cháo"]],
    "落尘": [["luò"], ["chén"]],
    "落成": [["luò"], ["chéng"]],
    "落单": [["luò"], ["dān"]],
    "落得": [["luò"], ["de"]],
    "落地": [["luò"], ["dì"]],
    "落第": [["luò"], ["dì"]],
    "落点": [["luò"], ["diǎn"]],
    "落发": [["luò"], ["fà"]],
    "落后": [["luò"], ["hòu"]],
    "落户": [["luò"], ["hù"]],
    "落荒": [["luò"], ["huāng"]],
    "落籍": [["luò"], ["jí"]],
    "落价": [["lào"], ["jià"]],
    "落脚": [["luò"], ["jiǎo"]],
    "落空": [["luò"], ["kōng"]],
    "落款": [["luò"], ["kuǎn"]],
    "落泪": [["luò"], ["lèi"]],
    "落马": [["luò"], ["mǎ"]],
    "落寞": [["luò"], ["mò"]],
    "落墨": [["luò"], ["mò"]],
    "落幕": [["luò"], ["mù"]],
    "落难": [["luò"], ["nàn"]],
    "落日": [["luò"], ["rì"]],
    "落魄": [["luò"], ["tuò"]],
    "落实": [["luò"], ["shí"]],
    "落山": [["luò"], ["shān"]],
    "落市": [["luò"], ["shì"]],
    "落水": [["luò"], ["shuǐ"]],
    "落俗": [["luò"], ["sú"]],
    "落锁": [["luò"], ["suǒ"]],
    "落套": [["luò"], ["tào"]],
    "落拓": [["luò"], ["tuò"]],
    "落体": [["luò"], ["tǐ"]],
    "落网": [["luò"], ["wǎng"]],
    "落伍": [["luò"], ["wǔ"]],
    "落霞": [["luò"], ["xiá"]],
    "落选": [["luò"], ["xuǎn"]],
    "落叶": [["luò"], ["yè"]],
    "落下": [["là"], ["xià"]],
    "落音": [["luò"], ["yīn"]],
    "落英": [["luò"], ["yīng"]],
    "落帐": [["luò"], ["zhàng"]],
    "落照": [["luò"], ["zhào"]],
    "落枕": [["lào"], ["zhěn"]],
    "落子": [["lào"], ["zǐ"]],
    "漯河": [["tà"], ["hé"]],
    "落座": [["luò"], ["zuò"]],
    "麻雀": [["má"], ["què"]],
    "马勃": [["mǎ"], ["bó"]],
    "马车": [["mǎ"], ["chē"]],
    "马刺": [["mǎ"], ["cì"]],
    "马夫": [["mǎ"], ["fū"]],
    "马号": [["mǎ"], ["hào"]],
    "马勒": [["mǎ"], ["lè"]],
    "马尿": [["mǎ"], ["niào"]],
    "马圈": [["mǎ"], ["juàn"]],
    "马上": [["mǎ"], ["shàng"]],
    "马术": [["mǎ"], ["shù"]],
    "马头": [["mǎ"], ["tóu"]],
    "马尾": [["mǎ"], ["yǐ"]],
    "马戏": [["mǎ"], ["xì"]],
    "马扎": [["mǎ"], ["zhá"]],
    "马仔": [["mǎ"], ["zǎi"]],
    "码垛": [["mǎ"], ["duǒ"]],
    "蚂蜂": [["mǎ"], ["fēng"]],
    "码头": [["mǎ"], ["tóu"]],
    "蚂蝗": [["mǎ"], ["huáng"]],
    "蚂蟥": [["mǎ"], ["huáng"]],
    "蚂蚁": [["mǎ"], ["yǐ"]],
    "蚂螂": [["mā"], ["láng"]],
    "蚂蚱": [["mà"], ["zhà"]],
    "唛头": [["mà"], ["tóu"]],
    "吗啡": [["mǎ"], ["fēi"]],
    "埋伏": [["mái"], ["fú"]],
    "埋藏": [["mái"], ["cáng"]],
    "埋名": [["mái"], ["míng"]],
    "埋没": [["mái"], ["mò"]],
    "埋设": [["mái"], ["shè"]],
    "埋首": [["mái"], ["shǒu"]],
    "埋头": [["mái"], ["tóu"]],
    "埋汰": [["mái"], ["tài"]],
    "埋怨": [["mán"], ["yuàn"]],
    "埋葬": [["mái"], ["zàng"]],
    "买好": [["mǎi"], ["hǎo"]],
    "买家": [["mǎi"], ["jiā"]],
    "买价": [["mǎi"], ["jià"]],
    "迈上": [["mài"], ["shàng"]],
    "麦蛾": [["mài"], ["é"]],
    "麦角": [["mài"], ["jiǎo"]],
    "麦片": [["mài"], ["piàn"]],
    "麦粥": [["mài"], ["zhōu"]],
    "卖好": [["mài"], ["hǎo"]],
    "卖价": [["mài"], ["jià"]],
    "卖空": [["mài"], ["kōng"]],
    "卖劲": [["mài"], ["jìn"]],
    "卖弄": [["mài"], ["nòng"]],
    "卖俏": [["mài"], ["qiào"]],
    "卖相": [["mài"], ["xiàng"]],
    "脉案": [["mài"], ["àn"]],
    "脉搏": [["mài"], ["bó"]],
    "脉冲": [["mài"], ["chōng"]],
    "脉动": [["mài"], ["dòng"]],
    "脉管": [["mài"], ["guǎn"]],
    "脉脉": [["mò"], ["mò"]],
    "脉络": [["mài"], ["luò"]],
    "脉理": [["mài"], ["lǐ"]],
    "脉门": [["mài"], ["mén"]],
    "脉息": [["mài"], ["xī"]],
    "脉石": [["mài"], ["shí"]],
    "脉象": [["mài"], ["xiàng"]],
    "脉压": [["mài"], ["yā"]],
    "蛮干": [["mán"], ["gàn"]],
    "蛮横": [["mán"], ["hèng"]],
    "蛮劲": [["mán"], ["jìn"]],
    "馒头": [["mán"], ["tou"]],
    "瞒产": [["mán"], ["chǎn"]],
    "瞒哄": [["mán"], ["hǒng"]],
    "满处": [["mǎn"], ["chǔ"]],
    "满分": [["mǎn"], ["fēn"]],
    "满期": [["mǎn"], ["qī"]],
    "满载": [["mǎn"], ["zài"]],
    "满员": [["mǎn"], ["yuán"]],
    "慢车": [["màn"], ["chē"]],
    "慢待": [["màn"], ["dài"]],
    "慢化": [["màn"], ["huà"]],
    "慢说": [["màn"], ["shuō"]],
    "漫长": [["màn"], ["cháng"]],
    "漫卷": [["màn"], ["juàn"]],
    "漫说": [["màn"], ["shuō"]],
    "蔓草": [["màn"], ["cǎo"]],
    "蔓生": [["màn"], ["shēng"]],
    "蔓延": [["màn"], ["yán"]],
    "蔓衍": [["màn"], ["yǎn"]],
    "忙碌": [["máng"], ["lù"]],
    "芒刺": [["máng"], ["cì"]],
    "芒种": [["máng"], ["zhòng"]],
    "盲从": [["máng"], ["cóng"]],
    "盲女": [["máng"], ["nǚ"]],
    "蟒袍": [["mǎng"], ["páo"]],
    "蟒蛇": [["mǎng"], ["shé"]],
    "毛刺": [["máo"], ["cì"]],
    "毛发": [["máo"], ["fà"]],
    "毛葛": [["máo"], ["gě"]],
    "毛拉": [["máo"], ["lā"]],
    "毛呢": [["máo"], ["ní"]],
    "毛囊": [["máo"], ["náng"]],
    "毛片": [["máo"], ["piàn"]],
    "毛票": [["máo"], ["piào"]],
    "毛渠": [["máo"], ["qú"]],
    "毛刷": [["máo"], ["shuā"]],
    "毛石": [["máo"], ["shí"]],
    "毛条": [["máo"], ["tiáo"]],
    "毛头": [["máo"], ["tóu"]],
    "毛重": [["máo"], ["zhòng"]],
    "矛头": [["máo"], ["tóu"]],
    "茅台": [["máo"], ["tái"]],
    "锚泊": [["máo"], ["bó"]],
    "锚地": [["máo"], ["dì"]],
    "铆钉": [["mǎo"], ["dīng"]],
    "茂盛": [["mào"], ["shèng"]],
    "冒充": [["mào"], ["chōng"]],
    "冒顶": [["mào"], ["dǐng"]],
    "冒犯": [["mào"], ["fàn"]],
    "冒渎": [["mào"], ["dú"]],
    "冒号": [["mào"], ["hào"]],
    "冒功": [["mào"], ["gōng"]],
    "冒火": [["mào"], ["huǒ"]],
    "冒尖": [["mào"], ["jiān"]],
    "冒进": [["mào"], ["jìn"]],
    "冒领": [["mào"], ["lǐng"]],
    "冒昧": [["mào"], ["mèi"]],
    "冒名": [["mào"], ["míng"]],
    "冒牌": [["mào"], ["pái"]],
    "冒失": [["mào"], ["shī"]],
    "冒死": [["mào"], ["sǐ"]],
    "冒头": [["mào"], ["tóu"]],
    "冒险": [["mào"], ["xiǎn"]],
    "冒烟": [["mào"], ["yān"]],
    "冒雨": [["mào"], ["yǔ"]],
    "貌似": [["mào"], ["sì"]],
    "貌相": [["mào"], ["xiāng"]],
    "没齿": [["mò"], ["chǐ"]],
    "没底": [["méi"], ["dǐ"]],
    "没劲": [["méi"], ["jìn"]],
    "没救": [["méi"], ["jiù"]],
    "没空": [["méi"], ["kòng"]],
    "没脸": [["méi"], ["liǎn"]],
    "没落": [["mò"], ["luò"]],
    "没命": [["méi"], ["mìng"]],
    "没趣": [["méi"], ["qù"]],
    "没人": [["méi"], ["rén"]],
    "没入": [["mò"], ["rù"]],
    "没世": [["mò"], ["shì"]],
    "没事": [["méi"], ["shì"]],
    "没收": [["mò"], ["shōu"]],
    "没完": [["méi"], ["wán"]],
    "没味": [["méi"], ["wèi"]],
    "没戏": [["méi"], ["xì"]],
    "没药": [["mò"], ["yào"]],
    "没用": [["méi"], ["yòng"]],
    "没羞": [["méi"], ["xiū"]],
    "没有": [["méi"], ["yǒu"]],
    "眉梢": [["méi"], ["shāo"]],
    "眉头": [["méi"], ["tóu"]],
    "梅雨": [["méi"], ["yǔ"]],
    "媒合": [["méi"], ["hé"]],
    "媒体": [["méi"], ["tǐ"]],
    "煤毒": [["méi"], ["dú"]],
    "霉菌": [["méi"], ["jūn"]],
    "霉头": [["méi"], ["tóu"]],
    "霉雨": [["méi"], ["yǔ"]],
    "每当": [["měi"], ["dāng"]],
    "美称": [["měi"], ["chēng"]],
    "美差": [["měi"], ["chāi"]],
    "美观": [["měi"], ["guān"]],
    "美好": [["měi"], ["hǎo"]],
    "美化": [["měi"], ["huà"]],
    "美景": [["měi"], ["jǐng"]],
    "美丽": [["měi"], ["lì"]],
    "美食": [["měi"], ["shí"]],
    "美女": [["měi"], ["nǚ"]],
    "美术": [["měi"], ["shù"]],
    "美语": [["měi"], ["yǔ"]],
    "妹夫": [["mèi"], ["fū"]],
    "媚骨": [["mèi"], ["gǔ"]],
    "门把": [["mén"], ["bà"]],
    "门丁": [["mén"], ["dīng"]],
    "门钉": [["mén"], ["dīng"]],
    "门斗": [["mén"], ["dǒu"]],
    "门风": [["mén"], ["fēng"]],
    "门缝": [["mén"], ["fèng"]],
    "门号": [["mén"], ["hào"]],
    "门槛": [["mén"], ["kǎn"]],
    "门将": [["mén"], ["jiāng"]],
    "门票": [["mén"], ["piào"]],
    "门禁": [["mén"], ["jìn"]],
    "门扇": [["mén"], ["shàn"]],
    "门上": [["mén"], ["shàng"]],
    "闷酒": [["mèn"], ["jiǔ"]],
    "闷棍": [["mèn"], ["gùn"]],
    "闷倦": [["mèn"], ["juàn"]],
    "闷雷": [["mēn"], ["léi"]],
    "闷热": [["mēn"], ["rè"]],
    "闷气": [["mēn"], ["qì"]],
    "闷声": [["mēn"], ["shēng"]],
    "闷头": [["mèn"], ["tóu"]],
    "盟员": [["méng"], ["yuán"]],
    "盟约": [["méng"], ["yuē"]],
    "礞石": [["méng"], ["shí"]],
    "猛可": [["měng"], ["kě"]],
    "蒙蔽": [["méng"], ["bì"]],
    "蒙尘": [["meng"], ["chen"]],
    "蒙恩": [["méng"], ["ēn"]],
    "蒙垢": [["méng"], ["gòu"]],
    "蒙混": [["méng"], ["hùn"]],
    "蒙哄": [["méng"], ["hǒng"]],
    "蒙胧": [["méng"], ["lóng"]],
    "蒙昧": [["méng"], ["mèi"]],
    "蒙蒙": [["méng"], ["méng"]],
    "蒙面": [["méng"], ["miàn"]],
    "蒙难": [["méng"], ["nàn"]],
    "蒙皮": [["méng"], ["pí"]],
    "蒙骗": [["méng"], ["piàn"]],
    "蒙事": [["mēng"], ["shì"]],
    "蒙师": [["méng"], ["shī"]],
    "蒙受": [["méng"], ["shòu"]],
    "蒙羞": [["méng"], ["xiū"]],
    "蒙药": [["méng"], ["yào"]],
    "蒙冤": [["méng"], ["yuān"]],
    "锰钢": [["měng"], ["gāng"]],
    "弥补": [["mí"], ["bǔ"]],
    "弥封": [["mí"], ["fēng"]],
    "弥合": [["mí"], ["hé"]],
    "弥缝": [["mí"], ["féng"]],
    "弥留": [["mí"], ["liú"]],
    "弥勒": [["mí"], ["lè"]],
    "弥漫": [["mí"], ["màn"]],
    "弥撒": [["mí"], ["sā"]],
    "弥蒙": [["mí"], ["méng"]],
    "弥天": [["mí"], ["tiān"]],
    "弥散": [["mí"], ["sàn"]],
    "弥望": [["mí"], ["wàng"]],
    "弥陀": [["mí"], ["tuó"]],
    "弥月": [["mí"], ["yuè"]],
    "迷糊": [["mí"], ["hu"]],
    "迷蒙": [["mí"], ["méng"]],
    "迷信": [["mí"], ["xìn"]],
    "糜费": [["mí"], ["fèi"]],
    "糜烂": [["mí"], ["làn"]],
    "靡丽": [["mǐ"], ["lì"]],
    "糜子": [["méi"], ["zǐ"]],
    "米尺": [["mǐ"], ["chǐ"]],
    "米汤": [["mǐ"], ["tāng"]],
    "泌阳": [["bì"], ["yáng"]],
    "觅食": [["mì"], ["shí"]],
    "秘本": [["mì"], ["běn"]],
    "秘宝": [["mì"], ["bǎo"]],
    "秘藏": [["mì"], ["cáng"]],
    "秘传": [["mì"], ["chuán"]],
    "秘方": [["mì"], ["fāng"]],
    "秘籍": [["mì"], ["jí"]],
    "秘诀": [["mì"], ["jué"]],
    "秘鲁": [["bì"], ["lǔ"]],
    "秘密": [["mì"], ["mì"]],
    "秘书": [["mì"], ["shū"]],
    "秘史": [["mì"], ["shǐ"]],
    "密语": [["mì"], ["yǔ"]],
    "蜜供": [["mì"], ["gòng"]],
    "蜜露": [["mì"], ["lù"]],
    "蜜语": [["mì"], ["yǔ"]],
    "棉被": [["mián"], ["bèi"]],
    "免得": [["miǎn"], ["de"]],
    "免冠": [["miǎn"], ["guān"]],
    "免票": [["miǎn"], ["piào"]],
    "黾勉": [["mǐn"], ["miǎn"]],
    "勉强": [["miǎn"], ["qiǎng"]],
    "面朝": [["miàn"], ["cháo"]],
    "面红": [["miàn"], ["hóng"]],
    "面糊": [["miàn"], ["hù"]],
    "面上": [["miàn"], ["shàng"]],
    "面见": [["miàn"], ["jiàn"]],
    "面食": [["miàn"], ["shí"]],
    "面汤": [["miàn"], ["tāng"]],
    "面条": [["miàn"], ["tiáo"]],
    "面相": [["miàn"], ["xiāng"]],
    "苗期": [["miáo"], ["qī"]],
    "苗条": [["miáo"], ["tiáo"]],
    "苗头": [["miáo"], ["tóu"]],
    "邈远": [["miǎo"], ["yuǎn"]],
    "妙处": [["miào"], ["chù"]],
    "渺远": [["miǎo"], ["yuǎn"]],
    "妙句": [["miào"], ["jù"]],
    "妙论": [["miào"], ["lùn"]],
    "妙趣": [["miào"], ["qù"]],
    "妙语": [["miào"], ["yǔ"]],
    "庙号": [["miào"], ["hào"]],
    "乜斜": [["niè"], ["xié"]],
    "庙会": [["miào"], ["huì"]],
    "灭亡": [["miè"], ["wáng"]],
    "灭种": [["miè"], ["zhǒng"]],
    "灭菌": [["miè"], ["jūn"]],
    "民风": [["mín"], ["fēng"]],
    "民夫": [["mín"], ["fū"]],
    "篾片": [["miè"], ["piàn"]],
    "民家": [["mín"], ["jiā"]],
    "民间": [["mín"], ["jiān"]],
    "民乐": [["mín"], ["yuè"]],
    "民食": [["mín"], ["shí"]],
    "民校": [["mín"], ["xiào"]],
    "民约": [["mín"], ["yuē"]],
    "泯没": [["mǐn"], ["mò"]],
    "名簿": [["míng"], ["bù"]],
    "名称": [["míng"], ["chēng"]],
    "名单": [["míng"], ["dān"]],
    "名分": [["míng"], ["fēn"]],
    "名号": [["míng"], ["hào"]],
    "名将": [["míng"], ["jiàng"]],
    "名家": [["míng"], ["jiā"]],
    "名角": [["míng"], ["jué"]],
    "名教": [["míng"], ["jiào"]],
    "名节": [["míng"], ["jié"]],
    "名句": [["míng"], ["jù"]],
    "名片": [["míng"], ["piàn"]],
    "名刹": [["míng"], ["shā"]],
    "名宿": [["míng"], ["sù"]],
    "名数": [["míng"], ["shù"]],
    "名帖": [["míng"], ["tiě"]],
    "名媛": [["míng"], ["yuàn"]],
    "名著": [["míng"], ["zhù"]],
    "明朝": [["míng"], ["cháo"]],
    "明处": [["míng"], ["chù"]],
    "明度": [["míng"], ["dù"]],
    "明净": [["míng"], ["jìng"]],
    "明丽": [["míng"], ["lì"]],
    "明教": [["míng"], ["jiào"]],
    "明了": [["míng"], ["liǎo"]],
    "明令": [["míng"], ["lìng"]],
    "明渠": [["míng"], ["qú"]],
    "明抢": [["míng"], ["qiǎng"]],
    "明说": [["míng"], ["shuō"]],
    "明瓦": [["míng"], ["wǎ"]],
    "明王": [["míng"], ["wáng"]],
    "明知": [["míng"], ["zhī"]],
    "冥思": [["míng"], ["sī"]],
    "螟蛾": [["míng"], ["é"]],
    "酩酊": [["mǐng"], ["dǐng"]],
    "命薄": [["mìng"], ["bó"]],
    "命令": [["mìng"], ["lìng"]],
    "命脉": [["mìng"], ["mài"]],
    "命相": [["mìng"], ["xiāng"]],
    "命数": [["mìng"], ["shù"]],
    "命中": [["mìng"], ["zhòng"]],
    "谬说": [["miù"], ["shuō"]],
    "谬论": [["miù"], ["lùn"]],
    "摸底": [["mō"], ["dǐ"]],
    "谬种": [["miù"], ["zhǒng"]],
    "摸头": [["mō"], ["tóu"]],
    "模板": [["mú"], ["bǎn"]],
    "模本": [["mó"], ["běn"]],
    "模范": [["mó"], ["fàn"]],
    "模仿": [["mó"], ["fǎng"]],
    "模糊": [["mó"], ["hu"]],
    "模具": [["mú"], ["jù"]],
    "模棱": [["mó"], ["léng"]],
    "模式": [["mó"], ["shì"]],
    "模拟": [["mó"], ["nǐ"]],
    "模型": [["mó"], ["xíng"]],
    "模印": [["mó"], ["yìn"]],
    "模样": [["mú"], ["yàng"]],
    "模子": [["mú"], ["zǐ"]],
    "摩擦": [["mó"], ["cā"]],
    "摩尔": [["mó"], ["ěr"]],
    "摩登": [["mó"], ["dēng"]],
    "摩抚": [["mó"], ["fǔ"]],
    "摩托": [["mó"], ["tuō"]],
    "摩天": [["mó"], ["tiān"]],
    "摩挲": [["mā"], ["sā"]],
    "摩崖": [["mó"], ["yá"]],
    "磨擦": [["mó"], ["cā"]],
    "磨蹭": [["mó"], ["cèng"]],
    "磨叨": [["mò"], ["dāo"]],
    "磨烦": [["mò"], ["fán"]],
    "磨坊": [["mò"], ["fáng"]],
    "磨房": [["mó"], ["fáng"]],
    "磨菇": [["mó"], ["gū"]],
    "磨光": [["mó"], ["guāng"]],
    "磨耗": [["mó"], ["hào"]],
    "磨合": [["mó"], ["hé"]],
    "磨快": [["mó"], ["kuài"]],
    "磨砺": [["mó"], ["lì"]],
    "磨炼": [["mó"], ["liàn"]],
    "磨练": [["mó"], ["liàn"]],
    "磨灭": [["mó"], ["miè"]],
    "磨磨": [["mó"], ["mó"]],
    "磨难": [["mó"], ["nàn"]],
    "磨盘": [["mò"], ["pán"]],
    "磨扇": [["mó"], ["shàn"]],
    "磨石": [["mó"], ["shí"]],
    "磨损": [["mó"], ["sǔn"]],
    "磨蚀": [["mó"], ["shí"]],
    "磨洗": [["mó"], ["xǐ"]],
    "磨牙": [["mó"], ["yá"]],
    "磨折": [["mó"], ["zhé"]],
    "磨子": [["mò"], ["zǐ"]],
    "磨嘴": [["mó"], ["zuǐ"]],
    "魔教": [["mó"], ["jiào"]],
    "魔女": [["mó"], ["nǚ"]],
    "魔术": [["mó"], ["shù"]],
    "魔头": [["mó"], ["tóu"]],
    "魔王": [["mó"], ["wáng"]],
    "魔爪": [["mó"], ["zhǎo"]],
    "抹布": [["mā"], ["bù"]],
    "抹粉": [["mǒ"], ["fěn"]],
    "抹灰": [["mò"], ["huī"]],
    "抹黑": [["mǒ"], ["hēi"]],
    "抹脸": [["mā"], ["liǎn"]],
    "抹杀": [["mǒ"], ["shā"]],
    "抹煞": [["mǒ"], ["shà"]],
    "抹子": [["mǒ"], ["zǐ"]],
    "抹胸": [["mò"], ["xiōng"]],
    "末节": [["mò"], ["jié"]],
    "末了": [["mò"], ["liǎo"]],
    "末期": [["mò"], ["qī"]],
    "末梢": [["mò"], ["shāo"]],
    "末尾": [["mò"], ["wěi"]],
    "末叶": [["mò"], ["yè"]],
    "莫不": [["mò"], ["bù"]],
    "莫大": [["mò"], ["dà"]],
    "莫非": [["mò"], ["fēi"]],
    "莫名": [["mò"], ["míng"]],
    "莫逆": [["mò"], ["nì"]],
    "莫如": [["mò"], ["rú"]],
    "漠北": [["mò"], ["běi"]],
    "漠南": [["mò"], ["nán"]],
    "墨斗": [["mò"], ["dǒu"]],
    "蓦地": [["mò"], ["dì"]],
    "墨家": [["mò"], ["jiā"]],
    "墨绿": [["mò"], ["lǜ"]],
    "墨囊": [["mò"], ["náng"]],
    "默读": [["mò"], ["dú"]],
    "默片": [["mò"], ["piàn"]],
    "默契": [["mò"], ["qì"]],
    "默许": [["mò"], ["xǔ"]],
    "牟利": [["móu"], ["lì"]],
    "牟取": [["móu"], ["qǔ"]],
    "某地": [["mǒu"], ["dì"]],
    "某个": [["mǒu"], ["gè"]],
    "某些": [["mǒu"], ["xiē"]],
    "母教": [["mǔ"], ["jiào"]],
    "母亲": [["mǔ"], ["qīn"]],
    "母体": [["mǔ"], ["tǐ"]],
    "母系": [["mǔ"], ["xì"]],
    "母畜": [["mǔ"], ["chù"]],
    "母校": [["mǔ"], ["xiào"]],
    "木尺": [["mù"], ["chǐ"]],
    "母语": [["mǔ"], ["yǔ"]],
    "木杆": [["mù"], ["gǎn"]],
    "木棍": [["mù"], ["gùn"]],
    "木杠": [["mù"], ["gàng"]],
    "木笼": [["mù"], ["lóng"]],
    "木排": [["mù"], ["pái"]],
    "木模": [["mù"], ["mú"]],
    "木塞": [["mù"], ["sāi"]],
    "木条": [["mù"], ["tiáo"]],
    "木头": [["mù"], ["tou"]],
    "木瓦": [["mù"], ["wǎ"]],
    "木栅": [["mù"], ["shān"]],
    "木钻": [["mù"], ["zuàn"]],
    "目的": [["mù"], ["dì"]],
    "目见": [["mù"], ["jiàn"]],
    "目论": [["mù"], ["lùn"]],
    "目语": [["mù"], ["yǔ"]],
    "牧场": [["mù"], ["chǎng"]],
    "牧地": [["mù"], ["dì"]],
    "牧区": [["mù"], ["qū"]],
    "牧羊": [["mù"], ["yáng"]],
    "牧畜": [["mù"], ["chù"]],
    "墓地": [["mù"], ["dì"]],
    "募化": [["mù"], ["huà"]],
    "墓祭": [["mù"], ["jì"]],
    "墓碣": [["mù"], ["jié"]],
    "暮景": [["mù"], ["jǐng"]],
    "拿大": [["ná"], ["dà"]],
    "拿给": [["ná"], ["gěi"]],
    "哪儿": [["nǎ"], ["ér"]],
    "哪里": [["nǎ"], ["lǐ"]],
    "哪个": [["něi"], ["gè"]],
    "哪怕": [["nǎ"], ["pà"]],
    "哪能": [["nǎ"], ["néng"]],
    "哪位": [["nǎ"], ["wèi"]],
    "哪些": [["něi"], ["xiē"]],
    "哪样": [["nǎ"], ["yàng"]],
    "哪吒": [["N&eacute;zhā"]],
    "内宾": [["nèi"], ["bīn"]],
    "内部": [["nèi"], ["bù"]],
    "内参": [["nèi"], ["cān"]],
    "内藏": [["nèi"], ["cáng"]],
    "内层": [["nèi"], ["céng"]],
    "内臣": [["nèi"], ["chén"]],
    "内传": [["nèi"], ["zhuàn"]],
    "内道": [["nèi"], ["dào"]],
    "内地": [["nèi"], ["dì"]],
    "内弟": [["nèi"], ["dì"]],
    "内定": [["nèi"], ["dìng"]],
    "内耳": [["nèi"], ["ěr"]],
    "内犯": [["nèi"], ["fàn"]],
    "内服": [["nèi"], ["fú"]],
    "内府": [["nèi"], ["fǔ"]],
    "内阁": [["nèi"], ["gé"]],
    "内港": [["nèi"], ["gǎng"]],
    "内功": [["nèi"], ["gōng"]],
    "内关": [["nèi"], ["guān"]],
    "内海": [["nèi"], ["hǎi"]],
    "内涵": [["nèi"], ["hán"]],
    "内含": [["nèi"], ["hán"]],
    "内耗": [["nèi"], ["hào"]],
    "内河": [["nèi"], ["hé"]],
    "内核": [["nèi"], ["hé"]],
    "内讧": [["nèi"], ["hòng"]],
    "内化": [["nèi"], ["huà"]],
    "内急": [["nèi"], ["jí"]],
    "内奸": [["nèi"], ["jiān"]],
    "内景": [["nèi"], ["jǐng"]],
    "内径": [["nèi"], ["jìng"]],
    "内疚": [["nèi"], ["jiù"]],
    "内眷": [["nèi"], ["juàn"]],
    "内科": [["nèi"], ["kē"]],
    "内涝": [["nèi"], ["lào"]],
    "内里": [["nèi"], ["lǐ"]],
    "内力": [["nèi"], ["lì"]],
    "内陆": [["nèi"], ["lù"]],
    "内乱": [["nèi"], ["luàn"]],
    "内贸": [["nèi"], ["mào"]],
    "内面": [["nèi"], ["miàn"]],
    "内幕": [["nèi"], ["mù"]],
    "内难": [["nèi"], ["nán"]],
    "内迁": [["nèi"], ["qiān"]],
    "内亲": [["nèi"], ["qīn"]],
    "内勤": [["nèi"], ["qín"]],
    "内侵": [["nèi"], ["qīn"]],
    "内倾": [["nèi"], ["qīng"]],
    "内情": [["nèi"], ["qíng"]],
    "内瓤": [["nèi"], ["ráng"]],
    "内热": [["nèi"], ["rè"]],
    "内人": [["nèi"], ["rén"]],
    "内容": [["nèi"], ["róng"]],
    "内伤": [["nèi"], ["shāng"]],
    "内省": [["nèi"], ["xǐng"]],
    "内侍": [["nèi"], ["shì"]],
    "内室": [["nèi"], ["shì"]],
    "内胎": [["nèi"], ["tāi"]],
    "内廷": [["nèi"], ["tíng"]],
    "内庭": [["nèi"], ["tíng"]],
    "内外": [["nèi"], ["wài"]],
    "内屋": [["nèi"], ["wū"]],
    "内务": [["nèi"], ["wù"]],
    "内线": [["nèi"], ["xiàn"]],
    "内陷": [["nèi"], ["xiàn"]],
    "内乡": [["nèi"], ["xiāng"]],
    "内向": [["nèi"], ["xiàng"]],
    "内详": [["nèi"], ["xiáng"]],
    "内销": [["nèi"], ["xiāo"]],
    "内兄": [["nèi"], ["xiōng"]],
    "内心": [["nèi"], ["xīn"]],
    "内行": [["nèi"], ["háng"]],
    "内秀": [["nèi"], ["xiù"]],
    "内焰": [["nèi"], ["yàn"]],
    "内衣": [["nèi"], ["yī"]],
    "内因": [["nèi"], ["yīn"]],
    "内应": [["nèi"], ["yìng"]],
    "内忧": [["nèi"], ["yōu"]],
    "内院": [["nèi"], ["yuàn"]],
    "内蕴": [["nèi"], ["yùn"]],
    "内在": [["nèi"], ["zài"]],
    "内脏": [["nèi"], ["zàng"]],
    "内债": [["nèi"], ["zhài"]],
    "内宅": [["nèi"], ["zhái"]],
    "内战": [["nèi"], ["zhàn"]],
    "内障": [["nèi"], ["zhàng"]],
    "内争": [["nèi"], ["zhēng"]],
    "内政": [["nèi"], ["zhèng"]],
    "内侄": [["nèi"], ["zhí"]],
    "内痔": [["nèi"], ["zhì"]],
    "内中": [["nèi"], ["zhōng"]],
    "内助": [["nèi"], ["zhù"]],
    "内资": [["nèi"], ["zī"]],
    "内子": [["nèi"], ["zǐ"]],
    "那般": [["nà"], ["bān"]],
    "那边": [["nà"], ["biān"]],
    "那儿": [["nà"], ["ér"]],
    "那个": [["nà"], ["gè"]],
    "那么": [["nà"], ["me"]],
    "那里": [["nà"], ["lǐ"]],
    "那末": [["nà"], ["mò"]],
    "那些": [["nèi"], ["xiē"]],
    "那样": [["nà"], ["yàng"]],
    "纳采": [["nà"], ["cǎi"]],
    "纳降": [["nà"], ["xiáng"]],
    "纳凉": [["nà"], ["liáng"]],
    "纳闷": [["nà"], ["mèn"]],
    "奶头": [["nǎi"], ["tóu"]],
    "耐看": [["nài"], ["kàn"]],
    "奈何": [["nài"], ["hé"]],
    "耐磨": [["nài"], ["mó"]],
    "男丁": [["nán"], ["dīng"]],
    "男家": [["nán"], ["jiā"]],
    "男女": [["nán"], ["nǚ"]],
    "男仆": [["nán"], ["pú"]],
    "南北": [["nán"], ["běi"]],
    "南边": [["nán"], ["biān"]],
    "南部": [["nán"], ["bù"]],
    "南朝": [["nán"], ["cháo"]],
    "南川": [["nán"], ["chuān"]],
    "南端": [["nán"], ["duān"]],
    "南方": [["nán"], ["fāng"]],
    "南风": [["nán"], ["fēng"]],
    "南宫": [["nán"], ["gōng"]],
    "南瓜": [["nán"], ["guā"]],
    "南国": [["nán"], ["guó"]],
    "南海": [["nán"], ["hǎi"]],
    "南汉": [["nán"], ["hàn"]],
    "南胡": [["nán"], ["hú"]],
    "南湖": [["nán"], ["hú"]],
    "南华": [["nán"], ["huá"]],
    "南货": [["nán"], ["huò"]],
    "南极": [["nán"], ["jí"]],
    "南江": [["nán"], ["jiāng"]],
    "南郊": [["nán"], ["jiāo"]],
    "南京": [["nán"], ["jīng"]],
    "南军": [["nán"], ["jūn"]],
    "南乐": [["nán"], ["lè"]],
    "南凉": [["nán"], ["liáng"]],
    "南岭": [["nán"], ["lǐng"]],
    "南陵": [["nán"], ["líng"]],
    "南吕": [["nán"], ["lǚ"]],
    "南蛮": [["nán"], ["mán"]],
    "南门": [["nán"], ["mén"]],
    "南面": [["nán"], ["miàn"]],
    "南皮": [["nán"], ["pí"]],
    "南欧": [["nán"], ["ōu"]],
    "南平": [["nán"], ["píng"]],
    "南齐": [["nán"], ["qí"]],
    "南迁": [["nán"], ["qiān"]],
    "南拳": [["nán"], ["quán"]],
    "南山": [["nán"], ["shān"]],
    "南式": [["nán"], ["shì"]],
    "南唐": [["nán"], ["táng"]],
    "南宋": [["nán"], ["sòng"]],
    "南纬": [["nán"], ["wěi"]],
    "南戏": [["nán"], ["xì"]],
    "南星": [["nán"], ["xīng"]],
    "南巡": [["nán"], ["xún"]],
    "南亚": [["nán"], ["yà"]],
    "南燕": [["nán"], ["yàn"]],
    "南阳": [["nán"], ["yáng"]],
    "南洋": [["nán"], ["yáng"]],
    "南音": [["nán"], ["yīn"]],
    "南岳": [["nán"], ["yuè"]],
    "南粤": [["nán"], ["yuè"]],
    "南越": [["nán"], ["yuè"]],
    "南诏": [["nán"], ["zhào"]],
    "南郑": [["nán"], ["zhèng"]],
    "南中": [["nán"], ["zhōng"]],
    "南竹": [["nán"], ["zhú"]],
    "难熬": [["nán"], ["áo"]],
    "难胞": [["nàn"], ["bāo"]],
    "难保": [["nán"], ["bǎo"]],
    "难缠": [["nán"], ["chán"]],
    "难产": [["nán"], ["chǎn"]],
    "难吃": [["nán"], ["chī"]],
    "难处": [["nán"], ["chǔ"]],
    "难倒": [["nán"], ["dǎo"]],
    "难道": [["nán"], ["dào"]],
    "难当": [["nán"], ["dāng"]],
    "难得": [["nán"], ["de"]],
    "难点": [["nán"], ["diǎn"]],
    "难懂": [["nán"], ["dǒng"]],
    "难度": [["nán"], ["dù"]],
    "难关": [["nán"], ["guān"]],
    "难怪": [["nán"], ["guài"]],
    "难过": [["nán"], ["guò"]],
    "难解": [["nán"], ["jiě"]],
    "难堪": [["nán"], ["kān"]],
    "难看": [["nán"], ["kàn"]],
    "难免": [["nán"], ["miǎn"]],
    "难耐": [["nán"], ["nài"]],
    "难民": [["nàn"], ["mín"]],
    "难侨": [["nàn"], ["qiáo"]],
    "难人": [["nán"], ["rén"]],
    "难忍": [["nán"], ["rěn"]],
    "难色": [["nán"], ["sè"]],
    "难事": [["nán"], ["shì"]],
    "难受": [["nán"], ["shòu"]],
    "难说": [["nán"], ["shuō"]],
    "难题": [["nán"], ["tí"]],
    "难为": [["nán"], ["wéi"]],
    "难忘": [["nán"], ["wàng"]],
    "难听": [["nán"], ["tīng"]],
    "难闻": [["nán"], ["wén"]],
    "难言": [["nán"], ["yán"]],
    "难以": [["nán"], ["yǐ"]],
    "难友": [["nàn"], ["yǒu"]],
    "难易": [["nán"], ["yì"]],
    "难于": [["nán"], ["yú"]],
    "难属": [["nàn"], ["shǔ"]],
    "难住": [["nán"], ["zhù"]],
    "难字": [["nán"], ["zì"]],
    "囊括": [["náng"], ["kuò"]],
    "孬种": [["nāo"], ["zhǒng"]],
    "挠曲": [["náo"], ["qū"]],
    "挠头": [["náo"], ["tóu"]],
    "脑浆": [["nǎo"], ["jiāng"]],
    "闹场": [["nào"], ["chǎng"]],
    "闹哄": [["nào"], ["hōng"]],
    "闹嚷": [["nào"], ["rāng"]],
    "呐喊": [["nà"], ["hǎn"]],
    "闹戏": [["nào"], ["xì"]],
    "呢喃": [["ní"], ["nán"]],
    "嫩红": [["nèn"], ["hóng"]],
    "呢绒": [["ní"], ["róng"]],
    "呢子": [["ní"], ["zǐ"]],
    "嫩绿": [["nèn"], ["lǜ"]],
    "嫩枝": [["nèn"], ["zhī"]],
    "能动": [["néng"], ["dòng"]],
    "能否": [["néng"], ["fǒu"]],
    "能够": [["néng"], ["gòu"]],
    "能耗": [["néng"], ["hào"]],
    "能干": [["néng"], ["gàn"]],
    "能力": [["néng"], ["lì"]],
    "能量": [["néng"], ["liàng"]],
    "能耐": [["néng"], ["nài"]],
    "能人": [["néng"], ["rén"]],
    "能事": [["néng"], ["shì"]],
    "能手": [["néng"], ["shǒu"]],
    "能源": [["néng"], ["yuán"]],
    "泥巴": [["ní"], ["bā"]],
    "尼采": [["ní"], ["cǎi"]],
    "泥封": [["ní"], ["fēng"]],
    "泥垢": [["ní"], ["gòu"]],
    "泥古": [["nì"], ["gǔ"]],
    "泥灰": [["ní"], ["huī"]],
    "泥浆": [["ní"], ["jiāng"]],
    "泥坑": [["ní"], ["kēng"]],
    "泥淖": [["ní"], ["nào"]],
    "泥泞": [["ní"], ["nìng"]],
    "泥坯": [["ní"], ["pī"]],
    "泥鳅": [["ní"], ["qiū"]],
    "泥人": [["ní"], ["rén"]],
    "泥沙": [["ní"], ["shā"]],
    "泥水": [["ní"], ["shuǐ"]],
    "泥塑": [["ní"], ["sù"]],
    "泥胎": [["ní"], ["tāi"]],
    "泥潭": [["ní"], ["tán"]],
    "泥滩": [["ní"], ["tān"]],
    "泥炭": [["ní"], ["tàn"]],
    "泥塘": [["ní"], ["táng"]],
    "泥土": [["ní"], ["tǔ"]],
    "泥丸": [["ní"], ["wán"]],
    "泥污": [["ní"], ["wū"]],
    "泥岩": [["ní"], ["yán"]],
    "泥沼": [["ní"], ["zhǎo"]],
    "泥子": [["nì"], ["zǐ"]],
    "霓裳": [["ní"], ["cháng"]],
    "你好": [["nǐ"], ["hǎo"]],
    "昵称": [["nì"], ["chēng"]],
    "拟合": [["nǐ"], ["hé"]],
    "逆差": [["nì"], ["chà"]],
    "逆行": [["nì"], ["xíng"]],
    "逆风": [["nì"], ["fēng"]],
    "逆转": [["nì"], ["zhuǎn"]],
    "匿藏": [["nì"], ["cáng"]],
    "溺爱": [["nì"], ["ài"]],
    "溺水": [["nì"], ["shuǐ"]],
    "溺死": [["nì"], ["sǐ"]],
    "溺婴": [["nì"], ["yīng"]],
    "拈度": [["niān"], ["dù"]],
    "年长": [["nián"], ["zhǎng"]],
    "年度": [["nián"], ["dù"]],
    "年底": [["nián"], ["dǐ"]],
    "年分": [["nián"], ["fēn"]],
    "年份": [["nián"], ["fèn"]],
    "年号": [["nián"], ["hào"]],
    "年会": [["nián"], ["huì"]],
    "年华": [["nián"], ["huá"]],
    "年纪": [["nián"], ["jì"]],
    "年假": [["nián"], ["jià"]],
    "年间": [["nián"], ["jiān"]],
    "年节": [["nián"], ["jié"]],
    "年景": [["nián"], ["jǐng"]],
    "年少": [["nián"], ["shào"]],
    "年头": [["nián"], ["tóu"]],
    "年尾": [["nián"], ["wěi"]],
    "年中": [["nián"], ["zhōng"]],
    "黏度": [["nián"], ["dù"]],
    "黏糊": [["nián"], ["hú"]],
    "黏着": [["nián"], ["zhe"]],
    "黏结": [["nián"], ["jié"]],
    "碾场": [["niǎn"], ["chǎng"]],
    "碾坊": [["niǎn"], ["fáng"]],
    "碾磨": [["niǎn"], ["mó"]],
    "念叨": [["niàn"], ["dāo"]],
    "碾压": [["niǎn"], ["yā"]],
    "念佛": [["niàn"], ["fó"]],
    "念头": [["niàn"], ["tou"]],
    "娘家": [["niáng"], ["jiā"]],
    "娘亲": [["niáng"], ["qīn"]],
    "鸟笼": [["niǎo"], ["lóng"]],
    "鸟雀": [["niǎo"], ["què"]],
    "袅娜": [["niǎo"], ["nuó"]],
    "尿闭": [["niào"], ["bì"]],
    "尿布": [["niào"], ["bù"]],
    "尿床": [["niào"], ["chuáng"]],
    "尿道": [["niào"], ["dào"]],
    "尿肥": [["niào"], ["féi"]],
    "尿壶": [["niào"], ["hú"]],
    "尿炕": [["niào"], ["kàng"]],
    "尿脬": [["suī"], ["pāo"]],
    "尿泡": [["suī"], ["pào"]],
    "尿盆": [["niào"], ["pén"]],
    "尿素": [["niào"], ["sù"]],
    "尿血": [["niào"], ["xuè"]],
    "捏合": [["niē"], ["hé"]],
    "啮合": [["niè"], ["hé"]],
    "捏弄": [["niē"], ["nòng"]],
    "颞骨": [["niè"], ["gǔ"]],
    "镍钢": [["niè"], ["gāng"]],
    "孽种": [["niè"], ["zhǒng"]],
    "宁安": [["níng"], ["ān"]],
    "宁靖": [["níng"], ["jìng"]],
    "宁静": [["níng"], ["jìng"]],
    "宁可": [["nìng"], ["kě"]],
    "宁肯": [["nìng"], ["kěn"]],
    "宁谧": [["níng"], ["mì"]],
    "宁南": [["níng"], ["nán"]],
    "宁日": [["níng"], ["rì"]],
    "宁帖": [["níng"], ["tiē"]],
    "宁愿": [["nìng"], ["yuàn"]],
    "狞恶": [["níng"], ["è"]],
    "凝合": [["níng"], ["hé"]],
    "凝华": [["níng"], ["huá"]],
    "凝结": [["níng"], ["jié"]],
    "凝思": [["níng"], ["sī"]],
    "凝重": [["níng"], ["zhòng"]],
    "牛扒": [["niú"], ["bā"]],
    "牛车": [["niú"], ["chē"]],
    "牛角": [["niú"], ["jiǎo"]],
    "牛劲": [["niú"], ["jìn"]],
    "牛郎": [["niú"], ["láng"]],
    "牛排": [["niú"], ["pái"]],
    "牛头": [["niú"], ["tóu"]],
    "牛鞅": [["niú"], ["yàng"]],
    "牛仔": [["niú"], ["zǎi"]],
    "扭打": [["niǔ"], ["dǎ"]],
    "扭结": [["niǔ"], ["jié"]],
    "扭曲": [["niǔ"], ["qū"]],
    "扭头": [["niǔ"], ["tóu"]],
    "扭转": [["niǔ"], ["zhuǎn"]],
    "纽结": [["niǔ"], ["jié"]],
    "农场": [["nóng"], ["chǎng"]],
    "农夫": [["nóng"], ["fū"]],
    "农会": [["nóng"], ["huì"]],
    "农家": [["nóng"], ["jiā"]],
    "农校": [["nóng"], ["xiào"]],
    "农行": [["nóng"], ["háng"]],
    "农畜": [["nóng"], ["chù"]],
    "浓度": [["nóng"], ["dù"]],
    "浓缩": [["nóng"], ["suō"]],
    "浓荫": [["nóng"], ["yīn"]],
    "浓重": [["nóng"], ["zhòng"]],
    "弄潮": [["nòng"], ["cháo"]],
    "脓血": [["nóng"], ["xuè"]],
    "弄错": [["nòng"], ["cuò"]],
    "弄臣": [["nòng"], ["chén"]],
    "弄鬼": [["nòng"], ["guǐ"]],
    "弄口": [["lòng"], ["kǒu"]],
    "弄假": [["nòng"], ["jiǎ"]],
    "弄权": [["nòng"], ["quán"]],
    "弄死": [["nòng"], ["sǐ"]],
    "弄堂": [["lòng"], ["táng"]],
    "弄瓦": [["nòng"], ["wǎ"]],
    "奴化": [["nú"], ["huà"]],
    "奴家": [["nú"], ["jiā"]],
    "奴隶": [["nú"], ["lì"]],
    "奴仆": [["nú"], ["pú"]],
    "怒号": [["nù"], ["háo"]],
    "女伴": [["nǚ"], ["bàn"]],
    "怒喝": [["nù"], ["hè"]],
    "女儿": [["nǚ"], ["ér"]],
    "女弟": [["nǚ"], ["dì"]],
    "女方": [["nǚ"], ["fāng"]],
    "女工": [["nǚ"], ["gōng"]],
    "女孩": [["nǚ"], ["hái"]],
    "女红": [["nǚ"], ["gōng"]],
    "女皇": [["nǚ"], ["huáng"]],
    "女家": [["nǚ"], ["jiā"]],
    "女监": [["nǚ"], ["jiān"]],
    "女将": [["nǚ"], ["jiàng"]],
    "女角": [["nǚ"], ["jiǎo"]],
    "女裤": [["nǚ"], ["kù"]],
    "女眷": [["nǚ"], ["juàn"]],
    "女郎": [["nǚ"], ["láng"]],
    "女流": [["nǚ"], ["liú"]],
    "女伶": [["nǚ"], ["líng"]],
    "女奴": [["nǚ"], ["nú"]],
    "女仆": [["nǚ"], ["pú"]],
    "女墙": [["nǚ"], ["qiáng"]],
    "女权": [["nǚ"], ["quán"]],
    "女人": [["nǚ"], ["rén"]],
    "女神": [["nǚ"], ["shén"]],
    "女色": [["nǚ"], ["sè"]],
    "女生": [["nǚ"], ["shēng"]],
    "女史": [["nǚ"], ["shǐ"]],
    "女尸": [["nǚ"], ["shī"]],
    "女士": [["nǚ"], ["shì"]],
    "女侍": [["nǚ"], ["shì"]],
    "女童": [["nǚ"], ["tóng"]],
    "女娲": [["nǚ"], ["wā"]],
    "女王": [["nǚ"], ["wáng"]],
    "女巫": [["nǚ"], ["wū"]],
    "女性": [["nǚ"], ["xìng"]],
    "女婿": [["nǚ"], ["xù"]],
    "女妖": [["nǚ"], ["yāo"]],
    "女优": [["nǚ"], ["yōu"]],
    "女贞": [["nǚ"], ["zhēn"]],
    "女真": [["nǚ"], ["zhēn"]],
    "女装": [["nǚ"], ["zhuāng"]],
    "女子": [["nǚ"], ["zǐ"]],
    "疟疾": [["nüè"], ["jí"]],
    "疟蚊": [["nüè"], ["wén"]],
    "虐待": [["nüè"], ["dài"]],
    "疟子": [["yào"], ["zǐ"]],
    "暖风": [["nuǎn"], ["fēng"]],
    "暖和": [["nuǎn"], ["huo"]],
    "懦夫": [["nuò"], ["fū"]],
    "欧风": [["ōu"], ["fēng"]],
    "欧化": [["ōu"], ["huà"]],
    "欧体": [["ōu"], ["tǐ"]],
    "殴打": [["ōu"], ["dǎ"]],
    "殴斗": [["ōu"], ["dòu"]],
    "呕气": [["ǒu"], ["qì"]],
    "呕心": [["ǒu"], ["xīn"]],
    "呕吐": [["ǒu"], ["tù"]],
    "呕血": [["ǒu"], ["xuè"]],
    "呕哑": [["ōu"], ["yā"]],
    "偶发": [["ǒu"], ["fā"]],
    "偶合": [["ǒu"], ["hé"]],
    "藕节": [["ǒu"], ["jié"]],
    "沤肥": [["òu"], ["féi"]],
    "啪嗒": [["pā"], ["dā"]],
    "爬行": [["pá"], ["xíng"]],
    "耙地": [["bà"], ["dì"]],
    "耙子": [["pá"], ["zǐ"]],
    "拍打": [["pāi"], ["dǎ"]],
    "拍发": [["pāi"], ["fā"]],
    "拍摄": [["pāi"], ["shè"]],
    "拍戏": [["pāi"], ["xì"]],
    "俳句": [["pái"], ["jù"]],
    "排班": [["pái"], ["bān"]],
    "排版": [["pái"], ["bǎn"]],
    "排笔": [["pái"], ["bǐ"]],
    "排长": [["pái"], ["zhǎng"]],
    "排场": [["pái"], ["chɑng"]],
    "排除": [["pái"], ["chú"]],
    "排挡": [["pái"], ["dǎng"]],
    "排队": [["pái"], ["duì"]],
    "排筏": [["pái"], ["fá"]],
    "排放": [["pái"], ["fàng"]],
    "排骨": [["pái"], ["gǔ"]],
    "排灌": [["pái"], ["guàn"]],
    "排击": [["pái"], ["jī"]],
    "排解": [["pái"], ["jiě"]],
    "排空": [["pái"], ["kōng"]],
    "排涝": [["pái"], ["lào"]],
    "排练": [["pái"], ["liàn"]],
    "排律": [["pái"], ["lǜ"]],
    "排偶": [["pái"], ["ǒu"]],
    "排炮": [["pái"], ["pào"]],
    "排枪": [["pái"], ["qiāng"]],
    "排遣": [["pái"], ["qiǎn"]],
    "排他": [["pái"], ["tā"]],
    "排外": [["pái"], ["wài"]],
    "排尾": [["pái"], ["wěi"]],
    "排污": [["pái"], ["wū"]],
    "排戏": [["pái"], ["xì"]],
    "排箫": [["pái"], ["xiāo"]],
    "排演": [["pái"], ["yǎn"]],
    "排印": [["pái"], ["yìn"]],
    "排字": [["pái"], ["zì"]],
    "牌坊": [["pái"], ["fāng"]],
    "牌风": [["pái"], ["fēng"]],
    "牌号": [["pái"], ["hào"]],
    "牌价": [["pái"], ["jià"]],
    "派别": [["pài"], ["bié"]],
    "派头": [["pài"], ["tóu"]],
    "派系": [["pài"], ["xì"]],
    "攀亲": [["pān"], ["qīn"]],
    "攀供": [["pān"], ["gòng"]],
    "攀折": [["pān"], ["zhé"]],
    "盘石": [["pán"], ["shí"]],
    "磐石": [["pán"], ["shí"]],
    "判别": [["pàn"], ["bié"]],
    "判读": [["pàn"], ["dú"]],
    "判处": [["pàn"], ["chǔ"]],
    "判据": [["pàn"], ["jù"]],
    "盼头": [["pàn"], ["tou"]],
    "庞大": [["páng"], ["dà"]],
    "旁白": [["páng"], ["bái"]],
    "旁边": [["páng"], ["biān"]],
    "旁侧": [["páng"], ["cè"]],
    "旁出": [["páng"], ["chū"]],
    "旁观": [["páng"], ["guān"]],
    "旁及": [["páng"], ["jí"]],
    "旁路": [["páng"], ["lù"]],
    "旁落": [["páng"], ["luò"]],
    "旁门": [["páng"], ["mén"]],
    "旁人": [["páng"], ["rén"]],
    "旁听": [["páng"], ["tīng"]],
    "旁通": [["páng"], ["tōng"]],
    "旁骛": [["páng"], ["wù"]],
    "旁证": [["páng"], ["zhèng"]],
    "旁支": [["páng"], ["zhī"]],
    "旁注": [["páng"], ["zhù"]],
    "旁坐": [["páng"], ["zuò"]],
    "抛洒": [["pāo"], ["sǎ"]],
    "抛空": [["pāo"], ["kōng"]],
    "抛撒": [["pāo"], ["sā"]],
    "刨冰": [["bào"], ["bīng"]],
    "抛射": [["pāo"], ["shè"]],
    "刨除": [["páo"], ["chú"]],
    "刨床": [["bào"], ["chuáng"]],
    "刨刀": [["bào"], ["dāo"]],
    "刨工": [["páo"], ["gōng"]],
    "刨花": [["páo"], ["huā"]],
    "刨食": [["páo"], ["shí"]],
    "刨削": [["páo"], ["xuē"]],
    "刨子": [["bào"], ["zǐ"]],
    "庖丁": [["páo"], ["dīng"]],
    "炮兵": [["pào"], ["bīng"]],
    "炮车": [["pào"], ["chē"]],
    "炮弹": [["pào"], ["dàn"]],
    "炮灰": [["pào"], ["huī"]],
    "炮火": [["pào"], ["huǒ"]],
    "炮击": [["pào"], ["jī"]],
    "炮舰": [["pào"], ["jiàn"]],
    "炮口": [["pào"], ["kǒu"]],
    "炮烙": [["páo"], ["luò"]],
    "炮楼": [["pào"], ["lóu"]],
    "炮手": [["pào"], ["shǒu"]],
    "炮塔": [["pào"], ["tǎ"]],
    "炮台": [["pào"], ["tái"]],
    "炮艇": [["pào"], ["tǐng"]],
    "炮膛": [["pào"], ["táng"]],
    "炮位": [["pào"], ["wèi"]],
    "炮眼": [["pào"], ["yǎn"]],
    "炮衣": [["pào"], ["yī"]],
    "炮仗": [["pào"], ["zhàng"]],
    "炮制": [["páo"], ["zhì"]],
    "炮竹": [["pào"], ["zhú"]],
    "炮座": [["pào"], ["zuò"]],
    "袍服": [["páo"], ["fú"]],
    "袍泽": [["páo"], ["zé"]],
    "跑表": [["pǎo"], ["biǎo"]],
    "跑步": [["pǎo"], ["bù"]],
    "跑车": [["pǎo"], ["chē"]],
    "跑道": [["pǎo"], ["dào"]],
    "跑调": [["pǎo"], ["diào"]],
    "跑电": [["pǎo"], ["diàn"]],
    "跑动": [["pǎo"], ["dòng"]],
    "跑肚": [["pǎo"], ["dù"]],
    "跑反": [["pǎo"], ["fǎn"]],
    "跑光": [["pǎo"], ["guāng"]],
    "跑街": [["pǎo"], ["jiē"]],
    "跑马": [["pǎo"], ["mǎ"]],
    "跑墒": [["pǎo"], ["shāng"]],
    "跑题": [["pǎo"], ["tí"]],
    "跑堂": [["pǎo"], ["táng"]],
    "跑腿": [["pǎo"], ["tuǐ"]],
    "跑外": [["pǎo"], ["wài"]],
    "跑鞋": [["pǎo"], ["xié"]],
    "泡菜": [["pào"], ["cài"]],
    "泡茶": [["pào"], ["chá"]],
    "泡饭": [["pào"], ["fàn"]],
    "泡货": [["pāo"], ["huò"]],
    "泡沫": [["pào"], ["mò"]],
    "泡妞": [["pào"], ["niū"]],
    "泡泡": [["pào"], ["pào"]],
    "泡汤": [["pào"], ["tāng"]],
    "泡桐": [["pāo"], ["tóng"]],
    "泡漩": [["pào"], ["xuán"]],
    "泡影": [["pào"], ["yǐng"]],
    "泡澡": [["pào"], ["zǎo"]],
    "泡制": [["pào"], ["zhì"]],
    "泡子": [["pāo"], ["zǐ"]],
    "胚轴": [["pēi"], ["zhóu"]],
    "陪都": [["péi"], ["dū"]],
    "陪祭": [["péi"], ["jì"]],
    "陪同": [["péi"], ["tóng"]],
    "赔还": [["péi"], ["huán"]],
    "佩服": [["pèi"], ["fú"]],
    "配称": [["pèi"], ["chèn"]],
    "配调": [["pèi"], ["diào"]],
    "配发": [["pèi"], ["fā"]],
    "配给": [["pèi"], ["jǐ"]],
    "配合": [["pèi"], ["hé"]],
    "配角": [["pèi"], ["jué"]],
    "配乐": [["pèi"], ["yuè"]],
    "配曲": [["pèi"], ["qǔ"]],
    "配戏": [["pèi"], ["xì"]],
    "配载": [["pèi"], ["zǎi"]],
    "配种": [["pèi"], ["zhǒng"]],
    "配属": [["pèi"], ["shǔ"]],
    "配重": [["pèi"], ["zhòng"]],
    "辔头": [["pèi"], ["tóu"]],
    "喷薄": [["pēn"], ["bó"]],
    "喷灯": [["pēn"], ["dēng"]],
    "喷发": [["pēn"], ["fā"]],
    "喷饭": [["pēn"], ["fàn"]],
    "喷粪": [["pēn"], ["fèn"]],
    "喷管": [["pēn"], ["guǎn"]],
    "喷灌": [["pēn"], ["guàn"]],
    "喷壶": [["pēn"], ["hú"]],
    "喷火": [["pēn"], ["huǒ"]],
    "喷溅": [["pēn"], ["jiàn"]],
    "喷浆": [["pēn"], ["jiāng"]],
    "喷口": [["pēn"], ["kǒu"]],
    "喷漆": [["pēn"], ["qī"]],
    "喷气": [["pēn"], ["qì"]],
    "喷泉": [["pēn"], ["quán"]],
    "喷撒": [["pēn"], ["sǎ"]],
    "喷洒": [["pēn"], ["sǎ"]],
    "喷射": [["pēn"], ["shè"]],
    "喷水": [["pēn"], ["shuǐ"]],
    "喷嚏": [["pēn"], ["tì"]],
    "喷头": [["pēn"], ["tóu"]],
    "喷吐": [["pēn"], ["tǔ"]],
    "喷雾": [["pēn"], ["wù"]],
    "喷香": [["pèn"], ["xiāng"]],
    "喷泻": [["pēn"], ["xiè"]],
    "喷涌": [["pēn"], ["yǒng"]],
    "喷嘴": [["pēn"], ["zuǐ"]],
    "盆景": [["pén"], ["jǐng"]],
    "盆地": [["pén"], ["dì"]],
    "盆汤": [["pén"], ["tāng"]],
    "抨弹": [["pēng"], ["tán"]],
    "烹调": [["pēng"], ["tiáo"]],
    "彭泽": [["péng"], ["zé"]],
    "棚车": [["péng"], ["chē"]],
    "棚圈": [["péng"], ["juàn"]],
    "蓬勃": [["péng"], ["bó"]],
    "篷车": [["péng"], ["chē"]],
    "膨大": [["péng"], ["dà"]],
    "膨化": [["péng"], ["huà"]],
    "碰见": [["pèng"], ["jiàn"]],
    "碰头": [["pèng"], ["tóu"]],
    "批发": [["pī"], ["fā"]],
    "批斗": [["pī"], ["dòu"]],
    "批号": [["pī"], ["hào"]],
    "批假": [["pī"], ["jià"]],
    "批量": [["pī"], ["liàng"]],
    "批条": [["pī"], ["tiáo"]],
    "批转": [["pī"], ["zhuǎn"]],
    "披发": [["pī"], ["fà"]],
    "纰缪": [["pī"], ["miù"]],
    "纰漏": [["pī"], ["lòu"]],
    "批语": [["pī"], ["yǔ"]],
    "披风": [["pī"], ["fēng"]],
    "披拂": [["pī"], ["fú"]],
    "披红": [["pī"], ["hóng"]],
    "披卷": [["pī"], ["juàn"]],
    "披头": [["pī"], ["tóu"]],
    "披露": [["pī"], ["lù"]],
    "披散": [["pī"], ["sǎn"]],
    "劈柴": [["pǐ"], ["chái"]],
    "劈叉": [["pǐ"], ["chà"]],
    "劈成": [["pǐ"], ["chéng"]],
    "劈刀": [["pī"], ["dāo"]],
    "劈刺": [["pī"], ["cì"]],
    "劈脸": [["pī"], ["liǎn"]],
    "劈裂": [["pī"], ["liè"]],
    "劈面": [["pī"], ["miàn"]],
    "劈啪": [["pī"], ["pā"]],
    "劈杀": [["pī"], ["shā"]],
    "劈山": [["pī"], ["shān"]],
    "劈手": [["pī"], ["shǒu"]],
    "劈头": [["pī"], ["tóu"]],
    "劈胸": [["pī"], ["xiōng"]],
    "皮尺": [["pí"], ["chǐ"]],
    "皮夹": [["pí"], ["jiā"]],
    "皮囊": [["pí"], ["náng"]],
    "皮条": [["pí"], ["tiáo"]],
    "皮相": [["pí"], ["xiàng"]],
    "疲沓": [["pí"], ["ta"]],
    "皮重": [["pí"], ["zhòng"]],
    "疲累": [["pí"], ["lèi"]],
    "匹夫": [["pǐ"], ["fū"]],
    "仳离": [["pǐ"], ["lí"]],
    "癖好": [["pǐ"], ["hào"]],
    "睥睨": [["bì"], ["nì"]],
    "僻巷": [["pì"], ["xiàng"]],
    "僻远": [["pì"], ["yuǎn"]],
    "譬若": [["pì"], ["ruò"]],
    "片酬": [["piàn"], ["chóu"]],
    "片段": [["piàn"], ["duàn"]],
    "片断": [["piàn"], ["duàn"]],
    "片儿": [["piān"], ["er"]],
    "片剂": [["piàn"], ["jì"]],
    "片刻": [["piàn"], ["kè"]],
    "片面": [["piàn"], ["miàn"]],
    "片时": [["piàn"], ["shí"]],
    "片头": [["piān"], ["tóu"]],
    "片言": [["piàn"], ["yán"]],
    "片语": [["piàn"], ["yǔ"]],
    "片子": [["piān"], ["zi"]],
    "偏差": [["piān"], ["chā"]],
    "偏好": [["piān"], ["hǎo"]],
    "偏食": [["piān"], ["shí"]],
    "偏信": [["piān"], ["xìn"]],
    "偏要": [["piān"], ["yào"]],
    "偏重": [["piān"], ["zhòng"]],
    "骈体": [["pián"], ["tǐ"]],
    "篇什": [["piān"], ["shí"]],
    "骈枝": [["pián"], ["zhī"]],
    "骗术": [["piàn"], ["shù"]],
    "漂泊": [["piāo"], ["bó"]],
    "漂白": [["piǎo"], ["bái"]],
    "漂儿": [["piāo"], ["ér"]],
    "漂浮": [["piāo"], ["fú"]],
    "漂砾": [["piāo"], ["lì"]],
    "漂海": [["piāo"], ["hǎi"]],
    "漂亮": [["piào"], ["liàng"]],
    "漂流": [["piāo"], ["liú"]],
    "漂漂": [["piāo"], ["piāo"]],
    "漂染": [["piǎo"], ["rǎn"]],
    "漂洗": [["piǎo"], ["xǐ"]],
    "漂移": [["piāo"], ["yí"]],
    "漂游": [["piāo"], ["yóu"]],
    "缥缈": [["piāo"], ["miǎo"]],
    "飘泊": [["piāo"], ["bó"]],
    "飘风": [["piāo"], ["fēng"]],
    "飘拂": [["piāo"], ["fú"]],
    "飘落": [["piāo"], ["luò"]],
    "飘洒": [["piāo"], ["sǎ"]],
    "飘散": [["piāo"], ["sàn"]],
    "嫖娼": [["piáo"], ["chāng"]],
    "嫖妓": [["piáo"], ["jì"]],
    "嫖客": [["piáo"], ["kè"]],
    "撇开": [["piē"], ["kāi"]],
    "嫖宿": [["piáo"], ["sù"]],
    "撇弃": [["piē"], ["qì"]],
    "撇嘴": [["piě"], ["zuǐ"]],
    "姘夫": [["pīn"], ["fū"]],
    "瞥见": [["piē"], ["jiàn"]],
    "姘头": [["pīn"], ["tou"]],
    "拼刺": [["pīn"], ["cì"]],
    "拼斗": [["pīn"], ["dòu"]],
    "拼读": [["pīn"], ["dú"]],
    "拼合": [["pīn"], ["hé"]],
    "拼抢": [["pīn"], ["qiǎng"]],
    "贫化": [["pín"], ["huà"]],
    "贫血": [["pín"], ["xuè"]],
    "嫔妃": [["pín"], ["fēi"]],
    "频传": [["pín"], ["chuán"]],
    "频次": [["pín"], ["cì"]],
    "频带": [["pín"], ["dài"]],
    "频道": [["pín"], ["dào"]],
    "频度": [["pín"], ["dù"]],
    "频段": [["pín"], ["duàn"]],
    "频繁": [["pín"], ["fán"]],
    "频率": [["pín"], ["lǜ"]],
    "频频": [["pín"], ["pín"]],
    "频谱": [["pín"], ["pǔ"]],
    "频数": [["pín"], ["shuò"]],
    "频仍": [["pín"], ["réng"]],
    "品红": [["pǐn"], ["hóng"]],
    "品节": [["pǐn"], ["jié"]],
    "品绿": [["pǐn"], ["lǜ"]],
    "品系": [["pǐn"], ["xì"]],
    "品行": [["pǐn"], ["xíng"]],
    "聘任": [["pìn"], ["rèn"]],
    "品种": [["pǐn"], ["zhǒng"]],
    "聘期": [["pìn"], ["qī"]],
    "聘约": [["pìn"], ["yuē"]],
    "平地": [["píng"], ["dì"]],
    "平调": [["píng"], ["diào"]],
    "平峒": [["píng"], ["dòng"]],
    "平度": [["píng"], ["dù"]],
    "平分": [["píng"], ["fēn"]],
    "平服": [["píng"], ["fú"]],
    "平和": [["píng"], ["hé"]],
    "平价": [["píng"], ["jià"]],
    "平空": [["píng"], ["kōng"]],
    "平乐": [["píng"], ["lè"]],
    "平铺": [["píng"], ["pù"]],
    "平台": [["píng"], ["tái"]],
    "平巷": [["píng"], ["hàng"]],
    "平头": [["píng"], ["tóu"]],
    "平信": [["píng"], ["xìn"]],
    "平行": [["píng"], ["xíng"]],
    "平正": [["píng"], ["zhèng"]],
    "评弹": [["píng"], ["tán"]],
    "平远": [["píng"], ["yuǎn"]],
    "评传": [["píng"], ["zhuàn"]],
    "评分": [["píng"], ["fēn"]],
    "评价": [["píng"], ["jià"]],
    "评估": [["píng"], ["gū"]],
    "评卷": [["píng"], ["juàn"]],
    "评量": [["píng"], ["liàng"]],
    "评论": [["píng"], ["lùn"]],
    "评说": [["píng"], ["shuō"]],
    "评委": [["píng"], ["wěi"]],
    "评戏": [["píng"], ["xì"]],
    "评语": [["píng"], ["yǔ"]],
    "凭单": [["píng"], ["dān"]],
    "凭藉": [["píng"], ["jiè"]],
    "凭据": [["píng"], ["jù"]],
    "凭空": [["píng"], ["kōng"]],
    "凭信": [["píng"], ["xìn"]],
    "苹果": [["pín"], ["guǒ"]],
    "屏除": [["bǐng"], ["chú"]],
    "屏蔽": [["píng"], ["bì"]],
    "屏风": [["píng"], ["fēng"]],
    "屏门": [["píng"], ["mén"]],
    "屏迹": [["píng"], ["jì"]],
    "屏幕": [["píng"], ["mù"]],
    "屏气": [["bǐng"], ["qì"]],
    "屏弃": [["bǐng"], ["qì"]],
    "屏山": [["píng"], ["shān"]],
    "屏条": [["píng"], ["tiáo"]],
    "屏退": [["bǐng"], ["tuì"]],
    "屏息": [["bǐng"], ["xī"]],
    "屏障": [["píng"], ["zhàng"]],
    "瓶颈": [["píng"], ["jǐng"]],
    "坡地": [["pō"], ["dì"]],
    "坡度": [["pō"], ["dù"]],
    "泼剌": [["pō"], ["là"]],
    "泼洒": [["pō"], ["sǎ"]],
    "迫促": [["pò"], ["cù"]],
    "迫害": [["pò"], ["hài"]],
    "迫降": [["pò"], ["jiàng"]],
    "迫近": [["pò"], ["jìn"]],
    "迫令": [["pò"], ["lìng"]],
    "迫临": [["pò"], ["lín"]],
    "迫使": [["pò"], ["shǐ"]],
    "迫切": [["pò"], ["qiè"]],
    "迫于": [["pò"], ["yú"]],
    "破读": [["pò"], ["dú"]],
    "破坏": [["pò"], ["huài"]],
    "破家": [["pò"], ["jiā"]],
    "破解": [["pò"], ["jiě"]],
    "破裂": [["pò"], ["liè"]],
    "破落": [["pò"], ["luò"]],
    "破片": [["pò"], ["piàn"]],
    "破相": [["pò"], ["xiàng"]],
    "剖解": [["pōu"], ["jiě"]],
    "破约": [["pò"], ["yuē"]],
    "仆从": [["pú"], ["cóng"]],
    "仆妇": [["pú"], ["fù"]],
    "仆人": [["pú"], ["rén"]],
    "仆役": [["pú"], ["yì"]],
    "扑打": [["pū"], ["dǎ"]],
    "扑地": [["pū"], ["dì"]],
    "扑空": [["pū"], ["kōng"]],
    "扑棱": [["pū"], ["lēng"]],
    "扑扇": [["pū"], ["shān"]],
    "铺板": [["pù"], ["bǎn"]],
    "铺陈": [["pū"], ["chén"]],
    "铺保": [["pù"], ["bǎo"]],
    "铺衬": [["pū"], ["chèn"]],
    "铺床": [["pū"], ["chuáng"]],
    "铺底": [["pù"], ["dǐ"]],
    "铺垫": [["pū"], ["diàn"]],
    "铺盖": [["pū"], ["gài"]],
    "铺轨": [["pū"], ["guǐ"]],
    "铺户": [["pù"], ["hù"]],
    "铺路": [["pū"], ["lù"]],
    "铺面": [["pū"], ["miàn"]],
    "铺排": [["pū"], ["pái"]],
    "铺平": [["pū"], ["píng"]],
    "铺铺": [["pù"], ["pù"]],
    "铺砌": [["pū"], ["qì"]],
    "铺设": [["pū"], ["shè"]],
    "铺叙": [["pū"], ["xù"]],
    "铺位": [["pù"], ["wèi"]],
    "铺展": [["pū"], ["zhǎn"]],
    "铺张": [["pū"], ["zhāng"]],
    "铺子": [["pù"], ["zǐ"]],
    "蒲节": [["pú"], ["jié"]],
    "蒲扇": [["pú"], ["shàn"]],
    "朴厚": [["pǔ"], ["hòu"]],
    "朴陋": [["pǔ"], ["lòu"]],
    "朴茂": [["pǔ"], ["mào"]],
    "朴实": [["pǔ"], ["shí"]],
    "朴素": [["pǔ"], ["sù"]],
    "朴硝": [["pò"], ["xiāo"]],
    "朴学": [["pǔ"], ["xué"]],
    "朴质": [["pǔ"], ["zhì"]],
    "朴直": [["pǔ"], ["zhí"]],
    "朴拙": [["pǔ"], ["zhuō"]],
    "普度": [["pǔ"], ["dù"]],
    "普查": [["pǔ"], ["zhā"]],
    "普降": [["pǔ"], ["jiàng"]],
    "普教": [["pǔ"], ["jiào"]],
    "谱号": [["pǔ"], ["hào"]],
    "谱曲": [["pǔ"], ["qǔ"]],
    "谱系": [["pǔ"], ["xì"]],
    "瀑布": [["pù"], ["bù"]],
    "曝露": [["pù"], ["lù"]],
    "曝光": [["bào"], ["guāng"]],
    "曝晒": [["pù"], ["shài"]],
    "七大": [["qī"], ["dà"]],
    "妻弟": [["qī"], ["dì"]],
    "妻儿": [["qī"], ["ér"]],
    "妻舅": [["qī"], ["jiù"]],
    "妻孥": [["qī"], ["nú"]],
    "妻室": [["qī"], ["shì"]],
    "妻小": [["qī"], ["xiǎo"]],
    "妻子": [["qī"], ["zǐ"]],
    "凄凉": [["qī"], ["liáng"]],
    "凄切": [["qī"], ["qiè"]],
    "栖居": [["qī"], ["jū"]],
    "栖身": [["qī"], ["shēn"]],
    "栖息": [["qī"], ["xī"]],
    "栖霞": [["qī"], ["xiá"]],
    "戚属": [["qī"], ["shǔ"]],
    "栖止": [["qī"], ["zhǐ"]],
    "期待": [["qī"], ["dài"]],
    "期货": [["qī"], ["huò"]],
    "期刊": [["qī"], ["kān"]],
    "期间": [["qī"], ["jiān"]],
    "期冀": [["qī"], ["jì"]],
    "期考": [["qī"], ["kǎo"]],
    "期满": [["qī"], ["mǎn"]],
    "期门": [["qī"], ["mén"]],
    "期末": [["qī"], ["mò"]],
    "期盼": [["qī"], ["pàn"]],
    "期年": [["jī"], ["nián"]],
    "期期": [["qī"], ["qī"]],
    "期票": [["qī"], ["piào"]],
    "期求": [["qī"], ["qiú"]],
    "期权": [["qī"], ["quán"]],
    "期数": [["qī"], ["shù"]],
    "期许": [["qī"], ["xǔ"]],
    "期望": [["qī"], ["wàng"]],
    "期中": [["qī"], ["zhōng"]],
    "期限": [["qī"], ["xiàn"]],
    "欺哄": [["qī"], ["hǒng"]],
    "欺瞒": [["qī"], ["mán"]],
    "欺蒙": [["qī"], ["méng"]],
    "欺压": [["qī"], ["yā"]],
    "齐备": [["qí"], ["bèi"]],
    "齐步": [["qí"], ["bù"]],
    "齐唱": [["qí"], ["chàng"]],
    "齐楚": [["qí"], ["chǔ"]],
    "齐发": [["qí"], ["fā"]],
    "齐放": [["qí"], ["fàng"]],
    "齐家": [["qí"], ["jiā"]],
    "齐集": [["qí"], ["jí"]],
    "齐肩": [["qí"], ["jiān"]],
    "齐眉": [["qí"], ["méi"]],
    "齐名": [["qí"], ["míng"]],
    "齐明": [["zī"], ["míng"]],
    "齐齐": [["qí"], ["qí"]],
    "齐全": [["qí"], ["quán"]],
    "齐射": [["qí"], ["shè"]],
    "齐人": [["qí"], ["rén"]],
    "齐声": [["qí"], ["shēng"]],
    "齐天": [["qí"], ["tiān"]],
    "齐头": [["qí"], ["tóu"]],
    "齐心": [["qí"], ["xīn"]],
    "齐行": [["qí"], ["xíng"]],
    "齐整": [["qí"], ["zhěng"]],
    "齐奏": [["qí"], ["zòu"]],
    "其次": [["qí"], ["cì"]],
    "其后": [["qí"], ["hòu"]],
    "其间": [["qí"], ["jiān"]],
    "其内": [["qí"], ["nèi"]],
    "其时": [["qí"], ["shí"]],
    "其实": [["qí"], ["shí"]],
    "其他": [["qí"], ["tā"]],
    "其它": [["qí"], ["tā"]],
    "其先": [["qí"], ["xiān"]],
    "其余": [["qí"], ["yú"]],
    "其中": [["qí"], ["zhōng"]],
    "奇兵": [["qí"], ["bīng"]],
    "奇才": [["qí"], ["cái"]],
    "奇功": [["qí"], ["gōng"]],
    "奇怪": [["qí"], ["guài"]],
    "奇观": [["qí"], ["guān"]],
    "奇诡": [["qí"], ["guǐ"]],
    "奇幻": [["qí"], ["huàn"]],
    "奇祸": [["qí"], ["huò"]],
    "奇迹": [["qí"], ["jì"]],
    "奇技": [["qí"], ["jì"]],
    "奇景": [["qí"], ["jǐng"]],
    "奇绝": [["qí"], ["jué"]],
    "奇崛": [["qí"], ["jué"]],
    "奇谲": [["qí"], ["jué"]],
    "奇零": [["jī"], ["líng"]],
    "奇丽": [["qí"], ["lì"]],
    "奇门": [["qí"], ["mén"]],
    "奇妙": [["qí"], ["miào"]],
    "奇谋": [["qí"], ["móu"]],
    "奇偶": [["jī"], ["ǒu"]],
    "奇葩": [["qí"], ["pā"]],
    "奇巧": [["qí"], ["qiǎo"]],
    "奇缺": [["qí"], ["quē"]],
    "奇趣": [["qí"], ["qù"]],
    "奇人": [["qí"], ["rén"]],
    "奇事": [["qí"], ["shì"]],
    "奇数": [["jī"], ["shù"]],
    "奇谈": [["qí"], ["tán"]],
    "奇特": [["qí"], ["tè"]],
    "奇伟": [["qí"], ["wěi"]],
    "奇文": [["qí"], ["wén"]],
    "奇闻": [["qí"], ["wén"]],
    "奇袭": [["qí"], ["xí"]],
    "奇秀": [["qí"], ["xiù"]],
    "奇勋": [["qí"], ["xūn"]],
    "奇遇": [["qí"], ["yù"]],
    "奇异": [["qí"], ["yì"]],
    "奇冤": [["qí"], ["yuān"]],
    "奇缘": [["qí"], ["yuán"]],
    "奇珍": [["qí"], ["zhēn"]],
    "奇志": [["qí"], ["zhì"]],
    "祈雨": [["qí"], ["yǔ"]],
    "耆老": [["qí"], ["lǎo"]],
    "耆宿": [["qí"], ["sù"]],
    "颀长": [["qí"], ["cháng"]],
    "骑乘": [["qí"], ["chéng"]],
    "骑射": [["qí"], ["shè"]],
    "旗杆": [["qí"], ["gān"]],
    "旗号": [["qí"], ["hào"]],
    "蕲蛇": [["qí"], ["shé"]],
    "旗语": [["qí"], ["yǔ"]],
    "乞和": [["qǐ"], ["hé"]],
    "乞降": [["qǐ"], ["xiáng"]],
    "乞食": [["qǐ"], ["shí"]],
    "企待": [["qǐ"], ["dài"]],
    "企划": [["qǐ"], ["huá"]],
    "岂不": [["qǐ"], ["bù"]],
    "岂但": [["qǐ"], ["dàn"]],
    "岂非": [["qǐ"], ["fēi"]],
    "岂敢": [["qǐ"], ["gǎn"]],
    "岂可": [["qǐ"], ["kě"]],
    "岂肯": [["qǐ"], ["kěn"]],
    "岂能": [["qǐ"], ["néng"]],
    "岂止": [["qǐ"], ["zhǐ"]],
    "启发": [["qǐ"], ["fā"]],
    "启蒙": [["qǐ"], ["méng"]],
    "启行": [["qǐ"], ["xíng"]],
    "起风": [["qǐ"], ["fēng"]],
    "起家": [["qǐ"], ["jiā"]],
    "起哄": [["qǐ"], ["hòng"]],
    "起价": [["qǐ"], ["jià"]],
    "起见": [["qǐ"], ["jiàn"]],
    "起降": [["qǐ"], ["jiàng"]],
    "起解": [["qǐ"], ["jiè"]],
    "起劲": [["qǐ"], ["jìn"]],
    "起落": [["qǐ"], ["luò"]],
    "起跑": [["qǐ"], ["pǎo"]],
    "起泡": [["qǐ"], ["pào"]],
    "起跳": [["qǐ"], ["tiào"]],
    "起头": [["qǐ"], ["tóu"]],
    "起兴": [["qǐ"], ["xìng"]],
    "起行": [["qǐ"], ["xíng"]],
    "起疑": [["qǐ"], ["yí"]],
    "起重": [["qǐ"], ["zhòng"]],
    "气度": [["qì"], ["dù"]],
    "气化": [["qì"], ["huà"]],
    "气节": [["qì"], ["jié"]],
    "气量": [["qì"], ["liàng"]],
    "气脉": [["qì"], ["mài"]],
    "气闷": [["qì"], ["mèn"]],
    "气囊": [["qì"], ["náng"]],
    "气泡": [["qì"], ["pào"]],
    "气圈": [["qì"], ["quān"]],
    "气盛": [["qì"], ["shèng"]],
    "气体": [["qì"], ["tǐ"]],
    "气数": [["qì"], ["shù"]],
    "气旋": [["qì"], ["xuán"]],
    "气血": [["qì"], ["xuè"]],
    "气压": [["qì"], ["yā"]],
    "汽车": [["qì"], ["chē"]],
    "汽化": [["qì"], ["huà"]],
    "泣血": [["qì"], ["xuè"]],
    "契丹": [["qì"], ["dān"]],
    "契合": [["qì"], ["hé"]],
    "契据": [["qì"], ["jù"]],
    "契机": [["qì"], ["jī"]],
    "契卡": [["qì"], ["kǎ"]],
    "契友": [["qì"], ["yǒu"]],
    "砌块": [["qì"], ["kuài"]],
    "契约": [["qì"], ["yuē"]],
    "器度": [["qì"], ["dù"]],
    "器乐": [["qì"], ["lè"]],
    "器量": [["qì"], ["liàng"]],
    "器重": [["qì"], ["zhòng"]],
    "器识": [["qì"], ["shí"]],
    "恰当": [["qià"], ["dàng"]],
    "恰好": [["qià"], ["hǎo"]],
    "恰切": [["qià"], ["qiē"]],
    "恰似": [["qià"], ["sì"]],
    "千夫": [["qiān"], ["fū"]],
    "千卡": [["qiān"], ["kǎ"]],
    "千瓦": [["qiān"], ["wǎ"]],
    "千万": [["qiān"], ["wàn"]],
    "迁都": [["qiān"], ["dū"]],
    "牵累": [["qiān"], ["lěi"]],
    "牵拉": [["qiān"], ["lā"]],
    "牵强": [["qiān"], ["qiǎng"]],
    "牵系": [["qiān"], ["xì"]],
    "牵头": [["qiān"], ["tóu"]],
    "铅板": [["qiān"], ["bǎn"]],
    "铅版": [["qiān"], ["bǎn"]],
    "铅笔": [["qiān"], ["bǐ"]],
    "铅丹": [["qiān"], ["dān"]],
    "铅弹": [["qiān"], ["dàn"]],
    "铅粉": [["qiān"], ["fěn"]],
    "铅华": [["qiān"], ["huá"]],
    "铅球": [["qiān"], ["qiú"]],
    "铅山": [["yán"], ["shān"]],
    "铅丝": [["qiān"], ["sī"]],
    "铅铁": [["qiān"], ["tiě"]],
    "铅条": [["qiān"], ["tiáo"]],
    "铅印": [["qiān"], ["yìn"]],
    "铅直": [["qiān"], ["zhí"]],
    "铅字": [["qiān"], ["zì"]],
    "谦称": [["qiān"], ["chēng"]],
    "谦冲": [["qiān"], ["chōng"]],
    "谦和": [["qiān"], ["hé"]],
    "愆期": [["qiān"], ["qī"]],
    "签发": [["qiān"], ["fā"]],
    "签条": [["qiān"], ["tiáo"]],
    "前臂": [["qián"], ["bì"]],
    "前场": [["qián"], ["chǎng"]],
    "前朝": [["qián"], ["cháo"]],
    "前仇": [["qián"], ["chóu"]],
    "前车": [["qián"], ["chē"]],
    "前夫": [["qián"], ["fū"]],
    "前排": [["qián"], ["pái"]],
    "前景": [["qián"], ["jǐng"]],
    "前期": [["qián"], ["qī"]],
    "前妻": [["qián"], ["qī"]],
    "前任": [["qián"], ["rèn"]],
    "前台": [["qián"], ["tái"]],
    "前提": [["qián"], ["tí"]],
    "前头": [["qián"], ["tou"]],
    "前行": [["qián"], ["xíng"]],
    "荨麻": [["xún"], ["má"]],
    "虔信": [["qián"], ["xìn"]],
    "钱柜": [["qián"], ["guì"]],
    "钱票": [["qián"], ["piào"]],
    "钱夹": [["qián"], ["jiā"]],
    "潜藏": [["qián"], ["cáng"]],
    "潜能": [["qián"], ["néng"]],
    "潜行": [["qián"], ["xíng"]],
    "潜隐": [["qián"], ["yǐn"]],
    "浅白": [["qiǎn"], ["bái"]],
    "黔南": [["qián"], ["nán"]],
    "浅薄": [["qiǎn"], ["bó"]],
    "浅尝": [["qiǎn"], ["cháng"]],
    "浅淡": [["qiǎn"], ["dàn"]],
    "浅耕": [["qiǎn"], ["gēng"]],
    "浅海": [["qiǎn"], ["hǎi"]],
    "浅见": [["qiǎn"], ["jiàn"]],
    "浅近": [["qiǎn"], ["jìn"]],
    "浅陋": [["qiǎn"], ["lòu"]],
    "浅露": [["qiǎn"], ["lù"]],
    "浅明": [["qiǎn"], ["míng"]],
    "浅浅": [["jiān"], ["jiān"]],
    "浅色": [["qiǎn"], ["sè"]],
    "浅水": [["qiǎn"], ["shuǐ"]],
    "浅滩": [["qiǎn"], ["tān"]],
    "浅说": [["qiǎn"], ["shuō"]],
    "浅显": [["qiǎn"], ["xiǎn"]],
    "浅学": [["qiǎn"], ["xué"]],
    "浅笑": [["qiǎn"], ["xiào"]],
    "浅易": [["qiǎn"], ["yì"]],
    "遣散": [["qiǎn"], ["sàn"]],
    "欠条": [["qiàn"], ["tiáo"]],
    "嵌合": [["qiàn"], ["hé"]],
    "嵌入": [["qiàn"], ["rù"]],
    "嵌镶": [["qiàn"], ["xiāng"]],
    "戗风": [["qiāng"], ["fēng"]],
    "戗脊": [["qiàng"], ["jǐ"]],
    "戗面": [["qiàng"], ["miàn"]],
    "枪刺": [["qiāng"], ["cì"]],
    "枪杆": [["qiāng"], ["gǎn"]],
    "枪弹": [["qiāng"], ["dàn"]],
    "枪炮": [["qiāng"], ["pào"]],
    "枪术": [["qiāng"], ["shù"]],
    "枪枝": [["qiāng"], ["zhī"]],
    "跄踉": [["qiàng"], ["liàng"]],
    "腔调": [["qiāng"], ["diào"]],
    "强暴": [["qiáng"], ["bào"]],
    "强逼": [["qiǎng"], ["bī"]],
    "强辩": [["qiáng"], ["biàn"]],
    "强大": [["qiáng"], ["dà"]],
    "强盗": [["qiáng"], ["dào"]],
    "强敌": [["qiáng"], ["dí"]],
    "强度": [["qiáng"], ["dù"]],
    "强调": [["qiáng"], ["diào"]],
    "强渡": [["qiáng"], ["dù"]],
    "强队": [["qiáng"], ["duì"]],
    "强夺": [["qiáng"], ["duó"]],
    "强干": [["qiáng"], ["gàn"]],
    "强风": [["qiáng"], ["fēng"]],
    "强攻": [["qiáng"], ["gōng"]],
    "强固": [["qiáng"], ["gù"]],
    "强悍": [["qiáng"], ["hàn"]],
    "强国": [["qiáng"], ["guó"]],
    "强化": [["qiáng"], ["huà"]],
    "强横": [["qiáng"], ["hèng"]],
    "强加": [["qiáng"], ["jiā"]],
    "强击": [["qiáng"], ["jī"]],
    "强记": [["qiáng"], ["jì"]],
    "强奸": [["qiáng"], ["jiān"]],
    "强健": [["qiáng"], ["jiàn"]],
    "强将": [["qiáng"], ["jiàng"]],
    "强劲": [["qiáng"], ["jìng"]],
    "强力": [["qiáng"], ["lì"]],
    "强梁": [["qiáng"], ["liáng"]],
    "强烈": [["qiáng"], ["liè"]],
    "强邻": [["qiáng"], ["lín"]],
    "强令": [["qiáng"], ["lìng"]],
    "强留": [["qiǎng"], ["liú"]],
    "强迫": [["qiǎng"], ["pò"]],
    "强求": [["qiǎng"], ["qiú"]],
    "强取": [["qiáng"], ["qǔ"]],
    "强权": [["qiáng"], ["quán"]],
    "强人": [["qiǎng"], ["rén"]],
    "强韧": [["qi&aacute;ngr&egrave;n"]],
    "强忍": [["qiáng"], ["rěn"]],
    "强弱": [["qiáng"], ["ruò"]],
    "强身": [["qiáng"], ["shēn"]],
    "强盛": [["qiáng"], ["shèng"]],
    "强势": [["qiáng"], ["shì"]],
    "强手": [["qiáng"], ["shǒu"]],
    "强似": [["qiáng"], ["sì"]],
    "强酸": [["qiáng"], ["suān"]],
    "强项": [["qiáng"], ["xiàng"]],
    "强笑": [["qiǎng"], ["xiào"]],
    "强行": [["qiáng"], ["xíng"]],
    "强颜": [["qiǎng"], ["yán"]],
    "强音": [["qiáng"], ["yīn"]],
    "强硬": [["qiáng"], ["yìng"]],
    "强占": [["qiáng"], ["zhàn"]],
    "强者": [["qiáng"], ["zhě"]],
    "强直": [["qiáng"], ["zhí"]],
    "强壮": [["qiáng"], ["zhuàng"]],
    "强制": [["qiáng"], ["zhì"]],
    "强嘴": [["jiàng"], ["zuǐ"]],
    "墙垛": [["qiáng"], ["duǒ"]],
    "墙角": [["qiáng"], ["jiǎo"]],
    "墙头": [["qiáng"], ["tóu"]],
    "抢白": [["qiǎng"], ["bái"]],
    "抢渡": [["qiǎng"], ["dù"]],
    "抢夺": [["qiǎng"], ["duó"]],
    "抢工": [["qiǎng"], ["gōng"]],
    "抢攻": [["qiǎng"], ["gōng"]],
    "抢购": [["qiǎng"], ["gòu"]],
    "抢话": [["qiǎng"], ["huà"]],
    "抢劫": [["qiǎng"], ["jié"]],
    "抢建": [["qiǎng"], ["jiàn"]],
    "抢救": [["qiǎng"], ["jiù"]],
    "抢掠": [["qiǎng"], ["lüè"]],
    "抢拍": [["qiǎng"], ["pāi"]],
    "抢亲": [["qiǎng"], ["qīn"]],
    "抢墒": [["qiǎng"], ["shāng"]],
    "抢市": [["qiǎng"], ["shì"]],
    "抢收": [["qiǎng"], ["shōu"]],
    "抢手": [["qiǎng"], ["shǒu"]],
    "抢滩": [["qiǎng"], ["tān"]],
    "抢先": [["qiǎng"], ["xiān"]],
    "抢险": [["qiǎng"], ["xiǎn"]],
    "抢修": [["qiǎng"], ["xiū"]],
    "抢眼": [["qiǎng"], ["yǎn"]],
    "抢运": [["qiǎng"], ["yùn"]],
    "抢占": [["qiǎng"], ["zhàn"]],
    "抢种": [["qiǎng"], ["zhòng"]],
    "抢嘴": [["qiǎng"], ["zuǐ"]],
    "悄悄": [["qiāo"], ["qiāo"]],
    "悄然": [["qiǎo"], ["rán"]],
    "悄声": [["qiǎo"], ["shēng"]],
    "敲打": [["qiāo"], ["dǎ"]],
    "桥台": [["qiáo"], ["tái"]],
    "侨属": [["qiáo"], ["shǔ"]],
    "桥头": [["qiáo"], ["tóu"]],
    "樵夫": [["qiáo"], ["fū"]],
    "巧合": [["qiǎo"], ["hé"]],
    "巧干": [["qiǎo"], ["gàn"]],
    "瞧见": [["qiáo"], ["jiàn"]],
    "巧劲": [["qiǎo"], ["jìn"]],
    "巧思": [["qiǎo"], ["sī"]],
    "俏丽": [["qiào"], ["lì"]],
    "俏货": [["qiào"], ["huò"]],
    "俏脸": [["qiào"], ["liǎn"]],
    "俏皮": [["qiào"], ["pí"]],
    "俏头": [["qiào"], ["tou"]],
    "翘楚": [["qiáo"], ["chǔ"]],
    "翘棱": [["qiáo"], ["lēng"]],
    "翘盼": [["qiáo"], ["pàn"]],
    "翘企": [["qiáo"], ["qǐ"]],
    "翘翘": [["qiào"], ["qiào"]],
    "翘首": [["qiáo"], ["shǒu"]],
    "翘望": [["qiáo"], ["wàng"]],
    "撬杠": [["qiào"], ["gàng"]],
    "撬棍": [["qiào"], ["gùn"]],
    "切变": [["qiē"], ["biàn"]],
    "切齿": [["qiè"], ["chǐ"]],
    "切除": [["qiē"], ["chú"]],
    "切磋": [["qiē"], ["cuō"]],
    "切当": [["qiē"], ["dāng"]],
    "切点": [["qiē"], ["diǎn"]],
    "切断": [["qiē"], ["duàn"]],
    "切糕": [["qiē"], ["gāo"]],
    "切割": [["qiē"], ["gē"]],
    "切合": [["qiè"], ["hé"]],
    "切花": [["qiē"], ["huā"]],
    "切记": [["qiè"], ["jì"]],
    "切忌": [["qiè"], ["jì"]],
    "切结": [["qiē"], ["jié"]],
    "切近": [["qiè"], ["jìn"]],
    "切口": [["qiē"], ["kǒu"]],
    "切脉": [["qiè"], ["mài"]],
    "切面": [["qiē"], ["miàn"]],
    "切莫": [["qiè"], ["mò"]],
    "切片": [["qiē"], ["piàn"]],
    "切盼": [["qiè"], ["pàn"]],
    "切切": [["qiē"], ["qiē"]],
    "切入": [["qiē"], ["rù"]],
    "切身": [["qiè"], ["shēn"]],
    "切实": [["qiè"], ["shí"]],
    "切题": [["qiè"], ["tí"]],
    "切望": [["qiè"], ["wàng"]],
    "切勿": [["qiē"], ["wù"]],
    "切屑": [["qiē"], ["xiè"]],
    "切削": [["qiē"], ["xiāo"]],
    "切音": [["qiè"], ["yīn"]],
    "切要": [["qiè"], ["yào"]],
    "切诊": [["qiè"], ["zhěn"]],
    "切中": [["qiè"], ["zhòng"]],
    "且慢": [["qiě"], ["màn"]],
    "且末": [["qiě"], ["mò"]],
    "怯场": [["qiè"], ["chǎng"]],
    "窃据": [["qiè"], ["jù"]],
    "且说": [["qiě"], ["shuō"]],
    "亲爱": [["qīn"], ["ài"]],
    "亲笔": [["qīn"], ["bǐ"]],
    "亲兵": [["qīn"], ["bīng"]],
    "亲本": [["qīn"], ["běn"]],
    "亲丁": [["qīn"], ["dīng"]],
    "亲代": [["qīn"], ["dài"]],
    "亲睹": [["qīn"], ["dǔ"]],
    "亲故": [["qīn"], ["gù"]],
    "亲和": [["qīn"], ["hé"]],
    "亲家": [["qìng"], ["jia"]],
    "亲近": [["qīn"], ["jìn"]],
    "亲眷": [["qīn"], ["juàn"]],
    "亲口": [["qīn"], ["kǒu"]],
    "亲历": [["qīn"], ["lì"]],
    "亲临": [["qīn"], ["lín"]],
    "亲密": [["qīn"], ["mì"]],
    "亲睦": [["qīn"], ["mù"]],
    "亲昵": [["qīn"], ["nì"]],
    "亲朋": [["qīn"], ["péng"]],
    "亲娘": [["qīn"], ["niáng"]],
    "亲戚": [["qīn"], ["qī"]],
    "亲切": [["qīn"], ["qiè"]],
    "亲亲": [["qīn"], ["qīn"]],
    "亲热": [["qīn"], ["rè"]],
    "亲情": [["qīn"], ["qíng"]],
    "亲人": [["qīn"], ["rén"]],
    "亲善": [["qīn"], ["shàn"]],
    "亲生": [["qīn"], ["shēng"]],
    "亲身": [["qīn"], ["shēn"]],
    "亲事": [["qīn"], ["shì"]],
    "亲手": [["qīn"], ["shǒu"]],
    "亲疏": [["qīn"], ["shū"]],
    "亲随": [["qīn"], ["suí"]],
    "亲吻": [["qīn"], ["wěn"]],
    "亲王": [["qīn"], ["wáng"]],
    "亲信": [["qīn"], ["xìn"]],
    "亲眼": [["qīn"], ["yǎn"]],
    "亲迎": [["qīn"], ["yíng"]],
    "亲友": [["qīn"], ["yǒu"]],
    "亲缘": [["qīn"], ["yuán"]],
    "亲征": [["qīn"], ["zhēng"]],
    "亲政": [["qīn"], ["zhèng"]],
    "亲知": [["qīn"], ["zhī"]],
    "亲属": [["qīn"], ["shǔ"]],
    "亲子": [["qīn"], ["zǐ"]],
    "亲自": [["qīn"], ["zì"]],
    "亲族": [["qīn"], ["zú"]],
    "亲嘴": [["qīn"], ["zuǐ"]],
    "侵占": [["qīn"], ["zhàn"]],
    "钦差": [["qīn"], ["chāi"]],
    "钦仰": [["qīn"], ["yǎng"]],
    "秦艽": [["qín"], ["jiāo"]],
    "秦岭": [["qín"], ["lǐng"]],
    "琴曲": [["qín"], ["qǔ"]],
    "勤朴": [["qín"], ["piáo"]],
    "勤王": [["qín"], ["wáng"]],
    "寝车": [["qǐn"], ["chē"]],
    "寝食": [["qǐn"], ["shí"]],
    "青绿": [["qīng"], ["lǜ"]],
    "青石": [["qīng"], ["shí"]],
    "青蛇": [["qīng"], ["shé"]],
    "青苔": [["qīng"], ["tái"]],
    "氢弹": [["qīng"], ["dàn"]],
    "轻便": [["qīng"], ["biàn"]],
    "轻薄": [["qīng"], ["bó"]],
    "轻度": [["qīng"], ["dù"]],
    "轻风": [["qīng"], ["fēng"]],
    "轻拂": [["qīng"], ["fú"]],
    "轻看": [["qīng"], ["kàn"]],
    "轻率": [["qīng"], ["shuài"]],
    "轻俏": [["qīng"], ["qiào"]],
    "轻省": [["qīng"], ["shěng"]],
    "轻信": [["qīng"], ["xìn"]],
    "轻重": [["qīng"], ["zhòng"]],
    "倾侧": [["qīng"], ["cè"]],
    "倾盖": [["qīng"], ["gài"]],
    "倾倒": [["qīng"], ["dǎo"]],
    "倾家": [["qīng"], ["jiā"]],
    "倾角": [["qīng"], ["jiǎo"]],
    "倾囊": [["qīng"], ["náng"]],
    "倾吐": [["qīng"], ["tǔ"]],
    "倾泄": [["qīng"], ["xiè"]],
    "情节": [["qíng"], ["jié"]],
    "情趣": [["qíng"], ["qù"]],
    "晴好": [["qíng"], ["hǎo"]],
    "晴和": [["qíng"], ["hé"]],
    "晴空": [["qíng"], ["kōng"]],
    "请便": [["qǐng"], ["biàn"]],
    "请调": [["qǐng"], ["diào"]],
    "请假": [["qǐng"], ["jià"]],
    "请见": [["qǐng"], ["jiàn"]],
    "请降": [["qǐng"], ["xiáng"]],
    "请教": [["qǐng"], ["jiào"]],
    "罄尽": [["qìng"], ["jìn"]],
    "请帖": [["qǐng"], ["tiě"]],
    "穷尽": [["qióng"], ["jìn"]],
    "穷期": [["qióng"], ["qī"]],
    "琼浆": [["qióng"], ["jiāng"]],
    "秋分": [["qiū"], ["fēn"]],
    "秋风": [["qiū"], ["fēng"]],
    "秋景": [["qiū"], ["jǐng"]],
    "秋凉": [["qiū"], ["liáng"]],
    "秋令": [["qiū"], ["lìng"]],
    "秋叶": [["qiū"], ["yè"]],
    "秋种": [["qiū"], ["zhǒng"]],
    "囚车": [["qiú"], ["chē"]],
    "囚笼": [["qiú"], ["lóng"]],
    "囚禁": [["qiú"], ["jìn"]],
    "求和": [["qiú"], ["hé"]],
    "求见": [["qiú"], ["jiàn"]],
    "求降": [["qiú"], ["xiáng"]],
    "求教": [["qiú"], ["jiào"]],
    "求解": [["qiú"], ["jiě"]],
    "求亲": [["qiú"], ["qīn"]],
    "求雨": [["qiú"], ["yǔ"]],
    "求知": [["qiú"], ["zhī"]],
    "酋长": [["qiú"], ["zhǎng"]],
    "求助": [["qiú"], ["zhù"]],
    "区别": [["qū"], ["bié"]],
    "遒劲": [["qiú"], ["jìng"]],
    "区段": [["qū"], ["duàn"]],
    "区分": [["qū"], ["fēn"]],
    "区划": [["qū"], ["huà"]],
    "区间": [["qū"], ["jiān"]],
    "区内": [["qū"], ["nèi"]],
    "区外": [["qū"], ["wài"]],
    "区区": [["qū"], ["qū"]],
    "区县": [["qū"], ["xiàn"]],
    "区域": [["qū"], ["yù"]],
    "曲笔": [["qū"], ["bǐ"]],
    "曲柄": [["qū"], ["bǐng"]],
    "曲池": [["qǔ"], ["chí"]],
    "曲尺": [["qū"], ["chǐ"]],
    "曲调": [["qǔ"], ["diào"]],
    "曲度": [["qǔ"], ["dù"]],
    "曲阜": [["qū"], ["fù"]],
    "曲解": [["qū"], ["jiě"]],
    "曲江": [["qǔ"], ["jiāng"]],
    "曲径": [["qū"], ["jìng"]],
    "曲剧": [["qǔ"], ["jù"]],
    "曲率": [["qǔ"], ["lǜ"]],
    "曲面": [["qǔ"], ["miàn"]],
    "曲目": [["qǔ"], ["mù"]],
    "曲牌": [["qǔ"], ["pái"]],
    "曲谱": [["qǔ"], ["pǔ"]],
    "曲曲": [["qū"], ["qū"]],
    "曲泉": [["qǔ"], ["quán"]],
    "曲蟮": [["qǔ"], ["shàn"]],
    "曲水": [["qǔ"], ["shuǐ"]],
    "曲线": [["qū"], ["xiàn"]],
    "曲艺": [["qǔ"], ["yì"]],
    "曲张": [["qǔ"], ["zhāng"]],
    "曲泽": [["qǔ"], ["zé"]],
    "曲折": [["qū"], ["zhé"]],
    "曲直": [["qū"], ["zhí"]],
    "驱车": [["qū"], ["chē"]],
    "曲子": [["qǔ"], ["zi"]],
    "驱迫": [["qū"], ["pò"]],
    "驱散": [["qū"], ["sàn"]],
    "驱邪": [["qū"], ["xié"]],
    "屈从": [["qū"], ["cóng"]],
    "屈服": [["qū"], ["fú"]],
    "屈节": [["qū"], ["jié"]],
    "屈强": [["qū"], ["qiáng"]],
    "屈曲": [["qū"], ["qǔ"]],
    "屈折": [["qū"], ["shé"]],
    "祛风": [["qū"], ["fēng"]],
    "祛邪": [["qū"], ["xié"]],
    "祛疑": [["qū"], ["yí"]],
    "躯干": [["qū"], ["gàn"]],
    "躯壳": [["qū"], ["qiào"]],
    "躯体": [["qū"], ["tǐ"]],
    "趋避": [["qū"], ["bì"]],
    "趋附": [["qū"], ["fù"]],
    "趋奉": [["qū"], ["fèng"]],
    "趋近": [["qū"], ["jìn"]],
    "趋利": [["qū"], ["lì"]],
    "趋时": [["qū"], ["shí"]],
    "趋势": [["qū"], ["shì"]],
    "趋向": [["qū"], ["xiàng"]],
    "渠道": [["qú"], ["dào"]],
    "取得": [["qǔ"], ["de"]],
    "取给": [["qǔ"], ["gěi"]],
    "取景": [["qǔ"], ["jǐng"]],
    "取乐": [["qǔ"], ["lè"]],
    "取齐": [["qǔ"], ["qí"]],
    "取信": [["qǔ"], ["xìn"]],
    "去处": [["qù"], ["chù"]],
    "去任": [["qù"], ["rèn"]],
    "趣话": [["qù"], ["huà"]],
    "趣剧": [["qù"], ["jù"]],
    "趣事": [["qù"], ["shì"]],
    "趣谈": [["qù"], ["tán"]],
    "趣味": [["qù"], ["wèi"]],
    "圈地": [["quān"], ["dì"]],
    "圈椅": [["quān"], ["yǐ"]],
    "圈阅": [["quān"], ["yuè"]],
    "圈子": [["quān"], ["zi"]],
    "全称": [["quán"], ["chēng"]],
    "全场": [["quán"], ["chǎng"]],
    "全份": [["quán"], ["fèn"]],
    "全都": [["quán"], ["dōu"]],
    "全副": [["quán"], ["fù"]],
    "全会": [["quán"], ["huì"]],
    "全家": [["quán"], ["jiā"]],
    "全价": [["quán"], ["jià"]],
    "全景": [["quán"], ["jǐng"]],
    "全能": [["quán"], ["néng"]],
    "全票": [["quán"], ["piào"]],
    "全盛": [["quán"], ["shèng"]],
    "全食": [["quán"], ["shí"]],
    "全数": [["quán"], ["shù"]],
    "全体": [["quán"], ["tǐ"]],
    "全校": [["quán"], ["xiào"]],
    "全休": [["quán"], ["xiū"]],
    "全员": [["quán"], ["yuán"]],
    "权能": [["quán"], ["néng"]],
    "权术": [["quán"], ["shù"]],
    "权且": [["quán"], ["qiě"]],
    "权重": [["quán"], ["zhòng"]],
    "权数": [["quán"], ["shù"]],
    "拳参": [["quán"], ["cān"]],
    "泉涌": [["quán"], ["yǒng"]],
    "拳打": [["quán"], ["dǎ"]],
    "拳曲": [["quán"], ["qū"]],
    "拳术": [["quán"], ["shù"]],
    "拳头": [["quán"], ["tou"]],
    "拳王": [["quán"], ["wáng"]],
    "蜷曲": [["quán"], ["qū"]],
    "蜷缩": [["quán"], ["suō"]],
    "鬈曲": [["quán"], ["qǔ"]],
    "颧骨": [["quán"], ["gǔ"]],
    "劝化": [["quàn"], ["huà"]],
    "劝和": [["quàn"], ["hé"]],
    "劝降": [["quàn"], ["xiáng"]],
    "劝解": [["quàn"], ["jiě"]],
    "劝说": [["quàn"], ["shuō"]],
    "缺少": [["quē"], ["shǎo"]],
    "却说": [["què"], ["shuō"]],
    "雀子": [["qiāo"], ["zǐ"]],
    "确当": [["què"], ["dàng"]],
    "确切": [["què"], ["qiè"]],
    "确信": [["què"], ["xìn"]],
    "阙如": [["quē"], ["rú"]],
    "阙漏": [["quē"], ["lòu"]],
    "阙文": [["quē"], ["wén"]],
    "阙疑": [["quē"], ["yí"]],
    "群氓": [["qún"], ["méng"]],
    "群体": [["qún"], ["tǐ"]],
    "染毒": [["rǎn"], ["dú"]],
    "染坊": [["rǎn"], ["fáng"]],
    "攘臂": [["rǎng"], ["bì"]],
    "嚷叫": [["rǎng"], ["jiào"]],
    "嚷嚷": [["rāng"], ["rɑng"]],
    "让价": [["ràng"], ["jià"]],
    "让与": [["ràng"], ["yǔ"]],
    "饶有": [["ráo"], ["yǒu"]],
    "饶头": [["ráo"], ["tóu"]],
    "桡骨": [["ráo"], ["gǔ"]],
    "绕行": [["rào"], ["xíng"]],
    "热地": [["rè"], ["dì"]],
    "热度": [["rè"], ["dù"]],
    "热毒": [["rè"], ["dú"]],
    "热风": [["rè"], ["fēng"]],
    "热和": [["rè"], ["huo"]],
    "热化": [["rè"], ["huà"]],
    "热量": [["rè"], ["liàng"]],
    "热络": [["rè"], ["luò"]],
    "热能": [["rè"], ["néng"]],
    "热切": [["rè"], ["qiè"]],
    "热汤": [["rè"], ["tāng"]],
    "热血": [["rè"], ["xuè"]],
    "热中": [["rè"], ["zhōng"]],
    "热症": [["rè"], ["zhèng"]],
    "人称": [["rén"], ["chēng"]],
    "人参": [["rén"], ["shēn"]],
    "人大": [["rén"], ["dà"]],
    "人丁": [["rén"], ["dīng"]],
    "人夫": [["rén"], ["fū"]],
    "人和": [["rén"], ["hé"]],
    "人家": [["rén"], ["jiā"]],
    "人间": [["rén"], ["jiān"]],
    "人氏": [["rén"], ["shì"]],
    "人数": [["rén"], ["shù"]],
    "人体": [["rén"], ["tǐ"]],
    "人头": [["rén"], ["tóu"]],
    "人为": [["rén"], ["wéi"]],
    "人员": [["rén"], ["yuán"]],
    "人中": [["rén"], ["zhōng"]],
    "人种": [["rén"], ["zhǒng"]],
    "仁弟": [["rén"], ["dì"]],
    "仁化": [["rén"], ["huà"]],
    "仁术": [["rén"], ["shù"]],
    "稔知": [["rěn"], ["zhī"]],
    "认得": [["rèn"], ["de"]],
    "认可": [["rèn"], ["kě"]],
    "认亲": [["rèn"], ["qīn"]],
    "认识": [["rèn"], ["shi"]],
    "认同": [["rèn"], ["tóng"]],
    "认头": [["rèn"], ["tóu"]],
    "认为": [["rèn"], ["wéi"]],
    "认知": [["rèn"], ["zhī"]],
    "任便": [["rèn"], ["biàn"]],
    "任从": [["rèn"], ["cóng"]],
    "任何": [["rèn"], ["hé"]],
    "任教": [["rèn"], ["jiào"]],
    "任课": [["rèn"], ["kè"]],
    "任免": [["rèn"], ["miǎn"]],
    "任脉": [["rèn"], ["mài"]],
    "任命": [["rèn"], ["mìng"]],
    "任内": [["rèn"], ["nèi"]],
    "任凭": [["rèn"], ["píng"]],
    "任期": [["rèn"], ["qī"]],
    "任情": [["rèn"], ["qíng"]],
    "任务": [["rèn"], ["wù"]],
    "任随": [["rèn"], ["suí"]],
    "任性": [["rèn"], ["xìng"]],
    "任意": [["rèn"], ["yì"]],
    "任选": [["rèn"], ["xuǎn"]],
    "任用": [["rèn"], ["yòng"]],
    "任职": [["rèn"], ["zhí"]],
    "韧劲": [["rèn"], ["jìn"]],
    "恁地": [["nèn"], ["dì"]],
    "日场": [["rì"], ["chǎng"]],
    "日华": [["rì"], ["huá"]],
    "日间": [["rì"], ["jiān"]],
    "日见": [["rì"], ["jiàn"]],
    "日渐": [["rì"], ["jiàn"]],
    "日落": [["rì"], ["luò"]],
    "日没": [["rì"], ["méi"]],
    "日内": [["rì"], ["nèi"]],
    "日期": [["rì"], ["qī"]],
    "日趋": [["rì"], ["qū"]],
    "日射": [["rì"], ["shè"]],
    "日食": [["rì"], ["shí"]],
    "日头": [["rì"], ["tou"]],
    "日晕": [["rì"], ["yùn"]],
    "日语": [["rì"], ["yǔ"]],
    "日中": [["rì"], ["zhōng"]],
    "戎行": [["róng"], ["háng"]],
    "荣华": [["róng"], ["huá"]],
    "荣任": [["róng"], ["rèn"]],
    "容量": [["róng"], ["liàng"]],
    "容许": [["róng"], ["xǔ"]],
    "溶斗": [["róng"], ["dòu"]],
    "溶合": [["róng"], ["hé"]],
    "溶解": [["róng"], ["jiě"]],
    "溶化": [["róng"], ["huà"]],
    "溶血": [["róng"], ["xuè"]],
    "熔化": [["róng"], ["huà"]],
    "融合": [["róng"], ["hé"]],
    "融和": [["róng"], ["hé"]],
    "熔解": [["róng"], ["jiě"]],
    "融化": [["róng"], ["huà"]],
    "融会": [["róng"], ["huì"]],
    "冗长": [["rǒng"], ["cháng"]],
    "融解": [["róng"], ["jiě"]],
    "冗繁": [["rǒng"], ["fán"]],
    "冗员": [["rǒng"], ["yuán"]],
    "柔和": [["róu"], ["hé"]],
    "柔化": [["róu"], ["huà"]],
    "柔术": [["róu"], ["shù"]],
    "糅合": [["róu"], ["hé"]],
    "肉丁": [["ròu"], ["dīng"]],
    "肉干": [["ròu"], ["gān"]],
    "肉冠": [["ròu"], ["guān"]],
    "肉红": [["ròu"], ["hóng"]],
    "肉糜": [["ròu"], ["mí"]],
    "肉排": [["ròu"], ["pái"]],
    "肉片": [["ròu"], ["piàn"]],
    "肉票": [["ròu"], ["piào"]],
    "肉铺": [["ròu"], ["pù"]],
    "肉食": [["ròu"], ["shí"]],
    "肉体": [["ròu"], ["tǐ"]],
    "肉头": [["ròu"], ["tóu"]],
    "肉畜": [["ròu"], ["chù"]],
    "如弟": [["rú"], ["dì"]],
    "如何": [["rú"], ["hé"]],
    "如期": [["rú"], ["qī"]],
    "如其": [["rú"], ["qí"]],
    "如若": [["rú"], ["ruò"]],
    "如上": [["rú"], ["shàng"]],
    "如数": [["rú"], ["shù"]],
    "如同": [["rú"], ["tóng"]],
    "如许": [["rú"], ["xǔ"]],
    "儒家": [["rú"], ["jiā"]],
    "如约": [["rú"], ["yuē"]],
    "儒将": [["rú"], ["jiàng"]],
    "儒教": [["rú"], ["jiào"]],
    "儒术": [["rú"], ["shù"]],
    "蠕行": [["rú"], ["xíng"]],
    "乳臭": [["rǔ"], ["xiù"]],
    "乳化": [["rǔ"], ["huà"]],
    "乳糜": [["rǔ"], ["mí"]],
    "乳头": [["rǔ"], ["tóu"]],
    "乳燕": [["rǔ"], ["yàn"]],
    "辱没": [["rǔ"], ["mò"]],
    "入场": [["rù"], ["chǎng"]],
    "入港": [["rù"], ["gǎng"]],
    "入骨": [["rù"], ["gǔ"]],
    "入会": [["rù"], ["huì"]],
    "入内": [["rù"], ["nèi"]],
    "入射": [["rù"], ["shè"]],
    "入戏": [["rù"], ["xì"]],
    "入邪": [["rù"], ["xié"]],
    "褥单": [["rù"], ["dān"]],
    "入行": [["rù"], ["xíng"]],
    "软尺": [["ruǎn"], ["chǐ"]],
    "软风": [["ruǎn"], ["fēng"]],
    "软膏": [["ruǎn"], ["gāo"]],
    "软骨": [["ruǎn"], ["gǔ"]],
    "软和": [["ruǎn"], ["huo"]],
    "软化": [["ruǎn"], ["huà"]],
    "软肋": [["ruǎn"], ["lèi"]],
    "软禁": [["ruǎn"], ["jìn"]],
    "软磨": [["ruǎn"], ["mó"]],
    "软片": [["ruǎn"], ["piàn"]],
    "软泥": [["ruǎn"], ["ní"]],
    "软食": [["ruǎn"], ["shí"]],
    "锐角": [["ruì"], ["jiǎo"]],
    "润泽": [["rùn"], ["zé"]],
    "若非": [["ruò"], ["fēi"]],
    "若夫": [["ruò"], ["fú"]],
    "若干": [["ruò"], ["gān"]],
    "若果": [["ruò"], ["guǒ"]],
    "若何": [["ruò"], ["hé"]],
    "若是": [["ruò"], ["shì"]],
    "偌大": [["ruò"], ["dà"]],
    "弱冠": [["ruò"], ["guàn"]],
    "撒播": [["sǎ"], ["bō"]],
    "撒布": [["sǎ"], ["bù"]],
    "撒旦": [["sā"], ["dàn"]],
    "撒刁": [["sā"], ["diāo"]],
    "撒欢": [["sā"], ["huān"]],
    "撒谎": [["sā"], ["huǎng"]],
    "撒开": [["sā"], ["kāi"]],
    "撒娇": [["sā"], ["jiāo"]],
    "撒拉": [["sā"], ["lā"]],
    "撒赖": [["sā"], ["lài"]],
    "撒泼": [["sā"], ["pō"]],
    "撒气": [["sā"], ["qì"]],
    "撒施": [["sǎ"], ["shī"]],
    "撒手": [["sā"], ["shǒu"]],
    "撒腿": [["sā"], ["tuǐ"]],
    "撒野": [["sā"], ["yě"]],
    "洒家": [["sǎ"], ["jiā"]],
    "洒泪": [["sǎ"], ["lèi"]],
    "洒落": [["sǎ"], ["luò"]],
    "洒洒": [["sǎ"], ["sǎ"]],
    "洒扫": [["sǎ"], ["sǎo"]],
    "洒脱": [["sǎ"], ["tuō"]],
    "塞北": [["sài"], ["běi"]],
    "塞车": [["sāi"], ["chē"]],
    "塞规": [["sāi"], ["guī"]],
    "塞满": [["sāi"], ["mǎn"]],
    "塞门": [["sài"], ["mén"]],
    "塞上": [["sāi"], ["shàng"]],
    "塞外": [["sài"], ["wài"]],
    "塞音": [["sè"], ["yīn"]],
    "塞责": [["sè"], ["zé"]],
    "塞子": [["sāi"], ["zi"]],
    "腮红": [["sāi"], ["hóng"]],
    "赛场": [["sài"], ["chǎng"]],
    "赛车": [["sài"], ["chē"]],
    "赛过": [["sài"], ["guò"]],
    "赛会": [["sài"], ["huì"]],
    "赛跑": [["sài"], ["pǎo"]],
    "三藏": [["sān"], ["zàng"]],
    "赛似": [["sài"], ["sì"]],
    "三北": [["sān"], ["běi"]],
    "三度": [["sān"], ["dù"]],
    "三分": [["sān"], ["fēn"]],
    "三副": [["sān"], ["fù"]],
    "三更": [["sān"], ["gēng"]],
    "三好": [["sān"], ["hǎo"]],
    "三号": [["sān"], ["hào"]],
    "三合": [["sān"], ["hé"]],
    "三角": [["sān"], ["jiǎo"]],
    "三教": [["sān"], ["jiào"]],
    "三节": [["sān"], ["jié"]],
    "三思": [["sān"], ["sī"]],
    "三台": [["sān"], ["tái"]],
    "三鲜": [["sān"], ["xiān"]],
    "三相": [["sān"], ["xiāng"]],
    "三行": [["sān"], ["xíng"]],
    "三重": [["sān"], ["chóng"]],
    "伞盖": [["sǎn"], ["gài"]],
    "散兵": [["sǎn"], ["bīng"]],
    "散板": [["sǎn"], ["bǎn"]],
    "散播": [["sàn"], ["bō"]],
    "散布": [["sàn"], ["bù"]],
    "散步": [["sàn"], ["bù"]],
    "散场": [["sàn"], ["chǎng"]],
    "散发": [["sàn"], ["fà"]],
    "散放": [["sàn"], ["fàng"]],
    "散工": [["sǎn"], ["gōng"]],
    "散光": [["sǎn"], ["guāng"]],
    "散户": [["sàn"], ["hù"]],
    "散会": [["sàn"], ["huì"]],
    "散伙": [["sàn"], ["huǒ"]],
    "散记": [["sǎn"], ["jì"]],
    "散剂": [["sǎn"], ["jì"]],
    "散架": [["sǎn"], ["jià"]],
    "散见": [["sǎn"], ["jiàn"]],
    "散件": [["sǎn"], ["jiàn"]],
    "散居": [["sǎn"], ["jū"]],
    "散开": [["sàn"], ["kāi"]],
    "散乱": [["sǎn"], ["luàn"]],
    "散落": [["sàn"], ["luò"]],
    "散漫": [["sǎn"], ["màn"]],
    "散闷": [["sàn"], ["mèn"]],
    "散钱": [["sàn"], ["qián"]],
    "散曲": [["sǎn"], ["qǔ"]],
    "散沙": [["sǎn"], ["shā"]],
    "散射": [["sǎn"], ["shè"]],
    "散失": [["sàn"], ["shī"]],
    "散水": [["sàn"], ["shuǐ"]],
    "散碎": [["sǎn"], ["suì"]],
    "散体": [["sǎn"], ["tǐ"]],
    "散亡": [["sàn"], ["wáng"]],
    "散席": [["sàn"], ["xí"]],
    "散戏": [["sàn"], ["xì"]],
    "散文": [["sǎn"], ["wén"]],
    "散心": [["sàn"], ["xīn"]],
    "散学": [["sàn"], ["xué"]],
    "散置": [["sàn"], ["zhì"]],
    "散佚": [["sàn"], ["yì"]],
    "散装": [["sǎn"], ["zhuāng"]],
    "散座": [["sàn"], ["zuò"]],
    "桑椹": [["sāng"], ["shèn"]],
    "桑叶": [["sāng"], ["yè"]],
    "丧胆": [["sàng"], ["dǎn"]],
    "丧服": [["sāng"], ["fú"]],
    "丧家": [["sàng"], ["jiā"]],
    "丧假": [["sāng"], ["jià"]],
    "丧礼": [["sāng"], ["lǐ"]],
    "丧乱": [["sāng"], ["luàn"]],
    "丧门": [["sàng"], ["mén"]],
    "丧命": [["sàng"], ["mìng"]],
    "丧偶": [["sàng"], ["ǒu"]],
    "丧气": [["sàng"], ["qì"]],
    "丧生": [["sàng"], ["shēng"]],
    "丧身": [["sàng"], ["shēn"]],
    "丧失": [["sàng"], ["shī"]],
    "丧事": [["sāng"], ["shì"]],
    "丧亡": [["sàng"], ["wáng"]],
    "丧志": [["sàng"], ["zhì"]],
    "丧葬": [["sāng"], ["zàng"]],
    "丧钟": [["sāng"], ["zhōng"]],
    "搔头": [["sāo"], ["tóu"]],
    "骚货": [["sāo"], ["huò"]],
    "骚动": [["sāo"], ["dòng"]],
    "骚乱": [["sāo"], ["luàn"]],
    "骚客": [["sāo"], ["kè"]],
    "骚气": [["sāo"], ["qì"]],
    "骚扰": [["sāo"], ["rǎo"]],
    "骚人": [["sāo"], ["rén"]],
    "骚体": [["sāo"], ["tǐ"]],
    "臊子": [["sào"], ["zǐ"]],
    "扫把": [["sào"], ["bǎ"]],
    "扫除": [["sǎo"], ["chú"]],
    "扫地": [["sǎo"], ["dì"]],
    "扫荡": [["sǎo"], ["dàng"]],
    "扫坟": [["sǎo"], ["fén"]],
    "扫黄": [["sǎo"], ["huáng"]],
    "扫雷": [["sǎo"], ["léi"]],
    "扫盲": [["sǎo"], ["máng"]],
    "扫描": [["sǎo"], ["miáo"]],
    "扫灭": [["sǎo"], ["miè"]],
    "扫墓": [["sǎo"], ["mù"]],
    "扫平": [["sǎo"], ["píng"]],
    "扫清": [["sǎo"], ["qīng"]],
    "扫射": [["sǎo"], ["shè"]],
    "扫视": [["sǎo"], ["shì"]],
    "扫数": [["sǎo"], ["shù"]],
    "扫尾": [["sǎo"], ["wěi"]],
    "扫兴": [["sǎo"], ["xìng"]],
    "扫雪": [["sǎo"], ["xuě"]],
    "色差": [["sè"], ["chà"]],
    "扫帚": [["sào"], ["zhǒu"]],
    "色度": [["sè"], ["dù"]],
    "色调": [["sè"], ["diào"]],
    "色觉": [["sè"], ["jué"]],
    "色拉": [["sè"], ["lā"]],
    "色散": [["sè"], ["sàn"]],
    "色相": [["sè"], ["xiàng"]],
    "色晕": [["sè"], ["yùn"]],
    "色泽": [["sè"], ["zé"]],
    "瑟缩": [["sè"], ["suō"]],
    "杀毒": [["shā"], ["dú"]],
    "杀价": [["shā"], ["jià"]],
    "杀菌": [["shā"], ["jūn"]],
    "杀头": [["shā"], ["tóu"]],
    "沙岸": [["shā"], ["àn"]],
    "沙坝": [["shā"], ["bà"]],
    "沙包": [["shā"], ["bāo"]],
    "沙暴": [["shā"], ["bào"]],
    "沙参": [["shā"], ["shēn"]],
    "沙场": [["shā"], ["chǎng"]],
    "沙尘": [["shā"], ["chén"]],
    "沙虫": [["shā"], ["chóng"]],
    "沙船": [["shā"], ["chuán"]],
    "沙袋": [["shā"], ["dài"]],
    "沙地": [["shā"], ["dì"]],
    "沙堆": [["shā"], ["duī"]],
    "沙俄": [["shā"], ["é"]],
    "沙锅": [["shā"], ["guō"]],
    "沙发": [["shā"], ["fā"]],
    "沙果": [["shā"], ["guǒ"]],
    "沙害": [["shā"], ["hài"]],
    "沙化": [["shā"], ["huà"]],
    "沙荒": [["shā"], ["huāng"]],
    "沙皇": [["shā"], ["huáng"]],
    "沙鸡": [["shā"], ["jī"]],
    "沙棘": [["shā"], ["jí"]],
    "沙金": [["shā"], ["jīn"]],
    "沙坑": [["shā"], ["kēng"]],
    "沙梨": [["shā"], ["lí"]],
    "沙拉": [["shā"], ["là"]],
    "沙砾": [["shā"], ["lì"]],
    "沙柳": [["shā"], ["liǔ"]],
    "沙龙": [["shā"], ["lóng"]],
    "沙漏": [["shā"], ["lòu"]],
    "沙门": [["shā"], ["mén"]],
    "沙弥": [["shā"], ["mí"]],
    "沙漠": [["shā"], ["mò"]],
    "沙囊": [["shā"], ["náng"]],
    "沙鸥": [["shā"], ["ōu"]],
    "沙盘": [["shā"], ["pán"]],
    "沙碛": [["shā"], ["qì"]],
    "沙丘": [["shā"], ["qiū"]],
    "沙沙": [["shā"], ["shā"]],
    "沙石": [["shā"], ["shí"]],
    "沙市": [["shā"], ["shì"]],
    "沙滩": [["shā"], ["tān"]],
    "沙田": [["shā"], ["tián"]],
    "沙土": [["shā"], ["tǔ"]],
    "沙哑": [["shā"], ["yǎ"]],
    "沙眼": [["shā"], ["yǎn"]],
    "沙浴": [["shā"], ["yù"]],
    "沙鱼": [["shā"], ["yú"]],
    "沙灾": [["shā"], ["zāi"]],
    "沙枣": [["shā"], ["zǎo"]],
    "沙质": [["shā"], ["zhì"]],
    "沙洲": [["shā"], ["zhōu"]],
    "沙子": [["shā"], ["zi"]],
    "纱厂": [["shā"], ["chǎng"]],
    "纱笼": [["shā"], ["lóng"]],
    "刹把": [["shā"], ["bǎ"]],
    "刹车": [["shā"], ["chē"]],
    "刹刹": [["shā"], ["shā"]],
    "刹那": [["chà"], ["nà"]],
    "刹时": [["shā"], ["shí"]],
    "砂浆": [["shā"], ["jiāng"]],
    "砂囊": [["shā"], ["náng"]],
    "砂石": [["shā"], ["shí"]],
    "莎草": [["suō"], ["cǎo"]],
    "刹住": [["shā"], ["zhù"]],
    "傻乐": [["shǎ"], ["lè"]],
    "煞白": [["shà"], ["bái"]],
    "歃血": [["shà"], ["xuè"]],
    "煞笔": [["shā"], ["bǐ"]],
    "煞车": [["shā"], ["chē"]],
    "煞气": [["shà"], ["qì"]],
    "煞神": [["shà"], ["shén"]],
    "煞尾": [["shā"], ["wěi"]],
    "煞星": [["shà"], ["xīng"]],
    "煞住": [["shā"], ["zhù"]],
    "筛分": [["shāi"], ["fēn"]],
    "筛号": [["shāi"], ["hào"]],
    "筛洗": [["shāi"], ["xǐ"]],
    "晒场": [["shài"], ["cháng"]],
    "晒台": [["shài"], ["tái"]],
    "山凹": [["shān"], ["āo"]],
    "山地": [["shān"], ["dì"]],
    "山龟": [["shān"], ["guī"]],
    "山岭": [["shān"], ["lǐng"]],
    "山猫": [["shān"], ["māo"]],
    "山脉": [["shān"], ["mài"]],
    "山风": [["shān"], ["fēng"]],
    "山炮": [["shān"], ["pào"]],
    "山区": [["shān"], ["qū"]],
    "山雀": [["shān"], ["què"]],
    "山体": [["shān"], ["tǐ"]],
    "山头": [["shān"], ["tóu"]],
    "山羊": [["shān"], ["yáng"]],
    "山系": [["shān"], ["xì"]],
    "山楂": [["shān"], ["zhā"]],
    "删节": [["shān"], ["jié"]],
    "删削": [["shān"], ["xuē"]],
    "姗姗": [["shān"], ["shān"]],
    "膻气": [["shān"], ["qì"]],
    "膻中": [["dàn"], ["zhōng"]],
    "闪过": [["shǎn"], ["guò"]],
    "闪射": [["shǎn"], ["shè"]],
    "苫布": [["shàn"], ["bù"]],
    "苫盖": [["shàn"], ["gài"]],
    "扇贝": [["shàn"], ["bèi"]],
    "扇车": [["shàn"], ["chē"]],
    "扇动": [["shān"], ["dòng"]],
    "扇骨": [["shàn"], ["gǔ"]],
    "扇惑": [["shān"], ["huò"]],
    "扇面": [["shàn"], ["miàn"]],
    "扇形": [["shàn"], ["xíng"]],
    "扇坠": [["shàn"], ["zhuì"]],
    "扇子": [["shàn"], ["zi"]],
    "善处": [["shàn"], ["chǔ"]],
    "善恶": [["shàn"], ["è"]],
    "善行": [["shàn"], ["xíng"]],
    "擅长": [["shàn"], ["cháng"]],
    "擅场": [["shàn"], ["chǎng"]],
    "膳食": [["shàn"], ["shí"]],
    "膳宿": [["shàn"], ["sù"]],
    "伤风": [["shāng"], ["fēng"]],
    "伤号": [["shāng"], ["hào"]],
    "伤亡": [["shāng"], ["wáng"]],
    "伤员": [["shāng"], ["yuán"]],
    "商场": [["shāng"], ["chǎng"]],
    "商调": [["shāng"], ["diào"]],
    "商兑": [["shāng"], ["duì"]],
    "商港": [["shāng"], ["gǎng"]],
    "商号": [["shāng"], ["hào"]],
    "商会": [["shāng"], ["huì"]],
    "商家": [["shāng"], ["jiā"]],
    "商量": [["shāng"], ["liáng"]],
    "商行": [["shāng"], ["háng"]],
    "商约": [["shāng"], ["yuē"]],
    "赏识": [["shǎng"], ["shí"]],
    "上岸": [["shàng"], ["àn"]],
    "上班": [["shàng"], ["bān"]],
    "上辈": [["shàng"], ["bèi"]],
    "上报": [["shàng"], ["bào"]],
    "上边": [["shàng"], ["biān"]],
    "上膘": [["shàng"], ["biāo"]],
    "上宾": [["shàng"], ["bīn"]],
    "上兵": [["shàng"], ["bīng"]],
    "上菜": [["shàng"], ["cài"]],
    "上苍": [["shàng"], ["cāng"]],
    "上操": [["shàng"], ["cāo"]],
    "上策": [["shàng"], ["cè"]],
    "上层": [["shàng"], ["céng"]],
    "上场": [["shàng"], ["chǎng"]],
    "上朝": [["shàng"], ["cháo"]],
    "上乘": [["shàng"], ["chéng"]],
    "上车": [["shàng"], ["chē"]],
    "上唇": [["shàng"], ["chún"]],
    "上床": [["shàng"], ["chuáng"]],
    "上次": [["shàng"], ["cì"]],
    "上簇": [["shàng"], ["cù"]],
    "上达": [["shàng"], ["dá"]],
    "上当": [["shàng"], ["dàng"]],
    "上代": [["shàng"], ["dài"]],
    "上等": [["shàng"], ["děng"]],
    "上帝": [["shàng"], ["dì"]],
    "上吊": [["shàng"], ["diào"]],
    "上调": [["shàng"], ["diào"]],
    "上冻": [["shàng"], ["dòng"]],
    "上端": [["shàng"], ["duān"]],
    "上方": [["shàng"], ["fāng"]],
    "上访": [["shàng"], ["fǎng"]],
    "上房": [["shàng"], ["fáng"]],
    "上粪": [["shàng"], ["fèn"]],
    "上坟": [["shàng"], ["fén"]],
    "上风": [["shàng"], ["fēng"]],
    "上峰": [["shàng"], ["fēng"]],
    "上浮": [["shàng"], ["fú"]],
    "上纲": [["shàng"], ["gāng"]],
    "上供": [["shàng"], ["gòng"]],
    "上钩": [["shàng"], ["gōu"]],
    "上古": [["shàng"], ["gǔ"]],
    "上官": [["shàng"], ["guān"]],
    "上告": [["shàng"], ["gào"]],
    "上海": [["shàng"], ["hǎi"]],
    "上好": [["shàng"], ["hǎo"]],
    "上回": [["shàng"], ["huí"]],
    "上火": [["shàng"], ["huǒ"]],
    "上货": [["shàng"], ["huò"]],
    "上级": [["shàng"], ["jí"]],
    "上工": [["shàng"], ["gōng"]],
    "上计": [["shàng"], ["jì"]],
    "上家": [["shàng"], ["jiā"]],
    "上将": [["shàng"], ["jiàng"]],
    "上交": [["shàng"], ["jiāo"]],
    "上缴": [["shàng"], ["jiǎo"]],
    "上街": [["shàng"], ["jiē"]],
    "上届": [["shàng"], ["jiè"]],
    "上界": [["shàng"], ["jiè"]],
    "上劲": [["shàng"], ["jìn"]],
    "上进": [["shàng"], ["jìn"]],
    "上焦": [["shàng"], ["jiāo"]],
    "上京": [["shàng"], ["jīng"]],
    "上举": [["shàng"], ["jǔ"]],
    "上客": [["shàng"], ["kè"]],
    "上卷": [["shàng"], ["juǎn"]],
    "上紧": [["shàng"], ["jǐn"]],
    "上课": [["shàng"], ["kè"]],
    "上空": [["shàng"], ["kōng"]],
    "上口": [["shàng"], ["kǒu"]],
    "上款": [["shàng"], ["kuǎn"]],
    "上来": [["shàng"], ["lái"]],
    "上联": [["shàng"], ["lián"]],
    "上脸": [["shàng"], ["liǎn"]],
    "上梁": [["shàng"], ["liáng"]],
    "上列": [["shàng"], ["liè"]],
    "上林": [["shàng"], ["lín"]],
    "上流": [["shàng"], ["liú"]],
    "上路": [["shàng"], ["lù"]],
    "上马": [["shàng"], ["mǎ"]],
    "上门": [["shàng"], ["mén"]],
    "上年": [["shàng"], ["nián"]],
    "上面": [["shàng"], ["miàn"]],
    "上品": [["shàng"], ["pǐn"]],
    "上坡": [["shàng"], ["pō"]],
    "上铺": [["shàng"], ["pù"]],
    "上情": [["shàng"], ["qíng"]],
    "上去": [["shǎng"], ["qù"]],
    "上人": [["shàng"], ["rén"]],
    "上任": [["shàng"], ["rèn"]],
    "上色": [["shàng"], ["sè"]],
    "上山": [["shàng"], ["shān"]],
    "上上": [["shàng"], ["shàng"]],
    "上身": [["shàng"], ["shēn"]],
    "上升": [["shàng"], ["shēng"]],
    "上声": [["shǎng"], ["shēng"]],
    "上士": [["shàng"], ["shì"]],
    "上世": [["shàng"], ["shì"]],
    "上市": [["shàng"], ["shì"]],
    "上手": [["shàng"], ["shǒu"]],
    "上首": [["shàng"], ["shǒu"]],
    "上寿": [["shàng"], ["shòu"]],
    "上书": [["shàng"], ["shū"]],
    "上疏": [["shàng"], ["shū"]],
    "上述": [["shàng"], ["shù"]],
    "上水": [["shàng"], ["shuǐ"]],
    "上闩": [["shàng"], ["shuān"]],
    "上税": [["shàng"], ["shuì"]],
    "上溯": [["shàng"], ["sù"]],
    "上诉": [["shàng"], ["sù"]],
    "上锁": [["shàng"], ["suǒ"]],
    "上台": [["shàng"], ["tái"]],
    "上司": [["shàng"], ["sī"]],
    "上算": [["shàng"], ["suàn"]],
    "上堂": [["shàng"], ["táng"]],
    "上膛": [["shàng"], ["táng"]],
    "上套": [["shàng"], ["tào"]],
    "上天": [["shàng"], ["tiān"]],
    "上体": [["shàng"], ["tǐ"]],
    "上头": [["shàng"], ["tou"]],
    "上位": [["shàng"], ["wèi"]],
    "上尉": [["shàng"], ["wèi"]],
    "上文": [["shàng"], ["wén"]],
    "上午": [["shàng"], ["wǔ"]],
    "上下": [["shàng"], ["xià"]],
    "上弦": [["shàng"], ["xián"]],
    "上限": [["shàng"], ["xiàn"]],
    "上相": [["shàng"], ["xiàng"]],
    "上校": [["shàng"], ["xiào"]],
    "上鞋": [["shàng"], ["xié"]],
    "上心": [["shàng"], ["xīn"]],
    "上行": [["shàng"], ["xíng"]],
    "上刑": [["shàng"], ["xíng"]],
    "上选": [["shàng"], ["xuǎn"]],
    "上学": [["shàng"], ["xué"]],
    "上旬": [["shàng"], ["xún"]],
    "上演": [["shàng"], ["yǎn"]],
    "上药": [["shàng"], ["yào"]],
    "上叶": [["shàng"], ["yè"]],
    "上夜": [["shàng"], ["yè"]],
    "上衣": [["shàng"], ["yī"]],
    "上瘾": [["shàng"], ["yǐn"]],
    "上映": [["shàng"], ["yìng"]],
    "上元": [["shàng"], ["yuán"]],
    "上谕": [["shàng"], ["yù"]],
    "上游": [["shàng"], ["yóu"]],
    "上院": [["shàng"], ["yuàn"]],
    "上月": [["shàng"], ["yuè"]],
    "上涨": [["shàng"], ["zhǎng"]],
    "上账": [["shàng"], ["zhàng"]],
    "上阵": [["shàng"], ["zhèn"]],
    "上肢": [["shàng"], ["zhī"]],
    "上装": [["shàng"], ["zhuāng"]],
    "上奏": [["shàng"], ["zòu"]],
    "上座": [["shàng"], ["zuò"]],
    "尚好": [["shàng"], ["hǎo"]],
    "尚可": [["shàng"], ["kě"]],
    "尚且": [["shàng"], ["qiě"]],
    "捎带": [["shāo"], ["dài"]],
    "捎脚": [["shāo"], ["jiǎo"]],
    "捎话": [["shāo"], ["huà"]],
    "捎信": [["shāo"], ["xìn"]],
    "烧化": [["shāo"], ["huà"]],
    "烧结": [["shāo"], ["jié"]],
    "稍后": [["shāo"], ["hòu"]],
    "稍事": [["shāo"], ["shì"]],
    "稍稍": [["shāo"], ["shāo"]],
    "稍微": [["shāo"], ["wēi"]],
    "稍为": [["shāo"], ["wéi"]],
    "稍息": [["shào"], ["xī"]],
    "稍许": [["shāo"], ["xǔ"]],
    "苕帚": [["tiáo"], ["zhǒu"]],
    "韶华": [["sháo"], ["huá"]],
    "少待": [["shǎo"], ["dài"]],
    "少儿": [["shǎo"], ["ér"]],
    "少府": [["shào"], ["fǔ"]],
    "少妇": [["shào"], ["fù"]],
    "少海": [["shǎo"], ["hǎi"]],
    "少见": [["shǎo"], ["jiàn"]],
    "少刻": [["shǎo"], ["kè"]],
    "少将": [["shào"], ["jiàng"]],
    "少礼": [["shǎo"], ["lǐ"]],
    "少林": [["shǎo"], ["lín"]],
    "少量": [["shǎo"], ["liàng"]],
    "少男": [["shǎo"], ["nán"]],
    "少年": [["shào"], ["nián"]],
    "少陪": [["shǎo"], ["péi"]],
    "少女": [["shào"], ["nǚ"]],
    "少顷": [["shǎo"], ["qǐng"]],
    "少商": [["shǎo"], ["shāng"]],
    "少时": [["shǎo"], ["shí"]],
    "少少": [["shǎo"], ["shǎo"]],
    "少数": [["shǎo"], ["shù"]],
    "少帅": [["shǎo"], ["shuài"]],
    "少说": [["shǎo"], ["shuō"]],
    "少尉": [["shào"], ["wèi"]],
    "少相": [["shào"], ["xiāng"]],
    "少小": [["shào"], ["xiǎo"]],
    "少校": [["shào"], ["xiào"]],
    "少许": [["shǎo"], ["xǔ"]],
    "少爷": [["shào"], ["yé"]],
    "少有": [["shǎo"], ["yǒu"]],
    "少壮": [["shào"], ["zhuàng"]],
    "少子": [["shǎo"], ["zǐ"]],
    "哨卡": [["shào"], ["qiǎ"]],
    "绍兴": [["shào"], ["xīng"]],
    "奢糜": [["shē"], ["mí"]],
    "舌苔": [["shé"], ["tāi"]],
    "舌头": [["shé"], ["tou"]],
    "蛇行": [["shé"], ["xíng"]],
    "舍得": [["shè"], ["de"]],
    "舍监": [["shè"], ["jiān"]],
    "舍亲": [["shè"], ["qīn"]],
    "设若": [["shè"], ["ruò"]],
    "社长": [["shè"], ["cháng"]],
    "社会": [["shè"], ["huì"]],
    "社论": [["shè"], ["lùn"]],
    "社区": [["shè"], ["qū"]],
    "社戏": [["shè"], ["xì"]],
    "社员": [["shè"], ["yuán"]],
    "射程": [["shè"], ["chéng"]],
    "射干": [["yè"], ["gàn"]],
    "射击": [["shè"], ["jī"]],
    "射箭": [["shè"], ["jiàn"]],
    "射界": [["shè"], ["jiè"]],
    "射精": [["shè"], ["jīng"]],
    "射猎": [["shè"], ["liè"]],
    "射流": [["shè"], ["liú"]],
    "射门": [["shè"], ["mén"]],
    "射频": [["shè"], ["pín"]],
    "射入": [["shè"], ["rù"]],
    "射手": [["shè"], ["shǒu"]],
    "射杀": [["shè"], ["shā"]],
    "射线": [["shè"], ["xiàn"]],
    "射影": [["shè"], ["yǐng"]],
    "慑服": [["shè"], ["fú"]],
    "摄取": [["shè"], ["qǔ"]],
    "摄生": [["shè"], ["shēng"]],
    "摄食": [["shè"], ["shí"]],
    "摄卫": [["shè"], ["wèi"]],
    "摄影": [["shè"], ["yǐng"]],
    "摄像": [["shè"], ["xiàng"]],
    "摄制": [["shè"], ["zhì"]],
    "摄政": [["shè"], ["zhèng"]],
    "申令": [["shēn"], ["lìng"]],
    "申论": [["shēn"], ["lùn"]],
    "申曲": [["shēn"], ["qǔ"]],
    "申说": [["shēn"], ["shuō"]],
    "伸长": [["shēn"], ["cháng"]],
    "伸缩": [["shēn"], ["suō"]],
    "伸头": [["shēn"], ["tóu"]],
    "身长": [["shēn"], ["cháng"]],
    "身分": [["shēn"], ["fèn"]],
    "身家": [["shēn"], ["jiā"]],
    "身份": [["shēn"], ["fèn"]],
    "身价": [["shēn"], ["jià"]],
    "身教": [["shēn"], ["jiào"]],
    "身量": [["shēn"], ["liàng"]],
    "身上": [["shēn"], ["shàng"]],
    "身体": [["shēn"], ["tǐ"]],
    "身条": [["shēn"], ["tiáo"]],
    "身亡": [["shēn"], ["wáng"]],
    "深长": [["shēn"], ["cháng"]],
    "深度": [["shēn"], ["dù"]],
    "深广": [["shēn"], ["guǎng"]],
    "深化": [["shēn"], ["huà"]],
    "深浅": [["shēn"], ["qiǎn"]],
    "深切": [["shēn"], ["qiè"]],
    "深省": [["shēn"], ["xǐng"]],
    "深思": [["shēn"], ["sī"]],
    "深巷": [["shēn"], ["xiàng"]],
    "深远": [["shēn"], ["yuǎn"]],
    "神采": [["shén"], ["cǎi"]],
    "神佛": [["shén"], ["fó"]],
    "神父": [["shén"], ["fù"]],
    "神棍": [["shén"], ["gùn"]],
    "神化": [["shén"], ["huà"]],
    "神会": [["shén"], ["huì"]],
    "神秘": [["shén"], ["mì"]],
    "神女": [["shén"], ["nǚ"]],
    "神祇": [["shén"], ["qí"]],
    "神奇": [["shén"], ["qí"]],
    "神曲": [["shén"], ["qū"]],
    "神阙": [["shén"], ["quē"]],
    "神思": [["shén"], ["sī"]],
    "神似": [["shén"], ["sì"]],
    "审查": [["shěn"], ["zhā"]],
    "沈思": [["shěn"], ["sī"]],
    "审处": [["shěn"], ["chǔ"]],
    "审度": [["shěn"], ["duó"]],
    "审读": [["shěn"], ["dú"]],
    "审核": [["shěn"], ["hé"]],
    "审结": [["shěn"], ["jié"]],
    "审干": [["shěn"], ["gàn"]],
    "审校": [["shěn"], ["jiào"]],
    "肾囊": [["shèn"], ["náng"]],
    "甚而": [["shèn"], ["ér"]],
    "甚或": [["shèn"], ["huò"]],
    "甚么": [["shèn"], ["me"]],
    "甚且": [["shèn"], ["qiě"]],
    "甚为": [["shèn"], ["wéi"]],
    "甚至": [["shèn"], ["zhì"]],
    "慎思": [["shèn"], ["sī"]],
    "慎重": [["shèn"], ["zhòng"]],
    "慎行": [["shèn"], ["xíng"]],
    "升华": [["shēng"], ["huá"]],
    "升降": [["shēng"], ["jiàng"]],
    "升空": [["shēng"], ["kōng"]],
    "升任": [["shēng"], ["rèn"]],
    "升压": [["shēng"], ["yā"]],
    "升涨": [["shēng"], ["zhǎng"]],
    "生长": [["shēng"], ["zhǎng"]],
    "生地": [["shēng"], ["dì"]],
    "生番": [["shēng"], ["fān"]],
    "生发": [["shēng"], ["fà"]],
    "生分": [["shēng"], ["fēn"]],
    "生风": [["shēng"], ["fēng"]],
    "生父": [["shēng"], ["fù"]],
    "生化": [["shēng"], ["huà"]],
    "生还": [["shēng"], ["huán"]],
    "生角": [["shēng"], ["jué"]],
    "生趣": [["shēng"], ["qù"]],
    "生鲜": [["shēng"], ["xiān"]],
    "生疑": [["shēng"], ["yí"]],
    "生肖": [["shēng"], ["xiào"]],
    "生员": [["shēng"], ["yuán"]],
    "生殖": [["shēng"], ["zhí"]],
    "声场": [["shēng"], ["chǎng"]],
    "声调": [["shēng"], ["diào"]],
    "声称": [["shēng"], ["chēng"]],
    "声价": [["shēng"], ["jià"]],
    "声乐": [["shēng"], ["yuè"]],
    "声旁": [["shēng"], ["páng"]],
    "声频": [["shēng"], ["pín"]],
    "声压": [["shēng"], ["yā"]],
    "牲畜": [["shēng"], ["chù"]],
    "胜朝": [["shèng"], ["cháo"]],
    "胜地": [["shèng"], ["dì"]],
    "胜过": [["shèng"], ["guò"]],
    "胜景": [["shèng"], ["jǐng"]],
    "胜券": [["shèng"], ["quàn"]],
    "胜任": [["shèng"], ["rèn"]],
    "胜似": [["shèng"], ["sì"]],
    "甥女": [["shēng"], ["nǚ"]],
    "渑池": [["miǎn"], ["chí"]],
    "省便": [["shěng"], ["biàn"]],
    "省察": [["xǐng"], ["chá"]],
    "省城": [["shěng"], ["chéng"]],
    "省道": [["shěng"], ["dào"]],
    "省得": [["shěng"], ["de"]],
    "省份": [["shěng"], ["fèn"]],
    "省府": [["shěng"], ["fǔ"]],
    "省会": [["shěng"], ["huì"]],
    "省俭": [["shěng"], ["jiǎn"]],
    "省力": [["shěng"], ["lì"]],
    "省略": [["shěng"], ["lüè"]],
    "省墓": [["shěng"], ["mù"]],
    "省内": [["shěng"], ["nèi"]],
    "省钱": [["shěng"], ["qián"]],
    "省亲": [["xǐng"], ["qīn"]],
    "省却": [["shěng"], ["què"]],
    "省事": [["shěng"], ["shì"]],
    "省视": [["xǐng"], ["shì"]],
    "省悟": [["xǐng"], ["wù"]],
    "省治": [["shěng"], ["zhì"]],
    "圣地": [["shèng"], ["dì"]],
    "省心": [["shěng"], ["xīn"]],
    "圣女": [["shèng"], ["nǚ"]],
    "圣上": [["shèng"], ["shàng"]],
    "尸体": [["shī"], ["tǐ"]],
    "失传": [["shī"], ["chuán"]],
    "失单": [["shī"], ["dān"]],
    "尸骨": [["shī"], ["gǔ"]],
    "失当": [["shī"], ["dàng"]],
    "失地": [["shī"], ["dì"]],
    "失调": [["shī"], ["tiáo"]],
    "失和": [["shī"], ["hé"]],
    "失风": [["shī"], ["fēng"]],
    "失节": [["shī"], ["jié"]],
    "失禁": [["shī"], ["jìn"]],
    "失据": [["shī"], ["jù"]],
    "失落": [["shī"], ["luò"]],
    "失散": [["shī"], ["sàn"]],
    "失体": [["shī"], ["tǐ"]],
    "失信": [["shī"], ["xìn"]],
    "失血": [["shī"], ["xuè"]],
    "失约": [["shī"], ["yuē"]],
    "失语": [["shī"], ["yǔ"]],
    "失重": [["shī"], ["zhòng"]],
    "失着": [["shī"], ["zhāo"]],
    "师伯": [["shī"], ["bó"]],
    "师长": [["shī"], ["zhǎng"]],
    "师传": [["shī"], ["chuán"]],
    "师弟": [["shī"], ["dì"]],
    "师父": [["shī"], ["fu"]],
    "诗风": [["shī"], ["fēng"]],
    "诗会": [["shī"], ["huì"]],
    "诗节": [["shī"], ["jié"]],
    "诗句": [["shī"], ["jù"]],
    "诗论": [["shī"], ["lùn"]],
    "诗体": [["shī"], ["tǐ"]],
    "诗兴": [["shī"], ["xìng"]],
    "施教": [["shī"], ["jiào"]],
    "施为": [["shī"], ["wéi"]],
    "施洗": [["shī"], ["xǐ"]],
    "诗行": [["shī"], ["háng"]],
    "施行": [["shī"], ["xíng"]],
    "施予": [["shī"], ["yǔ"]],
    "施与": [["shī"], ["yǔ"]],
    "湿地": [["shī"], ["dì"]],
    "湿度": [["shī"], ["dù"]],
    "十分": [["shí"], ["fēn"]],
    "十家": [["shí"], ["jiā"]],
    "十万": [["shí"], ["wàn"]],
    "什锦": [["shí"], ["jǐn"]],
    "什么": [["shén"], ["me"]],
    "什物": [["shí"], ["wù"]],
    "石版": [["shí"], ["bǎn"]],
    "石板": [["shí"], ["bǎn"]],
    "石碑": [["shí"], ["bēi"]],
    "石笔": [["shí"], ["bǐ"]],
    "石壁": [["shí"], ["bì"]],
    "石材": [["shí"], ["cái"]],
    "石槽": [["shí"], ["cáo"]],
    "石城": [["shí"], ["chéng"]],
    "石担": [["shí"], ["dān"]],
    "石刀": [["shí"], ["dāo"]],
    "石雕": [["shí"], ["diāo"]],
    "石洞": [["shí"], ["dòng"]],
    "石碓": [["shí"], ["duì"]],
    "石墩": [["shí"], ["dūn"]],
    "石方": [["shí"], ["fāng"]],
    "石坊": [["shí"], ["fāng"]],
    "石舫": [["shí"], ["fǎng"]],
    "石膏": [["shí"], ["gāo"]],
    "石斧": [["shí"], ["fǔ"]],
    "石工": [["shí"], ["gōng"]],
    "石弓": [["shí"], ["gōng"]],
    "石鼓": [["shí"], ["gǔ"]],
    "石关": [["shí"], ["guān"]],
    "石棺": [["shí"], ["guān"]],
    "石磙": [["shí"], ["gǔn"]],
    "石斛": [["shí"], ["hú"]],
    "石灰": [["shí"], ["huī"]],
    "石级": [["shí"], ["jí"]],
    "石匠": [["shí"], ["jiàng"]],
    "石经": [["shí"], ["jīng"]],
    "石径": [["shí"], ["jìng"]],
    "石臼": [["shí"], ["jiù"]],
    "石坎": [["shí"], ["kǎn"]],
    "石刻": [["shí"], ["kè"]],
    "石块": [["shí"], ["kuài"]],
    "石窟": [["shí"], ["kū"]],
    "石蜡": [["shí"], ["là"]],
    "石栗": [["shí"], ["lì"]],
    "石栏": [["shí"], ["lán"]],
    "石料": [["shí"], ["liào"]],
    "石林": [["shí"], ["lín"]],
    "石榴": [["shí"], ["liú"]],
    "石笼": [["shí"], ["lóng"]],
    "石楼": [["shí"], ["lóu"]],
    "石棉": [["shí"], ["mián"]],
    "石门": [["shí"], ["mén"]],
    "石磨": [["shí"], ["mó"]],
    "石墨": [["shí"], ["mò"]],
    "石楠": [["shí"], ["nán"]],
    "石女": [["shí"], ["nǚ"]],
    "石屏": [["shí"], ["píng"]],
    "石器": [["shí"], ["qì"]],
    "石桥": [["shí"], ["qiáo"]],
    "石青": [["shí"], ["qīng"]],
    "石渠": [["shí"], ["qú"]],
    "石泉": [["shí"], ["quán"]],
    "石蕊": [["shí"], ["ruǐ"]],
    "石山": [["shí"], ["shān"]],
    "石首": [["shí"], ["shǒu"]],
    "石室": [["shí"], ["shì"]],
    "石笋": [["shí"], ["sǔn"]],
    "石锁": [["shí"], ["suǒ"]],
    "石台": [["shí"], ["tái"]],
    "石炭": [["shí"], ["tàn"]],
    "石头": [["shí"], ["tou"]],
    "石韦": [["shí"], ["wéi"]],
    "石屋": [["shí"], ["wū"]],
    "石像": [["shí"], ["xiàng"]],
    "石盐": [["shí"], ["yán"]],
    "石堰": [["shí"], ["yàn"]],
    "石羊": [["shí"], ["yáng"]],
    "石印": [["shí"], ["yìn"]],
    "石英": [["shí"], ["yīng"]],
    "石竹": [["shí"], ["zhú"]],
    "石油": [["shí"], ["yóu"]],
    "石子": [["shí"], ["zǐ"]],
    "石柱": [["shí"], ["zhù"]],
    "时差": [["shí"], ["chà"]],
    "时调": [["shí"], ["diào"]],
    "时分": [["shí"], ["fēn"]],
    "时风": [["shí"], ["fēng"]],
    "时价": [["shí"], ["jià"]],
    "时会": [["shí"], ["huì"]],
    "时间": [["shí"], ["jiān"]],
    "时节": [["shí"], ["jié"]],
    "时空": [["shí"], ["kōng"]],
    "时期": [["shí"], ["qī"]],
    "时令": [["shí"], ["lìng"]],
    "时区": [["shí"], ["qū"]],
    "时鲜": [["shí"], ["xiān"]],
    "时兴": [["shí"], ["xīng"]],
    "时行": [["shí"], ["háng"]],
    "识别": [["shí"], ["bié"]],
    "识才": [["shí"], ["cái"]],
    "识货": [["shí"], ["huò"]],
    "识记": [["zhì"], ["jì"]],
    "识见": [["shí"], ["jiàn"]],
    "识破": [["shí"], ["pò"]],
    "识趣": [["shí"], ["qù"]],
    "识相": [["shí"], ["xiàng"]],
    "识羞": [["shí"], ["xiū"]],
    "识字": [["shí"], ["zì"]],
    "实弹": [["shí"], ["dàn"]],
    "实地": [["shí"], ["dì"]],
    "实干": [["shí"], ["gàn"]],
    "实价": [["shí"], ["jià"]],
    "实景": [["shí"], ["jǐng"]],
    "实据": [["shí"], ["jù"]],
    "实落": [["shí"], ["luò"]],
    "实数": [["shí"], ["shù"]],
    "实体": [["shí"], ["tǐ"]],
    "实相": [["shí"], ["xiàng"]],
    "实行": [["shí"], ["xíng"]],
    "拾掇": [["shí"], ["duo"]],
    "拾荒": [["shí"], ["huāng"]],
    "拾零": [["shí"], ["líng"]],
    "拾物": [["shí"], ["wù"]],
    "拾遗": [["shí"], ["yí"]],
    "食槽": [["shí"], ["cáo"]],
    "食道": [["shí"], ["dào"]],
    "食饵": [["shí"], ["ěr"]],
    "食管": [["shí"], ["guǎn"]],
    "食盒": [["shí"], ["hé"]],
    "食积": [["shí"], ["jī"]],
    "食具": [["shí"], ["jù"]],
    "食客": [["shí"], ["kè"]],
    "食口": [["shí"], ["kǒu"]],
    "食量": [["shí"], ["liàng"]],
    "食粮": [["shí"], ["liáng"]],
    "食料": [["shí"], ["liào"]],
    "食疗": [["shí"], ["liáo"]],
    "食品": [["shí"], ["pǐn"]],
    "食谱": [["shí"], ["pǔ"]],
    "食人": [["shí"], ["rén"]],
    "食肉": [["shí"], ["ròu"]],
    "食宿": [["shí"], ["sù"]],
    "食堂": [["shí"], ["táng"]],
    "食糖": [["shí"], ["táng"]],
    "食物": [["shí"], ["wù"]],
    "食相": [["shí"], ["xiāng"]],
    "食性": [["shí"], ["xìng"]],
    "食言": [["shí"], ["yán"]],
    "食盐": [["shí"], ["yán"]],
    "食邑": [["shí"], ["yì"]],
    "食用": [["shí"], ["yòng"]],
    "食欲": [["shí"], ["yù"]],
    "食油": [["shí"], ["yóu"]],
    "莳萝": [["shí"], ["luó"]],
    "食指": [["shí"], ["zhǐ"]],
    "史家": [["shǐ"], ["jiā"]],
    "史论": [["shǐ"], ["lùn"]],
    "矢量": [["shǐ"], ["liàng"]],
    "矢石": [["shǐ"], ["shí"]],
    "使得": [["shǐ"], ["de"]],
    "使坏": [["shǐ"], ["huài"]],
    "使节": [["shǐ"], ["jié"]],
    "使劲": [["shǐ"], ["jìn"]],
    "使令": [["shǐ"], ["lìng"]],
    "使女": [["shǐ"], ["nǚ"]],
    "始创": [["shǐ"], ["chuàng"]],
    "士女": [["shì"], ["nǚ"]],
    "士卒": [["shì"], ["zú"]],
    "氏族": [["shì"], ["zú"]],
    "世伯": [["shì"], ["bó"]],
    "世仇": [["shì"], ["chóu"]],
    "世传": [["shì"], ["chuán"]],
    "世风": [["shì"], ["fēng"]],
    "世纪": [["shì"], ["jì"]],
    "世间": [["shì"], ["jiān"]],
    "世家": [["shì"], ["jiā"]],
    "世亲": [["shì"], ["qīn"]],
    "世上": [["shì"], ["shàng"]],
    "世系": [["shì"], ["xì"]],
    "仕女": [["shì"], ["nǚ"]],
    "市长": [["shì"], ["zhǎng"]],
    "市场": [["shì"], ["chǎng"]],
    "市尺": [["shì"], ["chǐ"]],
    "市价": [["shì"], ["jià"]],
    "市区": [["shì"], ["qū"]],
    "事假": [["shì"], ["jià"]],
    "事体": [["shì"], ["tǐ"]],
    "侍从": [["shì"], ["cóng"]],
    "侍弄": [["shì"], ["nòng"]],
    "侍郎": [["shì"], ["láng"]],
    "侍女": [["shì"], ["nǚ"]],
    "势头": [["shì"], ["tóu"]],
    "势能": [["shì"], ["néng"]],
    "视差": [["shì"], ["chà"]],
    "势要": [["shì"], ["yào"]],
    "视角": [["shì"], ["jiǎo"]],
    "视觉": [["shì"], ["jué"]],
    "试车": [["shì"], ["chē"]],
    "试场": [["shì"], ["chǎng"]],
    "试卷": [["shì"], ["juàn"]],
    "试读": [["shì"], ["dú"]],
    "试看": [["shì"], ["kàn"]],
    "试片": [["shì"], ["piàn"]],
    "试射": [["shì"], ["shè"]],
    "试行": [["shì"], ["xíng"]],
    "试种": [["shì"], ["zhòng"]],
    "室内": [["shì"], ["nèi"]],
    "室女": [["shì"], ["nǚ"]],
    "是否": [["shì"], ["fǒu"]],
    "适从": [["shì"], ["cóng"]],
    "适当": [["shì"], ["dàng"]],
    "适度": [["shì"], ["dù"]],
    "适量": [["shì"], ["liàng"]],
    "适合": [["shì"], ["hé"]],
    "适切": [["shì"], ["qiè"]],
    "适应": [["shì"], ["yìng"]],
    "谥号": [["shì"], ["hào"]],
    "适中": [["shì"], ["zhōng"]],
    "释藏": [["shì"], ["cáng"]],
    "释读": [["shì"], ["dú"]],
    "释教": [["shì"], ["jiào"]],
    "释卷": [["shì"], ["juàn"]],
    "释疑": [["shì"], ["yí"]],
    "嗜好": [["shì"], ["hào"]],
    "嗜血": [["shì"], ["xuè"]],
    "誓约": [["shì"], ["yuē"]],
    "螫针": [["shì"], ["zhēn"]],
    "收藏": [["shōu"], ["cáng"]],
    "收场": [["shōu"], ["chǎng"]],
    "收发": [["shōu"], ["fā"]],
    "收风": [["shōu"], ["fēng"]],
    "收服": [["shōu"], ["fú"]],
    "收监": [["shōu"], ["jiān"]],
    "收缴": [["shōu"], ["jiǎo"]],
    "收据": [["shōu"], ["jù"]],
    "收看": [["shōu"], ["kàn"]],
    "收率": [["shōu"], ["lǜ"]],
    "收拾": [["shōu"], ["shí"]],
    "收缩": [["shōu"], ["suō"]],
    "收条": [["shōu"], ["tiáo"]],
    "收尾": [["shōu"], ["wěi"]],
    "收载": [["shōu"], ["zǎi"]],
    "手背": [["shǒu"], ["bèi"]],
    "手臂": [["shǒu"], ["bì"]],
    "手车": [["shǒu"], ["chē"]],
    "手创": [["shǒu"], ["chuàng"]],
    "手风": [["shǒu"], ["fēng"]],
    "手卷": [["shǒu"], ["juàn"]],
    "手夹": [["shǒu"], ["jiā"]],
    "手令": [["shǒu"], ["lìng"]],
    "手模": [["shǒu"], ["mó"]],
    "手上": [["shǒu"], ["shàng"]],
    "手术": [["shǒu"], ["shù"]],
    "手头": [["shǒu"], ["tóu"]],
    "手纹": [["shǒu"], ["wén"]],
    "手相": [["shǒu"], ["xiàng"]],
    "手语": [["shǒu"], ["yǔ"]],
    "手泽": [["shǒu"], ["zé"]],
    "手爪": [["shǒu"], ["zhǎo"]],
    "守车": [["shǒu"], ["chē"]],
    "守分": [["shǒu"], ["fèn"]],
    "守将": [["shǒu"], ["jiāng"]],
    "守节": [["shǒu"], ["jié"]],
    "守丧": [["shǒu"], ["sāng"]],
    "守信": [["shǒu"], ["xìn"]],
    "首长": [["shǒu"], ["zhǎng"]],
    "守约": [["shǒu"], ["yuē"]],
    "首倡": [["shǒu"], ["chàng"]],
    "首车": [["shǒu"], ["chē"]],
    "首创": [["shǒu"], ["chuàng"]],
    "首都": [["shǒu"], ["dū"]],
    "首度": [["shǒu"], ["dù"]],
    "首恶": [["shǒu"], ["è"]],
    "首发": [["shǒu"], ["fā"]],
    "首相": [["shǒu"], ["xiàng"]],
    "首尾": [["shǒu"], ["wěi"]],
    "首要": [["shǒu"], ["yào"]],
    "寿屏": [["shòu"], ["píng"]],
    "寿数": [["shòu"], ["shù"]],
    "受过": [["shòu"], ["guò"]],
    "受降": [["shòu"], ["xiáng"]],
    "受教": [["shòu"], ["jiào"]],
    "受看": [["shòu"], ["kàn"]],
    "受累": [["shòu"], ["lěi"]],
    "受凉": [["shòu"], ["liáng"]],
    "受难": [["shòu"], ["nàn"]],
    "受洗": [["shòu"], ["xǐ"]],
    "瘦长": [["shòu"], ["cháng"]],
    "瘦削": [["shòu"], ["xuē"]],
    "书背": [["shū"], ["bèi"]],
    "书场": [["shū"], ["chǎng"]],
    "书柜": [["shū"], ["guì"]],
    "书号": [["shū"], ["hào"]],
    "书家": [["shū"], ["jiā"]],
    "书价": [["shū"], ["jià"]],
    "书卷": [["shū"], ["juàn"]],
    "书论": [["shū"], ["lùn"]],
    "书契": [["shū"], ["qì"]],
    "书体": [["shū"], ["tǐ"]],
    "书僮": [["shū"], ["tóng"]],
    "书信": [["shū"], ["xìn"]],
    "抒发": [["shū"], ["fā"]],
    "叔伯": [["shū"], ["bó"]],
    "叔父": [["shū"], ["fù"]],
    "枢要": [["shū"], ["yào"]],
    "倏地": [["shū"], ["dì"]],
    "枢轴": [["shū"], ["zhóu"]],
    "淑女": [["shū"], ["nǚ"]],
    "疏解": [["shū"], ["jiě"]],
    "疏浚": [["shū"], ["jùn"]],
    "疏勒": [["shū"], ["lè"]],
    "疏落": [["shū"], ["luò"]],
    "疏浅": [["shū"], ["qiǎn"]],
    "疏远": [["shū"], ["yuǎn"]],
    "疏散": [["shū"], ["sàn"]],
    "舒服": [["shū"], ["fú"]],
    "舒卷": [["shū"], ["juàn"]],
    "舒散": [["shū"], ["sàn"]],
    "输家": [["shū"], ["jiā"]],
    "输血": [["shū"], ["xuè"]],
    "赎当": [["shú"], ["dàng"]],
    "熟地": [["shú"], ["dì"]],
    "熟化": [["shú"], ["huà"]],
    "熟识": [["shú"], ["shí"]],
    "熟食": [["shú"], ["shí"]],
    "熟思": [["shú"], ["sī"]],
    "熟语": [["shú"], ["yǔ"]],
    "熟知": [["shú"], ["zhī"]],
    "暑假": [["shǔ"], ["jià"]],
    "暑期": [["shǔ"], ["qī"]],
    "薯莨": [["shǔ"], ["liáng"]],
    "术科": [["shù"], ["kē"]],
    "术士": [["shù"], ["shì"]],
    "术语": [["shù"], ["yǔ"]],
    "术业": [["shù"], ["yè"]],
    "戍卒": [["shù"], ["zú"]],
    "束发": [["shù"], ["fà"]],
    "述说": [["shù"], ["shuō"]],
    "述语": [["shù"], ["yǔ"]],
    "树干": [["shù"], ["gàn"]],
    "树杈": [["shù"], ["chà"]],
    "树冠": [["shù"], ["guān"]],
    "树梢": [["shù"], ["shāo"]],
    "树叶": [["shù"], ["yè"]],
    "树荫": [["shù"], ["yīn"]],
    "树枝": [["shù"], ["zhī"]],
    "树种": [["shù"], ["zhǒng"]],
    "数表": [["shù"], ["biǎo"]],
    "数词": [["shù"], ["cí"]],
    "数叨": [["shù"], ["dāo"]],
    "数额": [["shù"], ["é"]],
    "数九": [["shǔ"], ["jiǔ"]],
    "数据": [["shù"], ["jù"]],
    "数量": [["shù"], ["liàng"]],
    "数列": [["shù"], ["liè"]],
    "数论": [["shù"], ["lùn"]],
    "数落": [["shǔ"], ["luò"]],
    "数码": [["shù"], ["mǎ"]],
    "数目": [["shù"], ["mù"]],
    "数数": [["shuò"], ["shuò"]],
    "数说": [["shǔ"], ["shuō"]],
    "数位": [["shù"], ["wèi"]],
    "数学": [["shù"], ["xué"]],
    "数值": [["shù"], ["zhí"]],
    "数制": [["shù"], ["zhì"]],
    "数珠": [["shù"], ["zhū"]],
    "数字": [["shù"], ["zì"]],
    "漱洗": [["shù"], ["xǐ"]],
    "刷白": [["shuà"], ["bái"]],
    "刷拉": [["shuā"], ["lā"]],
    "刷毛": [["shuā"], ["máo"]],
    "刷刷": [["shuā"], ["shuā"]],
    "刷洗": [["shuā"], ["xǐ"]],
    "刷新": [["shuā"], ["xīn"]],
    "刷子": [["shuā"], ["zǐ"]],
    "耍横": [["shuǎ"], ["hèng"]],
    "耍弄": [["shuǎ"], ["nòng"]],
    "衰败": [["shuāi"], ["bài"]],
    "衰惫": [["shuāi"], ["bèi"]],
    "衰变": [["shuāi"], ["biàn"]],
    "衰草": [["shuāi"], ["cǎo"]],
    "衰减": [["shuāi"], ["jiǎn"]],
    "衰竭": [["shuāi"], ["jié"]],
    "衰落": [["shuāi"], ["luò"]],
    "衰老": [["shuāi"], ["lǎo"]],
    "衰迈": [["shuāi"], ["mài"]],
    "衰年": [["shuāi"], ["nián"]],
    "衰退": [["shuāi"], ["tuì"]],
    "衰弱": [["shuāi"], ["ruò"]],
    "衰颓": [["shuāi"], ["tuí"]],
    "衰亡": [["shuāi"], ["wáng"]],
    "衰微": [["shuāi"], ["wēi"]],
    "衰朽": [["shuāi"], ["xiǔ"]],
    "衰萎": [["shuāi"], ["wěi"]],
    "摔倒": [["shuāi"], ["dǎo"]],
    "摔打": [["shuāi"], ["dá"]],
    "摔角": [["shuāi"], ["jiǎo"]],
    "栓塞": [["shuān"], ["sè"]],
    "双打": [["shuāng"], ["dǎ"]],
    "双杠": [["shuāng"], ["gàng"]],
    "双抢": [["shuāng"], ["qiǎng"]],
    "双栖": [["shuāng"], ["qī"]],
    "双亲": [["shuāng"], ["qīn"]],
    "双重": [["shuāng"], ["chóng"]],
    "霜降": [["shuāng"], ["jiàng"]],
    "霜期": [["shuāng"], ["qī"]],
    "霜叶": [["shuāng"], ["yè"]],
    "谁个": [["shuí"], ["gè"]],
    "谁家": [["shuí"], ["jiā"]],
    "水车": [["shuǐ"], ["chē"]],
    "水尺": [["shuǐ"], ["chǐ"]],
    "水地": [["shuǐ"], ["dì"]],
    "水斗": [["shuǐ"], ["dòu"]],
    "水发": [["shuǐ"], ["fā"]],
    "水柜": [["shuǐ"], ["guì"]],
    "水分": [["shuǐ"], ["fèn"]],
    "水合": [["shuǐ"], ["hé"]],
    "水红": [["shuǐ"], ["hóng"]],
    "水浒": [["shuǐ"], ["hǔ"]],
    "水解": [["shuǐ"], ["jiě"]],
    "水景": [["shuǐ"], ["jǐng"]],
    "水绿": [["shuǐ"], ["lǜ"]],
    "水量": [["shuǐ"], ["liàng"]],
    "水磨": [["shuǐ"], ["mó"]],
    "水泥": [["shuǐ"], ["ní"]],
    "水能": [["shuǐ"], ["néng"]],
    "水泡": [["shuǐ"], ["pào"]],
    "水炮": [["shuǐ"], ["pào"]],
    "水区": [["shuǐ"], ["qū"]],
    "水渠": [["shuǐ"], ["qú"]],
    "水上": [["shuǐ"], ["shàng"]],
    "水蛇": [["shuǐ"], ["shé"]],
    "水头": [["shuǐ"], ["tóu"]],
    "水纹": [["shuǐ"], ["wén"]],
    "水系": [["shuǐ"], ["xì"]],
    "水压": [["shuǐ"], ["yā"]],
    "水泽": [["shuǐ"], ["zé"]],
    "水栅": [["shuǐ"], ["shān"]],
    "税单": [["shuì"], ["dān"]],
    "税卡": [["shuì"], ["qiǎ"]],
    "税率": [["shuì"], ["lǜ"]],
    "税契": [["shuì"], ["qì"]],
    "税种": [["shuì"], ["zhǒng"]],
    "睡觉": [["shuì"], ["jiào"]],
    "睡相": [["shuì"], ["xiàng"]],
    "睡椅": [["shuì"], ["yǐ"]],
    "顺便": [["shùn"], ["biàn"]],
    "顺差": [["shùn"], ["chā"]],
    "顺从": [["shùn"], ["cóng"]],
    "顺当": [["shùn"], ["dāng"]],
    "顺服": [["shùn"], ["fú"]],
    "顺风": [["shùn"], ["fēng"]],
    "顺和": [["shùn"], ["hé"]],
    "顺化": [["shùn"], ["huà"]],
    "顺溜": [["shùn"], ["liū"]],
    "顺应": [["shùn"], ["yìng"]],
    "瞬间": [["shùn"], ["jiān"]],
    "说白": [["shuō"], ["bái"]],
    "说唱": [["shuō"], ["chàng"]],
    "说穿": [["shuō"], ["chuān"]],
    "说辞": [["shuō"], ["cí"]],
    "说词": [["shuō"], ["cí"]],
    "说错": [["shuō"], ["cuò"]],
    "说道": [["shuō"], ["dào"]],
    "说法": [["shuō"], ["fǎ"]],
    "说服": [["shuō"], ["fú"]],
    "说好": [["shuō"], ["hǎo"]],
    "说和": [["shuō"], ["hé"]],
    "说合": [["shuō"], ["hé"]],
    "说话": [["shuōhu&agrave;"]],
    "说谎": [["shuō"], ["huǎng"]],
    "说教": [["shuō"], ["jiào"]],
    "说开": [["shuō"], ["kāi"]],
    "说理": [["shuō"], ["lǐ"]],
    "说媒": [["shuō"], ["méi"]],
    "说明": [["shuō"], ["míng"]],
    "说破": [["shuō"], ["pò"]],
    "说客": [["shuō"], ["kè"]],
    "说亲": [["shuō"], ["qīn"]],
    "说情": [["shuō"], ["qíng"]],
    "说书": [["shuō"], ["shū"]],
    "说是": [["shuō"], ["shì"]],
    "说死": [["shuō"], ["sǐ"]],
    "说头": [["shuō"], ["tóu"]],
    "说戏": [["shuō"], ["xì"]],
    "说项": [["shuì"], ["xiàng"]],
    "说笑": [["shuō"], ["xiào"]],
    "朔风": [["shuò"], ["fēng"]],
    "说嘴": [["shuō"], ["zuǐ"]],
    "硕果": [["shuò"], ["guǒ"]],
    "司令": [["sī"], ["lìng"]],
    "司空": [["sī"], ["kōng"]],
    "司南": [["sī"], ["nán"]],
    "私藏": [["sī"], ["cáng"]],
    "私奔": [["sī"], ["bēn"]],
    "私车": [["sī"], ["chē"]],
    "私仇": [["sī"], ["chóu"]],
    "私处": [["sī"], ["chǔ"]],
    "私斗": [["sī"], ["dòu"]],
    "私分": [["sī"], ["fēn"]],
    "私会": [["sī"], ["huì"]],
    "私家": [["sī"], ["jiā"]],
    "私见": [["sī"], ["jiàn"]],
    "私了": [["sī"], ["le"]],
    "私囊": [["sī"], ["náng"]],
    "思辨": [["sī"], ["biàn"]],
    "思潮": [["sī"], ["cháo"]],
    "思春": [["sī"], ["chūn"]],
    "思凡": [["sī"], ["fán"]],
    "思忖": [["sī"], ["cǔn"]],
    "思古": [["sī"], ["gǔ"]],
    "思过": [["sī"], ["guò"]],
    "思旧": [["sī"], ["jiù"]],
    "思考": [["sī"], ["kǎo"]],
    "思恋": [["sī"], ["liàn"]],
    "思量": [["sī"], ["liang"]],
    "思路": [["sī"], ["lù"]],
    "思虑": [["sī"], ["lǜ"]],
    "思谋": [["sī"], ["móu"]],
    "思慕": [["sī"], ["mù"]],
    "思亲": [["sī"], ["qīn"]],
    "思念": [["sī"], ["niàn"]],
    "思索": [["sī"], ["suǒ"]],
    "思情": [["sī"], ["qíng"]],
    "思惟": [["sī"], ["wéi"]],
    "思维": [["sī"], ["wéi"]],
    "思想": [["sī"], ["xiǎng"]],
    "思绪": [["sī"], ["xù"]],
    "思议": [["sī"], ["yì"]],
    "厮打": [["sī"], ["dǎ"]],
    "厮混": [["sī"], ["hùn"]],
    "嘶哑": [["sī"], ["yǎ"]],
    "撕打": [["sī"], ["dǎ"]],
    "撕裂": [["sī"], ["liè"]],
    "撕票": [["sī"], ["piào"]],
    "死别": [["sǐ"], ["bié"]],
    "死当": [["sǐ"], ["dàng"]],
    "死地": [["sǐ"], ["dì"]],
    "死角": [["sǐ"], ["jiǎo"]],
    "死节": [["sǐ"], ["jié"]],
    "死结": [["sǐ"], ["jié"]],
    "死难": [["sǐ"], ["nàn"]],
    "死期": [["sǐ"], ["qī"]],
    "死契": [["sǐ"], ["qì"]],
    "死亡": [["sǐ"], ["wáng"]],
    "死巷": [["sǐ"], ["xiàng"]],
    "死症": [["sǐ"], ["zhèng"]],
    "死信": [["sǐ"], ["xìn"]],
    "四处": [["sì"], ["chù"]],
    "四大": [["sì"], ["dà"]],
    "四会": [["sì"], ["huì"]],
    "四溅": [["sì"], ["jiàn"]],
    "四化": [["sì"], ["huà"]],
    "四角": [["sì"], ["jiǎo"]],
    "四六": [["sì"], ["liù"]],
    "四旁": [["sì"], ["páng"]],
    "四散": [["sì"], ["sàn"]],
    "四射": [["sì"], ["shè"]],
    "四体": [["sì"], ["tǐ"]],
    "寺观": [["sì"], ["guàn"]],
    "伺候": [["cì"], ["hou"]],
    "伺机": [["sì"], ["jī"]],
    "伺隙": [["sì"], ["xì"]],
    "似的": [["shì"], ["de"]],
    "似曾": [["sì"], ["céng"]],
    "似乎": [["sì"], ["hū"]],
    "肆行": [["sì"], ["xíng"]],
    "肆应": [["sì"], ["yìng"]],
    "松节": [["sōng"], ["jié"]],
    "松劲": [["sōng"], ["jìn"]],
    "松柏": [["sōng"], ["bǎi"]],
    "松散": [["sōng"], ["sǎn"]],
    "松叶": [["sōng"], ["yè"]],
    "耸峙": [["sǒng"], ["zhì"]],
    "讼棍": [["sòng"], ["gùn"]],
    "宋朝": [["sòng"], ["cháo"]],
    "诵读": [["sòng"], ["dú"]],
    "送别": [["sòng"], ["bié"]],
    "送风": [["sòng"], ["fēng"]],
    "送给": [["sòng"], ["gěi"]],
    "送还": [["sòng"], ["hái"]],
    "送信": [["sòng"], ["xìn"]],
    "送丧": [["sòng"], ["sàng"]],
    "送亲": [["sòng"], ["qīn"]],
    "送行": [["sòng"], ["xíng"]],
    "搜查": [["sōu"], ["zhā"]],
    "搜剿": [["sōu"], ["jiǎo"]],
    "搜括": [["sōu"], ["guā"]],
    "苏白": [["sū"], ["bái"]],
    "苏打": [["sū"], ["dá"]],
    "苏丹": [["sū"], ["dān"]],
    "苏俄": [["sū"], ["é"]],
    "苏堤": [["sū"], ["dī"]],
    "苏剧": [["sū"], ["jù"]],
    "苏木": [["sū"], ["mù"]],
    "苏秦": [["sū"], ["qín"]],
    "苏区": [["sū"], ["qū"]],
    "苏醒": [["sū"], ["xǐng"]],
    "苏绣": [["sū"], ["xiù"]],
    "俗称": [["sú"], ["chēng"]],
    "苏子": [["sū"], ["zǐ"]],
    "俗家": [["sú"], ["jiā"]],
    "俗曲": [["sú"], ["qǔ"]],
    "俗体": [["sú"], ["tǐ"]],
    "俗语": [["sú"], ["yǔ"]],
    "夙仇": [["sù"], ["chóu"]],
    "诉说": [["sù"], ["shuō"]],
    "素服": [["sù"], ["fú"]],
    "素朴": [["sù"], ["piáo"]],
    "素净": [["sù"], ["jìng"]],
    "素食": [["sù"], ["shí"]],
    "素数": [["sù"], ["shù"]],
    "速度": [["sù"], ["dù"]],
    "速率": [["sù"], ["lǜ"]],
    "速射": [["sù"], ["shè"]],
    "宿将": [["sù"], ["jiàng"]],
    "嗉囊": [["sù"], ["náng"]],
    "酸雨": [["suān"], ["yǔ"]],
    "蒜泥": [["suàn"], ["ní"]],
    "蒜头": [["suàn"], ["tóu"]],
    "算得": [["suàn"], ["de"]],
    "算了": [["suàn"], ["le"]],
    "算术": [["suàn"], ["shù"]],
    "算数": [["suàn"], ["shù"]],
    "虽说": [["suī"], ["shuō"]],
    "绥宁": [["suí"], ["níng"]],
    "绥远": [["suí"], ["yuǎn"]],
    "随处": [["suí"], ["chù"]],
    "随和": [["suí"], ["hé"]],
    "岁数": [["suì"], ["shù"]],
    "岁差": [["suì"], ["chà"]],
    "遂行": [["suì"], ["xíng"]],
    "碎裂": [["suì"], ["liè"]],
    "碎片": [["suì"], ["piàn"]],
    "碎石": [["suì"], ["shí"]],
    "燧石": [["suì"], ["shí"]],
    "邃远": [["suì"], ["yuǎn"]],
    "孙儿": [["sūn"], ["ér"]],
    "孙女": [["sūn"], ["nǚ"]],
    "孙吴": [["sūn"], ["wú"]],
    "孙子": [["sūn"], ["zi"]],
    "损坏": [["sǔn"], ["huài"]],
    "笋干": [["sǔn"], ["gān"]],
    "榫头": [["sǔn"], ["tóu"]],
    "缩编": [["suō"], ["biān"]],
    "缩尺": [["suō"], ["chǐ"]],
    "缩短": [["suō"], ["duǎn"]],
    "缩回": [["suō"], ["huí"]],
    "缩简": [["suō"], ["jiǎn"]],
    "缩减": [["suō"], ["jiǎn"]],
    "缩紧": [["suō"], ["jǐn"]],
    "缩进": [["suō"], ["jìn"]],
    "缩聚": [["suō"], ["jù"]],
    "缩颈": [["suō"], ["jǐng"]],
    "缩略": [["suō"], ["lüè"]],
    "缩缩": [["suō"], ["suō"]],
    "缩手": [["suō"], ["shǒu"]],
    "缩水": [["suō"], ["shuǐ"]],
    "缩头": [["suō"], ["tóu"]],
    "缩微": [["suō"], ["wēi"]],
    "缩图": [["suō"], ["tú"]],
    "缩小": [["suō"], ["xiǎo"]],
    "缩写": [["suō"], ["xiě"]],
    "缩印": [["suō"], ["yìn"]],
    "所长": [["suǒ"], ["chánɡ"]],
    "缩影": [["suō"], ["yǐng"]],
    "所得": [["suǒ"], ["de"]],
    "所说": [["suǒ"], ["shuō"]],
    "所思": [["suǒ"], ["sī"]],
    "所有": [["suǒ"], ["yǒu"]],
    "所知": [["suǒ"], ["zhī"]],
    "所属": [["suǒ"], ["shǔ"]],
    "唢呐": [["suǒ"], ["nà"]],
    "索价": [["suǒ"], ["jià"]],
    "索解": [["suǒ"], ["jiě"]],
    "索要": [["suǒ"], ["yào"]],
    "锁匙": [["suǒ"], ["chí"]],
    "锁骨": [["suǒ"], ["gǔ"]],
    "锁上": [["suǒ"], ["shàng"]],
    "锁钥": [["suǒ"], ["yuè"]],
    "他处": [["tā"], ["chǔ"]],
    "他家": [["tā"], ["jiā"]],
    "趿拉": [["tā"], ["lā"]],
    "塌落": [["tā"], ["luò"]],
    "塌台": [["tā"], ["tái"]],
    "塔台": [["tǎ"], ["tái"]],
    "獭祭": [["tǎ"], ["jì"]],
    "踏看": [["tà"], ["kàn"]],
    "踏空": [["tà"], ["kōng"]],
    "胎毒": [["tāi"], ["dú"]],
    "胎发": [["tāi"], ["fà"]],
    "台安": [["tái"], ["ān"]],
    "胎教": [["tāi"], ["jiào"]],
    "台胞": [["tái"], ["bāo"]],
    "台北": [["tái"], ["běi"]],
    "台步": [["tái"], ["bù"]],
    "台布": [["tái"], ["bù"]],
    "台长": [["tái"], ["cháng"]],
    "台秤": [["tái"], ["chèng"]],
    "台词": [["tái"], ["cí"]],
    "台灯": [["tái"], ["dēng"]],
    "台地": [["tái"], ["dì"]],
    "台风": [["tái"], ["fēng"]],
    "台甫": [["tái"], ["fǔ"]],
    "台阁": [["tái"], ["gé"]],
    "台基": [["tái"], ["jī"]],
    "台驾": [["tái"], ["jià"]],
    "台鉴": [["tái"], ["jiàn"]],
    "台阶": [["tái"], ["jiē"]],
    "台历": [["tái"], ["lì"]],
    "台面": [["tái"], ["miàn"]],
    "台盘": [["tái"], ["pán"]],
    "台球": [["tái"], ["qiú"]],
    "台扇": [["tái"], ["shàn"]],
    "台下": [["tái"], ["xià"]],
    "台榭": [["tái"], ["xiè"]],
    "台钟": [["tái"], ["zhōng"]],
    "台中": [["tái"], ["zhōng"]],
    "台资": [["tái"], ["zī"]],
    "台子": [["tái"], ["zi"]],
    "台座": [["tái"], ["zuò"]],
    "抬杠": [["tái"], ["gàng"]],
    "抬价": [["tái"], ["jià"]],
    "抬头": [["tái"], ["tóu"]],
    "苔藓": [["tái"], ["xiǎn"]],
    "太冲": [["tài"], ["chòng"]],
    "太过": [["tài"], ["guò"]],
    "太和": [["tài"], ["hé"]],
    "太监": [["tài"], ["jiàn"]],
    "太空": [["tài"], ["kōng"]],
    "太甚": [["tài"], ["shèn"]],
    "太尉": [["tài"], ["wèi"]],
    "态度": [["tài"], ["dù"]],
    "泰斗": [["tài"], ["dǒu"]],
    "泰和": [["tài"], ["hé"]],
    "泰宁": [["tài"], ["níng"]],
    "泰语": [["tài"], ["yǔ"]],
    "坍台": [["tān"], ["tái"]],
    "贪食": [["tān"], ["shí"]],
    "贪占": [["tān"], ["zhàn"]],
    "摊还": [["tān"], ["hái"]],
    "滩地": [["tān"], ["dì"]],
    "滩头": [["tān"], ["tóu"]],
    "滩羊": [["tān"], ["yáng"]],
    "坛场": [["tán"], ["chǎng"]],
    "谈论": [["tán"], ["lùn"]],
    "谈兴": [["tán"], ["xìng"]],
    "谈吐": [["tán"], ["tǔ"]],
    "谈助": [["tán"], ["zhù"]],
    "檀郎": [["tán"], ["láng"]],
    "坦露": [["tǎn"], ["lù"]],
    "坦率": [["tǎn"], ["shuài"]],
    "叹服": [["tàn"], ["fú"]],
    "袒露": [["tǎn"], ["lù"]],
    "炭化": [["tàn"], ["huà"]],
    "汤包": [["tāng"], ["bāo"]],
    "汤池": [["tāng"], ["chí"]],
    "汤匙": [["tāng"], ["chí"]],
    "汤罐": [["tāng"], ["guàn"]],
    "汤锅": [["tāng"], ["guō"]],
    "汤剂": [["tāng"], ["jì"]],
    "汤面": [["tāng"], ["miàn"]],
    "汤泉": [["tāng"], ["quán"]],
    "汤勺": [["tāng"], ["sháo"]],
    "汤水": [["tāng"], ["shuǐ"]],
    "汤头": [["tāng"], ["tóu"]],
    "汤团": [["tāng"], ["tuán"]],
    "汤碗": [["tāng"], ["wǎn"]],
    "汤药": [["tāng"], ["yào"]],
    "汤圆": [["tāng"], ["yuán"]],
    "堂奥": [["táng"], ["ào"]],
    "堂会": [["táng"], ["huì"]],
    "棠棣": [["táng"], ["dì"]],
    "塘泥": [["táng"], ["ní"]],
    "搪塞": [["táng"], ["sè"]],
    "糖厂": [["táng"], ["chǎng"]],
    "溏便": [["táng"], ["biàn"]],
    "糖弹": [["táng"], ["dàn"]],
    "糖尿": [["táng"], ["niào"]],
    "糖食": [["táng"], ["shí"]],
    "倘然": [["tǎng"], ["rán"]],
    "倘或": [["tǎng"], ["huò"]],
    "倘若": [["tǎng"], ["ruò"]],
    "倘使": [["tǎng"], ["shǐ"]],
    "倘佯": [["cháng"], ["yáng"]],
    "耥耙": [["tǎng"], ["bà"]],
    "躺倒": [["tǎng"], ["dǎo"]],
    "躺柜": [["tǎng"], ["guì"]],
    "躺椅": [["tǎng"], ["yǐ"]],
    "烫发": [["tàng"], ["fà"]],
    "烫头": [["tàng"], ["tóu"]],
    "烫洗": [["tàng"], ["xǐ"]],
    "趟马": [["tàng"], ["mǎ"]],
    "逃奔": [["táo"], ["bèn"]],
    "逃难": [["táo"], ["nàn"]],
    "逃跑": [["táo"], ["pǎo"]],
    "逃票": [["táo"], ["piào"]],
    "逃散": [["táo"], ["sàn"]],
    "逃亡": [["táo"], ["wáng"]],
    "桃核": [["táo"], ["hé"]],
    "桃红": [["táo"], ["hóng"]],
    "淘洗": [["táo"], ["xǐ"]],
    "讨还": [["tǎo"], ["huán"]],
    "讨好": [["tǎo"], ["hǎo"]],
    "讨价": [["tǎo"], ["jià"]],
    "讨教": [["tǎo"], ["jiào"]],
    "讨论": [["tǎo"], ["lùn"]],
    "讨亲": [["tǎo"], ["qīn"]],
    "讨要": [["tǎo"], ["yào"]],
    "套车": [["tào"], ["chē"]],
    "套红": [["tào"], ["hóng"]],
    "套服": [["tào"], ["fú"]],
    "套间": [["tào"], ["jiān"]],
    "套结": [["tào"], ["jié"]],
    "套数": [["tào"], ["shù"]],
    "套曲": [["tào"], ["qǔ"]],
    "套头": [["tào"], ["tóu"]],
    "套种": [["tào"], ["zhòng"]],
    "套语": [["tào"], ["yǔ"]],
    "特长": [["tè"], ["cháng"]],
    "特别": [["tè"], ["bié"]],
    "特地": [["tè"], ["dì"]],
    "特价": [["tè"], ["jià"]],
    "特区": [["tè"], ["qū"]],
    "特为": [["tè"], ["wèi"]],
    "特约": [["tè"], ["yuē"]],
    "特许": [["tè"], ["xǔ"]],
    "特有": [["tè"], ["yǒu"]],
    "特徵": [["tè"], ["zhǐ"]],
    "特种": [["tè"], ["zhǒng"]],
    "腾空": [["téng"], ["kōng"]],
    "腾冲": [["téng"], ["chōng"]],
    "腾涌": [["téng"], ["yǒng"]],
    "藤蔓": [["téng"], ["wàn"]],
    "藤条": [["téng"], ["tiáo"]],
    "藤椅": [["téng"], ["yǐ"]],
    "剔红": [["tī"], ["hóng"]],
    "踢打": [["tī"], ["dǎ"]],
    "提案": [["tí"], ["àn"]],
    "啼血": [["tí"], ["xuè"]],
    "提拔": [["tí"], ["bá"]],
    "提包": [["tí"], ["bāo"]],
    "提笔": [["tí"], ["bǐ"]],
    "提拨": [["tí"], ["bō"]],
    "提倡": [["tí"], ["chàng"]],
    "提成": [["tí"], ["chéng"]],
    "提出": [["tí"], ["chū"]],
    "提纯": [["tí"], ["chún"]],
    "提词": [["tí"], ["cí"]],
    "提单": [["tí"], ["dān"]],
    "提点": [["tí"], ["diǎn"]],
    "提灯": [["tí"], ["dēng"]],
    "提到": [["tí"], ["dào"]],
    "提调": [["tí"], ["diào"]],
    "提兜": [["tí"], ["dōu"]],
    "提督": [["tí"], ["dū"]],
    "提法": [["tí"], ["fǎ"]],
    "提防": [["dī"], ["fáng"]],
    "提干": [["tí"], ["gàn"]],
    "提纲": [["tí"], ["gāng"]],
    "提高": [["tí"], ["gāo"]],
    "提供": [["tí"], ["gōng"]],
    "提盒": [["tí"], ["hé"]],
    "提壶": [["tí"], ["hú"]],
    "提花": [["tí"], ["huā"]],
    "提货": [["tí"], ["huò"]],
    "提婚": [["tí"], ["hūn"]],
    "提及": [["tí"], ["jí"]],
    "提级": [["tí"], ["jí"]],
    "提价": [["tí"], ["jià"]],
    "提交": [["tí"], ["jiāo"]],
    "提款": [["tí"], ["kuǎn"]],
    "提篮": [["tí"], ["lán"]],
    "提炼": [["tí"], ["liàn"]],
    "提梁": [["tí"], ["liáng"]],
    "提领": [["tí"], ["lǐng"]],
    "提溜": [["dī"], ["liū"]],
    "提留": [["tí"], ["liú"]],
    "提名": [["tí"], ["míng"]],
    "提起": [["tí"], ["qǐ"]],
    "提前": [["tí"], ["qián"]],
    "提挈": [["tí"], ["qiè"]],
    "提亲": [["tí"], ["qīn"]],
    "提琴": [["tí"], ["qín"]],
    "提请": [["tí"], ["qǐng"]],
    "提取": [["tí"], ["qǔ"]],
    "提神": [["tí"], ["shén"]],
    "提审": [["tí"], ["shěn"]],
    "提升": [["tí"], ["shēng"]],
    "提示": [["tí"], ["shì"]],
    "提手": [["tí"], ["shǒu"]],
    "提提": [["tí"], ["tí"]],
    "提问": [["tí"], ["wèn"]],
    "提箱": [["tí"], ["xiāng"]],
    "提携": [["tí"], ["xié"]],
    "提心": [["tí"], ["xīn"]],
    "提醒": [["tí"], ["xǐng"]],
    "提选": [["tí"], ["xuǎn"]],
    "提讯": [["tí"], ["xùn"]],
    "提要": [["tí"], ["yào"]],
    "提议": [["tí"], ["yì"]],
    "提早": [["tí"], ["zǎo"]],
    "题解": [["tí"], ["jiě"]],
    "提制": [["tí"], ["zhì"]],
    "醍醐": [["tí"], ["hú"]],
    "体表": [["tǐ"], ["biǎo"]],
    "体裁": [["tǐ"], ["cái"]],
    "体操": [["tǐ"], ["cāo"]],
    "体察": [["tǐ"], ["chá"]],
    "体罚": [["tǐ"], ["fá"]],
    "体肤": [["tǐ"], ["fū"]],
    "体格": [["tǐ"], ["gé"]],
    "体会": [["tǐ"], ["huì"]],
    "体积": [["tǐ"], ["jī"]],
    "体己": [["tī"], ["ji"]],
    "体检": [["tǐ"], ["jiǎn"]],
    "体力": [["tǐ"], ["lì"]],
    "体例": [["tǐ"], ["lì"]],
    "体谅": [["tǐ"], ["liàng"]],
    "体量": [["tǐ"], ["liàng"]],
    "体貌": [["tǐ"], ["mào"]],
    "体面": [["tǐ"], ["miàn"]],
    "体内": [["tǐ"], ["nèi"]],
    "体能": [["tǐ"], ["néng"]],
    "体念": [["tǐ"], ["niàn"]],
    "体魄": [["tǐ"], ["pò"]],
    "体腔": [["tǐ"], ["qiāng"]],
    "体认": [["tǐ"], ["rèn"]],
    "体弱": [["tǐ"], ["ruò"]],
    "体式": [["tǐ"], ["shì"]],
    "体态": [["tǐ"], ["tài"]],
    "体坛": [["tǐ"], ["tán"]],
    "体贴": [["tǐ"], ["tiē"]],
    "体统": [["tǐ"], ["tǒng"]],
    "体位": [["tǐ"], ["wèi"]],
    "体味": [["tǐ"], ["wèi"]],
    "体悟": [["tǐ"], ["wù"]],
    "体温": [["tǐ"], ["wēn"]],
    "体惜": [["tǐ"], ["xī"]],
    "体系": [["tǐ"], ["xì"]],
    "体现": [["tǐ"], ["xiàn"]],
    "体校": [["tǐ"], ["xiào"]],
    "体形": [["tǐ"], ["xíng"]],
    "体型": [["tǐ"], ["xíng"]],
    "体性": [["tǐ"], ["xìng"]],
    "体恤": [["tǐ"], ["xù"]],
    "体癣": [["tǐ"], ["xuǎn"]],
    "体验": [["tǐ"], ["yàn"]],
    "体液": [["tǐ"], ["yè"]],
    "体用": [["tǐ"], ["yòng"]],
    "体育": [["tǐ"], ["yù"]],
    "体制": [["tǐ"], ["zhì"]],
    "体质": [["tǐ"], ["zhì"]],
    "体重": [["tǐ"], ["zhòng"]],
    "剃度": [["tì"], ["dù"]],
    "剃发": [["tì"], ["fà"]],
    "剃头": [["tì"], ["tóu"]],
    "嚏喷": [["tì"], ["pen"]],
    "天朝": [["tiān"], ["cháo"]],
    "天车": [["tiān"], ["chē"]],
    "天冲": [["tiān"], ["chōng"]],
    "天底": [["tiān"], ["dǐ"]],
    "天地": [["tiān"], ["dì"]],
    "天蛾": [["tiān"], ["é"]],
    "天分": [["tiān"], ["fèn"]],
    "天父": [["tiān"], ["fù"]],
    "天干": [["tiān"], ["gān"]],
    "天和": [["tiān"], ["hé"]],
    "天空": [["tiān"], ["kōng"]],
    "天女": [["tiān"], ["nǚ"]],
    "天堑": [["tiān"], ["qiàn"]],
    "天趣": [["tiān"], ["qù"]],
    "天阙": [["tiān"], ["què"]],
    "天数": [["tiān"], ["shù"]],
    "天上": [["tiān"], ["shàng"]],
    "天台": [["tiān"], ["tāi"]],
    "天体": [["tiān"], ["tǐ"]],
    "天头": [["tiān"], ["tóu"]],
    "天条": [["tiān"], ["tiáo"]],
    "天王": [["tiān"], ["wáng"]],
    "天择": [["tiān"], ["zé"]],
    "天呀": [["tiān"], ["yā"]],
    "天正": [["tiān"], ["zhèng"]],
    "天竺": [["tiān"], ["zhú"]],
    "添丁": [["tiān"], ["dīng"]],
    "田地": [["tián"], ["dì"]],
    "田父": [["tián"], ["fǔ"]],
    "田间": [["tián"], ["jiān"]],
    "田家": [["tián"], ["jiā"]],
    "田契": [["tián"], ["qì"]],
    "田头": [["tián"], ["tóu"]],
    "恬和": [["tián"], ["hé"]],
    "填报": [["tián"], ["bào"]],
    "填补": [["tián"], ["bǔ"]],
    "填充": [["tián"], ["chōng"]],
    "填词": [["tián"], ["cí"]],
    "填堵": [["tián"], ["dǔ"]],
    "填发": [["tián"], ["fā"]],
    "填方": [["tián"], ["fāng"]],
    "填房": [["tián"], ["fáng"]],
    "填空": [["tián"], ["kòng"]],
    "填料": [["tián"], ["liào"]],
    "填满": [["tián"], ["mǎn"]],
    "填平": [["tián"], ["píng"]],
    "填塞": [["tián"], ["sāi"]],
    "填填": [["tián"], ["tián"]],
    "填写": [["tián"], ["xiě"]],
    "填鸭": [["tián"], ["yā"]],
    "舔食": [["tiǎn"], ["shí"]],
    "佻薄": [["tiāo"], ["bó"]],
    "挑拨": [["tiǎo"], ["bō"]],
    "挑刺": [["tiāo"], ["cì"]],
    "挑担": [["tiāo"], ["dàn"]],
    "挑错": [["tiāo"], ["cuò"]],
    "挑灯": [["tiǎo"], ["dēng"]],
    "挑动": [["tiǎo"], ["dòng"]],
    "挑逗": [["tiǎo"], ["dòu"]],
    "挑夫": [["tiāo"], ["fū"]],
    "挑花": [["tiǎo"], ["huā"]],
    "挑拣": [["tiāo"], ["jiǎn"]],
    "挑明": [["tiǎo"], ["míng"]],
    "挑弄": [["tiǎo"], ["nòng"]],
    "挑食": [["tiāo"], ["shí"]],
    "挑唆": [["tiǎo"], ["suō"]],
    "挑剔": [["tiāo"], ["tī"]],
    "挑头": [["tiāo"], ["tóu"]],
    "挑衅": [["tiǎo"], ["xìn"]],
    "挑选": [["tiāo"], ["xuǎn"]],
    "挑眼": [["tiāo"], ["yǎn"]],
    "挑中": [["tiāo"], ["zhòng"]],
    "挑战": [["tiǎo"], ["zhàn"]],
    "挑子": [["tiāo"], ["zi"]],
    "挑嘴": [["tiǎo"], ["zuǐ"]],
    "条案": [["tiáo"], ["àn"]],
    "条播": [["tiáo"], ["bō"]],
    "条畅": [["dí"], ["dàng"]],
    "条陈": [["tiáo"], ["chén"]],
    "条凳": [["tiáo"], ["dèng"]],
    "条干": [["tiáo"], ["gàn"]],
    "条幅": [["tiáo"], ["fú"]],
    "条规": [["tiáo"], ["guī"]],
    "条贯": [["tiáo"], ["guàn"]],
    "条几": [["tiáo"], ["jī"]],
    "条痕": [["tiáo"], ["hén"]],
    "条件": [["tiáo"], ["jiàn"]],
    "条款": [["tiáo"], ["kuǎn"]],
    "条理": [["tiáo"], ["lǐ"]],
    "条例": [["tiáo"], ["lì"]],
    "条令": [["tiáo"], ["lìng"]],
    "条目": [["tiáo"], ["mù"]],
    "条石": [["tiáo"], ["shí"]],
    "条绒": [["tiáo"], ["róng"]],
    "条条": [["tiáo"], ["tiáo"]],
    "条纹": [["tiáo"], ["wén"]],
    "条文": [["tiáo"], ["wén"]],
    "条形": [["tiáo"], ["xíng"]],
    "条约": [["tiáo"], ["yuē"]],
    "条状": [["tiáo"], ["zhuàng"]],
    "条桌": [["tiáo"], ["zhuō"]],
    "条子": [["tiáo"], ["zi"]],
    "迢远": [["tiáo"], ["yuǎn"]],
    "跳板": [["tiào"], ["bǎn"]],
    "跳槽": [["tiào"], ["cáo"]],
    "跳班": [["tiào"], ["bān"]],
    "跳虫": [["tiào"], ["chóng"]],
    "跳出": [["tiào"], ["chū"]],
    "跳动": [["tiào"], ["dòng"]],
    "跳荡": [["tiào"], ["dàng"]],
    "跳高": [["tiào"], ["gāo"]],
    "跳河": [["tiào"], ["hé"]],
    "跳级": [["tiào"], ["jí"]],
    "跳脚": [["tiào"], ["jiǎo"]],
    "跳井": [["tiào"], ["jǐng"]],
    "跳空": [["tiào"], ["kōng"]],
    "跳栏": [["tiào"], ["lán"]],
    "跳踉": [["tiào"], ["liáng"]],
    "跳梁": [["tiào"], ["liáng"]],
    "跳马": [["tiào"], ["mǎ"]],
    "跳棋": [["tiào"], ["qí"]],
    "跳伞": [["tiào"], ["sǎn"]],
    "跳神": [["tiào"], ["shén"]],
    "跳鼠": [["tiào"], ["shǔ"]],
    "跳绳": [["tiào"], ["shéng"]],
    "跳水": [["tiào"], ["shuǐ"]],
    "跳台": [["tiào"], ["tái"]],
    "跳脱": [["tiào"], ["tuō"]],
    "跳舞": [["tiào"], ["wǔ"]],
    "跳箱": [["tiào"], ["xiāng"]],
    "跳行": [["tiào"], ["háng"]],
    "跳远": [["tiào"], ["yuǎn"]],
    "跳月": [["tiào"], ["yuè"]],
    "跳跃": [["tiào"], ["yuè"]],
    "跳越": [["tiào"], ["yuè"]],
    "跳蚤": [["tiào"], ["zǎo"]],
    "跳闸": [["tiào"], ["zhá"]],
    "贴切": [["tiē"], ["qiè"]],
    "贴合": [["tiē"], ["hé"]],
    "贴着": [["tiē"], ["zhe"]],
    "铁臂": [["tiě"], ["bì"]],
    "铁打": [["tiě"], ["dǎ"]],
    "铁厂": [["tiě"], ["chǎng"]],
    "铁钉": [["tiě"], ["dīng"]],
    "铁杆": [["tiě"], ["gǎn"]],
    "铁骨": [["tiě"], ["gǔ"]],
    "铁柜": [["tiě"], ["guì"]],
    "铁岭": [["tiě"], ["lǐng"]],
    "铁笼": [["tiě"], ["lóng"]],
    "铁耙": [["tiě"], ["pá"]],
    "铁片": [["tiě"], ["piàn"]],
    "铁石": [["tiě"], ["shí"]],
    "铁血": [["tiě"], ["xuè"]],
    "铁椎": [["tiě"], ["chuí"]],
    "帖服": [["tiē"], ["fú"]],
    "帖子": [["tiě"], ["zǐ"]],
    "听便": [["tīng"], ["biàn"]],
    "听差": [["tīng"], ["chāi"]],
    "听从": [["tīng"], ["cóng"]],
    "听会": [["tīng"], ["huì"]],
    "听见": [["tīng"], ["jiàn"]],
    "听觉": [["tīng"], ["jué"]],
    "听任": [["tīng"], ["rèn"]],
    "听说": [["tīng"], ["shuō"]],
    "听戏": [["tīng"], ["xì"]],
    "听信": [["tīng"], ["xìn"]],
    "廷尉": [["tíng"], ["wèi"]],
    "亭长": [["tíng"], ["cháng"]],
    "庭长": [["tíng"], ["zhǎng"]],
    "停车": [["tíng"], ["chē"]],
    "停食": [["tíng"], ["shí"]],
    "挺括": [["tǐng"], ["guā"]],
    "通便": [["tōng"], ["biàn"]],
    "通车": [["tōng"], ["chē"]],
    "通称": [["tōng"], ["chēng"]],
    "通读": [["tōng"], ["dú"]],
    "通分": [["tōng"], ["fēn"]],
    "通风": [["tōng"], ["fēng"]],
    "通观": [["tōng"], ["guān"]],
    "通共": [["tōng"], ["gòng"]],
    "通过": [["tōng"], ["guò"]],
    "通好": [["tōng"], ["hǎo"]],
    "通红": [["tòng"], ["hóng"]],
    "通缉": [["tōng"], ["jī"]],
    "通化": [["tōng"], ["huà"]],
    "通家": [["tōng"], ["jiā"]],
    "通假": [["tōng"], ["jiǎ"]],
    "通解": [["tōng"], ["jiě"]],
    "通量": [["tōng"], ["liàng"]],
    "通令": [["tōng"], ["lìng"]],
    "通论": [["tōng"], ["lùn"]],
    "通票": [["tōng"], ["piào"]],
    "通铺": [["tōng"], ["pù"]],
    "通宿": [["tōng"], ["sù"]],
    "通体": [["tōng"], ["tǐ"]],
    "通条": [["tōng"], ["tiáo"]],
    "通同": [["tōng"], ["tóng"]],
    "通信": [["tōng"], ["xìn"]],
    "通行": [["tōng"], ["xíng"]],
    "通知": [["tōng"], ["zhī"]],
    "同班": [["tóng"], ["bān"]],
    "同案": [["tóng"], ["àn"]],
    "同伴": [["tóng"], ["bàn"]],
    "同辈": [["tóng"], ["bèi"]],
    "同胞": [["tóng"], ["bāo"]],
    "同步": [["tóng"], ["bù"]],
    "同侪": [["tóng"], ["chái"]],
    "同窗": [["tóng"], ["chuāng"]],
    "同道": [["tóng"], ["dào"]],
    "同党": [["tóng"], ["dǎng"]],
    "同等": [["tóng"], ["děng"]],
    "同德": [["tóng"], ["dé"]],
    "同调": [["tóng"], ["diào"]],
    "同队": [["tóng"], ["duì"]],
    "同犯": [["tóng"], ["fàn"]],
    "同方": [["tóng"], ["fāng"]],
    "同房": [["tóng"], ["fáng"]],
    "同感": [["tóng"], ["gǎn"]],
    "同庚": [["tóng"], ["gēng"]],
    "同归": [["tóng"], ["guī"]],
    "同好": [["tóng"], ["hào"]],
    "同贺": [["tóng"], ["hè"]],
    "同化": [["tóng"], ["huà"]],
    "同欢": [["tóng"], ["huān"]],
    "同伙": [["tóng"], ["huǒ"]],
    "同级": [["tóng"], ["jí"]],
    "同济": [["tóng"], ["jì"]],
    "同科": [["tóng"], ["kē"]],
    "同居": [["tóng"], ["jū"]],
    "同乐": [["tóng"], ["lè"]],
    "同类": [["tóng"], ["lèi"]],
    "同量": [["tóng"], ["liàng"]],
    "同僚": [["t&oacute;ngli&aacute;o"]],
    "同龄": [["tóng"], ["líng"]],
    "同路": [["tóng"], ["lù"]],
    "同门": [["tóng"], ["mén"]],
    "同盟": [["tóng"], ["méng"]],
    "同名": [["tóng"], ["míng"]],
    "同谋": [["tóng"], ["móu"]],
    "同命": [["tóng"], ["mìng"]],
    "同年": [["tóng"], ["nián"]],
    "同袍": [["tóng"], ["páo"]],
    "同期": [["tóng"], ["qī"]],
    "同气": [["tóng"], ["qì"]],
    "同前": [["tóng"], ["qián"]],
    "同庆": [["tóng"], ["qìng"]],
    "同情": [["tóng"], ["qíng"]],
    "同人": [["tóng"], ["rén"]],
    "同仁": [["tóng"], ["rén"]],
    "同日": [["tóng"], ["rì"]],
    "同声": [["tóng"], ["shēng"]],
    "同时": [["tóng"], ["shí"]],
    "同上": [["tóng"], ["shàng"]],
    "同事": [["tóng"], ["shì"]],
    "同室": [["tóng"], ["shì"]],
    "同岁": [["tóng"], ["suì"]],
    "同堂": [["tóng"], ["táng"]],
    "同体": [["tóng"], ["tǐ"]],
    "同位": [["tóng"], ["wèi"]],
    "同屋": [["tóng"], ["wū"]],
    "同喜": [["tóng"], ["xǐ"]],
    "同乡": [["tóng"], ["xiāng"]],
    "同心": [["tóng"], ["xīn"]],
    "同形": [["tóng"], ["xíng"]],
    "同行": [["tóng"], ["háng"]],
    "同姓": [["tóng"], ["xìng"]],
    "同性": [["tóng"], ["xìng"]],
    "同学": [["tóng"], ["xué"]],
    "同样": [["tóng"], ["yàng"]],
    "同业": [["tóng"], ["yè"]],
    "同一": [["tóng"], ["yī"]],
    "同义": [["tóng"], ["yì"]],
    "同意": [["tóng"], ["yì"]],
    "同音": [["tóng"], ["yīn"]],
    "同源": [["tóng"], ["yuán"]],
    "同志": [["tóng"], ["zhì"]],
    "同种": [["tóng"], ["zhǒng"]],
    "同质": [["tóng"], ["zhì"]],
    "同治": [["tóng"], ["zhì"]],
    "同宗": [["tóng"], ["zōng"]],
    "同族": [["tóng"], ["zú"]],
    "铜绿": [["tóng"], ["lǜ"]],
    "童便": [["tóng"], ["biàn"]],
    "童蒙": [["tóng"], ["méng"]],
    "童仆": [["tóng"], ["pú"]],
    "童女": [["tóng"], ["nǚ"]],
    "童趣": [["tóng"], ["qù"]],
    "僮仆": [["tóng"], ["pú"]],
    "统称": [["tǒng"], ["chēng"]],
    "统共": [["tǒng"], ["gòng"]],
    "统观": [["tǒng"], ["guān"]],
    "统括": [["tǒng"], ["kuò"]],
    "统率": [["tǒng"], ["shuài"]],
    "统摄": [["tǒng"], ["shè"]],
    "统属": [["tǒng"], ["shǔ"]],
    "筒瓦": [["tǒng"], ["wǎ"]],
    "痛处": [["tòng"], ["chù"]],
    "痛打": [["tòng"], ["dǎ"]],
    "痛恶": [["tòng"], ["wù"]],
    "痛觉": [["tòng"], ["jué"]],
    "痛风": [["tòng"], ["fēng"]],
    "痛切": [["tòng"], ["qiè"]],
    "偷空": [["tōu"], ["kòng"]],
    "头版": [["tóu"], ["bǎn"]],
    "头彩": [["tóu"], ["cǎi"]],
    "头筹": [["tóu"], ["chóu"]],
    "头寸": [["tóu"], ["cùn"]],
    "头等": [["tóu"], ["děng"]],
    "头顶": [["tóu"], ["dǐng"]],
    "头额": [["tóu"], ["é"]],
    "头儿": [["tou"], ["er"]],
    "头发": [["tóu"], ["fà"]],
    "头伏": [["tóu"], ["fú"]],
    "头盖": [["tóu"], ["gài"]],
    "头功": [["tóu"], ["gōng"]],
    "头骨": [["tóu"], ["gǔ"]],
    "头号": [["tóu"], ["hào"]],
    "头昏": [["tóu"], ["hūn"]],
    "头家": [["tóu"], ["jiā"]],
    "头角": [["tóu"], ["jiǎo"]],
    "头颈": [["tóu"], ["jǐng"]],
    "头巾": [["tóu"], ["jīn"]],
    "头盔": [["tóu"], ["kuī"]],
    "头里": [["tóu"], ["lǐ"]],
    "头脸": [["tóu"], ["liǎn"]],
    "头领": [["tóu"], ["lǐng"]],
    "头颅": [["tóu"], ["lú"]],
    "头马": [["tóu"], ["mǎ"]],
    "头路": [["tóu"], ["lù"]],
    "头名": [["tóu"], ["míng"]],
    "头面": [["tóu"], ["miàn"]],
    "头目": [["tóu"], ["mù"]],
    "头脑": [["tóu"], ["nǎo"]],
    "头年": [["tóu"], ["nián"]],
    "头帕": [["tóu"], ["pà"]],
    "头牌": [["tóu"], ["pái"]],
    "头皮": [["tóu"], ["pí"]],
    "头前": [["tóu"], ["qián"]],
    "头钱": [["tóu"], ["qián"]],
    "头球": [["tóu"], ["qiú"]],
    "头人": [["tóu"], ["rén"]],
    "头生": [["tóu"], ["shēng"]],
    "头绳": [["tóu"], ["shéng"]],
    "头虱": [["tóu"], ["shī"]],
    "头饰": [["tóu"], ["shì"]],
    "头胎": [["tóu"], ["tāi"]],
    "头套": [["tóu"], ["tào"]],
    "头疼": [["tóu"], ["téng"]],
    "头天": [["tóu"], ["tiān"]],
    "头痛": [["tóu"], ["tòng"]],
    "头头": [["tóu"], ["tóu"]],
    "头陀": [["tóu"], ["tuó"]],
    "头晚": [["tóu"], ["wǎn"]],
    "头尾": [["tóu"], ["wěi"]],
    "头先": [["tóu"], ["xiān"]],
    "头衔": [["tóu"], ["xián"]],
    "头像": [["tóu"], ["xiàng"]],
    "头绪": [["tóu"], ["xù"]],
    "头型": [["tóu"], ["xíng"]],
    "头癣": [["tóu"], ["xuǎn"]],
    "头羊": [["tóu"], ["yáng"]],
    "头晕": [["tóu"], ["yūn"]],
    "头油": [["tóu"], ["yóu"]],
    "头罩": [["tóu"], ["zhào"]],
    "头子": [["tóu"], ["zi"]],
    "头座": [["tóu"], ["zuò"]],
    "投奔": [["tóu"], ["bèn"]],
    "投弹": [["tóu"], ["dàn"]],
    "投合": [["tóu"], ["hé"]],
    "投降": [["tóu"], ["xiáng"]],
    "投票": [["tóu"], ["piào"]],
    "投契": [["tóu"], ["qì"]],
    "投亲": [["tóu"], ["qīn"]],
    "投射": [["tóu"], ["shè"]],
    "投石": [["tóu"], ["shí"]],
    "投宿": [["tóu"], ["sù"]],
    "透辟": [["tòu"], ["pì"]],
    "透底": [["tòu"], ["dǐ"]],
    "透风": [["tòu"], ["fēng"]],
    "透骨": [["tòu"], ["gǔ"]],
    "透过": [["tòu"], ["guò"]],
    "透汗": [["tòu"], ["hàn"]],
    "透露": [["tòu"], ["lù"]],
    "透射": [["tòu"], ["shè"]],
    "透信": [["tòu"], ["xìn"]],
    "透雨": [["tòu"], ["yǔ"]],
    "秃发": [["tū"], ["fā"]],
    "凸凹": [["tū"], ["āo"]],
    "秃头": [["tū"], ["tóu"]],
    "突地": [["tū"], ["dì"]],
    "突发": [["tū"], ["fā"]],
    "图钉": [["tú"], ["dīng"]],
    "图解": [["tú"], ["jiě"]],
    "图景": [["tú"], ["jǐng"]],
    "图卷": [["tú"], ["juàn"]],
    "图片": [["tú"], ["piàn"]],
    "徒长": [["tú"], ["zhǎng"]],
    "图说": [["tú"], ["shuō"]],
    "徒弟": [["tú"], ["dì"]],
    "涂抹": [["tú"], ["mǒ"]],
    "涂片": [["tú"], ["piàn"]],
    "徒孙": [["tú"], ["sūn"]],
    "荼毒": [["tú"], ["dú"]],
    "途中": [["tú"], ["zhōng"]],
    "土堡": [["tǔ"], ["pù"]],
    "土地": [["tǔ"], ["dì"]],
    "土风": [["tǔ"], ["fēng"]],
    "土棍": [["tǔ"], ["gùn"]],
    "土戏": [["tǔ"], ["xì"]],
    "土语": [["tǔ"], ["yǔ"]],
    "土系": [["tǔ"], ["xì"]],
    "土种": [["tǔ"], ["zhǒng"]],
    "土著": [["tǔ"], ["zhù"]],
    "吐蕃": [["tǔ"], ["bō"]],
    "吐口": [["tǔ"], ["kǒu"]],
    "吐露": [["tǔ"], ["lù"]],
    "吐沫": [["tù"], ["mò"]],
    "吐气": [["tǔ"], ["qì"]],
    "吐弃": [["tǔ"], ["qì"]],
    "吐穗": [["tǔ"], ["suì"]],
    "吐泻": [["tù"], ["xiè"]],
    "吐絮": [["tǔ"], ["xù"]],
    "吐血": [["tù"], ["xiě"]],
    "吐艳": [["tǔ"], ["yàn"]],
    "吐属": [["tǔ"], ["shǔ"]],
    "吐字": [["tǔ"], ["zì"]],
    "团长": [["tuán"], ["zhǎng"]],
    "团丁": [["tuán"], ["dīng"]],
    "团结": [["tuán"], ["jié"]],
    "团弄": [["tuán"], ["nòng"]],
    "团扇": [["tuán"], ["shàn"]],
    "团体": [["tuán"], ["tǐ"]],
    "团委": [["tuán"], ["wěi"]],
    "团员": [["tuán"], ["yuán"]],
    "颓风": [["tuí"], ["fēng"]],
    "退场": [["tuì"], ["chǎng"]],
    "退朝": [["tuì"], ["cháo"]],
    "退佃": [["tuì"], ["diàn"]],
    "退化": [["tuì"], ["huà"]],
    "退还": [["tuì"], ["huán"]],
    "退亲": [["tuì"], ["qīn"]],
    "退票": [["tuì"], ["piào"]],
    "退缩": [["tuì"], ["suō"]],
    "退行": [["tuì"], ["xíng"]],
    "退休": [["tuì"], ["xiū"]],
    "退隐": [["tuì"], ["yǐn"]],
    "蜕化": [["tuì"], ["huà"]],
    "褪去": [["tùn"], ["qù"]],
    "褪色": [["tuì"], ["shǎi"]],
    "吞并": [["tūn"], ["bìng"]],
    "吞剥": [["tūn"], ["bō"]],
    "吞食": [["tūn"], ["shí"]],
    "吞服": [["tūn"], ["fú"]],
    "吞没": [["tūn"], ["mò"]],
    "吞吐": [["tūn"], ["tǔ"]],
    "吞咽": [["tūn"], ["yàn"]],
    "屯兵": [["tún"], ["bīng"]],
    "屯积": [["tún"], ["jī"]],
    "屯集": [["tún"], ["jí"]],
    "屯聚": [["tún"], ["jù"]],
    "屯粮": [["tún"], ["liáng"]],
    "屯垦": [["tún"], ["kěn"]],
    "屯落": [["tún"], ["luò"]],
    "屯留": [["tún"], ["liú"]],
    "屯守": [["tún"], ["shǒu"]],
    "屯田": [["tún"], ["tián"]],
    "屯扎": [["tún"], ["zhā"]],
    "屯驻": [["tún"], ["zhù"]],
    "屯子": [["tún"], ["zǐ"]],
    "托底": [["tuō"], ["dǐ"]],
    "拖把": [["tuō"], ["bǎ"]],
    "拖长": [["tuō"], ["cháng"]],
    "拖车": [["tuō"], ["chē"]],
    "拖沓": [["tuō"], ["tà"]],
    "拖斗": [["tuō"], ["dǒu"]],
    "拖拉": [["tuō"], ["lā"]],
    "拖累": [["tuō"], ["lěi"]],
    "驼背": [["tuó"], ["bèi"]],
    "妥当": [["tuǒ"], ["dàng"]],
    "妥帖": [["tuǒ"], ["tiē"]],
    "拓拔": [["tuò"], ["bá"]],
    "拓本": [["tà"], ["běn"]],
    "拓地": [["tuò"], ["dì"]],
    "拓荒": [["tuò"], ["huāng"]],
    "拓宽": [["tuò"], ["kuān"]],
    "拓片": [["tà"], ["piàn"]],
    "拓扑": [["tuò"], ["pū"]],
    "拓印": [["tà"], ["yìn"]],
    "拓展": [["tuò"], ["zhǎn"]],
    "拓殖": [["tuò"], ["zhí"]],
    "哇塞": [["wā"], ["sāi"]],
    "哇啦": [["wā"], ["lā"]],
    "哇哇": [["wā"], ["wā"]],
    "洼地": [["wā"], ["dì"]],
    "瓦刀": [["wà"], ["dāo"]],
    "瓦当": [["wǎ"], ["dāng"]],
    "瓦房": [["wǎ"], ["fáng"]],
    "瓦工": [["wǎ"], ["gōng"]],
    "瓦罐": [["wǎ"], ["guàn"]],
    "瓦沟": [["wǎ"], ["gōu"]],
    "瓦匠": [["wǎ"], ["jiàng"]],
    "瓦解": [["wǎ"], ["jiě"]],
    "瓦蓝": [["wǎ"], ["lán"]],
    "瓦楞": [["wǎ"], ["léng"]],
    "瓦砾": [["wǎ"], ["lì"]],
    "瓦垄": [["wǎ"], ["lǒng"]],
    "瓦盆": [["wǎ"], ["pén"]],
    "瓦片": [["wǎ"], ["piàn"]],
    "瓦器": [["wǎ"], ["qì"]],
    "瓦圈": [["wǎ"], ["quān"]],
    "瓦全": [["wǎ"], ["quán"]],
    "瓦舍": [["wǎ"], ["shè"]],
    "瓦斯": [["wǎ"], ["sī"]],
    "瓦松": [["wǎ"], ["sōng"]],
    "瓦特": [["wǎ"], ["tè"]],
    "瓦屋": [["wǎ"], ["wū"]],
    "瓦窑": [["wǎ"], ["yáo"]],
    "歪风": [["wāi"], ["fēng"]],
    "歪曲": [["wāi"], ["qū"]],
    "外侧": [["wài"], ["cè"]],
    "外差": [["wài"], ["chà"]],
    "外长": [["wài"], ["zhǎng"]],
    "外厂": [["wài"], ["chǎng"]],
    "外场": [["wài"], ["chǎng"]],
    "外传": [["wài"], ["zhuàn"]],
    "外调": [["wài"], ["diào"]],
    "外地": [["wài"], ["dì"]],
    "外港": [["wài"], ["gǎng"]],
    "外观": [["wài"], ["guān"]],
    "外号": [["wài"], ["hào"]],
    "外化": [["wài"], ["huà"]],
    "外家": [["wài"], ["jiā"]],
    "外间": [["wài"], ["jiān"]],
    "外角": [["wài"], ["jiǎo"]],
    "外教": [["wài"], ["jiào"]],
    "外景": [["wài"], ["jǐng"]],
    "外壳": [["wài"], ["ké"]],
    "外露": [["wài"], ["lù"]],
    "外强": [["wài"], ["jiāng"]],
    "外切": [["wài"], ["qiē"]],
    "外亲": [["wài"], ["qīn"]],
    "外省": [["wài"], ["shěng"]],
    "外孙": [["wài"], ["sūn"]],
    "外头": [["wài"], ["tou"]],
    "外县": [["wài"], ["xiàn"]],
    "外相": [["wài"], ["xiāng"]],
    "外行": [["wài"], ["háng"]],
    "外语": [["wài"], ["yǔ"]],
    "外转": [["wài"], ["zhuǎn"]],
    "弯度": [["wān"], ["dù"]],
    "弯曲": [["wān"], ["qū"]],
    "弯头": [["wān"], ["tóu"]],
    "湾泊": [["wān"], ["bó"]],
    "湾头": [["wān"], ["tóu"]],
    "纨扇": [["wán"], ["shàn"]],
    "完好": [["wán"], ["hǎo"]],
    "完结": [["wán"], ["jié"]],
    "完了": [["wán"], ["le"]],
    "玩乐": [["wán"], ["lè"]],
    "玩弄": [["wán"], ["nòng"]],
    "玩兴": [["wán"], ["xìng"]],
    "顽强": [["wán"], ["qiáng"]],
    "顽石": [["wán"], ["shí"]],
    "顽症": [["wán"], ["zhèng"]],
    "宛然": [["wǎn"], ["rán"]],
    "宛如": [["wǎn"], ["rú"]],
    "宛若": [["wǎn"], ["ruò"]],
    "宛似": [["wǎn"], ["sì"]],
    "宛转": [["wǎn"], ["zhuǎn"]],
    "莞尔": [["wǎn"], ["ěr"]],
    "碗柜": [["wǎn"], ["guì"]],
    "万般": [["wàn"], ["bān"]],
    "万安": [["wàn"], ["ān"]],
    "万端": [["wàn"], ["duān"]],
    "万恶": [["wàn"], ["è"]],
    "万方": [["wàn"], ["fāng"]],
    "万分": [["wàn"], ["fēn"]],
    "万福": [["wàn"], ["fú"]],
    "万古": [["wàn"], ["gǔ"]],
    "万贯": [["wàn"], ["guàn"]],
    "万国": [["wàn"], ["guó"]],
    "万机": [["wàn"], ["jī"]],
    "万籁": [["wàn"], ["lài"]],
    "万金": [["wàn"], ["jīn"]],
    "万历": [["wàn"], ["lì"]],
    "万民": [["wàn"], ["mín"]],
    "万难": [["wàn"], ["nán"]],
    "万能": [["wàn"], ["néng"]],
    "万年": [["wàn"], ["nián"]],
    "万千": [["wàn"], ["qiān"]],
    "万顷": [["wàn"], ["qǐng"]],
    "万全": [["wàn"], ["quán"]],
    "万世": [["wàn"], ["shì"]],
    "万死": [["wàn"], ["sǐ"]],
    "万事": [["wàn"], ["shì"]],
    "万岁": [["wàn"], ["suì"]],
    "万万": [["wàn"], ["wàn"]],
    "万物": [["wàn"], ["wù"]],
    "万象": [["wàn"], ["xiàng"]],
    "万幸": [["wàn"], ["xìng"]],
    "万一": [["wàn"], ["yī"]],
    "万有": [["wàn"], ["yǒu"]],
    "万众": [["wàn"], ["zhòng"]],
    "万丈": [["wàn"], ["zhàng"]],
    "万状": [["wàn"], ["zhuàng"]],
    "腕骨": [["wàn"], ["gǔ"]],
    "亡党": [["wáng"], ["dǎng"]],
    "亡故": [["wáng"], ["gù"]],
    "亡国": [["wáng"], ["guó"]],
    "亡魂": [["wáng"], ["hún"]],
    "亡灵": [["wáng"], ["líng"]],
    "亡命": [["wáng"], ["mìng"]],
    "亡失": [["wáng"], ["shī"]],
    "亡佚": [["wáng"], ["yì"]],
    "亡友": [["wáng"], ["yǒu"]],
    "王八": [["wáng"], ["bā"]],
    "王朝": [["wáng"], ["cháo"]],
    "王储": [["wáng"], ["chǔ"]],
    "王道": [["wáng"], ["dào"]],
    "王法": [["wáng"], ["fǎ"]],
    "王妃": [["wáng"], ["fēi"]],
    "王府": [["wáng"], ["fǔ"]],
    "王公": [["wáng"], ["gōng"]],
    "王宫": [["wáng"], ["gōng"]],
    "王官": [["wáng"], ["guān"]],
    "王国": [["wáng"], ["guó"]],
    "王冠": [["wáng"], ["guān"]],
    "王侯": [["wáng"], ["hóu"]],
    "王后": [["wáng"], ["hòu"]],
    "王浆": [["wáng"], ["jiāng"]],
    "王蒙": [["wáng"], ["méng"]],
    "王牌": [["wáng"], ["pái"]],
    "王权": [["wáng"], ["quán"]],
    "王蛇": [["wáng"], ["shé"]],
    "王室": [["wáng"], ["shì"]],
    "王水": [["wáng"], ["shuǐ"]],
    "王孙": [["wáng"], ["sūn"]],
    "王台": [["wáng"], ["tái"]],
    "王位": [["wáng"], ["wèi"]],
    "王相": [["wáng"], ["xiāng"]],
    "王爷": [["wáng"], ["yé"]],
    "王者": [["wáng"], ["zhě"]],
    "王政": [["wáng"], ["zhèng"]],
    "王子": [["wáng"], ["zǐ"]],
    "王族": [["wáng"], ["zú"]],
    "网络": [["wǎng"], ["luò"]],
    "往还": [["wǎng"], ["huán"]],
    "妄称": [["wàng"], ["chēng"]],
    "妄说": [["wàng"], ["shuō"]],
    "妄为": [["wàng"], ["wéi"]],
    "妄语": [["wàng"], ["yǔ"]],
    "旺盛": [["wàng"], ["shèng"]],
    "危亡": [["wēi"], ["wáng"]],
    "危难": [["wēi"], ["nàn"]],
    "危重": [["wēi"], ["zhòng"]],
    "威风": [["wēi"], ["fēng"]],
    "威迫": [["wēi"], ["pò"]],
    "威吓": [["wēi"], ["hè"]],
    "威信": [["wēi"], ["xìn"]],
    "逶迤": [["wēi"], ["yí"]],
    "微薄": [["wēi"], ["bó"]],
    "微分": [["wēi"], ["fēn"]],
    "微风": [["wēi"], ["fēng"]],
    "微服": [["wēi"], ["fú"]],
    "微观": [["wēi"], ["guān"]],
    "微少": [["wēi"], ["shǎo"]],
    "微行": [["wēi"], ["xíng"]],
    "为此": [["wèi"], ["cǐ"]],
    "为害": [["wéi"], ["hài"]],
    "为何": [["wèi"], ["hé"]],
    "为患": [["wéi"], ["huàn"]],
    "为了": [["wèi"], ["le"]],
    "为难": [["wéi"], ["nán"]],
    "为期": [["wéi"], ["qī"]],
    "为人": [["wéi"], ["rén"]],
    "为生": [["wéi"], ["shēng"]],
    "为时": [["wéi"], ["shí"]],
    "为首": [["wéi"], ["shǒu"]],
    "为数": [["wéi"], ["shù"]],
    "为伍": [["wéi"], ["wǔ"]],
    "为限": [["wéi"], ["xiàn"]],
    "为政": [["wéi"], ["zhèng"]],
    "为止": [["wéi"], ["zhǐ"]],
    "为主": [["wéi"], ["zhǔ"]],
    "为着": [["wéi"], ["zhe"]],
    "圩堤": [["wéi"], ["dī"]],
    "圩垸": [["wéi"], ["yuàn"]],
    "圩子": [["wéi"], ["zǐ"]],
    "围场": [["wéi"], ["chǎng"]],
    "围观": [["wéi"], ["guān"]],
    "围剿": [["wéi"], ["jiǎo"]],
    "围屏": [["wéi"], ["píng"]],
    "违拗": [["wéi"], ["ào"]],
    "违背": [["wéi"], ["bèi"]],
    "违和": [["wéi"], ["hé"]],
    "违纪": [["wéi"], ["jì"]],
    "违禁": [["wéi"], ["jìn"]],
    "违令": [["wéi"], ["lìng"]],
    "违约": [["wéi"], ["yuē"]],
    "桅杆": [["wéi"], ["gān"]],
    "伟大": [["wěi"], ["dà"]],
    "伟论": [["wěi"], ["lùn"]],
    "尾巴": [["wěi"], ["bā"]],
    "尾部": [["wěi"], ["bù"]],
    "尾灯": [["wěi"], ["dēng"]],
    "尾骨": [["wěi"], ["gǔ"]],
    "尾花": [["wěi"], ["huā"]],
    "尾矿": [["wěi"], ["kuàng"]],
    "尾欠": [["wěi"], ["qiàn"]],
    "尾声": [["wěi"], ["shēng"]],
    "尾气": [["wěi"], ["qì"]],
    "尾数": [["wěi"], ["shù"]],
    "尾随": [["wěi"], ["suí"]],
    "尾翼": [["wěi"], ["yì"]],
    "尾音": [["wěi"], ["yīn"]],
    "尾蚴": [["wěi"], ["yòu"]],
    "尾羽": [["wěi"], ["yǔ"]],
    "纬度": [["wěi"], ["dù"]],
    "委靡": [["wěi"], ["mǐ"]],
    "委顿": [["wěi"], ["dùn"]],
    "委派": [["wěi"], ["pài"]],
    "委曲": [["wěi"], ["qū"]],
    "委屈": [["wěi"], ["qū"]],
    "委任": [["wěi"], ["rèn"]],
    "委蛇": [["wēi"], ["yí"]],
    "委身": [["wěi"], ["shēn"]],
    "委实": [["wěi"], ["shí"]],
    "委琐": [["wěi"], ["suǒ"]],
    "委托": [["wěi"], ["tuō"]],
    "委婉": [["wěi"], ["wǎn"]],
    "委员": [["wěi"], ["yuán"]],
    "委罪": [["wěi"], ["zuì"]],
    "诿过": [["wěi"], ["guò"]],
    "未便": [["wèi"], ["biàn"]],
    "未卜": [["wèi"], ["bǔ"]],
    "未几": [["wèi"], ["jǐ"]],
    "未可": [["wèi"], ["kě"]],
    "未了": [["wèi"], ["liǎo"]],
    "未详": [["wèi"], ["xiáng"]],
    "未有": [["wèi"], ["yǒu"]],
    "未曾": [["wèi"], ["zēng"]],
    "位能": [["wèi"], ["néng"]],
    "味觉": [["wèi"], ["jué"]],
    "畏服": [["wèi"], ["fú"]],
    "畏难": [["wèi"], ["nán"]],
    "畏缩": [["wèi"], ["suō"]],
    "尉官": [["wèi"], ["guān"]],
    "喂食": [["wèi"], ["shí"]],
    "慰藉": [["wèi"], ["jiè"]],
    "魏阙": [["wèi"], ["quē"]],
    "温差": [["wēn"], ["chà"]],
    "温和": [["wēn"], ["hé"]],
    "温度": [["wēn"], ["dù"]],
    "温觉": [["wēn"], ["jué"]],
    "温宿": [["wēn"], ["sù"]],
    "文采": [["wén"], ["cǎi"]],
    "文场": [["wén"], ["chǎng"]],
    "文斗": [["wén"], ["dòu"]],
    "文蛤": [["wén"], ["gé"]],
    "文风": [["wén"], ["fēng"]],
    "文号": [["wén"], ["hào"]],
    "文华": [["wén"], ["huá"]],
    "文化": [["wén"], ["huà"]],
    "文教": [["wén"], ["jiào"]],
    "文句": [["wén"], ["jù"]],
    "文卷": [["wén"], ["juàn"]],
    "文论": [["wén"], ["lùn"]],
    "文脉": [["wén"], ["mài"]],
    "文石": [["wén"], ["shí"]],
    "文契": [["wén"], ["qì"]],
    "文思": [["wén"], ["sī"]],
    "文戏": [["wén"], ["xì"]],
    "文体": [["wén"], ["tǐ"]],
    "文员": [["wén"], ["yuán"]],
    "纹理": [["wén"], ["lǐ"]],
    "纹路": [["wén"], ["lù"]],
    "纹身": [["wén"], ["shēn"]],
    "纹银": [["wén"], ["yín"]],
    "纹饰": [["wén"], ["shì"]],
    "闻风": [["wén"], ["fēng"]],
    "闻见": [["wén"], ["jiàn"]],
    "闻知": [["wén"], ["zhī"]],
    "刎颈": [["wěn"], ["jǐng"]],
    "吻别": [["wěn"], ["bié"]],
    "稳便": [["wěn"], ["biàn"]],
    "吻合": [["wěn"], ["hé"]],
    "稳当": [["wěn"], ["dāng"]],
    "稳重": [["wěn"], ["zhòng"]],
    "问卜": [["wèn"], ["bǔ"]],
    "问好": [["wèn"], ["hǎo"]],
    "问答": [["wèn"], ["dá"]],
    "问号": [["wèn"], ["hào"]],
    "问难": [["wèn"], ["nàn"]],
    "汶上": [["wèn"], ["shàng"]],
    "倭瓜": [["wō"], ["guā"]],
    "倭寇": [["wō"], ["kòu"]],
    "涡旋": [["wō"], ["xuán"]],
    "莴苣": [["wō"], ["jù"]],
    "喔喔": [["wō"], ["wō"]],
    "喔唷": [["ō"], ["yō"]],
    "窝藏": [["wō"], ["cáng"]],
    "窝家": [["wō"], ["jiā"]],
    "窝囊": [["wō"], ["nāng"]],
    "窝铺": [["wō"], ["pù"]],
    "窝头": [["wō"], ["tóu"]],
    "蜗角": [["wō"], ["jiǎo"]],
    "蜗旋": [["wō"], ["xuán"]],
    "我见": [["wǒ"], ["jiàn"]],
    "我家": [["wǒ"], ["jiā"]],
    "沃地": [["wò"], ["dì"]],
    "卧车": [["wò"], ["chē"]],
    "卧倒": [["wò"], ["dǎo"]],
    "卧底": [["wò"], ["dǐ"]],
    "卧铺": [["wò"], ["pù"]],
    "卧射": [["wò"], ["shè"]],
    "握别": [["wò"], ["bié"]],
    "斡旋": [["wò"], ["xuán"]],
    "乌龟": [["wū"], ["guī"]],
    "乌拉": [["wù"], ["lɑ"]],
    "乌头": [["wū"], ["tóu"]],
    "乌有": [["wū"], ["yǒu"]],
    "污泥": [["wū"], ["ní"]],
    "呜咽": [["wū"], ["yè"]],
    "巫女": [["wū"], ["nǚ"]],
    "巫术": [["wū"], ["shù"]],
    "无不": [["wú"], ["bù"]],
    "钨钢": [["wū"], ["gāng"]],
    "无处": [["wú"], ["chǔ"]],
    "无从": [["wú"], ["cóng"]],
    "无度": [["wú"], ["dù"]],
    "无风": [["wú"], ["fēng"]],
    "无缝": [["wú"], ["fèng"]],
    "无干": [["wú"], ["gān"]],
    "无过": [["wú"], ["guò"]],
    "无华": [["wú"], ["huá"]],
    "无何": [["wú"], ["hé"]],
    "无稽": [["wú"], ["jī"]],
    "无价": [["wú"], ["jià"]],
    "无几": [["wú"], ["jǐ"]],
    "无间": [["wú"], ["jiàn"]],
    "无疆": [["wú"], ["jiāng"]],
    "无尽": [["wú"], ["jìn"]],
    "无量": [["wú"], ["liàng"]],
    "无可": [["wú"], ["kě"]],
    "无论": [["wú"], ["lùn"]],
    "无能": [["wú"], ["néng"]],
    "无宁": [["wú"], ["nìng"]],
    "无期": [["wú"], ["qī"]],
    "无趣": [["wú"], ["qù"]],
    "无任": [["wú"], ["rèn"]],
    "无上": [["wú"], ["shàng"]],
    "无数": [["wú"], ["shù"]],
    "无为": [["wú"], ["wéi"]],
    "无相": [["wú"], ["xiāng"]],
    "无邪": [["wú"], ["xié"]],
    "无行": [["wú"], ["xíng"]],
    "无疑": [["wú"], ["yí"]],
    "无知": [["wú"], ["zhī"]],
    "无着": [["wú"], ["zhuó"]],
    "毋宁": [["wú"], ["nìng"]],
    "吴王": [["wú"], ["wáng"]],
    "吴语": [["wú"], ["yǔ"]],
    "吴中": [["wú"], ["zhōng"]],
    "吾辈": [["wú"], ["bèi"]],
    "吾侪": [["wú"], ["chái"]],
    "吾人": [["wú"], ["rén"]],
    "吾子": [["wú"], ["zǐ"]],
    "芜荑": [["wú"], ["yí"]],
    "蜈蚣": [["wú"], ["gōng"]],
    "五毒": [["wǔ"], ["dú"]],
    "五分": [["wǔ"], ["fēn"]],
    "五服": [["wǔ"], ["fú"]],
    "五更": [["wǔ"], ["gēng"]],
    "五号": [["wǔ"], ["hào"]],
    "五华": [["wǔ"], ["huá"]],
    "五节": [["wǔ"], ["jié"]],
    "五内": [["wǔ"], ["nèi"]],
    "五台": [["wǔ"], ["tái"]],
    "五羊": [["wǔ"], ["yáng"]],
    "五行": [["wǔ"], ["xíng"]],
    "五岭": [["wǔ"], ["lǐng"]],
    "午觉": [["wǔ"], ["jiào"]],
    "午间": [["wǔ"], ["jiān"]],
    "午休": [["wǔ"], ["xiū"]],
    "武场": [["wǔ"], ["chǎng"]],
    "武打": [["wǔ"], ["dǎ"]],
    "武斗": [["wǔ"], ["dòu"]],
    "武夫": [["wǔ"], ["fū"]],
    "武将": [["wǔ"], ["jiàng"]],
    "武术": [["wǔ"], ["shù"]],
    "武戏": [["wǔ"], ["xì"]],
    "武行": [["wǔ"], ["xíng"]],
    "舞场": [["wǔ"], ["chǎng"]],
    "舞会": [["wǔ"], ["huì"]],
    "舞女": [["wǔ"], ["nǚ"]],
    "舞曲": [["wǔ"], ["qǔ"]],
    "舞弄": [["wǔ"], ["nòng"]],
    "舞台": [["wǔ"], ["tái"]],
    "务期": [["wù"], ["qī"]],
    "务要": [["wù"], ["yào"]],
    "务正": [["wù"], ["zhèng"]],
    "物华": [["wù"], ["huá"]],
    "物化": [["wù"], ["huà"]],
    "物价": [["wù"], ["jià"]],
    "物体": [["wù"], ["tǐ"]],
    "物种": [["wù"], ["zhǒng"]],
    "误差": [["wù"], ["chā"]],
    "误场": [["wù"], ["chǎng"]],
    "误车": [["wù"], ["chē"]],
    "误称": [["wù"], ["chēng"]],
    "误传": [["wù"], ["chuán"]],
    "误会": [["wù"], ["huì"]],
    "误解": [["wù"], ["jiě"]],
    "误期": [["wù"], ["qī"]],
    "误信": [["wù"], ["xìn"]],
    "悟空": [["wù"], ["kōng"]],
    "晤见": [["wù"], ["jiàn"]],
    "雾化": [["wù"], ["huà"]],
    "西北": [["xī"], ["běi"]],
    "西藏": [["xī"], ["zàng"]],
    "西风": [["xī"], ["fēng"]],
    "西服": [["xī"], ["fú"]],
    "西华": [["xī"], ["huá"]],
    "西化": [["xī"], ["huà"]],
    "西乐": [["xī"], ["yuè"]],
    "西南": [["xī"], ["nán"]],
    "西头": [["xī"], ["tóu"]],
    "西王": [["xī"], ["wáng"]],
    "西语": [["xī"], ["yǔ"]],
    "吸毒": [["xī"], ["dú"]],
    "吸食": [["xī"], ["shí"]],
    "吸着": [["xī"], ["zhuó"]],
    "希腊": [["xī"], ["là"]],
    "希奇": [["xī"], ["qí"]],
    "希有": [["xī"], ["yǒu"]],
    "析疑": [["xī"], ["yí"]],
    "奚落": [["xī"], ["luò"]],
    "唏嘘": [["xī"], ["xū"]],
    "息率": [["xī"], ["lǜ"]],
    "犀角": [["xī"], ["jiǎo"]],
    "稀薄": [["xī"], ["bó"]],
    "稀拉": [["xī"], ["lā"]],
    "稀落": [["xī"], ["luò"]],
    "稀奇": [["xī"], ["qí"]],
    "稀少": [["xī"], ["shǎo"]],
    "稀有": [["xī"], ["yǒu"]],
    "锡石": [["xī"], ["shí"]],
    "熙和": [["xī"], ["hé"]],
    "嬉戏": [["xī"], ["xì"]],
    "膝盖": [["xī"], ["gài"]],
    "膝头": [["xī"], ["tóu"]],
    "膝行": [["xī"], ["xíng"]],
    "习服": [["xí"], ["fú"]],
    "习见": [["xí"], ["jiàn"]],
    "习好": [["xí"], ["hǎo"]],
    "席地": [["xí"], ["dì"]],
    "席卷": [["xí"], ["juǎn"]],
    "洗肠": [["xǐ"], ["cháng"]],
    "洗涤": [["xǐ"], ["dí"]],
    "洗尘": [["xǐ"], ["chén"]],
    "洗发": [["xǐ"], ["fā"]],
    "洗剂": [["xǐ"], ["jì"]],
    "洗劫": [["xǐ"], ["jié"]],
    "洗净": [["xǐ"], ["jìng"]],
    "洗礼": [["xǐ"], ["lǐ"]],
    "洗练": [["xǐ"], ["liàn"]],
    "洗煤": [["xǐ"], ["méi"]],
    "洗牌": [["xǐ"], ["pái"]],
    "洗钱": [["xǐ"], ["qián"]],
    "洗三": [["xǐ"], ["sān"]],
    "洗手": [["xǐ"], ["shǒu"]],
    "洗漱": [["xǐ"], ["shù"]],
    "洗刷": [["xǐ"], ["shuā"]],
    "洗涮": [["xǐ"], ["shuàn"]],
    "洗烫": [["xǐ"], ["tàng"]],
    "洗头": [["xǐ"], ["tóu"]],
    "洗脱": [["xǐ"], ["tuō"]],
    "洗胃": [["xǐ"], ["wèi"]],
    "洗洗": [["xǐ"], ["xǐ"]],
    "洗雪": [["xǐ"], ["xuě"]],
    "洗印": [["xǐ"], ["yìn"]],
    "洗浴": [["xǐ"], ["yù"]],
    "洗衣": [["xǐ"], ["yī"]],
    "洗冤": [["xǐ"], ["yuān"]],
    "洗澡": [["xǐ"], ["zǎo"]],
    "洗濯": [["xǐ"], ["zhuó"]],
    "喜好": [["xǐ"], ["hào"]],
    "喜乐": [["xǐ"], ["lè"]],
    "喜帖": [["xǐ"], ["tiě"]],
    "喜信": [["xǐ"], ["xìn"]],
    "喜兴": [["xǐ"], ["xìng"]],
    "喜雨": [["xǐ"], ["yǔ"]],
    "戏班": [["xì"], ["bān"]],
    "戏本": [["xì"], ["běn"]],
    "戏场": [["xì"], ["chǎng"]],
    "戏词": [["xì"], ["cí"]],
    "戏单": [["xì"], ["dān"]],
    "戏法": [["xì"], ["fǎ"]],
    "戏剧": [["xì"], ["jù"]],
    "戏楼": [["xì"], ["lóu"]],
    "戏路": [["xì"], ["lù"]],
    "戏码": [["xì"], ["mǎ"]],
    "戏迷": [["xì"], ["mí"]],
    "戏目": [["xì"], ["mù"]],
    "戏弄": [["xì"], ["nòng"]],
    "戏评": [["xì"], ["píng"]],
    "戏耍": [["xì"], ["shuǎ"]],
    "戏曲": [["xì"], ["qǔ"]],
    "戏水": [["xì"], ["shuǐ"]],
    "戏说": [["xì"], ["shuō"]],
    "戏台": [["xì"], ["tái"]],
    "戏文": [["xì"], ["wén"]],
    "戏侮": [["xì"], ["wǔ"]],
    "戏箱": [["xì"], ["xiāng"]],
    "戏谑": [["xì"], ["xuè"]],
    "戏言": [["xì"], ["yán"]],
    "戏衣": [["xì"], ["yī"]],
    "戏院": [["xì"], ["yuàn"]],
    "戏照": [["xì"], ["zhào"]],
    "戏装": [["xì"], ["zhuāng"]],
    "戏子": [["xì"], ["zǐ"]],
    "系泊": [["jì"], ["bó"]],
    "系词": [["xì"], ["cí"]],
    "系带": [["jì"], ["dài"]],
    "系缚": [["xì"], ["fù"]],
    "系恋": [["xì"], ["liàn"]],
    "系列": [["xì"], ["liè"]],
    "系谱": [["xì"], ["pǔ"]],
    "系念": [["xì"], ["niàn"]],
    "系绳": [["jì"], ["shéng"]],
    "系数": [["xì"], ["shù"]],
    "系统": [["xì"], ["tǒng"]],
    "细长": [["xì"], ["cháng"]],
    "细别": [["xì"], ["bié"]],
    "细读": [["xì"], ["dú"]],
    "细发": [["xì"], ["fà"]],
    "细节": [["xì"], ["jié"]],
    "细菌": [["xì"], ["jūn"]],
    "细看": [["xì"], ["kàn"]],
    "细说": [["xì"], ["shuō"]],
    "细挑": [["xì"], ["tāo"]],
    "细条": [["xì"], ["tiáo"]],
    "细雨": [["xì"], ["yǔ"]],
    "细语": [["xì"], ["yǔ"]],
    "虾蟆": [["há"], ["má"]],
    "隙缝": [["xì"], ["fèng"]],
    "瞎说": [["xiā"], ["shuō"]],
    "瞎炮": [["xiā"], ["pào"]],
    "侠骨": [["xiá"], ["gǔ"]],
    "侠女": [["xiá"], ["nǚ"]],
    "狭巷": [["xiá"], ["xiàng"]],
    "狭长": [["xiá"], ["cháng"]],
    "狭缝": [["xiá"], ["fèng"]],
    "遐思": [["xiá"], ["sī"]],
    "辖区": [["xiá"], ["qū"]],
    "霞石": [["xiá"], ["shí"]],
    "下场": [["xià"], ["chǎng"]],
    "下车": [["xià"], ["chē"]],
    "下乘": [["xià"], ["shèng"]],
    "下处": [["xià"], ["chǔ"]],
    "下调": [["xià"], ["diào"]],
    "下地": [["xià"], ["dì"]],
    "下毒": [["xià"], ["dú"]],
    "下发": [["xià"], ["fā"]],
    "下风": [["xià"], ["fēng"]],
    "下颌": [["xià"], ["hé"]],
    "下家": [["xià"], ["jiā"]],
    "下降": [["xià"], ["jiàng"]],
    "下劲": [["xià"], ["jìn"]],
    "下令": [["xià"], ["lìng"]],
    "下落": [["xià"], ["luò"]],
    "下铺": [["xià"], ["pù"]],
    "下台": [["xià"], ["tái"]],
    "下体": [["xià"], ["tǐ"]],
    "下帖": [["xià"], ["tiě"]],
    "下同": [["xià"], ["tóng"]],
    "下头": [["xià"], ["tou"]],
    "下泄": [["xià"], ["xiè"]],
    "下行": [["xià"], ["xíng"]],
    "下咽": [["xià"], ["yàn"]],
    "下雨": [["xià"], ["yǔ"]],
    "下种": [["xià"], ["zhǒng"]],
    "下属": [["xià"], ["shǔ"]],
    "吓唬": [["xià"], ["hu"]],
    "吓人": [["xià"], ["rén"]],
    "夏侯": [["xià"], ["hóu"]],
    "夏令": [["xià"], ["lìng"]],
    "夏种": [["xià"], ["zhòng"]],
    "仙乐": [["xiān"], ["lè"]],
    "仙女": [["xiān"], ["nǚ"]],
    "仙术": [["xiān"], ["shù"]],
    "仙台": [["xiān"], ["tái"]],
    "先夫": [["xiān"], ["fū"]],
    "先父": [["xiān"], ["fù"]],
    "先觉": [["xiān"], ["jué"]],
    "先见": [["xiān"], ["jiàn"]],
    "先令": [["xiān"], ["lìng"]],
    "先期": [["xiān"], ["qī"]],
    "先头": [["xiān"], ["tóu"]],
    "先王": [["xiān"], ["wáng"]],
    "先行": [["xiān"], ["xíng"]],
    "先知": [["xiān"], ["zhī"]],
    "纤长": [["xiān"], ["cháng"]],
    "纤尘": [["xiān"], ["chén"]],
    "纤度": [["xiān"], ["dù"]],
    "纤夫": [["qiàn"], ["fū"]],
    "纤毫": [["xiān"], ["háo"]],
    "纤毛": [["xiān"], ["máo"]],
    "纤巧": [["xiān"], ["qiǎo"]],
    "纤柔": [["xiān"], ["róu"]],
    "纤弱": [["xiān"], ["ruò"]],
    "纤手": [["qiàn"], ["shǒu"]],
    "纤绳": [["qiàn"], ["shéng"]],
    "纤瘦": [["xiān"], ["shòu"]],
    "纤微": [["xiān"], ["wēi"]],
    "纤悉": [["xiān"], ["xī"]],
    "纤维": [["xiān"], ["wéi"]],
    "纤细": [["xiān"], ["xì"]],
    "纤纤": [["xiān"], ["xiān"]],
    "纤小": [["xiān"], ["xiǎo"]],
    "纤秀": [["xiān"], ["xiù"]],
    "祆教": [["xiān"], ["jiào"]],
    "鲜卑": [["xiān"], ["bēi"]],
    "鲜果": [["xiān"], ["guǒ"]],
    "鲜红": [["xiān"], ["hóng"]],
    "鲜花": [["xiān"], ["huā"]],
    "鲜活": [["xiān"], ["huó"]],
    "鲜货": [["xiān"], ["huò"]],
    "鲜丽": [["xiān"], ["lì"]],
    "鲜亮": [["xiān"], ["liàng"]],
    "鲜灵": [["xiān"], ["líng"]],
    "鲜绿": [["xiān"], ["lǜ"]],
    "鲜美": [["xiān"], ["měi"]],
    "鲜明": [["xiān"], ["míng"]],
    "鲜嫩": [["xiān"], ["nèn"]],
    "鲜润": [["xiān"], ["rùn"]],
    "鲜食": [["xiān"], ["shí"]],
    "鲜甜": [["xiān"], ["tián"]],
    "鲜味": [["xiān"], ["wèi"]],
    "鲜血": [["xiān"], ["xuè"]],
    "鲜妍": [["xiān"], ["yán"]],
    "鲜艳": [["xiān"], ["yàn"]],
    "鲜鱼": [["xiān"], ["yú"]],
    "闲空": [["xián"], ["kòng"]],
    "闲散": [["xián"], ["sǎn"]],
    "弦乐": [["xián"], ["yuè"]],
    "贤弟": [["xián"], ["dì"]],
    "贤能": [["xián"], ["néng"]],
    "贤契": [["xián"], ["qì"]],
    "嫌恶": [["xián"], ["wù"]],
    "嫌疑": [["xián"], ["yí"]],
    "显得": [["xiǎn"], ["de"]],
    "显豁": [["xiǎn"], ["huò"]],
    "显见": [["xiǎn"], ["jiàn"]],
    "显露": [["xiǎn"], ["lù"]],
    "显要": [["xiǎn"], ["yào"]],
    "显能": [["xiǎn"], ["néng"]],
    "显著": [["xiǎn"], ["zhù"]],
    "险地": [["xiǎn"], ["dì"]],
    "险恶": [["xiǎn"], ["è"]],
    "险毒": [["xiǎn"], ["dú"]],
    "险些": [["xiǎn"], ["xiē"]],
    "险要": [["xiǎn"], ["yào"]],
    "险症": [["xiǎn"], ["zhèng"]],
    "县长": [["xiàn"], ["zhǎng"]],
    "县城": [["xiàn"], ["chéng"]],
    "县份": [["xiàn"], ["fèn"]],
    "县官": [["xiàn"], ["guān"]],
    "县令": [["xiàn"], ["lìng"]],
    "县委": [["xiàn"], ["wěi"]],
    "县尉": [["xiàn"], ["wèi"]],
    "县县": [["xiàn"], ["xiàn"]],
    "县志": [["xiàn"], ["zhì"]],
    "县治": [["xiàn"], ["zhì"]],
    "现场": [["xiàn"], ["chǎng"]],
    "现地": [["xiàn"], ["dì"]],
    "现量": [["xiàn"], ["liàng"]],
    "现期": [["xiàn"], ["qī"]],
    "现任": [["xiàn"], ["rèn"]],
    "现行": [["xiàn"], ["xíng"]],
    "现有": [["xiàn"], ["yǒu"]],
    "线圈": [["xiàn"], ["quān"]],
    "线呢": [["xiàn"], ["ne"]],
    "线条": [["xiàn"], ["tiáo"]],
    "线头": [["xiàn"], ["tóu"]],
    "限度": [["xiàn"], ["dù"]],
    "线轴": [["xiàn"], ["zhóu"]],
    "限价": [["xiàn"], ["jià"]],
    "限量": [["xiàn"], ["liàng"]],
    "限令": [["xiàn"], ["lìng"]],
    "限期": [["xiàn"], ["qī"]],
    "陷落": [["xiàn"], ["luò"]],
    "陷没": [["xiàn"], ["méi"]],
    "献上": [["xiàn"], ["shàng"]],
    "献血": [["xiàn"], ["xuè"]],
    "霰弹": [["xiàn"], ["dàn"]],
    "乡长": [["xiāng"], ["cháng"]],
    "乡间": [["xiāng"], ["jiān"]],
    "乡丁": [["xiāng"], ["dīng"]],
    "乡亲": [["xiāng"], ["qīn"]],
    "乡思": [["xiāng"], ["sī"]],
    "乡曲": [["xiāng"], ["qū"]],
    "乡约": [["xiāng"], ["yuē"]],
    "相安": [["xiāng"], ["ān"]],
    "相爱": [["xiāng"], ["ài"]],
    "相帮": [["xiāng"], ["bāng"]],
    "相伴": [["xiāng"], ["bàn"]],
    "相悖": [["xiāng"], ["bèi"]],
    "相比": [["xiāng"], ["bǐ"]],
    "相册": [["xiàng"], ["cè"]],
    "相差": [["xiāng"], ["chà"]],
    "相称": [["xiāng"], ["chèn"]],
    "相成": [["xiāng"], ["chéng"]],
    "相承": [["xiāng"], ["chéng"]],
    "相乘": [["xiāng"], ["chéng"]],
    "相持": [["xiāng"], ["chí"]],
    "相传": [["xiāng"], ["chuán"]],
    "相处": [["xiāng"], ["chǔ"]],
    "相待": [["xiāng"], ["dài"]],
    "相当": [["xiāng"], ["dāng"]],
    "相得": [["xiāng"], ["de"]],
    "相抵": [["xiāng"], ["dǐ"]],
    "相等": [["xiāng"], ["děng"]],
    "相对": [["xiāng"], ["duì"]],
    "相烦": [["xiāng"], ["fán"]],
    "相反": [["xiāng"], ["fǎn"]],
    "相逢": [["xiāng"], ["féng"]],
    "相仿": [["xiāng"], ["fǎng"]],
    "相符": [["xiāng"], ["fú"]],
    "相干": [["xiāng"], ["gān"]],
    "相隔": [["xiāng"], ["gé"]],
    "相顾": [["xiāng"], ["gù"]],
    "相公": [["xiàng"], ["gōng"]],
    "相关": [["xiāng"], ["guān"]],
    "相国": [["xiàng"], ["guó"]],
    "相好": [["xiāng"], ["hǎo"]],
    "相互": [["xiāng"], ["hù"]],
    "相会": [["xiāng"], ["huì"]],
    "相合": [["xiāng"], ["hé"]],
    "相机": [["xiàng"], ["jī"]],
    "相继": [["xiāng"], ["jì"]],
    "相间": [["xiāng"], ["jiàn"]],
    "相见": [["xiāng"], ["jiàn"]],
    "相交": [["xiāng"], ["jiāo"]],
    "相角": [["xiàng"], ["jiǎo"]],
    "相接": [["xiāng"], ["jiē"]],
    "相近": [["xiāng"], ["jìn"]],
    "相救": [["xiāng"], ["jiù"]],
    "相距": [["xiāng"], ["jù"]],
    "相聚": [["xiāng"], ["jù"]],
    "相看": [["xiāng"], ["kàn"]],
    "相克": [["xiāng"], ["kè"]],
    "相类": [["xiāng"], ["lèi"]],
    "相连": [["xiāng"], ["lián"]],
    "相恋": [["xiāng"], ["liàn"]],
    "相邻": [["xiāng"], ["lín"]],
    "相率": [["xiāng"], ["shuài"]],
    "相马": [["xiàng"], ["mǎ"]],
    "相貌": [["xiàng"], ["mào"]],
    "相面": [["xiàng"], ["miàn"]],
    "相命": [["xiāng"], ["mìng"]],
    "相配": [["xiāng"], ["pèi"]],
    "相碰": [["xiāng"], ["pèng"]],
    "相片": [["xiàng"], ["piān"]],
    "相契": [["xiāng"], ["qì"]],
    "相扑": [["xiàng"], ["pū"]],
    "相亲": [["xiāng"], ["qīn"]],
    "相去": [["xiāng"], ["qù"]],
    "相让": [["xiāng"], ["ràng"]],
    "相劝": [["xiāng"], ["quàn"]],
    "相扰": [["xiāng"], ["rǎo"]],
    "相认": [["xiāng"], ["rèn"]],
    "相容": [["xiāng"], ["róng"]],
    "相商": [["xiāng"], ["shāng"]],
    "相若": [["xiāng"], ["ruò"]],
    "相生": [["xiāng"], ["shēng"]],
    "相声": [["xiàng"], ["sheng"]],
    "相识": [["xiāng"], ["shí"]],
    "相士": [["xiàng"], ["shì"]],
    "相视": [["xiāng"], ["shì"]],
    "相书": [["xiāng"], ["shū"]],
    "相熟": [["xiāng"], ["shú"]],
    "相术": [["xiāng"], ["shù"]],
    "相思": [["xiāng"], ["sī"]],
    "相似": [["xiāng"], ["sì"]],
    "相态": [["xiāng"], ["tài"]],
    "相随": [["xiāng"], ["suí"]],
    "相通": [["xiāng"], ["tōng"]],
    "相同": [["xiāng"], ["tóng"]],
    "相投": [["xiāng"], ["tóu"]],
    "相图": [["xiàng"], ["tú"]],
    "相托": [["xiāng"], ["tuō"]],
    "相望": [["xiāng"], ["wàng"]],
    "相违": [["xiāng"], ["wéi"]],
    "相位": [["xiàng"], ["wèi"]],
    "相向": [["xiāng"], ["xiàng"]],
    "相像": [["xiāng"], ["xiàng"]],
    "相偕": [["xiāng"], ["xié"]],
    "相形": [["xiāng"], ["xíng"]],
    "相信": [["xiāng"], ["xìn"]],
    "相许": [["xiāng"], ["xǔ"]],
    "相沿": [["xiāng"], ["yán"]],
    "相依": [["xiāng"], ["yī"]],
    "相宜": [["xiāng"], ["yí"]],
    "相异": [["xiāng"], ["yì"]],
    "相应": [["xiāng"], ["yìng"]],
    "相映": [["xiāng"], ["yìng"]],
    "相与": [["xiāng"], ["yǔ"]],
    "相约": [["xiāng"], ["yuē"]],
    "相遇": [["xiāng"], ["yù"]],
    "相悦": [["xiāng"], ["yuè"]],
    "相争": [["xiāng"], ["zhēng"]],
    "相纸": [["xiàng"], ["zhǐ"]],
    "相知": [["xiāng"], ["zhī"]],
    "相中": [["xiāng"], ["zhòng"]],
    "相助": [["xiāng"], ["zhù"]],
    "相撞": [["xiāng"], ["zhuàng"]],
    "相左": [["xiāng"], ["zuǒ"]],
    "香臭": [["xiāng"], ["chòu"]],
    "香槟": [["xiāng"], ["bīn"]],
    "香干": [["xiāng"], ["gān"]],
    "香肚": [["xiāng"], ["dù"]],
    "香港": [["xiāng"], ["gǎng"]],
    "香会": [["xiāng"], ["huì"]],
    "香囊": [["xiāng"], ["náng"]],
    "香片": [["xiāng"], ["piàn"]],
    "湘语": [["xiāng"], ["yǔ"]],
    "香泽": [["xiāng"], ["zé"]],
    "箱底": [["xiāng"], ["dǐ"]],
    "箱笼": [["xiāng"], ["lǒng"]],
    "襄助": [["xiāng"], ["zhù"]],
    "详备": [["xiáng"], ["bèi"]],
    "详察": [["xiáng"], ["chá"]],
    "详解": [["xiáng"], ["jiě"]],
    "详尽": [["xiáng"], ["jìn"]],
    "详密": [["xiáng"], ["mì"]],
    "详略": [["xiáng"], ["lüè"]],
    "详明": [["xiáng"], ["míng"]],
    "详实": [["xiáng"], ["shí"]],
    "详情": [["xiáng"], ["qíng"]],
    "详述": [["xiáng"], ["shù"]],
    "详谈": [["xiáng"], ["tán"]],
    "详悉": [["xiáng"], ["xī"]],
    "详细": [["xiáng"], ["xì"]],
    "祥和": [["xiáng"], ["hé"]],
    "享乐": [["xiǎng"], ["lè"]],
    "享有": [["xiǎng"], ["yǒu"]],
    "响度": [["xiǎng"], ["dù"]],
    "响头": [["xiǎng"], ["tóu"]],
    "响应": [["xiǎng"], ["yìng"]],
    "想见": [["xiǎng"], ["jiàn"]],
    "想头": [["xiǎng"], ["tou"]],
    "想要": [["xiǎng"], ["yào"]],
    "想着": [["xiǎng"], ["zhe"]],
    "向背": [["xiàng"], ["bèi"]],
    "向着": [["xiàng"], ["zhe"]],
    "向上": [["xiàng"], ["shàng"]],
    "巷道": [["hàng"], ["dào"]],
    "巷口": [["xiàng"], ["kǒu"]],
    "巷陌": [["xiàng"], ["mò"]],
    "巷战": [["xiàng"], ["zhàn"]],
    "项背": [["xiàng"], ["bèi"]],
    "巷子": [["xiàng"], ["zi"]],
    "项圈": [["xiàng"], ["quān"]],
    "像片": [["xiàng"], ["piàn"]],
    "枭将": [["xiāo"], ["jiāng"]],
    "削壁": [["xuē"], ["bì"]],
    "削除": [["xuē"], ["chú"]],
    "削发": [["xuē"], ["fà"]],
    "削价": [["xuē"], ["jià"]],
    "削肩": [["xuē"], ["jiān"]],
    "削减": [["xuē"], ["jiǎn"]],
    "削皮": [["xiāo"], ["pí"]],
    "削平": [["xuē"], ["píng"]],
    "削弱": [["xuē"], ["ruò"]],
    "削职": [["xuē"], ["zhí"]],
    "削瘦": [["xuē"], ["shòu"]],
    "削削": [["xuē"], ["xuē"]],
    "骁将": [["xiāo"], ["jiàng"]],
    "宵旰": [["xiāo"], ["gàn"]],
    "宵禁": [["xiāo"], ["jìn"]],
    "消长": [["xiāo"], ["zhǎng"]],
    "消毒": [["xiāo"], ["dú"]],
    "消化": [["xiāo"], ["huà"]],
    "消解": [["xiāo"], ["jiě"]],
    "消磨": [["xiāo"], ["mó"]],
    "消散": [["xiāo"], ["sàn"]],
    "消食": [["xiāo"], ["shí"]],
    "消亡": [["xiāo"], ["wáng"]],
    "硝化": [["xiāo"], ["huà"]],
    "硝石": [["xiāo"], ["shí"]],
    "销差": [["xiāo"], ["chà"]],
    "销钉": [["xiāo"], ["dīng"]],
    "销号": [["xiāo"], ["hào"]],
    "销价": [["xiāo"], ["jià"]],
    "销假": [["xiāo"], ["jià"]],
    "销量": [["xiāo"], ["liàng"]],
    "销行": [["xiāo"], ["xíng"]],
    "潇洒": [["xiāo"], ["sǎ"]],
    "小便": [["xiǎo"], ["biàn"]],
    "小别": [["xiǎo"], ["bié"]],
    "小车": [["xiǎo"], ["chē"]],
    "小乘": [["xiǎo"], ["chéng"]],
    "小传": [["xiǎo"], ["zhuàn"]],
    "小弟": [["xiǎo"], ["dì"]],
    "小调": [["xiǎo"], ["diào"]],
    "小过": [["xiǎo"], ["guò"]],
    "小号": [["xiǎo"], ["hào"]],
    "小角": [["xiǎo"], ["jiǎo"]],
    "小将": [["xiǎo"], ["jiàng"]],
    "小教": [["xiǎo"], ["jiào"]],
    "小节": [["xiǎo"], ["jié"]],
    "小解": [["xiǎo"], ["jiě"]],
    "小结": [["xiǎo"], ["jié"]],
    "小楷": [["xiǎo"], ["kǎi"]],
    "小看": [["xiǎo"], ["kàn"]],
    "小量": [["xiǎo"], ["liàng"]],
    "小可": [["xiǎo"], ["kě"]],
    "小令": [["xiǎo"], ["lìng"]],
    "小女": [["xiǎo"], ["nǚ"]],
    "小跑": [["xiǎo"], ["pǎo"]],
    "小区": [["xiǎo"], ["qū"]],
    "小曲": [["xiǎo"], ["qǔ"]],
    "小觑": [["xiǎo"], ["qù"]],
    "小食": [["xiǎo"], ["shí"]],
    "小数": [["xiǎo"], ["shù"]],
    "小说": [["xiǎo"], ["shuō"]],
    "小体": [["xiǎo"], ["tǐ"]],
    "小头": [["xiǎo"], ["tóu"]],
    "小王": [["xiǎo"], ["wáng"]],
    "小戏": [["xiǎo"], ["xì"]],
    "小枝": [["xiǎo"], ["zhī"]],
    "小雨": [["xiǎo"], ["yǔ"]],
    "小卒": [["xiǎo"], ["zú"]],
    "晓得": [["xiǎo"], ["de"]],
    "孝弟": [["xiào"], ["dì"]],
    "孝服": [["xiào"], ["fú"]],
    "孝女": [["xiào"], ["nǚ"]],
    "孝行": [["xiào"], ["xíng"]],
    "肖像": [["xiào"], ["xiàng"]],
    "效率": [["xiào"], ["lǜ"]],
    "效能": [["xiào"], ["néng"]],
    "校本": [["xiào"], ["běn"]],
    "校场": [["jiào"], ["chǎng"]],
    "效应": [["xiào"], ["yìng"]],
    "校长": [["xiào"], ["zhǎng"]],
    "校点": [["jiào"], ["diǎn"]],
    "校订": [["jiào"], ["dìng"]],
    "校对": [["jiào"], ["duì"]],
    "校风": [["xiào"], ["fēng"]],
    "校服": [["xiào"], ["fú"]],
    "校改": [["jiào"], ["gǎi"]],
    "校歌": [["xiào"], ["gē"]],
    "校工": [["xiào"], ["gōng"]],
    "校官": [["xiào"], ["guān"]],
    "校规": [["xiào"], ["guī"]],
    "校核": [["jiào"], ["hé"]],
    "校花": [["xiào"], ["huā"]],
    "校徽": [["xiào"], ["huī"]],
    "校勘": [["jiào"], ["kān"]],
    "校刊": [["xiào"], ["kān"]],
    "校旗": [["xiào"], ["qí"]],
    "校庆": [["xiào"], ["qìng"]],
    "校舍": [["xiào"], ["shè"]],
    "校尉": [["xiào"], ["wèi"]],
    "校务": [["xiào"], ["wù"]],
    "校训": [["xiào"], ["xùn"]],
    "校验": [["jiào"], ["yàn"]],
    "校医": [["xiào"], ["yī"]],
    "校样": [["jiào"], ["yàng"]],
    "校友": [["xiào"], ["yǒu"]],
    "校园": [["xiào"], ["yuán"]],
    "校阅": [["jiào"], ["yuè"]],
    "校正": [["jiào"], ["zhèng"]],
    "校址": [["xiào"], ["zhǐ"]],
    "校注": [["jiào"], ["zhù"]],
    "校准": [["jiào"], ["zhǔn"]],
    "笑场": [["xiào"], ["chǎng"]],
    "笑纹": [["xiào"], ["wén"]],
    "笑语": [["xiào"], ["yǔ"]],
    "些个": [["xiē"], ["gè"]],
    "些小": [["xiē"], ["xiǎo"]],
    "些微": [["xiē"], ["wēi"]],
    "些须": [["xiē"], ["xū"]],
    "些许": [["xiē"], ["xǔ"]],
    "歇凉": [["xiē"], ["liáng"]],
    "歇宿": [["xiē"], ["sù"]],
    "歇枝": [["xiē"], ["zhī"]],
    "协调": [["xié"], ["tiáo"]],
    "协和": [["xié"], ["hé"]],
    "协会": [["xié"], ["huì"]],
    "协约": [["xié"], ["yuē"]],
    "协同": [["xié"], ["tóng"]],
    "协助": [["xié"], ["zhù"]],
    "邪财": [["xié"], ["cái"]],
    "邪道": [["xié"], ["dào"]],
    "邪恶": [["xié"], ["è"]],
    "邪乎": [["xié"], ["hū"]],
    "邪火": [["xié"], ["huǒ"]],
    "邪路": [["xié"], ["lù"]],
    "邪教": [["xié"], ["jiào"]],
    "邪门": [["xié"], ["mén"]],
    "邪魔": [["xié"], ["mó"]],
    "邪念": [["xié"], ["niàn"]],
    "邪气": [["xié"], ["qì"]],
    "邪说": [["xié"], ["shuō"]],
    "邪祟": [["xié"], ["suì"]],
    "邪心": [["xié"], ["xīn"]],
    "邪行": [["xié"], ["xíng"]],
    "胁从": [["xié"], ["cóng"]],
    "胁迫": [["xié"], ["pò"]],
    "挟持": [["xié"], ["chí"]],
    "挟带": [["xié"], ["dài"]],
    "挟嫌": [["xié"], ["xián"]],
    "挟制": [["xié"], ["zhì"]],
    "偕行": [["xié"], ["xíng"]],
    "鞋底": [["xié"], ["dǐ"]],
    "鞋刷": [["xié"], ["shuā"]],
    "写家": [["xiě"], ["jiā"]],
    "写信": [["xiě"], ["xìn"]],
    "写景": [["xiě"], ["jǐng"]],
    "泄沓": [["xiè"], ["tà"]],
    "泄底": [["xiè"], ["dǐ"]],
    "泄愤": [["xiè"], ["fèn"]],
    "泄恨": [["xiè"], ["hèn"]],
    "泄劲": [["xiè"], ["jìn"]],
    "泄洪": [["xiè"], ["hóng"]],
    "泄漏": [["xiè"], ["lòu"]],
    "泄露": [["xiè"], ["lòu"]],
    "泄密": [["xiè"], ["mì"]],
    "泄气": [["xiè"], ["qì"]],
    "泄水": [["xiè"], ["shuǐ"]],
    "泄泻": [["xiè"], ["xiè"]],
    "泻肚": [["xiè"], ["dù"]],
    "卸车": [["xiè"], ["chē"]],
    "卸任": [["xiè"], ["rèn"]],
    "卸载": [["xiè"], ["zǎi"]],
    "亵渎": [["xiè"], ["dú"]],
    "谢帖": [["xiè"], ["tiě"]],
    "心传": [["xīn"], ["chuán"]],
    "心得": [["xīn"], ["dé"]],
    "心底": [["xīn"], ["dǐ"]],
    "心毒": [["xīn"], ["dú"]],
    "心地": [["xīn"], ["dì"]],
    "心服": [["xīn"], ["fú"]],
    "心结": [["xīn"], ["jié"]],
    "心劲": [["xīn"], ["jìn"]],
    "心率": [["xīn"], ["lǜ"]],
    "心切": [["xīn"], ["qiè"]],
    "心曲": [["xīn"], ["qǔ"]],
    "心上": [["xīn"], ["shàng"]],
    "心术": [["xīn"], ["shù"]],
    "心数": [["xīn"], ["shù"]],
    "心思": [["xīn"], ["sī"]],
    "心头": [["xīn"], ["tóu"]],
    "心跳": [["xīn"], ["tiào"]],
    "心王": [["xīn"], ["wáng"]],
    "心许": [["xīn"], ["xǔ"]],
    "心血": [["xīn"], ["xuè"]],
    "心疑": [["xīn"], ["yí"]],
    "心折": [["xīn"], ["zhé"]],
    "心中": [["xīn"], ["zhōng"]],
    "心重": [["xīn"], ["zhòng"]],
    "芯子": [["xìn"], ["zǐ"]],
    "莘莘": [["shēn"], ["shēn"]],
    "新丁": [["xīn"], ["dīng"]],
    "新风": [["xīn"], ["fēng"]],
    "新化": [["xīn"], ["huà"]],
    "新疆": [["xīn"], ["jiāng"]],
    "新教": [["xīn"], ["jiào"]],
    "新郎": [["xīn"], ["láng"]],
    "新乐": [["xīn"], ["lè"]],
    "新绿": [["xīn"], ["lǜ"]],
    "新奇": [["xīn"], ["qí"]],
    "新区": [["xīn"], ["qū"]],
    "新任": [["xīn"], ["rèn"]],
    "新鲜": [["xīn"], ["xiān"]],
    "新兴": [["xīn"], ["xīng"]],
    "新雨": [["xīn"], ["yǔ"]],
    "新正": [["xīn"], ["zhēnɡ"]],
    "新语": [["xīn"], ["yǔ"]],
    "新知": [["xīn"], ["zhī"]],
    "薪传": [["xīn"], ["chuán"]],
    "薪给": [["xīn"], ["gěi"]],
    "信笔": [["xìn"], ["bǐ"]],
    "信标": [["xìn"], ["biāo"]],
    "信从": [["xìn"], ["cóng"]],
    "信差": [["xìn"], ["chāi"]],
    "信步": [["xìn"], ["bù"]],
    "信贷": [["xìn"], ["dài"]],
    "信道": [["xìn"], ["dào"]],
    "信访": [["xìn"], ["fǎng"]],
    "信风": [["xìn"], ["fēng"]],
    "信奉": [["xìn"], ["fèng"]],
    "信封": [["xìn"], ["fēng"]],
    "信服": [["xìn"], ["fú"]],
    "信函": [["xìn"], ["hán"]],
    "信鸽": [["xìn"], ["gē"]],
    "信号": [["xìn"], ["hào"]],
    "信笺": [["xìn"], ["jiān"]],
    "信汇": [["xìn"], ["huì"]],
    "信件": [["xìn"], ["jiàn"]],
    "信教": [["xìn"], ["jiào"]],
    "信据": [["xìn"], ["jù"]],
    "信口": [["xìn"], ["kǒu"]],
    "信赖": [["xìn"], ["lài"]],
    "信念": [["xìn"], ["niàn"]],
    "信女": [["xìn"], ["nǚ"]],
    "信任": [["xìn"], ["rèn"]],
    "信石": [["xìn"], ["shí"]],
    "信实": [["xìn"], ["shí"]],
    "信史": [["xìn"], ["shǐ"]],
    "信使": [["xìn"], ["shǐ"]],
    "信士": [["xìn"], ["shì"]],
    "信手": [["xìn"], ["shǒu"]],
    "信守": [["xìn"], ["shǒu"]],
    "信条": [["xìn"], ["tiáo"]],
    "信筒": [["xìn"], ["tǒng"]],
    "信徒": [["xìn"], ["tú"]],
    "信托": [["xìn"], ["tuō"]],
    "信物": [["xìn"], ["wù"]],
    "信息": [["xìn"], ["xī"]],
    "信箱": [["xìn"], ["xiāng"]],
    "信心": [["xìn"], ["xīn"]],
    "信邪": [["xìn"], ["xié"]],
    "信仰": [["xìn"], ["yǎng"]],
    "信用": [["xìn"], ["yòng"]],
    "信义": [["xìn"], ["yì"]],
    "信誉": [["xìn"], ["yù"]],
    "信纸": [["xìn"], ["zhǐ"]],
    "信札": [["xìn"], ["zhá"]],
    "兴安": [["xīng"], ["ān"]],
    "兴办": [["xīng"], ["bàn"]],
    "兴邦": [["xīng"], ["bāng"]],
    "兴兵": [["xīng"], ["bīng"]],
    "兴城": [["xīng"], ["chéng"]],
    "兴废": [["xīng"], ["fèi"]],
    "兴奋": [["xīng"], ["fèn"]],
    "兴革": [["xīng"], ["gé"]],
    "兴工": [["xīng"], ["gōng"]],
    "兴国": [["xīng"], ["guó"]],
    "兴化": [["xīng"], ["huà"]],
    "兴会": [["xìng"], ["huì"]],
    "兴建": [["xīng"], ["jiàn"]],
    "兴隆": [["xīng"], ["lóng"]],
    "兴平": [["xīng"], ["píng"]],
    "兴起": [["xīng"], ["qǐ"]],
    "兴趣": [["xìng"], ["qù"]],
    "兴盛": [["xīng"], ["shèng"]],
    "兴师": [["xīng"], ["shī"]],
    "兴衰": [["xīng"], ["shuāi"]],
    "兴叹": [["xīng"], ["tàn"]],
    "兴替": [["xīng"], ["tì"]],
    "兴头": [["xìng"], ["tou"]],
    "兴亡": [["xīng"], ["wáng"]],
    "兴旺": [["xīng"], ["wàng"]],
    "兴味": [["xìng"], ["wèi"]],
    "兴文": [["xīng"], ["wén"]],
    "兴修": [["xīng"], ["xiū"]],
    "兴许": [["xīng"], ["xǔ"]],
    "兴学": [["xīng"], ["xué"]],
    "兴业": [["xīng"], ["yè"]],
    "兴义": [["xīng"], ["yì"]],
    "兴致": [["xìng"], ["zhì"]],
    "兴筑": [["xīng"], ["zhù"]],
    "星斗": [["xīng"], ["dǒu"]],
    "星号": [["xīng"], ["hào"]],
    "星空": [["xīng"], ["kōng"]],
    "星期": [["xīng"], ["qī"]],
    "星散": [["xīng"], ["sàn"]],
    "星宿": [["xīng"], ["xiù"]],
    "星体": [["xīng"], ["tǐ"]],
    "星系": [["xīng"], ["xì"]],
    "星相": [["xīng"], ["xiàng"]],
    "星占": [["xīng"], ["zhān"]],
    "惺忪": [["xīng"], ["sōng"]],
    "猩红": [["xīng"], ["hóng"]],
    "腥臭": [["xīng"], ["chòu"]],
    "腥臊": [["xīng"], ["sāo"]],
    "腥膻": [["xīng"], ["shān"]],
    "刑场": [["xíng"], ["chǎng"]],
    "刑期": [["xíng"], ["qī"]],
    "刑种": [["xíng"], ["zhǒng"]],
    "行板": [["xíng"], ["bǎn"]],
    "行帮": [["háng"], ["bāng"]],
    "行辈": [["háng"], ["bèi"]],
    "行笔": [["xíng"], ["bǐ"]],
    "行草": [["xíng"], ["cǎo"]],
    "行藏": [["xíng"], ["cáng"]],
    "行车": [["xíng"], ["chē"]],
    "行船": [["xíng"], ["chuán"]],
    "行程": [["xíng"], ["chéng"]],
    "行刺": [["xíng"], ["cì"]],
    "行当": [["háng"], ["dāng"]],
    "行道": [["háng"], ["dào"]],
    "行都": [["xíng"], ["dū"]],
    "行动": [["xíng"], ["dòng"]],
    "行东": [["xíng"], ["dōng"]],
    "行房": [["xíng"], ["fáng"]],
    "行贩": [["xíng"], ["fàn"]],
    "行风": [["xíng"], ["fēng"]],
    "行宫": [["xíng"], ["gōng"]],
    "行规": [["háng"], ["guī"]],
    "行好": [["xíng"], ["hǎo"]],
    "行号": [["háng"], ["háo"]],
    "行话": [["háng"], ["huà"]],
    "行会": [["háng"], ["huì"]],
    "行贿": [["xíng"], ["huì"]],
    "行货": [["háng"], ["huò"]],
    "行迹": [["xíng"], ["jì"]],
    "行家": [["háng"], ["jiā"]],
    "行贾": [["xíng"], ["gǔ"]],
    "行将": [["xíng"], ["jiāng"]],
    "行间": [["háng"], ["jiān"]],
    "行脚": [["xíng"], ["jiǎo"]],
    "行劫": [["xíng"], ["jié"]],
    "行进": [["xíng"], ["jìn"]],
    "行径": [["xíng"], ["jìng"]],
    "行经": [["xíng"], ["jīng"]],
    "行距": [["háng"], ["jù"]],
    "行军": [["xíng"], ["jūn"]],
    "行楷": [["xíng"], ["kǎi"]],
    "行款": [["xíng"], ["kuǎn"]],
    "行乐": [["xíng"], ["lè"]],
    "行李": [["xíng"], ["lǐ"]],
    "行礼": [["xíng"], ["lǐ"]],
    "行列": [["háng"], ["liè"]],
    "行猎": [["xíng"], ["liè"]],
    "行令": [["xíng"], ["lìng"]],
    "行路": [["xíng"], ["lù"]],
    "行旅": [["xíng"], ["lǚ"]],
    "行囊": [["xíng"], ["náng"]],
    "行年": [["xíng"], ["nián"]],
    "行聘": [["xíng"], ["pìn"]],
    "行骗": [["xíng"], ["piàn"]],
    "行期": [["xíng"], ["qī"]],
    "行乞": [["xíng"], ["qǐ"]],
    "行抢": [["xíng"], ["qiǎng"]],
    "行腔": [["xíng"], ["qiāng"]],
    "行窃": [["xíng"], ["qiè"]],
    "行箧": [["xíng"], ["qiè"]],
    "行情": [["háng"], ["qíng"]],
    "行人": [["xíng"], ["rén"]],
    "行色": [["xíng"], ["sè"]],
    "行善": [["xíng"], ["shàn"]],
    "行商": [["háng"], ["shāng"]],
    "行赏": [["xíng"], ["shǎng"]],
    "行省": [["xíng"], ["shěng"]],
    "行时": [["xíng"], ["shí"]],
    "行使": [["xíng"], ["shǐ"]],
    "行驶": [["xíng"], ["shǐ"]],
    "行市": [["háng"], ["shì"]],
    "行事": [["xíng"], ["shì"]],
    "行书": [["xíng"], ["shū"]],
    "行署": [["xíng"], ["shǔ"]],
    "行述": [["xíng"], ["shù"]],
    "行唐": [["xíng"], ["táng"]],
    "行头": [["xíng"], ["tou"]],
    "行为": [["xíng"], ["wéi"]],
    "行文": [["xíng"], ["wén"]],
    "行伍": [["háng"], ["wǔ"]],
    "行销": [["xíng"], ["xiāo"]],
    "行星": [["xíng"], ["xīng"]],
    "行刑": [["xíng"], ["xíng"]],
    "行行": [["xíng"], ["xíng"]],
    "行凶": [["xíng"], ["xiōng"]],
    "行业": [["háng"], ["yè"]],
    "行医": [["xíng"], ["yī"]],
    "行营": [["xíng"], ["yíng"]],
    "行吟": [["xíng"], ["yín"]],
    "行辕": [["xíng"], ["yuán"]],
    "行运": [["xíng"], ["yùn"]],
    "行灶": [["xíng"], ["zào"]],
    "行诈": [["xíng"], ["zhà"]],
    "行栈": [["xíng"], ["zhàn"]],
    "行者": [["xíng"], ["zhě"]],
    "行政": [["xíng"], ["zhèng"]],
    "行止": [["xíng"], ["zhǐ"]],
    "行装": [["xíng"], ["zhuāng"]],
    "行舟": [["xíng"], ["zhōu"]],
    "行状": [["xíng"], ["zhuàng"]],
    "行走": [["xíng"], ["zǒu"]],
    "行踪": [["xíng"], ["zōng"]],
    "邢台": [["xíng"], ["tái"]],
    "形体": [["xíng"], ["tǐ"]],
    "形数": [["xíng"], ["shù"]],
    "形旁": [["xíng"], ["páng"]],
    "形似": [["xíng"], ["sì"]],
    "型钢": [["xíng"], ["gāng"]],
    "形相": [["xíng"], ["xiāng"]],
    "型号": [["xíng"], ["hào"]],
    "醒豁": [["xǐng"], ["huò"]],
    "醒觉": [["xǐng"], ["jué"]],
    "杏红": [["xìng"], ["hóng"]],
    "姓氏": [["xìng"], ["shì"]],
    "幸得": [["xìng"], ["de"]],
    "幸好": [["xìng"], ["hǎo"]],
    "幸会": [["xìng"], ["huì"]],
    "幸甚": [["xìng"], ["shèn"]],
    "性别": [["xìng"], ["bié"]],
    "性行": [["xìng"], ["xíng"]],
    "性能": [["xìng"], ["néng"]],
    "凶暴": [["xiōng"], ["bào"]],
    "凶恶": [["xiōng"], ["è"]],
    "凶横": [["xiōng"], ["hèng"]],
    "凶煞": [["xiōng"], ["shà"]],
    "凶信": [["xiōng"], ["xìn"]],
    "兄长": [["xiōng"], ["zhǎng"]],
    "凶相": [["xiōng"], ["xiàng"]],
    "兄弟": [["xiōng"], ["dì"]],
    "汹涌": [["xiōng"], ["yǒng"]],
    "胸骨": [["xiōng"], ["gǔ"]],
    "胸中": [["xiōng"], ["zhōng"]],
    "雄风": [["xióng"], ["fēng"]],
    "雄大": [["xióng"], ["dà"]],
    "胸椎": [["xiōng"], ["zhuī"]],
    "雄劲": [["xióng"], ["jìng"]],
    "雄奇": [["xióng"], ["qí"]],
    "雄峙": [["xióng"], ["zhì"]],
    "熊猫": [["xióng"], ["māo"]],
    "休班": [["xiū"], ["bān"]],
    "休兵": [["xiū"], ["bīng"]],
    "休耕": [["xiū"], ["gēng"]],
    "休会": [["xiū"], ["huì"]],
    "休假": [["xiū"], ["jià"]],
    "休刊": [["xiū"], ["kān"]],
    "休克": [["xiū"], ["kè"]],
    "休眠": [["xiū"], ["mián"]],
    "休宁": [["xiū"], ["níng"]],
    "休戚": [["xiū"], ["qī"]],
    "休憩": [["xiū"], ["qì"]],
    "休书": [["xiū"], ["shū"]],
    "休息": [["xiū"], ["xī"]],
    "休想": [["xiū"], ["xiǎng"]],
    "休闲": [["xiū"], ["xián"]],
    "休养": [["xiū"], ["yǎng"]],
    "休学": [["xiū"], ["xué"]],
    "休业": [["xiū"], ["yè"]],
    "休战": [["xiū"], ["zhàn"]],
    "休整": [["xiū"], ["zhěng"]],
    "休止": [["xiū"], ["zhǐ"]],
    "修长": [["xiū"], ["cháng"]],
    "修盖": [["xiū"], ["gài"]],
    "修好": [["xiū"], ["hǎo"]],
    "修女": [["xiū"], ["nǚ"]],
    "修正": [["xiū"], ["zhèng"]],
    "修行": [["xiū"], ["xíng"]],
    "修枝": [["xiū"], ["zhī"]],
    "修筑": [["xiū"], ["zhù"]],
    "羞臊": [["xiū"], ["sào"]],
    "羞恶": [["xiū"], ["wù"]],
    "秀发": [["xiù"], ["fā"]],
    "朽坏": [["xiǔ"], ["huài"]],
    "秀丽": [["xiù"], ["lì"]],
    "袖头": [["xiù"], ["tóu"]],
    "盱眙": [["xū"], ["yí"]],
    "锈菌": [["xiù"], ["jūn"]],
    "须要": [["xū"], ["yào"]],
    "须发": [["xū"], ["fà"]],
    "须知": [["xū"], ["zhī"]],
    "虚汗": [["xū"], ["hàn"]],
    "虚空": [["xū"], ["kōng"]],
    "嘘唏": [["xū"], ["xī"]],
    "需要": [["xū"], ["yào"]],
    "许昌": [["xǔ"], ["chāng"]],
    "许多": [["xǔ"], ["duō"]],
    "许婚": [["xǔ"], ["hūn"]],
    "许久": [["xǔ"], ["jiǔ"]],
    "许可": [["xǔ"], ["kě"]],
    "许诺": [["xǔ"], ["nuò"]],
    "许配": [["xǔ"], ["pèi"]],
    "许亲": [["xǔ"], ["qīn"]],
    "许身": [["xǔ"], ["shēn"]],
    "许是": [["xǔ"], ["shì"]],
    "许下": [["xǔ"], ["xià"]],
    "序论": [["xù"], ["lùn"]],
    "许愿": [["xǔ"], ["yuàn"]],
    "序曲": [["xù"], ["qǔ"]],
    "序数": [["xù"], ["shù"]],
    "叙别": [["xù"], ["bié"]],
    "叙说": [["xù"], ["shuō"]],
    "畜产": [["xù"], ["chǎn"]],
    "畜肥": [["chù"], ["féi"]],
    "畜栏": [["chù"], ["lán"]],
    "畜类": [["chù"], ["lèi"]],
    "畜力": [["chù"], ["lì"]],
    "畜牧": [["xù"], ["mù"]],
    "畜圈": [["chù"], ["juàn"]],
    "畜生": [["chù"], ["shēng"]],
    "畜牲": [["chù"], ["shēng"]],
    "畜养": [["xù"], ["yǎng"]],
    "畜疫": [["chù"], ["yì"]],
    "絮叨": [["xù"], ["dáo"]],
    "絮语": [["xù"], ["yǔ"]],
    "嗅觉": [["xiù"], ["jué"]],
    "蓄发": [["xù"], ["fā"]],
    "宣称": [["xuān"], ["chēng"]],
    "宣传": [["xuān"], ["chuán"]],
    "宣读": [["xuān"], ["dú"]],
    "宣教": [["xuān"], ["jiào"]],
    "宣化": [["xuān"], ["huà"]],
    "宣泄": [["xuān"], ["xiè"]],
    "宣召": [["xuān"], ["zhào"]],
    "喧哗": [["xuān"], ["huá"]],
    "喧嚷": [["xuān"], ["rǎng"]],
    "玄参": [["xuán"], ["cān"]],
    "玄奥": [["xuán"], ["ào"]],
    "玄秘": [["xuán"], ["mì"]],
    "玄思": [["xuán"], ["sī"]],
    "玄孙": [["xuán"], ["sūn"]],
    "玄远": [["xuán"], ["yuǎn"]],
    "漩涡": [["xuán"], ["wō"]],
    "选场": [["xuǎn"], ["chǎng"]],
    "选调": [["xuǎn"], ["diào"]],
    "选读": [["xuǎn"], ["dú"]],
    "选票": [["xuǎn"], ["piào"]],
    "选区": [["xuǎn"], ["qū"]],
    "选曲": [["xuǎn"], ["qǔ"]],
    "选任": [["xuǎn"], ["rèn"]],
    "选择": [["xuǎn"], ["zé"]],
    "选种": [["xuǎn"], ["zhǒng"]],
    "炫弄": [["xuàn"], ["nòng"]],
    "绚丽": [["xuàn"], ["lì"]],
    "眩晕": [["xuàn"], ["yūn"]],
    "楦头": [["xuàn"], ["tóu"]],
    "穴头": [["xué"], ["tóu"]],
    "学长": [["xué"], ["zhǎng"]],
    "学分": [["xué"], ["fēn"]],
    "学风": [["xué"], ["fēng"]],
    "学棍": [["xué"], ["gùn"]],
    "学会": [["xué"], ["huì"]],
    "学好": [["xué"], ["hǎo"]],
    "学监": [["xué"], ["jiān"]],
    "学区": [["xué"], ["qū"]],
    "学期": [["xué"], ["qī"]],
    "学识": [["xué"], ["shí"]],
    "学术": [["xué"], ["shù"]],
    "学系": [["xué"], ["xì"]],
    "学校": [["xué"], ["xiào"]],
    "学说": [["xué"], ["shuō"]],
    "学员": [["xué"], ["yuán"]],
    "血癌": [["xuè"], ["ái"]],
    "血案": [["xuè"], ["àn"]],
    "血本": [["xuè"], ["běn"]],
    "血崩": [["xuè"], ["bēng"]],
    "血泊": [["xuè"], ["pō"]],
    "血沉": [["xuè"], ["chén"]],
    "血仇": [["xuè"], ["chóu"]],
    "血防": [["xuè"], ["fáng"]],
    "血汗": [["xuè"], ["hàn"]],
    "血海": [["xuè"], ["hǎi"]],
    "血管": [["xuè"], ["guǎn"]],
    "血痕": [["xuè"], ["hén"]],
    "血红": [["xuè"], ["hóng"]],
    "血花": [["xuè"], ["huā"]],
    "血祭": [["xuè"], ["jì"]],
    "血迹": [["xuè"], ["jì"]],
    "血浆": [["xuè"], ["jiāng"]],
    "血竭": [["xuè"], ["jié"]],
    "血口": [["xuè"], ["kǒu"]],
    "血亏": [["xuè"], ["kuī"]],
    "血泪": [["xuè"], ["lèi"]],
    "血块": [["xuè"], ["kuài"]],
    "血库": [["xuè"], ["kù"]],
    "血流": [["xuè"], ["liú"]],
    "血路": [["xuè"], ["lù"]],
    "血脉": [["xuè"], ["mài"]],
    "血尿": [["xuè"], ["niào"]],
    "血泡": [["xuè"], ["pào"]],
    "血气": [["xuè"], ["qì"]],
    "血亲": [["xuè"], ["qīn"]],
    "血清": [["xuè"], ["qīng"]],
    "血球": [["xuè"], ["qiú"]],
    "血肉": [["xuè"], ["ròu"]],
    "血色": [["xuè"], ["sè"]],
    "血书": [["xuè"], ["shū"]],
    "血栓": [["xuè"], ["shuān"]],
    "血统": [["xuè"], ["tǒng"]],
    "血污": [["xuè"], ["wū"]],
    "血洗": [["xuè"], ["xǐ"]],
    "血水": [["xuè"], ["shuǐ"]],
    "血丝": [["xuè"], ["sī"]],
    "血象": [["xuè"], ["xiàng"]],
    "血腥": [["xuè"], ["xīng"]],
    "血型": [["xuè"], ["xíng"]],
    "血压": [["xuè"], ["yā"]],
    "血虚": [["xuè"], ["xū"]],
    "血性": [["xuè"], ["xìng"]],
    "血液": [["xuè"], ["yè"]],
    "血衣": [["xuè"], ["yī"]],
    "血印": [["xuè"], ["yìn"]],
    "血缘": [["xuè"], ["yuán"]],
    "血债": [["xuè"], ["zhài"]],
    "血晕": [["xiě"], ["yùn"]],
    "血战": [["xuè"], ["zhàn"]],
    "血证": [["xuè"], ["zhèng"]],
    "血肿": [["xuè"], ["zhǒng"]],
    "血渍": [["xuè"], ["zì"]],
    "熏风": [["xūn"], ["fēng"]],
    "熏染": [["xūn"], ["rǎn"]],
    "熏陶": [["xūn"], ["táo"]],
    "熏香": [["xūn"], ["xiāng"]],
    "熏熏": [["xūn"], ["xūn"]],
    "熏制": [["xūn"], ["zhì"]],
    "熏蒸": [["xūn"], ["zhēng"]],
    "薰风": [["xūn"], ["fēng"]],
    "寻见": [["xún"], ["jiàn"]],
    "寻思": [["xín"], ["sī"]],
    "巡查": [["xún"], ["zhā"]],
    "巡风": [["xún"], ["fēng"]],
    "巡行": [["xún"], ["xíng"]],
    "巡更": [["xún"], ["gēng"]],
    "驯服": [["xùn"], ["fú"]],
    "驯化": [["xùn"], ["huà"]],
    "询查": [["xún"], ["zhā"]],
    "训令": [["xùn"], ["lìng"]],
    "训条": [["xùn"], ["tiáo"]],
    "迅跑": [["xùn"], ["pǎo"]],
    "讯号": [["xùn"], ["hào"]],
    "汛期": [["xùn"], ["qī"]],
    "殉教": [["xùn"], ["jiào"]],
    "殉节": [["xùn"], ["jié"]],
    "丫杈": [["yā"], ["chà"]],
    "殉难": [["xùn"], ["nàn"]],
    "压板": [["yà"], ["bǎn"]],
    "丫头": [["yā"], ["tou"]],
    "压场": [["yā"], ["chǎng"]],
    "压车": [["yā"], ["chē"]],
    "压秤": [["yā"], ["chèng"]],
    "压船": [["yā"], ["chuán"]],
    "压倒": [["yā"], ["dǎo"]],
    "压队": [["yā"], ["duì"]],
    "压顶": [["yā"], ["dǐng"]],
    "压服": [["yā"], ["fú"]],
    "压港": [["yā"], ["gǎng"]],
    "压光": [["yā"], ["guāng"]],
    "压货": [["yā"], ["huò"]],
    "压价": [["yā"], ["jià"]],
    "压惊": [["yā"], ["jīng"]],
    "压境": [["yā"], ["jìng"]],
    "压卷": [["yā"], ["juàn"]],
    "压力": [["yā"], ["lì"]],
    "压平": [["yā"], ["píng"]],
    "压迫": [["yā"], ["pò"]],
    "压气": [["yā"], ["qì"]],
    "压强": [["yā"], ["qiáng"]],
    "压缩": [["yā"], ["suō"]],
    "压台": [["yā"], ["tái"]],
    "压条": [["yā"], ["tiáo"]],
    "压头": [["yā"], ["tóu"]],
    "压痛": [["yā"], ["tòng"]],
    "压压": [["yā"], ["yā"]],
    "压腿": [["yā"], ["tuǐ"]],
    "压抑": [["yā"], ["yì"]],
    "压延": [["yā"], ["yán"]],
    "压榨": [["yā"], ["zhà"]],
    "压制": [["yā"], ["zhì"]],
    "压阵": [["yā"], ["zhèn"]],
    "压轴": [["yā"], ["zhòu"]],
    "押车": [["yā"], ["chē"]],
    "呀呀": [["yā"], ["yā"]],
    "押当": [["yā"], ["dàng"]],
    "押解": [["yā"], ["jiè"]],
    "押禁": [["yā"], ["jìn"]],
    "押头": [["yā"], ["tou"]],
    "押尾": [["yā"], ["wěi"]],
    "鸦片": [["yā"], ["piàn"]],
    "桠杈": [["yā"], ["chà"]],
    "桠枝": [["yā"], ["zhī"]],
    "牙缝": [["yá"], ["fèng"]],
    "牙膏": [["yá"], ["gāo"]],
    "牙石": [["yá"], ["shí"]],
    "牙龈": [["yá"], ["yín"]],
    "牙刷": [["yá"], ["shuā"]],
    "衙内": [["yá"], ["nèi"]],
    "哑巴": [["yǎ"], ["bā"]],
    "哑场": [["yǎ"], ["chǎng"]],
    "哑火": [["yǎ"], ["huǒ"]],
    "哑剧": [["yǎ"], ["jù"]],
    "哑口": [["yǎ"], ["kǒu"]],
    "哑铃": [["yǎ"], ["líng"]],
    "哑谜": [["yǎ"], ["mí"]],
    "哑炮": [["yǎ"], ["pào"]],
    "哑然": [["yǎ"], ["rán"]],
    "哑哑": [["yā"], ["yā"]],
    "哑语": [["yǎ"], ["yǔ"]],
    "雅称": [["yǎ"], ["chēng"]],
    "哑子": [["yǎ"], ["zǐ"]],
    "雅观": [["yǎ"], ["guān"]],
    "雅号": [["yǎ"], ["hào"]],
    "雅乐": [["yǎ"], ["yuè"]],
    "雅量": [["yǎ"], ["liàng"]],
    "雅趣": [["yǎ"], ["qù"]],
    "雅思": [["yǎ"], ["sī"]],
    "雅兴": [["yǎ"], ["xìng"]],
    "雅正": [["yǎ"], ["zhèng"]],
    "亚当": [["yà"], ["dāng"]],
    "咽喉": [["yān"], ["hóu"]],
    "咽气": [["yàn"], ["qì"]],
    "咽头": [["yān"], ["tóu"]],
    "咽炎": [["yān"], ["yán"]],
    "烟斗": [["yān"], ["dǒu"]],
    "烟毒": [["yān"], ["dú"]],
    "烟膏": [["yān"], ["gāo"]],
    "烟泡": [["yān"], ["pào"]],
    "烟卷": [["yān"], ["juàn"]],
    "烟头": [["yān"], ["tóu"]],
    "烟叶": [["yān"], ["yè"]],
    "烟熏": [["yān"], ["xūn"]],
    "烟雨": [["yān"], ["yǔ"]],
    "胭红": [["yān"], ["hóng"]],
    "淹埋": [["yān"], ["mái"]],
    "淹没": [["yān"], ["mò"]],
    "淹溺": [["yān"], ["nì"]],
    "湮没": [["yān"], ["mò"]],
    "湮灭": [["yān"], ["miè"]],
    "腌菜": [["yān"], ["cài"]],
    "腌肉": [["yān"], ["ròu"]],
    "腌臜": [["ā"], ["zā"]],
    "腌制": [["yān"], ["zhì"]],
    "嫣红": [["yān"], ["hóng"]],
    "腌渍": [["yān"], ["zì"]],
    "延长": [["yán"], ["cháng"]],
    "延搁": [["yán"], ["gē"]],
    "延期": [["yán"], ["qī"]],
    "严查": [["yán"], ["zhā"]],
    "严处": [["yán"], ["chǔ"]],
    "严禁": [["yán"], ["jìn"]],
    "严父": [["yán"], ["fù"]],
    "严苛": [["yán"], ["kē"]],
    "严令": [["yán"], ["lìng"]],
    "严正": [["yán"], ["zhèng"]],
    "严重": [["yán"], ["zhòng"]],
    "妍丽": [["yán"], ["lì"]],
    "芫花": [["yuán"], ["huā"]],
    "芫荽": [["yán"], ["sui"]],
    "言和": [["yán"], ["hé"]],
    "言传": [["yán"], ["chuán"]],
    "言教": [["yán"], ["jiào"]],
    "言论": [["yán"], ["lùn"]],
    "言说": [["yán"], ["shuō"]],
    "言语": [["yán"], ["yǔ"]],
    "言行": [["yán"], ["xíng"]],
    "言重": [["yán"], ["zhòng"]],
    "言中": [["yán"], ["zhōng"]],
    "岩浆": [["yán"], ["jiāng"]],
    "岩石": [["yán"], ["shí"]],
    "岩羊": [["yán"], ["yáng"]],
    "沿条": [["yán"], ["tiáo"]],
    "炎凉": [["yán"], ["liáng"]],
    "沿着": [["yán"], ["zhe"]],
    "炎症": [["yán"], ["zhèng"]],
    "研读": [["yán"], ["dú"]],
    "研究": [["yán"], ["jiū"]],
    "研磨": [["yán"], ["mó"]],
    "研拟": [["yán"], ["nǐ"]],
    "研求": [["yán"], ["qiú"]],
    "研判": [["yán"], ["pàn"]],
    "研讨": [["yán"], ["tǎo"]],
    "研析": [["yán"], ["xī"]],
    "研习": [["yán"], ["xí"]],
    "研制": [["yán"], ["zhì"]],
    "盐场": [["yán"], ["chǎng"]],
    "盐分": [["yán"], ["fèn"]],
    "檐头": [["yán"], ["tóu"]],
    "颜体": [["yán"], ["tǐ"]],
    "奄然": [["yǎn"], ["rán"]],
    "奄忽": [["yǎn"], ["hū"]],
    "衍射": [["yǎn"], ["shè"]],
    "奄奄": [["yǎn"], ["yǎn"]],
    "眼见": [["yǎn"], ["jiàn"]],
    "演化": [["yǎn"], ["huà"]],
    "演说": [["yǎn"], ["shuō"]],
    "演戏": [["yǎn"], ["xì"]],
    "演员": [["yǎn"], ["yuán"]],
    "厌恶": [["yàn"], ["wù"]],
    "砚石": [["yàn"], ["shí"]],
    "砚台": [["yàn"], ["tāi"]],
    "宴会": [["yàn"], ["huì"]],
    "宴乐": [["yàn"], ["lè"]],
    "艳称": [["yàn"], ["chēng"]],
    "艳服": [["yàn"], ["fú"]],
    "艳红": [["yàn"], ["hóng"]],
    "艳丽": [["yàn"], ["lì"]],
    "验查": [["yàn"], ["zhā"]],
    "验核": [["yàn"], ["hé"]],
    "验看": [["yàn"], ["kàn"]],
    "验票": [["yàn"], ["piào"]],
    "验血": [["yàn"], ["xuè"]],
    "雁行": [["yàn"], ["háng"]],
    "燕儿": [["yàn"], ["ér"]],
    "燕尔": [["yàn"], ["ěr"]],
    "燕京": [["yān"], ["jīng"]],
    "燕居": [["yàn"], ["jū"]],
    "燕麦": [["yān"], ["mài"]],
    "燕雀": [["yàn"], ["què"]],
    "燕山": [["yān"], ["shān"]],
    "燕尾": [["yàn"], ["wěi"]],
    "燕赵": [["yān"], ["zhào"]],
    "燕子": [["yàn"], ["zi"]],
    "燕窝": [["yàn"], ["wō"]],
    "扬长": [["yáng"], ["cháng"]],
    "扬场": [["yáng"], ["cháng"]],
    "羊肠": [["yáng"], ["cháng"]],
    "羊城": [["yáng"], ["chéng"]],
    "羊齿": [["yáng"], ["chǐ"]],
    "羊羔": [["yáng"], ["gāo"]],
    "羊羹": [["yáng"], ["gēng"]],
    "羊工": [["yáng"], ["gōng"]],
    "羊倌": [["yáng"], ["guān"]],
    "羊角": [["yáng"], ["jiǎo"]],
    "羊毛": [["yáng"], ["máo"]],
    "羊毫": [["yáng"], ["háo"]],
    "羊膜": [["yáng"], ["mó"]],
    "羊圈": [["yáng"], ["juàn"]],
    "羊水": [["yáng"], ["shuǐ"]],
    "羊桃": [["yáng"], ["táo"]],
    "羊头": [["yáng"], ["tóu"]],
    "羊脂": [["yáng"], ["zhī"]],
    "阳间": [["yáng"], ["jiān"]],
    "阳台": [["yáng"], ["tái"]],
    "佯称": [["yáng"], ["chēng"]],
    "洋场": [["yáng"], ["chǎng"]],
    "洋车": [["yáng"], ["chē"]],
    "洋服": [["yáng"], ["fú"]],
    "洋红": [["yáng"], ["hóng"]],
    "洋化": [["yáng"], ["huà"]],
    "洋相": [["yáng"], ["xiàng"]],
    "洋行": [["yáng"], ["háng"]],
    "仰承": [["yǎng"], ["chéng"]],
    "仰给": [["yǎng"], ["jǐ"]],
    "仰光": [["yǎng"], ["guāng"]],
    "仰角": [["yǎng"], ["jiǎo"]],
    "仰赖": [["yǎng"], ["lài"]],
    "仰面": [["yǎng"], ["miàn"]],
    "仰慕": [["yǎng"], ["mù"]],
    "仰视": [["yǎng"], ["shì"]],
    "仰首": [["yǎng"], ["shǒu"]],
    "仰天": [["yǎng"], ["tiān"]],
    "仰卧": [["yǎng"], ["wò"]],
    "仰望": [["yǎng"], ["wàng"]],
    "仰泳": [["yǎng"], ["yǒng"]],
    "仰仗": [["yǎng"], ["zhàng"]],
    "养分": [["yǎng"], ["fèn"]],
    "养父": [["yǎng"], ["fù"]],
    "养家": [["yǎng"], ["jiā"]],
    "养女": [["yǎng"], ["nǚ"]],
    "养畜": [["yǎng"], ["chù"]],
    "养殖": [["yǎng"], ["zhí"]],
    "氧化": [["yǎng"], ["huà"]],
    "样片": [["yàng"], ["piàn"]],
    "夭矫": [["yāo"], ["jiǎo"]],
    "夭折": [["yāo"], ["zhé"]],
    "夭亡": [["yāo"], ["wáng"]],
    "吆喝": [["yāo"], ["he"]],
    "妖风": [["yāo"], ["fēng"]],
    "妖女": [["yāo"], ["nǚ"]],
    "妖娆": [["yāo"], ["ráo"]],
    "妖术": [["yāo"], ["shù"]],
    "腰背": [["yāo"], ["bèi"]],
    "腰杆": [["yāo"], ["gǎn"]],
    "腰俞": [["yāo"], ["yú"]],
    "邀约": [["yāo"], ["yuē"]],
    "腰椎": [["yāo"], ["zhuī"]],
    "谣风": [["yáo"], ["fēng"]],
    "谣传": [["yáo"], ["chuán"]],
    "摇晃": [["yáo"], ["huàng"]],
    "摇头": [["yáo"], ["tóu"]],
    "摇椅": [["yáo"], ["yǐ"]],
    "遥远": [["yáo"], ["yuǎn"]],
    "繇役": [["yáo"], ["yì"]],
    "咬合": [["yǎo"], ["hé"]],
    "窈窕": [["yǎo"], ["tiǎo"]],
    "药厂": [["yào"], ["chǎng"]],
    "药单": [["yào"], ["dān"]],
    "药膏": [["yào"], ["gāo"]],
    "药捻": [["yào"], ["niǎn"]],
    "药片": [["yào"], ["piàn"]],
    "药石": [["yào"], ["shí"]],
    "药铺": [["yào"], ["pù"]],
    "药王": [["yào"], ["wáng"]],
    "要隘": [["yào"], ["ài"]],
    "要道": [["yào"], ["dào"]],
    "要不": [["yào"], ["bù"]],
    "要冲": [["yào"], ["chōng"]],
    "要得": [["yào"], ["de"]],
    "要地": [["yào"], ["dì"]],
    "要点": [["yào"], ["diǎn"]],
    "要端": [["yào"], ["duān"]],
    "要犯": [["yào"], ["fàn"]],
    "要饭": [["yào"], ["fàn"]],
    "要害": [["yào"], ["hài"]],
    "要谎": [["yào"], ["huǎng"]],
    "要好": [["yāo"], ["hǎo"]],
    "要击": [["yāo"], ["jī"]],
    "要件": [["yào"], ["jiàn"]],
    "要价": [["yào"], ["jià"]],
    "要津": [["yào"], ["jīn"]],
    "要紧": [["yào"], ["jǐn"]],
    "要诀": [["yào"], ["jué"]],
    "要览": [["yào"], ["lǎn"]],
    "要脸": [["yào"], ["liǎn"]],
    "要领": [["yào"], ["lǐng"]],
    "要路": [["yào"], ["lù"]],
    "要略": [["yào"], ["lüè"]],
    "要么": [["yào"], ["me"]],
    "要命": [["yào"], ["mìng"]],
    "要目": [["yào"], ["mù"]],
    "要钱": [["yào"], ["qián"]],
    "要强": [["yào"], ["qiáng"]],
    "要人": [["yào"], ["rén"]],
    "要求": [["yāo"], ["qiú"]],
    "要塞": [["yào"], ["sài"]],
    "要事": [["yào"], ["shì"]],
    "要是": [["yào"], ["shì"]],
    "要死": [["yào"], ["sǐ"]],
    "要素": [["yào"], ["sù"]],
    "要图": [["yào"], ["tú"]],
    "要位": [["yào"], ["wèi"]],
    "要闻": [["yào"], ["wén"]],
    "要挟": [["yāo"], ["xié"]],
    "要务": [["yào"], ["wù"]],
    "要言": [["yào"], ["yán"]],
    "要义": [["yào"], ["yì"]],
    "要员": [["yào"], ["yuán"]],
    "要约": [["yào"], ["yuē"]],
    "要则": [["yào"], ["zé"]],
    "要职": [["yào"], ["zhí"]],
    "要账": [["yào"], ["zhàng"]],
    "要旨": [["yào"], ["zhǐ"]],
    "要子": [["yào"], ["zǐ"]],
    "耶教": [["yē"], ["jiào"]],
    "耶稣": [["yē"], ["sū"]],
    "也罢": [["yě"], ["bà"]],
    "也好": [["yě"], ["hǎo"]],
    "也许": [["yě"], ["xǔ"]],
    "业大": [["yè"], ["dà"]],
    "叶柄": [["yè"], ["bǐng"]],
    "叶蜂": [["yè"], ["fēng"]],
    "叶猴": [["yè"], ["hóu"]],
    "叶轮": [["yè"], ["lún"]],
    "叶脉": [["yè"], ["mài"]],
    "叶面": [["yè"], ["miàn"]],
    "叶片": [["yè"], ["piàn"]],
    "叶鞘": [["yè"], ["qiào"]],
    "叶肉": [["yè"], ["ròu"]],
    "叶酸": [["yè"], ["suān"]],
    "叶序": [["yè"], ["xù"]],
    "叶叶": [["yè"], ["yè"]],
    "叶腋": [["yè"], ["yè"]],
    "叶韵": [["xié"], ["yùn"]],
    "叶枝": [["yè"], ["zhī"]],
    "叶子": [["yè"], ["zi"]],
    "夜叉": [["yè"], ["chā"]],
    "夜场": [["yè"], ["chǎng"]],
    "夜车": [["yè"], ["chē"]],
    "夜大": [["yè"], ["dà"]],
    "夜蛾": [["yè"], ["é"]],
    "夜分": [["yè"], ["fēn"]],
    "夜间": [["yè"], ["jiān"]],
    "夜禁": [["yè"], ["jìn"]],
    "夜景": [["yè"], ["jǐng"]],
    "夜空": [["yè"], ["kōng"]],
    "夜曲": [["yè"], ["qǔ"]],
    "夜校": [["yè"], ["xiào"]],
    "夜行": [["yè"], ["xíng"]],
    "腋臭": [["yè"], ["chòu"]],
    "一并": [["yī"], ["bìng"]],
    "一场": [["yī"], ["chǎng"]],
    "一朝": [["yī"], ["zhāo"]],
    "一撮": [["yī"], ["zuǒ"]],
    "一打": [["yī"], ["dǎ"]],
    "一得": [["yī"], ["de"]],
    "一度": [["yí"], ["dù"]],
    "一发": [["yī"], ["fà"]],
    "一番": [["yī"], ["fān"]],
    "一分": [["yī"], ["fēn"]],
    "一份": [["yī"], ["fèn"]],
    "一服": [["yī"], ["fù"]],
    "一干": [["yī"], ["gān"]],
    "一副": [["yī"], ["fù"]],
    "一个": [["yí"], ["gè"]],
    "一共": [["yī"], ["gòng"]],
    "一号": [["yī"], ["hào"]],
    "一晃": [["yī"], ["huǎng"]],
    "一家": [["yī"], ["jiā"]],
    "一会": [["yī"], ["huì"]],
    "一卷": [["yī"], ["juàn"]],
    "一觉": [["yī"], ["jiào"]],
    "一片": [["yī"], ["piàn"]],
    "一期": [["yī"], ["qī"]],
    "一齐": [["yī"], ["qí"]],
    "一切": [["yī"], ["qiè"]],
    "一任": [["yī"], ["rèn"]],
    "一似": [["yī"], ["sì"]],
    "一宿": [["yī"], ["xiǔ"]],
    "一体": [["yī"], ["tǐ"]],
    "一条": [["yī"], ["tiáo"]],
    "一同": [["yī"], ["tóng"]],
    "一头": [["yī"], ["tóu"]],
    "一些": [["yī"], ["xiē"]],
    "一行": [["yī"], ["xíng"]],
    "一应": [["yī"], ["yīng"]],
    "一种": [["yī"], ["zhǒng"]],
    "伊吾": [["yī"], ["wú"]],
    "衣蛾": [["yī"], ["é"]],
    "衣分": [["yī"], ["fēn"]],
    "衣服": [["yī"], ["fú"]],
    "衣冠": [["yì"], ["guān"]],
    "衣柜": [["yī"], ["guì"]],
    "衣裳": [["yī"], ["shang"]],
    "衣食": [["yī"], ["shí"]],
    "衣着": [["yī"], ["zhuó"]],
    "医家": [["yī"], ["jiā"]],
    "医术": [["yī"], ["shù"]],
    "依从": [["yī"], ["cóng"]],
    "依据": [["yī"], ["jù"]],
    "咿呀": [["yī"], ["yā"]],
    "依约": [["yī"], ["yuē"]],
    "仪节": [["yí"], ["jié"]],
    "怡和": [["yí"], ["hé"]],
    "迤逦": [["yǐ"], ["lǐ"]],
    "姨夫": [["yí"], ["fū"]],
    "姨父": [["yí"], ["fù"]],
    "遗毒": [["yí"], ["dú"]],
    "遗传": [["yí"], ["chuán"]],
    "遗风": [["yí"], ["fēng"]],
    "遗骨": [["yí"], ["gǔ"]],
    "遗落": [["yí"], ["luò"]],
    "遗尿": [["yí"], ["niào"]],
    "遗少": [["yí"], ["shào"]],
    "遗体": [["yí"], ["tǐ"]],
    "遗属": [["yí"], ["shǔ"]],
    "疑案": [["yí"], ["àn"]],
    "疑兵": [["yí"], ["bīng"]],
    "疑点": [["yí"], ["diǎn"]],
    "疑窦": [["yí"], ["dòu"]],
    "疑惑": [["yí"], ["huò"]],
    "疑忌": [["yí"], ["jì"]],
    "疑惧": [["yí"], ["jù"]],
    "疑虑": [["yí"], ["lǜ"]],
    "疑难": [["yí"], ["nán"]],
    "疑念": [["yí"], ["niàn"]],
    "疑团": [["yí"], ["tuán"]],
    "疑似": [["yí"], ["sì"]],
    "疑问": [["yí"], ["wèn"]],
    "疑心": [["yí"], ["xīn"]],
    "疑义": [["yí"], ["yì"]],
    "疑云": [["yí"], ["yún"]],
    "疑阵": [["yí"], ["zhèn"]],
    "以便": [["yǐ"], ["biàn"]],
    "以还": [["yǐ"], ["huán"]],
    "以内": [["yǐ"], ["nèi"]],
    "以期": [["yǐ"], ["qī"]],
    "以上": [["yǐ"], ["shàng"]],
    "以为": [["yǐ"], ["wéi"]],
    "迆逦": [["yǐ"], ["lǐ"]],
    "倚重": [["yǐ"], ["zhòng"]],
    "蚁王": [["yǐ"], ["wáng"]],
    "义女": [["yì"], ["nǚ"]],
    "义行": [["yì"], ["xíng"]],
    "亿万": [["yì"], ["wàn"]],
    "艺能": [["yì"], ["néng"]],
    "艺术": [["yì"], ["shù"]],
    "议长": [["yì"], ["cháng"]],
    "议场": [["yì"], ["chǎng"]],
    "议和": [["yì"], ["hé"]],
    "议会": [["yì"], ["huì"]],
    "议价": [["yì"], ["jià"]],
    "议论": [["yì"], ["lùn"]],
    "议员": [["yì"], ["yuán"]],
    "异地": [["yì"], ["dì"]],
    "异化": [["yì"], ["huà"]],
    "异读": [["yì"], ["dú"]],
    "异见": [["yì"], ["jiàn"]],
    "异教": [["yì"], ["jiào"]],
    "异能": [["yì"], ["néng"]],
    "异趣": [["yì"], ["qù"]],
    "异说": [["yì"], ["shuō"]],
    "异同": [["yì"], ["tóng"]],
    "佚失": [["yì"], ["shī"]],
    "佚文": [["yì"], ["wén"]],
    "役畜": [["yì"], ["xù"]],
    "呓语": [["yì"], ["yǔ"]],
    "译员": [["yì"], ["yuán"]],
    "译著": [["yì"], ["zhù"]],
    "易地": [["yì"], ["dì"]],
    "驿卒": [["yì"], ["zú"]],
    "疫疠": [["yì"], ["lì"]],
    "疫区": [["yì"], ["qū"]],
    "益处": [["yì"], ["chù"]],
    "益发": [["yì"], ["fā"]],
    "逸乐": [["yì"], ["lè"]],
    "意会": [["yì"], ["huì"]],
    "意见": [["yì"], ["jiàn"]],
    "意趣": [["yì"], ["qù"]],
    "意思": [["yì"], ["sī"]],
    "意识": [["yì"], ["shí"]],
    "意兴": [["yì"], ["xìng"]],
    "溢价": [["yì"], ["jià"]],
    "意中": [["yì"], ["zhōng"]],
    "翼侧": [["yì"], ["cè"]],
    "臆度": [["yì"], ["duó"]],
    "臆见": [["yì"], ["jiàn"]],
    "臆说": [["yì"], ["shuō"]],
    "因数": [["yīn"], ["shù"]],
    "因为": [["yīn"], ["wèi"]],
    "因应": [["yīn"], ["yìng"]],
    "阴毒": [["yīn"], ["dú"]],
    "阴风": [["yīn"], ["fēng"]],
    "阴干": [["yīn"], ["gàn"]],
    "阴核": [["yīn"], ["hé"]],
    "阴间": [["yīn"], ["jiān"]],
    "阴凉": [["yīn"], ["liáng"]],
    "阴模": [["yīn"], ["mó"]],
    "阴囊": [["yīn"], ["náng"]],
    "阴雨": [["yīn"], ["yǔ"]],
    "姻亲": [["yīn"], ["qīn"]],
    "荫庇": [["yìn"], ["bì"]],
    "荫蔽": [["yīn"], ["bì"]],
    "荫凉": [["yìn"], ["liáng"]],
    "音叉": [["yīn"], ["chā"]],
    "荫翳": [["yīn"], ["yì"]],
    "音调": [["yīn"], ["diào"]],
    "音读": [["yīn"], ["dú"]],
    "音乐": [["yīn"], ["yuè"]],
    "音节": [["yīn"], ["jié"]],
    "音量": [["yīn"], ["liàng"]],
    "音频": [["yīn"], ["pín"]],
    "音强": [["yīn"], ["qiáng"]],
    "音区": [["yīn"], ["qū"]],
    "殷富": [["yīn"], ["fù"]],
    "殷红": [["yān"], ["hóng"]],
    "音信": [["yīn"], ["xìn"]],
    "殷鉴": [["yīn"], ["jiàn"]],
    "殷切": [["yīn"], ["qiè"]],
    "殷勤": [["yīn"], ["qín"]],
    "殷商": [["yīn"], ["shāng"]],
    "殷实": [["yīn"], ["shí"]],
    "殷墟": [["yīn"], ["xū"]],
    "殷忧": [["yīn"], ["yōu"]],
    "殷殷": [["yīn"], ["yīn"]],
    "溵溜": [["yīn"], ["liū"]],
    "吟哦": [["yín"], ["é"]],
    "淫雨": [["yín"], ["yǔ"]],
    "引发": [["yǐn"], ["fā"]],
    "引得": [["yǐn"], ["de"]],
    "引号": [["yǐn"], ["hào"]],
    "引见": [["yǐn"], ["jiàn"]],
    "引颈": [["yǐn"], ["jǐng"]],
    "引信": [["yǐn"], ["xìn"]],
    "引语": [["yǐn"], ["yǔ"]],
    "引种": [["yǐn"], ["zhǒng"]],
    "吲哚": [["yǐn"], ["duǒ"]],
    "饮弹": [["yǐn"], ["dàn"]],
    "饮食": [["yǐn"], ["shí"]],
    "饮片": [["yǐn"], ["piàn"]],
    "隐蔽": [["yǐn"], ["bì"]],
    "瘾头": [["yǐn"], ["tóu"]],
    "印发": [["yìn"], ["fā"]],
    "印度": [["yìn"], ["dù"]],
    "印泥": [["yìn"], ["ní"]],
    "印刷": [["yìn"], ["shuā"]],
    "印台": [["yìn"], ["tái"]],
    "印纹": [["yìn"], ["wén"]],
    "印信": [["yìn"], ["xìn"]],
    "印行": [["yìn"], ["xíng"]],
    "应变": [["yìng"], ["biàn"]],
    "应承": [["yìng"], ["chéng"]],
    "应酬": [["yìng"], ["chóu"]],
    "应从": [["yìng"], ["cóng"]],
    "应当": [["yīng"], ["dāng"]],
    "应得": [["yīng"], ["de"]],
    "应答": [["yìng"], ["dá"]],
    "应对": [["yìng"], ["duì"]],
    "应敌": [["yìng"], ["dí"]],
    "应付": [["yìng"], ["fù"]],
    "应分": [["yīng"], ["fèn"]],
    "应和": [["yìng"], ["hè"]],
    "应急": [["yìng"], ["jí"]],
    "应该": [["yīng"], ["gāi"]],
    "应接": [["yìng"], ["jiē"]],
    "应举": [["yìng"], ["jǔ"]],
    "应届": [["yīng"], ["jiè"]],
    "应景": [["yìng"], ["jǐng"]],
    "应卯": [["yìng"], ["mǎo"]],
    "应考": [["yìng"], ["kǎo"]],
    "应募": [["yìng"], ["mù"]],
    "应门": [["yìng"], ["mén"]],
    "应诺": [["yìng"], ["nuò"]],
    "应聘": [["yìng"], ["pìn"]],
    "应声": [["yīng"], ["shēng"]],
    "应时": [["yìng"], ["shí"]],
    "应市": [["yìng"], ["shì"]],
    "应试": [["yìng"], ["shì"]],
    "应手": [["yìng"], ["shǒu"]],
    "应许": [["yīng"], ["xǔ"]],
    "应选": [["yìng"], ["xuǎn"]],
    "应验": [["yìng"], ["yàn"]],
    "应邀": [["yìng"], ["yāo"]],
    "应用": [["yìng"], ["yòng"]],
    "应有": [["yīng"], ["yǒu"]],
    "应约": [["yìng"], ["yuē"]],
    "应允": [["yīng"], ["yǔn"]],
    "应战": [["yìng"], ["zhàn"]],
    "应运": [["yìng"], ["yùn"]],
    "应召": [["yìng"], ["zhào"]],
    "应诊": [["yìng"], ["zhěn"]],
    "应征": [["yìng"], ["zhēng"]],
    "应徵":  [["yìng "], ["zhǐ"]],
    "应制": [["yìng"], ["zhì"]],
    "英尺": [["yīng"], ["chǐ"]],
    "英华": [["yīng"], ["huá"]],
    "英石": [["yīng"], ["shí"]],
    "英语": [["yīng"], ["yǔ"]],
    "莺语": [["yīng"], ["yǔ"]],
    "迎风": [["yíng"], ["fēng"]],
    "迎合": [["yíng"], ["hé"]],
    "鹰爪": [["yīng"], ["zhǎo"]],
    "迎亲": [["yíng"], ["qīn"]],
    "迎头": [["yíng"], ["tóu"]],
    "茔地": [["yíng"], ["dì"]],
    "荥阳": [["xíng"], ["yáng"]],
    "荧屏": [["yíng"], ["píng,yíng"], ["mù"]],
    "赢得": [["yíng"], ["de"]],
    "蝇头": [["yíng"], ["tóu"]],
    "赢家": [["yíng"], ["jiā"]],
    "瀛台": [["yíng"], ["tái"]],
    "影调": [["yǐng"], ["diào"]],
    "影片": [["yǐng"], ["piān"]],
    "影区": [["yǐng"], ["qū"]],
    "影戏": [["yǐng"], ["xì"]],
    "影射": [["yǐng"], ["shè"]],
    "映射": [["yìng"], ["shè"]],
    "佣工": [["yōng"], ["gōng"]],
    "佣金": [["yòng"], ["jīn"]],
    "佣钱": [["yòng"], ["qián"]],
    "佣人": [["yōng"], ["rén"]],
    "拥塞": [["yōng"], ["sè"]],
    "拥有": [["yōng"], ["yǒu"]],
    "庸碌": [["yōng"], ["lù"]],
    "雍和": [["yōng"], ["hé"]],
    "雍正": [["yōng"], ["zhèng"]],
    "壅塞": [["yōng"], ["sè"]],
    "永别": [["yǒng"], ["bié"]],
    "永宁": [["yǒng"], ["níng"]],
    "永远": [["yǒng"], ["yuǎn"]],
    "勇夫": [["yǒng"], ["fū"]],
    "涌出": [["yǒng"], ["chū"]],
    "涌进": [["yǒng"], ["jìn"]],
    "涌浪": [["yǒng"], ["làng"]],
    "涌流": [["yǒng"], ["liú"]],
    "涌泉": [["yǒng"], ["quán"]],
    "涌现": [["yǒng"], ["xiàn"]],
    "蛹期": [["yǒng"], ["qī"]],
    "用场": [["yòng"], ["chǎng"]],
    "用处": [["yòng"], ["chǔ"]],
    "用度": [["yòng"], ["dù"]],
    "用劲": [["yòng"], ["jìn"]],
    "用语": [["yòng"], ["yǔ"]],
    "优待": [["yōu"], ["dài"]],
    "优化": [["yōu"], ["huà"]],
    "忧闷": [["yōu"], ["mèn"]],
    "优价": [["yōu"], ["jià"]],
    "忧思": [["yōu"], ["sī"]],
    "幽会": [["yōu"], ["huì"]],
    "幽禁": [["yōu"], ["jìn"]],
    "幽丽": [["yōu"], ["lì"]],
    "幽期": [["yōu"], ["qī"]],
    "幽思": [["yōu"], ["sī"]],
    "幽趣": [["yōu"], ["qù"]],
    "幽咽": [["yōu"], ["yè"]],
    "幽远": [["yōu"], ["yuǎn"]],
    "尤其": [["yóu"], ["qí"]],
    "由得": [["yóu"], ["de"]],
    "由头": [["yóu"], ["tou"]],
    "犹大": [["yóu"], ["dà"]],
    "犹若": [["yóu"], ["ruò"]],
    "犹疑": [["yóu"], ["nǐ"]],
    "邮差": [["yóu"], ["chāi"]],
    "邮车": [["yóu"], ["chē"]],
    "邮票": [["yóu"], ["piào"]],
    "油藏": [["yóu"], ["cáng"]],
    "油车": [["yóu"], ["chē"]],
    "油坊": [["yóu"], ["fáng"]],
    "油膏": [["yóu"], ["gāo"]],
    "油绿": [["yóu"], ["lǜ"]],
    "油泥": [["yóu"], ["ní"]],
    "油区": [["yóu"], ["qū"]],
    "油石": [["yóu"], ["shí"]],
    "油条": [["yóu"], ["tiáo"]],
    "柚木": [["yóu"], ["mù"]],
    "友好": [["yǒu"], ["hǎo"]],
    "有偿": [["yǒu"], ["cháng"]],
    "有成": [["yǒu"], ["chéng"]],
    "有道": [["yǒu"], ["dào"]],
    "有待": [["yǒu"], ["dài"]],
    "有得": [["yǒu"], ["de"]],
    "有德": [["yǒu"], ["dé"]],
    "有的": [["yǒu"], ["de"]],
    "有点": [["yǒu"], ["diǎn"]],
    "有底": [["yǒu"], ["dǐ"]],
    "有方": [["yǒu"], ["fāng"]],
    "有感": [["yǒu"], ["gǎn"]],
    "有关": [["yǒu"], ["guān"]],
    "有功": [["yǒu"], ["gōng"]],
    "有鬼": [["yǒu"], ["guǐ"]],
    "有害": [["yǒu"], ["hài"]],
    "有机": [["yǒu"], ["jī"]],
    "有恒": [["yǒu"], ["héng"]],
    "有节": [["yǒu"], ["jié"]],
    "有劲": [["yǒu"], ["jìn"]],
    "有旧": [["yǒu"], ["jiù"]],
    "有救": [["yǒu"], ["jiù"]],
    "有赖": [["yǒu"], ["lài"]],
    "有劳": [["yǒu"], ["láo"]],
    "有理": [["yǒu"], ["lǐ"]],
    "有力": [["yǒu"], ["lì"]],
    "有利": [["yǒu"], ["lì"]],
    "有脸": [["yǒu"], ["liǎn"]],
    "有零": [["yǒu"], ["líng"]],
    "有名": [["yǒu"], ["míng"]],
    "有年": [["yǒu"], ["nián"]],
    "有气": [["yǒu"], ["qì"]],
    "有钱": [["yǒu"], ["qián"]],
    "有情": [["yǒu"], ["qíng"]],
    "有顷": [["yǒu"], ["qǐng"]],
    "有请": [["yǒu"], ["qǐng"]],
    "有穷": [["yǒu"], ["qióng"]],
    "有趣": [["yǒu"], ["qù"]],
    "有染": [["yǒu"], ["rǎn"]],
    "有人": [["yǒu"], ["rén"]],
    "有如": [["yǒu"], ["rú"]],
    "有若": [["yǒu"], ["ruò"]],
    "有色": [["yǒu"], ["sè"]],
    "有神": [["yǒu"], ["shén"]],
    "有生": [["yǒu"], ["shēng"]],
    "有声": [["yǒu"], ["shēng"]],
    "有时": [["yǒu"], ["shí"]],
    "有识": [["yǒu"], ["shí"]],
    "有事": [["yǒu"], ["shì"]],
    "有数": [["yǒu"], ["shù"]],
    "有司": [["yǒu"], ["sī"]],
    "有望": [["yǒu"], ["wàng"]],
    "有为": [["yǒu"], ["wéi"]],
    "有味": [["yǒu"], ["wèi"]],
    "有无": [["yǒu"], ["wú"]],
    "有喜": [["yǒu"], ["xǐ"]],
    "有戏": [["yǒu"], ["xì"]],
    "有闲": [["yǒu"], ["xián"]],
    "有限": [["yǒu"], ["xiàn"]],
    "有效": [["yǒu"], ["xiào"]],
    "有些": [["yǒu"], ["xiē"]],
    "有心": [["yǒu"], ["xīn"]],
    "有幸": [["yǒu"], ["xìng"]],
    "有形": [["yǒu"], ["xíng"]],
    "有性": [["yǒu"], ["xìng"]],
    "有序": [["yǒu"], ["xù"]],
    "有言": [["yǒu"], ["yán"]],
    "有益": [["yǒu"], ["yì"]],
    "有意": [["yǒu"], ["yì"]],
    "有用": [["yǒu"], ["yòng"]],
    "有余": [["yǒu"], ["yú"]],
    "有缘": [["yǒu"], ["yuán"]],
    "有致": [["yǒu"], ["zhì"]],
    "有志": [["yǒu"], ["zhì"]],
    "有种": [["yǒu"], ["zhǒng"]],
    "有着": [["yǒu"], ["zhe"]],
    "有罪": [["yǒu"], ["zuì"]],
    "右臂": [["yòu"], ["bì"]],
    "右侧": [["yòu"], ["cè"]],
    "右行": [["yòu"], ["xíng"]],
    "幼教": [["yòu"], ["jiào"]],
    "幼体": [["yòu"], ["tǐ"]],
    "佑助": [["yòu"], ["zhù"]],
    "诱供": [["yòu"], ["gòng"]],
    "诱发": [["yòu"], ["fā"]],
    "诱降": [["yòu"], ["xiáng"]],
    "诱迫": [["yòu"], ["pò"]],
    "诱掖": [["yòu"], ["yè"]],
    "迂论": [["yū"], ["lùn"]],
    "迂曲": [["yū"], ["qū"]],
    "淤泥": [["yū"], ["ní"]],
    "淤塞": [["yū"], ["sè"]],
    "淤血": [["yū"], ["xuè"]],
    "瘀血": [["yū"], ["xuè"]],
    "于思": [["yú"], ["sāi"]],
    "予以": [["yǔ"], ["yǐ"]],
    "余地": [["yú"], ["dì"]],
    "余毒": [["yú"], ["dú"]],
    "余风": [["yú"], ["fēng"]],
    "余角": [["yú"], ["jiǎo"]],
    "余量": [["yú"], ["liàng"]],
    "余切": [["yú"], ["qiē"]],
    "余数": [["yú"], ["shù"]],
    "余头": [["yú"], ["tóu"]],
    "余兴": [["yú"], ["xìng"]],
    "於菟": [["wū"], ["tú"]],
    "鱼叉": [["yú"], ["chā"]],
    "鱼刺": [["yú"], ["cì"]],
    "鱼肚": [["yú"], ["dǔ"]],
    "鱼片": [["yú"], ["piàn"]],
    "鱼漂": [["yú"], ["piāo"]],
    "鱼汤": [["yú"], ["tāng"]],
    "鱼头": [["yú"], ["tóu"]],
    "鱼尾": [["yú"], ["wěi"]],
    "鱼种": [["yú"], ["zhǒng"]],
    "鱼鲜": [["yú"], ["xiān"]],
    "俞允": [["yú"], ["yǔn"]],
    "娱乐": [["yú"], ["lè"]],
    "逾分": [["yú"], ["fèn"]],
    "逾期": [["yú"], ["qī"]],
    "愚见": [["yú"], ["jiàn"]],
    "愚氓": [["yú"], ["méng"]],
    "愚蒙": [["yú"], ["méng"]],
    "榆中": [["yú"], ["zhōng"]],
    "愚弄": [["yú"], ["nòng"]],
    "瑜伽": [["yú"], ["jiā"]],
    "舆论": [["yú"], ["lùn"]],
    "与共": [["yǔ"], ["gòng"]],
    "与会": [["yù"], ["huì"]],
    "与门": [["yǔ"], ["mén"]],
    "与其": [["yǔ"], ["qí"]],
    "与闻": [["yù"], ["wén"]],
    "伛偻": [["yǔ"], ["lǚ"]],
    "宇内": [["yǔ"], ["nèi"]],
    "羽冠": [["yǔ"], ["guān"]],
    "羽化": [["yǔ"], ["huà"]],
    "羽扇": [["yǔ"], ["shàn"]],
    "雨布": [["yǔ"], ["bù"]],
    "雨带": [["yǔ"], ["dài"]],
    "雨滴": [["yǔ"], ["dī"]],
    "雨点": [["yǔ"], ["diǎn"]],
    "雨季": [["yǔ"], ["jì"]],
    "雨脚": [["yǔ"], ["jiǎo"]],
    "雨具": [["yǔ"], ["jù"]],
    "雨涝": [["yǔ"], ["lào"]],
    "雨量": [["yǔ"], ["liàng"]],
    "雨露": [["yǔ"], ["lù"]],
    "雨幕": [["yǔ"], ["mù"]],
    "雨蓬": [["yǔ"], ["péng"]],
    "雨披": [["yǔ"], ["pī"]],
    "雨前": [["yǔ"], ["qián"]],
    "雨情": [["yǔ"], ["qíng"]],
    "雨区": [["yǔ"], ["qū"]],
    "雨伞": [["yǔ"], ["sǎn"]],
    "雨势": [["yǔ"], ["shì"]],
    "雨丝": [["yǔ"], ["sī"]],
    "雨凇": [["yǔ"], ["sōng"]],
    "雨水": [["yǔ"], ["shuǐ"]],
    "雨蛙": [["yǔ"], ["wā"]],
    "雨雾": [["yǔ"], ["wù"]],
    "雨鞋": [["yǔ"], ["xié"]],
    "雨靴": [["yǔ"], ["xuē"]],
    "雨燕": [["yǔ"], ["yàn"]],
    "雨意": [["yǔ"], ["yì"]],
    "雨衣": [["yǔ"], ["yī"]],
    "雨云": [["yǔ"], ["yún"]],
    "语病": [["yǔ"], ["bìng"]],
    "雨珠": [["yǔ"], ["zhū"]],
    "语词": [["yǔ"], ["cí"]],
    "语调": [["yǔ"], ["diào"]],
    "语法": [["yǔ"], ["fǎ"]],
    "语境": [["yǔ"], ["jìng"]],
    "语汇": [["yǔ"], ["huì"]],
    "语感": [["yǔ"], ["gǎn"]],
    "语句": [["yǔ"], ["jù"]],
    "语录": [["yǔ"], ["lù"]],
    "语气": [["yǔ"], ["qì"]],
    "语塞": [["yǔ"], ["sè"]],
    "语声": [["yǔ"], ["shēng"]],
    "语素": [["yǔ"], ["sù"]],
    "语态": [["yǔ"], ["tài"]],
    "语体": [["yǔ"], ["tǐ"]],
    "语文": [["yǔ"], ["wén"]],
    "语系": [["yǔ"], ["xì"]],
    "语序": [["yǔ"], ["xù"]],
    "语言": [["yǔ"], ["yán"]],
    "语意": [["yǔ"], ["yì"]],
    "语音": [["yǔ"], ["yīn"]],
    "语源": [["yǔ"], ["yuán"]],
    "语云": [["yǔ"], ["yún"]],
    "语族": [["yǔ"], ["zú"]],
    "语种": [["yǔ"], ["zhǒng"]],
    "玉佛": [["yù"], ["fó"]],
    "玉女": [["yù"], ["nǚ"]],
    "玉石": [["yù"], ["shí"]],
    "玉食": [["yù"], ["shí"]],
    "玉体": [["yù"], ["tǐ"]],
    "吁请": [["yù"], ["qǐng"]],
    "吁求": [["yù"], ["qiú"]],
    "吁吁": [["xū"], ["xū"]],
    "芋头": [["yù"], ["tou"]],
    "育种": [["yù"], ["zhǒng"]],
    "郁结": [["yù"], ["jié"]],
    "郁闷": [["yù"], ["mèn"]],
    "狱卒": [["yù"], ["zú"]],
    "浴场": [["yù"], ["chǎng"]],
    "浴佛": [["yù"], ["fó"]],
    "浴血": [["yù"], ["xuè"]],
    "预卜": [["yù"], ["bǔ"]],
    "预估": [["yù"], ["gū"]],
    "预见": [["yù"], ["jiàn"]],
    "预期": [["yù"], ["qī"]],
    "预行": [["yù"], ["xíng"]],
    "预压": [["yù"], ["yā"]],
    "预知": [["yù"], ["zhī"]],
    "预约": [["yù"], ["yuē"]],
    "域内": [["yù"], ["nèi"]],
    "愈发": [["yù"], ["fā"]],
    "愈合": [["yù"], ["hé"]],
    "豫见": [["yù"], ["jiàn"]],
    "鸢尾": [["yuān"], ["wěi"]],
    "冤仇": [["yuān"], ["chóu"]],
    "冤家": [["yuān"], ["jiā"]],
    "元朝": [["yuán"], ["cháo"]],
    "冤头": [["yuān"], ["tóu"]],
    "元曲": [["yuán"], ["qǔ"]],
    "员工": [["yuán"], ["gōng"]],
    "员额": [["yuán"], ["é"]],
    "员警": [["yuán"], ["jǐng"]],
    "员司": [["yuán"], ["sī"]],
    "员外": [["yuán"], ["wài"]],
    "园地": [["yuán"], ["dì"]],
    "园丁": [["yuán"], ["dīng"]],
    "原地": [["yuán"], ["dì"]],
    "原处": [["yuán"], ["chǔ"]],
    "原价": [["yuán"], ["jià"]],
    "原任": [["yuán"], ["rèn"]],
    "原浆": [["yuán"], ["jiāng"]],
    "原汤": [["yuán"], ["tāng"]],
    "原委": [["yuán"], ["wěi"]],
    "原著": [["yuán"], ["zhù"]],
    "圆场": [["yuán"], ["chǎng"]],
    "圆钢": [["yuán"], ["gāng"]],
    "圆号": [["yuán"], ["hào"]],
    "圆笼": [["yuán"], ["lóng"]],
    "圆圈": [["yuán"], ["quān"]],
    "缘簿": [["yuán"], ["bù"]],
    "源地": [["yuán"], ["dì"]],
    "源头": [["yuán"], ["tóu"]],
    "远别": [["yuǎn"], ["bié"]],
    "远程": [["yuǎn"], ["chéng"]],
    "远大": [["yuǎn"], ["dà"]],
    "远处": [["yuǎn"], ["chù"]],
    "远道": [["yuǎn"], ["dào"]],
    "远地": [["yuǎn"], ["dì"]],
    "远东": [["yuǎn"], ["dōng"]],
    "远渡": [["yuǎn"], ["dù"]],
    "远方": [["yuǎn"], ["fāng"]],
    "远房": [["yuǎn"], ["fáng"]],
    "远古": [["yuǎn"], ["gǔ"]],
    "远海": [["yuǎn"], ["hǎi"]],
    "远航": [["yuǎn"], ["háng"]],
    "远郊": [["yuǎn"], ["jiāo"]],
    "远见": [["yuǎn"], ["jiàn"]],
    "远近": [["yuǎn"], ["jìn"]],
    "远景": [["yuǎn"], ["jǐng"]],
    "远客": [["yuǎn"], ["kè"]],
    "远路": [["yuǎn"], ["lù"]],
    "远离": [["yuǎn"], ["lí"]],
    "远虑": [["yuǎn"], ["lǜ"]],
    "远略": [["yuǎn"], ["lüè"]],
    "远门": [["yuǎn"], ["mén"]],
    "远谋": [["yuǎn"], ["móu"]],
    "远亲": [["yuǎn"], ["qīn"]],
    "远期": [["yuǎn"], ["qī"]],
    "远涉": [["yuǎn"], ["shè"]],
    "远识": [["yuǎn"], ["shí"]],
    "远视": [["yuǎn"], ["shì"]],
    "远天": [["yuǎn"], ["tiān"]],
    "远逝": [["yuǎn"], ["shì"]],
    "远眺": [["yuǎn"], ["tiào"]],
    "远望": [["yuǎn"], ["wàng"]],
    "远途": [["yuǎn"], ["tú"]],
    "远销": [["yuǎn"], ["xiāo"]],
    "远行": [["yuǎn"], ["xíng"]],
    "远扬": [["yuǎn"], ["yáng"]],
    "远洋": [["yuǎn"], ["yáng"]],
    "远因": [["yuǎn"], ["yīn"]],
    "怨毒": [["yu&agrave;nd&uacute;"]],
    "怨女": [["yuàn"], ["nǚ"]],
    "院长": [["yuàn"], ["cháng"]],
    "院落": [["yuàn"], ["luò"]],
    "垸子": [["yuàn"], ["zǐ"]],
    "约定": [["yuē"], ["dìng"]],
    "约旦": [["yuē"], ["dàn"]],
    "约法": [["yuē"], ["fǎ"]],
    "约分": [["yuē"], ["fēn"]],
    "约稿": [["yuē"], ["gǎo"]],
    "约会": [["yuē"], ["huì"]],
    "约集": [["yuē"], ["jí"]],
    "约计": [["yuē"], ["jì"]],
    "约见": [["yuē"], ["jiàn"]],
    "约略": [["yuē"], ["lüè"]],
    "约摸": [["yuē"], ["mō"]],
    "约莫": [["yuē"], ["mò"]],
    "约期": [["yuē"], ["qī"]],
    "约请": [["yuē"], ["qǐng"]],
    "约束": [["yuē"], ["shù"]],
    "约数": [["yuē"], ["shù"]],
    "约同": [["yuē"], ["tóng"]],
    "月底": [["yuè"], ["dǐ"]],
    "约言": [["yuē"], ["yán"]],
    "月度": [["yuè"], ["dù"]],
    "月份": [["yuè"], ["fèn"]],
    "月华": [["yuè"], ["huá"]],
    "月令": [["yuè"], ["lìng"]],
    "月票": [["yuè"], ["piào"]],
    "月食": [["yuè"], ["shí"]],
    "月石": [["yuè"], ["shí"]],
    "月氏": [["ròu"], ["zhī"]],
    "月台": [["yuè"], ["tái"]],
    "月尾": [["yuè"], ["wěi"]],
    "月相": [["yuè"], ["xiàng"]],
    "月晕": [["yuè"], ["yùn"]],
    "岳父": [["yuè"], ["fù"]],
    "月中": [["yuè"], ["zhōng"]],
    "岳家": [["yuè"], ["jiā"]],
    "钥匙": [["yào"], ["shi"]],
    "悦服": [["yuè"], ["fú"]],
    "阅读": [["yuè"], ["dú"]],
    "阅卷": [["yuè"], ["juàn"]],
    "阅看": [["yuè"], ["kàn"]],
    "云和": [["yún"], ["hé"]],
    "云景": [["yún"], ["jǐng"]],
    "云量": [["yún"], ["liàng"]],
    "云岭": [["yún"], ["lǐng"]],
    "云南": [["yún"], ["nán"]],
    "云雀": [["yún"], ["què"]],
    "云散": [["yún"], ["sàn"]],
    "云梢": [["yún"], ["shāo"]],
    "云头": [["yún"], ["tóu"]],
    "云涌": [["yún"], ["yǒng"]],
    "云雨": [["yún"], ["yǔ"]],
    "匀称": [["yún"], ["chèn"]],
    "匀兑": [["yún"], ["duì"]],
    "匀和": [["yún"], ["hé"]],
    "匀溜": [["yún"], ["liū"]],
    "匀净": [["yún"], ["jìng"]],
    "匀浆": [["yún"], ["jiāng"]],
    "允当": [["yǔn"], ["dàng"]],
    "允许": [["yǔn"], ["xǔ"]],
    "陨落": [["yǔn"], ["luò"]],
    "陨石": [["yǔn"], ["shí"]],
    "孕期": [["yùn"], ["qī"]],
    "孕吐": [["yùn"], ["tù"]],
    "运单": [["yùn"], ["dān"]],
    "运价": [["yùn"], ["jià"]],
    "运量": [["yùn"], ["liàng"]],
    "运数": [["yùn"], ["shù"]],
    "运思": [["yùn"], ["sī"]],
    "运行": [["yùn"], ["xíng"]],
    "运载": [["yùn"], ["zài"]],
    "运转": [["yùn"], ["zhuàn"]],
    "晕场": [["yùn"], ["chǎng"]],
    "晕车": [["yùn"], ["chē"]],
    "晕池": [["yùn"], ["chí"]],
    "晕船": [["yùn"], ["chuán"]],
    "晕倒": [["yūn"], ["dǎo"]],
    "晕高": [["yùn"], ["gāo"]],
    "晕眩": [["yūn"], ["xuàn"]],
    "晕厥": [["yūn"], ["jué"]],
    "晕针": [["yùn"], ["zhēn"]],
    "韵调": [["yùn"], ["diào"]],
    "韵头": [["yùn"], ["tóu"]],
    "韵尾": [["yùn"], ["wěi"]],
    "熨斗": [["yùn"], ["dǒu"]],
    "熨帖": [["yù"], ["tiē"]],
    "韵语": [["yùn"], ["yǔ"]],
    "蕴藏": [["yùn"], ["cáng"]],
    "蕴结": [["yùn"], ["jié"]],
    "蕴藉": [["yùn"], ["jiè"]],
    "匝地": [["zā"], ["dì"]],
    "杂拌": [["zá"], ["bàn"]],
    "拶子": [["zǎn"], ["zǐ"]],
    "杂差": [["zá"], ["chà"]],
    "杂处": [["zá"], ["chǔ"]],
    "杂沓": [["zá"], ["tà"]],
    "杂家": [["zá"], ["jiā"]],
    "杂食": [["zá"], ["shí"]],
    "杂说": [["zá"], ["shuō"]],
    "杂症": [["zá"], ["zhèng"]],
    "杂种": [["zá"], ["zhǒng"]],
    "灾区": [["zāi"], ["qū"]],
    "灾难": [["zāi"], ["nàn"]],
    "栽倒": [["zāi"], ["dǎo"]],
    "栽种": [["zāi"], ["zhòng"]],
    "宰相": [["zǎi"], ["xiàng"]],
    "载波": [["zài"], ["bō"]],
    "载荷": [["zài"], ["hè"]],
    "载货": [["zài"], ["huò"]],
    "载频": [["zài"], ["pín"]],
    "载运": [["zài"], ["yùn"]],
    "载重": [["zài"], ["zhòng"]],
    "再不": [["zài"], ["bù"]],
    "再度": [["zài"], ["dù"]],
    "再分": [["zài"], ["fēn"]],
    "再会": [["zài"], ["huì"]],
    "再见": [["zài"], ["jiàn"]],
    "再说": [["zài"], ["shuō"]],
    "再行": [["zài"], ["xíng"]],
    "在场": [["zài"], ["chǎng"]],
    "在朝": [["zài"], ["cháo"]],
    "在教": [["zài"], ["jiào"]],
    "在家": [["zài"], ["jiā"]],
    "在内": [["zài"], ["nèi"]],
    "在任": [["zài"], ["rèn"]],
    "在行": [["zài"], ["háng"]],
    "咱家": [["zá"], ["jiā"]],
    "咱们": [["zán"], ["men"]],
    "攒动": [["cuán"], ["dòng"]],
    "攒盒": [["cuán"], ["hé"]],
    "攒集": [["cuán"], ["jí"]],
    "攒聚": [["cuán"], ["jù"]],
    "攒眉": [["cuán"], ["méi"]],
    "攒射": [["cuán"], ["shè"]],
    "攒钱": [["zǎn"], ["qián"]],
    "攒攒": [["zǎn"], ["zǎn"]],
    "攒竹": [["zǎn"], ["zhú"]],
    "暂行": [["zàn"], ["xíng"]],
    "赞同": [["zàn"], ["tóng"]],
    "赞许": [["zàn"], ["xǔ"]],
    "赞语": [["zàn"], ["yǔ"]],
    "赞助": [["zàn"], ["zhù"]],
    "臧否": [["zāng"], ["pǐ"]],
    "遭难": [["zāo"], ["nàn"]],
    "早场": [["zǎo"], ["chǎng"]],
    "早朝": [["zǎo"], ["cháo"]],
    "早车": [["zǎo"], ["chē"]],
    "早间": [["zǎo"], ["jiān"]],
    "早上": [["zǎo"], ["shàng"]],
    "早期": [["zǎo"], ["qī"]],
    "早衰": [["zǎo"], ["shuāi"]],
    "枣核": [["zǎo"], ["hé"]],
    "早知": [["zǎo"], ["zhī"]],
    "枣泥": [["zǎo"], ["ní"]],
    "蚤休": [["zǎo"], ["xiū"]],
    "藻思": [["zǎo"], ["sī"]],
    "枣红": [["zǎo"], ["hóng"]],
    "灶间": [["zào"], ["jiān"]],
    "灶台": [["zào"], ["tái"]],
    "灶头": [["zào"], ["tou"]],
    "皂角": [["zào"], ["jiǎo"]],
    "皂化": [["zào"], ["huà"]],
    "皂隶": [["zào"], ["lì"]],
    "造化": [["zào"], ["huà"]],
    "造价": [["zào"], ["jià"]],
    "造假": [["zào"], ["jiǎ"]],
    "造句": [["zào"], ["jù"]],
    "燥裂": [["zào"], ["liè"]],
    "则甚": [["zé"], ["shèn"]],
    "择菜": [["zhái"], ["cài"]],
    "择吉": [["zé"], ["jí"]],
    "择交": [["zé"], ["jiāo"]],
    "择日": [["zé"], ["rì"]],
    "择要": [["zé"], ["yào"]],
    "择席": [["zhái"], ["xí"]],
    "择优": [["zé"], ["yōu"]],
    "泽国": [["zé"], ["guó"]],
    "泽兰": [["zé"], ["lán"]],
    "泽泻": [["zé"], ["xiè"]],
    "责令": [["zé"], ["lìng"]],
    "责打": [["zé"], ["dǎ"]],
    "责难": [["zé"], ["nàn"]],
    "责任": [["zé"], ["rèn"]],
    "贼风": [["zéi"], ["fēng"]],
    "怎的": [["zěn"], ["de"]],
    "怎地": [["zěn"], ["dì"]],
    "怎么": [["zěn"], ["me"]],
    "曾经": [["céng"], ["jīng"]],
    "曾祖": [["zēng"], ["zǔ"]],
    "曾孙": [["zēng"], ["sūn"]],
    "增长": [["zēng"], ["zhǎng"]],
    "增大": [["zēng"], ["dà"]],
    "增广": [["zēng"], ["guǎng"]],
    "增量": [["zēng"], ["liàng"]],
    "增强": [["zēng"], ["qiáng"]],
    "增压": [["zēng"], ["yā"]],
    "增殖": [["zēng"], ["zhí"]],
    "增重": [["zēng"], ["zhòng"]],
    "憎恶": [["zēng"], ["wù"]],
    "赠别": [["zèng"], ["bié"]],
    "赠答": [["zèng"], ["dá"]],
    "赠予": [["zèng"], ["yǔ"]],
    "赠与": [["zèng"], ["yǔ"]],
    "咋呼": [["zhā"], ["hū"]],
    "咋舌": [["zé"], ["shé"]],
    "扎根": [["zhā"], ["gēn"]],
    "扎堆": [["zhā"], ["duī"]],
    "扎花": [["zhā"], ["huā"]],
    "扎染": [["zā"], ["rǎn"]],
    "扎手": [["zhā"], ["shǒu"]],
    "扎实": [["zhā"], ["shí"]],
    "扎眼": [["zhā"], ["yǎn"]],
    "扎营": [["zhā"], ["yíng"]],
    "扎扎": [["zhā"], ["zhā"]],
    "扎针": [["zhā"], ["zhēn"]],
    "扎挣": [["zhá"], ["zhēng"]],
    "轧场": [["yà"], ["chǎng"]],
    "轧钢": [["zhá"], ["gāng"]],
    "闸把": [["zhá"], ["bǎ"]],
    "乍看": [["zhà"], ["kàn"]],
    "诈唬": [["zhà"], ["hǔ"]],
    "诈称": [["zhà"], ["chēng"]],
    "诈语": [["zhà"], ["yǔ"]],
    "诈降": [["zhà"], ["xiáng"]],
    "栅极": [["shān"], ["jí"]],
    "栅栏": [["zhà"], ["lán"]],
    "栅门": [["zhà"], ["mén"]],
    "栅子": [["zhà"], ["zǐ"]],
    "炸弹": [["zhà"], ["dàn"]],
    "炸糕": [["zhá"], ["gāo"]],
    "炸锅": [["zhà"], ["guō"]],
    "炸毁": [["zhà"], ["huǐ"]],
    "炸酱": [["zhá"], ["jiàng"]],
    "炸雷": [["zhà"], ["léi"]],
    "炸裂": [["zhà"], ["liè"]],
    "炸破": [["zhà"], ["pò"]],
    "炸碎": [["zhà"], ["suì"]],
    "炸窝": [["zhà"], ["wō"]],
    "炸药": [["zhà"], ["yào"]],
    "斋期": [["zhāi"], ["qī"]],
    "摘发": [["zhāi"], ["fā"]],
    "摘要": [["zhāi"], ["yào"]],
    "宅地": [["zhái"], ["dì"]],
    "债券": [["zhài"], ["quàn"]],
    "沾化": [["zhān"], ["huà"]],
    "沾亲": [["zhān"], ["qīn"]],
    "粘结": [["nián"], ["jié"]],
    "谵语": [["zhān"], ["yǔ"]],
    "瞻仰": [["zhān"], ["yǎng"]],
    "展读": [["zhǎn"], ["dú"]],
    "展期": [["zhǎn"], ["qī"]],
    "展转": [["zhǎn"], ["zhuǎn"]],
    "辗转": [["zhǎn"], ["zhuǎn"]],
    "占卜": [["zhān"], ["bǔ"]],
    "占卦": [["zhān"], ["guà"]],
    "占地": [["zhàn"], ["dì"]],
    "占居": [["zhàn"], ["jū"]],
    "占据": [["zhàn"], ["jù"]],
    "占课": [["zhān"], ["kè"]],
    "占领": [["zhàn"], ["lǐng"]],
    "占理": [["zhàn"], ["lǐ"]],
    "占梦": [["zhān"], ["mèng"]],
    "占线": [["zhàn"], ["xiàn"]],
    "占先": [["zhàn"], ["xiān"]],
    "占星": [["zhān"], ["xīng"]],
    "占压": [["zhàn"], ["yā"]],
    "占用": [["zhàn"], ["yòng"]],
    "占有": [["zhàn"], ["yǒu"]],
    "战场": [["zhàn"], ["chǎng"]],
    "战车": [["zhàn"], ["chē"]],
    "战地": [["zhàn"], ["dì"]],
    "战将": [["zhàn"], ["jiàng"]],
    "战斗": [["zhàn"], ["dòu"]],
    "战区": [["zhàn"], ["qū"]],
    "战术": [["zhàn"], ["shù"]],
    "站长": [["zhàn"], ["zhǎng"]],
    "站票": [["zhàn"], ["piào"]],
    "站台": [["zhàn"], ["tái"]],
    "张榜": [["zhāng"], ["bǎng"]],
    "张大": [["zhāng"], ["dà"]],
    "涨潮": [["zhǎng"], ["cháo"]],
    "涨风": [["zhǎng"], ["fēng"]],
    "涨价": [["zhǎng"], ["jià"]],
    "涨落": [["zhǎng"], ["luò"]],
    "涨钱": [["zhǎng"], ["qián"]],
    "涨水": [["zhǎng"], ["shuǐ"]],
    "丈夫": [["zhàng"], ["fū"]],
    "丈量": [["zhàng"], ["liáng"]],
    "帐簿": [["zhàng"], ["bù"]],
    "帐单": [["zhàng"], ["dān"]],
    "账簿": [["zhàng"], ["bù"]],
    "账单": [["zhàng"], ["dān"]],
    "瘴疠": [["zhàng"], ["lì"]],
    "账号": [["zhàng"], ["hào"]],
    "招待": [["zhāo"], ["dài"]],
    "招风": [["zhāo"], ["fēng"]],
    "招供": [["zhāo"], ["gòng"]],
    "招降": [["zhāo"], ["xiáng"]],
    "招徕": [["zhāo"], ["lái"]],
    "招亲": [["zhāo"], ["qīn"]],
    "招数": [["zhāo"], ["shù"]],
    "昭苏": [["zhāo"], ["sū"]],
    "昭著": [["zhāo"], ["zhù"]],
    "啁啾": [["zhōu"], ["jiū"]],
    "找碴": [["zhǎo"], ["chá"]],
    "找齐": [["zhǎo"], ["qí"]],
    "找头": [["zhǎo"], ["tou"]],
    "沼地": [["zhǎo"], ["dì"]],
    "沼泽": [["zhǎo"], ["zé"]],
    "召唤": [["zhào"], ["huàn"]],
    "召回": [["zhào"], ["huí"]],
    "召祸": [["zhào"], ["huò"]],
    "召集": [["zhào"], ["jí"]],
    "召见": [["zhào"], ["jiàn"]],
    "召开": [["zhào"], ["kāi"]],
    "召募": [["zhào"], ["mù"]],
    "兆头": [["zhào"], ["tou"]],
    "诏令": [["zhào"], ["lìng"]],
    "赵体": [["zhào"], ["tǐ"]],
    "照度": [["zhào"], ["dù"]],
    "照发": [["zhào"], ["fā"]],
    "照拂": [["zhào"], ["fú"]],
    "照会": [["zhào"], ["huì"]],
    "照见": [["zhào"], ["jiàn"]],
    "照看": [["zhào"], ["kàn"]],
    "照片": [["zhào"], ["piān"]],
    "照射": [["zhào"], ["shè"]],
    "照说": [["zhào"], ["shuō"]],
    "照相": [["zhào"], ["xiàng"]],
    "照应": [["zhào"], ["yìng"]],
    "遮藏": [["zhē"], ["cáng"]],
    "遮挡": [["zhē"], ["dǎng"]],
    "遮盖": [["zhē"], ["gài"]],
    "遮瞒": [["zhē"], ["mán"]],
    "遮荫": [["zhē"], ["yīn"]],
    "折半": [["zhé"], ["bàn"]],
    "折本": [["shé"], ["běn"]],
    "折变": [["zhé"], ["biàn"]],
    "折秤": [["shé"], ["chèng"]],
    "折尺": [["zhé"], ["chǐ"]],
    "折冲": [["zhé"], ["chōng"]],
    "折刀": [["zhé"], ["dāo"]],
    "折叠": [["zhé"], ["dié"]],
    "折断": [["zhé"], ["duàn"]],
    "折兑": [["zhé"], ["duì"]],
    "折堕": [["shé"], ["duò"]],
    "折返": [["zhé"], ["fǎn"]],
    "折服": [["zhé"], ["fú"]],
    "折福": [["zhé"], ["fú"]],
    "折桂": [["zhé"], ["guì"]],
    "折光": [["zhé"], ["guāng"]],
    "折耗": [["shé"], ["hào"]],
    "折合": [["zhé"], ["hé"]],
    "折痕": [["zhé"], ["hén"]],
    "折回": [["zhé"], ["huí"]],
    "折价": [["zhé"], ["jià"]],
    "折旧": [["zhé"], ["jiù"]],
    "折扣": [["zhé"], ["kòu"]],
    "折磨": [["zhé"], ["mó"]],
    "折辱": [["shé"], ["rǔ"]],
    "折杀": [["zhé"], ["shā"]],
    "折扇": [["zhé"], ["shàn"]],
    "折射": [["zhé"], ["shè"]],
    "折寿": [["zhé"], ["shòu"]],
    "折损": [["shé"], ["sǔn"]],
    "折算": [["zhé"], ["suàn"]],
    "折腾": [["zhē"], ["téng"]],
    "折弯": [["zhé"], ["wān"]],
    "折头": [["zhé"], ["tou"]],
    "折线": [["zhé"], ["xiàn"]],
    "折腰": [["zhé"], ["yāo"]],
    "折页": [["zhé"], ["yè"]],
    "折椅": [["zhé"], ["yǐ"]],
    "折账": [["zhé"], ["zhàng"]],
    "折枝": [["zhé"], ["zhī"]],
    "折纸": [["zhé"], ["zhǐ"]],
    "折中": [["zhé"], ["zhōng"]],
    "折皱": [["zhé"], ["zhòu"]],
    "折衷": [["shé"], ["zhōng"]],
    "折转": [["zhé"], ["zhuǎn"]],
    "折子": [["zhé"], ["zǐ"]],
    "哲思": [["zhé"], ["sī"]],
    "赭石": [["zhě"], ["shí"]],
    "这边": [["zhè"], ["biān"]],
    "这般": [["zhè"], ["bān"]],
    "这次": [["zhè"], ["cì"]],
    "这点": [["zhè"], ["diǎn"]],
    "这儿": [["zhè"], ["ér"]],
    "这个": [["zhè"], ["gè"]],
    "这么": [["zhè"], ["me"]],
    "这里": [["zhè"], ["lǐ"]],
    "这些": [["zhèi"], ["xiē"]],
    "这样": [["zhè"], ["yàng"]],
    "贞观": [["zhēn"], ["guān"]],
    "贞节": [["zhēn"], ["jié"]],
    "贞女": [["zhēn"], ["nǚ"]],
    "针刺": [["zhēn"], ["cì"]],
    "针头": [["zhēn"], ["tóu"]],
    "针叶": [["zhēn"], ["yè"]],
    "侦查": [["zhēn"], ["zhā"]],
    "针织": [["zhēn"], ["zhī"]],
    "侦缉": [["zhēn"], ["jī"]],
    "珍藏": [["zhēn"], ["cáng"]],
    "珍奇": [["zhēn"], ["qí"]],
    "珍摄": [["zhēn"], ["shè"]],
    "珍重": [["zhēn"], ["zhòng"]],
    "真传": [["zhēn"], ["chuán"]],
    "真个": [["zhēn"], ["gè"]],
    "真菌": [["zhēn"], ["jūn"]],
    "真空": [["zhēn"], ["kōng"]],
    "真切": [["zhēn"], ["qiè"]],
    "真数": [["zhēn"], ["shù"]],
    "真率": [["zhēn"], ["shuài"]],
    "真相": [["zhēn"], ["xiàng"]],
    "真正": [["zhēn"], ["zhèng"]],
    "真知": [["zhēn"], ["zhī"]],
    "甄别": [["zhēn"], ["bié"]],
    "诊脉": [["zhěn"], ["mài"]],
    "枕骨": [["zhěn"], ["gǔ"]],
    "枕藉": [["zhěn"], ["jiè"]],
    "枕头": [["zhěn"], ["tou"]],
    "阵地": [["zhèn"], ["dì"]],
    "阵发": [["zhèn"], ["fā"]],
    "阵亡": [["zhèn"], ["wáng"]],
    "阵风": [["zhèn"], ["fēng"]],
    "阵雨": [["zhèn"], ["yǔ"]],
    "鸩毒": [["zhèn"], ["dú"]],
    "振臂": [["zhèn"], ["bì"]],
    "振兴": [["zhèn"], ["xīng"]],
    "镇长": [["zhèn"], ["cháng"]],
    "镇尺": [["zhèn"], ["chǐ"]],
    "镇服": [["zhèn"], ["fú"]],
    "镇压": [["zhèn"], ["yā"]],
    "震颤": [["zhèn"], ["chàn"]],
    "震区": [["zhèn"], ["qū"]],
    "震中": [["zhèn"], ["zhōng"]],
    "争吵": [["zhēng"], ["chǎo"]],
    "争得": [["zhēng"], ["de"]],
    "争斗": [["zhēng"], ["dòu"]],
    "争论": [["zhēng"], ["lùn"]],
    "争强": [["zhēng"], ["qiáng"]],
    "争抢": [["zhēng"], ["qiǎng"]],
    "征调": [["zhēng"], ["diào"]],
    "征发": [["zhēng"], ["fā"]],
    "征夫": [["zhēng"], ["fū"]],
    "征服": [["zhēng"], ["fú"]],
    "征剿": [["zhēng"], ["jiǎo"]],
    "征召": [["zhēng"], ["zhào"]],
    "挣揣": [["zhèng"], ["chuài"]],
    "挣命": [["zhèng"], ["mìng"]],
    "挣钱": [["zhèng"], ["qián"]],
    "挣脱": [["zhèng"], ["tuō"]],
    "挣扎": [["zhēng"], ["zhá"]],
    "蒸发": [["zhēng"], ["fā"]],
    "蒸馏": [["zhēng"], ["liú"]],
    "蒸笼": [["zhēng"], ["lóng"]],
    "蒸散": [["zhēng"], ["sàn"]],
    "蒸食": [["zhēng"], ["shí"]],
    "整地": [["zhěng"], ["dì"]],
    "整个": [["zhěng"], ["gè"]],
    "整风": [["zhěng"], ["fēng"]],
    "整数": [["zhěng"], ["shù"]],
    "整齐": [["zhěng"], ["qí"]],
    "整宿": [["zhěng"], ["sù"]],
    "整体": [["zhěng"], ["tǐ"]],
    "整枝": [["zhěng"], ["zhī"]],
    "正本": [["zhèng"], ["běn"]],
    "正比": [["zhèng"], ["bǐ"]],
    "正步": [["zhèng"], ["bù"]],
    "正餐": [["zhèng"], ["cān"]],
    "正册": [["zhèng"], ["cè"]],
    "正常": [["zhèng"], ["cháng"]],
    "正传": [["zhèng"], ["zhuàn"]],
    "正出": [["zhèng"], ["chū"]],
    "正大": [["zhèng"], ["dà"]],
    "正旦": [["zhēng"], ["dàn"]],
    "正当": [["zhèng"], ["dāng"]],
    "正道": [["zhèng"], ["dào"]],
    "正德": [["zhèng"], ["dé"]],
    "正点": [["zhèng"], ["diǎn"]],
    "正电": [["zhèng"], ["diàn"]],
    "正殿": [["zhèng"], ["diàn"]],
    "正定": [["zhèng"], ["dìng"]],
    "正法": [["zhèng"], ["fǎ"]],
    "正犯": [["zhèng"], ["fàn"]],
    "正方": [["zhèng"], ["fāng"]],
    "正房": [["zhèng"], ["fáng"]],
    "正负": [["zhèng"], ["fù"]],
    "正告": [["zhèng"], ["gào"]],
    "正割": [["zhèng"], ["gē"]],
    "正格": [["zhèng"], ["gé"]],
    "正宫": [["zhèng"], ["gōng"]],
    "正骨": [["zhèng"], ["gǔ"]],
    "正规": [["zhèng"], ["guī"]],
    "正轨": [["zhèng"], ["guǐ"]],
    "正果": [["zhèng"], ["guǒ"]],
    "正好": [["zhèng"], ["hǎo"]],
    "正话": [["zhèng"], ["huà"]],
    "正号": [["zhèng"], ["hào"]],
    "正极": [["zhèng"], ["jí"]],
    "正见": [["zhèng"], ["jiàn"]],
    "正解": [["zhèng"], ["jiě"]],
    "正教": [["zhèng"], ["jiào"]],
    "正经": [["zhèng"], ["jīng"]],
    "正剧": [["zhèng"], ["jù"]],
    "正楷": [["zhèng"], ["kǎi"]],
    "正课": [["zhèng"], ["kè"]],
    "正理": [["zhèng"], ["lǐ"]],
    "正梁": [["zhèng"], ["liáng"]],
    "正路": [["zhèng"], ["lù"]],
    "正论": [["zhèng"], ["lùn"]],
    "正门": [["zhèng"], ["mén"]],
    "正面": [["zhèng"], ["miàn"]],
    "正名": [["zhèng"], ["míng"]],
    "正牌": [["zhèng"], ["pái"]],
    "正派": [["zhèng"], ["pài"]],
    "正片": [["zhèng"], ["piàn"]],
    "正品": [["zhèng"], ["pǐn"]],
    "正气": [["zhèng"], ["qì"]],
    "正巧": [["zhèng"], ["qiǎo"]],
    "正切": [["zhèng"], ["qiē"]],
    "正确": [["zhèng"], ["què"]],
    "正日": [["zhèng"], ["rì"]],
    "正色": [["zhèng"], ["sè"]],
    "正身": [["zhèng"], ["shēn"]],
    "正时": [["zhèng"], ["shí"]],
    "正史": [["zhèng"], ["shǐ"]],
    "正始": [["zhèng"], ["shǐ"]],
    "正式": [["zhèng"], ["shì"]],
    "正事": [["zhèng"], ["shì"]],
    "正视": [["zhèng"], ["shì"]],
    "正室": [["zhèng"], ["shì"]],
    "正是": [["zhèng"], ["shì"]],
    "正手": [["zhèng"], ["shǒu"]],
    "正书": [["zhèng"], ["shū"]],
    "正数": [["zhèng"], ["shù"]],
    "正朔": [["zhēng"], ["shuò"]],
    "正堂": [["zhèng"], ["táng"]],
    "正题": [["zhèng"], ["tí"]],
    "正体": [["zhèng"], ["tǐ"]],
    "正厅": [["zhèng"], ["tīng"]],
    "正统": [["zhèng"], ["tǒng"]],
    "正位": [["zhèng"], ["wèi"]],
    "正途": [["zhèng"], ["tú"]],
    "正文": [["zhèng"], ["wén"]],
    "正屋": [["zhèng"], ["wū"]],
    "正午": [["zhèng"], ["wǔ"]],
    "正误": [["zhèng"], ["wù"]],
    "正弦": [["zhèng"], ["xián"]],
    "正向": [["zhèng"], ["xiàng"]],
    "正行": [["zhèng"], ["xíng"]],
    "正像": [["zhèng"], ["xiàng"]],
    "正心": [["zhèng"], ["xīn"]],
    "正凶": [["zhèng"], ["xiōng"]],
    "正眼": [["zhèng"], ["yǎn"]],
    "正阳": [["zhèng"], ["yáng"]],
    "正盐": [["zhèng"], ["yán"]],
    "正要": [["zhèng"], ["yào"]],
    "正业": [["zhèng"], ["yè"]],
    "正音": [["zhèng"], ["yīn"]],
    "正义": [["zhèng"], ["yì"]],
    "正用": [["zhèng"], ["yòng"]],
    "正月": [["zhēng"], ["yuè"]],
    "正在": [["zhèng"], ["zài"]],
    "正则": [["zhèng"], ["zé"]],
    "正直": [["zhèng"], ["zhí"]],
    "正值": [["zhèng"], ["zhí"]],
    "正职": [["zhèng"], ["zhí"]],
    "正治": [["zhèng"], ["zhì"]],
    "正中": [["zhèng"], ["zhōng"]],
    "正字": [["zhèng"], ["zì"]],
    "正宗": [["zhèng"], ["zōng"]],
    "正座": [["zhèng"], ["zuò"]],
    "证见": [["zhèng"], ["jiàn"]],
    "证据": [["zhèng"], ["jù"]],
    "证券": [["zhèng"], ["quàn"]],
    "郑重": [["zhèng"], ["zhòng"]],
    "政纪": [["zhèng"], ["jì"]],
    "政见": [["zhèng"], ["jiàn"]],
    "政教": [["zhèng"], ["jiào"]],
    "政令": [["zhèng"], ["lìng"]],
    "政论": [["zhèng"], ["lùn"]],
    "政体": [["zhèng"], ["tǐ"]],
    "政委": [["zhèng"], ["wěi"]],
    "政要": [["zhèng"], ["yào"]],
    "症候": [["zhèng"], ["hòu"]],
    "症结": [["zhēng"], ["jié"]],
    "症状": [["zhèng"], ["zhuàng"]],
    "支差": [["zhī"], ["chāi"]],
    "支会": [["zhī"], ["huì"]],
    "支解": [["zhī"], ["jiě"]],
    "支棱": [["zhī"], ["léng"]],
    "支脉": [["zhī"], ["mài"]],
    "支那": [["zhī"], ["nà"]],
    "支票": [["zhī"], ["piào"]],
    "支渠": [["zhī"], ["qú"]],
    "支数": [["zhī"], ["shù"]],
    "支委": [["zhī"], ["wěi"]],
    "支吾": [["zhī"], ["wú"]],
    "支应": [["zhī"], ["yìng"]],
    "支助": [["zhī"], ["zhù"]],
    "吱扭": [["zī"], ["niǔ"]],
    "吱声": [["zhī"], ["shēng"]],
    "吱吱": [["zhī"], ["zhī"]],
    "枝杈": [["zhī"], ["chà"]],
    "枝干": [["zhī"], ["gàn"]],
    "枝接": [["zhī"], ["jiē"]],
    "枝节": [["zhī"], ["jié"]],
    "枝柯": [["zhī"], ["kē"]],
    "枝蔓": [["zhī"], ["wàn"]],
    "枝头": [["zhī"], ["tóu"]],
    "枝梢": [["zhī"], ["shāo"]],
    "枝条": [["zhī"], ["tiáo"]],
    "枝梧": [["zhī"], ["wú"]],
    "枝丫": [["zhī"], ["yā"]],
    "枝叶": [["zhī"], ["yè"]],
    "枝子": [["zhī"], ["zǐ"]],
    "知道": [["zhī"], ["dào"]],
    "知底": [["zhī"], ["dǐ"]],
    "知府": [["zhī"], ["fǔ"]],
    "知会": [["zhī"], ["huì"]],
    "知己": [["zhī"], ["jǐ"]],
    "知交": [["zhī"], ["jiāo"]],
    "知觉": [["zhī"], ["jué"]],
    "知了": [["zhī"], ["liǎo"]],
    "知名": [["zhī"], ["míng"]],
    "知命": [["zhī"], ["mìng"]],
    "知能": [["zhī"], ["néng"]],
    "知青": [["zhī"], ["qīng"]],
    "知情": [["zhī"], ["qíng"]],
    "知趣": [["zhī"], ["qù"]],
    "知人": [["zhī"], ["rén"]],
    "知识": [["zhī"], ["shí"]],
    "知事": [["zhī"], ["shì"]],
    "知悉": [["zhī"], ["xī"]],
    "知县": [["zhī"], ["xiàn"]],
    "知晓": [["zhī"], ["xiǎo"]],
    "知心": [["zhī"], ["xīn"]],
    "知音": [["zhī"], ["yīn"]],
    "知性": [["zhī"], ["xìng"]],
    "知友": [["zhī"], ["yǒu"]],
    "知遇": [["zhī"], ["yù"]],
    "知照": [["zhī"], ["zhào"]],
    "知者": [["zhī"], ["zhě"]],
    "织补": [["zhī"], ["bǔ"]],
    "知州": [["zhī"], ["zhōu"]],
    "知足": [["zhī"], ["zú"]],
    "织布": [["zhī"], ["bù"]],
    "织成": [["zhī"], ["chéng"]],
    "织花": [["zhī"], ["huā"]],
    "织机": [["zhī"], ["jī"]],
    "织锦": [["zhī"], ["jǐn"]],
    "织金": [["zhī"], ["jīn"]],
    "织女": [["zhī"], ["nǚ"]],
    "织品": [["zhī"], ["pǐn"]],
    "织物": [["zhī"], ["wù"]],
    "织造": [["zhī"], ["zào"]],
    "肢解": [["zhī"], ["jiě"]],
    "肢体": [["zhī"], ["tǐ"]],
    "执拗": [["zhí"], ["niù"]],
    "脂膏": [["zhī"], ["gāo"]],
    "执教": [["zhí"], ["jiào"]],
    "执泥": [["zhí"], ["ní"]],
    "执著": [["zhí"], ["zhuó"]],
    "执行": [["zhí"], ["xíng"]],
    "执着": [["zhí"], ["zhuó"]],
    "侄女": [["zhí"], ["nǚ"]],
    "侄孙": [["zhí"], ["sūn"]],
    "直尺": [["zhí"], ["chǐ"]],
    "直冲": [["zhí"], ["chōng"]],
    "直待": [["zhí"], ["dài"]],
    "直观": [["zhí"], ["guān"]],
    "直角": [["zhí"], ["jiǎo"]],
    "直觉": [["zhí"], ["jué"]],
    "直溜": [["zhí"], ["liū"]],
    "直率": [["zhí"], ["shuài"]],
    "直落": [["zhí"], ["luò"]],
    "直射": [["zhí"], ["shè"]],
    "直说": [["zhí"], ["shuō"]],
    "直系": [["zhí"], ["xì"]],
    "直行": [["zhí"], ["xíng"]],
    "直属": [["zhí"], ["shǔ"]],
    "值当": [["zhí"], ["dàng"]],
    "值得": [["zhí"], ["de"]],
    "止血": [["zhǐ"], ["xuè"]],
    "只此": [["zhī"], ["cǐ"]],
    "只当": [["zhǐ"], ["dāng"]],
    "只得": [["zhǐ"], ["de"]],
    "只顾": [["zhǐ"], ["gù"]],
    "只好": [["zhǐ"], ["hǎo"]],
    "只管": [["zhǐ"], ["guǎn"]],
    "只见": [["zhī"], ["jiàn"]],
    "只怕": [["zhǐ"], ["pà"]],
    "只能": [["zhǐ"], ["néng"]],
    "只身": [["zhī"], ["shēn"]],
    "只是": [["zhǐ"], ["shì"]],
    "只消": [["zhǐ"], ["xiāo"]],
    "只要": [["zhǐ"], ["yào"]],
    "只有": [["zhǐ"], ["yǒu"]],
    "只字": [["zhī"], ["zì"]],
    "旨趣": [["zhǐ"], ["qù"]],
    "旨要": [["zhǐ"], ["yào"]],
    "纸夹": [["zhǐ"], ["jiā"]],
    "纸浆": [["zhǐ"], ["jiāng"]],
    "纸捻": [["zhǐ"], ["niǎn"]],
    "纸票": [["zhǐ"], ["piào"]],
    "纸条": [["zhǐ"], ["tiáo"]],
    "咫尺": [["zhǐ"], ["chǐ"]],
    "指称": [["zhǐ"], ["chēng"]],
    "指缝": [["zhǐ"], ["féng"]],
    "指供": [["zhǐ"], ["gòng"]],
    "指教": [["zhǐ"], ["jiào"]],
    "指令": [["zhǐ"], ["lìng"]],
    "指节": [["zhǐ"], ["jié"]],
    "指南": [["zhǐ"], ["nán"]],
    "指数": [["zhǐ"], ["shù"]],
    "指头": [["zhǐ"], ["tou"]],
    "指纹": [["zhǐ"], ["wén"]],
    "指正": [["zhǐ"], ["zhèng"]],
    "枳壳": [["zhǐ"], ["ké"]],
    "至当": [["zhì"], ["dāng"]],
    "至好": [["zhì"], ["hǎo"]],
    "至亲": [["zhì"], ["qīn"]],
    "至若": [["zhì"], ["ruò"]],
    "至上": [["zhì"], ["shàng"]],
    "至少": [["zhì"], ["shǎo"]],
    "至为": [["zhì"], ["wéi"]],
    "至正": [["zhì"], ["zhèng"]],
    "志节": [["zhì"], ["jié"]],
    "志趣": [["zhì"], ["qù"]],
    "制度": [["zhì"], ["dù"]],
    "制服": [["zhì"], ["fú"]],
    "制约": [["zhì"], ["yuē"]],
    "治服": [["zhì"], ["fú"]],
    "治家": [["zhì"], ["jiā"]],
    "治丧": [["zhì"], ["sāng"]],
    "质地": [["zhì"], ["dì"]],
    "质量": [["zhì"], ["liàng"]],
    "质朴": [["zhì"], ["piáo"]],
    "质体": [["zhì"], ["tǐ"]],
    "质数": [["zhì"], ["shù"]],
    "质疑": [["zhì"], ["yí"]],
    "峙立": [["zhì"], ["lì"]],
    "贽见": [["zhì"], ["jiàn"]],
    "智囊": [["zhì"], ["náng"]],
    "智术": [["zhì"], ["shù"]],
    "置疑": [["zhì"], ["yí"]],
    "置信": [["zhì"], ["xìn"]],
    "中班": [["zhōng"], ["bān"]],
    "中饱": [["zhōng"], ["bǎo"]],
    "中保": [["zhōng"], ["bǎo"]],
    "中标": [["zhòng"], ["biāo"]],
    "中表": [["zhōng"], ["biǎo"]],
    "中波": [["zhōng"], ["bō"]],
    "中部": [["zhōng"], ["bù"]],
    "中彩": [["zhòng"], ["cǎi"]],
    "中餐": [["zhōng"], ["cān"]],
    "中策": [["zhōng"], ["cè"]],
    "中层": [["zhōng"], ["céng"]],
    "中产": [["zhōng"], ["chǎn"]],
    "中长": [["zhōng"], ["cháng"]],
    "中常": [["zhōng"], ["cháng"]],
    "中程": [["zhōng"], ["chéng"]],
    "中场": [["zhōng"], ["chǎng"]],
    "中辍": [["zhōng"], ["chuò"]],
    "中词": [["zhōng"], ["cí"]],
    "中弹": [["zhòng"], ["dàn"]],
    "中道": [["zhōng"], ["dào"]],
    "中稻": [["zhōng"], ["dào"]],
    "中的": [["zhōng"], ["de"]],
    "中等": [["zhōng"], ["děng"]],
    "中东": [["zhōng"], ["dōng"]],
    "中点": [["zhōng"], ["diǎn"]],
    "中都": [["zhōng"], ["dōu"]],
    "中毒": [["zhòng"], ["dú"]],
    "中度": [["zhōng"], ["dù"]],
    "中段": [["zhōng"], ["duàn"]],
    "中断": [["zhōng"], ["duàn"]],
    "中队": [["zhōng"], ["duì"]],
    "中耳": [["zhōng"], ["ěr"]],
    "中法": [["zhōng"], ["fǎ"]],
    "中幡": [["zhōng"], ["fān"]],
    "中饭": [["zhōng"], ["fàn"]],
    "中方": [["zhōng"], ["fāng"]],
    "中非": [["zhōng"], ["fēi"]],
    "中分": [["zhōng"], ["fēn"]],
    "中风": [["zhòng"], ["fēng"]],
    "中封": [["zhōng"], ["fēng"]],
    "中锋": [["zhōng"], ["fēng"]],
    "中缝": [["zhōng"], ["fèng"]],
    "中伏": [["zhōng"], ["fú"]],
    "中服": [["zhōng"], ["fú"]],
    "中府": [["zhōng"], ["fǔ"]],
    "中耕": [["zhōng"], ["gēng"]],
    "中古": [["zhōng"], ["gǔ"]],
    "中共": [["zhōng"], ["gòng"]],
    "中国": [["zhōng"], ["guó"]],
    "中号": [["zhōng"], ["hào"]],
    "中和": [["zhōng"], ["hé"]],
    "中华": [["zhōng"], ["huá"]],
    "中黄": [["zhōng"], ["huáng"]],
    "中级": [["zhōng"], ["jí"]],
    "中极": [["zhōng"], ["jí"]],
    "中计": [["zhòng"], ["jì"]],
    "中技": [["zhōng"], ["jì"]],
    "忠骨": [["zhōng"], ["gǔ"]],
    "忠仆": [["zhōng"], ["pú"]],
    "忠信": [["zhōng"], ["xìn"]],
    "终场": [["zhōng"], ["chǎng"]],
    "终将": [["zhōng"], ["jiāng"]],
    "终结": [["zhōng"], ["jié"]],
    "终了": [["zhōng"], ["liǎo"]],
    "钟头": [["zhōng"], ["tóu"]],
    "衷曲": [["zhōng"], ["qǔ"]],
    "肿大": [["zhǒng"], ["dà"]],
    "种别": [["zhǒng"], ["bié"]],
    "种菜": [["zhòng"], ["cài"]],
    "种草": [["zhǒng"], ["cǎo"]],
    "种差": [["zhǒng"], ["chà"]],
    "种蛋": [["zhǒng"], ["dàn"]],
    "种地": [["zhòng"], ["dì"]],
    "种痘": [["zhòng"], ["dòu"]],
    "种花": [["zhòng"], ["huā"]],
    "种类": [["zhǒng"], ["lèi"]],
    "种麻": [["zhǒng"], ["má"]],
    "种马": [["zhǒng"], ["mǎ"]],
    "种牛": [["zhòng"], ["niú"]],
    "种禽": [["zhǒng"], ["qín"]],
    "种群": [["zhǒng"], ["qún"]],
    "种树": [["zhòng"], ["shù"]],
    "种系": [["zhǒng"], ["xì"]],
    "种姓": [["zhǒng"], ["xìng"]],
    "种田": [["zhòng"], ["tián"]],
    "种畜": [["zhǒng"], ["chù"]],
    "种植": [["zhòng"], ["zhí"]],
    "种种": [["zhǒng"], ["zhǒng"]],
    "种籽": [["zhǒng"], ["zǐ"]],
    "种子": [["zhǒng"], ["zi"]],
    "仲家": [["zhòng"], ["jiā"]],
    "种族": [["zhǒng"], ["zú"]],
    "仲孙": [["zhòng"], ["sūn"]],
    "众数": [["zhòng"], ["shù"]],
    "众说": [["zhòng"], ["shuō"]],
    "重版": [["chóng"], ["bǎn"]],
    "重办": [["zhòng"], ["bàn"]],
    "重臂": [["zhòng"], ["bì"]],
    "重兵": [["zhòng"], ["bīng"]],
    "重播": [["chóng"], ["bō"]],
    "重彩": [["zhòng"], ["cǎi"]],
    "重茬": [["zhòng"], ["chá"]],
    "重唱": [["chóng"], ["chàng"]],
    "重臣": [["zhòng"], ["chén"]],
    "重惩": [["zhòng"], ["chéng"]],
    "重创": [["zhòng"], ["chuāng"]],
    "重出": [["chóng"], ["chū"]],
    "重大": [["zhòng"], ["dà"]],
    "重担": [["zhòng"], ["dàn"]],
    "重弹": [["chóng"], ["tán"]],
    "重地": [["zhòng"], ["dì"]],
    "重典": [["zhòng"], ["diǎn"]],
    "重点": [["zhòng"], ["diǎn"]],
    "重迭": [["zhòng"], ["dié"]],
    "重叠": [["chóng"], ["dié"]],
    "重读": [["zhòng"], ["dú"]],
    "重罚": [["zhòng"], ["fá"]],
    "重返": [["chóng"], ["fǎn"]],
    "重犯": [["chóng"], ["fàn"]],
    "重逢": [["chóng"], ["féng"]],
    "重负": [["zhòng"], ["fù"]],
    "重复": [["chóng"], ["fù"]],
    "重工": [["zhòng"], ["gōng"]],
    "重光": [["chóng"], ["guāng"]],
    "重合": [["chóng"], ["hé"]],
    "重荷": [["zhòng"], ["hè"]],
    "重话": [["zhòng"], ["huà"]],
    "重婚": [["chóng"], ["hūn"]],
    "重活": [["zhòng"], ["huó"]],
    "重价": [["zhòng"], ["jià"]],
    "重建": [["chóng"], ["jiàn"]],
    "重金": [["zhòng"], ["jīn"]],
    "重九": [["chóng"], ["jiǔ"]],
    "重聚": [["chóng"], ["jù"]],
    "重力": [["zhòng"], ["lì"]],
    "重利": [["zhòng"], ["lì"]],
    "重量": [["zhòng"], ["liàng"]],
    "重名": [["zhòng"], ["míng"]],
    "重楼": [["zhòng"], ["lóu"]],
    "重拍": [["chóng"], ["pāi"]],
    "重炮": [["zhòng"], ["pào"]],
    "重氢": [["zhòng"], ["qīng"]],
    "重庆": [["chóng"], ["qìng"]],
    "重任": [["zhòng"], ["rèn"]],
    "重伤": [["zhòng"], ["shāng"]],
    "重赏": [["zhòng"], ["shǎng"]],
    "重设": [["zhòng"], ["shè"]],
    "重申": [["chóng"], ["shēn"]],
    "重审": [["chóng"], ["shěn"]],
    "重生": [["zhòng"], ["shēng"]],
    "重视": [["zhòng"], ["shì"]],
    "重述": [["chóng"], ["shù"]],
    "重数": [["chóng"], ["shù"]],
    "重税": [["zhòng"], ["shuì"]],
    "重水": [["zhòng"], ["shuǐ"]],
    "重提": [["chóng"], ["tí"]],
    "重孙": [["chóng"], ["sūn"]],
    "重听": [["zhòng"], ["tīng"]],
    "重头": [["chóng"], ["tóu"]],
    "重托": [["zhòng"], ["tuō"]],
    "重望": [["zhòng"], ["wàng"]],
    "重围": [["chóng"], ["wéi"]],
    "重温": [["chóng"], ["wēn"]],
    "重物": [["zhòng"], ["wù"]],
    "重现": [["chóng"], ["xiàn"]],
    "重霄": [["chóng"], ["xiāo"]],
    "重孝": [["zhòng"], ["xiào"]],
    "重心": [["zhòng"], ["xīn"]],
    "重新": [["chóng"], ["xīn"]],
    "重行": [["chóng"], ["xíng"]],
    "重型": [["zhòng"], ["xíng"]],
    "重选": [["zhòng"], ["xuǎn"]],
    "重修": [["chóng"], ["xiū"]],
    "重压": [["zhòng"], ["yā"]],
    "重言": [["zhòng"], ["yán"]],
    "重檐": [["zhòng"], ["yán"]],
    "重演": [["chóng"], ["yǎn"]],
    "重阳": [["chóng"], ["yáng"]],
    "重洋": [["chóng"], ["yáng"]],
    "重要": [["zhòng"], ["yào"]],
    "重译": [["chóng"], ["yì"]],
    "重音": [["zhòng"], ["yīn"]],
    "重印": [["chóng"], ["yìn"]],
    "重影": [["chóng"], ["yǐng"]],
    "重映": [["chóng"], ["yìng"]],
    "重油": [["zhòng"], ["yóu"]],
    "重圆": [["chóng"], ["yuán"]],
    "重载": [["zhòng"], ["zài"]],
    "重责": [["zhòng"], ["zé"]],
    "重镇": [["zhòng"], ["zhèn"]],
    "重装": [["zhòng"], ["zhuāng"]],
    "重重": [["chóng"], ["chóng"]],
    "重子": [["zhòng"], ["zǐ"]],
    "重奏": [["chóng"], ["zòu"]],
    "重罪": [["zhòng"], ["zuì"]],
    "州长": [["zhōu"], ["zhǎng"]],
    "舟车": [["zhōu"], ["chē"]],
    "周长": [["zhōu"], ["cháng"]],
    "周会": [["zhōu"], ["huì"]],
    "周济": [["zhōu"], ["jì"]],
    "周期": [["zhōu"], ["qī"]],
    "周详": [["zhōu"], ["xiáng"]],
    "周旋": [["zhōu"], ["xuán"]],
    "周折": [["zhōu"], ["zhé"]],
    "周知": [["zhōu"], ["zhī"]],
    "周正": [["zhōu"], ["zhēng"]],
    "周转": [["zhōu"], ["zhuǎn"]],
    "轴衬": [["zhóu"], ["chèn"]],
    "轴承": [["zhóu"], ["chéng"]],
    "轴瓦": [["zhóu"], ["wǎ"]],
    "轴线": [["zhóu"], ["xiàn"]],
    "轴心": [["zhóu"], ["xīn"]],
    "轴子": [["zhóu"], ["zǐ"]],
    "咒语": [["zhòu"], ["yǔ"]],
    "皱缩": [["zhòu"], ["suō"]],
    "皱纹": [["zhòu"], ["wén"]],
    "骤降": [["zhòu"], ["jiàng"]],
    "骤雨": [["zhòu"], ["yǔ"]],
    "朱笔": [["zhū"], ["bǐ"]],
    "朱红": [["zhū"], ["hóng"]],
    "朱槿": [["zhū"], ["jǐn"]],
    "朱门": [["zhū"], ["mén"]],
    "朱诺": [["zhū"], ["nuò"]],
    "朱墨": [["zhū"], ["mò"]],
    "朱批": [["zhū"], ["pī"]],
    "朱漆": [["zhū"], ["qī"]],
    "朱雀": [["zhū"], ["què"]],
    "朱砂": [["zhū"], ["shā"]],
    "朱文": [["zhū"], ["wén"]],
    "朱熹": [["zhū"], ["xī"]],
    "珠蚌": [["zhū"], ["bàng"]],
    "珠被": [["zhū"], ["bèi"]],
    "诸葛": [["zhū"], ["gě"]],
    "诸侯": [["zhū"], ["hóu"]],
    "猪排": [["zhū"], ["pái"]],
    "竹杠": [["zhú"], ["gàng"]],
    "竹笼": [["zhú"], ["lóng"]],
    "竹节": [["zhú"], ["jié"]],
    "竹排": [["zhú"], ["pái"]],
    "竹叶": [["zhú"], ["yè"]],
    "烛台": [["zhú"], ["tái"]],
    "竹枝": [["zhú"], ["zhī"]],
    "逐个": [["zhú"], ["gè"]],
    "逐臭": [["zhú"], ["chòu"]],
    "逐渐": [["zhú"], ["jiàn"]],
    "逐句": [["zhú"], ["jù"]],
    "逐条": [["zhú"], ["tiáo"]],
    "主从": [["zhǔ"], ["cóng"]],
    "主调": [["zhǔ"], ["diào"]],
    "主干": [["zhǔ"], ["gàn"]],
    "主观": [["zhǔ"], ["guān"]],
    "主祭": [["zhǔ"], ["jì"]],
    "主家": [["zhǔ"], ["jiā"]],
    "主见": [["zhǔ"], ["jiàn"]],
    "主角": [["zhǔ"], ["jué"]],
    "主将": [["zhǔ"], ["jiàng"]],
    "主教": [["zhǔ"], ["jiào"]],
    "主句": [["zhǔ"], ["jù"]],
    "主任": [["zhǔ"], ["rèn"]],
    "主仆": [["zhǔ"], ["pú"]],
    "主上": [["zhǔ"], ["shàng"]],
    "主食": [["zhǔ"], ["shí"]],
    "主体": [["zhǔ"], ["tǐ"]],
    "主语": [["zhǔ"], ["yǔ"]],
    "主要": [["zhǔ"], ["yào"]],
    "主轴": [["zhǔ"], ["zhóu"]],
    "住地": [["zhù"], ["dì"]],
    "住处": [["zhù"], ["chù"]],
    "住读": [["zhù"], ["dú"]],
    "住家": [["zhù"], ["jiā"]],
    "住宿": [["zhù"], ["sù"]],
    "住校": [["zhù"], ["xiào"]],
    "助产": [["zhù"], ["chǎn"]],
    "助长": [["zhù"], ["zhǎng"]],
    "助词": [["zhù"], ["cí"]],
    "助耕": [["zhù"], ["gēng"]],
    "助工": [["zhù"], ["gōng"]],
    "助攻": [["zhù"], ["gōng"]],
    "助教": [["zhù"], ["jiào"]],
    "助力": [["zhù"], ["lì"]],
    "助理": [["zhù"], ["lǐ"]],
    "助跑": [["zhù"], ["pǎo"]],
    "助燃": [["zhù"], ["rán"]],
    "助威": [["zhù"], ["wēi"]],
    "助手": [["zhù"], ["shǒu"]],
    "助推": [["zhù"], ["tuī"]],
    "助兴": [["zhù"], ["xìng"]],
    "助学": [["zhù"], ["xué"]],
    "助益": [["zhù"], ["yì"]],
    "助研": [["zhù"], ["yán"]],
    "助战": [["zhù"], ["zhàn"]],
    "注解": [["zhù"], ["jiě"]],
    "助阵": [["zhù"], ["zhèn"]],
    "注射": [["zhù"], ["shè"]],
    "注重": [["zhù"], ["zhòng"]],
    "贮藏": [["zhù"], ["cáng"]],
    "驻地": [["zhù"], ["dì"]],
    "驻屯": [["zhù"], ["tún"]],
    "驻扎": [["zhù"], ["zhā"]],
    "柱石": [["zhù"], ["shí"]],
    "抓差": [["zhuā"], ["chāi"]],
    "抓斗": [["zhuā"], ["dòu"]],
    "爪儿": [["zhuǎ"], ["ér"]],
    "爪哇": [["zhǎo"], ["wā"]],
    "爪牙": [["zhǎo"], ["yá"]],
    "爪子": [["zhuǎ"], ["zǐ"]],
    "专差": [["zhuān"], ["chāi"]],
    "专长": [["zhuān"], ["cháng"]],
    "专车": [["zhuān"], ["chē"]],
    "专场": [["zhuān"], ["chǎng"]],
    "专柜": [["zhuān"], ["guì"]],
    "专号": [["zhuān"], ["hào"]],
    "专横": [["zhuān"], ["hèng"]],
    "专家": [["zhuān"], ["jiā"]],
    "专论": [["zhuān"], ["lùn"]],
    "专区": [["zhuān"], ["qū"]],
    "专任": [["zhuān"], ["rèn"]],
    "专有": [["zhuān"], ["yǒu"]],
    "专员": [["zhuān"], ["yuán"]],
    "专著": [["zhuān"], ["zhù"]],
    "砖厂": [["zhuān"], ["chǎng"]],
    "砖头": [["zhuān"], ["tóu"]],
    "转变": [["zhuǎn"], ["biàn"]],
    "转播": [["zhuǎn"], ["bō"]],
    "转产": [["zhuǎn"], ["chǎn"]],
    "转场": [["zhuǎn"], ["chǎng"]],
    "转车": [["zhuǎn"], ["chē"]],
    "转乘": [["zhuǎn"], ["chéng"]],
    "转船": [["zhuǎn"], ["chuán"]],
    "转导": [["zhuǎn"], ["dǎo"]],
    "转达": [["zhuǎn"], ["dá"]],
    "转道": [["zhuǎn"], ["dào"]],
    "转递": [["zhuǎn"], ["dì"]],
    "转调": [["zhuǎn"], ["diào"]],
    "转动": [["zhuàn"], ["dòng"]],
    "转发": [["zhuǎn"], ["fā"]],
    "转干": [["zhuǎn"], ["gàn"]],
    "转告": [["zhuǎn"], ["gào"]],
    "转换": [["zhuǎn"], ["huàn"]],
    "转化": [["zhuǎn"], ["huà"]],
    "转回": [["zhuǎn"], ["huí"]],
    "转机": [["zhuǎn"], ["jī"]],
    "转寄": [["zhuǎn"], ["jì"]],
    "转嫁": [["zhuǎn"], ["jià"]],
    "转交": [["zhuǎn"], ["jiāo"]],
    "转角": [["zhuǎn"], ["jiǎo"]],
    "转接": [["zhuǎn"], ["jiē"]],
    "转筋": [["zhuàn"], ["jīn"]],
    "转借": [["zhuǎn"], ["jiè"]],
    "转矩": [["zhuàn"], ["jǔ"]],
    "转科": [["zhuǎn"], ["kē"]],
    "转口": [["zhuǎn"], ["kǒu"]],
    "转脸": [["zhuǎn"], ["liǎn"]],
    "转捩": [["zhuǎn"], ["liè"]],
    "转炉": [["zhuàn"], ["lú"]],
    "转轮": [["zhuàn"], ["lún"]],
    "转卖": [["zhuǎn"], ["mài"]],
    "转门": [["zhuàn"], ["mén"]],
    "转磨": [["zhuàn"], ["mò"]],
    "转念": [["zhuǎn"], ["niàn"]],
    "转年": [["zhuǎn"], ["nián"]],
    "转盘": [["zhuǎn"], ["pán"]],
    "转圈": [["zhuàn"], ["quān"]],
    "转让": [["zhuǎn"], ["ràng"]],
    "转任": [["zhuǎn"], ["rèn"]],
    "转入": [["zhuǎn"], ["rù"]],
    "转身": [["zhuǎn"], ["shēn"]],
    "转生": [["zhuǎn"], ["shēng"]],
    "转世": [["zhuǎn"], ["shì"]],
    "转手": [["zhuǎn"], ["shǒu"]],
    "转述": [["zhuǎn"], ["shù"]],
    "转瞬": [["zhuǎn"], ["shùn"]],
    "转送": [["zhuǎn"], ["sòng"]],
    "转速": [["zhuàn"], ["sù"]],
    "转台": [["zhuàn"], ["tái"]],
    "转体": [["zhuǎn"], ["tǐ"]],
    "转头": [["zhuǎn"], ["tóu"]],
    "转托": [["zhuǎn"], ["tuō"]],
    "转弯": [["zhuǎn"], ["wān"]],
    "转文": [["zhuǎi"], ["wén"]],
    "转徙": [["zhuǎn"], ["xǐ"]],
    "转向": [["zhuǎn"], ["xiàng"]],
    "转写": [["zhuǎn"], ["xiě"]],
    "转行": [["zhuǎn"], ["háng"]],
    "转学": [["zhuǎn"], ["xué"]],
    "转眼": [["zhuǎn"], ["yǎn"]],
    "转业": [["zhuǎn"], ["yè"]],
    "转移": [["zhuǎn"], ["yí"]],
    "转义": [["zhuǎn"], ["yì"]],
    "转椅": [["zhuàn"], ["yǐ"]],
    "转译": [["zhuǎn"], ["yì"]],
    "转引": [["zhuǎn"], ["yǐn"]],
    "转悠": [["zhuàn"], ["yōu"]],
    "转圜": [["zhuǎn"], ["huán"]],
    "转运": [["zhuǎn"], ["yùn"]],
    "转赠": [["zhuǎn"], ["zèng"]],
    "转载": [["zhuǎn"], ["zǎi"]],
    "转战": [["zhuǎn"], ["zhàn"]],
    "转帐": [["zhuǎn"], ["zhàng"]],
    "转折": [["zhuǎn"], ["zhé"]],
    "转账": [["zhuǎn"], ["zhàng"]],
    "转诊": [["zhuǎn"], ["zhěn"]],
    "转正": [["zhuǎn"], ["zhèng"]],
    "转职": [["zhuǎn"], ["zhí"]],
    "转轴": [["zhuǎn"], ["zhóu"]],
    "转注": [["zhuǎn"], ["zhù"]],
    "转转": [["zhuǎn"], ["zhuǎn"]],
    "转子": [["zhuàn"], ["zǐ"]],
    "转租": [["zhuǎn"], ["zū"]],
    "赚头": [["zhuàn"], ["tou"]],
    "赚得": [["zuàn"], ["de"]],
    "撰著": [["zhu&agrave;nzh&ugrave;"]],
    "篆体": [["zhuàn"], ["tǐ"]],
    "庄家": [["zhuāng"], ["jiā"]],
    "庄重": [["zhuāng"], ["zhòng"]],
    "装潢": [["zhuāng"], ["huáng"]],
    "壮大": [["zhuàng"], ["dà"]],
    "壮丁": [["zhuàng"], ["dīng"]],
    "壮丽": [["zhuàng"], ["lì"]],
    "壮硕": [["zhuàng"], ["shuò"]],
    "壮观": [["zhuàng"], ["guān"]],
    "壮语": [["zhuàng"], ["yǔ"]],
    "幢幢": [["chuáng"], ["chuáng"]],
    "状语": [["zhuàng"], ["yǔ"]],
    "撞车": [["zhuàng"], ["chē"]],
    "撞坏": [["zhuàng"], ["huài"]],
    "撞见": [["zhuàng"], ["jiàn"]],
    "追逼": [["zhuī"], ["bī"]],
    "追比": [["zhuī"], ["bǐ"]],
    "追补": [["zhuī"], ["bǔ"]],
    "追兵": [["zhuī"], ["bīng"]],
    "追捕": [["zhuī"], ["bǔ"]],
    "追查": [["zhuī"], ["zhā"]],
    "追悼": [["zhuī"], ["dào"]],
    "追肥": [["zhuī"], ["féi"]],
    "追风": [["zhuī"], ["fēng"]],
    "追根": [["zhuī"], ["gēn"]],
    "追怀": [["zhuī"], ["huái"]],
    "追赶": [["zhuī"], ["gǎn"]],
    "追还": [["zhuī"], ["huán"]],
    "追悔": [["zhuī"], ["huǐ"]],
    "追击": [["zhuī"], ["jī"]],
    "追魂": [["zhuī"], ["hún"]],
    "追缉": [["zhuī"], ["jī"]],
    "追记": [["zhuī"], ["jì"]],
    "追加": [["zhuī"], ["jiā"]],
    "追歼": [["zhuī"], ["jiān"]],
    "追剿": [["zhuī"], ["jiǎo"]],
    "追究": [["zhuī"], ["jiū"]],
    "追缴": [["zhuī"], ["jiǎo"]],
    "追念": [["zhuī"], ["niàn"]],
    "追求": [["zhuī"], ["qiú"]],
    "追认": [["zhuī"], ["rèn"]],
    "追授": [["zhuī"], ["shòu"]],
    "追述": [["zhuī"], ["shù"]],
    "追思": [["zhuī"], ["sī"]],
    "追诉": [["zhuī"], ["sù"]],
    "追溯": [["zhuī"], ["sù"]],
    "追随": [["zhuī"], ["suí"]],
    "追索": [["zhuī"], ["suǒ"]],
    "追讨": [["zhuī"], ["tǎo"]],
    "追尾": [["zhuī"], ["wěi"]],
    "追问": [["zhuī"], ["wèn"]],
    "追想": [["zhuī"], ["xiǎng"]],
    "追叙": [["zhuī"], ["xù"]],
    "追寻": [["zhuī"], ["xún"]],
    "追忆": [["zhuī"], ["yì"]],
    "追赃": [["zhuī"], ["zāng"]],
    "追赠": [["zhuī"], ["zèng"]],
    "追逐": [["zhuī"], ["zhú"]],
    "追踪": [["zhuī"], ["zōng"]],
    "锥度": [["zhuī"], ["dù"]],
    "锥体": [["zhuī"], ["tǐ"]],
    "坠地": [["zhuì"], ["dì"]],
    "坠落": [["zhuì"], ["luò"]],
    "准将": [["zhǔn"], ["jiàng"]],
    "准据": [["zhǔn"], ["jù"]],
    "准头": [["zhǔn"], ["tou"]],
    "准信": [["zhǔn"], ["xìn"]],
    "准许": [["zhǔn"], ["xǔ"]],
    "准予": [["zhǔn"], ["yǔ"]],
    "卓识": [["zhuó"], ["shí"]],
    "卓见": [["zhuó"], ["jiàn"]],
    "卓著": [["zhuó"], ["zhù"]],
    "拙见": [["zhuō"], ["jiàn"]],
    "拙著": [["zhuō"], ["zhù"]],
    "拙朴": [["zhuō"], ["piáo"]],
    "捉弄": [["zhuō"], ["nòng"]],
    "灼见": [["zhuó"], ["jiàn"]],
    "茁长": [["zhuó"], ["zhǎng"]],
    "浊度": [["zhuó"], ["dù"]],
    "酌处": [["zhuó"], ["chǔ"]],
    "酌量": [["zhuó"], ["liàng"]],
    "着边": [["zhuó"], ["biān"]],
    "着凉": [["zháo"], ["liáng"]],
    "着迷": [["zháo"], ["mí"]],
    "着数": [["zhāo"], ["shù"]],
    "着意": [["zhuó"], ["yì"]],
    "濯濯": [["zhuó"], ["zhuó"]],
    "仔鸡": [["zǐ"], ["jī"]],
    "仔肩": [["zǐ"], ["jiān"]],
    "仔密": [["zǐ"], ["mì"]],
    "仔细": [["zǐ"], ["xì"]],
    "仔畜": [["zǐ"], ["chù"]],
    "仔猪": [["zǐ"], ["zhū"]],
    "仔鱼": [["zǐ"], ["yú"]],
    "资助": [["zī"], ["zhù"]],
    "辎重": [["zī"], ["zhòng"]],
    "趑趄": [["zī"], ["jū"]],
    "籽种": [["zǐ"], ["zhǒng"]],
    "子弹": [["zǐ"], ["dàn"]],
    "子弟": [["zǐ"], ["dì"]],
    "子句": [["zǐ"], ["jù"]],
    "子囊": [["zǐ"], ["náng"]],
    "子女": [["zǐ"], ["nǚ"]],
    "子孙": [["zǐ"], ["sūn"]],
    "子畜": [["zǐ"], ["chù"]],
    "子叶": [["zǐ"], ["yè"]],
    "姊夫": [["zǐ"], ["fū"]],
    "字调": [["zì"], ["diào"]],
    "字号": [["zì"], ["hào"]],
    "字节": [["zì"], ["jié"]],
    "字句": [["zì"], ["jù"]],
    "字据": [["zì"], ["jù"]],
    "字模": [["zì"], ["mú"]],
    "字数": [["zì"], ["shù"]],
    "字体": [["zì"], ["tǐ"]],
    "字条": [["zì"], ["tiáo"]],
    "字帖": [["zì"], ["tiè"]],
    "自便": [["zì"], ["biàn"]],
    "自嘲": [["zì"], ["cháo"]],
    "自称": [["zì"], ["chēng"]],
    "自乘": [["zì"], ["chéng"]],
    "自传": [["zì"], ["zhuàn"]],
    "自从": [["zì"], ["cóng"]],
    "自打": [["zì"], ["dǎ"]],
    "自大": [["zì"], ["dà"]],
    "自当": [["zì"], ["dāng"]],
    "自得": [["zì"], ["dé"]],
    "自渎": [["zì"], ["dú"]],
    "自发": [["zì"], ["fā"]],
    "自分": [["zì"], ["fēn"]],
    "自给": [["zì"], ["jǐ"]],
    "自供": [["zì"], ["gòng"]],
    "自汗": [["zì"], ["hàn"]],
    "自家": [["zì"], ["jiā"]],
    "自矜": [["zì"], ["jīn"]],
    "自尽": [["zì"], ["jìn"]],
    "自禁": [["zì"], ["jīn"]],
    "自净": [["zì"], ["jìng"]],
    "自觉": [["zì"], ["jué"]],
    "自夸": [["zì"], ["kuā"]],
    "自量": [["zì"], ["liàng"]],
    "自强": [["zì"], ["qiáng"]],
    "自若": [["zì"], ["ruò"]],
    "自省": [["zì"], ["xǐng"]],
    "自食": [["zì"], ["shí"]],
    "自信": [["zì"], ["xìn"]],
    "自行": [["zì"], ["xíng"]],
    "自许": [["zì"], ["xǔ"]],
    "自旋": [["zì"], ["xuán"]],
    "自知": [["zì"], ["zhī"]],
    "自重": [["zì"], ["zhòng"]],
    "自助": [["zì"], ["zhù"]],
    "恣睢": [["zì"], ["suī"]],
    "自转": [["zì"], ["zhuàn"]],
    "恣纵": [["zì"], ["zòng"]],
    "宗教": [["zōng"], ["jiào"]],
    "宗仰": [["zōng"], ["yǎng"]],
    "宗亲": [["zōng"], ["qīn"]],
    "综合": [["zōng"], ["hé"]],
    "综述": [["zōng"], ["shù"]],
    "鬃刷": [["zōng"], ["shuā"]],
    "总长": [["zǒng"], ["zhǎng"]],
    "总称": [["zǒng"], ["chēng"]],
    "总得": [["zǒng"], ["děi"]],
    "总共": [["zǒng"], ["gòng"]],
    "总合": [["zǒng"], ["hé"]],
    "总和": [["zǒng"], ["hé"]],
    "总价": [["zǒng"], ["jià"]],
    "总监": [["zǒng"], ["jiān"]],
    "总角": [["zǒng"], ["jiǎo"]],
    "总结": [["zǒng"], ["jié"]],
    "总括": [["zǒng"], ["kuò"]],
    "总量": [["zǒng"], ["liàng"]],
    "总论": [["zǒng"], ["lùn"]],
    "总数": [["zǒng"], ["shù"]],
    "总体": [["zǒng"], ["tǐ"]],
    "总行": [["zǒng"], ["xíng"]],
    "总校": [["zǒng"], ["xiào"]],
    "纵波": [["zòng"], ["bō"]],
    "纵步": [["zòng"], ["bù"]],
    "纵荡": [["zòng"], ["dàng"]],
    "纵队": [["zòng"], ["duì"]],
    "纵观": [["zòng"], ["guān"]],
    "纵贯": [["zòng"], ["guàn"]],
    "纵横": [["zòng"], ["héng"]],
    "纵酒": [["zòng"], ["jiǔ"]],
    "纵火": [["zòng"], ["huǒ"]],
    "纵览": [["zòng"], ["lǎn"]],
    "纵令": [["zòng"], ["lìng"]],
    "纵论": [["zòng"], ["lùn"]],
    "纵目": [["zòng"], ["mù"]],
    "纵情": [["zòng"], ["qíng"]],
    "纵然": [["zòng"], ["rán"]],
    "纵容": [["zòng"], ["róng"]],
    "纵身": [["zòng"], ["shēn"]],
    "纵深": [["zòng"], ["shēn"]],
    "纵声": [["zòng"], ["shēng"]],
    "纵使": [["zòng"], ["shǐ"]],
    "纵谈": [["zòng"], ["tán"]],
    "纵向": [["zòng"], ["xiàng"]],
    "纵欲": [["zòng"], ["yù"]],
    "走调": [["zǒu"], ["diào"]],
    "走风": [["zǒu"], ["fēng"]],
    "走读": [["zǒu"], ["dú"]],
    "走红": [["zǒu"], ["hóng"]],
    "走俏": [["zǒu"], ["qiào"]],
    "走散": [["zǒu"], ["sàn"]],
    "走卒": [["zǒu"], ["zú"]],
    "奏乐": [["zòu"], ["yuè"]],
    "奏折": [["zòu"], ["zhé"]],
    "租地": [["zū"], ["dì"]],
    "租佃": [["zū"], ["diàn"]],
    "租价": [["zū"], ["jià"]],
    "租约": [["zū"], ["yuē"]],
    "足底": [["zú"], ["dǐ"]],
    "租种": [["zū"], ["zhǒng"]],
    "足见": [["zú"], ["jiàn"]],
    "卒年": [["zú"], ["nián"]],
    "卒岁": [["zú"], ["suì"]],
    "卒业": [["zú"], ["yè"]],
    "卒子": [["zú"], ["zǐ"]],
    "阻挡": [["zǔ"], ["dǎng"]],
    "阻难": [["zǔ"], ["nàn"]],
    "阻塞": [["zǔ"], ["sè"]],
    "组分": [["zǔ"], ["fèn"]],
    "组合": [["zǔ"], ["hé"]],
    "组曲": [["zǔ"], ["qǔ"]],
    "组员": [["zǔ"], ["yuán"]],
    "组织": [["zǔ"], ["zhī"]],
    "祖传": [["zǔ"], ["chuán"]],
    "祖父": [["zǔ"], ["fù"]],
    "祖率": [["zǔ"], ["lǜ"]],
    "祖上": [["zǔ"], ["shàng"]],
    "祖孙": [["zǔ"], ["sūn"]],
    "钻床": [["zuàn"], ["chuáng"]],
    "钻洞": [["zuān"], ["dòng"]],
    "钻杆": [["zuàn"], ["gǎn"]],
    "钻机": [["zuàn"], ["jī"]],
    "钻戒": [["zuàn"], ["jiè"]],
    "钻劲": [["zuān"], ["jìn"]],
    "钻井": [["zuàn"], ["jǐng"]],
    "钻孔": [["zuān"], ["kǒng"]],
    "钻谋": [["zuān"], ["móu"]],
    "钻石": [["zuàn"], ["shí"]],
    "钻塔": [["zuàn"], ["tǎ"]],
    "钻台": [["zuàn"], ["tái"]],
    "钻探": [["zuān"], ["tàn"]],
    "钻头": [["zuàn"], ["tóu"]],
    "钻心": [["zuān"], ["xīn"]],
    "钻研": [["zuān"], ["yán"]],
    "钻营": [["zuān"], ["yíng"]],
    "嘴角": [["zuǐ"], ["jiǎo"]],
    "嘴头": [["zuǐ"], ["tóu"]],
    "罪恶": [["zuì"], ["è"]],
    "罪过": [["zuì"], ["guò"]],
    "罪行": [["zuì"], ["xíng"]],
    "遵从": [["zūn"], ["cóng"]],
    "遵行": [["zūn"], ["xíng"]],
    "撙节": [["zǔn"], ["jié"]],
    "左侧": [["zuǒ"], ["cè"]],
    "左券": [["zuǒ"], ["quàn"]],
    "左转": [["zuǒ"], ["zhuǎn"]],
    "作罢": [["zuò"], ["bà"]],
    "作别": [["zuò"], ["bié"]],
    "作答": [["zuò"], ["dá"]],
    "作恶": [["zuò"], ["è"]],
    "作坊": [["zuō"], ["fang"]],
    "作风": [["zuò"], ["fēng"]],
    "作家": [["zuò"], ["jiā"]],
    "作价": [["zuò"], ["jià"]],
    "作假": [["zuò"], ["jiǎ"]],
    "作乐": [["zuò"], ["yuè"]],
    "作难": [["zuò"], ["nán"]],
    "作弄": [["zuō"], ["nòng"]],
    "作曲": [["zuò"], ["qǔ"]],
    "作数": [["zuò"], ["shù"]],
    "作为": [["zuò"], ["wéi"]],
    "作呕": [["zuò"], ["ǒu"]],
    "坐禅": [["zuò"], ["chán"]],
    "坐车": [["zuò"], ["chē"]],
    "作兴": [["zuò"], ["xīng"]],
    "坐大": [["zuò"], ["dà"]],
    "坐待": [["zuò"], ["dài"]],
    "坐骨": [["zuò"], ["gǔ"]],
    "坐化": [["zuò"], ["huà"]],
    "坐监": [["zuò"], ["jiān"]],
    "坐落": [["zuò"], ["luò"]],
    "坐上": [["zuò"], ["shàng"]],
    "坐台": [["zuò"], ["tái"]],
    "柞蚕": [["zuò"], ["cán"]],
    "座号": [["zuò"], ["hào"]],
    "座落": [["zuò"], ["luò"]],
    "做假": [["zuò"], ["jiǎ"]],
    "做亲": [["zuò"], ["qīn"]],
    "阿比让": [["ā"], ["bǐ"], ["ràng"]],
    "阿鼻地狱": [["ā"], ["bí"], ["dì"], ["yù"]],
    "阿波罗": [["ā"], ["bō"], ["luó"]],
    "阿昌族": [["ā"], ["chāng"], ["zú"]],
    "阿党比周": [["ē"], ["dǎng"], ["bǐ"], ["zhōu"]],
    "阿党相为": [["ē"], ["dǎng"], ["xiāng"], ["wéi"]],
    "阿的平": [["ā"], ["dì"], ["píng"]],
    "阿尔卑斯山脉": [["ā"], ["ěr"], ["bēi"], ["sī"], ["shān"], ["mài"]],
    "阿尔巴尼亚": [["ā"], ["ěr"], ["bā"], ["ní"], ["yà"]],
    "阿尔法射线": [["ā"], ["ěr"], ["fǎ"], ["shè"], ["xiàn"]],
    "阿尔及利亚": [["ā"], ["ěr"], ["jí"], ["lì"], ["yà"]],
    "阿尔及尔": [["ā"], ["ěr"], ["jí"], ["ěr"]],
    "阿房宫": [["ē"], ["páng"], ["gōng"]],
    "阿富汗": [["ā"], ["fù"], ["hàn"]],
    "阿根廷": [["ā"], ["gēn"], ["tíng"]],
    "阿狗阿猫": [["ā"], ["gǒu"], ["ā"], ["māo"]],
    "阿姑阿翁": [["ā"], ["gū"], ["ā"], ["wēng"]],
    "阿基米德": [["ā"], ["jī"], ["mǐ"], ["dé"]],
    "阿家阿翁": [["ā"], ["gū"], ["ā"], ["wēng"]],
    "阿娇金屋": [["ā"], ["jiāo"], ["jīn"], ["wū"]],
    "阿拉伯国家": [["ā"], ["lā"], ["bó"], ["guó"], ["jiā"]],
    "阿拉伯半岛": [["ā"], ["lā"], ["bó"], ["bàn"], ["dǎo"]],
    "阿拉伯海": [["ā"], ["lā"], ["bó"], ["hǎi"]],
    "阿拉伯联合酋长国": [["ā"], ["lā"], ["bó"], ["lián"], ["hé"], ["qiú"], ["zhǎng"], ["guó"]],
    "阿拉伯人": [["ā"], ["lā"], ["bó"], ["rén"]],
    "阿拉伯数字": [["ā"], ["lā"], ["bó"], ["shù"], ["zì"]],
    "阿拉伯语": [["ā"], ["lā"], ["bó"], ["yǔ"]],
    "阿里山": [["ā"], ["lǐ"], ["shān"]],
    "阿鲁巴岛": [["ā"], ["lǔ"], ["bā"], ["dǎo"]],
    "阿留申群岛": [["ā"], ["liú"], ["shēn"], ["qún"], ["dǎo"]],
    "阿罗汉": [["ā"], ["luó"], ["hàn"]],
    "阿猫阿狗": [["ā"], ["māo"], ["ā"], ["gǒu"]],
    "阿弥陀佛": [["ē"], ["mí"], ["tuó"], ["fó"]],
    "阿米巴痢疾": [["ā"], ["mǐ"], ["bā"], ["lì"], ["jí"]],
    "阿姆斯特丹": [["ā"], ["mǔ"], ["sī"], ["tè"], ["dān"]],
    "阿毗地狱": [["ā"], ["pí"], ["dì"], ["yù"]],
    "阿平绝倒": [["ā"], ["píng"], ["jué"], ["dǎo"]],
    "阿其所好": [["ē"], ["qí"], ["suǒ"], ["hào"]],
    "阿塞拜疆": [["ā"], ["sāi"], ["bài"], ["jiāng"]],
    "阿时趋俗": [["ē"], ["shí"], ["qū"], ["sú"]],
    "阿世盗名": [["ē"], ["shì"], ["dào"], ["míng"]],
    "阿世取容": [["ē"], ["shì"], ["qǔ"], ["róng"]],
    "阿世媚俗": [["ē"], ["shì"], ["mèi"], ["sú"]],
    "阿意取容": [["ē"], ["yì"], ["qǔ"], ["róng"]],
    "阿谀谄媚": [["ē"], ["yú"], ["chǎn"], ["mèi"]],
    "阿谀逢迎": [["ē"], ["yú"], ["féng"], ["yíng"]],
    "阿谀奉承": [["ē"], ["yú"], ["fèng"], ["chéng"]],
    "阿谀取容": [["ē"], ["yú"], ["qǔ"], ["róng"]],
    "哀哀父母": [["āi"], ["āi"], ["fù"], ["mǔ"]],
    "哀的美敦书": [["āi"], ["de"], ["měi"], ["dūn"], ["shū"]],
    "哀而不伤": [["āi"], ["ér"], ["bù"], ["shāng"]],
    "哀感天地": [["āi"], ["gǎn"], ["tiān"], ["dì"]],
    "哀感中年": [["āi"], ["gǎn"], ["zhōng"], ["nián"]],
    "哀告宾服": [["āi"], ["gào"], ["bīn"], ["fú"]],
    "哀鸿遍地": [["āi"], ["hóng"], ["biàn"], ["dì"]],
    "哀毁骨立": [["āi"], ["huǐ"], ["gǔ"], ["lì"]],
    "哀梨蒸食": [["āi"], ["lí"], ["zhēng"], ["shí"]],
    "哀思如潮": [["āi"], ["sī"], ["rú"], ["cháo"]],
    "哀天叫地": [["āi"], ["tiān"], ["jiào"], ["dì"]],
    "哀莫大于心死": [["āi"], ["mò"], ["dà"], ["yú"], ["xīn"], ["sǐ"]],
    "唉声叹气": [["āi"], ["shēng"], ["tàn"], ["qì"]],
    "埃菲尔铁塔": [["āi"], ["fēi"], ["ěr"], ["tiě"], ["tǎ"]],
    "埃塞俄比亚": [["āi"], ["sāi"], ["é"], ["bǐ"], ["yà"]],
    "挨冻受饿": [["ái"], ["dòng"], ["shòu"], ["è"]],
    "挨风缉缝": [["āi"], ["fēng"], ["jī"], ["fèng"]],
    "挨家挨户": [["āi"], ["ji"], ["āi"], ["hù"]],
    "挨肩并足": [["āi"], ["jiān"], ["bìng"], ["zú"]],
    "挨肩擦背": [["āi"], ["jiān"], ["cā"], ["bèi"]],
    "挨肩擦膀": [["āi"], ["jiān"], ["cā"], ["bǎng"]],
    "挨肩擦脸": [["āi"], ["jiān"], ["cā"], ["liǎn"]],
    "挨肩搭背": [["āi"], ["jiān"], ["dā"], ["bèi"]],
    "挨肩迭背": [["āi"], ["jiān"], ["dié"], ["bèi"]],
    "挨肩叠背": [["āi"], ["jiān"], ["dié"], ["bèi"]],
    "挨门挨户": [["āi"], ["mén"], ["āi"], ["hù"]],
    "挨门逐户": [["āi"], ["mén"], ["zhú"], ["hù"]],
    "挨三顶五": [["āi"], ["sān"], ["dǐng"], ["wǔ"]],
    "挨山塞海": [["āi"], ["shān"], ["sè"], ["hǎi"]],
    "捱风缉缝": [["āi"], ["fēng"], ["qī"], ["fèng"]],
    "嗳声叹气": [["ài"], ["shēng"], ["tàn"], ["qì"]],
    "矮个子": [["ǎi"], ["gè"], ["zi"]],
    "矮人观场": [["ǎi"], ["rén"], ["guān"], ["cháng"]],
    "矮人看场": [["ǎi"], ["rén"], ["kàn"], ["chǎng"]],
    "矮子观场": [["ǎi"], ["zǐ"], ["guān"], ["cháng"]],
    "矮人看戏": [["ǎi"], ["rén"], ["kàn"], ["xì"]],
    "矮子看戏": [["ǎi"], ["zǐ"], ["kàn"], ["xì"]],
    "蔼然可亲": [["ǎi"], ["rán"], ["kě"], ["qīn"]],
    "爱别离苦": [["ài"], ["bié"], ["lí"], ["kǔ"]],
    "爱博而情不专": [["ài"], ["bó"], ["ér"], ["qíng"], ["bù"], ["zhuān"]],
    "爱不忍释": [["ài"], ["bù"], ["rěn"], ["shì"]],
    "爱不释手": [["ài"], ["bù"], ["shì"], ["shǒu"]],
    "爱才若渴": [["ài"], ["cái"], ["ruò"], ["kě"]],
    "爱答不理": [["ài"], ["dá"], ["bù"], ["lǐ"]],
    "爱国如家": [["ài"], ["guó"], ["rú"], ["jiā"]],
    "爱礼存羊": [["ài"], ["lǐ"], ["cún"], ["yáng"]],
    "爱丽舍宫": [["ài"], ["lì"], ["shè"], ["gōng"]],
    "爱莫能助": [["ài"], ["mò"], ["néng"], ["zhù"]],
    "爱莫之助": [["ài"], ["mò"], ["zhī"], ["zhù"]],
    "爱人好士": [["ài"], ["rén"], ["hào"], ["shì"]],
    "爱沙尼亚人": [["ài"], ["shā"], ["ní"], ["yà"], ["rén"]],
    "爱生恶死": [["ài"], ["shēng"], ["wù"], ["sǐ"]],
    "爱斯基摩人": [["ài"], ["sī"], ["jī"], ["mó"], ["rén"]],
    "爱素好古": [["ài"], ["sù"], ["hào"], ["gǔ"]],
    "爱憎分明": [["ài"], ["zēng"], ["fēn"], ["míng"]],
    "爱之欲其生": [["ài"], ["zhī"], ["yù"], ["qí"], ["shēng"]],
    "碍口识羞": [["ài"], ["kǒu"], ["shí"], ["xiū"]],
    "碍难从命": [["ài"], ["nán"], ["cóng"], ["mìng"]],
    "暧昧不明": [["ài"], ["mèi"], ["bù"], ["míng"]],
    "安不忘危": [["ān"], ["bù"], ["wàng"], ["wēi"]],
    "安步当车": [["ān"], ["bù"], ["dàng"], ["chē"]],
    "安常处顺": [["ān"], ["cháng"], ["chǔ"], ["shùn"]],
    "安常守分": [["ān"], ["cháng"], ["shǒu"], ["fèn"]],
    "安车蒲轮": [["ān"], ["chē"], ["pú"], ["lún"]],
    "安定团结": [["ān"], ["dìng"], ["tuán"], ["jié"]],
    "安堵乐业": [["ān"], ["dǔ"], ["lè"], ["yè"]],
    "安分守己": [["ān"], ["fèn"], ["shǒu"], ["jǐ"]],
    "安分知足": [["ān"], ["fèn"], ["zhī"], ["zú"]],
    "安份守己": [["ān"], ["fèn"], ["shǒu"], ["jǐ"]],
    "安故重迁": [["ān"], ["gù"], ["zhòng"], ["qiān"]],
    "安哥拉": [["ān"], ["gē"], ["lā"]],
    "安圭拉岛": [["ān"], ["guī"], ["lā"], ["dǎo"]],
    "安国宁家": [["ān"], ["guó"], ["níng"], ["jiā"]],
    "安徽省": [["ān"], ["huī"], ["shěng"]],
    "安魂曲": [["ān"], ["hún"], ["qǔ"]],
    "安家费": [["ān"], ["jiā"], ["fèi"]],
    "安家乐业": [["ān"], ["jiā"], ["lè"], ["yè"]],
    "安家立业": [["ān"], ["jiā"], ["lì"], ["yè"]],
    "安家落户": [["ān"], ["jiā"], ["luò"], ["hù"]],
    "安居乐业": [["ān"], ["jū"], ["lè"], ["yè"]],
    "安老怀少": [["ān"], ["lǎo"], ["huái"], ["shào"]],
    "安乐死": [["ān"], ["lè"], ["sǐ"]],
    "安乐窝": [["ān"], ["lè"], ["wō"]],
    "安乐椅": [["ān"], ["lè"], ["yǐ"]],
    "安理会": [["ān"], ["lǐ"], ["huì"]],
    "安内攘外": [["ān"], ["nèi"], ["rǎng"], ["wài"]],
    "安良除暴": [["ān"], ["liáng"], ["chú"], ["bào"]],
    "安贫乐道": [["ān"], ["pín"], ["lè"], ["dào"]],
    "安贫乐贱": [["ān"], ["pín"], ["lè"], ["jiàn"]],
    "安全电压": [["ān"], ["quán"], ["diàn"], ["yā"]],
    "安全理事会": [["ān"], ["quán"], ["lǐ"], ["shì"], ["huì"]],
    "安全系数": [["ān"], ["quán"], ["xì"], ["shù"]],
    "安忍无亲": [["ān"], ["rěn"], ["wú"], ["qīn"]],
    "安如磐石": [["ān"], ["rú"], ["pán"], ["shí"]],
    "安若泰山": [["ān"], ["ruò"], ["tài"], ["shān"]],
    "安身乐业": [["ān"], ["shēn"], ["lè"], ["yè"]],
    "安身为乐": [["ān"], ["shēn"], ["wéi"], ["lè"]],
    "安身之地": [["ān"], ["shēn"], ["zhī"], ["dì"]],
    "安身之处": [["ān"], ["shēn"], ["zhī"], ["chù"]],
    "安生服业": [["ān"], ["shēng"], ["fú"], ["yè"]],
    "安生乐业": [["ān"], ["shēng"], ["lè"], ["yè"]],
    "安时处顺": [["ān"], ["shí"], ["chǔ"], ["shùn"]],
    "安室利处": [["ān"], ["shì"], ["lì"], ["chù"]],
    "安土乐业": [["ān"], ["tǔ"], ["lè"], ["yè"]],
    "安土重旧": [["ān"], ["tǔ"], ["zhòng"], ["jiù"]],
    "安土重居": [["ān"], ["tǔ"], ["zhòng"], ["jū"]],
    "安危与共": [["ān"], ["wēi"], ["yǔ"], ["gòng"]],
    "安土重迁": [["ān"], ["tǔ"], ["zhòng"], ["qiān"]],
    "安危相易": [["ān"], ["wēi"], ["xiāng"], ["yì"]],
    "安闲自得": [["ān"], ["xián"], ["zì"], ["dé"]],
    "安心乐业": [["ān"], ["xīn"], ["lè"], ["yè"]],
    "安心乐意": [["ān"], ["xīn"], ["lè"], ["yì"]],
    "安心落意": [["ān"], ["xīn"], ["luò"], ["yì"]],
    "安营扎寨": [["ān"], ["yíng"], ["zhā"], ["zhài"]],
    "安于盘石": [["ān"], ["yú"], ["pán"], ["shí"]],
    "安宅正路": [["ān"], ["zhái"], ["zhèng"], ["lù"]],
    "安之若素": [["ān"], ["zhī"], ["ruò"], ["sù"]],
    "安之若命": [["ān"], ["zhī"], ["ruò"], ["mìng"]],
    "安坐待毙": [["ān"], ["zuò"], ["dài"], ["bì"]],
    "按兵不动": [["àn"], ["bīng"], ["bù"], ["dòng"]],
    "按兵不举": [["àn"], ["bīng"], ["bù"], ["jǔ"]],
    "按甲休兵": [["àn"], ["jiǎ"], ["xiū"], ["bīng"]],
    "按劳分配": [["àn"], ["láo"], ["fēn"], ["pèi"]],
    "按捺不住": [["àn"], ["nà"], ["bù"], ["zhù"]],
    "按需分配": [["àn"], ["xū"], ["fēn"], ["pèi"]],
    "按行自抑": [["àn"], ["xíng"], ["zì"], ["yì"]],
    "案甲休兵": [["àn"], ["jiǎ"], ["xiū"], ["bīng"]],
    "暗锤打人": [["àn"], ["chuí"], ["dǎ"], ["rén"]],
    "按辔徐行": [["àn"], ["pèi"], ["xú"], ["xíng"]],
    "暗地里": [["àn"], ["dì"], ["lǐ"]],
    "暗斗明争": [["àn"], ["dòu"], ["míng"], ["zhēng"]],
    "暗度陈仓": [["àn"], ["dù"], ["chén"], ["cāng"]],
    "暗度金针": [["àn"], ["dù"], ["jīn"], ["zhēn"]],
    "暗箭难防": [["àn"], ["jiàn"], ["nán"], ["fáng"]],
    "暗箭中人": [["àn"], ["jiàn"], ["zhòng"], ["rén"]],
    "暗绿稀红": [["àn"], ["lǜ"], ["xī"], ["hóng"]],
    "暗射地图": [["àn"], ["shè"], ["dì"], ["tú"]],
    "暗室不欺": [["àn"], ["shì"], ["bù"], ["qī"]],
    "昂昂自若": [["áng"], ["áng"], ["zì"], ["roò"]],
    "暗中摸索": [["àn"], ["zhōng"], ["mō"], ["suǒ"]],
    "昂藏七尺": [["áng"], ["cáng"], ["qī"], ["chǐ"]],
    "昂然自若": [["áng"], ["rán"], ["zì"], ["ruò"]],
    "昂然自得": [["áng"], ["rán"], ["zì"], ["dé"]],
    "昂头阔步": [["áng"], ["tóu"], ["kuò"], ["bù"]],
    "昂头天外": [["áng"], ["tóu"], ["tiān"], ["wài"]],
    "昂头挺胸": [["áng"], ["tóu"], ["tǐng"], ["xiōng"]],
    "盎盂相敲": [["àng"], ["yú"], ["xiāng"], ["qiāo"]],
    "盎盂相击": [["àng"], ["yú"], ["xiāng"], ["jī"]],
    "凹版印刷": [["āo"], ["bǎn"], ["yìn"], ["shuā"]],
    "凹面镜": [["āo"], ["miàn"], ["jìng"]],
    "凹透镜": [["āo"], ["tòu"], ["jìng"]],
    "敖不可长": [["ào"], ["bù"], ["kě"], ["zhǎng"]],
    "嗷嗷待哺": [["áo"], ["áo"], ["dài"], ["bǔ"]],
    "遨翔自得": [["áo"], ["xiáng"], ["zì"], ["dé"]],
    "熬肠刮肚": [["áo"], ["cháng"], ["guā"], ["dù"]],
    "熬出头": [["áo"], ["chū"], ["tóu"]],
    "熬更守夜": [["áo"], ["gēng"], ["shǒu"], ["yè"]],
    "熬姜呷醋": [["áo"], ["jiāng"], ["xiā"], ["cù"]],
    "熬枯受淡": [["áo"], ["kū"], ["shòu"], ["dàn"]],
    "熬清守淡": [["áo"], ["qīng"], ["shǒu"], ["dàn"]],
    "熬清守谈": [["áo"], ["qīng"], ["shǒu"], ["tán"]],
    "熬清受淡": [["áo"], ["qīng"], ["shòu"], ["dàn"]],
    "熬心费力": [["áo"], ["xīn"], ["fèi"], ["lì"]],
    "熬油费火": [["áo"], ["yóu"], ["fèi"], ["huǒ"]],
    "聱牙诘曲": [["áo"], ["yá"], ["jié"], ["qū"]],
    "聱牙诘屈": [["áo"], ["yá"], ["jié"], ["qū"]],
    "謷牙诘屈": [["áo"], ["yá"], ["jié"], ["qū"]],
    "鳌鸣鳖应": [["áo"], ["míng"], ["biē"], ["yīng"]],
    "鳌头独占": [["áo"], ["tóu"], ["dú"], ["zhàn"]],
    "拗不过": [["niù"], ["bù"], ["guò"]],
    "拗口令": [["ào"], ["kǒu"], ["lìng"]],
    "傲不可长": [["ào"], ["bù"], ["kě"], ["zhǎng"]],
    "傲骨嶙嶙": [["ào"], ["gǔ"], ["lín"], ["lín"]],
    "傲慢不逊": [["ào"], ["màn"], ["bù"], ["xùn"]],
    "傲慢少礼": [["ào"], ["màn"], ["shǎo"], ["lǐ"]],
    "傲睨万物": [["ào"], ["nì"], ["wàn"], ["wù"]],
    "傲睨得志": [["ào"], ["nì"], ["dé"], ["zhì"]],
    "傲睨一切": [["ào"], ["nì"], ["yī"], ["qiè"]],
    "傲睨自若": [["ào"], ["nì"], ["zì"], ["ruò"]],
    "傲霜斗雪": [["ào"], ["shuāng"], ["dòu"], ["xuě"]],
    "傲头傲脑": [["ào"], ["tóu"], ["ào"], ["nǎo"]],
    "奥地利": [["ào"], ["dì"], ["lì"]],
    "奥地利帝国": [["ào"], ["dì"], ["lì"], ["dì"], ["guó"]],
    "奥地利人": [["ào"], ["dì"], ["lì"], ["rén"]],
    "奥克兰": [["ào"], ["kè"], ["lán"]],
    "奥林匹克运动会": [["ào"], ["lín"], ["pǐ"], ["kè"], ["yùn"], ["dòng"], ["huì"]],
    "奥妙无穷": [["ào"], ["miào"], ["wú"], ["qióng"]],
    "奥斯卡奖": [["ào"], ["sī"], ["kǎ"], ["jiǎng"]],
    "奥斯陆": [["ào"], ["sī"], ["lù"]],
    "奥援有灵": [["ào"], ["yuán"], ["yǒu"], ["líng"]],
    "奥运会": [["ào"], ["yùn"], ["huì"]],
    "澳大利亚": [["ào"], ["dà"], ["lì"], ["yà"]],
    "澳大利亚人": [["ào"], ["dà"], ["lì"], ["yà"], ["rén"]],
    "八达岭": [["bā"], ["dá"], ["lǐng"]],
    "八大山人": [["bā"], ["tài"], ["shān"], ["rén"]],
    "八斗才": [["bā"], ["dǒu"], ["cái"]],
    "八大胡同": [["bā"], ["dà"], ["hú"], ["tòng"]],
    "八斗之才": [["bā"], ["dǒu"], ["zhī"], ["cái"]],
    "八方风雨": [["bā"], ["fāng"], ["fēng"], ["yǔ"]],
    "八方呼应": [["bā"], ["fāng"], ["hū"], ["yìng"]],
    "八竿子打不着": [["bā"], ["gān"], ["zǐ"], ["dǎ"], ["bù"], ["zháo"]],
    "八卦教": [["bā"], ["guà"], ["jiào"]],
    "八纮同轨": [["bā"], ["hóng"], ["tóng"], ["guǐ"]],
    "八角茴香": [["bā"], ["jiǎo"], ["huí"], ["xiāng"]],
    "八角帽": [["bā"], ["jiǎo"], ["mào"]],
    "八九不离十": [["bā"], ["jiǔ"], ["bù"], ["lí"], ["shí"]],
    "八面见光": [["bā"], ["miàn"], ["jiàn"], ["guāng"]],
    "八面驶风": [["bā"], ["miàn"], ["shǐ"], ["fēng"]],
    "八面威风": [["bā"], ["miàn"], ["wēi"], ["fēng"]],
    "八难三灾": [["bā"], ["nàn"], ["sān"], ["zāi"]],
    "八旗子弟": [["bā"], ["qí"], ["zi"], ["dì"]],
    "八千里路云和月": [["bā"], ["qiān"], ["lǐ"], ["lù"], ["yún"], ["hé"], ["yuè"]],
    "八抬大轿": [["bā"], ["tái"], ["dà"], ["jiào"]],
    "八万四千": [["bā"], ["wàn"], ["sì"], ["qiān"]],
    "八仙过海": [["bā"], ["xiān"], ["guò"], ["hǎi"]],
    "八行书": [["bā"], ["háng"], ["shū"]],
    "八一建军节": [["bā"], ["yī"], ["jiàn"], ["jūn"], ["jié"]],
    "八月节": [["bā"], ["yuè"], ["jié"]],
    "八珍玉食": [["bā"], ["zhēn"], ["yù"], ["shí"]],
    "八字打开": [["bā"], ["zì"], ["dǎ"], ["kāi"]],
    "八字还没有一撇": [["bā"], ["zì"], ["hái"], ["méi"], ["yǒu"], ["yī"], ["piě"]],
    "八字没见一撇": [["bā"], ["zì"], ["méi"], ["jiàn"], ["yī"], ["piě"]],
    "八字没一撇": [["bā"], ["zì"], ["méi"], ["yī"], ["piě"]],
    "巴巴结结": [["bā"], ["bā"], ["jiē"], ["jiē"]],
    "巴不得": [["bā"], ["bù"], ["dé"]],
    "巴尔干半岛": [["bā"], ["ěr"], ["gàn"], ["bàn"], ["dǎo"]],
    "巴尔喀什湖": [["bā"], ["ěr"], ["kā"], ["shí"], ["hú"]],
    "巴尔扎克": [["bā"], ["ěr"], ["zhā"], ["kè"]],
    "巴高望上": [["bā"], ["gāo"], ["wàng"], ["shàng"]],
    "巴高枝儿": [["bā"], ["gāo"], ["zhī"], ["ér"]],
    "巴拉圭": [["bā"], ["lā"], ["guī"]],
    "巴勒斯坦": [["bā"], ["lè"], ["sī"], ["tǎn"]],
    "巴黎和会": [["bā"], ["lí"], ["hé"], ["huì"]],
    "巴山夜雨": [["bā"], ["shān"], ["yè"], ["yǔ"]],
    "巴山度岭": [["bā"], ["shān"], ["dù"], ["lǐng"]],
    "巴山越岭": [["bā"], ["shān"], ["yuè"], ["lǐng"]],
    "巴头探脑": [["bā"], ["tóu"], ["tàn"], ["nǎo"]],
    "扒耳搔腮": [["pá"], ["ěr"], ["sāo"], ["sāi"]],
    "扒高踩低": [["bā"], ["gāo"], ["cǎi"], ["dī"]],
    "芭蕉扇": [["bā"], ["jiāo"], ["shàn"]],
    "拔本塞原": [["bá"], ["běn"], ["sè"], ["yuán"]],
    "拔本塞源": [["bá"], ["běn"], ["sè"], ["yuán"]],
    "拔刀相向": [["bá"], ["dāo"], ["xiāng"], ["xiàng"]],
    "拔地参天": [["bá"], ["dì"], ["cān"], ["tiān"]],
    "拔刀相助": [["bá"], ["dāo"], ["xiāng"], ["zhù"]],
    "拔地摇山": [["bá"], ["dì"], ["yáo"], ["shān"]],
    "拔地倚天": [["bá"], ["dì"], ["yǐ"], ["tiān"]],
    "拔丁抽楔": [["bá"], ["dīng"], ["chōu"], ["xiē"]],
    "拔锅卷席": [["bá"], ["guō"], ["juǎn"], ["xí"]],
    "拔剑论功": [["bá"], ["jiàn"], ["lùn"], ["gōng"]],
    "拔葵去织": [["bá"], ["kuí"], ["qù"], ["zhī"]],
    "拔了萝卜地皮宽": [["bá"], ["le"], ["luó"], ["bo"], ["dì"], ["pí"], ["kuān"]],
    "拔毛济世": [["bá"], ["máo"], ["jì"], ["shì"]],
    "拔苗助长": [["bá"], ["miáo"], ["zhù"], ["zhǎng"]],
    "拔山扛鼎": [["bá"], ["shān"], ["gāng"], ["dǐng"]],
    "拔山盖世": [["bá"], ["shān"], ["gài"], ["shì"]],
    "拔十得五": [["bá"], ["shí"], ["dé"], ["wǔ"]],
    "拔宅上升": [["bá"], ["zhái"], ["shàng"], ["shēng"]],
    "跋胡疐尾": [["bá"], ["hú"], ["zhì"], ["wěi"]],
    "跋扈恣睢": [["bá"], ["hù"], ["zì"], ["suī"]],
    "跋前疐后": [["bá"], ["qián"], ["zhì"], ["hòu"]],
    "把臂入林": [["bǎ"], ["bì"], ["rù"], ["lín"]],
    "把臂徐去": [["bǎ"], ["bì"], ["xú"], ["qù"]],
    "把持不定": [["bǎ"], ["chí"], ["bù"], ["dìng"]],
    "把饭叫饥": [["bǎ"], ["fàn"], ["jiào"], ["jī"]],
    "把酒持螯": [["bǎ"], ["jiǔ"], ["chí"], ["áo"]],
    "把素持斋": [["bǎ"], ["sù"], ["chí"], ["zhāi"]],
    "把玩无厌": [["bǎ"], ["wán"], ["wǔ"], ["yàn"]],
    "把薪助火": [["bǎ"], ["xīn"], ["zhù"], ["huǒ"]],
    "把兄弟": [["bǎ"], ["xiōng"], ["dì"]],
    "罢黜百家": [["bā"], ["chù"], ["bǎi"], ["jiā"]],
    "霸道横行": [["bà"], ["dào"], ["héng"], ["xíng"]],
    "霸陵醉尉": [["bà"], ["líng"], ["zuì"], ["wèi"]],
    "霸王鞭": [["bà"], ["wáng"], ["biān"]],
    "霸王别姬": [["bà"], ["wáng"], ["bié"], ["jī"]],
    "霸王风月": [["bà"], ["wáng"], ["fēng"], ["yuè"]],
    "白白朱朱": [["bái"], ["bái"], ["zhū"], ["zhū"]],
    "白不呲咧": [["bái"], ["bù"], ["cī"], ["liě"]],
    "白癜风": [["bái"], ["diàn"], ["fēng"]],
    "白丁俗客": [["bái"], ["dīng"], ["sú"], ["kè"]],
    "白藋同心": [["bái"], ["diào"], ["tóng"], ["xīn"]],
    "白发苍苍": [["bái"], ["fà"], ["cāng"], ["cāng"]],
    "白发苍颜": [["bái"], ["fà"], ["cāng"], ["yán"]],
    "白发丹心": [["bái"], ["fà"], ["dān"], ["xīn"]],
    "白发红颜": [["bái"], ["fà"], ["hóng"], ["yán"]],
    "白发千丈": [["bái"], ["fà"], ["qiān"], ["zhàng"]],
    "白干儿": [["bái"], ["gān"], ["ér"]],
    "白发青衫": [["bái"], ["fà"], ["qīng"], ["shān"]],
    "白发朱颜": [["bái"], ["fà"], ["zhū"], ["yán"]],
    "白骨精": [["bái"], ["gǔ"], ["jīng"]],
    "白骨露野": [["bái"], ["gǔ"], ["lù"], ["yě"]],
    "白骨再肉": [["bái"], ["gǔ"], ["zài"], ["ròu"]],
    "白黑不分": [["bái"], ["hēi"], ["bù"], ["fēn"]],
    "白黑颠倒": [["bái"], ["hēi"], ["diān"], ["dǎo"]],
    "白黑分明": [["bái"], ["hēi"], ["fēn"], ["míng"]],
    "白华之怨": [["bái"], ["huá"], ["zhī"], ["yuàn"]],
    "白晃晃": [["bái"], ["huàng"], ["huǎng"]],
    "白袷蓝衫": [["bái"], ["jiá"], ["lán"], ["shān"]],
    "白驹过隙": [["bái"], ["jū"], ["guò"], ["xì"]],
    "白驹空谷": [["bái"], ["jū"], ["kōng"], ["gǔ"]],
    "白兰地": [["bái"], ["lán"], ["dì"]],
    "白莲教": [["bái"], ["lián"], ["jiào"]],
    "白令海": [["bái"], ["lìng"], ["hǎi"]],
    "白龙鱼服": [["bái"], ["lóng"], ["yú"], ["fú"]],
    "白马王子": [["bái"], ["mǎ"], ["wáng"], ["zǐ"]],
    "白旄黄钺": [["bái"], ["máo"], ["huáng"], ["yuè"]],
    "白毛女": [["bái"], ["máo"], ["nǚ"]],
    "白蒙蒙": [["bái"], ["méng"], ["méng"]],
    "白面儒冠": [["bái"], ["miàn"], ["rú"], ["guān"]],
    "白面书郎": [["bái"], ["miàn"], ["shū"], ["láng"]],
    "白内障": [["bái"], ["nèi"], ["zhàng"]],
    "白热化": [["bái"], ["rè"], ["huà"]],
    "白日见鬼": [["bái"], ["rì"], ["jiàn"], ["guǐ"]],
    "白日上升": [["bái"], ["rì"], ["shàng"], ["shēng"]],
    "白手空拳": [["bái"], ["shǒu"], ["kōng"], ["quán"]],
    "白手起家": [["bái"], ["shǒu"], ["qǐ"], ["jiā"]],
    "白手成家": [["bái"], ["shǒu"], ["chéng"], ["jiā"]],
    "白首北面": [["bái"], ["shǒu"], ["běi"], ["miàn"]],
    "白首不渝": [["bái"], ["shǒu"], ["bù"], ["yú"]],
    "白首空归": [["bái"], ["shǒu"], ["kōng"], ["guī"]],
    "白首齐眉": [["bái"], ["shǒu"], ["qí"], ["méi"]],
    "白首同归": [["bái"], ["shǒu"], ["tóng"], ["guī"]],
    "白首相知": [["bái"], ["shǒu"], ["xiāng"], ["zhī"]],
    "白首为郎": [["bái"], ["shǒu"], ["wéi"], ["láng"]],
    "白首相庄": [["bái"], ["shǒu"], ["xiāng"], ["zhuāng"]],
    "白刷刷": [["bái"], ["shuā"], ["shuā"]],
    "白首一节": [["bái"], ["shǒu"], ["yī"], ["jié"]],
    "白天见鬼": [["bái"], ["tiān"], ["jiàn"], ["guǐ"]],
    "白头不终": [["bái"], ["tóu"], ["bù"], ["zhōng"]],
    "白头到老": [["bái"], ["tóu"], ["dào"], ["lǎo"]],
    "白头而新": [["bái"], ["tóu"], ["ér"], ["xīn"]],
    "白头翁": [["bái"], ["tóu"], ["wēng"]],
    "白头如新": [["bái"], ["tóu"], ["rú"], ["xīn"]],
    "白头相守": [["bái"], ["tóu"], ["xiāng"], ["shǒu"]],
    "白头相并": [["bái"], ["tóu"], ["xiāng"], ["bìng"]],
    "白头偕老": [["bái"], ["tóu"], ["xié"], ["lǎo"]],
    "白头之叹": [["bái"], ["tóu"], ["zhī"], ["tàn"]],
    "白雪难和": [["bái"], ["xuě"], ["nán"], ["hé"]],
    "白血病": [["bái"], ["xuè"], ["bìng"]],
    "白血球": [["bái"], ["xuè"], ["qiú"]],
    "白眼相看": [["bái"], ["yǎn"], ["xiāng"], ["kàn"]],
    "白衣卿相": [["bái"], ["yī"], ["qīng"], ["xiàng"]],
    "白衣宰相": [["bái"], ["yī"], ["zǎi"], ["xiàng"]],
    "白云亲舍": [["bái"], ["yún"], ["qīn"], ["shè"]],
    "白种人": [["bái"], ["zhǒng"], ["rén"]],
    "百般刁难": [["bǎi"], ["bān"], ["diāo"], ["nàn"]],
    "百宝万货": [["bǎi"], ["bǎo"], ["wàn"], ["huò"]],
    "百般折磨": [["bǎi"], ["bān"], ["zhé"], ["mó"]],
    "百不当一": [["bǎi"], ["bù"], ["dāng"], ["yī"]],
    "百不获一": [["bǎi"], ["bù"], ["huò"], ["yī"]],
    "百不失一": [["bǎi"], ["bù"], ["shī"], ["yī"]],
    "百不一存": [["bǎi"], ["bù"], ["yī"], ["cún"]],
    "百不一贷": [["bǎi"], ["bù"], ["yī"], ["dài"]],
    "百不一遇": [["bǎi"], ["bù"], ["yī"], ["yù"]],
    "百尺竿头": [["bǎi"], ["chǐ"], ["gān"], ["tóu"]],
    "百尺竿头更进一步": [["bǎi"], ["chǐ"], ["gān"], ["tóu"], ["gèng"], ["jìn"], ["yī"], ["bù"]],
    "百尺无枝": [["bǎi"], ["chǐ"], ["wú"], ["zhī"]],
    "百川朝海": [["bǎi"], ["chuān"], ["cháo"], ["hǎi"]],
    "百辞莫辩": [["bǎi"], ["cí"], ["mò"], ["biàn"]],
    "百代过客": [["bǎi"], ["dài"], ["guò"], ["kè"]],
    "百动不如一静": [["bǎi"], ["dòng"], ["bù"], ["rú"], ["yī"], ["jìng"]],
    "百读不厌": [["bǎi"], ["dú"], ["bù"], ["yàn"]],
    "百端待举": [["bǎi"], ["duān"], ["dài"], ["jǔ"]],
    "百堕俱举": [["bǎi"], ["huī"], ["jù"], ["jǔ"]],
    "百发百中": [["bǎi"], ["fā"], ["bǎi"], ["zhòng"]],
    "百凡待举": [["bǎi"], ["fán"], ["dài"], ["jǔ"]],
    "百废待举": [["bǎi"], ["fèi"], ["dài"], ["jǔ"]],
    "百废待兴": [["bǎi"], ["fèi"], ["dài"], ["xīng"]],
    "百废具兴": [["bǎi"], ["fèi"], ["jù"], ["xīng"]],
    "百废俱兴": [["bǎi"], ["fèi"], ["jù"], ["xīng"]],
    "百分比": [["bǎi"], ["fēn"], ["bǐ"]],
    "百分率": [["bǎi"], ["fēn"], ["lǜ"]],
    "百分数": [["bǎi"], ["fēn"], ["shù"]],
    "百分之百": [["bǎi"], ["fēn"], ["zhī"], ["bǎi"]],
    "百分制": [["bǎi"], ["fēn"], ["zhì"]],
    "百夫长": [["bǎi"], ["fū"], ["zhǎng"]],
    "百怪千奇": [["bǎi"], ["guài"], ["qiān"], ["qí"]],
    "百合花": [["bǎi"], ["hé"], ["huā"]],
    "百花齐放": [["bǎi"], ["huā"], ["qí"], ["fàng"]],
    "百喙莫辩": [["bǎi"], ["huì"], ["mò"], ["biàn"]],
    "百喙难辩": [["bǎi"], ["huì"], ["nán"], ["biàn"]],
    "百喙难辞": [["bǎi"], ["huì"], ["nán"], ["cí"]],
    "百家饭": [["bǎi"], ["jiā"], ["fàn"]],
    "百家姓": [["bǎi"], ["jiā"], ["xìng"]],
    "百家争鸣": [["bǎi"], ["jiā"], ["zhēng"], ["míng"]],
    "百结愁肠": [["bǎi"], ["jié"], ["chóu"], ["cháng"]],
    "百结悬鹑": [["bǎi"], ["jié"], ["xuán"], ["chún"]],
    "百孔千创": [["bǎi"], ["kǒng"], ["qiān"], ["chuāng"]],
    "百口莫辩": [["bǎi"], ["kǒu"], ["mò"], ["biàn"]],
    "百口同声": [["bǎi"], ["kǒu"], ["tóng"], ["shēng"]],
    "百口难分": [["bǎi"], ["kǒu"], ["nán"], ["fēn"]],
    "百里挑一": [["bǎi"], ["lǐ"], ["tiāo"], ["yī"]],
    "百炼成钢": [["bǎi"], ["liàn"], ["chéng"], ["gāng"]],
    "百了千当": [["bǎi"], ["liǎo"], ["qiān"], ["dāng"]],
    "百虑攒心": [["bǎi"], ["lǜ"], ["zǎn"], ["xīn"]],
    "百慕大群岛": [["bǎi"], ["mù"], ["dà"], ["qún"], ["dǎo"]],
    "百年不遇": [["bǎi"], ["nián"], ["bù"], ["yù"]],
    "百年大计": [["bǎi"], ["nián"], ["dà"], ["jì"]],
    "百年大业": [["bǎi"], ["nián"], ["dà"], ["yè"]],
    "百年好合": [["bǎi"], ["nián"], ["hǎo"], ["hé"]],
    "百年难遇": [["bǎi"], ["nián"], ["nán"], ["yù"]],
    "百年之好": [["bǎi"], ["nián"], ["zhī"], ["hǎo"]],
    "百年好事": [["bǎi"], ["nián"], ["hǎo"], ["shì"]],
    "百鸟朝凤": [["bǎi"], ["niǎo"], ["cháo"], ["fèng"]],
    "百年之约": [["bǎi"], ["nián"], ["zhī"], ["yuē"]],
    "百品千条": [["bǎi"], ["pǐn"], ["qiān"], ["tiáo"]],
    "百日咳": [["bǎi"], ["rì"], ["hāi"]],
    "百舍重茧": [["bǎi"], ["shè"], ["chóng"], ["jiǎn"]],
    "百身莫赎": [["bǎi"], ["shēn"], ["mò"], ["shú"]],
    "百身何赎": [["bǎi"], ["shēn"], ["hé"], ["shú"]],
    "百舍重趼": [["bǎi"], ["shè"], ["chóng"], ["jiǎn"]],
    "百世不易": [["bǎi"], ["shì"], ["bù"], ["yì"]],
    "百世不磨": [["bǎi"], ["shì"], ["bù"], ["mó"]],
    "百事大吉": [["bǎi"], ["shì"], ["dà"], ["jí"]],
    "百事可乐": [["bǎi"], ["shì"], ["kě"], ["lè"]],
    "百兽率舞": [["bǎi"], ["shòu"], ["shuài"], ["wǔ"]],
    "百思不得其解": [["bǎi"], ["sī"], ["bù"], ["dé"], ["qí"], ["jiě"]],
    "百思不解": [["bǎi"], ["sī"], ["bù"], ["jiě"]],
    "百思莫解": [["bǎi"], ["sī"], ["mò"], ["jiě"]],
    "百岁之好": [["bǎi"], ["suì"], ["zhī"], ["hǎo"]],
    "百万富翁": [["bǎi"], ["wàn"], ["fù"], ["wēng"]],
    "百万雄兵": [["bǎi"], ["wàn"], ["xióng"], ["bīng"]],
    "百万雄师": [["bǎi"], ["wàn"], ["xióng"], ["shī"]],
    "百无禁忌": [["bǎi"], ["wú"], ["jìn"], ["jì"]],
    "百闻不如一见": [["bǎi"], ["wén"], ["bù"], ["rú"], ["yī"], ["jiàn"]],
    "百无是处": [["bǎi"], ["wú"], ["shì"], ["chù"]],
    "百下百着": [["bǎi"], ["xià"], ["bǎi"], ["zháo"]],
    "百无一能": [["bǎi"], ["wú"], ["yī"], ["néng"]],
    "百星不如一月": [["bǎi"], ["xīng"], ["bù"], ["rú"], ["yī"], ["yuè"]],
    "百业萧条": [["bǎi"], ["yè"], ["xiāo"], ["tiáo"]],
    "百叶窗": [["bǎi"], ["yè"], ["chuāng"]],
    "百叶箱": [["bǎi"], ["yè"], ["xiāng"]],
    "百依百从": [["bǎi"], ["yī"], ["bǎi"], ["cóng"]],
    "百战不殆": [["bǎi"], ["zhàn"], ["bù"], ["dài"]],
    "百载树人": [["bǎi"], ["zǎi"], ["shù"], ["rén"]],
    "百丈竿头": [["bǎi"], ["zhàng"], ["gān"], ["tóu"]],
    "百折不回": [["bǎi"], ["zhé"], ["bù"], ["huí"]],
    "百折不挠": [["bǎi"], ["zhé"], ["bù"], ["náo"]],
    "百折不屈": [["bǎi"], ["zhé"], ["bù"], ["qū"]],
    "百折不移": [["bǎi"], ["zhé"], ["bù"], ["yí"]],
    "百折千回": [["bǎi"], ["zhé"], ["qiān"], ["huí"]],
    "百中百发": [["bǎi"], ["zhòng"], ["bǎi"], ["fā"]],
    "百紫千红": [["bǎi"], ["zǐ"], ["qiān"], ["hóng"]],
    "百纵千随": [["bǎi"], ["zòng"], ["qiān"], ["suí"]],
    "百足不僵": [["bǎi"], ["zú"], ["bù"], ["jiāng"]],
    "柏拉图": [["bó"], ["lā"], ["tú"]],
    "柏油路": [["bǎi"], ["yóu"], ["lù"]],
    "柏舟之节": [["bǎi"], ["zhōu"], ["zhī"], ["jié"]],
    "柏舟之誓": [["bǎi"], ["zhōu"], ["zhī"], ["shì"]],
    "捭阖纵横": [["bǎi"], ["hé"], ["zòng"], ["héng"]],
    "摆擂台": [["bǎi"], ["lèi"], ["tái"]],
    "摆尾摇头": [["bǎi"], ["wěi"], ["yáo"], ["tóu"]],
    "败不旋踵": [["bài"], ["bù"], ["xuán"], ["zhǒng"]],
    "败德辱行": [["bài"], ["dé"], ["rǔ"], ["xíng"]],
    "败法乱纪": [["bài"], ["fǎ"], ["luàn"], ["jì"]],
    "败国丧家": [["bài"], ["guó"], ["sàng"], ["jiā"]],
    "败国亡家": [["bài"], ["guó"], ["wáng"], ["jiā"]],
    "败绩失据": [["bài"], ["jì"], ["shī"], ["jù"]],
    "败化伤风": [["bài"], ["huà"], ["shāng"], ["fēng"]],
    "败家子": [["bài"], ["jiā"], ["zǐ"]],
    "败将残兵": [["bài"], ["jiàng"], ["cán"], ["bīng"]],
    "败军之将": [["bài"], ["jūn"], ["zhī"], ["jiàng"]],
    "败俗伤风": [["bài"], ["sú"], ["shāng"], ["fēng"]],
    "败俗伤化": [["bài"], ["sú"], ["shāng"], ["huà"]],
    "败兴而归": [["bài"], ["xìng"], ["ér"], ["guī"]],
    "败血病": [["bài"], ["xuè"], ["bìng"]],
    "败血症": [["bài"], ["xuè"], ["zhèng"]],
    "拜把子": [["bài"], ["bà"], ["zi"]],
    "拜倒辕门": [["bài"], ["dǎo"], ["yuán"], ["mén"]],
    "拜将封侯": [["bài"], ["jiàng"], ["fēng"], ["hóu"]],
    "拜上帝会": [["bài"], ["shàng"], ["dì"], ["huì"]],
    "拜天地": [["bài"], ["tiān"], ["dì"]],
    "拜物教": [["bài"], ["wù"], ["jiào"]],
    "稗官小说": [["bài"], ["guān"], ["xiǎo"], ["shuō"]],
    "班班可考": [["bān"], ["bān"], ["kě"], ["kǎo"]],
    "班禅额尔德尼": [["bān"], ["chán"], ["é"], ["ěr"], ["dé"], ["ní"]],
    "班功行赏": [["bān"], ["gōng"], ["xíng"], ["shǎng"]],
    "班门弄斧": [["bān"], ["mén"], ["nòng"], ["fǔ"]],
    "班师得胜": [["bān"], ["shī"], ["dé"], ["shèng"]],
    "班师回朝": [["bān"], ["shī"], ["huí"], ["cháo"]],
    "班衣戏采": [["bān"], ["yī"], ["xì"], ["cǎi"]],
    "斑衣戏彩": [["bān"], ["yī"], ["xì"], ["cǎi"]],
    "搬唇弄舌": [["bān"], ["chún"], ["nòng"], ["shé"]],
    "搬口弄舌": [["bān"], ["kǒu"], ["nòng"], ["shé"]],
    "搬弄是非": [["bān"], ["nòng"], ["shì"], ["fēi"]],
    "搬起石头打自己的脚": [["bān"], ["qǐ"], ["shí"], ["tóu"], ["dǎ"], ["zì"], ["jǐ"], ["de"], ["jiǎo"]],
    "搬石砸脚": [["bān"], ["shí"], ["zá"], ["jiǎo"]],
    "阪上走丸": [["bǎn"], ["shàng"], ["zǒu"], ["wán"]],
    "板板六十四": [["bǎn"], ["bǎn"], ["liù"], ["shí"], ["sì"]],
    "板上钉钉": [["bǎn"], ["shàng"], ["dìng"], ["dīng"]],
    "板上砸钉": [["bǎn"], ["shàng"], ["zá"], ["dīng"]],
    "版版六十四": [["bǎn"], ["bǎn"], ["liù"], ["shí"], ["sì"]],
    "版筑饭牛": [["bǎn"], ["zhù"], ["fàn"], ["niú"]],
    "办不到": [["bàn"], ["bú"], ["dào"]],
    "办得到": [["bàn"], ["dé"], ["dào"]],
    "办公会议": [["bàn"], ["gōng"], ["huì"], ["yì"]],
    "办事处": [["bàn"], ["shì"], ["chù"]],
    "办事员": [["bàn"], ["shì"], ["yuán"]],
    "半半拉拉": [["bàn"], ["bàn"], ["lā"], ["lā"]],
    "半部论语": [["bàn"], ["bù"], ["lún"], ["yǔ"]],
    "半部论语治天下": [["bàn"], ["bù"], ["lún"], ["yǔ"], ["zhì"], ["tiān"], ["xià"]],
    "半痴不颠": [["bàn"], ["chī"], ["bù"], ["diān"]],
    "半筹不纳": [["bàn"], ["chóu"], ["bù"], ["nà"]],
    "半大不小": [["bàn"], ["dà"], ["bù"], ["xiǎo"]],
    "半筹莫展": [["bàn"], ["chóu"], ["mò"], ["chǎn"]],
    "半导体": [["bàn"], ["dǎo"], ["tǐ"]],
    "半低不高": [["bàn"], ["dī"], ["bù"], ["gāo"]],
    "半懂不懂": [["bàn"], ["dǒng"], ["bù"], ["dǒng"]],
    "半工半读": [["bàn"], ["gōng"], ["bàn"], ["dú"]],
    "半机械化": [["bàn"], ["jī"], ["xiè"], ["huà"]],
    "半间半界": [["bàn"], ["gān"], ["bàn"], ["gà"]],
    "半间不界": [["bàn"], ["gān"], ["bù"], ["gà"]],
    "半解一知": [["bàn"], ["jiě"], ["yī"], ["zhī"]],
    "半空中": [["bàn"], ["kōng"], ["zhōng"]],
    "半拉子": [["bàn"], ["lǎ"], ["zǐ"]],
    "半路出家": [["bàn"], ["lù"], ["chū"], ["jiā"]],
    "半路修行": [["bàn"], ["lù"], ["xiū"], ["xíng"]],
    "半面不忘": [["bàn"], ["miàn"], ["bù"], ["wàng"]],
    "半农半牧区": [["bàn"], ["nóng"], ["bàn"], ["mù"], ["qū"]],
    "半三不四": [["bàn"], ["sān"], ["bù"], ["sì"]],
    "半上半下": [["bàn"], ["shàng"], ["bàn"], ["xià"]],
    "半上落下": [["bàn"], ["shàng"], ["luò"], ["xià"]],
    "半身不遂": [["bàn"], ["shēn"], ["bù"], ["suí"]],
    "半生不熟": [["bàn"], ["shēng"], ["bù"], ["shú"]],
    "半衰期": [["bàn"], ["shuāi"], ["qī"]],
    "半死不活": [["bàn"], ["sǐ"], ["bù"], ["huó"]],
    "半涂而罢": [["bàn"], ["tú"], ["ér"], ["bà"]],
    "半吐半露": [["bàn"], ["tǔ"], ["bàn"], ["lù"]],
    "半吞半吐": [["bàn"], ["tūn"], ["bàn"], ["tǔ"]],
    "半文不白": [["bàn"], ["wén"], ["bù"], ["bái"]],
    "半信半疑": [["bàn"], ["xìn"], ["bàn"], ["yí"]],
    "半信不信": [["bàn"], ["xìn"], ["bù"], ["xìn"]],
    "半新不旧": [["bàn"], ["xīn"], ["bù"], ["jiù"]],
    "半夜三更": [["bàn"], ["yè"], ["sān"], ["gēng"]],
    "半疑半信": [["bàn"], ["yí"], ["bàn"], ["xìn"]],
    "半殖民地": [["bàn"], ["zhí"], ["mín"], ["dì"]],
    "半真半假": [["bàn"], ["zhēn"], ["bàn"], ["jiǎ"]],
    "半中间": [["bàn"], ["zhōng"], ["jiān"]],
    "半中腰": [["bàn"], ["zhōng"], ["yāo"]],
    "伴食宰相": [["bàn"], ["shí"], ["zǎi"], ["xiàng"]],
    "伴食中书": [["bàn"], ["shí"], ["zhōng"], ["shū"]],
    "绊脚石": [["bàn"], ["jiǎo"], ["shí"]],
    "邦以民为本": [["bāng"], ["yǐ"], ["mín"], ["wéi"], ["běn"]],
    "帮倒忙": [["bāng"], ["dào"], ["máng"]],
    "帮狗吃食": [["bāng"], ["gǒu"], ["chī"], ["shí"]],
    "帮虎吃食": [["bāng"], ["hǔ"], ["chī"], ["shí"]],
    "帮闲钻懒": [["bāng"], ["xián"], ["zuān"], ["lǎn"]],
    "榜上无名": [["bǎng"], ["shàng"], ["wú"], ["míng"]],
    "蚌病成珠": [["bàng"], ["bìng"], ["chéng"], ["zhū"]],
    "膀大腰圆": [["bǎng"], ["dà"], ["yāo"], ["yuán"]],
    "蚌病生珠": [["bàng"], ["bìng"], ["shēng"], ["zhū"]],
    "蚌埠市": [["bèng"], ["bù"], ["shì"]],
    "蚌鹬相持": [["bàng"], ["yù"], ["xiāng"], ["chí"]],
    "傍观冷眼": [["bàng"], ["guān"], ["lěng"], ["yǎn"]],
    "傍观者清": [["bàng"], ["guān"], ["zhě"], ["qīng"]],
    "傍人篱落": [["bàng"], ["rén"], ["lí"], ["luò"]],
    "傍若无人": [["páng"], ["ruò"], ["wú"], ["rén"]],
    "棒打鸳鸯": [["bàng"], ["dǎ"], ["yuān"], ["yāng"]],
    "包藏祸心": [["bāo"], ["cáng"], ["huò"], ["xīn"]],
    "包藏奸心": [["bāo"], ["cáng"], ["jiān"], ["xīn"]],
    "包乘制": [["bāo"], ["chéng"], ["zhì"]],
    "包乘组": [["bāo"], ["chéng"], ["zǔ"]],
    "包打天下": [["bāo"], ["dǎ"], ["tiān"], ["xià"]],
    "包打听": [["bāo"], ["dǎ"], ["tīng"]],
    "包干儿": [["bāo"], ["gān"], ["ér"]],
    "包干制": [["bāo"], ["gān"], ["zhì"]],
    "包工头": [["bāo"], ["gōng"], ["tóu"]],
    "包举宇内": [["bāo"], ["jǔ"], ["yǔ"], ["nèi"]],
    "包罗万象": [["bāo"], ["luó"], ["wàn"], ["xiàng"]],
    "包罗万有": [["bāo"], ["luó"], ["wàn"], ["yǒu"]],
    "包头市": [["bāo"], ["tóu"], ["shì"]],
    "包围圈": [["bāo"], ["wéi"], ["quān"]],
    "苞苴竿牍": [["bāo"], ["jū"], ["gān"], ["dú"]],
    "褒贬与夺": [["bǎo"], ["biǎn"], ["yǔ"], ["duó"]],
    "褒善贬恶": [["bāo"], ["shàn"], ["biǎn"], ["è"]],
    "宝刀不老": [["bǎo"], ["dāo"], ["bù"], ["lǎo"]],
    "褒衣危冠": [["bāo"], ["yī"], ["wēi"], ["guān"]],
    "宝贝疙瘩": [["bǎo"], ["bèi"], ["gē"], ["dā"]],
    "宝盖头": [["bǎo"], ["gài"], ["tóu"]],
    "宝马香车": [["bǎo"], ["mǎ"], ["xiāng"], ["chē"]],
    "宝山空回": [["bǎo"], ["shān"], ["kōng"], ["huí"]],
    "饱汉不知饿汉饥": [["bǎo"], ["hàn"], ["bù"], ["zhī"], ["è"], ["hàn"], ["jī"]],
    "饱和点": [["bǎo"], ["huó"], ["diǎn"]],
    "饱和溶液": [["bǎo"], ["hé"], ["róng"], ["yè"]],
    "饱经风霜": [["bǎo"], ["jīng"], ["fēng"], ["shuāng"]],
    "饱经风雨": [["bǎo"], ["jīng"], ["fēng"], ["yǔ"]],
    "饱暖思淫欲": [["bǎo"], ["nuǎn"], ["sī"], ["yín"], ["yù"]],
    "饱人不知饿人饥": [["bǎo"], ["rén"], ["bù"], ["zhī"], ["è"], ["rén"], ["jī"]],
    "饱食暖衣": [["bǎo"], ["shí"], ["nuǎn"], ["yī"]],
    "饱食终日，无所用心": [["bǎo"], ["shí"], ["zhōng"], ["rì"], [",wú"], ["suǒ"], ["yòng"], ["xīn"]],
    "饱食终日": [["bǎo"], ["shí"], ["zhōng"], ["rì"]],
    "保不定": [["bǎo"], ["bù"], ["dìng"]],
    "保不住": [["bǎo"], ["bú"], ["zhù"]],
    "保不齐": [["bǎo"], ["bù"], ["qí"]],
    "保得住": [["bǎo"], ["de"], ["zhù"]],
    "保管员": [["bǎo"], ["guǎn"], ["yuán"]],
    "保家卫国": [["bǎo"], ["jiā"], ["wèi"], ["guó"]],
    "保税区": [["bǎo"], ["shuì"], ["qū"]],
    "保外执行": [["bǎo"], ["wài"], ["zhí"], ["xíng"]],
    "保险柜": [["bǎo"], ["xiǎn"], ["guì"]],
    "保育员": [["bǎo"], ["yù"], ["yuán"]],
    "保真度": [["bǎo"], ["zhēn"], ["dù"]],
    "报仇雪耻": [["bào"], ["chóu"], ["xuě"], ["chǐ"]],
    "报仇雪恨": [["bào"], ["chóu"], ["xuě"], ["hèn"]],
    "报务员": [["bào"], ["wù"], ["yuán"]],
    "报效万一": [["bào"], ["xiào"], ["wàn"], ["yī"]],
    "报应不爽": [["bào"], ["yìng"], ["bù"], ["shuǎng"]],
    "抱不平": [["bào"], ["bù"], ["píng"]],
    "抱打不平": [["bào"], ["dǎ"], ["bù"], ["píng"]],
    "抱残守阙": [["bào"], ["cán"], ["shǒu"], ["quē"]],
    "抱法处势": [["bào"], ["fǎ"], ["chǔ"], ["shì"]],
    "抱佛脚": [["bào"], ["fó"], ["jiǎo"]],
    "抱负不凡": [["bào"], ["fù"], ["bù"], ["fán"]],
    "抱关执钥": [["bào"], ["guān"], ["zhí"], ["yuè"]],
    "抱蔓摘瓜": [["bào"], ["wàn"], ["zhāi"], ["guā"]],
    "抱璞泣血": [["bào"], ["pú"], ["qì"], ["xuè"]],
    "抱令守律": [["bào"], ["lìng"], ["shǒu"], ["lǜ"]],
    "抱朴含真": [["bào"], ["pǔ"], ["hán"], ["zhēn"]],
    "抱椠怀铅": [["bào"], ["qiàn"], ["huái"], ["qiān"]],
    "抱头大哭": [["bào"], ["tóu"], ["dà"], ["kū"]],
    "抱头鼠窜": [["bào"], ["tóu"], ["shǔ"], ["cuàn"]],
    "抱枝拾叶": [["bào"], ["zhī"], ["shí"], ["yè"]],
    "抱头痛哭": [["bào"], ["tóu"], ["tòng"], ["kū"]],
    "抱柱之信": [["bào"], ["zhù"], ["zhī"], ["xìn"]],
    "抱子弄孙": [["bào"], ["zǐ"], ["nòng"], ["sūn"]],
    "豹头环眼": [["bào"], ["tóu"], ["huán"], ["yǎn"]],
    "趵突泉": [["bō"], ["tū"], ["quán"]],
    "鲍子知我": [["bào"], ["zǐ"], ["zhī"], ["wǒ"]],
    "暴发户": [["bào"], ["fā"], ["hù"]],
    "暴风疾雨": [["bào"], ["fēng"], ["jí"], ["yǔ"]],
    "暴风雪": [["bào"], ["fēng"], ["xuě"]],
    "暴风雨": [["bào"], ["fēng"], ["yǔ"]],
    "暴风骤雨": [["bào"], ["fēng"], ["zhòu"], ["yǔ"]],
    "暴虎冯河": [["bào"], ["hǔ"], ["píng"], ["hé"]],
    "暴力革命": [["bào"], ["lì"], ["gé"], ["mìng"]],
    "暴戾恣睢": [["bào"], ["lì"], ["zì"], ["suī"]],
    "暴敛横征": [["bào"], ["liǎn"], ["héng"], ["zhēng"]],
    "暴露文学": [["bào"], ["lòu"], ["wén"], ["xué"]],
    "暴露无遗": [["bào"], ["lù"], ["wú"], ["yí"]],
    "暴虐无道": [["bào"], ["nüè"], ["wú"], ["dào"]],
    "暴内陵外": [["bào"], ["nèi"], ["líng"], ["wài"]],
    "暴取豪夺": [["bào"], ["qǔ"], ["háo"], ["duó"]],
    "暴跳如雷": [["bào"], ["tiào"], ["rú"], ["léi"]],
    "暴殄天物": [["bào"], ["tiǎn"], ["tiān"], ["wù"]],
    "暴腮龙门": [["pù"], ["sāi"], ["lóng"], ["mén"]],
    "暴衣露盖": [["pù"], ["yī"], ["lù"], ["gài"]],
    "暴衣露冠": [["pù"], ["yī"], ["lù"], ["guàn"]],
    "暴饮暴食": [["bào"], ["yǐn"], ["bào"], ["shí"]],
    "暴躁如雷": [["bào"], ["zào"], ["rú"], ["léi"]],
    "爆发力": [["bào"], ["fā"], ["lì"]],
    "爆跳如雷": [["bào"], ["tiào"], ["rú"], ["léi"]],
    "陂湖禀量": [["bēi"], ["hú"], ["bǐng"], ["liáng"]],
    "卑卑不足道": [["bēi"], ["bēi"], ["bù"], ["zú"], ["dào"]],
    "卑辞重币": [["bēi"], ["cí"], ["zhòng"], ["bì"]],
    "卑不足道": [["bēi"], ["bù"], ["zú"], ["dào"]],
    "卑宫菲食": [["bēi"], ["gōng"], ["fěi"], ["shí"]],
    "卑躬屈节": [["bēi"], ["gōng"], ["qū"], ["jié"]],
    "卑身贱体": [["bēi"], ["shēn"], ["jiàn"], ["tǐ"]],
    "卑身屈体": [["bēi"], ["shēn"], ["qū"], ["tǐ"]],
    "卑之无甚高论": [["bēi"], ["zhī"], ["wú"], ["shèn"], ["gāo"], ["lùn"]],
    "杯弓蛇影": [["bēi"], ["gōng"], ["shé"], ["yǐng"]],
    "杯酒解怨": [["bēi"], ["jiǔ"], ["jiě"], ["yuàn"]],
    "杯盘狼藉": [["bēi"], ["pán"], ["láng"], ["jí"]],
    "杯蛇鬼车": [["bēi"], ["shé"], ["guǐ"], ["chē"]],
    "杯蛇幻影": [["bēi"], ["shé"], ["huàn"], ["yǐng"]],
    "杯水车薪": [["bēi"], ["shuǐ"], ["chē"], ["xīn"]],
    "杯影蛇弓": [["bēi"], ["yǐng"], ["shé"], ["gōng"]],
    "杯中蛇影": [["bēi"], ["zhōng"], ["shé"], ["yǐng"]],
    "杯中物": [["bēi"], ["zhōng"], ["wù"]],
    "悲悲切切": [["bēi"], ["bēi"], ["qiè"], ["qiē"]],
    "杯中之物": [["bēi"], ["zhōng"], ["zhī"], ["wù"]],
    "悲不自胜": [["bēi"], ["bù"], ["zì"], ["shèng"]],
    "悲从中来": [["bēi"], ["cóng"], ["zhōng"], ["lái"]],
    "悲愤填膺": [["bēi"], ["fèn"], ["tián"], ["yīng"]],
    "悲歌击筑": [["bēi"], ["gē"], ["jī"], ["zhù"]],
    "悲观厌世": [["bēi"], ["guān"], ["yàn"], ["shì"]],
    "悲欢离合": [["bēi"], ["huān"], ["lí"], ["hé"]],
    "悲声载道": [["bēi"], ["shēng"], ["zài"], ["dào"]],
    "北爱尔兰": [["běi"], ["ài"], ["ěr"], ["lán"]],
    "北半球": [["běi"], ["bàn"], ["qiú"]],
    "北鄙之声": [["bēi"], ["bǐ"], ["zhī"], ["shēng"]],
    "北鄙之音": [["bēi"], ["bǐ"], ["zhī"], ["yīn"]],
    "北冰洋": [["běi"], ["bīng"], ["yáng"]],
    "北部湾": [["běi"], ["bù"], ["wān"]],
    "北辰星拱": [["bēi"], ["chén"], ["xīng"], ["gǒng"]],
    "北窗高卧": [["bēi"], ["chuāng"], ["gāo"], ["wò"]],
    "北大荒": [["běi"], ["dà"], ["huāng"]],
    "北戴河": [["běi"], ["dài"], ["hé"]],
    "北道主人": [["běi"], ["dào"], ["zhǔ"], ["rén"]],
    "北斗七星": [["běi"], ["dǒu"], ["qī"], ["xīng"]],
    "北斗星": [["běi"], ["dǒu"], ["xīng"]],
    "北斗之尊": [["běi"], ["dǒu"], ["zhī"], ["zūn"]],
    "北伐战争": [["běi"], ["fá"], ["zhàn"], ["zhēng"]],
    "北伐军": [["běi"], ["fá"], ["jūn"]],
    "北方方言": [["běi"], ["fāng"], ["fāng"], ["yán"]],
    "北方话": [["běi"], ["fāng"], ["huà"]],
    "北方交通大学": [["běi"], ["fāng"], ["jiāo"], ["tōng"], ["dà"], ["xué"]],
    "北方人": [["běi"], ["fāng"], ["rén"]],
    "北风之恋": [["běi"], ["fēng"], ["zhī"], ["liàn"]],
    "北宫婴儿": [["běi"], ["gōng"], ["yīng"], ["ér"]],
    "北郭先生": [["běi"], ["guō"], ["xiān"], ["shēng"]],
    "北海道": [["běi"], ["hǎi"], ["dào"]],
    "北海市": [["běi"], ["hǎi"], ["shì"]],
    "北寒带": [["běi"], ["hán"], ["dài"]],
    "北极光": [["běi"], ["jí"], ["guāng"]],
    "北极圈": [["běi"], ["jí"], ["quān"]],
    "北极星": [["běi"], ["jí"], ["xīng"]],
    "北极熊": [["běi"], ["jí"], ["xióng"]],
    "北京大学": [["běi"], ["jīng"], ["dà"], ["xué"]],
    "北京话": [["běi"], ["jīng"], ["huà"]],
    "北京科技大学": [["běi"], ["jīng"], ["kē"], ["jì"], ["dà"], ["xué"]],
    "北京理工大学": [["běi"], ["jīng"], ["lǐ"], ["gōng"], ["dà"], ["xué"]],
    "北京林业大学": [["běi"], ["jīng"], ["lín"], ["yè"], ["dà"], ["xué"]],
    "北京人": [["běi"], ["jīng"], ["rén"]],
    "北京师范大学": [["běi"], ["jīng"], ["shī"], ["fàn"], ["dà"], ["xué"]],
    "北京时间": [["běi"], ["jīng"], ["shí"], ["jiān"]],
    "北京市": [["běi"], ["jīng"], ["shì"]],
    "北京鸭": [["běi"], ["jīng"], ["yā"]],
    "北京医科大学": [["běi"], ["jīng"], ["yī"], ["kē"], ["dà"], ["xué"]],
    "北京猿人": [["běi"], ["jīng"], ["yuán"], ["rén"]],
    "北门南牙": [["běi"], ["mén"], ["nán"], ["yá"]],
    "北门管钥": [["běi"], ["mén"], ["guǎn"], ["yuè"]],
    "北门锁钥": [["běi"], ["mén"], ["suǒ"], ["yuè"]],
    "北门之管": [["běi"], ["mén"], ["zhī"], ["guǎn"]],
    "北门之寄": [["běi"], ["mén"], ["zhī"], ["jì"]],
    "北面称臣": [["běi"], ["miàn"], ["chēng"], ["chén"]],
    "北叟失马": [["běi"], ["sǒu"], ["shī"], ["mǎ"]],
    "北温带": [["běi"], ["wēn"], ["dài"]],
    "北洋军阀": [["běi"], ["yáng"], ["jūn"], ["fá"]],
    "北辕适楚": [["běi"], ["yuán"], ["shì"], ["chǔ"]],
    "北辕适粤": [["běi"], ["yuán"], ["shì"], ["yuè"]],
    "北辙南辕": [["běi"], ["zhé"], ["nán"], ["yuán"]],
    "贝阙珠宫": [["bèi"], ["què"], ["zhū"], ["gōng"]],
    "备不住": [["bèi"], ["bú"], ["zhù"]],
    "备多力分": [["bèi"], ["duō"], ["lì"], ["fēn"]],
    "备而不用": [["bèi"], ["ér"], ["bù"], ["yòng"]],
    "备位充数": [["bèi"], ["wèi"], ["chōng"], ["shù"]],
    "背暗投明": [["bèi"], ["àn"], ["tóu"], ["míng"]],
    "背包袱": [["bēi"], ["bāo"], ["fú"]],
    "背碑覆局": [["bèi"], ["bēi"], ["fù"], ["jú"]],
    "背本趋末": [["bèi"], ["běn"], ["qū"], ["mò"]],
    "背不住": [["bèi"], ["bú"], ["zhù"]],
    "背本就末": [["bèi"], ["běn"], ["jiù"], ["mò"]],
    "背城借一": [["bèi"], ["chéng"], ["jiè"], ["yī"]],
    "背城一战": [["bèi"], ["chéng"], ["yī"], ["zhàn"]],
    "背搭子": [["bèi"], ["dā"], ["zǐ"]],
    "背带裤": [["bēi"], ["dài"], ["kù"]],
    "背带裙": [["bēi"], ["dài"], ["qún"]],
    "背道而驰": [["bèi"], ["dào"], ["ér"], ["chí"]],
    "背地里": [["bèi"], ["dì"], ["lǐ"]],
    "背恩负义": [["bèi"], ["ēn"], ["fù"], ["yì"]],
    "背恩弃义": [["bèi"], ["ēn"], ["qì"], ["yì"]],
    "背恩忘义": [["bèi"], ["ēn"], ["wàng"], ["yì"]],
    "背风面": [["bèi"], ["fēng"], ["miàn"]],
    "背腹受敌": [["bèi"], ["fù"], ["shòu"], ["dí"]],
    "背公向私": [["bèi"], ["gōng"], ["xiàng"], ["sī"]],
    "背公营私": [["bèi"], ["gōng"], ["yíng"], ["sī"]],
    "背光性": [["bèi"], ["guāng"], ["xìng"]],
    "背黑锅": [["bēi"], ["hēi"], ["guō"]],
    "背惠食言": [["bèi"], ["huì"], ["shí"], ["yán"]],
    "背井离乡": [["bèi"], ["jǐng"], ["lí"], ["xiāng"]],
    "背靠背": [["bèi"], ["kào"], ["bèi"]],
    "背盟败约": [["bèi"], ["méng"], ["bài"], ["yuē"]],
    "背前面后": [["bèi"], ["qián"], ["miàn"], ["hòu"]],
    "背曲腰躬": [["bèi"], ["qǔ"], ["yāo"], ["gōng"]],
    "背曲腰弯": [["bèi"], ["qǔ"], ["yāo"], ["wān"]],
    "背日性": [["bèi"], ["rì"], ["xìng"]],
    "背若芒刺": [["bèi"], ["ruò"], ["máng"], ["cì"]],
    "背山起楼": [["bèi"], ["shān"], ["qǐ"], ["lóu"]],
    "背生芒刺": [["bèi"], ["shēng"], ["máng"], ["cì"]],
    "背水一战": [["bèi"], ["shuǐ"], ["yī"], ["zhàn"]],
    "背水阵": [["bèi"], ["shuǐ"], ["zhèn"]],
    "背乡离井": [["bèi"], ["xiāng"], ["lí"], ["jǐng"]],
    "背信弃义": [["bèi"], ["xìn"], ["qì"], ["yì"]],
    "背义负恩": [["bèi"], ["yù"], ["fù"], ["ēn"]],
    "背义负信": [["bèi"], ["yù"], ["fù"], ["xìn"]],
    "背义忘恩": [["bèi"], ["yù"], ["wàng"], ["ēn"]],
    "背着手": [["bèi"], ["zhe"], ["shǒu"]],
    "倍道而行": [["bèi"], ["dào"], ["ér"], ["xíng"]],
    "倍道兼行": [["bèi"], ["dào"], ["jiān"], ["xíng"]],
    "倍日并行": [["bèi"], ["rì"], ["bìng"], ["xíng"]],
    "被宠若惊": [["bèi"], ["chǒng"], ["ruò"], ["jīng"]],
    "被动式": [["bèi"], ["dòng"], ["shì"]],
    "被发文身": [["pī"], ["fà"], ["wén"], ["shēn"]],
    "被发缨冠": [["pī"], ["fà"], ["yīng"], ["guàn"]],
    "被发左衽": [["pī"], ["fà"], ["zuǒ"], ["rèn"]],
    "被告人": [["bèi"], ["gào"], ["rén"]],
    "被害人": [["bèi"], ["hài"], ["rén"]],
    "被褐怀玉": [["pī"], ["hè"], ["huái"], ["yù"]],
    "被褐怀珠": [["pī"], ["hè"], ["huái"], ["zhū"]],
    "被甲持兵": [["pī"], ["jiǎ"], ["chí"], ["bīng"]],
    "被甲据鞍": [["pī"], ["jiǎ"], ["jù"], ["ān"]],
    "被甲枕戈": [["pī"], ["jiǎ"], ["zhěn"], ["gē"]],
    "被甲执兵": [["pī"], ["jiǎ"], ["zhí"], ["bīng"]],
    "被山带河": [["pī"], ["shān"], ["dài"], ["hé"]],
    "被窝儿": [["bèi"], ["wō"], ["ér"]],
    "被选举权": [["bèi"], ["xuǎn"], ["jǔ"], ["quán"]],
    "被泽蒙庥": [["bèi"], ["zé"], ["méng"], ["xiū"]],
    "被子植物": [["bèi"], ["zi"], ["zhí"], ["wù"]],
    "辈数儿": [["bèi"], ["shù"], ["ér"]],
    "奔头儿": [["bèn"], ["tou"], ["er"]],
    "奔轶绝尘": [["bēn"], ["yì"], ["jué"], ["chén"]],
    "奔逸绝尘": [["bēn"], ["yì"], ["jué"], ["chén"]],
    "奔走呼号": [["bēn"], ["zǒu"], ["hū"], ["háo"]],
    "奔走如市": [["bēn"], ["zǒu"], ["rú"], ["shì"]],
    "奔走相告": [["bēn"], ["zǒu"], ["xiāng"], ["gào"]],
    "奔走之友": [["bēn"], ["zǒu"], ["zhī"], ["yǒu"]],
    "奔走钻营": [["bēn"], ["zǒu"], ["zuān"], ["yíng"]],
    "本本分分": [["běn"], ["běn"], ["fèn"], ["fēn"]],
    "本地人": [["běn"], ["dì"], ["rén"]],
    "本固邦宁": [["běn"], ["gù"], ["bāng"], ["níng"]],
    "本固枝荣": [["běn"], ["gù"], ["zhī"], ["róng"]],
    "本末倒置": [["běn"], ["mò"], ["dào"], ["zhì"]],
    "本年度": [["běn"], ["nián"], ["dù"]],
    "本世纪": [["běn"], ["shì"], ["jì"]],
    "本同末离": [["běn"], ["tóng"], ["mò"], ["lí"]],
    "本同末异": [["běn"], ["tóng"], ["mò"], ["yì"]],
    "本相毕露": [["běn"], ["xiàng"], ["bì"], ["lù"]],
    "本性难移": [["běn"], ["xìng"], ["nán"], ["yí"]],
    "本枝百世": [["běn"], ["zhī"], ["bǒi"], ["shì"]],
    "笨头笨脑": [["bèn"], ["tóu"], ["bèn"], ["nǎo"]],
    "绷扒吊拷": [["bēng"], ["bā"], ["diào"], ["kǎo"]],
    "绷巴吊拷": [["bēng"], ["bā"], ["diào"], ["kǎo"]],
    "绷场面": [["bēng"], ["chǎng"], ["miàn"]],
    "绷爬吊拷": [["bēng"], ["pá"], ["diào"], ["kǎo"]],
    "蹦蹦跳跳": [["bèng"], ["bèng"], ["tiào"], ["tiào"]],
    "逼不得已": [["bī"], ["bù"], ["dé"], ["yǐ"]],
    "逼供信": [["bī"], ["gòng"], ["xìn"]],
    "逼良为娼": [["bī"], ["liáng"], ["wéi"], ["chāng"]],
    "逼上梁山": [["bī"], ["shàng"], ["liáng"], ["shān"]],
    "逼人太甚": [["bī"], ["rén"], ["tài"], ["shèn"]],
    "鼻孔朝天": [["bí"], ["kǒng"], ["cháo"], ["tiān"]],
    "鼻孔撩天": [["bí"], ["kǒng"], ["liáo"], ["tiān"]],
    "鼻头出火": [["bí"], ["tóu"], ["chū"], ["huǒ"]],
    "鼻咽癌": [["bí"], ["yān"], ["ái"]],
    "鼻中隔": [["bí"], ["zhōng"], ["gé"]],
    "匕鬯不惊": [["bǐ"], ["chàng"], ["bù"], ["jīng"]],
    "比户可封": [["bǐ"], ["hù"], ["kě"], ["fēng"]],
    "比肩并起": [["bǐ"], ["jiān"], ["bìng"], ["qǐ"]],
    "比肩齐声": [["bǐ"], ["jiān"], ["qí"], ["shēng"]],
    "比肩系踵": [["bǐ"], ["jiān"], ["xì"], ["zhǒng"]],
    "比较价格": [["bǐ"], ["jiào"], ["jià"], ["gé"]],
    "比较语言学": [["bǐ"], ["jiào"], ["yǔ"], ["yán"], ["xué"]],
    "比勒陀利亚": [["bǐ"], ["lè"], ["tuó"], ["lì"], ["yà"]],
    "比类从事": [["bǐ"], ["lèi"], ["cóng"], ["shì"]],
    "比例尺": [["bǐ"], ["lì"], ["chǐ"]],
    "比量齐观": [["bǐ"], ["liàng"], ["qí"], ["guān"]],
    "比目连枝": [["bǐ"], ["mù"], ["lián"], ["zhī"]],
    "比年不登": [["bǐ"], ["nián"], ["bù"], ["dēng"]],
    "比权量力": [["bǐ"], ["quán"], ["liàng"], ["lì"]],
    "比手划脚": [["bǐ"], ["shǒu"], ["huà"], ["jiǎo"]],
    "比岁不登": [["bǐ"], ["suì"], ["bù"], ["dēng"]],
    "比屋可封": [["bǐ"], ["wū"], ["kě"], ["fēng"]],
    "比物属事": [["bǐ"], ["wù"], ["zhǔ"], ["shì"]],
    "比物假事": [["bǐ"], ["wù"], ["jiǎ"], ["shì"]],
    "比翼连枝": [["bǐ"], ["yì"], ["lián"], ["zhī"]],
    "比翼齐飞": [["bǐ"], ["yì"], ["qí"], ["fēi"]],
    "比众不同": [["bǐ"], ["zhòng"], ["bù"], ["tóng"]],
    "彼倡此和": [["bǐ"], ["chàng"], ["cǐ"], ["hè"]],
    "彼唱此和": [["bǐ"], ["chàng"], ["cǐ"], ["hè"]],
    "秕言谬说": [["bǐ"], ["yán"], ["miù"], ["shuò"]],
    "笔大如椽": [["bǐ"], ["dà"], ["rú"], ["chuán"]],
    "笔底超生": [["bǐ"], ["dǐ"], ["chāo"], ["shēng"]],
    "笔底春风": [["bǐ"], ["dǐ"], ["chūn"], ["fēng"]],
    "笔底龙蛇": [["bǐ"], ["dǐ"], ["lóng"], ["shé"]],
    "笔底生花": [["bǐ"], ["dǐ"], ["shēng"], ["huā"]],
    "笔底下": [["bǐ"], ["dǐ"], ["xià"]],
    "笔杆儿": [["bǐ"], ["gǎn"], ["ér"]],
    "笔管条直": [["bǐ"], ["guǎn"], ["tiáo"], ["zhí"]],
    "笔墨横姿": [["bǐ"], ["mò"], ["héng"], ["zī"]],
    "笔扫千军": [["bǐ"], ["sǎo"], ["qiān"], ["jūn"]],
    "笔头儿": [["bǐ"], ["tou"], ["er"]],
    "笔头生花": [["bǐ"], ["tóu"], ["shēng"], ["huā"]],
    "笔冢研穿": [["bǐ"], ["zhǒng"], ["yán"], ["chuān"]],
    "笔削褒贬": [["bǐ"], ["xuē"], ["bāo"], ["biǎn"]],
    "笔走龙蛇": [["bǐ"], ["zǒu"], ["lóng"], ["shé"]],
    "鄙俚浅陋": [["bǐ"], ["lǐ"], ["qiǎn"], ["lòu"]],
    "鄙夷不屑": [["bǐ"], ["yí"], ["bù"], ["xiè"]],
    "鄙于不屑": [["bǐ"], ["yú"], ["bù"], ["xiè"]],
    "币重言甘": [["bì"], ["zhòng"], ["yán"], ["gān"]],
    "必不得已": [["bì"], ["bù"], ["dé"], ["yǐ"]],
    "必不可少": [["bì"], ["bù"], ["kě"], ["shǎo"]],
    "必不挠北": [["bì"], ["bù"], ["náo"], ["běi"]],
    "必操胜券": [["bì"], ["cāo"], ["shèng"], ["quàn"]],
    "必躬必亲": [["bì"], ["gōng"], ["bì"], ["qīn"]],
    "必然王国": [["bì"], ["rán"], ["wáng"], ["guó"]],
    "必要产品": [["bì"], ["yào"], ["chǎn"], ["pǐn"]],
    "必要劳动": [["bì"], ["yào"], ["láo"], ["dòng"]],
    "必要条件": [["bì"], ["yào"], ["tiáo"], ["jiàn"]],
    "必也正名": [["bì"], ["yě"], ["zhèng"], ["míng"]],
    "必争之地": [["bì"], ["zhēng"], ["zhī"], ["dì"]],
    "毕达哥拉斯": [["bì"], ["dá"], ["gē"], ["lā"], ["sī"]],
    "毕力同心": [["bì"], ["lì"], ["tóng"], ["xīn"]],
    "毕其功于一役": [["bì"], ["qí"], ["gōng"], ["yú"], ["yī"], ["yì"]],
    "毕业论文": [["bì"], ["yè"], ["lùn"], ["wén"]],
    "毕雨箕风": [["bì"], ["yǔ"], ["jī"], ["fēng"]],
    "闭阁思过": [["bì"], ["gé"], ["sī"], ["guò"]],
    "闭关却扫": [["bì"], ["guān"], ["què"], ["sǎo"]],
    "闭合电路": [["bì"], ["hé"], ["diàn"], ["lù"]],
    "闭合思过": [["bì"], ["gé"], ["sī"], ["guò"]],
    "闭合自责": [["bì"], ["gé"], ["zì"], ["zé"]],
    "闭户读书": [["bì"], ["hù"], ["dú"], ["shū"]],
    "闭口不言": [["bì"], ["kǒu"], ["bù"], ["yán"]],
    "闭口藏舌": [["bì"], ["kǒu"], ["cáng"], ["shé"]],
    "闭口结舌": [["bì"], ["kǒu"], ["jié"], ["shé"]],
    "闭门不出": [["bì"], ["mén"], ["bù"], ["chū"]],
    "闭门不纳": [["bì"], ["mén"], ["bù"], ["nà"]],
    "闭门读书": [["bì"], ["mén"], ["dú"], ["shū"]],
    "闭门合辙": [["bì"], ["kǒu"], ["hé"], ["shé"]],
    "闭门却扫": [["bì"], ["mén"], ["què"], ["sǎo"]],
    "闭门觅句": [["bì"], ["mén"], ["mì"], ["jù"]],
    "闭门塞窦": [["bì"], ["kǒu"], ["sè"], ["dòu"]],
    "闭门塞户": [["bì"], ["kǒu"], ["sè"], ["hù"]],
    "闭门扫轨": [["bì"], ["mén"], ["sǎo"], ["guǐ"]],
    "闭门扫迹": [["bì"], ["kǒu"], ["sǎo"], ["guǐ"]],
    "闭门埽轨": [["bì"], ["mén"], ["sào"], ["guǐ"]],
    "闭门思过": [["bì"], ["mén"], ["sī"], ["guò"]],
    "闭门造车": [["bì"], ["mén"], ["zào"], ["chē"]],
    "闭门思愆": [["bì"], ["gé"], ["sī"], ["qiān"]],
    "闭明塞聪": [["bì"], ["míng"], ["sè"], ["cōng"]],
    "闭目塞聪": [["bì"], ["mù"], ["sāi"], ["cōng"]],
    "闭目塞耳": [["bì"], ["mù"], ["sè"], ["ěr"]],
    "闭目塞听": [["bì"], ["mù"], ["sè"], ["tīng"]],
    "闭塞眼睛捉麻雀": [["bì"], ["sè"], ["yǎn"], ["jīng"], ["zhuō"], ["má"], ["què"]],
    "婢作夫人": [["bì"], ["zuò"], ["fū"], ["rén"]],
    "敝鼓丧豚": [["bì"], ["gǔ"], ["sàng"], ["tún"]],
    "敝盖不弃": [["bǐ"], ["gài"], ["bù"], ["qì"]],
    "敝绨恶粟": [["bì"], ["tí"], ["è"], ["sù"]],
    "敝帷不弃": [["bǐ"], ["wéi"], ["bù"], ["qì"]],
    "敝綈恶粟": [["bì"], ["tì"], ["è"], ["sù"]],
    "敝衣粝食": [["bì"], ["yī"], ["lì"], ["shí"]],
    "弊车羸马": [["bì"], ["chē"], ["léi"], ["mǎ"]],
    "弊绝风清": [["bì"], ["jué"], ["fēng"], ["qīng"]],
    "弊衣箪食": [["bì"], ["yī"], ["dān"], ["shí"]],
    "弊衣疏食": [["bì"], ["yī"], ["shū"], ["shí"]],
    "弊衣蔬食": [["bì"], ["yī"], ["shū"], ["shí"]],
    "碧鬟红袖": [["bì"], ["huán"], ["hóng"], ["xiù"]],
    "碧空如洗": [["bì"], ["kōng"], ["rú"], ["xǐ"]],
    "碧落黄泉": [["bì"], ["luò"], ["huáng"], ["quán"]],
    "碧血丹心": [["bì"], ["xuè"], ["dān"], ["xīn"]],
    "蔽聪塞明": [["bì"], ["cōnɡ"], ["sè"], ["mínɡ"]],
    "蔽明塞聪": [["bì"], ["míng"], ["sè"], ["cōng"]],
    "蔽日干云": [["bì"], ["rì"], ["gān"], ["yún"]],
    "壁间蛇影": [["bì"], ["jiān"], ["shé"], ["yǐng"]],
    "壁上观": [["bì"], ["shàng"], ["guān"]],
    "避而不谈": [["bì"], ["ér"], ["bù"], ["tán"]],
    "避烦斗捷": [["bì"], ["fán"], ["dòu"], ["jié"]],
    "避风港": [["bì"], ["fēng"], ["gǎng"]],
    "避迹藏时": [["bì"], ["jì"], ["cáng"], ["shí"]],
    "避风头": [["bì"], ["fēng"], ["tou"]],
    "避坑落井": [["bì"], ["kēng"], ["luò"], ["jǐng"]],
    "避凉附炎": [["bì"], ["liáng"], ["fù"], ["yán"]],
    "避难就易": [["bì"], ["nán"], ["jiù"], ["yì"]],
    "避难趋易": [["bì"], ["nán"], ["qiù"], ["yì"]],
    "避溺山隅": [["bì"], ["nì"], ["shān"], ["yú"]],
    "避强击惰": [["bì"], ["qiáng"], ["jī"], ["duò"]],
    "避强打弱": [["bì"], ["qiáng"], ["dǎ"], ["ruò"]],
    "避强击弱": [["bì"], ["qiáng"], ["jī"], ["ruò"]],
    "避俗趋新": [["bì"], ["sú"], ["qū"], ["xīn"]],
    "避凶趋吉": [["bì"], ["xiōng"], ["qū"], ["jí"]],
    "避重就轻": [["bì"], ["zhòng"], ["jiù"], ["qīng"]],
    "避之若浼": [["bì"], ["zhī"], ["ruò"], ["měi"]],
    "避重逐轻": [["bì"], ["zhòng"], ["zhú"], ["qīng"]],
    "璧合珠连": [["bì"], ["hé"], ["zhū"], ["lián"]],
    "臂有四肘": [["bì"], ["yǒu"], ["sì"], ["zhǒu"]],
    "璧合珠联": [["bì"], ["hé"], ["zhū"], ["lián"]],
    "边尘不惊": [["biān"], ["chén"], ["bù"], ["jīng"]],
    "边角料": [["biān"], ["jiǎo"], ["liào"]],
    "编年体": [["biān"], ["nián"], ["tǐ"]],
    "编织品": [["biān"], ["zhī"], ["pǐn"]],
    "编织物": [["biān"], ["zhī"], ["wù"]],
    "鞭辟近里": [["biān"], ["pì"], ["jìn"], ["lǐ"]],
    "鞭辟入里": [["biān"], ["pì"], ["rù"], ["lǐ"]],
    "鞭辟向里": [["biān"], ["bì"], ["xiàng"], ["lǐ"]],
    "鞭辟着里": [["biān"], ["bì"], ["zhuó"], ["lǐ"]],
    "鞭不及腹": [["biān"], ["bù"], ["jí"], ["fù"]],
    "鞭长不及": [["biān"], ["cháng"], ["bù"], ["jí"]],
    "鞭长不及马腹": [["biān"], ["cháng"], ["bù"], ["jí"], ["mǎ"], ["fù"]],
    "鞭长驾远": [["biān"], ["cháng"], ["jià"], ["yuǎn"]],
    "鞭长莫及": [["biān"], ["cháng"], ["mò"], ["jí"]],
    "鞭打快牛": [["biān"], ["dǎ"], ["kuài"], ["niú"]],
    "鞭擗进里": [["bīan"], ["pì"], ["jìn"], ["lǐ"]],
    "鞭擗向里": [["biān"], ["bì"], ["xiàng"], ["lǐ"]],
    "鞭约近里": [["biān"], ["yuē"], ["jīn"], ["lǐ"]],
    "扁平足": [["biǎn"], ["píng"], ["zú"]],
    "扁桃体": [["biǎn"], ["táo"], ["tǐ"]],
    "扁桃体炎": [["biǎn"], ["táo"], ["tǐ"], ["yán"]],
    "扁桃腺": [["biǎn"], ["táo"], ["xiàn"]],
    "扁形动物": [["biǎn"], ["xíng"], ["dòng"], ["wù"]],
    "抃风舞润": [["biàn"], ["fēng"], ["wǔ"], ["rùn"]],
    "抃风儛润": [["biàn"], ["fēng"], ["wǔ"], ["rùn"]],
    "便步走": [["biàn"], ["bù"], ["zǒu"]],
    "便辞巧说": [["biàn"], ["cí"], ["qiǎo"], ["shuō"]],
    "便携式": [["biàn"], ["xié"], ["shì"]],
    "便宜从事": [["biàn"], ["yú"], ["cóng"], ["shì"]],
    "便宜货": [["biàn"], ["yí"], ["huò"]],
    "便宜施行": [["bián"], ["yú"], ["shī"], ["xíng"]],
    "便宜行事": [["biàn"], ["yì"], ["xíng"], ["shì"]],
    "变动不居": [["biàn"], ["dòng"], ["bù"], ["jū"]],
    "变分法": [["biàn"], ["fēn"], ["fǎ"]],
    "变风改俗": [["biàn"], ["fēng"], ["yì"], ["sú"]],
    "变化不测": [["biàn"], ["huà"], ["bù"], ["cè"]],
    "变风易俗": [["biàn"], ["fēng"], ["yì"], ["sú"]],
    "变化不穷": [["biàn"], ["huà"], ["bù"], ["qióng"]],
    "变化多端": [["biàn"], ["huà"], ["duō"], ["duān"]],
    "变化莫测": [["biàn"], ["huà"], ["mò"], ["cè"]],
    "变化如神": [["biàn"], ["huà"], ["rú"], ["shén"]],
    "变化无穷": [["biàn"], ["huà"], ["wú"], ["qióng"]],
    "变化无常": [["biàn"], ["huà"], ["wú"], ["cháng"]],
    "变幻不测": [["biàn"], ["huà"], ["bù"], ["cè"]],
    "变幻莫测": [["biàn"], ["huàn"], ["mò"], ["cè"]],
    "变生不测": [["biàn"], ["shēng"], ["bù"], ["cè"]],
    "变俗易教": [["biàn"], ["sú"], ["yì"], ["jiào"]],
    "变态反应": [["biàn"], ["tài"], ["fǎn"], ["yìng"]],
    "变危为安": [["biàn"], ["wēi"], ["wéi"], ["ān"]],
    "变贪厉薄": [["biǎn"], ["tān"], ["lì"], ["bó"]],
    "变戏法": [["biàn"], ["xì"], ["fǎ"]],
    "变压器": [["biàn"], ["yā"], ["qì"]],
    "变奏曲": [["biàn"], ["zòu"], ["qǔ"]],
    "遍地开花": [["biàn"], ["dì"], ["kāi"], ["huā"]],
    "遍体鳞伤": [["biàn"], ["tǐ"], ["lín"], ["shāng"]],
    "辨别力": [["biàn"], ["bié"], ["lì"]],
    "辨日炎凉": [["biàn"], ["rì"], ["yán"], ["liáng"]],
    "辨若悬河": [["biàn"], ["ruò"], ["xuán"], ["hé"]],
    "辨证论治": [["biàn"], ["zhèng"], ["lùn"], ["zhì"]],
    "彪形大汉": [["biāo"], ["xíng"], ["dà"], ["hàn"]],
    "标点符号": [["biāo"], ["diǎn"], ["fú"], ["hào"]],
    "标情夺趣": [["biāo"], ["qíng"], ["duó"], ["qù"]],
    "标题音乐": [["biāo"], ["tí"], ["yīn"], ["yuè"]],
    "标同伐异": [["biāo"], ["tóng"], ["fá"], ["yì"]],
    "标新创异": [["biāo"], ["xīn"], ["chuàng"], ["yì"]],
    "标枝野鹿": [["biāo"], ["zhī"], ["yě"], ["lù"]],
    "标准大气压": [["biāo"], ["zhǔn"], ["dà"], ["qì"], ["yā"]],
    "标准化": [["biāo"], ["zhǔn"], ["huà"]],
    "标准时区": [["biāo"], ["zhǔn"], ["shí"], ["qū"]],
    "标准语": [["biāo"], ["zhǔn"], ["yǔ"]],
    "膘肥体壮": [["biāo"], ["féi"], ["tǐ"], ["zhuàng"]],
    "飙发电举": [["biāo"], ["fā"], ["diàn"], ["jù"]],
    "表里不一": [["biǎo"], ["lǐ"], ["bù"], ["yī"]],
    "表里为奸": [["biǎo"], ["lǐ"], ["wéi"], ["jiān"]],
    "表里相符": [["biǎo"], ["lǐ"], ["xiāng"], ["fú"]],
    "表里相济": [["biǎo"], ["lǐ"], ["xiāng"], ["jì"]],
    "表里相依": [["biǎo"], ["lǐ"], ["xiāng"], ["yī"]],
    "表里相应": [["biǎo"], ["lǐ"], ["xiāng"], ["yìng"]],
    "表蒙子": [["biǎo"], ["méng"], ["zǐ"]],
    "表面化": [["biǎo"], ["miàn"], ["huà"]],
    "表兄弟": [["biǎo"], ["xiōng"], ["dì"]],
    "表演艺术": [["biǎo"], ["yǎn"], ["yì"], ["shù"]],
    "表壮不如里壮": [["biǎo"], ["zhuàng"], ["bù"], ["rú"], ["lǐ"], ["zhuàng"]],
    "表侄女": [["biǎo"], ["zhí"], ["nǚ"]],
    "摽梅之年": [["biào"], ["mén"], ["zhī"], ["nián"]],
    "别抱琵琶": [["bié"], ["bào"], ["pí"], ["pá"]],
    "别出机杼": [["bié"], ["chū"], ["jī"], ["zhù"]],
    "别出手眼": [["bié"], ["chū"], ["shǒu"], ["yǎn"]],
    "别财异居": [["bié"], ["cái"], ["yì"], ["jū"]],
    "别出心裁": [["bié"], ["chū"], ["xīn"], ["cái"]],
    "别出新裁": [["bié"], ["chū"], ["xīn"], ["cái"]],
    "别出新意": [["bié"], ["chū"], ["xīn"], ["yì"]],
    "别创一格": [["bié"], ["chuàng"], ["yí"], ["gé"]],
    "别动队": [["bié"], ["dòng"], ["duì"]],
    "别风淮雨": [["bié"], ["fēng"], ["huái"], ["yǔ"]],
    "别鹤孤鸾": [["bié"], ["hè"], ["gū"], ["luán"]],
    "别鹤离鸾": [["bié"], ["hè"], ["lí"], ["láun"]],
    "别籍异财": [["bié"], ["jí"], ["yì"], ["cái"]],
    "别籍异居": [["bié"], ["jí"], ["yì"], ["jū"]],
    "别居异财": [["bié"], ["jū"], ["yì"], ["cái"]],
    "别具肺肠": [["bié"], ["jù"], ["fèi"], ["cháng"]],
    "别具匠心": [["bié"], ["jù"], ["jiàng"], ["xīn"]],
    "别具慧眼": [["bié"], ["jù"], ["huì"], ["yǎn"]],
    "别具手眼": [["bié"], ["jù"], ["shǒu"], ["yǎn"]],
    "别具心肠": [["bié"], ["jù"], ["xīn"], ["cháng"]],
    "别具只眼": [["bié"], ["jù"], ["zhī"], ["yǎn"]],
    "别具一格": [["bié"], ["jù"], ["yī"], ["gé"]],
    "别开蹊径": [["bié"], ["kāi"], ["xī"], ["jìng"]],
    "别开生面": [["bié"], ["kāi"], ["shēng"], ["miàn"]],
    "别开一格": [["bié"], ["kāi"], ["yí"], ["gé"]],
    "别来无恙": [["bié"], ["lái"], ["wú"], ["yàng"]],
    "别类分门": [["bié"], ["lèi"], ["fān"], ["mén"]],
    "别生枝节": [["bié"], ["shēng"], ["zhī"], ["jié"]],
    "别饶风致": [["bié"], ["ráo"], ["fēng"], ["zhì"]],
    "别树一旗": [["bié"], ["shù"], ["yī"], ["qí"]],
    "别树一帜": [["bié"], ["shù"], ["yī"], ["zhì"]],
    "别无长物": [["bié"], ["wú"], ["cháng"], ["wù"]],
    "别无出路": [["bié"], ["wú"], ["chū"], ["lù"]],
    "别无二致": [["bié"], ["wú"], ["èr"], ["zhì"]],
    "别无他物": [["bié"], ["wú"], ["tā"], ["wù"]],
    "别有洞天": [["bié"], ["yǒu"], ["dòng"], ["tiān"]],
    "别有肺肠": [["bié"], ["yǒu"], ["fèi"], ["cháng"]],
    "别有风趣": [["bié"], ["yǒu"], ["fēng"], ["qù"]],
    "别有人间": [["bié"], ["yǒu"], ["rén"], ["jiān"]],
    "别有风味": [["bié"], ["yǒu"], ["fēng"], ["wèi"]],
    "别有天地": [["bié"], ["yǒu"], ["tiān"], ["dì"]],
    "别有心肠": [["bié"], ["yǒu"], ["xīn"], ["cháng"]],
    "别有心肝": [["bié"], ["yǒu"], ["xīn"], ["gān"]],
    "别有用心": [["bié"], ["yǒu"], ["yòng"], ["xīn"]],
    "别有滋味": [["bié"], ["yǒu"], ["zī"], ["wèi"]],
    "别置一喙": [["bié"], ["zhì"], ["yī"], ["huì"]],
    "别作良图": [["bié"], ["zuò"], ["liáng"], ["tú"]],
    "别作一眼": [["bié"], ["zuò"], ["yī"], ["yǎn"]],
    "彬彬济济": [["bīn"], ["bīn"], ["jǐ"], ["jǐ"]],
    "彬彬有礼": [["bīn"], ["bīn"], ["yǒu"], ["lǐ"]],
    "滨海区": [["bīn"], ["hǎi"], ["qū"]],
    "鬓乱钗横": [["bìn"], ["luàn"], ["chāi"], ["héng"]],
    "冰碴儿": [["bīng"], ["chá"], ["ér"]],
    "冰川期": [["bīng"], ["chuān"], ["qī"]],
    "冰棍儿": [["bīng"], ["gùn"], ["ér"]],
    "冰肌玉骨": [["bīng"], ["jī"], ["yù"], ["gǔ"]],
    "冰河期": [["bīng"], ["hé"], ["qī"]],
    "冰解冻释": [["bīng"], ["jiě"], ["dòng"], ["shì"]],
    "冰解的破": [["bīng"], ["jiě"], ["dì"], ["pò"]],
    "冰解云散": [["bīng"], ["jiě"], ["yún"], ["sàn"]],
    "冰解壤分": [["bīng"], ["jiě"], ["rǎng"], ["fēn"]],
    "冰淇淋": [["bīng"], ["qí"], ["lín"]],
    "冰散瓦解": [["bīng"], ["sàn"], ["wǎ"], ["jiě"]],
    "冰山难靠": [["bīng"], ["shān"], ["nán"], ["kào"]],
    "冰山易倒": [["bīng"], ["shān"], ["yì"], ["dǎo"]],
    "冰上运动": [["bīng"], ["shàng"], ["yùn"], ["dòng"]],
    "冰炭不同炉": [["bīng"], ["tàn"], ["bù"], ["tóng"], ["lú"]],
    "冰炭不同器": [["bīng"], ["tàn"], ["bù"], ["tóng"], ["qì"]],
    "冰炭不投": [["bīng"], ["tàn"], ["bù"], ["tóu"]],
    "冰天雪地": [["bīng"], ["tiān"], ["xuě"], ["dì"]],
    "冰消冻解": [["bīng"], ["xiāo"], ["dòng"], ["jiě"]],
    "冰消瓦解": [["bīng"], ["xiāo"], ["wǎ"], ["jiě"]],
    "冰消雾散": [["bīng"], ["xiāo"], ["wù"], ["sàn"]],
    "冰消云散": [["bīng"], ["xiāo"], ["yún"], ["sàn"]],
    "冰销雾散": [["bīng"], ["xiāo"], ["wù"], ["sàn"]],
    "冰销叶散": [["bīng"], ["xiāo"], ["yè"], ["sàn"]],
    "冰心一片": [["bīng"], ["xīn"], ["yī"], ["piàn"]],
    "冰雪节": [["bīng"], ["xuě"], ["jié"]],
    "兵败如山倒": [["bīng"], ["bài"], ["rú"], ["shān"], ["dǎo"]],
    "兵不接刃": [["bīng"], ["bù"], ["jiē"], ["rèn"]],
    "兵不污刃": [["bīng"], ["bù"], ["wū"], ["rèn"]],
    "兵不雪刃": [["bīng"], ["bù"], ["xuě"], ["rèn"]],
    "兵不厌权": [["bīng"], ["bù"], ["yàn"], ["quán"]],
    "兵不厌诈": [["bīng"], ["bù"], ["yàn"], ["zhà"]],
    "兵不由将": [["bīng"], ["bù"], ["yóu"], ["jiàng"]],
    "兵不血刃": [["bīng"], ["bù"], ["xuè"], ["rèn"]],
    "兵车之会": [["bīng"], ["chē"], ["zhī"], ["huì"]],
    "兵多将广": [["bīng"], ["duō"], ["jiàng"], ["guǎng"]],
    "兵工厂": [["bīng"], ["gōng"], ["chǎng"]],
    "兵连祸结": [["bīng"], ["lián"], ["huò"], ["jié"]],
    "兵拏祸结": [["bīng"], ["ná"], ["huò"], ["jié"]],
    "兵强将勇": [["bīng"], ["qiáng"], ["àng"], ["yǒng"]],
    "兵强则灭": [["bīng"], ["qiáng"], ["zé"], ["miè"]],
    "兵强马壮": [["bīng"], ["qiáng"], ["mǎ"], ["zhuàng"]],
    "兵戎相见": [["bīng"], ["róng"], ["xiāng"], ["jiàn"]],
    "兵微将寡": [["bīng"], ["wēi"], ["jiàng"], ["guǎ"]],
    "兵未血刃": [["bīng"], ["wèi"], ["xuě"], ["rèn"]],
    "兵无血刃": [["bīng"], ["wú"], ["xuè"], ["rèn"]],
    "兵役制度": [["bīng"], ["yì"], ["zhì"], ["dù"]],
    "兵行诡道": [["bīng"], ["xíng"], ["guǐ"], ["dào"]],
    "兵在精而不在多": [["bīng"], ["zài"], ["jīng"], ["ér"], ["bù"], ["zài"], ["duō"]],
    "兵在其颈": [["bīng"], ["zài"], ["qí"], ["jǐng"]],
    "掤扒吊拷": [["bīng"], ["bā"], ["diào"], ["kǎo"]],
    "丙种射线": [["bǐng"], ["zhǒng"], ["shè"], ["xiàn"]],
    "秉公任直": [["bǐng"], ["gōng"], ["rèn"], ["zhí"]],
    "秉节持重": [["bǐng"], ["jié"], ["chí"], ["zhòng"]],
    "秉钧持轴": [["bǐng"], ["jūn"], ["chí"], ["zhóu"]],
    "秉钧当轴": [["bǐng"], ["jūn"], ["dāng"], ["zhóu"]],
    "秉要执本": [["bǐng"], ["yào"], ["zhí"], ["běn"]],
    "秉正无私": [["bǐng"], ["zhèng"], ["wú"], ["sī"]],
    "秉烛待旦": [["bǐng"], ["zhú"], ["dài"], ["dàn"]],
    "炳若观火": [["bǐng"], ["ruò"], ["guān"], ["huǒ"]],
    "炳如观火": [["bǐng"], ["rú"], ["guān"], ["huǒ"]],
    "炳若日星": [["bǐng"], ["ruò"], ["rì"], ["xīng"]],
    "禀性难移": [["bǐng"], ["xìng"], ["nán"], ["yí"]],
    "并存不悖": [["bìng"], ["cún"], ["bù"], ["bèi"]],
    "并蒂芙蓉": [["bìng"], ["dì"], ["fú"], ["róng"]],
    "并蒂莲": [["bìng"], ["dì"], ["lián"]],
    "并发症": [["bìng"], ["fā"], ["zhèng"]],
    "并驾齐驱": [["bìng"], ["jià"], ["qí"], ["qū"]],
    "并肩作战": [["bìng"], ["jiān"], ["zuò"], ["zhàn"]],
    "并疆兼巷": [["bìng"], ["jiāng"], ["jiān"], ["xiàng"]],
    "并驱争先": [["bìng"], ["qū"], ["zhēng"], ["xiān"]],
    "并日而食": [["bìng"], ["rì"], ["ér"], ["shí"]],
    "并容徧覆": [["bìng"], ["róng"], ["biàn"], ["fù"]],
    "并世无两": [["bìng"], ["shì"], ["wú"], ["liǎng"]],
    "并威偶势": [["bìng"], ["wēi"], ["ǒu"], ["shì"]],
    "并为一谈": [["bìng"], ["wéi"], ["yī"], ["tán"]],
    "并行不悖": [["bìng"], ["xíng"], ["bù"], ["bèi"]],
    "并赃拿贼": [["bìng"], ["zhuō"], ["ná"], ["zéi"]],
    "病从口入": [["bìng"], ["cóng"], ["kǒu"], ["rù"]],
    "病毒性肝炎": [["bìng"], ["dú"], ["xìng"], ["gān"], ["yán"]],
    "病骨支离": [["bìng"], ["gǔ"], ["zhī"], ["lí"]],
    "病入膏肓": [["bìng"], ["rù"], ["gāo"], ["huāng"]],
    "病染膏肓": [["bìng"], ["rǎn"], ["gāo"], ["huāng"]],
    "病入骨隨": [["bìng"], ["rù"], ["gǔ"], ["suǐ"]],
    "病入骨髓": [["bìng"], ["rù"], ["gǔ"], ["suǐ"]],
    "病原体": [["bìng"], ["yuán"], ["tǐ"]],
    "拨草寻蛇": [["bō"], ["cǎo"], ["xún"], ["shé"]],
    "病在膏肓": [["bìng"], ["zài"], ["gāo"], ["huāng"]],
    "拨草瞻风": [["bō"], ["cǎo"], ["zhān"], ["fēng"]],
    "拨乱反正": [["bō"], ["luàn"], ["fǎn"], ["zhèng"]],
    "拨乱济时": [["bō"], ["luàn"], ["jì"], ["shí"]],
    "拨乱济危": [["bō"], ["luàn"], ["jì"], ["wēi"]],
    "拨乱为治": [["bō"], ["luàn"], ["wéi"], ["zhì"]],
    "拨万轮千": [["bō"], ["wàn"], ["lún"], ["qiān"]],
    "拨雨撩云": [["bō"], ["yǔ"], ["liáo"], ["yún"]],
    "拨万论千": [["bō"], ["wàn"], ["lùn"], ["qiān"]],
    "拨云见日": [["bō"], ["yún"], ["jiàn"], ["rì"]],
    "拨嘴撩牙": [["bō"], ["zuǐ"], ["liáo"], ["yá"]],
    "拨云撩雨": [["bō"], ["yún"], ["liáo"], ["yǔ"]],
    "波波碌碌": [["bō"], ["bō"], ["lù"], ["lù"]],
    "拨云雾见青天": [["bō"], ["yún"], ["wū"], ["jiàn"], ["qīng"], ["tiān"]],
    "波骇云属": [["bō"], ["hài"], ["yún"], ["zhǔ"]],
    "波罗的海": [["bō"], ["luó"], ["de"], ["hǎi"]],
    "波罗塞戏": [["bō"], ["luó"], ["sāi"], ["xì"]],
    "波斯猫": [["bō"], ["sī"], ["māo"]],
    "波涛汹涌": [["bō"], ["tāo"], ["xiōng"], ["yǒng"]],
    "波属云委": [["bō"], ["zhǔ"], ["yún"], ["wěi"]],
    "玻璃钢": [["bō"], ["li"], ["gāng"]],
    "玻璃纤维": [["bō"], ["li"], ["xiān"], ["wéi"]],
    "剥床及肤": [["bō"], ["chuáng"], ["jí"], ["fū"]],
    "剥肤之痛": [["bō"], ["fū"], ["zhī"], ["tòng"]],
    "剥肤及髓": [["bō"], ["fū"], ["jí"], ["suǐ"]],
    "剥肤椎髓": [["bō"], ["fū"], ["chuí"], ["suǐ"]],
    "剥极必复": [["bō"], ["jí"], ["bì"], ["fù"]],
    "剥极将复": [["bō"], ["jí"], ["jiāng"], ["fù"]],
    "剥极则复": [["bō"], ["jí"], ["zé"], ["fù"]],
    "剥茧抽丝": [["bō"], ["jiǎn"], ["chōu"], ["sī"]],
    "剥皮抽筋": [["bō"], ["pí"], ["chōu"], ["jīn"]],
    "剥削阶级": [["bō"], ["xuē"], ["jiē"], ["jí"]],
    "剥削者": [["bō"], ["xuē"], ["zhě"]],
    "播穅眯目": [["bō"], ["kāng"], ["mǐ"], ["mù"]],
    "播糠眯目": [["bō"], ["kāng"], ["mǐ"], ["mù"]],
    "播弄是非": [["bō"], ["nòng"], ["shì"], ["fēi"]],
    "播音员": [["bō"], ["yīn"], ["yuán"]],
    "播种机": [["bō"], ["zhǒng"], ["jī"]],
    "伯道无儿": [["bó"], ["dào"], ["wú"], ["ér"]],
    "伯尔尼": [["bó"], ["ěr"], ["ní"]],
    "伯歌季舞": [["bó"], ["gē"], ["jì"], ["wǔ"]],
    "伯劳飞燕": [["bó"], ["láo"], ["fēi"], ["yàn"]],
    "伯乐相马": [["bó"], ["lè"], ["xiàng"], ["mǎ"]],
    "伯乐一顾": [["bō"], ["lè"], ["yī"], ["gù"]],
    "伯利兹": [["bó"], ["lì"], ["zī"]],
    "伯埙仲篪": [["bó"], ["xūn"], ["zhòng"], ["chí"]],
    "伯玉知非": [["bó"], ["yù"], ["zhī"], ["fēi"]],
    "伯仲叔季": [["bó"], ["zhòng"], ["shū"], ["jì"]],
    "伯仲之间": [["bó"], ["zhòng"], ["zhī"], ["jiān"]],
    "伯祖母": [["bó"], ["zǔ"], ["mǔ"]],
    "勃然变色": [["bó"], ["rán"], ["biàn"], ["sè"]],
    "勃然大怒": [["bó"], ["rán"], ["dà"], ["nù"]],
    "勃然奋励": [["bó"], ["rán"], ["fèn"], ["lì"]],
    "博采众长": [["bó"], ["cǎi"], ["zhòng"], ["cháng"]],
    "博采众议": [["bó"], ["cǎi"], ["zhòng"], ["yì"]],
    "博茨瓦纳": [["bó"], ["cí"], ["wǎ"], ["nà"]],
    "博大精深": [["bó"], ["dà"], ["jīng"], ["shēn"]],
    "博而不精": [["bó"], ["ér"], ["bù"], ["jīng"]],
    "博而寡要": [["bó"], ["ér"], ["guǎ"], ["yào"]],
    "博览会": [["bó"], ["lǎn"], ["huì"]],
    "博览五车": [["bó"], ["lǎn"], ["wǔ"], ["chē"]],
    "博施济众": [["bó"], ["shī"], ["jì"], ["zhòng"]],
    "博识多通": [["bó"], ["shí"], ["duō"], ["tōng"]],
    "博识洽闻": [["bó"], ["shí"], ["qià"], ["wén"]],
    "博硕肥腯": [["bó"], ["shuò"], ["féi"], ["tú"]],
    "博闻多识": [["bó"], ["wén"], ["duō"], ["shí"]],
    "博文约礼": [["bó"], ["wén"], ["yuè"], ["lǐ"]],
    "博闻强记": [["bó"], ["wén"], ["qiáng"], ["jì"]],
    "博闻强识": [["bó"], ["wén"], ["qiáng"], ["zhì"]],
    "博物学家": [["bó"], ["wù"], ["xué"], ["jiā"]],
    "博闻强志": [["bó"], ["wén"], ["qiáng"], ["zhì"]],
    "踣地呼天": [["bó"], ["dì"], ["hū"], ["tiān"]],
    "薄唇轻言": [["báo"], ["chún"], ["qīng"], ["yán"]],
    "薄寒中人": [["bó"], ["hán"], ["zhòng"], ["rén"]],
    "薄荷脑": [["bò"], ["he"], ["nǎo"]],
    "薄技在身": [["bó"], ["jì"], ["zài"], ["shēn"]],
    "薄利多销": [["bó"], ["lì"], ["duō"], ["xiāo"]],
    "薄命佳人": [["bó"], ["mìng"], ["jiā"], ["rén"]],
    "薄暮冥冥": [["bó"], ["mù"], ["míng"], ["míng"]],
    "薄情无义": [["báo"], ["qíng"], ["wú"], ["yì"]],
    "薄物细故": [["bó"], ["wù"], ["xì"], ["gù"]],
    "跛行千里": [["bǒ"], ["xíng"], ["qiān"], ["lǐ"]],
    "簸土扬沙": [["bǒ"], ["tǔ"], ["yáng"], ["shā"]],
    "擘肌分理": [["bò"], ["jī"], ["fēn"], ["lǐ"]],
    "擘两分星": [["bó"], ["liǎng"], ["fēn"], ["xīng"]],
    "餔糟啜漓": [["bǔ"], ["zāo"], ["chuò"], ["lí"]],
    "餔糟啜醨": [["bū"], ["zāo"], ["chuò"], ["lí"]],
    "卜夜卜昼": [["bǔ"], ["yè"], ["bǔ"], ["zhòu"]],
    "卜昼卜夜": [["bǔ"], ["zhòu"], ["bǔ"], ["yè"]],
    "补骨脂": [["bǔ"], ["gǔ"], ["zhī"]],
    "补过饰非": [["bǔ"], ["guò"], ["shì"], ["fēi"]],
    "补过拾遗": [["bǔ"], ["guò"], ["shí"], ["yí"]],
    "补苴罅漏": [["bǔ"], ["jū"], ["xià"], ["lòu"]],
    "补阙灯檠": [["bǔ"], ["quē"], ["dēng"], ["qíng"]],
    "补阙挂漏": [["bǔ"], ["quē"], ["guà"], ["lòu"]],
    "补阙拾遗": [["bǔ"], ["quē"], ["shí"], ["yí"]],
    "补天柱地": [["bǔ"], ["tiān"], ["zhù"], ["dì"]],
    "补习学校": [["bǔ"], ["xí"], ["xué"], ["xiào"]],
    "捕风弄月": [["bǔ"], ["fēng"], ["nòng"], ["yuè"]],
    "哺糟啜醨": [["bǔ"], ["zāo"], ["chuò"], ["lí"]],
    "捕风捉影": [["bǔ"], ["fēng"], ["zhuō"], ["yǐng"]],
    "捕影系风": [["bǔ"], ["yǐng"], ["xì"], ["fēng"]],
    "不安分": [["bù"], ["ān"], ["fèn"]],
    "不安其室": [["bù"], ["ān"], ["qí"], ["shì"]],
    "不安于室": [["bù"], ["ān"], ["yú"], ["shì"]],
    "不安于位": [["bù"], ["ān"], ["yú"], ["wèi"]],
    "不按君臣": [["bù"], ["àn"], ["jūn"], ["chén"]],
    "不拔一毛": [["bù"], ["bá"], ["yì"], ["máo"]],
    "不拔之志": [["bù"], ["bá"], ["zhī"], ["zhì"]],
    "不白之冤": [["bù"], ["bái"], ["zhī"], ["yuān"]],
    "不败之地": [["bù"], ["bài"], ["zhī"], ["dì"]],
    "不卑不亢": [["bù"], ["bēi"], ["bù"], ["kàng"]],
    "不辟斧钺": [["bù"], ["bì"], ["fǔ"], ["yuè"]],
    "不避艰险": [["bù"], ["bì"], ["jiān"], ["xiǎn"]],
    "不避斧钺": [["bù"], ["bì"], ["fǔ"], ["yuè"]],
    "不避水火": [["bù"], ["bì"], ["shuǐ"], ["huǒ"]],
    "不避汤火": [["bù"], ["bì"], ["tāng"], ["huǒ"]],
    "不便水土": [["bù"], ["biàn"], ["shuǐ"], ["tǔ"]],
    "不变价格": [["bù"], ["biàn"], ["jià"], ["gé"]],
    "不变资本": [["bù"], ["biàn"], ["zī"], ["běn"]],
    "不辨菽麦": [["bù"], ["biàn"], ["shū"], ["mài"]],
    "不辨菽粟": [["bù"], ["biàn"], ["shū"], ["sù"]],
    "不辨真伪": [["bù"], ["biàn"], ["zhēn"], ["wěi"]],
    "不辩菽麦": [["bù"], ["biàn"], ["shū"], ["mài"]],
    "不步人脚": [["bù"], ["bù"], ["rén"], ["jiǎo"]],
    "不测之忧": [["bù"], ["cè"], ["zhī"], ["yōu"]],
    "不测之祸": [["bù"], ["cè"], ["zhī"], ["huò"]],
    "不测之罪": [["bù"], ["cè"], ["zhī"], ["zuì"]],
    "不茶不饭": [["bù"], ["chá"], ["bù"], ["fàn"]],
    "不差毫发": [["bù"], ["chā"], ["háo"], ["fà"]],
    "不差毫厘": [["bù"], ["chā"], ["háo"], ["lí"]],
    "不差累黍": [["bù"], ["chā"], ["lěi"], ["shǔ"]],
    "不差上下": [["bù"], ["chā"], ["shàng"], ["xià"]],
    "不差什么": [["bù"], ["chà"], ["shí"], ["mǒ"]],
    "不臣之心": [["bù"], ["chén"], ["zhī"], ["xīn"]],
    "不成才": [["bù"], ["chéng"], ["cái"]],
    "不成话": [["bù"], ["chéng"], ["huà"]],
    "不成器": [["bù"], ["chéng"], ["qì"]],
    "不成三瓦": [["bù"], ["chéng"], ["sān"], ["wǎ"]],
    "不成体统": [["bù"], ["chéng"], ["tǐ"], ["tǒng"]],
    "不成文法": [["bù"], ["chéng"], ["wén"], ["fǎ"]],
    "不逞之徒": [["bù"], ["chěng"], ["zhī"], ["tú"]],
    "不吃烟火食": [["bù"], ["chī"], ["yān"], ["huǒ"], ["shí"]],
    "不痴不聋": [["bù"], ["chī"], ["bù"], ["lóng"]],
    "不齿于人": [["bù"], ["chǐ"], ["yú"], ["rén"]],
    "不耻下问": [["bù"], ["chǐ"], ["xià"], ["wèn"]],
    "不耻最后": [["bù"], ["chǐ"], ["zuì"], ["hòu"]],
    "不啻天渊": [["bù"], ["chì"], ["tiān"], ["yuān"]],
    "不偢不倸": [["bù"], ["chǒu"], ["bù"], ["cǎi"]],
    "不出所料": [["bù"], ["chū"], ["suǒ"], ["liào"]],
    "不瞅不睬": [["bù"], ["chǒu"], ["bù"], ["cǎi"]],
    "不揣冒昧": [["bù"], ["chuǎi"], ["mào"], ["mèi"]],
    "不辞而别": [["bù"], ["cí"], ["ér"], ["bié"]],
    "不辞劳苦": [["bù"], ["cí"], ["láo"], ["kǔ"]],
    "不次之迁": [["bù"], ["cì"], ["zhī"], ["qiān"]],
    "不次之位": [["bù"], ["cì"], ["zhī"], ["wèi"]],
    "不存不济": [["bù"], ["cún"], ["bù"], ["jì"]],
    "不存芥蒂": [["bù"], ["cún"], ["jiè"], ["dì"]],
    "不打不相识": [["bù"], ["dǎ"], ["bù"], ["xiāng"], ["shí"]],
    "不打紧": [["bù"], ["dǎ"], ["jǐn"]],
    "不打自招": [["bù"], ["dǎ"], ["zì"], ["zhāo"]],
    "不大离": [["bù"], ["dà"], ["lí"]],
    "不待蓍龟": [["bù"], ["dài"], ["shī"], ["guī"]],
    "不当不正": [["bù"], ["dāng"], ["bù"], ["zhèng"]],
    "不当人子": [["bù"], ["dāng"], ["rén"], ["zǐ"]],
    "不倒翁": [["bù"], ["dǎo"], ["wēng"]],
    "不到长城非好汉": [["bú"], ["dào"], ["cháng"], ["chéng"], ["fēi"], ["hǎo"], ["hàn"]],
    "不到黄河心不死": [["bù"], ["dào"], ["huáng"], ["hé"], ["xīn"], ["bù"], ["sǐ"]],
    "不道德": [["bù"], ["dào"], ["dé"]],
    "不得不": [["bù"], ["dé"], ["bù"]],
    "不得不尔": [["bù"], ["dé"], ["bù"], ["ěr"]],
    "不得而知": [["bù"], ["dé"], ["ér"], ["zhī"]],
    "不得劲": [["bù"], ["dé"], ["jìn"]],
    "不得开交": [["bù"], ["dé"], ["kāi"], ["jiāo"]],
    "不得了": [["bù"], ["dé"], ["le"]],
    "不得其死": [["bù"], ["dé"], ["qí"], ["sǐ"]],
    "不得其所": [["bù"], ["dé"], ["qí"], ["suǒ"]],
    "不得人心": [["bù"], ["dé"], ["rén"], ["xīn"]],
    "不得善终": [["bù"], ["dé"], ["shàn"], ["zhōng"]],
    "不得违误": [["bù"], ["dé"], ["wéi"], ["wù"]],
    "不得要领": [["bù"], ["dé"], ["yào"], ["lǐng"]],
    "不得已": [["bù"], ["dé"], ["yǐ"]],
    "不得已而为之": [["bù"], ["dé"], ["yǐ"], ["ér"], ["wéi"], ["zhī"]],
    "不得已而用之": [["bù"], ["dé"], ["yǐ"], ["ér"], ["yòng"], ["zhī"]],
    "不得志": [["bù"], ["dé"], ["zhì"]],
    "不登大雅": [["bù"], ["dēng"], ["dà"], ["yǎ"]],
    "不登大雅之堂": [["bù"], ["dēng"], ["dà"], ["yǎ"], ["zhī"], ["táng"]],
    "不等号": [["bù"], ["děng"], ["hào"]],
    "不等价交换": [["bù"], ["děng"], ["jià"], ["jiāo"], ["huàn"]],
    "不等式": [["bù"], ["děng"], ["shì"]],
    "不点儿": [["bù"], ["diǎn"], ["er"]],
    "不定积分": [["bù"], ["dìng"], ["jī"], ["fēn"]],
    "不懂装懂": [["bù"], ["dǒng"], ["zhuāng"], ["dǒng"]],
    "不动产": [["bù"], ["dòng"], ["chǎn"]],
    "不动声色": [["bù"], ["dòng"], ["shēng"], ["sè"]],
    "不冻港": [["bù"], ["dòng"], ["gǎng"]],
    "不断如带": [["bù"], ["duàn"], ["rú"], ["dài"]],
    "不对茬儿": [["bú"], ["duì"], ["chá"], ["ér"]],
    "不对劲": [["bú"], ["duì"], ["jìn"]],
    "不对头": [["bú"], ["duì"], ["tóu"]],
    "不恶而严": [["bù"], ["è"], ["ér"], ["yán"]],
    "不二法门": [["bù"], ["èr"], ["fǎ"], ["mén"]],
    "不二价": [["bù"], ["èr"], ["jià"]],
    "不乏其人": [["bù"], ["fá"], ["qí"], ["rén"]],
    "不乏先例": [["bù"], ["fá"], ["xiān"], ["lì"]],
    "不法常可": [["bù"], ["fǎ"], ["cháng"], ["kě"]],
    "不法古不修今": [["bù"], ["fǎ"], ["gǔ"], ["bù"], ["xiū"], ["jīn"]],
    "不法之徒": [["bù"], ["fǎ"], ["zhī"], ["tú"]],
    "不方便": [["bù"], ["fāng"], ["biàn"]],
    "不悱不发": [["bù"], ["fěi"], ["bù"], ["fā"]],
    "不废江河": [["bù"], ["fèi"], ["jiāng"], ["hé"]],
    "不费吹灰之力": [["bù"], ["fèi"], ["chuī"], ["huī"], ["zhī"], ["lì"]],
    "不费之惠": [["bù"], ["fèi"], ["zhī"], ["huì"]],
    "不分彼此": [["bù"], ["fēn"], ["bǐ"], ["cǐ"]],
    "不分伯仲": [["bù"], ["fēn"], ["bó"], ["zhòng"]],
    "不分青白": [["bù"], ["fēn"], ["qīng"], ["béi"]],
    "不分青红皂白": [["bù"], ["fēn"], ["qīng"], ["hóng"], ["zào"], ["bái"]],
    "不分轩轾": [["bù"], ["fēn"], ["xuān"], ["zhì"]],
    "不分玉石": [["bù"], ["fēn"], ["yù"], ["shí"]],
    "不分皂白": [["bù"], ["fēn"], ["zào"], ["bái"]],
    "不分畛域": [["bù"], ["fēn"], ["zhěn"], ["yù"]],
    "不愤不启": [["bù"], ["fèn"], ["bù"], ["qǐ"]],
    "不丰不俭": [["bù"], ["fēng"], ["bù"], ["jiǎn"]],
    "不丰不杀": [["bù"], ["fēng"], ["bù"], ["shā"]],
    "不伏烧埋": [["bù"], ["fú"], ["shāo"], ["mái"]],
    "不服气": [["bù"], ["fú"], ["qì"]],
    "不服水土": [["bù"], ["fú"], ["shuǐ"], ["tǔ"]],
    "不负众望": [["bù"], ["fù"], ["zhòng"], ["wàng"]],
    "不复堪命": [["bù"], ["fù"], ["kān"], ["mìng"]],
    "不改其乐": [["bù"], ["gǎi"], ["qí"], ["lè"]],
    "不干不净": [["bù"], ["gān"], ["bù"], ["jìng"]],
    "不甘雌伏": [["bù"], ["gān"], ["cí"], ["fú"]],
    "不甘后人": [["bù"], ["gān"], ["hòu"], ["rén"]],
    "不甘寂寞": [["bù"], ["gān"], ["jì"], ["mò"]],
    "不尴不尬": [["bù"], ["gān"], ["bù"], ["gà"]],
    "不甘示弱": [["bù"], ["gān"], ["shì"], ["ruò"]],
    "不甘心": [["bù"], ["gān"], ["xīn"]],
    "不敢当": [["bù"], ["gǎn"], ["dāng"]],
    "不敢高攀": [["bù"], ["gǎn"], ["gāo"], ["pān"]],
    "不敢苟同": [["bù"], ["gǎn"], ["gǒu"], ["tóng"]],
    "不敢告劳": [["bù"], ["gǎn"], ["gào"], ["láo"]],
    "不敢掠美": [["bù"], ["gǎn"], ["lüè"], ["měi"]],
    "不敢后人": [["bù"], ["gǎn"], ["hòu"], ["rén"]],
    "不敢旁骛": [["bù"], ["gǎn"], ["páng"], ["wù"]],
    "不敢问津": [["bù"], ["gǎn"], ["wèn"], ["jīn"]],
    "不敢越雷池一步": [["bù"], ["gǎn"], ["yuè"], ["léi"], ["chí"], ["yī"], ["bù"]],
    "不敢造次": [["bù"], ["gǎn"], ["zào"], ["cì"]],
    "不敢自专": [["bù"], ["gǎn"], ["zì"], ["zhuān"]],
    "不根之论": [["bù"], ["gēn"], ["zhī"], ["lùn"]],
    "不根之谈": [["bù"], ["gān"], ["zhī"], ["tán"]],
    "不更事": [["bù"], ["gēng"], ["shì"]],
    "不攻自破": [["bù"], ["gōng"], ["zì"], ["pò"]],
    "不共戴天": [["bù"], ["gòng"], ["dài"], ["tiān"]],
    "不苟言笑": [["bù"], ["gǒu"], ["yán"], ["xiào"]],
    "不古不今": [["bù"], ["gǔ"], ["bù"], ["jīn"]],
    "不瞽不聋": [["bù"], ["gǔ"], ["bù"], ["lóng"]],
    "不顾大局": [["bù"], ["gù"], ["dà"], ["jú"]],
    "不顾前后": [["bù"], ["gù"], ["qián"], ["hòu"]],
    "不顾死活": [["bù"], ["gù"], ["sǐ"], ["huó"]],
    "不顾一切": [["bù"], ["gù"], ["yī"], ["qiè"]],
    "不关紧要": [["bù"], ["guān"], ["jǐn"], ["yào"]],
    "不关痛痒": [["bù"], ["guān"], ["tòng"], ["yǎng"]],
    "不管不顾": [["bù"], ["guǎn"], ["bù"], ["gù"]],
    "不管三七二十一": [["bù"], ["guǎn"], ["sān"], ["qī"], ["èr"], ["shí"], ["yī"]],
    "不管一二": [["bù"], ["guǎn"], ["yī"], ["èr"]],
    "不龟手药": [["bù"], ["guī"], ["shǒu"], ["yào"]],
    "不规则": [["bù"], ["guī"], ["zé"]],
    "不轨之徒": [["bù"], ["guǐ"], ["zhī"], ["tú"]],
    "不过尔尔": [["bù"], ["guò"], ["ěr"], ["ěr"]],
    "不过如此": [["bù"], ["guò"], ["rú"], ["cǐ"]],
    "不过意": [["bù"], ["guò"], ["yì"]],
    "不含糊": [["bù"], ["hán"], ["hu"]],
    "不寒而栗": [["bù"], ["hán"], ["ér"], ["lì"]],
    "不好过": [["bù"], ["hǎo"], ["guò"]],
    "不好看": [["bù"], ["hǎo"], ["kàn"]],
    "不好惹": [["bù"], ["hǎo"], ["rě"]],
    "不好意思": [["bù"], ["hǎo"], ["yì"], ["sī"]],
    "不合时宜": [["bù"], ["hé"], ["shí"], ["yí"]],
    "不哼不哈": [["bù"], ["hēng"], ["bù"], ["hā"]],
    "不护细行": [["bù"], ["hù"], ["xì"], ["xíng"]],
    "不怀好意": [["bù"], ["huái"], ["hào"], ["yì"]],
    "不欢而散": [["bù"], ["huān"], ["ér"], ["sàn"]],
    "不慌不忙": [["bù"], ["huāng"], ["bù"], ["máng"]],
    "不遑枚举": [["bù"], ["huáng"], ["méi"], ["jǔ"]],
    "不遑宁处": [["bù"], ["huáng"], ["níng"], ["chǔ"]],
    "不遑宁息": [["bù"], ["huáng"], ["níng"], ["xī"]],
    "不遑启处": [["bù"], ["huáng"], ["qǐ"], ["chǔ"]],
    "不讳之朝": [["bù"], ["huì"], ["zhī"], ["cháo"]],
    "不遑暇食": [["bù"], ["huáng"], ["xiá"], ["shí"]],
    "不讳之路": [["bù"], ["huì"], ["zhī"], ["lù"]],
    "不讳之门": [["bù"], ["huì"], ["zhī"], ["mén"]],
    "不惑之年": [["bù"], ["huò"], ["zhī"], ["nián"]],
    "不饥不寒": [["bù"], ["jī"], ["bù"], ["hán"]],
    "不羁之才": [["bù"], ["jī"], ["zhī"], ["cái"]],
    "不羁之民": [["bù"], ["jī"], ["zhī"], ["mín"]],
    "不及格": [["bù"], ["jí"], ["gé"]],
    "不及之法": [["bù"], ["jí"], ["zhī"], ["fǎ"]],
    "不即不离": [["bù"], ["jí"], ["bù"], ["lí"]],
    "不急之务": [["bù"], ["jí"], ["zhī"], ["wù"]],
    "不计其数": [["bù"], ["jì"], ["qí"], ["shù"]],
    "不疾不徐": [["bù"], ["jí"], ["bù"], ["xú"]],
    "不记前仇": [["bù"], ["jì"], ["qián"], ["chóu"]],
    "不济事": [["bù"], ["jì"], ["shì"]],
    "不假思索": [["bù"], ["jiǎ"], ["sī"], ["suǒ"]],
    "不稼不穑": [["bù"], ["jià"], ["bù"], ["sè"]],
    "不间不界": [["bù"], ["gān"], ["bù"], ["gà"]],
    "不见得": [["bú"], ["jiàn"], ["de"]],
    "不见棺材不落泪": [["bù"], ["jiàn"], ["guān"], ["cái"], ["bù"], ["luò"], ["lèi"]],
    "不见棺材不下泪": [["bù"], ["jiàn"], ["guān"], ["cái"], ["bù"], ["xià"], ["lèi"]],
    "不见经传": [["bù"], ["jiàn"], ["jīng"], ["zhuàn"]],
    "不见天日": [["bù"], ["jiàn"], ["tiān"], ["rì"]],
    "不见舆薪": [["bú"], ["jiàn"], ["yú"], ["xīn"]],
    "不骄不躁": [["bù"], ["jiāo"], ["bù"], ["zào"]],
    "不教而杀": [["bù"], ["jiào"], ["ér"], ["shā"]],
    "不教而诛": [["bù"], ["jiào"], ["ér"], ["zhū"]],
    "不教之教": [["bù"], ["jiào"], ["zhī"], ["jiào"]],
    "不结盟国家": [["bù"], ["jié"], ["méng"], ["guó"], ["jiā"]],
    "不结盟运动": [["bù"], ["jié"], ["méng"], ["yùn"], ["dòng"]],
    "不解之仇": [["bù"], ["jiě"], ["zhī"], ["chóu"]],
    "不解之缘": [["bù"], ["jiě"], ["zhī"], ["yuán"]],
    "不介意": [["bù"], ["jiè"], ["yì"]],
    "不今不古": [["bù"], ["jīn"], ["bù"], ["gǔ"]],
    "不矜不伐": [["bù"], ["jīn"], ["bù"], ["fá"]],
    "不矜细行": [["bù"], ["jīn"], ["xì"], ["xíng"]],
    "不紧不慢": [["bù"], ["jīn"], ["bù"], ["màn"]],
    "不尽然": [["bù"], ["jìn"], ["rán"]],
    "不近道理": [["bù"], ["jìn"], ["dào"], ["lǐ"]],
    "不近人情": [["bù"], ["jìn"], ["rén"], ["qíng"]],
    "不进则退": [["bù"], ["jìn"], ["zé"], ["tuì"]],
    "不禁不由": [["bù"], ["jīn"], ["bù"], ["yóu"]],
    "不经世故": [["bù"], ["jīng"], ["shì"], ["gù"]],
    "不经意": [["bù"], ["jīng"], ["yì"]],
    "不经之说": [["bù"], ["jīng"], ["zhī"], ["shuō"]],
    "不经之谈": [["bù"], ["jīng"], ["zhī"], ["tán"]],
    "不经之语": [["bù"], ["jīng"], ["zhī"], ["yǔ"]],
    "不景气": [["bù"], ["jǐng"], ["qì"]],
    "不胫而走": [["bù"], ["jìng"], ["ér"], ["zǒu"]],
    "不揪不采": [["bù"], ["jiū"], ["bù"], ["cǎi"]],
    "不揪不採": [["bù"], ["jiū"], ["bù"], ["cǎi"]],
    "不揪不睬": [["bù"], ["chǒu"], ["bù"], ["cǎi"]],
    "不咎既往": [["bù"], ["jiù"], ["jì"], ["wǎng"]],
    "不拘细节": [["bù"], ["jū"], ["xì"], ["jié"]],
    "不拘细行": [["bù"], ["jū"], ["xì"], ["xíng"]],
    "不拘小节": [["bù"], ["jū"], ["xiǎo"], ["jié"]],
    "不拘形迹": [["bù"], ["jū"], ["xíng"], ["jī"]],
    "不拘一格": [["bù"], ["jū"], ["yī"], ["gé"]],
    "不绝如带": [["bù"], ["jué"], ["rú"], ["dài"]],
    "不绝如缕": [["bù"], ["jué"], ["rú"], ["lǚ"]],
    "不绝如发": [["bù"], ["jué"], ["rú"], ["fà"]],
    "不绝如线": [["bù"], ["jué"], ["rú"], ["xiàn"]],
    "不绝若线": [["bù"], ["jué"], ["ruò"], ["xiàn"]],
    "不绝于耳": [["bù"], ["jué"], ["yú"], ["ěr"]],
    "不觉技痒": [["bù"], ["jué"], ["jì"], ["yǎng"]],
    "不开眼": [["bù"], ["kāi"], ["yǎn"]],
    "不刊之论": [["bù"], ["kān"], ["zhī"], ["lùn"]],
    "不刊之典": [["bù"], ["kān"], ["zhī"], ["diǎn"]],
    "不刊之书": [["bù"], ["kān"], ["zhī"], ["shū"]],
    "不刊之说": [["bù"], ["kān"], ["zhī"], ["shuō"]],
    "不堪回首": [["bù"], ["kān"], ["huí"], ["shǒu"]],
    "不堪其忧": [["bù"], ["kān"], ["qí"], ["yōu"]],
    "不堪入耳": [["bù"], ["kān"], ["rù"], ["ěr"]],
    "不堪入目": [["bù"], ["kān"], ["rù"], ["mù"]],
    "不堪设想": [["bù"], ["kān"], ["shè"], ["xiǎng"]],
    "不堪一击": [["bù"], ["kān"], ["yī"], ["jī"]],
    "不堪言状": [["bù"], ["kān"], ["yán"], ["zhuàng"]],
    "不堪造就": [["bù"], ["kān"], ["zào"], ["jiù"]],
    "不亢不卑": [["bù"], ["kàng"], ["bù"], ["bēi"]],
    "不看僧面看佛面": [["bù"], ["kàn"], ["sēng"], ["miàn"], ["kàn"], ["fó"], ["miàn"]],
    "不抗不卑": [["bù"], ["kàng"], ["bù"], ["bēi"]],
    "不可动摇": [["bù"], ["kě"], ["dòng"], ["yáo"]],
    "不可端倪": [["bù"], ["kě"], ["duān"], ["ní"]],
    "不可多得": [["bù"], ["kě"], ["duō"], ["dé"]],
    "不可分": [["bù"], ["kě"], ["fēn"]],
    "不可告人": [["bù"], ["kě"], ["gào"], ["rén"]],
    "不可估量": [["bù"], ["kě"], ["gū"], ["liang"]],
    "不可教训": [["bù"], ["kě"], ["jiào"], ["xùn"]],
    "不可究诘": [["bù"], ["kě"], ["jiū"], ["jié"]],
    "不可救疗": [["bù"], ["kě"], ["jiù"], ["liáo"]],
    "不可救药": [["bù"], ["kě"], ["jiù"], ["yào"]],
    "不可开交": [["bù"], ["kě"], ["kāi"], ["jiāo"]],
    "不可抗力": [["bù"], ["kě"], ["kàng"], ["lì"]],
    "不可揆度": [["bù"], ["kě"], ["kuí"], ["duó"]],
    "不可理喻": [["bù"], ["kě"], ["lǐ"], ["yù"]],
    "不可枚举": [["bù"], ["kě"], ["méi"], ["jǔ"]],
    "不可名状": [["bù"], ["kě"], ["míng"], ["zhuàng"]],
    "不可摸捉": [["bù"], ["kě"], ["mō"], ["zhuō"]],
    "不可磨灭": [["bù"], ["kě"], ["mó"], ["miè"]],
    "不可奈何": [["bù"], ["kě"], ["mài"], ["hé"]],
    "不可能事件": [["bù"], ["kě"], ["néng"], ["shì"], ["jiàn"]],
    "不可偏废": [["bù"], ["kě"], ["piān"], ["fèi"]],
    "不可企及": [["bù"], ["kě"], ["qǐ"], ["jí"]],
    "不可胜道": [["bù"], ["kě"], ["shèng"], ["dào"]],
    "不可胜计": [["bù"], ["kě"], ["shèng"], ["jì"]],
    "不可胜纪": [["bù"], ["kě"], ["shèng"], ["jì"]],
    "不可胜记": [["bù"], ["kě"], ["shèng"], ["jì"]],
    "不可胜举": [["bù"], ["kě"], ["shèng"], ["jù"]],
    "不可胜数": [["bù"], ["kě"], ["shèng"], ["shǔ"]],
    "不可胜算": [["bù"], ["kě"], ["shèng"], ["suàn"]],
    "不可胜言": [["bù"], ["kě"], ["shèng"], ["yán"]],
    "不可收拾": [["bù"], ["kě"], ["shōu"], ["shí"]],
    "不可思议": [["bù"], ["kě"], ["sī"], ["yì"]],
    "不可同日而语": [["bù"], ["kě"], ["tóng"], ["rì"], ["ér"], ["yǔ"]],
    "不可限量": [["bù"], ["kě"], ["xiàn"], ["liàng"]],
    "不可乡迩": [["bù"], ["kě"], ["xiāng"], ["ěr"]],
    "不可向迩": [["bù"], ["kě"], ["xiàng"], ["ěr"]],
    "不可言传": [["bù"], ["kě"], ["yán"], ["chuán"]],
    "不可言宣": [["bù"], ["kě"], ["yán"], ["xuān"]],
    "不可言喻": [["bù"], ["kě"], ["yán"], ["yù"]],
    "不可言状": [["bù"], ["kě"], ["yán"], ["zhuàng"]],
    "不可一世": [["bù"], ["kě"], ["yī"], ["shì"]],
    "不可逾越": [["bù"], ["kě"], ["yú"], ["yuè"]],
    "不可造次": [["bù"], ["kě"], ["zào"], ["cì"]],
    "不可知论": [["bù"], ["kě"], ["zhī"], ["lùn"]],
    "不可终日": [["bù"], ["kě"], ["zhōng"], ["rì"]],
    "不可捉摸": [["bù"], ["kě"], ["zhuō"], ["mō"]],
    "不媿下学": [["bù"], ["kuì"], ["xià"], ["xué"]],
    "不愧不作": [["bù"], ["kuì"], ["bù"], ["zuò"]],
    "不愧不怍": [["bù"], ["kuì"], ["bù"], ["zuò"]],
    "不愧屋漏": [["bù"], ["kuì"], ["wū"], ["lòu"]],
    "不愧下学": [["bù"], ["kuì"], ["xià"], ["xué"]],
    "不来梅": [["bù"], ["lái"], ["méi"]],
    "不稂不莠": [["bù"], ["láng"], ["bù"], ["yǒu"]],
    "不郎不秀": [["bù"], ["láng"], ["bù"], ["xiù"]],
    "不劳而成": [["bù"], ["láo"], ["ér"], ["chéng"]],
    "不劳而获": [["bù"], ["láo"], ["ér"], ["huò"]],
    "不冷不热": [["bù"], ["lěng"], ["bù"], ["rè"]],
    "不老少": [["bù"], ["lǎo"], ["shào"]],
    "不立文字": [["bù"], ["lì"], ["wén"], ["zì"]],
    "不凉不酸": [["bù"], ["liáng"], ["bù"], ["suān"]],
    "不了不当": [["bù"], ["liǎo"], ["bù"], ["dàng"]],
    "不了而了": [["bù"], ["liǎo"], ["ér"], ["liǎo"]],
    "不了了之": [["bù"], ["liǎo"], ["liǎo"], ["zhī"]],
    "不劣方头": [["bù"], ["liè"], ["fāng"], ["tóu"]],
    "不磷不缁": [["bù"], ["lín"], ["bù"], ["zī"]],
    "不吝赐教": [["bù"], ["lìn"], ["cì"], ["jiào"]],
    "不吝指教": [["bù"], ["lìn"], ["zhǐ"], ["jiào"]],
    "不吝珠玉": [["bù"], ["lìn"], ["zhū"], ["yù"]],
    "不留余地": [["bù"], ["liú"], ["yú"], ["dì"]],
    "不露锋芒": [["bù"], ["lù"], ["fēng"], ["máng"]],
    "不露锋铓": [["bù"], ["lù"], ["fēng"], ["huì"]],
    "不露圭角": [["bù"], ["lù"], ["guī"], ["jiǎo"]],
    "不露神色": [["bù"], ["lù"], ["shén"], ["sè"]],
    "不露声色": [["bù"], ["lù"], ["shēng"], ["sè"]],
    "不露形色": [["bù"], ["lù"], ["xíng"], ["sè"]],
    "不伦不类": [["bù"], ["lún"], ["bù"], ["lèi"]],
    "不落边际": [["bù"], ["luò"], ["biān"], ["jì"]],
    "不落窠臼": [["bù"], ["luò"], ["kē"], ["jiù"]],
    "不落俗套": [["bù"], ["luò"], ["sú"], ["tào"]],
    "不蔓不支": [["bù"], ["màn"], ["bù"], ["zhī"]],
    "不蔓不枝": [["bù"], ["màn"], ["bù"], ["zhī"]],
    "不忙不暴": [["bù"], ["máng"], ["bù"], ["bào"]],
    "不毛之地": [["bù"], ["máo"], ["zhī"], ["dì"]],
    "不名一钱": [["bù"], ["míng"], ["yī"], ["qián"]],
    "不名一格": [["bù"], ["míng"], ["yī"], ["gé"]],
    "不名一文": [["bù"], ["míng"], ["yī"], ["wén"]],
    "不名誉": [["bù"], ["míng"], ["yù"]],
    "不明不白": [["bù"], ["míng"], ["bù"], ["bái"]],
    "不摸头": [["bù"], ["mō"], ["tóu"]],
    "不谋而同": [["bù"], ["móu"], ["ér"], ["tóng"]],
    "不谋而合": [["bù"], ["móu"], ["ér"], ["hé"]],
    "不谋同辞": [["bù"], ["móu"], ["tóng"], ["cí"]],
    "不牧之地": [["bù"], ["mù"], ["zhī"], ["dì"]],
    "不耐烦": [["bù"], ["nài"], ["fán"]],
    "不奈之何": [["bù"], ["nai"], ["zhī"], ["hé"]],
    "不挠不屈": [["bù"], ["náo"], ["bù"], ["qū"]],
    "不挠不折": [["bù"], ["náo"], ["bù"], ["zhé"]],
    "不能不": [["bù"], ["néng"], ["bù"]],
    "不能登大雅之堂": [["bù"], ["néng"], ["dēng"], ["dà"], ["yǎ"], ["zhī"], ["táng"]],
    "不能赞一词": [["bù"], ["néng"], ["zàn"], ["yī"], ["cí"]],
    "不能赞一辞": [["bù"], ["néng"], ["zàn"], ["yī"], ["cí"]],
    "不能自拔": [["bù"], ["néng"], ["zì"], ["bá"]],
    "不念旧恶": [["bù"], ["niàn"], ["jiù"], ["è"]],
    "不能自已": [["bù"], ["néng"], ["zì"], ["yǐ"]],
    "不宁唯是": [["bù"], ["níng"], ["wéi"], ["shì"]],
    "不念僧面念佛面": [["bù"], ["niàn"], ["sēng"], ["miàn"], ["niàn"], ["fó"], ["miàn"]],
    "不偏不党": [["bù"], ["piān"], ["bù"], ["dǎng"]],
    "不偏不倚": [["bù"], ["piān"], ["bù"], ["yǐ"]],
    "不平等条约": [["bù"], ["píng"], ["děng"], ["tiáo"], ["yuē"]],
    "不平则鸣": [["bù"], ["píng"], ["zé"], ["míng"]],
    "不期而会": [["bù"], ["qī"], ["ér"], ["huì"]],
    "不破不立": [["bù"], ["può"], ["bù"], ["lì"]],
    "不期而然": [["bù"], ["qī"], ["ér"], ["rán"]],
    "不期而同": [["bù"], ["qī"], ["ér"], ["tóng"]],
    "不期而遇": [["bù"], ["qī"], ["ér"], ["yù"]],
    "不期然而然": [["bù"], ["qī"], ["rán"], ["ér"], ["rán"]],
    "不期修古": [["bù"], ["qī"], ["xiū"], ["gǔ"]],
    "不欺闇室": [["bù"], ["qī"], ["àn"], ["shì"]],
    "不欺暗室": [["bù"], ["qī"], ["àn"], ["shì"]],
    "不欺屋漏": [["bù"], ["qī"], ["wū"], ["lòu"]],
    "不起眼": [["bù"], ["qǐ"], ["yǎn"]],
    "不起诉": [["bù"], ["qǐ"], ["sù"]],
    "不弃草昧": [["bù"], ["qì"], ["cǎo"], ["mèi"]],
    "不迁之庙": [["bù"], ["qiān"], ["zhī"], ["miào"]],
    "不勤而获": [["bù"], ["qín"], ["ér"], ["huò"]],
    "不切实际": [["bù"], ["qiē"], ["shí"], ["jì"]],
    "不擒二毛": [["bù"], ["qín"], ["èr"], ["máo"]],
    "不轻然诺": [["bù"], ["qīng"], ["rán"], ["nuò"]],
    "不情之请": [["bù"], ["qíng"], ["zhī"], ["qǐng"]],
    "不求甚解": [["bù"], ["qiú"], ["shèn"], ["jiě"]],
    "不求闻达": [["bù"], ["qiú"], ["wén"], ["dá"]],
    "不屈不挠": [["bù"], ["qū"], ["bù"], ["náo"]],
    "不染一尘": [["bù"], ["rǎn"], ["yī"], ["chén"]],
    "不忍卒读": [["bù"], ["rěn"], ["zú"], ["dú"]],
    "不人道": [["bù"], ["rén"], ["dào"]],
    "不日不月": [["bù"], ["rì"], ["bù"], ["yuè"]],
    "不容分说": [["bù"], ["róng"], ["fēn"], ["shuō"]],
    "不容置辩": [["bù"], ["róng"], ["zhì"], ["biàn"]],
    "不容置喙": [["bù"], ["róng"], ["zhì"], ["huì"]],
    "不容置疑": [["bù"], ["róng"], ["zhì"], ["yí"]],
    "不如归去": [["bù"], ["rú"], ["guī"], ["qù"]],
    "不如意": [["bù"], ["rú"], ["yì"]],
    "不辱使命": [["bù"], ["rǔ"], ["shǐ"], ["mìng"]],
    "不入时宜": [["bù"], ["rù"], ["shí"], ["yí"]],
    "不三不四": [["bù"], ["sān"], ["bù"], ["sì"]],
    "不僧不俗": [["bù"], ["sēng"], ["bù"], ["sú"]],
    "不衫不履": [["bù"], ["shān"], ["bù"], ["lǚ"]],
    "不伤脾胃": [["bù"], ["shāng"], ["pí"], ["wèi"]],
    "不赏之功": [["bù"], ["shǎng"], ["zhī"], ["gōng"]],
    "不上不落": [["bù"], ["shàng"], ["bù"], ["luò"]],
    "不上不下": [["bù"], ["shàng"], ["bù"], ["xià"]],
    "不舍昼夜": [["bù"], ["shě"], ["zhòu"], ["yè"]],
    "不甚了了": [["bù"], ["shèn"], ["liǎo"], ["liǎo"]],
    "不生不灭": [["bù"], ["shēng"], ["bù"], ["miè"]],
    "不声不吭": [["bù"], ["shēng"], ["bù"], ["kēng"]],
    "不声不响": [["bù"], ["shēng"], ["bù"], ["xiǎng"]],
    "不声不气": [["bù"], ["shēng"], ["bù"], ["qì"]],
    "不胜杯杓": [["bù"], ["shèng"], ["bēi"], ["sháo"]],
    "不胜桮杓": [["bù"], ["shèng"], ["bēi"], ["sháo"]],
    "不胜枚举": [["bù"], ["shèng"], ["méi"], ["jǔ"]],
    "不胜其烦": [["bù"], ["shèng"], ["qí"], ["fán"]],
    "不胜其苦": [["bù"], ["shèng"], ["qí"], ["kǔ"]],
    "不胜其任": [["bù"], ["shèng"], ["qí"], ["rèn"]],
    "不省人事": [["bù"], ["xǐng"], ["rén"], ["shì"]],
    "不失圭撮": [["bù"], ["shī"], ["guī"], ["cuō"]],
    "不失毫厘": [["bù"], ["shī"], ["háo"], ["lí"]],
    "不失时机": [["bù"], ["shī"], ["shí"], ["jī"]],
    "不失黍絫": [["bù"], ["shī"], ["shǔ"], ["lěi"]],
    "不时之须": [["bù"], ["shí"], ["zhī"], ["xū"]],
    "不时之需": [["bù"], ["shí"], ["zhī"], ["xū"]],
    "不识不知": [["bù"], ["shí"], ["bù"], ["zhī"]],
    "不识大体": [["bù"], ["shí"], ["dà"], ["tǐ"]],
    "不识东家": [["bù"], ["shí"], ["dōng"], ["jiā"]],
    "不识高低": [["bù"], ["shí"], ["gāo"], ["dī"]],
    "不识好歹": [["bù"], ["shí"], ["hǎo"], ["dǎi"]],
    "不识局面": [["bù"], ["shí"], ["jú"], ["miàn"]],
    "不识庐山真面目": [["bù"], ["shí"], ["lú"], ["shān"], ["zhēn"], ["miàn"], ["mù"]],
    "不识马肝": [["bù"], ["shí"], ["mǎ"], ["gān"]],
    "不识起倒": [["bù"], ["shí"], ["qǐ"], ["dǎo"]],
    "不识人间有羞耻事": [["bù"], ["shí"], ["rén"], ["jiān"], ["yǒu"], ["xiū"], ["chǐ"], ["shì"]],
    "不识时务": [["bù"], ["shí"], ["shí"], ["wù"]],
    "不识抬举": [["bù"], ["shí"], ["tái"], ["jǔ"]],
    "不识泰山": [["bù"], ["shí"], ["tài"], ["shān"]],
    "不识一丁": [["bù"], ["shí"], ["yī"], ["dīng"]],
    "不识之无": [["bù"], ["shí"], ["zhī"], ["wú"]],
    "不实之词": [["bù"], ["shí"], ["zhī"], ["cí"]],
    "不食马肝": [["bù"], ["shí"], ["mǎ"], ["gān"]],
    "不食烟火": [["bù"], ["shí"], ["yān"], ["huǒ"]],
    "不食之地": [["bù"], ["shí"], ["zhī"], ["dì"]],
    "不世之功": [["bù"], ["shì"], ["zhī"], ["gōng"]],
    "不世之业": [["bù"], ["shì"], ["zhī"], ["yè"]],
    "不食周粟": [["bù"], ["shí"], ["zhōu"], ["sù"]],
    "不事边幅": [["bù"], ["shì"], ["biān"], ["fú"]],
    "不是味儿": [["bú"], ["shì"], ["wèi"], ["ér"]],
    "不是冤家不聚头": [["bù"], ["shì"], ["yuān"], ["jiā"], ["bù"], ["jù"], ["tóu"]],
    "不受欢迎的人": [["bù"], ["shòu"], ["huān"], ["yíng"], ["de"], ["rén"]],
    "不爽累黍": [["bù"], ["shuǎng"], ["lèi"], ["shǔ"]],
    "不爽毫发": [["bù"], ["shuǎng"], ["háo"], ["fā"]],
    "不死不活": [["bù"], ["sǐ"], ["bù"], ["huó"]],
    "不速之客": [["bù"], ["sù"], ["zhī"], ["kè"]],
    "不随以止": [["bu"], ["shui"], ["yi"], ["zi"]],
    "不贪为宝": [["bù"], ["tān"], ["wé"], ["bǎo"]],
    "不腆之仪": [["bù"], ["tiǎn"], ["zhī"], ["yí"]],
    "不挑之祖": [["bù"], ["tiāo"], ["zhī"], ["zǔ"]],
    "不祧之宗": [["bù"], ["tiāo"], ["zhī"], ["zōng"]],
    "不祧之祖": [["bù"], ["tiāo"], ["zhī"], ["zǔ"]],
    "不通水火": [["bù"], ["tōng"], ["shuǐ"], ["huǒ"]],
    "不同戴天": [["bù"], ["tóng"], ["dài"], ["tiān"]],
    "不同凡响": [["bù"], ["tóng"], ["fán"], ["xiǎng"]],
    "不同流俗": [["bù"], ["tóng"], ["liú"], ["sú"]],
    "不痛不痒": [["bù"], ["tòng"], ["bù"], ["yǎng"]],
    "不吐不茹": [["bù"], ["tǔ"], ["bù"], ["rú"]],
    "不忘故旧": [["bù"], ["wàng"], ["gù"], ["jiù"]],
    "不忘沟壑": [["bù"], ["wàng"], ["gōu"], ["hè"]],
    "不为五斗米折腰": [["bù"], ["wèi"], ["wǔ"], ["dǒu"], ["mǐ"], ["zhé"], ["yāo"]],
    "不为已甚": [["bù"], ["wéi"], ["yǐ"], ["shèn"]],
    "不违农时": [["bù"], ["wéi"], ["nóng"], ["shí"]],
    "不瘟不火": [["bù"], ["wēn"], ["bù"], ["huǒ"]],
    "不文不武": [["bù"], ["wén"], ["bù"], ["wǔ"]],
    "不闻不问": [["bù"], ["wén"], ["bù"], ["wèn"]],
    "不问不闻": [["bù"], ["wèn"], ["bù"], ["wén"]],
    "不问青红皂白": [["bù"], ["wèn"], ["qīng"], ["hóng"], ["zào"], ["bái"]],
    "不问皂白": [["bù"], ["wèn"], ["zào"], ["bái"]],
    "不猧不魀": [["bù"], ["wō"], ["bù"], ["gà"]],
    "不无小补": [["bù"], ["wú"], ["xiǎo"], ["bǔ"]],
    "不舞之鹤": [["bù"], ["wǔ"], ["zhī"], ["hè"]],
    "不务空名": [["bù"], ["wù"], ["kōng"], ["míng"]],
    "不务正业": [["bù"], ["wù"], ["zhèng"], ["yè"]],
    "不惜工本": [["bù"], ["xī"], ["gōng"], ["běn"]],
    "不习地土": [["bù"], ["xí"], ["dì"], ["tǔ"]],
    "不习水土": [["bù"], ["xí"], ["shuǐ"], ["tǔ"]],
    "不習水土": [["bù"], ["xí"], ["shuǐ"], ["tǔ"]],
    "不下于": [["bù"], ["xià"], ["yú"]],
    "不咸不淡": [["bù"], ["xián"], ["bù"], ["dàn"]],
    "不相称": [["bù"], ["xiāng"], ["chèn"]],
    "不相干": [["bù"], ["xiāng"], ["gān"]],
    "不相上下": [["bù"], ["xiāng"], ["shàng"], ["xià"]],
    "不相为谋": [["bù"], ["xiāng"], ["wéi"], ["móu"]],
    "不相闻问": [["bù"], ["xiāng"], ["wén"], ["wèn"]],
    "不相问闻": [["bù"], ["xiāng"], ["wèn"], ["wén"]],
    "不祥之兆": [["bù"], ["xiáng"], ["zhī"], ["zhào"]],
    "不象话": [["bù"], ["xiàng"], ["huà"]],
    "不像话": [["bù"], ["xiàng"], ["huà"]],
    "不消说": [["bù"], ["xiāo"], ["shuō"]],
    "不晓世务": [["bù"], ["xiǎo"], ["shì"], ["wù"]],
    "不肖子孙": [["bù"], ["xiào"], ["zǐ"], ["sūn"]],
    "不屑毁誉": [["bù"], ["xiè"], ["huǐ"], ["yù"]],
    "不屑教诲": [["bù"], ["xiè"], ["jiào"], ["huì"]],
    "不屑一顾": [["bù"], ["xiè"], ["yī"], ["gù"]],
    "不幸而言中": [["bù"], ["xìng"], ["ér"], ["yán"], ["zhòng"]],
    "不修边幅": [["bù"], ["xiū"], ["biān"], ["fú"]],
    "不羞当面": [["bù"], ["xiū"], ["dāng"], ["miàn"]],
    "不修小节": [["bù"], ["xiū"], ["xiǎo"], ["jié"]],
    "不锈钢": [["bù"], ["xiù"], ["gāng"]],
    "不脩边幅": [["bù"], ["xiū"], ["biān"], ["fú"]],
    "不虚此行": [["bù"], ["xū"], ["cǐ"], ["xíng"]],
    "不徐不疾": [["bù"], ["xú"], ["bù"], ["jí"]],
    "不恤人言": [["bù"], ["xù"], ["rén"], ["yán"]],
    "不宣而战": [["bù"], ["xuān"], ["ér"], ["zhàn"]],
    "不学无识": [["bù"], ["xué"], ["wú"], ["shí"]],
    "不旋踵": [["bù"], ["xuán"], ["zhǒng"]],
    "不学无术": [["bù"], ["xué"], ["wú"], ["shù"]],
    "不徇私情": [["bù"], ["xún"], ["sī"], ["qíng"]],
    "不言而信": [["bù"], ["yán"], ["ér"], ["xìn"]],
    "不言不语": [["bù"], ["yán"], ["bù"], ["yǔ"]],
    "不言而谕": [["bù"], ["yán"], ["ér"], ["yù"]],
    "不言而喻": [["bù"], ["yán"], ["ér"], ["yù"]],
    "不厌其烦": [["bù"], ["yàn"], ["qí"], ["fán"]],
    "不厌其繁": [["bù"], ["yàn"], ["qí"], ["fán"]],
    "不厌其详": [["bù"], ["yàn"], ["qí"], ["xiáng"]],
    "不要紧": [["bú"], ["yào"], ["jǐn"]],
    "不药而愈": [["bù"], ["yào"], ["ér"], ["yù"]],
    "不要脸": [["bú"], ["yào"], ["liǎn"]],
    "不夜城": [["bù"], ["yè"], ["chéng"]],
    "不一定": [["bù"], ["yí"], ["dìng"]],
    "不一而足": [["bù"], ["yī"], ["ér"], ["zú"]],
    "不一会儿": [["bù"], ["yī"], ["huì"], ["er"]],
    "不依不饶": [["bù"], ["yī"], ["bù"], ["ráo"]],
    "不壹而三": [["bù"], ["yī"], ["ér"], ["sān"]],
    "不壹而足": [["bù"], ["yī"], ["ér"], ["zú"]],
    "不夷不惠": [["bù"], ["yí"], ["bù"], ["huì"]],
    "不遗巨细": [["bù"], ["yí"], ["jù"], ["xì"]],
    "不遗寸长": [["bù"], ["yí"], ["cùn"], ["cháng"]],
    "不遗余力": [["bù"], ["yí"], ["yú"], ["lì"]],
    "不以辞害志": [["bù"], ["yǐ"], ["cí"], ["hài"], ["zhì"]],
    "不以人废言": [["bù"], ["yǐ"], ["rén"], ["fèi"], ["yán"]],
    "不以为耻": [["bù"], ["yǐ"], ["wéi"], ["chǐ"]],
    "不以为奇": [["bù"], ["yǐ"], ["wéi"], ["qí"]],
    "不以为意": [["bù"], ["yǐ"], ["wéi"], ["yì"]],
    "不以一眚掩大德": [["bù"], ["yǐ"], ["yī"], ["shěng"], ["yǎn"], ["dà"], ["dé"]],
    "不以为然": [["bù"], ["yǐ"], ["wéi"], ["rán"]],
    "不义之财": [["bù"], ["yì"], ["zhī"], ["cái"]],
    "不亦乐乎": [["bù"], ["yì"], ["lè"], ["hū"]],
    "不亦善夫": [["bù"], ["yi"], ["shàn"], ["fū"]],
    "不易一字": [["bù"], ["yì"], ["yī"], ["zì"]],
    "不易之典": [["bù"], ["yì"], ["zhī"], ["diǎn"]],
    "不易之论": [["bù"], ["yì"], ["zhī"], ["lùn"]],
    "不翼而飞": [["bù"], ["yì"], ["ér"], ["fēi"]],
    "不因不由": [["bù"], ["yīn"], ["bù"], ["yóu"]],
    "不因人热": [["bù"], ["yīn"], ["rén"], ["rè"]],
    "不阴不阳": [["bù"], ["yīn"], ["bù"], ["yáng"]],
    "不饮盗泉": [["bù"], ["yǐn"], ["dào"], ["quán"]],
    "不由得": [["bù"], ["yóu"], ["de"]],
    "不由分说": [["bù"], ["yóu"], ["fēn"], ["shuō"]],
    "不由自主": [["bù"], ["yóu"], ["zì"], ["zhǔ"]],
    "不虞之誉": [["bù"], ["yú"], ["zhī"], ["yù"]],
    "不远万里": [["bù"], ["yuǎn"], ["wàn"], ["lǐ"]],
    "不远千里": [["bù"], ["yuǎn"], ["qiān"], ["lǐ"]],
    "不约而同": [["bù"], ["yuē"], ["ér"], ["tóng"]],
    "不越雷池": [["bù"], ["yuè"], ["léi"], ["shi"]],
    "不在乎": [["bù"], ["zài"], ["hu"]],
    "不在话下": [["bù"], ["zài"], ["huà"], ["xià"]],
    "不在意": [["bù"], ["zài"], ["yì"]],
    "不赞一词": [["bù"], ["zàn"], ["yī"], ["cí"]],
    "不择生冷": [["bù"], ["zé"], ["shēng"], ["lěng"]],
    "不择手段": [["bù"], ["zé"], ["shǒu"], ["duàn"]],
    "不怎么样": [["bù"], ["zěn"], ["me"], ["yàng"]],
    "不粘锅": [["bù"], ["nián"], ["guō"]],
    "不折不扣": [["bù"], ["zhé"], ["bù"], ["kòu"]],
    "不争气": [["bù"], ["zhēng"], ["qì"]],
    "不正当竞争": [["bù"], ["zhèng"], ["dāng"], ["jìng"], ["zhēng"]],
    "不正之风": [["bù"], ["zhèng"], ["zhī"], ["fēng"]],
    "不知不觉": [["bù"], ["zhī"], ["bù"], ["jué"]],
    "不知颠倒": [["bù"], ["zhī"], ["diān"], ["dǎo"]],
    "不知丁董": [["bù"], ["zhī"], ["dīng"], ["dǒng"]],
    "不知薡蕫": [["bù"], ["zhī"], ["dīng"], ["dǒng"]],
    "不知端倪": [["bù"], ["zhī"], ["duān"], ["ní"]],
    "不知凡几": [["bù"], ["zhī"], ["fán"], ["jǐ"]],
    "不知甘苦": [["bù"], ["zhī"], ["gān"], ["kǔ"]],
    "不知高低": [["bù"], ["zhī"], ["gāo"], ["dī"]],
    "不知高下": [["bù"], ["zhī"], ["gāo"], ["xià"]],
    "不知好歹": [["bù"], ["zhī"], ["hǎo"], ["dǎi"]],
    "不知纪极": [["bù"], ["zhī"], ["jì"], ["jí"]],
    "不知进退": [["bù"], ["zhī"], ["jìn"], ["tuì"]],
    "不知就里": [["bù"], ["zhī"], ["jiù"], ["lǐ"]],
    "不知老之将至": [["bù"], ["zhī"], ["lǎo"], ["zhī"], ["jiāng"], ["zhì"]],
    "不知利害": [["bù"], ["zhī"], ["lì"], ["hài"]],
    "不知起倒": [["bù"], ["zhī"], ["qǐ"], ["dǎo"]],
    "不知寝食": [["bù"], ["zhī"], ["qǐn"], ["shí"]],
    "不知轻重": [["bù"], ["zhī"], ["qīng"], ["zhòng"]],
    "不知去向": [["bù"], ["zhī"], ["qù"], ["xiàng"]],
    "不知人间有羞耻事": [["bù"], ["zhī"], ["rén"], ["jiān"], ["yǒu"], ["xiū"], ["chǐ"], ["shì"]],
    "不知肉味": [["bù"], ["zhī"], ["ròu"], ["wèi"]],
    "不知深浅": [["bù"], ["zhī"], ["shēn"], ["qiǎn"]],
    "不知世务": [["bù"], ["zhī"], ["shì"], ["wù"]],
    "不知死活": [["bù"], ["zhī"], ["sǐ"], ["huó"]],
    "不知所出": [["bù"], ["zhī"], ["suǒ"], ["chū"]],
    "不知所厝": [["bù"], ["zhī"], ["suǒ"], ["cuò"]],
    "不知所措": [["bù"], ["zhī"], ["suǒ"], ["cuò"]],
    "不知所错": [["bù"], ["zhī"], ["suǒ"], ["cuò"]],
    "不知所可": [["bù"], ["zhī"], ["suǒ"], ["kě"]],
    "不知所言": [["bù"], ["zhī"], ["suǒ"], ["yán"]],
    "不知所以": [["bù"], ["zhī"], ["suǒ"], ["yǐ"]],
    "不知所云": [["bù"], ["zhī"], ["suǒ"], ["yún"]],
    "不知疼痒": [["bù"], ["zhī"], ["téng"], ["yǎng"]],
    "不知所终": [["bù"], ["zhī"], ["suǒ"], ["zhōng"]],
    "不知天高地厚": [["bù"], ["zhī"], ["tiān"], ["gāo"], ["dì"], ["hòu"]],
    "不知头脑": [["bù"], ["zhī"], ["tóu"], ["nǎo"]],
    "不知痛痒": [["bù"], ["zhī"], ["tòng"], ["yǎng"]],
    "不知者不罪": [["bù"], ["zhī"], ["zhě"], ["bù"], ["zuì"]],
    "不知自量": [["bù"], ["zhī"], ["zì"], ["liàng"]],
    "不知自爱": [["bù"], ["zhī"], ["zì"], ["ài"]],
    "不直一钱": [["bù"], ["zhí"], ["yī"], ["qián"]],
    "不直一文": [["bù"], ["zhí"], ["yī"], ["wén"]],
    "不值一驳": [["bù"], ["zhí"], ["yī"], ["bó"]],
    "不值一顾": [["bù"], ["zhí"], ["yī"], ["gù"]],
    "不值一钱": [["bù"], ["zhí"], ["yī"], ["qián"]],
    "不值一哂": [["bù"], ["zhí"], ["yī"], ["shěn"]],
    "不值一笑": [["bù"], ["zhí"], ["yī"], ["xiào"]],
    "不至于": [["bù"], ["zhì"], ["yú"]],
    "不忮不求": [["bù"], ["zhì"], ["bù"], ["qiú"]],
    "不栉进士": [["bù"], ["zhì"], ["jìn"], ["shì"]],
    "不治之症": [["bù"], ["zhì"], ["zhī"], ["zhèng"]],
    "不置褒贬": [["bù"], ["zhì"], ["bāo"], ["biǎn"]],
    "不置可否": [["bù"], ["zhì"], ["kě"], ["fǒu"]],
    "不中用": [["bù"], ["zhōng"], ["yòng"]],
    "不周延": [["bù"], ["zhōu"], ["yán"]],
    "不主故常": [["bù"], ["zhǔ"], ["gù"], ["cháng"]],
    "不追既往": [["bù"], ["zhuī"], ["jì"], ["wǎng"]],
    "不着边际": [["bù"], ["zhuó"], ["biān"], ["jì"]],
    "不着疼热": [["bù"], ["zhuó"], ["téng"], ["rè"]],
    "不自量": [["bù"], ["zì"], ["liàng"]],
    "不自量力": [["bù"], ["zì"], ["liàng"], ["lì"]],
    "不自满假": [["bù"], ["zì"], ["mǎn"], ["jiǎ"]],
    "不自在": [["bù"], ["zì"], ["zài"]],
    "不足齿数": [["bù"], ["zú"], ["chǐ"], ["shǔ"]],
    "不足道": [["bù"], ["zú"], ["dào"]],
    "不足挂齿": [["bù"], ["zú"], ["guà"], ["chǐ"]],
    "不足介意": [["bù"], ["zú"], ["jiè"], ["yì"]],
    "不足轻重": [["bù"], ["zú"], ["qīng"], ["zhòng"]],
    "不足为法": [["bù"], ["zú"], ["wéi"], ["fǎ"]],
    "不足取": [["bù"], ["zú"], ["qǔ"]],
    "不足为凭": [["bù"], ["zú"], ["wéi"], ["píng"]],
    "不足为据": [["bù"], ["zú"], ["wéi"], ["jù"]],
    "不足为奇": [["bù"], ["zú"], ["wéi"], ["qí"]],
    "不足为训": [["bù"], ["zú"], ["wéi"], ["xùn"]],
    "不足为外人道": [["bù"], ["zú"], ["wéi"], ["wài"], ["rén"], ["dào"]],
    "不足为意": [["bù"], ["zú"], ["wéi"], ["yì"]],
    "不作声": [["bù"], ["zuò"], ["shēng"]],
    "不做声": [["bù"], ["zuò"], ["shēng"]],
    "不做不休": [["bù"], ["zuò"], ["bù"], ["xiū"]],
    "布被瓦器": [["bù"], ["bèi"], ["wǎ"], ["qì"]],
    "布达拉宫": [["bù"], ["dá"], ["lā"], ["gōng"]],
    "布尔什维克": [["bù"], ["ěr"], ["shí"], ["wéi"], ["kè"]],
    "布拉柴维尔": [["bù"], ["lā"], ["chái"], ["wéi"], ["ěr"]],
    "布拉格": [["bù"], ["lā"], ["gé"]],
    "布拉吉": [["bù"], ["lā"], ["jí"]],
    "布鲁塞尔": [["bù"], ["lǔ"], ["sài"], ["ěr"]],
    "布琼布拉": [["bù"], ["qióng"], ["bù"], ["lā"]],
    "布天盖地": [["bù"], ["tiān"], ["gài"], ["dì"]],
    "布衣粝食": [["bù"], ["yī"], ["lì"], ["shí"]],
    "布衣蔬食": [["bù"], ["yī"], ["shū"], ["shí"]],
    "步步为营": [["bù"], ["bù"], ["wéi"], ["yíng"]],
    "步调一致": [["bù"], ["diào"], ["yī"], ["zhì"]],
    "步罡踏斗": [["bù"], ["gāng"], ["tà"], ["dǒu"]],
    "步斗踏罡": [["bù"], ["dǒu"], ["tà"], ["gāng"]],
    "步线行针": [["bù"], ["xiàn"], ["xíng"], ["zhēn"]],
    "擦拳磨掌": [["cā"], ["quán"], ["mó"], ["zhǎng"]],
    "擦拳抹掌": [["cā"], ["quán"], ["mò"], ["zhǎng"]],
    "擦掌磨拳": [["cā"], ["zhǎng"], ["mó"], ["quán"]],
    "擦脂抹粉": [["cā"], ["zhī"], ["mǒ"], ["fěn"]],
    "猜拳行令": [["cāi"], ["quán"], ["xíng"], ["lìng"]],
    "猜枚行令": [["cāi"], ["méi"], ["xíng"], ["lìng"]],
    "才蔽识浅": [["cái"], ["bì"], ["shí"], ["qiǎn"]],
    "才薄智浅": [["cāi"], ["bó"], ["zhì"], ["qiǎn"]],
    "才大难用": [["cái"], ["dà"], ["nán"], ["yòng"]],
    "才大如海": [["cái"], ["dà"], ["rú"], ["hǎi"]],
    "才短思涩": [["cái"], ["duǎn"], ["sī"], ["sè"]],
    "才多识寡": [["cái"], ["duō"], ["shí"], ["guǎ"]],
    "才高识远": [["cái"], ["gāo"], ["shí"], ["yuǎn"]],
    "才高八斗": [["cái"], ["gāo"], ["bā"], ["dǒu"]],
    "才高行洁": [["cái"], ["gāo"], ["xíng"], ["jié"]],
    "才高行厚": [["cái"], ["gāo"], ["xíng"], ["hòu"]],
    "才高意广": [["cái"], ["gāo"], ["yì"], ["guǎng"]],
    "才广妨身": [["cái"], ["guǎng"], ["fáng"], ["shēn"]],
    "才过屈宋": [["cái"], ["guò"], ["qū"], ["sòng"]],
    "才华超众": [["cái"], ["huá"], ["chāo"], ["zhòng"]],
    "才华横溢": [["cái"], ["huá"], ["héng"], ["yì"]],
    "才华盖世": [["cái"], ["huá"], ["gài"], ["shì"]],
    "才气过人": [["cái"], ["qì"], ["guò"], ["rén"]],
    "才轻德薄": [["cái"], ["qīng"], ["dé"], ["bó"]],
    "才夸八斗": [["cái"], ["kuā"], ["bā"], ["dǒu"]],
    "才识过人": [["cái"], ["shí"], ["guò"], ["rén"]],
    "才疏德薄": [["cái"], ["shū"], ["dé"], ["bó"]],
    "才疏学浅": [["cái"], ["shū"], ["xué"], ["qiǎn"]],
    "才疏意广": [["cái"], ["shū"], ["yì"], ["guǎng"]],
    "才疏志大": [["cái"], ["shū"], ["zhì"], ["dà"]],
    "才占八斗": [["cái"], ["zhān"], ["bā"], ["dǒu"]],
    "材薄质衰": [["cái"], ["bó"], ["zhì"], ["shuāi"]],
    "材大难用": [["cái"], ["dà"], ["nán"], ["yòng"]],
    "材高知深": [["cái"], ["gāo"], ["zhì"], ["shēn"]],
    "材剧志大": [["cái"], ["jù"], ["zhì"], ["dà"]],
    "材茂行洁": [["cái"], ["mào"], ["xíng"], ["jié"]],
    "材茂行絜": [["cái"], ["mào"], ["xíng"], ["jié"]],
    "材能兼备": [["cái"], ["néng"], ["jiān"], ["bèi"]],
    "材疏志大": [["cái"], ["shū"], ["zhì"], ["dà"]],
    "材轻德薄": [["cái"], ["qīng"], ["dé"], ["bó"]],
    "材朽行秽": [["cái"], ["xiǔ"], ["xíng"], ["huì"]],
    "材优干济": [["cái"], ["yōu"], ["gàn"], ["jǐ"]],
    "财不露白": [["cái"], ["bù"], ["lù"], ["bái"]],
    "财大气粗": [["cái"], ["dà"], ["qì"], ["cù"]],
    "财殚力尽": [["cái"], ["dān"], ["lì"], ["jìn"]],
    "财殚力痡": [["cái"], ["dān"], ["lì"], ["pū"]],
    "财竭力尽": [["cái"], ["jié"], ["lì"], ["jìn"]],
    "财匮力绌": [["cái"], ["kuì"], ["lì"], ["chù"]],
    "财运亨通": [["cái"], ["yùn"], ["hēng"], ["tōng"]],
    "财政寡头": [["cái"], ["zhèng"], ["guǎ"], ["tóu"]],
    "裁长补短": [["cái"], ["cháng"], ["bǔ"], ["duǎn"]],
    "裁红点翠": [["cái"], ["hóng"], ["diǎn"], ["cuì"]],
    "裁判员": [["cái"], ["pàn"], ["yuán"]],
    "采茶戏": [["cǎi"], ["chá"], ["xì"]],
    "采椽不斫": [["cǎi"], ["chuán"], ["bù"], ["zhuó"]],
    "采风问俗": [["cǎi"], ["fēng"], ["wèn"], ["sú"]],
    "采葑采菲": [["cǎi"], ["fēng"], ["cǎi"], ["fēi"]],
    "采凤随鸦": [["cǎi"], ["fèng"], ["suí"], ["yā"]],
    "采及葑菲": [["cǎi"], ["jí"], ["fēng"], ["fēi"]],
    "采兰赠芍": [["cǎi"], ["lán"], ["zèng"], ["sháo"]],
    "采兰赠药": [["cǎi"], ["lán"], ["zèng"], ["yào"]],
    "采石场": [["cǎi"], ["shí"], ["chǎng"]],
    "采薪之疾": [["cǎi"], ["xīn"], ["zhī"], ["jí"]],
    "采薪之患": [["cǎi"], ["xīn"], ["zhī"], ["huàn"]],
    "采薪之忧": [["cǎi"], ["xīn"], ["zhī"], ["yōu"]],
    "彩衣娱亲": [["cǎi"], ["yī"], ["yú"], ["qīn"]],
    "彩云易散": [["cǎi"], ["yún"], ["yì"], ["sàn"]],
    "参差不齐": [["cēn"], ["cī"], ["bù"], ["qí"]],
    "参差不一": [["cēn"], ["cī"], ["bù"], ["yī"]],
    "参差错落": [["cēn"], ["cī"], ["cuò"], ["luò"]],
    "参辰日月": [["shēn"], ["chén"], ["rì"], ["yuè"]],
    "参辰卯酉": [["shēn"], ["chén"], ["mǎo"], ["yǒu"]],
    "参回斗转": [["shēn"], ["huí"], ["dǒu"], ["zhuǎn"]],
    "参横斗转": [["shēn"], ["héng"], ["dǒu"], ["zhuǎn"]],
    "参考书": [["cān"], ["kǎo"], ["shū"]],
    "参谋长": [["cān"], ["móu"], ["zhǎng"]],
    "参前倚衡": [["cān"], ["qián"], ["yǐ"], ["héng"]],
    "参商之虞": [["shēn"], ["shāng"], ["zhī"], ["yú"]],
    "参天贰地": [["cān"], ["tiān"], ["èr"], ["dì"]],
    "参天两地": [["cān"], ["tiān"], ["liǎng"], ["dì"]],
    "参透机关": [["cān"], ["tòu"], ["jī"], ["guān"]],
    "参伍错综": [["cēn"], ["wǔ"], ["cuò"], ["zōng"]],
    "参议会": [["cān"], ["yì"], ["huì"]],
    "参伍错纵": [["cān"], ["wǔ"], ["cuò"], ["zòng"]],
    "参议院": [["cān"], ["yì"], ["yuàn"]],
    "参照系": [["cān"], ["zhào"], ["xì"]],
    "参政党": [["cān"], ["zhèng"], ["dǎng"]],
    "参政议政": [["cān"], ["zhèng"], ["yì"], ["zhèng"]],
    "骖风驷霞": [["cēn"], ["fēng"], ["sì"], ["xiá"]],
    "餐风露宿": [["cān"], ["fēng"], ["lù"], ["sù"]],
    "餐风沐雨": [["cān"], ["fēng"], ["mù"], ["yǔ"]],
    "餐风啮雪": [["cān"], ["fēng"], ["niè"], ["xuě"]],
    "餐风茹雪": [["cān"], ["fēng"], ["rú"], ["xuě"]],
    "餐风宿草": [["cān"], ["fēng"], ["sù"], ["xuě"]],
    "餐风宿露": [["cān"], ["fēng"], ["sù"], ["lù"]],
    "餐风宿水": [["cān"], ["fēng"], ["sù"], ["shuǐ"]],
    "餐风宿雨": [["cān"], ["fēng"], ["sù"], ["yǔ"]],
    "餐风咽露": [["cān"], ["fēng"], ["yàn"], ["lù"]],
    "餐风饮露": [["cān"], ["fēng"], ["yǐn"], ["lù"]],
    "餐松啖柏": [["cān"], ["sōng"], ["dàn"], ["biǎ"]],
    "餐葩饮露": [["cān"], ["pā"], ["yǐn"], ["lù"]],
    "餐霞吸露": [["cān"], ["xiá"], ["xī"], ["lù"]],
    "餐霞饮景": [["cān"], ["xiá"], ["yǐn"], ["jǐng"]],
    "餐云卧石": [["cān"], ["yún"], ["wò"], ["shí"]],
    "残暴不仁": [["cán"], ["bào"], ["bù"], ["rén"]],
    "残编裂简": [["cán"], ["biān"], ["liè"], ["jiǎn"]],
    "残兵败将": [["cán"], ["bīng"], ["bài"], ["jiàng"]],
    "残膏剩馥": [["cán"], ["gāo"], ["shèng"], ["fù"]],
    "残军败将": [["cán"], ["jūn"], ["bài"], ["jiàng"]],
    "残年暮景": [["cán"], ["nián"], ["mù"], ["jǐng"]],
    "残缺不全": [["cán"], ["quē"], ["bù"], ["quán"]],
    "残汤剩饭": [["cán"], ["tāng"], ["shèng"], ["fàn"]],
    "蚕食鲸吞": [["cán"], ["shí"], ["jīng"], ["tūn"]],
    "蚕头燕尾": [["cán"], ["tóu"], ["yàn"], ["wěi"]],
    "惨不忍睹": [["cǎn"], ["bù"], ["rěn"], ["dǔ"]],
    "惨不忍闻": [["cǎn"], ["bù"], ["rěn"], ["wén"]],
    "惨不忍言": [["cǎn"], ["bù"], ["rěn"], ["yán"]],
    "惨澹经营": [["cǎn"], ["dàn"], ["jīng"], ["yíng"]],
    "惨绿愁红": [["cǎn"], ["lü"], ["chóu"], ["hóng"]],
    "惨绿年华": [["cǎn"], ["lǜ"], ["nián"], ["huá"]],
    "惨绿少年": [["cǎn"], ["lǜ"], ["shào"], ["nián"]],
    "惨然不乐": [["cǎn"], ["rán"], ["bù"], ["lè"]],
    "惨雨酸风": [["cǎn"], ["yǔ"], ["suān"], ["fēng"]],
    "灿若繁星": [["càn"], ["ruò"], ["fán"], ["xīng"]],
    "粲然可观": [["càn"], ["rán"], ["kě"], ["guān"]],
    "粲花之论": [["càn"], ["huā"], ["zhī"], ["lùn"]],
    "仓卒主人": [["cāng"], ["cù"], ["zhǔ"], ["rén"]],
    "仓卒之际": [["cāng"], ["cù"], ["zhī"], ["jì"]],
    "沧海横流": [["cāng"], ["hǎi"], ["héng"], ["liú"]],
    "苍松翠柏": [["cāng"], ["sōng"], ["cuì"], ["bǎi"]],
    "苍颜白发": [["cāng"], ["yán"], ["bái"], ["fà"]],
    "苍蝇见血": [["cāng"], ["yíng"], ["jiàn"], ["xuě"]],
    "藏锋敛锷": [["cáng"], ["fēng"], ["liǎn"], ["è"]],
    "藏锋敛锐": [["cáng"], ["fēng"], ["liǎn"], ["ruì"]],
    "藏锋敛颖": [["cáng"], ["fēng"], ["liǎn"], ["yǐng"]],
    "藏弓烹狗": [["cáng"], ["gōng"], ["pēng"], ["gǒu"]],
    "藏垢纳污": [["cáng"], ["gòu"], ["nà"], ["wū"]],
    "藏红花": [["zàng"], ["hóng"], ["huā"]],
    "藏龙卧虎": [["cáng"], ["lóng"], ["wò"], ["hǔ"]],
    "藏猫儿": [["cáng"], ["māo"], ["ér"]],
    "藏怒宿怨": [["cáng"], ["nù"], ["sù"], ["yuàn"]],
    "藏器待时": [["cáng"], ["qì"], ["dài"], ["shí"]],
    "藏巧于拙": [["cáng"], ["qiǎo"], ["yú"], ["zhuō"]],
    "藏头亢脑": [["cáng"], ["tóu"], ["kàng"], ["nǎo"]],
    "藏头露尾": [["cáng"], ["tóu"], ["lù"], ["wěi"]],
    "藏污纳垢": [["cáng"], ["wū"], ["nà"], ["gòu"]],
    "藏形匿影": [["cáng"], ["xíng"], ["nì"], ["yǐng"]],
    "藏之名山": [["cáng"], ["zhī"], ["míng"], ["shān"]],
    "藏诸名山": [["cáng"], ["zhū"], ["míng"], ["shān"]],
    "藏踪蹑迹": [["cáng"], ["zōng"], ["niè"], ["jī"]],
    "操戈同室": [["cāo"], ["gē"], ["tóon"], ["shì"]],
    "操奇计赢": [["cāo"], ["qí"], ["jì"], ["yíng"]],
    "操奇逐赢": [["cāo"], ["qì"], ["zhù"], ["yíng"]],
    "操揉磨治": [["cāo"], ["róu"], ["mó"], ["zhì"]],
    "操身行世": [["cāo"], ["shēn"], ["xíng"], ["shì"]],
    "操赢致奇": [["cāo"], ["yíng"], ["zhì"], ["qí"]],
    "操之过蹙": [["cāo"], ["zhī"], ["guò"], ["cù"]],
    "操之过激": [["cāo"], ["zhī"], ["guò"], ["jī"]],
    "操之过急": [["cāo"], ["zhī"], ["guò"], ["jí"]],
    "操之过切": [["cāo"], ["zhī"], ["guò"], ["qiè"]],
    "操纵自如": [["cāo"], ["zòng"], ["zì"], ["rú"]],
    "操作台": [["cāo"], ["zuò"], ["tái"]],
    "嘈嘈切切": [["cáo"], ["cáo"], ["qiē"], ["qiē"]],
    "草草了事": [["cǎo"], ["cǎo"], ["liǎo"], ["shì"]],
    "草长莺飞": [["cǎo"], ["zhǎng"], ["yīng"], ["fēi"]],
    "草创未就": [["cǎo"], ["chuàng"], ["wèi"], ["jiù"]],
    "草甸子": [["cǎo"], ["diàn"], ["zǐ"]],
    "草间求活": [["cǎo"], ["jiān"], ["qiú"], ["huó"]],
    "草芥人命": [["cǎo"], ["jiè"], ["rén"], ["mìng"]],
    "草料场": [["cǎo"], ["liào"], ["chǎng"]],
    "草率从事": [["cǎo"], ["shuài"], ["cóng"], ["shì"]],
    "草率将事": [["cǎo"], ["lǜ"], ["jiāng"], ["shì"]],
    "草率收兵": [["cǎo"], ["shuài"], ["shōu"], ["bīng"]],
    "草靡风行": [["cǎo"], ["mí"], ["fēng"], ["xíng"]],
    "草木愚夫": [["cǎo"], ["mù"], ["yú"], ["fū"]],
    "草木知威": [["cǎo"], ["mù"], ["zhī"], ["wēi"]],
    "草蛇灰线": [["cǎo"], ["shé"], ["huī"], ["xiàn"]],
    "草头天子": [["cǎo"], ["tóu"], ["tiān"], ["zǐ"]],
    "草行露宿": [["cǎo"], ["xíng"], ["lù"], ["sù"]],
    "草偃风从": [["cǎo"], ["yǎn"], ["fēng"], ["cóng"]],
    "草偃风行": [["cǎo"], ["yǎn"], ["fēng"], ["xíng"]],
    "草衣木食": [["cǎo"], ["yī"], ["mù"], ["shí"]],
    "侧目而视": [["cè"], ["mù"], ["ér"], ["shì"]],
    "侧足而立": [["cè"], ["zú"], ["ér"], ["lì"]],
    "厕身其间": [["cè"], ["shēn"], ["qí"], ["jiān"]],
    "厕足其间": [["cè"], ["zú"], ["qí"], ["jiān"]],
    "恻隐之心": [["cè"], ["yǐn"], ["zhī"], ["xīn"]],
    "测量学": [["cè"], ["liáng"], ["xué"]],
    "策名委质": [["cè"], ["míng"], ["wěi"], ["zhì"]],
    "策顽磨钝": [["cè"], ["wán"], ["mó"], ["dùn"]],
    "策源地": [["cè"], ["yuán"], ["dì"]],
    "岑楼齐末": [["cén"], ["lóu"], ["qí"], ["mò"]],
    "层出不穷": [["céng"], ["chū"], ["bù"], ["qióng"]],
    "层出迭见": [["céng"], ["chū"], ["dié"], ["jiàn"]],
    "层出叠见": [["céng"], ["chū"], ["dié"], ["jiàn"]],
    "层见错出": [["céng"], ["jiàn"], ["cuò"], ["chū"]],
    "层见迭出": [["céng"], ["chū"], ["dié"], ["jiàn"]],
    "层见叠出": [["céng"], ["jiàn"], ["dié"], ["chū"]],
    "层台累榭": [["céng"], ["tái"], ["lěi"], ["xiè"]],
    "插翅难飞": [["chā"], ["chì"], ["nán"], ["fēi"]],
    "插翅难逃": [["chā"], ["chì"], ["nán"], ["táo"]],
    "插队落户": [["chā"], ["duì"], ["luò"], ["hù"]],
    "插科打诨": [["chā"], ["kē"], ["dǎ"], ["hùn"]],
    "插架万轴": [["chā"], ["jià"], ["wàn"], ["zhóu"]],
    "插科使砌": [["chā"], ["kē"], ["shǐ"], ["qì"]],
    "插圈弄套": [["chā"], ["quān"], ["nòng"], ["tào"]],
    "查号台": [["chá"], ["hào"], ["tái"]],
    "查无实据": [["chá"], ["wú"], ["shí"], ["jù"]],
    "茶话会": [["chá"], ["huà"], ["huì"]],
    "茶叶蛋": [["chá"], ["yè"], ["dàn"]],
    "搽脂抹粉": [["chá"], ["zhī"], ["mǒ"], ["fěn"]],
    "察察为明": [["chá"], ["chá"], ["wéi"], ["míng"]],
    "察己知人": [["chá"], ["jǐ"], ["zhī"], ["rén"]],
    "察见渊鱼": [["chá"], ["jiàn"], ["yuān"], ["yú"]],
    "察今知古": [["chá"], ["jīn"], ["zhī"], ["gǔ"]],
    "察言观色": [["chá"], ["yán"], ["guān"], ["sè"]],
    "察言观行": [["chá"], ["yán"], ["guān"], ["xíng"]],
    "察颜观色": [["chá"], ["yán"], ["guān"], ["sè"]],
    "姹紫嫣红": [["chà"], ["zǐ"], ["yān"], ["hóng"]],
    "差不多": [["chà"], ["bù"], ["duō"]],
    "差不离": [["chà"], ["bù"], ["lí"]],
    "差额选举": [["chā"], ["é"], ["xuǎn"], ["jǔ"]],
    "差分放大器": [["chà"], ["fēn"], ["fàng"], ["dà"], ["qì"]],
    "差强人意": [["chā"], ["qiáng"], ["rén"], ["yì"]],
    "差三错四": [["chā"], ["sān"], ["cuò"], ["sì"]],
    "差一点": [["chà"], ["yì"], ["diǎn"]],
    "拆白道字": [["chāi"], ["bái"], ["dào"], ["zì"]],
    "拆东补西": [["chāi"], ["dōng"], ["bǔ"], ["xī"]],
    "拆东墙补西墙": [["chāi"], ["dōng"], ["qiáng"], ["bǔ"], ["xī"], ["qiáng"]],
    "拆牌道字": [["chāi"], ["pái"], ["dào"], ["zì"]],
    "拆墙脚": [["chāi"], ["qiáng"], ["jiǎo"]],
    "拆西补东": [["chāi"], ["xī"], ["bǔ"], ["dōng"]],
    "钗横鬓乱": [["chāi"], ["héng"], ["bìn"], ["luàn"]],
    "柴达木盆地": [["chái"], ["dá"], ["mù"], ["pén"], ["dì"]],
    "柴毁骨立": [["chái"], ["huǐ"], ["gǔ"], ["lì"]],
    "柴立不阿": [["chái"], ["lì"], ["bù"], ["ē"]],
    "柴米夫妻": [["chái"], ["mǐ"], ["fū"], ["qī"]],
    "豺狼当道": [["chái"], ["láng"], ["dāng"], ["dào"]],
    "豺狼当路": [["chái"], ["láng"], ["dāng"], ["lù"]],
    "豺狼当涂": [["chái"], ["láng"], ["dāng"], ["tú"]],
    "豺狼横道": [["chái"], ["láng"], ["héng"], ["dào"]],
    "搀前落后": [["chān"], ["qián"], ["luò"], ["hòu"]],
    "搀行夺市": [["chān"], ["háng"], ["duó"], ["shì"]],
    "谗言佞语": [["chán"], ["yán"], ["nìng"], ["yǔ"]],
    "禅世雕龙": [["chán"], ["shì"], ["diāo"], ["lóng"]],
    "禅絮沾泥": [["chán"], ["xū"], ["zhān"], ["ní"]],
    "缠夹不清": [["chán"], ["jiā"], ["bù"], ["qīng"]],
    "缠绵蕴藉": [["chán"], ["mián"], ["yùn"], ["jiè"]],
    "蝉不知雪": [["chán"], ["bù"], ["zhī"], ["xuě"]],
    "蝉喘雷干": [["chán"], ["chuǎn"], ["léi"], ["gān"]],
    "蝉腹龟肠": [["chán"], ["fù"], ["guī"], ["cháng"]],
    "蟾宫折桂": [["chán"], ["gōng"], ["zhé"], ["guì"]],
    "产品质量": [["chǎn"], ["pǐn"], ["zhì"], ["liàng"]],
    "产褥期": [["chǎn"], ["rù"], ["qī"]],
    "产业结构": [["chǎn"], ["yè"], ["jié"], ["gòu"]],
    "刬草除根": [["chǎn"], ["cǎo"], ["chú"], ["gēn"]],
    "刬恶锄奸": [["chǎn"], ["è"], ["chú"], ["jiān"]],
    "刬旧谋新": [["chǎn"], ["jiù"], ["móu"], ["xīn"]],
    "剗草除根": [["chǎn"], ["cǎo"], ["chú"], ["gēn"]],
    "剗恶锄奸": [["chǎn"], ["è"], ["chú"], ["jiān"]],
    "剗旧谋新": [["chǎn"], ["jiù"], ["móu"], ["xīn"]],
    "谄上傲下": [["chǎn"], ["shàng"], ["ào"], ["xià"]],
    "谄词令色": [["chǎn"], ["cí"], ["lìng"], ["sè"]],
    "谄上骄下": [["chǎn"], ["shàng"], ["jiāo"], ["xià"]],
    "谄上欺下": [["chǎn"], ["shàng"], ["qī"], ["xià"]],
    "谄上抑下": [["chǎn"], ["shàng"], ["yi"], ["xià"]],
    "阐扬光大": [["chǎn"], ["yáng"], ["guāng"], ["dà"]],
    "颤巍巍": [["chàn"], ["wēi"], ["wēi"]],
    "颤悠悠": [["chàn"], ["yōu"], ["yōu"]],
    "昌歜羊枣": [["chāng"], ["chù"], ["yáng"], ["zǎo"]],
    "昌都县": [["chāng"], ["dōu"], ["xiàn"]],
    "昌亭旅食": [["cháng"], ["tíng"], ["lǚ"], ["shí"]],
    "长安道上": [["cháng"], ["ān"], ["dào"], ["shàng"]],
    "长安棋局": [["cháng"], ["ān"], ["qí"], ["jú"]],
    "长安少年": [["cháng"], ["ān"], ["shào"], ["nián"]],
    "长傲饰非": [["zhǎng"], ["ào"], ["shì"], ["fēi"]],
    "长白山": [["cháng"], ["bái"], ["shān"]],
    "长才短驭": [["cháng"], ["cái"], ["duǎn"], ["yù"]],
    "长臂猿": [["cháng"], ["bì"], ["yuán"]],
    "长才广度": [["cháng"], ["cái"], ["guǎng"], ["dù"]],
    "长材茂学": [["cháng"], ["cái"], ["mào"], ["xué"]],
    "长材小试": [["cháng"], ["cái"], ["xiǎo"], ["shì"]],
    "长长短短": [["cháng"], ["cháng"], ["duǎn"], ["duǎn"]],
    "长春不老": [["cháng"], ["chún"], ["bù"], ["lǎo"]],
    "长春市": [["cháng"], ["chūn"], ["shì"]],
    "长此以往": [["cháng"], ["cǐ"], ["yǐ"], ["wǎng"]],
    "长短句": [["cháng"], ["duǎn"], ["jù"]],
    "长恶不悛": [["cháng"], ["è"], ["bù"], ["quān"]],
    "长恶靡悛": [["cháng"], ["è"], ["mǐ"], ["quān"]],
    "长方形": [["cháng"], ["fāng"], ["xíng"]],
    "长方体": [["cháng"], ["fāng"], ["tǐ"]],
    "长风破浪": [["cháng"], ["fēng"], ["pò"], ["làng"]],
    "长歌当哭": [["cháng"], ["gē"], ["dàng"], ["kū"]],
    "长恨歌": [["cháng"], ["hèn"], ["gē"]],
    "长话短说": [["cháng"], ["huà"], ["duǎn"], ["shuō"]],
    "长戟高门": [["cháng"], ["jǐ"], ["gāo"], ["mén"]],
    "长虺成蛇": [["zhǎng"], ["huǐ"], ["chéng"], ["shé"]],
    "长计远虑": [["cháng"], ["jì"], ["yuǎn"], ["lǜ"]],
    "长驾远驭": [["cháng"], ["jià"], ["yuǎn"], ["yù"]],
    "长江后浪推前浪": [["cháng"], ["jiāng"], ["hòu"], ["làng"], ["tuī"], ["qián"], ["làng"]],
    "长江三角洲": [["cháng"], ["jiāng"], ["sān"], ["jiǎo"], ["zhōu"]],
    "长江三峡": [["cháng"], ["jiāng"], ["sān"], ["xiá"]],
    "长江天堑": [["cháng"], ["jiāng"], ["tiān"], ["qiàn"]],
    "长街短巷": [["cháng"], ["jiē"], ["duǎn"], ["xiàng"]],
    "长颈鸟喙": [["cháng"], ["jǐng"], ["niǎo"], ["huì"]],
    "长颈鹿": [["cháng"], ["jǐng"], ["lù"]],
    "长久之计": [["cháng"], ["jiǔ"], ["zhī"], ["jì"]],
    "长林丰草": [["cháng"], ["lín"], ["fēng"], ["cǎo"]],
    "长乐未央": [["cháng"], ["lè"], ["wèi"], ["yāng"]],
    "长虑顾后": [["cháng"], ["lǜ"], ["gù"], ["hòu"]],
    "长虑后顾": [["cháng"], ["lǜ"], ["hòu"], ["gù"]],
    "长虑却顾": [["cháng"], ["lǜ"], ["què"], ["gù"]],
    "长毛绒": [["cháng"], ["máo"], ["róng"]],
    "长眠不起": [["cháng"], ["mián"], ["bù"], ["qǐ"]],
    "长明灯": [["cháng"], ["míng"], ["dēng"]],
    "长鸣都尉": [["cháng"], ["míng"], ["dōu"], ["wèi"]],
    "长命百岁": [["cháng"], ["mìng"], ["bǎi"], ["suì"]],
    "长命锁": [["cháng"], ["mìng"], ["suǒ"]],
    "长命富贵": [["cháng"], ["mìng"], ["fù"], ["guì"]],
    "长目飞耳": [["cháng"], ["mù"], ["fēi"], ["ěr"]],
    "长年累月": [["cháng"], ["nián"], ["lěi"], ["yuè"]],
    "长念却虑": [["cháng"], ["niàn"], ["què"], ["lǜ"]],
    "长年三老": [["zhǎng"], ["nián"], ["sān"], ["lǎo"]],
    "长辔远驭": [["cháng"], ["pèi"], ["yuǎn"], ["yù"]],
    "长篇大论": [["cháng"], ["piān"], ["dà"], ["lùn"]],
    "长辔远御": [["cháng"], ["pèi"], ["yuǎn"], ["yù"]],
    "长篇大套": [["cháng"], ["piān"], ["dà"], ["tào"]],
    "长篇累牍": [["cháng"], ["piān"], ["lěi"], ["dú"]],
    "长篇小说": [["cháng"], ["piān"], ["xiǎo"], ["shuō"]],
    "长七短八": [["cháng"], ["qī"], ["duǎn"], ["bā"]],
    "长驱深入": [["cháng"], ["qū"], ["shēn"], ["rù"]],
    "长驱直进": [["cháng"], ["qū"], ["zhí"], ["jìn"]],
    "长驱直入": [["cháng"], ["qū"], ["zhí"], ["rù"]],
    "长沙市": [["cháng"], ["shā"], ["shì"]],
    "长舌之妇": [["cháng"], ["shé"], ["zhī"], ["fù"]],
    "长舌妇": [["cháng"], ["shé"], ["fù"]],
    "长蛇阵": [["cháng"], ["shé"], ["zhèn"]],
    "长蛇封豕": [["cháng"], ["shé"], ["fēng"], ["shǐ"]],
    "长生不老": [["cháng"], ["shēng"], ["bù"], ["lǎo"]],
    "长生不死": [["cháng"], ["shēng"], ["bū"], ["sǐ"]],
    "长生果": [["cháng"], ["shēng"], ["guǒ"]],
    "长生久视": [["cháng"], ["shēng"], ["jiǔ"], ["shì"]],
    "长绳系景": [["cháng"], ["shéng"], ["xì"], ["jǐng"]],
    "长绳系日": [["cháng"], ["shéng"], ["jì"], ["rì"]],
    "长算远略": [["cháng"], ["suàn"], ["yuǎn"], ["lüè"]],
    "长谈阔论": [["cháng"], ["tán"], ["kuò"], ["lùn"]],
    "长统靴": [["cháng"], ["tǒng"], ["xuē"]],
    "长途跋涉": [["cháng"], ["tú"], ["bá"], ["shè"]],
    "长途电话": [["cháng"], ["tú"], ["diàn"], ["huà"]],
    "长往远引": [["cháng"], ["wǎng"], ["yuǎn"], ["yǐn"]],
    "长袖善舞": [["cháng"], ["xiù"], ["shàn"], ["wǔ"]],
    "长嘘短叹": [["cháng"], ["xū"], ["duǎn"], ["tàn"]],
    "长夜漫漫": [["cháng"], ["yè"], ["màn"], ["màn"]],
    "长夜难明": [["cháng"], ["yè"], ["nán"], ["míng"]],
    "长揖不拜": [["cháng"], ["yī"], ["bù"], ["bài"]],
    "长幼有序": [["zhǎng"], ["yòu"], ["yǒu"], ["xù"]],
    "长幼有叙": [["zhǎng"], ["yòu"], ["yǒu"], ["xù"]],
    "长幼尊卑": [["zhǎng"], ["yòu"], ["zūn"], ["bēi"]],
    "长吁短气": [["cháng"], ["xū"], ["duǎn"], ["qì"]],
    "长吁短叹": [["cháng"], ["xū"], ["duǎn"], ["tàn"]],
    "长斋绣佛": [["cháng"], ["zhāi"], ["xiù"], ["fó"]],
    "长枕大被": [["cháng"], ["zhěn"], ["dà"], ["bèi"]],
    "长枕大衾": [["cháng"], ["zhěn"], ["dà"], ["qīn"]],
    "长治久安": [["cháng"], ["zhì"], ["jiǔ"], ["ān"]],
    "苌弘碧血": [["cháng"], ["hóng"], ["bì"], ["xuě"]],
    "苌弘化碧": [["cháng"], ["hóng"], ["huà"], ["bì"]],
    "偿其大欲": [["cháng"], ["qí"], ["dà"], ["yù"]],
    "常备不懈": [["cháng"], ["bèi"], ["bù"], ["xiè"]],
    "常年累月": [["cháng"], ["nián"], ["lèi"], ["yuè"]],
    "常胜将军": [["cháng"], ["shèng"], ["jiāng"], ["jūn"]],
    "常用对数": [["cháng"], ["yòng"], ["duì"], ["shù"]],
    "场面上": [["chǎng"], ["miàn"], ["shàng"]],
    "场面人": [["chǎng"], ["miàn"], ["rén"]],
    "敞篷车": [["chǎng"], ["péng"], ["chē"]],
    "怅然若失": [["chàng"], ["rán"], ["ruò"], ["shī"]],
    "畅所欲为": [["chàng"], ["suǒ"], ["yù"], ["wéi"]],
    "畅行无阻": [["chàng"], ["xíng"], ["wú"], ["zǔ"]],
    "畅行无碍": [["chàng"], ["xíng"], ["wú"], ["ài"]],
    "倡而不和": [["chàng"], ["ér"], ["bù"], ["hè"]],
    "倡情冶思": [["chàng"], ["qíng"], ["yě"], ["sī"]],
    "倡条冶叶": [["chāng"], ["tiáo"], ["yě"], ["yè"]],
    "倡议书": [["chàng"], ["yì"], ["shū"]],
    "唱筹量沙": [["chàng"], ["chóu"], ["liáng"], ["shā"]],
    "唱对台戏": [["chàng"], ["duì"], ["tái"], ["xì"]],
    "唱反调": [["chàng"], ["fǎn"], ["diào"]],
    "唱沙作米": [["chàng"], ["shā"], ["zuò"], ["mǐ"]],
    "超超玄著": [["chāo"], ["chāo"], ["xuán"], ["zhù"]],
    "超导体": [["chāo"], ["dǎo"], ["tǐ"]],
    "超度众生": [["chāo"], ["dù"], ["zhòng"], ["shēng"]],
    "超高频": [["chāo"], ["gāo"], ["pín"]],
    "超高压": [["chāo"], ["gāo"], ["yā"]],
    "超级大国": [["chāo"], ["jí"], ["dà"], ["guó"]],
    "超级市场": [["chāo"], ["jí"], ["shì"], ["chǎng"]],
    "超今冠古": [["chāo"], ["jīn"], ["guàn"], ["gǔ"]],
    "超期服役": [["chāo"], ["qī"], ["fú"], ["yì"]],
    "超然不群": [["chāo"], ["rán"], ["bù"], ["qún"]],
    "超然独处": [["chāo"], ["rán"], ["dú"], ["chǔ"]],
    "超然远举": [["chāo"], ["rán"], ["yuǎn"], ["jǔ"]],
    "超然远引": [["chāo"], ["rán"], ["yuǎn"], ["yǐn"]],
    "超然自得": [["chāo"], ["rán"], ["zì"], ["dé"]],
    "巢焚原燎": [["cháo"], ["fén"], ["yuán"], ["liáo"]],
    "巢居穴处": [["cháo"], ["jū"], ["xué"], ["chǔ"]],
    "朝不保暮": [["zhāo"], ["bù"], ["bǎo"], ["mù"]],
    "巢林一枝": [["cháo"], ["lín"], ["yī"], ["zhī"]],
    "朝不保夕": [["zhāo"], ["bù"], ["bǎo"], ["xī"]],
    "朝不及夕": [["zhāo"], ["bù"], ["jí"], ["xī"]],
    "朝不虑夕": [["zhāo"], ["bù"], ["lǜ"], ["xī"]],
    "朝朝暮暮": [["zhāo"], ["zhāo"], ["mù"], ["mù"]],
    "朝不谋夕": [["zhāo"], ["bù"], ["móu"], ["xī"]],
    "朝趁暮食": [["zhāo"], ["chèn"], ["mù"], ["shí"]],
    "朝成暮徧": [["cháo"], ["chéng"], ["mù"], ["shí"]],
    "朝成暮毁": [["zhāo"], ["chéng"], ["mù"], ["huǐ"]],
    "朝成暮遍": [["zhāo"], ["chéng"], ["mù"], ["biàn"]],
    "朝成夕毁": [["zhāo"], ["chéng"], ["xī"], ["huǐ"]],
    "朝穿暮塞": [["zhāo"], ["chuān"], ["mù"], ["sāi"]],
    "朝发暮至": [["zhāo"], ["fā"], ["mù"], ["zhì"]],
    "朝歌暮弦": [["zhāo"], ["gē"], ["mù"], ["xián"]],
    "朝发夕至": [["zhāo"], ["fā"], ["xī"], ["zhì"]],
    "朝更暮改": [["zhāo"], ["gèng"], ["mù"], ["gǎi"]],
    "朝歌夜弦": [["zhāo"], ["gē"], ["yè"], ["xián"]],
    "朝过夕改": [["zhāo"], ["guò"], ["xī"], ["gǎi"]],
    "朝华夕秀": [["zhāo"], ["huá"], ["xī"], ["xiù"]],
    "朝欢暮乐": [["zhāo"], ["huān"], ["mù"], ["lè"]],
    "朝齑暮盐": [["zhāo"], ["jī"], ["mù"], ["yán"]],
    "朝经暮史": [["zhāo"], ["jīng"], ["mù"], ["shǐ"]],
    "朝里无人莫做官": [["cháo"], ["lǐ"], ["wú"], ["rén"], ["mò"], ["zuò"], ["guān"]],
    "朝梁暮陈": [["zhāo"], ["liáng"], ["mù"], ["chén"]],
    "朝梁暮晋": [["zhāo"], ["liáng"], ["mù"], ["jìn"]],
    "朝令暮改": [["zhāo"], ["lìng"], ["mù"], ["gǎi"]],
    "朝梁暮周": [["zhāo"], ["liáng"], ["mù"], ["zhōu"]],
    "朝露溘至": [["zhāo"], ["lù"], ["kè"], ["zhì"]],
    "朝攀暮折": [["zhāo"], ["pān"], ["mù"], ["shé"]],
    "朝令夕改": [["zhāo"], ["lìng"], ["xī"], ["gǎi"]],
    "朝气蓬勃": [["zhāo"], ["qì"], ["péng"], ["bó"]],
    "朝前夕惕": [["zhāo"], ["qiáng"], ["xī"], ["tì"]],
    "朝乾夕愓": [["zhāo"], ["qián"], ["xī"], ["dàng"]],
    "朝乾夕惕": [["zhāo"], ["qián"], ["xī"], ["tì"]],
    "朝秦暮楚": [["zhāo"], ["qín"], ["mù"], ["chǔ"]],
    "朝三暮二": [["zhāo"], ["sān"], ["mù"], ["èr"]],
    "朝升暮合": [["zhāo"], ["shēng"], ["mù"], ["gě"]],
    "朝三暮四": [["zhāo"], ["sān"], ["mù"], ["sì"]],
    "朝生夕死": [["zhāo"], ["shēng"], ["xī"], ["sǐ"]],
    "朝生暮死": [["zhāo"], ["shēng"], ["mù"], ["sǐ"]],
    "朝思暮想": [["zhāo"], ["sī"], ["mù"], ["xiǎng"]],
    "朝闻夕改": [["zhāo"], ["wén"], ["xī"], ["gǎi"]],
    "朝斯夕斯": [["zhāo"], ["sī"], ["xī"], ["sī"]],
    "朝闻夕死": [["zhāo"], ["wén"], ["xī"], ["sǐ"]],
    "朝夕相处": [["zhāo"], ["xī"], ["xiāng"], ["chǔ"]],
    "朝鲜族": [["cháo"], ["xiǎn"], ["zú"]],
    "朝阳丹凤": [["cháo"], ["yáng"], ["dān"], ["fèng"]],
    "朝阳鸣凤": [["zhāo"], ["yáng"], ["míng"], ["fèng"]],
    "朝野上下": [["cháo"], ["yě"], ["shàng"], ["xià"]],
    "朝衣东市": [["zhāo"], ["yī"], ["dōng"], ["shì"]],
    "朝夷暮跖": [["zhāo"], ["yí"], ["mù"], ["zhí"]],
    "朝饔夕飧": [["zhāo"], ["yōng"], ["xī"], ["sūn"]],
    "朝云暮雨": [["zhāo"], ["yún"], ["mù"], ["yǔ"]],
    "朝章国典": [["cháo"], ["zhāng"], ["guó"], ["diǎn"]],
    "朝章国故": [["cháo"], ["zhāng"], ["guó"], ["gù"]],
    "朝折暮折": [["zhāo"], ["shé"], ["mù"], ["shé"]],
    "朝锺暮鼓": [["zhāo"], ["zhōng"], ["mù"], ["gǔ"]],
    "朝钟暮鼓": [["zhāo"], ["zhōng"], ["mù"], ["gǔ"]],
    "朝种暮获": [["zhāo"], ["zhǒng"], ["mù"], ["hù"]],
    "朝奏暮召": [["zhāo"], ["zòu"], ["mù"], ["zhào"]],
    "朝奏夕召": [["zhāo"], ["zòu"], ["xī"], ["zhào"]],
    "嘲风弄月": [["cháo"], ["fēng"], ["nòng"], ["yuè"]],
    "嘲风咏月": [["cháo"], ["fēng"], ["yǒng"], ["yuè"]],
    "潮涨潮落": [["cháo"], ["zhǎng"], ["cháo"], ["luò"]],
    "吵吵闹闹": [["chāo"], ["chao"], ["nào"], ["nào"]],
    "炒地皮": [["chǎo"], ["dì"], ["pí"]],
    "炒股票": [["chǎo"], ["gǔ"], ["piào"]],
    "车把式": [["chē"], ["bǎ"], ["shì"]],
    "车尘马迹": [["chē"], ["zhén"], ["mǎ"], ["jì"]],
    "车尘马足": [["chē"], ["chén"], ["mǎ"], ["zú"]],
    "车驰马骤": [["chē"], ["chí"], ["mǎ"], ["zhòu"]],
    "车怠马烦": [["chē"], ["dài"], ["mǎ"], ["fán"]],
    "车殆马烦": [["chē"], ["dài"], ["mǎ"], ["fán"]],
    "车到山前必有路": [["chē"], ["dào"], ["shān"], ["qián"], ["bì"], ["yǒu"], ["lù"]],
    "车烦马毙": [["chē"], ["fán"], ["mǎ"], ["bì"]],
    "车轱辘": [["chē"], ["gū"], ["lù"]],
    "车轱辘话": [["chē"], ["gū"], ["lù"], ["huà"]],
    "车击舟连": [["chē"], ["jī"], ["zhōu"], ["lián"]],
    "车笠之盟": [["chē"], ["lì"], ["zhī"], ["méng"]],
    "车辆厂": [["chē"], ["liàng"], ["chǎng"]],
    "车轮战": [["chē"], ["lún"], ["zhàn"]],
    "车马费": [["chē"], ["mǎ"], ["fèi"]],
    "车马辐辏": [["chē"], ["mǎ"], ["fú"], ["còu"]],
    "车马骈阗": [["chē"], ["mǎ"], ["pián"], ["tián"]],
    "车马填门": [["chē"], ["mǎ"], ["tián"], ["mén"]],
    "车马盈门": [["chē"], ["mǎ"], ["yíng"], ["mén"]],
    "车前子": [["chē"], ["qián"], ["zǐ"]],
    "车水马龙": [["chē"], ["shuǐ"], ["mǎ"], ["lóng"]],
    "车填马隘": [["chē"], ["tián"], ["mǎ"], ["ài"]],
    "车同轨": [["chē"], ["tóng"], ["guǐ"]],
    "车无退表": [["chē"], ["wú"], ["tuì"], ["biǎo"]],
    "车行道": [["chē"], ["háng"], ["dào"]],
    "车载船装": [["chē"], ["zǎi"], ["chuán"], ["zhuāng"]],
    "车载斗量": [["chē"], ["zài"], ["dǒu"], ["liáng"]],
    "车在马前": [["chē"], ["zài"], ["mǎ"], ["qián"]],
    "扯篷拉纤": [["chě"], ["péng"], ["lā"], ["qiàn"]],
    "车辙马迹": [["chē"], ["zhé"], ["mǎ"], ["jì"]],
    "扯旗放炮": [["chě"], ["qí"], ["fàng"], ["pào"]],
    "扯空砑光": [["chě"], ["kōng"], ["yà"], ["guāng"]],
    "扯顺风旗": [["chě"], ["shǔn"], ["fēng"], ["qí"]],
    "扯纤拉烟": [["chě"], ["qiàn"], ["lā"], ["yān"]],
    "彻上彻下": [["chè"], ["shàng"], ["chè"], ["xià"]],
    "彻内彻外": [["chè"], ["nèi"], ["chè"], ["wài"]],
    "彻首彻尾": [["chè"], ["shǒu"], ["chè"], ["wěi"]],
    "彻头彻尾": [["chè"], ["tóu"], ["chè"], ["wěi"]],
    "掣襟露肘": [["chè"], ["jīn"], ["lù"], ["zhǒu"]],
    "澈底澄清": [["chè"], ["dǐ"], ["chéng"], ["qīng"]],
    "嗔目切齿": [["chēn"], ["mù"], ["qiē"], ["chǐ"]],
    "嗔拳不打笑面": [["chēn"], ["quán"], ["bù"], ["dǎ"], ["xiào"], ["miàn"]],
    "瞋目切齿": [["chēn"], ["mù"], ["qiè"], ["chǐ"]],
    "沉甸甸": [["chén"], ["diàn"], ["diàn"]],
    "沉博绝丽": [["chén"], ["bó"], ["jué"], ["lì"]],
    "沉浮俯仰": [["chén"], ["fú"], ["fǔ"], ["yǎng"]],
    "沉痼自若": [["chén"], ["gù"], ["zì"], ["ruò"]],
    "沉疴宿疾": [["chén"], ["kē"], ["sù"], ["jì"]],
    "沉疴难起": [["chén"], ["kē"], ["nán"], ["qǐ"]],
    "沉迷不悟": [["chén"], ["mí"], ["bù"], ["wù"]],
    "沉谋研虑": [["chén"], ["móu"], ["yán"], ["lǜ"]],
    "沉谋重虑": [["chén"], ["móu"], ["chóng"], ["lǜ"]],
    "沉思熟虑": [["chén"], ["sī"], ["shú"], ["lǜ"]],
    "沉吟不决": [["chén"], ["yīn"], ["bù"], ["jué"]],
    "沉吟章句": [["chén"], ["yīn"], ["zhāng"], ["jù"]],
    "沉冤莫白": [["chén"], ["yuān"], ["mò"], ["bái"]],
    "沉鱼落雁": [["chén"], ["yú"], ["luò"], ["yàn"]],
    "沉冤莫雪": [["chén"], ["yuān"], ["mò"], ["xuě"]],
    "沉重寡言": [["chén"], ["zhòng"], ["guǎ"], ["yán"]],
    "沉重少言": [["chén"], ["zhòng"], ["shǎo"], ["yán"]],
    "沉著痛快": [["chén"], ["zhù"], ["tòng"], ["kuài"]],
    "沉着痛快": [["chén"], ["zhuó"], ["tòng"], ["kuài"]],
    "陈陈相因": [["chén"], ["chén"], ["xiāng"], ["yīn"]],
    "陈词滥调": [["chén"], ["cí"], ["làn"], ["diào"]],
    "陈辞滥调": [["chén"], ["cí"], ["làn"], ["diào"]],
    "陈古刺今": [["chén"], ["gǔ"], ["cì"], ["jīn"]],
    "陈善闭邪": [["chén"], ["shàn"], ["bì"], ["xié"]],
    "陈述句": [["chén"], ["shù"], ["jù"]],
    "晨参暮礼": [["chén"], ["cān"], ["mù"], ["lǐ"]],
    "晨参暮省": [["chén"], ["cān"], ["mù"], ["shěng"]],
    "晨昏定省": [["chén"], ["hūn"], ["dìng"], ["xǐng"]],
    "晨提夕命": [["chén"], ["tí"], ["xī"], ["mìng"]],
    "晨兴夜寐": [["chén"], ["xīng"], ["yè"], ["mèi"]],
    "闯南走北": [["chuǎng"], ["nán"], ["zǒu"], ["běi"]],
    "称柴而爨": [["chēng"], ["chái"], ["ér"], ["cuàn"]],
    "称臣纳贡": [["chēng"], ["chén"], ["nà"], ["gòng"]],
    "称德度功": [["chēng"], ["dé"], ["duó"], ["gōng"]],
    "称功颂德": [["chēng"], ["gōng"], ["sòng"], ["dé"]],
    "称家有无": [["chèn"], ["jiā"], ["yǒu"], ["wú"]],
    "称孤道寡": [["chēng"], ["gū"], ["dào"], ["guǎ"]],
    "称奇道绝": [["chēng"], ["qí"], ["dào"], ["jué"]],
    "称赏不已": [["chēng"], ["shǎng"], ["bù"], ["yǐ"]],
    "称体裁衣": [["chèn"], ["tǐ"], ["cái"], ["yī"]],
    "称体载衣": [["chèn"], ["tǐ"], ["cái"], ["yī"]],
    "称王称霸": [["chēng"], ["wáng"], ["chēng"], ["bà"]],
    "称贤荐能": [["chēng"], ["xián"], ["jiàn"], ["néng"]],
    "称心快意": [["chèn"], ["xīn"], ["kuài"], ["yì"]],
    "称心满意": [["chèn"], ["xīn"], ["mǎn"], ["yì"]],
    "称心如意": [["chèn"], ["xīn"], ["rú"], ["yì"]],
    "称薪而爨": [["chēng"], ["xīn"], ["ér"], ["cuàn"]],
    "称兄道弟": [["chēng"], ["xiōng"], ["dào"], ["dì"]],
    "称雨道晴": [["chēng"], ["yǔ"], ["dào"], ["aíng"]],
    "趁风使柁": [["chèn"], ["fēng"], ["shǐ"], ["duò"]],
    "趁哄打劫": [["chèn"], ["hōng"], ["dǎ"], ["jié"]],
    "趁火打劫": [["chèn"], ["huǒ"], ["dǎ"], ["jié"]],
    "趁火抢劫": [["chèn"], ["huǒ"], ["qiǎng"], ["jié"]],
    "趁热打铁": [["chèn"], ["rè"], ["dǎ"], ["tiě"]],
    "趁势落篷": [["chèn"], ["shì"], ["luò"], ["péng"]],
    "趁水和泥": [["chèn"], ["shuǐ"], ["huò"], ["ní"]],
    "撑肠拄肚": [["chēng"], ["cháng"], ["zhǔ"], ["dù"]],
    "撑场面": [["chēng"], ["chǎng"], ["miàn"]],
    "撑竿跳高": [["chēng"], ["gān"], ["tiào"], ["gāo"]],
    "撑天柱地": [["chēng"], ["tiān"], ["zhù"], ["dì"]],
    "撑天拄地": [["chēng"], ["tiān"], ["zhǔ"], ["dì"]],
    "撑霆裂月": [["chēng"], ["tíng"], ["liè"], ["yuè"]],
    "瞠乎其后": [["chēng"], ["hū"], ["qí"], ["hòu"]],
    "瞠目结舌": [["chēng"], ["mù"], ["jié"], ["shé"]],
    "成败得失": [["chéng"], ["bài"], ["dé"], ["shī"]],
    "成败论人": [["chéng"], ["bài"], ["lùn"], ["rén"]],
    "成败兴废": [["chéng"], ["bài"], ["xīng"], ["fèi"]],
    "成帮结队": [["chéng"], ["bāng"], ["jié"], ["duì"]],
    "成都平原": [["chéng"], ["dū"], ["píng"], ["yuán"]],
    "成都市": [["chéng"], ["dū"], ["shì"]],
    "成风尽垩": [["chéng"], ["fēng"], ["jìn"], ["è"]],
    "成风之斫": [["chéng"], ["fēng"], ["zhī"], ["zhuó"]],
    "成佛作祖": [["chéng"], ["fó"], ["zuò"], ["zǔ"]],
    "成功率": [["chéng"], ["gōng"], ["lǜ"]],
    "成活率": [["chéng"], ["huó"], ["lǜ"]],
    "成绩单": [["chéng"], ["jì"], ["dān"]],
    "成吉思汗": [["chéng"], ["jí"], ["sī"], ["hán"]],
    "成家立计": [["chéng"], ["jiā"], ["lì"], ["jì"]],
    "成家立业": [["chéng"], ["jiā"], ["lì"], ["yiè"]],
    "成名成家": [["chéng"], ["míng"], ["chéng"], ["jiā"]],
    "成年累月": [["chéng"], ["nián"], ["lěi"], ["yuè"]],
    "成千成万": [["chéng"], ["qiān"], ["chéng"], ["wàn"]],
    "成千论万": [["chéng"], ["qiān"], ["lùn"], ["wàn"]],
    "成千累万": [["chéng"], ["qiān"], ["lèi"], ["wàn"]],
    "成千上万": [["chéng"], ["qiān"], ["shàng"], ["wàn"]],
    "成群打伙": [["chéng"], ["qún"], ["dǎ"], ["huǒ"]],
    "成群结党": [["chéng"], ["qún"], ["jié"], ["dǎng"]],
    "成群结队": [["chéng"], ["qún"], ["jié"], ["duì"]],
    "成群结伙": [["chéng"], ["qún"], ["jié"], ["huǒ"]],
    "成人教育": [["chéng"], ["rén"], ["jiào"], ["yù"]],
    "成事不说": [["chéng"], ["shì"], ["bù"], ["shuō"]],
    "成王败寇": [["chéng"], ["wáng"], ["bài"], ["kòu"]],
    "成团打块": [["chéng"], ["tuán"], ["dǎ"], ["kuài"]],
    "成也萧何败萧何": [["chéng"], ["yě"], ["xiāo"], ["hé"], ["bài"], ["xiāo"], ["hé"]],
    "成一家言": [["chěng"], ["yī"], ["jiān"], ["yán"]],
    "承平盛世": [["chéng"], ["píng"], ["shèng"], ["shì"]],
    "承嬗离合": [["chéng"], ["shàn"], ["lí"], ["hé"]],
    "承上启下": [["chéng"], ["shàng"], ["qǐ"], ["xià"]],
    "承上起下": [["chéng"], ["shàng"], ["qǐ"], ["xià"]],
    "城北徐公": [["chéng"], ["běi"], ["xǘ"], ["gōng"]],
    "诚心正意": [["chéng"], ["xīn"], ["zhèng"], ["yì"]],
    "城市化": [["chéng"], ["shì"], ["huà"]],
    "城市社会学": [["chéng"], ["shì"], ["shè"], ["huì"], ["xué"]],
    "乘车戴笠": [["chéng"], ["chē"], ["dài"], ["lì"]],
    "乘肥衣轻": [["chéng"], ["féi"], ["yì"], ["qīng"]],
    "乘风破浪": [["chéng"], ["fēng"], ["pò"], ["làng"]],
    "乘风兴浪": [["chéng"], ["fēng"], ["xīng"], ["làng"]],
    "乘风转舵": [["chéng"], ["fēng"], ["zhuǎn"], ["duò"]],
    "乘高决水": [["chéng"], ["gāo"], ["jué"], ["shuǐ"]],
    "乘机打劫": [["chéng"], ["jī"], ["dǎ"], ["jié"]],
    "乘坚策肥": [["chéng"], ["jiān"], ["cè"], ["féi"]],
    "乘坚驱良": [["chéng"], ["jiān"], ["qū"], ["liáng"]],
    "乘间抵隙": [["chéng"], ["jiān"], ["dǐ"], ["xì"]],
    "乘间投隙": [["chéng"], ["jiān"], ["tóu"], ["xì"]],
    "乘间伺隙": [["chéng"], ["jiān"], ["sì"], ["xì"]],
    "乘龙佳婿": [["chéng"], ["lóng"], ["jiā"], ["xù"]],
    "乘利席胜": [["chéng"], ["lì"], ["xí"], ["shèng"]],
    "乘龙快婿": [["chéng"], ["lóng"], ["kuài"], ["xù"]],
    "乘龙配凤": [["chéng"], ["lóng"], ["pèi"], ["fèng"]],
    "乘鸾跨凤": [["chéng"], ["luán"], ["kuà"], ["fèng"]],
    "乘其不备": [["chéng"], ["qí"], ["bù"], ["bèi"]],
    "乘其不意": [["chéng"], ["qí"], ["bù"], ["yì"]],
    "乘轻驱肥": [["chéng"], ["qīng"], ["qū"], ["féi"]],
    "乘人之危": [["chéng"], ["rén"], ["zhī"], ["wēi"]],
    "乘热打铁": [["chéng"], ["rè"], ["dǎ"], ["tiě"]],
    "乘胜逐北": [["chéng"], ["shèng"], ["zhú"], ["běi"]],
    "乘胜追击": [["chéng"], ["shèng"], ["zhuī"], ["jī"]],
    "乘时乘势": [["chéng"], ["shí"], ["chéng"], ["shì"]],
    "乘势使气": [["chéng"], ["shì"], ["shǐ"], ["qì"]],
    "乘顺水船": [["chéng"], ["shùn"], ["shuǐ"], ["chuán"]],
    "乘伪行诈": [["chéng"], ["wěi"], ["xíng"], ["zhà"]],
    "乘务员": [["chéng"], ["wù"], ["yuán"]],
    "乘隙捣虚": [["chéng"], ["xì"], ["dǎo"], ["xū"]],
    "乘隙而入": [["chéng"], ["xì"], ["ér"], ["rù"]],
    "乘险抵巇": [["chéng"], ["xiǎn"], ["dǐ"], ["xī"]],
    "乘兴而来": [["chéng"], ["xìng"], ["ér"], ["lái"]],
    "乘虚蹈隙": [["chéng"], ["xū"], ["dǎo"], ["xì"]],
    "乘虚迭出": [["chéng"], ["xū"], ["dié"], ["chū"]],
    "乘虚而入": [["chéng"], ["xū"], ["ér"], ["rù"]],
    "乘舆播越": [["chéng"], ["yú"], ["bō"], ["yuè"]],
    "乘云行泥": [["chéng"], ["yún"], ["xíng"], ["ní"]],
    "惩恶劝善": [["chéng"], ["è"], ["quàn"], ["shàn"]],
    "澄江如练": [["chéng"], ["jiāng"], ["rú"], ["liàn"]],
    "澄清天下": [["chéng"], ["qīng"], ["tiān"], ["xià"]],
    "澄沙汰砾": [["dèng"], ["shā"], ["tài"], ["lì"]],
    "澄神离形": [["chéng"], ["shén"], ["lí"], ["xíng"]],
    "澄思渺虑": [["chéng"], ["sī"], ["miǎo"], ["lǜ"]],
    "橙黄桔绿": [["chéng"], ["huáng"], ["jú"], ["lǜ"]],
    "橙黄橘绿": [["chéng"], ["huáng"], ["jú"], ["lǜ"]],
    "逞怪披奇": [["chěng"], ["guài"], ["pī"], ["qí"]],
    "逞娇斗媚": [["chěng"], ["jiāo"], ["dòu"], ["mèi"]],
    "逞奇眩异": [["chěng"], ["qí"], ["xuàn"], ["yì"]],
    "逞强称能": [["chěng"], ["qiáng"], ["chēng"], ["néng"]],
    "逞强好胜": [["chěng"], ["qiáng"], ["hào"], ["shèng"]],
    "逞威风": [["chěng"], ["wēi"], ["fēng"]],
    "逞性妄为": [["chěng"], ["xìng"], ["wàng"], ["wéi"]],
    "逞妍斗色": [["chěng"], ["yán"], ["dòu"], ["sè"]],
    "逞异夸能": [["chěng"], ["yì"], ["kuā"], ["néng"]],
    "骋耆奔欲": [["chěng"], ["qí"], ["bēn"], ["yù"]],
    "骋嗜奔欲": [["chěng"], ["shì"], ["bēn"], ["yù"]],
    "秤不离砣": [["chèng"], ["bù"], ["lí"], ["tuó"]],
    "秤锤落井": [["chèng"], ["chuí"], ["luò"], ["jǐng"]],
    "秤砣虽小压千斤": [["chèng"], ["tuó"], ["suī"], ["xiǎo"], ["yā"], ["qiān"], ["jīn"]],
    "秤平斗满": [["chèng"], ["píng"], ["dǒu"], ["mǎn"]],
    "吃白食": [["chī"], ["bái"], ["shí"]],
    "吃不服": [["chī"], ["bù"], ["fú"]],
    "吃不来": [["chī"], ["bù"], ["lái"]],
    "吃不开": [["chī"], ["bù"], ["kāi"]],
    "吃不了": [["chī"], ["bù"], ["liǎo"]],
    "吃不了兜着走": [["chī"], ["bù"], ["liǎo"], ["dōu"], ["zhe"], ["zǒu"]],
    "吃不上": [["chī"], ["bù"], ["shàng"]],
    "吃不透": [["chī"], ["bù"], ["tòu"]],
    "吃不消": [["chī"], ["bù"], ["xiāo"]],
    "吃不住": [["chī"], ["bú"], ["zhù"]],
    "吃不准": [["chī"], ["bù"], ["zhǔn"]],
    "吃穿用度": [["chī"], ["chuān"], ["yòng"], ["dù"]],
    "吃吃喝喝": [["chī"], ["chī"], ["hē"], ["hē"]],
    "吃大户": [["chī"], ["dà"], ["hù"]],
    "吃大锅饭": [["chī"], ["dà"], ["guō"], ["fàn"]],
    "吃得开": [["chī"], ["de"], ["kāi"]],
    "吃得来": [["chī"], ["de"], ["lái"]],
    "吃得消": [["chī"], ["de"], ["xiāo"]],
    "吃得下": [["chī"], ["de"], ["xià"]],
    "吃得住": [["chī"], ["de"], ["zhù"]],
    "吃干饭": [["chī"], ["gān"], ["fàn"]],
    "吃独食": [["chī"], ["dú"], ["shí"]],
    "吃喝玩乐": [["chī"], ["hē"], ["wán"], ["lè"]],
    "吃空额": [["chī"], ["kòng"], ["é"]],
    "吃里扒外": [["chī"], ["lǐ"], ["pá"], ["wài"]],
    "吃粮不管事": [["chī"], ["liáng"], ["bù"], ["guǎn"], ["shì"]],
    "吃力不讨好": [["chī"], ["lì"], ["bù"], ["tǎo"], ["hǎo"]],
    "吃偏食": [["chī"], ["piān"], ["shí"]],
    "吃人不吐骨头": [["chī"], ["rén"], ["bù"], ["tǔ"], ["gú"], ["tou"]],
    "吃软不吃硬": [["chī"], ["ruǎn"], ["bù"], ["chī"], ["yìng"]],
    "吃哑巴亏": [["chī"], ["yǎ"], ["bā"], ["kuī"]],
    "吃硬不吃软": [["chī"], ["yìng"], ["bù"], ["chī"], ["ruǎn"]],
    "吃着不尽": [["chī"], ["zhuó"], ["bù"], ["jìn"]],
    "吃着碗里瞧着锅里": [["chī"], ["zhe"], ["wǎn"], ["lǐ"], ["qiáo"], ["zhe"], ["guō"], ["lǐ"]],
    "鸱鸮弄舌": [["chī"], ["xiāo"], ["nòng"], ["shé"]],
    "痴儿呆女": [["chī"], ["ér"], ["dāi"], ["nǚ"]],
    "痴男怨女": [["chī"], ["nán"], ["yuàn"], ["nǚ"]],
    "弛高骛远": [["chí"], ["gāo"], ["wù"], ["yuǎn"]],
    "痴人说梦": [["chī"], ["rén"], ["shuō"], ["mèng"]],
    "池鱼幕燕": [["chí"], ["yú"], ["mù"], ["yàn"]],
    "池鱼笼鸟": [["chí"], ["yú"], ["lóng"], ["niǎo"]],
    "池鱼堂燕": [["chí"], ["yú"], ["táng"], ["yàn"]],
    "池中物": [["chí"], ["zhōng"], ["wù"]],
    "驰风骋雨": [["chí"], ["fēng"], ["chěng"], ["yǔ"]],
    "驰骋疆场": [["chí"], ["chěng"], ["jiāng"], ["chǎng"]],
    "驰名当世": [["chí"], ["míng"], ["dāng"], ["shì"]],
    "驰高鹜远": [["chí"], ["gāo"], ["wù"], ["yuǎn"]],
    "驰名中外": [["chí"], ["míng"], ["zhōng"], ["wài"]],
    "迟迟吾行": [["chí"], ["chí"], ["wú"], ["xíng"]],
    "驰志伊吾": [["chí"], ["zhì"], ["yī"], ["wú"]],
    "迟徊不决": [["chí"], ["huái"], ["bù"], ["jué"]],
    "迟徊观望": [["chí"], ["huái"], ["guān"], ["wàng"]],
    "迟回观望": [["chí"], ["huí"], ["guān"], ["wàng"]],
    "迟疑不断": [["chí"], ["yí"], ["bù"], ["duàn"]],
    "迟疑不定": [["chí"], ["yí"], ["bù"], ["dìng"]],
    "迟疑不决": [["chí"], ["yí"], ["bù"], ["jué"]],
    "迟疑顾望": [["chí"], ["yí"], ["gù"], ["wàng"]],
    "迟疑观望": [["chí"], ["yí"], ["guān"], ["wàng"]],
    "迟疑未决": [["chí"], ["yí"], ["wèi"], ["jué"]],
    "持螯把酒": [["chí"], ["áo"], ["bǎ"], ["jiǔ"]],
    "持平之论": [["chí"], ["píng"], ["zhī"], ["lùn"]],
    "持论公允": [["chí"], ["lùn"], ["gōng"], ["yǔn"]],
    "持权合变": [["chí"], ["quán"], ["hé"], ["biàn"]],
    "持人长短": [["chí"], ["rén"], ["cháng"], ["duǎn"]],
    "持斋把素": [["chí"], ["zhāi"], ["bǎ"], ["sù"]],
    "持之有故": [["chí"], ["zhī"], ["yǒu"], ["gù"]],
    "持正不阿": [["chí"], ["zhèng"], ["bù"], ["ā"]],
    "踟蹰不前": [["chí"], ["chú"], ["bù"], ["qián"]],
    "尺兵寸铁": [["chǐ"], ["bīng"], ["cùn"], ["tiě"]],
    "尺板斗食": [["chǐ"], ["bǎn"], ["dòu"], ["shí"]],
    "尺波电谢": [["chǐ"], ["bō"], ["diàn"], ["xiè"]],
    "尺布斗粟": [["chǐ"], ["bù"], ["dǒu"], ["sù"]],
    "尺步绳趋": [["chǐ"], ["bù"], ["shéng"], ["qū"]],
    "尺椽片瓦": [["chǐ"], ["chuán"], ["piàn"], ["wǎ"]],
    "尺寸可取": [["chǐ"], ["cùn"], ["kě"], ["qǔ"]],
    "尺寸千里": [["chǐ"], ["cùn"], ["qiān"], ["lǐ"]],
    "尺寸之柄": [["chǐ"], ["cùn"], ["zhī"], ["bǐng"]],
    "尺寸之地": [["chǐ"], ["cùn"], ["zhī"], ["dì"]],
    "尺寸之功": [["chǐ"], ["cù"], ["zhī"], ["gōng"]],
    "尺短寸长": [["chǐ"], ["duǎn"], ["cù"], ["cháng"]],
    "尺二秀才": [["chǐ"], ["èr"], ["xiù"], ["cái"]],
    "尺二冤家": [["chǐ"], ["èr"], ["yuān"], ["jia"]],
    "尺幅寸缣": [["chǐ"], ["fú"], ["cùn"], ["jiān"]],
    "尺幅千里": [["chǐ"], ["fú"], ["qiān"], ["lǐ"]],
    "尺蠖求伸": [["chǐ"], ["huò"], ["qiú"], ["shēn"]],
    "尺籍伍符": [["chǐ"], ["jí"], ["wǔ"], ["fú"]],
    "尺山寸水": [["chǐ"], ["shān"], ["cùn"], ["shuǐ"]],
    "尺树寸泓": [["chǐ"], ["shù"], ["cùn"], ["hóng"]],
    "尺水丈波": [["chǐ"], ["shuǐ"], ["zhàng"], ["bō"]],
    "尺有所短": [["chǐ"], ["yǒu"], ["suǒ"], ["duǎn"]],
    "尺瑜寸瑕": [["chǐ"], ["yú"], ["cùn"], ["xiá"]],
    "尺泽之鲵": [["chǐ"], ["zé"], ["zhī"], ["ní"]],
    "尺竹伍符": [["chǐ"], ["zhú"], ["wǔ"], ["fú"]],
    "侈侈不休": [["chǐ"], ["chǐ"], ["bù"], ["xiū"]],
    "侈丽闳衍": [["chǐ"], ["lì"], ["hóng"], ["yǎn"]],
    "侈衣美食": [["chǐ"], ["yī"], ["měi"], ["shí"]],
    "侈人观听": [["chǐ"], ["rén"], ["guān"], ["tīng"]],
    "侈纵偷苟": [["chǐ"], ["zòng"], ["tōu"], ["gǒu"]],
    "齿白唇红": [["chǐ"], ["bái"], ["chún"], ["hóng"]],
    "齿甘乘肥": [["chǐ"], ["gān"], ["chéng"], ["féi"]],
    "齿过肩随": [["chǐ"], ["guò"], ["jiān"], ["suí"]],
    "齿豁头童": [["chǐ"], ["huō"], ["tóu"], ["tóng"]],
    "齿落舌钝": [["chǐ"], ["luò"], ["shé"], ["dùn"]],
    "齿如齐贝": [["chǐ"], ["rú"], ["qí"], ["bèi"]],
    "齿若编贝": [["chǐ"], ["ruò"], ["biān"], ["bèi"]],
    "齿少气锐": [["chǐ"], ["shǎo"], ["qì"], ["ruì"]],
    "齿少心锐": [["chǐ"], ["shǎo"], ["xīn"], ["ruì"]],
    "齿亡舌存": [["chǐ"], ["wáng"], ["shé"], ["cún"]],
    "齿危发秀": [["chǐ"], ["wēi"], ["fā"], ["xiù"]],
    "齿牙为猾": [["chǐ"], ["yá"], ["wéi"], ["huá"]],
    "齿牙为祸": [["chǐ"], ["yá"], ["wéi"], ["huò"]],
    "齿牙余论": [["chǐ"], ["yá"], ["yú"], ["lùn"]],
    "齿牙馀论": [["chǐ"], ["yá"], ["yú"], ["lùn"]],
    "耻居王后": [["chǐ"], ["jū"], ["wáng"], ["hòu"]],
    "耻言人过": [["chǐ"], ["yán"], ["rén"], ["guò"]],
    "耻与哙伍": [["chǐ"], ["yú"], ["kuài"], ["wǔ"]],
    "叱嗟风云": [["chì"], ["jiē"], ["fēng"], ["yún"]],
    "叱咤风云": [["chì"], ["zhà"], ["fēng"], ["yún"]],
    "赤膊上阵": [["chì"], ["bó"], ["shàng"], ["zhèn"]],
    "赤诚相待": [["chì"], ["chéng"], ["xiāng"], ["dài"]],
    "赤地千里": [["chì"], ["dì"], ["qiān"], ["lǐ"]],
    "赤口毒舌": [["chì"], ["kǒu"], ["dú"], ["shé"]],
    "赤练蛇": [["chì"], ["liàn"], ["shé"]],
    "赤贫如洗": [["chì"], ["pín"], ["rú"], ["xǐ"]],
    "赤身露体": [["chì"], ["shēn"], ["lù"], ["tǐ"]],
    "赤身裸体": [["chì"], ["shēn"], ["luǒ"], ["tǐ"]],
    "赤绳系足": [["chì"], ["shéng"], ["jì"], ["zú"]],
    "赤手空拳": [["chì"], ["shǒu"], ["kōng"], ["quán"]],
    "赤县神州": [["chì"], ["xiàn"], ["shén"], ["zhōu"]],
    "赤心相待": [["chì"], ["xīn"], ["xiāng"], ["dài"]],
    "充栋汗牛": [["chōng"], ["dòng"], ["hàn"], ["niú"]],
    "充栋盈车": [["chōng"], ["dòng"], ["yíng"], ["chē"]],
    "充耳不闻": [["chōng"], ["ěr"], ["bù"], ["wén"]],
    "充其量": [["chōng"], ["qí"], ["liàng"]],
    "充类至尽": [["chōng"], ["lèi"], ["zhì"], ["jìn"]],
    "充天塞地": [["chōng"], ["tiān"], ["sāi"], ["dì"]],
    "冲盹儿": [["chòng"], ["dǔn"], ["er"]],
    "冲风冒雨": [["chōng"], ["fēng"], ["mào"], ["yǔ"]],
    "冲锋队": [["chōng"], ["fēng"], ["duì"]],
    "冲风破浪": [["chōng"], ["fēng"], ["pò"], ["làng"]],
    "冲锋号": [["chōng"], ["fēng"], ["hào"]],
    "冲锋枪": [["chōng"], ["fēng"], ["qiāng"]],
    "冲锋陷坚": [["chōng"], ["fēng"], ["xiàn"], ["jiān"]],
    "冲锋陷阵": [["chōng"], ["fēng"], ["xiàn"], ["zhèn"]],
    "冲锋陷锐": [["chōng"], ["fēng"], ["xiàn"], ["ruì"]],
    "冲冠发怒": [["chōng"], ["guàn"], ["fā"], ["nù"]],
    "冲冠怒发": [["chōng"], ["guàn"], ["nù"], ["fà"]],
    "冲昏头脑": [["chōng"], ["hūn"], ["tóu"], ["nǎo"]],
    "冲冠眦裂": [["chōng"], ["guàn"], ["zì"], ["liè"]],
    "冲击波": [["chōng"], ["jī"], ["bō"]],
    "冲坚毁锐": [["chōng"], ["jiān"], ["huǐ"], ["ruì"]],
    "冲劲儿": [["chòng"], ["jìn"], ["er"]],
    "冲口而出": [["chōng"], ["kǒu"], ["ér"], ["chū"]],
    "冲浪板": [["chōng"], ["làng"], ["bǎn"]],
    "冲天炮": [["chōng"], ["tiān"], ["pào"]],
    "冲云破雾": [["chōng"], ["yún"], ["pò"], ["wù"]],
    "冲州撞府": [["chōng"], ["zhōu"], ["zhuàng"], ["fǔ"]],
    "冲州过府": [["chōng"], ["zhōu"], ["guò"], ["fǔ"]],
    "舂容大雅": [["chōng"], ["róng"], ["dà"], ["yá"]],
    "虫臂鼠肝": [["chóng"], ["bì"], ["shǔ"], ["gān"]],
    "虫沙猿鹤": [["chóng"], ["shā"], ["yuán"], ["hè"]],
    "崇论吰议": [["chóng"], ["lùn"], ["hóng"], ["yì"]],
    "崇论闳议": [["chóng"], ["lùn"], ["hóng"], ["yì"]],
    "崇论宏议": [["chóng"], ["lùn"], ["hóng"], ["yì"]],
    "崇论谹议": [["chóng"], ["lùn"], ["hóng"], ["yì"]],
    "崇山峻岭": [["chóng"], ["shān"], ["jùn"], ["lǐng"]],
    "宠辱不惊": [["chǒng"], ["rǔ"], ["bù"], ["jīng"]],
    "宠辱若惊": [["chǒng"], ["rǔ"], ["ruò"], ["jīng"]],
    "抽丁拔楔": [["chōu"], ["dīng"], ["bá"], ["xiē"]],
    "抽功夫": [["chōu"], ["gōng"], ["fū"]],
    "抽筋拔骨": [["chōu"], ["jīn"], ["bá"], ["gǔ"]],
    "抽筋剥皮": [["chōu"], ["jīn"], ["bāo"], ["pí"]],
    "抽祕骋妍": [["chōu"], ["bì"], ["chěng"], ["yán"]],
    "抽秘骋妍": [["chōu"], ["mì"], ["chěng"], ["yán"]],
    "抽丝剥茧": [["chōu"], ["sī"], ["bāo"], ["jiǎn"]],
    "抽胎换骨": [["chōu"], ["tāi"], ["huàn"], ["gǔ"]],
    "抽样调查": [["chōu"], ["yàng"], ["diào"], ["chá"]],
    "抽象思维": [["chōu"], ["xiàng"], ["sī"], ["wéi"]],
    "绸缪束薪": [["chóu"], ["móu"], ["shù"], ["xīn"]],
    "绸缪帷幄": [["chóu"], ["móu"], ["wéi"], ["wò"]],
    "愁长殢酒": [["chóu"], ["cháng"], ["tì"], ["jiǔ"]],
    "愁肠百结": [["chóu"], ["cháng"], ["bǎi"], ["jié"]],
    "愁肠九转": [["chóu"], ["cháng"], ["jiǔ"], ["zhuǎn"]],
    "愁多夜长": [["chóu"], ["duō"], ["yè"], ["cháng"]],
    "愁红惨绿": [["chóu"], ["hóng"], ["cǎn"], ["lü"]],
    "愁红怨绿": [["chóu"], ["hóng"], ["yuàn"], ["lǜ"]],
    "愁眉不展": [["chóu"], ["méi"], ["bù"], ["zhān"]],
    "愁潘病沈": [["chóu"], ["pān"], ["bìng"], ["shěn"]],
    "稠人广众": [["chóu"], ["rén"], ["guǎng"], ["zhòng"]],
    "愁山闷海": [["chóu"], ["shān"], ["mèn"], ["hǎi"]],
    "稠人广座": [["chóu"], ["rén"], ["guǎng"], ["zuò"]],
    "稠人广坐": [["chóu"], ["rén"], ["guǎng"], ["zuò"]],
    "酬功给效": [["chóu"], ["gōng"], ["gěi"], ["xiào"]],
    "踌躇不决": [["chóu"], ["chú"], ["bù"], ["jué"]],
    "踌躇不前": [["chóu"], ["chú"], ["bù"], ["qián"]],
    "丑类恶物": [["chǒu"], ["lèi"], ["è"], ["wù"]],
    "丑声远播": [["chǒu"], ["shēng"], ["yuǎn"], ["bō"]],
    "丑态毕露": [["chǒu"], ["tài"], ["bì"], ["lù"]],
    "丑媳妇总得见公婆": [["chǒu"], ["xí"], ["fù"], ["zǒng"], ["de"], ["jiàn"], ["gōng"], ["pó"]],
    "臭不可当": [["chòu"], ["bù"], ["kě"], ["dāng"]],
    "臭不可闻": [["chòu"], ["bù"], ["kě"], ["wén"]],
    "臭豆腐": [["chòu"], ["dòu"], ["fǔ"]],
    "臭烘烘": [["chòu"], ["hōng"], ["hōng"]],
    "臭架子": [["chòu"], ["jià"], ["zi"]],
    "臭老九": [["chòu"], ["lǎo"], ["jiǔ"]],
    "臭名远扬": [["chòu"], ["míng"], ["yuǎn"], ["yáng"]],
    "臭名昭著": [["chòu"], ["míng"], ["zhāo"], ["zhù"]],
    "臭名昭彰": [["chòu"], ["míng"], ["zhāo"], ["zhāng"]],
    "臭皮囊": [["chòu"], ["pí"], ["náng"]],
    "臭肉来蝇": [["chòu"], ["ròu"], ["lái"], ["yíng"]],
    "臭味相投": [["xiù"], ["wèi"], ["xiāng"], ["tóu"]],
    "臭氧层": [["chòu"], ["yǎng"], ["céng"]],
    "出厂价格": [["chū"], ["chǎng"], ["jià"], ["gé"]],
    "出尘不染": [["chū"], ["chén"], ["bù"], ["rǎn"]],
    "出处进退": [["chū"], ["chǔ"], ["jìn"], ["tuì"]],
    "出处殊涂": [["chū"], ["chǔ"], ["shū"], ["tú"]],
    "出处殊途": [["chū"], ["chǔ"], ["shū"], ["tú"]],
    "出处语默": [["chū"], ["chǔ"], ["yǔ"], ["mò"]],
    "出词吐气": [["chū"], ["cí"], ["tǔ"], ["qì"]],
    "出敌不意": [["chū"], ["dí"], ["bù"], ["yì"]],
    "出发点": [["chū"], ["fā"], ["diǎn"]],
    "出份子": [["chū"], ["fèn"], ["zi"]],
    "出风头": [["chū"], ["fēng"], ["tou"]],
    "出乖露丑": [["chū"], ["guāi"], ["lù"], ["chǒu"]],
    "出乖弄丑": [["chū"], ["guāi"], ["nòng"], ["chǒu"]],
    "出何经典": [["chū"], ["hé"], ["jīng"], ["diǎn"]],
    "出何典记": [["chū"], ["hé"], ["diǎn"], ["jì"]],
    "出家人": [["chū"], ["jiā"], ["rén"]],
    "出将入相": [["chū"], ["jiàng"], ["rù"], ["xiàng"]],
    "出口加工区": [["chū"], ["kǒu"], ["jiā"], ["gōng"], ["qū"]],
    "出没不常": [["chū"], ["mò"], ["bù"], ["cháng"]],
    "出没无常": [["chū"], ["mò"], ["wú"], ["cháng"]],
    "出门应辙": [["chū"], ["mén"], ["yīng"], ["zhé"]],
    "出门合辙": [["chū"], ["mén"], ["hé"], ["zhé"]],
    "出谋划策": [["chū"], ["móu"], ["huà"], ["cè"]],
    "出内之吝": [["chū"], ["nèi"], ["zhī"], ["lìn"]],
    "出其不备": [["chū"], ["qí"], ["bù"], ["bèi"]],
    "出其不虞": [["chū"], ["qí"], ["bù"], ["yú"]],
    "出其不意": [["chū"], ["qí"], ["bù"], ["yì"]],
    "出奇不穷": [["chū"], ["qí"], ["bù"], ["qióng"]],
    "出奇划策": [["chū"], ["qí"], ["huá"], ["cè"]],
    "出奇无穷": [["chū"], ["qí"], ["wú"], ["qióng"]],
    "出奇制胜": [["chū"], ["qí"], ["zhì"], ["shèng"]],
    "出奇取胜": [["chū"], ["qí"], ["qǔ"], ["shèng"]],
    "出奇致胜": [["chū"], ["qí"], ["zhì"], ["shèng"]],
    "出浅入深": [["chū"], ["qiǎn"], ["rù"], ["shēn"]],
    "出勤率": [["chū"], ["qín"], ["lǜ"]],
    "出人头地": [["chū"], ["rén"], ["tóu"], ["dì"]],
    "出圈儿": [["chū"], ["quān"], ["ér"]],
    "出入将相": [["chū"], ["rù"], ["jiāng"], ["xiāng"]],
    "出入无间": [["chū"], ["rù"], ["wú"], ["jiān"]],
    "出神入化": [["chū"], ["shén"], ["rù"], ["huà"]],
    "出生率": [["chū"], ["shēng"], ["lǜ"]],
    "出师不利": [["chū"], ["shī"], ["bù"], ["lì"]],
    "出师有名": [["chū"], ["shī"], ["yǒu"], ["míng"]],
    "出手得卢": [["chū"], ["shǒu"], ["dé"], ["lú"]],
    "出死断亡": [["chū"], ["sǐ"], ["duàn"], ["wáng"]],
    "出头露面": [["chū"], ["tóu"], ["lù"], ["miàn"]],
    "出头之日": [["chū"], ["tóu"], ["zhī"], ["rì"]],
    "出污泥而不染": [["chū"], ["wū"], ["ní"], ["ér"], ["bù"], ["rǎn"]],
    "出言不逊": [["chū"], ["yán"], ["bù"], ["xùn"]],
    "出言吐词": [["chū"], ["yán"], ["tǔ"], ["cí"]],
    "出言吐气": [["chū"], ["yán"], ["tǔ"], ["qì"]],
    "出言吐语": [["chū"], ["yán"], ["tǔ"], ["yǔ"]],
    "出言有章": [["chū"], ["yán"], ["yǒu"], ["zhāng"]],
    "出洋相": [["chū"], ["yáng"], ["xiàng"]],
    "出一头地": [["chū"], ["yī"], ["tóu"], ["dì"]],
    "出有入无": [["chū"], ["yǒu"], ["rù"], ["wú"]],
    "出淤泥而不染": [["chū"], ["yū"], ["ní"], ["ér"], ["bù"], ["rǎn"]],
    "出语成章": [["chū"], ["yǔ"], ["chéng"], ["zhāng"]],
    "出云入泥": [["chū"], ["yún"], ["rù"], ["ní"]],
    "出租汽车": [["chū"], ["zū"], ["qì"], ["chē"]],
    "初等教育": [["chū"], ["děng"], ["jiào"], ["yù"]],
    "初级中学": [["chū"], ["jí"], ["zhōng"], ["xué"]],
    "初露头角": [["chū"], ["lù"], ["tóu"], ["jiǎo"]],
    "初露锋芒": [["chū"], ["lù"], ["fēng"], ["máng"]],
    "初生之犊不惧虎": [["chū"], ["shēng"], ["zhī"], ["dú"], ["bù"], ["jù"], ["hǔ"]],
    "初生之犊不畏虎": [["chū"], ["shēng"], ["zhī"], ["dú"], ["bù"], ["wèi"], ["hǔ"]],
    "初生牛犊不怕虎": [["chū"], ["shēng"], ["niú"], ["dú"], ["bù"], ["pà"], ["hǔ"]],
    "初中生": [["chū"], ["zhōng"], ["shēng"]],
    "樗栎庸材": [["chū"], ["lì"], ["yōng"], ["cái"]],
    "刍荛之见": [["chú"], ["ráo"], ["zhī"], ["jiàn"]],
    "除暴安良": [["chú"], ["bào"], ["ān"], ["liáng"]],
    "除恶务本": [["chú"], ["è"], ["wù"], ["běn"]],
    "除恶务尽": [["chú"], ["è"], ["wù"], ["jìn"]],
    "除害兴利": [["chú"], ["hài"], ["xīng"], ["lì"]],
    "除患兴利": [["chú"], ["huàn"], ["xīng"], ["lì"]],
    "除旧更新": [["chú"], ["jiù"], ["gēng"], ["xīn"]],
    "除狼得虎": [["chú"], ["láng"], ["dé"], ["hǔ"]],
    "除邪惩恶": [["chú"], ["xié"], ["chéng"], ["è"]],
    "锄强扶弱": [["chú"], ["qiáng"], ["fú"], ["ruò"]],
    "础泣而雨": [["chǔ"], ["qì"], ["ér"], ["yǔ"]],
    "础润而雨": [["chǔ"], ["rùn"], ["ér"], ["yǔ"]],
    "储蓄银行": [["chǔ"], ["xù"], ["yín"], ["háng"]],
    "楚楚可爱": [["chǔ"], ["chǔ"], ["kě"], ["ài"]],
    "楚璧隋珍": [["chǔ"], ["bì"], ["suí"], ["zhēn"]],
    "楚楚不凡": [["chǔ"], ["chǔ"], ["bù"], ["fán"]],
    "楚楚可怜": [["chǔ"], ["chǔ"], ["kě"], ["lián"]],
    "楚楚可人": [["chǔ"], ["chǔ"], ["kě"], ["rén"]],
    "楚楚有致": [["chǔ"], ["chǔ"], ["yǒu"], ["zhì"]],
    "楚弓楚得": [["chǔ"], ["gōng"], ["chǔ"], ["dé"]],
    "楚得楚弓": [["chǔ"], ["dé"], ["chǔ"], ["gōng"]],
    "楚歌四合": [["chǔ"], ["gē"], ["sì"], ["hé"]],
    "楚弓复得": [["chǔ"], ["gōng"], ["fù"], ["dé"]],
    "楚梦云雨": [["chǔ"], ["mèng"], ["yún"], ["yǔ"]],
    "楚囊之情": [["chǔ"], ["náng"], ["zhī"], ["qíng"]],
    "楚囚相对": [["chǔ"], ["qiú"], ["xiāng"], ["duì"]],
    "楚天云雨": [["chǔ"], ["tiān"], ["yún"], ["yǔ"]],
    "楚尾吴头": [["chǔ"], ["wěi"], ["wú"], ["tóu"]],
    "楚腰纤细": [["chǔ"], ["yāo"], ["xiān"], ["xì"]],
    "楚雨巫云": [["chǔ"], ["yǔ"], ["wū"], ["yún"]],
    "楚云湘雨": [["chǔ"], ["yún"], ["xiāng"], ["yǔ"]],
    "褚小杯大": [["zhǔ"], ["xiǎo"], ["bēi"], ["dà"]],
    "褚小怀大": [["zhǔ"], ["xiǎo"], ["huái"], ["dà"]],
    "处高临深": [["chǔ"], ["gāo"], ["lín"], ["shēn"]],
    "处理品": [["chǔ"], ["lǐ"], ["pǐn"]],
    "处女地": [["chǔ"], ["nǚ"], ["dì"]],
    "处女膜": [["chǔ"], ["nǚ"], ["mó"]],
    "处女作": [["chǔ"], ["nǚ"], ["zuò"]],
    "处实效功": [["chǔ"], ["shí"], ["xiào"], ["gōng"]],
    "处堂燕雀": [["chǔ"], ["táng"], ["yàn"], ["què"]],
    "处堂燕鹊": [["chǔ"], ["táng"], ["yàn"], ["què"]],
    "处心积虑": [["chǔ"], ["xīn"], ["jī"], ["lǜ"]],
    "处之泰然": [["chǔ"], ["zhī"], ["tài"], ["rán"]],
    "处尊居显": [["chǔ"], ["zūn"], ["jū"], ["xiǎn"]],
    "触地号天": [["chù"], ["dì"], ["hào"], ["tiān"]],
    "触处机来": [["chù"], ["chǔ"], ["jī"], ["lái"]],
    "触斗蛮争": [["chù"], ["dòu"], ["mán"], ["zhēng"]],
    "触机便发": [["chù"], ["jī"], ["biàn"], ["fā"]],
    "触发器": [["chù"], ["fā"], ["qì"]],
    "触景伤怀": [["chù"], ["jǐng"], ["shāng"], ["huái"]],
    "触景伤情": [["chù"], ["jǐng"], ["shāng"], ["qíng"]],
    "触景伤心": [["chù"], ["jǐng"], ["shāng"], ["xīn"]],
    "触景生情": [["chù"], ["jǐng"], ["shēng"], ["qíng"]],
    "触类而长": [["chù"], ["lèi"], ["ér"], ["cháng"]],
    "触类旁通": [["chù"], ["lèi"], ["páng"], ["tōng"]],
    "触霉头": [["chù"], ["méi"], ["tóu"]],
    "触目兴叹": [["chù"], ["mù"], ["xīng"], ["tàn"]],
    "触石决木": [["chù"], ["shí"], ["jué"], ["mù"]],
    "触手可及": [["chù"], ["shǒu"], ["kě"], ["jí"]],
    "触物兴怀": [["chù"], ["wù"], ["xīng"], ["huái"]],
    "黜邪崇正": [["chù"], ["xié"], ["chóng"], ["zhèng"]],
    "黜衣缩食": [["chù"], ["yī"], ["suō"], ["shí"]],
    "揣骨听声": [["chuāi"], ["gǔ"], ["tīng"], ["shēng"]],
    "揣合逢迎": [["chuǎi"], ["hé"], ["féng"], ["yíng"]],
    "揣奸把猾": [["chuāi"], ["jiān"], ["bǎ"], ["huá"]],
    "揣时度力": [["chuǎi"], ["shí"], ["duó"], ["lì"]],
    "揣手儿": [["chuāi"], ["shǒu"], ["er"]],
    "啜食吐哺": [["chuò"], ["shí"], ["tǔ"], ["bǔ"]],
    "啜菽饮水": [["chuò"], ["shū"], ["yǐn"], ["shuǐ"]],
    "啜英咀华": [["chuò"], ["yīng"], ["jǔ"], ["huá"]],
    "川流不息": [["chuān"], ["liú"], ["bù"], ["xī"]],
    "川渟岳峙": [["chuān"], ["tīng"], ["yuè"], ["zhì"]],
    "川泽纳污": [["chuān"], ["zé"], ["nà"], ["wū"]],
    "川壅必溃": [["chuān"], ["yōng"], ["bì"], ["kuì"]],
    "穿红着绿": [["chuān"], ["hóng"], ["zhuó"], ["lǜ"]],
    "穿井得人": [["chuān"], ["jǐng"], ["dé"], ["rén"]],
    "穿堂风": [["chuān"], ["táng"], ["fēng"]],
    "穿云裂石": [["chuān"], ["yún"], ["liè"], ["shí"]],
    "穿凿附会": [["chuān"], ["záo"], ["fù"], ["huì"]],
    "穿着打扮": [["chuān"], ["zhe"], ["dǎ"], ["bàn"]],
    "传帮带": [["chuán"], ["bāng"], ["dài"]],
    "传杯换盏": [["chuán"], ["bēi"], ["huàn"], ["zhǎn"]],
    "传柄移藉": [["chuán"], ["bǐng"], ["yí"], ["jiè"]],
    "传杯弄盏": [["chuán"], ["bēi"], ["nòng"], ["zhǎn"]],
    "传达室": [["chuán"], ["dá"], ["shì"]],
    "传道受业": [["chuán"], ["dào"], ["shòu"], ["yè"]],
    "传动带": [["chuán"], ["dòng"], ["dài"]],
    "传风搧火": [["chuán"], ["fēng"], ["yǒu"], ["huǒ"]],
    "传风扇火": [["chuán"], ["fēng"], ["shān"], ["huǒ"]],
    "传龟袭紫": [["chuán"], ["guī"], ["xí"], ["zǐ"]],
    "传圭袭组": [["chuán"], ["guī"], ["xí"], ["zǔ"]],
    "传感器": [["chuán"], ["gǎn"], ["qì"]],
    "传呼电话": [["chuán"], ["hū"], ["diàn"], ["huà"]],
    "传家宝": [["chuán"], ["jiā"], ["bǎo"]],
    "传教士": [["chuán"], ["jiào"], ["shì"]],
    "传经送宝": [["chuán"], ["jīng"], ["sòng"], ["bǎo"]],
    "传爵袭紫": [["chuán"], ["jué"], ["xí"], ["zǐ"]],
    "传令兵": [["chuán"], ["lìng"], ["bīng"]],
    "传染病": [["chuán"], ["rǎn"], ["bìng"]],
    "传神阿堵": [["chuán"], ["shén"], ["ā"], ["dǔ"]],
    "传声器": [["chuán"], ["shēng"], ["qì"]],
    "传声筒": [["chuán"], ["shēng"], ["tǒng"]],
    "传送带": [["chuán"], ["sòng"], ["dài"]],
    "传诵一时": [["chuán"], ["sòng"], ["yī"], ["shí"]],
    "传为佳话": [["chuán"], ["wéi"], ["jiā"], ["huà"]],
    "传为美谈": [["chuán"], ["wéi"], ["měi"], ["tán"]],
    "传为笑柄": [["chuán"], ["wéi"], ["xiào"], ["bǐng"]],
    "传为笑谈": [["chuán"], ["wéi"], ["xiào"], ["tán"]],
    "传闻不如亲见": [["chuán"], ["wén"], ["bù"], ["rú"], ["qīn"], ["jiàn"]],
    "传闻异辞": [["chuán"], ["wén"], ["yì"], ["cí"]],
    "传檄而定": [["chuán"], ["xí"], ["ér"], ["dìng"]],
    "传真电报": [["chuán"], ["zhēn"], ["diàn"], ["bào"]],
    "传宗接代": [["chuán"], ["zōng"], ["jiē"], ["dài"]],
    "船到桥门自会直": [["chuán"], ["dào"], ["qiáo"], ["mén"], ["zì"], ["huì"], ["zhí"]],
    "船多不碍路": [["chuán"], ["duō"], ["bù"], ["ài"], ["lù"]],
    "船夫曲": [["chuán"], ["fū"], ["qǔ"]],
    "船坚炮利": [["chuán"], ["jiān"], ["pào"], ["lì"]],
    "喘息之间": [["chuǎn"], ["xī"], ["zhī"], ["jiān"]],
    "喘嘘嘘": [["chuǎn"], ["xū"], ["xū"]],
    "喘吁吁": [["chuǎn"], ["xū"], ["xū"]],
    "串并联": [["chuàn"], ["bìng"], ["lián"]],
    "串亲访友": [["chuàn"], ["qīn"], ["fǎng"], ["yǒu"]],
    "串亲戚": [["chuàn"], ["qīn"], ["qī"]],
    "窗间过马": [["chuāng"], ["jiān"], ["guò"], ["mǎ"]],
    "窗明几净": [["chuāng"], ["míng"], ["jī"], ["jìng"]],
    "床上安床": [["chuáng"], ["shàng"], ["ān"], ["chuáng"]],
    "床上叠床": [["chuáng"], ["shàng"], ["dié"], ["chuáng"]],
    "床上迭床": [["chuáng"], ["shàng"], ["dié"], ["chuáng"]],
    "床上施床": [["chuáng"], ["shàng"], ["shī"], ["chuáng"]],
    "床头柜": [["chuáng"], ["tóu"], ["guì"]],
    "床头金尽": [["chuáng"], ["tóu"], ["jīn"], ["jìn"]],
    "床下牛斗": [["chuáng"], ["xià"], ["niú"], ["dòu"]],
    "创巨痛仍": [["chuàng"], ["jù"], ["tòng"], ["réng"]],
    "创巨痛深": [["chuāng"], ["jù"], ["tòng"], ["shēn"]],
    "创钜痛仍": [["chuàng"], ["jù"], ["tòng"], ["réng"]],
    "创钜痛深": [["chuàng"], ["jù"], ["tòng"], ["shēn"]],
    "创剧痛深": [["chuàng"], ["jù"], ["tòng"], ["shēn"]],
    "创刊词": [["chuàng"], ["kān"], ["cí"]],
    "创刊号": [["chuàng"], ["kān"], ["hào"]],
    "创牌子": [["chuàng"], ["pái"], ["zi"]],
    "创始人": [["chuàng"], ["shǐ"], ["rén"]],
    "创世纪": [["chuàng"], ["shì"], ["jì"]],
    "创业垂统": [["chuàng"], ["yè"], ["chuí"], ["tǒng"]],
    "创业史": [["chuàng"], ["yè"], ["shǐ"]],
    "创业维艰": [["chuàng"], ["yè"], ["wéi"], ["jiān"]],
    "创意造言": [["chuàng"], ["yì"], ["zào"], ["yán"]],
    "创造力": [["chuàng"], ["zào"], ["lì"]],
    "创造性": [["chuàng"], ["zào"], ["xìng"]],
    "创造性思维": [["chuàng"], ["zào"], ["xìng"], ["sī"], ["wéi"]],
    "创作方法": [["chuàng"], ["zuò"], ["fāng"], ["fǎ"]],
    "怆地呼天": [["chuàng"], ["dì"], ["hū"], ["tiān"]],
    "怆天呼地": [["chuàng"], ["tiān"], ["hū"], ["dì"]],
    "吹吹打打": [["chuī"], ["chuī"], ["dǎ"], ["dǎ"]],
    "吹篪乞食": [["chuī"], ["chí"], ["qǐ"], ["shí"]],
    "吹弹得破": [["chuī"], ["tán"], ["dé"], ["pò"]],
    "吹弹歌舞": [["chuī"], ["tán"], ["gē"], ["wǔ"]],
    "吹花嚼蕊": [["chuī"], ["huā"], ["jiáo"], ["ruǐ"]],
    "吹风机": [["chuī"], ["fēng"], ["jī"]],
    "吹角连营": [["chuī"], ["jiǎo"], ["lián"], ["yíng"]],
    "吹拉弹唱": [["chuī"], ["lā"], ["tán"], ["chàng"]],
    "吹糠见米": [["chuī"], ["kāng"], ["jiàn"], ["mǐ"]],
    "吹毛数睫": [["chuī"], ["máo"], ["shù"], ["jié"]],
    "吹冷风": [["chuī"], ["lěng"], ["fēng"]],
    "吹毛洗垢": [["chuī"], ["máo"], ["xǐ"], ["gòu"]],
    "吹叶嚼蕊": [["chuī"], ["yè"], ["jiáo"], ["ruǐ"]],
    "吹箫乞食": [["chuī"], ["xiāo"], ["qǐ"], ["shí"]],
    "吹竹弹丝": [["chuí"], ["zhú"], ["dàn"], ["sī"]],
    "炊沙成饭": [["chuī"], ["shā"], ["chéng"], ["fàn"]],
    "炊沙镂冰": [["chuī"], ["shā"], ["lòu"], ["bīng"]],
    "炊沙作饭": [["chuī"], ["shā"], ["zuò"], ["fàn"]],
    "炊沙作糜": [["chuī"], ["shā"], ["zuò"], ["mí"]],
    "炊事员": [["chuī"], ["shì"], ["yuán"]],
    "炊鲜漉清": [["chuī"], ["xiān"], ["lù"], ["qīng"]],
    "垂手而得": [["chuí"], ["shǒu"], ["ér"], ["dé"]],
    "垂首帖耳": [["chuí"], ["shǒu"], ["tiē"], ["ěr"]],
    "垂手可得": [["chuí"], ["shǒu"], ["kě"], ["dé"]],
    "垂首丧气": [["chuí"], ["shǒu"], ["sàng"], ["qì"]],
    "垂死挣扎": [["chuí"], ["sǐ"], ["zhēng"], ["zhá"]],
    "垂头塞耳": [["chuí"], ["tóu"], ["sāi"], ["ěr"]],
    "垂头丧气": [["chuí"], ["tóu"], ["sàng"], ["qì"]],
    "垂头铩羽": [["chuí"], ["tóu"], ["shā"], ["yǔ"]],
    "垂头塌翅": [["chuí"], ["tóu"], ["tā"], ["chì"]],
    "垂头搨翼": [["chuí"], ["tóu"], ["dá"], ["yì"]],
    "垂涎三尺": [["chuí"], ["xián"], ["sān"], ["chǐ"]],
    "垂直地带性": [["chuí"], ["zhí"], ["dì"], ["dài"], ["xìng"]],
    "垂直绿化": [["chuí"], ["zhí"], ["lǜ"], ["huà"]],
    "垂直平分线": [["chuí"], ["zhí"], ["píng"], ["fēn"], ["xiàn"]],
    "捶骨沥髓": [["chuí"], ["gǔ"], ["lì"], ["suǐ"]],
    "槌仁提义": [["chuí"], ["rén"], ["tí"], ["yì"]],
    "槌胸蹋地": [["chuí"], ["xiōng"], ["tà"], ["dì"]],
    "春冰虎尾": [["chūn"], ["bīng"], ["hǔ"], ["wěi"]],
    "春蚕到死丝方尽": [["chūn"], ["cán"], ["dào"], ["sǐ"], ["sī"], ["fāng"], ["jìn"]],
    "春大麦": [["chūn"], ["dà"], ["mài"]],
    "春风得意": [["chūn"], ["fēng"], ["dé"], ["yì"]],
    "春风和气": [["chūn"], ["fēng"], ["hé"], ["qì"]],
    "春风风人": [["chūn"], ["fēng"], ["fèng"], ["rén"]],
    "春风化雨": [["chūn"], ["fēng"], ["huà"], ["yǔ"]],
    "春风满面": [["chūn"], ["fēng"], ["mǎn"], ["miàn"]],
    "春风野火": [["chūn"], ["fēng"], ["yě"], ["huǒ"]],
    "春风夏雨": [["chūn"], ["fēng"], ["xià"], ["yǔ"]],
    "春风一度": [["chūn"], ["fēng"], ["yī"], ["dù"]],
    "春风沂水": [["chūn"], ["fēng"], ["yí"], ["shuǐ"]],
    "春光漏泄": [["chūn"], ["guāng"], ["lòu"], ["xiè"]],
    "春风雨露": [["chūn"], ["fēng"], ["yǔ"], ["lù"]],
    "春和景明": [["chūn"], ["hé"], ["jǐng"], ["míng"]],
    "春华秋实": [["chūn"], ["huá"], ["qiū"], ["shí"]],
    "春回大地": [["chūn"], ["huí"], ["dà"], ["dì"]],
    "春露秋霜": [["chūn"], ["lù"], ["qiū"], ["shuāng"]],
    "春葩丽藻": [["chūn"], ["pā"], ["lì"], ["zǎo"]],
    "春秋鼎盛": [["chūn"], ["qiū"], ["dǐng"], ["shèng"]],
    "春色撩人": [["chūn"], ["sè"], ["liáo"], ["rén"]],
    "春蛇秋蚓": [["chūn"], ["shé"], ["qiū"], ["yǐn"]],
    "春深似海": [["chūn"], ["shēn"], ["sì"], ["hǎi"]],
    "春笋怒发": [["chūn"], ["sǔn"], ["mù"], ["fā"]],
    "春蚓秋蛇": [["chūn"], ["yǐn"], ["qiū"], ["shé"]],
    "春雨如油": [["chūn"], ["yǔ"], ["rú"], ["yóu"]],
    "椿萱并茂": [["chūn"], ["xuān"], ["bìng"], ["mào"]],
    "纯一不杂": [["chún"], ["yī"], ["bù"], ["zá"]],
    "纯正无邪": [["chún"], ["zhèng"], ["wú"], ["xié"]],
    "纯属骗局": [["chún"], ["shú"], ["piàn"], ["jú"]],
    "唇齿相须": [["chún"], ["chǐ"], ["xiāng"], ["xū"]],
    "唇齿相依": [["chún"], ["chǐ"], ["xiāng"], ["yī"]],
    "唇不离腮": [["chún"], ["bù"], ["lí"], ["sāi"]],
    "唇辅相连": [["chún"], ["fǔ"], ["xiāng"], ["lián"]],
    "唇干口燥": [["chún"], ["gān"], ["kǒu"], ["zào"]],
    "唇腐齿落": [["chún"], ["fǔ"], ["chǐ"], ["luò"]],
    "唇红齿白": [["chún"], ["hóng"], ["chǐ"], ["bái"]],
    "唇揭齿寒": [["chún"], ["jiē"], ["chǐ"], ["hán"]],
    "唇亡齿寒": [["chún"], ["wáng"], ["chǐ"], ["hán"]],
    "莼鲈之思": [["chún"], ["lú"], ["zhī"], ["sī"]],
    "鹑居鷇食": [["chún"], ["jū"], ["kòu"], ["shí"]],
    "鹑衣鷇食": [["chún"], ["yī"], ["kòu"], ["shí"]],
    "鹑衣百结": [["chún"], ["yī"], ["bǎi"], ["jié"]],
    "踔绝之能": [["chuō"], ["jué"], ["zhī"], ["néng"]],
    "踔厉奋发": [["chuō"], ["lì"], ["fèn"], ["fā"]],
    "踔厉风发": [["chuō"], ["lì"], ["fēng"], ["fā"]],
    "踔厉骏发": [["chuō"], ["lì"], ["jùn"], ["fā"]],
    "绰绰有余": [["chuò"], ["chuò"], ["yǒu"], ["yú"]],
    "惙怛伤悴": [["chuò"], ["dá"], ["shāng"], ["cuì"]],
    "绰绰有裕": [["chuò"], ["chuò"], ["yǒu"], ["yù"]],
    "绰有余裕": [["chuò"], ["yǒu"], ["yú"], ["yù"]],
    "绰约多姿": [["chuò"], ["yuē"], ["duō"], ["zī"]],
    "辍毫栖牍": [["chuò"], ["háo"], ["qī"], ["dú"]],
    "词不达意": [["cí"], ["bù"], ["dá"], ["yì"]],
    "词不逮理": [["cí"], ["bù"], ["dài"], ["lǐ"]],
    "词不逮意": [["cí"], ["bù"], ["dài"], ["yì"]],
    "词华典赡": [["cí"], ["huá"], ["diǎn"], ["shàn"]],
    "词穷理尽": [["cí"], ["qióng"], ["lǐ"], ["jìn"]],
    "词无枝叶": [["cí"], ["wú"], ["zhī"], ["yè"]],
    "词严义正": [["cí"], ["yán"], ["yì"], ["zhèng"]],
    "词言义正": [["cí"], ["yán"], ["yì"], ["zhèng"]],
    "词约指明": [["cí"], ["yuē"], ["zhǐ"], ["míng"]],
    "词正理直": [["cí"], ["zhèng"], ["lǐ"], ["zhí"]],
    "慈悲为本": [["cí"], ["bēi"], ["wéi"], ["běn"]],
    "辞不达义": [["cí"], ["bù"], ["dá"], ["yì"]],
    "辞不达意": [["cí"], ["bù"], ["dá"], ["yì"]],
    "辞不获命": [["cí"], ["bù"], ["huò"], ["mìng"]],
    "辞多受少": [["cí"], ["duō"], ["shòu"], ["shǎo"]],
    "辞严气正": [["cí"], ["yán"], ["qì"], ["zhèng"]],
    "辞微旨远": [["cí"], ["wēi"], ["zhǐ"], ["yuǎn"]],
    "辞严义正": [["cí"], ["yán"], ["yì"], ["zhèng"]],
    "辞严谊正": [["cí"], ["yán"], ["yì"], ["zhèng"]],
    "辞严意正": [["cí"], ["yán"], ["yì"], ["zhèng"]],
    "此唱彼和": [["cǐ"], ["chàng"], ["bǐ"], ["hè"]],
    "此地无银三百两": [["cǐ"], ["dì"], ["wú"], ["yín"], ["sān"], ["bǎi"], ["liǎng"]],
    "此动彼应": [["cǐ"], ["dòng"], ["bǐ"], ["yīng"]],
    "此发彼应": [["cǐ"], ["fā"], ["bǐ"], ["yīng"]],
    "此风不可长": [["cǐ"], ["fēng"], ["bù"], ["kě"], ["zhǎng"]],
    "此呼彼应": [["cǐ"], ["hū"], ["bǐ"], ["yīng"]],
    "此界彼疆": [["cǐ"], ["jiè"], ["bǐ"], ["jiāng"]],
    "此疆尔界": [["cǐ"], ["jiāng"], ["ěr"], ["jiè"]],
    "此起彼落": [["cǐ"], ["qǐ"], ["bǐ"], ["luò"]],
    "此问彼难": [["cǐ"], ["wèn"], ["bǐ"], ["nán"]],
    "此事体大": [["cǐ"], ["shì"], ["tǐ"], ["dà"]],
    "此中三昧": [["cǐ"], ["zhōng"], ["sān"], ["mèi"]],
    "次大陆": [["cì"], ["dà"], ["lù"]],
    "刺刺不休": [["cì"], ["cì"], ["bù"], ["xiū"]],
    "刺儿头": [["cì"], ["ér"], ["tóu"]],
    "刺股悬梁": [["cì"], ["gǔ"], ["xuán"], ["liáng"]],
    "刺股读书": [["cì"], ["gǔ"], ["dú"], ["shū"]],
    "刺虎持鹬": [["cì"], ["hǔ"], ["chí"], ["yù"]],
    "刺激素": [["cì"], ["jī"], ["sù"]],
    "刺激性": [["cì"], ["jī"], ["xìng"]],
    "刺上化下": [["cì"], ["shàng"], ["huà"], ["xià"]],
    "刺心刻骨": [["cì"], ["xīn"], ["kè"], ["gǔ"]],
    "刺心裂肝": [["cì"], ["xīn"], ["liè"], ["gān"]],
    "刺心切骨": [["cì"], ["xīn"], ["qiè"], ["gǔ"]],
    "从壁上观": [["cóng"], ["bì"], ["shàng"], ["guān"]],
    "从长计较": [["cóng"], ["cháng"], ["jì"], ["jiào"]],
    "从长计议": [["cóng"], ["cháng"], ["jì"], ["yì"]],
    "从长商议": [["cóng"], ["cháng"], ["shāng"], ["yì"]],
    "从从容容": [["cóng"], ["cóng"], ["róng"], ["róng"]],
    "从恶如崩": [["cóng"], ["è"], ["rú"], ["bēng"]],
    "从恶若崩": [["cóng"], ["è"], ["ruò"], ["bēng"]],
    "从恶是崩": [["cóng"], ["è"], ["shì"], ["bēng"]],
    "从风而服": [["cóng"], ["fēng"], ["ér"], ["fú"]],
    "从风而靡": [["cóng"], ["fēng"], ["ér"], ["mí"]],
    "从谏如流": [["cóng"], ["jiàn"], ["rú"], ["liú"]],
    "从井救人": [["cóng"], ["jǐng"], ["jiù"], ["rén"]],
    "从宽发落": [["cóng"], ["kuān"], ["fā"], ["luò"]],
    "从令如流": [["cóng"], ["lìng"], ["rú"], ["liú"]],
    "从流忘反": [["cóng"], ["liú"], ["wàng"], ["fǎn"]],
    "从轻发落": [["cóng"], ["qīng"], ["fā"], ["luò"]],
    "从容不迫": [["cóng"], ["róng"], ["bù"], ["pò"]],
    "从容就义": [["cóng"], ["róng"], ["jiù"], ["yì"]],
    "从容应对": [["cóng"], ["róng"], ["yìng"], ["duì"]],
    "从容自如": [["cóng"], ["róng"], ["zì"], ["rú"]],
    "从容自若": [["cóng"], ["róng"], ["zì"], ["ruò"]],
    "从善如登": [["cóng"], ["shàn"], ["rú"], ["dēng"]],
    "从善如流": [["cóng"], ["shàn"], ["rú"], ["liú"]],
    "从善若流": [["cóng"], ["shàn"], ["ruò"], ["liú"]],
    "从俗就简": [["cóng"], ["sú"], ["jiù"], ["jiǎ"]],
    "从俗浮沉": [["cóng"], ["sú"], ["fú"], ["chén"]],
    "从天而降": [["cóng"], ["tiān"], ["ér"], ["jiàng"]],
    "从头彻尾": [["cóng"], ["tóu"], ["chè"], ["wěi"]],
    "从天而下": [["cóng"], ["tiān"], ["ér"], ["xià"]],
    "从头到尾": [["cóng"], ["tóu"], ["dào"], ["wěi"]],
    "从头至尾": [["cóng"], ["tóu"], ["zhì"], ["wěi"]],
    "从心所欲": [["cóng"], ["xīn"], ["suǒ"], ["yù"]],
    "从一而终": [["cóng"], ["yī"], ["ér"], ["zhōng"]],
    "从中渔利": [["cóng"], ["zhōng"], ["yú"], ["lì"]],
    "从中作梗": [["cóng"], ["zhōng"], ["zuò"], ["gěng"]],
    "聪明反被聪明误": [["cōng"], ["míng"], ["fǎn"], ["bèi"], ["cōng"], ["míng"], ["wù"]],
    "聪明智能": [["cōng"], ["míng"], ["zhì"], ["néng"]],
    "聪明正直": [["cōng"], ["míng"], ["zhèng"], ["zhí"]],
    "丛轻折轴": [["cóng"], ["qīng"], ["zhé"], ["zhóu"]],
    "丛雀渊鱼": [["cóng"], ["què"], ["yuān"], ["yú"]],
    "丛山峻岭": [["cóng"], ["shān"], ["jùn"], ["lǐng"]],
    "凑份子": [["còu"], ["fèn"], ["zi"]],
    "粗风暴雨": [["cū"], ["fēng"], ["bào"], ["yǔ"]],
    "粗服乱头": [["cū"], ["fú"], ["luàn"], ["tóu"]],
    "粗袍粝食": [["cū"], ["páo"], ["lì"], ["shí"]],
    "粗心大意": [["cū"], ["xīn"], ["dà"], ["yì"]],
    "粗衣粝食": [["cū"], ["yī"], ["lì"], ["shí"]],
    "粗衣恶食": [["cū"], ["yī"], ["è"], ["shí"]],
    "粗枝大叶": [["cū"], ["zhī"], ["dà"], ["yè"]],
    "粗中有细": [["cū"], ["zhōng"], ["yǒu"], ["xì"]],
    "猝不及防": [["cù"], ["bù"], ["jí"], ["fáng"]],
    "踧踖不安": [["cù"], ["jí"], ["bù"], ["ān"]],
    "酢浆草": [["cù"], ["jiāng"], ["cǎo"]],
    "醋劲儿": [["cù"], ["jìn"], ["er"]],
    "蹙金结绣": [["cù"], ["jīn"], ["jié"], ["xiù"]],
    "催化剂": [["cuī"], ["huà"], ["jì"]],
    "催化裂化": [["cuī"], ["huà"], ["liè"], ["huà"]],
    "催泪弹": [["cuī"], ["lèi"], ["dàn"]],
    "催眠术": [["cuī"], ["mián"], ["shù"]],
    "催眠曲": [["cuī"], ["mián"], ["qǔ"]],
    "催吐剂": [["cuī"], ["tǔ"], ["jì"]],
    "摧枯拉腐": [["cuī"], ["kū"], ["lā"], ["fǔ"]],
    "摧刚为柔": [["cuī"], ["gāng"], ["wéi"], ["róu"]],
    "摧枯拉朽": [["cuī"], ["kū"], ["lā"], ["xiǔ"]],
    "摧枯折腐": [["cuī"], ["kū"], ["zhé"], ["fǔ"]],
    "摧兰折玉": [["cuī"], ["lán"], ["zhé"], ["yù"]],
    "摧眉折腰": [["cuī"], ["méi"], ["zhé"], ["yāo"]],
    "摧朽拉枯": [["cuī"], ["xiǔ"], ["lā"], ["kū"]],
    "摧折豪强": [["cuī"], ["zhé"], ["háo"], ["qiáng"]],
    "榱崩栋折": [["cuī"], ["bēng"], ["dòng"], ["shé"]],
    "榱栋崩折": [["cuī"], ["dòng"], ["bēng"], ["shé"]],
    "脆而不坚": [["cuì"], ["ér"], ["bù"], ["jiān"]],
    "啛啛喳喳": [["cuì"], ["cuì"], ["chā"], ["chā"]],
    "翠消红减": [["cuì"], ["xiāo"], ["hóng"], ["jiǎn"]],
    "村夫俗子": [["cūn"], ["fū"], ["sú"], ["zǐ"]],
    "村夫野老": [["cūn"], ["fū"], ["yě"], ["lǎo"]],
    "村生泊长": [["cūn"], ["shēng"], ["bó"], ["cháng"]],
    "村野匹夫": [["cūn"], ["yě"], ["pǐ"], ["fū"]],
    "村学究语": [["cūn"], ["xué"], ["jiū"], ["yǔ"]],
    "存车处": [["cún"], ["chē"], ["chù"]],
    "存而不论": [["cún"], ["ér"], ["bù"], ["lùn"]],
    "存款单": [["cún"], ["kuǎn"], ["dān"]],
    "存亡安危": [["cún"], ["wáng"], ["ān"], ["wēi"]],
    "存亡继绝": [["cún"], ["wáng"], ["jì"], ["jué"]],
    "存亡未卜": [["cún"], ["wáng"], ["wèi"], ["bǔ"]],
    "存亡绝续": [["cún"], ["wáng"], ["jué"], ["xù"]],
    "存亡续绝": [["cún"], ["wáng"], ["xù"], ["jué"]],
    "存心不良": [["cún"], ["xīn"], ["bù"], ["liáng"]],
    "寸兵尺铁": [["cùn"], ["bīng"], ["chǐ"], ["tiě"]],
    "寸步不让": [["cùn"], ["bù"], ["bù"], ["ràng"]],
    "寸步不离": [["cùn"], ["bù"], ["bù"], ["lí"]],
    "寸步难移": [["cùn"], ["bù"], ["nán"], ["yí"]],
    "寸步难行": [["cùn"], ["bù"], ["nán"], ["xíng"]],
    "寸草不生": [["cùn"], ["cǎo"], ["bù"], ["shēng"]],
    "寸草不留": [["cùn"], ["cǎo"], ["bù"], ["liú"]],
    "寸草衔结": [["cùn"], ["cǎo"], ["xián"], ["jié"]],
    "寸长尺短": [["cùn"], ["cháng"], ["chǐ"], ["duǎn"]],
    "寸长尺技": [["cùn"], ["cháng"], ["chǐ"], ["jì"]],
    "寸长片善": [["cùn"], ["cháng"], ["piàn"], ["shàn"]],
    "寸地尺天": [["cùn"], ["dì"], ["chǐ"], ["tiān"]],
    "寸积铢累": [["cùn"], ["jī"], ["zhū"], ["lěi"]],
    "寸劲儿": [["cùn"], ["jìn"], ["er"]],
    "寸进尺退": [["cùn"], ["jìn"], ["chǐ"], ["tuì"]],
    "寸量铢称": [["cùn"], ["liáng"], ["zhū"], ["chēng"]],
    "寸利必得": [["cùn"], ["lì"], ["bì"], ["dé"]],
    "寸男尺女": [["cùn"], ["nán"], ["chǐ"], ["nǚ"]],
    "寸善片长": [["cùn"], ["shàn"], ["piàn"], ["cháng"]],
    "寸丝不挂": [["cùn"], ["sī"], ["bù"], ["guà"]],
    "寸田尺宅": [["cùn"], ["tián"], ["chǐ"], ["zhái"]],
    "寸蹄尺缣": [["cùn"], ["tí"], ["chǐ"], ["jiān"]],
    "寸土不让": [["cùn"], ["tǔ"], ["bù"], ["ràng"]],
    "寸土尺地": [["cùn"], ["tǔ"], ["chǐ"], ["dì"]],
    "寸土尺金": [["cùn"], ["tǔ"], ["chǐ"], ["jīn"]],
    "寸阴若岁": [["cùn"], ["yīn"], ["ruò"], ["suì"]],
    "寸阴尺璧": [["cùn"], ["yīn"], ["chǐ"], ["bì"]],
    "寸有所长": [["cùn"], ["yǒu"], ["suǒ"], ["cháng"]],
    "撮科打哄": [["cuō"], ["kē"], ["dǎ"], ["hòng"]],
    "撮土焚香": [["cuō"], ["gǔ"], ["fén"], ["xiāng"]],
    "撮科打閧": [["cuō"], ["kē"], ["dǎ"], ["hòng"]],
    "撮盐入火": [["cuō"], ["yán"], ["rù"], ["huǒ"]],
    "撮盐入水": [["cuō"], ["yán"], ["rù"], ["shuǐ"]],
    "厝火燎原": [["cuò"], ["huǒ"], ["liǎo"], ["yuán"]],
    "挫骨扬灰": [["cuò"], ["gǔ"], ["yáng"], ["huī"]],
    "措手不及": [["cuò"], ["shǒu"], ["bù"], ["jí"]],
    "错别字": [["cuò"], ["bié"], ["zì"]],
    "错落不齐": [["cuò"], ["luò"], ["bù"], ["qí"]],
    "错节盘根": [["cuò"], ["jié"], ["pán"], ["gēn"]],
    "错落高下": [["cuò"], ["luò"], ["gāo"], ["xià"]],
    "错落有致": [["cuò"], ["luò"], ["yǒu"], ["zhì"]],
    "错综复杂": [["cuò"], ["zōng"], ["fù"], ["zá"]],
    "搭搭撒撒": [["dā"], ["dā"], ["sā"], ["sā"]],
    "搭街坊": [["dā"], ["jiē"], ["fāng"]],
    "嗒然若丧": [["tà"], ["rán"], ["ruò"], ["sàng"]],
    "达地知根": [["dá"], ["dì"], ["zhī"], ["gēn"]],
    "达官贵要": [["dá"], ["guān"], ["guì"], ["yào"]],
    "达官要人": [["dá"], ["guān"], ["yào"], ["rén"]],
    "达官知命": [["dá"], ["guān"], ["zhī"], ["mìng"]],
    "达赖喇嘛": [["dá"], ["lài"], ["lǎ"], ["mɑ"]],
    "达姆弹": [["dá"], ["mǔ"], ["dàn"]],
    "达权知变": [["dá"], ["quán"], ["zhī"], ["biàn"]],
    "达人知命": [["dá"], ["rén"], ["zhī"], ["mìng"]],
    "达斡尔族": [["dá"], ["wò"], ["ěr"], ["zú"]],
    "沓来麕至": [["tà"], ["lái"], ["yǒu"], ["zhì"]],
    "沓来踵至": [["tǎ"], ["lái"], ["zhǒng"], ["zhì"]],
    "沓冈复岭": [["tà"], ["gāng"], ["fù"], ["lǐng"]],
    "答茬儿": [["dá"], ["chá"], ["ér"]],
    "打把式": [["dǎ"], ["bǎ"], ["shì"]],
    "答非所问": [["dá"], ["fēi"], ["suǒ"], ["wèn"]],
    "打把势": [["dǎ"], ["bǎ"], ["shì"]],
    "打靶场": [["dǎ"], ["bǎ"], ["chǎng"]],
    "打摆子": [["dǎ"], ["bǎi"], ["zǐ"]],
    "打板子": [["dǎ"], ["bǎn"], ["zi"]],
    "打包票": [["dǎ"], ["bāo"], ["piào"]],
    "打抱不平": [["dǎ"], ["bào"], ["bù"], ["píng"]],
    "打边鼓": [["dǎ"], ["biān"], ["gǔ"]],
    "打不住": [["dǎ"], ["bú"], ["zhù"]],
    "打草惊蛇": [["dǎ"], ["cǎo"], ["jīng"], ["shé"]],
    "打赤膊": [["dǎ"], ["chì"], ["bó"]],
    "打草蛇惊": [["dǎ"], ["cǎo"], ["shé"], ["jīng"]],
    "打成一片": [["dǎ"], ["chéng"], ["yī"], ["piàn"]],
    "打冲锋": [["dǎ"], ["chōng"], ["fēng"]],
    "打得火热": [["dǎ"], ["dé"], ["huǒ"], ["rè"]],
    "打灯谜": [["dǎ"], ["dēng"], ["mí"]],
    "打底子": [["dǎ"], ["dǐ"], ["zi"]],
    "打电话": [["dǎ"], ["diàn"], ["huà"]],
    "打电报": [["dǎ"], ["diàn"], ["bào"]],
    "打短工": [["dǎ"], ["duǎn"], ["gōng"]],
    "打趸儿": [["dǎ"], ["dǔn"], ["ér"]],
    "打哆嗦": [["dǎ"], ["duō"], ["suo"]],
    "打耳光": [["dǎ"], ["ěr"], ["guāng"]],
    "打翻身仗": [["dǎ"], ["fān"], ["shēn"], ["zhàng"]],
    "打凤捞龙": [["dǎ"], ["fèng"], ["lāo"], ["lóng"]],
    "打凤牢龙": [["dǎ"], ["fèng"], ["láo"], ["lóng"]],
    "打富济贫": [["dǎ"], ["fù"], ["jì"], ["pín"]],
    "打工妹": [["dǎ"], ["gōng"], ["mèi"]],
    "打工仔": [["dǎ"], ["gōng"], ["zǎi"]],
    "打恭作揖": [["dǎ"], ["gōng"], ["zuò"], ["yī"]],
    "打躬作揖": [["dǎ"], ["gōng"], ["zuō"], ["yī"]],
    "打拱作揖": [["dǎ"], ["gǒng"], ["zuò"], ["yī"]],
    "打狗看主": [["dǎ"], ["gǒu"], ["kàn"], ["zhǔ"]],
    "打官腔": [["dǎ"], ["guān"], ["qiāng"]],
    "打谷场": [["dǎ"], ["gǔ"], ["chǎng"]],
    "打官司": [["dǎ"], ["guān"], ["sī"]],
    "打光棍": [["dǎ"], ["guāng"], ["gùn"]],
    "打滚撒泼": [["dǎ"], ["gǔn"], ["sā"], ["pō"]],
    "打棍子": [["dǎ"], ["gùn"], ["zi"]],
    "打哈哈": [["dǎ"], ["hā"], ["hā"]],
    "打寒战": [["dǎ"], ["hán"], ["zhàn"]],
    "打呼噜": [["dǎ"], ["hū"], ["lū"]],
    "打虎牢龙": [["dǎ"], ["hǔ"], ["láo"], ["lóng"]],
    "打呵欠": [["dǎ"], ["hē"], ["qiàn"]],
    "打诨插科": [["dǎ"], ["hùn"], ["chā"], ["kē"]],
    "打火机": [["dǎ"], ["huǒ"], ["jī"]],
    "打击报复": [["dǎ"], ["jī"], ["bào"], ["fù"]],
    "打击乐器": [["dǎ"], ["jī"], ["yuè"], ["qì"]],
    "打鸡骂狗": [["dǎ"], ["jī"], ["mà"], ["gǒu"]],
    "打基础": [["dǎ"], ["jī"], ["chǔ"]],
    "打家劫舍": [["dǎ"], ["jiā"], ["jié"], ["shè"]],
    "打家截道": [["dǎ"], ["jiā"], ["jié"], ["dào"]],
    "打家截舍": [["dǎ"], ["jiā"], ["jié"], ["shě"]],
    "打交道": [["dǎ"], ["jiāo"], ["dào"]],
    "打街骂巷": [["dǎ"], ["jiē"], ["mà"], ["xiàng"]],
    "打瞌睡": [["dǎ"], ["kē"], ["shuì"]],
    "打开天窗说亮话": [["dǎ"], ["kāi"], ["tiān"], ["chuāng"], ["liàng"], ["huà"]],
    "打擂台": [["dǎ"], ["lèi"], ["tái"]],
    "打冷枪": [["dǎ"], ["lěng"], ["qiāng"]],
    "打冷战": [["dǎ"], ["lěng"], ["zhàn"]],
    "打落水狗": [["dǎ"], ["luò"], ["shuǐ"], ["gǒu"]],
    "打马虎眼": [["dǎ"], ["mǎ"], ["hu"], ["yǎn"]],
    "打埋伏": [["dǎ"], ["mái"], ["fú"]],
    "打毛衣": [["dǎ"], ["máo"], ["yī"]],
    "打闷葫芦": [["dǎ"], ["mèn"], ["hú"], ["lu"]],
    "打鸣儿": [["dǎ"], ["míng"], ["ér"]],
    "打拍子": [["dǎ"], ["pāi"], ["zi"]],
    "打喷嚏": [["dǎ"], ["pēn"], ["tì"]],
    "打破常规": [["dǎ"], ["pò"], ["cháng"], ["guī"]],
    "打破迷关": [["dǎ"], ["pò"], ["mí"], ["guān"]],
    "打破砂锅问到底": [["dǎ"], ["pò"], ["shā"], ["guō"], ["wèn"], ["dào"], ["dǐ"]],
    "打破沙锅问到底": [["dǎ"], ["pò"], ["shā"], ["guō"], ["wèn"], ["dào"], ["dǐ"]],
    "打前站": [["dǎ"], ["qián"], ["zhàn"]],
    "打情骂俏": [["dǎ"], ["qíng"], ["mà"], ["qiào"]],
    "打情骂趣": [["dǎ"], ["qíng"], ["mà"], ["qù"]],
    "打情卖笑": [["dǎ"], ["qíng"], ["mài"], ["xiào"]],
    "打秋风": [["dǎ"], ["qiū"], ["fēng"]],
    "打圈子": [["dǎ"], ["quān"], ["zi"]],
    "打群架": [["dǎ"], ["qún"], ["jià"]],
    "打人骂狗": [["dǎ"], ["rén"], ["mà"], ["gǒu"]],
    "打入冷宫": [["dǎ"], ["rù"], ["lěng"], ["gōng"]],
    "打蛇打七寸": [["dǎ"], ["shé"], ["dǎ"], ["qī"], ["cùn"]],
    "打手式": [["dǎ"], ["shǒu"], ["shì"]],
    "打手势": [["dǎ"], ["shǒu"], ["shì"]],
    "打死虎": [["dǎ"], ["sǐ"], ["hǔ"]],
    "打算盘": [["dǎ"], ["suàn"], ["pán"]],
    "打天下": [["dǎ"], ["tiān"], ["xià"]],
    "打铁趁热": [["dǎ"], ["tiě"], ["chèn"], ["rè"]],
    "打挺儿": [["dǎ"], ["tǐng"], ["ér"]],
    "打通关": [["dǎ"], ["tōng"], ["guān"]],
    "打头炮": [["dǎ"], ["tóu"], ["pào"]],
    "打头风": [["dǎ"], ["tóu"], ["fēng"]],
    "打头阵": [["dǎ"], ["tóu"], ["zhèn"]],
    "打退堂鼓": [["dǎ"], ["tuì"], ["táng"], ["gǔ"]],
    "打问号": [["dǎ"], ["wèn"], ["hào"]],
    "打先锋": [["dǎ"], ["xiān"], ["fēng"]],
    "打下手": [["dǎ"], ["xià"], ["shǒu"]],
    "打小报告": [["dǎ"], ["xiǎo"], ["bào"], ["gào"]],
    "打鸭惊鸳": [["dǎ"], ["yā"], ["jīng"], ["yuān"]],
    "打小算盘": [["dǎ"], ["xiǎo"], ["suàn"], ["pán"]],
    "打雪仗": [["dǎ"], ["xuě"], ["zhàng"]],
    "打鸭惊鸳鸯": [["dǎ"], ["yā"], ["jīng"], ["yuān"], ["yāng"]],
    "打牙犯嘴": [["dǎ"], ["yá"], ["fàn"], ["zuǐ"]],
    "打鸭子上架": [["dǎ"], ["yā"], ["zi"], ["shàng"], ["jià"]],
    "打牙祭": [["dǎ"], ["yá"], ["jì"]],
    "打牙配嘴": [["dǎ"], ["yá"], ["pèi"], ["zuǐ"]],
    "打蔫儿": [["dǎ"], ["niān"], ["ér"]],
    "打掩护": [["dǎ"], ["yǎn"], ["hù"]],
    "打印机": [["dǎ"], ["yìn"], ["jī"]],
    "打油诗": [["dǎ"], ["yóu"], ["shī"]],
    "打游击": [["dǎ"], ["yóu"], ["jī"]],
    "打圆场": [["dǎ"], ["yuán"], ["chǎng"]],
    "打砸抢": [["dǎ"], ["zá"], ["qiǎng"]],
    "打招呼": [["dǎ"], ["zhāo"], ["hū"]],
    "打折扣": [["dǎ"], ["zhé"], ["kòu"]],
    "打肿脸充胖子": [["dǎ"], ["zhǒng"], ["liǎn"], ["chōng"], ["pàng"], ["zī"]],
    "打主意": [["dǎ"], ["zhǔ"], ["yì"]],
    "打桩机": [["dǎ"], ["zhuāng"], ["jī"]],
    "打桩船": [["dǎ"], ["zhuāng"], ["chuán"]],
    "打字机": [["dǎ"], ["zì"], ["jī"]],
    "打嘴仗": [["dǎ"], ["zuǐ"], ["zhàng"]],
    "大白菜": [["dà"], ["bái"], ["cài"]],
    "大白话": [["dà"], ["bái"], ["huà"]],
    "大白鼠": [["dà"], ["bái"], ["shǔ"]],
    "大败亏轮": [["dà"], ["bài"], ["kuī"], ["lún"]],
    "大败亏输": [["dà"], ["bài"], ["kuī"], ["shū"]],
    "大板车": [["dà"], ["bǎn"], ["chē"]],
    "大半天": [["dà"], ["bàn"], ["tiān"]],
    "大包大揽": [["dà"], ["bāo"], ["dà"], ["lǎn"]],
    "大包干": [["dà"], ["bāo"], ["gān"]],
    "大堡礁": [["dà"], ["pù"], ["jiāo"]],
    "大本大宗": [["dà"], ["běn"], ["dà"], ["zōng"]],
    "大本营": [["dà"], ["běn"], ["yíng"]],
    "大笔如椽": [["dà"], ["bǐ"], ["rú"], ["chuán"]],
    "大辩不言": [["dà"], ["biàn"], ["bù"], ["yán"]],
    "大辩若讷": [["dà"], ["biàn"], ["ruò"], ["nè"]],
    "大别山": [["dà"], ["bié"], ["shān"]],
    "大脖子病": [["dà"], ["bó"], ["zi"], ["bìng"]],
    "大伯子": [["dà"], ["bǎi"], ["zǐ"]],
    "大不敬": [["dà"], ["bù"], ["jìng"]],
    "大不了": [["dà"], ["bù"], ["liǎo"]],
    "大步流星": [["dǎ"], ["bù"], ["liú"], ["xīng"]],
    "大部分": [["dà"], ["bù"], ["fèn"]],
    "大部头": [["dà"], ["bù"], ["tóu"]],
    "大才榱盘": [["dà"], ["cái"], ["cuī"], ["pán"]],
    "大才榱槃": [["dà"], ["cái"], ["cuī"], ["pán"]],
    "大才盘盘": [["dà"], ["cái"], ["pán"], ["pán"]],
    "大才槃槃": [["dà"], ["cái"], ["pán"], ["pán"]],
    "大材小用": [["dà"], ["cái"], ["xiǎo"], ["yòng"]],
    "大藏经": [["dà"], ["zàng"], ["jīng"]],
    "大肠杆菌": [["dà"], ["cháng"], ["gǎn"], ["jūn"]],
    "大吵大闹": [["dà"], ["chǎo"], ["dà"], ["nào"]],
    "大车以载": [["dà"], ["chē"], ["yǐ"], ["zài"]],
    "大澈大悟": [["dà"], ["chè"], ["dà"], ["wù"]],
    "大彻大悟": [["dà"], ["chè"], ["dà"], ["wù"]],
    "大城市": [["dài"], ["chéng"], ["shì"]],
    "大吃大喝": [["dà"], ["chī"], ["dà"], ["hè"]],
    "大吃一惊": [["dà"], ["chī"], ["yī"], ["jīng"]],
    "大处着墨": [["dà"], ["chù"], ["zhuó"], ["mò"]],
    "大处落墨": [["dà"], ["chù"], ["luò"], ["mò"]],
    "大出血": [["dà"], ["chū"], ["xuè"]],
    "大处着眼": [["dà"], ["chù"], ["zhuó"], ["yǎn"]],
    "大吹大打": [["dà"], ["chuī"], ["dà"], ["dǎ"]],
    "大吹大擂": [["dà"], ["chuī"], ["dà"], ["léi"]],
    "大吹法螺": [["dà"], ["chuī"], ["fǎ"], ["luó"]],
    "大醇小疵": [["dà"], ["chún"], ["xiǎo"], ["cī"]],
    "大慈大悲": [["dà"], ["cí"], ["dà"], ["bēi"]],
    "大错特错": [["dà"], ["cuò"], ["tè"], ["cuò"]],
    "大打出手": [["dà"], ["dǎ"], ["chū"], ["shǒu"]],
    "大大咧咧": [["dà"], ["dà"], ["liē"], ["liē"]],
    "大大落落": [["dà"], ["dà"], ["luò"], ["luò"]],
    "大胆包身": [["dà"], ["dǎn"], ["bāo"], ["shēn"]],
    "大刀阔斧": [["dà"], ["dāo"], ["kuò"], ["fǔ"]],
    "大道理": [["dà"], ["dào"], ["lǐ"]],
    "大得人心": [["dà"], ["dé"], ["rén"], ["xīn"]],
    "大敌当前": [["dà"], ["dí"], ["dāng"], ["qián"]],
    "大地测量": [["dà"], ["dì"], ["cè"], ["liáng"]],
    "大地回春": [["dà"], ["dì"], ["huí"], ["chūn"]],
    "大地春回": [["dà"], ["dì"], ["chūn"], ["huí"]],
    "大动肝火": [["dà"], ["dòng"], ["gān"], ["huǒ"]],
    "大动干戈": [["dà"], ["dòng"], ["gān"], ["gē"]],
    "大动公惯": [["dà"], ["dòng"], ["gōng"], ["guàn"]],
    "大动脉": [["dà"], ["dòng"], ["mài"]],
    "大动作": [["dà"], ["dòng"], ["zuò"]],
    "大都会": [["dà"], ["dū"], ["huì"]],
    "大独裁者": [["dà"], ["dú"], ["cái"], ["zhě"]],
    "大度包容": [["dà"], ["dù"], ["bāo"], ["róng"]],
    "大肚子": [["dà"], ["dǔ"], ["zi"]],
    "大渡河": [["dà"], ["dù"], ["hé"]],
    "大恩大德": [["dà"], ["ēn"], ["dà"], ["dé"]],
    "大多数": [["dà"], ["duō"], ["shù"]],
    "大而化之": [["dà"], ["ér"], ["huà"], ["zhī"]],
    "大发慈悲": [["dà"], ["fā"], ["cí"], ["bēi"]],
    "大而无当": [["dà"], ["ér"], ["wú"], ["dàng"]],
    "大发雷霆": [["dà"], ["fā"], ["léi"], ["tíng"]],
    "大发议论": [["dà"], ["fā"], ["yì"], ["lùn"]],
    "大发谬论": [["dà"], ["fā"], ["miù"], ["lùn"]],
    "大法小廉": [["dà"], ["fǎ"], ["xiǎo"], ["lián"]],
    "大方向": [["dà"], ["fāng"], ["xiàng"]],
    "大方之家": [["dà"], ["fāng"], ["zhī"], ["jiā"]],
    "大放悲声": [["dà"], ["fàng"], ["bēi"], ["shēng"]],
    "大放厥词": [["dà"], ["fàng"], ["jué"], ["cí"]],
    "大放厥辞": [["dà"], ["fàng"], ["jué"], ["cí"]],
    "大风大浪": [["dà"], ["fēng"], ["dà"], ["làng"]],
    "大风歌": [["dà"], ["fēng"], ["gē"]],
    "大腹便便": [["dà"], ["fù"], ["pián"], ["pián"]],
    "大概其": [["dà"], ["gài"], ["qí"]],
    "大哥大": [["dà"], ["gē"], ["dà"]],
    "大革命": [["dà"], ["gé"], ["mìng"]],
    "大工告成": [["dà"], ["gōng"], ["gào"], ["chéng"]],
    "大个子": [["dà"], ["gè"], ["zi"]],
    "大公报": [["dà"], ["gōng"], ["bào"]],
    "大公无私": [["dà"], ["gōng"], ["wú"], ["sī"]],
    "大功毕成": [["dà"], ["gōng"], ["bì"], ["chéng"]],
    "大功告成": [["dà"], ["gōng"], ["gào"], ["chéng"]],
    "大姑娘": [["dà"], ["gū"], ["niáng"]],
    "大姑子": [["dà"], ["gū"], ["zǐ"]],
    "大骨节病": [["dà"], ["gǔ"], ["jié"], ["bìng"]],
    "大海捞针": [["dà"], ["hǎi"], ["lāo"], ["zhēn"]],
    "大锅饭": [["dà"], ["guō"], ["fàn"]],
    "大含细入": [["dà"], ["hán"], ["xì"], ["rù"]],
    "大寒索裘": [["dà"], ["hán"], ["suǒ"], ["qiú"]],
    "大喊大叫": [["dà"], ["hǎn"], ["dà"], ["jiào"]],
    "大汉族主义": [["dà"], ["hàn"], ["zú"], ["zhǔ"], ["yì"]],
    "大旱望云霓": [["dà"], ["hàn"], ["wàng"], ["yún"], ["ní"]],
    "大旱望云": [["dà"], ["hàn"], ["wàng"], ["yún"]],
    "大好河山": [["dà"], ["hǎo"], ["hé"], ["shān"]],
    "大合唱": [["dà"], ["hé"], ["chàng"]],
    "大轰大嗡": [["dà"], ["hōng"], ["dà"], ["wēng"]],
    "大红大绿": [["dà"], ["hóng"], ["dà"], ["lǜ"]],
    "大红大紫": [["dà"], ["hóng"], ["dà"], ["zǐ"]],
    "大后方": [["dà"], ["hòu"], ["fāng"]],
    "大后天": [["dà"], ["hòu"], ["tiān"]],
    "大后年": [["dà"], ["hòu"], ["nián"]],
    "大呼隆": [["dà"], ["hū"], ["lóng"]],
    "大呼小喝": [["dà"], ["hū"], ["xiǎo"], ["hē"]],
    "大呼小叫": [["dà"], ["hū"], ["xiǎo"], ["jiào"]],
    "大花脸": [["dà"], ["huā"], ["liǎn"]],
    "大换血": [["dà"], ["huàn"], ["xuè"]],
    "大黄鱼": [["dài"], ["huáng"], ["yú"]],
    "大茴香": [["dà"], ["huí"], ["xiāng"]],
    "大获全胜": [["dà"], ["huò"], ["quán"], ["shèng"]],
    "大惑不解": [["dà"], ["huò"], ["bù"], ["jiě"]],
    "大吉大利": [["dà"], ["jí"], ["dà"], ["lì"]],
    "大计小用": [["dà"], ["jì"], ["xiǎo"], ["yòng"]],
    "大家风范": [["dà"], ["jiā"], ["fēng"], ["fàn"]],
    "大家伙": [["dà"], ["jiā"], ["huo"]],
    "大家闺秀": [["dà"], ["jiā"], ["guī"], ["xiù"]],
    "大家庭": [["dà"], ["jiā"], ["tíng"]],
    "大江东去": [["dà"], ["jiāng"], ["dōng"], ["qù"]],
    "大渐弥留": [["dà"], ["jiàn"], ["mí"], ["liú"]],
    "大江南北": [["dà"], ["jiāng"], ["nán"], ["běi"]],
    "大将军": [["dà"], ["jiàng"], ["jūn"]],
    "大匠运斤": [["dà"], ["jiàng"], ["yùn"], ["jīn"]],
    "大教堂": [["dà"], ["jiào"], ["táng"]],
    "大街小巷": [["dà"], ["jiē"], ["xiǎo"], ["xiàng"]],
    "大节不夺": [["dà"], ["jié"], ["bù"], ["duó"]],
    "大经大法": [["dà"], ["jīng"], ["dà"], ["fǎ"]],
    "大惊失色": [["dà"], ["jīng"], ["shī"], ["sè"]],
    "大惊小怪": [["dà"], ["jīng"], ["xiǎo"], ["guài"]],
    "大舅子": [["dà"], ["jiù"], ["zǐ"]],
    "大开大合": [["dà"], ["kāi"], ["dà"], ["hé"]],
    "大开方便之门": [["dà"], ["kāi"], ["fāng"], ["biàn"], ["zhī"], ["mén"]],
    "大开眼界": [["dà"], ["kāi"], ["yǎn"], ["jiè"]],
    "大客车": [["dà"], ["kè"], ["chē"]],
    "大块头": [["dà"], ["kuài"], ["tóu"]],
    "大块文章": [["dà"], ["kuài"], ["wén"], ["zhāng"]],
    "大快人心": [["dà"], ["kuài"], ["rén"], ["xīn"]],
    "大浪淘沙": [["dà"], ["làng"], ["táo"], ["shā"]],
    "大老粗": [["dà"], ["lǎo"], ["cū"]],
    "大老婆": [["dà"], ["lǎo"], ["pó"]],
    "大老爷们儿": [["dà"], ["lǎo"], ["yé"], ["men"], ["ér"]],
    "大老远": [["dà"], ["lǎo"], ["yuǎn"]],
    "大礼拜": [["dà"], ["lǐ"], ["bài"]],
    "大礼服": [["dà"], ["lǐ"], ["fú"]],
    "大礼堂": [["dà"], ["lǐ"], ["táng"]],
    "大理石": [["dà"], ["lǐ"], ["shí"]],
    "大理市": [["dà"], ["lǐ"], ["shì"]],
    "大理寺": [["dà"], ["lǐ"], ["sì"]],
    "大力士": [["dà"], ["lì"], ["shì"]],
    "大丽花": [["dà"], ["lì"], ["huā"]],
    "大连理工大学": [["dà"], ["lián"], ["lǐ"], ["gōng"], ["dà"], ["xué"]],
    "大连市": [["dà"], ["lián"], ["shì"]],
    "大陆架": [["dà"], ["lù"], ["jià"]],
    "大陆坡": [["dà"], ["lù"], ["pō"]],
    "大辂椎轮": [["dà"], ["lù"], ["zhuī"], ["lún"]],
    "大陆性气候": [["dà"], ["lù"], ["xìng"], ["qì"], ["hòu"]],
    "大路活": [["dà"], ["lù"], ["huó"]],
    "大路椎轮": [["dà"], ["lù"], ["zhuī"], ["lún"]],
    "大路货": [["dà"], ["lù"], ["huò"]],
    "大麻哈鱼": [["dà"], ["má"], ["hā"], ["yú"]],
    "大马哈鱼": [["dà"], ["mǎ"], ["hā"], ["yú"]],
    "大马金刀": [["dà"], ["mǎ"], ["jīn"], ["dāo"]],
    "大马士革": [["dà"], ["mǎ"], ["shì"], ["gé"]],
    "大帽子": [["dà"], ["mào"], ["zi"]],
    "大梦方醒": [["dà"], ["mèng"], ["fāng"], ["xǐng"]],
    "大梦初醒": [["dà"], ["mèng"], ["chū"], ["xǐng"]],
    "大名鼎鼎": [["dà"], ["míng"], ["dǐng"], ["dǐng"]],
    "大名难居": [["dà"], ["míng"], ["nán"], ["jū"]],
    "大明法度": [["dà"], ["jíng"], ["fǎ"], ["dù"]],
    "大谬不然": [["dà"], ["miù"], ["bù"], ["rán"]],
    "大缪不然": [["dà"], ["miù"], ["bù"], ["rán"]],
    "大模大样": [["dà"], ["mó"], ["dà"], ["yàng"]],
    "大莫与京": [["dà"], ["mò"], ["yǔ"], ["jīng"]],
    "大谋不谋": [["dà"], ["móu"], ["bù"], ["móu"]],
    "大拇哥": [["dà"], ["mǔ"], ["gē"]],
    "大拇指": [["dà"], ["mǔ"], ["zhǐ"]],
    "大男大女": [["dà"], ["nán"], ["dà"], ["nǚ"]],
    "大难不死": [["dà"], ["nàn"], ["bù"], ["sǐ"]],
    "大难临头": [["dà"], ["nàn"], ["lín"], ["tóu"]],
    "大脑皮层": [["dà"], ["nǎo"], ["pí"], ["céng"]],
    "大脑皮质": [["dà"], ["nǎo"], ["pí"], ["zhì"]],
    "大脑炎": [["dà"], ["nǎo"], ["yán"]],
    "大逆不道": [["dà"], ["nì"], ["bù"], ["dào"]],
    "大逆无道": [["dà"], ["nì"], ["wú"], ["dào"]],
    "大年初一": [["dà"], ["nián"], ["chū"], ["yī"]],
    "大年三十": [["dà"], ["nián"], ["sān"], ["shí"]],
    "大年夜": [["dà"], ["nián"], ["yè"]],
    "大璞不完": [["tài"], ["bú"], ["bù"], ["wán"]],
    "大气磅礴": [["dà"], ["qì"], ["páng"], ["bó"]],
    "大起大落": [["dà"], ["qǐ"], ["dà"], ["luò"]],
    "大气层": [["dà"], ["qì"], ["céng"]],
    "大气圈": [["dà"], ["qì"], ["quān"]],
    "大气污染": [["dà"], ["qì"], ["wū"], ["rǎn"]],
    "大气压": [["dà"], ["qì"], ["yā"]],
    "大器晚成": [["dà"], ["qì"], ["wǎn"], ["chéng"]],
    "大千世界": [["dà"], ["qiān"], ["shì"], ["jiè"]],
    "大前年": [["dà"], ["qián"], ["nián"]],
    "大前提": [["dà"], ["qián"], ["tí"]],
    "大前天": [["dà"], ["qián"], ["tiān"]],
    "大巧若拙": [["dà"], ["qiǎo"], ["ruò"], ["zhuō"]],
    "大清早": [["dà"], ["qīng"], ["zǎo"]],
    "大晴天": [["dà"], ["qíng"], ["tiān"]],
    "大请大受": [["dà"], ["qǐng"], ["dà"], ["shòu"]],
    "大庆市": [["dà"], ["qìng"], ["shì"]],
    "大庆油田": [["dà"], ["qìng"], ["yóu"], ["tián"]],
    "大秋作物": [["dà"], ["qiū"], ["zuò"], ["wù"]],
    "大权独揽": [["dà"], ["quán"], ["dú"], ["lǎn"]],
    "大权旁落": [["dà"], ["quán"], ["páng"], ["luò"]],
    "大权在握": [["dà"], ["quán"], ["zài"], ["wò"]],
    "大人物": [["dà"], ["rén"], ["wù"]],
    "大人先生": [["dà"], ["rén"], ["xiān"], ["sheng"]],
    "大仁大义": [["dà"], ["rén"], ["dà"], ["yì"]],
    "大扫除": [["dà"], ["sǎo"], ["chú"]],
    "大嫂子": [["dà"], ["sǎo"], ["zi"]],
    "大杀风景": [["dà"], ["shā"], ["fēng"], ["jǐng"]],
    "大煞风景": [["dà"], ["shā"], ["fēng"], ["jǐng"]],
    "大煞风趣": [["dà"], ["shà"], ["fēng"], ["qù"]],
    "大少爷": [["dà"], ["shào"], ["yé"]],
    "大舌头": [["dà"], ["shé"], ["tou"]],
    "大婶儿": [["dà"], ["shěn"], ["ér"]],
    "大声疾呼": [["dà"], ["shēng"], ["jí"], ["hū"]],
    "大牲畜": [["dà"], ["shēng"], ["chù"]],
    "大失人望": [["dà"], ["shī"], ["rén"], ["wàng"]],
    "大失所望": [["dà"], ["shī"], ["suǒ"], ["wàng"]],
    "大师傅": [["dà"], ["shī"], ["fū"]],
    "大使馆": [["dà"], ["shǐ"], ["guǎn"]],
    "大世界": [["dà"], ["shì"], ["jiè"]],
    "大事不糊涂": [["dà"], ["shì"], ["bù"], ["hú"], ["tú"]],
    "大事记": [["dà"], ["shì"], ["jì"]],
    "大事铺张": [["dà"], ["shì"], ["pū"], ["zhāng"]],
    "大事去矣": [["dà"], ["shì"], ["qù"], ["yǐ"]],
    "大势所趋": [["dà"], ["shì"], ["suǒ"], ["qū"]],
    "大势已去": [["dà"], ["shì"], ["yǐ"], ["qù"]],
    "大是大非": [["dà"], ["shì"], ["dà"], ["fēi"]],
    "大手笔": [["dà"], ["shǒu"], ["bǐ"]],
    "大手大脚": [["dà"], ["shǒu"], ["dà"], ["jiǎo"]],
    "大手术": [["dà"], ["shǒu"], ["shù"]],
    "大书特书": [["dà"], ["shū"], ["tè"], ["shū"]],
    "大树将军": [["dà"], ["shù"], ["jiāng"], ["jūn"]],
    "大司马": [["dà"], ["sī"], ["mǎ"]],
    "大肆挥霍": [["dà"], ["sì"], ["huī"], ["huò"]],
    "大肆宣传": [["dà"], ["sì"], ["xuān"], ["chuán"]],
    "大肆厥辞": [["dà"], ["sì"], ["jué"], ["cí"]],
    "大踏步": [["dà"], ["tà"], ["bù"]],
    "大提琴": [["dà"], ["tí"], ["qín"]],
    "大题小作": [["dà"], ["tí"], ["xiǎo"], ["zuò"]],
    "大题小做": [["dà"], ["tí"], ["xiǎo"], ["zuò"]],
    "大天白日": [["dà"], ["tiān"], ["bái"], ["rì"]],
    "大田作物": [["dà"], ["tián"], ["zuò"], ["wù"]],
    "大廷广众": [["dà"], ["tíng"], ["guǎng"], ["zhòng"]],
    "大庭广众": [["dà"], ["tíng"], ["guǎng"], ["zhòng"]],
    "大同江": [["dà"], ["tóng"], ["jiāng"]],
    "大同市": [["dà"], ["tóng"], ["shì"]],
    "大同小异": [["dà"], ["tóng"], ["xiǎo"], ["yì"]],
    "大头菜": [["dà"], ["tóu"], ["cài"]],
    "大头小尾": [["dà"], ["tóu"], ["xiǎo"], ["wěi"]],
    "大头鱼": [["dà"], ["tóu"], ["yú"]],
    "大头针": [["dà"], ["tóu"], ["zhēn"]],
    "大团结": [["dà"], ["tuán"], ["jié"]],
    "大团圆": [["dà"], ["tuán"], ["yuán"]],
    "大碗茶": [["dà"], ["wǎn"], ["chá"]],
    "大五金": [["dà"], ["wǔ"], ["jīn"]],
    "大无畏": [["dà"], ["wú"], ["wèi"]],
    "大西北": [["dà"], ["xī"], ["běi"]],
    "大西洋": [["dà"], ["xī"], ["yáng"]],
    "大喜过望": [["dà"], ["xǐ"], ["guò"], ["wàng"]],
    "大喜若狂": [["dā"], ["xǐ"], ["ruò"], ["kuáng"]],
    "大厦栋梁": [["dà"], ["shà"], ["dòng"], ["liáng"]],
    "大厦将颠": [["dà"], ["shà"], ["jiāng"], ["diān"]],
    "大显身手": [["dà"], ["xiǎn"], ["shēn"], ["shǒu"]],
    "大厦将倾": [["dà"], ["shà"], ["jiāng"], ["qīng"]],
    "大显神通": [["dà"], ["xiǎn"], ["shén"], ["tōng"]],
    "大相径庭": [["dà"], ["xiāng"], ["jìng"], ["tíng"]],
    "大相迳庭": [["dà"], ["xiāng"], ["jìng"], ["tíng"]],
    "大小姐": [["dà"], ["xiǎo"], ["jiě"]],
    "大卸八块": [["dà"], ["xiè"], ["bā"], ["kuài"]],
    "大兴土木": [["dà"], ["xīng"], ["tǔ"], ["mù"]],
    "大兴安岭": [["dà"], ["xīng"], ["ān"], ["lǐng"]],
    "大猩猩": [["dà"], ["xīng"], ["xīng"]],
    "大行大市": [["dà"], ["háng"], ["dà"], ["shì"]],
    "大行星": [["dà"], ["háng"], ["xīng"]],
    "大雄宝殿": [["dà"], ["xióng"], ["bǎo"], ["diàn"]],
    "大熊猫": [["dà"], ["xióng"], ["māo"]],
    "大熊座": [["dà"], ["xióng"], ["zuò"]],
    "大学生": [["dà"], ["xué"], ["shēng"]],
    "大学士": [["dà"], ["xué"], ["shì"]],
    "大雪山": [["dà"], ["xuě"], ["shān"]],
    "大雅君子": [["dà"], ["yǎ"], ["jūn"], ["zǐ"]],
    "大循环": [["dà"], ["xún"], ["huán"]],
    "大雅之堂": [["dà"], ["yǎ"], ["zhī"], ["táng"]],
    "大烟鬼": [["dà"], ["yān"], ["guǐ"]],
    "大言不惭": [["dà"], ["yán"], ["bù"], ["cán"]],
    "大眼瞪小眼": [["dà"], ["yǎn"], ["dèng"], ["xiǎo"], ["yǎn"]],
    "大眼望小眼": [["dà"], ["yǎn"], ["wàng"], ["xiǎo"], ["yǎn"]],
    "大洋洲": [["dà"], ["yáng"], ["zhōu"]],
    "大吆小喝": [["dà"], ["yāo"], ["xiǎo"], ["hē"]],
    "大摇大摆": [["dà"], ["yáo"], ["dà"], ["bǎi"]],
    "大一统": [["dà"], ["yī"], ["tǒng"]],
    "大姨子": [["dà"], ["yí"], ["zǐ"]],
    "大义凛然": [["dà"], ["yì"], ["lǐn"], ["rán"]],
    "大义灭亲": [["dà"], ["yì"], ["miè"], ["qīn"]],
    "大音希声": [["dà"], ["yīn"], ["xī"], ["shēng"]],
    "大勇若怯": [["dà"], ["yǒng"], ["ruò"], ["qiè"]],
    "大有见地": [["dà"], ["yǒu"], ["jiàn"], ["dì"]],
    "大有裨益": [["dà"], ["yǒu"], ["bì"], ["yì"]],
    "大有径庭": [["dà"], ["yǒu"], ["jìng"], ["tíng"]],
    "大有迳庭": [["dà"], ["yǒu"], ["jìng"], ["tíng"]],
    "大有可观": [["dà"], ["yǒu"], ["kě"], ["guān"]],
    "大有可为": [["dà"], ["yǒu"], ["kě"], ["wéi"]],
    "大有起色": [["dà"], ["yǒu"], ["qǐ"], ["sè"]],
    "大有人在": [["dà"], ["yǒu"], ["rén"], ["zài"]],
    "大有文章": [["dà"], ["yǒu"], ["wén"], ["zhāng"]],
    "大有希望": [["dà"], ["yǒu"], ["xī"], ["wàng"]],
    "大有作为": [["dà"], ["yǒu"], ["zuò"], ["wéi"]],
    "大鱼吃小鱼": [["dà"], ["yú"], ["chī"], ["xiǎo"], ["yú"]],
    "大雨滂沱": [["dà"], ["yǔ"], ["páng"], ["tuó"]],
    "大雨倾盆": [["dà"], ["yǔ"], ["qīng"], ["pén"]],
    "大雨如注": [["dà"], ["yǔ"], ["rú"], ["zhù"]],
    "大元帅": [["dà"], ["yuán"], ["shuài"]],
    "大禹治水": [["dà"], ["yǔ"], ["zhì"], ["shuǐ"]],
    "大约摸": [["dà"], ["yuē"], ["mō"]],
    "大跃进": [["dà"], ["yuè"], ["jìn"]],
    "大运河": [["dà"], ["yùn"], ["hé"]],
    "大杂烩": [["dà"], ["zá"], ["huì"]],
    "大杂院": [["dà"], ["zá"], ["yuàn"]],
    "大展宏图": [["dà"], ["zhǎn"], ["hóng"], ["tú"]],
    "大展经纶": [["dà"], ["zhǎn"], ["jīng"], ["lún"]],
    "大张其词": [["dà"], ["zhāng"], ["qí"], ["cí"]],
    "大张旗鼓": [["dà"], ["zhāng"], ["qí"], ["gǔ"]],
    "大张声势": [["dà"], ["zhāng"], ["shēng"], ["shì"]],
    "大张挞伐": [["dà"], ["zhāng"], ["tà"], ["fá"]],
    "大丈夫": [["dà"], ["zhàng"], ["fū"]],
    "大杖则走": [["dà"], ["zhàng"], ["zé"], ["zǒu"]],
    "大昭寺": [["dà"], ["zhāo"], ["sì"]],
    "大政方针": [["dà"], ["zhèng"], ["fāng"], ["zhēn"]],
    "大直若诎": [["dà"], ["zhí"], ["ruò"], ["qū"]],
    "大直若屈": [["dà"], ["zhí"], ["ruò"], ["qū"]],
    "大智大勇": [["dà"], ["zhì"], ["dà"], ["yǒng"]],
    "大智如愚": [["dà"], ["zhì"], ["rú"], ["yú"]],
    "大智若愚": [["dà"], ["zhì"], ["ruò"], ["yú"]],
    "大中至正": [["dà"], ["zhōng"], ["zhì"], ["zhèng"]],
    "大众传播": [["dà"], ["zhòng"], ["chuán"], ["bō"]],
    "大轴子": [["dà"], ["zhòu"], ["zǐ"]],
    "大主教": [["dà"], ["zhǔ"], ["jiào"]],
    "大专院校": [["dà"], ["zhuān"], ["yuàn"], ["xiào"]],
    "大字报": [["dà"], ["zì"], ["bào"]],
    "大自然": [["dà"], ["zì"], ["rán"]],
    "大总统": [["dà"], ["zǒng"], ["tǒng"]],
    "大做文章": [["dà"], ["zuò"], ["wén"], ["zhāng"]],
    "呆里撒奸": [["dāi"], ["lǐ"], ["sā"], ["jiān"]],
    "呆似木鸡": [["dāi"], ["sì"], ["mù"], ["jī"]],
    "呆若木鸡": [["dāi"], ["ruò"], ["mù"], ["jī"]],
    "呆头呆脑": [["dāi"], ["tóu"], ["dāi"], ["nǎo"]],
    "代代相传": [["dài"], ["dài"], ["xiāng"], ["chuán"]],
    "代马望北": [["dài"], ["mǎ"], ["wàng"], ["běi"]],
    "代马依风": [["dài"], ["mǎ"], ["yī"], ["fēng"]],
    "代人受过": [["dài"], ["rén"], ["shòu"], ["guò"]],
    "代人说项": [["dài"], ["rén"], ["shuō"], ["xiàng"]],
    "代数方程": [["dài"], ["shù"], ["fāng"], ["chéng"]],
    "代数和": [["dài"], ["shù"], ["hé"]],
    "代数式": [["dài"], ["shù"], ["shì"]],
    "代数学": [["dài"], ["shù"], ["xué"]],
    "代为说项": [["dài"], ["wéi"], ["shuō"], ["xiàng"]],
    "带刺儿": [["dài"], ["cì"], ["ér"]],
    "带好儿": [["dài"], ["hǎo"], ["ér"]],
    "带菌者": [["dài"], ["jūn"], ["zhě"]],
    "带水拖泥": [["dài"], ["shuǐ"], ["tuō"], ["ní"]],
    "带徒弟": [["dài"], ["tú"], ["dì"]],
    "带着铃铛去做贼": [["dài"], ["zhe"], ["líng"], ["dāng"], ["qù"], ["zuò"], ["zéi"]],
    "待定系数法": [["dài"], ["dìng"], ["xì"], ["shù"], ["fǎ"]],
    "待贾而沽": [["dài"], ["jiǎ"], ["ér"], ["gū"]],
    "待价而沽": [["dài"], ["jià"], ["ér"], ["gū"]],
    "待理不理": [["dài"], ["lǐ"], ["bù"], ["lǐ"]],
    "待人接物": [["dài"], ["rén"], ["jiē"], ["wù"]],
    "待时而动": [["dài"], ["shí"], ["ér"], ["dòng"]],
    "待时守分": [["dài"], ["shí"], ["shǒu"], ["fèn"]],
    "待兔守株": [["dài"], ["tù"], ["shǒu"], ["zhū"]],
    "待月西厢": [["dài"], ["yuè"], ["xī"], ["xiāng"]],
    "待字闺中": [["dài"], ["zì"], ["guī"], ["zhōng"]],
    "戴发含齿": [["dài"], ["fā"], ["hán"], ["chǐ"]],
    "戴发含牙": [["dài"], ["fā"], ["hán"], ["yá"]],
    "戴笠乘车": [["dài"], ["lì"], ["chéng"], ["chē"]],
    "戴绿帽子": [["dài"], ["lǜ"], ["mào"], ["zi"]],
    "戴日戴斗": [["dài"], ["rì"], ["dài"], ["dòu"]],
    "戴天蹐地": [["dài"], ["tiān"], ["jí"], ["dì"]],
    "戴天履地": [["dài"], ["tiān"], ["lǚ"], ["dì"]],
    "戴头识脸": [["dài"], ["tóu"], ["shí"], ["liǎn"]],
    "丹凤朝阳": [["dān"], ["fèng"], ["cháo"], ["yáng"]],
    "丹铅甲乙": [["dān"], ["qiān"], ["jiǎ"], ["yǐ"]],
    "丹青不渝": [["dān"], ["qīng"], ["bù"], ["yú"]],
    "丹书铁券": [["dān"], ["shū"], ["tiě"], ["quàn"]],
    "丹书铁契": [["dān"], ["shū"], ["tiě"], ["qì"]],
    "丹心碧血": [["dān"], ["xīn"], ["bì"], ["xuè"]],
    "丹之所藏者赤": [["dān"], ["zhī"], ["suǒ"], ["cáng"], ["zhě"], ["chì"]],
    "单板计算机": [["dān"], ["bǎn"], ["jì"], ["suàn"], ["jī"]],
    "单兵孤城": [["dān"], ["bīng"], ["gū"], ["chéng"]],
    "单纯词": [["dān"], ["chún"], ["cí"]],
    "单打一": [["dān"], ["dǎ"], ["yī"]],
    "单刀直入": [["dān"], ["dāo"], ["zhí"], ["rù"]],
    "单刀赴会": [["dān"], ["dāo"], ["fù"], ["huì"]],
    "单方面": [["dān"], ["fāng"], ["miàn"]],
    "单峰驼": [["dān"], ["fēng"], ["tuó"]],
    "单干户": [["dān"], ["gàn"], ["hù"]],
    "单个儿": [["dān"], ["gè"], ["ér"]],
    "单鹄寡凫": [["dān"], ["hú"], ["guǎ"], ["fú"]],
    "单簧管": [["dān"], ["huáng"], ["guǎn"]],
    "单见浅闻": [["dān"], ["jiàn"], ["qiǎn"], ["wén"]],
    "单季稻": [["dān"], ["jì"], ["dào"]],
    "单孑独立": [["dān"], ["jié"], ["dú"], ["lì"]],
    "单晶硅": [["dān"], ["jīng"], ["guī"]],
    "单口相声": [["dān"], ["kǒu"], ["xiàng"], ["sheng"]],
    "单门独户": [["dān"], ["mén"], ["dú"], ["hù"]],
    "单枪独马": [["dān"], ["qiāng"], ["dú"], ["mǎ"]],
    "单枪匹马": [["dān"], ["qiāng"], ["pí"], ["mǎ"]],
    "单人独马": [["dān"], ["rén"], ["dú"], ["mǎ"]],
    "单人滑": [["dān"], ["rén"], ["huá"]],
    "单人舞": [["dān"], ["rén"], ["wǔ"]],
    "单色光": [["dān"], ["sè"], ["guāng"]],
    "单身汉": [["dān"], ["shēn"], ["hàn"]],
    "单丝不成线": [["dān"], ["sī"], ["bù"], ["chéng"], ["xiàn"]],
    "单丝不线": [["dān"], ["sī"], ["bù"], ["xiàn"]],
    "单文孤证": [["dān"], ["wén"], ["gū"], ["zhèng"]],
    "单弦儿": [["dān"], ["xián"], ["ér"]],
    "单相思": [["dān"], ["xiāng"], ["sī"]],
    "单行本": [["dān"], ["xíng"], ["běn"]],
    "单行线": [["dān"], ["xíng"], ["xiàn"]],
    "单眼皮": [["dān"], ["yǎn"], ["pí"]],
    "单音词": [["dān"], ["yīn"], ["cí"]],
    "单忧极瘁": [["dān"], ["yōu"], ["jí"], ["cuì"]],
    "单子叶植物": [["dān"], ["zi"], ["yè"], ["zhí"], ["wù"]],
    "担不是": [["dān"], ["bú"], ["shì"]],
    "担担面": [["dàn"], ["dɑn"], ["miàn"]],
    "担惊忍怕": [["dān"], ["jīng"], ["rěn"], ["pà"]],
    "担架队": [["dān"], ["jià"], ["duì"]],
    "担惊受恐": [["dān"], ["jīng"], ["shòu"], ["kǒng"]],
    "担惊受怕": [["dān"], ["jīng"], ["shòu"], ["pà"]],
    "担雪塞井": [["dān"], ["xuě"], ["sāi"], ["jǐng"]],
    "担雪填井": [["dān"], ["xuě"], ["tián"], ["jǐng"]],
    "担雪填河": [["dān"], ["xuě"], ["tián"], ["hé"]],
    "殚见洽闻": [["dān"], ["jiàn"], ["qià"], ["wén"]],
    "殚思极虑": [["dān"], ["sī"], ["jí"], ["lǜ"]],
    "箪豆见色": [["dān"], ["dòu"], ["jiàn"], ["sè"]],
    "箪瓢屡空": [["dān"], ["piáo"], ["lǚ"], ["kōng"]],
    "箪食壶浆": [["dān"], ["sì"], ["hú"], ["jiāng"]],
    "箪食壶酒": [["dān"], ["sì"], ["hú"], ["jiǔ"]],
    "箪食瓢饮": [["dān"], ["sì"], ["piáo"], ["yǐn"]],
    "儋石之储": [["dàn"], ["shí"], ["zhī"], ["chǔ"]],
    "胆颤心惊": [["dǎn"], ["chàn"], ["xīn"], ["jīng"]],
    "胆大包天": [["dǎn"], ["dà"], ["bāo"], ["tiān"]],
    "胆大妄为": [["dǎn"], ["dà"], ["wàng"], ["wéi"]],
    "胆大泼天": [["dǎn"], ["dà"], ["pō"], ["tiān"]],
    "胆大如斗": [["dǎn"], ["dà"], ["rú"], ["dǒu"]],
    "胆大心粗": [["dǎn"], ["dā"], ["xīn"], ["cū"]],
    "胆大心细": [["dǎn"], ["dà"], ["xīn"], ["xì"]],
    "胆大心小": [["dǎn"], ["dà"], ["xīn"], ["xiǎo"]],
    "胆大心雄": [["dǎn"], ["dà"], ["xīn"], ["xióng"]],
    "胆大于身": [["dǎn"], ["dà"], ["yú"], ["shēn"]],
    "胆寒发竖": [["dǎn"], ["hán"], ["fā"], ["shù"]],
    "胆结石": [["dǎn"], ["jié"], ["shí"]],
    "胆裂魂飞": [["dǎn"], ["liè"], ["hún"], ["fēi"]],
    "胆丧魂惊": [["dǎn"], ["sàng"], ["hún"], ["jīng"]],
    "胆囊炎": [["dǎn"], ["náng"], ["yán"]],
    "胆丧魂消": [["dǎn"], ["sàng"], ["hún"], ["xiāo"]],
    "旦角儿": [["dàn"], ["jué"], ["ér"]],
    "旦种暮成": [["dàn"], ["zhòng"], ["mù"], ["chéng"]],
    "旦暮入地": [["dàn"], ["mù"], ["rù"], ["dì"]],
    "诞幻不经": [["dàn"], ["huàn"], ["bù"], ["jīng"]],
    "诞谩不经": [["dàn"], ["màn"], ["bù"], ["jīng"]],
    "诞罔不经": [["dàn"], ["wǎng"], ["bù"], ["jīng"]],
    "诞妄不经": [["dàn"], ["wàng"], ["bù"], ["jīng"]],
    "啖以重利": [["dàn"], ["yǐ"], ["zhòng"], ["lì"]],
    "弹冠结绶": [["tán"], ["guān"], ["jié"], ["shòu"]],
    "弹冠相庆": [["tán"], ["guān"], ["xiāng"], ["qìng"]],
    "弹冠振衿": [["tán"], ["guān"], ["zhèn"], ["jīn"]],
    "弹冠振衣": [["tán"], ["guān"], ["zhèn"], ["yī"]],
    "弹铗无鱼": [["dàn"], ["jiá"], ["wú"], ["yú"]],
    "弹剑作歌": [["tán"], ["jiàn"], ["zuò"], ["gē"]],
    "弹斤估两": [["tán"], ["jīn"], ["gū"], ["liǎng"]],
    "弹尽粮绝": [["dàn"], ["jìn"], ["liáng"], ["jué"]],
    "弹尽援绝": [["dàn"], ["jìn"], ["yuán"], ["jué"]],
    "弹空说嘴": [["tán"], ["kōng"], ["shuō"], ["zuǐ"]],
    "弹丝品竹": [["tán"], ["sī"], ["pǐn"], ["zhú"]],
    "弹丸黑志": [["dàn"], ["wán"], ["hēi"], ["zhì"]],
    "弹丸黑子": [["dàn"], ["wán"], ["hēi"], ["zǐ"]],
    "弹丸脱手": [["tán"], ["wán"], ["tuō"], ["shǒu"]],
    "弹丸之地": [["dàn"], ["wán"], ["zhī"], ["dì"]],
    "弹无虚发": [["dàn"], ["wú"], ["xū"], ["fā"]],
    "弹性体": [["tán"], ["xìng"], ["tǐ"]],
    "弹雨枪林": [["dàn"], ["yǔ"], ["qiāng"], ["lín"]],
    "弹指之间": [["tán"], ["zhǐ"], ["zhī"], ["jiān"]],
    "惮赫千里": [["dàn"], ["hè"], ["qiān"], ["lǐ"]],
    "淡而不厌": [["dàn"], ["ér"], ["bù"], ["yàn"]],
    "淡泊明志": [["dàn"], ["bó"], ["míng"], ["zhì"]],
    "淡然处之": [["dàn"], ["rán"], ["chǔ"], ["zhī"]],
    "淡汝浓抹": [["dàn"], ["zhuāng"], ["nóng"], ["mǒ"]],
    "淡扫蛾眉": [["dàn"], ["sǎo"], ["é"], ["méi"]],
    "淡妆浓抹": [["dàn"], ["zhuāng"], ["nóng"], ["mǒ"]],
    "淡妆轻抹": [["dàn"], ["zhuāng"], ["qīng"], ["mò"]],
    "澹泊寡欲": [["dàn"], ["bó"], ["guǎ"], ["yù"]],
    "当不起": [["dāng"], ["bù"], ["qǐ"]],
    "当场出彩": [["dāng"], ["chǎng"], ["chū"], ["cǎi"]],
    "当场出丑": [["dāng"], ["chǎng"], ["chū"], ["chǒu"]],
    "当断不断": [["dāng"], ["duàn"], ["bù"], ["duàn"]],
    "当耳边风": [["dāng"], ["ěr"], ["biān"], ["fēng"]],
    "当风秉烛": [["dāng"], ["fēng"], ["bǐng"], ["zhú"]],
    "当耳旁风": [["dāng"], ["ěr"], ["páng"], ["fēng"]],
    "当机立断": [["dāng"], ["jī"], ["lì"], ["duàn"]],
    "当机立决": [["dāng"], ["jī"], ["lì"], ["jué"]],
    "当家的": [["dāng"], ["jiā"], ["de"]],
    "当家理纪": [["dāng"], ["jiā"], ["lǐ"], ["jì"]],
    "当家立计": [["dāng"], ["jiā"], ["lì"], ["jì"]],
    "当家立事": [["dāng"], ["jiā"], ["lì"], ["shì"]],
    "当家立纪": [["dāng"], ["jiā"], ["lì"], ["jì"]],
    "当家立业": [["dāng"], ["jiā"], ["lì"], ["yè"]],
    "当家人": [["dāng"], ["jiā"], ["rén"]],
    "当家作主": [["dāng"], ["jiā"], ["zuò"], ["zhǔ"]],
    "当家做主": [["dāng"], ["jiā"], ["zuò"], ["zhǔ"]],
    "当间儿": [["dāng"], ["jiàn"], ["ér"]],
    "当今无辈": [["dāng"], ["jīn"], ["wú"], ["bèi"]],
    "当局者迷": [["dāng"], ["jú"], ["zhě"], ["mí"]],
    "当口儿": [["dāng"], ["kǒu"], ["er"]],
    "当立之年": [["dāng"], ["lì"], ["zhī"], ["nián"]],
    "当门抵户": [["dāng"], ["mén"], ["dǐ"], ["hù"]],
    "当面错过": [["dāng"], ["miàn"], ["cuò"], ["guò"]],
    "当面锣对面鼓": [["dāng"], ["miàn"], ["luó"], ["duì"], ["miàn"], ["gǔ"]],
    "当面输心背面笑": [["dāng"], ["miàn"], ["shū"], ["xīn"], ["bèi"], ["miàn"], ["xiào"]],
    "当权派": [["dāng"], ["quán"], ["pài"]],
    "当仁不让": [["dāng"], ["rén"], ["bù"], ["ràng"]],
    "当世才度": [["dāng"], ["shì"], ["cái"], ["dù"]],
    "当世无双": [["dāng"], ["shì"], ["wú"], ["shuāng"]],
    "当事人": [["dāng"], ["shì"], ["rén"]],
    "当头棒喝": [["dāng"], ["tóu"], ["bàng"], ["hè"]],
    "当事者": [["dāng"], ["shì"], ["zhě"]],
    "当头一棒": [["dāng"], ["tóu"], ["yī"], ["bàng"]],
    "当头对面": [["dāng"], ["tóu"], ["duì"], ["miàn"]],
    "当务始终": [["dang"], ["wu"], ["shi"], ["zhong"]],
    "当务之急": [["dāng"], ["wù"], ["zhī"], ["jí"]],
    "当刑而王": [["dāng"], ["xíng"], ["ér"], ["wáng"]],
    "当行本色": [["dāng"], ["xíng"], ["běn"], ["sè"]],
    "当行出色": [["dāng"], ["háng"], ["chū"], ["sè"]],
    "当一天和尚撞一天钟": [["dāng"], ["yì"], ["tiān"], ["hé"], ["shàng"], ["zhuàng"], ["yì"], ["tiān"], ["zhōng"]],
    "当之无愧": [["dāng"], ["zhī"], ["wú"], ["kuì"]],
    "当之有愧": [["dāng"], ["zhī"], ["yǒu"], ["kuì"]],
    "当着不着": [["dāng"], ["zhuó"], ["bù"], ["zhuó"]],
    "当轴处中": [["dāng"], ["zhóu"], ["chǔ"], ["zhōng"]],
    "挡车工": [["dǎng"], ["chē"], ["gōng"]],
    "挡箭牌": [["dǎng"], ["jiàn"], ["pái"]],
    "挡泥板": [["dǎng"], ["ní"], ["bǎn"]],
    "党豺为虐": [["dǎng"], ["chái"], ["wéi"], ["nüè"]],
    "挡土墙": [["dǎng"], ["tǔ"], ["qiáng"]],
    "党的基本路线": [["dǎng"], ["de"], ["jī"], ["běn"], ["lù"], ["xiàn"]],
    "党的建设": [["dǎng"], ["de"], ["jiàn"], ["shè"]],
    "党恶佑奸": [["dǎng"], ["è"], ["yòu"], ["jiān"]],
    "党坚势盛": [["dǎng"], ["jiān"], ["shì"], ["shèng"]],
    "党同妒异": [["dǎng"], ["tóng"], ["dù"], ["yì"]],
    "党同伐异": [["dǎng"], ["tóng"], ["fá"], ["yì"]],
    "党邪丑正": [["dǎng"], ["xié"], ["chǒu"], ["zhèng"]],
    "党邪陷正": [["dǎng"], ["xié"], ["xiàn"], ["zhèng"]],
    "谠论侃侃": [["dǎng"], ["lùn"], ["kǎn"], ["kǎn"]],
    "谠言嘉论": [["dǎng"], ["yán"], ["jiā"], ["lùn"]],
    "荡产倾家": [["dàng"], ["chǎn"], ["qīng"], ["jiā"]],
    "荡魂摄魄": [["dàng"], ["hún"], ["shè"], ["pò"]],
    "刀把子": [["dāo"], ["bà"], ["zi"]],
    "刀刀见血": [["dāo"], ["dāo"], ["jiàn"], ["xiě"]],
    "刀耕火种": [["dāo"], ["gēng"], ["huǒ"], ["zhòng"]],
    "刀光血影": [["dāo"], ["guāng"], ["xuè"], ["yǐng"]],
    "刀过竹解": [["dāo"], ["guò"], ["zhú"], ["jiě"]],
    "刀头剑首": [["dāo"], ["tóu"], ["jiàn"], ["shǒu"]],
    "刀枪不入": [["dāo"], ["qiāng"], ["bù"], ["rù"]],
    "刀头舔蜜": [["dāo"], ["tóu"], ["tiǎn"], ["mì"]],
    "刀削面": [["dāo"], ["xiāo"], ["miàn"]],
    "刀头燕尾": [["dāo"], ["tóu"], ["yàn"], ["wěi"]],
    "叨陪末座": [["tāo"], ["péi"], ["mò"], ["zuò"]],
    "叨在知己": [["tāo"], ["zài"], ["zhī"], ["jǐ"]],
    "导弹基地": [["dǎo"], ["dàn"], ["jī"], ["dì"]],
    "导弹艇": [["dǎo"], ["dàn"], ["tǐng"]],
    "导德齐礼": [["dǎo"], ["dé"], ["qí"], ["lǐ"]],
    "导航台": [["dǎo"], ["háng"], ["tái"]],
    "倒背如流": [["dào"], ["bèi"], ["rú"], ["liú"]],
    "倒绷孩儿": [["dào"], ["bēng"], ["hái"], ["ér"]],
    "倒插门": [["dào"], ["chā"], ["mén"]],
    "倒持干戈": [["dǎo"], ["chí"], ["gān"], ["gē"]],
    "倒持手板": [["dǎo"], ["chí"], ["shǒu"], ["bǎn"]],
    "倒持戈矛": [["dǎo"], ["chí"], ["gē"], ["máo"]],
    "倒持太阿": [["dǎo"], ["chí"], ["tài"], ["ā"]],
    "倒持泰阿": [["dào"], ["chí"], ["tài"], ["ē"]],
    "倒打一耙": [["dào"], ["dǎ"], ["yī"], ["pá"]],
    "倒春寒": [["dǎo"], ["chūn"], ["hán"]],
    "倒打一瓦": [["dào"], ["dǎ"], ["yī"], ["wǎ"]],
    "倒凤颠鸾": [["dǎo"], ["fèng"], ["diān"], ["luán"]],
    "倒戈卸甲": [["dǎo"], ["gē"], ["xiè"], ["jiǎ"]],
    "倒挂金钟": [["dào"], ["guà"], ["jīn"], ["zhōng"]],
    "倒冠落佩": [["dǎo"], ["guān"], ["luò"], ["pèi"]],
    "倒冠落珮": [["dǎo"], ["guàn"], ["luò"], ["pèi"]],
    "倒果为因": [["dào"], ["guǒ"], ["wéi"], ["yīn"]],
    "倒过儿": [["dào"], ["guò"], ["ér"]],
    "倒好儿": [["dǎo"], ["hǎo"], ["ér"]],
    "倒海翻江": [["dǎo"], ["hǎi"], ["fān"], ["jiāng"]],
    "倒街卧巷": [["dǎo"], ["jiē"], ["wò"], ["xiàng"]],
    "倒廪倾囷": [["dǎo"], ["lǐn"], ["qīng"], ["qūn"]],
    "倒买倒卖": [["dǎo"], ["mǎi"], ["dǎo"], ["mài"]],
    "倒戢干戈": [["dǎo"], ["jí"], ["gān"], ["gē"]],
    "倒箧倾筐": [["dǎo"], ["qiè"], ["qīng"], ["kuāng"]],
    "倒箧倾囊": [["dǎo"], ["qiè"], ["qīng"], ["náng"]],
    "倒三颠四": [["dǎo"], ["sān"], ["diān"], ["sì"]],
    "倒山倾海": [["dǎo"], ["shān"], ["qīng"], ["hǎi"]],
    "倒裳索领": [["dào"], ["cháng"], ["suǒ"], ["lǐng"]],
    "倒胃口": [["dǎo"], ["wèi"], ["kǒu"]],
    "倒屣相迎": [["dào"], ["xǐ"], ["xiāng"], ["yíng"]],
    "倒峡泻河": [["dǎo"], ["xiá"], ["xiè"], ["hé"]],
    "倒行逆施": [["dào"], ["xíng"], ["nì"], ["shī"]],
    "倒悬之急": [["dào"], ["xuán"], ["zhī"], ["jí"]],
    "倒悬之苦": [["dào"], ["xuán"], ["zhī"], ["kǔ"]],
    "倒因为果": [["dǎo"], ["yīn"], ["wéi"], ["guǒ"]],
    "倒栽葱": [["dǎo"], ["zāi"], ["cōng"]],
    "倒载干戈": [["dào"], ["zài"], ["gān"], ["gē"]],
    "倒执手版": [["dǎo"], ["zhí"], ["shǒu"], ["bǎn"]],
    "倒置干戈": [["dào"], ["zhì"], ["gān"], ["gē"]],
    "捣虚撇抗": [["dǎo"], ["xū"], ["piē"], ["kàng"]],
    "捣虚批吭": [["dǎo"], ["xū"], ["pī"], ["háng"]],
    "蹈锋饮血": [["dǎo"], ["fēng"], ["yǐn"], ["xuè"]],
    "蹈赴汤火": [["dǎo"], ["fù"], ["tāng"], ["huǒ"]],
    "蹈火赴汤": [["dǎo"], ["huǒ"], ["fù"], ["tāng"]],
    "蹈火探汤": [["dǎo"], ["huǒ"], ["tàn"], ["tāng"]],
    "蹈节死义": [["dǎo"], ["jié"], ["sǐ"], ["yì"]],
    "蹈厉奋发": [["dǎo"], ["lì"], ["fèn"], ["fā"]],
    "蹈其覆辙": [["dǎo"], ["qì"], ["fù"], ["zhé"]],
    "蹈刃不旋": [["dǎo"], ["rèn"], ["bù"], ["xuán"]],
    "蹈汤赴火": [["dǎo"], ["tāng"], ["fù"], ["huǒ"]],
    "到此为止": [["dào"], ["cǐ"], ["wéi"], ["zhǐ"]],
    "到头来": [["dào"], ["tóu"], ["lái"]],
    "盗食致饱": [["dào"], ["shí"], ["zhì"], ["bǎo"]],
    "盗亦有道": [["dào"], ["yì"], ["yǒu"], ["dào"]],
    "道傍之筑": [["dào"], ["bàng"], ["zhī"], ["zhù"]],
    "道傍筑室": [["dào"], ["bàng"], ["zhù"], ["shì"]],
    "道不掇遗": [["dào"], ["bù"], ["duō"], ["yí"]],
    "道不举遗": [["dào"], ["bù"], ["jǔ"], ["yí"]],
    "道不拾遗": [["dào"], ["bù"], ["shí"], ["yí"]],
    "道不同不相为谋": [["dào"], ["bù"], ["tóng"], ["bù"], ["xiāng"], ["wéi"], ["móu"]],
    "道长论短": [["dào"], ["cháng"], ["lùn"], ["duǎn"]],
    "道长争短": [["dào"], ["cháng"], ["zhēng"], ["duǎn"]],
    "道不相谋": [["dào"], ["bù"], ["xiāng"], ["móu"]],
    "道大莫容": [["dào"], ["dà"], ["mò"], ["róng"]],
    "道道地地": [["dào"], ["dào"], ["dì"], ["dì"]],
    "道德教育": [["dào"], ["dé"], ["jiào"], ["yù"]],
    "道德行为": [["dào"], ["dé"], ["xíng"], ["wéi"]],
    "道弟称兄": [["dào"], ["dì"], ["chēng"], ["xiōng"]],
    "道东说西": [["dào"], ["dōng"], ["shuō"], ["xī"]],
    "道而不径": [["dào"], ["ér"], ["bù"], ["jìng"]],
    "道高德重": [["dào"], ["gāo"], ["dé"], ["zhòng"]],
    "道高魔重": [["dào"], ["gāo"], ["mó"], ["zhòng"]],
    "道高望重": [["dào"], ["gāo"], ["wàng"], ["zhòng"]],
    "道骨仙风": [["dào"], ["gǔ"], ["xiān"], ["fēng"]],
    "道寡称孤": [["dào"], ["guǎ"], ["chēng"], ["gū"]],
    "道合志同": [["dào"], ["hé"], ["zhì"], ["tóng"]],
    "道尽涂殚": [["dào"], ["jìn"], ["tú"], ["dān"]],
    "道尽涂穷": [["dào"], ["jìn"], ["tú"], ["qióng"]],
    "道尽途殚": [["dào"], ["jìn"], ["tú"], ["dān"]],
    "道尽途穷": [["dào"], ["jìn"], ["tú"], ["qióng"]],
    "道殣相望": [["dào"], ["jìn"], ["xiāng"], ["wàng"]],
    "道殣相枕": [["dào"], ["jìn"], ["xiāng"], ["zhěn"]],
    "道殣相属": [["dào"], ["jìn"], ["xiāng"], ["shǔ"]],
    "道旁苦李": [["dào"], ["páng"], ["kǔ"], ["lǐ"]],
    "道听耳食": [["dào"], ["tīng"], ["ěr"], ["shí"]],
    "道听涂说": [["dào"], ["tīng"], ["tú"], ["shuō"]],
    "道听途说": [["dào"], ["tīng"], ["tú"], ["shuō"]],
    "道同义合": [["dào"], ["tóng"], ["yì"], ["hé"]],
    "道同契合": [["dào"], ["tóng"], ["qì"], ["hé"]],
    "道同志合": [["dào"], ["tóng"], ["zhì"], ["hé"]],
    "道头会尾": [["dào"], ["tóu"], ["huì"], ["wěi"]],
    "道头知尾": [["dào"], ["tóu"], ["zhī"], ["wěi"]],
    "道微德薄": [["dào"], ["wēi"], ["dé"], ["báo"]],
    "道无拾遗": [["dào"], ["wú"], ["shí"], ["yí"]],
    "道西说东": [["dào"], ["xī"], ["shuō"], ["dōng"]],
    "道远日暮": [["dào"], ["yuàn"], ["rì"], ["mù"]],
    "道在人为": [["dào"], ["zài"], ["rén"], ["wéi"]],
    "道远知骥": [["dào"], ["yuǎn"], ["zhī"], ["jì"]],
    "道在屎溺": [["dào"], ["zài"], ["shǐ"], ["nì"]],
    "得薄能鲜": [["dé"], ["bó"], ["néng"], ["xiān"]],
    "得不补失": [["dé"], ["bù"], ["bǔ"], ["shī"]],
    "得不偿丧": [["dé"], ["bù"], ["cháng"], ["sàng"]],
    "得不偿失": [["dé"], ["bù"], ["cháng"], ["shī"]],
    "得不酬失": [["dé"], ["bù"], ["chóu"], ["shī"]],
    "得步进步": [["dé"], ["bù"], ["jìn"], ["bù"]],
    "得尺得寸": [["dé"], ["chǐ"], ["dé"], ["cùn"]],
    "得寸进尺": [["dé"], ["cùn"], ["jìn"], ["chǐ"]],
    "得寸得尺": [["dé"], ["cùn"], ["dé"], ["chǐ"]],
    "得道多助": [["dé"], ["dào"], ["duō"], ["zhù"]],
    "得而复失": [["dé"], ["ér"], ["fù"], ["shī"]],
    "得过且过": [["dé"], ["guò"], ["qiě"], ["guò"]],
    "得陇望蜀": [["dé"], ["lǒng"], ["wàng"], ["shǔ"]],
    "得马生灾": [["dé"], ["mǎ"], ["shēng"], ["zāi"]],
    "得马失马": [["dé"], ["mǎ"], ["shī"], ["mǎ"]],
    "得马折足": [["dé"], ["mǎ"], ["shé"], ["zú"]],
    "得其三昧": [["dé"], ["qí"], ["sān"], ["mèi"]],
    "得其所哉": [["dé"], ["qí"], ["suǒ"], ["zāi"]],
    "得饶人处且饶人": [["dé"], ["ráo"], ["rén"], ["chù"], ["qiě"], ["ráo"], ["rén"]],
    "得人死力": [["dé"], ["rén"], ["sǐ"], ["lì"]],
    "得人心": [["dé"], ["rén"], ["xīn"]],
    "得胜回朝": [["dé"], ["shèng"], ["huí"], ["cháo"]],
    "得胜头回": [["dé"], ["shèng"], ["tóu"], ["huí"]],
    "得失参半": [["dé"], ["shī"], ["cān"], ["bàn"]],
    "得失成败": [["dé"], ["shī"], ["chéng"], ["bài"]],
    "得失荣枯": [["dé"], ["shī"], ["róng"], ["kū"]],
    "得失相半": [["dé"], ["shī"], ["xiāng"], ["bàn"]],
    "得失在人": [["dé"], ["shī"], ["zài"], ["rén"]],
    "得手应心": [["dé"], ["shǒu"], ["yīng"], ["xīn"]],
    "得天独厚": [["dé"], ["tiān"], ["dú"], ["hòu"]],
    "得兔忘蹄": [["dé"], ["tù"], ["wàng"], ["tí"]],
    "得未尝有": [["dé"], ["wèi"], ["cháng"], ["yǒu"]],
    "得未曾有": [["dé"], ["wèi"], ["céng"], ["yǒu"]],
    "得心应手": [["dé"], ["xīn"], ["yìng"], ["shǒu"]],
    "得婿如龙": [["dé"], ["xù"], ["rú"], ["lóng"]],
    "得意忘象": [["dé"], ["yì"], ["wàng"], ["xiàng"]],
    "得意门生": [["dé"], ["yì"], ["mén"], ["shēng"]],
    "得意忘形": [["dé"], ["yì"], ["wàng"], ["xíng"]],
    "得意扬扬": [["dé"], ["yì"], ["yáng"], ["yáng"]],
    "得意忘言": [["dé"], ["yì"], ["wàng"], ["yán"]],
    "得意洋洋": [["dé"], ["yì"], ["yáng"], ["yáng"]],
    "得意之作": [["dé"], ["yì"], ["zhī"], ["zuò"]],
    "得意之色": [["dé"], ["yì"], ["zhī"], ["sè"]],
    "得鱼忘荃": [["dé"], ["yú"], ["wàng"], ["quán"]],
    "得月较先": [["dé"], ["yuè"], ["jiào"], ["xiān"]],
    "得鱼忘筌": [["dé"], ["yú"], ["wàng"], ["quán"]],
    "德薄才疏": [["dé"], ["bó"], ["cái"], ["shū"]],
    "德薄能鲜": [["dé"], ["bó"], ["néng"], ["xiǎn"]],
    "德薄才鲜": [["dé"], ["báo"], ["cái"], ["xiān"]],
    "德高望重": [["dé"], ["gāo"], ["wàng"], ["zhòng"]],
    "德隆望重": [["dé"], ["lóng"], ["wàng"], ["zhòng"]],
    "德配天地": [["dé"], ["pèi"], ["tiān"], ["dì"]],
    "德浅行薄": [["dé"], ["qiǎn"], ["xíng"], ["báo"]],
    "德胜头迴": [["dé"], ["shèng"], ["tóu"], ["huí"]],
    "德兴市": [["dé"], ["xīng"], ["shì"]],
    "德音莫违": [["dé"], ["yīn"], ["mò"], ["wéi"]],
    "德重恩弘": [["dé"], ["zhòng"], ["ēn"], ["hóng"]],
    "德尊望重": [["dé"], ["zūn"], ["wàng"], ["zhòng"]],
    "的确良": [["dí"], ["què"], ["liáng"]],
    "的一确二": [["dí"], ["yī"], ["què"], ["èr"]],
    "灯蛾扑火": [["dé"], ["é"], ["pū"], ["huǒ"]],
    "灯红酒绿": [["dēng"], ["hóng"], ["jiǔ"], ["lǜ"]],
    "灯火万家": [["dēng"], ["huǒ"], ["wàn"], ["jiā"]],
    "灯尽油干": [["dēng"], ["jìn"], ["yóu"], ["gàn"]],
    "灯笼裤": [["dēng"], ["lóng"], ["kù"]],
    "登高望远": [["dēng"], ["gāo"], ["wàng"], ["yuǎn"]],
    "登山越岭": [["dēng"], ["shān"], ["yuè"], ["lǐng"]],
    "登山陟岭": [["dēng"], ["shān"], ["zhì"], ["lǐng"]],
    "登台拜将": [["dēng"], ["tái"], ["bài"], ["jiàng"]],
    "登坛拜将": [["dēng"], ["tán"], ["bài"], ["jiàng"]],
    "等比级数": [["děng"], ["bǐ"], ["jí"], ["shù"]],
    "等比数列": [["děng"], ["bǐ"], ["shù"], ["liè"]],
    "等边三角形": [["děng"], ["biān"], ["sān"], ["jiǎo"], ["xíng"]],
    "等不及": [["děng"], ["bù"], ["jí"]],
    "等差级数": [["děng"], ["chà"], ["jí"], ["shù"]],
    "等差数列": [["děng"], ["chā"], ["shù"], ["liè"]],
    "等而上之": [["děng"], ["ér"], ["shàng"], ["zhī"]],
    "等价交换": [["děng"], ["jià"], ["jiāo"], ["huàn"]],
    "等价连城": [["děng"], ["jià"], ["lián"], ["chéng"]],
    "等离子体": [["děng"], ["lí"], ["zǐ"], ["tǐ"]],
    "等礼相亢": [["děng"], ["lǐ"], ["xiāng"], ["kàng"]],
    "等量齐观": [["děng"], ["liàng"], ["qí"], ["guān"]],
    "等压线": [["děng"], ["yā"], ["xiàn"]],
    "等腰三角形": [["děng"], ["yāo"], ["sān"], ["jiǎo"], ["xíng"]],
    "邓小平理论": [["dèng"], ["xiǎo"], ["píng"], ["lǐ"], ["lùn"]],
    "瞪眼咋舌": [["dèng"], ["yǎn"], ["zé"], ["shé"]],
    "瞪目结舌": [["dèng"], ["mù"], ["jié"], ["shé"]],
    "低唱浅斟": [["dì"], ["chàng"], ["qiǎn"], ["zhēn"]],
    "低唱浅酌": [["dì"], ["chàng"], ["qiǎn"], ["zhuó"]],
    "低回不已": [["dī"], ["huí"], ["bù"], ["yǐ"]],
    "低级趣味": [["dī"], ["jí"], ["qù"], ["wèi"]],
    "低眉折腰": [["dī"], ["méi"], ["zhé"], ["yāo"]],
    "低能儿": [["dī"], ["néng"], ["ér"]],
    "低情曲意": [["dī"], ["qíng"], ["qū"], ["yì"]],
    "低声细语": [["dī"], ["shēng"], ["xì"], ["yǔ"]],
    "低声哑气": [["dī"], ["shēng"], ["yǎ"], ["qì"]],
    "低头耷脑": [["dī"], ["tóu"], ["dā"], ["nǎo"]],
    "低头搭脑": [["dī"], ["tóu"], ["dā"], ["nǎo"]],
    "低头丧气": [["dī"], ["tóu"], ["sàng"], ["qì"]],
    "低头哈腰": [["dī"], ["tóu"], ["hā"], ["yāo"]],
    "低血糖": [["dī"], ["xuè"], ["táng"]],
    "低血压": [["dī"], ["xuè"], ["yā"]],
    "低吟浅唱": [["dī"], ["yín"], ["qiǎn"], ["chàng"]],
    "羝羊触藩": [["dī"], ["yáng"], ["chù"], ["fān"]],
    "堤溃蚁孔": [["dī"], ["kuì"], ["yǐ"], ["kǒng"]],
    "堤溃蚁穴": [["dī"], ["kuì"], ["yǐ"], ["xué"]],
    "滴溜儿": [["dī"], ["liù"], ["ér"]],
    "滴滴答答": [["dī"], ["dī"], ["dā"], ["dā"]],
    "滴溜溜": [["dī"], ["liū"], ["liū"]],
    "滴露研珠": [["dī"], ["lù"], ["yán"], ["zhū"]],
    "滴露研朱": [["dī"], ["lù"], ["yán"], ["zhū"]],
    "滴水不羼": [["dī"], ["shuǐ"], ["bù"], ["chàn"]],
    "滴水不漏": [["dī"], ["shuǐ"], ["bù"], ["lòu"]],
    "滴水穿石": [["dī"], ["shuǐ"], ["chuān"], ["shí"]],
    "滴水难消": [["dī"], ["shuǐ"], ["nán"], ["xiāo"]],
    "敌不可假": [["dí"], ["bù"], ["kě"], ["jiǎ"]],
    "迪斯尼乐园": [["dí"], ["sī"], ["ní"], ["lè"], ["yuán"]],
    "敌忾同仇": [["dí"], ["kài"], ["tóng"], ["chóu"]],
    "敌不可纵": [["dí"], ["bù"], ["kě"], ["zòng"]],
    "敌力角气": [["dí"], ["lì"], ["jiǎo"], ["qì"]],
    "敌王所忾": [["dí"], ["wáng"], ["suǒ"], ["kài"]],
    "敌占区": [["dí"], ["zhàn"], ["qū"]],
    "涤地无类": [["dí"], ["dì"], ["wú"], ["lèi"]],
    "涤故更新": [["dí"], ["gù"], ["gēng"], ["xīn"]],
    "嫡长子": [["dí"], ["zhǎng"], ["zǐ"]],
    "底死谩生": [["dǐ"], ["sǐ"], ["màn"], ["shēng"]],
    "底下人": [["dǐ"], ["xià"], ["rén"]],
    "抵背扼喉": [["dǐ"], ["bèi"], ["è"], ["hóu"]],
    "抵死瞒生": [["dǐ"], ["sǐ"], ["mán"], ["shēng"]],
    "砥节奉公": [["dǐ"], ["jié"], ["fèng"], ["gōng"]],
    "砥节厉行": [["dǐ"], ["jié"], ["lì"], ["xíng"]],
    "砥节励行": [["dǐ"], ["jié"], ["lì"], ["xíng"]],
    "砥节砺行": [["dǐ"], ["jié"], ["lì"], ["xíng"]],
    "砥砺风节": [["dǐ"], ["lì"], ["fēng"], ["jié"]],
    "砥厉名号": [["dǐ"], ["lì"], ["míng"], ["hào"]],
    "砥砺名号": [["dǐ"], ["lì"], ["míng"], ["hào"]],
    "砥砺名节": [["dǐ"], ["lì"], ["míng"], ["jié"]],
    "砥砺琢磨": [["dǐ"], ["lì"], ["zhuó"], ["mó"]],
    "砥身砺行": [["dǐ"], ["shēn"], ["lì"], ["xíng"]],
    "砥行立名": [["dǐ"], ["xíng"], ["lì"], ["míng"]],
    "砥行磨名": [["dǐ"], ["xíng"], ["mó"], ["míng"]],
    "砥志研思": [["dǐ"], ["zhì"], ["yán"], ["sī"]],
    "砥柱中流": [["dǐ"], ["zhù"], ["zhōng"], ["liú"]],
    "地北天南": [["dì"], ["běi"], ["tiān"], ["nán"]],
    "地崩山摧": [["dì"], ["bēng"], ["shān"], ["cuī"]],
    "地表水": [["dì"], ["biǎo"], ["shuǐ"]],
    "地层学": [["dì"], ["céng"], ["xué"]],
    "地坼天崩": [["dì"], ["chè"], ["tiān"], ["bēng"]],
    "地丑力敌": [["dì"], ["chǒu"], ["lì"], ["dí"]],
    "地丑德齐": [["dì"], ["chǒu"], ["dé"], ["qí"]],
    "地带性": [["dì"], ["dài"], ["xìng"]],
    "地大物博": [["dì"], ["dà"], ["wù"], ["bó"]],
    "地道战": [["dì"], ["dào"], ["zhàn"]],
    "地动山摧": [["dì"], ["dòng"], ["shān"], ["cuī"]],
    "地动山摇": [["dì"], ["dòng"], ["shēn"], ["yáo"]],
    "地动仪": [["dì"], ["dòng"], ["yí"]],
    "地方病": [["dì"], ["fāng"], ["bìng"]],
    "地方官": [["dì"], ["fāng"], ["guān"]],
    "地方民族主义": [["dì"], ["fāng"], ["mín"], ["zú"], ["zhǔ"], ["yì"]],
    "地方时": [["dì"], ["fāng"], ["shí"]],
    "地方税": [["dì"], ["fāng"], ["shuì"]],
    "地方戏": [["dì"], ["fāng"], ["xì"]],
    "地方志": [["dì"], ["fāng"], ["zhì"]],
    "地方主义": [["dì"], ["fāng"], ["zhǔ"], ["yì"]],
    "地负海涵": [["dì"], ["fù"], ["hǎi"], ["hán"]],
    "地覆天翻": [["dì"], ["fù"], ["tiān"], ["fān"]],
    "地广人希": [["dì"], ["guǎng"], ["rén"], ["xī"]],
    "地骨皮": [["dì"], ["gǔ"], ["pí"]],
    "地广人稀": [["dì"], ["guǎng"], ["rén"], ["xī"]],
    "地滚球": [["dì"], ["gǔn"], ["qiú"]],
    "地棘天荆": [["dì"], ["jí"], ["tiān"], ["jīng"]],
    "地瘠民贫": [["dì"], ["jí"], ["mín"], ["pín"]],
    "地价税": [["dì"], ["jià"], ["shuì"]],
    "地角天涯": [["dì"], ["jiǎo"], ["tiān"], ["yá"]],
    "地久天长": [["dì"], ["jiǔ"], ["tiān"], ["cháng"]],
    "地壳运动": [["dì"], ["qiào"], ["yùn"], ["dòng"]],
    "地空导弹": [["dì"], ["kōng"], ["dǎo"], ["dàn"]],
    "地旷人稀": [["dì"], ["kuàng"], ["rén"], ["xī"]],
    "地老虎": [["dì"], ["lǎo"], ["hǔ"]],
    "地老天荒": [["dì"], ["lǎo"], ["tiān"], ["huāng"]],
    "地老天昏": [["dì"], ["lǎo"], ["tiān"], ["hūn"]],
    "地雷战": [["dì"], ["léi"], ["zhàn"]],
    "地理环境": [["dì"], ["lǐ"], ["huán"], ["jìng"]],
    "地理数据库": [["dì"], ["lǐ"], ["shù"], ["jù"], ["kù"]],
    "地理位置": [["dì"], ["lǐ"], ["wèi"], ["zhì"]],
    "地理信息": [["dì"], ["lǐ"], ["xìn"], ["xī"]],
    "地理信息系统": [["dì"], ["lǐ"], ["xìn"], ["xī"], ["xì"], ["tǒng"]],
    "地理学": [["dì"], ["lǐ"], ["xué"]],
    "地利人和": [["dì"], ["lì"], ["rén"], ["hé"]],
    "地沥青": [["dì"], ["lì"], ["qīng"]],
    "地灵人杰": [["dì"], ["líng"], ["rén"], ["jié"]],
    "地貌学": [["dì"], ["mào"], ["xué"]],
    "地面沉降": [["dì"], ["miàn"], ["chén"], ["jiàng"]],
    "地面灌溉": [["dì"], ["miàn"], ["guàn"], ["gài"]],
    "地面水": [["dì"], ["miàn"], ["shuǐ"]],
    "地平线": [["dì"], ["píng"], ["xiàn"]],
    "地平天成": [["dì"], ["píng"], ["tiān"], ["chéng"]],
    "地球化学": [["dì"], ["qiú"], ["huà"], ["xué"]],
    "地球物理学": [["dì"], ["qiú"], ["wù"], ["lǐ"], ["xué"]],
    "地球仪": [["dì"], ["qiú"], ["yí"]],
    "地球资源卫星": [["dì"], ["qiú"], ["zī"], ["yuán"], ["wèi"], ["xīng"]],
    "地区差价": [["dì"], ["qū"], ["chā"], ["jià"]],
    "地塞米松": [["dì"], ["sāi"], ["mǐ"], ["sōng"]],
    "地上茎": [["dì"], ["shàng"], ["jīng"]],
    "地上天宫": [["dì"], ["shàng"], ["tiān"], ["gōng"]],
    "地上天官": [["dì"], ["shàng"], ["tiān"], ["guān"]],
    "地塌天荒": [["dì"], ["tā"], ["tiān"], ["huāng"]],
    "地头蛇": [["dì"], ["tóu"], ["shé"]],
    "地图册": [["dì"], ["tú"], ["cè"]],
    "地网天罗": [["dì"], ["wǎng"], ["tiān"], ["luó"]],
    "地图学": [["dì"], ["tú"], ["xué"]],
    "地下河": [["dì"], ["xià"], ["hé"]],
    "地下街": [["dì"], ["xià"], ["jiē"]],
    "地下茎": [["dì"], ["xià"], ["jīng"]],
    "地下室": [["dì"], ["xià"], ["shì"]],
    "地下水": [["dì"], ["xià"], ["shuǐ"]],
    "地下水库": [["dì"], ["xià"], ["shuǐ"], ["kù"]],
    "地下铁道": [["dì"], ["xià"], ["tiě"], ["dào"]],
    "地心说": [["dì"], ["xīn"], ["shuō"]],
    "地下修文": [["dì"], ["xià"], ["xiū"], ["wén"]],
    "地心引力": [["dì"], ["xīn"], ["yǐn"], ["lì"]],
    "地形图": [["dì"], ["xíng"], ["tú"]],
    "地窨子": [["dì"], ["yìn"], ["zǐ"]],
    "地狱变相": [["dì"], ["yù"], ["biàn"], ["xiàng"]],
    "地震波": [["dì"], ["zhèn"], ["bō"]],
    "地震带": [["dì"], ["zhèn"], ["dài"]],
    "地震烈度": [["dì"], ["zhèn"], ["liè"], ["dù"]],
    "地震学": [["dì"], ["zhèn"], ["xué"]],
    "地震仪": [["dì"], ["zhèn"], ["yí"]],
    "地震预报": [["dì"], ["zhèn"], ["yù"], ["bào"]],
    "地震震级": [["dì"], ["zhèn"], ["zhèn"], ["jí"]],
    "地质力学": [["dì"], ["zhì"], ["lì"], ["xué"]],
    "地质年代": [["dì"], ["zhì"], ["nián"], ["dài"]],
    "地质学": [["dì"], ["zhì"], ["xué"]],
    "地中海": [["dì"], ["zhōng"], ["hǎi"]],
    "地中海气候": [["dì"], ["zhōng"], ["hǎi"], ["qì"], ["hòu"]],
    "地主阶级": [["dì"], ["zhǔ"], ["jiē"], ["jí"]],
    "地主之仪": [["dì"], ["zhǔ"], ["zhī"], ["yí"]],
    "地主之谊": [["dì"], ["zhǔ"], ["zhī"], ["yì"]],
    "弟男子侄": [["dì"], ["nán"], ["zǐ"], ["zhí"]],
    "帝王将相": [["dì"], ["wáng"], ["jiòn"], ["xiàng"]],
    "递条子": [["dì"], ["tiáo"], ["zi"]],
    "递兴递废": [["dì"], ["xīng"], ["dì"], ["fèi"]],
    "第二信号系统": [["dì"], ["èr"], ["xìn"], ["hào"], ["xì"], ["tǒng"]],
    "第五纵队": [["dì"], ["wǔ"], ["zòng"], ["duì"]],
    "第一次世界大战": [["dì"], ["yí"], ["cì"], ["shì"], ["jiè"], ["dà"], ["zhàn"]],
    "第一信号系统": [["dì"], ["yī"], ["shēn"], ["hào"], ["xì"], ["tǒng"]],
    "谛分审布": [["dì"], ["fēn"], ["shěn"], ["bù"]],
    "缔约国": [["dì"], ["yuē"], ["guó"]],
    "掂斤估两": [["diān"], ["jīn"], ["gū"], ["liǎng"]],
    "掂斤抹两": [["diān"], ["jīn"], ["mò"], ["liǎng"]],
    "掂梢折本": [["diān"], ["shāo"], ["shé"], ["běn"]],
    "颠簸不破": [["diān"], ["bǒ"], ["bù"], ["pò"]],
    "颠唇簸嘴": [["diān"], ["chún"], ["bò"], ["zuǐ"]],
    "颠倒干坤": [["diān"], ["dǎo"], ["gàn"], ["kūn"]],
    "颠倒黑白": [["diān"], ["dǎo"], ["hēi"], ["bái"]],
    "颠倒乾坤": [["diān"], ["dǎo"], ["qián"], ["kūn"]],
    "颠倒是非": [["diān"], ["dǎo"], ["shì"], ["fēi"]],
    "颠倒衣裳": [["diān"], ["dǎo"], ["yī"], ["cháng"]],
    "颠倒阴阳": [["diān"], ["dǎo"], ["yīn"], ["yáng"]],
    "颠颠倒倒": [["diān"], ["diān"], ["dǎo"], ["dǎo"]],
    "颠来簸去": [["diān"], ["lái"], ["bǒ"], ["qù"]],
    "颠来倒去": [["diān"], ["lái"], ["dǎo"], ["qù"]],
    "颠毛种种": [["diān"], ["máo"], ["zhǒng"], ["zhǒng"]],
    "颠鸾倒凤": [["diān"], ["luán"], ["dǎo"], ["fèng"]],
    "颠仆流离": [["diān"], ["pú"], ["liú"], ["lí"]],
    "颠扑不磨": [["diān"], ["pū"], ["bù"], ["mó"]],
    "颠扑不破": [["diān"], ["pū"], ["bù"], ["pò"]],
    "颠乾倒坤": [["diān"], ["qiān"], ["dǎo"], ["kūn"]],
    "颠三倒四": [["diān"], ["sān"], ["dǎo"], ["sì"]],
    "颠衣到裳": [["diān"], ["yī"], ["dào"], ["shang"]],
    "攧扑不破": [["diān"], ["pū"], ["bù"], ["pò"]],
    "典妻鬻子": [["diǎn"], ["qī"], ["yù"], ["zǐ"]],
    "典型化": [["diǎn"], ["xíng"], ["huà"]],
    "点金乏术": [["diǎn"], ["jīn"], ["fá"], ["shù"]],
    "点金无术": [["diǎn"], ["jīn"], ["wú"], ["shù"]],
    "点石成金": [["diǎn"], ["shí"], ["chéng"], ["jīn"]],
    "点手划脚": [["diǎn"], ["shǒu"], ["jí"], ["jiǎo"]],
    "点石为金": [["diǎn"], ["shí"], ["wéi"], ["jīn"]],
    "点水不漏": [["diǎn"], ["shuǐ"], ["bù"], ["lòu"]],
    "点头会意": [["diǎn"], ["tóu"], ["huì"], ["yì"]],
    "点头哈腰": [["diǎn"], ["tóu"], ["hā"], ["yāo"]],
    "点头咂嘴": [["diǎn"], ["tóu"], ["zā"], ["zuǐ"]],
    "点头之交": [["diǎn"], ["tóu"], ["zhī"], ["jiāo"]],
    "点胸洗眼": [["diǎn"], ["xiōng"], ["xǐ"], ["yǎn"]],
    "点指划脚": [["diǎn"], ["zhǐ"], ["jí"], ["jiǎo"]],
    "碘化物": [["diǎn"], ["huà"], ["wù"]],
    "电报挂号": [["diàn"], ["bào"], ["guà"], ["hào"]],
    "电冰柜": [["diàn"], ["bīng"], ["guì"]],
    "电掣风驰": [["diàn"], ["chè"], ["fēng"], ["chí"]],
    "电吹风": [["diàn"], ["chuī"], ["fēng"]],
    "电磁场": [["diàn"], ["cí"], ["chǎng"]],
    "电磁感应": [["diàn"], ["cí"], ["gǎn"], ["yìng"]],
    "电灯泡": [["diàn"], ["dēng"], ["pào"]],
    "电度表": [["diàn"], ["dù"], ["biǎo"]],
    "电风扇": [["diàn"], ["fēng"], ["shàn"]],
    "电功率": [["diàn"], ["gōng"], ["lǜ"]],
    "电光朝露": [["diàn"], ["guāng"], ["zhāo"], ["lù"]],
    "电光石火": [["diàn"], ["guāng"], ["shí"], ["huǒ"]],
    "电荷耦合器件": [["diàn"], ["hè"], ["ǒu"], ["hé"], ["qì"], ["jiàn"]],
    "电化教学": [["diàn"], ["huà"], ["jiào"], ["xué"]],
    "电化教育": [["diàn"], ["huà"], ["jiào"], ["yù"]],
    "电话会议": [["diàn"], ["huà"], ["huì"], ["yì"]],
    "电话号码": [["diàn"], ["huà"], ["hào"], ["mǎ"]],
    "电解质": [["diàn"], ["jiě"], ["zhì"]],
    "电烙铁": [["diàn"], ["lào"], ["tiě"]],
    "电力机车": [["diàn"], ["lì"], ["jī"], ["chē"]],
    "电力系统": [["diàn"], ["lì"], ["xì"], ["tǒng"]],
    "电流放大器": [["diàn"], ["liú"], ["fàng"], ["dà"], ["qì"]],
    "电流强度": [["diàn"], ["liú"], ["qiáng"], ["dù"]],
    "电流星散": [["diàn"], ["liú"], ["xīng"], ["sàn"]],
    "电脑病毒": [["diàn"], ["nǎo"], ["bìng"], ["dú"]],
    "电能表": [["diàn"], ["néng"], ["biǎo"]],
    "电瓶车": [["diàn"], ["píng"], ["chē"]],
    "电气化": [["diàn"], ["qì"], ["huà"]],
    "电气石": [["diàn"], ["qì"], ["shí"]],
    "电气化铁路": [["diàn"], ["qì"], ["huà"], ["tiě"], ["lù"]],
    "电石气": [["diàn"], ["shí"], ["qì"]],
    "电势差": [["diàn"], ["shì"], ["chà"]],
    "电视大学": [["diàn"], ["shì"], ["dà"], ["xué"]],
    "电视发射塔": [["diàn"], ["shì"], ["fā"], ["shè"], ["tǎ"]],
    "电视广播": [["diàn"], ["shì"], ["guǎng"], ["bō"]],
    "电视会议": [["diàn"], ["shì"], ["huì"], ["yì"]],
    "电视片": [["diàn"], ["shì"], ["piàn"]],
    "电视频道": [["diàn"], ["shì"], ["pín"], ["dào"]],
    "电视台": [["diàn"], ["shì"], ["tái"]],
    "电视系列片": [["diàn"], ["shì"], ["xì"], ["liè"], ["piàn"]],
    "电位差": [["diàn"], ["wèi"], ["chà"]],
    "电线杆": [["diàn"], ["xiàn"], ["gān"]],
    "电压表": [["diàn"], ["yā"], ["biǎo"]],
    "电压放大器": [["diàn"], ["yā"], ["fàng"], ["dà"], ["qì"]],
    "电压互感器": [["diàn"], ["yā"], ["hù"], ["gǎn"], ["qì"]],
    "电压计": [["diàn"], ["yā"], ["jì"]],
    "电影摄影机": [["diàn"], ["yǐng"], ["shè"], ["yǐng"], ["jī"]],
    "电熨斗": [["diàn"], ["yùn"], ["dǒu"]],
    "电照风行": [["diàn"], ["zhào"], ["fēng"], ["xíng"]],
    "电子干扰": [["diàn"], ["zǐ"], ["gān"], ["rǎo"]],
    "电子乐器": [["diàn"], ["zǐ"], ["yuè"], ["qì"]],
    "电子音乐": [["diàn"], ["zǐ"], ["yīn"], ["yuè"]],
    "电子游戏": [["diàn"], ["zǐ"], ["yóu"], ["xì"]],
    "电子游戏机": [["diàn"], ["zǐ"], ["yóu"], ["xì"], ["jī"]],
    "电阻率": [["diàn"], ["zǔ"], ["lǜ"]],
    "垫底儿": [["diàn"], ["dǐ"], ["ér"]],
    "垫上运动": [["diàn"], ["shàng"], ["yùn"], ["dòng"]],
    "垫脚石": [["diàn"], ["jiǎo"], ["shí"]],
    "钿合金钗": [["diàn"], ["hé"], ["jīn"], ["chāi"]],
    "奠基石": [["diàn"], ["jī"], ["shí"]],
    "簟纹如水": [["diàn"], ["wén"], ["rú"], ["shuǐ"]],
    "刁斗森严": [["diāo"], ["dǒu"], ["sēn"], ["yán"]],
    "刁天决地": [["diāo"], ["tiān"], ["jué"], ["dì"]],
    "刁钻促搯": [["diāo"], ["zuàn"], ["cù"], ["chāo"]],
    "刁钻促狭": [["diāo"], ["zuàn"], ["cù"], ["xiá"]],
    "刁钻古怪": [["diāo"], ["zuān"], ["gǔ"], ["guài"]],
    "刁钻刻薄": [["diāo"], ["zuān"], ["kè"], ["bó"]],
    "彫肝琢肾": [["diāo"], ["gān"], ["zhuó"], ["shèn"]],
    "彫章镂句": [["diāo"], ["zhāng"], ["lòu"], ["jù"]],
    "貂狗相属": [["diāo"], ["gǒu"], ["xiāng"], ["shǔ"]],
    "雕虫薄技": [["diāo"], ["chóng"], ["báo"], ["jì"]],
    "雕虫末伎": [["diāo"], ["chóng"], ["mò"], ["jì"]],
    "雕风镂月": [["diāo"], ["fēng"], ["lòu"], ["yuè"]],
    "雕肝琢膂": [["diāo"], ["gān"], ["zhuó"], ["lǚ"]],
    "雕肝琢肾": [["diāo"], ["gān"], ["zhuó"], ["shèn"]],
    "雕蚶镂蛤": [["diāo"], ["hān"], ["lòu"], ["gé"]],
    "雕栏玉砌": [["diāo"], ["lán"], ["yù"], ["qì"]],
    "雕阑玉砌": [["diāo"], ["lán"], ["yù"], ["qì"]],
    "雕盘绮食": [["diāo"], ["pán"], ["qǐ"], ["shí"]],
    "雕文织采": [["diāo"], ["wén"], ["zhī"], ["cǎi"]],
    "雕心雁爪": [["diāo"], ["xīn"], ["yàn"], ["zhǎo"]],
    "雕心鹰爪": [["diāo"], ["xīn"], ["yīng"], ["zhǎo"]],
    "雕楹碧槛": [["diāo"], ["yíng"], ["bì"], ["kǎn"]],
    "雕章镂句": [["diāo"], ["zhāng"], ["lòu"], ["jù"]],
    "雕章绘句": [["diāo"], ["zhāng"], ["huì"], ["jù"]],
    "雕章琢句": [["diāo"], ["zhāng"], ["zhuó"], ["jù"]],
    "吊胆提心": [["diào"], ["dǎn"], ["tí"], ["xīn"]],
    "吊儿郎当": [["diào"], ["er"], ["láng"], ["dāng"]],
    "吊尔郎当": [["diào"], ["er"], ["láng"], ["dāng"]],
    "钓名要誉": [["diào"], ["míng"], ["yào"], ["yù"]],
    "钓游之地": [["diào"], ["yóu"], ["zhī"], ["dì"]],
    "钓鱼台": [["diào"], ["yú"], ["tái"]],
    "调兵遣将": [["diào"], ["bīng"], ["qiǎn"], ["jiàng"]],
    "调查研究": [["diào"], ["chá"], ["yán"], ["jiū"]],
    "调唇弄舌": [["tiáo"], ["chún"], ["nòng"], ["shé"]],
    "调词架讼": [["tiáo"], ["cí"], ["jià"], ["sòng"]],
    "调风变俗": [["tiáo"], ["fēng"], ["biàn"], ["sú"]],
    "调风弄月": [["tiáo"], ["fēng"], ["nòng"], ["yuè"]],
    "调和鼎鼐": [["tiáo"], ["hé"], ["dǐng"], ["nài"]],
    "调和阴阳": [["tiáo"], ["hé"], ["yīn"], ["yáng"]],
    "调虎离山": [["diào"], ["hǔ"], ["lí"], ["shān"]],
    "调理阴阳": [["tiáo"], ["lǐ"], ["yīn"], ["yáng"]],
    "调良稳泛": [["tiáo"], ["liáng"], ["wěn"], ["fàn"]],
    "调门儿": [["diào"], ["mén"], ["ér"]],
    "调墨弄笔": [["tiáo"], ["mò"], ["nòng"], ["bǐ"]],
    "调皮鬼": [["tiáo"], ["pí"], ["guǐ"]],
    "调三窝四": [["tiáo"], ["sān"], ["wō"], ["sì"]],
    "调三惑四": [["tiáo"], ["sān"], ["huò"], ["sì"]],
    "调三斡四": [["tiáo"], ["sān"], ["wò"], ["sì"]],
    "调色板": [["tiáo"], ["sè"], ["bǎn"]],
    "调舌弄唇": [["tiáo"], ["shé"], ["nòng"], ["chún"]],
    "调神畅情": [["tiáo"], ["shén"], ["chàng"], ["qíng"]],
    "调丝品竹": [["tiáo"], ["sī"], ["pǐn"], ["zhú"]],
    "调停两用": [["tiáo"], ["tíng"], ["liǎng"], ["yòng"]],
    "调味品": [["tiáo"], ["wèi"], ["pǐn"]],
    "调弦品竹": [["diào"], ["xián"], ["pǐn"], ["zhú"]],
    "调脂弄粉": [["tiáo"], ["zhī"], ["nòng"], ["fěn"]],
    "调嘴调舌": [["tiáo"], ["zuǐ"], ["diào"], ["shé"]],
    "调朱傅粉": [["tiáo"], ["zhū"], ["fù"], ["fěn"]],
    "调朱弄粉": [["tiáo"], ["zhū"], ["nòng"], ["fěn"]],
    "调嘴弄舌": [["tiáo"], ["zuǐ"], ["nòng"], ["shé"]],
    "调嘴学舌": [["tiáo"], ["zuǐ"], ["xué"], ["shé"]],
    "掉臂不顾": [["diào"], ["bì"], ["bù"], ["gù"]],
    "掉过儿": [["diào"], ["guò"], ["ér"]],
    "掉头鼠窜": [["diào"], ["tóu"], ["shǔ"], ["cuàn"]],
    "跌打损伤": [["diē"], ["dǎ"], ["sǔn"], ["shāng"]],
    "跌弹斑鸠": [["diē"], ["dàn"], ["bān"], ["jiū"]],
    "跌宕不羁": [["dié"], ["dàng"], ["bù"], ["jī"]],
    "跌宕风流": [["diē"], ["dàng"], ["fēngliú"]],
    "跌荡不拘": [["diē"], ["dàng"], ["bù"], ["jū"]],
    "跌荡不羁": [["diē"], ["dàng"], ["bù"], ["jī"]],
    "跌荡风流": [["diē"], ["dàng"], ["fēng"], ["liú"]],
    "迭矩重规": [["dié"], ["jǔ"], ["chóng"], ["guī"]],
    "喋喋不休": [["dié"], ["dié"], ["bù"], ["xiū"]],
    "叠矩重规": [["dié"], ["jǔ"], ["chóng"], ["guī"]],
    "蹀躞不下": [["dié"], ["xiè"], ["bù"], ["xià"]],
    "鲽离鹣背": [["dié"], ["lí"], ["jiān"], ["bèi"]],
    "丁点儿": [["dīng"], ["diǎn"], ["er"]],
    "丁丁当当": [["dīng"], ["dīng"], ["dāng"], ["dāng"]],
    "丁公凿井": [["dīng"], ["gōng"], ["záo"], ["jǐng"]],
    "丁公藤": [["dīng"], ["gōng"], ["téng"]],
    "丁零当啷": [["dīng"], ["líng"], ["dāng"], ["lāng"]],
    "丁一卯二": [["dīng"], ["yī"], ["mǎo"], ["èr"]],
    "丁一确二": [["dīng"], ["yī"], ["què"], ["èr"]],
    "丁字尺": [["dīng"], ["zì"], ["chǐ"]],
    "丁字街": [["dīng"], ["zì"], ["jiē"]],
    "叮叮当当": [["dīng"], ["dīng"], ["dāng"], ["dāng"]],
    "钉齿耙": [["dīng"], ["chǐ"], ["bà"]],
    "钉头磷磷": [["ding"], ["tou"], ["lin"], ["lin"]],
    "钉子户": [["dīng"], ["zi"], ["hù"]],
    "钉嘴铁舌": [["dīng"], ["zuǐ"], ["tiě"], ["shé"]],
    "顶风冒雪": [["dǐng"], ["fēng"], ["mào"], ["xuě"]],
    "顶呱呱": [["dǐng"], ["guā"], ["guā"]],
    "顶门杠": [["dǐng"], ["mén"], ["gàng"]],
    "顶天踵地": [["dǐng"], ["tiān"], ["zhǒng"], ["dì"]],
    "顶天立地": [["dǐng"], ["tiān"], ["lì"], ["dì"]],
    "顶名冒姓": [["dǐng"], ["míng"], ["mào"], ["xìng"]],
    "顶头上司": [["dǐng"], ["tóu"], ["shàng"], ["sī"]],
    "顶踵尽捐": [["dǐng"], ["zhǒng"], ["jìn"], ["juān"]],
    "鼎铛玉石": [["dǐng"], ["chēng"], ["yù"], ["shí"]],
    "顶踵捐糜": [["dǐng"], ["zhǒng"], ["juān"], ["mí"]],
    "鼎铛有耳": [["dǐng"], ["chēng"], ["yǒu"], ["ěr"]],
    "鼎鼎大名": [["dǐng"], ["dǐng"], ["dà"], ["míng"]],
    "鼎鼎有名": [["dǐng"], ["dǐng"], ["yǒu"], ["míng"]],
    "鼎分三足": [["dǐng"], ["fēn"], ["sān"], ["zú"]],
    "鼎鼐调和": [["dǐng"], ["nai"], ["tiáo"], ["hé"]],
    "鼎食鸣钟": [["dǐng"], ["shí"], ["míng"], ["zhōng"]],
    "鼎食鸣锺": [["dǐng"], ["shí"], ["míng"], ["zhōng"]],
    "鼎食钟鸣": [["dǐng"], ["shí"], ["zhōng"], ["míng"]],
    "鼎鱼幕燕": [["dǐng"], ["yú"], ["mù"], ["yàn"]],
    "鼎玉龟符": [["dǐng"], ["yù"], ["guī"], ["fú"]],
    "鼎折覆餗": [["dǐng"], ["shé"], ["fù"], ["sù"]],
    "鼎折餗覆": [["dǐng"], ["shé"], ["sù"], ["fù"]],
    "鼎足三分": [["dǐng"], ["zú"], ["sān"], ["fēn"]],
    "定场白": [["dìng"], ["chǎng"], ["bái"]],
    "定场诗": [["dìng"], ["chǎng"], ["shī"]],
    "定调子": [["dìng"], ["diào"], ["zi"]],
    "定冠词": [["dìng"], ["guàn"], ["cí"]],
    "定货单": [["dìng"], ["huò"], ["dān"]],
    "定量分析": [["dìng"], ["liàng"], ["fēn"], ["xī"]],
    "定乱扶衰": [["dìng"], ["luàn"], ["fú"], ["shuāi"]],
    "定时炸弹": [["dìng"], ["shí"], ["zhà"], ["dàn"]],
    "定性分析": [["dìng"], ["xìng"], ["fēn"], ["xī"]],
    "丢魂丧胆": [["diu1"], ["hún"], ["sàng"], ["dǎn"]],
    "丢三落四": [["diū"], ["sān"], ["là"], ["sì"]],
    "丢三拉四": [["diu"], ["sān"], ["lā"], ["sì"]],
    "丢下耙儿弄扫帚": [["diū"], ["xià"], ["pá"], ["er"], ["nòng"], ["sào"], ["zhǒu"]],
    "丢卒保车": [["diū"], ["zú"], ["bǎo"], ["jū"]],
    "东挨西撞": [["dōng"], ["āi"], ["xī"], ["zhuàng"]],
    "东北虎": [["dōng"], ["běi"], ["hǔ"]],
    "东奔西窜": [["dōng"], ["bēn"], ["xī"], ["cuàn"]],
    "东奔西跑": [["dōng"], ["bēn"], ["xī"], ["pǎo"]],
    "东奔西逃": [["dōng"], ["bēn"], ["xī"], ["táo"]],
    "东奔西向": [["dōng"], ["bēn"], ["xī"], ["xiàng"]],
    "东奔西撞": [["dōng"], ["bēn"], ["xī"], ["zhuàng"]],
    "东奔西走": [["dōng"], ["bēn"], ["xī"], ["zǒu"]],
    "东猜西揣": [["dōng"], ["cāi"], ["xī"], ["chuāi"]],
    "东猜西疑": [["dōng"], ["cāi"], ["xī"], ["yí"]],
    "东差西误": [["dōng"], ["chà"], ["xī"], ["wù"]],
    "东藏西躲": [["dōng"], ["cáng"], ["xī"], ["duǒ"]],
    "东扯西拉": [["dōng"], ["chě"], ["xī"], ["lā"]],
    "东扯西拽": [["dōng"], ["chě"], ["xī"], ["zhuāi"]],
    "东冲西决": [["dōng"], ["chōng"], ["xī"], ["jué"]],
    "东冲西突": [["dōng"], ["chōng"], ["xī"], ["tū"]],
    "东冲西撞": [["dōng"], ["chōng"], ["xī"], ["zhuàng"]],
    "东窗事发": [["dōng"], ["chuāng"], ["shì"], ["fā"]],
    "东床择对": [["dōng"], ["chuáng"], ["zé"], ["duì"]],
    "东床姣婿": [["dōng"], ["chuáng"], ["jiāo"], ["xù"]],
    "东倒西歪": [["dōng"], ["dǎo"], ["xī"], ["wāi"]],
    "东躲西藏": [["dōng"], ["duǒ"], ["xī"], ["cáng"]],
    "东躲西跑": [["dōng"], ["duǒ"], ["xī"], ["pǎo"]],
    "东方不亮西方亮": [["dōng"], ["fāng"], ["bù"], ["liàng"], ["xī"], ["fāng"], ["liàng"]],
    "东方将白": [["dong"], ["fang"], ["jiang"], ["bai"]],
    "东方文化": [["dōng"], ["fāng"], ["wén"], ["huà"]],
    "东风吹马耳": [["dōng"], ["fēng"], ["chuī"], ["mǎ"], ["ěr"]],
    "东风过耳": [["dōng"], ["fēng"], ["guò"], ["ěr"]],
    "东风浩荡": [["dōng"], ["fēng"], ["hào"], ["dàng"]],
    "东风化雨": [["dōng"], ["fēng"], ["huà"], ["yǔ"]],
    "东风马耳": [["dōng"], ["fēng"], ["mǎ"], ["ěr"]],
    "东风人面": [["dōng"], ["fēng"], ["rén"], ["miàn"]],
    "东风入律": [["dōng"], ["fēng"], ["rù"], ["lǜ"]],
    "东风射马耳": [["dōng"], ["fēng"], ["shè"], ["mǎ"], ["ěr"]],
    "东风压倒西风": [["dōng"], ["fēng"], ["yā"], ["dǎo"], ["xī"], ["fēng"]],
    "东扶西倒": [["dōng"], ["fú"], ["xī"], ["dǎo"]],
    "东观西望": [["dōng"], ["guāng"], ["xī"], ["wàng"]],
    "东观续史": [["dōng"], ["guān"], ["xù"], ["shǐ"]],
    "东观之殃": [["dōng"], ["guān"], ["zhī"], ["yāng"]],
    "东横西倒": [["dōng"], ["héng"], ["xī"], ["dǎo"]],
    "东家西舍": [["dōng"], ["jiā"], ["xī"], ["shě"]],
    "东家效颦": [["dōng"], ["jiā"], ["xiào"], ["pín"]],
    "东箭南金": [["dōng"], ["jiàn"], ["nán"], ["jīn"]],
    "东京大学": [["dōng"], ["jīng"], ["dà"], ["xué"]],
    "东拉西扯": [["dōng"], ["lā"], ["xī"], ["chě"]],
    "东劳西燕": [["dōng"], ["láo"], ["xī"], ["yàn"]],
    "东量西折": [["dōng"], ["liàng"], ["xī"], ["shé"]],
    "东鳞西爪": [["dōng"], ["lín"], ["xī"], ["zhǎo"]],
    "东零西落": [["dōng"], ["líng"], ["xī"], ["luò"]],
    "东零西散": [["dōng"], ["líng"], ["xī"], ["sàn"]],
    "东流西上": [["dōng"], ["liú"], ["xī"], ["shàng"]],
    "东流西落": [["dōng"], ["liú"], ["xī"], ["luò"]],
    "东鸣西应": [["dōng"], ["míng"], ["xī"], ["yīng"]],
    "东抹西涂": [["dōng"], ["mò"], ["xī"], ["tú"]],
    "东南半壁": [["dōng"], ["nán"], ["bàn"], ["bì"]],
    "东南欧": [["dōng"], ["nán"], ["ōu"]],
    "东南雀飞": [["dōng"], ["nán"], ["què"], ["fēi"]],
    "东南亚": [["dōng"], ["nán"], ["yà"]],
    "东南亚国家联盟": [["dōng"], ["nán"], ["yà"], ["guó"], ["jiā"], ["lián"], ["méng"]],
    "东南之宝": [["dōng"], ["nán"], ["zhī"], ["bǎo"]],
    "东南之美": [["dōng"], ["nán"], ["zhī"], ["měi"]],
    "东南之秀": [["dōng"], ["nán"], ["zhī"], ["xiù"]],
    "东南竹箭": [["dōng"], ["nán"], ["zhú"], ["jiàn"]],
    "东挪西撮": [["dōng"], ["nuó"], ["xī"], ["cuō"]],
    "东跑西颠": [["dōng"], ["pǎo"], ["xī"], ["diān"]],
    "东飘西泊": [["dōng"], ["piāo"], ["xī"], ["bó"]],
    "东墙处子": [["dōng"], ["qiáng"], ["chǔ"], ["zǐ"]],
    "东趋西步": [["dōng"], ["qū"], ["xī"], ["bù"]],
    "东萨摩亚": [["dōng"], ["sà"], ["mó"], ["yà"]],
    "东三省": [["dōng"], ["sān"], ["xǐng"]],
    "东食西宿": [["dōng"], ["shí"], ["xī"], ["sù"]],
    "东市朝衣": [["dōng"], ["shì"], ["cháo"], ["yī"]],
    "东涂西抹": [["dōng"], ["tú"], ["xī"], ["mǒ"]],
    "东谈西说": [["dōng"], ["tán"], ["xī"], ["shuō"]],
    "东歪西倒": [["dōng"], ["wāi"], ["xī"], ["dǎo"]],
    "东望西观": [["dōng"], ["wàng"], ["xī"], ["guān"]],
    "东西南北": [["dōng"], ["xī"], ["nán"], ["běi"]],
    "东西南北客": [["dōng"], ["xi"], ["nán"], ["běi"], ["kè"]],
    "东西南北人": [["dōng"], ["xi"], ["nán"], ["běi"], ["rén"]],
    "东西南朔": [["dōng"], ["xī"], ["nán"], ["shuò"]],
    "东踅西倒": [["dōng"], ["xué"], ["xī"], ["dǎo"]],
    "东洋车": [["dōng"], ["yáng"], ["chē"]],
    "东洋大海": [["dōng"], ["yáng"], ["dà"], ["hǎi"]],
    "东印度公司": [["dōng"], ["yìn"], ["dù"], ["gōng"], ["sī"]],
    "东张西觑": [["dōng"], ["zhāng"], ["xī"], ["qù"]],
    "东正教": [["dōng"], ["zhèng"], ["jiào"]],
    "东支西吾": [["dōng"], ["zhī"], ["xī"], ["wú"]],
    "东撙西节": [["dōng"], ["zǔn"], ["xī"], ["jié"]],
    "冬不拉": [["dōng"], ["bù"], ["lā"]],
    "冬烘头脑": [["dōng"], ["hōng"], ["tóu"], ["nǎo"]],
    "冬裘夏葛": [["dōng"], ["qiú"], ["xià"], ["gě"]],
    "冬扇夏炉": [["dōng"], ["shàn"], ["xià"], ["lú"]],
    "冬日可爱": [["dōng"], ["rì"], ["kě"], ["ài"]],
    "董事会": [["dǒng"], ["shì"], ["huì"]],
    "动不动": [["dòng"], ["bù"], ["dòng"]],
    "动不失时": [["dòng"], ["bù"], ["shī"], ["shí"]],
    "动荡不安": [["dòng"], ["dàng"], ["bù"], ["ān"]],
    "动荡不定": [["dòng"], ["dàng"], ["bù"], ["dìng"]],
    "动地惊天": [["dòng"], ["dì"], ["jīng"], ["tiān"]],
    "动画片": [["dòng"], ["huà"], ["piān"]],
    "动画影片": [["dòng"], ["huà"], ["yǐng"], ["piān"]],
    "动静有常": [["dòng"], ["jìng"], ["yǒu"], ["cháng"]],
    "动脉弓": [["dòng"], ["mài"], ["gōng"]],
    "动脉硬化": [["dòng"], ["mài"], ["yìng"], ["huà"]],
    "动脉粥样硬化": [["dòng"], ["mài"], ["zhōu"], ["yàng"], ["yìng"], ["huà"]],
    "动如参商": [["dòng"], ["rú"], ["cān"], ["shāng"]],
    "动手术": [["dòng"], ["shǒu"], ["shù"]],
    "动物纤维": [["dòng"], ["wù"], ["xiān"], ["wéi"]],
    "动辄得咎": [["dòng"], ["zhé"], ["dé"], ["jiù"]],
    "动员令": [["dòng"], ["yuán"], ["lìng"]],
    "动中窾要": [["dòng"], ["zhōng"], ["zhe"], ["yào"]],
    "冻解冰释": [["dòng"], ["jiě"], ["bīng"], ["shì"]],
    "恫疑虚喝": [["dòng"], ["yí"], ["xū"], ["hè"]],
    "恫疑虚猲": [["dòng"], ["yí"], ["xū"], ["gé"]],
    "栋折榱崩": [["dòng"], ["zhé"], ["cuī"], ["bēng"]],
    "栋折榱坏": [["dòng"], ["shé"], ["cuī"], ["huài"]],
    "洞察其奸": [["dòng"], ["chá"], ["qí"], ["jiān"]],
    "洞察一切": [["dòng"], ["chá"], ["yī"], ["qiè"]],
    "洞见症结": [["dòng"], ["jiàn"], ["zhèng"], ["jié"]],
    "洞鉴废兴": [["dòng"], ["jiàn"], ["fèi"], ["xīng"]],
    "洞如观火": [["dòng"], ["rú"], ["guān"], ["huǒ"]],
    "洞若观火": [["dòng"], ["ruò"], ["guān"], ["huǒ"]],
    "洞天福地": [["dòng"], ["tiān"], ["fú"], ["dì"]],
    "洞隐烛微": [["dòng"], ["yǐn"], ["zhú"], ["wēi"]],
    "洞幽烛远": [["dòng"], ["yōu"], ["zhú"], ["yuǎn"]],
    "洞中肯綮": [["dòng"], ["zhōng"], ["kěn"], ["qìng"]],
    "洞烛其奸": [["dòng"], ["zhú"], ["qí"], ["jiān"]],
    "都柏林": [["dōu"], ["bó"], ["lín"]],
    "都察院": [["dū"], ["chá"], ["yuàn"]],
    "都江堰": [["dū"], ["jiāng"], ["yàn"]],
    "都头异姓": [["dū"], ["tóu"], ["yì"], ["xìng"]],
    "都俞吁咈": [["dōu"], ["yú"], ["xū"], ["fú"]],
    "都中纸贵": [["dū"], ["zhōng"], ["zhǐ"], ["guì"]],
    "兜肚连肠": [["dōu"], ["dǔ"], ["lián"], ["cháng"]],
    "兜头盖脸": [["dōu"], ["tóu"], ["gài"], ["liǎn"]],
    "斗唇合舌": [["dòu"], ["chún"], ["hé"], ["shé"]],
    "斗而铸兵": [["dòu"], ["ér"], ["zhù"], ["bīng"]],
    "斗而铸锥": [["dòu"], ["ér"], ["zhù"], ["zhuī"]],
    "斗方名士": [["dǒu"], ["fāng"], ["míng"], ["shì"]],
    "斗怪争奇": [["dòu"], ["guài"], ["zhēng"], ["qí"]],
    "斗鸡眼": [["dòu"], ["jī"], ["yǎn"]],
    "斗鸡养狗": [["dòu"], ["jī"], ["yǎng"], ["gǒu"]],
    "斗鸡走狗": [["dòu"], ["jī"], ["zǒu"], ["gǒu"]],
    "斗鸡走马": [["dòu"], ["jī"], ["zǒu"], ["mǎ"]],
    "斗鸡走犬": [["dòu"], ["jī"], ["zǒu"], ["quǎn"]],
    "斗酒百篇": [["dǒu"], ["jiǔ"], ["bǎi"], ["piān"]],
    "斗酒双柑": [["dòu"], ["jiǔ"], ["shuāng"], ["gān"]],
    "斗酒学士": [["dǒu"], ["jiǔ"], ["xué"], ["shì"]],
    "斗酒只鸡": [["dǒu"], ["jiǔ"], ["zhī"], ["jī"]],
    "斗绝一隅": [["dǒu"], ["jué"], ["yī"], ["yú"]],
    "斗丽争妍": [["dòu"], ["lì"], ["zhēng"], ["yán"]],
    "斗量筲计": [["dǒu"], ["liáng"], ["shāo"], ["jì"]],
    "斗量车载": [["dǒu"], ["liáng"], ["chē"], ["zài"]],
    "斗美夸丽": [["dòu"], ["měi"], ["kuā"], ["lì"]],
    "斗媚争妍": [["dòu"], ["mèi"], ["zhēng"], ["yán"]],
    "斗牛场": [["dòu"], ["niú"], ["chǎng"]],
    "斗米尺布": [["dǒu"], ["mǐ"], ["chǐ"], ["bù"]],
    "斗南一人": [["dǒu"], ["nán"], ["yī"], ["rén"]],
    "斗色争妍": [["dòu"], ["sè"], ["zhēng"], ["yán"]],
    "斗筲穿窬": [["dòu"], ["shāo"], ["chuān"], ["yú"]],
    "斗筲之器": [["dǒu"], ["shāo"], ["zhī"], ["qì"]],
    "斗筲之人": [["dǒu"], ["shāo"], ["zhī"], ["rén"]],
    "斗升之水": [["dǒu"], ["shēng"], ["zhī"], ["shuǐ"]],
    "斗霜傲雪": [["dòu"], ["shuāng"], ["ào"], ["xuě"]],
    "斗水活鳞": [["dòu"], ["shuǐ"], ["huó"], ["lín"]],
    "斗粟尺布": [["dǒu"], ["sù"], ["chǐ"], ["bù"]],
    "斗榫合缝": [["dǒu"], ["sǔn"], ["hé"], ["fèng"]],
    "斗蟋蟀": [["dòu"], ["xī"], ["shuài"]],
    "斗心眼儿": [["dòu"], ["xīn"], ["yǎn"], ["ér"]],
    "斗艳争芳": [["dòu"], ["yàn"], ["zhēng"], ["fāng"]],
    "斗牙拌齿": [["dòu"], ["yá"], ["bàn"], ["chǐ"]],
    "斗艳争辉": [["dòu"], ["yàn"], ["zhēng"], ["huī"]],
    "斗艳争妍": [["dòu"], ["yàn"], ["zhēng"], ["yán"]],
    "斗折蛇行": [["dǒu"], ["zhé"], ["shé"], ["xíng"]],
    "斗挹箕扬": [["dǒu"], ["yì"], ["jī"], ["yáng"]],
    "斗争性": [["dòu"], ["zhēng"], ["xìng"]],
    "斗志昂扬": [["dòu"], ["zhì"], ["áng"], ["yáng"]],
    "斗转参横": [["dǒu"], ["zhuǎn"], ["shēn"], ["héng"]],
    "斗转星移": [["dǒu"], ["zhuǎn"], ["xīng"], ["yí"]],
    "抖威风": [["dǒu"], ["wēi"], ["fēng"]],
    "抖擞精神": [["dǒu"], ["sǒu"], ["jīng"], ["shén"]],
    "豆分瓜剖": [["dòu"], ["fēn"], ["guā"], ["pōu"]],
    "豆腐干": [["dòu"], ["fǔ"], ["gàn"]],
    "豆角儿": [["dòu"], ["jué"], ["ér"]],
    "豆蔻年华": [["dòu"], ["kòu"], ["nián"], ["huá"]],
    "豆剖瓜分": [["dòu"], ["pōu"], ["guā"], ["fēn"]],
    "豆萁相煎": [["dòu"], ["qí"], ["xiāng"], ["jiān"]],
    "逗闷子": [["dòu"], ["mèn"], ["zǐ"]],
    "豆重榆瞑": [["dòu"], ["chóng"], ["yú"], ["míng"]],
    "逗趣儿": [["dòu"], ["qù"], ["ér"]],
    "毒赋剩敛": [["dú"], ["fù"], ["shèng"], ["liǎn"]],
    "毒辣辣": [["dú"], ["là"], ["là"]],
    "毒魔狠怪": [["dú"], ["mó"], ["hěn"], ["guài"]],
    "毒泷恶雾": [["dú"], ["lóng"], ["è"], ["wù"]],
    "毒手尊前": [["dú"], ["shǒu"], ["zūn"], ["qián"]],
    "毒蛇猛兽": [["dú"], ["shé"], ["měng"], ["shòu"]],
    "毒手尊拳": [["dú"], ["shǒu"], ["zūn"], ["quán"]],
    "毒瓦斯": [["dú"], ["wǎ"], ["sī"]],
    "读不舍手": [["dú"], ["bù"], ["shě"], ["shǒu"]],
    "读后感": [["dú"], ["hòu"], ["gǎn"]],
    "读书笔记": [["dú"], ["shū"], ["bǐ"], ["jì"]],
    "读书得间": [["dú"], ["shū"], ["dé"], ["jiàn"]],
    "读书君子": [["dú"], ["shū"], ["jūn"], ["zǐ"]],
    "读书人": [["dú"], ["shū"], ["rén"]],
    "读书三到": [["dú"], ["shū"], ["sān"], ["dào"]],
    "读书三余": [["dú"], ["shū"], ["sān"], ["yú"]],
    "读书种子": [["dú"], ["shū"], ["zhǒng"], ["zǐ"]],
    "读者文摘": [["dú"], ["zhě"], ["wén"], ["zhāi"]],
    "渎职罪": [["dú"], ["zhí"], ["zuì"]],
    "犊牧采薪": [["dú"], ["mù"], ["cǎi"], ["xīn"]],
    "独辟蹊径": [["dú"], ["pì"], ["xī"], ["jìng"]],
    "独步当时": [["dú"], ["bù"], ["dāng"], ["shí"]],
    "独步当世": [["dú"], ["bù"], ["dāng"], ["shì"]],
    "独出己见": [["dú"], ["chū"], ["jǐ"], ["jiàn"]],
    "独当一面": [["dú"], ["dāng"], ["yī"], ["miàn"]],
    "独到之处": [["dú"], ["dào"], ["zhī"], ["chù"]],
    "独得之见": [["dú"], ["dé"], ["zhī"], ["jiàn"]],
    "独断专行": [["dú"], ["duàn"], ["zhuān"], ["xíng"]],
    "独断独行": [["dú"], ["duàn"], ["dú"], ["xíng"]],
    "独夫民贼": [["dú"], ["fū"], ["mín"], ["zéi"]],
    "独角戏": [["dú"], ["jiǎo"], ["xì"]],
    "独脚戏": [["dú"], ["jiǎo"], ["xì"]],
    "独具只眼": [["dú"], ["jù"], ["zhī"], ["yǎn"]],
    "独揽大权": [["dú"], ["lǎn"], ["dà"], ["quán"]],
    "独立王国": [["dú"], ["lì"], ["wáng"], ["guó"]],
    "独轮车": [["dú"], ["lún"], ["chē"]],
    "独木不成林": [["dú"], ["mù"], ["bù"], ["chéng"], ["lín"]],
    "独木不林": [["dú"], ["mù"], ["bù"], ["lín"]],
    "独木难支": [["dú"], ["mù"], ["nán"], ["zhī"]],
    "独善其身": [["dú"], ["shàn"], ["qí"], ["shēn"]],
    "独善吾身": [["dú"], ["shàn"], ["wú"], ["shēn"]],
    "独生女": [["dú"], ["shēng"], ["nǚ"]],
    "独行独断": [["dú"], ["xíng"], ["dú"], ["duàn"]],
    "独行踽踽": [["dú"], ["xíng"], ["jǔ"], ["jǔ"]],
    "独行其是": [["dú"], ["xíng"], ["qí"], ["shì"]],
    "独行其道": [["dú"], ["xíng"], ["qí"], ["dào"]],
    "独有千古": [["dú"], ["yǒu"], ["qiān"], ["gǔ"]],
    "独有千秋": [["dú"], ["yòu"], ["qiān"], ["qiū"]],
    "独占鳌头": [["dú"], ["zhàn"], ["áo"], ["tóu"]],
    "笃而论之": [["dǔ"], ["ér"], ["lùn"], ["zhī"]],
    "笃近举远": [["dǔ"], ["jìn"], ["jǔ"], ["juǎn"]],
    "笃论高言": [["dǔ"], ["lùn"], ["gāo"], ["yán"]],
    "笃实好学": [["dǔ"], ["shí"], ["hào"], ["xué"]],
    "笃信好学": [["dǔ"], ["xìn"], ["hào"], ["xué"]],
    "笃学不倦": [["dǔ"], ["xué"], ["bù"], ["juàn"]],
    "笃学好古": [["dǔ"], ["xué"], ["hào"], ["gǔ"]],
    "赌长较短": [["dǔ"], ["cháng"], ["jiào"], ["duǎn"]],
    "笃志好学": [["dǔ"], ["zhì"], ["hǎo"], ["xué"]],
    "赌神发咒": [["dǔ"], ["shén"], ["fā"], ["zhòu"]],
    "赌誓发原": [["dǔ"], ["shì"], ["fā"], ["yuán"]],
    "赌誓发愿": [["dǔ"], ["shì"], ["fā"], ["yuàn"]],
    "睹景伤情": [["dǔ"], ["jǐng"], ["shāng"], ["qíng"]],
    "赌咒发誓": [["dǔ"], ["zhòu"], ["fā"], ["shì"]],
    "睹始知终": [["dǔ"], ["shǐ"], ["zhī"], ["zhōng"]],
    "睹微知著": [["dǔ"], ["wēi"], ["zhī"], ["zhù"]],
    "睹物思人": [["dǔ"], ["wù"], ["sī"], ["rén"]],
    "睹物兴情": [["dǔ"], ["wù"], ["xīng"], ["qíng"]],
    "睹著知微": [["dǔ"], ["zhù"], ["zhī"], ["wēi"]],
    "睹着知微": [["dǔ"], ["zhe"], ["zhī"], ["wēi"]],
    "妒能害贤": [["dù"], ["néng"], ["hài"], ["xián"]],
    "妒贤疾能": [["dù"], ["xián"], ["jí"], ["néng"]],
    "妒贤嫉能": [["dù"], ["xián"], ["jí"], ["néng"]],
    "杜耳恶闻": [["dù"], ["ěr"], ["è"], ["wén"]],
    "杜渐除微": [["dù"], ["jiàn"], ["chú"], ["wēi"]],
    "杜渐防萌": [["dù"], ["jiàn"], ["fáng"], ["méng"]],
    "杜渐防微": [["dù"], ["jiàn"], ["fáng"], ["wēi"]],
    "杜鹃啼血": [["dù"], ["juān"], ["tí"], ["xuě"]],
    "杜口结舌": [["dù"], ["kǒu"], ["jié"], ["shé"]],
    "杜门不出": [["dù"], ["mén"], ["bù"], ["chū"]],
    "杜门屏迹": [["dù"], ["mén"], ["píng"], ["jì"]],
    "杜门却扫": [["dù"], ["mén"], ["què"], ["sǎo"]],
    "杜默为诗": [["dù"], ["mò"], ["wéi"], ["shī"]],
    "肚里蛔虫": [["dù"], ["lǐ"], ["huí"], ["chóng"]],
    "肚里泪下": [["dù"], ["lǐ"], ["lèi"], ["xià"]],
    "度长絜大": [["dù"], ["cháng"], ["xié"], ["dà"]],
    "度德量力": [["duó"], ["dé"], ["liàng"], ["lì"]],
    "度长絜短": [["dù"], ["cháng"], ["xié"], ["duǎn"]],
    "度己以绳": [["duó"], ["jǐ"], ["yǐ"], ["shéng"]],
    "度假村": [["dù"], ["jià"], ["cūn"]],
    "度量衡": [["dù"], ["liàng"], ["héng"]],
    "度蜜月": [["dù"], ["mì"], ["yuè"]],
    "度日如年": [["dù"], ["rì"], ["rú"], ["nián"]],
    "度外之人": [["dù"], ["wài"], ["zhī"], ["rén"]],
    "度日如岁": [["dù"], ["rì"], ["rú"], ["suì"]],
    "蠹居棊处": [["dù"], ["jū"], ["què"], ["chǔ"]],
    "蠹居棋处": [["dù"], ["jū"], ["qí"], ["chǔ"]],
    "蠹众木折": [["dù"], ["zhòng"], ["mù"], ["zhé"]],
    "端本澄源": [["duān"], ["běn"], ["chéng"], ["yuán"]],
    "端本正源": [["duān"], ["běn"], ["zhèng"], ["yuán"]],
    "端倪可察": [["duān"], ["ní"], ["kě"], ["chá"]],
    "端人正士": [["duān"], ["rén"], ["zhèng"], ["shì"]],
    "端午节": [["duān"], ["wǔ"], ["jié"]],
    "短兵相接": [["duǎn"], ["bīng"], ["xiāng"], ["jiē"]],
    "短不了": [["duǎn"], ["bù"], ["liǎo"]],
    "短吃少穿": [["duǎn"], ["chī"], ["shǎo"], ["chuān"]],
    "短歌行": [["duǎn"], ["gē"], ["xíng"]],
    "短褐不完": [["duān"], ["hè"], ["bù"], ["wán"]],
    "短褐穿结": [["duǎn"], ["hè"], ["chuān"], ["jié"]],
    "短见薄识": [["duǎn"], ["jiàn"], ["bó"], ["shí"]],
    "短篇小说": [["duǎn"], ["piān"], ["xiǎo"], ["shuō"]],
    "短叹长吁": [["duǎn"], ["tàn"], ["cháng"], ["xū"]],
    "短中取长": [["duǎn"], ["zhōng"], ["qǔ"], ["cháng"]],
    "断长补短": [["duàn"], ["chāng"], ["bǔ"], ["duǎn"]],
    "断长续短": [["duàn"], ["chāng"], ["xù"], ["duǎn"]],
    "断发文身": [["duàn"], ["fà"], ["wén"], ["shēn"]],
    "断发纹身": [["duàn"], ["fā"], ["wén"], ["shēn"]],
    "断管残沈": [["duàn"], ["guǎn"], ["cán"], ["shěn"]],
    "断还归宗": [["duàn"], ["huán"], ["guī"], ["zōng"]],
    "断根绝种": [["duàn"], ["gēn"], ["jué"], ["zhǒng"]],
    "断齑画粥": [["duàn"], ["jī"], ["huà"], ["zhōu"]],
    "断蛟刺虎": [["duàn"], ["jiāo"], ["cì"], ["hǔ"]],
    "断缣尺楮": [["duàn"], ["jiān"], ["chǐ"], ["chǔ"]],
    "断齑块粥": [["duàn"], ["jī"], ["kuài"], ["zhōu"]],
    "断烂朝报": [["duàn"], ["làn"], ["cháo"], ["bào"]],
    "断木掘地": [["duàn"], ["mù"], ["jué"], ["dì"]],
    "断头将军": [["duàn"], ["tóu"], ["jiāng"], ["jūn"]],
    "断线风筝": [["duàn"], ["xiàn"], ["fēng"], ["zhēng"]],
    "断头台": [["duàn"], ["tóu"], ["tái"]],
    "断线偶戏": [["duàn"], ["xiàn"], ["ǒu"], ["xì"]],
    "断章截句": [["duàn"], ["zhāng"], ["jié"], ["jù"]],
    "断雨残云": [["duàn"], ["yǔ"], ["cán"], ["yún"]],
    "断章摘句": [["duàn"], ["zhāng"], ["zhāi"], ["jù"]],
    "断织之诫": [["duàn"], ["zhī"], ["zhī"], ["jiè"]],
    "断织劝学": [["duàn"], ["zhī"], ["quàn"], ["xué"]],
    "断杼择邻": [["duàn"], ["zhù"], ["zé"], ["lín"]],
    "断子绝孙": [["duàn"], ["zǐ"], ["jué"], ["sūn"]],
    "堆案盈几": [["duī"], ["àn"], ["yíng"], ["jī"]],
    "对比度": [["duì"], ["bǐ"], ["dù"]],
    "对薄公堂": [["duì"], ["bù"], ["gōng"], ["táng"]],
    "对不起": [["duì"], ["bù"], ["qǐ"]],
    "对不住": [["duì"], ["bú"], ["zhù"]],
    "对簿公堂": [["duì"], ["bù"], ["gōng"], ["táng"]],
    "对称性": [["duì"], ["chèn"], ["xìng"]],
    "对称轴": [["duì"], ["chèn"], ["zhóu"]],
    "对床风雨": [["duì"], ["chuáng"], ["fēng"], ["yǔ"]],
    "对床夜雨": [["duì"], ["chuáng"], ["yè"], ["yǔ"]],
    "对床夜语": [["duì"], ["chuáng"], ["yè"], ["yǔ"]],
    "对答如流": [["duì"], ["dá"], ["rú"], ["liú"]],
    "对得起": [["duì"], ["de"], ["qǐ"]],
    "对得住": [["duì"], ["de"], ["zhù"]],
    "对号入座": [["duì"], ["hào"], ["rù"], ["zuò"]],
    "对角线": [["duì"], ["jiǎo"], ["xiàn"]],
    "对景挂画": [["duì"], ["jǐng"], ["guà"], ["huà"]],
    "对景伤情": [["duì"], ["jǐng"], ["shāng"], ["qíng"]],
    "对酒当歌": [["duì"], ["jiǔ"], ["dāng"], ["gē"]],
    "对空射击": [["duì"], ["kōng"], ["shè"], ["jī"]],
    "对口相声": [["duì"], ["kǒu"], ["xiàng"], ["sheng"]],
    "对牛弹琴": [["duì"], ["niú"], ["tán"], ["qín"]],
    "对台戏": [["duì"], ["tái"], ["xì"]],
    "对头冤家": [["duì"], ["tóu"], ["yuān"], ["jiā"]],
    "对症发药": [["duì"], ["zhèng"], ["fā"], ["yào"]],
    "对症之药": [["duì"], ["zhèng"], ["zhī"], ["yào"]],
    "对症下药": [["duì"], ["zhèng"], ["xià"], ["yào"]],
    "对着干": [["duì"], ["zhe"], ["gàn"]],
    "兑换券": [["duì"], ["huàn"], ["quàn"]],
    "敦本务实": [["dūn"], ["běn"], ["wù"], ["shí"]],
    "敦风厉俗": [["dūn"], ["fēng"], ["lì"], ["sú"]],
    "敦煌石窟": [["dūn"], ["huáng"], ["shí"], ["kū"]],
    "敦默寡言": [["dūn"], ["mò"], ["guǎ"], ["yán"]],
    "敦诗说礼": [["dūn"], ["shī"], ["shuō"], ["lǐ"]],
    "敦世厉俗": [["dūn"], ["shì"], ["lì"], ["sú"]],
    "囤积居奇": [["tún"], ["jī"], ["jū"], ["qí"]],
    "顿开茅塞": [["dùn"], ["kāi"], ["máo"], ["sè"]],
    "顿纲振纪": [["dùn"], ["gāng"], ["zhèn"], ["jì"]],
    "顿学累功": [["dùn"], ["xué"], ["lěi"], ["gōng"]],
    "顿足不前": [["dùn"], ["zú"], ["bù"], ["qián"]],
    "顿足椎胸": [["dùn"], ["zú"], ["zhuī"], ["xiōng"]],
    "遁迹藏名": [["dùn"], ["jì"], ["cáng"], ["míng"]],
    "遁迹黄冠": [["dùn"], ["jì"], ["huáng"], ["guàn"]],
    "遁迹空门": [["dùn"], ["jì"], ["kōng"], ["mén"]],
    "遁身远迹": [["dùn"], ["shēn"], ["yuǎn"], ["jì"]],
    "遁入空门": [["dùn"], ["rù"], ["kōng"], ["mén"]],
    "遁世长往": [["dùn"], ["shì"], ["cháng"], ["wǎng"]],
    "遁世无闷": [["dùn"], ["shì"], ["wú"], ["mèn"]],
    "遁世隐居": [["dùn"], ["shì"], ["yǐn"], ["jū"]],
    "遁俗无闷": [["dùn"], ["sú"], ["wú"], ["mèn"]],
    "遁天妄行": [["dùn"], ["tiān"], ["wàng"], ["xíng"]],
    "遁逸无闷": [["dùn"], ["yì"], ["wú"], ["mèn"]],
    "遁形远世": [["dùn"], ["xíng"], ["yuǎn"], ["shì"]],
    "遁阴匿景": [["dùn"], ["yīn"], ["nì"], ["jǐng"]],
    "多倍体": [["duō"], ["bèi"], ["tǐ"]],
    "多财善贾": [["duō"], ["cái"], ["shàn"], ["gǔ"]],
    "多藏厚亡": [["duō"], ["cáng"], ["hòu"], ["wáng"]],
    "多吃多占": [["duō"], ["chī"], ["duō"], ["zhàn"]],
    "多弹头": [["duō"], ["dàn"], ["tóu"]],
    "多动症": [["duō"], ["dòng"], ["zhèng"]],
    "多端寡要": [["duō"], ["duān"], ["guǎi"], ["yào"]],
    "多发病": [["duō"], ["fā"], ["bìng"]],
    "多多少少": [["duō"], ["duō"], ["shǎo"], ["shǎo"]],
    "多见广识": [["duō"], ["jiàn"], ["guǎng"], ["shí"]],
    "多会儿": [["duō"], ["huì"], ["er"]],
    "多角形": [["duō"], ["jiǎo"], ["xíng"]],
    "多晶体": [["duō"], ["jīng"], ["tǐ"]],
    "多口相声": [["duō"], ["kǒu"], ["xiàng"], ["sheng"]],
    "多口阿师": [["duō"], ["kǒu"], ["ā"], ["shī"]],
    "多快好省": [["duō"], ["kuài"], ["hǎo"], ["shěng"]],
    "多劳多得": [["duō"], ["láo"], ["duō"], ["de"]],
    "多棱镜": [["duō"], ["léng"], ["jìng"]],
    "多面角": [["duō"], ["miàn"], ["jiǎo"]],
    "多米尼加共和国": [["duō"], ["mǐ"], ["ní"], ["jiā"], ["gòng"], ["hé"], ["guó"]],
    "多民族国家": [["duō"], ["mín"], ["zú"], ["guó"], ["jiā"]],
    "多难兴邦": [["duō"], ["nàn"], ["xīng"], ["bāng"]],
    "多面体": [["duō"], ["miàn"], ["tǐ"]],
    "多能多艺": [["duō"], ["néng"], ["duō"], ["yì"]],
    "多普勒效应": [["duō"], ["pǔ"], ["lè"], ["xiào"], ["yìng"]],
    "多歧亡羊": [["duō"], ["qí"], ["wáng"], ["yáng"]],
    "多钱善贾": [["duō"], ["qián"], ["shàn"], ["gǔ"]],
    "多神教": [["duō"], ["shén"], ["jiào"]],
    "多收并畜": [["duō"], ["shōu"], ["bìng"], ["chù"]],
    "多文强记": [["duō"], ["wén"], ["qiáng"], ["jì"]],
    "多文为富": [["duō"], ["wén"], ["wéi"], ["fù"]],
    "多闻阙疑": [["duō"], ["wén"], ["quē"], ["yí"]],
    "多闻强记": [["duō"], ["wén"], ["qiáng"], ["jì"]],
    "多行不义必自毙": [["duō"], ["xíng"], ["bù"], ["yì"], ["bì"], ["zì"], ["bì"]],
    "多凶少吉": [["duō"], ["xiōng"], ["shǎo"], ["jí"]],
    "多许少与": [["duō"], ["xǔ"], ["shǎo"], ["yǔ"]],
    "多言繁称": [["duō"], ["yán"], ["fán"], ["chēng"]],
    "多言多语": [["duō"], ["yán"], ["duō"], ["yǔ"]],
    "多言或中": [["duō"], ["yán"], ["huò"], ["zhōng"]],
    "多言数穷": [["duō"], ["yán"], ["shuò"], ["qióng"]],
    "多一事不如少一事": [["duō"], ["yī"], ["shì"], ["bù"], ["rú"], ["shǎo"], ["yī"], ["shì"]],
    "多一事不如省一事": [["duō"], ["yī"], ["shì"], ["bù"], ["rú"], ["shěng"], ["yī"], ["shì"]],
    "多元论": [["duō"], ["yuán"], ["lùn"]],
    "多灾多难": [["duō"], ["zāi"], ["duō"], ["nàn"]],
    "多种多样": [["duō"], ["zhǒng"], ["duō"], ["yàng"]],
    "多嘴献浅": [["duō"], ["zuǐ"], ["xiàn"], ["qiǎn"]],
    "咄咄书空": [["duō"], ["duō"], ["shū"], ["kōng"]],
    "咄嗟便办": [["duō"], ["jiē"], ["biàn"], ["bàn"]],
    "咄嗟之间": [["duō"], ["jiē"], ["zhī"], ["jiān"]],
    "夺人所好": [["duó"], ["rén"], ["suǒ"], ["hào"]],
    "夺其谈经": [["duó"], ["qí"], ["tán"], ["jīng"]],
    "夺胎换骨": [["duó"], ["tāi"], ["huàn"], ["gǔ"]],
    "掇菁撷华": [["duō"], ["jīng"], ["xié"], ["huá"]],
    "掇青拾紫": [["duō"], ["qīng"], ["shí"], ["zǐ"]],
    "掇拾章句": [["duō"], ["shí"], ["zhāng"], ["jù"]],
    "朵颐大嚼": [["duǒ"], ["yī"], ["dà"], ["jiáo"]],
    "堕溷飘茵": [["duò"], ["hùn"], ["piāo"], ["yīn"]],
    "躲猫猫": [["duǒ"], ["māo"], ["māo"]],
    "堕云雾中": [["duò"], ["yún"], ["wù"], ["zhōng"]],
    "堕甑不顾": [["duò"], ["zèng"], ["bù"], ["gù"]],
    "惰性气体": [["duò"], ["xìng"], ["qì"], ["tǐ"]],
    "讹以传讹": [["é"], ["yǐ"], ["chuán"], ["é"]],
    "屙金溺银": [["ē"], ["jīn"], ["niào"], ["yín"]],
    "峨冠博带": [["é"], ["guān"], ["bó"], ["dài"]],
    "峨峨汤汤": [["é"], ["é"], ["shāng"], ["shāng"]],
    "鹅不食草": [["é"], ["bù"], ["shí"], ["cǎo"]],
    "鹅湖之会": [["é"], ["hú"], ["zhī"], ["huì"]],
    "鹅卵石": [["é"], ["luǎn"], ["shí"]],
    "鹅毛大雪": [["é"], ["máo"], ["dà"], ["xuě"]],
    "鹅王择乳": [["é"], ["wáng"], ["zé"], ["rǔ"]],
    "鹅毛扇": [["é"], ["máo"], ["shàn"]],
    "鹅行鸭步": [["é"], ["xíng"], ["yā"], ["bù"]],
    "蛾眉皓齿": [["é"], ["méi"], ["hào"], ["chǐ"]],
    "鹅掌风": [["é"], ["zhǎng"], ["fēng"]],
    "蛾眉螓首": [["é"], ["méi"], ["qín"], ["shǒu"]],
    "蛾眉月": [["é"], ["méi"], ["yuè"]],
    "额手称庆": [["é"], ["shǒu"], ["chēng"], ["qìng"]],
    "额手相庆": [["é"], ["shǒu"], ["xiāng"], ["qìng"]],
    "额首称庆": [["é"], ["shǒu"], ["chēng"], ["qìng"]],
    "额手称颂": [["é"], ["shǒu"], ["chēng"], ["sòng"]],
    "婀娜多姿": [["ē"], ["nuó"], ["duō"], ["zī"]],
    "扼喉抚背": [["è"], ["hóu"], ["fǔ"], ["bèi"]],
    "扼襟控咽": [["è"], ["jīn"], ["kòng"], ["yān"]],
    "扼吭夺食": [["è"], ["gāng"], ["duó"], ["shí"]],
    "扼吭拊背": [["è"], ["gāng"], ["fǔ"], ["bèi"]],
    "扼亢拊背": [["è"], ["kàng"], ["fǔ"], ["bèi"]],
    "扼腕长叹": [["è"], ["wàn"], ["cháng"], ["tàn"]],
    "恶不去善": [["wù"], ["bù"], ["qù"], ["shàn"]],
    "恶尘无染": [["è"], ["chén"], ["wú"], ["rǎn"]],
    "恶叉白赖": [["è"], ["chā"], ["bái"], ["lài"]],
    "恶贯满盈": [["è"], ["guàn"], ["mǎn"], ["yíng"]],
    "恶恶从短": [["wù"], ["wù"], ["cóng"], ["duǎn"]],
    "恶贯已盈": [["è"], ["guàn"], ["yǐ"], ["yíng"]],
    "恶狠狠": [["è"], ["hěn"], ["hěn"]],
    "恶虎不食子": [["è"], ["hǔ"], ["bù"], ["shí"], ["zǐ"]],
    "恶迹昭著": [["è"], ["jì"], ["zhāo"], ["zhù"]],
    "恶迹昭着": [["è"], ["jì"], ["zhāo"], ["zhe"]],
    "恶积祸盈": [["è"], ["jī"], ["huò"], ["yíng"]],
    "恶籍盈指": [["è"], ["jí"], ["yíng"], ["zhǐ"]],
    "恶居下流": [["wù"], ["jū"], ["xià"], ["liú"]],
    "恶人先告状": [["è"], ["rén"], ["xiān"], ["gào"], ["zhuàng"]],
    "恶声恶气": [["è"], ["shēng"], ["è"], ["qì"]],
    "恶湿居下": [["wù"], ["shī"], ["jū"], ["xià"]],
    "恶事传千里": [["è"], ["shì"], ["chuán"], ["qiān"], ["lǐ"]],
    "恶事行千里": [["è"], ["shì"], ["xíng"], ["qiān"], ["lǐ"]],
    "恶向胆边生": [["è"], ["xiàng"], ["dǎn"], ["biān"], ["shēng"]],
    "恶势力": [["è"], ["shì"], ["lì"]],
    "恶性循环": [["è"], ["xìng"], ["xún"], ["huán"]],
    "恶凶凶": [["è"], ["xiōng"], ["xiōng"]],
    "恶言厉色": [["è"], ["yán"], ["lì"], ["sè"]],
    "恶性肿瘤": [["è"], ["xìng"], ["zhǒng"], ["liú"]],
    "恶言詈辞": [["è"], ["yán"], ["lì"], ["cí"]],
    "恶衣菲食": [["è"], ["yī"], ["fēi"], ["shí"]],
    "恶衣恶食": [["è"], ["yī"], ["è"], ["shí"]],
    "恶衣蔬食": [["è"], ["yī"], ["shū"], ["shí"]],
    "恶衣粝食": [["è"], ["yī"], ["lì"], ["shí"]],
    "恶意中伤": [["è"], ["yì"], ["zhòng"], ["shāng"]],
    "恶语伤人": [["è"], ["yǔ"], ["shāng"], ["rén"]],
    "恶有恶报": [["è"], ["yǒu"], ["è"], ["bào"]],
    "恶语伤人六月寒": [["è"], ["yǔ"], ["shāng"], ["rén"], ["liù"], ["yuè"], ["hán"]],
    "恶语相加": [["è"], ["yǔ"], ["xiāng"], ["jiā"]],
    "恶语中伤": [["è"], ["yǔ"], ["zhòng"], ["shāng"]],
    "恶直丑正": [["è"], ["zhí"], ["chǒu"], ["zhèng"]],
    "恶醉强酒": [["wù"], ["zuì"], ["qiǎng"], ["jiǔ"]],
    "恶紫夺朱": [["wù"], ["zǐ"], ["duó"], ["zhū"]],
    "恶作剧": [["è"], ["zuò"], ["jù"]],
    "饿莩遍野": [["è"], ["piǎo"], ["biàn"], ["yě"]],
    "饿莩载道": [["è"], ["piǎo"], ["zǎi"], ["dào"]],
    "饿虎扑食": [["è"], ["hǔ"], ["pū"], ["shí"]],
    "饿虎擒羊": [["è"], ["hǔ"], ["qín"], ["yáng"]],
    "饿虎扑羊": [["è"], ["hǔ"], ["pū"], ["yáng"]],
    "饿殍载道": [["è"], ["piǎo"], ["zài"], ["dào"]],
    "饿虎吞羊": [["è"], ["hǔ"], ["tūn"], ["yáng"]],
    "饿殍枕藉": [["è"], ["piǎo"], ["zhěn"], ["jí"]],
    "遏恶扬善": [["è"], ["è"], ["yán"], ["shàn"]],
    "遏渐防萌": [["è"], ["jiàn"], ["fáng"], ["méng"]],
    "搤臂啮指": [["è"], ["bì"], ["niè"], ["zhǐ"]],
    "恩不放债": [["ēn"], ["bù"], ["fàng"], ["zhai"]],
    "恩恩相报": [["ēn"], ["ēn"], ["xiāng"], ["bào"]],
    "恩将仇报": [["ēn"], ["jiāng"], ["chóu"], ["bào"]],
    "恩荣并济": [["ēn"], ["róng"], ["bìng"], ["jì"]],
    "恩若再生": [["ēn"], ["ruò"], ["zài"], ["shēng"]],
    "恩深义重": [["ēn"], ["shēn"], ["yì"], ["zhòng"]],
    "恩甚怨生": [["ēn"], ["shèn"], ["yuàn"], ["shēng"]],
    "恩同父母": [["ēn"], ["tóng"], ["fù"], ["mǔ"]],
    "恩同山岳": [["ēn"], ["tóng"], ["shān"], ["yuè"]],
    "恩同再造": [["ēn"], ["tóng"], ["zài"], ["zào"]],
    "恩威并用": [["ēn"], ["wēi"], ["bìng"], ["yòng"]],
    "恩威并行": [["ēn"], ["wēi"], ["bìng"], ["xíng"]],
    "恩有重报": [["ēn"], ["yǒu"], ["zhòng"], ["bào"]],
    "恩怨分明": [["ēn"], ["yuàn"], ["fēn"], ["míng"]],
    "恩重如山": [["ēn"], ["zhòng"], ["rú"], ["shān"]],
    "恩重泰山": [["ēn"], ["zhòng"], ["tài"], ["shān"]],
    "摁钉儿": [["èn"], ["dīng"], ["ér"]],
    "儿女成行": [["ér"], ["nǚ"], ["chéng"], ["háng"]],
    "儿女情长": [["ér"], ["nǚ"], ["qíng"], ["cháng"]],
    "儿女亲家": [["ér"], ["nǚ"], ["qìng"], ["jiā"]],
    "儿女心肠": [["ér"], ["nǘ"], ["xīn"], ["cháng"]],
    "儿女债": [["ér"], ["nǚ"], ["zhài"]],
    "儿女之情": [["ér"], ["nǚ"], ["zhī"], ["qíng"]],
    "儿童节": [["ér"], ["tóng"], ["jié"]],
    "儿童乐园": [["ér"], ["tóng"], ["lè"], ["yuán"]],
    "耳边风": [["ěr"], ["biān"], ["fēng"]],
    "耳鬓斯磨": [["ěr"], ["bìn"], ["sī"], ["mó"]],
    "耳鬓撕磨": [["ěr"], ["bìn"], ["sī"], ["mó"]],
    "耳鬓厮磨": [["ěr"], ["bìn"], ["sī"], ["mó"]],
    "耳根清净": [["ěr"], ["gēn"], ["qīng"], ["jìng"]],
    "耳红面赤": [["ěr"], ["hóng"], ["miàn"], ["chì"]],
    "耳后生风": [["ěr"], ["hòu"], ["shēng"], ["fēng"]],
    "耳目闭塞": [["ěr"], ["mù"], ["bì"], ["sāi"]],
    "耳旁风": [["ěr"], ["páng"], ["fēng"]],
    "耳食之论": [["ěr"], ["shí"], ["zhī"], ["lùn"]],
    "耳食之谈": [["ěr"], ["shí"], ["zhī"], ["tán"]],
    "耳食之言": [["ěr"], ["shí"], ["zhī"], ["yán"]],
    "耳视目食": [["ěr"], ["shì"], ["mù"], ["shí"]],
    "耳熟能详": [["ěr"], ["shú"], ["néng"], ["xiáng"]],
    "耳提面命": [["ěr"], ["tí"], ["miàn"], ["mìng"]],
    "耳闻不如面见": [["ěr"], ["wén"], ["bù"], ["rú"], ["miàn"], ["jiàn"]],
    "耳闻不如目见": [["ěr"], ["wén"], ["bù"], ["rú"], ["mù"], ["jiàn"]],
    "耳闻目见": [["ěr"], ["wén"], ["mù"], ["jiàn"]],
    "耳熏目染": [["ěr"], ["xūn"], ["mù"], ["rǎn"]],
    "迩安远至": [["ěr"], ["ān"], ["yuǎn"], ["zhì"]],
    "二把刀": [["èr"], ["bǎ"], ["dāo"]],
    "二把手": [["èr"], ["bǎ"], ["shǒu"]],
    "二传手": [["èr"], ["chuán"], ["shǒu"]],
    "二次能源": [["èr"], ["cì"], ["néng"], ["yuán"]],
    "二次曲线": [["èr"], ["cì"], ["qū"], ["xiàn"]],
    "二地主": [["èr"], ["dì"], ["zhǔ"]],
    "二分明月": [["èr"], ["fēn"], ["míng"], ["yuè"]],
    "二锅头": [["èr"], ["guō"], ["tóu"]],
    "二化螟": [["èr"], ["huà"], ["míng"]],
    "二话没说": [["èr"], ["huà"], ["méi"], ["shuō"]],
    "二话不说": [["èr"], ["huà"], ["bù"], ["shuō"]],
    "二郎腿": [["èr"], ["láng"], ["tuǐ"]],
    "二龙戏珠": [["èr"], ["lóng"], ["xì"], ["zhū"]],
    "二面角": [["èr"], ["miàn"], ["jiǎo"]],
    "二七大罢工": [["èr"], ["qī"], ["dà"], ["bà"], ["gōng"]],
    "二人台": [["èr"], ["rén"], ["tái"]],
    "二人转": [["èr"], ["rén"], ["zhuàn"]],
    "二三其德": [["èr"], ["sān"], ["qí"], ["dé"]],
    "二三其意": [["èr"], ["sān"], ["qí"], ["yì"]],
    "二十八宿": [["èr"], ["shí"], ["bā"], ["xiù"]],
    "二十四节气": [["èr"], ["shí"], ["sì"], ["jié"], ["qì"]],
    "二竖为虐": [["èr"], ["shù"], ["wéi"], ["nüè"]],
    "二万五千里长征": [["èr"], ["wàn"], ["wǔ"], ["qiān"], ["lǐ"], ["cháng"], ["zhēng"]],
    "二姓之好": [["èr"], ["xìng"], ["zhī"], ["hǎo"]],
    "二氧化硅": [["èr"], ["yǎng"], ["huà"], ["guī"]],
    "二氧化硫": [["èr"], ["yǎng"], ["huà"], ["liú"]],
    "二氧化锰": [["èr"], ["yǎng"], ["huà"], ["měng"]],
    "二氧化碳": [["èr"], ["yǎng"], ["huà"], ["tàn"]],
    "二氧化物": [["èr"], ["yǎng"], ["huà"], ["wù"]],
    "二元论": [["èr"], ["yuán"], ["lùn"]],
    "二者不可得兼": [["èr"], ["zhě"], ["bù"], ["kě"], ["dé"], ["jiān"]],
    "二重唱": [["èr"], ["chóng"], ["chàng"]],
    "二重根": [["èr"], ["chóng"], ["gēn"]],
    "二重性": [["èr"], ["chóng"], ["xìng"]],
    "二重奏": [["èr"], ["chóng"], ["zòu"]],
    "发报机": [["fā"], ["bào"], ["jī"]],
    "发病率": [["fā"], ["bìng"], ["lǜ"]],
    "发财致富": [["fā"], ["cái"], ["zhì"], ["fù"]],
    "发策决科": [["fā"], ["cè"], ["jué"], ["kē"]],
    "发达国家": [["fā"], ["dá"], ["guó"], ["jiā"]],
    "发电厂": [["fā"], ["diàn"], ["chǎng"]],
    "发电机": [["fā"], ["diàn"], ["jī"]],
    "发动机": [["fā"], ["dòng"], ["jī"]],
    "发端词": [["fā"], ["duān"], ["cí"]],
    "发短心长": [["fà"], ["duǎn"], ["xīn"], ["cháng"]],
    "发凡起例": [["fā"], ["fán"], ["qǐ"], ["lì"]],
    "发奋图强": [["fā"], ["fèn"], ["tú"], ["qiáng"]],
    "发愤图强": [["fā"], ["fèn"], ["tú"], ["qiáng"]],
    "发愤忘食": [["fā"], ["fèn"], ["wàng"], ["shí"]],
    "发高烧": [["fā"], ["gāo"], ["shāo"]],
    "发号施令": [["fā"], ["hào"], ["shī"], ["lìng"]],
    "发横财": [["fā"], ["hèng"], ["cái"]],
    "发昏章第十一": [["fā"], ["hūn"], ["zhāng"], ["dì"], ["shí"], ["yī"]],
    "发家致富": [["fā"], ["jiā"], ["zhì"], ["fù"]],
    "发奸擿伏": [["fā"], ["jiān"], ["tì"], ["fú"]],
    "发酒疯": [["fā"], ["jiǔ"], ["fēng"]],
    "发刊词": [["fā"], ["kān"], ["cí"]],
    "发科打诨": [["fā"], ["kē"], ["dǎ"], ["hùn"]],
    "发牢骚": [["fā"], ["láo"], ["sāo"]],
    "发令枪": [["fā"], ["lìng"], ["qiāng"]],
    "发聋振聩": [["fā"], ["lóng"], ["zhèn"], ["kuì"]],
    "发蒙解缚": [["fā"], ["méng"], ["jiě"], ["fu"]],
    "发蒙解惑": [["fā"], ["méng"], ["jiě"], ["huò"]],
    "发蒙振落": [["fā"], ["méng"], ["zhèn"], ["luò"]],
    "发蒙振聩": [["fā"], ["méng"], ["zhèn"], ["kuì"]],
    "发明家": [["fā"], ["míng"], ["jiā"]],
    "发明权": [["fā"], ["míng"], ["quán"]],
    "发怒冲冠": [["fā"], ["nù"], ["chōng"], ["guàn"]],
    "发怒穿冠": [["fà"], ["nù"], ["chuān"], ["guān"]],
    "发疟子": [["fā"], ["yào"], ["zǐ"]],
    "发脾气": [["fā"], ["pí"], ["qì"]],
    "发起人": [["fā"], ["qǐ"], ["rén"]],
    "发人深省": [["fā"], ["rén"], ["shēn"], ["xǐng"]],
    "发人深思": [["fā"], ["rén"], ["shēn"], ["sī"]],
    "发上冲冠": [["fā"], ["shàng"], ["chōng"], ["guàn"]],
    "发上指冠": [["fā"], ["shàng"], ["zhǐ"], ["guàn"]],
    "发烧友": [["fā"], ["shāo"], ["yǒu"]],
    "发神经": [["fā"], ["shén"], ["jīng"]],
    "发生炉煤气": [["fā"], ["shēng"], ["lú"], ["méi"], ["qì"]],
    "发棠之请": [["fā"], ["táng"], ["zhī"], ["qǐng"]],
    "发秃齿豁": [["fà"], ["tū"], ["chǐ"], ["huò"]],
    "发屋求狸": [["fā"], ["wū"], ["qiú"], ["lí"]],
    "发宪布令": [["fā"], ["xiàn"], ["bù"], ["lìng"]],
    "发祥地": [["fā"], ["xiáng"], ["dì"]],
    "发行人": [["fā"], ["xíng"], ["rén"]],
    "发行量": [["fā"], ["xíng"], ["liàng"]],
    "发硎新试": [["fā"], ["xíng"], ["xīn"], ["shì"]],
    "发芽率": [["fā"], ["yá"], ["lǜ"]],
    "发言人": [["fā"], ["yán"], ["rén"]],
    "发言权": [["fā"], ["yán"], ["quán"]],
    "发扬踔厉": [["fā"], ["yáng"], ["chuō"], ["lì"]],
    "发言盈庭": [["fā"], ["yán"], ["yíng"], ["tíng"]],
    "发扬光大": [["fā"], ["yáng"], ["guāng"], ["dà"]],
    "发洋财": [["fā"], ["yáng"], ["cái"]],
    "发扬蹈厉": [["fā"], ["yáng"], ["dǎo"], ["lì"]],
    "发音器官": [["fā"], ["yīn"], ["qì"], ["guān"]],
    "发隐擿伏": [["fā"], ["yǐn"], ["tī"], ["fú"]],
    "发引千钧": [["fà"], ["yǐn"], ["qiān"], ["jūn"]],
    "发踊冲冠": [["fà"], ["yǒng"], ["chōng"], ["guān"]],
    "发语词": [["fā"], ["yǔ"], ["cí"]],
    "发源地": [["fā"], ["yuán"], ["dì"]],
    "发展速度": [["fā"], ["zhǎn"], ["sù"], ["dù"]],
    "发展心理学": [["fā"], ["zhǎn"], ["xīn"], ["lǐ"], ["xué"]],
    "发政施仁": [["fā"], ["zhèng"], ["shī"], ["rén"]],
    "发展中国家": [["fā"], ["zhǎn"], ["zhōng"], ["guó"], ["jiā"]],
    "发植穿冠": [["fà"], ["zhí"], ["chuān"], ["guān"]],
    "发指眦裂": [["fà"], ["zhǐ"], ["zì"], ["liè"]],
    "发综指示": [["fā"], ["zōng"], ["zhǐ"], ["shì"]],
    "发踪指使": [["fā"], ["zōng"], ["zhǐ"], ["shǐ"]],
    "发踪指示": [["fā"], ["zōng"], ["zhǐ"], ["shì"]],
    "发纵指使": [["fā"], ["zòng"], ["zhǐ"], ["shǐ"]],
    "发纵指示": [["fā"], ["zòng"], ["zhǐ"], ["shì"]],
    "伐冰之家": [["fá"], ["bīng"], ["zhī"], ["jiā"]],
    "伐功矜能": [["fá"], ["gōng"], ["jīn"], ["néng"]],
    "伐毛洗髓": [["fá"], ["máo"], ["xǐ"], ["suǐ"]],
    "伐异党同": [["fá"], ["yì"], ["dǎng"], ["tóng"]],
    "罚不责众": [["fá"], ["bù"], ["zé"], ["zhòng"]],
    "罚不当罪": [["fá"], ["bù"], ["dāng"], ["zuì"]],
    "法不阿贵": [["fǎ"], ["bù"], ["ē"], ["guì"]],
    "法不传六耳": [["fǎ"], ["bù"], ["chuán"], ["liù"], ["ěr"]],
    "法不徇情": [["fǎ"], ["bù"], ["xùn"], ["qíng"]],
    "法定人数": [["fǎ"], ["dìng"], ["rén"], ["shù"]],
    "法国号": [["fǎ"], ["guó"], ["hào"]],
    "法拉第": [["fǎ"], ["lā"], ["dì"]],
    "法律关系": [["fǎ"], ["lǜ"], ["guān"], ["xì"]],
    "法律行为": [["fǎ"], ["lǜ"], ["xíng"], ["wéi"]],
    "法律意识": [["fǎ"], ["lǜ"], ["yì"], ["shí"]],
    "法律责任": [["fǎ"], ["lǜ"], ["zé"], ["rèn"]],
    "法律制度": [["fǎ"], ["lǜ"], ["zhì"], ["dù"]],
    "法脉准绳": [["fǎ"], ["mài"], ["zhǔn"], ["shéng"]],
    "法轮常转": [["fǎ"], ["lún"], ["cháng"], ["zhuàn"]],
    "法向加速度": [["fǎ"], ["xiàng"], ["jiā"], ["sù"], ["dù"]],
    "法无可贷": [["fǎ"], ["wú"], ["kě"], ["dài"]],
    "番红花": [["fān"], ["hóng"], ["huā"]],
    "番窠倒臼": [["fān"], ["kē"], ["dǎo"], ["jiù"]],
    "番来覆去": [["fān"], ["lái"], ["fù"], ["qù"]],
    "番木瓜": [["fān"], ["mù"], ["guā"]],
    "番石榴": [["fān"], ["shí"], ["liú"]],
    "翻肠倒肚": [["fān"], ["cháng"], ["dǎo"], ["dǔ"]],
    "翻肠搅肚": [["fān"], ["cháng"], ["jiǎo"], ["dù"]],
    "翻车鱼": [["fān"], ["chē"], ["yú"]],
    "翻唇弄舌": [["fān"], ["chún"], ["nòng"], ["shé"]],
    "翻个儿": [["fān"], ["gè"], ["ér"]],
    "翻跟斗": [["fān"], ["gēn"], ["dǒu"]],
    "翻跟头": [["fān"], ["gēn"], ["tou"]],
    "翻黄倒皁": [["fān"], ["huáng"], ["dǎo"], ["yí"]],
    "翻黄倒皂": [["fān"], ["huáng"], ["dǎo"], ["zào"]],
    "翻江倒海": [["fān"], ["jiāng"], ["dǎo"], ["hǎi"]],
    "翻空出奇": [["fān"], ["kōng"], ["chū"], ["qí"]],
    "翻筋斗": [["fān"], ["jīn"], ["dǒu"]],
    "翻脸不认人": [["fān"], ["liǎn"], ["bù"], ["rèn"], ["rén"]],
    "翻山越岭": [["fān"], ["shān"], ["yuè"], ["lǐng"]],
    "翻手云覆手雨": [["fān"], ["shǒu"], ["yún"], ["fù"], ["shǒu"], ["yǔ"]],
    "翻箱倒柜": [["fān"], ["xiāng"], ["dǎo"], ["guì"]],
    "翻天作地": [["fān"], ["tiān"], ["zuò"], ["dì"]],
    "翻天覆地": [["fān"], ["tiān"], ["fù"], ["dì"]],
    "翻箱倒笼": [["fān"], ["xiāng"], ["dǎo"], ["lóng"]],
    "藩镇割据": [["fān"], ["zhèn"], ["gē"], ["jù"]],
    "翻云覆雨": [["fān"], ["yún"], ["fù"], ["yǔ"]],
    "凡才浅识": [["fán"], ["cái"], ["qiǎn"], ["shí"]],
    "凡尔丁": [["fán"], ["ěr"], ["dīng"]],
    "凡夫肉眼": [["fán"], ["fū"], ["ròu"], ["yǎn"]],
    "凡夫俗子": [["fán"], ["fū"], ["sú"], ["zǐ"]],
    "凡胎浊骨": [["fán"], ["tāi"], ["zhuó"], ["gǔ"]],
    "凡胎浊体": [["fán"], ["tāi"], ["zhuó"], ["tǐ"]],
    "繁花似锦": [["fán"], ["huā"], ["sì"], ["jǐn"]],
    "繁华损枝": [["fán"], ["huá"], ["sǔn"], ["zhī"]],
    "繁荣富强": [["fán"], ["róng"], ["fù"], ["qiáng"]],
    "繁荣昌盛": [["fán"], ["róng"], ["chāng"], ["shèng"]],
    "繁荣兴旺": [["fán"], ["róng"], ["xīng"], ["wàng"]],
    "繁体字": [["fán"], ["tǐ"], ["zì"]],
    "繁文末节": [["fán"], ["wén"], ["mò"], ["jié"]],
    "繁文缛节": [["fán"], ["wén"], ["rù"], ["jié"]],
    "繁文缛礼": [["fán"], ["wén"], ["rù"], ["lǐ"]],
    "繁弦急管": [["fán"], ["xián"], ["jí"], ["guǎn"]],
    "繁刑重赋": [["fán"], ["xíng"], ["zhòng"], ["fù"]],
    "繁征博引": [["fán"], ["zhēng"], ["bó"], ["yǐn"]],
    "繁枝细节": [["fán"], ["zhī"], ["xì"], ["jié"]],
    "反败为胜": [["fǎn"], ["bài"], ["wéi"], ["shèng"]],
    "反唇相讥": [["fǎn"], ["chún"], ["xiāng"], ["jī"]],
    "反冲力": [["fǎn"], ["chōng"], ["lì"]],
    "反唇相稽": [["fǎn"], ["chún"], ["xiāng"], ["jī"]],
    "反对票": [["fǎn"], ["duì"], ["piào"]],
    "反风灭火": [["fǎn"], ["fēng"], ["miè"], ["huǒ"]],
    "反戈相向": [["fǎn"], ["gē"], ["xiāng"], ["xiàng"]],
    "反攻倒算": [["fǎn"], ["gōng"], ["dǎo"], ["suàn"]],
    "反躬自省": [["fǎn"], ["gōng"], ["zì"], ["xǐng"]],
    "反间谍": [["fǎn"], ["jiàn"], ["dié"]],
    "反间计": [["fǎn"], ["jiàn"], ["jì"]],
    "反间之计": [["fǎn"], ["jiàn"], ["zhī"], ["jì"]],
    "反经合道": [["fǎn"], ["jīng"], ["hé"], ["dào"]],
    "反经合义": [["fǎn"], ["jīng"], ["hé"], ["yì"]],
    "反经行权": [["fǎn"], ["jīng"], ["xíng"], ["quán"]],
    "反劳为逸": [["fǎn"], ["láo"], ["wéi"], ["yì"]],
    "反客为主": [["fǎn"], ["kè"], ["wéi"], ["zhǔ"]],
    "反老还童": [["fǎn"], ["lǎo"], ["huán"], ["tóng"]],
    "反面教员": [["fǎn"], ["miàn"], ["jiào"], ["yuán"]],
    "反目成仇": [["fǎn"], ["mù"], ["chéng"], ["chóu"]],
    "反朴归真": [["fǎn"], ["pǔ"], ["guī"], ["zhēn"]],
    "反朴还淳": [["fǎn"], ["pǔ"], ["huán"], ["chún"]],
    "反其道而行之": [["fǎn"], ["qí"], ["dào"], ["ér"], ["xíng"], ["zhī"]],
    "反气旋": [["fǎn"], ["qì"], ["xuán"]],
    "反射定律": [["fǎn"], ["shè"], ["dìng"], ["lǜ"]],
    "反射角": [["fǎn"], ["shè"], ["jiǎo"]],
    "反手可得": [["fǎn"], ["shǒu"], ["kě"], ["dé"]],
    "反水不收": [["fǎn"], ["shuǐ"], ["bù"], ["shōu"]],
    "反坦克炮": [["fǎn"], ["tǎn"], ["kè"], ["pào"]],
    "反听内视": [["fǎn"], ["tīng"], ["nèi"], ["shì"]],
    "反眼不识": [["fǎn"], ["yǎn"], ["bù"], ["shí"]],
    "反应堆": [["fǎn"], ["yìng"], ["duī"]],
    "反应器": [["fǎn"], ["yìng"], ["qì"]],
    "反应式": [["fǎn"], ["yìng"], ["shì"]],
    "反映论": [["fǎn"], ["yìng"], ["lùn"]],
    "反右派斗争": [["fǎn"], ["yòu"], ["pài"], ["dòu"], ["zhēng"]],
    "反正拨乱": [["fǎn"], ["zhèng"], ["bō"], ["luàn"]],
    "反正还淳": [["fǎn"], ["zhèng"], ["huán"], ["chún"]],
    "反治其身": [["fǎn"], ["zhì"], ["qí"], ["shēn"]],
    "返本朝元": [["fǎn"], ["běn"], ["cháo"], ["yuán"]],
    "反转片": [["fǎn"], ["zhuǎn"], ["piàn"]],
    "返本还元": [["fǎn"], ["běn"], ["huán"], ["yuán"]],
    "返本还原": [["fǎn"], ["běn"], ["huán"], ["yuán"]],
    "返本还源": [["fǎn"], ["běn"], ["huán"], ["yuán"]],
    "返老还童": [["fǎn"], ["lǎo"], ["huán"], ["tóng"]],
    "返观内照": [["fǎn"], ["guān"], ["nèi"], ["zhào"]],
    "返观内视": [["fǎn"], ["guān"], ["nèi"], ["shì"]],
    "返朴归真": [["fǎn"], ["pǔ"], ["guī"], ["zhēn"]],
    "返朴还淳": [["fǎn"], ["pǔ"], ["huán"], ["chún"]],
    "返视内照": [["fǎn"], ["shì"], ["nèi"], ["zhào"]],
    "返朴还真": [["fǎn"], ["pǔ"], ["huán"], ["zhēn"]],
    "返我初服": [["fǎn"], ["wǒ"], ["chū"], ["fú"]],
    "返邪归正": [["fǎn"], ["xié"], ["guī"], ["zhèng"]],
    "犯不着": [["fàn"], ["bù"], ["zháo"]],
    "犯不上": [["fàn"], ["bù"], ["shàng"]],
    "犯得上": [["fàn"], ["děi"], ["shàng"]],
    "犯而不校": [["fàn"], ["ér"], ["bù"], ["jiào"]],
    "犯得着": [["fàn"], ["de"], ["zháo"]],
    "犯而勿校": [["fàn"], ["ér"], ["wù"], ["xiào"]],
    "犯节气": [["fàn"], ["jié"], ["qì"]],
    "犯上作乱": [["fàn"], ["shàng"], ["zuò"], ["luàn"]],
    "犯罪嫌疑人": [["fàn"], ["zuì"], ["xián"], ["yí"], ["rén"]],
    "泛浩摩苍": [["fàn"], ["hào"], ["mó"], ["cāng"]],
    "泛神论": [["fàn"], ["shén"], ["lùn"]],
    "泛应曲当": [["fàn"], ["yīng"], ["qǔ"], ["dāng"]],
    "饭囊酒瓮": [["fàn"], ["náng"], ["jiǔ"], ["wèng"]],
    "泛宅浮家": [["fàn"], ["zhái"], ["fú"], ["jiā"]],
    "饭坑酒囊": [["fàn"], ["kēng"], ["jiǔ"], ["náng"]],
    "饭囊酒甕": [["fàn"], ["náng"], ["jiǔ"], ["wèng"]],
    "饭囊衣架": [["fàn"], ["náng"], ["yī"], ["jià"]],
    "范水模山": [["fàn"], ["shuǐ"], ["mó"], ["shān"]],
    "贩夫贩妇": [["fàn"], ["fū"], ["fàn"], ["fù"]],
    "贩夫俗子": [["fàn"], ["fū"], ["sú"], ["zǐ"]],
    "贩夫皁隶": [["fàn"], ["fū"], ["yě"], ["lì"]],
    "贩夫驺卒": [["fàn"], ["fū"], ["zōu"], ["zú"]],
    "贩夫皂隶": [["fàn"], ["fū"], ["zào"], ["lì"]],
    "贩夫走卒": [["fàn"], ["fū"], ["zǒu"], ["fú"]],
    "梵册贝叶": [["fàn"], ["cè"], ["bèi"], ["yè"]],
    "梵哑铃": [["fàn"], ["yǎ"], ["líng"]],
    "方便面": [["fāng"], ["biàn"], ["miàn"]],
    "方便之门": [["fāng"], ["biàn"], ["zhī"], ["mén"]],
    "方骖并路": [["fāng"], ["cān"], ["bìng"], ["lù"]],
    "方寸不乱": [["fāng"], ["cùn"], ["bù"], ["luàn"]],
    "方寸万重": [["fāng"], ["cùn"], ["wàn"], ["chóng"]],
    "方寸之地": [["fāng"], ["cùn"], ["zhī"], ["dì"]],
    "方底圆盖": [["fāng"], ["dǐ"], ["yuán"], ["gài"]],
    "方法论": [["fāng"], ["fǎ"], ["lùn"]],
    "方方正正": [["fāng"], ["fāng"], ["zhèng"], ["zhèng"]],
    "方解石": [["fāng"], ["jiě"], ["shí"]],
    "方括号": [["fāng"], ["kuò"], ["hào"]],
    "方领圆冠": [["fāng"], ["lǐng"], ["yuán"], ["guàn"]],
    "方面大耳": [["fāng"], ["miàn"], ["dà"], ["ěr"]],
    "方枘圜凿": [["fāng"], ["ruì"], ["huán"], ["záo"]],
    "方头不劣": [["fāng"], ["tóu"], ["bù"], ["liè"]],
    "方头不律": [["fāng"], ["tóu"], ["bù"], ["lǜ"]],
    "方位角": [["fāng"], ["wèi"], ["jiǎo"]],
    "方兴未艾": [["fāng"], ["xīng"], ["wèi"], ["ài"]],
    "方兴未已": [["fāng"], ["xīng"], ["wèi"], ["yǐ"]],
    "方言矩行": [["fāng"], ["yán"], ["jǔ"], ["xíng"]],
    "方员可施": [["fāng"], ["yuán"], ["kě"], ["shī"]],
    "方正不阿": [["fāng"], ["zhèng"], ["bù"], ["ē"]],
    "芳年华月": [["fāng"], ["nián"], ["huá"], ["yuè"]],
    "芳兰竟体": [["fāng"], ["lán"], ["jìng"], ["tǐ"]],
    "防不及防": [["fáng"], ["bù"], ["jí"], ["fáng"]],
    "防不胜防": [["fáng"], ["bù"], ["shèng"], ["fáng"]],
    "防城港市": [["fáng"], ["chéng"], ["gǎng"], ["shì"]],
    "防毒面具": [["fáng"], ["dú"], ["miàn"], ["jù"]],
    "防风林": [["fáng"], ["fēng"], ["lín"]],
    "防空洞": [["fáng"], ["kōng"], ["dòng"]],
    "防萌杜渐": [["fáng"], ["méng"], ["dù"], ["jiàn"]],
    "防空壕": [["fáng"], ["kōng"], ["háo"]],
    "防沙林": [["fáng"], ["shā"], ["lín"]],
    "防微杜渐": [["fáng"], ["wēi"], ["dù"], ["jiàn"]],
    "防微虑远": [["fáng"], ["wēi"], ["lǜ"], ["yuǎn"]],
    "防卫过当": [["fáng"], ["wèi"], ["guò"], ["dāng"]],
    "防心摄行": [["fáng"], ["xīn"], ["shè"], ["xíng"]],
    "妨功害能": [["fáng"], ["gōng"], ["hài"], ["néng"]],
    "房地产": [["fáng"], ["dì"], ["chǎn"]],
    "房地产市场": [["fáng"], ["dì"], ["chǎn"], ["shì"], ["chǎng"]],
    "鲂鱼赪尾": [["fáng"], ["yú"], ["chēng"], ["wěi"]],
    "仿宋体": [["fǎng"], ["sòng"], ["tǐ"]],
    "访亲问友": [["fǎng"], ["qīn"], ["wèn"], ["yǒu"]],
    "纺织工业": [["fǎng"], ["zhī"], ["gōng"], ["yè"]],
    "纺织娘": [["fǎng"], ["zhī"], ["niáng"]],
    "纺织品": [["fǎng"], ["zhī"], ["pǐn"]],
    "放辟邪侈": [["fàng"], ["pì"], ["xié"], ["chǐ"]],
    "放辟淫侈": [["fàng"], ["pì"], ["yín"], ["chǐ"]],
    "放长线钓大鱼": [["fáng"], ["cháng"], ["xiàn"], ["diào"], ["dà"], ["yú"]],
    "放达不羁": [["fàng"], ["dá"], ["bù"], ["jī"]],
    "放大镜": [["fàng"], ["dà"], ["jìng"]],
    "放大率": [["fàng"], ["dà"], ["shuài"]],
    "放大器": [["fàng"], ["dà"], ["qì"]],
    "放大炮": [["fàng"], ["dà"], ["pào"]],
    "放大纸": [["fàng"], ["dà"], ["zhǐ"]],
    "放诞不羁": [["fàng"], ["dàn"], ["bù"], ["jī"]],
    "放诞不拘": [["fàng"], ["dàn"], ["bù"], ["jū"]],
    "放诞风流": [["fàng"], ["dàn"], ["fēng"], ["liú"]],
    "放荡不羁": [["fàng"], ["dàng"], ["bù"], ["jī"]],
    "放刁把滥": [["fàng"], ["diāo"], ["bǎ"], ["làn"]],
    "放刁撒泼": [["fàng"], ["diāo"], ["sā"], ["pō"]],
    "放歌纵酒": [["fàng"], ["gē"], ["zòng"], ["jiǔ"]],
    "放空气": [["fàng"], ["kōng"], ["qì"]],
    "放空炮": [["fàng"], ["kōng"], ["pào"]],
    "放浪不羁": [["fàng"], ["làng"], ["bù"], ["jī"]],
    "放浪不拘": [["fàng"], ["làng"], ["bù"], ["jū"]],
    "放浪无拘": [["fàng"], ["làng"], ["wú"], ["jū"]],
    "放冷风": [["fàng"], ["lěng"], ["fēng"]],
    "放马后炮": [["fàng"], ["mǎ"], ["hòu"], ["pào"]],
    "放马华阳": [["fàng"], ["mǎ"], ["huá"], ["yáng"]],
    "放屁添风": [["fàng"], ["pì"], ["tiān"], ["fēng"]],
    "放僻邪侈": [["fàng"], ["pì"], ["xié"], ["chǐ"]],
    "放僻淫佚": [["fàng"], ["pì"], ["yín"], ["yì"]],
    "放泼撒豪": [["fàng"], ["pō"], ["sā"], ["háo"]],
    "放任自流": [["fàng"], ["rèn"], ["zì"], ["liú"]],
    "放射病": [["fàng"], ["shè"], ["bìng"]],
    "放射疗法": [["fàng"], ["shè"], ["liáo"], ["fǎ"]],
    "放射线": [["fàng"], ["shè"], ["xiàn"]],
    "放射性": [["fàng"], ["shè"], ["xìng"]],
    "放射形": [["fàng"], ["shè"], ["xíng"]],
    "放射性同位素": [["fàng"], ["shè"], ["xìng"], ["tóng"], ["wèi"], ["sù"]],
    "放射性元素": [["fàng"], ["shè"], ["xìng"], ["yuán"], ["sù"]],
    "放心解体": [["fàng"], ["xīn"], ["jiě"], ["tǐ"]],
    "放言高论": [["fàng"], ["yán"], ["gāo"], ["lùn"]],
    "放纵不羁": [["fàng"], ["zòng"], ["bù"], ["jī"]],
    "放纵不拘": [["fàng"], ["zòng"], ["bù"], ["jū"]],
    "放纵驰荡": [["fàng"], ["zòng"], ["chí"], ["dàng"]],
    "飞刍转饷": [["fēi"], ["chú"], ["zhuǎn"], ["xiǎng"]],
    "飞车走壁": [["fēi"], ["chē"], ["zǒu"], ["bì"]],
    "飞短流长": [["fēi"], ["duǎn"], ["liú"], ["cháng"]],
    "飞蛾赴火": [["fēi"], ["é"], ["fù"], ["huǒ"]],
    "飞蛾赴焰": [["fēi"], ["é"], ["fù"], ["yàn"]],
    "飞蛾赴烛": [["fēi"], ["é"], ["fù"], ["zhú"]],
    "飞蛾扑火": [["fēi"], ["é"], ["pū"], ["huǒ"]],
    "飞蛾投火": [["fēi"], ["é"], ["tóu"], ["huǒ"]],
    "飞鸿雪爪": [["fēi"], ["hóng"], ["xuě"], ["zhǎo"]],
    "飞机场": [["fēi"], ["jī"], ["chǎng"]],
    "飞将军": [["fēi"], ["jiàng"], ["jūn"]],
    "飞将数奇": [["fē"], ["jiàng"], ["shù"], ["jī"]],
    "飞流短长": [["fēi"], ["liú"], ["duǎn"], ["cháng"]],
    "飞来横祸": [["fēi"], ["lái"], ["hèng"], ["huò"]],
    "飞龙乘云": [["fēi"], ["lóng"], ["chéng"], ["yún"]],
    "飞米转刍": [["fēi"], ["mǐ"], ["zhuǎn"], ["chú"]],
    "飞鸟惊蛇": [["fēi"], ["niǎo"], ["jīng"], ["shé"]],
    "飞沙扬砾": [["fēi"], ["shā"], ["yáng"], ["lì"]],
    "飞蓬随风": [["fēi"], ["péng"], ["suí"], ["fēng"]],
    "飞沙走砾": [["fēi"], ["shē"], ["zǒu"], ["lì"]],
    "飞沙走石": [["fēi"], ["shā"], ["zǒu"], ["shí"]],
    "飞砂转石": [["fēi"], ["shā"], ["zhuǎn"], ["shí"]],
    "飞砂走石": [["fēi"], ["shā"], ["zǒu"], ["shí"]],
    "飞霜六月": [["fēi"], ["shuāng"], ["liù"], ["yuè"]],
    "飞行员": [["fēi"], ["xíng"], ["yuán"]],
    "飞眼传情": [["fēi"], ["yǎn"], ["chuán"], ["qíng"]],
    "飞鹰奔犬": [["fēi"], ["yīng"], ["bēn"], ["quǎn"]],
    "飞灾横祸": [["fēi"], ["zāi"], ["hèng"], ["huò"]],
    "飞珠溅玉": [["fēi"], ["zhū"], ["jiàn"], ["yù"]],
    "非池中物": [["fēi"], ["chí"], ["zhōng"], ["wù"]],
    "非电解质": [["fēi"], ["diàn"], ["jiě"], ["zhì"]],
    "非分之财": [["fēi"], ["fèn"], ["zhī"], ["cái"]],
    "非分之念": [["fēi"], ["fèn"], ["zhī"], ["niàn"]],
    "非分之想": [["fēi"], ["fèn"], ["zhī"], ["xiǎng"]],
    "非金属": [["fēi"], ["jīn"], ["shǔ"]],
    "非晶体": [["fēi"], ["jīng"], ["tǐ"]],
    "非亲非故": [["fēi"], ["qīn"], ["fēi"], ["gù"]],
    "非同儿戏": [["fēi"], ["tóng"], ["ér"], ["xì"]],
    "非同寻常": [["fēi"], ["tóng"], ["xún"], ["cháng"]],
    "非同小可": [["fēi"], ["tóng"], ["xiǎo"], ["kě"]],
    "非异人任": [["fēi"], ["yì"], ["rén"], ["rèn"]],
    "非意相干": [["fēi"], ["yì"], ["xiāng"], ["gān"]],
    "非正式": [["fēi"], ["zhèng"], ["shì"]],
    "非正义战争": [["fēi"], ["zhèng"], ["yì"], ["zhàn"], ["zhēng"]],
    "菲食薄衣": [["fěi"], ["shí"], ["bó"], ["yī"]],
    "蜚短流长": [["fēi"], ["duǎn"], ["liú"], ["cháng"]],
    "蜚瓦拔木": [["fēi"], ["wǎ"], ["bá"], ["mù"]],
    "肥头大面": [["féi"], ["tóu"], ["dà"], ["miàn"]],
    "肥头大耳": [["féi"], ["tóu"], ["dà"], ["ěr"]],
    "肥头胖耳": [["féi"], ["tóu"], ["pàng"], ["ěr"]],
    "肥皂泡": [["féi"], ["zào"], ["pào"]],
    "肥鱼大肉": [["féi"], ["yú"], ["dà"], ["ròu"]],
    "匪朝伊夕": [["fěi"], ["cháo"], ["yī"], ["xī"]],
    "匪石匪席": [["fěi"], ["shí"], ["fěi"], ["xí"]],
    "匪石之心": [["fěi"], ["shí"], ["zhī"], ["xīn"]],
    "匪伊朝夕": [["fěi"], ["yí"], ["zhāo"], ["xī"]],
    "匪夷所思": [["fěi"], ["yí"], ["suǒ"], ["sī"]],
    "斐然乡风": [["fěi"], ["rán"], ["xiāng"], ["fēng"]],
    "斐然成章": [["fěi"], ["rán"], ["chéng"], ["zhāng"]],
    "斐然向风": [["fěi"], ["rán"], ["xiàng"], ["fēng"]],
    "吠非其主": [["fèi"], ["fēi"], ["qí"], ["zhǔ"]],
    "废寝忘食": [["fèi"], ["qǐn"], ["wàng"], ["shí"]],
    "废文任武": [["fèi"], ["wén"], ["rèn"], ["wǔ"]],
    "沸沸汤汤": [["fèi"], ["fèi"], ["shāng"], ["shāng"]],
    "肺动脉": [["fèi"], ["dòng"], ["mài"]],
    "沸天震地": [["fèi"], ["tiān"], ["zhèn"], ["dì"]],
    "肺活量": [["fèi"], ["huó"], ["liàng"]],
    "肺结核": [["fèi"], ["jié"], ["hé"]],
    "肺静脉": [["fèi"], ["jìng"], ["mài"]],
    "肺石风清": [["fèi"], ["shí"], ["fēng"], ["qīng"]],
    "费尽心机": [["fèi"], ["jìn"], ["xīn"], ["jī"]],
    "痱子粉": [["fèi"], ["zǐ"], ["fěn"]],
    "分崩离析": [["fēn"], ["bēng"], ["lí"], ["xī"]],
    "分别部居": [["fēn"], ["bié"], ["bù"], ["jū"]],
    "分别门户": [["fēn"], ["bié"], ["mén"], ["hù"]],
    "分钗劈凤": [["fēn"], ["chāi"], ["pī"], ["fèng"]],
    "分钗断带": [["fēn"], ["chāi"], ["duàn"], ["dài"]],
    "分钗破镜": [["fēn"], ["chāi"], ["pò"], ["jìng"]],
    "分床同梦": [["fēn"], ["chuáng"], ["tóng"], ["mèng"]],
    "分寸之末": [["fēn"], ["cùn"], ["zhī"], ["mò"]],
    "分道扬镳": [["fēn"], ["dào"], ["yáng"], ["biāo"]],
    "分而治之": [["fēn"], ["ér"], ["zhì"], ["zhī"]],
    "分房减口": [["fēn"], ["fáng"], ["jiǎn"], ["kǒu"]],
    "分风劈流": [["fēn"], ["fēng"], ["pǐ"], ["liú"]],
    "分甘共苦": [["fēn"], ["gān"], ["gòng"], ["kǔ"]],
    "分甘绝少": [["fēn"], ["gān"], ["jué"], ["shǎo"]],
    "分甘同苦": [["fēn"], ["gān"], ["tóng"], ["kǔ"]],
    "分工合作": [["fēn"], ["gōng"], ["hé"], ["zuò"]],
    "分毫不差": [["fēn"], ["háo"], ["bù"], ["chā"]],
    "分毫不爽": [["fēn"], ["háo"], ["bù"], ["shuǎng"]],
    "分毫不取": [["fēn"], ["háo"], ["bù"], ["qǔ"]],
    "分毫不值": [["fēn"], ["háo"], ["bù"], ["zhí"]],
    "分毫无爽": [["fēn"], ["háo"], ["wú"], ["shuǎng"]],
    "分毫析厘": [["fēn"], ["háo"], ["xī"], ["lí"]],
    "分花拂柳": [["fēn"], ["huā"], ["fú"], ["liǔ"]],
    "分花约柳": [["fēn"], ["huā"], ["yuē"], ["liǔ"]],
    "分化瓦解": [["fēn"], ["huà"], ["wǎ"], ["jiě"]],
    "分家析产": [["fēn"], ["jiā"], ["xī"], ["chǎn"]],
    "分角器": [["fēn"], ["jiǎo"], ["qì"]],
    "分解者": [["fēn"], ["jiě"], ["zhě"]],
    "分界线": [["fēn"], ["jiè"], ["xiàn"]],
    "分斤掰两": [["fēn"], ["jīn"], ["bāi"], ["liǎng"]],
    "分斤拨两": [["fēn"], ["jīn"], ["bō"], ["liǎng"]],
    "分金掰两": [["fēn"], ["jīn"], ["bāi"], ["liǎng"]],
    "分镜头": [["fēn"], ["jìng"], ["tóu"]],
    "分进合击": [["fēn"], ["jìn"], ["hé"], ["jī"]],
    "分居异爨": [["fēn"], ["jū"], ["yì"], ["cuàn"]],
    "分劳赴功": [["fēn"], ["láo"], ["fù"], ["gōng"]],
    "分类学": [["fēn"], ["lèi"], ["xué"]],
    "分厘毫丝": [["fēn"], ["lí"], ["háo"], ["sī"]],
    "分理处": [["fēn"], ["lǐ"], ["chù"]],
    "分列式": [["fēn"], ["liè"], ["shì"]],
    "分路扬镳": [["fēn"], ["lù"], ["yáng"], ["biāo"]],
    "分茅赐土": [["fēn"], ["máo"], ["cì"], ["tǔ"]],
    "分茅列土": [["fēn"], ["máo"], ["liè"], ["tǔ"]],
    "分茅裂土": [["fēn"], ["máo"], ["liè"], ["tǔ"]],
    "分茅锡土": [["fēn"], ["máo"], ["xī"], ["tǔ"]],
    "分茅胙土": [["fēn"], ["máo"], ["zuò"], ["tǔ"]],
    "分门别户": [["fēn"], ["mén"], ["bié"], ["hù"]],
    "分门别类": [["fēn"], ["mén"], ["bié"], ["lèi"]],
    "分内之事": [["fèn"], ["nèi"], ["zhī"], ["shì"]],
    "分秒必争": [["fēn"], ["miǎo"], ["bì"], ["zhēng"]],
    "分配律": [["fēn"], ["pèi"], ["lǜ"]],
    "分朋引类": [["fēn"], ["péng"], ["yǐn"], ["lèi"]],
    "分贫振穷": [["fēn"], ["pín"], ["zhèn"], ["qióng"]],
    "分情破爱": [["fēn"], ["qíng"], ["pò"], ["ài"]],
    "分三别两": [["fēn"], ["sān"], ["bié"], ["liǎng"]],
    "分散染料": [["fēn"], ["sǎn"], ["rǎn"], ["liào"]],
    "分散主义": [["fēn"], ["sǎn"], ["zhǔ"], ["yì"]],
    "分身减口": [["fēn"], ["shēn"], ["jiǎn"], ["kǒu"]],
    "分身术": [["fēn"], ["shēn"], ["shù"]],
    "分身无术": [["fēn"], ["shēn"], ["wú"], ["shù"]],
    "分守要津": [["fēn"], ["shǒu"], ["yào"], ["jīn"]],
    "分数线": [["fēn"], ["shù"], ["xiàn"]],
    "分水岭": [["fēn"], ["shuǐ"], ["lǐng"]],
    "分水线": [["fēn"], ["shuǐ"], ["xiàn"]],
    "分丝析缕": [["fēn"], ["sī"], ["xī"], ["lǚ"]],
    "分条析理": [["fēn"], ["tiáo"], ["xī"], ["lǐ"]],
    "分庭伉礼": [["fēn"], ["tíng"], ["kàng"], ["lǐ"]],
    "分庭抗礼": [["fēn"], ["tíng"], ["kàng"], ["lǐ"]],
    "分外妖娆": [["fèn"], ["wài"], ["yāo"], ["ráo"]],
    "分文不取": [["fēn"], ["wén"], ["bù"], ["qǔ"]],
    "分文不名": [["fēn"], ["wén"], ["bù"], ["míng"]],
    "分文不直": [["fēn"], ["wén"], ["bù"], ["zhí"]],
    "分文不值": [["fēn"], ["wén"], ["bù"], ["zhí"]],
    "分文未取": [["fēn"], ["wén"], ["wèi"], ["qǔ"]],
    "分我杯羹": [["fēn"], ["wǒ"], ["bēi"], ["gēng"]],
    "分析语": [["fēn"], ["xī"], ["yǔ"]],
    "分香卖履": [["fēn"], ["xiāng"], ["mài"], ["lǚ"]],
    "分宵达曙": [["fēn"], ["xiāo"], ["dá"], ["shǔ"]],
    "分销店": [["fēn"], ["xiāo"], ["diàn"]],
    "分鞋破镜": [["fēn"], ["xié"], ["pò"], ["jìng"]],
    "分心挂腹": [["fēn"], ["xīn"], ["guà"], ["fù"]],
    "分星拨两": [["fēn"], ["xīng"], ["bō"], ["liǎng"]],
    "分星擘两": [["fēn"], ["xīng"], ["bò"], ["liǎng"]],
    "分星劈两": [["fēn"], ["xīng"], ["pī"], ["liǎng"]],
    "分形共气": [["fēn"], ["xíng"], ["gòng"], ["qì"]],
    "分形同气": [["fēn"], ["xíng"], ["tóng"], ["qì"]],
    "分形连气": [["fēn"], ["xíng"], ["lián"], ["qì"]],
    "分烟析产": [["fēn"], ["yān"], ["xī"], ["chǎn"]],
    "分烟析生": [["fēn"], ["yān"], ["xī"], ["shēng"]],
    "分章析句": [["fēn"], ["zhāng"], ["xī"], ["jù"]],
    "分子力": [["fèn"], ["zǐ"], ["lì"]],
    "分子量": [["fèn"], ["zǐ"], ["liàng"]],
    "分子筛": [["fèn"], ["zǐ"], ["shāi"]],
    "分子生物学": [["fèn"], ["zǐ"], ["shēng"], ["wù"], ["xué"]],
    "分子式": [["fèn"], ["zǐ"], ["shì"]],
    "分子物理学": [["fèn"], ["zǐ"], ["wù"], ["lǐ"], ["xué"]],
    "分子运动论": [["fèn"], ["zǐ"], ["yùn"], ["dòng"], ["lùn"]],
    "纷纷不一": [["fēn"], ["fēn"], ["bù"], ["yī"]],
    "纷红骇绿": [["fēn"], ["hóng"], ["hài"], ["lǜ"]],
    "纷纭杂沓": [["fēn"], ["yún"], ["zá"], ["tà"]],
    "纷至沓来": [["fēn"], ["zhì"], ["tà"], ["lái"]],
    "焚膏继晷": [["fén"], ["gāo"], ["jì"], ["guǐ"]],
    "焚骨扬灰": [["fén"], ["gǔ"], ["yáng"], ["huī"]],
    "焚枯食淡": [["fén"], ["kū"], ["shí"], ["dàn"]],
    "焚香扫地": [["fén"], ["xiāng"], ["sǎo"], ["dì"]],
    "焚林竭泽": [["fén"], ["lín"], ["jié"], ["zé"]],
    "粉白黛绿": [["fěn"], ["bái"], ["dài"], ["lǜ"]],
    "粉骨糜身": [["fěn"], ["gǔ"], ["mí"], ["shēn"]],
    "粉骨捐躯": [["fěn"], ["gǔ"], ["juān"], ["qū"]],
    "粉骨碎身": [["fěn"], ["gǔ"], ["suì"], ["shēn"]],
    "粉骨糜躯": [["fěn"], ["gǔ"], ["mí"], ["qū"]],
    "粉面油头": [["fěn"], ["miàn"], ["yóu"], ["tóu"]],
    "粉墨登场": [["fěn"], ["mò"], ["dēng"], ["chǎng"]],
    "粉面朱唇": [["fěn"], ["miàn"], ["zhū"], ["chún"]],
    "粉身灰骨": [["fěn"], ["shēn"], ["huī"], ["gǔ"]],
    "粉身碎骨": [["fěn"], ["shēn"], ["suì"], ["gǔ"]],
    "粉妆玉砌": [["fěn"], ["zhuāng"], ["yù"], ["qì"]],
    "粉妆玉琢": [["fěn"], ["zhuāng"], ["yù"], ["zhuó"]],
    "粉装玉琢": [["fěn"], ["zhuāng"], ["yù"], ["zhuó"]],
    "份儿饭": [["fèn"], ["ér"], ["fàn"]],
    "奋不顾命": [["fèn"], ["bù"], ["gù"], ["mìng"]],
    "奋不顾身": [["fèn"], ["bù"], ["gù"], ["shēn"]],
    "奋发蹈厉": [["fèn"], ["fā"], ["dǎo"], ["lì"]],
    "奋发踔厉": [["fèn"], ["fā"], ["chuō"], ["lì"]],
    "奋发有为": [["fèn"], ["fā"], ["yǒu"], ["wéi"]],
    "奋发图强": [["fèn"], ["fā"], ["tú"], ["qiáng"]],
    "奋起直追": [["fèn"], ["qǐ"], ["zhí"], ["zhuī"]],
    "奋身不顾": [["fèn"], ["shēn"], ["bù"], ["gù"]],
    "忿不顾身": [["fèn"], ["bù"], ["gù"], ["shēn"]],
    "忿忿不平": [["fèn"], ["fèn"], ["bù"], ["píng"]],
    "奋勇当先": [["fèn"], ["yǒng"], ["dāng"], ["xiān"]],
    "忿火中烧": [["fèn"], ["huǒ"], ["zhōng"], ["shāo"]],
    "愤不顾身": [["fèn"], ["bù"], ["gù"], ["shēn"]],
    "愤不欲生": [["fèn"], ["bù"], ["yù"], ["shēng"]],
    "愤风惊浪": [["fèn"], ["fēng"], ["jīng"], ["làng"]],
    "愤愤不平": [["fèn"], ["fèn"], ["bù"], ["píng"]],
    "愤世疾邪": [["fèn"], ["shì"], ["jí"], ["xié"]],
    "粪土不如": [["fèn"], ["tú"], ["bù"], ["rú"]],
    "丰标不凡": [["fēng"], ["biāo"], ["bù"], ["fán"]],
    "丰草长林": [["fēng"], ["cǎo"], ["cháng"], ["lín"]],
    "丰度翩翩": [["fēng"], ["dù"], ["piān"], ["piān"]],
    "丰富多采": [["fēng"], ["fù"], ["duō"], ["cǎi"]],
    "丰功盛烈": [["fēng"], ["gōng"], ["shèng"], ["liè"]],
    "丰功硕德": [["fēng"], ["gōng"], ["shuò"], ["dé"]],
    "丰亨豫大": [["fēng"], ["hēng"], ["yù"], ["dà"]],
    "丰肌弱骨": [["fēng"], ["jī"], ["ruò"], ["gǔ"]],
    "丰肌秀骨": [["fēng"], ["jī"], ["xiù"], ["gǔ"]],
    "丰取刻与": [["fēng"], ["qǔ"], ["kè"], ["yǔ"]],
    "丰神绰约": [["fēng"], ["shén"], ["chuò"], ["yuē"]],
    "丰屋蔀家": [["fēng"], ["wū"], ["zhī"], ["jiā"]],
    "丰屋之过": [["fēng"], ["wū"], ["zhī"], ["guò"]],
    "丰衣足食": [["fēng"], ["yī"], ["zú"], ["shí"]],
    "丰姿绰约": [["fēng"], ["zī"], ["chuò"], ["yuē"]],
    "丰姿冶丽": [["fēng"], ["zī"], ["yě"], ["lì"]],
    "风兵草甲": [["fēng"], ["bīng"], ["cǎo"], ["jiǎ"]],
    "风不鸣条": [["fēng"], ["bù"], ["míng"], ["tiáo"]],
    "风餐露宿": [["fēng"], ["cān"], ["lù"], ["sù"]],
    "风车云马": [["fēng"], ["chē"], ["yún"], ["mǎ"]],
    "风车雨马": [["fēng"], ["chē"], ["yǔ"], ["mǎ"]],
    "风掣雷行": [["fēng"], ["chè"], ["léi"], ["xíng"]],
    "风尘肮脏": [["fēng"], ["chén"], ["āng"], ["zāng"]],
    "风尘碌碌": [["fēng"], ["chén"], ["lù"], ["lù"]],
    "风尘之变": [["fēng"], ["chén"], ["zhī"], ["biàn"]],
    "风尘仆仆": [["fēng"], ["chén"], ["pú"], ["pú"]],
    "风驰草靡": [["fēng"], ["chí"], ["cǎo"], ["mǐ"]],
    "风尘之会": [["fēng"], ["chén"], ["zhī"], ["huì"]],
    "风驰电掣": [["fēng"], ["chí"], ["diàn"], ["chè"]],
    "风驰电骋": [["fēng"], ["chí"], ["diàn"], ["chěng"]],
    "风驰电赴": [["fēng"], ["chí"], ["diàn"], ["fù"]],
    "风驰电击": [["fēng"], ["chí"], ["diàn"], ["jī"]],
    "风驰电逝": [["fēng"], ["chí"], ["diàn"], ["shì"]],
    "风驰电卷": [["fēng"], ["chí"], ["diàn"], ["juǎn"]],
    "风驰霆击": [["fēng"], ["chí"], ["tíng"], ["jī"]],
    "风驰雨骤": [["fēng"], ["chí"], ["yǔ"], ["zhòu"]],
    "风驰云卷": [["fēng"], ["chí"], ["yún"], ["juǎn"]],
    "风驰云走": [["fēng"], ["chí"], ["yún"], ["zǒu"]],
    "风吹草动": [["fēng"], ["chuī"], ["cǎo"], ["dòng"]],
    "风吹浪打": [["fēng"], ["chuī"], ["làng"], ["dǎ"]],
    "风吹马耳": [["fēng"], ["chuī"], ["mǎ"], ["ěr"]],
    "风吹日晒": [["fēng"], ["chuī"], ["rì"], ["shài"]],
    "风吹雨打": [["fēng"], ["chuī"], ["yǔ"], ["dǎ"]],
    "风吹云散": [["fēng"], ["chuī"], ["yún"], ["sàn"]],
    "风刀霜剑": [["fēng"], ["dāo"], ["shuāng"], ["jiàn"]],
    "风调雨顺": [["fēng"], ["tiáo"], ["yǔ"], ["shùn"]],
    "风动工具": [["fēng"], ["dòng"], ["gōng"], ["jù"]],
    "风度翩翩": [["fēng"], ["dù"], ["piān"], ["piān"]],
    "风风雨雨": [["fēng"], ["fēng"], ["yǔ"], ["yǔ"]],
    "风风火火": [["fēng"], ["fēng"], ["huǒ"], ["huǒ"]],
    "风风韵韵": [["fēng"], ["fēng"], ["yùn"], ["yùn"]],
    "风骨峭峻": [["fēng"], ["gǔ"], ["qiào"], ["jùn"]],
    "风光旖旎": [["fēng"], ["guāng"], ["yǐ"], ["nǐ"]],
    "风光月霁": [["fēng"], ["guāng"], ["yuè"], ["jì"]],
    "风禾尽起": [["fēng"], ["hé"], ["jìn"], ["qǐ"]],
    "风和日丽": [["fēng"], ["hé"], ["rì"], ["lì"]],
    "风和日美": [["fēng"], ["hé"], ["rì"], ["měi"]],
    "风和日暖": [["fēng"], ["hé"], ["rì"], ["nuǎn"]],
    "风虎云龙": [["fēng"], ["hǔ"], ["yún"], ["lóng"]],
    "风和日暄": [["fēng"], ["hé"], ["rì"], ["xuān"]],
    "风花雪夜": [["fēng"], ["huā"], ["xuě"], ["yè"]],
    "风华绝代": [["fēng"], ["huá"], ["jué"], ["dài"]],
    "风花雪月": [["fēng"], ["huā"], ["xuě"], ["yuè"]],
    "风华正茂": [["fēng"], ["huá"], ["zhèng"], ["mào"]],
    "风鬟雾鬓": [["fēng"], ["huán"], ["wù"], ["bìn"]],
    "风鬟雨鬓": [["fēng"], ["huán"], ["yǔ"], ["bìn"]],
    "风回电激": [["fēng"], ["huí"], ["diàn"], ["jī"]],
    "风火墙": [["fēng"], ["huǒ"], ["qiáng"]],
    "风激电飞": [["fēng"], ["jī"], ["diàn"], ["fēi"]],
    "风激电骇": [["fēng"], ["jī"], ["diàn"], ["hài"]],
    "风景不殊": [["fēng"], ["jǐng"], ["bù"], ["shū"]],
    "风纪扣": [["fēng"], ["jì"], ["kòu"]],
    "风急浪高": [["fēng"], ["jí"], ["làng"], ["gāo"]],
    "风景画": [["fēng"], ["jǐng"], ["huà"]],
    "风举云飞": [["fēng"], ["jǔ"], ["yún"], ["fēi"]],
    "风举云摇": [["fēng"], ["jǔ"], ["yún"], ["yáo"]],
    "风卷残云": [["fēng"], ["juǎn"], ["cán"], ["yún"]],
    "风口浪尖": [["fēng"], ["kǒu"], ["làng"], ["jiān"]],
    "风谲云诡": [["fēng"], ["jué"], ["yún"], ["guǐ"]],
    "风雷火炮": [["fēng"], ["léi"], ["huǒ"], ["pào"]],
    "风雷之变": [["fēng"], ["léi"], ["zhī"], ["biàn"]],
    "风凉话": [["fēng"], ["liáng"], ["huà"]],
    "风流才子": [["fēng"], ["liú"], ["cái"], ["zǐ"]],
    "风流跌宕": [["fēng"], ["liú"], ["diē"], ["dàng"]],
    "风流千古": [["fēng"], ["liú"], ["qiān"], ["gǔ"]],
    "风流人物": [["fēng"], ["liú"], ["rén"], ["wù"]],
    "风流倜傥": [["fēng"], ["liú"], ["tì"], ["tǎng"]],
    "风流潇洒": [["fēng"], ["liú"], ["xiāo"], ["sǎ"]],
    "风流儒雅": [["fēng"], ["liú"], ["rú"], ["yǎ"]],
    "风流冤孽": [["fēng"], ["liú"], ["yuān"], ["niè"]],
    "风流云散": [["fēng"], ["liú"], ["yún"], ["sàn"]],
    "风流蕴藉": [["fēng"], ["liú"], ["yùn"], ["jiè"]],
    "风流韵事": [["fēng"], ["liú"], ["yùn"], ["shì"]],
    "风流罪过": [["fēng"], ["liú"], ["zuì"], ["guò"]],
    "风马不接": [["fēng"], ["mǎ"], ["bù"], ["jiē"]],
    "风马牛不相及": [["fēng"], ["mǎ"], ["niú"], ["bù"], ["xiāng"], ["jí"]],
    "风马云车": [["fēng"], ["mǎ"], ["yún"], ["chē"]],
    "风媒花": [["fēng"], ["méi"], ["huā"]],
    "风门水口": [["fēng"], ["mén"], ["shuǐ"], ["kǒu"]],
    "风靡一时": [["fēng"], ["mǐ"], ["yī"], ["shí"]],
    "风靡一世": [["fēng"], ["mǐ"], ["yī"], ["shì"]],
    "风木含悲": [["fēng"], ["mù"], ["hán"], ["bēi"]],
    "风木之思": [["fēng"], ["mù"], ["zhī"], ["sī"]],
    "风木之悲": [["fēng"], ["mù"], ["zhī"], ["bēi"]],
    "风牛马不相及": [["fēng"], ["niú"], ["mǎ"], ["bù"], ["xiāng"], ["jí"]],
    "风平波息": [["fēng"], ["píng"], ["bō"], ["xī"]],
    "风平浪静": [["fēng"], ["píng"], ["làng"], ["jìng"]],
    "风起水涌": [["fēng"], ["qǐ"], ["shuǐ"], ["yǒng"]],
    "风起云涌": [["fēng"], ["qǐ"], ["yún"], ["yǒng"]],
    "风起云蒸": [["fēng"], ["qǐ"], ["yún"], ["zhēng"]],
    "风前月下": [["fēng"], ["qián"], ["yuè"], ["xià"]],
    "风前残烛": [["fēng"], ["qián"], ["cán"], ["zhú"]],
    "风樯阵马": [["fēng"], ["qiáng"], ["zhèn"], ["mǎ"]],
    "风轻云净": [["fēng"], ["qīng"], ["yún"], ["jìng"]],
    "风清弊绝": [["fēng"], ["qīng"], ["bì"], ["jué"]],
    "风清月皎": [["fēng"], ["qīng"], ["yuè"], ["jiāo"]],
    "风清月朗": [["fēng"], ["qīng"], ["yuè"], ["lǎng"]],
    "风清月明": [["fēng"], ["qīng"], ["yuè"], ["míng"]],
    "风情月思": [["fēng"], ["qíng"], ["yuè"], ["sī"]],
    "风情月意": [["fēng"], ["qíng"], ["yuè"], ["yì"]],
    "风驱电击": [["fēng"], ["qū"], ["diàn"], ["jī"]],
    "风情月债": [["fēng"], ["qíng"], ["yuè"], ["zhài"]],
    "风驱电扫": [["fēng"], ["qū"], ["diàn"], ["sǎo"]],
    "风趣横生": [["fēng"], ["qù"], ["héng"], ["shēng"]],
    "风声鹤唳": [["fēng"], ["shēng"], ["hè"], ["lì"]],
    "风湿病": [["fēng"], ["shī"], ["bìng"]],
    "风湿性关节炎": [["fēng"], ["shī"], ["xìng"], ["guān"], ["jié"], ["yán"]],
    "风霜雨雪": [["fēng"], ["shuāng"], ["yǔ"], ["xuě"]],
    "风水先生": [["fēng"], ["shuǐ"], ["xiān"], ["shēng"]],
    "风俗画": [["fēng"], ["sú"], ["huà"]],
    "风俗人情": [["fēng"], ["sú"], ["rén"], ["qíng"]],
    "风俗习惯": [["fēng"], ["sú"], ["xí"], ["guàn"]],
    "风速器": [["fēng"], ["sù"], ["qì"]],
    "风土人情": [["fēng"], ["tú"], ["rén"], ["qíng"]],
    "风向标": [["fēng"], ["xiàng"], ["biāo"]],
    "风向器": [["fēng"], ["xiàng"], ["qì"]],
    "风潇雨晦": [["fēng"], ["xiāo"], ["yǔ"], ["huì"]],
    "风信年华": [["fēng"], ["xìn"], ["nián"], ["huá"]],
    "风信子": [["fēng"], ["xìn"], ["zǐ"]],
    "风行草从": [["fēng"], ["xíng"], ["cǎo"], ["cóng"]],
    "风行草靡": [["fēng"], ["xíng"], ["cǎo"], ["mí"]],
    "风行草偃": [["fēng"], ["xíng"], ["cǎo"], ["yǎn"]],
    "风行电掣": [["fēng"], ["xíng"], ["diàn"], ["chè"]],
    "风行电击": [["fēng"], ["xíng"], ["diàn"], ["jī"]],
    "风行电扫": [["fēng"], ["xíng"], ["diàn"], ["sǎo"]],
    "风行电照": [["fēng"], ["xíng"], ["diàn"], ["zhào"]],
    "风行雷厉": [["fēng"], ["xíng"], ["léi"], ["lì"]],
    "风行革偃": [["fēng"], ["xíng"], ["gé"], ["yǎn"]],
    "风行水上": [["fēng"], ["xíng"], ["shuǐ"], ["shàng"]],
    "风行一时": [["fēng"], ["xíng"], ["yī"], ["shī"]],
    "风行一世": [["fēng"], ["xíng"], ["yī"], ["shì"]],
    "风旋电掣": [["fēng"], ["xuán"], ["diàn"], ["chè"]],
    "风行雨散": [["fēng"], ["xíng"], ["yǔ"], ["sàn"]],
    "风雪交加": [["fēng"], ["xuě"], ["jiāo"], ["jiā"]],
    "风言醋语": [["fēng"], ["yán"], ["cù"], ["yǔ"]],
    "风言雾语": [["fēng"], ["yán"], ["wù"], ["yǔ"]],
    "风言风语": [["fēng"], ["yán"], ["fēng"], ["yǔ"]],
    "风言影语": [["fēng"], ["yán"], ["yǐng"], ["yǔ"]],
    "风影敷衍": [["fēng"], ["yǐng"], ["fū"], ["yān"]],
    "风雨不测": [["fēng"], ["yǔ"], ["bù"], ["cè"]],
    "风油精": [["fēng"], ["yóu"], ["jīng"]],
    "风雨不透": [["fēng"], ["yǔ"], ["bù"], ["tòu"]],
    "风雨不改": [["fēng"], ["yǔ"], ["bù"], ["gǎi"]],
    "风雨灯": [["fēng"], ["yǔ"], ["dēng"]],
    "风雨对床": [["fēng"], ["yǔ"], ["duì"], ["chuáng"]],
    "风雨共舟": [["fēng"], ["yǔ"], ["gòng"], ["zhōu"]],
    "风雨晦冥": [["fēng"], ["yǔ"], ["huì"], ["míng"]],
    "风雨晦暝": [["fēng"], ["yǔ"], ["huì"], ["míng"]],
    "风雨交加": [["fēng"], ["yǔ"], ["jiāo"], ["jiā"]],
    "风雨漂摇": [["fēng"], ["yǔ"], ["piāo"], ["yáo"]],
    "风雨连床": [["fēng"], ["yǔ"], ["lián"], ["chuáng"]],
    "风雨飘零": [["fēng"], ["yǔ"], ["piāo"], ["líng"]],
    "风雨飘摇": [["fēng"], ["yǔ"], ["piāo"], ["yáo"]],
    "风雨飘飖": [["fēng"], ["yǔ"], ["piāo"], ["yáo"]],
    "风雨凄凄": [["fēng"], ["yǔ"], ["qī"], ["qī"]],
    "风雨如磐": [["fēng"], ["yǔ"], ["rú"], ["pán"]],
    "风雨时若": [["fēng"], ["yǔ"], ["shí"], ["ruò"]],
    "风雨如晦": [["fēng"], ["yǔ"], ["rú"], ["huì"]],
    "风雨同舟": [["fēng"], ["yǔ"], ["tóng"], ["zhōu"]],
    "风雨无阻": [["fēng"], ["yǔ"], ["wú"], ["zǔ"]],
    "风雨摇摆": [["fēng"], ["yǔ"], ["yáo"], ["bǎi"]],
    "风雨衣": [["fēng"], ["yǔ"], ["yī"]],
    "风雨萧条": [["fēng"], ["yǔ"], ["xiāo"], ["tiáo"]],
    "风语不透": [["fēng"], ["yǔ"], ["bù"], ["tòu"]],
    "风月无涯": [["fēng"], ["yuè"], ["wú"], ["yá"]],
    "风月无边": [["fēng"], ["yuè"], ["wú"], ["biān"]],
    "风云变幻": [["fēng"], ["yún"], ["bià"], ["huàn"]],
    "风云变态": [["fēng"], ["yún"], ["biàn"], ["tài"]],
    "风云不测": [["fēng"], ["yún"], ["bù"], ["cè"]],
    "风云际会": [["fēng"], ["yún"], ["jì"], ["huì"]],
    "风云人物": [["fēng"], ["yún"], ["rén"], ["wù"]],
    "风云突变": [["fēng"], ["yún"], ["tū"], ["biàn"]],
    "风云之志": [["fēng"], ["yún"], ["zhī"], ["zhì"]],
    "风云月露": [["fēng"], ["yún"], ["yuè"], ["lù"]],
    "风韵犹存": [["fēng"], ["yùn"], ["yóu"], ["cún"]],
    "风疹块": [["fēng"], ["zhěn"], ["kuài"]],
    "风栉雨沐": [["fēng"], ["zhì"], ["yǔ"], ["mù"]],
    "风中秉烛": [["fēng"], ["zhōng"], ["bǐng"], ["zhú"]],
    "风中之烛": [["fēng"], ["zhōng"], ["zhī"], ["zhú"]],
    "风烛残年": [["fēng"], ["zhú"], ["cán"], ["nián"]],
    "风烛草露": [["fēng"], ["zhú"], ["cǎo"], ["lù"]],
    "风烛之年": [["fēng"], ["zhú"], ["zhī"], ["nián"]],
    "风姿绰约": [["fēng"], ["zī"], ["chuō"], ["yué"]],
    "封官许原": [["fēng"], ["guān"], ["xǔ"], ["yuán"]],
    "封建把头": [["fēng"], ["jiàn"], ["bǎ"], ["tóu"]],
    "封官许愿": [["fēng"], ["guān"], ["xǔ"], ["yuàn"]],
    "封建割据": [["fēng"], ["jiàn"], ["gē"], ["jù"]],
    "封建社会": [["fēng"], ["jiàn"], ["shè"], ["huì"]],
    "封建制度": [["fēng"], ["jiàn"], ["zhì"], ["dù"]],
    "封妻荫子": [["fēng"], ["qī"], ["yìn"], ["zǐ"]],
    "封豕长蛇": [["fēng"], ["shǐ"], ["cháng"], ["shé"]],
    "封豨修蛇": [["fēng"], ["xī"], ["yǒu"], ["shé"]],
    "峰回路转": [["fēng"], ["huí"], ["lù"], ["zhuǎn"]],
    "烽鼓不息": [["fēng"], ["gǔ"], ["bù"], ["xī"]],
    "烽火台": [["fēng"], ["huǒ"], ["tái"]],
    "烽火相连": [["fēng"], ["huǒ"], ["xiāng"], ["lián"]],
    "葑菲之采": [["fēng"], ["fēi"], ["zhī"], ["cǎi"]],
    "锋不可当": [["fēng"], ["bù"], ["kě"], ["dāng"]],
    "锋发韵流": [["fēng"], ["fā"], ["yùn"], ["liú"]],
    "锋芒毕露": [["fēng"], ["máng"], ["bì"], ["lù"]],
    "锋芒不露": [["fēng"], ["máng"], ["bù"], ["lù"]],
    "锋铓毕露": [["fēng"], ["máng"], ["bì"], ["lù"]],
    "蜂虿有毒": [["fēng"], ["chài"], ["yǒu"], ["dú"]],
    "蜂合豕突": [["fēng"], ["hé"], ["shǐ"], ["tū"]],
    "蜂合蚁聚": [["fēng"], ["hé"], ["yǐ"], ["jù"]],
    "蜂起云涌": [["fēng"], ["qǐ"], ["yún"], ["yǒng"]],
    "蜂趋蚁附": [["fēng"], ["qū"], ["yǐ"], ["fù"]],
    "蜂扇蚁聚": [["fēng"], ["shān"], ["yǐ"], ["jù"]],
    "蜂识莺猜": [["fēng"], ["shí"], ["yīng"], ["cāi"]],
    "蜂屯乌合": [["fēng"], ["tún"], ["wū"], ["hé"]],
    "蜂屯蚁聚": [["fēng"], ["tún"], ["yǐ"], ["jù"]],
    "蜂屯蚁附": [["fēng"], ["tún"], ["yǐ"], ["fù"]],
    "蜂屯蚁杂": [["fēng"], ["tún"], ["yǐ"], ["zá"]],
    "蜂王浆": [["fēng"], ["wáng"], ["jiāng"]],
    "蜂腰削背": [["fēng"], ["yāo"], ["xuē"], ["bèi"]],
    "蜂腰猿背": [["fēng"], ["yāo"], ["yuán"], ["bèi"]],
    "蜂拥而上": [["fēng"], ["yōng"], ["ér"], ["shàng"]],
    "蜂拥蚁屯": [["fēng"], ["yōng"], ["yǐ"], ["tún"]],
    "蜂攒蚁集": [["fēng"], ["cuán"], ["yǐ"], ["jí"]],
    "蜂攒蚁聚": [["fēng"], ["cuán"], ["yǐ"], ["jù"]],
    "冯河暴虎": [["féng"], ["hé"], ["bào"], ["hǔ"]],
    "冯驩弹铗": [["féng"], ["huān"], ["dàn"], ["jiá"]],
    "冯生弹铗": [["féng"], ["shēng"], ["dàn"], ["jiá"]],
    "冯唐白首": [["féng"], ["táng"], ["bái"], ["shǒu"]],
    "冯唐头白": [["féng"], ["táng"], ["tóu"], ["bái"]],
    "冯唐已老": [["féng"], ["táng"], ["yǐ"], ["lǎo"]],
    "冯唐易老": [["féng"], ["táng"], ["yì"], ["lǎo"]],
    "逢场竿木": [["féng"], ["chǎng"], ["gān"], ["mù"]],
    "逢场游戏": [["féng"], ["chǎng"], ["yóu"], ["xì"]],
    "逢场作乐": [["féng"], ["chǎng"], ["zuò"], ["lè"]],
    "逢场作趣": [["féng"], ["chǎng"], ["zuò"], ["qù"]],
    "逢场作戏": [["féng"], ["chǎng"], ["zuò"], ["xì"]],
    "逢恶导非": [["féng"], ["è"], ["dǎo"], ["fēi"]],
    "逢机遘会": [["féng"], ["jī"], ["gòu"], ["huì"]],
    "逢吉丁辰": [["féng"], ["jí"], ["dīng"], ["chén"]],
    "逢君之恶": [["féng"], ["jūn"], ["zhī"], ["è"]],
    "逢年过节": [["féng"], ["nián"], ["guò"], ["jié"]],
    "逢人说项": [["féng"], ["rén"], ["shuō"], ["xiàng"]],
    "逢凶化吉": [["féng"], ["xiōng"], ["huà"], ["jí"]],
    "逢时遇节": [["féng"], ["shí"], ["yù"], ["jié"]],
    "缝缝连连": [["fèng"], ["fèng"], ["lián"], ["lián"]],
    "缝纫机": [["féng"], ["rèn"], ["jī"]],
    "缝衣浅带": [["féng"], ["yī"], ["qiǎn"], ["dài"]],
    "凤泊鸾漂": [["fèng"], ["bó"], ["luán"], ["piāo"]],
    "讽多要寡": [["fěng"], ["duō"], ["yào"], ["guǎ"]],
    "凤泊鸾飘": [["fèng"], ["bó"], ["luán"], ["piāo"]],
    "凤采鸾章": [["fèng"], ["cǎi"], ["luán"], ["zhāng"]],
    "凤冠霞帔": [["fèng"], ["guān"], ["xiá"], ["pèi"]],
    "凤骨龙姿": [["fèng"], ["gǔ"], ["lóng"], ["zī"]],
    "凤楼龙阙": [["fèng"], ["lóu"], ["lóng"], ["què"]],
    "凤毛济美": [["fèng"], ["máo"], ["jì"], ["měi"]],
    "凤毛麟角": [["fèng"], ["máo"], ["lín"], ["jiǎo"]],
    "凤靡鸾吪": [["fèng"], ["mǐ"], ["luán"], ["é"]],
    "凤鸣朝阳": [["fèng"], ["míng"], ["zhāo"], ["yáng"]],
    "凤食鸾栖": [["fèng"], ["shí"], ["luán"], ["qī"]],
    "凤尾草": [["fèng"], ["wěi"], ["cǎo"]],
    "凤尾鱼": [["fèng"], ["wěi"], ["yú"]],
    "凤尾竹": [["fèng"], ["wěi"], ["zhú"]],
    "凤枭同巢": [["fèng"], ["xiāo"], ["tóng"], ["cháo"]],
    "凤协鸾和": [["fèng"], ["xié"], ["luán"], ["hé"]],
    "凤只鸾孤": [["fèng"], ["zhī"], ["luán"], ["gū"]],
    "奉公不阿": [["fèng"], ["gōng"], ["bù"], ["ē"]],
    "凤子龙孙": [["fèng"], ["zǐ"], ["lóng"], ["sūn"]],
    "奉公正己": [["fèng"], ["gōng"], ["zhèng"], ["jǐ"]],
    "奉令承教": [["fèng"], ["lìng"], ["chéng"], ["jiào"]],
    "奉若神明": [["fèng"], ["ruò"], ["shén"], ["míng"]],
    "奉头鼠窜": [["fèng"], ["tóu"], ["shǔ"], ["cuàn"]],
    "奉为至宝": [["fèng"], ["wéi"], ["zhì"], ["bǎo"]],
    "奉为圭臬": [["fèng"], ["wéi"], ["guī"], ["niè"]],
    "奉为楷模": [["fèng"], ["wéi"], ["kǎi"], ["mó"]],
    "奉行故事": [["fèng"], ["xíng"], ["gù"], ["shì"]],
    "奉扬仁风": [["fèng"], ["yáng"], ["rén"], ["fēng"]],
    "佛光寺": [["fó"], ["guāng"], ["sì"]],
    "佛甲草": [["fó"], ["jiǎ"], ["cǎo"]],
    "佛教徒": [["fó"], ["jiào"], ["tú"]],
    "佛口蛇心": [["fó"], ["kǒu"], ["shé"], ["xīn"]],
    "佛罗伦萨": [["fó"], ["luó"], ["lún"], ["sà"]],
    "佛门弟子": [["fó"], ["mén"], ["dì"], ["zǐ"]],
    "佛山市": [["fó"], ["shān"], ["shì"]],
    "佛手柑": [["fó"], ["shǒu"], ["gān"]],
    "佛头加秽": [["fó"], ["tóu"], ["jiā"], ["huì"]],
    "佛头着粪": [["fó"], ["tóu"], ["zhuó"], ["fèn"]],
    "佛心蛇口": [["fó"], ["xīn"], ["shé"], ["kǒu"]],
    "佛头著粪": [["fó"], ["tóu"], ["zhuó"], ["fèn"]],
    "佛性禅心": [["fó"], ["xìng"], ["chán"], ["xīn"]],
    "佛眼相看": [["fó"], ["yǎn"], ["xiāng"], ["kàn"]],
    "佛眼佛心": [["fó"], ["yǎn"], ["fó"], ["xīn"]],
    "否极泰回": [["pǐ"], ["jí"], ["tài"], ["huí"]],
    "否极泰来": [["pǐ"], ["jí"], ["tài"], ["lái"]],
    "否决权": [["fǒu"], ["jué"], ["quán"]],
    "否极阳回": [["pǐ"], ["jí"], ["yáng"], ["huí"]],
    "否去泰来": [["pǐ"], ["qù"], ["tài"], ["lái"]],
    "否往泰来": [["pǐ"], ["wǎng"], ["tài"], ["lái"]],
    "否终复泰": [["pǐ"], ["zhōng"], ["fù"], ["tài"]],
    "否终则泰": [["pǐ"], ["zhōng"], ["zé"], ["tài"]],
    "夫倡妇随": [["fū"], ["chàng"], ["fù"], ["suí"]],
    "夫唱妇随": [["fū"], ["chàng"], ["fù"], ["suí"]],
    "夫负妻戴": [["fū"], ["fù"], ["qī"], ["dài"]],
    "夫贵妻荣": [["fū"], ["guì"], ["qī"], ["róng"]],
    "夫妻店": [["fū"], ["qī"], ["diàn"]],
    "夫妻反目": [["fū"], ["qī"], ["fǎn"], ["mù"]],
    "夫人裙带": [["fū"], ["rén"], ["qún"], ["dài"]],
    "夫荣妻贵": [["fū"], ["róng"], ["qī"], ["guì"]],
    "夫荣妻显": [["fū"], ["róng"], ["qī"], ["xiǎn"]],
    "夫子自道": [["fū"], ["zǐ"], ["zì"], ["dào"]],
    "夫子庙": [["fū"], ["zǐ"], ["miào"]],
    "肤寸而合": [["fū"], ["cùn"], ["ér"], ["hé"]],
    "肤见谫识": [["fū"], ["jiàn"], ["jiǎn"], ["shí"]],
    "肤见謭识": [["fū"], ["jiàn"], ["guǎng"], ["shí"]],
    "肤皮潦草": [["fū"], ["pǐ"], ["liǎo"], ["cǎo"]],
    "肤受之愬": [["fū"], ["shòu"], ["zhī"], ["xiāng"]],
    "跗萼载韡": [["fū"], ["è"], ["zǎi"], ["wěi"]],
    "敷衍了事": [["fū"], ["yǎn"], ["liǎo"], ["shì"]],
    "敷衍塞责": [["fū"], ["yǎn"], ["sè"], ["zé"]],
    "敷衍搪塞": [["fū"], ["yǎn"], ["táng"], ["sè"]],
    "伏地圣人": [["fú"], ["dì"], ["shèng"], ["rén"]],
    "伏而咶天": [["fú"], ["ér"], ["shì"], ["tiān"]],
    "伏虎降龙": [["fú"], ["hǔ"], ["xiáng"], ["lóng"]],
    "凫短鹤长": [["fú"], ["duǎn"], ["hè"], ["cháng"]],
    "凫鹤从方": [["fú"], ["hè"], ["cóng"], ["fāng"]],
    "孚尹旁达": [["fú"], ["yǐn"], ["páng"], ["dá"]],
    "凫趋雀跃": [["fú"], ["qū"], ["què"], ["yuè"]],
    "扶弱抑强": [["fú"], ["ruò"], ["yì"], ["qiáng"]],
    "扶倾济弱": [["fú"], ["qīng"], ["jì"], ["ruò"]],
    "扶危济急": [["fú"], ["wēi"], ["jì"], ["jí"]],
    "扶危济困": [["fú"], ["wēi"], ["jì"], ["kùn"]],
    "扶危拯溺": [["fú"], ["wēi"], ["zhěng"], ["nì"]],
    "扶摇万里": [["fú"], ["yáo"], ["wàn"], ["lǐ"]],
    "扶正黜邪": [["fú"], ["zhèng"], ["chù"], ["xié"]],
    "扶摇直上": [["fú"], ["yáo"], ["zhí"], ["shàng"]],
    "扶正祛邪": [["fú"], ["zhèng"], ["qū"], ["xié"]],
    "芙蓉并蒂": [["fú"], ["róng"], ["bìng"], ["dì"]],
    "拂袖而归": [["fú"], ["xiù"], ["ér"], ["guī"]],
    "怫然不悦": [["fú"], ["rán"], ["bù"], ["yuè"]],
    "拂袖而去": [["fú"], ["xiù"], ["ér"], ["qù"]],
    "服低做小": [["fú"], ["dī"], ["zuò"], ["xiǎo"]],
    "服服贴贴": [["fú"], ["fú"], ["tiē"], ["tiē"]],
    "服服帖帖": [["fú"], ["fu"], ["tiē"], ["tiē"]],
    "服牛乘马": [["fú"], ["niú"], ["chéng"], ["mǎ"]],
    "服田力穑": [["fú"], ["tián"], ["lì"], ["sè"]],
    "服务行业": [["fú"], ["wù"], ["háng"], ["yè"]],
    "服务业": [["fú"], ["wù"], ["yè"]],
    "服务员": [["fú"], ["wù"], ["yuán"]],
    "浮动汇率": [["fú"], ["dòng"], ["huì"], ["lǜ"]],
    "浮白载笔": [["fú"], ["bái"], ["zǎi"], ["bǐ"]],
    "浮而不实": [["fú"], ["ér"], ["bù"], ["shí"]],
    "浮瓜沈李": [["fú"], ["guā"], ["shěn"], ["lǐ"]],
    "浮家泛宅": [["fú"], ["jiā"], ["fàn"], ["zhái"]],
    "浮名薄利": [["fú"], ["míng"], ["bó"], ["lì"]],
    "浮皮潦草": [["fú"], ["pí"], ["liáo"], ["cǎo"]],
    "浮生六记": [["fú"], ["shēng"], ["liù"], ["jì"]],
    "浮生切响": [["fú"], ["shēng"], ["qiè"], ["xiǎng"]],
    "浮生若梦": [["fú"], ["shēng"], ["ruò"], ["mèng"]],
    "浮声切响": [["fú"], ["shēng"], ["qiè"], ["xiǎng"]],
    "浮石沉木": [["fú"], ["shí"], ["chén"], ["mù"]],
    "浮收勒索": [["fú"], ["shōu"], ["lè"], ["suǒ"]],
    "浮收勒折": [["fú"], ["shōu"], ["lè"], ["shé"]],
    "浮头滑脑": [["fú"], ["tóu"], ["huá"], ["nǎo"]],
    "浮文巧语": [["fú"], ["wén"], ["qiǎo"], ["yǔ"]],
    "浮一大白": [["fú"], ["yī"], ["dà"], ["bái"]],
    "浮云朝露": [["fú"], ["yún"], ["zhāo"], ["lù"]],
    "浮语虚辞": [["fú"], ["yǔ"], ["xū"], ["cí"]],
    "桴鼓相应": [["fú"], ["gǔ"], ["xiāng"], ["yìng"]],
    "符号论": [["fú"], ["hào"], ["lùn"]],
    "符号逻辑": [["fú"], ["hào"], ["luó"], ["ji"]],
    "艴然不悦": [["fú"], ["rán"], ["bù"], ["yuè"]],
    "福不盈眦": [["fú"], ["bù"], ["yíng"], ["zì"]],
    "福地洞天": [["fú"], ["dì"], ["dòng"], ["tiān"]],
    "福过灾生": [["fú"], ["guò"], ["zāi"], ["shēng"]],
    "福建省": [["fú"], ["jiàn"], ["shěng"]],
    "福衢寿车": [["fú"], ["qú"], ["shòu"], ["chē"]],
    "福寿康宁": [["fú"], ["shòu"], ["kāng"], ["níng"]],
    "福寿无疆": [["fú"], ["shòu"], ["wú"], ["jiāng"]],
    "福寿齐天": [["fú"], ["shòu"], ["qí"], ["tiān"]],
    "福孙荫子": [["fú"], ["sūn"], ["yìn"], ["zǐ"]],
    "福为祸始": [["fú"], ["wéi"], ["huò"], ["shǐ"]],
    "福为祸先": [["fú"], ["wéi"], ["huò"], ["xiān"]],
    "蜉蝣撼大树": [["fú"], ["yóu"], ["hàn"], ["dà"], ["shù"]],
    "辐射能": [["fú"], ["shè"], ["néng"]],
    "抚今思昔": [["fǔ"], ["jīn"], ["sī"], ["xī"]],
    "抚今追昔": [["fǔ"], ["jīn"], ["zhuī"], ["xī"]],
    "抚景伤情": [["fǔ"], ["jǐng"], ["shāng"], ["qíng"]],
    "抚绥万方": [["fǔ"], ["suí"], ["wàn"], ["fāng"]],
    "抚掌大笑": [["fǔ"], ["zhǎng"], ["dà"], ["xiào"]],
    "抚掌击节": [["fǔ"], ["zhǎng"], ["jī"], ["jié"]],
    "拊背扼喉": [["fǔ"], ["bèi"], ["è"], ["hóu"]],
    "拊背扼吭": [["fǔ"], ["bèi"], ["è"], ["kēng"]],
    "拊心泣血": [["fǔ"], ["xīn"], ["qì"], ["xuè"]],
    "拊背搤吭": [["fǔ"], ["bèi"], ["hè"], ["kēng"]],
    "斧钺汤镬": [["fǔ"], ["yuè"], ["tāng"], ["huò"]],
    "俯拾地芥": [["fǔ"], ["shí"], ["dì"], ["jiè"]],
    "俯拾即是": [["fǔ"], ["shí"], ["jí"], ["shì"]],
    "俯拾仰取": [["fǔ"], ["shí"], ["yǎng"], ["qǔ"]],
    "俯拾皆是": [["fǔ"], ["shí"], ["jiē"], ["shì"]],
    "俯首帖耳": [["fǔ"], ["shǒu"], ["tiē"], ["ěr"]],
    "俯仰随人": [["fǔ"], ["yǎng"], ["suí"], ["rén"]],
    "俯仰唯唯": [["fǔ"], ["yǎng"], ["wéi"], ["wéi"]],
    "俯仰无愧": [["fǔ"], ["yǎng"], ["wú"], ["kuì"]],
    "俯仰由人": [["fǔ"], ["yǎng"], ["yóu"], ["rén"]],
    "俯仰之间": [["fǔ"], ["yǎng"], ["zhī"], ["jiān"]],
    "釜底抽薪": [["fǔ"], ["dǐ"], ["chōu"], ["xīn"]],
    "釜底游魂": [["fǔ"], ["dǐ"], ["yóu"], ["hún"]],
    "釜底游鱼": [["fǔ"], ["dǐ"], ["yóu"], ["yú"]],
    "釜鱼幕燕": [["fǔ"], ["yú"], ["mù"], ["yàn"]],
    "釜中生尘": [["fǔ"], ["zhōng"], ["shēng"], ["chén"]],
    "釜中生鱼": [["fǔ"], ["zhōng"], ["shēng"], ["yú"]],
    "釜中游鱼": [["fǔ"], ["zhōng"], ["yóu"], ["yú"]],
    "釜中之鱼": [["fǔ"], ["zhōng"], ["zhī"], ["yú"]],
    "辅车唇齿": [["fǔ"], ["chē"], ["chún"], ["chǐ"]],
    "辅车相将": [["fǔ"], ["chē"], ["xiāng"], ["jiāng"]],
    "辅车相依": [["fǔ"], ["chē"], ["xiāng"], ["yī"]],
    "辅导员": [["fǔ"], ["dǎo"], ["yuán"]],
    "辅世长民": [["fǔ"], ["shì"], ["zhǎng"], ["mín"]],
    "辅牙相倚": [["fǔ"], ["yá"], ["xiāng"], ["yǐ"]],
    "腐殖质": [["fǔ"], ["zhí"], ["zhì"]],
    "簠簋不饬": [["fǔ"], ["guǐ"], ["bù"], ["chì"]],
    "黼蔀黻纪": [["fǔ"], ["bù"], ["fú"], ["jì"]],
    "黼国黻家": [["fǔ"], ["guó"], ["fú"], ["jiā"]],
    "父慈子孝": [["fù"], ["cí"], ["zǐ"], ["xiào"]],
    "父母恩勤": [["fù"], ["mǔ"], ["ēn"], ["qín"]],
    "父母官": [["fù"], ["mǔ"], ["guān"]],
    "父母之邦": [["fù"], ["mǔ"], ["zhī"], ["bāng"]],
    "父亲节": [["fù"], ["qīn"], ["jié"]],
    "父权制": [["fù"], ["quán"], ["zhì"]],
    "父为子隐": [["fù"], ["wéi"], ["zǐ"], ["yǐn"]],
    "父析子荷": [["fù"], ["xī"], ["zǐ"], ["hé"]],
    "父严子孝": [["fù"], ["yán"], ["zǐ"], ["xiào"]],
    "付之丙丁": [["fù"], ["zhī"], ["bǐng"], ["dīng"]],
    "父债子还": [["fù"], ["zhài"], ["zǐ"], ["huán"]],
    "付之度外": [["fù"], ["zhī"], ["dù"], ["wài"]],
    "妇道人家": [["fù"], ["dào"], ["rén"], ["jiā"]],
    "妇姑勃溪": [["fù"], ["gū"], ["bó"], ["xī"]],
    "妇姑勃谿": [["fù"], ["gū"], ["bó"], ["xī"]],
    "妇女病": [["fù"], ["nǚ"], ["bìng"]],
    "妇女节": [["fù"], ["nǚ"], ["jié"]],
    "妇女运动": [["fù"], ["nǚ"], ["yùn"], ["dòng"]],
    "妇孺皆知": [["fù"], ["rú"], ["jiē"], ["zhī"]],
    "负才任气": [["fù"], ["cái"], ["rèn"], ["qì"]],
    "负材矜地": [["fù"], ["cái"], ["jīn"], ["dì"]],
    "负材任气": [["fù"], ["cái"], ["rèn"], ["qì"]],
    "负乘致寇": [["fù"], ["chéng"], ["zhì"], ["kòu"]],
    "负乘斯夺": [["fù"], ["chéng"], ["sī"], ["duó"]],
    "负德背义": [["fù"], ["dé"], ["bèi"], ["yì"]],
    "负地矜才": [["fù"], ["dì"], ["jīn"], ["cái"]],
    "负恩背义": [["fù"], ["ēn"], ["bèi"], ["yì"]],
    "负固不宾": [["fù"], ["gù"], ["bù"], ["bīn"]],
    "负固不服": [["fù"], ["gù"], ["bù"], ["fú"]],
    "负衡据鼎": [["fù"], ["héng"], ["jù"], ["dǐng"]],
    "负老提幼": [["fù"], ["lǎo"], ["tí"], ["yòu"]],
    "负气斗狠": [["fù"], ["qì"], ["dǒu"], ["hěn"]],
    "负任蒙劳": [["fù"], ["rèn"], ["méng"], ["láo"]],
    "负石赴河": [["fù"], ["shí"], ["fù"], ["hé"]],
    "负俗之累": [["fù"], ["sú"], ["zhī"], ["lèi"]],
    "负险不宾": [["fù"], ["xiǎn"], ["bù"], ["bīn"]],
    "负险不臣": [["fù"], ["xiǎn"], ["bù"], ["chén"]],
    "负债累累": [["fù"], ["zhai"], ["lèi"], ["lèi"]],
    "负重含污": [["fù"], ["zhòng"], ["hán"], ["wū"]],
    "负重涉远": [["fù"], ["zhòng"], ["shè"], ["yuǎn"]],
    "负重吞污": [["fù"], ["zhòng"], ["tūn"], ["wū"]],
    "负重致远": [["fù"], ["zhòng"], ["zhì"], ["yuǎn"]],
    "附耳射声": [["fù"], ["ěr"], ["shè"], ["shēng"]],
    "负阻不宾": [["fù"], ["zǔ"], ["bù"], ["bīn"]],
    "附肤落毛": [["fù"], ["fū"], ["luò"], ["máo"]],
    "附会穿凿": [["fù"], ["huì"], ["chuān"], ["záo"]],
    "附骥尾": [["fù"], ["jì"], ["wěi"]],
    "附膻逐腥": [["fù"], ["shān"], ["zhú"], ["xīng"]],
    "附上罔下": [["fù"], ["shàng"], ["wǎng"], ["xià"]],
    "附势趋炎": [["fù"], ["shì"], ["qū"], ["yán"]],
    "附下罔上": [["fù"], ["xià"], ["wǎng"], ["shàng"]],
    "附炎趋热": [["fù"], ["yán"], ["qū"], ["rè"]],
    "附庸风雅": [["fù"], ["yōng"], ["fēng"], ["yǎ"]],
    "附属国": [["fù"], ["shǔ"], ["guó"]],
    "附赘县疣": [["fù"], ["zhuì"], ["xiàn"], ["yóu"]],
    "复旦大学": [["fù"], ["dàn"], ["dà"], ["xué"]],
    "复合材料": [["fù"], ["hé"], ["cái"], ["liào"]],
    "复合词": [["fù"], ["hé"], ["cí"]],
    "复合肥料": [["fù"], ["hé"], ["féi"], ["liào"]],
    "复合量词": [["fù"], ["hé"], ["liàng"], ["cí"]],
    "复合元音": [["fù"], ["hé"], ["yuán"], ["yīn"]],
    "复合物": [["fù"], ["hé"], ["wù"]],
    "复活节": [["fù"], ["huó"], ["jié"]],
    "复名数": [["fù"], ["míng"], ["shù"]],
    "复种指数": [["fù"], ["zhǒng"], ["zhǐ"], ["shù"]],
    "赴汤蹈火": [["fù"], ["tāng"], ["dǎo"], ["huǒ"]],
    "副标题": [["fù"], ["biāo"], ["tí"]],
    "副产品": [["fù"], ["chǎn"], ["pǐn"]],
    "副产物": [["fù"], ["chǎn"], ["wù"]],
    "副教授": [["fù"], ["jiào"], ["shòu"]],
    "副食品": [["fù"], ["shí"], ["pǐn"]],
    "副研究员": [["fù"], ["yán"], ["jiū"], ["yuán"]],
    "副油箱": [["fù"], ["yóu"], ["xiāng"]],
    "副作用": [["fù"], ["zuò"], ["yòng"]],
    "傅粉何郎": [["fù"], ["fěn"], ["hé"], ["láng"]],
    "傅粉施朱": [["fù"], ["fěn"], ["shī"], ["zhū"]],
    "傅立叶": [["fù"], ["lì"], ["yè"]],
    "富富有余": [["fù"], ["fù"], ["yǒu"], ["yú"]],
    "富贵不能淫": [["fù"], ["guì"], ["bù"], ["néng"], ["yín"]],
    "富贵荣华": [["fù"], ["guì"], ["róng"], ["huá"]],
    "富贵不淫": [["fù"], ["guì"], ["bù"], ["yín"]],
    "富国彊兵": [["fù"], ["guó"], ["jiāng"], ["bīng"]],
    "富国强兵": [["fù"], ["guó"], ["qiáng"], ["bīng"]],
    "富国强民": [["fù"], ["guó"], ["qiáng"], ["mín"]],
    "富家大室": [["fù"], ["jiā"], ["dà"], ["shì"]],
    "富家巨室": [["fù"], ["jiā"], ["jù"], ["shì"]],
    "富可敌国": [["fù"], ["kě"], ["dí"], ["guó"]],
    "富轹万古": [["fù"], ["lì"], ["wàn"], ["gǔ"]],
    "富丽堂皇": [["fù"], ["lì"], ["táng"], ["huáng"]],
    "富埒王侯": [["fù"], ["liè"], ["wáng"], ["hóu"]],
    "富商大贾": [["fù"], ["shāng"], ["dà"], ["jiǎ"]],
    "富商巨贾": [["fù"], ["shāng"], ["jù"], ["jiǎ"]],
    "富商蓄贾": [["fù"], ["shāng"], ["xù"], ["jiǎ"]],
    "富室大家": [["fù"], ["shì"], ["dà"], ["jiā"]],
    "富营养化": [["fù"], ["yíng"], ["yǎng"], ["huà"]],
    "富裕中农": [["fù"], ["yù"], ["zhōng"], ["nóng"]],
    "富在知足": [["fù"], ["zài"], ["zhī"], ["zú"]],
    "腹饱万言": [["fù"], ["bǎo"], ["wàn"], ["yán"]],
    "腹心相照": [["fù"], ["xīn"], ["xiāng"], ["zhào"]],
    "腹背之毛": [["fù"], ["bèi"], ["zhī"], ["máo"]],
    "腹背受敌": [["fù"], ["bèi"], ["shòu"], ["dí"]],
    "腹有鳞甲": [["fù"], ["yǒu"], ["lín"], ["jiǎ"]],
    "腹载五车": [["fù"], ["zài"], ["wǔ"], ["chē"]],
    "腹中兵甲": [["fù"], ["zhōng"], ["bīng"], ["jiǎ"]],
    "覆车之轨": [["fù"], ["chē"], ["zhī"], ["guǐ"]],
    "覆车之戒": [["fù"], ["chē"], ["zhī"], ["jiè"]],
    "覆车之鉴": [["fù"], ["chē"], ["zhī"], ["jiàn"]],
    "覆地翻天": [["fù"], ["dì"], ["fān"], ["tiān"]],
    "覆盖面": [["fù"], ["gài"], ["miàn"]],
    "覆军杀将": [["fù"], ["jūn"], ["shā"], ["jiāng"]],
    "覆盆难照": [["fù"], ["pén"], ["nán"], ["zhào"]],
    "覆水难收": [["fù"], ["shuǐ"], ["nán"], ["shōu"]],
    "覆雨翻云": [["fù"], ["yǔ"], ["fān"], ["yún"]],
    "覆亡无日": [["fù"], ["wáng"], ["wú"], ["rì"]],
    "伽马射线": [["gā"], ["mǎ"], ["shè"], ["xiàn"]],
    "伽利略": [["jiā"], ["lì"], ["lüè"]],
    "嘎嘣脆": [["gā"], ["bēng"], ["cuì"]],
    "嘎渣儿": [["gā"], ["zhā"], ["ér"]],
    "改操易节": [["gǎi"], ["cāo"], ["yì"], ["jié"]],
    "改朝换代": [["gǎi"], ["cháo"], ["huàn"], ["dài"]],
    "改朝换姓": [["gǎi"], ["cháo"], ["huàn"], ["xìng"]],
    "改恶从善": [["gǎi"], ["è"], ["cóng"], ["shàn"]],
    "改恶为善": [["gǎi"], ["è"], ["wéi"], ["shàn"]],
    "改恶向善": [["gǎi"], ["è"], ["xiàng"], ["shàn"]],
    "改恶行善": [["gǎi"], ["è"], ["xíng"], ["shàn"]],
    "改而更张": [["gǎi"], ["ér"], ["gèng"], ["zhāng"]],
    "改过不吝": [["gǎi"], ["guò"], ["bù"], ["lìn"]],
    "改过从善": [["gǎi"], ["guò"], ["cóng"], ["shàn"]],
    "改过作新": [["gǎi"], ["guò"], ["zuò"], ["xīn"]],
    "改过迁善": [["gǎi"], ["guò"], ["qiān"], ["shàn"]],
    "改过自新": [["gǎi"], ["guò"], ["zì"], ["xīn"]],
    "改换家门": [["gǎi"], ["huàn"], ["jiā"], ["mén"]],
    "改换头面": [["gǎi"], ["huàn"], ["tóu"], ["miàn"]],
    "改节易操": [["gǎi"], ["jié"], ["yì"], ["cāo"]],
    "改柯易节": [["gǎi"], ["kē"], ["yì"], ["jié"]],
    "改柯易叶": [["gǎi"], ["kē"], ["yì"], ["yè"]],
    "改口沓舌": [["gǎi"], ["kǒu"], ["tà"], ["shé"]],
    "改曲易调": [["gǎi"], ["qǔ"], ["yì"], ["diào"]],
    "改俗迁风": [["gǎi"], ["sú"], ["qiān"], ["fēng"]],
    "改天换地": [["gǎi"], ["tiān"], ["huàn"], ["dì"]],
    "改头换面": [["gǎi"], ["tóu"], ["huàn"], ["miàn"]],
    "改头换尾": [["gǎi"], ["tóu"], ["huàn"], ["wěi"]],
    "改弦易调": [["gǎi"], ["xián"], ["yì"], ["diào"]],
    "改弦更张": [["gǎi"], ["xián"], ["gēng"], ["zhāng"]],
    "改邪归正": [["gǎi"], ["xié"], ["guī"], ["zhèng"]],
    "改行从善": [["gǎi"], ["xíng"], ["cóng"], ["shàn"]],
    "改行迁善": [["gǎi"], ["xíng"], ["qiān"], ["shàn"]],
    "改行为善": [["gǎi"], ["xíng"], ["wéi"], ["shàn"]],
    "改行自新": [["gǎi"], ["xíng"], ["zìxīn"]],
    "改姓更名": [["gǎi"], ["xìng"], ["gēng"], ["míng"]],
    "改玉改行": [["gǎi"], ["yù"], ["gǎi"], ["xíng"]],
    "改张易调": [["gǎi"], ["zhāng"], ["yì"], ["diào"]],
    "改政移风": [["gǎi"], ["zhèng"], ["yí"], ["fēng"]],
    "盖不由己": [["gài"], ["bù"], ["yóu"], ["jǐ"]],
    "盖棺论定": [["gài"], ["guān"], ["lùn"], ["dìng"]],
    "盖棺事定": [["gài"], ["guān"], ["shì"], ["dìng"]],
    "盖帽儿": [["gài"], ["mào"], ["ér"]],
    "盖世太保": [["gài"], ["shì"], ["tài"], ["bǎo"]],
    "盖世无双": [["gài"], ["shì"], ["wú"], ["shuāng"]],
    "盖世英雄": [["gài"], ["shì"], ["yīng"], ["xióng"]],
    "盖头换面": [["gài"], ["tóu"], ["huàn"], ["miàn"]],
    "盖世之才": [["gài"], ["shì"], ["zhī"], ["cái"]],
    "概率论": [["gài"], ["lǜ"], ["lùn"]],
    "概莫能外": [["gài"], ["mò"], ["néng"], ["wài"]],
    "概念化": [["gài"], ["niàn"], ["huà"]],
    "干巴巴": [["gān"], ["bā"], ["bā"]],
    "干巴利脆": [["gān"], ["bā"], ["lì"], ["cuì"]],
    "干巴利落": [["gān"], ["bā"], ["lì"], ["luò"]],
    "干部学校": [["gàn"], ["bù"], ["xué"], ["xiào"]],
    "干柴烈火": [["gān"], ["chái"], ["liè"], ["huǒ"]],
    "干城之将": [["gān"], ["chéng"], ["zhī"], ["jiàng"]],
    "干脆利落": [["gān"], ["cuì"], ["lì"], ["luò"]],
    "干脆利索": [["gàn"], ["cuì"], ["lì"], ["suǒ"]],
    "干打垒": [["gàn"], ["dǎ"], ["lěi"]],
    "干瞪眼": [["gàn"], ["dèng"], ["yǎn"]],
    "干电池": [["gàn"], ["diàn"], ["chí"]],
    "干端坤倪": [["gàn"], ["duān"], ["kūn"], ["ní"]],
    "干父之蛊": [["gàn"], ["fù"], ["zhī"], ["gǔ"]],
    "干干净净": [["gàn"], ["gān"], ["jìng"], ["jìng"]],
    "干干翼翼": [["gàn"], ["gàn"], ["yì"], ["yì"]],
    "干戈载戢": [["gàn"], ["gē"], ["zǎi"], ["jí"]],
    "干将莫邪": [["gān"], ["jiàng"], ["mò"], ["yé"]],
    "干酵母": [["gàn"], ["jiào"], ["mǔ"]],
    "干净利落": [["gān"], ["jìng"], ["lì"], ["luò"]],
    "干净利索": [["gàn"], ["jìng"], ["lì"], ["suǒ"]],
    "干名采誉": [["gān"], ["míng"], ["cǎi"], ["yù"]],
    "干名犯义": [["gàn"], ["míng"], ["fàn"], ["yì"]],
    "干卿底事": [["gān"], ["qīng"], ["dǐ"], ["shì"]],
    "干涉现象": [["gān"], ["shè"], ["xiàn"], ["xiàng"]],
    "干什么": [["gàn"], ["shén"], ["me"]],
    "干啼湿哭": [["gàn"], ["tí"], ["shī"], ["kū"]],
    "干霄蔽日": [["gàn"], ["xiāo"], ["bì"], ["rì"]],
    "干霄凌云": [["gān"], ["xiāo"], ["líng"], ["yún"]],
    "干性油": [["gàn"], ["xìng"], ["yóu"]],
    "干云蔽日": [["gān"], ["yún"], ["bì"], ["rì"]],
    "干燥剂": [["gān"], ["zào"], ["jì"]],
    "干燥器": [["gān"], ["zào"], ["qì"]],
    "甘败下风": [["gān"], ["bài"], ["xià"], ["fēng"]],
    "干着急": [["gān"], ["zháo"], ["jí"]],
    "甘拜下风": [["gān"], ["bài"], ["xià"], ["fēng"]],
    "甘处下流": [["gān"], ["chǔ"], ["xià"], ["liú"]],
    "甘分随时": [["gān"], ["fèn"], ["suí"], ["shí"]],
    "甘苦与共": [["gān"], ["kǔ"], ["yǔ"], ["gòng"]],
    "甘冒虎口": [["gān"], ["mào"], ["hǔ"], ["kǒu"]],
    "甘贫乐道": [["gān"], ["pín"], ["lè"], ["dào"]],
    "甘贫守分": [["gān"], ["pín"], ["shǒu"], ["fēn"]],
    "甘雨随车": [["gān"], ["yǔ"], ["suí"], ["chē"]],
    "甘言美语": [["gān"], ["yán"], ["měi"], ["yǔ"]],
    "甘之若素": [["gān"], ["zhī"], ["ruò"], ["sù"]],
    "肝胆过人": [["gān"], ["dǎn"], ["guò"], ["rén"]],
    "肝胆涂地": [["gān"], ["dǎn"], ["tú"], ["dì"]],
    "肝胆相照": [["gān"], ["dǎn"], ["xiāng"], ["zhào"]],
    "肝脑涂地": [["gān"], ["nǎo"], ["tú"], ["dì"]],
    "肝心若裂": [["gān"], ["xīn"], ["ruò"], ["liè"]],
    "肝硬化": [["gān"], ["yìng"], ["huà"]],
    "肝心涂地": [["gān"], ["xīn"], ["tú"], ["dì"]],
    "竿头日进": [["gān"], ["tóu"], ["rì"], ["jìn"]],
    "竿头日上": [["gān"], ["tóu"], ["rí"], ["shàng"]],
    "竿头一步": [["gān"], ["tóu"], ["yī"], ["bù"]],
    "竿头直上": [["gān"], ["tóu"], ["zhí"], ["shàng"]],
    "赶不及": [["gǎn"], ["bù"], ["jí"]],
    "赶不上": [["gǎn"], ["bù"], ["shàng"]],
    "赶得及": [["gǎn"], ["de"], ["jí"]],
    "赶得上": [["gǎn"], ["děi"], ["shàng"]],
    "赶尽杀绝": [["gǎn"], ["jìn"], ["shā"], ["jué"]],
    "赶浪头": [["gǎn"], ["làng"], ["tóu"]],
    "赶任务": [["gǎn"], ["rèn"], ["wù"]],
    "赶庙会": [["gǎn"], ["miào"], ["huì"]],
    "赶趟儿": [["gǎn"], ["tàng"], ["ér"]],
    "赶鸭子上架": [["gǎn"], ["yā"], ["zī"], ["shàng"], ["jià"]],
    "敢不承命": [["gǎn"], ["bù"], ["chéng"], ["mìng"]],
    "敢怒而不敢言": [["gǎn"], ["nù"], ["ér"], ["bù"], ["gǎn"], ["yán"]],
    "敢为敢做": [["gǎn"], ["wéi"], ["gǎn"], ["zuò"]],
    "敢勇当先": [["gǎn"], ["yǒng"], ["dāng"], ["xiān"]],
    "敢怨而不敢言": [["gǎn"], ["yuàn"], ["ér"], ["bù"], ["gǎn"], ["yán"]],
    "敢作敢当": [["gǎn"], ["zuò"], ["gǎn"], ["dāng"]],
    "敢作敢为": [["gǎn"], ["zuò"], ["gǎn"], ["wéi"]],
    "感恩节": [["gǎn"], ["ēn"], ["jié"]],
    "感光片": [["gǎn"], ["guāng"], ["piàn"]],
    "感激不尽": [["gǎn"], ["jī"], ["bù"], ["jìn"]],
    "感今思昔": [["gǎn"], ["jīn"], ["sī"], ["xī"]],
    "感慨万端": [["gǎn"], ["kǎi"], ["wàn"], ["duān"]],
    "感觉器官": [["gǎn"], ["jué"], ["qì"], ["guān"]],
    "感慨万千": [["gǎn"], ["kǎi"], ["wàn"], ["qiān"]],
    "感慨系之": [["gǎn"], ["kǎi"], ["xì"], ["zhī"]],
    "感叹号": [["gǎn"], ["tàn"], ["hào"]],
    "感叹句": [["gǎn"], ["tàn"], ["jù"]],
    "感天动地": [["gǎn"], ["tiān"], ["dòng"], ["dì"]],
    "感同身受": [["gǎn"], ["tóng"], ["shēn"], ["shòu"]],
    "感性认识": [["gǎn"], ["xìng"], ["rèn"], ["shi"]],
    "感应电流": [["gǎn"], ["yìng"], ["diàn"], ["liú"]],
    "感应圈": [["gǎn"], ["yìng"], ["quān"]],
    "橄榄绿": [["gǎn"], ["lǎn"], ["lǜ"]],
    "橄榄石": [["gǎn"], ["lǎn"], ["shí"]],
    "橄榄枝": [["gǎn"], ["lǎn"], ["zhī"]],
    "旰食宵衣": [["gàn"], ["shí"], ["xiāo"], ["yī"]],
    "旰食之劳": [["gàn"], ["shí"], ["zhī"], ["láo"]],
    "刚柔相济": [["gāng"], ["róu"], ["xiāng"], ["jì"]],
    "刚肠嫉恶": [["gāng"], ["cháng"], ["jí"], ["è"]],
    "刚正不阿": [["gāng"], ["zhèng"], ["bù"], ["ē"]],
    "刚直不阿": [["gāng"], ["zhí"], ["bù"], ["ē"]],
    "刚中柔外": [["gāng"], ["zhōng"], ["róu"], ["wài"]],
    "岗头泽底": [["gāng"], ["tóu"], ["zé"], ["dǐ"]],
    "岗位责任制": [["gǎng"], ["wèi"], ["zé"], ["rèn"], ["zhì"]],
    "纲纪废弛": [["gāng"], ["jì"], ["fèi"], ["chí"]],
    "纲目不疏": [["gāng"], ["mù"], ["bù"], ["shū"]],
    "纲提领挈": [["gāng"], ["tí"], ["lǐng"], ["qiè"]],
    "钢笔套": [["gāng"], ["bǐ"], ["tào"]],
    "钢化玻璃": [["gāng"], ["huà"], ["bō"], ["li"]],
    "钢浇铁铸": [["gāng"], ["jiāo"], ["tiě"], ["zhù"]],
    "钢结构": [["gāng"], ["jié"], ["gòu"]],
    "钢筋混凝土": [["gāng"], ["jīn"], ["hùn"], ["níng"], ["tǔ"]],
    "钢筋铁骨": [["gāng"], ["jīng"], ["tiě"], ["gǔ"]],
    "钢丝床": [["gāng"], ["sī"], ["chuáng"]],
    "钢丝锯": [["gāng"], ["sī"], ["jù"]],
    "钢丝绳": [["gāng"], ["sī"], ["shéng"]],
    "港务监督": [["gǎng"], ["wù"], ["jiān"], ["dū"]],
    "港务局": [["gǎng"], ["wù"], ["jú"]],
    "高傲自大": [["gāo"], ["ào"], ["zì"], ["dà"]],
    "高八度": [["gāo"], ["bā"], ["dù"]],
    "高不成低不就": [["gāo"], ["bù"], ["chéng"], ["dī"], ["bù"], ["jiù"]],
    "高不凑低不就": [["gāo"], ["bù"], ["còu"], ["dī"], ["bù"], ["jiù"]],
    "高不辏低不就": [["gāo"], ["bù"], ["còu"], ["dī"], ["bù"], ["jiù"]],
    "高不可登": [["gāo"], ["bù"], ["kě"], ["dēng"]],
    "高不可攀": [["gāo"], ["bù"], ["kě"], ["pān"]],
    "高才大学": [["gāo"], ["cái"], ["dà"], ["xué"]],
    "高才远识": [["gāo"], ["cái"], ["yuǎn"], ["shí"]],
    "高层建筑": [["gāo"], ["céng"], ["jiàn"], ["zhù"]],
    "高才卓识": [["gāo"], ["cái"], ["zhuó"], ["shí"]],
    "高车驷马": [["gāo"], ["chē"], ["sì"], ["mǎ"]],
    "高蹈远举": [["gāo"], ["dǎo"], ["yuǎn"], ["jǔ"]],
    "高等教育": [["gāo"], ["děng"], ["jiào"], ["yù"]],
    "高等学校": [["gāo"], ["děng"], ["xué"], ["xiào"]],
    "高低杠": [["gāo"], ["dī"], ["gàng"]],
    "高遏行云": [["gāo"], ["è"], ["xíng"], ["yún"]],
    "高度计": [["gāo"], ["dù"], ["jì"]],
    "高而不危": [["gāo"], ["ér"], ["bù"], ["wēi"]],
    "高尔夫球": [["gāo"], ["ěr"], ["fū"], ["qiú"]],
    "高飞远遁": [["gāo"], ["fēi"], ["yuǎn"], ["dùn"]],
    "高飞远集": [["gāo"], ["fēi"], ["yuǎn"], ["jí"]],
    "高飞远举": [["gāo"], ["fēi"], ["yuǎn"], ["jǔ"]],
    "高飞远翔": [["gāo"], ["fēi"], ["yuǎn"], ["xiáng"]],
    "高飞远走": [["gāo"], ["fēi"], ["yuǎn"], ["zǒu"]],
    "高分子": [["gāo"], ["fèn"], ["zǐ"]],
    "高分子化合物": [["gāo"], ["fèn"], ["zǐ"], ["huà"], ["hé"], ["wù"]],
    "高风劲节": [["gāo"], ["fēng"], ["jìng"], ["jié"]],
    "高风峻节": [["gāo"], ["fēng"], ["jùn"], ["jié"]],
    "高风亮节": [["gāo"], ["fēng"], ["liàng"], ["jié"]],
    "高高在上": [["gāo"], ["gāo"], ["zài"], ["shàng"]],
    "高高兴兴": [["gāo"], ["gāo"], ["xìng"], ["xīng"]],
    "高官重禄": [["gāo"], ["guān"], ["zhòng"], ["lù"]],
    "高冠博带": [["gāo"], ["guān"], ["bó"], ["dài"]],
    "高级中学": [["gāo"], ["jí"], ["zhōng"], ["xué"]],
    "高技术": [["gāo"], ["jì"], ["shù"]],
    "高甲戏": [["gāo"], ["jiǎ"], ["xì"]],
    "高见远识": [["gāo"], ["jiàn"], ["yuǎn"], ["shí"]],
    "高节清风": [["gāo"], ["jié"], ["qīng"], ["fēng"]],
    "高举深藏": [["gāo"], ["jǔ"], ["shēn"], ["cáng"]],
    "高举远蹈": [["gāo"], ["jǔ"], ["yuǎn"], ["dǎo"]],
    "高空槽": [["gāo"], ["kōng"], ["cáo"]],
    "高爵重禄": [["gāo"], ["jué"], ["zhòng"], ["lù"]],
    "高空作业": [["gāo"], ["kōng"], ["zuò"], ["yè"]],
    "高丽参": [["gāo"], ["lí"], ["shēn"]],
    "高丽纸": [["gāo"], ["lí"], ["zhǐ"]],
    "高岭土": [["gāo"], ["lǐng"], ["tǔ"]],
    "高楼大厦": [["gāo"], ["lóu"], ["dà"], ["shà"]],
    "高门大户": [["gāo"], ["mén"], ["dà"], ["hù"]],
    "高门大屋": [["gāo"], ["mén"], ["dà"], ["wū"]],
    "高明远识": [["gāo"], ["míng"], ["yuǎn"], ["shí"]],
    "高名大姓": [["gāo"], ["míng"], ["dà"], ["xìng"]],
    "高睨大谈": [["gāo"], ["nì"], ["dà"], ["tán"]],
    "高频头": [["gāo"], ["pín"], ["tóu"]],
    "高情逸兴": [["gāo"], ["qíng"], ["yì"], ["xīng"]],
    "高情远意": [["gāo"], ["qíng"], ["yuǎn"], ["yì"]],
    "高情远韵": [["gāo"], ["qíng"], ["yuǎn"], ["yùn"]],
    "高情远致": [["gāo"], ["qíng"], ["yuǎn"], ["zhì"]],
    "高山景行": [["gāo"], ["shān"], ["jǐng"], ["xíng"]],
    "高山反应": [["gāo"], ["shān"], ["fǎn"], ["yìng"]],
    "高山峻岭": [["gāo"], ["shān"], ["jùn"], ["lǐng"]],
    "高山仰之": [["gāo"], ["shān"], ["yǎng"], ["zhī"]],
    "高山仰止": [["gāo"], ["shān"], ["yǎng"], ["zhǐ"]],
    "高射炮": [["gāo"], ["shè"], ["pào"]],
    "高深莫测": [["gāo"], ["shēn"], ["mò"], ["cè"]],
    "高识远见": [["gāo"], ["shí"], ["yuǎn"], ["jiàn"]],
    "高速钢": [["gāo"], ["sù"], ["gāng"]],
    "高谈大论": [["gāo"], ["tán"], ["dà"], ["lùn"]],
    "高谈弘论": [["gāo"], ["tán"], ["hóng"], ["lùn"]],
    "高碳钢": [["gāo"], ["tàn"], ["gāng"]],
    "高谈虚论": [["gāo"], ["tán"], ["xū"], ["lùn"]],
    "高谈阔论": [["gāo"], ["tán"], ["kuò"], ["lùn"]],
    "高天厚地": [["gāo"], ["tiān"], ["hòu"], ["dì"]],
    "高挑儿": [["gāo"], ["tiǎo"], ["ér"]],
    "高堂大厦": [["gāo"], ["táng"], ["dà"], ["shà"]],
    "高头大马": [["gāo"], ["tóu"], ["dà"], ["mǎ"]],
    "高位重禄": [["gāo"], ["wèi"], ["zhòng"], ["lù"]],
    "高纬度": [["gāo"], ["wěi"], ["dù"]],
    "高头讲章": [["gāo"], ["tóu"], ["jiǎng"], ["zhāng"]],
    "高文大册": [["gāo"], ["wén"], ["dà"], ["cè"]],
    "高下任心": [["gāo"], ["xià"], ["rèn"], ["xīn"]],
    "高下其手": [["gāo"], ["xià"], ["qí"], ["shǒu"]],
    "高翔远引": [["gāo"], ["xiáng"], ["yuǎn"], ["yǐn"]],
    "高效能": [["gāo"], ["xiào"], ["néng"]],
    "高血压": [["gāo"], ["xuè"], ["yā"]],
    "高姓大名": [["gāo"], ["xìng"], ["dà"], ["míng"]],
    "高压电": [["gāo"], ["yā"], ["diàn"]],
    "高压锅": [["gāo"], ["yā"], ["guō"]],
    "高压线": [["gāo"], ["yā"], ["xiàn"]],
    "高牙大纛": [["gāo"], ["yá"], ["dà"], ["dào"]],
    "高义薄云": [["gāo"], ["yì"], ["bó"], ["yún"]],
    "高义薄云天": [["gāo"], ["yì"], ["báo"], ["yún"], ["tiān"]],
    "高掌远跖": [["gāo"], ["zhǎng"], ["yuǎn"], ["zhí"]],
    "高瞻远瞩": [["gāo"], ["zhān"], ["yuǎn"], ["zhǔ"]],
    "高掌远蹠": [["gāo"], ["zhǎng"], ["yuǎn"], ["zhí"]],
    "高足弟子": [["gāo"], ["zú"], ["dì"], ["zǐ"]],
    "高祖父": [["gāo"], ["zǔ"], ["fù"]],
    "膏场绣浍": [["gāo"], ["cháng"], ["xiù"], ["kuài"]],
    "膏车秣马": [["gào"], ["chē"], ["mò"], ["mǎ"]],
    "膏唇贩舌": [["gào"], ["chún"], ["fàn"], ["shé"]],
    "膏唇试舌": [["gāo"], ["chún"], ["shì"], ["shé"]],
    "膏唇岐舌": [["gào"], ["chún"], ["qí"], ["shé"]],
    "膏唇拭舌": [["gāo"], ["chún"], ["shì"], ["shé"]],
    "膏肓之疾": [["gāo"], ["huāng"], ["zhī"], ["jí"]],
    "膏火之费": [["gāo"], ["huǒ"], ["zhī"], ["fèi"]],
    "膏火自煎": [["gāo"], ["huǒ"], ["zì"], ["jiān"]],
    "膏梁锦绣": [["gāo"], ["liáng"], ["jǐn"], ["xiù"]],
    "膏梁纨袴": [["gāo"], ["liáng"], ["wán"], ["kù"]],
    "膏粱锦绣": [["gāo"], ["liáng"], ["jǐn"], ["xiù"]],
    "膏粱纨袴": [["gāo"], ["liáng"], ["wán"], ["kù"]],
    "膏粱年少": [["gāo"], ["liáng"], ["nián"], ["shào"]],
    "膏粱子弟": [["gāo"], ["liáng"], ["zǐ"], ["dì"]],
    "膏粱文绣": [["gāo"], ["liáng"], ["wén"], ["xiù"]],
    "膏腴贵游": [["gāo"], ["yú"], ["guì"], ["yóu"]],
    "膏腴之地": [["gāo"], ["yú"], ["zhī"], ["dì"]],
    "膏腴子弟": [["gāo"], ["yú"], ["zǐ"], ["dì"]],
    "槁苏暍醒": [["gǎo"], ["sū"], ["yē"], ["xǐng"]],
    "膏泽脂香": [["gāo"], ["zé"], ["zhī"], ["xiāng"]],
    "槁项没齿": [["gǎo"], ["xiàng"], ["méi"], ["chǐ"]],
    "告老还家": [["gào"], ["lǎo"], ["huán"], ["jiā"]],
    "告老还乡": [["gào"], ["lǎo"], ["huán"], ["xiāng"]],
    "告老在家": [["gào"], ["lǎo"], ["zài"], ["jiā"]],
    "告朔饩羊": [["gù"], ["shuò"], ["xì"], ["yáng"]],
    "告往知来": [["gào"], ["wǎng"], ["zhī"], ["lái"]],
    "戈兰高地": [["gē"], ["lán"], ["gāo"], ["dì"]],
    "疙瘩汤": [["gē"], ["dā"], ["tāng"]],
    "疙疙瘩瘩": [["gē"], ["gē"], ["dā"], ["dá"]],
    "疙里疙瘩": [["gē"], ["lǐ"], ["gē"], ["dā"]],
    "哥本哈根": [["gē"], ["běn"], ["hā"], ["gēn"]],
    "哥老会": [["gē"], ["lǎo"], ["huì"]],
    "胳膊拧不过大腿": [["gē"], ["bo"], ["nǐng"], ["bù"], ["guò"], ["dà"], ["tuǐ"]],
    "胳膊腕子": [["gē"], ["bo"], ["wàn"], ["zǐ"]],
    "胳膊肘": [["gē"], ["bo"], ["zhǒu"]],
    "胳肢窝": [["gē"], ["zhī"], ["wō"]],
    "胳膊肘子": [["gē"], ["bo"], ["zhǒu"], ["zǐ"]],
    "鸽子笼": [["gē"], ["zi"], ["lóng"]],
    "割臂盟公": [["gē"], ["bì"], ["méng"], ["gōng"]],
    "割臂之盟": [["gē"], ["bì"], ["zhī"], ["méng"]],
    "割地称臣": [["gē"], ["dì"], ["chēng"], ["chén"]],
    "割地求和": [["gē"], ["dì"], ["qiú"], ["hé"]],
    "割肚牵肠": [["gē"], ["dù"], ["qiān"], ["cháng"]],
    "割股疗亲": [["gē"], ["gǔ"], ["liáo"], ["qīn"]],
    "割骨疗亲": [["gē"], ["gǔ"], ["liáo"], ["qīn"]],
    "割据一方": [["gē"], ["jù"], ["yī"], ["fāng"]],
    "割尾巴": [["gē"], ["wěi"], ["bā"]],
    "割席分坐": [["gē"], ["xí"], ["fēn"], ["zuò"]],
    "搁不住": [["gé"], ["bú"], ["zhù"]],
    "搁得住": [["gé"], ["de"], ["zhù"]],
    "歌唱家": [["gē"], ["chàng"], ["jiā"]],
    "歌片儿": [["gē"], ["piān"], ["er"]],
    "歌台舞榭": [["gē"], ["tái"], ["wǔ"], ["xiè"]],
    "歌舞伎": [["gē"], ["wǔ"], ["jì"]],
    "歌莺舞燕": [["gē"], ["yíng"], ["wǔ"], ["yàn"]],
    "歌仔戏": [["gē"], ["zǎi"], ["xì"]],
    "革风易俗": [["gé"], ["fēng"], ["yì"], ["sú"]],
    "革奸铲暴": [["gé"], ["jiān"], ["chǎn"], ["bào"]],
    "革旧从新": [["gé"], ["jiù"], ["cóng"], ["xīn"]],
    "革面洗心": [["gé"], ["miàn"], ["xǐ"], ["xīn"]],
    "革命创制": [["gé"], ["mìng"], ["chuàng"], ["zhì"]],
    "革命反正": [["gé"], ["mìng"], ["fǎn"], ["zhèng"]],
    "革命根据地": [["gé"], ["mìng"], ["gēn"], ["jù"], ["dì"]],
    "革命家": [["gé"], ["mìng"], ["jiā"]],
    "革命委员会": [["gé"], ["mìng"], ["wěi"], ["yuán"], ["huì"]],
    "革邪反正": [["gé"], ["xié"], ["fǎn"], ["zhèng"]],
    "格不相入": [["gé"], ["bù"], ["xiāng"], ["rù"]],
    "革心易行": [["gé"], ["xīn"], ["yì"], ["xíng"]],
    "格高意远": [["gé"], ["gāo"], ["yì"], ["yuǎn"]],
    "格格不吐": [["gē"], ["gē"], ["bù"], ["tǔ"]],
    "格格不纳": [["gē"], ["gē"], ["bù"], ["nà"]],
    "格格不入": [["gé"], ["gé"], ["bù"], ["rù"]],
    "格林尼治时间": [["gé"], ["lín"], ["ní"], ["zhì"], ["shí"], ["jiān"]],
    "格杀不论": [["gé"], ["shā"], ["bù"], ["lùn"]],
    "格杀弗论": [["gé"], ["shā"], ["fú"], ["lùn"]],
    "格杀无论": [["gé"], ["shā"], ["wú"], ["lùn"]],
    "格杀勿论": [["gé"], ["shā"], ["wù"], ["lùn"]],
    "格物致知": [["gé"], ["wù"], ["zhì"], ["zhī"]],
    "葛屦履霜": [["gě"], ["jù"], ["lǚ"], ["shuāng"]],
    "蛤蟆镜": [["há"], ["má"], ["jìng"]],
    "隔岸观火": [["gé"], ["àn"], ["guān"], ["huǒ"]],
    "隔墙有耳": [["gé"], ["qiáng"], ["yǒu"], ["ěr"]],
    "隔三差五": [["gé"], ["sān"], ["chà"], ["wǔ"]],
    "隔行如隔山": [["gé"], ["háng"], ["rú"], ["gé"], ["shān"]],
    "隔音符号": [["gé"], ["yīn"], ["fú"], ["hào"]],
    "个旧市": [["gè"], ["jiù"], ["shì"]],
    "个人财产": [["gè"], ["rén"], ["cái"], ["chǎn"]],
    "个人主义": [["gè"], ["rén"], ["zhǔ"], ["yì"]],
    "个体户": [["gè"], ["tǐ"], ["hù"]],
    "个体经济": [["gè"], ["tǐ"], ["jīng"], ["jì"]],
    "个体所有制": [["gè"], ["tǐ"], ["suǒ"], ["yǒu"], ["zhì"]],
    "个头儿": [["gè"], ["tou"], ["er"]],
    "个中妙趣": [["gè"], ["zhōng"], ["miào"], ["qù"]],
    "个中滋味": [["gè"], ["zhōng"], ["zī"], ["wèi"]],
    "各安生业": [["gè"], ["ān"], ["shēng"], ["yè"]],
    "各奔前程": [["gè"], ["bèn"], ["qián"], ["chéng"]],
    "各不相谋": [["gè"], ["bù"], ["xiāng"], ["móu"]],
    "各不相让": [["gè"], ["bù"], ["xiāng"], ["ràng"]],
    "各持己见": [["gè"], ["chí"], ["jǐ"], ["jiàn"]],
    "各从其志": [["gè"], ["cóng"], ["qí"], ["zhì"]],
    "各得其所": [["gè"], ["dé"], ["qí"], ["suǒ"]],
    "各得其宜": [["gè"], ["dé"], ["qí"], ["yí"]],
    "各个击破": [["gè"], ["gè"], ["jī"], ["pò"]],
    "各尽所能": [["gè"], ["jìn"], ["suǒ"], ["néng"]],
    "各就各位": [["gè"], ["jiù"], ["gè"], ["wèi"]],
    "各取所长": [["gè"], ["qǔ"], ["suǒ"], ["cháng"]],
    "各人自扫门前雪": [["gè"], ["rén"], ["zì"], ["sǎo"], ["mén"], ["qián"], ["xuě"]],
    "各取所需": [["gè"], ["qǔ"], ["suǒ"], ["xū"]],
    "各色各样": [["gè"], ["sè"], ["gè"], ["yàng"]],
    "各色名样": [["gè"], ["sè"], ["gè"], ["yàng"]],
    "各抒己见": [["gè"], ["shū"], ["jǐ"], ["jiàn"]],
    "各色人等": [["gè"], ["sè"], ["rén"], ["děng"]],
    "各抒所见": [["gè"], ["shū"], ["suǒ"], ["jiàn"]],
    "各式各样": [["gè"], ["shì"], ["gè"], ["yàng"]],
    "各司其事": [["gè"], ["sī"], ["qí"], ["shì"]],
    "各为其主": [["gè"], ["wèi"], ["qí"], ["zhǔ"]],
    "各行各业": [["gè"], ["háng"], ["gè"], ["yè"]],
    "各行其是": [["gè"], ["xíng"], ["qí"], ["shì"]],
    "各行其志": [["gè"], ["xíng"], ["qí"], ["zhì"]],
    "各有千秋": [["gè"], ["yǒu"], ["qiān"], ["qiū"]],
    "各有所长": [["gè"], ["yǒu"], ["suǒ"], ["chéng"]],
    "各有所短": [["gè"], ["yǒu"], ["suǒ"], ["duǎn"]],
    "各有所好": [["gè"], ["yǒu"], ["suǒ"], ["hào"]],
    "各有所职": [["gè"], ["yǒu"], ["suǒ"], ["zhí"]],
    "各执己见": [["gè"], ["zhí"], ["jǐ"], ["jiàn"]],
    "各执一词": [["gè"], ["zhí"], ["yī"], ["cí"]],
    "各种各样": [["gè"], ["zhǒng"], ["gè"], ["yàng"]],
    "各自为战": [["gè"], ["zì"], ["wéi"], ["zhàn"]],
    "各自为政": [["gè"], ["zì"], ["wéi"], ["zhèng"]],
    "给面子": [["gěi"], ["miàn"], ["zi"]],
    "根孤伎薄": [["gēn"], ["gū"], ["jì"], ["báo"]],
    "根椽片瓦": [["gēn"], ["chuán"], ["piàn"], ["wǎ"]],
    "根结盘固": [["gēn"], ["jié"], ["pán"], ["gù"]],
    "根结盘据": [["gēn"], ["jié"], ["pán"], ["jù"]],
    "根据地": [["gēn"], ["jù"], ["dì"]],
    "根据盘互": [["gēn"], ["jù"], ["pán"], ["hù"]],
    "根据槃互": [["gēn"], ["jù"], ["pán"], ["hù"]],
    "根瘤菌": [["gēn"], ["liú"], ["jūn"]],
    "根盘蒂结": [["gēn"], ["pán"], ["dì"], ["jié"]],
    "根蟠节错": [["gēn"], ["pán"], ["jié"], ["cuò"]],
    "根深柢固": [["gēn"], ["shēn"], ["dǐ"], ["gù"]],
    "根深蒂结": [["gēn"], ["shēn"], ["dì"], ["jié"]],
    "根深叶茂": [["gēn"], ["shēn"], ["yè"], ["mào"]],
    "根深枝茂": [["gēn"], ["shēn"], ["zhī"], ["mào"]],
    "根生土长": [["gēn"], ["shēn"], ["tǔ"], ["zhǎng"]],
    "根指数": [["gēn"], ["zhǐ"], ["shù"]],
    "根株附丽": [["gēn"], ["zhū"], ["fù"], ["lì"]],
    "根株结盘": [["gēn"], ["zhū"], ["jié"], ["pán"]],
    "根壮叶茂": [["gēn"], ["zhuàng"], ["yè"], ["mào"]],
    "亘古不灭": [["gèn"], ["gǔ"], ["bù"], ["miè"]],
    "亘古奇闻": [["gèn"], ["gǔ"], ["qī"], ["wén"]],
    "亘古未有": [["gèn"], ["gǔ"], ["wèi"], ["yǒu"]],
    "更长梦短": [["gēng"], ["cháng"], ["mèng"], ["duǎn"]],
    "更唱迭和": [["gēng"], ["chàng"], ["dié"], ["hé"]],
    "更唱叠和": [["gēng"], ["chàng"], ["dié"], ["hé"]],
    "更待干罢": [["gèng"], ["dài"], ["gàn"], ["bà"]],
    "更阑人静": [["gēng"], ["lán"], ["rén"], ["jǐng"]],
    "更进一竿": [["gèng"], ["jìn"], ["yī"], ["gān"]],
    "更令明号": [["gēng"], ["lìng"], ["míng"], ["hào"]],
    "更名改姓": [["gèng"], ["míng"], ["gǎi"], ["xìng"]],
    "更难仆数": [["gēng"], ["nán"], ["pú"], ["shù"]],
    "更年期": [["gēng"], ["nián"], ["qī"]],
    "更仆难尽": [["gèng"], ["pú"], ["nán"], ["jìn"]],
    "更仆难数": [["gēng"], ["pú"], ["nán"], ["shǔ"]],
    "更仆难终": [["gēng"], ["pú"], ["nán"], ["zhōng"]],
    "更上一层楼": [["gèng"], ["shàng"], ["yī"], ["céng"], ["lóu"]],
    "更深夜静": [["gēng"], ["shēn"], ["yè"], ["jìng"]],
    "更深人静": [["gēng"], ["shēn"], ["rén"], ["jìng"]],
    "更弦改辙": [["gēng"], ["xián"], ["gǎi"], ["zhé"]],
    "更弦易辙": [["gēng"], ["xián"], ["yì"], ["zhé"]],
    "更新换代": [["gēng"], ["xīn"], ["huàn"], ["dài"]],
    "更姓改物": [["gēng"], ["xìng"], ["gǎi"], ["wù"]],
    "更衣室": [["gēng"], ["yī"], ["shì"]],
    "庚癸频呼": [["gēng"], ["guǐ"], ["pín"], ["hū"]],
    "耕当问奴": [["gēng"], ["dāng"], ["wèn"], ["nú"]],
    "耕云播雨": [["gēng"], ["yún"], ["bō"], ["yǔ"]],
    "耕者有其田": [["gēng"], ["zhě"], ["yǒu"], ["qí"], ["tián"]],
    "羹藜唅糗": [["gēng"], ["lí"], ["hán"], ["qiǔ"]],
    "梗泛萍漂": [["gěng"], ["fàn"], ["píng"], ["piāo"]],
    "梗顽不化": [["gěng"], ["wán"], ["bù"], ["huà"]],
    "工读学校": [["gōng"], ["dú"], ["xué"], ["xiào"]],
    "工间操": [["gōng"], ["jiān"], ["cāo"]],
    "工具钢": [["gōng"], ["jù"], ["gāng"]],
    "工农兵学员": [["gōng"], ["nóng"], ["bīng"], ["xué"], ["yuán"]],
    "工农红军": [["gōng"], ["nóng"], ["hóng"], ["jūn"]],
    "工业化": [["gōng"], ["yè"], ["huà"]],
    "工业基地": [["gōng"], ["yè"], ["jī"], ["dì"]],
    "工业建筑": [["gōng"], ["yè"], ["jiàn"], ["zhù"]],
    "工业区": [["gōng"], ["yè"], ["qū"]],
    "工业区位论": [["gōng"], ["yè"], ["qū"], ["wèi"], ["lùn"]],
    "工业体系": [["gōng"], ["yè"], ["tǐ"], ["xì"]],
    "工艺美术": [["gōng"], ["yì"], ["měi"], ["shù"]],
    "工字钢": [["gōng"], ["zì"], ["gāng"]],
    "工作服": [["gōng"], ["zuò"], ["fú"]],
    "工作量": [["gōng"], ["zuò"], ["liàng"]],
    "弓影杯蛇": [["gōng"], ["yǐng"], ["bēi"], ["shé"]],
    "弓调马服": [["gōng"], ["diào"], ["mǎ"], ["fú"]],
    "弓折刀尽": [["gōng"], ["zhé"], ["dāo"], ["jìn"]],
    "公倍数": [["gōng"], ["bèi"], ["shù"]],
    "公报私仇": [["gōng"], ["bào"], ["sī"], ["chóu"]],
    "公道合理": [["gōng"], ["dào"], ["hé"], ["lǐ"]],
    "公共厕所": [["gōng"], ["gòng"], ["cè"], ["suǒ"]],
    "公共场所": [["gōng"], ["gòng"], ["chǎng"], ["suǒ"]],
    "公共关系": [["gōng"], ["gòng"], ["guān"], ["xì"]],
    "公共积累": [["gōng"], ["gòng"], ["jī"], ["lěi"]],
    "公共建筑": [["gōng"], ["gòng"], ["jiàn"], ["zhù"]],
    "公共课": [["gōng"], ["gòng"], ["kè"]],
    "公共交通": [["gōng"], ["gòng"], ["jiāo"], ["tōng"]],
    "公共汽车": [["gōng"], ["gòng"], ["qì"], ["chē"]],
    "公共事业": [["gōng"], ["gòng"], ["shì"], ["yè"]],
    "公共卫生": [["gōng"], ["gòng"], ["wèi"], ["shēng"]],
    "公共秩序": [["gōng"], ["gòng"], ["zhì"], ["xù"]],
    "公教人员": [["gōng"], ["jiào"], ["rén"], ["yuán"]],
    "公开信": [["gōng"], ["kāi"], ["xìn"]],
    "公立学校": [["gōng"], ["lì"], ["xué"], ["xiào"]],
    "公民投票": [["gōng"], ["mín"], ["tóu"], ["piào"]],
    "公明正大": [["gōng"], ["míng"], ["zhèng"], ["dà"]],
    "公平合理": [["gōng"], ["píng"], ["hé"], ["lǐ"]],
    "公切线": [["gōng"], ["qiē"], ["xiàn"]],
    "公式化": [["gōng"], ["shì"], ["huà"]],
    "公司债券": [["gōng"], ["sī"], ["zhài"], ["quàn"]],
    "公私合营": [["gōng"], ["sī"], ["hé"], ["yíng"]],
    "公私两济": [["gōng"], ["sī"], ["liǎng"], ["jì"]],
    "公私两便": [["gōng"], ["sī"], ["liǎng"], ["biàn"]],
    "公听并观": [["gōng"], ["tīng"], ["bìng"], ["guān"]],
    "公务员": [["gōng"], ["wù"], ["yuán"]],
    "公休日": [["gōng"], ["xiū"], ["rì"]],
    "公有制": [["gōng"], ["yǒu"], ["zhì"]],
    "公约数": [["gōng"], ["yuē"], ["shù"]],
    "公债券": [["gōng"], ["zhài"], ["quàn"]],
    "公正不阿": [["gōng"], ["zhèng"], ["bù"], ["ē"]],
    "公正廉明": [["gōng"], ["zhèng"], ["lián"], ["míng"]],
    "公正廉洁": [["gōng"], ["zhèng"], ["lián"], ["jié"]],
    "公正无私": [["gōng"], ["zhèng"], ["wú"], ["sī"]],
    "公职人员": [["gōng"], ["zhí"], ["rén"], ["yuán"]],
    "公诸同好": [["gōng"], ["zhū"], ["tóng"], ["hào"]],
    "公忠体国": [["gōng"], ["zhōng"], ["tǐ"], ["guó"]],
    "公子王孙": [["gōng"], ["zǐ"], ["wáng"], ["sūn"]],
    "功薄蝉翼": [["gōng"], ["bó"], ["chán"], ["yì"]],
    "功成不居": [["gōng"], ["chéng"], ["bù"], ["jū"]],
    "功成骨枯": [["gōng"], ["chéng"], ["gǔ"], ["kū"]],
    "功成行满": [["gōng"], ["chéng"], ["xíng"], ["mǎn"]],
    "功德无量": [["gōng"], ["dé"], ["wú"], ["liàng"]],
    "功夫片": [["gōng"], ["fū"], ["piàn"]],
    "功夫茶": [["gōng"], ["fū"], ["chá"]],
    "功盖天下": [["gōng"], ["gài"], ["tiān"], ["xià"]],
    "功高不赏": [["gōng"], ["gāo"], ["bù"], ["shǎng"]],
    "功高盖世": [["gōng"], ["gāo"], ["gài"], ["shì"]],
    "功高望重": [["gōng"], ["gāo"], ["wàng"], ["zhòng"]],
    "功劳簿": [["gōng"], ["láo"], ["bù"]],
    "功率放大器": [["gōng"], ["lǜ"], ["fàng"], ["dà"], ["qì"]],
    "功若丘山": [["gōng"], ["ruò"], ["qiū"], ["shān"]],
    "攻城掠地": [["gōng"], ["chéng"], ["lüě"], ["dì"]],
    "攻城略地": [["gōng"], ["chéng"], ["lüè"], ["dì"]],
    "攻过箴阙": [["gōng"], ["guò"], ["zhēn"], ["què"]],
    "攻苦食啖": [["gōng"], ["kǔ"], ["shí"], ["dàn"]],
    "攻击行为": [["gōng"], ["jī"], ["xíng"], ["wéi"]],
    "攻苦食淡": [["gōng"], ["kǔ"], ["shí"], ["dàn"]],
    "攻苦食俭": [["gōng"], ["kǔ"], ["shí"], ["jiǎn"]],
    "攻其不备": [["gōng"], ["qí"], ["bù"], ["bèi"]],
    "攻其无备": [["gōng"], ["qí"], ["wú"], ["bèi"]],
    "攻守同盟": [["gōng"], ["shǒu"], ["tóng"], ["méng"]],
    "攻无不克": [["gōng"], ["wú"], ["bù"], ["kè"]],
    "攻心为上": [["gōng"], ["xīn"], ["wèi"], ["shàng"]],
    "攻心扼吭": [["gōng"], ["xīn"], ["è"], ["kēng"]],
    "供不应求": [["gōng"], ["bù"], ["yìng"], ["qiú"]],
    "供过于求": [["gōng"], ["guò"], ["yú"], ["qiú"]],
    "供给制": [["gōng"], ["jǐ"], ["zhì"]],
    "供求关系": [["gōng"], ["qiú"], ["guān"], ["xì"]],
    "供销合作社": [["gōng"], ["xiāo"], ["hé"], ["zuò"], ["shè"]],
    "供销社": [["gōng"], ["xiāo"], ["shè"]],
    "宫车晏驾": [["gōng"], ["chē"], ["yàn"], ["jià"]],
    "恭而有礼": [["gōng"], ["ér"], ["yǒu"], ["lǐ"]],
    "恭逢其盛": [["gōng"], ["féng"], ["qí"], ["shèng"]],
    "恭敬不如从命": [["gōng"], ["jìng"], ["bù"], ["rú"], ["cóng"], ["mìng"]],
    "恭行天罚": [["gōng"], ["xíng"], ["tiān"], ["fá"]],
    "躬蹈矢石": [["gōng"], ["dǎo"], ["shǐ"], ["shí"]],
    "躬逢其盛": [["gōng"], ["féng"], ["qí"], ["shèng"]],
    "躬耕乐道": [["gōng"], ["gēng"], ["lè"], ["dào"]],
    "躬体力行": [["gōng"], ["tǐ"], ["lì"], ["xíng"]],
    "躬冒矢石": [["gōng"], ["mào"], ["shǐ"], ["shí"]],
    "躬先士卒": [["gōng"], ["xiān"], ["shì"], ["zú"]],
    "躬行节俭": [["gōng"], ["xíng"], ["jié"], ["jiǎn"]],
    "躬行实践": [["gōng"], ["xíng"], ["shí"], ["jiàn"]],
    "躬自菲薄": [["gōng"], ["zì"], ["fěi"], ["bó"]],
    "龚行天罚": [["gōng"], ["xíng"], ["tiān"], ["fá"]],
    "觥饭不及壶飧": [["gōng"], ["fàn"], ["bù"], ["jí"], ["hú"], ["sūn"]],
    "拱肩缩背": [["gǒng"], ["jān"], ["suō"], ["bèi"]],
    "汞溴红": [["gǒng"], ["xiù"], ["hóng"]],
    "拱手而降": [["gǒng"], ["shòu"], ["ér"], ["xiáng"]],
    "共产党": [["gòng"], ["chǎn"], ["dǎng"]],
    "共产党宣言": [["gòng"], ["chǎn"], ["dǎng"], ["xuān"], ["yán"]],
    "共产主义": [["gòng"], ["chǎn"], ["zhǔ"], ["yì"]],
    "共产主义道德": [["gòng"], ["chǎn"], ["zhǔ"], ["yì"], ["dào"], ["dé"]],
    "共产主义青年团": [["gòng"], ["chǎn"], ["zhǔ"], ["yì"], ["qīng"], ["nián"], ["tuán"]],
    "共产主义社会": [["gòng"], ["chǎn"], ["zhǔ"], ["yì"], ["shè"], ["huì"]],
    "共存亡": [["gòng"], ["cún"], ["wáng"]],
    "共贯同条": [["gòng"], ["guàn"], ["tóng"], ["tiáo"]],
    "共和党": [["gòng"], ["hé"], ["dǎng"]],
    "共和国": [["gòng"], ["hé"], ["guó"]],
    "共和制": [["gòng"], ["hé"], ["zhì"]],
    "共价键": [["gòng"], ["jià"], ["jiàn"]],
    "共进会": [["gòng"], ["jìn"], ["huì"]],
    "共聚物": [["gòng"], ["jù"], ["wù"]],
    "共鸣器": [["gòng"], ["míng"], ["qì"]],
    "共青团": [["gòng"], ["qīng"], ["tuán"]],
    "共商国是": [["gòng"], ["shāng"], ["guó"], ["shì"]],
    "共生矿": [["gòng"], ["shēng"], ["kuàng"]],
    "共同犯罪": [["gòng"], ["tóng"], ["fàn"], ["zuì"]],
    "共同富裕": [["gòng"], ["tóng"], ["fù"], ["yù"]],
    "共同纲领": [["gòng"], ["tóng"], ["gāng"], ["lǐng"]],
    "共同社": [["gòng"], ["tóng"], ["shè"]],
    "共同市场": [["gòng"], ["tóng"], ["shì"], ["chǎng"]],
    "共同体": [["gòng"], ["tóng"], ["tǐ"]],
    "共同语": [["gòng"], ["tóng"], ["yǔ"]],
    "共同语言": [["gòng"], ["tóng"], ["yǔ"], ["yán"]],
    "共为唇齿": [["gòng"], ["wéi"], ["chún"], ["chǐ"]],
    "共挽鹿车": [["gòng"], ["wǎn"], ["lù"], ["chē"]],
    "共振器": [["gòng"], ["zhèn"], ["qì"]],
    "共枝别干": [["gòng"], ["zhī"], ["bié"], ["gàn"]],
    "贡禹弹冠": [["gòng"], ["yǔ"], ["tán"], ["guān"]],
    "勾勾搭搭": [["gōu"], ["gōu"], ["dā"], ["dā"]],
    "勾股定理": [["gōu"], ["gǔ"], ["dìng"], ["lǐ"]],
    "勾魂摄魄": [["gōu"], ["hún"], ["shè"], ["pò"]],
    "勾三搭四": [["gōu"], ["sān"], ["dā"], ["sì"]],
    "勾心斗角": [["gōu"], ["xīn"], ["dòu"], ["jiǎo"]],
    "佝偻病": [["gōu"], ["lóu"], ["bìng"]],
    "钩深极奥": [["gōu"], ["shēn"], ["jí"], ["ào"]],
    "钩深索隐": [["gōu"], ["shēn"], ["suǒ"], ["yǐn"]],
    "钩深致远": [["gōu"], ["shēn"], ["zhì"], ["yuǎn"]],
    "钩深图远": [["gōu"], ["shēn"], ["tú"], ["yuǎn"]],
    "钩心斗角": [["gōu"], ["xīn"], ["dòu"], ["jiǎo"]],
    "钩元摘秘": [["gōu"], ["yuán"], ["zhāi"], ["mì"]],
    "钩玄猎秘": [["gōu"], ["xuán"], ["liè"], ["mì"]],
    "钩元提要": [["gōu"], ["yuán"], ["tí"], ["yào"]],
    "钩玄提要": [["gōu"], ["xuán"], ["tí"], ["yào"]],
    "钩章棘句": [["gōu"], ["zhāng"], ["jí"], ["jù"]],
    "钩爪锯牙": [["gōu"], ["zhǎo"], ["jù"], ["yá"]],
    "狗恶酒酸": [["gǒu"], ["è"], ["jiǔ"], ["suān"]],
    "狗吠不惊": [["gǒu"], ["fèi"], ["bù"], ["jīng"]],
    "狗急跳墙": [["gǒu"], ["jí"], ["tiào"], ["qiáng"]],
    "狗口里生不出象牙": [["gǒu"], ["kǒu"], ["lǐ"], ["shēng"], ["bù"], ["chū"], ["xiàng"], ["yá"]],
    "狗口里吐不出象牙": [["gǒu"], ["kǒu"], ["lǐ"], ["tǔ"], ["bù"], ["chū"], ["xiàng"], ["yá"]],
    "狗皮膏药": [["gǒu"], ["pí"], ["gāo"], ["yào"]],
    "狗屁不通": [["gǒu"], ["pì"], ["bù"], ["tōng"]],
    "狗头军师": [["gǒu"], ["tóu"], ["jūn"], ["shī"]],
    "狗头鼠脑": [["gǒu"], ["tóu"], ["shǔ"], ["nǎo"]],
    "狗尾草": [["gǒu"], ["wěi"], ["cǎo"]],
    "狗尾貂续": [["gǒu"], ["wěi"], ["diāo"], ["xù"]],
    "狗心狗行": [["gǒu"], ["xīn"], ["gǒu"], ["xíng"]],
    "狗尾续貂": [["gǒu"], ["wěi"], ["xù"], ["diāo"]],
    "狗行狼心": [["gǒu"], ["xíng"], ["láng"], ["xīn"]],
    "狗续貂尾": [["gǒu"], ["xù"], ["diāo"], ["wěi"]],
    "狗续侯冠": [["gǒu"], ["xù"], ["hòu"], ["guàn"]],
    "狗血淋头": [["gǒu"], ["xuè"], ["lín"], ["tóu"]],
    "狗血喷头": [["gǒu"], ["xuè"], ["pēn"], ["tóu"]],
    "狗眼看人": [["gǒu"], ["yǎn"], ["kàn"], ["rén"]],
    "狗彘不如": [["gǒu"], ["zhì"], ["bù"], ["rú"]],
    "狗彘不若": [["gǒu"], ["zhì"], ["bù"], ["ruò"]],
    "狗彘不食": [["gǒu"], ["zhì"], ["bù"], ["shí"]],
    "狗彘不食其余": [["gǒu"], ["zhì"], ["bù"], ["shí"], ["qí"], ["yú"]],
    "狗猪不食其余": [["gǒu"], ["zhū"], ["bù"], ["shí"], ["qí"], ["yú"]],
    "狗追耗子": [["gǒu"], ["zhuī"], ["hào"], ["zǐ"]],
    "狗嘴里吐不出象牙": [["gǒu"], ["zuǐ"], ["lǐ"], ["tǔ"], ["bù"], ["chū"], ["xiàng"], ["yá"]],
    "狗嘴吐不出象牙": [["gǒu"], ["zuǐ"], ["tǔ"], ["bù"], ["chū"], ["xiàng"], ["yá"]],
    "苟合取容": [["gǒu"], ["hé"], ["qǔ"], ["ān"]],
    "苟且偷安": [["gǒu"], ["qiě"], ["tōu"], ["ān"]],
    "苟且偷生": [["gǒu"], ["qiě"], ["tōu"], ["shēng"]],
    "枸杞子": [["gǒu"], ["qǐ"], ["zǐ"]],
    "苟且之心": [["gǒu"], ["qiě"], ["zhī"], ["xīn"]],
    "构造地震": [["gòu"], ["zào"], ["dì"], ["zhèn"]],
    "构筑物": [["gòu"], ["zhù"], ["wù"]],
    "诟如不闻": [["gòu"], ["rú"], ["bù"], ["wén"]],
    "诟龟呼天": [["gòu"], ["guī"], ["hū"], ["tiān"]],
    "购物中心": [["gòu"], ["wù"], ["zhōng"], ["xīn"]],
    "购销差价": [["gòu"], ["xiāo"], ["chā"], ["jià"]],
    "垢面蓬头": [["gòu"], ["miàn"], ["péng"], ["tóu"]],
    "够劲儿": [["gòu"], ["jìn"], ["er"]],
    "够受的": [["gòu"], ["shòu"], ["de"]],
    "估堆儿": [["gū"], ["duī"], ["ér"]],
    "够意思": [["gòu"], ["yì"], ["sī"]],
    "姑娘家": [["gū"], ["niáng"], ["jiā"]],
    "姑射神人": [["gū"], ["yè"], ["shén"], ["rén"]],
    "姑置勿论": [["gū"], ["zhì"], ["wù"], ["lùn"]],
    "孤傲不群": [["gū"], ["ào"], ["bù"], ["qún"]],
    "孤雌生殖": [["gū"], ["cí"], ["shēng"], ["zhí"]],
    "孤独矜寡": [["gū"], ["dú"], ["guān"], ["guǎ"]],
    "孤家寡人": [["gū"], ["jiā"], ["guǎ"], ["rén"]],
    "孤苦零丁": [["gū"], ["kǔ"], ["líng"], ["dīng"]],
    "孤立无助": [["gū"], ["lì"], ["wú"], ["zhù"]],
    "孤立寡与": [["gū"], ["lì"], ["guǎ"], ["yǔ"]],
    "孤履危行": [["gū"], ["lǚ"], ["wēi"], ["xíng"]],
    "孤身只影": [["gū"], ["shēn"], ["zhī"], ["yǐng"]],
    "孤文断句": [["gū"], ["wén"], ["duàn"], ["jù"]],
    "孤文只义": [["gū"], ["wén"], ["zhī"], ["yì"]],
    "孤行己见": [["gū"], ["xíng"], ["jǐ"], ["jiàn"]],
    "孤行己意": [["gū"], ["xíng"], ["jǐ"], ["yì"]],
    "孤行一意": [["gū"], ["xíng"], ["yī"], ["yì"]],
    "孤掌难鸣": [["gū"], ["zhǎng"], ["nán"], ["míng"]],
    "沽名干誉": [["gū"], ["míng"], ["gàn"], ["yù"]],
    "沽名要誉": [["gū"], ["míng"], ["yào"], ["yù"]],
    "辜恩背义": [["gū"], ["ēn"], ["bèi"], ["yì"]],
    "毂击肩摩": [["gǔ"], ["jī"], ["jiān"], ["mó"]],
    "古北口": [["gǔ"], ["běi"], ["kǒu"]],
    "古地理学": [["gǔ"], ["dì"], ["lǐ"], ["xué"]],
    "古调不弹": [["gǔ"], ["diào"], ["bù"], ["tán"]],
    "古典音乐": [["gǔ"], ["diǎn"], ["yīn"], ["yuè"]],
    "古调单弹": [["gǔ"], ["diào"], ["dān"], ["tán"]],
    "古尔邦节": [["gǔ"], ["ěr"], ["bāng"], ["jié"]],
    "古井不波": [["gǔ"], ["jǐng"], ["bù"], ["bō"]],
    "古今中外": [["gǔ"], ["jīn"], ["zhōng"], ["wài"]],
    "古木参天": [["gǔ"], ["mù"], ["cān"], ["tiān"]],
    "古体诗": [["gǔ"], ["tǐ"], ["shī"]],
    "古为今用": [["gǔ"], ["wéi"], ["jīn"], ["yòng"]],
    "谷父蚕母": [["gǔ"], ["fù"], ["cán"], ["mǔ"]],
    "股份公司": [["gǔ"], ["fèn"], ["gōng"], ["sī"]],
    "股份制": [["gǔ"], ["fèn"], ["zhì"]],
    "股掌之上": [["gǔ"], ["zhǎng"], ["zhī"], ["shàng"]],
    "骨朵儿": [["gū"], ["duǒ"], ["er"]],
    "骨骼肌": [["gǔ"], ["gé"], ["jī"]],
    "骨鲠在喉": [["gǔ"], ["gěng"], ["zài"], ["hóu"]],
    "骨鲠之臣": [["gǔ"], ["gěng"], ["zhī"], ["chén"]],
    "骨寒毛竖": [["gǔ"], ["hán"], ["máo"], ["shù"]],
    "骨化风成": [["gǔ"], ["huà"], ["fēng"], ["chéng"]],
    "骨灰盒": [["gǔ"], ["huī"], ["hé"]],
    "骨化形销": [["gǔ"], ["huà"], ["xíng"], ["xiāo"]],
    "骨结核": [["gǔ"], ["jié"], ["hé"]],
    "骨碌碌": [["gū"], ["lù"], ["lù"]],
    "骨肉离散": [["gǔ"], ["ròu"], ["lí"], ["sàn"]],
    "骨肉团圆": [["gǔ"], ["ròu"], ["tuán"], ["yuán"]],
    "骨肉未寒": [["gǔ"], ["ròu"], ["wèi"], ["hán"]],
    "骨肉相残": [["gǔ"], ["ròu"], ["xiāng"], ["cán"]],
    "骨肉至亲": [["gǔ"], ["ròu"], ["zhì"], ["qīn"]],
    "骨肉相连": [["gǔ"], ["ròu"], ["xiāng"], ["lián"]],
    "骨软筋麻": [["gǔ"], ["ruǎn"], ["jīn"], ["má"]],
    "骨软筋酥": [["gǔ"], ["ruǎn"], ["jīn"], ["sū"]],
    "骨软肉酥": [["gǔ"], ["ruǎn"], ["ròu"], ["sū"]],
    "骨瘦如柴": [["gǔ"], ["shòu"], ["rú"], ["chái"]],
    "骨瘦如豺": [["gǔ"], ["shòu"], ["rú"], ["chái"]],
    "骨瘦形销": [["gǔ"], ["shòu"], ["xíng"], ["xiāo"]],
    "骨碎补": [["gǔ"], ["suì"], ["bǔ"]],
    "骨腾肉飞": [["gǔ"], ["téng"], ["ròu"], ["fēi"]],
    "骨头架子": [["gú"], ["tou"], ["jià"], ["zi"]],
    "骨子里": [["gǔ"], ["zi"], ["lǐ"]],
    "鹄峙鸾停": [["hú"], ["zhì"], ["luán"], ["tíng"]],
    "鹄峙鸾翔": [["hú"], ["zhì"], ["luán"], ["xiáng"]],
    "鼓唇弄舌": [["gǔ"], ["chún"], ["nòng"], ["shé"]],
    "鼓唇咋舌": [["gǔ"], ["chún"], ["zǎ"], ["shé"]],
    "鼓风机": [["gǔ"], ["fēng"], ["jī"]],
    "鼓风炉": [["gǔ"], ["fēng"], ["lú"]],
    "鼓腹含和": [["gǔ"], ["fù"], ["hán"], ["hé"]],
    "鼓鼓囊囊": [["gǔ"], ["gǔ"], ["nāng"], ["nāng"]],
    "鼓角齐鸣": [["gǔ"], ["jiǎo"], ["qí"], ["míng"]],
    "鼓睛暴眼": [["gǔ"], ["jīng"], ["bào"], ["yǎn"]],
    "鼓乐喧天": [["gǔ"], ["yuè"], ["xuān"], ["tiān"]],
    "鼓乐齐鸣": [["gǔ"], ["yuè"], ["qí"], ["míng"]],
    "鼓囊囊": [["gǔ"], ["nāng"], ["nɑng"]],
    "鼓脑争头": [["gǔ"], ["nǎo"], ["zhēng"], ["tóu"]],
    "鼓旗相当": [["gǔ"], ["qí"], ["xiāng"], ["dāng"]],
    "鼓衰力尽": [["gǔ"], ["shuāi"], ["lì"], ["jìn"]],
    "鼓吻奋爪": [["gǔ"], ["wěn"], ["fèn"], ["zhǎo"]],
    "鼓吻弄舌": [["gǔ"], ["wěn"], ["nòng"], ["shé"]],
    "固定汇率": [["gù"], ["dìng"], ["huì"], ["lǜ"]],
    "固定价格": [["gù"], ["dìng"], ["jià"], ["gé"]],
    "固若金汤": [["gù"], ["ruò"], ["jīn"], ["tāng"]],
    "固沙林": [["gù"], ["shā"], ["lín"]],
    "固体潮": [["gù"], ["tǐ"], ["cháo"]],
    "固体燃料": [["gù"], ["tǐ"], ["rán"], ["liào"]],
    "固有频率": [["gù"], ["yǒu"], ["pín"], ["lǜ"]],
    "固执成见": [["gù"], ["zhí"], ["chéng"], ["jiàn"]],
    "固执己见": [["gù"], ["zhí"], ["jǐ"], ["jiàn"]],
    "故伎重演": [["gù"], ["jì"], ["zhòng"], ["yǎn"]],
    "故技重演": [["gù"], ["jì"], ["chóng"], ["yǎn"]],
    "故弄虚玄": [["gù"], ["nòng"], ["xū"], ["xuán"]],
    "故旧不弃": [["gù"], ["jiù"], ["bù"], ["qì"]],
    "故家乔木": [["gù"], ["jiā"], ["qiáo"], ["mù"]],
    "故弄玄虚": [["gù"], ["nòng"], ["xuán"], ["xū"]],
    "故事片": [["gù"], ["shì"], ["piàn"]],
    "故甚其词": [["gù"], ["shèn"], ["qí"], ["cí"]],
    "故态复还": [["gù"], ["tài"], ["fù"], ["huán"]],
    "故土难离": [["gù"], ["tǔ"], ["nán"], ["lí"]],
    "顾虑重重": [["gù"], ["lǜ"], ["chóng"], ["chóng"]],
    "顾景惭形": [["gù"], ["yǐng"], ["cán"], ["xíng"]],
    "顾名思义": [["gù"], ["míng"], ["sī"], ["yì"]],
    "顾前不顾后": [["gù"], ["qián"], ["bù"], ["gù"], ["hòu"]],
    "顾曲周郎": [["gù"], ["qǔ"], ["zhōu"], ["láng"]],
    "顾全大局": [["gù"], ["quán"], ["dà"], ["jú"]],
    "顾头不顾尾": [["gù"], ["tóu"], ["bù"], ["gù"], ["wěi"]],
    "顾小失大": [["gù"], ["xiǎo"], ["shī"], ["dà"]],
    "顾影弄姿": [["gù"], ["yǐng"], ["nòng"], ["zī"]],
    "雇佣军": [["gù"], ["yōng"], ["jūn"]],
    "雇佣劳动": [["gù"], ["yōng"], ["láo"], ["dòng"]],
    "瓜分豆剖": [["guā"], ["fēn"], ["dòu"], ["pōu"]],
    "瓜分鼎峙": [["guā"], ["fēn"], ["dǐng"], ["zhì"]],
    "瓜葛相连": [["guā"], ["gě"], ["xiāng"], ["lián"]],
    "瓜剖豆分": [["guā"], ["pōu"], ["dòu"], ["fēn"]],
    "瓜连蔓引": [["guā"], ["lián"], ["màn"], ["yǐn"]],
    "瓜区豆分": [["guā"], ["qū"], ["dòu"], ["fēn"]],
    "瓜熟蒂落": [["guā"], ["shú"], ["dì"], ["luò"]],
    "瓜字初分": [["guā"], ["zì"], ["chū"], ["fēn"]],
    "刮肠洗胃": [["guā"], ["cháng"], ["xǐ"], ["wèi"]],
    "刮地皮": [["guā"], ["dì"], ["pí"]],
    "刮垢磨光": [["guā"], ["gòu"], ["mó"], ["guāng"]],
    "刮垢磨痕": [["guā"], ["gòu"], ["mó"], ["hén"]],
    "刮骨抽筋": [["guā"], ["gǔ"], ["chōu"], ["jīn"]],
    "刮骨去毒": [["guā"], ["gǔ"], ["qù"], ["dú"]],
    "刮目相待": [["guā"], ["mù"], ["xiāng"], ["dài"]],
    "刮目相见": [["guā"], ["mù"], ["xiāng"], ["jiàn"]],
    "刮目相看": [["guā"], ["mù"], ["xiāng"], ["kàn"]],
    "刮野扫地": [["guā"], ["yě"], ["sǎo"], ["dì"]],
    "呱呱堕地": [["gū"], ["gū"], ["duò"], ["dì"]],
    "呱嗒板儿": [["guā"], ["dā"], ["bǎn"], ["ér"]],
    "呱呱叫": [["guā"], ["guā"], ["jiào"]],
    "呱呱坠地": [["gū"], ["gū"], ["zhuì"], ["dì"]],
    "寡不敌众": [["guǎ"], ["bù"], ["dí"], ["zhòng"]],
    "寡二少双": [["guǎ"], ["èr"], ["shǎo"], ["shuāng"]],
    "寡见少闻": [["guǎ"], ["jiàn"], ["shǎo"], ["wén"]],
    "寡不胜众": [["guǎ"], ["bù"], ["shèng"], ["zhòng"]],
    "寡凫单鹄": [["guǎ"], ["fú"], ["dān"], ["hú"]],
    "寡见鲜闻": [["guǎ"], ["jiàn"], ["xiǎn"], ["wén"]],
    "寡廉鲜耻": [["guǎ"], ["lián"], ["xiǎn"], ["chǐ"]],
    "寡情薄意": [["guǎ"], ["qíng"], ["báo"], ["yì"]],
    "寡闻少见": [["guǎ"], ["wén"], ["shǎo"], ["jiàn"]],
    "寡头政治": [["guǎ"], ["tóu"], ["zhèng"], ["zhì"]],
    "寡信轻诺": [["guǎ"], ["xìn"], ["qīng"], ["nuò"]],
    "挂灯结彩": [["guà"], ["dēng"], ["jié"], ["cǎi"]],
    "挂不住": [["guà"], ["bú"], ["zhù"]],
    "挂肚牵肠": [["guà"], ["dù"], ["qiān"], ["cháng"]],
    "挂肚牵心": [["guà"], ["dù"], ["qiān"], ["xīn"]],
    "挂冠归去": [["guà"], ["guān"], ["guī"], ["qù"]],
    "挂冠求去": [["guà"], ["guān"], ["qiú"], ["qù"]],
    "挂号信": [["guà"], ["hào"], ["xìn"]],
    "挂席为门": [["guà"], ["xí"], ["wéi"], ["mén"]],
    "挂羊头卖狗肉": [["guà"], ["yáng"], ["tóu"], ["mài"], ["gǒu"], ["ròu"]],
    "挂一漏万": [["guà"], ["yī"], ["lòu"], ["wàn"]],
    "乖僻邪谬": [["guāi"], ["pì"], ["xié"], ["miù"]],
    "拐弯抹角": [["guǎi"], ["wān"], ["mò"], ["jiǎo"]],
    "怪不得": [["guài"], ["bù"], ["dé"]],
    "怪诞诡奇": [["guài"], ["dàn"], ["guǐ"], ["qí"]],
    "怪诞不经": [["guài"], ["dàn"], ["bù"], ["jīng"]],
    "怪模怪样": [["guài"], ["mó"], ["guài"], ["yàng"]],
    "怪雨盲风": [["guài"], ["yǔ"], ["máng"], ["fēng"]],
    "关键期": [["guān"], ["jiàn"], ["qī"]],
    "关节点": [["guān"], ["jié"], ["diǎn"]],
    "关节痛": [["guān"], ["jié"], ["tòng"]],
    "关节炎": [["guān"], ["jié"], ["yán"]],
    "关门打狗": [["guān"], ["mén"], ["dǎ"], ["gǒu"]],
    "关门落闩": [["guān"], ["mén"], ["luò"], ["shuān"]],
    "关门大吉": [["guān"], ["mén"], ["dà"], ["jí"]],
    "关情脉脉": [["guān"], ["qíng"], ["mài"], ["mài"]],
    "关系户": [["guān"], ["xì"], ["hù"]],
    "关系网": [["guān"], ["xì"], ["wǎng"]],
    "关系学": [["guān"], ["xì"], ["xué"]],
    "观察家": [["guān"], ["chá"], ["jiā"]],
    "观察力": [["guān"], ["chá"], ["lì"]],
    "观察哨": [["guān"], ["chá"], ["shào"]],
    "观察使": [["guān"], ["chá"], ["shǐ"]],
    "观察所": [["guān"], ["chá"], ["suǒ"]],
    "观察员": [["guān"], ["chá"], ["yuán"]],
    "观场矮人": [["guān"], ["chǎng"], ["ǎi"], ["rén"]],
    "观风察俗": [["guān"], ["fēng"], ["chá"], ["sú"]],
    "观过知仁": [["guān"], ["guò"], ["zhī"], ["rén"]],
    "观化听风": [["guān"], ["huà"], ["tīng"], ["fēng"]],
    "观机而作": [["guān"], ["jī"], ["ér"], ["zuò"]],
    "观机而动": [["guān"], ["jī"], ["ér"], ["dòng"]],
    "观今宜鉴古": [["guān"], ["jīn"], ["yì"], ["jiàn"], ["gǔ"]],
    "观貌察色": [["guān"], ["mào"], ["chá"], ["sè"]],
    "观眉说眼": [["guān"], ["méi"], ["shuō"], ["yǎn"]],
    "观念形态": [["guān"], ["niàn"], ["xíng"], ["tài"]],
    "观山玩水": [["guān"], ["shān"], ["wán"], ["shuǐ"]],
    "观世音": [["guān"], ["shì"], ["yīn"]],
    "观赏植物": [["guān"], ["shǎng"], ["zhí"], ["wù"]],
    "观往知来": [["guān"], ["wǎng"], ["zhī"], ["lái"]],
    "观望不前": [["guān"], ["wàng"], ["bù"], ["qián"]],
    "观象台": [["guān"], ["xiàng"], ["tái"]],
    "观星台": [["guān"], ["xīng"], ["tái"]],
    "观形察色": [["guān"], ["xíng"], ["chá"], ["sè"]],
    "观隅反三": [["guān"], ["yú"], ["fǎn"], ["sān"]],
    "观音土": [["guān"], ["yīn"], ["tǔ"]],
    "观音竹": [["guān"], ["yīn"], ["zhú"]],
    "观者成堵": [["guān"], ["zhě"], ["chéng"], ["dǔ"]],
    "观者如堵": [["guān"], ["zhě"], ["rú"], ["dǔ"]],
    "观者如垛": [["guān"], ["zhě"], ["rú"], ["duǒ"]],
    "观者如市": [["guān"], ["zhě"], ["rú"], ["shì"]],
    "观者如云": [["guān"], ["zhě"], ["rú"], ["yún"]],
    "观者如织": [["guān"], ["zhě"], ["rú"], ["zhī"]],
    "官报私仇": [["guān"], ["bào"], ["sī"], ["chóu"]],
    "观者云集": [["guān"], ["zhě"], ["yún"], ["jí"]],
    "观众席": [["guān"], ["zhòng"], ["xí"]],
    "官场如戏": [["guān"], ["chǎng"], ["rú"], ["xì"]],
    "官场现形记": [["guān"], ["chǎng"], ["xiàn"], ["xíng"], ["jì"]],
    "官官相护": [["guān"], ["guān"], ["xiāng"], ["hù"]],
    "官官相为": [["guān"], ["guān"], ["xiāng"], ["wéi"]],
    "官官相卫": [["guān"], ["guān"], ["xiāng"], ["wèi"]],
    "官能团": [["guān"], ["néng"], ["tuán"]],
    "官情纸薄": [["guān"], ["qíng"], ["zhǐ"], ["báo"]],
    "官运亨通": [["guān"], ["yùn"], ["hēng"], ["gōng"]],
    "官止神行": [["guān"], ["zhǐ"], ["shén"], ["xíng"]],
    "冠盖如云": [["guān"], ["gài"], ["rú"], ["yún"]],
    "冠盖相望": [["guān"], ["gài"], ["xiāng"], ["wàng"]],
    "冠屦倒施": [["guàn"], ["jù"], ["dǎo"], ["shī"]],
    "冠绝一时": [["guàn"], ["jué"], ["yī"], ["shí"]],
    "冠履倒易": [["guān"], ["lǚ"], ["dào"], ["yì"]],
    "冠履倒置": [["guān"], ["lǚ"], ["dào"], ["zhì"]],
    "冠冕堂皇": [["guān"], ["miǎn"], ["táng"], ["huáng"]],
    "冠袍带履": [["guān"], ["páo"], ["dài"], ["lǚ"]],
    "冠山戴粒": [["guàn"], ["shān"], ["dài"], ["lì"]],
    "冠上加冠": [["guān"], ["shàng"], ["jiā"], ["guān"]],
    "冠上履下": [["guān"], ["shàng"], ["lǚ"], ["xià"]],
    "冠心病": [["guān"], ["xīn"], ["bìng"]],
    "冠状动脉": [["guān"], ["zhuàng"], ["dòng"], ["mài"]],
    "管鲍分金": [["guǎn"], ["bào"], ["fēn"], ["jīn"]],
    "管风琴": [["guǎn"], ["fēng"], ["qín"]],
    "管家婆": [["guǎn"], ["jiā"], ["pó"]],
    "管见所及": [["guǎn"], ["jiàn"], ["suǒ"], ["jí"]],
    "管乐器": [["guǎn"], ["yuè"], ["qì"]],
    "管宁割席": [["guǎn"], ["níng"], ["gē"], ["xí"]],
    "管弦乐": [["guǎn"], ["xián"], ["yuè"]],
    "管中窥豹": [["guǎn"], ["zhōng"], ["kuī"], ["bào"]],
    "管中窥天": [["guǎn"], ["zhōng"], ["kuī"], ["tiān"]],
    "贯穿融会": [["guàn"], ["chuān"], ["róng"], ["huì"]],
    "贯斗双龙": [["guàn"], ["dòu"], ["shuāng"], ["lóng"]],
    "贯通融会": [["guàn"], ["tōng"], ["róng"], ["huì"]],
    "贯朽粟红": [["guàn"], ["xiǔ"], ["sù"], ["hóng"]],
    "贯盈恶稔": [["guàn"], ["yíng"], ["è"], ["rěn"]],
    "盥洗室": [["guàn"], ["xǐ"], ["shì"]],
    "灌夫骂座": [["guàn"], ["fū"], ["mà"], ["zuò"]],
    "灌夫骂坐": [["guàn"], ["fū"], ["mà"], ["zuò"]],
    "灌溉渠": [["guàn"], ["gài"], ["qú"]],
    "灌米汤": [["guàn"], ["mǐ"], ["tāng"]],
    "光采夺目": [["guāng"], ["cǎi"], ["duó"], ["mù"]],
    "光车骏马": [["guāng"], ["chē"], ["jùn"], ["mǎ"]],
    "光导纤维": [["guāng"], ["dǎo"], ["xiān"], ["wéi"]],
    "光风霁月": [["guāng"], ["fēng"], ["jì"], ["yuè"]],
    "光杆儿": [["guāng"], ["gǎn"], ["ér"]],
    "光棍儿": [["guāng"], ["gùn"], ["ér"]],
    "光合作用": [["guāng"], ["hé"], ["zuò"], ["yòng"]],
    "光华夺目": [["guāng"], ["huá"], ["duó"], ["mù"]],
    "光洁度": [["guāng"], ["jié"], ["dù"]],
    "光可鉴人": [["guāng"], ["kě"], ["jiàn"], ["rén"]],
    "光溜溜": [["guāng"], ["liū"], ["liū"]],
    "光芒万丈": [["guāng"], ["máng"], ["wàn"], ["zhàng"]],
    "光明磊落": [["guāng"], ["míng"], ["lěi"], ["luò"]],
    "光明正大": [["guāng"], ["míng"], ["zhèng"], ["dà"]],
    "光荣榜": [["guāng"], ["róng"], ["bǎng"]],
    "光天化日": [["guāng"], ["tiān"], ["huà"], ["rì"]],
    "光纤通信": [["guāng"], ["xiān"], ["tōng"], ["xìn"]],
    "光焰万丈": [["guāng"], ["yàn"], ["wàn"], ["zhàng"]],
    "光阴似箭": [["guāng"], ["yīn"], ["sì"], ["jiàn"]],
    "广播电台": [["guǎng"], ["bō"], ["diàn"], ["tái"]],
    "广播剧": [["guǎng"], ["bō"], ["jù"]],
    "广播体操": [["guǎng"], ["bō"], ["tǐ"], ["cāo"]],
    "广播站": [["guǎng"], ["bō"], ["zhàn"]],
    "广东音乐": [["guǎng"], ["dōng"], ["yīn"], ["yuè"]],
    "广而言之": [["guǎng"], ["ér"], ["yán"], ["zhī"]],
    "广寒宫": [["guǎng"], ["hán"], ["gōng"]],
    "广寒仙子": [["guǎng"], ["hán"], ["xiān"], ["zǐ"]],
    "广交会": [["guǎng"], ["jiāo"], ["huì"]],
    "广见洽闻": [["guǎng"], ["jiàn"], ["qià"], ["wén"]],
    "广角镜头": [["guǎng"], ["jiǎo"], ["jìng"], ["tóu"]],
    "广结良缘": [["guǎng"], ["jié"], ["liáng"], ["yuán"]],
    "广开才路": [["guǎng"], ["kāi"], ["cái"], ["lù"]],
    "广开言路": [["guǎng"], ["kāi"], ["yán"], ["lù"]],
    "广陵散绝": [["guǎng"], ["líng"], ["sǎn"], ["jué"]],
    "广譬曲谕": [["guǎng"], ["pì"], ["qǔ"], ["yù"]],
    "广庭大众": [["guǎng"], ["tíng"], ["dà"], ["zhòng"]],
    "广土众民": [["guǎng"], ["tǔ"], ["zhòng"], ["mín"]],
    "广文先生": [["guǎng"], ["wén"], ["xiān"], ["sheng"]],
    "广夏细旃": [["guǎng"], ["xià"], ["xì"], ["zhān"]],
    "广厦万间": [["guǎng"], ["shà"], ["wàn"], ["jiān"]],
    "广义相对论": [["guǎng"], ["yì"], ["xiāng"], ["duì"], ["lùn"]],
    "广种薄收": [["guǎng"], ["zhòng"], ["bó"], ["shōu"]],
    "归根结底": [["guī"], ["gēn"], ["jié"], ["dǐ"]],
    "归根到底": [["guī"], ["gēn"], ["dào"], ["dǐ"]],
    "归根结柢": [["guī"], ["gēn"], ["jié"], ["dǐ"]],
    "归根结蒂": [["guī"], ["gēn"], ["jié"], ["dì"]],
    "归根究柢": [["guī"], ["gēn"], ["jiū"], ["dǐ"]],
    "归奇顾怪": [["guī"], ["qí"], ["gù"], ["guài"]],
    "归邪转曜": [["guī"], ["xié"], ["zhuǎn"], ["yào"]],
    "归正邱首": [["guī"], ["zhèng"], ["qiū"], ["shǒu"]],
    "归真反朴": [["guī"], ["zhēn"], ["fǎn"], ["pǔ"]],
    "归正守丘": [["guī"], ["zhèng"], ["shǒu"], ["qiū"]],
    "归心似箭": [["guī"], ["xīn"], ["sì"], ["jiàn"]],
    "归正首丘": [["guī"], ["zhèng"], ["shǒu"], ["qiū"]],
    "归正首邱": [["guī"], ["zhèng"], ["shǒu"], ["qiū"]],
    "归之若水": [["guī"], ["zhī"], ["ruò"], ["shuǐ"]],
    "圭角岸然": [["guī"], ["jiǎo"], ["àn"], ["rán"]],
    "圭角不露": [["guī"], ["jiǎo"], ["bù"], ["lù"]],
    "龟鹤遐龄": [["guī"], ["hè"], ["xiá"], ["líng"]],
    "龟鹤遐寿": [["guī"], ["hè"], ["xiá"], ["shòu"]],
    "龟冷支床": [["guī"], ["lěng"], ["zhī"], ["chuáng"]],
    "龟冷搘床": [["guī"], ["lěng"], ["zhī"], ["chuáng"]],
    "龟龙鳞凤": [["guī"], ["lóng"], ["lín"], ["fèng"]],
    "龟龄鹤算": [["guī"], ["líng"], ["hè"], ["suàn"]],
    "龟龙麟凤": [["guī"], ["lóng"], ["lín"], ["fèng"]],
    "龟毛兔角": [["guī"], ["máo"], ["tù"], ["jiǎo"]],
    "龟龙片甲": [["guī"], ["lóng"], ["piàn"], ["jiǎ"]],
    "龟年鹤寿": [["guī"], ["nián"], ["hè"], ["shòu"]],
    "龟年鹤算": [["guī"], ["nián"], ["hè"], ["suàn"]],
    "龟厌不告": [["guī"], ["yàn"], ["bù"], ["gào"]],
    "龟文鸟迹": [["guī"], ["wén"], ["niǎo"], ["jì"]],
    "龟玉毁椟": [["guī"], ["yù"], ["huǐ"], ["dú"]],
    "规范化": [["guī"], ["fàn"], ["huà"]],
    "规求无度": [["guī"], ["qiú"], ["wú"], ["dù"]],
    "规天矩地": [["guī"], ["tiān"], ["jǔ"], ["dì"]],
    "规行矩步": [["guī"], ["xíng"], ["jǔ"], ["bù"]],
    "规行矩止": [["guī"], ["xíng"], ["jǔ"], ["zhǐ"]],
    "规旋矩折": [["guī"], ["xuán"], ["jǔ"], ["shé"]],
    "规重矩迭": [["guī"], ["zhòng"], ["jǔ"], ["dié"]],
    "规重矩叠": [["guī"], ["chóng"], ["jǔ"], ["dié"]],
    "瑰意奇行": [["guī"], ["yì"], ["qí"], ["xíng"]],
    "瑰意琦行": [["guī"], ["yì"], ["qí"], ["xíng"]],
    "佹得佹失": [["guǐ"], ["dé"], ["guǐ"], ["shī"]],
    "佹形僪状": [["guǐ"], ["xíng"], ["yù"], ["zhuàng"]],
    "诡诞不经": [["guǐ"], ["dàn"], ["bù"], ["jīng"]],
    "诡秘莫测": [["guǐ"], ["mì"], ["mò"], ["cè"]],
    "诡形奇制": [["guǐ"], ["xíng"], ["qí"], ["zhì"]],
    "鬼把戏": [["guǐ"], ["bǎ"], ["xì"]],
    "诡言浮说": [["guǐ"], ["yán"], ["fú"], ["shuō"]],
    "鬼打墙": [["guǐ"], ["dǎ"], ["qiáng"]],
    "鬼见愁": [["guǐ"], ["jiàn"], ["chóu"]],
    "鬼瞰其室": [["guǐ"], ["kàn"], ["qí"], ["shì"]],
    "鬼哭神号": [["guǐ"], ["kū"], ["shén"], ["hào"]],
    "鬼魅伎俩": [["guǐ"], ["mèi"], ["jì"], ["liǎng"]],
    "鬼怕恶人": [["guǐ"], ["pà"], ["èr"], ["én"]],
    "鬼神不测": [["guǐ"], ["shén"], ["bù"], ["cè"]],
    "鬼泣神号": [["guǐ"], ["qì"], ["shén"], ["hào"]],
    "鬼神莫测": [["guǐ"], ["shén"], ["mò"], ["cè"]],
    "鬼使神差": [["guǐ"], ["shǐ"], ["shén"], ["chāi"]],
    "鬼剃头": [["guǐ"], ["tì"], ["tóu"]],
    "鬼头鬼脑": [["guǐ"], ["tóu"], ["guǐ"], ["nǎo"]],
    "鬼头滑脑": [["guǐ"], ["tóu"], ["huá"], ["nǎo"]],
    "鬼蜮伎俩": [["guǐ"], ["yù"], ["jì"], ["liǎng"]],
    "鬼吒狼嚎": [["guǐ"], ["zhà"], ["láng"], ["háo"]],
    "贵不可言": [["guì"], ["bù"], ["kě"], ["yán"]],
    "贵不召骄": [["guì"], ["bù"], ["zhào"], ["jiāo"]],
    "贵不期骄": [["guì"], ["bù"], ["qī"], ["jiāo"]],
    "贵冠履轻头足": [["guì"], ["guān"], ["lǚ"], ["qīng"], ["tóu"], ["zú"]],
    "贵金属": [["guì"], ["jīn"], ["shǔ"]],
    "贵少贱老": [["guì"], ["shǎo"], ["jiàn"], ["lǎo"]],
    "贵远鄙近": [["guì"], ["yuǎn"], ["bǐ"], ["jìn"]],
    "贵远贱近": [["guì"], ["yuǎn"], ["jiàn"], ["jìn"]],
    "贵在知心": [["guì"], ["zài"], ["zhī"], ["xīn"]],
    "桂酒椒浆": [["guì"], ["jiǔ"], ["jiāo"], ["jiāng"]],
    "桂林一枝": [["guì"], ["lín"], ["yī"], ["zhī"]],
    "桂玉之地": [["guì"], ["yù"], ["zhī"], ["dì"]],
    "桂折兰摧": [["guì"], ["shé"], ["lán"], ["cuī"]],
    "桂折一枝": [["guì"], ["shé"], ["yī"], ["zhī"]],
    "桂枝片玉": [["guì"], ["zhī"], ["piàn"], ["yù"]],
    "滚动轴承": [["gǔn"], ["dòng"], ["zhóu"], ["chéng"]],
    "桂子兰孙": [["guì"], ["zǐ"], ["lán"], ["sūn"]],
    "滚珠轴承": [["gǔn"], ["zhū"], ["zhóu"], ["chéng"]],
    "滚柱轴承": [["gǔn"], ["zhù"], ["zhóu"], ["chéng"]],
    "棍儿茶": [["gùn"], ["ér"], ["chá"]],
    "国步艰难": [["guó"], ["bù"], ["jiān"], ["nán"]],
    "国仇家恨": [["guó"], ["chóu"], ["jiā"], ["hèn"]],
    "国而忘家": [["guó"], ["ér"], ["wàng"], ["jiā"]],
    "国尔忘家": [["guó"], ["ěr"], ["wàng"], ["jiā"]],
    "国耳忘家": [["guó"], ["ěr"], ["wàng"], ["jiā"]],
    "国富兵强": [["guó"], ["fù"], ["bīng"], ["qiáng"]],
    "国富民强": [["guó"], ["fù"], ["mín"], ["qiáng"]],
    "国际单位制": [["guó"], ["jì"], ["dān"], ["wèi"], ["zhì"]],
    "国际儿童节": [["guó"], ["jì"], ["ér"], ["tóng"], ["jié"]],
    "国际妇女节": [["guó"], ["jì"], ["fù"], ["nǚ"], ["jié"]],
    "国际复兴开发银行": [["guó"], ["jì"], ["fù"], ["xīng"], ["kāi"], ["fā"], ["yín"], ["háng"]],
    "国际劳动节": [["guó"], ["jì"], ["láo"], ["dòng"], ["jié"]],
    "国家栋梁": [["guó"], ["jiā"], ["dòng"], ["liáng"]],
    "国家机关": [["guó"], ["jiā"], ["jī"], ["guān"]],
    "国家机器": [["guó"], ["jiā"], ["jī"], ["qì"]],
    "国家资本主义": [["guó"], ["jiā"], ["zī"], ["běn"], ["zhǔ"], ["yì"]],
    "国将不国": [["guó"], ["jiāng"], ["bù"], ["guó"]],
    "国库券": [["guó"], ["kù"], ["quàn"]],
    "国民经济": [["guó"], ["mín"], ["jīng"], ["jì"]],
    "国难当头": [["guó"], ["nàn"], ["dāng"], ["tóu"]],
    "国破家亡": [["guó"], ["pò"], ["jiā"], ["wáng"]],
    "国庆节": [["guó"], ["qìng"], ["jié"]],
    "国统区": [["guó"], ["tǒng"], ["qū"]],
    "国无宁日": [["guó"], ["wú"], ["níng"], ["rì"]],
    "国营经济": [["guó"], ["yíng"], ["jīng"], ["jì"]],
    "国有化": [["guó"], ["yǒu"], ["huà"]],
    "国之干城": [["guó"], ["zhī"], ["gān"], ["chéng"]],
    "国子监": [["guó"], ["zǐ"], ["jiàn"]],
    "果不其然": [["guǒ"], ["bù"], ["qí"], ["rán"]],
    "果熟蒂落": [["guǒ"], ["shú"], ["dì"], ["luò"]],
    "果行育德": [["guǒ"], ["xíng"], ["yù"], ["dé"]],
    "果刑信赏": [["guǒ"], ["xíng"], ["xìn"], ["shǎng"]],
    "果于自信": [["guǒ"], ["yú"], ["zì"], ["xìn"]],
    "果子露": [["guǒ"], ["zǐ"], ["lù"]],
    "裹血力战": [["guǒ"], ["xuè"], ["lì"], ["zhàn"]],
    "裹足不前": [["guǒ"], ["zú"], ["bù"], ["qián"]],
    "过半数": [["guò"], ["bàn"], ["shù"]],
    "过不去": [["guò"], ["bù"], ["qù"]],
    "过从甚密": [["guò"], ["cóng"], ["shèn"], ["mì"]],
    "过得硬": [["guò"], ["de"], ["yìng"]],
    "过得去": [["guò"], ["děi"], ["qù"]],
    "过电影": [["guò"], ["diàn"], ["yǐng"]],
    "过冬作物": [["guò"], ["dōng"], ["zuò"], ["wù"]],
    "过都历块": [["guò"], ["dū"], ["lì"], ["kuài"]],
    "过而能改": [["guò"], ["ér"], ["néng"], ["gǎi"]],
    "过府冲州": [["guò"], ["fǔ"], ["chōng"], ["zhōu"]],
    "过河拆桥": [["guò"], ["hé"], ["chāi"], ["qiáo"]],
    "过关斩将": [["guò"], ["guān"], ["zhǎn"], ["jiàng"]],
    "过河卒子": [["guò"], ["hé"], ["zú"], ["zǐ"]],
    "过化存神": [["guò"], ["huà"], ["cún"], ["shén"]],
    "过家家": [["guō"], ["jiā"], ["jiā"]],
    "过江之鲫": [["guò"], ["jiāng"], ["zhī"], ["jì"]],
    "过街老鼠": [["guò"], ["jiē"], ["lǎo"], ["shǔ"]],
    "过街天桥": [["guò"], ["jiē"], ["tiān"], ["qiáo"]],
    "过街楼": [["guò"], ["jiē"], ["lóu"]],
    "过节儿": [["guò"], ["jié"], ["ér"]],
    "过来人": [["guò"], ["lái"], ["rén"]],
    "过磷酸钙": [["guò"], ["lín"], ["suān"], ["gài"]],
    "过滤嘴": [["guò"], ["lǜ"], ["zuǐ"]],
    "过路财神": [["guò"], ["lù"], ["cái"], ["shén"]],
    "过门不入": [["guò"], ["mén"], ["bù"], ["rù"]],
    "过目不忘": [["guò"], ["mù"], ["bù"], ["wàng"]],
    "过目成诵": [["guò"], ["mù"], ["chéng"], ["sòng"]],
    "过桥拆桥": [["guò"], ["qiáo"], ["chāi"], ["qiáo"]],
    "过桥抽板": [["guò"], ["qiáo"], ["chōu"], ["bǎn"]],
    "过日子": [["guò"], ["rì"], ["zi"]],
    "过生日": [["guò"], ["shēng"], ["rì"]],
    "过甚其辞": [["guò"], ["shèn"], ["qí"], ["cí"]],
    "过甚其词": [["guò"], ["shèn"], ["qí"], ["cí"]],
    "过失杀人": [["guò"], ["shī"], ["shā"], ["rén"]],
    "过时黄花": [["guò"], ["shí"], ["huáng"], ["huā"]],
    "过市招摇": [["guò"], ["shì"], ["zhāo"], ["yáo"]],
    "过堂风": [["guò"], ["táng"], ["fēng"]],
    "过水面": [["guò"], ["shuǐ"], ["miàn"]],
    "过庭之训": [["guò"], ["tíng"], ["zhī"], ["xùn"]],
    "过屠大嚼": [["guò"], ["tú"], ["dà"], ["jué"]],
    "过屠门而大嚼": [["guò"], ["tú"], ["mén"], ["ér"], ["dà"], ["jiáo"]],
    "过为已甚": [["guò"], ["wéi"], ["yǐ"], ["shèn"]],
    "过五关": [["guò"], ["wǔ"], ["guān"]],
    "过五关斩六将": [["guò"], ["wǔ"], ["guān"], ["zhǎn"], ["liù"], ["jiàng"]],
    "过隙白驹": [["guò"], ["xī"], ["bái"], ["jū"]],
    "过眼云烟": [["guò"], ["yǎn"], ["yún"], ["yān"]],
    "过眼烟云": [["guò"], ["yǎn"], ["yān"], ["yún"]],
    "过意不去": [["guò"], ["yì"], ["bù"], ["qù"]],
    "过犹不及": [["guò"], ["yóu"], ["bù"], ["jí"]],
    "哈巴狗": [["hǎ"], ["bā"], ["gǒu"]],
    "哈尔滨": [["hā"], ["ěr"], ["bīn"]],
    "哈哈镜": [["hā"], ["hā"], ["jìng"]],
    "哈喇子": [["hā"], ["lǎ"], ["zǐ"]],
    "哈雷彗星": [["hā"], ["léi"], ["huì"], ["xīng"]],
    "哈密瓜": [["hā"], ["mì"], ["guā"]],
    "哈尼族": [["hā"], ["ní"], ["zú"]],
    "哈萨克斯坦": [["hā"], ["sà"], ["kè"], ["sī"], ["tǎn"]],
    "哈萨克族": [["hā"], ["sà"], ["kè"], ["zú"]],
    "孩子头": [["hái"], ["zi"], ["tóu"]],
    "孩子王": [["hái"], ["zi"], ["wáng"]],
    "海不波溢": [["hǎi"], ["bù"], ["bō"], ["yì"]],
    "海北天南": [["hǎi"], ["běi"], ["tiān"], ["nán"]],
    "海参崴": [["hǎi"], ["shēn"], ["wēi"]],
    "海不扬波": [["hǎi"], ["bù"], ["yáng"], ["bō"]],
    "海德堡大学": [["hǎi"], ["dé"], ["pù"], ["dà"], ["xué"]],
    "海底捞月": [["hǎi"], ["dǐ"], ["lāo"], ["yuè"]],
    "海底捞针": [["hǎi"], ["dǐ"], ["lāo"], ["zhēn"]],
    "海沸山裂": [["hǎi"], ["fèi"], ["shān"], ["liè"]],
    "海涵地负": [["hǎi"], ["hán"], ["dì"], ["fù"]],
    "海涸石烂": [["hǎi"], ["hé"], ["shí"], ["làn"]],
    "海角天涯": [["hǎi"], ["jiǎo"], ["tiān"], ["yá"]],
    "海角天隅": [["hǎi"], ["jiǎo"], ["tiān"], ["yú"]],
    "海军航空兵": [["hǎi"], ["jūn"], ["háng"], ["kōng"], ["bīng"]],
    "海枯见底": [["hǎi"], ["kū"], ["jiàn"], ["dǐ"]],
    "海枯石烂": [["hǎi"], ["kū"], ["shí"], ["làn"]],
    "海阔天空": [["hǎi"], ["kuò"], ["tiān"], ["kōng"]],
    "海内鼎沸": [["hǎi"], ["nèi"], ["dǐng"], ["fèi"]],
    "海内无双": [["hǎi"], ["nèi"], ["wú"], ["shuāng"]],
    "海南岛": [["hǎi"], ["nán"], ["dǎo"]],
    "海南省": [["hǎi"], ["nán"], ["shěng"]],
    "海水不可斗量": [["hǎi"], ["shuǐ"], ["bù"], ["kě"], ["dǒu"], ["liáng"]],
    "海水难量": [["hǎi"], ["shuǐ"], ["nán"], ["liáng"]],
    "海外关系": [["hǎi"], ["wài"], ["guān"], ["xì"]],
    "海外奇谈": [["hǎi"], ["wài"], ["qí"], ["tán"]],
    "海王星": [["hǎi"], ["wáng"], ["xīng"]],
    "海涯天角": [["hǎi"], ["yá"], ["tiān"], ["jiǎo"]],
    "海约山盟": [["hǎi"], ["yuē"], ["shān"], ["méng"]],
    "海中捞月": [["hǎi"], ["zhōng"], ["lāo"], ["yuè"]],
    "亥豕相望": [["hài"], ["shǐ"], ["xiāng"], ["wàng"]],
    "骇龙走蛇": [["hài"], ["lóng"], ["zǒu"], ["shé"]],
    "骇人闻见": [["hài"], ["rén"], ["wén"], ["jiàn"]],
    "害人不浅": [["hài"], ["rén"], ["bù"], ["qiǎn"]],
    "酣畅淋漓": [["hān"], ["chàng"], ["lín"], ["lí"]],
    "酣痛淋漓": [["hān"], ["tòng"], ["lín"], ["lí"]],
    "酣嬉淋漓": [["hān"], ["xī"], ["lín"], ["lí"]],
    "憨状可掬": [["hān"], ["zhuàng"], ["kě"], ["jū"]],
    "含苞待放": [["hán"], ["bāo"], ["dài"], ["fàng"]],
    "含齿戴发": [["hán"], ["chǐ"], ["dài"], ["fā"]],
    "含宫咀征": [["hán"], ["gōng"], ["jǔ"], ["zhēng"]],
    "含宫咀徵": [["hán"], ["gōng"], ["jǔ"], ["zhēng"]],
    "含垢藏瑕": [["hán"], ["gòu"], ["cáng"], ["xiá"]],
    "含垢藏疾": [["hán"], ["gǒu"], ["cáng"], ["jí"]],
    "含含糊糊": [["hán"], ["hán"], ["hu"], ["hū"]],
    "含糊不明": [["hán"], ["hú"], ["bù"], ["míng"]],
    "含糊其词": [["hán"], ["hú"], ["qí"], ["cí"]],
    "含糊其辞": [["hán"], ["hú"], ["qí"], ["cí"]],
    "含菁咀华": [["hán"], ["jīng"], ["jǔ"], ["huá"]],
    "含明隐迹": [["hán"], ["míng"], ["yǐn"], ["jì"]],
    "含蓼问疾": [["hán"], ["liǎo"], ["wèn"], ["jí"]],
    "含情脉脉": [["hán"], ["qíng"], ["mò"], ["mò"]],
    "含沙射影": [["hán"], ["shā"], ["shè"], ["yǐng"]],
    "含商咀徵": [["hán"], ["shāng"], ["jǔ"], ["zhēng"]],
    "含商咀征": [["hán"], ["shāng"], ["jǔ"], ["zhēng"]],
    "含水量": [["hán"], ["shuǐ"], ["liàng"]],
    "含血喷人": [["hán"], ["xuè"], ["pēn"], ["rén"]],
    "含血噀人": [["hán"], ["xuè"], ["xùn"], ["rén"]],
    "含血潠人": [["hán"], ["xuè"], ["xùn"], ["rén"]],
    "含牙戴角": [["hán"], ["yá"], ["dài"], ["jiǎo"]],
    "含牙带角": [["hán"], ["yá"], ["dài"], ["jiǎo"]],
    "含笑入地": [["hán"], ["xiào"], ["rù"], ["dì"]],
    "含饴弄孙": [["hán"], ["yí"], ["nòng"], ["sūn"]],
    "含英咀华": [["hán"], ["yīng"], ["jǔ"], ["huá"]],
    "含冤莫白": [["hán"], ["yuān"], ["mò"], ["bái"]],
    "含着骨头露着肉": [["hán"], ["zhe"], ["gǔ"], ["tóu"], ["lù"], ["zhe"], ["ròu"]],
    "邯郸重步": [["hán"], ["dān"], ["zhóng"], ["bù"]],
    "函盖充周": [["hán"], ["gài"], ["chōng"], ["zhōu"]],
    "函盖乾坤": [["hán"], ["gài"], ["qián"], ["kūn"]],
    "函矢相攻": [["hán"], ["shǐ"], ["xiāng"], ["gōng"]],
    "函授学校": [["hán"], ["shòu"], ["xué"], ["xiào"]],
    "函授大学": [["hán"], ["shòu"], ["dà"], ["xué"]],
    "寒蝉凄切": [["hán"], ["chán"], ["qī"], ["qiè"]],
    "寒冬腊月": [["hán"], ["dōng"], ["là"], ["yuè"]],
    "寒风侵肌": [["hán"], ["fēng"], ["qīn"], ["jī"]],
    "寒腹短识": [["hán"], ["fù"], ["duǎn"], ["shí"]],
    "寒花晚节": [["hán"], ["huā"], ["wǎn"], ["jié"]],
    "寒木春华": [["hán"], ["mù"], ["chūn"], ["huá"]],
    "寒灰更然": [["hán"], ["huī"], ["gèng"], ["rán"]],
    "寒泉之思": [["hán"], ["quán"], ["zhī"], ["sī"]],
    "寒暑假": [["hán"], ["shǔ"], ["jià"]],
    "寒武纪": [["hán"], ["wǔ"], ["jì"]],
    "寒酸落魄": [["hán"], ["suān"], ["luò"], ["pò"]],
    "韩潮苏海": [["hán"], ["cháo"], ["sū"], ["hǎi"]],
    "韩海苏潮": [["hán"], ["hǎi"], ["sū"], ["cháo"]],
    "韩寿分香": [["hán"], ["shòu"], ["fēn"], ["xiāng"]],
    "罕言寡语": [["hǎn"], ["yán"], ["guǎ"], ["yǔ"]],
    "汉堡包": [["hàn"], ["pù"], ["bāo"]],
    "汉白玉石": [["hàn"], ["bái"], ["yù"], ["shí"]],
    "汉学家": [["hàn"], ["xué"], ["jiā"]],
    "汉语拼音方案": [["hàn"], ["yǔ"], ["pīn"], ["yīn"], ["fāng"], ["àn"]],
    "汉贼不两立": [["hàn"], ["zéi"], ["bù"], ["liǎng"], ["lì"]],
    "扞格不入": [["hàn"], ["gé"], ["bù"], ["rù"]],
    "汗涔涔": [["hàn"], ["cén"], ["cén"]],
    "汗不敢出": [["hàn"], ["bù"], ["gǎn"], ["chū"]],
    "汗背心": [["hàn"], ["bèi"], ["xīn"]],
    "汗出浃背": [["hàn"], ["chū"], ["jiā"], ["bèi"]],
    "汗出洽背": [["hàn"], ["chū"], ["qià"], ["bèi"]],
    "汗淋淋": [["hàn"], ["lín"], ["lín"]],
    "汗津津": [["hàn"], ["jīn"], ["jīn"]],
    "汗褂儿": [["hàn"], ["guà"], ["er"]],
    "汗流夹背": [["hàn"], ["liú"], ["jiā"], ["bèi"]],
    "汗流浃背": [["hàn"], ["liú"], ["jiā"], ["bèi"]],
    "汗流浃肤": [["hàn"], ["liú"], ["jiā"], ["fū"]],
    "汗流浃体": [["hàn"], ["liú"], ["jiā"], ["tǐ"]],
    "汗流浃踵": [["hàn"], ["liú"], ["jiā"], ["zhǒng"]],
    "汗流满面": [["hàn"], ["liú"], ["mǎn"], ["miàn"]],
    "汗流接踵": [["hàn"], ["liú"], ["jiē"], ["zhǒng"]],
    "汗流洽背": [["hàn"], ["liú"], ["qià"], ["bèi"]],
    "汗流洽衣": [["hàn"], ["liú"], ["qià"], ["yī"]],
    "汗流至踵": [["hàn"], ["liú"], ["zhì"], ["zhǒng"]],
    "汗马功劳": [["hàn"], ["mǎ"], ["gōng"], ["láo"]],
    "汗马之劳": [["hàn"], ["mǎ"], ["zhī"], ["láo"]],
    "汗马之功": [["hàn"], ["mǎ"], ["zhī"], ["gōng"]],
    "汗牛充栋": [["hàn"], ["niú"], ["chōng"], ["dòng"]],
    "汗牛充屋": [["hàn"], ["niú"], ["chōng"], ["wū"]],
    "汗牛塞栋": [["hàn"], ["niú"], ["sāi"], ["dòng"]],
    "汗洽股栗": [["hàn"], ["qià"], ["gǔ"], ["lì"]],
    "汗青头白": [["hàn"], ["qīng"], ["tóu"], ["bái"]],
    "汗如雨下": [["hàn"], ["rú"], ["yǔ"], ["xià"]],
    "汗血盐车": [["hàn"], ["xuè"], ["yán"], ["chē"]],
    "汗颜无地": [["hàn"], ["yán"], ["wú"], ["dì"]],
    "汗渍渍": [["hàn"], ["zì"], ["zì"]],
    "旱魃为虐": [["hàn"], ["bá"], ["wèi"], ["nüè"]],
    "旱冰场": [["hàn"], ["bīng"], ["chǎng"]],
    "旱苗得雨": [["hàn"], ["miáo"], ["dé"], ["yǔ"]],
    "悍然不顾": [["hàn"], ["rán"], ["bù"], ["gù"]],
    "熯天炽地": [["hàn"], ["tiān"], ["chì"], ["dì"]],
    "撼地摇天": [["hàn"], ["dì"], ["yáo"], ["tiān"]],
    "撼天动地": [["hàn"], ["tiān"], ["dòng"], ["dì"]],
    "撼天震地": [["hàn"], ["tiān"], ["zhèn"], ["dì"]],
    "航空港": [["háng"], ["kōng"], ["gǎng"]],
    "航空母舰": [["háng"], ["kōng"], ["mǔ"], ["jiàn"]],
    "航空信": [["háng"], ["kōng"], ["xìn"]],
    "毫不讳言": [["háo"], ["bù"], ["huì"], ["yán"]],
    "毫不介意": [["háo"], ["bù"], ["jiè"], ["yì"]],
    "毫发不爽": [["háo"], ["fà"], ["bù"], ["shuǎng"]],
    "毫分缕析": [["háo"], ["fēn"], ["lǚ"], ["xī"]],
    "毫发丝粟": [["háo"], ["fā"], ["sī"], ["sù"]],
    "毫毛不犯": [["háo"], ["máo"], ["bù"], ["fàn"]],
    "毫厘不爽": [["háo"], ["lí"], ["bù"], ["shuǎng"]],
    "毫无疑义": [["háo"], ["wú"], ["yí"], ["yì"]],
    "豪放不羁": [["háo"], ["fàng"], ["bù"], ["jī"]],
    "豪干暴取": [["háo"], ["gàn"], ["bào"], ["qǔ"]],
    "豪横跋扈": [["háo"], ["héng"], ["bá"], ["hù"]],
    "豪迈不群": [["háo"], ["mài"], ["bù"], ["qún"]],
    "豪取智笼": [["háo"], ["qǔ"], ["zhì"], ["lóng"]],
    "豪商巨贾": [["háo"], ["shāng"], ["jù"], ["jiǎ"]],
    "豪言壮语": [["háo"], ["yán"], ["zhuàng"], ["yǔ"]],
    "嚎天动地": [["háo"], ["tiān"], ["dòng"], ["dì"]],
    "嚎啕大哭": [["háo"], ["táo"], ["dà"], ["kū"]],
    "濠梁之上": [["háo"], ["liáng"], ["zhī"], ["shàng"]],
    "嚎天喊地": [["háo"], ["tiān"], ["hǎn"], ["dì"]],
    "好不好": [["hǎo"], ["bù"], ["hǎo"]],
    "好吃懒做": [["hào"], ["chī"], ["lǎn"], ["zuò"]],
    "好大喜功": [["hào"], ["dà"], ["xǐ"], ["gōng"]],
    "好戴高帽": [["hǎo"], ["dài"], ["gāo"], ["mào"]],
    "好端端": [["hǎo"], ["duān"], ["duān"]],
    "好丹非素": [["hào"], ["dān"], ["fēi"], ["sù"]],
    "好恶不同": [["hǎo"], ["è"], ["bù"], ["tóng"]],
    "好高骛远": [["hào"], ["gāo"], ["wù"], ["yuǎn"]],
    "好高鹜远": [["hǎo"], ["gāo"], ["wù"], ["yuǎn"]],
    "好管闲事": [["hǎo"], ["guǎn"], ["xián"], ["shì"]],
    "好汉不吃眼前亏": [["hǎo"], ["hàn"], ["bù"], ["chī"], ["yǎn"], ["qián"], ["kuī"]],
    "好好先生": [["hǎo"], ["hǎo"], ["xiān"], ["shēng"]],
    "好好儿": [["hǎo"], ["hǎo"], ["ér"]],
    "好极了": [["hǎo"], ["jí"], ["le"]],
    "好家伙": [["hǎo"], ["jiā"], ["huo"]],
    "好景不常": [["hǎo"], ["jǐng"], ["bù"], ["cháng"]],
    "好酒贪杯": [["hào"], ["jiǔ"], ["tān"], ["bēi"]],
    "好来好去": [["hǎo"], ["lái"], ["hǎo"], ["qù"]],
    "好景不长": [["hǎo"], ["jǐng"], ["bù"], ["cháng"]],
    "好莱坞": [["hǎo"], ["lái"], ["wù"]],
    "好离好散": [["hǎo"], ["lí"], ["hǎo"], ["sàn"]],
    "好了疮疤忘了痛": [["hǎo"], ["le"], ["chuāng"], ["bā"], ["wàng"], ["le"], ["tòng"]],
    "好梦不长": [["hǎo"], ["mèng"], ["bù"], ["cháng"]],
    "好梦难成": [["hǎo"], ["mèng"], ["nán"], ["chéng"]],
    "好梦难圆": [["hǎo"], ["mèng"], ["nán"], ["yuán"]],
    "好模好样": [["hǎo"], ["mó"], ["hǎo"], ["yàng"]],
    "好谋善断": [["hào"], ["móu"], ["shàn"], ["duàn"]],
    "好女不穿嫁时衣": [["hǎo"], ["nǚ"], ["bù"], ["chuān"], ["jià"], ["shí"], ["yī"]],
    "好奇尚异": [["hǎo"], ["qí"], ["shàng"], ["yì"]],
    "好奇心": [["hào"], ["qí"], ["xīn"]],
    "好骑者堕": [["hào"], ["qí"], ["zhě"], ["duò"]],
    "好人家": [["hǎo"], ["rén"], ["jiā"]],
    "好日子": [["hǎo"], ["rì"], ["zi"]],
    "好容易": [["hǎo"], ["róng"], ["yì"]],
    "好肉剜疮": [["hǎo"], ["ròu"], ["wān"], ["chuāng"]],
    "好色之徒": [["hào"], ["sè"], ["zhī"], ["tú"]],
    "好善恶恶": [["hǎo"], ["shàn"], ["wù"], ["è"]],
    "好善嫉恶": [["hǎo"], ["shàn"], ["jí"], ["è"]],
    "好善乐施": [["hào"], ["shàn"], ["lè"], ["shī"]],
    "好身手": [["hǎo"], ["shēn"], ["shǒu"]],
    "好生之德": [["hào"], ["shēng"], ["zhī"], ["dé"]],
    "好声好气": [["hǎo"], ["shēng"], ["hǎo"], ["qì"]],
    "好事多磨": [["hǎo"], ["shì"], ["duō"], ["mó"]],
    "好事多悭": [["hǎo"], ["shì"], ["duō"], ["qiān"]],
    "好事天悭": [["hǎo"], ["shì"], ["tiān"], ["qiān"]],
    "好事之徒": [["hào"], ["shì"], ["zhī"], ["tú"]],
    "好说歹说": [["hǎo"], ["shuō"], ["dǎi"], ["shuō"]],
    "好说话": [["hǎo"], ["shuō"], ["huà"]],
    "好天良夜": [["hǎo"], ["tiān"], ["liáng"], ["yè"]],
    "好玩儿": [["hǎo"], ["wán"], ["ér"]],
    "好望角": [["hǎo"], ["wàng"], ["jiǎo"]],
    "好为人师": [["hào"], ["wéi"], ["rén"], ["shī"]],
    "好问决疑": [["hào"], ["wèn"], ["jué"], ["yí"]],
    "好为事端": [["hào"], ["wéi"], ["shì"], ["duān"]],
    "好问则裕": [["hào"], ["wèn"], ["zé"], ["yù"]],
    "好消息": [["hǎo"], ["xiāo"], ["xī"]],
    "好心好意": [["hǎo"], ["xīn"], ["hǎo"], ["yì"]],
    "好心做了驴肝肺": [["hǎo"], ["xīn"], ["zuò"], ["le"], ["lǘ"], ["gān"], ["fèi"]],
    "好行小惠": [["hào"], ["xíng"], ["xiǎo"], ["huì"]],
    "好行小慧": [["hǎo"], ["xíng"], ["xiǎo"], ["huì"]],
    "好学不倦": [["hào"], ["xué"], ["bù"], ["juàn"]],
    "好言好语": [["hǎo"], ["yán"], ["hǎo"], ["yǔ"]],
    "好佚恶劳": [["hǎo"], ["yì"], ["wù"], ["láo"]],
    "好意思": [["hǎo"], ["yì"], ["sī"]],
    "好逸恶劳": [["hào"], ["yì"], ["wù"], ["láo"]],
    "好勇斗狠": [["hào"], ["yǒng"], ["dòu"], ["hěn"]],
    "好语如珠": [["hǎo"], ["yǔ"], ["rú"], ["zhū"]],
    "好语似珠": [["hǎo"], ["yǔ"], ["sì"], ["zhū"]],
    "好整以暇": [["hào"], ["zhěng"], ["yǐ"], ["xiá"]],
    "好自为之": [["hào"], ["zì"], ["wéi"], ["zhī"]],
    "号寒啼饥": [["háo"], ["hán"], ["tí"], ["jī"]],
    "号令如山": [["hào"], ["lìng"], ["rú"], ["shān"]],
    "号码机": [["hào"], ["mǎ"], ["jī"]],
    "号咷大哭": [["háo"], ["táo"], ["dà"], ["kū"]],
    "号啕大哭": [["háo"], ["táo"], ["dà"], ["kū"]],
    "号天扣地": [["hào"], ["tiān"], ["kòu"], ["dì"]],
    "号志灯": [["hào"], ["zhì"], ["dēng"]],
    "昊天不吊": [["hào"], ["tiān"], ["bù"], ["diào"]],
    "浩浩汤汤": [["hào"], ["hào"], ["shāng"], ["shāng"]],
    "浩气长存": [["hào"], ["qì"], ["cháng"], ["cún"]],
    "皓齿蛾眉": [["hào"], ["chǐ"], ["é"], ["méi"]],
    "诃佛诋巫": [["hē"], ["fó"], ["dǐ"], ["wū"]],
    "呵佛骂祖": [["hē"], ["fó"], ["mà"], ["zǔ"]],
    "呵壁问天": [["hē"], ["bì"], ["wèn"], ["tiān"]],
    "呵欠连天": [["hē"], ["qiàn"], ["lián"], ["tiān"]],
    "喝倒彩": [["hè"], ["dào"], ["cǎi"]],
    "喝墨水": [["hē"], ["mò"], ["shuǐ"]],
    "喝西北风": [["hē"], ["xī"], ["běi"], ["fēng"]],
    "合不来": [["hé"], ["bù"], ["lái"]],
    "合并症": [["hé"], ["bìng"], ["zhèng"]],
    "合成词": [["hé"], ["chéng"], ["cí"]],
    "合成革": [["hé"], ["chéng"], ["gé"]],
    "合成纤维": [["hé"], ["chéng"], ["xiān"], ["wéi"]],
    "合成橡胶": [["hé"], ["chéng"], ["xiàng"], ["jiāo"]],
    "合胆同心": [["hé"], ["dǎn"], ["tóng"], ["xīn"]],
    "合从连衡": [["hé"], ["zòng"], ["lián"], ["héng"]],
    "合得来": [["hé"], ["de"], ["lái"]],
    "合而为一": [["hé"], ["ér"], ["wéi"], ["yī"]],
    "合订本": [["hé"], ["dìng"], ["běn"]],
    "合二为一": [["hé"], ["èr"], ["wéi"], ["yī"]],
    "合法性": [["hé"], ["fǎ"], ["xìng"]],
    "合伙人": [["hé"], ["huǒ"], ["rén"]],
    "合家欢": [["hé"], ["jiā"], ["huān"]],
    "合金钢": [["hé"], ["jīn"], ["gāng"]],
    "合理化": [["hé"], ["lǐ"], ["huà"]],
    "合两为一": [["hé"], ["liǎng"], ["wéi"], ["yī"]],
    "合盘托出": [["hé"], ["pán"], ["tuō"], ["chū"]],
    "合浦还珠": [["hé"], ["pǔ"], ["huán"], ["zhū"]],
    "合浦珠还": [["hé"], ["pǔ"], ["zhū"], ["huán"]],
    "合情合理": [["hé"], ["qíng"], ["hé"], ["lǐ"]],
    "合同工": [["hé"], ["tóng"], ["gōng"]],
    "合眼摸象": [["hé"], ["yǎn"], ["mō"], ["xiàng"]],
    "合议庭": [["hé"], ["yì"], ["tíng"]],
    "合议制": [["hé"], ["yì"], ["zhì"]],
    "合衷共济": [["hé"], ["zhōng"], ["gòng"], ["jì"]],
    "合作化": [["hé"], ["zuò"], ["huà"]],
    "合作社": [["hé"], ["zuò"], ["shè"]],
    "何必当初": [["hé"], ["bì"], ["dāng"], ["chū"]],
    "何患无辞": [["hé"], ["huàn"], ["wú"], ["cí"]],
    "何乐不为": [["hé"], ["lè"], ["bù"], ["wéi"]],
    "何乐而不为": [["hé"], ["lè"], ["ér"], ["bù"], ["wéi"]],
    "何其毒也": [["hé"], ["qí"], ["dú"], ["yě"]],
    "何其相似乃尔": [["hé"], ["qí"], ["xiāng"], ["sì"], ["nǎi"], ["ěr"]],
    "何去何从": [["hé"], ["qù"], ["hé"], ["cóng"]],
    "何首乌": [["hé"], ["shǒu"], ["wū"]],
    "何所不为": [["hé"], ["suǒ"], ["bù"], ["wéi"]],
    "何所不有": [["hé"], ["suǒ"], ["bù"], ["yǒu"]],
    "何仙姑": [["hé"], ["xiān"], ["gū"]],
    "何所不至": [["hé"], ["suǒ"], ["bù"], ["zhì"]],
    "何许人": [["hé"], ["xǔ"], ["rén"]],
    "何足挂齿": [["hé"], ["zú"], ["guà"], ["chǐ"]],
    "何足道哉": [["hé"], ["zú"], ["dào"], ["zāi"]],
    "何足介意": [["hé"], ["zú"], ["jiè"], ["yì"]],
    "和蔼近人": [["hé"], ["ǎi"], ["jìn"], ["rén"]],
    "何足为奇": [["hé"], ["zú"], ["wéi"], ["qí"]],
    "何罪之有": [["hé"], ["zuì"], ["zhī"], ["yǒu"]],
    "和蔼可亲": [["hé"], ["ǎi"], ["kě"], ["qīn"]],
    "和璧隋珠": [["hé"], ["bì"], ["suí"], ["zhū"]],
    "和而不唱": [["hé"], ["ér"], ["bù"], ["chàng"]],
    "和而不同": [["hé"], ["ér"], ["bù"], ["tóng"]],
    "和风丽日": [["hé"], ["fēng"], ["lì"], ["rì"]],
    "和光同尘": [["hé"], ["guāng"], ["tóng"], ["chén"]],
    "和风细雨": [["hé"], ["fēng"], ["xì"], ["yǔ"]],
    "和睦相处": [["hé"], ["mù"], ["xiāng"], ["chǔ"]],
    "和盘托出": [["hé"], ["pán"], ["tuō"], ["chū"]],
    "和平鸽": [["hé"], ["píng"], ["gē"]],
    "和平共处五项原则": [["hé"], ["píng"], ["gòng"], ["chǔ"], ["wǔ"], ["xiàng"], ["yuán"], ["zé"]],
    "和平共处": [["hé"], ["píng"], ["gòng"], ["chǔ"]],
    "和气生财": [["hé"], ["qì"], ["shēng"], ["cái"]],
    "和气致祥": [["hé"], ["qì"], ["zhì"], ["xiáng"]],
    "和容悦色": [["hé"], ["róng"], ["yuè"], ["sè"]],
    "和如琴瑟": [["hé"], ["rú"], ["qín"], ["sè"]],
    "和尚头": [["hé"], ["shàng"], ["tóu"]],
    "和氏璧": [["hé"], ["shì"], ["bì"]],
    "和事佬": [["hé"], ["shì"], ["lǎo"]],
    "和事老": [["hé"], ["shì"], ["lǎo"]],
    "和稀泥": [["huò"], ["xī"], ["ní"]],
    "和颜说色": [["hé"], ["yán"], ["yuè"], ["sè"]],
    "和颜悦色": [["hé"], ["yán"], ["yuè"], ["sè"]],
    "和衣而卧": [["hé"], ["yī"], ["ér"], ["wò"]],
    "和衷共济": [["hé"], ["zhōng"], ["gòng"], ["jì"]],
    "河北梆子": [["hé"], ["běi"], ["bāng"], ["zi"]],
    "河北省": [["hé"], ["běi"], ["shěng"]],
    "河伯为患": [["hé"], ["bó"], ["wéi"], ["huàn"]],
    "河奔海聚": [["hé"], ["bēn"], ["hǎi"], ["jù"]],
    "河不出图": [["hé"], ["bù"], ["chū"], ["tú"]],
    "河海不择细流": [["hé"], ["hǎi"], ["bù"], ["zé"], ["xì"], ["liú"]],
    "河涸海干": [["hé"], ["hé"], ["hǎi"], ["qián"]],
    "河溓海晏": [["hé"], ["lián"], ["hǎi"], ["yàn"]],
    "河溓海夷": [["hé"], ["lián"], ["hǎi"], ["yí"]],
    "河落海干": [["hé"], ["luò"], ["hǎi"], ["gān"]],
    "河南梆子": [["hé"], ["nán"], ["bāng"], ["zi"]],
    "河南坠子": [["hé"], ["nán"], ["zhuì"], ["zǐ"]],
    "河倾月落": [["hé"], ["qīng"], ["yuè"], ["luò"]],
    "河清难俟": [["hé"], ["qīng"], ["nán"], ["sì"]],
    "河沙世界": [["hé"], ["shā"], ["shì"], ["jiè"]],
    "河水不犯井水": [["hé"], ["shuǐ"], ["bù"], ["fàn"], ["jǐng"], ["shuǐ"]],
    "河水不洗船": [["hé"], ["shuǐ"], ["bù"], ["xǐ"], ["chuán"]],
    "河同水密": [["hé"], ["tóng"], ["shuǐ"], ["mì"]],
    "河斜月落": [["hé"], ["xié"], ["yuè"], ["luò"]],
    "核爆炸": [["hé"], ["bào"], ["zhà"]],
    "核磁共振": [["hé"], ["cí"], ["gòng"], ["zhèn"]],
    "核弹头": [["hé"], ["dàn"], ["tóu"]],
    "核蛋白": [["hé"], ["dàn"], ["bái"]],
    "核电厂": [["hé"], ["diàn"], ["chǎng"]],
    "核电站": [["hé"], ["diàn"], ["zhàn"]],
    "核讹诈": [["hé"], ["é"], ["zhà"]],
    "核反应": [["hé"], ["fǎn"], ["yìng"]],
    "核反应堆": [["hé"], ["fǎn"], ["yìng"], ["duī"]],
    "核黄素": [["hé"], ["huáng"], ["sù"]],
    "核潜艇": [["hé"], ["qián"], ["tǐng"]],
    "核燃料": [["hé"], ["rán"], ["liào"]],
    "核试验": [["hé"], ["shì"], ["yàn"]],
    "核糖核酸": [["hé"], ["táng"], ["hé"], ["suān"]],
    "核武器": [["hé"], ["wǔ"], ["qì"]],
    "核战争": [["hé"], ["zhàn"], ["zhēng"]],
    "核装置": [["hé"], ["zhuāng"], ["zhì"]],
    "荷尔蒙": [["hé"], ["ěr"], ["méng"]],
    "荷枪实弹": [["hè"], ["qiāng"], ["shí"], ["dàn"]],
    "涸鱼得水": [["hé"], ["yú"], ["dé"], ["shuǐ"]],
    "涸思干虑": [["hé"], ["sī"], ["qián"], ["lǜ"]],
    "涸鲋得水": [["hé"], ["fù"], ["dé"], ["shuǐ"]],
    "涸泽而渔": [["hé"], ["zé"], ["ér"], ["yú"]],
    "贺年卡": [["hè"], ["nián"], ["kǎ"]],
    "贺年片": [["hè"], ["nián"], ["piàn"]],
    "褐衣不完": [["hè"], ["yī"], ["bù"], ["wán"]],
    "褐衣蔬食": [["hè"], ["yī"], ["shū"], ["shí"]],
    "赫赫有名": [["hè"], ["hè"], ["yǒu"], ["míng"]],
    "鹤背扬州": [["hè"], ["bèi"], ["yáng"], ["zhōu"]],
    "鹤长凫短": [["hè"], ["cháng"], ["fú"], ["duǎn"]],
    "鹤处鸡群": [["hè"], ["chǔ"], ["jī"], ["qún"]],
    "鹤发鸡皮": [["hè"], ["fà"], ["jī"], ["pí"]],
    "鹤短凫长": [["hè"], ["duǎn"], ["fú"], ["cháng"]],
    "鹤发松姿": [["hè"], ["fà"], ["sōng"], ["zī"]],
    "鹤发童颜": [["hè"], ["fà"], ["tóng"], ["yán"]],
    "鹤骨鸡肤": [["hè"], ["gǔ"], ["jī"], ["fū"]],
    "鹤骨龙筋": [["hè"], ["gǔ"], ["lóng"], ["jīn"]],
    "鹤骨松筋": [["hè"], ["gǔ"], ["sōng"], ["jīn"]],
    "鹤骨霜髯": [["hè"], ["gǔ"], ["shuāng"], ["rán"]],
    "鹤骨松姿": [["hè"], ["gǔ"], ["sōng"], ["zī"]],
    "鹤唳风声": [["hè"], ["lì"], ["fēng"], ["shēng"]],
    "鹤唳华亭": [["hè"], ["lì"], ["huá"], ["tíng"]],
    "鹤鸣九皋": [["hè"], ["míng"], ["jiǔ"], ["gāo"]],
    "鹤行鸡群": [["hè"], ["xíng"], ["jī"], ["qún"]],
    "鹤知夜半": [["hè"], ["zhī"], ["yè"], ["bàn"]],
    "鹤子梅妻": [["hè"], ["zǐ"], ["méi"], ["qī"]],
    "鹤归华表": [["hè"], ["guī"], ["huá"], ["biǎo"]],
    "黑白分明": [["hēi"], ["bái"], ["fēn"], ["míng"]],
    "黑白混淆": [["hēi"], ["bái"], ["hùn"], ["xiáo"]],
    "黑白片": [["hēi"], ["bái"], ["piàn"]],
    "黑不溜秋": [["hēi"], ["bù"], ["liū"], ["qiū"]],
    "黑地昏天": [["hēi"], ["dì"], ["hūn"], ["tiān"]],
    "黑风孽海": [["hēi"], ["fēng"], ["niè"], ["hǎi"]],
    "黑更半夜": [["hēi"], ["gēng"], ["bàn"], ["yè"]],
    "黑糊糊": [["hēi"], ["hū"], ["hū"]],
    "黑家白日": [["hēi"], ["jiā"], ["bái"], ["rì"]],
    "黑价白日": [["hēi"], ["jià"], ["bái"], ["rì"]],
    "黑溜溜": [["hēi"], ["liū"], ["liū"]],
    "黑蒙蒙": [["hēi"], ["méng"], ["méng"]],
    "黑名单": [["hēi"], ["míng"], ["dān"]],
    "黑漆皮灯笼": [["hēi"], ["qī"], ["pí"], ["dēng"], ["lóng"]],
    "黑色金属": [["hēi"], ["sè"], ["jīn"], ["shǔ"]],
    "黑社会": [["hēi"], ["shè"], ["huì"]],
    "黑陶文化": [["hēi"], ["táo"], ["wén"], ["huà"]],
    "黑体字": [["hēi"], ["tǐ"], ["zì"]],
    "黑天墨地": [["hēi"], ["tiān"], ["mò"], ["dì"]],
    "黑天摸地": [["hēi"], ["tiān"], ["mō"], ["dì"]],
    "黑压压": [["hēi"], ["yā"], ["yā"]],
    "黑言诳语": [["hēi"], ["yán"], ["kuáng"], ["yǔ"]],
    "黑云压城城欲摧": [["hēi"], ["yún"], ["yā"], ["chéng"], ["chéng"], ["yù"], ["cuī"]],
    "恨不得": [["hèn"], ["bù"], ["dé"]],
    "恨不能": [["hèn"], ["bù"], ["néng"]],
    "恨海难填": [["hèn"], ["hǎi"], ["nán"], ["tián"]],
    "恨如头醋": [["hèn"], ["rú"], ["tóu"], ["cù"]],
    "恨入骨髓": [["hèn"], ["rù"], ["gǔ"], ["suǐ"]],
    "恨铁不成钢": [["hèn"], ["tiě"], ["bù"], ["chéng"], ["gāng"]],
    "恨相见晚": [["hèn"], ["xiāng"], ["jiàn"], ["wǎn"]],
    "恨相知晚": [["hèn"], ["xiāng"], ["zhī"], ["wǎn"]],
    "恨之入骨": [["hèn"], ["zhī"], ["rù"], ["gǔ"]],
    "亨嘉之会": [["hēng"], ["jiā"], ["zhī"], ["huì"]],
    "恒河沙数": [["héng"], ["hé"], ["shā"], ["shù"]],
    "哼哈二将": [["hēng"], ["hā"], ["èr"], ["jiàng"]],
    "恒河一沙": [["héng"], ["hé"], ["yī"], ["shā"]],
    "横草之功": [["héng"], ["cǎo"], ["zhī"], ["gōng"]],
    "横冲直闯": [["héng"], ["chōng"], ["zhí"], ["chuǎng"]],
    "横冲直撞": [["héng"], ["chōng"], ["zhí"], ["zhuàng"]],
    "横从穿贯": [["héng"], ["cóng"], ["chuān"], ["guàn"]],
    "横刀跃马": [["héng"], ["dāo"], ["yuè"], ["mǎ"]],
    "横刀揭斧": [["héng"], ["dāo"], ["jiē"], ["fǔ"]],
    "横倒竖卧": [["héng"], ["dǎo"], ["shù"], ["wò"]],
    "横断面": [["héng"], ["duàn"], ["miàn"]],
    "横恩滥赏": [["hèng"], ["ēn"], ["làn"], ["shǎng"]],
    "横峰侧岭": [["héng"], ["fēng"], ["cè"], ["lǐng"]],
    "横赋暴敛": [["héng"], ["fù"], ["bào"], ["liǎn"]],
    "横戈盘马": [["héng"], ["gē"], ["pán"], ["mǎ"]],
    "横戈跃马": [["héng"], ["gē"], ["yuè"], ["mǎ"]],
    "横祸飞灾": [["hèng"], ["huò"], ["fēi"], ["zāi"]],
    "横祸非灾": [["hèng"], ["huò"], ["fēi"], ["zāi"]],
    "横见侧出": [["héng"], ["jiàn"], ["cè"], ["chū"]],
    "横金拖玉": [["héng"], ["jīn"], ["tuō"], ["yù"]],
    "横科暴敛": [["hèng"], ["kē"], ["bào"], ["liǎn"]],
    "横拦竖挡": [["héng"], ["lán"], ["shù"], ["dǎng"]],
    "横蛮无理": [["hèng"], ["mán"], ["wú"], ["lǐ"]],
    "横眉瞪目": [["héng"], ["méi"], ["dèng"], ["mù"]],
    "横眉瞪眼": [["héng"], ["méi"], ["dèng"], ["yǎn"]],
    "横眉冷对千夫指": [["héng"], ["méi"], ["lěng"], ["duì"], ["qiān"], ["fū"], ["zhǐ"]],
    "横眉冷目": [["héng"], ["méi"], ["lěng"], ["mù"]],
    "横眉冷眼": [["héng"], ["méi"], ["lěng"], ["yǎn"]],
    "横眉立目": [["héng"], ["méi"], ["lì"], ["mù"]],
    "横眉努目": [["héng"], ["méi"], ["nǔ"], ["mù"]],
    "横眉立眼": [["héng"], ["méi"], ["lì"], ["yǎn"]],
    "横眉怒目": [["héng"], ["méi"], ["nù"], ["mù"]],
    "横眉竖目": [["héng"], ["méi"], ["shù"], ["mù"]],
    "横眉怒视": [["héng"], ["méi"], ["nù"], ["shì"]],
    "横眉竖眼": [["héng"], ["méi"], ["shù"], ["yǎn"]],
    "横眉吐气": [["héng"], ["méi"], ["tǔ"], ["qì"]],
    "横七竖八": [["héng"], ["qī"], ["shù"], ["bā"]],
    "横抢武夺": [["hèng"], ["qiǎng"], ["wǔ"], ["duó"]],
    "横枪跃马": [["héng"], ["qiāng"], ["yuè"], ["mǎ"]],
    "横抢硬夺": [["hèng"], ["qiǎng"], ["yìng"], ["duó"]],
    "横驱别骛": [["héng"], ["qū"], ["bié"], ["wù"]],
    "横三竖四": [["héng"], ["sān"], ["shù"], ["sì"]],
    "横僿不文": [["héng"], ["sài"], ["bù"], ["wén"]],
    "横三顺四": [["héng"], ["sān"], ["shùn"], ["sì"]],
    "横扫千军": [["héng"], ["sǎo"], ["qiān"], ["jūn"]],
    "横切面": [["héng"], ["qiē"], ["miàn"]],
    "横生枝节": [["héng"], ["shēng"], ["zhī"], ["jié"]],
    "横槊赋诗": [["héng"], ["shuò"], ["fù"], ["shī"]],
    "横说竖说": [["héng"], ["shuō"], ["shù"], ["shuō"]],
    "横躺竖卧": [["héng"], ["tǎng"], ["shù"], ["wò"]],
    "横挑鼻子竖挑眼": [["héng"], ["tiāo"], ["bí"], ["zi"], ["shù"], ["tiāo"], ["yǎn"]],
    "横拖倒扯": [["héng"], ["tuō"], ["dào"], ["chě"]],
    "横拖倒拽": [["héng"], ["tuō"], ["dào"], ["zhuāi"]],
    "横拖竖拉": [["héng"], ["tuō"], ["shù"], ["lā"]],
    "横纹肌": [["héng"], ["wén"], ["jī"]],
    "横无忌惮": [["hèng"], ["wú"], ["jì"], ["dàn"]],
    "横翔捷出": [["héng"], ["xiáng"], ["jié"], ["chū"]],
    "横行霸道": [["héng"], ["xíng"], ["bà"], ["dào"]],
    "横行不法": [["héng"], ["xíng"], ["bù"], ["fǎ"]],
    "横行逆施": [["héng"], ["xíng"], ["nì"], ["shī"]],
    "横行天下": [["héng"], ["xíng"], ["tiān"], ["xià"]],
    "横行无忌": [["héng"], ["xíng"], ["wú"], ["jì"]],
    "横行直撞": [["héng"], ["xíng"], ["zhí"], ["zhuàng"]],
    "横殃飞祸": [["hèng"], ["yāng"], ["fēi"], ["huò"]],
    "横灾飞祸": [["hèng"], ["zāi"], ["fēi"], ["huò"]],
    "横行直走": [["héng"], ["xíng"], ["zhí"], ["zǒu"]],
    "横遮竖挡": [["héng"], ["zhē"], ["shù"], ["dǎng"]],
    "横针竖线": [["héng"], ["zhēn"], ["shù"], ["xiàn"]],
    "横征暴赋": [["hèng"], ["zhēng"], ["bào"], ["fù"]],
    "横征暴敛": [["héng"], ["zhēng"], ["bào"], ["liǎn"]],
    "横征苛敛": [["hèng"], ["zhēng"], ["kē"], ["liǎn"]],
    "横征苛役": [["hèng"], ["zhēng"], ["kē"], ["yì"]],
    "横坐标": [["héng"], ["zuò"], ["biāo"]],
    "衡门深巷": [["héng"], ["mén"], ["shēn"], ["xiàng"]],
    "衡短论长": [["héng"], ["duǎn"], ["lùn"], ["cháng"]],
    "衡石程书": [["héng"], ["shí"], ["chéng"], ["shū"]],
    "衡石量书": [["héng"], ["shí"], ["liàng"], ["shū"]],
    "轰堂大笑": [["hōng"], ["táng"], ["dà"], ["xiào"]],
    "轰天烈地": [["hōng"], ["tiān"], ["liè"], ["dì"]],
    "轰天裂地": [["hōng"], ["tiān"], ["liè"], ["dì"]],
    "轰炸机": [["hōng"], ["zhà"], ["jī"]],
    "哄动一时": [["hōng"], ["dòng"], ["yī"], ["shí"]],
    "哄堂大笑": [["hōng"], ["táng"], ["dà"], ["xiào"]],
    "烘堂大笑": [["hōng"], ["táng"], ["dà"], ["xiào"]],
    "弘奖风流": [["hóng"], ["jiǎng"], ["fēng"], ["liú"]],
    "红白喜事": [["hóng"], ["bái"], ["xǐ"], ["shì"]],
    "红宝石": [["hóng"], ["bǎo"], ["shí"]],
    "红不棱登": [["hóng"], ["bù"], ["lēng"], ["dēng"]],
    "红澄澄": [["hóng"], ["deng"], ["deng"]],
    "红愁绿惨": [["hóng"], ["chóu"], ["lǜ"], ["cǎn"]],
    "红得发紫": [["hóng"], ["de"], ["fā"], ["zǐ"]],
    "红灯区": [["hóng"], ["dēng"], ["qū"]],
    "红豆蔻": [["hóng"], ["dòu"], ["kòu"]],
    "红豆相思": [["hóng"], ["dòu"], ["xiāng"], ["sī"]],
    "红飞翠舞": [["hóng"], ["fēi"], ["cuì"], ["wǔ"]],
    "红粉青楼": [["hóng"], ["fěn"], ["qīng"], ["lóu"]],
    "红腐贯朽": [["hóng"], ["fǔ"], ["guàn"], ["xiǔ"]],
    "红光满面": [["hóng"], ["guāng"], ["mǎn"], ["miàn"]],
    "红口白牙": [["hóng"], ["kǒu"], ["bái"], ["yá"]],
    "红楼梦": [["hóng"], ["lóu"], ["mèng"]],
    "红绿灯": [["hóng"], ["lǜ"], ["dēng"]],
    "红领巾": [["hóng"], ["lǐng"], ["jīn"]],
    "红帽子": [["hóng"], ["mào"], ["zi"]],
    "红霉素": [["hóng"], ["méi"], ["sù"]],
    "红模子": [["hóng"], ["mú"], ["zǐ"]],
    "红男绿女": [["hóng"], ["nán"], ["lǜ"], ["nǚ"]],
    "红皮书": [["hóng"], ["pí"], ["shū"]],
    "红扑扑": [["hóng"], ["pū"], ["pū"]],
    "红旗报捷": [["hóng"], ["qí"], ["bào"], ["jié"]],
    "红旗手": [["hóng"], ["qí"], ["shǒu"]],
    "红情绿意": [["hóng"], ["qíng"], ["lǜ"], ["yì"]],
    "红日三竿": [["hóng"], ["rì"], ["sān"], ["gān"]],
    "红烧肉": [["hóng"], ["shāo"], ["ròu"]],
    "红绳系足": [["hóng"], ["shéng"], ["jì"], ["zú"]],
    "红十字会": [["hóng"], ["shí"], ["zì"], ["huì"]],
    "红衰翠减": [["hóng"], ["shuāi"], ["cuì"], ["jiǎn"]],
    "红水河": [["hóng"], ["shuǐ"], ["hé"]],
    "红通通": [["hóng"], ["tōng"], ["tōng"]],
    "红彤彤": [["hóng"], ["tōng"], ["tōng"]],
    "红头文件": [["hóng"], ["tóu"], ["wén"], ["jiàn"]],
    "红外线": [["hóng"], ["wài"], ["xiàn"]],
    "红卫兵": [["hóng"], ["wèi"], ["bīng"]],
    "红细胞": [["hóng"], ["xì"], ["bāo"]],
    "红小鬼": [["hóng"], ["xiǎo"], ["guǐ"]],
    "红新月会": [["hóng"], ["xīn"], ["yuè"], ["huì"]],
    "红杏出墙": [["hóng"], ["xìng"], ["chū"], ["qiáng"]],
    "红血球": [["hóng"], ["xuè"], ["qiú"]],
    "红颜薄命": [["hóng"], ["yán"], ["bó"], ["mìng"]],
    "红眼病": [["hóng"], ["yǎn"], ["bìng"]],
    "红艳艳": [["hóng"], ["yàn"], ["yàn"]],
    "红药水": [["hóng"], ["yào"], ["shuǐ"]],
    "红叶题诗": [["hóng"], ["yè"], ["tí"], ["shī"]],
    "红衣主教": [["hóng"], ["yī"], ["zhǔ"], ["jiào"]],
    "红殷殷": [["hóng"], ["yīn"], ["yīn"]],
    "红缨枪": [["hóng"], ["yīng"], ["qiāng"]],
    "红紫乱朱": [["hóng"], ["zǐ"], ["luàn"], ["zhū"]],
    "宏才大略": [["hóng"], ["cái"], ["dà"], ["lüè"]],
    "宏材大略": [["hóng"], ["cái"], ["dà"], ["lüè"]],
    "宏观经济": [["hóng"], ["guān"], ["jīng"], ["jì"]],
    "宏观经济学": [["hóng"], ["guān"], ["jīng"], ["jì"], ["xué"]],
    "宏观世界": [["hóng"], ["guān"], ["shì"], ["jiè"]],
    "宏图大志": [["hóng"], ["tú"], ["dà"], ["zhì"]],
    "闳侈不经": [["hóng"], ["chǐ"], ["bù"], ["jīng"]],
    "闳大不经": [["hóng"], ["dà"], ["bù"], ["jīng"]],
    "闳识孤怀": [["hóng"], ["shí"], ["gū"], ["huái"]],
    "闳中肆外": [["hóng"], ["zhōng"], ["sì"], ["wài"]],
    "闳言高论": [["hóng"], ["yán"], ["gāo"], ["lùn"]],
    "洪都拉斯": [["hóng"], ["dōu"], ["lā"], ["sī"]],
    "洪福齐天": [["hóng"], ["fú"], ["qí"], ["tiān"]],
    "洪炉燎发": [["hóng"], ["lú"], ["liáo"], ["fà"]],
    "洪乔捎书": [["hóng"], ["qiáo"], ["shāo"], ["shū"]],
    "洪水横流": [["hóng"], ["shuǐ"], ["héng"], ["liú"]],
    "洪泽湖": [["hóng"], ["zé"], ["hú"]],
    "虹销雨霁": [["hóng"], ["xiāo"], ["yǔ"], ["jì"]],
    "鸿案相庄": [["hóng"], ["àn"], ["xiāng"], ["zhuāng"]],
    "鸿案鹿车": [["hóng"], ["àn"], ["lù"], ["chē"]],
    "鸿笔丽藻": [["hóng"], ["bǐ"], ["lì"], ["zǎo"]],
    "鸿都买第": [["hóng"], ["dōu"], ["mǎi"], ["dì"]],
    "鸿飞霜降": [["hóng"], ["fēi"], ["shuāng"], ["jiàng"]],
    "鸿飞雪爪": [["hóng"], ["fēi"], ["xuě"], ["zhǎo"]],
    "鸿鹄将至": [["hóng"], ["hú"], ["jiāng"], ["zhì"]],
    "鸿渐于干": [["hóng"], ["jiàn"], ["yú"], ["gàn"]],
    "鸿渐之仪": [["hóng"], ["jiàn"], ["zhī"], ["yí"]],
    "鸿渐之翼": [["hóng"], ["jiàn"], ["zhī"], ["yì"]],
    "鸿蒙初辟": [["hóng"], ["méng"], ["chū"], ["pì"]],
    "鸿篇巨著": [["hóng"], ["piān"], ["jù"], ["zhù"]],
    "鸿泥雪爪": [["hóng"], ["ní"], ["xuě"], ["zhǎo"]],
    "鸿篇巨着": [["hóng"], ["piān"], ["jù"], ["zhe"]],
    "鸿儒硕学": [["hóng"], ["rú"], ["shuò"], ["xué"]],
    "鸿图华构": [["hóng"], ["tú"], ["huá"], ["gòu"]],
    "鸿商富贾": [["hóng"], ["shāng"], ["fù"], ["jiǎ"]],
    "鸿业远图": [["hóng"], ["yè"], ["yuǎn"], ["tú"]],
    "鸿衣羽裳": [["hóng"], ["yī"], ["yǔ"], ["shang"]],
    "鸿隐凤伏": [["hóng"], ["yǐn"], ["fèng"], ["fú"]],
    "鸿爪春泥": [["hóng"], ["zhǎo"], ["chūn"], ["ní"]],
    "鸿爪留泥": [["hóng"], ["zhǎo"], ["liú"], ["ní"]],
    "鸿爪雪泥": [["hóng"], ["zhǎo"], ["xuě"], ["ní"]],
    "侯服玉食": [["hóu"], ["fú"], ["yù"], ["shí"]],
    "侯门如海": [["hóu"], ["mén"], ["rú"], ["hǎi"]],
    "侯门深似海": [["hóu"], ["mén"], ["shēn"], ["sì"], ["hǎi"]],
    "侯门似海": [["hóu"], ["mén"], ["sì"], ["hǎi"]],
    "喉长气短": [["hóu"], ["cháng"], ["qì"], ["duǎn"]],
    "猴头猴脑": [["hóu"], ["tóu"], ["hóu"], ["nǎo"]],
    "后车之戒": [["hòu"], ["chē"], ["zhī"], ["jiè"]],
    "后发制人": [["hòu"], ["fā"], ["zhì"], ["rén"]],
    "后福无量": [["hòu"], ["fú"], ["wú"], ["liàng"]],
    "后悔不及": [["hòu"], ["huǐ"], ["bù"], ["jí"]],
    "后悔莫及": [["hòu"], ["huǐ"], ["mò"], ["jí"]],
    "后会无期": [["hòu"], ["huì"], ["wú"], ["qī"]],
    "后继有人": [["hòu"], ["jì"], ["yǒu"], ["rén"]],
    "后会有期": [["hòu"], ["huì"], ["yǒu"], ["qī"]],
    "后来居上": [["hòu"], ["lái"], ["jū"], ["shàng"]],
    "后来者居上": [["hòu"], ["lái"], ["zhě"], ["jū"], ["shàng"]],
    "后生可畏": [["hòu"], ["shēng"], ["kě"], ["wèi"]],
    "后手不接": [["hòu"], ["shǒu"], ["bù"], ["jiē"]],
    "后台老板": [["hòu"], ["tái"], ["lǎo"], ["bǎn"]],
    "后遗症": [["hòu"], ["yí"], ["zhèng"]],
    "厚此薄彼": [["hòu"], ["cǐ"], ["bó"], ["bǐ"]],
    "厚德载福": [["hòu"], ["dé"], ["zǎi"], ["fú"]],
    "厚德载物": [["hòu"], ["dé"], ["zài"], ["wù"]],
    "厚古薄今": [["hòu"], ["gǔ"], ["bó"], ["jīn"]],
    "厚积薄发": [["hòu"], ["jī"], ["bó"], ["fā"]],
    "厚往薄来": [["hòu"], ["wǎng"], ["báo"], ["lái"]],
    "厚今薄古": [["hòu"], ["jīn"], ["bó"], ["gǔ"]],
    "厚味腊毒": [["hòu"], ["wèi"], ["xī"], ["dú"]],
    "候风地动仪": [["hòu"], ["fēng"], ["dì"], ["dòng"], ["yí"]],
    "候车室": [["hòu"], ["chē"], ["shì"]],
    "呼不给吸": [["hū"], ["bù"], ["jǐ"], ["xī"]],
    "呼风唤雨": [["hū"], ["fēng"], ["huàn"], ["yǔ"]],
    "呼和浩特": [["hū"], ["hé"], ["hào"], ["tè"]],
    "呼啦啦": [["hū"], ["lā"], ["lā"]],
    "呼来喝去": [["hū"], ["lái"], ["hè"], ["qù"]],
    "呼卢喝雉": [["hū"], ["lú"], ["hè"], ["zhì"]],
    "呼天号地": [["hū"], ["tiān"], ["hào"], ["dì"]],
    "呼群结党": [["hū"], ["qún"], ["jié"], ["dǎng"]],
    "呼天叫地": [["hū"], ["tiān"], ["jiào"], ["dì"]],
    "呼天抢地": [["hū"], ["tiān"], ["qiāng"], ["dì"]],
    "呼天唤地": [["hū"], ["tiān"], ["huàn"], ["dì"]],
    "呼天吁地": [["hū"], ["tiān"], ["yù"], ["dì"]],
    "呼天钥地": [["hū"], ["tiān"], ["yào"], ["dì"]],
    "呼吸系统": [["hū"], ["xī"], ["xì"], ["tǒng"]],
    "呼天叩地": [["hū"], ["tiān"], ["kòu"], ["dì"]],
    "呼吸相通": [["hū"], ["xī"], ["xiāng"], ["tōng"]],
    "呼吸之间": [["hū"], ["xī"], ["zhī"], ["jiān"]],
    "呼幺喝六": [["hū"], ["yāo"], ["hè"], ["liù"]],
    "忽忽不乐": [["hū"], ["hū"], ["bù"], ["lè"]],
    "忽隐忽现": [["hū"], ["yǐn"], ["hū"], ["xiàn"]],
    "囫囵半片": [["hú"], ["lún"], ["bàn"], ["piàn"]],
    "狐奔鼠窜": [["hú"], ["bēn"], ["shǔ"], ["cuàn"]],
    "弧圈球": [["hú"], ["quān"], ["qiú"]],
    "狐不二雄": [["hú"], ["bù"], ["èr"], ["xióng"]],
    "狐假虎威": [["hú"], ["jiǎ"], ["hǔ"], ["wēi"]],
    "狐假鸱张": [["hú"], ["jiǎ"], ["chī"], ["zhāng"]],
    "狐唱枭和": [["hú"], ["chàng"], ["xiāo"], ["hé"]],
    "狐藉虎威": [["hú"], ["jiè"], ["hǔ"], ["wēi"]],
    "狐狸尾巴": [["hú"], ["li"], ["wěi"], ["ba"]],
    "狐埋狐扬": [["hú"], ["mái"], ["hú"], ["yáng"]],
    "狐埋狐搰": [["hú"], ["mái"], ["hú"], ["hú"]],
    "狐鸣篝中": [["hú"], ["míng"], ["gōu"], ["zhōng"]],
    "狐裘尨茸": [["hú"], ["qiú"], ["méng"], ["róng"]],
    "狐裘蒙茸": [["hú"], ["qiú"], ["méng"], ["róng"]],
    "狐疑不决": [["hú"], ["yí"], ["bù"], ["jué"]],
    "狐裘蒙戎": [["hú"], ["qiú"], ["méng"], ["róng"]],
    "胡吃海喝": [["hú"], ["chī"], ["hǎi"], ["hē"]],
    "胡服骑射": [["hú"], ["fú"], ["qí"], ["shè"]],
    "胡打海摔": [["hú"], ["dǎ"], ["hǎi"], ["shuāi"]],
    "胡拉乱扯": [["hú"], ["lā"], ["luàn"], ["chě"]],
    "胡萝卜": [["hú"], ["luó"], ["bo"]],
    "胡说八道": [["hú"], ["shuō"], ["bā"], ["dào"]],
    "胡说乱道": [["hú"], ["shuō"], ["luàn"], ["dào"]],
    "胡说白道": [["hú"], ["shuō"], ["bái"], ["dào"]],
    "胡思乱量": [["hú"], ["sī"], ["luàn"], ["liàng"]],
    "胡思乱想": [["hú"], ["sī"], ["luàn"], ["xiǎng"]],
    "胡天胡地": [["hú"], ["tiān"], ["hú"], ["dì"]],
    "胡行乱为": [["hú"], ["xíng"], ["luàn"], ["wéi"]],
    "胡言汉语": [["hú"], ["yán"], ["hàn"], ["yǔ"]],
    "胡言乱语": [["hú"], ["yán"], ["luàn"], ["yǔ"]],
    "胡越同舟": [["hú"], ["yuè"], ["tóng"], ["zhōu"]],
    "胡越一家": [["hú"], ["yuè"], ["yī"], ["jiā"]],
    "胡支扯叶": [["hú"], ["zhī"], ["chě"], ["yè"]],
    "胡枝扯叶": [["hú"], ["zhī"], ["chě"], ["yè"]],
    "胡子拉碴": [["hú"], ["zǐ"], ["lā"], ["chā"]],
    "胡诌乱说": [["hú"], ["zhōu"], ["luàn"], ["shuō"]],
    "胡作非为": [["hú"], ["zuò"], ["fēi"], ["wéi"]],
    "胡作胡为": [["hú"], ["zuò"], ["hú"], ["wéi"]],
    "胡作乱为": [["hú"], ["zuò"], ["luàn"], ["wéi"]],
    "壶里乾坤": [["hú"], ["lǐ"], ["qián"], ["kūn"]],
    "壶浆塞道": [["hú"], ["jiāng"], ["sāi"], ["dào"]],
    "壶中日月": [["hú"], ["zhōng"], ["rì"], ["yuè"]],
    "壶中天地": [["hú"], ["zhōng"], ["tiān"], ["dì"]],
    "湖北大鼓": [["hú"], ["běi"], ["dà"], ["gǔ"]],
    "糊糊涂涂": [["hū"], ["hū"], ["tú"], ["tú"]],
    "糊口度日": [["hú"], ["kǒu"], ["dù"], ["rì"]],
    "糊里糊涂": [["hú"], ["lǐ"], ["hú"], ["tú"]],
    "糊涂虫": [["hú"], ["tú"], ["chóng"]],
    "糊涂蛋": [["hú"], ["tú"], ["dàn"]],
    "蝴蝶结": [["hú"], ["dié"], ["jié"]],
    "糊涂账": [["hú"], ["tú"], ["zhàng"]],
    "虎背熊腰": [["hǔ"], ["bèi"], ["xióng"], ["yāo"]],
    "虎步龙行": [["hǔ"], ["bù"], ["lóng"], ["xíng"]],
    "虎不食儿": [["hǔ"], ["bù"], ["shí"], ["ér"]],
    "虎荡羊群": [["hǔ"], ["dàng"], ["yáng"], ["qún"]],
    "虎而冠": [["hǔ"], ["ér"], ["guàn"]],
    "虎骨酒": [["hǔ"], ["gǔ"], ["jiǔ"]],
    "虎据龙蟠": [["hǔ"], ["jù"], ["lóng"], ["pán"]],
    "虎落平川": [["hǔ"], ["luò"], ["píng"], ["chuān"]],
    "虎珀拾芥": [["hǔ"], ["pò"], ["shí"], ["jiè"]],
    "虎入羊群": [["hǔ"], ["rù"], ["yáng"], ["qún"]],
    "虎体熊腰": [["hǔ"], ["tǐ"], ["xióng"], ["yāo"]],
    "虎斗龙争": [["hǔ"], ["dòu"], ["lóng"], ["zhēng"]],
    "虎头虎脑": [["hǔ"], ["tóu"], ["hǔ"], ["nǎo"]],
    "虎头蛇尾": [["hǔ"], ["tóu"], ["shé"], ["wěi"]],
    "虎尾春冰": [["hǔ"], ["wěi"], ["chūn"], ["bīng"]],
    "虎头燕颔": [["hǔ"], ["tóu"], ["yàn"], ["hàn"]],
    "虎卧龙跳": [["hǔ"], ["wò"], ["lóng"], ["tiào"]],
    "虎啸风生": [["hǔ"], ["xiào"], ["fēng"], ["shēng"]],
    "互剥痛疮": [["hù"], ["bō"], ["tòng"], ["chuāng"]],
    "互通有无": [["hù"], ["tōng"], ["yǒu"], ["wú"]],
    "互为表里": [["hù"], ["wéi"], ["biǎo"], ["lǐ"]],
    "互为因果": [["hù"], ["wéi"], ["yīn"], ["guò"]],
    "互相标榜": [["hù"], ["xiāng"], ["biāo"], ["bǎng"]],
    "互相推诿": [["hù"], ["xiāng"], ["tuī"], ["wěi"]],
    "互助组": [["hù"], ["zhù"], ["zǔ"]],
    "户曹参军": [["hù"], ["cáo"], ["cān"], ["jūn"]],
    "户口簿": [["hù"], ["kǒu"], ["bù"]],
    "户枢不蠹": [["hù"], ["shū"], ["bù"], ["dù"]],
    "户枢不蝼": [["hù"], ["shū"], ["bù"], ["lóu"]],
    "户枢不朽": [["hù"], ["shū"], ["bù"], ["xiǔ"]],
    "户限为穿": [["hù"], ["xiàn"], ["wéi"], ["chuān"]],
    "护过饰非": [["hù"], ["guò"], ["shì"], ["fēi"]],
    "护士长": [["hù"], ["shì"], ["zhǎng"]],
    "怙恶不悛": [["hù"], ["è"], ["bù"], ["quān"]],
    "怙过不悛": [["hù"], ["guò"], ["bù"], ["quān"]],
    "怙顽不悛": [["hù"], ["wán"], ["bù"], ["quān"]],
    "怙终不悔": [["hù"], ["zhōng"], ["bù"], ["huǐ"]],
    "怙终不悛": [["hù"], ["zhōng"], ["bù"], ["quān"]],
    "花不棱登": [["huā"], ["bù"], ["lēng"], ["dēng"]],
    "花朝月夕": [["huā"], ["zhāo"], ["yuè"], ["xī"]],
    "花朝月夜": [["huā"], ["zhāo"], ["yuè"], ["yè"]],
    "花大姐": [["huā"], ["dà"], ["jiě"]],
    "花簇锦攒": [["huā"], ["cù"], ["jǐn"], ["cuán"]],
    "花灯戏": [["huā"], ["dēng"], ["xì"]],
    "花骨朵": [["huā"], ["gū"], ["duǒ"]],
    "花岗石": [["huā"], ["gǎng"], ["shí"]],
    "花鼓戏": [["huā"], ["gǔ"], ["xì"]],
    "花好月圆": [["huā"], ["hǎo"], ["yuè"], ["yuán"]],
    "花红柳绿": [["huā"], ["hóng"], ["liǔ"], ["lǜ"]],
    "花花绿绿": [["huā"], ["huā"], ["lǜ"], ["lǜ"]],
    "花街柳巷": [["huā"], ["jiē"], ["liǔ"], ["xiàng"]],
    "花露水": [["huā"], ["lù"], ["shuǐ"]],
    "花说柳说": [["huā"], ["shuō"], ["liǔ"], ["shuō"]],
    "花天酒地": [["huā"], ["tiān"], ["jiǔ"], ["dì"]],
    "花天锦地": [["huā"], ["tiān"], ["jǐn"], ["dì"]],
    "花香鸟语": [["huā"], ["xiāng"], ["niǎo"], ["yǔ"]],
    "花信年华": [["huā"], ["xìn"], ["nián"], ["huá"]],
    "花言巧语": [["huā"], ["yán"], ["qiǎo"], ["yǔ"]],
    "花攒锦簇": [["huā"], ["cuán"], ["jǐn"], ["cù"]],
    "花攒锦聚": [["huā"], ["cuán"], ["jǐn"], ["jù"]],
    "花遮柳隐": [["huā"], ["zhē"], ["liǔ"], ["yǐn"]],
    "花枝招展": [["huā"], ["zhī"], ["zhāo"], ["zhǎn"]],
    "花枝招颤": [["huā"], ["zhī"], ["zhāo"], ["chàn"]],
    "花枝招颭": [["huā"], ["zhī"], ["zhāo"], ["zhǎn"]],
    "华北平原": [["huá"], ["běi"], ["píng"], ["yuán"]],
    "华不再扬": [["huá"], ["bù"], ["zài"], ["yáng"]],
    "华达呢": [["huá"], ["dá"], ["ní"]],
    "华尔兹": [["huá"], ["ěr"], ["zī"]],
    "华而不实": [["huá"], ["ér"], ["bù"], ["shí"]],
    "华尔街": [["huá"], ["ěr"], ["jiē"]],
    "华冠丽服": [["huá"], ["guān"], ["lì"], ["fú"]],
    "华封三祝": [["huá"], ["fēng"], ["sān"], ["zhù"]],
    "华盛顿": [["huá"], ["shèng"], ["dùn"]],
    "华氏温度计": [["huà"], ["shì"], ["wēn"], ["dù"], ["jì"]],
    "华亭鹤唳": [["huà"], ["tíng"], ["hè"], ["lì"]],
    "华屋丘墟": [["huá"], ["wū"], ["qiū"], ["xū"]],
    "华屋秋墟": [["huá"], ["wū"], ["qiū"], ["xū"]],
    "华屋山丘": [["huá"], ["wū"], ["shān"], ["qiū"]],
    "华星秋月": [["huá"], ["xīng"], ["qiū"], ["yuè"]],
    "华严宗": [["huá"], ["yán"], ["zōng"]],
    "华阴市": [["huá"], ["yīn"], ["shì"]],
    "哗世动俗": [["huá"], ["shì"], ["dòng"], ["sú"]],
    "哗啦啦": [["huā"], ["lā"], ["lā"]],
    "哗世取宠": [["huá"], ["shì"], ["qǔ"], ["chǒng"]],
    "哗世取名": [["huá"], ["shì"], ["qǔ"], ["míng"]],
    "滑冰场": [["huá"], ["bīng"], ["chǎng"]],
    "哗众取宠": [["huá"], ["zhòng"], ["qǔ"], ["chǒng"]],
    "滑不唧溜": [["huá"], ["bù"], ["jī"], ["liū"]],
    "滑稽戏": [["huá"], ["jī"], ["xì"]],
    "滑稽剧": [["huá"], ["jī"], ["jù"]],
    "滑泥扬波": [["huá"], ["ní"], ["yáng"], ["bō"]],
    "滑石粉": [["huá"], ["shí"], ["fěn"]],
    "滑天下之大稽": [["huá"], ["tiān"], ["xià"], ["zhī"], ["dà"], ["jī"]],
    "滑头滑脑": [["huá"], ["tóu"], ["huá"], ["nǎo"]],
    "化鸱为凤": [["huà"], ["chī"], ["wéi"], ["fèng"]],
    "化粪池": [["huà"], ["fèn"], ["chí"]],
    "化腐为奇": [["huà"], ["fǔ"], ["wéi"], ["qí"]],
    "化腐成奇": [["huà"], ["fǔ"], ["chéng"], ["qí"]],
    "化腐朽为神奇": [["huà"], ["fǔ"], ["xiǔ"], ["wéi"], ["shén"], ["qí"]],
    "化干戈为玉帛": [["huà"], ["gān"], ["gē"], ["wéi"], ["yù"], ["bó"]],
    "化合物": [["huà"], ["hé"], ["wù"]],
    "化及豚鱼": [["huà"], ["jí"], ["tún"], ["yú"]],
    "化零为整": [["huà"], ["líng"], ["wéi"], ["zhěng"]],
    "化民成俗": [["huà"], ["mín"], ["chéng"], ["sú"]],
    "化民易俗": [["huà"], ["mín"], ["yì"], ["sú"]],
    "化日光天": [["huà"], ["rì"], ["guāng"], ["tiān"]],
    "化若偃草": [["huà"], ["ruò"], ["yǎn"], ["cǎo"]],
    "化铁炉": [["huà"], ["tiě"], ["lú"]],
    "化外之民": [["huà"], ["wài"], ["zhī"], ["mín"]],
    "化为泡影": [["huà"], ["wéi"], ["pāo"], ["yǐng"]],
    "化为乌有": [["huà"], ["wéi"], ["wū"], ["yǒu"]],
    "化险为夷": [["huà"], ["xiǎn"], ["wéi"], ["yí"]],
    "化枭为鸠": [["huà"], ["xiāo"], ["wéi"], ["jiū"]],
    "化性起伪": [["huà"], ["xìng"], ["qǐ"], ["wěi"]],
    "化学肥料": [["huà"], ["xué"], ["féi"], ["liào"]],
    "化学元素": [["huà"], ["xué"], ["yuán"], ["sù"]],
    "化整为零": [["huà"], ["zhěng"], ["wéi"], ["líng"]],
    "化妆品": [["huà"], ["zhuāng"], ["pǐn"]],
    "划不来": [["huá"], ["bù"], ["lái"]],
    "划得来": [["huá"], ["de"], ["lái"]],
    "划时代": [["huà"], ["shí"], ["dài"]],
    "划地为牢": [["huá"], ["dì"], ["wéi"], ["láo"]],
    "划一不二": [["huà"], ["yī"], ["bù"], ["èr"]],
    "划粥割齑": [["huà"], ["zhōu"], ["gē"], ["jī"]],
    "画等号": [["huà"], ["děng"], ["hào"]],
    "画荻和丸": [["huà"], ["dí"], ["huò"], ["wán"]],
    "画荻教子": [["huà"], ["dí"], ["jiào"], ["zǐ"]],
    "画地成牢": [["huà"], ["dì"], ["chéng"], ["láo"]],
    "画地成图": [["huà"], ["dì"], ["chéng"], ["tú"]],
    "画地刻木": [["huà"], ["dì"], ["kè"], ["mù"]],
    "画地而趋": [["huà"], ["dì"], ["ér"], ["qū"]],
    "画地为牢": [["huà"], ["dì"], ["wéi"], ["láo"]],
    "画地为狱": [["huà"], ["dì"], ["wéi"], ["yù"]],
    "画地作狱": [["huà"], ["dì"], ["zuò"], ["yù"]],
    "画虎不成": [["huà"], ["hǔ"], ["bù"], ["chéng"]],
    "画虎不成反类狗": [["huà"], ["hǔ"], ["bù"], ["chéng"], ["fǎn"], ["lèi"], ["gǒu"]],
    "画虎不成反类犬": [["huà"], ["hǔ"], ["bù"], ["chéng"], ["fǎn"], ["lèi"], ["quǎn"]],
    "画虎画皮难画骨": [["huà"], ["hǔ"], ["huà"], ["pí"], ["nán"], ["huà"], ["gǔ"]],
    "画疆墨守": [["huà"], ["jiāng"], ["mò"], ["shǒu"]],
    "画龙不成反为狗": [["huà"], ["lóng"], ["bù"], ["chéng"], ["fǎn"], ["wéi"], ["gǒu"]],
    "画沙聚米": [["huà"], ["shā"], ["jù"], ["mǐ"]],
    "画沙印泥": [["huà"], ["shā"], ["yìn"], ["ní"]],
    "画蛇著足": [["huà"], ["shé"], ["zhuó"], ["zú"]],
    "画蛇添足": [["huà"], ["shé"], ["tiān"], ["zú"]],
    "画土分疆": [["huà"], ["tǔ"], ["fēn"], ["jiāng"]],
    "画野分疆": [["huà"], ["yě"], ["fēn"], ["jiāng"]],
    "画中有诗": [["huà"], ["zhōng"], ["yǒu"], ["shī"]],
    "话把儿": [["huà"], ["bà"], ["er"]],
    "话不投机": [["huà"], ["bù"], ["tóu"], ["jī"]],
    "话不相投": [["huà"], ["bù"], ["xiāng"], ["tóu"]],
    "话不虚传": [["huà"], ["bù"], ["xū"], ["chuán"]],
    "话长说短": [["huà"], ["cháng"], ["shuō"], ["duǎn"]],
    "话里藏阄": [["huà"], ["lǐ"], ["cáng"], ["jiū"]],
    "话里带刺": [["huà"], ["lǐ"], ["dài"], ["cì"]],
    "话里有刺": [["huà"], ["lǐ"], ["yǒu"], ["cì"]],
    "话里有话": [["huà"], ["lǐ"], ["yǒu"], ["huà"]],
    "话务员": [["huà"], ["wù"], ["yuán"]],
    "话言话语": [["huà"], ["yán"], ["huà"], ["yǔ"]],
    "话中有话": [["huà"], ["zhōng"], ["yǒu"], ["huà"]],
    "怀璧其罪": [["huái"], ["bì"], ["qí"], ["zuì"]],
    "怀才不遇": [["huái"], ["cái"], ["bū"], ["yù"]],
    "怀敌附远": [["huái"], ["dí"], ["fù"], ["yuǎn"]],
    "怀铅提椠": [["huái"], ["qiān"], ["tí"], ["qiàn"]],
    "怀铅握椠": [["huái"], ["qiān"], ["wò"], ["qiàn"]],
    "怀珠韫玉": [["huái"], ["zhū"], ["yùn"], ["yù"]],
    "怀着鬼胎": [["huái"], ["zhe"], ["guǐ"], ["tāi"]],
    "淮橘为枳": [["huái"], ["jú"], ["wéi"], ["zhǐ"]],
    "淮南鸡犬": [["huái"], ["nán"], ["jī"], ["quǎn"]],
    "淮王鸡狗": [["huái"], ["wáng"], ["jī"], ["gǒu"]],
    "槐南一梦": [["huái"], ["nán"], ["yī"], ["mēng"]],
    "踝子骨": [["huái"], ["zǐ"], ["gǔ"]],
    "坏东西": [["huài"], ["dōng"], ["xī"]],
    "坏法乱纪": [["huài"], ["fǎ"], ["luàn"], ["jì"]],
    "坏分子": [["huài"], ["fèn"], ["zǐ"]],
    "坏脾气": [["huài"], ["pí"], ["qì"]],
    "坏人心术": [["huài"], ["rén"], ["xīn"], ["shù"]],
    "坏裳为裤": [["huài"], ["shang"], ["wéi"], ["kù"]],
    "坏血病": [["huài"], ["xuè"], ["bìng"]],
    "坏植散群": [["huài"], ["zhí"], ["sàn"], ["qún"]],
    "欢迸乱跳": [["huān"], ["bèng"], ["luàn"], ["tiào"]],
    "欢蹦乱跳": [["huān"], ["bèng"], ["luàn"], ["tiào"]],
    "欢呼雀跃": [["huān"], ["hū"], ["qué"], ["yué"]],
    "欢声笑语": [["huān"], ["shēng"], ["xiào"], ["yǔ"]],
    "欢若平生": [["huān"], ["ruò"], ["píng"], ["shēng"]],
    "欢天喜地": [["huān"], ["tiān"], ["xǐ"], ["dì"]],
    "欢喜若狂": [["huān"], ["xǐ"], ["ruò"], ["kuáng"]],
    "欢喜冤家": [["huān"], ["xǐ"], ["yuān"], ["jiā"]],
    "欢欣若狂": [["huān"], ["xīn"], ["ruò"], ["kuáng"]],
    "还淳反古": [["huán"], ["chún"], ["fǎn"], ["gǔ"]],
    "还淳反朴": [["huán"], ["chún"], ["fǎn"], ["pǔ"]],
    "还淳反素": [["huán"], ["chún"], ["fǎn"], ["sù"]],
    "还淳返朴": [["huán"], ["chún"], ["fǎn"], ["pǔ"]],
    "还醇返朴": [["huán"], ["chún"], ["fǎn"], ["pǔ"]],
    "还年卻老": [["huán"], ["nián"], ["què"], ["lǎo"]],
    "还年却老": [["huán"], ["nián"], ["què"], ["lǎo"]],
    "还年驻色": [["huán"], ["nián"], ["zhù"], ["sè"]],
    "还朴反古": [["huán"], ["pǔ"], ["fǎn"], ["gǔ"]],
    "还我河山": [["huán"], ["wǒ"], ["hé"], ["shān"]],
    "还乡团": [["huán"], ["xiāng"], ["tuán"]],
    "还乡昼锦": [["huán"], ["xiāng"], ["zhòu"], ["jǐn"]],
    "还元返本": [["huán"], ["yuán"], ["fǎn"], ["běn"]],
    "还原反本": [["huán"], ["yuán"], ["fǎn"], ["běn"]],
    "还原染料": [["huán"], ["yuán"], ["rǎn"], ["liào"]],
    "还珠返璧": [["huán"], ["zhū"], ["fǎn"], ["bì"]],
    "还珠合浦": [["huán"], ["zhū"], ["hé"], ["pǔ"]],
    "还珠买椟": [["huán"], ["zhū"], ["mǎi"], ["dú"]],
    "环肥燕瘦": [["huán"], ["féi"], ["yàn"], ["shòu"]],
    "缓不济急": [["huǎn"], ["bù"], ["jì"], ["jí"]],
    "缓步代车": [["huǎn"], ["bù"], ["dài"], ["chē"]],
    "缓急轻重": [["huǎn"], ["jí"], ["qīng"], ["zhòng"]],
    "缓急相济": [["huǎn"], ["jí"], ["xiāng"], ["jì"]],
    "幻灯片": [["huàn"], ["dēng"], ["piàn"]],
    "宦海风波": [["huàn"], ["hǎi"], ["fēng"], ["bō"]],
    "幻想曲": [["huàn"], ["xiǎng"], ["qǔ"]],
    "换斗移星": [["huàn"], ["dǒu"], ["yí"], ["xīng"]],
    "换个儿": [["huàn"], ["gè"], ["ér"]],
    "换骨脱胎": [["huàn"], ["gǔ"], ["tuō"], ["tāi"]],
    "换骨夺胎": [["huàn"], ["gǔ"], ["duó"], ["tāi"]],
    "换汤不换药": [["huàn"], ["tāng"], ["bù"], ["huàn"], ["yào"]],
    "涣发大号": [["huàn"], ["fā"], ["dà"], ["hào"]],
    "涣汗大号": [["huàn"], ["hàn"], ["dà"], ["hào"]],
    "涣若冰释": [["huàn"], ["ruò"], ["bīng"], ["shì"]],
    "涣若冰消": [["huàn"], ["ruò"], ["bīng"], ["xiāo"]],
    "患得患失": [["huàn"], ["dé"], ["huàn"], ["shī"]],
    "患难夫妻": [["huàn"], ["nàn"], ["fū"], ["qī"]],
    "患难与共": [["huàn"], ["nàn"], ["yǔ"], ["gòng"]],
    "患难之交": [["huàn"], ["nàn"], ["zhī"], ["jiāo"]],
    "荒诞不经": [["huāng"], ["dàn"], ["bù"], ["jīng"]],
    "荒诞无稽": [["huāng"], ["dàn"], ["wú"], ["jī"]],
    "荒时暴月": [["huāng"], ["shí"], ["bào"], ["yuè"]],
    "荒唐无稽": [["huāng"], ["táng"], ["wú"], ["jī"]],
    "荒淫无度": [["huāng"], ["yín"], ["wú"], ["dù"]],
    "皇皇不可终日": [["huáng"], ["huáng"], ["bù"], ["kě"], ["zhōng"], ["rì"]],
    "慌不择路": [["huāng"], ["bù"], ["zé"], ["lù"]],
    "皇亲国戚": [["huáng"], ["qīn"], ["guó"], ["qī"]],
    "皇天不负苦心人": [["huáng"], ["tiān"], ["bù"], ["fù"], ["kǔ"], ["xīn"], ["rén"]],
    "黄耳传书": [["huáng"], ["ěr"], ["chuán"], ["shū"]],
    "黄发垂髫": [["huáng"], ["fà"], ["chuí"], ["tiáo"]],
    "黄发儿齿": [["huáng"], ["fà"], ["ér"], ["chǐ"]],
    "黄发骀背": [["huáng"], ["fā"], ["dài"], ["bèi"]],
    "黄发台背": [["huáng"], ["fā"], ["tái"], ["bèi"]],
    "黄发鲐背": [["huáng"], ["fā"], ["tái"], ["bèi"]],
    "黄风雾罩": [["huáng"], ["fēng"], ["wù"], ["zhào"]],
    "黄干黑廋": [["huáng"], ["gān"], ["hēi"], ["sōu"]],
    "黄冠草服": [["huáng"], ["guàn"], ["cǎo"], ["fú"]],
    "黄冠草履": [["huáng"], ["guàn"], ["cǎo"], ["lǚ"]],
    "黄冠野服": [["huáng"], ["guàn"], ["yě"], ["fú"]],
    "黄花晚节": [["huáng"], ["huā"], ["wǎn"], ["jié"]],
    "黄金时间": [["huáng"], ["jīn"], ["shí"], ["jiān"]],
    "黄卷青灯": [["huáng"], ["juàn"], ["qīng"], ["dēng"]],
    "黄卷幼妇": [["huáng"], ["juàn"], ["yòu"], ["fù"]],
    "黄麻紫泥": [["huáng"], ["má"], ["zǐ"], ["ní"]],
    "黄袍加体": [["huáng"], ["páo"], ["jiā"], ["tǐ"]],
    "黄埔港": [["huáng"], ["pǔ"], ["gǎng"]],
    "黄雀伺蝉": [["huáng"], ["què"], ["sì"], ["chán"]],
    "黄雀衔环": [["huáng"], ["què"], ["xián"], ["huán"]],
    "黄雀在后": [["huáng"], ["què"], ["zài"], ["hòu"]],
    "黄台之瓜": [["huáng"], ["tái"], ["zhī"], ["guā"]],
    "黄汤淡水": [["huáng"], ["tāng"], ["dàn"], ["shuǐ"]],
    "黄汤辣水": [["huáng"], ["tāng"], ["là"], ["shuǐ"]],
    "黄钟长弃": [["huáng"], ["zhōng"], ["cháng"], ["qì"]],
    "黄钟大吕": [["huáng"], ["zhōng"], ["dà"], ["lǚ"]],
    "黄钟瓦釜": [["huáng"], ["zhōng"], ["wǎ"], ["fǔ"]],
    "黄锺瓦缶": [["huáng"], ["zhōng"], ["wǎ"], ["fǒu"]],
    "惶惶不可终日": [["huáng"], ["huáng"], ["bù"], ["kě"], ["zhōng"], ["rì"]],
    "惶惶不安": [["huáng"], ["huáng"], ["bù"], ["ān"]],
    "惶恐不安": [["huáng"], ["kǒng"], ["bù"], ["ān"]],
    "潢池盗弄": [["huáng"], ["shi"], ["dào"], ["nòng"]],
    "潢池弄兵": [["huáng"], ["chí"], ["nòng"], ["bīng"]],
    "恍然大悟": [["huǎng"], ["rán"], ["dà"], ["wù"]],
    "恍然若失": [["huǎng"], ["rán"], ["ruò"], ["shī"]],
    "晃晃悠悠": [["huàng"], ["huǎng"], ["yōu"], ["yōu"]],
    "灰不溜丢": [["huī"], ["bù"], ["liū"], ["diū"]],
    "灰溜溜": [["huī"], ["liū"], ["liū"]],
    "灰蒙蒙": [["huī"], ["mēng"], ["méng"]],
    "灰身粉骨": [["huī"], ["shēn"], ["fěn"], ["gǔ"]],
    "灰躯糜骨": [["huī"], ["qū"], ["mí"], ["gǔ"]],
    "灰头土脸": [["huī"], ["tóu"], ["tǔ"], ["liǎn"]],
    "灰头土面": [["huī"], ["tóu"], ["tǔ"], ["miàn"]],
    "灰心丧气": [["huī"], ["xīn"], ["sàng"], ["qì"]],
    "灰心丧意": [["huī"], ["xīn"], ["sàng"], ["yì"]],
    "恢复期": [["huī"], ["fù"], ["qī"]],
    "恢宏大度": [["huī"], ["hóng"], ["dà"], ["dù"]],
    "恢恢有余": [["huī"], ["huī"], ["yǒu"], ["yú"]],
    "恢廓大度": [["huī"], ["kuò"], ["dà"], ["dù"]],
    "挥发性": [["huī"], ["fā"], ["xìng"]],
    "挥发油": [["huī"], ["fā"], ["yóu"]],
    "挥汗成雨": [["huī"], ["hàn"], ["chéng"], ["yǔ"]],
    "挥汗如雨": [["huī"], ["hàn"], ["rú"], ["yǔ"]],
    "挥毫落纸": [["huī"], ["háo"], ["luò"], ["zhǐ"]],
    "挥霍无度": [["huī"], ["huò"], ["wú"], ["dù"]],
    "挥沐吐餐": [["huī"], ["mù"], ["tǔ"], ["cān"]],
    "挥洒自如": [["huī"], ["sǎ"], ["zì"], ["rú"]],
    "隳胆抽肠": [["huī"], ["dǎn"], ["chōu"], ["cháng"]],
    "隳肝尝胆": [["huī"], ["gān"], ["cháng"], ["dǎn"]],
    "隳肝沥胆": [["huī"], ["gān"], ["lì"], ["dǎn"]],
    "隳节败名": [["huī"], ["jié"], ["bài"], ["míng"]],
    "回肠百转": [["huí"], ["cháng"], ["bǎi"], ["zhuǎn"]],
    "回肠九转": [["huí"], ["cháng"], ["jiǔ"], ["zhuǎn"]],
    "回筹转策": [["huí"], ["chóu"], ["zhuǎn"], ["cè"]],
    "回船转舵": [["huí"], ["chuán"], ["zhǎn"], ["duò"]],
    "回春之术": [["huí"], ["chūn"], ["zhī"], ["shù"]],
    "回干就湿": [["huí"], ["gān"], ["jiù"], ["shī"]],
    "回黄转绿": [["huí"], ["huáng"], ["zhuǎn"], ["lǜ"]],
    "回老家": [["huí"], ["lǎo"], ["jiā"]],
    "回娘家": [["huí"], ["niáng"], ["jiā"]],
    "回山倒海": [["huí"], ["shān"], ["dǎo"], ["hǎi"]],
    "回山转海": [["huí"], ["shān"], ["zhuǎn"], ["hǎi"]],
    "回天倒日": [["huí"], ["tiān"], ["dǎo"], ["rì"]],
    "回天乏术": [["huí"], ["tiān"], ["fá"], ["shù"]],
    "回天转地": [["huí"], ["tiān"], ["zhuǎn"], ["dì"]],
    "回天运斗": [["huí"], ["tiān"], ["yùn"], ["dǒu"]],
    "回头见": [["huí"], ["tóu"], ["jiàn"]],
    "回头路": [["huí"], ["tóu"], ["lù"]],
    "回头是岸": [["huí"], ["tóu"], ["shì"], ["àn"]],
    "回文织锦": [["huí"], ["wén"], ["zhī"], ["jǐn"]],
    "回邪入正": [["huí"], ["xié"], ["rù"], ["zhèng"]],
    "回心转意": [["huí"], ["xīn"], ["zhuǎn"], ["yì"]],
    "回旋曲": [["huí"], ["xuán"], ["qǔ"]],
    "悔不当初": [["huǐ"], ["bù"], ["dāng"], ["chū"]],
    "悔读南华": [["huǐ"], ["dú"], ["nán"], ["huá"]],
    "悔过书": [["huǐ"], ["guò"], ["shū"]],
    "悔过自新": [["huǐ"], ["guò"], ["zì"], ["xīn"]],
    "悔过自责": [["huǐ"], ["guò"], ["zì"], ["zè"]],
    "悔其少作": [["huǐ"], ["qí"], ["shǎo"], ["zuò"]],
    "悔之不及": [["huǐ"], ["zhī"], ["bù"], ["jí"]],
    "汇丰银行": [["huì"], ["fēng"], ["yín"], ["háng"]],
    "会道能说": [["huì"], ["dào"], ["néng"], ["shuō"]],
    "会道门": [["huì"], ["dào"], ["mén"]],
    "会逢其适": [["huì"], ["féng"], ["qí"], ["shì"]],
    "会计师": [["kuài"], ["jì"], ["shī"]],
    "会计制度": [["kuài"], ["jì"], ["zhì"], ["dù"]],
    "会家不忙": [["huì"], ["jiā"], ["bù"], ["máng"]],
    "会客室": [["huì"], ["kè"], ["shì"]],
    "会少离多": [["huì"], ["shǎo"], ["lí"], ["duō"]],
    "会议室": [["huì"], ["yì"], ["shì"]],
    "会员国": [["huì"], ["yuán"], ["guó"]],
    "会者不忙": [["huì"], ["zhě"], ["bù"], ["máng"]],
    "讳恶不悛": [["huì"], ["è"], ["bù"], ["quān"]],
    "讳莫高深": [["huì"], ["mò"], ["gāo"], ["shēn"]],
    "讳莫如深": [["huì"], ["mò"], ["rú"], ["shēn"]],
    "讳树数马": [["huì"], ["shù"], ["shù"], ["mǎ"]],
    "诲人不倦": [["huì"], ["rén"], ["bù"], ["juàn"]],
    "诲人不惓": [["huì"], ["rén"], ["bù"], ["tiě"]],
    "贿货公行": [["huì"], ["huò"], ["gōng"], ["xíng"]],
    "贿赂公行": [["huì"], ["lù"], ["gōng"], ["xíng"]],
    "贿赂并行": [["huì"], ["lù"], ["bìng"], ["xíng"]],
    "晦盲否塞": [["huì"], ["máng"], ["pǐ"], ["sè"]],
    "秽德垢行": [["huì"], ["dé"], ["gòu"], ["xíng"]],
    "秽言污语": [["huì"], ["yán"], ["wū"], ["yǔ"]],
    "喙长三尺": [["huì"], ["cháng"], ["sān"], ["chǐ"]],
    "惠而不费": [["huì"], ["ér"], ["bù"], ["fèi"]],
    "惠更斯": [["huì"], ["gēng"], ["sī"]],
    "惠风和畅": [["huì"], ["fēng"], ["hé"], ["chàng"]],
    "惠子知我": [["huì"], ["zǐ"], ["zhī"], ["wǒ"]],
    "毁不灭性": [["huǐ"], ["bù"], ["miè"], ["xìng"]],
    "毁不危身": [["huǐ"], ["bù"], ["wēi"], ["shēn"]],
    "毁车杀马": [["huǐ"], ["chē"], ["shā"], ["mǎ"]],
    "毁风败俗": [["huǐ"], ["fēng"], ["bài"], ["sú"]],
    "毁方瓦合": [["huǐ"], ["fāng"], ["wǎ"], ["hé"]],
    "毁冠裂裳": [["huǐ"], ["guān"], ["liè"], ["cháng"]],
    "毁家纾国": [["huǐ"], ["jiā"], ["shū"], ["guó"]],
    "毁家纾难": [["huǐ"], ["jiā"], ["shū"], ["nàn"]],
    "毁誉参半": [["huǐ"], ["yù"], ["cān"], ["bàn"]],
    "毁瓦画墁": [["huǐ"], ["wǎ"], ["huà"], ["màn"]],
    "毁誉不一": [["huǐ"], ["yù"], ["bù"], ["yī"]],
    "毁钟为铎": [["huǐ"], ["zhōng"], ["wéi"], ["duó"]],
    "毁舟为杕": [["huǐ"], ["zhōu"], ["wéi"], ["duò"]],
    "慧心巧思": [["huì"], ["xīn"], ["qiǎo"], ["sī"]],
    "昏定晨省": [["hūn"], ["dìng"], ["chén"], ["xǐng"]],
    "昏镜重明": [["hūn"], ["jìng"], ["chóng"], ["míng"]],
    "昏镜重磨": [["hūn"], ["jìng"], ["chóng"], ["mó"]],
    "昏聩无能": [["hūn"], ["kuì"], ["wú"], ["néng"]],
    "昏迷不省": [["hūn"], ["mí"], ["bù"], ["xǐng"]],
    "昏迷不醒": [["hūn"], ["mí"], ["bù"], ["xǐng"]],
    "昏天暗地": [["hūn"], ["tiān"], ["àn"], ["dì"]],
    "昏天黑地": [["hūn"], ["tiān"], ["hēi"], ["dì"]],
    "昏头搭脑": [["hūn"], ["tóu"], ["dā"], ["nǎo"]],
    "昏头打脑": [["hūn"], ["tóu"], ["dǎ"], ["nǎo"]],
    "昏头昏脑": [["hūn"], ["tóu"], ["hūn"], ["nǎo"]],
    "昏头晕脑": [["hūn"], ["tóu"], ["yūn"], ["nǎo"]],
    "昏头转向": [["hūn"], ["tóu"], ["zhuǎn"], ["xiàng"]],
    "浑抡吞枣": [["hún"], ["lún"], ["tūn"], ["zǎo"]],
    "浑然无知": [["hún"], ["rán"], ["wú"], ["zhī"]],
    "浑身解数": [["hún"], ["shēn"], ["xiè"], ["shù"]],
    "浑身上下": [["hún"], ["shēn"], ["shàng"], ["xià"]],
    "浑然一体": [["hún"], ["rán"], ["yī"], ["tǐ"]],
    "浑俗和光": [["hún"], ["sú"], ["hé"], ["guāng"]],
    "浑头浑脑": [["hún"], ["tóu"], ["hún"], ["nǎo"]],
    "魂不负体": [["hún"], ["bù"], ["fù"], ["tǐ"]],
    "魂不附体": [["hún"], ["bù"], ["fù"], ["tǐ"]],
    "魂不赴体": [["hún"], ["bù"], ["fù"], ["tǐ"]],
    "魂不守舍": [["hún"], ["bù"], ["shǒu"], ["shè"]],
    "魂不著体": [["hún"], ["bù"], ["zhuó"], ["tǐ"]],
    "魂不守宅": [["hún"], ["bù"], ["shǒu"], ["zhái"]],
    "魂颠梦倒": [["hún"], ["diān"], ["mèng"], ["dǎo"]],
    "魂不着体": [["hún"], ["bù"], ["zhuó"], ["tǐ"]],
    "魂飞胆颤": [["hún"], ["fēi"], ["dǎn"], ["chàn"]],
    "魂飞胆裂": [["hún"], ["fēi"], ["dǎn"], ["liè"]],
    "魂飞胆落": [["hún"], ["fēi"], ["dǎn"], ["luò"]],
    "魂飞胆丧": [["hún"], ["fēi"], ["dǎn"], ["sàng"]],
    "魂飞魄散": [["hún"], ["fēi"], ["pò"], ["sàn"]],
    "魂飞魄丧": [["hún"], ["fēi"], ["pò"], ["sāng"]],
    "魂飞神丧": [["hún"], ["fēi"], ["shén"], ["sàng"]],
    "魂耗魄丧": [["hún"], ["hào"], ["pò"], ["sàng"]],
    "魂惊胆颤": [["hún"], ["jīng"], ["dǎn"], ["chàn"]],
    "魂惊魄落": [["hún"], ["jīng"], ["pò"], ["luò"]],
    "魂惊胆落": [["hún"], ["jīng"], ["dǎn"], ["luò"]],
    "魂飘魄散": [["hún"], ["piāo"], ["pò"], ["sàn"]],
    "魂丧神夺": [["hún"], ["sàng"], ["shén"], ["duó"]],
    "魂慑色沮": [["hún"], ["shè"], ["sè"], ["jǔ"]],
    "魂慴色沮": [["hún"], ["shè"], ["sè"], ["jǔ"]],
    "魂亡胆落": [["hún"], ["wáng"], ["dǎn"], ["luò"]],
    "魂亡魄失": [["hún"], ["wáng"], ["pò"], ["shī"]],
    "魂消胆丧": [["hún"], ["xiāo"], ["dǎn"], ["sàng"]],
    "魂消魄丧": [["hún"], ["xiāo"], ["pò"], ["sàng"]],
    "混沌不分": [["hùn"], ["dùn"], ["bù"], ["fēn"]],
    "混混沌沌": [["hùn"], ["hùn"], ["dùn"], ["dùn"]],
    "混混噩噩": [["hún"], ["hún"], ["è"], ["è"]],
    "混混沄沄": [["hùn"], ["hùn"], ["yún"], ["yún"]],
    "混然天成": [["hùn"], ["rán"], ["tiān"], ["chéng"]],
    "混然一体": [["hún"], ["rán"], ["yī"], ["tǐ"]],
    "混世魔王": [["hùn"], ["shì"], ["mó"], ["wáng"]],
    "混水捞鱼": [["hùn"], ["shuǐ"], ["lāo"], ["yú"]],
    "混日子": [["hùn"], ["rì"], ["zi"]],
    "混水摸鱼": [["hùn"], ["shuǐ"], ["mō"], ["yú"]],
    "混俗和光": [["hùn"], ["sú"], ["hé"], ["guāng"]],
    "混为一谈": [["hùn"], ["wéi"], ["yī"], ["tán"]],
    "混淆视听": [["hùn"], ["xiáo"], ["shì"], ["tīng"]],
    "混淆黑白": [["hùn"], ["xiáo"], ["hēi"], ["bái"]],
    "混淆是非": [["hùn"], ["xiáo"], ["shì"], ["fēi"]],
    "混应滥应": [["hùn"], ["yīng"], ["làn"], ["yīng"]],
    "混作一谈": [["hùn"], ["zuò"], ["yī"], ["tán"]],
    "豁出去": [["huō"], ["chū"], ["qù"]],
    "豁达大度": [["huò"], ["dá"], ["dà"], ["dù"]],
    "豁口截舌": [["huō"], ["kǒu"], ["jié"], ["shé"]],
    "豁免权": [["huò"], ["miǎn"], ["quán"]],
    "豁然大悟": [["huò"], ["rán"], ["dà"], ["wù"]],
    "豁然贯通": [["huò"], ["rán"], ["guàn"], ["tōng"]],
    "豁然顿悟": [["huò"], ["rán"], ["dùn"], ["wù"]],
    "豁然开朗": [["huò"], ["rán"], ["kāi"], ["lǎng"]],
    "豁然开悟": [["huò"], ["rán"], ["kāi"], ["wù"]],
    "豁然省悟": [["huò"], ["rán"], ["xǐng"], ["wù"]],
    "豁然确斯": [["huò"], ["rán"], ["què"], ["sī"]],
    "豁人耳目": [["huò"], ["rén"], ["ěr"], ["mù"]],
    "活蹦活跳": [["huó"], ["bèng"], ["huó"], ["tiào"]],
    "活蹦乱跳": [["huó"], ["bèng"], ["luàn"], ["tiào"]],
    "活剥生吞": [["huó"], ["bāo"], ["shēng"], ["tūn"]],
    "活地狱": [["huó"], ["dì"], ["yù"]],
    "活动分子": [["huó"], ["dòng"], ["fèn"], ["zǐ"]],
    "活动家": [["huó"], ["dòng"], ["jiā"]],
    "活见鬼": [["huó"], ["jiàn"], ["guǐ"]],
    "活龙鲜健": [["huó"], ["lóng"], ["xiān"], ["jiàn"]],
    "活教材": [["huó"], ["jiào"], ["cái"]],
    "活期存款": [["huó"], ["qī"], ["cún"], ["kuǎn"]],
    "活鲜鲜": [["huó"], ["xiān"], ["xiān"]],
    "活阎王": [["huó"], ["yán"], ["wáng"]],
    "活字印刷": [["huó"], ["zì"], ["yìn"], ["shuā"]],
    "火把节": [["huǒ"], ["bǎ"], ["jié"]],
    "火车头": [["huǒ"], ["chē"], ["tóu"]],
    "火耕流种": [["huǒ"], ["gēng"], ["liú"], ["zhǒng"]],
    "火耕水种": [["huǒ"], ["gēng"], ["shuǐ"], ["zhòng"]],
    "火急火燎": [["huǒ"], ["jí"], ["huǒ"], ["liǎo"]],
    "火箭炮": [["huǒ"], ["jiàn"], ["pào"]],
    "火尽灰冷": [["huǒ"], ["jìn"], ["huī"], ["lěng"]],
    "火尽薪传": [["huǒ"], ["jìn"], ["xīn"], ["chuán"]],
    "火力发电": [["huǒ"], ["lì"], ["fā"], ["diàn"]],
    "火冒三尺": [["huǒ"], ["mào"], ["sān"], ["chǐ"]],
    "火冒三丈": [["huǒ"], ["mào"], ["sān"], ["zhàng"]],
    "火妻灰子": [["huǒ"], ["qī"], ["huī"], ["zǐ"]],
    "火山汤海": [["huǒ"], ["shān"], ["tāng"], ["hǎi"]],
    "火上加油": [["huǒ"], ["shàng"], ["jiā"], ["yóu"]],
    "火上浇油": [["huǒ"], ["shàng"], ["jiāo"], ["yóu"]],
    "火上弄冰": [["huǒ"], ["shàng"], ["nòng"], ["bīng"]],
    "火上添油": [["huǒ"], ["shàng"], ["tiān"], ["yóu"]],
    "火烧火燎": [["huǒ"], ["shāo"], ["huǒ"], ["liǎo"]],
    "火头军": [["huǒ"], ["tóu"], ["jūn"]],
    "火头上": [["huǒ"], ["tóu"], ["shàng"]],
    "火中取栗": [["huǒ"], ["zhōng"], ["qǔ"], ["lì"]],
    "伙伴关系": [["huǒ"], ["bàn"], ["guān"], ["xì"]],
    "或多或少": [["huò"], ["duō"], ["huò"], ["shǎo"]],
    "货而不售": [["huo"], ["er"], ["bu"], ["shou"]],
    "货贿公行": [["huò"], ["huì"], ["gōng"], ["xíng"]],
    "货郎鼓": [["huò"], ["láng"], ["gǔ"]],
    "货郎担": [["huò"], ["láng"], ["dān"]],
    "货赂大行": [["huò"], ["lù"], ["dà"], ["xíng"]],
    "货赂公行": [["huò"], ["lù"], ["gōng"], ["xíng"]],
    "货真价实": [["huò"], ["zhēn"], ["jià"], ["shí"]],
    "获得性免疫": [["huò"], ["dé"], ["xìng"], ["miǎn"], ["yì"]],
    "获隽公车": [["huò"], ["jūn"], ["gōng"], ["chē"]],
    "祸不单行": [["huò"], ["bù"], ["dān"], ["xíng"]],
    "祸不旋踵": [["huò"], ["bù"], ["xuán"], ["zhǒng"]],
    "祸从口出": [["huò"], ["cóng"], ["kǒu"], ["chū"]],
    "祸从口生": [["huò"], ["cóng"], ["kǒu"], ["shēng"]],
    "祸福同门": [["huò"], ["fú"], ["tóng"], ["mén"]],
    "祸从天降": [["huò"], ["cóng"], ["tiān"], ["jiàng"]],
    "祸福相生": [["huò"], ["fú"], ["xiāng"], ["shēng"]],
    "祸福相依": [["huò"], ["fú"], ["xiāng"], ["yī"]],
    "祸福相倚": [["huò"], ["fú"], ["xiāng"], ["yī"]],
    "祸福有命": [["huò"], ["fú"], ["yǒu"], ["mìng"]],
    "祸结兵连": [["huò"], ["jié"], ["bīng"], ["lián"]],
    "祸稔恶积": [["huò"], ["rěn"], ["è"], ["jī"]],
    "祸迫眉睫": [["huò"], ["pò"], ["méi"], ["jié"]],
    "祸为福先": [["huò"], ["wéi"], ["fú"], ["xiān"]],
    "祸中有福": [["huò"], ["zhōng"], ["yǒu"], ["fú"]],
    "祸盈恶稔": [["huò"], ["yíng"], ["è"], ["rěn"]],
    "蠖屈不伸": [["huò"], ["qū"], ["bù"], ["shēn"]],
    "击搏挽裂": [["jī"], ["bó"], ["wǎn"], ["liè"]],
    "击电奔星": [["jī"], ["diàn"], ["bēn"], ["xīng"]],
    "击毂摩肩": [["jī"], ["gǔ"], ["mó"], ["jiān"]],
    "击楫中流": [["jī"], ["jí"], ["zhōng"], ["liú"]],
    "击节称赏": [["jī"], ["jié"], ["chēng"], ["shǎng"]],
    "击节叹赏": [["jī"], ["jié"], ["tàn"], ["shǎng"]],
    "击排冒没": [["jī"], ["pái"], ["mào"], ["mò"]],
    "击其不意": [["jī"], ["qí"], ["bù"], ["yì"]],
    "击石弹丝": [["jī"], ["shí"], ["tán"], ["sī"]],
    "击中要害": [["jī"], ["zhòng"], ["yào"], ["hài"]],
    "击钟鼎食": [["jī"], ["zhōng"], ["dǐng"], ["shí"]],
    "击筑悲歌": [["jī"], ["zhù"], ["bēi"], ["gē"]],
    "叽叽嘎嘎": [["jī"], ["jī"], ["gā"], ["gā"]],
    "叽叽喳喳": [["jī"], ["jī"], ["zhā"], ["zhā"]],
    "叽里呱啦": [["jī"], ["lǐ"], ["guā"], ["lā"]],
    "叽哩咕噜": [["jī"], ["lǐ"], ["gū"], ["lū"]],
    "饥不遑食": [["jī"], ["bù"], ["huáng"], ["shí"]],
    "饥不暇食": [["jī"], ["bù"], ["xiá"], ["shí"]],
    "饥不择食": [["jī"], ["bù"], ["zé"], ["shí"]],
    "饥冻交切": [["jī"], ["dòng"], ["jiāo"], ["qiē"]],
    "饥寒交迫": [["jī"], ["hán"], ["jiāo"], ["pò"]],
    "饥焰中烧": [["jī"], ["yàn"], ["zhōng"], ["shāo"]],
    "饥寒交切": [["jī"], ["hán"], ["jiāo"], ["qiē"]],
    "机不可失": [["jī"], ["bù"], ["kě"], ["shī"]],
    "机不容发": [["jī"], ["bù"], ["róng"], ["fā"]],
    "机不旋踵": [["jī"], ["bù"], ["xuán"], ["zhǒng"]],
    "机动车": [["jī"], ["dòng"], ["chē"]],
    "机关车": [["jī"], ["guān"], ["chē"]],
    "机关炮": [["jī"], ["guān"], ["pào"]],
    "机关算尽": [["jī"], ["guān"], ["suàn"], ["jìn"]],
    "机关用尽": [["jī"], ["guān"], ["yòng"], ["jìn"]],
    "机会主义": [["jī"], ["huì"], ["zhǔ"], ["yì"]],
    "机难轻失": [["jī"], ["nán"], ["qīng"], ["shī"]],
    "机器脚踏车": [["jī"], ["qì"], ["jiǎo"], ["tà"], ["chē"]],
    "机事不密": [["jī"], ["shì"], ["bù"], ["mì"]],
    "机械化": [["jī"], ["xiè"], ["huà"]],
    "机械论": [["jī"], ["xiè"], ["lùn"]],
    "机要秘书": [["jī"], ["yào"], ["mì"], ["shū"]],
    "机要员": [["jī"], ["yào"], ["yuán"]],
    "机杼一家": [["jī"], ["zhù"], ["yī"], ["jiā"]],
    "肌劈理解": [["jī"], ["pī"], ["lǐ"], ["jiě"]],
    "鸡肠狗肚": [["jī"], ["cháng"], ["gǒu"], ["dù"]],
    "鸡不及凤": [["jī"], ["bù"], ["jí"], ["fèng"]],
    "鸡虫得丧": [["jī"], ["chóng"], ["dé"], ["sàng"]],
    "鸡虫得失": [["jī"], ["chóng"], ["dé"], ["shī"]],
    "鸡蛋里找骨头": [["jī"], ["dàn"], ["lǐ"], ["zhǎo"], ["gǔ"], ["tóu"]],
    "鸡飞蛋打": [["jī"], ["fēi"], ["dàn"], ["dǎ"]],
    "鸡飞狗跳": [["jī"], ["fēi"], ["gǒu"], ["tiào"]],
    "鸡肤鹤发": [["jī"], ["fū"], ["hè"], ["fā"]],
    "鸡公车": [["jī"], ["gōng"], ["chē"]],
    "鸡骨支床": [["jī"], ["gǔ"], ["zhī"], ["chuáng"]],
    "鸡毛掸子": [["jī"], ["máo"], ["dǎn"], ["zǐ"]],
    "鸡毛信": [["jī"], ["máo"], ["xìn"]],
    "鸡内金": [["jī"], ["nà"], ["jīn"]],
    "鸡皮疙瘩": [["jī"], ["pí"], ["gē"], ["dā"]],
    "鸡皮鹤发": [["jī"], ["pí"], ["hè"], ["fà"]],
    "鸡犬不安": [["jī"], ["quǎn"], ["bù"], ["ān"]],
    "鸡栖凤巢": [["jī"], ["qī"], ["fèng"], ["cháo"]],
    "鸡犬不惊": [["jī"], ["quǎn"], ["bù"], ["jīng"]],
    "鸡犬不留": [["jī"], ["quǎn"], ["bù"], ["liú"]],
    "鸡犬不宁": [["jī"], ["quǎn"], ["bù"], ["níng"]],
    "鸡犬不闻": [["jī"], ["quǎn"], ["bù"], ["wén"]],
    "鸡犬相闻": [["jī"], ["quǎn"], ["xiāng"], ["wén"]],
    "鸡声鹅斗": [["jī"], ["shēng"], ["é"], ["dòu"]],
    "鸡尸牛从": [["jī"], ["shī"], ["niú"], ["cóng"]],
    "鸡头鱼刺": [["jī"], ["tóu"], ["yú"], ["cì"]],
    "鸡尾酒": [["jī"], ["wěi"], ["jiǔ"]],
    "鸡尾酒会": [["jī"], ["wěi"], ["jiǔ"], ["huì"]],
    "鸡鹜相争": [["jī"], ["wù"], ["xiāng"], ["zhēng"]],
    "鸡鹜争食": [["jī"], ["wù"], ["zhēng"], ["shí"]],
    "鸡胸龟背": [["jī"], ["xiōng"], ["guī"], ["bèi"]],
    "鸡血石": [["jī"], ["xiě"], ["shí"]],
    "鸡争鹅斗": [["jī"], ["zhēng"], ["é"], ["dòu"]],
    "唧唧喳喳": [["jī"], ["jī"], ["zhā"], ["zhā"]],
    "屐齿之折": [["jī"], ["chǐ"], ["zhī"], ["zhé"]],
    "积不相能": [["jī"], ["bù"], ["xiāng"], ["néng"]],
    "积草屯粮": [["jī"], ["cǎo"], ["tún"], ["liáng"]],
    "积谗糜骨": [["jī"], ["chán"], ["méi"], ["gǔ"]],
    "积德累功": [["jī"], ["dé"], ["lěi"], ["gōng"]],
    "积谗磨骨": [["jī"], ["chán"], ["mó"], ["gǔ"]],
    "积德累善": [["jī"], ["dé"], ["lěi"], ["shàn"]],
    "积德累仁": [["jī"], ["dé"], ["lěi"], ["rén"]],
    "积恶余殃": [["jī"], ["è"], ["yú"], ["yāng"]],
    "积毁销骨": [["jī"], ["huǐ"], ["xiāo"], ["gǔ"]],
    "积功兴业": [["jī"], ["gōng"], ["xīng"], ["yè"]],
    "积极分子": [["jī"], ["jí"], ["fèn"], ["zǐ"]],
    "积甲山齐": [["jī"], ["jiǎ"], ["shān"], ["qí"]],
    "积金累玉": [["jī"], ["jīn"], ["lèi"], ["yù"]],
    "积露为波": [["jī"], ["lù"], ["wéi"], ["bō"]],
    "积年累岁": [["jī"], ["nián"], ["lěi"], ["suì"]],
    "积年累月": [["jī"], ["nián"], ["lěi"], ["yuè"]],
    "积日累久": [["jī"], ["rì"], ["lěi"], ["jiǔ"]],
    "积日累月": [["jī"], ["rì"], ["lěi"], ["yuè"]],
    "积日累岁": [["jī"], ["rì"], ["lěi"], ["suì"]],
    "积沙成塔": [["jī"], ["shā"], ["chéng"], ["tǎ"]],
    "积沙成滩": [["jī"], ["shā"], ["chéng"], ["tān"]],
    "积时累日": [["jī"], ["shí"], ["lěi"], ["rì"]],
    "积少成多": [["jī"], ["shǎo"], ["chéng"], ["duō"]],
    "积思广益": [["jī"], ["sī"], ["guǎng"], ["yì"]],
    "积素累旧": [["jī"], ["sù"], ["lěi"], ["jiù"]],
    "积岁累月": [["jī"], ["suì"], ["lěi"], ["yuè"]],
    "积微成著": [["jī"], ["wēi"], ["chéng"], ["zhù"]],
    "积习难除": [["jī"], ["xí"], ["nán"], ["chú"]],
    "积习难改": [["jī"], ["xí"], ["nán"], ["gǎi"]],
    "积小成大": [["jī"], ["xiǎo"], ["chéng"], ["dà"]],
    "积雪囊萤": [["jī"], ["xuě"], ["náng"], ["yíng"]],
    "积薪候燎": [["jī"], ["xīn"], ["hòu"], ["liáo"]],
    "积以为常": [["jī"], ["yǐ"], ["wéi"], ["cháng"]],
    "积雨云": [["jī"], ["yǔ"], ["yún"]],
    "积重不反": [["jī"], ["zhòng"], ["bù"], ["fǎn"]],
    "积重不返": [["jī"], ["zhòng"], ["bù"], ["fǎn"]],
    "积重难反": [["jī"], ["zhòng"], ["nán"], ["fǎn"]],
    "积重难返": [["jī"], ["zhòng"], ["nán"], ["fǎn"]],
    "积铢累寸": [["jī"], ["zhū"], ["lěi"], ["cùn"]],
    "赍粮藉寇": [["jī"], ["liáng"], ["jiè"], ["kòu"]],
    "赍志而没": [["jī"], ["zhì"], ["ér"], ["mò"]],
    "赍志以没": [["jī"], ["zhì"], ["yǐ"], ["méi"]],
    "畸重畸轻": [["jī"], ["zhòng"], ["jī"], ["qīng"]],
    "箕裘相继": [["jī"], ["qiú"], ["xiāng"], ["jì"]],
    "箕风毕雨": [["jī"], ["fēng"], ["bì"], ["yǔ"]],
    "箕山之风": [["jī"], ["shān"], ["zhī"], ["fēng"]],
    "畸轻畸重": [["jī"], ["qīng"], ["jī"], ["zhòng"]],
    "箕山之节": [["jī"], ["shān"], ["zhī"], ["jié"]],
    "稽古揆今": [["jī"], ["gǔ"], ["zhèn"], ["jīn"]],
    "稽古振今": [["jī"], ["gǔ"], ["zhèn"], ["jīn"]],
    "稽疑送难": [["jī"], ["yí"], ["sòng"], ["nán"]],
    "齑身粉骨": [["jī"], ["shēn"], ["fěn"], ["gǔ"]],
    "激薄停浇": [["jī"], ["bó"], ["tíng"], ["jiāo"]],
    "激忿填膺": [["jī"], ["fèn"], ["tián"], ["yīng"]],
    "激将法": [["jī"], ["jiàng"], ["fǎ"]],
    "及笄年华": [["jí"], ["jī"], ["nián"], ["huá"]],
    "及宾有鱼": [["jí"], ["bīn"], ["yoǔ"], ["yú"]],
    "及溺呼船": [["jí"], ["nì"], ["hū"], ["chuán"]],
    "及时行乐": [["jí"], ["shí"], ["xíng"], ["lè"]],
    "及时雨": [["jí"], ["shí"], ["yǔ"]],
    "吉卜赛": [["jí"], ["bǔ"], ["sài"]],
    "吉光片裘": [["jí"], ["guāng"], ["piàn"], ["qiú"]],
    "吉光片羽": [["jí"], ["guāng"], ["piàn"], ["yǔ"]],
    "吉普车": [["jí"], ["pǔ"], ["chē"]],
    "吉人自有天相": [["jí"], ["rén"], ["zì"], ["yǒu"], ["tiān"], ["xiàng"]],
    "吉人天相": [["jí"], ["rén"], ["tiān"], ["xiàng"]],
    "吉凶未卜": [["jí"], ["xiōng"], ["wèi"], ["bǔ"]],
    "岌岌不可终日": [["jí"], ["jí"], ["bù"], ["kě"], ["zhōng"], ["rì"]],
    "岌岌可危": [["jí"], ["jí"], ["kě"], ["wēi"]],
    "即景生情": [["jí"], ["jǐng"], ["shēng"], ["qíng"]],
    "即小见大": [["jí"], ["xiǎo"], ["jiàn"], ["dà"]],
    "即兴之作": [["jí"], ["xìng"], ["zhī"], ["zuò"]],
    "极大值": [["jí"], ["dà"], ["zhí"]],
    "极恶不赦": [["jí"], ["è"], ["bù"], ["shè"]],
    "极恶穷凶": [["jí"], ["è"], ["qióng"], ["xiōng"]],
    "极乐世界": [["jí"], ["lè"], ["shì"], ["jiè"]],
    "极乐鸟": [["jí"], ["lè"], ["niǎo"]],
    "极目远望": [["jí"], ["mù"], ["yuǎn"], ["wàng"]],
    "极目远眺": [["jí"], ["mù"], ["yuǎn"], ["tiào"]],
    "极情尽致": [["jí"], ["qíng"], ["jìn"], ["zhì"]],
    "极情纵欲": [["jí"], ["qíng"], ["zòng"], ["yù"]],
    "极深研几": [["jí"], ["shēn"], ["yán"], ["jī"]],
    "极深研幾": [["jí"], ["shēn"], ["yán"], ["jī"]],
    "极寿无疆": [["jí"], ["shòu"], ["wú"], ["jiāng"]],
    "极天际地": [["jí"], ["tiān"], ["jì"], ["dì"]],
    "极天蟠地": [["jí"], ["tiān"], ["pán"], ["dì"]],
    "极天罔地": [["jí"], ["tiān"], ["wǎng"], ["dì"]],
    "极往知来": [["jí"], ["wǎng"], ["zhī"], ["lái"]],
    "极智穷思": [["jí"], ["zhì"], ["qióng"], ["sī"]],
    "极重不反": [["jí"], ["zhòng"], ["bù"], ["fǎn"]],
    "亟疾苛察": [["jí"], ["jí"], ["kē"], ["chá"]],
    "极重难返": [["jí"], ["zhòng"], ["nán"], ["fǎn"]],
    "急不及待": [["jí"], ["bù"], ["jí"], ["dài"]],
    "急不可耐": [["jí"], ["bù"], ["kě"], ["nài"]],
    "急不可待": [["jí"], ["bù"], ["kě"], ["dài"]],
    "急不暇择": [["jí"], ["bù"], ["xiá"], ["zé"]],
    "急不择路": [["jí"], ["bù"], ["zé"], ["lù"]],
    "急不择言": [["jí"], ["bù"], ["zé"], ["yán"]],
    "急不择途": [["jí"], ["bù"], ["zé"], ["tú"]],
    "急风暴雨": [["jí"], ["fēng"], ["bào"], ["yǔ"]],
    "急处从宽": [["jí"], ["chù"], ["cóng"], ["kuān"]],
    "急风骤雨": [["jí"], ["fēng"], ["zhòu"], ["yǔ"]],
    "急公好施": [["jí"], ["gōng"], ["hào"], ["shī"]],
    "急功好利": [["jí"], ["gōng"], ["hào"], ["lì"]],
    "急公好义": [["jí"], ["gōng"], ["hào"], ["yì"]],
    "急管繁弦": [["jí"], ["guǎn"], ["fán"], ["xián"]],
    "急急如律令": [["jí"], ["jí"], ["rú"], ["lǜ"], ["lìng"]],
    "急惊风撞着慢郎中": [["jí"], ["jīng"], ["fēng"], ["zhuàng"], ["zhe"], ["màn"], ["láng"], ["zhōng"]],
    "急景凋年": [["jí"], ["yǐng"], ["diāo"], ["nián"]],
    "急景流年": [["jí"], ["jǐng"], ["liú"], ["nián"]],
    "急救车": [["jí"], ["jiù"], ["chē"]],
    "急口令": [["jí"], ["kǒu"], ["lìng"]],
    "急来报佛脚": [["jí"], ["lái"], ["bào"], ["fó"], ["jiǎo"]],
    "急来抱佛脚": [["jí"], ["lái"], ["bào"], ["fó"], ["jiǎo"]],
    "急敛暴征": [["jí"], ["liǎn"], ["bào"], ["zhēng"]],
    "急脉缓灸": [["jí"], ["mài"], ["huǎn"], ["jiù"]],
    "急脉缓受": [["jí"], ["mài"], ["huǎn"], ["shòu"]],
    "急拍繁弦": [["jí"], ["pāi"], ["fán"], ["xián"]],
    "急起直追": [["jí"], ["qǐ"], ["zhí"], ["zhuī"]],
    "急如风火": [["jí"], ["rú"], ["fēng"], ["huǒ"]],
    "急人之难": [["jí"], ["rén"], ["zhī"], ["nán"]],
    "急刹车": [["jí"], ["shā"], ["chē"]],
    "急行军": [["jí"], ["xíng"], ["jūn"]],
    "急张拘诸": [["jí"], ["zhāng"], ["jū"], ["zhū"]],
    "急中生智": [["jí"], ["zhōng"], ["shēng"], ["zhì"]],
    "急竹繁丝": [["jí"], ["zhú"], ["fán"], ["sī"]],
    "急转弯": [["jí"], ["zhuǎn"], ["wān"]],
    "急转直下": [["jí"], ["zhuǎn"], ["zhí"], ["xià"]],
    "疾病相扶": [["jí"], ["bìng"], ["xiāng"], ["fú"]],
    "疾不可为": [["jí"], ["bù"], ["kě"], ["wéi"]],
    "疾恶如仇": [["jí"], ["è"], ["rú"], ["chóu"]],
    "疾恶如风": [["jí"], ["è"], ["rú"], ["fēng"]],
    "疾恶如雠": [["jí"], ["è"], ["rú"], ["chóu"]],
    "疾恶若雠": [["jí"], ["è"], ["ruò"], ["chóu"]],
    "疾风暴雨": [["jí"], ["fēng"], ["bào"], ["yǔ"]],
    "疾风劲草": [["jí"], ["fēng"], ["jìng"], ["cǎo"]],
    "疾风扫秋叶": [["jí"], ["fēng"], ["sǎo"], ["qiū"], ["yè"]],
    "疾风迅雷": [["jí"], ["fēng"], ["xùn"], ["léi"]],
    "疾风甚雨": [["jí"], ["fēng"], ["shèn"], ["yǔ"]],
    "疾风知劲草": [["jí"], ["fēng"], ["zhī"], ["jìng"], ["cǎo"]],
    "疾风彰劲草": [["jí"], ["fēng"], ["zhāng"], ["jìng"], ["cǎo"]],
    "疾风骤雨": [["jí"], ["fēng"], ["zhòu"], ["yǔ"]],
    "疾雷不及塞耳": [["jí"], ["léi"], ["bù"], ["jí"], ["sāi"], ["ěr"]],
    "疾雷不暇掩耳": [["jí"], ["léi"], ["bù"], ["xiá"], ["yǎn"], ["ěr"]],
    "疾如旋踵": [["jí"], ["rú"], ["xuán"], ["zhǒng"]],
    "疾雷不及掩耳": [["jí"], ["léi"], ["bù"], ["jí"], ["yǎn"], ["ěr"]],
    "疾雨暴风": [["jí"], ["yǔ"], ["bào"], ["fēng"]],
    "疾霆不暇掩目": [["jí"], ["tíng"], ["bù"], ["xiá"], ["yǎn"], ["mù"]],
    "戢鳞委翼": [["jí"], ["lín"], ["wěi"], ["yì"]],
    "疾走先得": [["jí"], ["zǒu"], ["xiān"], ["dé"]],
    "疾足先得": [["jí"], ["zú"], ["xiān"], ["dé"]],
    "棘地荆天": [["jí"], ["dì"], ["jīng"], ["tiān"]],
    "集大成": [["jí"], ["dà"], ["chéng"]],
    "集散地": [["jí"], ["sàn"], ["dì"]],
    "集思广议": [["jí"], ["sī"], ["guǎng"], ["yì"]],
    "集思广益": [["jí"], ["sī"], ["guǎng"], ["yì"]],
    "集体户": [["jí"], ["tǐ"], ["hù"]],
    "集体经济": [["jí"], ["tǐ"], ["jīng"], ["jì"]],
    "集体主义": [["jí"], ["tǐ"], ["zhǔ"], ["yì"]],
    "集腋为裘": [["jí"], ["yè"], ["wéi"], ["qiú"]],
    "集中营": [["jí"], ["zhōng"], ["yíng"]],
    "嫉恶如仇": [["jí"], ["è"], ["rú"], ["chóu"]],
    "嫉恶若仇": [["jí"], ["è"], ["ruò"], ["chóu"]],
    "嫉闲妒能": [["jí"], ["xián"], ["dù"], ["néng"]],
    "嫉贤妒能": [["jí"], ["xián"], ["dù"], ["néng"]],
    "蹐地局天": [["jí"], ["dì"], ["jú"], ["tiān"]],
    "蹐地跼天": [["jí"], ["dì"], ["jú"], ["tiān"]],
    "几不欲生": [["jī"], ["bù"], ["yù"], ["shēng"]],
    "几次三番": [["jǐ"], ["cì"], ["sān"], ["fān"]],
    "几何学": [["jǐ"], ["hé"], ["xué"]],
    "几乎不": [["jī"], ["hū"], ["bù"]],
    "几起几落": [["jǐ"], ["qǐ"], ["jǐ"], ["luò"]],
    "己饥己溺": [["jǐ"], ["jī"], ["jǐ"], ["nì"]],
    "己溺己饥": [["jǐ"], ["nì"], ["jǐ"], ["jī"]],
    "虮虱相吊": [["jǐ"], ["shī"], ["xiēng"], ["diào"]],
    "挤眉溜眼": [["jǐ"], ["méi"], ["liū"], ["yǎn"]],
    "挤眉弄眼": [["jǐ"], ["méi"], ["nòng"], ["yǎn"]],
    "挤牙膏": [["jǐ"], ["yá"], ["gāo"]],
    "脊梁骨": [["jǐ"], ["liáng"], ["gǔ"]],
    "脊椎动物": [["jǐ"], ["zhuī"], ["dòng"], ["wù"]],
    "脊椎骨": [["jǐ"], ["zhuī"], ["gǔ"]],
    "掎角之势": [["jǐ"], ["jiǎo"], ["zhī"], ["shì"]],
    "掎挈伺诈": [["jǐ"], ["qiè"], ["sì"], ["zhà"]],
    "掎裳连袂": [["jǐ"], ["cháng"], ["lián"], ["mèi"]],
    "戟指嚼舌": [["jǐ"], ["zhǐ"], ["jiáo"], ["shé"]],
    "掎裳连襼": [["jǐ"], ["shang"], ["lián"], ["zhēng"]],
    "计不反顾": [["jì"], ["bù"], ["fǎn"], ["gù"]],
    "计不旋跬": [["jì"], ["bù"], ["xuán"], ["kuǐ"]],
    "计不返顾": [["jì"], ["bù"], ["fǎn"], ["gù"]],
    "计不旋踵": [["jì"], ["bù"], ["xuán"], ["zhǒng"]],
    "计出万全": [["jì"], ["chū"], ["wàn"], ["quán"]],
    "计绌方匮": [["jì"], ["chù"], ["fāng"], ["kuì"]],
    "计出万死": [["jì"], ["chū"], ["wàn"], ["sǐ"]],
    "计斗负才": [["jì"], ["dòu"], ["fù"], ["cái"]],
    "计伐称勋": [["jì"], ["fá"], ["chēng"], ["xūn"]],
    "计功补过": [["jì"], ["gōng"], ["bǔ"], ["guò"]],
    "计功量罪": [["jì"], ["gōng"], ["liàng"], ["zuì"]],
    "计功行封": [["jì"], ["gōng"], ["xíng"], ["fēng"]],
    "计过自讼": [["jì"], ["guò"], ["zì"], ["sòng"]],
    "计功行赏": [["jì"], ["gōng"], ["xíng"], ["shǎng"]],
    "计合谋从": [["jì"], ["hé"], ["móu"], ["cóng"]],
    "计尽力穷": [["jì"], ["jìn"], ["lì"], ["qióng"]],
    "计将安出": [["jì"], ["jiāng"], ["ān"], ["chū"]],
    "计穷力尽": [["jì"], ["qióng"], ["lì"], ["jìn"]],
    "计穷虑尽": [["jì"], ["qióng"], ["lǜ"], ["jìn"]],
    "计穷势迫": [["jì"], ["qióng"], ["shì"], ["pò"]],
    "计然之术": [["jì"], ["rán"], ["zhī"], ["shù"]],
    "计日而待": [["jì"], ["rì"], ["ér"], ["dài"]],
    "计日而俟": [["jì"], ["rì"], ["ér"], ["sì"]],
    "计日可待": [["jì"], ["rì"], ["kě"], ["dài"]],
    "计日可期": [["jì"], ["rì"], ["kě"], ["qī"]],
    "计日以期": [["jì"], ["rì"], ["yǐ"], ["qī"]],
    "计日以待": [["jì"], ["rì"], ["yǐ"], ["dài"]],
    "计日以俟": [["jì"], ["rì"], ["yǐ"], ["sì"]],
    "计日指期": [["jì"], ["rì"], ["zhǐ"], ["qī"]],
    "计上心来": [["jì"], ["shàng"], ["xīn"], ["lái"]],
    "计上心头": [["jì"], ["shàng"], ["xīn"], ["tóu"]],
    "计深虑远": [["jì"], ["shēng"], ["lǜ"], ["yuǎn"]],
    "计行虑义": [["jì"], ["xíng"], ["lǜ"], ["yì"]],
    "计勋行赏": [["jì"], ["xūn"], ["xíng"], ["shǎng"]],
    "计研心算": [["jì"], ["yán"], ["xīn"], ["suàn"]],
    "计行言听": [["jì"], ["xíng"], ["yán"], ["tīng"]],
    "记分册": [["jì"], ["fēn"], ["cè"]],
    "记功忘过": [["jì"], ["gōng"], ["wàng"], ["guò"]],
    "记录片": [["jì"], ["lù"], ["piàn"]],
    "纪纲人论": [["jì"], ["gāng"], ["rén"], ["lún"]],
    "纪念碑": [["jì"], ["niàn"], ["bēi"]],
    "纪念册": [["jì"], ["niàn"], ["cè"]],
    "纪念馆": [["jì"], ["niàn"], ["guǎn"]],
    "纪念品": [["jì"], ["niàn"], ["pǐn"]],
    "纪传体": [["jì"], ["chuán"], ["tǐ"]],
    "纪念日": [["jì"], ["niàn"], ["rì"]],
    "纪念堂": [["jì"], ["niàn"], ["táng"]],
    "纪念章": [["jì"], ["niàn"], ["zhāng"]],
    "纪群之交": [["jì"], ["qún"], ["zhī"], ["jiāo"]],
    "技工学校": [["jì"], ["gōng"], ["xué"], ["xiào"]],
    "技术革命": [["jì"], ["shù"], ["gé"], ["mìng"]],
    "技术革新": [["jì"], ["shù"], ["gé"], ["xīn"]],
    "技术员": [["jì"], ["shù"], ["yuán"]],
    "际地蟠天": [["jì"], ["dì"], ["pán"], ["tiān"]],
    "际会风云": [["jì"], ["huì"], ["fēng"], ["yún"]],
    "际遇风云": [["jì"], ["yù"], ["fēng"], ["yún"]],
    "季风气候": [["jì"], ["fēng"], ["qì"], ["hòu"]],
    "季孟之间": [["jì"], ["mèng"], ["zhī"], ["jiān"]],
    "季孙之忧": [["jì"], ["sūn"], ["zhī"], ["yōu"]],
    "季友伯兄": [["jì"], ["yǒu"], ["bó"], ["xiōng"]],
    "哜哜嘈嘈": [["jì"], ["jì"], ["cáo"], ["cáo"]],
    "既得利益": [["jì"], ["dé"], ["lì"], ["yì"]],
    "既往不咎": [["jì"], ["wǎng"], ["bù"], ["jiù"]],
    "济寒赈贫": [["jì"], ["hán"], ["zhèn"], ["pín"]],
    "济河焚舟": [["jì"], ["hé"], ["fén"], ["zhōu"]],
    "济济一堂": [["jǐ"], ["jǐ"], ["yī"], ["táng"]],
    "济苦怜贫": [["jì"], ["kǔ"], ["lián"], ["pín"]],
    "济困扶危": [["jì"], ["kùn"], ["fú"], ["wēi"]],
    "济南市": [["jǐ"], ["nán"], ["shì"]],
    "济窍飘风": [["jì"], ["qiào"], ["piāo"], ["fēng"]],
    "济贫拔苦": [["jì"], ["pín"], ["bá"], ["kǔ"]],
    "济人利物": [["jì"], ["rén"], ["lì"], ["wù"]],
    "济弱锄强": [["jì"], ["ruò"], ["chú"], ["qiáng"]],
    "济弱扶倾": [["jì"], ["ruò"], ["fú"], ["qīng"]],
    "济世安邦": [["jì"], ["shì"], ["ān"], ["bāng"]],
    "济世安民": [["jì"], ["shì"], ["ān"], ["mín"]],
    "济世安人": [["jì"], ["shì"], ["ān"], ["rén"]],
    "济世救人": [["jì"], ["shì"], ["jiù"], ["rén"]],
    "济世匡时": [["jì"], ["shì"], ["kuāng"], ["shí"]],
    "济世之才": [["jì"], ["shì"], ["zhī"], ["cái"]],
    "继晷焚膏": [["jì"], ["guǐ"], ["fén"], ["gāo"]],
    "寂然不动": [["jì"], ["rán"], ["bù"], ["dòng"]],
    "寂若无人": [["jì"], ["ruò"], ["wú"], ["rén"]],
    "寂天寞地": [["jì"], ["tiān"], ["mò"], ["dì"]],
    "寄兴寓情": [["jì"], ["xìng"], ["yù"], ["qíng"]],
    "寄雁传书": [["jì"], ["yàn"], ["chuán"], ["shū"]],
    "霁风朗月": [["jī"], ["fēng"], ["lǎng"], ["yuè"]],
    "霁月光风": [["jī"], ["yuè"], ["guāng"], ["fēng"]],
    "骥伏盐车": [["jì"], ["fú"], ["yán"], ["chē"]],
    "骥服盐车": [["jì"], ["fú"], ["yán"], ["chē"]],
    "加尔各答": [["jiā"], ["ěr"], ["gè"], ["dá"]],
    "加减乘除": [["jiā"], ["jiǎn"], ["chéng"], ["chú"]],
    "加勒比海": [["jiā"], ["lè"], ["bǐ"], ["hǎi"]],
    "加农炮": [["jiā"], ["nóng"], ["pào"]],
    "加塞儿": [["jiā"], ["sāi"], ["ér"]],
    "加速度": [["jiā"], ["sù"], ["dù"]],
    "加枝添叶": [["jiā"], ["zhī"], ["tiān"], ["yè"]],
    "夹板气": [["jiā"], ["bǎn"], ["qì"]],
    "夹板医驼子": [["jiá"], ["bǎn"], ["yī"], ["tuó"], ["zǐ"]],
    "夹层玻璃": [["jiā"], ["céng"], ["bō"], ["li"]],
    "夹袋人物": [["jiā"], ["dài"], ["rén"], ["wù"]],
    "夹七夹八": [["jiā"], ["qī"], ["jiā"], ["bā"]],
    "夹枪带棒": [["jiā"], ["qiāng"], ["dài"], ["bàng"]],
    "夹生饭": [["jiā"], ["shēng"], ["fàn"]],
    "夹枪带棍": [["jiā"], ["qiāng"], ["dài"], ["gùn"]],
    "夹竹桃": [["jiā"], ["zhú"], ["táo"]],
    "佳兵不祥": [["jiā"], ["bīng"], ["bù"], ["xiáng"]],
    "佳人薄命": [["jiā"], ["rén"], ["bó"], ["mìng"]],
    "浃背汗流": [["jiā"], ["bèi"], ["hàn"], ["liú"]],
    "家败人亡": [["jiā"], ["bài"], ["rén"], ["wáng"]],
    "家藏户有": [["jiā"], ["cáng"], ["hù"], ["yǒu"]],
    "家长礼短": [["jiā"], ["cháng"], ["lǐ"], ["duǎn"]],
    "家长里短": [["jiā"], ["cháng"], ["lǐ"], ["duǎn"]],
    "家长制": [["jiā"], ["zhǎng"], ["zhì"]],
    "家常便饭": [["jiā"], ["cháng"], ["biàn"], ["fàn"]],
    "家常茶饭": [["jiā"], ["cháng"], ["chá"], ["fàn"]],
    "家常饭": [["jiā"], ["cháng"], ["fàn"]],
    "家常话": [["jiā"], ["cháng"], ["huà"]],
    "家常里短": [["jiā"], ["cháng"], ["lǐ"], ["duǎn"]],
    "家成业就": [["jiā"], ["chéng"], ["yè"], ["jiù"]],
    "家丑不可外谈": [["jiā"], ["chǒu"], ["bù"], ["kě"], ["wài"], ["tán"]],
    "家丑不可外扬": [["jiā"], ["chǒu"], ["bù"], ["kě"], ["wài"], ["yáng"]],
    "家传户诵": [["jiā"], ["chuán"], ["hù"], ["sòng"]],
    "家传户颂": [["jiā"], ["chuán"], ["hù"], ["sòng"]],
    "家传人诵": [["jiā"], ["chuán"], ["rén"], ["sòng"]],
    "家道从容": [["jiā"], ["dào"], ["cōng"], ["róng"]],
    "家道消乏": [["jiā"], ["dào"], ["xiāo"], ["fá"]],
    "家道中落": [["jiā"], ["dào"], ["zhōng"], ["luò"]],
    "家道小康": [["jiā"], ["dào"], ["xiǎo"], ["kāng"]],
    "家翻宅乱": [["jiā"], ["fān"], ["zhái"], ["luàn"]],
    "家反宅乱": [["jiā"], ["fǎn"], ["zhái"], ["luàn"]],
    "家烦宅乱": [["jiā"], ["fán"], ["zhái"], ["luàn"]],
    "家给民足": [["jiā"], ["jǐ"], ["mín"], ["zú"]],
    "家给人足": [["jiā"], ["jǐ"], ["rén"], ["zú"]],
    "家鸡野鹜": [["jiā"], ["jī"], ["yě"], ["wù"]],
    "家鸡野雉": [["jiā"], ["jī"], ["yě"], ["zhì"]],
    "家骥人璧": [["jiā"], ["jì"], ["rén"], ["bì"]],
    "家家户户": [["jiā"], ["jiā"], ["hù"], ["hù"]],
    "家见户说": [["jiā"], ["jiàn"], ["hù"], ["shuō"]],
    "家累千金": [["jiā"], ["lèi"], ["qiān"], ["jīn"]],
    "家贫如洗": [["jiā"], ["pín"], ["rú"], ["xǐ"]],
    "家贫亲老": [["jiā"], ["pín"], ["qīn"], ["lǎo"]],
    "家破人离": [["jiā"], ["pò"], ["rén"], ["lí"]],
    "家破人亡": [["jiā"], ["pò"], ["rén"], ["wáng"]],
    "家破身亡": [["jiā"], ["pò"], ["shēn"], ["wáng"]],
    "家雀儿": [["jiā"], ["qiǎo"], ["ér"]],
    "家散人亡": [["jiā"], ["sàn"], ["rén"], ["wáng"]],
    "家书抵万金": [["jiā"], ["shū"], ["dǐ"], ["wàn"], ["jīn"]],
    "家天下": [["jiā"], ["tiān"], ["xià"]],
    "家庭妇女": [["jiā"], ["tíng"], ["fù"], ["nǚ"]],
    "家庭副业": [["jiā"], ["tíng"], ["fù"], ["yè"]],
    "家庭教师": [["jiā"], ["tíng"], ["jiào"], ["shī"]],
    "家徒壁立": [["jiā"], ["tú"], ["bì"], ["lì"]],
    "家徒四壁": [["jiā"], ["tú"], ["sì"], ["bì"]],
    "家亡国破": [["jiā"], ["wáng"], ["guó"], ["pò"]],
    "家无常礼": [["jiā"], ["wú"], ["cháng"], ["lǐ"]],
    "家无担石": [["jiā"], ["wú"], ["dàn"], ["shí"]],
    "家无儋石": [["jiā"], ["wú"], ["dàn"], ["shí"]],
    "家无斗储": [["jiā"], ["wú"], ["dòu"], ["chǔ"]],
    "家无二主": [["jiā"], ["wú"], ["èr"], ["zhǔ"]],
    "家务活": [["jiā"], ["wù"], ["huó"]],
    "家务事": [["jiā"], ["wù"], ["shì"]],
    "家弦户诵": [["jiā"], ["xián"], ["hù"], ["sòng"]],
    "家学渊源": [["jiā"], ["xué"], ["yuān"], ["yuán"]],
    "家殷人足": [["jiā"], ["yīn"], ["rén"], ["zú"]],
    "家用电器": [["jiā"], ["yòng"], ["diàn"], ["qì"]],
    "家谕户晓": [["jiā"], ["yù"], ["hù"], ["xiǎo"]],
    "家喻户习": [["jiā"], ["yù"], ["hù"], ["xí"]],
    "家喻户晓": [["jiā"], ["yù"], ["hù"], ["xiǎo"]],
    "家贼难防": [["jiā"], ["zéi"], ["nán"], ["fáng"]],
    "家至户到": [["jiā"], ["zhì"], ["hù"], ["dào"]],
    "家至户察": [["jiā"], ["zhì"], ["hù"], ["chá"]],
    "家至户晓": [["jiā"], ["zhì"], ["hù"], ["xiǎo"]],
    "家至人说": [["jiā"], ["zhì"], ["rén"], ["shuō"]],
    "葭莩之亲": [["jiā"], ["fú"], ["zhī"], ["qīn"]],
    "嘉兴市": [["jiā"], ["xīng"], ["shì"]],
    "嘉言善行": [["jiā"], ["yán"], ["shàn"], ["xíng"]],
    "嘉言懿行": [["jiā"], ["yán"], ["yì"], ["xíng"]],
    "颊上三毫": [["jiá"], ["shàng"], ["sān"], ["háo"]],
    "颊上三毛": [["jiá"], ["shàng"], ["sān"], ["máo"]],
    "颊上添毫": [["jiá"], ["shàng"], ["tiān"], ["háo"]],
    "甲骨文": [["jiǎ"], ["gǔ"], ["wén"]],
    "甲冠天下": [["jiǎ"], ["guàn"], ["tiān"], ["xià"]],
    "价等连城": [["jià"], ["děng"], ["lián"], ["chéng"]],
    "价廉物美": [["jià"], ["lián"], ["wù"], ["měi"]],
    "价增一顾": [["jià"], ["zēng"], ["yī"], ["gù"]],
    "价值规律": [["jià"], ["zhí"], ["guī"], ["lǜ"]],
    "价值连城": [["jià"], ["zhí"], ["lián"], ["chéng"]],
    "架不住": [["jià"], ["bú"], ["zhù"]],
    "架谎凿空": [["jià"], ["huǎng"], ["záo"], ["kōng"]],
    "架子车": [["jià"], ["zi"], ["chē"]],
    "假痴假呆": [["jiǎ"], ["chī"], ["jiǎ"], ["dāi"]],
    "假痴不癫": [["jiǎ"], ["chī"], ["bù"], ["diān"]],
    "假慈悲": [["jiǎ"], ["cí"], ["bēi"]],
    "假道灭虢": [["jiǎ"], ["dào"], ["miè"], ["guó"]],
    "假分数": [["jiǎ"], ["fēn"], ["shù"]],
    "假公济私": [["jiǎ"], ["gōng"], ["jì"], ["sī"]],
    "假虎张威": [["jiǎ"], ["hǔ"], ["zhāng"], ["wēi"]],
    "假公营私": [["jiǎ"], ["gōng"], ["yíng"], ["sī"]],
    "假力于人": [["jiǎ"], ["lì"], ["yú"], ["rén"]],
    "假眉三道": [["jiǎ"], ["méi"], ["sān"], ["dào"]],
    "假门假氏": [["jiǎ"], ["mén"], ["jiǎ"], ["shì"]],
    "假门假事": [["jiǎ"], ["mén"], ["jiǎ"], ["shì"]],
    "假名托姓": [["jiǎ"], ["míng"], ["tuō"], ["xìng"]],
    "假人辞色": [["jiǎ"], ["rén"], ["cí"], ["sè"]],
    "假人假义": [["jiǎ"], ["rén"], ["jiǎ"], ["yì"]],
    "假仁假义": [["jiǎ"], ["rén"], ["jiǎ"], ["yì"]],
    "假仁假意": [["jiǎ"], ["rén"], ["jiǎ"], ["yì"]],
    "假手于人": [["jiǎ"], ["shǒu"], ["yú"], ["rén"]],
    "假途灭虢": [["jiǎ"], ["tú"], ["miè"], ["guó"]],
    "假戏真做": [["jiǎ"], ["xì"], ["zhēn"], ["zuò"]],
    "假惺惺": [["jiǎ"], ["xīng"], ["xīng"]],
    "假洋鬼子": [["jiǎ"], ["yáng"], ["guǐ"], ["zi"]],
    "假以辞色": [["jiǎ"], ["yǐ"], ["cí"], ["sè"]],
    "假誉驰声": [["jiǎ"], ["yù"], ["chí"], ["shēng"]],
    "稼穑艰难": [["jià"], ["sè"], ["jiān"], ["nán"]],
    "尖担两头脱": [["jiān"], ["dàn"], ["liǎng"], ["tóu"], ["tuō"]],
    "尖溜溜": [["jiān"], ["liū"], ["liū"]],
    "尖酸刻薄": [["jiān"], ["suān"], ["kè"], ["bó"]],
    "尖言尖语": [["jiān"], ["yán"], ["jiān"], ["yǔ"]],
    "尖言冷语": [["jiān"], ["yán"], ["lěng"], ["yǔ"]],
    "尖嘴薄舌": [["jiān"], ["zuǐ"], ["bó"], ["shé"]],
    "坚不可摧": [["jiān"], ["bù"], ["kě"], ["cuī"]],
    "坚持不懈": [["jiān"], ["chí"], ["bù"], ["xiè"]],
    "坚持不渝": [["jiān"], ["chí"], ["bù"], ["yú"]],
    "坚定不移": [["jiān"], ["dìng"], ["bù"], ["yí"]],
    "坚强不屈": [["jiān"], ["qiáng"], ["bù"], ["qū"]],
    "坚忍不拔": [["jiān"], ["rěn"], ["bù"], ["bá"]],
    "坚韧不拔": [["jiān"], ["rèn"], ["bù"], ["bá"]],
    "坚如盘石": [["jiān"], ["rú"], ["pán"], ["shí"]],
    "坚如磐石": [["jiān"], ["rú"], ["pán"], ["shí"]],
    "坚守不渝": [["jiān"], ["shǒu"], ["bù"], ["yú"]],
    "坚贞不屈": [["jiān"], ["zhēn"], ["bù"], ["qū"]],
    "坚贞不渝": [["jiān"], ["zhēn"], ["bù"], ["yú"]],
    "坚执不从": [["jiān"], ["zhí"], ["bù"], ["cóng"]],
    "间不容发": [["jiān"], ["bù"], ["róng"], ["fà"]],
    "间不容缓": [["jiān"], ["bù"], ["róng"], ["huǎn"]],
    "间不容缕": [["jiān"], ["bù"], ["róng"], ["lǚ"]],
    "间不容砺": [["jiān"], ["bù"], ["róng"], ["lì"]],
    "间不容瞚": [["jiān"], ["bù"], ["róng"], ["xǐ"]],
    "间不容瞬": [["jiān"], ["bù"], ["róng"], ["shùn"]],
    "间不容息": [["jiàn"], ["bù"], ["róng"], ["xī"]],
    "间见层出": [["jiàn"], ["xiàn"], ["céng"], ["chū"]],
    "间奏曲": [["jiàn"], ["zòu"], ["qǔ"]],
    "肩背难望": [["jiān"], ["bèi"], ["nán"], ["wàng"]],
    "肩背相望": [["jiān"], ["bèi"], ["xiāng"], ["wàng"]],
    "肩从齿序": [["jiān"], ["cóng"], ["chǐ"], ["xù"]],
    "肩胛骨": [["jiān"], ["jiǎ"], ["gǔ"]],
    "肩劳任怨": [["jiān"], ["láo"], ["rèn"], ["yuàn"]],
    "肩摩毂击": [["jiān"], ["mó"], ["gǔ"], ["jī"]],
    "肩摩毂接": [["jiān"], ["mó"], ["gū"], ["jiē"]],
    "肩摩袂接": [["jiān"], ["mó"], ["mèi"], ["jiē"]],
    "肩摩踵接": [["jiān"], ["mó"], ["zhǒng"], ["jiē"]],
    "艰苦创业": [["jiān"], ["kǔ"], ["chuàng"], ["yè"]],
    "艰苦奋斗": [["jiān"], ["kǔ"], ["fèn"], ["dòu"]],
    "艰苦朴素": [["jiān"], ["kǔ"], ["pǔ"], ["sù"]],
    "艰难竭蹶": [["jiān"], ["nán"], ["jié"], ["jué"]],
    "艰难曲折": [["jiān"], ["nán"], ["qū"], ["zhé"]],
    "艰难困苦": [["jiān"], ["nán"], ["kùn"], ["kǔ"]],
    "艰难险阻": [["jiān"], ["nán"], ["xiǎn"], ["zǔ"]],
    "艰难玉成": [["jiān"], ["nán"], ["yù"], ["chéng"]],
    "兼包并容": [["jiān"], ["bāo"], ["bìng"], ["róng"]],
    "兼包并畜": [["jiān"], ["bāo"], ["bìng"], ["chù"]],
    "兼而有之": [["jiān"], ["ér"], ["yǒu"], ["zhī"]],
    "兼程并进": [["jiān"], ["chéng"], ["bìng"], ["jìn"]],
    "兼官重绂": [["jiān"], ["guān"], ["zhòng"], ["fú"]],
    "兼容并包": [["jiān"], ["róng"], ["bìng"], ["bāo"]],
    "兼容并蓄": [["jiān"], ["róng"], ["bìng"], ["xù"]],
    "兼收并采": [["jiān"], ["shōu"], ["bìng"], ["cǎi"]],
    "兼收并录": [["jiān"], ["shōu"], ["bìng"], ["lù"]],
    "兼收并畜": [["jiān"], ["shōu"], ["bìng"], ["chù"]],
    "兼收并蓄": [["jiān"], ["shōu"], ["bìng"], ["xù"]],
    "兼收博采": [["jiān"], ["shōu"], ["bó"], ["cǎi"]],
    "兼听则明，偏信则暗": [["jiān"], ["tīng"], ["zé"], ["míng，piān"], ["xìn"], ["zé"], ["àn"]],
    "兼朱重紫": [["jiān"], ["zhū"], ["zhòng"], ["zǐ"]],
    "监护人": [["jiān"], ["hù"], ["rén"]],
    "监临自盗": [["jiān"], ["lín"], ["zì"], ["dào"]],
    "监市履狶": [["jiān"], ["shì"], ["lǚ"], ["xī"]],
    "监守自盗": [["jiān"], ["shǒu"], ["zì"], ["dào"]],
    "监主自盗": [["jiān"], ["zhǔ"], ["zì"], ["dào"]],
    "缄口不言": [["jiān"], ["kǒu"], ["bù"], ["yán"]],
    "缄口结舌": [["jiān"], ["kǒu"], ["jié"], ["shé"]],
    "蒹葭之思": [["jiān"], ["jiā"], ["zhī"], ["sī"]],
    "拣佛烧香": [["jiǎn"], ["fó"], ["shāo"], ["xiāng"]],
    "拣精择肥": [["jiǎn"], ["jīng"], ["zé"], ["féi"]],
    "俭故能广": [["jiǎn"], ["gù"], ["néng"], ["guǎng"]],
    "俭不中礼": [["jiǎn"], ["bù"], ["zhòng"], ["lǐ"]],
    "俭可养廉": [["jiǎn"], ["kě"], ["yǎng"], ["lián"]],
    "剪恶除奸": [["jiǎn"], ["è"], ["chú"], ["jiān"]],
    "剪发被褐": [["jiǎn"], ["fā"], ["bèi"], ["hè"]],
    "剪发杜门": [["jiǎn"], ["fà"], ["dù"], ["mén"]],
    "剪发披缁": [["jiǎn"], ["fā"], ["pī"], ["zī"]],
    "简单化": [["jiǎn"], ["dān"], ["huà"]],
    "简分数": [["jiǎn"], ["fēn"], ["shù"]],
    "简化汉字": [["jiǎn"], ["huà"], ["hàn"], ["zì"]],
    "简化字": [["jiǎn"], ["huà"], ["zì"]],
    "简捷了当": [["jiǎn"], ["jié"], ["liǎo"], ["dàng"]],
    "简截了当": [["jiǎn"], ["jié"], ["liǎo"], ["dàng"]],
    "简落狐狸": [["jiǎn"], ["luò"], ["hú"], ["lí"]],
    "简明扼要": [["jiǎn"], ["míng"], ["é"], ["yào"]],
    "简能而任": [["jiǎn"], ["néng"], ["ér"], ["rèn"]],
    "简切了当": [["jiǎn"], ["qiè"], ["liǎo"], ["dàng"]],
    "简丝数米": [["jiǎn"], ["sī"], ["shǔ"], ["mǐ"]],
    "简体字": [["jiǎn"], ["tǐ"], ["zì"]],
    "简贤任能": [["jiǎn"], ["xián"], ["rèn"], ["néng"]],
    "简要不烦": [["jiǎn"], ["yào"], ["bù"], ["fán"]],
    "简要清通": [["jiǎn"], ["yào"], ["qīng"], ["tōng"]],
    "简约详核": [["jiǎn"], ["yuē"], ["xiáng"], ["hé"]],
    "碱金属": [["jiǎn"], ["jīn"], ["shǔ"]],
    "蹇人上天": [["jiǎn"], ["rén"], ["shàng"], ["tiān"]],
    "见鞍思马": [["jiàn"], ["ān"], ["sī"], ["mǎ"]],
    "见不得": [["jiàn"], ["bù"], ["dé"]],
    "见财起意": [["jiàn"], ["cái"], ["qǐ"], ["yì"]],
    "见弹求鹗": [["jiàn"], ["dàn"], ["qiú"], ["è"]],
    "见弹求鸮": [["jiàn"], ["dàn"], ["qiú"], ["háo"]],
    "见多识广": [["jiàn"], ["duō"], ["shí"], ["guǎng"]],
    "见德思齐": [["jiàn"], ["dé"], ["sī"], ["qí"]],
    "见风使船": [["jiàn"], ["fēng"], ["shǐ"], ["chuán"]],
    "见风使舵": [["jiàn"], ["fēng"], ["shǐ"], ["duò"]],
    "见风使帆": [["jiàn"], ["fēng"], ["shǐ"], ["fān"]],
    "见风是雨": [["jiàn"], ["fēng"], ["shì"], ["yǔ"]],
    "见风转舵": [["jiàn"], ["fēng"], ["zhuǎn"], ["duò"]],
    "见风转篷": [["jiàn"], ["fēng"], ["zhuǎn"], ["péng"]],
    "见缝插针": [["jiàn"], ["fèng"], ["chā"], ["zhēn"]],
    "见缝就钻": [["jiàn"], ["fèng"], ["jiù"], ["zuān"]],
    "见羹见墙": [["jiàn"], ["gēng"], ["jiàn"], ["qiáng"]],
    "见怪不怪": [["jiàn"], ["guài"], ["bù"], ["guài"]],
    "见怪非怪": [["jiàn"], ["guài"], ["fēi"], ["guài"]],
    "见惯不惊": [["jiàn"], ["guàn"], ["bù"], ["jīng"]],
    "见惯司空": [["jiàn"], ["guàn"], ["sī"], ["kōng"]],
    "见机而作": [["jiàn"], ["jī"], ["ér"], ["zuò"]],
    "见机而行": [["jiàn"], ["jī"], ["ér"], ["xíng"]],
    "见机行事": [["jiàn"], ["jī"], ["xíng"], ["shì"]],
    "见几而作": [["jiàn"], ["jī"], ["ér"], ["zuò"]],
    "见幾而作": [["jiàn"], ["jī"], ["ér"], ["zuò"]],
    "见经识经": [["jiàn"], ["jīng"], ["shí"], ["jīng"]],
    "见精识精": [["jiàn"], ["jīng"], ["shí"], ["jīng"]],
    "见可而进": [["jiàn"], ["kě"], ["ér"], ["jìn"]],
    "见景生情": [["jiàn"], ["jǐng"], ["shēng"], ["qíng"]],
    "见哭兴悲": [["jiàn"], ["kū"], ["xīng"], ["bēi"]],
    "见棱见角": [["jiàn"], ["léng"], ["jiàn"], ["jiǎo"]],
    "见利思义": [["jiàn"], ["lì"], ["sī"], ["yì"]],
    "见猎心喜": [["jiàn"], ["liè"], ["xīn"], ["xǐ"]],
    "见利忘义": [["jiàn"], ["lì"], ["wàng"], ["yì"]],
    "见卵求鸡": [["jiàn"], ["luǎn"], ["qiú"], ["jī"]],
    "见马克思": [["jiàn"], ["mǎ"], ["kè"], ["sī"]],
    "见貌辨色": [["jiàn"], ["mào"], ["biàn"], ["sè"]],
    "见溺不救": [["jiàn"], ["nì"], ["bù"], ["jiù"]],
    "见面礼": [["jiàn"], ["miàn"], ["lǐ"]],
    "见其一未见其二": [["jiàn"], ["qí"], ["yī"], ["wèi"], ["jiàn"], ["qí"], ["èr"]],
    "见弃于人": [["jiàn"], ["qì"], ["yǔ"], ["rén"]],
    "见钱眼红": [["jiàn"], ["qián"], ["yǎn"], ["hóng"]],
    "见诮大方": [["jiàn"], ["qiào"], ["dà"], ["fāng"]],
    "见墙见羹": [["jiàn"], ["qiáng"], ["jiàn"], ["gēng"]],
    "见钱眼开": [["jiàn"], ["qián"], ["yǎn"], ["kāi"]],
    "见雀张罗": [["jiàn"], ["què"], ["zhāng"], ["luó"]],
    "见仁见智": [["jiàn"], ["rén"], ["jiàn"], ["zhì"]],
    "见善必迁": [["jiàn"], ["shàn"], ["bì"], ["qiān"]],
    "见上帝": [["jiàn"], ["shàng"], ["dì"]],
    "见神见鬼": [["jiàn"], ["shén"], ["jiàn"], ["guǐ"]],
    "见时知几": [["jiàn"], ["shí"], ["zhī"], ["jǐ"]],
    "见世面": [["xiàn"], ["shì"], ["miàn"]],
    "见豕负涂": [["jiàn"], ["shǐ"], ["fù"], ["tú"]],
    "见始知终": [["jiàn"], ["shǐ"], ["zhī"], ["zhōng"]],
    "见世生苗": [["jiàn"], ["shì"], ["shēng"], ["miáo"]],
    "见事风生": [["jiàn"], ["shì"], ["fēng"], ["shēng"]],
    "见事生风": [["jiàn"], ["shì"], ["shēng"], ["fēng"]],
    "见势不妙": [["jiàn"], ["shì"], ["bù"], ["miào"]],
    "见死不救": [["jiàn"], ["sǐ"], ["bù"], ["jiù"]],
    "见素抱朴": [["xiàn"], ["sù"], ["bào"], ["pǔ"]],
    "见所不见": [["jiàn"], ["suǒ"], ["bù"], ["jiàn"]],
    "见所未见": [["jiàn"], ["suǒ"], ["wèi"], ["jiàn"]],
    "见兔放鹰": [["jiàn"], ["tù"], ["fàng"], ["yīng"]],
    "见兔顾犬": [["jiàn"], ["tù"], ["gù"], ["quǎn"]],
    "见危授命": [["jiàn"], ["wēi"], ["shòu"], ["mìng"]],
    "见危致命": [["jiàn"], ["wēi"], ["zhì"], ["mìng"]],
    "见微知萌": [["jiàn"], ["wēi"], ["zhī"], ["méng"]],
    "见微知著": [["jiàn"], ["wēi"], ["zhī"], ["zhù"]],
    "见物不见人": [["jiàn"], ["wù"], ["bù"], ["jiàn"], ["rén"]],
    "见习生": [["jiàn"], ["xí"], ["shēng"]],
    "见贤思齐": [["jiàn"], ["xián"], ["sī"], ["qí"]],
    "见小暗大": [["jiàn"], ["xiǎo"], ["àn"], ["dà"]],
    "见笑大方": [["jiàn"], ["xiào"], ["dà"], ["fāng"]],
    "见性成佛": [["jiàn"], ["xìng"], ["chéng"], ["fó"]],
    "见阎王": [["jiàn"], ["yán"], ["wáng"]],
    "见噎废食": [["jiàn"], ["yē"], ["fèi"], ["shí"]],
    "见义必为": [["jiàn"], ["yì"], ["bì"], ["wéi"]],
    "见义当为": [["jiàn"], ["yì"], ["dāng"], ["wéi"]],
    "见义敢为": [["jiàn"], ["yì"], ["gǎn"], ["wéi"]],
    "见义勇为": [["jiàn"], ["yì"], ["yǒng"], ["wéi"]],
    "见异思迁": [["jiàn"], ["yì"], ["sī"], ["qiān"]],
    "见证人": [["jiàn"], ["zhèng"], ["rén"]],
    "见智见仁": [["jiàn"], ["zhì"], ["jiàn"], ["rén"]],
    "建筑面积": [["jiàn"], ["zhù"], ["miàn"], ["jī"]],
    "建筑物": [["jiàn"], ["zhù"], ["wù"]],
    "建筑学": [["jiàn"], ["zhù"], ["xué"]],
    "剑首一吷": [["jiàn"], ["shǒu"], ["yī"], ["guī"]],
    "贱骨头": [["jiàn"], ["gú"], ["tou"]],
    "剑头一吷": [["jiàn"], ["tóu"], ["yī"], ["xuè"]],
    "贱敛贵发": [["jiàn"], ["liǎn"], ["guì"], ["fā"]],
    "渐不可长": [["jiàn"], ["bù"], ["kě"], ["zhǎng"]],
    "渐入佳境": [["jiàn"], ["rù"], ["jiā"], ["jìng"]],
    "渐至佳境": [["jiàn"], ["zhì"], ["jiā"], ["jìng"]],
    "践土食毛": [["jiàn"], ["tǔ"], ["shí"], ["máo"]],
    "鉴机识变": [["jiàn"], ["jī"], ["shí"], ["biàn"]],
    "鉴空衡平": [["jiàn"], ["kōng"], ["héng"], ["píng"]],
    "鉴往知来": [["jiàn"], ["wǎng"], ["zhī"], ["lái"]],
    "鉴影度形": [["jiàn"], ["yǐng"], ["duó"], ["xíng"]],
    "键盘乐器": [["jiàn"], ["pán"], ["yuè"], ["qì"]],
    "箭不虚发": [["jiàn"], ["bù"], ["xū"], ["fā"]],
    "槛花笼鹤": [["jiàn"], ["huā"], ["lóng"], ["hè"]],
    "箭在弦上": [["jiàn"], ["zài"], ["xián"], ["shàng"]],
    "江东父老": [["jiāng"], ["dōng"], ["fù"], ["lǎo"]],
    "江翻海倒": [["jiāng"], ["fān"], ["hǎi"], ["dǎo"]],
    "江海不逆小流": [["jiāng"], ["hǎi"], ["bù"], ["nì"], ["xiǎo"], ["liú"]],
    "江汉朝宗": [["jiāng"], ["hàn"], ["cháo"], ["zōng"]],
    "江河行地": [["jiāng"], ["hé"], ["xíng"], ["dì"]],
    "江郎才尽": [["jiāng"], ["láng"], ["cái"], ["jìn"]],
    "江郎才掩": [["jiāng"], ["láng"], ["cái"], ["yǎn"]],
    "江南海北": [["jiāng"], ["nán"], ["hǎi"], ["běi"]],
    "江水不犯河水": [["jiāng"], ["shuǐ"], ["bù"], ["fàn"], ["hé"], ["shuǐ"]],
    "江苏省": [["jiāng"], ["sū"], ["shěng"]],
    "江淹才尽": [["jiāng"], ["yān"], ["cái"], ["jìn"]],
    "江洋大盗": [["jiāng"], ["yáng"], ["dà"], ["dào"]],
    "江泽民": [["jiāng"], ["zé"], ["mín"]],
    "江左夷吾": [["jiāng"], ["zuǒ"], ["yí"], ["wú"]],
    "将本求财": [["jiāng"], ["běn"], ["qiú"], ["cái"]],
    "将本求利": [["jiāng"], ["běn"], ["qiú"], ["lì"]],
    "将伯之呼": [["qiāng"], ["bó"], ["zhī"], ["hū"]],
    "将伯之助": [["qiāng"], ["bó"], ["zhī"], ["zhù"]],
    "将错就错": [["jiāng"], ["cuò"], ["jiù"], ["cuò"]],
    "将夺固与": [["jiāng"], ["duó"], ["gū"], ["yǔ"]],
    "将飞翼伏": [["jiāng"], ["fēi"], ["yì"], ["fú"]],
    "将功补过": [["jiāng"], ["gōng"], ["bǔ"], ["guò"]],
    "将功抵罪": [["jiāng"], ["gōng"], ["dǐ"], ["zuì"]],
    "将功赎罪": [["jiāng"], ["gōng"], ["shú"], ["zuì"]],
    "将功折过": [["jiāng"], ["gōng"], ["shé"], ["guò"]],
    "将功折罪": [["jiāng"], ["gōng"], ["zhé"], ["zuì"]],
    "将机就机": [["jiāng"], ["jī"], ["jiù"], ["jī"]],
    "将机就计": [["jiāng"], ["jī"], ["jiù"], ["jì"]],
    "将计就计": [["jiāng"], ["jì"], ["jiù"], ["jì"]],
    "将门虎子": [["jiàng"], ["mén"], ["hǔ"], ["zǐ"]],
    "将李代桃": [["jiāng"], ["lǐ"], ["dài"], ["táo"]],
    "将门无犬子": [["jiàng"], ["mén"], ["wú"], ["quǎn"], ["zǐ"]],
    "将门有将": [["jiàng"], ["mén"], ["yǒu"], ["jiàng"]],
    "将取固予": [["jiāng"], ["qǔ"], ["gū"], ["yǔ"]],
    "将勤补拙": [["jiāng"], ["qín"], ["bǔ"], ["zhuō"]],
    "将顺其美": [["jiāng"], ["shùn"], ["qí"], ["měi"]],
    "将天就地": [["jiāng"], ["tiān"], ["jiù"], ["dì"]],
    "将无作有": [["jiāng"], ["wú"], ["zuò"], ["yǒu"]],
    "将无做有": [["jiāng"], ["wú"], ["zuò"], ["yǒu"]],
    "将虾钓鳖": [["jiāng"], ["xiā"], ["diào"], ["biē"]],
    "将相之器": [["jiàng"], ["xiàng"], ["zhī"], ["qì"]],
    "将心比心": [["jiāng"], ["xīn"], ["bǐ"], ["xīn"]],
    "将信将疑": [["jiāng"], ["xìn"], ["jiāng"], ["yí"]],
    "将胸比肚": [["jiāng"], ["xiōng"], ["bǐ"], ["dù"]],
    "将遇良材": [["jiàng"], ["yù"], ["liáng"], ["cái"]],
    "浆酒霍肉": [["jiāng"], ["jiǔ"], ["huò"], ["ròu"]],
    "浆酒藿肉": [["jiāng"], ["jiǔ"], ["huò"], ["ròu"]],
    "浆水不交": [["jiāng"], ["shuǐ"], ["bù"], ["jiāo"]],
    "讲古论今": [["jiǎng"], ["gǔ"], ["lùn"], ["jīn"]],
    "讲价钱": [["jiǎng"], ["jià"], ["qián"]],
    "讲解员": [["jiǎng"], ["jiě"], ["yuán"]],
    "讲经说法": [["jiǎng"], ["jīng"], ["shuō"], ["fǎ"]],
    "讲是说非": [["jiǎng"], ["shì"], ["shuō"], ["fēi"]],
    "讲信修睦": [["jiǎng"], ["xìn"], ["xiū"], ["mù"]],
    "奖罚分明": [["jiǎng"], ["fá"], ["fēn"], ["míng"]],
    "匠石运金": [["jiàng"], ["shí"], ["yùn"], ["jīn"]],
    "降本流末": [["jiàng"], ["běn"], ["liú"], ["mò"]],
    "降格以求": [["jiàng"], ["gé"], ["yǐ"], ["qiú"]],
    "降贵纡尊": [["jiàng"], ["guì"], ["yū"], ["zūn"]],
    "降龙伏虎": [["xiáng"], ["lóng"], ["fú"], ["hǔ"]],
    "降落伞": [["jiàng"], ["luò"], ["sǎn"]],
    "降心顺俗": [["jiàng"], ["xīn"], ["shùn"], ["sú"]],
    "降心俯首": [["jiàng"], ["xīn"], ["fǔ"], ["shǒu"]],
    "降心下气": [["jiàng"], ["xīn"], ["xià"], ["qì"]],
    "降心相从": [["jiàng"], ["xīn"], ["xiāng"], ["cóng"]],
    "降颜屈体": [["jiàng"], ["yán"], ["qū"], ["tǐ"]],
    "降妖捉怪": [["xiáng"], ["yāo"], ["zhuō"], ["guài"]],
    "降雨量": [["jiàng"], ["yǔ"], ["liàng"]],
    "降志辱身": [["jiàng"], ["zhì"], ["rǔ"], ["shēn"]],
    "降尊临卑": [["jiàng"], ["zūn"], ["lín"], ["bēi"]],
    "降尊纡贵": [["jiàng"], ["zūn"], ["yū"], ["guì"]],
    "交白卷": [["jiāo"], ["bái"], ["juàn"]],
    "交臂失之": [["jiāo"], ["bì"], ["shī"], ["zhī"]],
    "交臂历指": [["jiāo"], ["bì"], ["lì"], ["zhǐ"]],
    "交臂相失": [["jiāo"], ["bì"], ["xiāng"], ["shī"]],
    "交叉点": [["jiāo"], ["chā"], ["diǎn"]],
    "交叉感染": [["jiāo"], ["chā"], ["gǎn"], ["rǎn"]],
    "交淡若水": [["jiāo"], ["dàn"], ["ruò"], ["shuǐ"]],
    "交换价值": [["jiāo"], ["huàn"], ["jià"], ["zhí"]],
    "交换台": [["jiāo"], ["huàn"], ["tái"]],
    "交颈并头": [["jiāo"], ["jǐng"], ["bìng"], ["tóu"]],
    "交口称誉": [["jiāo"], ["kǒu"], ["chēng"], ["yù"]],
    "交口称赞": [["jiāo"], ["kǒu"], ["chēng"], ["zàn"]],
    "交口同声": [["jiāo"], ["kǒu"], ["tóng"], ["shēng"]],
    "交能易作": [["jiāo"], ["néng"], ["yì"], ["zuò"]],
    "交浅言深": [["jiāo"], ["qiǎn"], ["yán"], ["shēn"]],
    "交通车": [["jiāo"], ["tōng"], ["chē"]],
    "交通员": [["jiāo"], ["tōng"], ["yuán"]],
    "交头互耳": [["jiāo"], ["tóu"], ["hù"], ["ěr"]],
    "交头接耳": [["jiāo"], ["tóu"], ["jiē"], ["ěr"]],
    "交相辉映": [["jiāo"], ["xiāng"], ["huī"], ["yìng"]],
    "交响乐": [["jiāo"], ["xiǎng"], ["yuè"]],
    "交响曲": [["jiāo"], ["xiǎng"], ["qǔ"]],
    "浇淳散朴": [["jiāo"], ["chún"], ["sàn"], ["pǔ"]],
    "浇醇散朴": [["jiāo"], ["chún"], ["sàn"], ["pǔ"]],
    "骄侈暴佚": [["jiāo"], ["chǐ"], ["bào"], ["yì"]],
    "浇风薄俗": [["jiāo"], ["fēng"], ["bó"], ["sú"]],
    "骄儿騃女": [["jiāo"], ["ér"], ["bā"], ["nǚ"]],
    "骄奢淫泆": [["jiāo"], ["shē"], ["yín"], ["yí"]],
    "骄泰淫泆": [["jiāo"], ["tai"], ["yín"], ["zhuàng"]],
    "骄佚奢淫": [["jiāo"], ["yì"], ["shē"], ["yín"]],
    "骄奢淫佚": [["jiāo"], ["shē"], ["yín"], ["yì"]],
    "胶鬲之困": [["jiāo"], ["gé"], ["zhī"], ["kùn"]],
    "胶合板": [["jiāo"], ["hé"], ["bǎn"]],
    "胶柱调瑟": [["jiāo"], ["zhù"], ["tiáo"], ["sè"]],
    "椒焚桂折": [["jiāo"], ["fén"], ["guì"], ["zhé"]],
    "焦熬投石": [["jiāo"], ["áo"], ["tóu"], ["shí"]],
    "焦唇干肺": [["jiāo"], ["chún"], ["gān"], ["fèi"]],
    "焦唇干舌": [["jiāo"], ["chún"], ["gàn"], ["shé"]],
    "焦金流石": [["jiāo"], ["jīn"], ["liú"], ["shí"]],
    "焦金烁石": [["jiāo"], ["jīn"], ["shuò"], ["shí"]],
    "焦圈儿": [["jiāo"], ["quān"], ["ér"]],
    "焦沙烂石": [["jiāo"], ["shā"], ["shí"], ["làn"]],
    "焦头烂额": [["jiāo"], ["tóu"], ["làn"], ["é"]],
    "焦思苦虑": [["jiāo"], ["sī"], ["kǔ"], ["lǜ"]],
    "焦心劳思": [["jiāo"], ["xīn"], ["láo"], ["sī"]],
    "焦心热中": [["jiāo"], ["xīn"], ["rè"], ["zhōng"]],
    "蛟龙得水": [["jiāo"], ["lóng"], ["dé"], ["shuǐ"]],
    "蛟龙戏水": [["jiāo"], ["lóng"], ["xì"], ["shuǐ"]],
    "燋头烂额": [["jiāo"], ["tóu"], ["làn"], ["é"]],
    "燋金烁石": [["jiāo"], ["jīn"], ["shuò"], ["shí"]],
    "鹪鹩一枝": [["jiāo"], ["liáo"], ["yī"], ["zhī"]],
    "角动量": [["jiǎo"], ["dòng"], ["liàng"]],
    "角户分门": [["jiǎo"], ["hù"], ["fēn"], ["mén"]],
    "角巾东路": [["jiǎo"], ["jīn"], ["dōng"], ["lù"]],
    "角巾私第": [["jiǎo"], ["jīn"], ["sī"], ["dì"]],
    "角立杰出": [["jiao"], ["li"], ["jie"], ["chu"]],
    "角膜炎": [["jiǎo"], ["mó"], ["yán"]],
    "角速度": [["jiǎo"], ["sù"], ["dù"]],
    "挢抂过正": [["jiǎo"], ["kuāng"], ["guò"], ["zhèng"]],
    "挢枉过正": [["jiǎo"], ["wǎng"], ["guò"], ["zhèng"]],
    "狡焉思逞": [["jiǎo"], ["yān"], ["sī"], ["chěng"]],
    "狡焉思启": [["jiǎo"], ["yān"], ["sī"], ["qǐ"]],
    "狡焉思肆": [["jiǎo"], ["yān"], ["sī"], ["sì"]],
    "绞尽脑汁": [["jiǎo"], ["jìn"], ["nǎo"], ["zhī"]],
    "皎阳似火": [["jiǎo"], ["yáng"], ["shì"], ["huǒ"]],
    "矫国革俗": [["jiǎo"], ["guó"], ["gé"], ["sú"]],
    "矫国更俗": [["jiǎo"], ["guó"], ["gēng"], ["sú"]],
    "矫矫不群": [["jiǎo"], ["jiǎo"], ["bù"], ["qùn"]],
    "矫情干誉": [["jiǎo"], ["qíng"], ["gān"], ["yù"]],
    "矫情饰貌": [["jiǎo"], ["qíng"], ["shì"], ["mào"]],
    "矫情饰行": [["jiǎo"], ["qíng"], ["shì"], ["xíng"]],
    "矫情饰诈": [["jiǎo"], ["qíng"], ["shì"], ["zhà"]],
    "矫情镇物": [["jiǎo"], ["qíng"], ["zhèn"], ["wù"]],
    "矫揉造作": [["jiǎo"], ["róu"], ["zào"], ["zuò"]],
    "矫若惊龙": [["jiǎo"], ["ruò"], ["jīng"], ["lóng"]],
    "矫若游龙": [["jiǎo"], ["ruò"], ["yóu"], ["lóng"]],
    "矫时慢物": [["jiǎo"], ["shí"], ["màn"], ["wù"]],
    "矫世变俗": [["jiǎo"], ["shì"], ["biàn"], ["sú"]],
    "矫世厉俗": [["jiǎo"], ["shì"], ["lì"], ["sú"]],
    "矫世励俗": [["jiǎo"], ["shì"], ["lì"], ["sú"]],
    "矫枉过当": [["jiǎo"], ["wǎng"], ["guò"], ["dāng"]],
    "矫枉过正": [["jiǎo"], ["wǎng"], ["guò"], ["zhèng"]],
    "矫枉过直": [["jiǎo"], ["wǎng"], ["guò"], ["zhí"]],
    "矫枉过中": [["jiǎo"], ["wǎng"], ["guò"], ["zhōng"]],
    "矫尾厉角": [["jiǎo"], ["wěi"], ["lì"], ["jiǎo"]],
    "矫邪归正": [["jiǎo"], ["xié"], ["guī"], ["zhèng"]],
    "矫言伪行": [["jiǎo"], ["yán"], ["wěi"], ["xíng"]],
    "脚不点地": [["jiǎo"], ["bù"], ["diǎn"], ["dì"]],
    "脚不沾地": [["jiǎo"], ["bù"], ["zhān"], ["dì"]],
    "脚踏实地": [["jiǎo"], ["tà"], ["shí"], ["dì"]],
    "脚踏两只船": [["jiǎo"], ["tà"], ["liǎng"], ["zhī"], ["chuán"]],
    "脚心朝天": [["jiǎo"], ["xīn"], ["cháo"], ["tiān"]],
    "搅拌机": [["jiǎo"], ["bàn"], ["jī"]],
    "叫苦不迭": [["jiào"], ["kǔ"], ["bù"], ["dié"]],
    "较短量长": [["jiào"], ["duǎn"], ["liáng"], ["cháng"]],
    "较德焯勤": [["jiào"], ["dé"], ["zhuō"], ["qín"]],
    "较长絜短": [["jiào"], ["cháng"], ["xié"], ["duǎn"]],
    "较短比长": [["jiào"], ["duǎn"], ["bǐ"], ["cháng"]],
    "较短絜长": [["jiào"], ["duǎn"], ["xié"], ["cháng"]],
    "较若画一": [["jiào"], ["ruò"], ["huà"], ["yī"]],
    "较瘦量肥": [["jiào"], ["shòu"], ["liàng"], ["féi"]],
    "较武论文": [["jiào"], ["wǔ"], ["lùn"], ["wén"]],
    "教导有方": [["jiào"], ["dǎo"], ["yǒu"], ["fāng"]],
    "教猱升木": [["jiāo"], ["náo"], ["shēng"], ["mù"]],
    "教无常师": [["jiào"], ["wú"], ["cháng"], ["shī"]],
    "教学相长": [["jiào"], ["xué"], ["xiāng"], ["zhǎng"]],
    "教一识百": [["jiāo"], ["yī"], ["shí"], ["bǎi"]],
    "教亦多术": [["jiào"], ["yì"], ["duō"], ["shù"]],
    "教育经济学": [["jiào"], ["yù"], ["jīng"], ["jì"], ["xué"]],
    "斠若画一": [["jiào"], ["ruò"], ["huà"], ["yī"]],
    "阶级斗争": [["jiē"], ["jí"], ["dòu"], ["zhēng"]],
    "阶级社会": [["jiē"], ["jí"], ["shè"], ["huì"]],
    "阶前万里": [["jiē"], ["qián"], ["wàn"], ["lǐ"]],
    "皆大欢喜": [["jiē"], ["dà"], ["huān"], ["xǐ"]],
    "接风洗尘": [["jiē"], ["fēng"], ["xǐ"], ["chén"]],
    "接连不断": [["jiē"], ["lián"], ["bù"], ["duàn"]],
    "嗟来之食": [["jiē"], ["lái"], ["zhī"], ["shí"]],
    "揭不开锅": [["jiē"], ["bù"], ["kāi"], ["guō"]],
    "揭地掀天": [["jiē"], ["dì"], ["xiān"], ["tiān"]],
    "揭竿而起": [["jiē"], ["gān"], ["ér"], ["qǐ"]],
    "揭老底": [["jiē"], ["lǎo"], ["dǐ"]],
    "揭盖子": [["jiē"], ["gài"], ["zi"]],
    "揭箧担囊": [["jiē"], ["qiè"], ["dān"], ["náng"]],
    "揭箧探囊": [["jiē"], ["qiè"], ["tàn"], ["náng"]],
    "街坊邻里": [["jiē"], ["fāng"], ["lín"], ["lǐ"]],
    "街坊四邻": [["jiē"], ["fāng"], ["sì"], ["lín"]],
    "街号巷哭": [["jiē"], ["hào"], ["xiàng"], ["kū"]],
    "街面儿上": [["jiē"], ["miàn"], ["ér"], ["shàng"]],
    "街谈巷说": [["jiē"], ["tán"], ["xiàng"], ["shuō"]],
    "街谈巷谚": [["jiē"], ["tán"], ["xiàng"], ["yàn"]],
    "街谈巷议": [["jiē"], ["tán"], ["xiàng"], ["yì"]],
    "街谈巷语": [["jiē"], ["tán"], ["xiàng"], ["yǔ"]],
    "街谭巷议": [["jiē"], ["tán"], ["xiàng"], ["yì"]],
    "街头剧": [["jiē"], ["tóu"], ["jù"]],
    "街头诗": [["jiē"], ["tóu"], ["shī"]],
    "街头巷底": [["jiē"], ["tóu"], ["xiàng"], ["dǐ"]],
    "街巷阡陌": [["jiē"], ["xiàng"], ["qiān"], ["mò"]],
    "街头巷尾": [["jiē"], ["tóu"], ["xiàng"], ["wěi"]],
    "节哀顺变": [["jié"], ["āi"], ["shùn"], ["biàn"]],
    "节度使": [["jié"], ["dù"], ["shǐ"]],
    "节骨眼": [["jiē"], ["gǔ"], ["yǎn"]],
    "节假日": [["jié"], ["jià"], ["rì"]],
    "节目单": [["jié"], ["mù"], ["dān"]],
    "节目主持人": [["jié"], ["mù"], ["zhǔ"], ["chí"], ["rén"]],
    "节外生枝": [["jié"], ["wài"], ["shēng"], ["zhī"]],
    "节衣缩食": [["jié"], ["yī"], ["suō"], ["shí"]],
    "节用裕民": [["jié"], ["yòng"], ["yù"], ["mín"]],
    "节用爱民": [["jié"], ["yòng"], ["ài"], ["mín"]],
    "节肢动物": [["jié"], ["zhī"], ["dòng"], ["wù"]],
    "节制资本": [["jié"], ["zhì"], ["zī"], ["běn"]],
    "节奏感": [["jié"], ["zòu"], ["gǎn"]],
    "劫富济贫": [["jié"], ["fù"], ["jì"], ["pín"]],
    "劫数难逃": [["jié"], ["shù"], ["nán"], ["táo"]],
    "诘曲聱牙": [["jié"], ["qǔ"], ["áo"], ["yá"]],
    "诘诎聱牙": [["jié"], ["qū"], ["áo"], ["yá"]],
    "诘屈磝碻": [["jié"], ["qū"], ["bìng"], ["zhòu"]],
    "诘屈聱牙": [["jié"], ["qū"], ["áo"], ["yá"]],
    "诘屈謷牙": [["jié"], ["qū"], ["dà"], ["yá"]],
    "诘戎治兵": [["jié"], ["róng"], ["zhì"], ["bīng"]],
    "洁己从公": [["jié"], ["jǐ"], ["cóng"], ["gōng"]],
    "洁身累行": [["jié"], ["shēn"], ["lèi"], ["xíng"]],
    "洁身自好": [["jié"], ["shēn"], ["zì"], ["hào"]],
    "结不解缘": [["jié"], ["bù"], ["jiě"], ["yuán"]],
    "结草衔环": [["jié"], ["cǎo"], ["xián"], ["huán"]],
    "结党营私": [["jié"], ["dǎng"], ["yíng"], ["sī"]],
    "结缔组织": [["jié"], ["dì"], ["zǔ"], ["zhī"]],
    "结发夫妻": [["jié"], ["fà"], ["fū"], ["qī"]],
    "结核病": [["jié"], ["hé"], ["bìng"]],
    "结核杆菌": [["jié"], ["hé"], ["gǎn"], ["jūn"]],
    "结婚证书": [["jié"], ["hūn"], ["zhèng"], ["shū"]],
    "结结巴巴": [["jiē"], ["jiē"], ["bā"], ["bā"]],
    "结晶体": [["jié"], ["jīng"], ["tǐ"]],
    "结膜炎": [["jié"], ["mó"], ["yán"]],
    "结舌杜口": [["jié"], ["shé"], ["dù"], ["kǒu"]],
    "结绳而治": [["jié"], ["shéng"], ["ér"], ["zhì"]],
    "结驷连骑": [["jié"], ["sì"], ["lián"], ["qí"]],
    "结束语": [["jié"], ["shù"], ["yǔ"]],
    "桀敖不驯": [["jié"], ["áo"], ["bù"], ["xùn"]],
    "桀傲不恭": [["jié"], ["ào"], ["bù"], ["gōng"]],
    "桀傲不驯": [["jié"], ["ào"], ["bù"], ["xùn"]],
    "桀骜不恭": [["jié"], ["ào"], ["bù"], ["gōng"]],
    "桀骜不驯": [["jié"], ["ào"], ["bù"], ["xùn"]],
    "桀骜不逊": [["jié"], ["ào"], ["bù"], ["xùn"]],
    "桀骜难驯": [["jié"], ["ào"], ["nán"], ["xùn"]],
    "捷报频传": [["jié"], ["bào"], ["pín"], ["chuán"]],
    "捷雷不及掩耳": [["jié"], ["léi"], ["bù"], ["jí"], ["yǎn"], ["ěr"]],
    "捷足先得": [["jié"], ["zú"], ["xiān"], ["dé"]],
    "截长补短": [["jié"], ["cháng"], ["bǔ"], ["duǎn"]],
    "截发留宾": [["jié"], ["fā"], ["liú"], ["bīn"]],
    "截发剉稾": [["jié"], ["fā"], ["cuò"], ["gǎo"]],
    "截然不同": [["jié"], ["rán"], ["bù"], ["tóng"]],
    "截铁斩钉": [["jié"], ["tiě"], ["zhǎn"], ["dìng"]],
    "竭诚相待": [["jié"], ["chéng"], ["xiāng"], ["dài"]],
    "竭诚尽节": [["jié"], ["chéng"], ["jìn"], ["jié"]],
    "竭尽全力": [["jié"], ["jìn"], ["quán"], ["lì"]],
    "竭尽心力": [["jié"], ["jìn"], ["xīn"], ["lì"]],
    "竭泽而渔": [["jié"], ["zé"], ["ér"], ["yú"]],
    "竭泽焚薮": [["jié"], ["zé"], ["fén"], ["sǒu"]],
    "竭智尽力": [["jié"], ["zhì"], ["jìn"], ["lì"]],
    "竭智尽忠": [["jié"], ["zhì"], ["jìn"], ["zhōng"]],
    "竭忠尽智": [["jié"], ["zhōng"], ["jìn"], ["zhì"]],
    "解兵释甲": [["jiě"], ["bīng"], ["shì"], ["jiǎ"]],
    "解骖推食": [["jiě"], ["cān"], ["tuī"], ["shí"]],
    "解发佯狂": [["jiě"], ["fà"], ["yáng"], ["kuáng"]],
    "解放军": [["jiě"], ["fàng"], ["jūn"]],
    "解放区": [["jiě"], ["fàng"], ["qū"]],
    "解放战争": [["jiě"], ["fàng"], ["zhàn"], ["zhēng"]],
    "解纷排难": [["jiě"], ["fēn"], ["pái"], ["nán"]],
    "解甲倒戈": [["jiě"], ["jiǎ"], ["dǎo"], ["gē"]],
    "解甲投戈": [["jiě"], ["jiǎ"], ["tóu"], ["gē"]],
    "解甲归田": [["jiě"], ["jiǎ"], ["guī"], ["tián"]],
    "解剑拜仇": [["jiě"], ["jiàn"], ["bài"], ["chóu"]],
    "解甲休士": [["jiě"], ["jiǎ"], ["xiū"], ["shì"]],
    "解甲休兵": [["jiě"], ["jiǎ"], ["xiū"], ["bīng"]],
    "解扣儿": [["jiě"], ["kòu"], ["ér"]],
    "解铃还是系铃人": [["jiě"], ["líng"], ["hái"], ["shì"], ["xì"], ["líng"], ["rén"]],
    "解铃还须系铃人": [["jiě"], ["líng"], ["hái"], ["xū"], ["xì"], ["líng"], ["rén"]],
    "解铃还需系铃人": [["jiě"], ["líng"], ["hái"], ["xū"], ["jì"], ["líng"], ["rén"]],
    "解铃系铃": [["jiě"], ["líng"], ["jì"], ["líng"]],
    "解铃须用系铃人": [["jiě"], ["líng"], ["xū"], ["yòng"], ["xì"], ["líng"], ["rén"]],
    "解囊相助": [["jiě"], ["náng"], ["xiāng"], ["zhù"]],
    "解民倒悬": [["jiě"], ["mín"], ["dào"], ["xuán"]],
    "解黏去缚": [["jiě"], ["nián"], ["qù"], ["fù"]],
    "解剖麻雀": [["jiě"], ["pōu"], ["má"], ["què"]],
    "解剖学": [["jiě"], ["pōu"], ["xué"]],
    "解剖室": [["jiě"], ["pōu"], ["shì"]],
    "解人难得": [["jiě"], ["rén"], ["nán"], ["dé"]],
    "解说词": [["jiě"], ["shuō"], ["cí"]],
    "解析几何": [["jiě"], ["xī"], ["jǐ"], ["hé"]],
    "解弦更张": [["jiě"], ["xián"], ["gēng"], ["zhāng"]],
    "解衣般礴": [["jiě"], ["yī"], ["bān"], ["bó"]],
    "解衣磅礴": [["jiě"], ["yī"], ["páng"], ["bó"]],
    "解衣包火": [["jiě"], ["yī"], ["bāo"], ["huǒ"]],
    "解衣抱火": [["jiě"], ["yī"], ["bào"], ["huǒ"]],
    "解衣盘磅": [["j