#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Oct 01 11:55:06 2015 by generateDS.py version 2.17a.
#
# Command line options:
#   ('-o', 'wof\\WaterML_1_1.py')
#
# Command line arguments:
#   test\cuahsiTimeSeries_v1_1.xsd
#
# Command line:
#   C:\Python27\Scripts\generateDS.py -o "wof\WaterML_1_1.py" test\cuahsiTimeSeries_v1_1.xsd
#
# Current working directory (os.getcwd()):
#   WOFpy
#

import sys
import re as re_
import base64
import datetime as datetime_
import warnings as warnings_
from lxml import etree as etree_


Validate_simpletypes_ = True


def parsexml_(infile, parser=None, **kwargs):
    if parser is None:
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        parser = etree_.ETCompatXMLParser()
    doc = etree_.parse(infile, parser=parser, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError as exp:

    class GeneratedsSuper(object):
        tzoff_pattern = re_.compile(r'(\+|-)((0\d|1[0-3]):[0-5]\d|14:00)$')
        class _FixedOffsetTZ(datetime_.tzinfo):
            def __init__(self, offset, name):
                self.__offset = datetime_.timedelta(minutes=offset)
                self.__name = name
            def utcoffset(self, dt):
                return self.__offset
            def tzname(self, dt):
                return self.__name
            def dst(self, dt):
                return None
        def gds_format_string(self, input_data, input_name=''):
            return input_data
        def gds_validate_string(self, input_data, node=None, input_name=''):
            if not input_data:
                return ''
            else:
                return input_data
        def gds_format_base64(self, input_data, input_name=''):
            return base64.b64encode(input_data)
        def gds_validate_base64(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def gds_validate_integer(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_integer_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    int(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of integers')
            return values
        def gds_format_float(self, input_data, input_name=''):
            return ('%.15f' % input_data).rstrip('0')
        def gds_validate_float(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_float_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of floats')
            return values
        def gds_format_double(self, input_data, input_name=''):
            #return '%e' % input_data
            return "{0}".format(input_data)
        def gds_validate_double(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_double_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    float(value)
                except (TypeError, ValueError):
                    raise_parse_error(node, 'Requires sequence of doubles')
            return values
        def gds_format_boolean(self, input_data, input_name=''):
            return ('%s' % input_data).lower()
        def gds_validate_boolean(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % ' '.join(input_data)
        def gds_validate_boolean_list(
                self, input_data, node=None, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(
                        node,
                        'Requires sequence of booleans '
                        '("true", "1", "false", "0")')
            return values
        def gds_validate_datetime(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_datetime(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%04d-%02d-%02dT%02d:%02d:%02d.%s' % (
                    input_data.year,
                    input_data.month,
                    input_data.day,
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        @classmethod
        def gds_parse_datetime(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            time_parts = input_data.split('.')
            if len(time_parts) > 1:
                micro_seconds = int(float('0.' + time_parts[1]) * 1000000)
                input_data = '%s.%s' % (time_parts[0], micro_seconds, )
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(
                    input_data, '%Y-%m-%dT%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt
        def gds_validate_date(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_date(self, input_data, input_name=''):
            _svalue = '%04d-%02d-%02d' % (
                input_data.year,
                input_data.month,
                input_data.day,
            )
            try:
                if input_data.tzinfo is not None:
                    tzoff = input_data.tzinfo.utcoffset(input_data)
                    if tzoff is not None:
                        total_seconds = tzoff.seconds + (86400 * tzoff.days)
                        if total_seconds == 0:
                            _svalue += 'Z'
                        else:
                            if total_seconds < 0:
                                _svalue += '-'
                                total_seconds *= -1
                            else:
                                _svalue += '+'
                            hours = total_seconds // 3600
                            minutes = (total_seconds - (hours * 3600)) // 60
                            _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            except AttributeError:
                pass
            return _svalue
        @classmethod
        def gds_parse_date(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            dt = datetime_.datetime.strptime(input_data, '%Y-%m-%d')
            dt = dt.replace(tzinfo=tz)
            return dt.date()
        def gds_validate_time(self, input_data, node=None, input_name=''):
            return input_data
        def gds_format_time(self, input_data, input_name=''):
            if input_data.microsecond == 0:
                _svalue = '%02d:%02d:%02d' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                )
            else:
                _svalue = '%02d:%02d:%02d.%s' % (
                    input_data.hour,
                    input_data.minute,
                    input_data.second,
                    ('%f' % (float(input_data.microsecond) / 1000000))[2:],
                )
            if input_data.tzinfo is not None:
                tzoff = input_data.tzinfo.utcoffset(input_data)
                if tzoff is not None:
                    total_seconds = tzoff.seconds + (86400 * tzoff.days)
                    if total_seconds == 0:
                        _svalue += 'Z'
                    else:
                        if total_seconds < 0:
                            _svalue += '-'
                            total_seconds *= -1
                        else:
                            _svalue += '+'
                        hours = total_seconds // 3600
                        minutes = (total_seconds - (hours * 3600)) // 60
                        _svalue += '{0:02d}:{1:02d}'.format(hours, minutes)
            return _svalue
        def gds_validate_simple_patterns(self, patterns, target):
            # pat is a list of lists of strings/patterns.  We should:
            # - AND the outer elements
            # - OR the inner elements
            found1 = True
            for patterns1 in patterns:
                found2 = False
                for patterns2 in patterns1:
                    if re_.search(patterns2, target) is not None:
                        found2 = True
                        break
                if not found2:
                    found1 = False
                    break
            return found1
        @classmethod
        def gds_parse_time(cls, input_data):
            tz = None
            if input_data[-1] == 'Z':
                tz = GeneratedsSuper._FixedOffsetTZ(0, 'UTC')
                input_data = input_data[:-1]
            else:
                results = GeneratedsSuper.tzoff_pattern.search(input_data)
                if results is not None:
                    tzoff_parts = results.group(2).split(':')
                    tzoff = int(tzoff_parts[0]) * 60 + int(tzoff_parts[1])
                    if results.group(1) == '-':
                        tzoff *= -1
                    tz = GeneratedsSuper._FixedOffsetTZ(
                        tzoff, results.group(0))
                    input_data = input_data[:-6]
            if len(input_data.split('.')) > 1:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S.%f')
            else:
                dt = datetime_.datetime.strptime(input_data, '%H:%M:%S')
            dt = dt.replace(tzinfo=tz)
            return dt.time()
        def gds_str_lower(self, instring):
            return instring.lower()
        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')
        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)
        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1
        def gds_build_any(self, node, type_name=None):
            return None
        @classmethod
        def gds_reverse_node_mapping(cls, mapping):
            return dict(((v, k) for k, v in mapping.iteritems()))


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'utf-8' #'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')
CDATA_pattern_ = re_.compile(r"<!\[CDATA\[.*?\]\]>", re_.DOTALL)

#
# Support/utility functions.
#


def showIndent(outfile, level, pretty_print=True):
    if pretty_print:
        for idx in range(level):
            outfile.write('    ')


def quote_xml(inStr):
    "Escape markup chars, but do not modify CDATA sections."
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s2 = ''
    pos = 0
    matchobjects = CDATA_pattern_.finditer(s1)
    for mo in matchobjects:
        s3 = s1[pos:mo.start()]
        s2 += quote_xml_aux(s3)
        s2 += s1[mo.start():mo.end()]
        pos = mo.end()
    s3 = s1[pos:]
    s2 += quote_xml_aux(s3)
    return s2


def quote_xml_aux(inStr):
    s1 = inStr.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    TypeBase64 = 8
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace, pretty_print=True):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name, pretty_print)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (
                self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeBase64:
            outfile.write('<%s>%s</%s>' % (
                self.name, base64.b64encode(self.value), self.name))
    def to_etree(self, element):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                if len(element) > 0:
                    if element[-1].tail is None:
                        element[-1].tail = self.value
                    else:
                        element[-1].tail += self.value
                else:
                    if element.text is None:
                        element.text = self.value
                    else:
                        element.text += self.value
        elif self.category == MixedContainer.CategorySimple:
            subelement = etree_.SubElement(element, '%s' % self.name)
            subelement.text = self.to_etree_simple()
        else:    # category == MixedContainer.CategoryComplex
            self.value.to_etree(element)
    def to_etree_simple(self):
        if self.content_type == MixedContainer.TypeString:
            text = self.value
        elif (self.content_type == MixedContainer.TypeInteger or
                self.content_type == MixedContainer.TypeBoolean):
            text = '%d' % self.value
        elif (self.content_type == MixedContainer.TypeFloat or
                self.content_type == MixedContainer.TypeDecimal):
            text = '%f' % self.value
        elif self.content_type == MixedContainer.TypeDouble:
            text = '%g' % self.value
        elif self.content_type == MixedContainer.TypeBase64:
            text = '%s' % base64.b64encode(self.value)
        return text
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s", "%s"),\n' % (
                    self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write(
                'model_.MixedContainer(%d, %d, "%s",\n' % (
                    self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class TsValuesSingleVariableType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, value=None, units=None, qualifier=None, qualityControlLevel=None, method=None, source=None, offset=None, sample=None, censorCode=None):
        self.original_tagname_ = None
        if value is None:
            self.value = []
        else:
            self.value = value
        self.units = units
        if qualifier is None:
            self.qualifier = []
        else:
            self.qualifier = qualifier
        if qualityControlLevel is None:
            self.qualityControlLevel = []
        else:
            self.qualityControlLevel = qualityControlLevel
        if method is None:
            self.method = []
        else:
            self.method = method
        if source is None:
            self.source = []
        else:
            self.source = source
        if offset is None:
            self.offset = []
        else:
            self.offset = offset
        if sample is None:
            self.sample = []
        else:
            self.sample = sample
        if censorCode is None:
            self.censorCode = []
        else:
            self.censorCode = censorCode
    def factory(*args_, **kwargs_):
        if TsValuesSingleVariableType.subclass:
            return TsValuesSingleVariableType.subclass(*args_, **kwargs_)
        else:
            return TsValuesSingleVariableType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def add_value(self, value): self.value.append(value)
    def insert_value_at(self, index, value): self.value.insert(index, value)
    def replace_value_at(self, index, value): self.value[index] = value
    def get_units(self): return self.units
    def set_units(self, units): self.units = units
    def get_qualifier(self): return self.qualifier
    def set_qualifier(self, qualifier): self.qualifier = qualifier
    def add_qualifier(self, value): self.qualifier.append(value)
    def insert_qualifier_at(self, index, value): self.qualifier.insert(index, value)
    def replace_qualifier_at(self, index, value): self.qualifier[index] = value
    def get_qualityControlLevel(self): return self.qualityControlLevel
    def set_qualityControlLevel(self, qualityControlLevel): self.qualityControlLevel = qualityControlLevel
    def add_qualityControlLevel(self, value): self.qualityControlLevel.append(value)
    def insert_qualityControlLevel_at(self, index, value): self.qualityControlLevel.insert(index, value)
    def replace_qualityControlLevel_at(self, index, value): self.qualityControlLevel[index] = value
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def add_method(self, value): self.method.append(value)
    def insert_method_at(self, index, value): self.method.insert(index, value)
    def replace_method_at(self, index, value): self.method[index] = value
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def add_source(self, value): self.source.append(value)
    def insert_source_at(self, index, value): self.source.insert(index, value)
    def replace_source_at(self, index, value): self.source[index] = value
    def get_offset(self): return self.offset
    def set_offset(self, offset): self.offset = offset
    def add_offset(self, value): self.offset.append(value)
    def insert_offset_at(self, index, value): self.offset.insert(index, value)
    def replace_offset_at(self, index, value): self.offset[index] = value
    def get_sample(self): return self.sample
    def set_sample(self, sample): self.sample = sample
    def add_sample(self, value): self.sample.append(value)
    def insert_sample_at(self, index, value): self.sample.insert(index, value)
    def replace_sample_at(self, index, value): self.sample[index] = value
    def get_censorCode(self): return self.censorCode
    def set_censorCode(self, censorCode): self.censorCode = censorCode
    def add_censorCode(self, value): self.censorCode.append(value)
    def insert_censorCode_at(self, index, value): self.censorCode.insert(index, value)
    def replace_censorCode_at(self, index, value): self.censorCode[index] = value
    def hasContent_(self):
        if (
            self.value or
            self.units is not None or
            self.qualifier or
            self.qualityControlLevel or
            self.method or
            self.source or
            self.offset or
            self.sample or
            self.censorCode
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TsValuesSingleVariableType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TsValuesSingleVariableType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TsValuesSingleVariableType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TsValuesSingleVariableType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TsValuesSingleVariableType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for value_ in self.value:
            value_.export(outfile, level, namespace_, name_='value', pretty_print=pretty_print)
        if self.units is not None:
            self.units.export(outfile, level, namespace_, name_='units', pretty_print=pretty_print)
        for qualifier_ in self.qualifier:
            qualifier_.export(outfile, level, namespace_, name_='qualifier', pretty_print=pretty_print)
        for qualityControlLevel_ in self.qualityControlLevel:
            qualityControlLevel_.export(outfile, level, namespace_, name_='qualityControlLevel', pretty_print=pretty_print)
        for method_ in self.method:
            method_.export(outfile, level, namespace_, name_='method', pretty_print=pretty_print)
        for source_ in self.source:
            source_.export(outfile, level, namespace_, name_='source', pretty_print=pretty_print)
        for offset_ in self.offset:
            offset_.export(outfile, level, namespace_, name_='offset', pretty_print=pretty_print)
        for sample_ in self.sample:
            sample_.export(outfile, level, namespace_, name_='sample', pretty_print=pretty_print)
        for censorCode_ in self.censorCode:
            censorCode_.export(outfile, level, namespace_, name_='censorCode', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'value':
            obj_ = ValueSingleVariable.factory()
            obj_.build(child_)
            self.value.append(obj_)
            obj_.original_tagname_ = 'value'
        elif nodeName_ == 'units':
            obj_ = UnitsType.factory()
            obj_.build(child_)
            self.units = obj_
            obj_.original_tagname_ = 'units'
        elif nodeName_ == 'qualifier':
            obj_ = QualifierType.factory()
            obj_.build(child_)
            self.qualifier.append(obj_)
            obj_.original_tagname_ = 'qualifier'
        elif nodeName_ == 'qualityControlLevel':
            obj_ = QualityControlLevelType.factory()
            obj_.build(child_)
            self.qualityControlLevel.append(obj_)
            obj_.original_tagname_ = 'qualityControlLevel'
        elif nodeName_ == 'method':
            obj_ = MethodType.factory()
            obj_.build(child_)
            self.method.append(obj_)
            obj_.original_tagname_ = 'method'
        elif nodeName_ == 'source':
            obj_ = SourceType.factory()
            obj_.build(child_)
            self.source.append(obj_)
            obj_.original_tagname_ = 'source'
        elif nodeName_ == 'offset':
            obj_ = OffsetType.factory()
            obj_.build(child_)
            self.offset.append(obj_)
            obj_.original_tagname_ = 'offset'
        elif nodeName_ == 'sample':
            obj_ = SampleType.factory()
            obj_.build(child_)
            self.sample.append(obj_)
            obj_.original_tagname_ = 'sample'
        elif nodeName_ == 'censorCode':
            obj_ = CensorCodeType.factory()
            obj_.build(child_)
            self.censorCode.append(obj_)
            obj_.original_tagname_ = 'censorCode'
# end class TsValuesSingleVariableType


class VariableInfoType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, metadataTime=None, oid=None, variableCode=None, variableName=None, variableDescription=None, valueType=None, dataType=None, generalCategory=None, sampleMedium=None, unit=None, options=None, note=None, related=None, extension=None, noDataValue=None, timeScale=None, speciation=None, categories=None, variableProperty=None):
        self.original_tagname_ = None
        if isinstance(metadataTime, basestring):
            initvalue_ = datetime_.datetime.strptime(metadataTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = metadataTime
        self.metadataTime = initvalue_
        self.oid = _cast(None, oid)
        if variableCode is None:
            self.variableCode = []
        else:
            self.variableCode = variableCode
        self.variableName = variableName
        self.variableDescription = variableDescription
        self.valueType = valueType
        self.validate_ValueTypeCodeList(self.valueType)
        self.dataType = dataType
        self.validate_DataTypeCodeList(self.dataType)
        self.generalCategory = generalCategory
        self.validate_GeneralCategoryCodeList(self.generalCategory)
        self.sampleMedium = sampleMedium
        self.validate_SampleMediumCodeList(self.sampleMedium)
        self.unit = unit
        self.options = options
        if note is None:
            self.note = []
        else:
            self.note = note
        self.related = related
        self.extension = extension
        self.noDataValue = noDataValue
        self.timeScale = timeScale
        self.speciation = speciation
        self.validate_SpeciationCodeList(self.speciation)
        self.categories = categories
        if variableProperty is None:
            self.variableProperty = []
        else:
            self.variableProperty = variableProperty
    def factory(*args_, **kwargs_):
        if VariableInfoType.subclass:
            return VariableInfoType.subclass(*args_, **kwargs_)
        else:
            return VariableInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_variableCode(self): return self.variableCode
    def set_variableCode(self, variableCode): self.variableCode = variableCode
    def add_variableCode(self, value): self.variableCode.append(value)
    def insert_variableCode_at(self, index, value): self.variableCode.insert(index, value)
    def replace_variableCode_at(self, index, value): self.variableCode[index] = value
    def get_variableName(self): return self.variableName
    def set_variableName(self, variableName): self.variableName = variableName
    def get_variableDescription(self): return self.variableDescription
    def set_variableDescription(self, variableDescription): self.variableDescription = variableDescription
    def get_valueType(self): return self.valueType
    def set_valueType(self, valueType): self.valueType = valueType
    def get_dataType(self): return self.dataType
    def set_dataType(self, dataType): self.dataType = dataType
    def get_generalCategory(self): return self.generalCategory
    def set_generalCategory(self, generalCategory): self.generalCategory = generalCategory
    def get_sampleMedium(self): return self.sampleMedium
    def set_sampleMedium(self, sampleMedium): self.sampleMedium = sampleMedium
    def get_unit(self): return self.unit
    def set_unit(self, unit): self.unit = unit
    def get_options(self): return self.options
    def set_options(self, options): self.options = options
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def add_note(self, value): self.note.append(value)
    def insert_note_at(self, index, value): self.note.insert(index, value)
    def replace_note_at(self, index, value): self.note[index] = value
    def get_related(self): return self.related
    def set_related(self, related): self.related = related
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def get_noDataValue(self): return self.noDataValue
    def set_noDataValue(self, noDataValue): self.noDataValue = noDataValue
    def get_timeScale(self): return self.timeScale
    def set_timeScale(self, timeScale): self.timeScale = timeScale
    def get_speciation(self): return self.speciation
    def set_speciation(self, speciation): self.speciation = speciation
    def get_categories(self): return self.categories
    def set_categories(self, categories): self.categories = categories
    def get_variableProperty(self): return self.variableProperty
    def set_variableProperty(self, variableProperty): self.variableProperty = variableProperty
    def add_variableProperty(self, value): self.variableProperty.append(value)
    def insert_variableProperty_at(self, index, value): self.variableProperty.insert(index, value)
    def replace_variableProperty_at(self, index, value): self.variableProperty[index] = value
    def get_metadataTime(self): return self.metadataTime
    def set_metadataTime(self, metadataTime): self.metadataTime = metadataTime
    def get_oid(self): return self.oid
    def set_oid(self, oid): self.oid = oid
    def validate_ValueTypeCodeList(self, value):
        # Validate type ValueTypeCodeList, a restriction on None.
        pass
    def validate_DataTypeCodeList(self, value):
        # Validate type DataTypeCodeList, a restriction on None.
        pass
    def validate_GeneralCategoryCodeList(self, value):
        # Validate type GeneralCategoryCodeList, a restriction on None.
        pass
    def validate_SampleMediumCodeList(self, value):
        # Validate type SampleMediumCodeList, a restriction on None.
        pass
    def validate_SpeciationCodeList(self, value):
        # Validate type SpeciationCodeList, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.variableCode or
            self.variableName is not None or
            self.variableDescription is not None or
            self.valueType is not None or
            self.dataType is not None or
            self.generalCategory is not None or
            self.sampleMedium is not None or
            self.unit is not None or
            self.options is not None or
            self.note or
            self.related is not None or
            self.extension is not None or
            self.noDataValue is not None or
            self.timeScale is not None or
            self.speciation is not None or
            self.categories is not None or
            self.variableProperty
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VariableInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VariableInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VariableInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VariableInfoType'):
        if self.metadataTime is not None and 'metadataTime' not in already_processed:
            already_processed.add('metadataTime')
            outfile.write(' metadataTime="%s"' % self.gds_format_datetime(self.metadataTime, input_name='metadataTime'))
        if self.oid is not None and 'oid' not in already_processed:
            already_processed.add('oid')
            outfile.write(' oid=%s' % (self.gds_format_string(quote_attrib(self.oid).encode(ExternalEncoding), input_name='oid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='VariableInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variableCode_ in self.variableCode:
            variableCode_.export(outfile, level, namespace_, name_='variableCode', pretty_print=pretty_print)
        if self.variableName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svariableName>%s</%svariableName>%s' % (namespace_, self.gds_format_string(quote_xml(self.variableName).encode(ExternalEncoding), input_name='variableName'), namespace_, eol_))
        if self.variableDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svariableDescription>%s</%svariableDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.variableDescription).encode(ExternalEncoding), input_name='variableDescription'), namespace_, eol_))
        if self.valueType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalueType>%s</%svalueType>%s' % (namespace_, self.gds_format_string(quote_xml(self.valueType).encode(ExternalEncoding), input_name='valueType'), namespace_, eol_))
        if self.dataType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataType>%s</%sdataType>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataType).encode(ExternalEncoding), input_name='dataType'), namespace_, eol_))
        if self.generalCategory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgeneralCategory>%s</%sgeneralCategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.generalCategory).encode(ExternalEncoding), input_name='generalCategory'), namespace_, eol_))
        if self.sampleMedium is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssampleMedium>%s</%ssampleMedium>%s' % (namespace_, self.gds_format_string(quote_xml(self.sampleMedium).encode(ExternalEncoding), input_name='sampleMedium'), namespace_, eol_))
        if self.unit is not None:
            self.unit.export(outfile, level, namespace_, name_='unit', pretty_print=pretty_print)
        if self.options is not None:
            self.options.export(outfile, level, namespace_, name_='options', pretty_print=pretty_print)
        for note_ in self.note:
            note_.export(outfile, level, namespace_, name_='note', pretty_print=pretty_print)
        if self.related is not None:
            self.related.export(outfile, level, namespace_, name_='related', pretty_print=pretty_print)
        if self.extension is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespace_, self.gds_format_string(quote_xml(self.extension).encode(ExternalEncoding), input_name='extension'), namespace_, eol_))
        if self.noDataValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snoDataValue>%s</%snoDataValue>%s' % (namespace_, self.gds_format_double(self.noDataValue, input_name='noDataValue'), namespace_, eol_))
        if self.timeScale is not None:
            self.timeScale.export(outfile, level, namespace_, name_='timeScale', pretty_print=pretty_print)
        if self.speciation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sspeciation>%s</%sspeciation>%s' % (namespace_, self.gds_format_string(quote_xml(self.speciation).encode(ExternalEncoding), input_name='speciation'), namespace_, eol_))
        if self.categories is not None:
            self.categories.export(outfile, level, namespace_, name_='categories', pretty_print=pretty_print)
        for variableProperty_ in self.variableProperty:
            variableProperty_.export(outfile, level, namespace_, name_='variableProperty', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('metadataTime', node)
        if value is not None and 'metadataTime' not in already_processed:
            already_processed.add('metadataTime')
            try:
                self.metadataTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (metadataTime): %s' % exp)
        value = find_attr_value_('oid', node)
        if value is not None and 'oid' not in already_processed:
            already_processed.add('oid')
            self.oid = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variableCode':
            obj_ = variableCodeType.factory()
            obj_.build(child_)
            self.variableCode.append(obj_)
            obj_.original_tagname_ = 'variableCode'
        elif nodeName_ == 'variableName':
            variableName_ = child_.text
            variableName_ = self.gds_validate_string(variableName_, node, 'variableName')
            self.variableName = variableName_
        elif nodeName_ == 'variableDescription':
            variableDescription_ = child_.text
            variableDescription_ = self.gds_validate_string(variableDescription_, node, 'variableDescription')
            self.variableDescription = variableDescription_
        elif nodeName_ == 'valueType':
            valueType_ = child_.text
            valueType_ = self.gds_validate_string(valueType_, node, 'valueType')
            self.valueType = valueType_
            # validate type ValueTypeCodeList
            self.validate_ValueTypeCodeList(self.valueType)
        elif nodeName_ == 'dataType':
            dataType_ = child_.text
            dataType_ = self.gds_validate_string(dataType_, node, 'dataType')
            self.dataType = dataType_
            # validate type DataTypeCodeList
            self.validate_DataTypeCodeList(self.dataType)
        elif nodeName_ == 'generalCategory':
            generalCategory_ = child_.text
            generalCategory_ = self.gds_validate_string(generalCategory_, node, 'generalCategory')
            self.generalCategory = generalCategory_
            # validate type GeneralCategoryCodeList
            self.validate_GeneralCategoryCodeList(self.generalCategory)
        elif nodeName_ == 'sampleMedium':
            sampleMedium_ = child_.text
            sampleMedium_ = self.gds_validate_string(sampleMedium_, node, 'sampleMedium')
            self.sampleMedium = sampleMedium_
            # validate type SampleMediumCodeList
            self.validate_SampleMediumCodeList(self.sampleMedium)
        elif nodeName_ == 'unit':
            obj_ = UnitsType.factory()
            obj_.build(child_)
            self.unit = obj_
            obj_.original_tagname_ = 'unit'
        elif nodeName_ == 'options':
            obj_ = options.factory()
            obj_.build(child_)
            self.options = obj_
            obj_.original_tagname_ = 'options'
        elif nodeName_ == 'note':
            obj_ = NoteType.factory()
            obj_.build(child_)
            self.note.append(obj_)
            obj_.original_tagname_ = 'note'
        elif nodeName_ == 'related':
            obj_ = relatedType.factory()
            obj_.build(child_)
            self.related = obj_
            obj_.original_tagname_ = 'related'
        elif nodeName_ == 'extension':
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, 'extension')
            self.extension = extension_
        elif nodeName_ == 'noDataValue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'noDataValue')
            self.noDataValue = fval_
        elif nodeName_ == 'timeScale':
            obj_ = timeScaleType.factory()
            obj_.build(child_)
            self.timeScale = obj_
            obj_.original_tagname_ = 'timeScale'
        elif nodeName_ == 'speciation':
            speciation_ = child_.text
            speciation_ = self.gds_validate_string(speciation_, node, 'speciation')
            self.speciation = speciation_
            # validate type SpeciationCodeList
            self.validate_SpeciationCodeList(self.speciation)
        elif nodeName_ == 'categories':
            obj_ = categoriesType.factory()
            obj_.build(child_)
            self.categories = obj_
            obj_.original_tagname_ = 'categories'
        elif nodeName_ == 'variableProperty':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.variableProperty.append(obj_)
            obj_.original_tagname_ = 'variableProperty'
# end class VariableInfoType


class options(GeneratedsSuper):
    """A list of options. Option elements are key-value pair elements that
    control how a variable maght be utilized in a service. Examples:
    MODIS web service. Information is aggreated over land or ocean
    or both. The plotarea option can include: plotarea=land,
    plotarea=land, plotarea=landocean USGS uses a statistic code,
    0003, to repesent a value type of 'Average'. The USGS statistic
    codes also several options that do not fit the ODM data model."""
    subclass = None
    superclass = None
    def __init__(self, option=None):
        self.original_tagname_ = None
        if option is None:
            self.option = []
        else:
            self.option = option
    def factory(*args_, **kwargs_):
        if options.subclass:
            return options.subclass(*args_, **kwargs_)
        else:
            return options(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_option(self): return self.option
    def set_option(self, option): self.option = option
    def add_option(self, value): self.option.append(value)
    def insert_option_at(self, index, value): self.option.insert(index, value)
    def replace_option_at(self, index, value): self.option[index] = value
    def hasContent_(self):
        if (
            self.option
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='options', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='options')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='options', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='options'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='options', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for option_ in self.option:
            option_.export(outfile, level, namespace_, name_='option', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'option':
            obj_ = option.factory()
            obj_.build(child_)
            self.option.append(obj_)
            obj_.original_tagname_ = 'option'
# end class options


class option(GeneratedsSuper):
    """Option elements are key-value pair elements that control how a
    variable maght be utilized in a service. Examples: MODIS web
    service. Information is aggreated over land or ocean or both.
    The plotarea option can include: plotarea=land, plotarea=land,
    plotarea=landocean USGS uses a statistic code, 0003, to repesent
    a value type of 'Average'. The USGS statistic codes also several
    options that do not fit the ODM data model."""
    subclass = None
    superclass = None
    def __init__(self, optionCode=None, optionID=None, name=None, valueOf_=None):
        self.original_tagname_ = None
        self.optionCode = _cast(None, optionCode)
        self.optionID = _cast(int, optionID)
        self.name = _cast(None, name)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if option.subclass:
            return option.subclass(*args_, **kwargs_)
        else:
            return option(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_optionCode(self): return self.optionCode
    def set_optionCode(self, optionCode): self.optionCode = optionCode
    def get_optionID(self): return self.optionID
    def set_optionID(self, optionID): self.optionID = optionID
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='option', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='option')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='option', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='option'):
        if self.optionCode is not None and 'optionCode' not in already_processed:
            already_processed.add('optionCode')
            outfile.write(' optionCode=%s' % (self.gds_format_string(quote_attrib(self.optionCode).encode(ExternalEncoding), input_name='optionCode'), ))
        if self.optionID is not None and 'optionID' not in already_processed:
            already_processed.add('optionID')
            outfile.write(' optionID="%s"' % self.gds_format_integer(self.optionID, input_name='optionID'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='option', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('optionCode', node)
        if value is not None and 'optionCode' not in already_processed:
            already_processed.add('optionCode')
            self.optionCode = value
            self.optionCode = ' '.join(self.optionCode.split())
        value = find_attr_value_('optionID', node)
        if value is not None and 'optionID' not in already_processed:
            already_processed.add('optionID')
            try:
                self.optionID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class option


class QueryInfoType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, creationTime=None, queryURL=None, criteria=None, note=None, extension=None):
        self.original_tagname_ = None
        if isinstance(creationTime, basestring):
            initvalue_ = datetime_.datetime.strptime(creationTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = creationTime
        self.creationTime = initvalue_
        self.queryURL = queryURL
        self.criteria = criteria
        if note is None:
            self.note = []
        else:
            self.note = note
        self.extension = extension
    def factory(*args_, **kwargs_):
        if QueryInfoType.subclass:
            return QueryInfoType.subclass(*args_, **kwargs_)
        else:
            return QueryInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_creationTime(self): return self.creationTime
    def set_creationTime(self, creationTime): self.creationTime = creationTime
    def get_queryURL(self): return self.queryURL
    def set_queryURL(self, queryURL): self.queryURL = queryURL
    def get_criteria(self): return self.criteria
    def set_criteria(self, criteria): self.criteria = criteria
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def add_note(self, value): self.note.append(value)
    def insert_note_at(self, index, value): self.note.insert(index, value)
    def replace_note_at(self, index, value): self.note[index] = value
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def hasContent_(self):
        if (
            self.creationTime is not None or
            self.queryURL is not None or
            self.criteria is not None or
            self.note or
            self.extension is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QueryInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QueryInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QueryInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QueryInfoType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='QueryInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.creationTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%screationTime>%s</%screationTime>%s' % (namespace_, self.gds_format_datetime(self.creationTime, input_name='creationTime'), namespace_, eol_))
        if self.queryURL is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squeryURL>%s</%squeryURL>%s' % (namespace_, self.gds_format_string(quote_xml(self.queryURL).encode(ExternalEncoding), input_name='queryURL'), namespace_, eol_))
        if self.criteria is not None:
            self.criteria.export(outfile, level, namespace_, name_='criteria', pretty_print=pretty_print)
        for note_ in self.note:
            note_.export(outfile, level, namespace_, name_='note', pretty_print=pretty_print)
        if self.extension is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespace_, self.gds_format_string(quote_xml(self.extension).encode(ExternalEncoding), input_name='extension'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'creationTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.creationTime = dval_
        elif nodeName_ == 'queryURL':
            queryURL_ = child_.text
            queryURL_ = self.gds_validate_string(queryURL_, node, 'queryURL')
            self.queryURL = queryURL_
        elif nodeName_ == 'criteria':
            obj_ = criteriaType.factory()
            obj_.build(child_)
            self.criteria = obj_
            obj_.original_tagname_ = 'criteria'
        elif nodeName_ == 'note':
            obj_ = NoteType.factory()
            obj_.build(child_)
            self.note.append(obj_)
            obj_.original_tagname_ = 'note'
        elif nodeName_ == 'extension':
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, 'extension')
            self.extension = extension_
# end class QueryInfoType


class TimeZoneType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, zoneOffset=None, zoneAbbreviation=None, extensiontype_=None):
        self.original_tagname_ = None
        self.zoneOffset = _cast(None, zoneOffset)
        self.zoneAbbreviation = _cast(None, zoneAbbreviation)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if TimeZoneType.subclass:
            return TimeZoneType.subclass(*args_, **kwargs_)
        else:
            return TimeZoneType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_zoneOffset(self): return self.zoneOffset
    def set_zoneOffset(self, zoneOffset): self.zoneOffset = zoneOffset
    def get_zoneAbbreviation(self): return self.zoneAbbreviation
    def set_zoneAbbreviation(self, zoneAbbreviation): self.zoneAbbreviation = zoneAbbreviation
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimeZoneType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeZoneType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimeZoneType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimeZoneType'):
        if self.zoneOffset is not None and 'zoneOffset' not in already_processed:
            already_processed.add('zoneOffset')
            outfile.write(' zoneOffset=%s' % (self.gds_format_string(quote_attrib(self.zoneOffset).encode(ExternalEncoding), input_name='zoneOffset'), ))
        if self.zoneAbbreviation is not None and 'zoneAbbreviation' not in already_processed:
            already_processed.add('zoneAbbreviation')
            outfile.write(' zoneAbbreviation=%s' % (self.gds_format_string(quote_attrib(self.zoneAbbreviation).encode(ExternalEncoding), input_name='zoneAbbreviation'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='TimeZoneType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('zoneOffset', node)
        if value is not None and 'zoneOffset' not in already_processed:
            already_processed.add('zoneOffset')
            self.zoneOffset = value
        value = find_attr_value_('zoneAbbreviation', node)
        if value is not None and 'zoneAbbreviation' not in already_processed:
            already_processed.add('zoneAbbreviation')
            self.zoneAbbreviation = value
            self.zoneAbbreviation = ' '.join(self.zoneAbbreviation.split())
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class TimeZoneType


class DocumentationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, show=None, href=None, type_=None, title=None, valueOf_=None, mixedclass_=None, content_=None):
        self.original_tagname_ = None
        self.show = _cast(None, show)
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.title = _cast(None, title)
        self.valueOf_ = valueOf_
        if mixedclass_ is None:
            self.mixedclass_ = MixedContainer
        else:
            self.mixedclass_ = mixedclass_
        if content_ is None:
            self.content_ = []
        else:
            self.content_ = content_
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if DocumentationType.subclass:
            return DocumentationType.subclass(*args_, **kwargs_)
        else:
            return DocumentationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_show(self): return self.show
    def set_show(self, show): self.show = show
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_DocumentationEnumTypes(self, value):
        # Validate type DocumentationEnumTypes, a restriction on xsi:token.
        pass
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DocumentationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DocumentationType')
        outfile.write('>')
        self.exportChildren(outfile, level + 1, namespace_, name_, pretty_print=pretty_print)
        outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DocumentationType'):
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (self.gds_format_string(quote_attrib(self.show).encode(ExternalEncoding), input_name='show'), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (quote_attrib(self.type_), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_format_string(quote_attrib(self.title).encode(ExternalEncoding), input_name='title'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='DocumentationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        if node.text is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', node.text)
            self.content_.append(obj_)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
            self.validate_DocumentationEnumTypes(self.type_)    # validate type DocumentationEnumTypes
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if not fromsubclass_ and child_.tail is not None:
            obj_ = self.mixedclass_(MixedContainer.CategoryText,
                MixedContainer.TypeNone, '', child_.tail)
            self.content_.append(obj_)
        pass
# end class DocumentationType


class SourceInfoType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, extensiontype_=None):
        self.original_tagname_ = None
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if SourceInfoType.subclass:
            return SourceInfoType.subclass(*args_, **kwargs_)
        else:
            return SourceInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SourceInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SourceInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SourceInfoType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SourceInfoType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SourceInfoType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class SourceInfoType


class TimePeriodType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, beginDateTime=None, endDateTime=None, beginDateTimeUTC=None, endDateTimeUTC=None, extensiontype_=None):
        self.original_tagname_ = None
        if isinstance(beginDateTime, basestring):
            initvalue_ = datetime_.datetime.strptime(beginDateTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = beginDateTime
        self.beginDateTime = initvalue_
        if isinstance(endDateTime, basestring):
            initvalue_ = datetime_.datetime.strptime(endDateTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endDateTime
        self.endDateTime = initvalue_
        if isinstance(beginDateTimeUTC, basestring):
            initvalue_ = datetime_.datetime.strptime(beginDateTimeUTC, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = beginDateTimeUTC
        self.beginDateTimeUTC = initvalue_
        if isinstance(endDateTimeUTC, basestring):
            initvalue_ = datetime_.datetime.strptime(endDateTimeUTC, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = endDateTimeUTC
        self.endDateTimeUTC = initvalue_
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if TimePeriodType.subclass:
            return TimePeriodType.subclass(*args_, **kwargs_)
        else:
            return TimePeriodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_beginDateTime(self): return self.beginDateTime
    def set_beginDateTime(self, beginDateTime): self.beginDateTime = beginDateTime
    def get_endDateTime(self): return self.endDateTime
    def set_endDateTime(self, endDateTime): self.endDateTime = endDateTime
    def get_beginDateTimeUTC(self): return self.beginDateTimeUTC
    def set_beginDateTimeUTC(self, beginDateTimeUTC): self.beginDateTimeUTC = beginDateTimeUTC
    def get_endDateTimeUTC(self): return self.endDateTimeUTC
    def set_endDateTimeUTC(self, endDateTimeUTC): self.endDateTimeUTC = endDateTimeUTC
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (
            self.beginDateTime is not None or
            self.endDateTime is not None or
            self.beginDateTimeUTC is not None or
            self.endDateTimeUTC is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimePeriodType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimePeriodType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimePeriodType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimePeriodType'):
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TimePeriodType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.beginDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbeginDateTime>%s</%sbeginDateTime>%s' % (namespace_, self.gds_format_datetime(self.beginDateTime, input_name='beginDateTime'), namespace_, eol_))
        if self.endDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendDateTime>%s</%sendDateTime>%s' % (namespace_, self.gds_format_datetime(self.endDateTime, input_name='endDateTime'), namespace_, eol_))
        if self.beginDateTimeUTC is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbeginDateTimeUTC>%s</%sbeginDateTimeUTC>%s' % (namespace_, self.gds_format_datetime(self.beginDateTimeUTC, input_name='beginDateTimeUTC'), namespace_, eol_))
        if self.endDateTimeUTC is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendDateTimeUTC>%s</%sendDateTimeUTC>%s' % (namespace_, self.gds_format_datetime(self.endDateTimeUTC, input_name='endDateTimeUTC'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'beginDateTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.beginDateTime = dval_
        elif nodeName_ == 'endDateTime':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.endDateTime = dval_
        elif nodeName_ == 'beginDateTimeUTC':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.beginDateTimeUTC = dval_
        elif nodeName_ == 'endDateTimeUTC':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.endDateTimeUTC = dval_
# end class TimePeriodType


class TimeIntervalType(TimePeriodType):
    subclass = None
    superclass = TimePeriodType
    def __init__(self, beginDateTime=None, endDateTime=None, beginDateTimeUTC=None, endDateTimeUTC=None):
        self.original_tagname_ = None
        super(TimeIntervalType, self).__init__(beginDateTime, endDateTime, beginDateTimeUTC, endDateTimeUTC, )
    def factory(*args_, **kwargs_):
        if TimeIntervalType.subclass:
            return TimeIntervalType.subclass(*args_, **kwargs_)
        else:
            return TimeIntervalType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(TimeIntervalType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimeIntervalType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeIntervalType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimeIntervalType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimeIntervalType'):
        super(TimeIntervalType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TimeIntervalType')
    def exportChildren(self, outfile, level, namespace_='', name_='TimeIntervalType', fromsubclass_=False, pretty_print=True):
        super(TimeIntervalType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TimeIntervalType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(TimeIntervalType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class TimeIntervalType


class TimeSingleType(TimePeriodType):
    subclass = None
    superclass = TimePeriodType
    def __init__(self, beginDateTime=None, endDateTime=None, beginDateTimeUTC=None, endDateTimeUTC=None, timeSingle=None):
        self.original_tagname_ = None
        super(TimeSingleType, self).__init__(beginDateTime, endDateTime, beginDateTimeUTC, endDateTimeUTC, )
        if isinstance(timeSingle, basestring):
            initvalue_ = datetime_.datetime.strptime(timeSingle, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = timeSingle
        self.timeSingle = initvalue_
    def factory(*args_, **kwargs_):
        if TimeSingleType.subclass:
            return TimeSingleType.subclass(*args_, **kwargs_)
        else:
            return TimeSingleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_timeSingle(self): return self.timeSingle
    def set_timeSingle(self, timeSingle): self.timeSingle = timeSingle
    def hasContent_(self):
        if (
            self.timeSingle is not None or
            super(TimeSingleType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimeSingleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeSingleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimeSingleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimeSingleType'):
        super(TimeSingleType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TimeSingleType')
    def exportChildren(self, outfile, level, namespace_='', name_='TimeSingleType', fromsubclass_=False, pretty_print=True):
        super(TimeSingleType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.timeSingle is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimeSingle>%s</%stimeSingle>%s' % (namespace_, self.gds_format_datetime(self.timeSingle, input_name='timeSingle'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TimeSingleType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'timeSingle':
            sval_ = child_.text
            dval_ = self.gds_parse_datetime(sval_)
            self.timeSingle = dval_
        super(TimeSingleType, self).buildChildren(child_, node, nodeName_, True)
# end class TimeSingleType


class TimePeriodRealTimeType(TimePeriodType):
    subclass = None
    superclass = TimePeriodType
    def __init__(self, beginDateTime=None, endDateTime=None, beginDateTimeUTC=None, endDateTimeUTC=None, realTimeDataPeriod=None):
        self.original_tagname_ = None
        super(TimePeriodRealTimeType, self).__init__(beginDateTime, endDateTime, beginDateTimeUTC, endDateTimeUTC, )
        self.realTimeDataPeriod = realTimeDataPeriod
    def factory(*args_, **kwargs_):
        if TimePeriodRealTimeType.subclass:
            return TimePeriodRealTimeType.subclass(*args_, **kwargs_)
        else:
            return TimePeriodRealTimeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_realTimeDataPeriod(self): return self.realTimeDataPeriod
    def set_realTimeDataPeriod(self, realTimeDataPeriod): self.realTimeDataPeriod = realTimeDataPeriod
    def hasContent_(self):
        if (
            self.realTimeDataPeriod is not None or
            super(TimePeriodRealTimeType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimePeriodRealTimeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimePeriodRealTimeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimePeriodRealTimeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimePeriodRealTimeType'):
        super(TimePeriodRealTimeType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='TimePeriodRealTimeType')
    def exportChildren(self, outfile, level, namespace_='', name_='TimePeriodRealTimeType', fromsubclass_=False, pretty_print=True):
        super(TimePeriodRealTimeType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.realTimeDataPeriod is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%srealTimeDataPeriod>%s</%srealTimeDataPeriod>%s' % (namespace_, self.gds_format_string(quote_xml(self.realTimeDataPeriod).encode(ExternalEncoding), input_name='realTimeDataPeriod'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(TimePeriodRealTimeType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'realTimeDataPeriod':
            realTimeDataPeriod_ = child_.text
            realTimeDataPeriod_ = self.gds_validate_string(realTimeDataPeriod_, node, 'realTimeDataPeriod')
            self.realTimeDataPeriod = realTimeDataPeriod_
        super(TimePeriodRealTimeType, self).buildChildren(child_, node, nodeName_, True)
# end class TimePeriodRealTimeType


class GeogLocationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, srs='EPSG:4326', extensiontype_=None):
        self.original_tagname_ = None
        self.srs = _cast(None, srs)
        self.extensiontype_ = extensiontype_
    def factory(*args_, **kwargs_):
        if GeogLocationType.subclass:
            return GeogLocationType.subclass(*args_, **kwargs_)
        else:
            return GeogLocationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_srs(self): return self.srs
    def set_srs(self, srs): self.srs = srs
    def get_extensiontype_(self): return self.extensiontype_
    def set_extensiontype_(self, extensiontype_): self.extensiontype_ = extensiontype_
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='GeogLocationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='GeogLocationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='GeogLocationType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='GeogLocationType'):
        if self.srs != "EPSG:4326" and 'srs' not in already_processed:
            already_processed.add('srs')
            outfile.write(' srs=%s' % (self.gds_format_string(quote_attrib(self.srs).encode(ExternalEncoding), input_name='srs'), ))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)
    def exportChildren(self, outfile, level, namespace_='', name_='GeogLocationType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('srs', node)
        if value is not None and 'srs' not in already_processed:
            already_processed.add('srs')
            self.srs = value
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.add('xsi:type')
            self.extensiontype_ = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class GeogLocationType


class LatLonPointType(GeogLocationType):
    subclass = None
    superclass = GeogLocationType
    def __init__(self, srs='EPSG:4326', latitude=None, longitude=None):
        self.original_tagname_ = None
        super(LatLonPointType, self).__init__(srs, )
        self.latitude = latitude
        self.validate_Latitude(self.latitude)
        self.longitude = longitude
        self.validate_Longitude(self.longitude)
    def factory(*args_, **kwargs_):
        if LatLonPointType.subclass:
            return LatLonPointType.subclass(*args_, **kwargs_)
        else:
            return LatLonPointType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_latitude(self): return self.latitude
    def set_latitude(self, latitude): self.latitude = latitude
    def get_longitude(self): return self.longitude
    def set_longitude(self, longitude): self.longitude = longitude
    def validate_Latitude(self, value):
        # Validate type Latitude, a restriction on xsi:double.
        if value is not None and Validate_simpletypes_:
            if float(value) < -90.00:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on Latitude' % {"value" : value} )
            if float(value) > 90.00:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on Latitude' % {"value" : value} )
    def validate_Longitude(self, value):
        # Validate type Longitude, a restriction on xsi:double.
        if value is not None and Validate_simpletypes_:
            if float(value) < -180.00:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on Longitude' % {"value" : value} )
            if float(value) > 180.00:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on Longitude' % {"value" : value} )
    def hasContent_(self):
        if (
            self.latitude is not None or
            self.longitude is not None or
            super(LatLonPointType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LatLonPointType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LatLonPointType')
        outfile.write(u' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(u' xsi:type="LatLonPointType"')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LatLonPointType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LatLonPointType'):
        super(LatLonPointType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LatLonPointType')
    def exportChildren(self, outfile, level, namespace_='', name_='LatLonPointType', fromsubclass_=False, pretty_print=True):
        super(LatLonPointType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.latitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatitude>%s</%slatitude>%s' % (namespace_, self.gds_format_double(self.latitude, input_name='latitude'), namespace_, eol_))
        if self.longitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slongitude>%s</%slongitude>%s' % (namespace_, self.gds_format_double(self.longitude, input_name='longitude'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LatLonPointType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'latitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'latitude')
            self.latitude = fval_
            # validate type Latitude
            self.validate_Latitude(self.latitude)
        elif nodeName_ == 'longitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'longitude')
            self.longitude = fval_
            # validate type Longitude
            self.validate_Longitude(self.longitude)
        super(LatLonPointType, self).buildChildren(child_, node, nodeName_, True)
# end class LatLonPointType


class LatLonBoxType(GeogLocationType):
    subclass = None
    superclass = GeogLocationType
    def __init__(self, srs='EPSG:4326', south=None, west=None, north=None, east=None):
        self.original_tagname_ = None
        super(LatLonBoxType, self).__init__(srs, )
        self.south = south
        self.validate_Latitude(self.south)
        self.west = west
        self.validate_Longitude(self.west)
        self.north = north
        self.validate_Latitude(self.north)
        self.east = east
        self.validate_Longitude(self.east)
    def factory(*args_, **kwargs_):
        if LatLonBoxType.subclass:
            return LatLonBoxType.subclass(*args_, **kwargs_)
        else:
            return LatLonBoxType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_south(self): return self.south
    def set_south(self, south): self.south = south
    def get_west(self): return self.west
    def set_west(self, west): self.west = west
    def get_north(self): return self.north
    def set_north(self, north): self.north = north
    def get_east(self): return self.east
    def set_east(self, east): self.east = east
    def validate_Latitude(self, value):
        # Validate type Latitude, a restriction on xsi:double.
        if value is not None and Validate_simpletypes_:
            if float(value) < -90.00:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on Latitude' % {"value" : value} )
            if float(value) > 90.00:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on Latitude' % {"value" : value} )
    def validate_Longitude(self, value):
        # Validate type Longitude, a restriction on xsi:double.
        if value is not None and Validate_simpletypes_:
            if float(value) < -180.00:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on Longitude' % {"value" : value} )
            if float(value) > 180.00:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on Longitude' % {"value" : value} )
    def hasContent_(self):
        if (
            self.south is not None or
            self.west is not None or
            self.north is not None or
            self.east is not None or
            super(LatLonBoxType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LatLonBoxType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LatLonBoxType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LatLonBoxType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LatLonBoxType'):
        super(LatLonBoxType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='LatLonBoxType')
    def exportChildren(self, outfile, level, namespace_='', name_='LatLonBoxType', fromsubclass_=False, pretty_print=True):
        super(LatLonBoxType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.south is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssouth>%s</%ssouth>%s' % (namespace_, self.gds_format_double(self.south, input_name='south'), namespace_, eol_))
        if self.west is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%swest>%s</%swest>%s' % (namespace_, self.gds_format_double(self.west, input_name='west'), namespace_, eol_))
        if self.north is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%snorth>%s</%snorth>%s' % (namespace_, self.gds_format_double(self.north, input_name='north'), namespace_, eol_))
        if self.east is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%seast>%s</%seast>%s' % (namespace_, self.gds_format_double(self.east, input_name='east'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(LatLonBoxType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'south':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'south')
            self.south = fval_
            # validate type Latitude
            self.validate_Latitude(self.south)
        elif nodeName_ == 'west':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'west')
            self.west = fval_
            # validate type Longitude
            self.validate_Longitude(self.west)
        elif nodeName_ == 'north':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'north')
            self.north = fval_
            # validate type Latitude
            self.validate_Latitude(self.north)
        elif nodeName_ == 'east':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'east')
            self.east = fval_
            # validate type Longitude
            self.validate_Longitude(self.east)
        super(LatLonBoxType, self).buildChildren(child_, node, nodeName_, True)
# end class LatLonBoxType


class latLonLineString(GeogLocationType):
    subclass = None
    superclass = GeogLocationType
    def __init__(self, srs='EPSG:4326', zDirection=None, coordLatLong=None):
        self.original_tagname_ = None
        super(latLonLineString, self).__init__(srs, )
        self.zDirection = _cast(None, zDirection)
        if coordLatLong is None:
            self.coordLatLong = []
        else:
            self.coordLatLong = coordLatLong
    def factory(*args_, **kwargs_):
        if latLonLineString.subclass:
            return latLonLineString.subclass(*args_, **kwargs_)
        else:
            return latLonLineString(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_coordLatLong(self): return self.coordLatLong
    def set_coordLatLong(self, coordLatLong): self.coordLatLong = coordLatLong
    def add_coordLatLong(self, value): self.coordLatLong.append(value)
    def insert_coordLatLong_at(self, index, value): self.coordLatLong.insert(index, value)
    def replace_coordLatLong_at(self, index, value): self.coordLatLong[index] = value
    def get_zDirection(self): return self.zDirection
    def set_zDirection(self, zDirection): self.zDirection = zDirection
    def hasContent_(self):
        if (
            self.coordLatLong or
            super(latLonLineString, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='latLonLineString', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='latLonLineString')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='latLonLineString', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='latLonLineString'):
        super(latLonLineString, self).exportAttributes(outfile, level, already_processed, namespace_, name_='latLonLineString')
        if self.zDirection is not None and 'zDirection' not in already_processed:
            already_processed.add('zDirection')
            outfile.write(' zDirection=%s' % (self.gds_format_string(quote_attrib(self.zDirection).encode(ExternalEncoding), input_name='zDirection'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='latLonLineString', fromsubclass_=False, pretty_print=True):
        super(latLonLineString, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for coordLatLong_ in self.coordLatLong:
            coordLatLong_.export(outfile, level, namespace_, name_='coordLatLong', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('zDirection', node)
        if value is not None and 'zDirection' not in already_processed:
            already_processed.add('zDirection')
            self.zDirection = value
        super(latLonLineString, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'coordLatLong':
            obj_ = CoordType.factory()
            obj_.build(child_)
            self.coordLatLong.append(obj_)
            obj_.original_tagname_ = 'coordLatLong'
        super(latLonLineString, self).buildChildren(child_, node, nodeName_, True)
# end class latLonLineString


class CoordType(GeneratedsSuper):
    """Represents a coordinate tuple in one, two, or three dimensions.
    ==============================================================
    There are two ways to represent coordinates: (1) as a sequence
    of &lt;coord> elements that encapsulate tuples, or (2) using a
    single &lt;coordinates> string. ================================
    ==================================="""
    subclass = None
    superclass = None
    def __init__(self, latitude=None, longitude=None, Z=None):
        self.original_tagname_ = None
        self.latitude = latitude
        self.validate_Latitude(self.latitude)
        self.longitude = longitude
        self.validate_Longitude(self.longitude)
        self.Z = Z
    def factory(*args_, **kwargs_):
        if CoordType.subclass:
            return CoordType.subclass(*args_, **kwargs_)
        else:
            return CoordType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_latitude(self): return self.latitude
    def set_latitude(self, latitude): self.latitude = latitude
    def get_longitude(self): return self.longitude
    def set_longitude(self, longitude): self.longitude = longitude
    def get_Z(self): return self.Z
    def set_Z(self, Z): self.Z = Z
    def validate_Latitude(self, value):
        # Validate type Latitude, a restriction on xsi:double.
        if value is not None and Validate_simpletypes_:
            if float(value) < -90.00:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on Latitude' % {"value" : value} )
            if float(value) > 90.00:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on Latitude' % {"value" : value} )
    def validate_Longitude(self, value):
        # Validate type Longitude, a restriction on xsi:double.
        if value is not None and Validate_simpletypes_:
            if float(value) < -180.00:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on Longitude' % {"value" : value} )
            if float(value) > 180.00:
                warnings_.warn('Value "%(value)s" does not match xsd maxInclusive restriction on Longitude' % {"value" : value} )
    def hasContent_(self):
        if (
            self.latitude is not None or
            self.longitude is not None or
            self.Z is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CoordType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CoordType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CoordType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CoordType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='CoordType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.latitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slatitude>%s</%slatitude>%s' % (namespace_, self.gds_format_double(self.latitude, input_name='latitude'), namespace_, eol_))
        if self.longitude is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slongitude>%s</%slongitude>%s' % (namespace_, self.gds_format_double(self.longitude, input_name='longitude'), namespace_, eol_))
        if self.Z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sZ>%s</%sZ>%s' % (namespace_, self.gds_format_float(self.Z, input_name='Z'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'latitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'latitude')
            self.latitude = fval_
            # validate type Latitude
            self.validate_Latitude(self.latitude)
        elif nodeName_ == 'longitude':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'longitude')
            self.longitude = fval_
            # validate type Longitude
            self.validate_Longitude(self.longitude)
        elif nodeName_ == 'Z':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Z')
            self.Z = fval_
# end class CoordType


class seriesCatalogType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, menuGroupName=None, serviceWsdl=None, note=None, series=None, seriesCatalogProperty=None, extension=None):
        self.original_tagname_ = None
        self.menuGroupName = _cast(None, menuGroupName)
        self.serviceWsdl = _cast(None, serviceWsdl)
        if note is None:
            self.note = []
        else:
            self.note = note
        if series is None:
            self.series = []
        else:
            self.series = series
        if seriesCatalogProperty is None:
            self.seriesCatalogProperty = []
        else:
            self.seriesCatalogProperty = seriesCatalogProperty
        self.extension = extension
    def factory(*args_, **kwargs_):
        if seriesCatalogType.subclass:
            return seriesCatalogType.subclass(*args_, **kwargs_)
        else:
            return seriesCatalogType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def add_note(self, value): self.note.append(value)
    def insert_note_at(self, index, value): self.note.insert(index, value)
    def replace_note_at(self, index, value): self.note[index] = value
    def get_series(self): return self.series
    def set_series(self, series): self.series = series
    def add_series(self, value): self.series.append(value)
    def insert_series_at(self, index, value): self.series.insert(index, value)
    def replace_series_at(self, index, value): self.series[index] = value
    def get_seriesCatalogProperty(self): return self.seriesCatalogProperty
    def set_seriesCatalogProperty(self, seriesCatalogProperty): self.seriesCatalogProperty = seriesCatalogProperty
    def add_seriesCatalogProperty(self, value): self.seriesCatalogProperty.append(value)
    def insert_seriesCatalogProperty_at(self, index, value): self.seriesCatalogProperty.insert(index, value)
    def replace_seriesCatalogProperty_at(self, index, value): self.seriesCatalogProperty[index] = value
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def get_menuGroupName(self): return self.menuGroupName
    def set_menuGroupName(self, menuGroupName): self.menuGroupName = menuGroupName
    def get_serviceWsdl(self): return self.serviceWsdl
    def set_serviceWsdl(self, serviceWsdl): self.serviceWsdl = serviceWsdl
    def hasContent_(self):
        if (
            self.note or
            self.series or
            self.seriesCatalogProperty or
            self.extension is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='seriesCatalogType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='seriesCatalogType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='seriesCatalogType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='seriesCatalogType'):
        if self.menuGroupName is not None and 'menuGroupName' not in already_processed:
            already_processed.add('menuGroupName')
            outfile.write(' menuGroupName=%s' % (self.gds_format_string(quote_attrib(self.menuGroupName).encode(ExternalEncoding), input_name='menuGroupName'), ))
        if self.serviceWsdl is not None and 'serviceWsdl' not in already_processed:
            already_processed.add('serviceWsdl')
            outfile.write(' serviceWsdl=%s' % (self.gds_format_string(quote_attrib(self.serviceWsdl).encode(ExternalEncoding), input_name='serviceWsdl'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='seriesCatalogType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for note_ in self.note:
            note_.export(outfile, level, namespace_, name_='note', pretty_print=pretty_print)
        for series_ in self.series:
            series_.export(outfile, level, namespace_, name_='series', pretty_print=pretty_print)
        for seriesCatalogProperty_ in self.seriesCatalogProperty:
            seriesCatalogProperty_.export(outfile, level, namespace_, name_='seriesCatalogProperty', pretty_print=pretty_print)
        if self.extension is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespace_, self.gds_format_string(quote_xml(self.extension).encode(ExternalEncoding), input_name='extension'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('menuGroupName', node)
        if value is not None and 'menuGroupName' not in already_processed:
            already_processed.add('menuGroupName')
            self.menuGroupName = value
        value = find_attr_value_('serviceWsdl', node)
        if value is not None and 'serviceWsdl' not in already_processed:
            already_processed.add('serviceWsdl')
            self.serviceWsdl = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'note':
            obj_ = NoteType.factory()
            obj_.build(child_)
            self.note.append(obj_)
            obj_.original_tagname_ = 'note'
        elif nodeName_ == 'series':
            obj_ = seriesType.factory()
            obj_.build(child_)
            self.series.append(obj_)
            obj_.original_tagname_ = 'series'
        elif nodeName_ == 'seriesCatalogProperty':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.seriesCatalogProperty.append(obj_)
            obj_.original_tagname_ = 'seriesCatalogProperty'
        elif nodeName_ == 'extension':
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, 'extension')
            self.extension = extension_
# end class seriesCatalogType


class QualifierType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, qualifierID=None, default=None, network=None, vocabulary=None, qualifierCode=None, qualifierDescription=None):
        self.original_tagname_ = None
        self.qualifierID = _cast(None, qualifierID)
        self.default = _cast(bool, default)
        self.network = _cast(None, network)
        self.vocabulary = _cast(None, vocabulary)
        self.qualifierCode = qualifierCode
        self.qualifierDescription = qualifierDescription
    def factory(*args_, **kwargs_):
        if QualifierType.subclass:
            return QualifierType.subclass(*args_, **kwargs_)
        else:
            return QualifierType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualifierCode(self): return self.qualifierCode
    def set_qualifierCode(self, qualifierCode): self.qualifierCode = qualifierCode
    def get_qualifierDescription(self): return self.qualifierDescription
    def set_qualifierDescription(self, qualifierDescription): self.qualifierDescription = qualifierDescription
    def get_qualifierID(self): return self.qualifierID
    def set_qualifierID(self, qualifierID): self.qualifierID = qualifierID
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_vocabulary(self): return self.vocabulary
    def set_vocabulary(self, vocabulary): self.vocabulary = vocabulary
    def validate_positiveInt(self, value):
        # Validate type positiveInt, a restriction on xsi:int.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on positiveInt' % {"value" : value} )
    def hasContent_(self):
        if (
            self.qualifierCode is not None or
            self.qualifierDescription is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QualifierType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QualifierType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QualifierType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QualifierType'):
        if self.qualifierID is not None and 'qualifierID' not in already_processed:
            already_processed.add('qualifierID')
            outfile.write(' qualifierID=%s' % (quote_attrib(self.qualifierID), ))
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.vocabulary is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            outfile.write(' vocabulary=%s' % (self.gds_format_string(quote_attrib(self.vocabulary).encode(ExternalEncoding), input_name='vocabulary'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='QualifierType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.qualifierCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squalifierCode>%s</%squalifierCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.qualifierCode).encode(ExternalEncoding), input_name='qualifierCode'), namespace_, eol_))
        if self.qualifierDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squalifierDescription>%s</%squalifierDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.qualifierDescription).encode(ExternalEncoding), input_name='qualifierDescription'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualifierID', node)
        if value is not None and 'qualifierID' not in already_processed:
            already_processed.add('qualifierID')
            try:
                self.qualifierID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_positiveInt(self.qualifierID)    # validate type positiveInt
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
        value = find_attr_value_('vocabulary', node)
        if value is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            self.vocabulary = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'qualifierCode':
            qualifierCode_ = child_.text
            qualifierCode_ = re_.sub(String_cleanup_pat_, " ", qualifierCode_).strip()
            qualifierCode_ = self.gds_validate_string(qualifierCode_, node, 'qualifierCode')
            self.qualifierCode = qualifierCode_
        elif nodeName_ == 'qualifierDescription':
            qualifierDescription_ = child_.text
            qualifierDescription_ = self.gds_validate_string(qualifierDescription_, node, 'qualifierDescription')
            self.qualifierDescription = qualifierDescription_
# end class QualifierType


class TimeSeriesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, sourceInfo=None, variable=None, values=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.sourceInfo = sourceInfo
        self.variable = variable
        if values is None:
            self.values = []
        else:
            self.values = values
    def factory(*args_, **kwargs_):
        if TimeSeriesType.subclass:
            return TimeSeriesType.subclass(*args_, **kwargs_)
        else:
            return TimeSeriesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sourceInfo(self): return self.sourceInfo
    def set_sourceInfo(self, sourceInfo): self.sourceInfo = sourceInfo
    def get_variable(self): return self.variable
    def set_variable(self, variable): self.variable = variable
    def get_values(self): return self.values
    def set_values(self, values): self.values = values
    def add_values(self, value): self.values.append(value)
    def insert_values_at(self, index, value): self.values.insert(index, value)
    def replace_values_at(self, index, value): self.values[index] = value
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def hasContent_(self):
        if (
            self.sourceInfo is not None or
            self.variable is not None or
            self.values
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimeSeriesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeSeriesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimeSeriesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimeSeriesType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='TimeSeriesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sourceInfo is not None:
            self.sourceInfo.export(outfile, level, namespace_, name_='sourceInfo', pretty_print=pretty_print)
        if self.variable is not None:
            self.variable.export(outfile, level, namespace_, name_='variable', pretty_print=pretty_print)
        for values_ in self.values:
        #if self.values:
            values_.export(outfile, level, namespace_, name_='values', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sourceInfo':
            class_obj_ = self.get_class_obj_(child_, SourceInfoType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.sourceInfo = obj_
            obj_.original_tagname_ = 'sourceInfo'
        elif nodeName_ == 'variable':
            obj_ = VariableInfoType.factory()
            obj_.build(child_)
            self.variable = obj_
            obj_.original_tagname_ = 'variable'
        elif nodeName_ == 'values':
            obj_ = TsValuesSingleVariableType.factory()
            obj_.build(child_)
            self.values.append(obj_)
            obj_.original_tagname_ = 'values'
# end class TimeSeriesType


class NoteType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, show=None, href=None, type_=None, title=None, valueOf_=None):
        self.original_tagname_ = None
        self.show = _cast(None, show)
        self.href = _cast(None, href)
        self.type_ = _cast(None, type_)
        self.title = _cast(None, title)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if NoteType.subclass:
            return NoteType.subclass(*args_, **kwargs_)
        else:
            return NoteType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_show(self): return self.show
    def set_show(self, show): self.show = show
    def get_href(self): return self.href
    def set_href(self, href): self.href = href
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='NoteType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='NoteType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='NoteType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='NoteType'):
        if self.show is not None and 'show' not in already_processed:
            already_processed.add('show')
            outfile.write(' show=%s' % (self.gds_format_string(quote_attrib(self.show).encode(ExternalEncoding), input_name='show'), ))
        if self.href is not None and 'href' not in already_processed:
            already_processed.add('href')
            outfile.write(' href=%s' % (self.gds_format_string(quote_attrib(self.href).encode(ExternalEncoding), input_name='href'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.title is not None and 'title' not in already_processed:
            already_processed.add('title')
            outfile.write(' title=%s' % (self.gds_format_string(quote_attrib(self.title).encode(ExternalEncoding), input_name='title'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='NoteType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('show', node)
        if value is not None and 'show' not in already_processed:
            already_processed.add('show')
            self.show = value
        value = find_attr_value_('href', node)
        if value is not None and 'href' not in already_processed:
            already_processed.add('href')
            self.href = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('title', node)
        if value is not None and 'title' not in already_processed:
            already_processed.add('title')
            self.title = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class NoteType


class ValueSingleVariable(GeneratedsSuper):
    """This represents an offset for the time zone. [+/-]hh:mm"""
    subclass = None
    superclass = None
    def __init__(self, codedVocabularyTerm=None, sampleID=None, methodCode=None, qualityControlLevelCode=None, methodID=None, metadataTime=None, codedVocabulary=None, labSampleCode=None, sourceID=None, censorCode=None, accuracyStdDev=None, offsetTypeID=None, dateTime=None, offsetTypeCode=None, dateTimeUTC=None, sourceCode=None, timeOffset=None, offsetValue=None, qualifiers=None, oid=None, valueOf_=None):
        self.original_tagname_ = None
        self.codedVocabularyTerm = _cast(None, codedVocabularyTerm)
        self.sampleID = _cast(int, sampleID)
        self.methodCode = _cast(None, methodCode)
        self.qualityControlLevelCode = _cast(None, qualityControlLevelCode)
        self.methodID = _cast(int, methodID)
        if isinstance(metadataTime, basestring):
            initvalue_ = datetime_.datetime.strptime(metadataTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = metadataTime
        self.metadataTime = initvalue_
        self.codedVocabulary = _cast(bool, codedVocabulary)
        self.labSampleCode = _cast(None, labSampleCode)
        self.sourceID = _cast(int, sourceID)
        self.censorCode = _cast(None, censorCode)
        self.accuracyStdDev = _cast(float, accuracyStdDev)
        self.offsetTypeID = _cast(int, offsetTypeID)
        if isinstance(dateTime, basestring):
            initvalue_ = datetime_.datetime.strptime(dateTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = dateTime
        self.dateTime = initvalue_
        self.offsetTypeCode = _cast(None, offsetTypeCode)
        if isinstance(dateTimeUTC, basestring):
            initvalue_ = datetime_.datetime.strptime(dateTimeUTC, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = dateTimeUTC
        self.dateTimeUTC = initvalue_
        self.sourceCode = _cast(None, sourceCode)
        self.timeOffset = _cast(None, timeOffset)
        self.offsetValue = _cast(float, offsetValue)
        self.qualifiers = _cast(None, qualifiers)
        self.oid = _cast(None, oid)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if ValueSingleVariable.subclass:
            return ValueSingleVariable.subclass(*args_, **kwargs_)
        else:
            return ValueSingleVariable(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_codedVocabularyTerm(self): return self.codedVocabularyTerm
    def set_codedVocabularyTerm(self, codedVocabularyTerm): self.codedVocabularyTerm = codedVocabularyTerm
    def get_sampleID(self): return self.sampleID
    def set_sampleID(self, sampleID): self.sampleID = sampleID
    def get_methodCode(self): return self.methodCode
    def set_methodCode(self, methodCode): self.methodCode = methodCode
    def get_qualityControlLevelCode(self): return self.qualityControlLevelCode
    def set_qualityControlLevelCode(self, qualityControlLevelCode): self.qualityControlLevelCode = qualityControlLevelCode
    def get_methodID(self): return self.methodID
    def set_methodID(self, methodID): self.methodID = methodID
    def get_metadataTime(self): return self.metadataTime
    def set_metadataTime(self, metadataTime): self.metadataTime = metadataTime
    def get_codedVocabulary(self): return self.codedVocabulary
    def set_codedVocabulary(self, codedVocabulary): self.codedVocabulary = codedVocabulary
    def get_labSampleCode(self): return self.labSampleCode
    def set_labSampleCode(self, labSampleCode): self.labSampleCode = labSampleCode
    def get_sourceID(self): return self.sourceID
    def set_sourceID(self, sourceID): self.sourceID = sourceID
    def get_censorCode(self): return self.censorCode
    def set_censorCode(self, censorCode): self.censorCode = censorCode
    def get_accuracyStdDev(self): return self.accuracyStdDev
    def set_accuracyStdDev(self, accuracyStdDev): self.accuracyStdDev = accuracyStdDev
    def get_offsetTypeID(self): return self.offsetTypeID
    def set_offsetTypeID(self, offsetTypeID): self.offsetTypeID = offsetTypeID
    def get_dateTime(self): return self.dateTime
    def set_dateTime(self, dateTime): self.dateTime = dateTime
    def get_offsetTypeCode(self): return self.offsetTypeCode
    def set_offsetTypeCode(self, offsetTypeCode): self.offsetTypeCode = offsetTypeCode
    def get_dateTimeUTC(self): return self.dateTimeUTC
    def set_dateTimeUTC(self, dateTimeUTC): self.dateTimeUTC = dateTimeUTC
    def get_sourceCode(self): return self.sourceCode
    def set_sourceCode(self, sourceCode): self.sourceCode = sourceCode
    def get_timeOffset(self): return self.timeOffset
    def set_timeOffset(self, timeOffset): self.timeOffset = timeOffset
    def get_offsetValue(self): return self.offsetValue
    def set_offsetValue(self, offsetValue): self.offsetValue = offsetValue
    def get_qualifiers(self): return self.qualifiers
    def set_qualifiers(self, qualifiers): self.qualifiers = qualifiers
    def get_oid(self): return self.oid
    def set_oid(self, oid): self.oid = oid
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_CensorCodeCodeList(self, value):
        # Validate type CensorCodeCodeList, a restriction on None.
        pass
    def validate_TimeOffsetType(self, value):
        # Validate type TimeOffsetType, a restriction on xsi:normalizedString.
        if value is not None and Validate_simpletypes_:
            if not self.gds_validate_simple_patterns(
                    self.validate_TimeOffsetType_patterns_, value):
                warnings_.warn('Value "%s" does not match xsd pattern restrictions: %s' % (value.encode('utf-8'), self.validate_TimeOffsetType_patterns_, ))
    validate_TimeOffsetType_patterns_ = [['^^[+-][01]\\d:[0-5]\\d$']]
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ValueSingleVariable', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ValueSingleVariable')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ValueSingleVariable', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ValueSingleVariable'):
        if self.codedVocabularyTerm is not None and 'codedVocabularyTerm' not in already_processed:
            already_processed.add('codedVocabularyTerm')
            outfile.write(' codedVocabularyTerm=%s' % (self.gds_format_string(quote_attrib(self.codedVocabularyTerm).encode(ExternalEncoding), input_name='codedVocabularyTerm'), ))
        if self.sampleID is not None and 'sampleID' not in already_processed:
            already_processed.add('sampleID')
            outfile.write(' sampleID="%s"' % self.gds_format_integer(self.sampleID, input_name='sampleID'))
        if self.methodCode is not None and 'methodCode' not in already_processed:
            already_processed.add('methodCode')
            outfile.write(' methodCode=%s' % (self.gds_format_string(quote_attrib(self.methodCode).encode(ExternalEncoding), input_name='methodCode'), ))
        if self.qualityControlLevelCode is not None and 'qualityControlLevelCode' not in already_processed:
            already_processed.add('qualityControlLevelCode')
            outfile.write(' qualityControlLevelCode=%s' % (self.gds_format_string(quote_attrib(self.qualityControlLevelCode).encode(ExternalEncoding), input_name='qualityControlLevelCode'), ))
        if self.methodID is not None and 'methodID' not in already_processed:
            already_processed.add('methodID')
            outfile.write(' methodID="%s"' % self.gds_format_integer(self.methodID, input_name='methodID'))
        if self.metadataTime is not None and 'metadataTime' not in already_processed:
            already_processed.add('metadataTime')
            outfile.write(' metadataTime="%s"' % self.gds_format_datetime(self.metadataTime, input_name='metadataTime'))
        if self.codedVocabulary is not None and 'codedVocabulary' not in already_processed:
            already_processed.add('codedVocabulary')
            outfile.write(' codedVocabulary="%s"' % self.gds_format_boolean(self.codedVocabulary, input_name='codedVocabulary'))
        if self.labSampleCode is not None and 'labSampleCode' not in already_processed:
            already_processed.add('labSampleCode')
            outfile.write(' labSampleCode=%s' % (self.gds_format_string(quote_attrib(self.labSampleCode).encode(ExternalEncoding), input_name='labSampleCode'), ))
        if self.sourceID is not None and 'sourceID' not in already_processed:
            already_processed.add('sourceID')
            outfile.write(' sourceID="%s"' % self.gds_format_integer(self.sourceID, input_name='sourceID'))
        if self.censorCode is not None and 'censorCode' not in already_processed:
            already_processed.add('censorCode')
            outfile.write(' censorCode=%s' % (quote_attrib(self.censorCode), ))
        if self.accuracyStdDev is not None and 'accuracyStdDev' not in already_processed:
            already_processed.add('accuracyStdDev')
            outfile.write(' accuracyStdDev="%s"' % self.gds_format_double(self.accuracyStdDev, input_name='accuracyStdDev'))
        if self.offsetTypeID is not None and 'offsetTypeID' not in already_processed:
            already_processed.add('offsetTypeID')
            outfile.write(' offsetTypeID="%s"' % self.gds_format_integer(self.offsetTypeID, input_name='offsetTypeID'))
        if self.dateTime is not None and 'dateTime' not in already_processed:
            already_processed.add('dateTime')
            outfile.write(' dateTime="%s"' % self.gds_format_datetime(self.dateTime, input_name='dateTime'))
        if self.offsetTypeCode is not None and 'offsetTypeCode' not in already_processed:
            already_processed.add('offsetTypeCode')
            outfile.write(' offsetTypeCode=%s' % (self.gds_format_string(quote_attrib(self.offsetTypeCode).encode(ExternalEncoding), input_name='offsetTypeCode'), ))
        if self.dateTimeUTC is not None and 'dateTimeUTC' not in already_processed:
            already_processed.add('dateTimeUTC')
            outfile.write(' dateTimeUTC="%s"' % self.gds_format_datetime(self.dateTimeUTC, input_name='dateTimeUTC'))
        if self.sourceCode is not None and 'sourceCode' not in already_processed:
            already_processed.add('sourceCode')
            outfile.write(' sourceCode=%s' % (self.gds_format_string(quote_attrib(self.sourceCode).encode(ExternalEncoding), input_name='sourceCode'), ))
        if self.timeOffset is not None and 'timeOffset' not in already_processed:
            already_processed.add('timeOffset')
            outfile.write(' timeOffset=%s' % (quote_attrib(self.timeOffset), ))
        if self.offsetValue is not None and 'offsetValue' not in already_processed:
            already_processed.add('offsetValue')
            outfile.write(' offsetValue="%s"' % self.gds_format_double(self.offsetValue, input_name='offsetValue'))
        if self.qualifiers is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            outfile.write(' qualifiers=%s' % (quote_attrib(self.qualifiers), ))
        if self.oid is not None and 'oid' not in already_processed:
            already_processed.add('oid')
            outfile.write(' oid=%s' % (self.gds_format_string(quote_attrib(self.oid).encode(ExternalEncoding), input_name='oid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='ValueSingleVariable', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('codedVocabularyTerm', node)
        if value is not None and 'codedVocabularyTerm' not in already_processed:
            already_processed.add('codedVocabularyTerm')
            self.codedVocabularyTerm = value
        value = find_attr_value_('sampleID', node)
        if value is not None and 'sampleID' not in already_processed:
            already_processed.add('sampleID')
            try:
                self.sampleID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.sampleID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('methodCode', node)
        if value is not None and 'methodCode' not in already_processed:
            already_processed.add('methodCode')
            self.methodCode = value
            self.methodCode = ' '.join(self.methodCode.split())
        value = find_attr_value_('qualityControlLevelCode', node)
        if value is not None and 'qualityControlLevelCode' not in already_processed:
            already_processed.add('qualityControlLevelCode')
            self.qualityControlLevelCode = value
            self.qualityControlLevelCode = ' '.join(self.qualityControlLevelCode.split())
        value = find_attr_value_('methodID', node)
        if value is not None and 'methodID' not in already_processed:
            already_processed.add('methodID')
            try:
                self.methodID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.methodID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('metadataTime', node)
        if value is not None and 'metadataTime' not in already_processed:
            already_processed.add('metadataTime')
            try:
                self.metadataTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (metadataTime): %s' % exp)
        value = find_attr_value_('codedVocabulary', node)
        if value is not None and 'codedVocabulary' not in already_processed:
            already_processed.add('codedVocabulary')
            if value in ('true', '1'):
                self.codedVocabulary = True
            elif value in ('false', '0'):
                self.codedVocabulary = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('labSampleCode', node)
        if value is not None and 'labSampleCode' not in already_processed:
            already_processed.add('labSampleCode')
            self.labSampleCode = value
            self.labSampleCode = ' '.join(self.labSampleCode.split())
        value = find_attr_value_('sourceID', node)
        if value is not None and 'sourceID' not in already_processed:
            already_processed.add('sourceID')
            try:
                self.sourceID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.sourceID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('censorCode', node)
        if value is not None and 'censorCode' not in already_processed:
            already_processed.add('censorCode')
            self.censorCode = value
            self.validate_CensorCodeCodeList(self.censorCode)    # validate type CensorCodeCodeList
        value = find_attr_value_('accuracyStdDev', node)
        if value is not None and 'accuracyStdDev' not in already_processed:
            already_processed.add('accuracyStdDev')
            try:
                self.accuracyStdDev = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (accuracyStdDev): %s' % exp)
        value = find_attr_value_('offsetTypeID', node)
        if value is not None and 'offsetTypeID' not in already_processed:
            already_processed.add('offsetTypeID')
            try:
                self.offsetTypeID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            if self.offsetTypeID < 0:
                raise_parse_error(node, 'Invalid NonNegativeInteger')
        value = find_attr_value_('dateTime', node)
        if value is not None and 'dateTime' not in already_processed:
            already_processed.add('dateTime')
            try:
                self.dateTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (dateTime): %s' % exp)
        value = find_attr_value_('offsetTypeCode', node)
        if value is not None and 'offsetTypeCode' not in already_processed:
            already_processed.add('offsetTypeCode')
            self.offsetTypeCode = value
            self.offsetTypeCode = ' '.join(self.offsetTypeCode.split())
        value = find_attr_value_('dateTimeUTC', node)
        if value is not None and 'dateTimeUTC' not in already_processed:
            already_processed.add('dateTimeUTC')
            try:
                self.dateTimeUTC = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (dateTimeUTC): %s' % exp)
        value = find_attr_value_('sourceCode', node)
        if value is not None and 'sourceCode' not in already_processed:
            already_processed.add('sourceCode')
            self.sourceCode = value
            self.sourceCode = ' '.join(self.sourceCode.split())
        value = find_attr_value_('timeOffset', node)
        if value is not None and 'timeOffset' not in already_processed:
            already_processed.add('timeOffset')
            self.timeOffset = value
            self.validate_TimeOffsetType(self.timeOffset)    # validate type TimeOffsetType
        value = find_attr_value_('offsetValue', node)
        if value is not None and 'offsetValue' not in already_processed:
            already_processed.add('offsetValue')
            try:
                self.offsetValue = float(value)
            except ValueError as exp:
                raise ValueError('Bad float/double attribute (offsetValue): %s' % exp)
        value = find_attr_value_('qualifiers', node)
        if value is not None and 'qualifiers' not in already_processed:
            already_processed.add('qualifiers')
            self.qualifiers = value
        value = find_attr_value_('oid', node)
        if value is not None and 'oid' not in already_processed:
            already_processed.add('oid')
            self.oid = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class ValueSingleVariable


class VariablesResponseType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, queryInfo=None, variables=None):
        self.original_tagname_ = None
        self.queryInfo = queryInfo
        self.variables = variables
    def factory(*args_, **kwargs_):
        if VariablesResponseType.subclass:
            return VariablesResponseType.subclass(*args_, **kwargs_)
        else:
            return VariablesResponseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_queryInfo(self): return self.queryInfo
    def set_queryInfo(self, queryInfo): self.queryInfo = queryInfo
    def get_variables(self): return self.variables
    def set_variables(self, variables): self.variables = variables
    def hasContent_(self):
        if (
            self.queryInfo is not None or
            self.variables is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='VariablesResponseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='VariablesResponseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='VariablesResponseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='VariablesResponseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='VariablesResponseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.queryInfo is not None:
            self.queryInfo.export(outfile, level, namespace_, name_='queryInfo', pretty_print=pretty_print)
        if self.variables is not None:
            self.variables.export(outfile, level, namespace_, name_='variables', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'queryInfo':
            obj_ = QueryInfoType.factory()
            obj_.build(child_)
            self.queryInfo = obj_
            obj_.original_tagname_ = 'queryInfo'
        elif nodeName_ == 'variables':
            obj_ = variablesType.factory()
            obj_.build(child_)
            self.variables = obj_
            obj_.original_tagname_ = 'variables'
# end class VariablesResponseType


class TimeSeriesResponseType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, queryInfo=None, timeSeries=None):
        self.original_tagname_ = None
        self.queryInfo = queryInfo
        if timeSeries is None:
            self.timeSeries = []
        else:
            self.timeSeries = timeSeries
    def factory(*args_, **kwargs_):
        if TimeSeriesResponseType.subclass:
            return TimeSeriesResponseType.subclass(*args_, **kwargs_)
        else:
            return TimeSeriesResponseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_queryInfo(self): return self.queryInfo
    def set_queryInfo(self, queryInfo): self.queryInfo = queryInfo
    def get_timeSeries(self): return self.timeSeries
    def set_timeSeries(self, timeSeries): self.timeSeries = timeSeries
    def add_timeSeries(self, value): self.timeSeries.append(value)
    def insert_timeSeries_at(self, index, value): self.timeSeries.insert(index, value)
    def replace_timeSeries_at(self, index, value): self.timeSeries[index] = value
    def hasContent_(self):
        if (
            self.queryInfo is not None or
            self.timeSeries
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='TimeSeriesResponseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='TimeSeriesResponseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='TimeSeriesResponseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='TimeSeriesResponseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='TimeSeriesResponseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.queryInfo is not None:
            self.queryInfo.export(outfile, level, namespace_, name_='queryInfo', pretty_print=pretty_print)
        for timeSeries_ in self.timeSeries:
        #if self.timeSeries:
            timeSeries_.export(outfile, level, namespace_, name_='timeSeries', pretty_print=pretty_print)

    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'queryInfo':
            obj_ = QueryInfoType.factory()
            obj_.build(child_)
            self.queryInfo = obj_
            obj_.original_tagname_ = 'queryInfo'
        elif nodeName_ == 'timeSeries':
            obj_ = TimeSeriesType.factory()
            obj_.build(child_)
            self.timeSeries.append(obj_)
            obj_.original_tagname_ = 'timeSeries'
# end class TimeSeriesResponseType


class SiteInfoResponseType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, queryInfo=None, site=None):
        self.original_tagname_ = None
        self.queryInfo = queryInfo
        if site is None:
            self.site = []
        else:
            self.site = site
    def factory(*args_, **kwargs_):
        if SiteInfoResponseType.subclass:
            return SiteInfoResponseType.subclass(*args_, **kwargs_)
        else:
            return SiteInfoResponseType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_queryInfo(self): return self.queryInfo
    def set_queryInfo(self, queryInfo): self.queryInfo = queryInfo
    def get_site(self): return self.site
    def set_site(self, site): self.site = site
    def add_site(self, value): self.site.append(value)
    def insert_site_at(self, index, value): self.site.insert(index, value)
    def replace_site_at(self, index, value): self.site[index] = value
    def hasContent_(self):
        if (
            self.queryInfo is not None or
            self.site
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SiteInfoResponseType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SiteInfoResponseType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SiteInfoResponseType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SiteInfoResponseType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='SiteInfoResponseType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.queryInfo is not None:
            self.queryInfo.export(outfile, level, namespace_, name_='queryInfo', pretty_print=pretty_print)
        for site_ in self.site:
            site_.export(outfile, level, namespace_, name_='site', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'queryInfo':
            obj_ = QueryInfoType.factory()
            obj_.build(child_)
            self.queryInfo = obj_
            obj_.original_tagname_ = 'queryInfo'
        elif nodeName_ == 'site':
            obj_ = siteType.factory()
            obj_.build(child_)
            self.site.append(obj_)
            obj_.original_tagname_ = 'site'
# end class SiteInfoResponseType


class UnitsType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, unitID=None, unitName=None, unitDescription=None, unitType=None, unitAbbreviation=None, unitCode=None):
        self.original_tagname_ = None
        self.unitID = _cast(int, unitID)
        self.unitName = unitName
        self.unitDescription = unitDescription
        self.unitType = unitType
        self.validate_UnitsTypeCodeList(self.unitType)
        self.unitAbbreviation = unitAbbreviation
        self.unitCode = unitCode
    def factory(*args_, **kwargs_):
        if UnitsType.subclass:
            return UnitsType.subclass(*args_, **kwargs_)
        else:
            return UnitsType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_unitName(self): return self.unitName
    def set_unitName(self, unitName): self.unitName = unitName
    def get_unitDescription(self): return self.unitDescription
    def set_unitDescription(self, unitDescription): self.unitDescription = unitDescription
    def get_unitType(self): return self.unitType
    def set_unitType(self, unitType): self.unitType = unitType
    def get_unitAbbreviation(self): return self.unitAbbreviation
    def set_unitAbbreviation(self, unitAbbreviation): self.unitAbbreviation = unitAbbreviation
    def get_unitCode(self): return self.unitCode
    def set_unitCode(self, unitCode): self.unitCode = unitCode
    def get_unitID(self): return self.unitID
    def set_unitID(self, unitID): self.unitID = unitID
    def validate_UnitsTypeCodeList(self, value):
        # Validate type UnitsTypeCodeList, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.unitName is not None or
            self.unitDescription is not None or
            self.unitType is not None or
            self.unitAbbreviation is not None or
            self.unitCode is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='UnitsType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='UnitsType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='UnitsType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='UnitsType'):
        if self.unitID is not None and 'unitID' not in already_processed:
            already_processed.add('unitID')
            outfile.write(' unitID="%s"' % self.gds_format_integer(self.unitID, input_name='unitID'))
    def exportChildren(self, outfile, level, namespace_='', name_='UnitsType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.unitName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sunitName>%s</%sunitName>%s' % (namespace_, self.gds_format_string(quote_xml(self.unitName).encode(ExternalEncoding), input_name='unitName'), namespace_, eol_))
        if self.unitDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sunitDescription>%s</%sunitDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.unitDescription).encode(ExternalEncoding), input_name='unitDescription'), namespace_, eol_))
        if self.unitType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sunitType>%s</%sunitType>%s' % (namespace_, self.gds_format_string(quote_xml(self.unitType).encode(ExternalEncoding), input_name='unitType'), namespace_, eol_))
        if self.unitAbbreviation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sunitAbbreviation>%s</%sunitAbbreviation>%s' % (namespace_, self.gds_format_string(quote_xml(self.unitAbbreviation).encode(ExternalEncoding), input_name='unitAbbreviation'), namespace_, eol_))
        if self.unitCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sunitCode>%s</%sunitCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.unitCode).encode(ExternalEncoding), input_name='unitCode'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('unitID', node)
        if value is not None and 'unitID' not in already_processed:
            already_processed.add('unitID')
            try:
                self.unitID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'unitName':
            unitName_ = child_.text
            unitName_ = self.gds_validate_string(unitName_, node, 'unitName')
            self.unitName = unitName_
        elif nodeName_ == 'unitDescription':
            unitDescription_ = child_.text
            unitDescription_ = self.gds_validate_string(unitDescription_, node, 'unitDescription')
            self.unitDescription = unitDescription_
        elif nodeName_ == 'unitType':
            unitType_ = child_.text
            unitType_ = self.gds_validate_string(unitType_, node, 'unitType')
            self.unitType = unitType_
            # validate type UnitsTypeCodeList
            self.validate_UnitsTypeCodeList(self.unitType)
        elif nodeName_ == 'unitAbbreviation':
            unitAbbreviation_ = child_.text
            unitAbbreviation_ = self.gds_validate_string(unitAbbreviation_, node, 'unitAbbreviation')
            self.unitAbbreviation = unitAbbreviation_
        elif nodeName_ == 'unitCode':
            unitCode_ = child_.text
            unitCode_ = re_.sub(String_cleanup_pat_, " ", unitCode_).strip()
            unitCode_ = self.gds_validate_string(unitCode_, node, 'unitCode')
            self.unitCode = unitCode_
# end class UnitsType


class MethodType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, methodID=None, methodCode=None, methodDescription=None, methodLink=None):
        self.original_tagname_ = None
        self.methodID = _cast(None, methodID)
        self.methodCode = methodCode
        self.methodDescription = methodDescription
        self.methodLink = methodLink
    def factory(*args_, **kwargs_):
        if MethodType.subclass:
            return MethodType.subclass(*args_, **kwargs_)
        else:
            return MethodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_methodCode(self): return self.methodCode
    def set_methodCode(self, methodCode): self.methodCode = methodCode
    def get_methodDescription(self): return self.methodDescription
    def set_methodDescription(self, methodDescription): self.methodDescription = methodDescription
    def get_methodLink(self): return self.methodLink
    def set_methodLink(self, methodLink): self.methodLink = methodLink
    def get_methodID(self): return self.methodID
    def set_methodID(self, methodID): self.methodID = methodID
    def validate_positiveInt(self, value):
        # Validate type positiveInt, a restriction on xsi:int.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on positiveInt' % {"value" : value} )
    def hasContent_(self):
        if (
            self.methodCode is not None or
            self.methodDescription is not None or
            self.methodLink is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MethodType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MethodType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MethodType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MethodType'):
        if self.methodID is not None and 'methodID' not in already_processed:
            already_processed.add('methodID')
            outfile.write(' methodID=%s' % (quote_attrib(self.methodID), ))
    def exportChildren(self, outfile, level, namespace_='', name_='MethodType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.methodCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethodCode>%s</%smethodCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.methodCode).encode(ExternalEncoding), input_name='methodCode'), namespace_, eol_))
        if self.methodDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethodDescription>%s</%smethodDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.methodDescription).encode(ExternalEncoding), input_name='methodDescription'), namespace_, eol_))
        if self.methodLink is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smethodLink>%s</%smethodLink>%s' % (namespace_, self.gds_format_string(quote_xml(self.methodLink).encode(ExternalEncoding), input_name='methodLink'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('methodID', node)
        if value is not None and 'methodID' not in already_processed:
            already_processed.add('methodID')
            try:
                self.methodID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_positiveInt(self.methodID)    # validate type positiveInt
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'methodCode':
            methodCode_ = child_.text
            methodCode_ = re_.sub(String_cleanup_pat_, " ", methodCode_).strip()
            methodCode_ = self.gds_validate_string(methodCode_, node, 'methodCode')
            self.methodCode = methodCode_
        elif nodeName_ == 'methodDescription':
            methodDescription_ = child_.text
            methodDescription_ = self.gds_validate_string(methodDescription_, node, 'methodDescription')
            self.methodDescription = methodDescription_
        elif nodeName_ == 'methodLink':
            methodLink_ = child_.text
            methodLink_ = self.gds_validate_string(methodLink_, node, 'methodLink')
            self.methodLink = methodLink_
# end class MethodType


class SampleType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sampleID=None, labSampleCode=None, sampleType=None, labMethod=None):
        self.original_tagname_ = None
        self.sampleID = _cast(int, sampleID)
        self.labSampleCode = labSampleCode
        self.sampleType = sampleType
        self.validate_SampleTypeCodeList(self.sampleType)
        self.labMethod = labMethod
    def factory(*args_, **kwargs_):
        if SampleType.subclass:
            return SampleType.subclass(*args_, **kwargs_)
        else:
            return SampleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_labSampleCode(self): return self.labSampleCode
    def set_labSampleCode(self, labSampleCode): self.labSampleCode = labSampleCode
    def get_sampleType(self): return self.sampleType
    def set_sampleType(self, sampleType): self.sampleType = sampleType
    def get_labMethod(self): return self.labMethod
    def set_labMethod(self, labMethod): self.labMethod = labMethod
    def get_sampleID(self): return self.sampleID
    def set_sampleID(self, sampleID): self.sampleID = sampleID
    def validate_SampleTypeCodeList(self, value):
        # Validate type SampleTypeCodeList, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.labSampleCode is not None or
            self.sampleType is not None or
            self.labMethod is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SampleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SampleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SampleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SampleType'):
        if self.sampleID is not None and 'sampleID' not in already_processed:
            already_processed.add('sampleID')
            outfile.write(' sampleID="%s"' % self.gds_format_integer(self.sampleID, input_name='sampleID'))
    def exportChildren(self, outfile, level, namespace_='', name_='SampleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.labSampleCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabSampleCode>%s</%slabSampleCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.labSampleCode).encode(ExternalEncoding), input_name='labSampleCode'), namespace_, eol_))
        if self.sampleType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssampleType>%s</%ssampleType>%s' % (namespace_, self.gds_format_string(quote_xml(self.sampleType).encode(ExternalEncoding), input_name='sampleType'), namespace_, eol_))
        if self.labMethod is not None:
            self.labMethod.export(outfile, level, namespace_, name_='labMethod', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sampleID', node)
        if value is not None and 'sampleID' not in already_processed:
            already_processed.add('sampleID')
            try:
                self.sampleID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'labSampleCode':
            labSampleCode_ = child_.text
            labSampleCode_ = self.gds_validate_string(labSampleCode_, node, 'labSampleCode')
            self.labSampleCode = labSampleCode_
        elif nodeName_ == 'sampleType':
            sampleType_ = child_.text
            sampleType_ = self.gds_validate_string(sampleType_, node, 'sampleType')
            self.sampleType = sampleType_
            # validate type SampleTypeCodeList
            self.validate_SampleTypeCodeList(self.sampleType)
        elif nodeName_ == 'labMethod':
            obj_ = LabMethodType.factory()
            obj_.build(child_)
            self.labMethod = obj_
            obj_.original_tagname_ = 'labMethod'
# end class SampleType


class LabMethodType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, labMethodID=None, labCode=None, labName=None, labOrganization=None, labMethodName=None, labMethodDescription=None, labMethodLink=None, labSourceDetails=None):
        self.original_tagname_ = None
        self.labMethodID = _cast(int, labMethodID)
        self.labCode = labCode
        self.labName = labName
        self.labOrganization = labOrganization
        self.labMethodName = labMethodName
        self.labMethodDescription = labMethodDescription
        self.labMethodLink = labMethodLink
        self.labSourceDetails = labSourceDetails
    def factory(*args_, **kwargs_):
        if LabMethodType.subclass:
            return LabMethodType.subclass(*args_, **kwargs_)
        else:
            return LabMethodType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_labCode(self): return self.labCode
    def set_labCode(self, labCode): self.labCode = labCode
    def get_labName(self): return self.labName
    def set_labName(self, labName): self.labName = labName
    def get_labOrganization(self): return self.labOrganization
    def set_labOrganization(self, labOrganization): self.labOrganization = labOrganization
    def get_labMethodName(self): return self.labMethodName
    def set_labMethodName(self, labMethodName): self.labMethodName = labMethodName
    def get_labMethodDescription(self): return self.labMethodDescription
    def set_labMethodDescription(self, labMethodDescription): self.labMethodDescription = labMethodDescription
    def get_labMethodLink(self): return self.labMethodLink
    def set_labMethodLink(self, labMethodLink): self.labMethodLink = labMethodLink
    def get_labSourceDetails(self): return self.labSourceDetails
    def set_labSourceDetails(self, labSourceDetails): self.labSourceDetails = labSourceDetails
    def get_labMethodID(self): return self.labMethodID
    def set_labMethodID(self, labMethodID): self.labMethodID = labMethodID
    def hasContent_(self):
        if (
            self.labCode is not None or
            self.labName is not None or
            self.labOrganization is not None or
            self.labMethodName is not None or
            self.labMethodDescription is not None or
            self.labMethodLink is not None or
            self.labSourceDetails is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='LabMethodType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='LabMethodType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='LabMethodType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='LabMethodType'):
        if self.labMethodID is not None and 'labMethodID' not in already_processed:
            already_processed.add('labMethodID')
            outfile.write(' labMethodID="%s"' % self.gds_format_integer(self.labMethodID, input_name='labMethodID'))
    def exportChildren(self, outfile, level, namespace_='', name_='LabMethodType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.labCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabCode>%s</%slabCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.labCode).encode(ExternalEncoding), input_name='labCode'), namespace_, eol_))
        if self.labName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabName>%s</%slabName>%s' % (namespace_, self.gds_format_string(quote_xml(self.labName).encode(ExternalEncoding), input_name='labName'), namespace_, eol_))
        if self.labOrganization is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabOrganization>%s</%slabOrganization>%s' % (namespace_, self.gds_format_string(quote_xml(self.labOrganization).encode(ExternalEncoding), input_name='labOrganization'), namespace_, eol_))
        if self.labMethodName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabMethodName>%s</%slabMethodName>%s' % (namespace_, self.gds_format_string(quote_xml(self.labMethodName).encode(ExternalEncoding), input_name='labMethodName'), namespace_, eol_))
        if self.labMethodDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabMethodDescription>%s</%slabMethodDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.labMethodDescription).encode(ExternalEncoding), input_name='labMethodDescription'), namespace_, eol_))
        if self.labMethodLink is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slabMethodLink>%s</%slabMethodLink>%s' % (namespace_, self.gds_format_string(quote_xml(self.labMethodLink).encode(ExternalEncoding), input_name='labMethodLink'), namespace_, eol_))
        if self.labSourceDetails is not None:
            self.labSourceDetails.export(outfile, level, namespace_, name_='labSourceDetails', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('labMethodID', node)
        if value is not None and 'labMethodID' not in already_processed:
            already_processed.add('labMethodID')
            try:
                self.labMethodID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'labCode':
            labCode_ = child_.text
            labCode_ = re_.sub(String_cleanup_pat_, " ", labCode_).strip()
            labCode_ = self.gds_validate_string(labCode_, node, 'labCode')
            self.labCode = labCode_
        elif nodeName_ == 'labName':
            labName_ = child_.text
            labName_ = self.gds_validate_string(labName_, node, 'labName')
            self.labName = labName_
        elif nodeName_ == 'labOrganization':
            labOrganization_ = child_.text
            labOrganization_ = self.gds_validate_string(labOrganization_, node, 'labOrganization')
            self.labOrganization = labOrganization_
        elif nodeName_ == 'labMethodName':
            labMethodName_ = child_.text
            labMethodName_ = self.gds_validate_string(labMethodName_, node, 'labMethodName')
            self.labMethodName = labMethodName_
        elif nodeName_ == 'labMethodDescription':
            labMethodDescription_ = child_.text
            labMethodDescription_ = self.gds_validate_string(labMethodDescription_, node, 'labMethodDescription')
            self.labMethodDescription = labMethodDescription_
        elif nodeName_ == 'labMethodLink':
            labMethodLink_ = child_.text
            labMethodLink_ = self.gds_validate_string(labMethodLink_, node, 'labMethodLink')
            self.labMethodLink = labMethodLink_
        elif nodeName_ == 'labSourceDetails':
            obj_ = SourceType.factory()
            obj_.build(child_)
            self.labSourceDetails = obj_
            obj_.original_tagname_ = 'labSourceDetails'
# end class LabMethodType


class CensorCodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, censorCodeID=None, censorCode=None, censorCodeDescription=None):
        self.original_tagname_ = None
        self.censorCodeID = _cast(int, censorCodeID)
        self.censorCode = censorCode
        self.validate_CensorCodeCodeList(self.censorCode)
        self.censorCodeDescription = censorCodeDescription
    def factory(*args_, **kwargs_):
        if CensorCodeType.subclass:
            return CensorCodeType.subclass(*args_, **kwargs_)
        else:
            return CensorCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_censorCode(self): return self.censorCode
    def set_censorCode(self, censorCode): self.censorCode = censorCode
    def get_censorCodeDescription(self): return self.censorCodeDescription
    def set_censorCodeDescription(self, censorCodeDescription): self.censorCodeDescription = censorCodeDescription
    def get_censorCodeID(self): return self.censorCodeID
    def set_censorCodeID(self, censorCodeID): self.censorCodeID = censorCodeID
    def validate_CensorCodeCodeList(self, value):
        # Validate type CensorCodeCodeList, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.censorCode is not None or
            self.censorCodeDescription is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='CensorCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='CensorCodeType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='CensorCodeType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='CensorCodeType'):
        if self.censorCodeID is not None and 'censorCodeID' not in already_processed:
            already_processed.add('censorCodeID')
            outfile.write(' censorCodeID="%s"' % self.gds_format_integer(self.censorCodeID, input_name='censorCodeID'))
    def exportChildren(self, outfile, level, namespace_='', name_='CensorCodeType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.censorCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scensorCode>%s</%scensorCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.censorCode).encode(ExternalEncoding), input_name='censorCode'), namespace_, eol_))
        if self.censorCodeDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scensorCodeDescription>%s</%scensorCodeDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.censorCodeDescription).encode(ExternalEncoding), input_name='censorCodeDescription'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('censorCodeID', node)
        if value is not None and 'censorCodeID' not in already_processed:
            already_processed.add('censorCodeID')
            try:
                self.censorCodeID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'censorCode':
            censorCode_ = child_.text
            censorCode_ = self.gds_validate_string(censorCode_, node, 'censorCode')
            self.censorCode = censorCode_
            # validate type CensorCodeCodeList
            self.validate_CensorCodeCodeList(self.censorCode)
        elif nodeName_ == 'censorCodeDescription':
            censorCodeDescription_ = child_.text
            censorCodeDescription_ = self.gds_validate_string(censorCodeDescription_, node, 'censorCodeDescription')
            self.censorCodeDescription = censorCodeDescription_
# end class CensorCodeType


class SourceType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, sourceID=None, sourceCode=None, organization=None, sourceDescription=None, metadata=None, contactInformation=None, sourceLink=None, citation=None):
        self.original_tagname_ = None
        self.sourceID = _cast(None, sourceID)
        self.sourceCode = sourceCode
        self.organization = organization
        self.sourceDescription = sourceDescription
        self.metadata = metadata
        if contactInformation is None:
            self.contactInformation = []
        else:
            self.contactInformation = contactInformation
        if sourceLink is None:
            self.sourceLink = []
        else:
            self.sourceLink = sourceLink
        self.citation = citation
    def factory(*args_, **kwargs_):
        if SourceType.subclass:
            return SourceType.subclass(*args_, **kwargs_)
        else:
            return SourceType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_sourceCode(self): return self.sourceCode
    def set_sourceCode(self, sourceCode): self.sourceCode = sourceCode
    def get_organization(self): return self.organization
    def set_organization(self, organization): self.organization = organization
    def get_sourceDescription(self): return self.sourceDescription
    def set_sourceDescription(self, sourceDescription): self.sourceDescription = sourceDescription
    def get_metadata(self): return self.metadata
    def set_metadata(self, metadata): self.metadata = metadata
    def get_contactInformation(self): return self.contactInformation
    def set_contactInformation(self, contactInformation): self.contactInformation = contactInformation
    def add_contactInformation(self, value): self.contactInformation.append(value)
    def insert_contactInformation_at(self, index, value): self.contactInformation.insert(index, value)
    def replace_contactInformation_at(self, index, value): self.contactInformation[index] = value
    def get_sourceLink(self): return self.sourceLink
    def set_sourceLink(self, sourceLink): self.sourceLink = sourceLink
    def add_sourceLink(self, value): self.sourceLink.append(value)
    def insert_sourceLink_at(self, index, value): self.sourceLink.insert(index, value)
    def replace_sourceLink_at(self, index, value): self.sourceLink[index] = value
    def get_citation(self): return self.citation
    def set_citation(self, citation): self.citation = citation
    def get_sourceID(self): return self.sourceID
    def set_sourceID(self, sourceID): self.sourceID = sourceID
    def validate_positiveInt(self, value):
        # Validate type positiveInt, a restriction on xsi:int.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on positiveInt' % {"value" : value} )
    def hasContent_(self):
        if (
            self.sourceCode is not None or
            self.organization is not None or
            self.sourceDescription is not None or
            self.metadata is not None or
            self.contactInformation or
            self.sourceLink or
            self.citation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SourceType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SourceType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SourceType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SourceType'):
        if self.sourceID is not None and 'sourceID' not in already_processed:
            already_processed.add('sourceID')
            outfile.write(' sourceID=%s' % (quote_attrib(self.sourceID), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SourceType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.sourceCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssourceCode>%s</%ssourceCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.sourceCode).encode(ExternalEncoding), input_name='sourceCode'), namespace_, eol_))
        if self.organization is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sorganization>%s</%sorganization>%s' % (namespace_, self.gds_format_string(quote_xml(self.organization).encode(ExternalEncoding), input_name='organization'), namespace_, eol_))
        if self.sourceDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssourceDescription>%s</%ssourceDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.sourceDescription).encode(ExternalEncoding), input_name='sourceDescription'), namespace_, eol_))
        if self.metadata is not None:
            self.metadata.export(outfile, level, namespace_, name_='metadata', pretty_print=pretty_print)
        for contactInformation_ in self.contactInformation:
            contactInformation_.export(outfile, level, namespace_, name_='contactInformation', pretty_print=pretty_print)
        #for sourceLink_ in self.sourceLink:
        if self.sourceLink is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssourceLink>%s</%ssourceLink>%s' % (namespace_, self.gds_format_string(quote_xml(self.sourceLink).encode(ExternalEncoding), input_name='sourceLink'), namespace_, eol_))

        if self.citation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scitation>%s</%scitation>%s' % (namespace_, self.gds_format_string(quote_xml(self.citation).encode(ExternalEncoding), input_name='citation'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('sourceID', node)
        if value is not None and 'sourceID' not in already_processed:
            already_processed.add('sourceID')
            try:
                self.sourceID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_positiveInt(self.sourceID)    # validate type positiveInt
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'sourceCode':
            sourceCode_ = child_.text
            sourceCode_ = re_.sub(String_cleanup_pat_, " ", sourceCode_).strip()
            sourceCode_ = self.gds_validate_string(sourceCode_, node, 'sourceCode')
            self.sourceCode = sourceCode_
        elif nodeName_ == 'organization':
            organization_ = child_.text
            organization_ = self.gds_validate_string(organization_, node, 'organization')
            self.organization = organization_
        elif nodeName_ == 'sourceDescription':
            sourceDescription_ = child_.text
            sourceDescription_ = self.gds_validate_string(sourceDescription_, node, 'sourceDescription')
            self.sourceDescription = sourceDescription_
        elif nodeName_ == 'metadata':
            obj_ = MetaDataType.factory()
            obj_.build(child_)
            self.metadata = obj_
            obj_.original_tagname_ = 'metadata'
        elif nodeName_ == 'contactInformation':
            obj_ = ContactInformationType.factory()
            obj_.build(child_)
            self.contactInformation.append(obj_)
            obj_.original_tagname_ = 'contactInformation'
        elif nodeName_ == 'sourceLink':
            sourceLink_ = child_.text
            sourceLink_ = self.gds_validate_string(sourceLink_, node, 'sourceLink')
            self.sourceLink.append(sourceLink_)
        elif nodeName_ == 'citation':
            citation_ = child_.text
            citation_ = self.gds_validate_string(citation_, node, 'citation')
            self.citation = citation_
# end class SourceType


class ContactInformationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, contactName=None, typeOfContact=None, email=None, phone=None, address=None):
        self.original_tagname_ = None
        self.contactName = contactName
        self.typeOfContact = typeOfContact
        if email is None:
            self.email = []
        else:
            self.email = email
        if phone is None:
            self.phone = []
        else:
            self.phone = phone
        if address is None:
            self.address = []
        else:
            self.address = address
    def factory(*args_, **kwargs_):
        if ContactInformationType.subclass:
            return ContactInformationType.subclass(*args_, **kwargs_)
        else:
            return ContactInformationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_contactName(self): return self.contactName
    def set_contactName(self, contactName): self.contactName = contactName
    def get_typeOfContact(self): return self.typeOfContact
    def set_typeOfContact(self, typeOfContact): self.typeOfContact = typeOfContact
    def get_email(self): return self.email
    def set_email(self, email): self.email = email
    def add_email(self, value): self.email.append(value)
    def insert_email_at(self, index, value): self.email.insert(index, value)
    def replace_email_at(self, index, value): self.email[index] = value
    def get_phone(self): return self.phone
    def set_phone(self, phone): self.phone = phone
    def add_phone(self, value): self.phone.append(value)
    def insert_phone_at(self, index, value): self.phone.insert(index, value)
    def replace_phone_at(self, index, value): self.phone[index] = value
    def get_address(self): return self.address
    def set_address(self, address): self.address = address
    def add_address(self, value): self.address.append(value)
    def insert_address_at(self, index, value): self.address.insert(index, value)
    def replace_address_at(self, index, value): self.address[index] = value
    def hasContent_(self):
        if (
            self.contactName is not None or
            self.typeOfContact is not None or
            self.email or
            self.phone or
            self.address
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='ContactInformationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='ContactInformationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='ContactInformationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='ContactInformationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='ContactInformationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.contactName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%scontactName>%s</%scontactName>%s' % (namespace_, self.gds_format_string(quote_xml(self.contactName).encode(ExternalEncoding), input_name='contactName'), namespace_, eol_))
        if self.typeOfContact is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stypeOfContact>%s</%stypeOfContact>%s' % (namespace_, self.gds_format_string(quote_xml(self.typeOfContact).encode(ExternalEncoding), input_name='typeOfContact'), namespace_, eol_))
        for email_ in self.email:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%semail>%s</%semail>%s' % (namespace_, self.gds_format_string(quote_xml(email_).encode(ExternalEncoding), input_name='email'), namespace_, eol_))
        for phone_ in self.phone:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sphone>%s</%sphone>%s' % (namespace_, self.gds_format_string(quote_xml(phone_).encode(ExternalEncoding), input_name='phone'), namespace_, eol_))
        for address_ in self.address:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saddress>%s</%saddress>%s' % (namespace_, self.gds_format_string(quote_xml(address_).encode(ExternalEncoding), input_name='address'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'contactName':
            contactName_ = child_.text
            contactName_ = self.gds_validate_string(contactName_, node, 'contactName')
            self.contactName = contactName_
        elif nodeName_ == 'typeOfContact':
            typeOfContact_ = child_.text
            typeOfContact_ = self.gds_validate_string(typeOfContact_, node, 'typeOfContact')
            self.typeOfContact = typeOfContact_
        elif nodeName_ == 'email':
            email_ = child_.text
            email_ = self.gds_validate_string(email_, node, 'email')
            self.email.append(email_)
        elif nodeName_ == 'phone':
            phone_ = child_.text
            phone_ = self.gds_validate_string(phone_, node, 'phone')
            self.phone.append(phone_)
        elif nodeName_ == 'address':
            address_ = child_.text
            address_ = self.gds_validate_string(address_, node, 'address')
            self.address.append(address_)
# end class ContactInformationType


class MetaDataType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, topicCategory=None, title=None, abstract=None, profileVersion=None, metadataLink=None):
        self.original_tagname_ = None
        self.topicCategory = topicCategory
        self.title = title
        self.abstract = abstract
        self.profileVersion = profileVersion
        self.metadataLink = metadataLink
    def factory(*args_, **kwargs_):
        if MetaDataType.subclass:
            return MetaDataType.subclass(*args_, **kwargs_)
        else:
            return MetaDataType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_topicCategory(self): return self.topicCategory
    def set_topicCategory(self, topicCategory): self.topicCategory = topicCategory
    def get_title(self): return self.title
    def set_title(self, title): self.title = title
    def get_abstract(self): return self.abstract
    def set_abstract(self, abstract): self.abstract = abstract
    def get_profileVersion(self): return self.profileVersion
    def set_profileVersion(self, profileVersion): self.profileVersion = profileVersion
    def get_metadataLink(self): return self.metadataLink
    def set_metadataLink(self, metadataLink): self.metadataLink = metadataLink
    def hasContent_(self):
        if (
            self.topicCategory is not None or
            self.title is not None or
            self.abstract is not None or
            self.profileVersion is not None or
            self.metadataLink is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='MetaDataType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='MetaDataType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='MetaDataType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='MetaDataType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='MetaDataType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.topicCategory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stopicCategory>%s</%stopicCategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.topicCategory).encode(ExternalEncoding), input_name='topicCategory'), namespace_, eol_))
        if self.title is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stitle>%s</%stitle>%s' % (namespace_, self.gds_format_string(quote_xml(self.title).encode(ExternalEncoding), input_name='title'), namespace_, eol_))
        if self.abstract is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sabstract>%s</%sabstract>%s' % (namespace_, self.gds_format_string(quote_xml(self.abstract).encode(ExternalEncoding), input_name='abstract'), namespace_, eol_))
        if self.profileVersion is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sprofileVersion>%s</%sprofileVersion>%s' % (namespace_, self.gds_format_string(quote_xml(self.profileVersion).encode(ExternalEncoding), input_name='profileVersion'), namespace_, eol_))
        if self.metadataLink is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%smetadataLink>%s</%smetadataLink>%s' % (namespace_, self.gds_format_string(quote_xml(self.metadataLink).encode(ExternalEncoding), input_name='metadataLink'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'topicCategory':
            topicCategory_ = child_.text
            topicCategory_ = self.gds_validate_string(topicCategory_, node, 'topicCategory')
            self.topicCategory = topicCategory_
        elif nodeName_ == 'title':
            title_ = child_.text
            title_ = self.gds_validate_string(title_, node, 'title')
            self.title = title_
        elif nodeName_ == 'abstract':
            abstract_ = child_.text
            abstract_ = self.gds_validate_string(abstract_, node, 'abstract')
            self.abstract = abstract_
        elif nodeName_ == 'profileVersion':
            profileVersion_ = child_.text
            profileVersion_ = self.gds_validate_string(profileVersion_, node, 'profileVersion')
            self.profileVersion = profileVersion_
        elif nodeName_ == 'metadataLink':
            metadataLink_ = child_.text
            metadataLink_ = self.gds_validate_string(metadataLink_, node, 'metadataLink')
            self.metadataLink = metadataLink_
# end class MetaDataType


class QualityControlLevelType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, qualityControlLevelID=None, qualityControlLevelCode=None, definition=None, explanation=None):
        self.original_tagname_ = None
        self.qualityControlLevelID = _cast(int, qualityControlLevelID)
        self.qualityControlLevelCode = qualityControlLevelCode
        self.definition = definition
        self.validate_definitionType(self.definition)
        self.explanation = explanation
    def factory(*args_, **kwargs_):
        if QualityControlLevelType.subclass:
            return QualityControlLevelType.subclass(*args_, **kwargs_)
        else:
            return QualityControlLevelType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_qualityControlLevelCode(self): return self.qualityControlLevelCode
    def set_qualityControlLevelCode(self, qualityControlLevelCode): self.qualityControlLevelCode = qualityControlLevelCode
    def get_definition(self): return self.definition
    def set_definition(self, definition): self.definition = definition
    def get_explanation(self): return self.explanation
    def set_explanation(self, explanation): self.explanation = explanation
    def get_qualityControlLevelID(self): return self.qualityControlLevelID
    def set_qualityControlLevelID(self, qualityControlLevelID): self.qualityControlLevelID = qualityControlLevelID
    def validate_definitionType(self, value):
        # Validate type definitionType, a restriction on xsi:string.
        if value is not None and Validate_simpletypes_:
            if len(value) > 255:
                warnings_.warn('Value "%(value)s" does not match xsd maxLength restriction on definitionType' % {"value" : value.encode("utf-8")} )
            if len(value) < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minLength restriction on definitionType' % {"value" : value.encode("utf-8")} )
    def hasContent_(self):
        if (
            self.qualityControlLevelCode is not None or
            self.definition is not None or
            self.explanation is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='QualityControlLevelType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='QualityControlLevelType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='QualityControlLevelType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='QualityControlLevelType'):
        if self.qualityControlLevelID is not None and 'qualityControlLevelID' not in already_processed:
            already_processed.add('qualityControlLevelID')
            outfile.write(' qualityControlLevelID="%s"' % self.gds_format_integer(self.qualityControlLevelID, input_name='qualityControlLevelID'))
    def exportChildren(self, outfile, level, namespace_='', name_='QualityControlLevelType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.qualityControlLevelCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%squalityControlLevelCode>%s</%squalityControlLevelCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.qualityControlLevelCode).encode(ExternalEncoding), input_name='qualityControlLevelCode'), namespace_, eol_))
        if self.definition is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdefinition>%s</%sdefinition>%s' % (namespace_, self.gds_format_string(quote_xml(self.definition).encode(ExternalEncoding), input_name='definition'), namespace_, eol_))
        if self.explanation is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sexplanation>%s</%sexplanation>%s' % (namespace_, self.gds_format_string(quote_xml(self.explanation).encode(ExternalEncoding), input_name='explanation'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('qualityControlLevelID', node)
        if value is not None and 'qualityControlLevelID' not in already_processed:
            already_processed.add('qualityControlLevelID')
            try:
                self.qualityControlLevelID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'qualityControlLevelCode':
            qualityControlLevelCode_ = child_.text
            qualityControlLevelCode_ = re_.sub(String_cleanup_pat_, " ", qualityControlLevelCode_).strip()
            qualityControlLevelCode_ = self.gds_validate_string(qualityControlLevelCode_, node, 'qualityControlLevelCode')
            self.qualityControlLevelCode = qualityControlLevelCode_
        elif nodeName_ == 'definition':
            definition_ = child_.text
            definition_ = self.gds_validate_string(definition_, node, 'definition')
            self.definition = definition_
            # validate type definitionType
            self.validate_definitionType(self.definition)
        elif nodeName_ == 'explanation':
            explanation_ = child_.text
            explanation_ = self.gds_validate_string(explanation_, node, 'explanation')
            self.explanation = explanation_
# end class QualityControlLevelType


class OffsetType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, offsetTypeID=None, offsetTypeCode=None, offsetValue=None, offsetDescription=None, unit=None, offsetIsVertical=True, offsetAzimuthDegrees=None):
        self.original_tagname_ = None
        self.offsetTypeID = _cast(None, offsetTypeID)
        self.offsetTypeCode = offsetTypeCode
        self.offsetValue = offsetValue
        self.offsetDescription = offsetDescription
        self.unit = unit
        self.offsetIsVertical = offsetIsVertical
        self.offsetAzimuthDegrees = offsetAzimuthDegrees
    def factory(*args_, **kwargs_):
        if OffsetType.subclass:
            return OffsetType.subclass(*args_, **kwargs_)
        else:
            return OffsetType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_offsetTypeCode(self): return self.offsetTypeCode
    def set_offsetTypeCode(self, offsetTypeCode): self.offsetTypeCode = offsetTypeCode
    def get_offsetValue(self): return self.offsetValue
    def set_offsetValue(self, offsetValue): self.offsetValue = offsetValue
    def get_offsetDescription(self): return self.offsetDescription
    def set_offsetDescription(self, offsetDescription): self.offsetDescription = offsetDescription
    def get_unit(self): return self.unit
    def set_unit(self, unit): self.unit = unit
    def get_offsetIsVertical(self): return self.offsetIsVertical
    def set_offsetIsVertical(self, offsetIsVertical): self.offsetIsVertical = offsetIsVertical
    def get_offsetAzimuthDegrees(self): return self.offsetAzimuthDegrees
    def set_offsetAzimuthDegrees(self, offsetAzimuthDegrees): self.offsetAzimuthDegrees = offsetAzimuthDegrees
    def get_offsetTypeID(self): return self.offsetTypeID
    def set_offsetTypeID(self, offsetTypeID): self.offsetTypeID = offsetTypeID
    def validate_positiveInt(self, value):
        # Validate type positiveInt, a restriction on xsi:int.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on positiveInt' % {"value" : value} )
    def hasContent_(self):
        if (
            self.offsetTypeCode is not None or
            self.offsetValue is not None or
            self.offsetDescription is not None or
            self.unit is not None or
            not self.offsetIsVertical or
            self.offsetAzimuthDegrees is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='OffsetType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='OffsetType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='OffsetType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='OffsetType'):
        if self.offsetTypeID is not None and 'offsetTypeID' not in already_processed:
            already_processed.add('offsetTypeID')
            outfile.write(' offsetTypeID=%s' % (quote_attrib(self.offsetTypeID), ))
    def exportChildren(self, outfile, level, namespace_='', name_='OffsetType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.offsetTypeCode is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soffsetTypeCode>%s</%soffsetTypeCode>%s' % (namespace_, self.gds_format_string(quote_xml(self.offsetTypeCode).encode(ExternalEncoding), input_name='offsetTypeCode'), namespace_, eol_))
        if self.offsetValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soffsetValue>%s</%soffsetValue>%s' % (namespace_, self.gds_format_float(self.offsetValue, input_name='offsetValue'), namespace_, eol_))
        if self.offsetDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soffsetDescription>%s</%soffsetDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.offsetDescription).encode(ExternalEncoding), input_name='offsetDescription'), namespace_, eol_))
        if self.unit is not None:
            self.unit.export(outfile, level, namespace_, name_='unit', pretty_print=pretty_print)
# default is true. Always show
        #if not self.offsetIsVertical:
        showIndent(outfile, level, pretty_print)
        outfile.write('<%soffsetIsVertical>%s</%soffsetIsVertical>%s' % (namespace_, self.gds_format_boolean(self.offsetIsVertical, input_name='offsetIsVertical'), namespace_, eol_))
        if self.offsetAzimuthDegrees is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%soffsetAzimuthDegrees>%s</%soffsetAzimuthDegrees>%s' % (namespace_, self.gds_format_integer(self.offsetAzimuthDegrees, input_name='offsetAzimuthDegrees'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('offsetTypeID', node)
        if value is not None and 'offsetTypeID' not in already_processed:
            already_processed.add('offsetTypeID')
            try:
                self.offsetTypeID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_positiveInt(self.offsetTypeID)    # validate type positiveInt
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'offsetTypeCode':
            offsetTypeCode_ = child_.text
            offsetTypeCode_ = re_.sub(String_cleanup_pat_, " ", offsetTypeCode_).strip()
            offsetTypeCode_ = self.gds_validate_string(offsetTypeCode_, node, 'offsetTypeCode')
            self.offsetTypeCode = offsetTypeCode_
        elif nodeName_ == 'offsetValue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'offsetValue')
            self.offsetValue = fval_
        elif nodeName_ == 'offsetDescription':
            offsetDescription_ = child_.text
            offsetDescription_ = self.gds_validate_string(offsetDescription_, node, 'offsetDescription')
            self.offsetDescription = offsetDescription_
        elif nodeName_ == 'unit':
            obj_ = UnitsType.factory()
            obj_.build(child_)
            self.unit = obj_
            obj_.original_tagname_ = 'unit'
        elif nodeName_ == 'offsetIsVertical':
            sval_ = child_.text
            if sval_ in ('true', '1'):
                ival_ = True
            elif sval_ in ('false', '0'):
                ival_ = False
            else:
                raise_parse_error(child_, 'requires boolean')
            ival_ = self.gds_validate_boolean(ival_, node, 'offsetIsVertical')
            self.offsetIsVertical = ival_
        elif nodeName_ == 'offsetAzimuthDegrees':
            sval_ = child_.text
            try:
                ival_ = int(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires integer: %s' % exp)
            ival_ = self.gds_validate_integer(ival_, node, 'offsetAzimuthDegrees')
            self.offsetAzimuthDegrees = ival_
# end class OffsetType


class PropertyType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, type_=None, name=None, uri=None, valueOf_=None):
        self.original_tagname_ = None
        self.type_ = _cast(None, type_)
        self.name = _cast(None, name)
        self.uri = _cast(None, uri)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if PropertyType.subclass:
            return PropertyType.subclass(*args_, **kwargs_)
        else:
            return PropertyType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_type(self): return self.type_
    def set_type(self, type_): self.type_ = type_
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_uri(self): return self.uri
    def set_uri(self, uri): self.uri = uri
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='PropertyType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='PropertyType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='PropertyType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='PropertyType'):
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.add('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.uri is not None and 'uri' not in already_processed:
            already_processed.add('uri')
            outfile.write(' uri=%s' % (self.gds_format_string(quote_attrib(self.uri).encode(ExternalEncoding), input_name='uri'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='PropertyType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.add('type')
            self.type_ = value
            self.type_ = ' '.join(self.type_.split())
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
        value = find_attr_value_('uri', node)
        if value is not None and 'uri' not in already_processed:
            already_processed.add('uri')
            self.uri = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class PropertyType


class siteCodeType(GeneratedsSuper):
    """True if this is the main identifier that this service uses to access
    this site. default value is false. The name of the observation
    network that this site identification is use for. An identifier
    of the site, the type of identifier must be specified."""
    subclass = None
    superclass = None
    def __init__(self, default=None, agencyCode=None, siteID=None, network=None, agencyName=None, valueOf_=None):
        self.original_tagname_ = None
        self.default = _cast(bool, default)
        self.agencyCode = _cast(None, agencyCode)
        self.siteID = _cast(None, siteID)
        self.network = _cast(None, network)
        self.agencyName = _cast(None, agencyName)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if siteCodeType.subclass:
            return siteCodeType.subclass(*args_, **kwargs_)
        else:
            return siteCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_agencyCode(self): return self.agencyCode
    def set_agencyCode(self, agencyCode): self.agencyCode = agencyCode
    def get_siteID(self): return self.siteID
    def set_siteID(self, siteID): self.siteID = siteID
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_agencyName(self): return self.agencyName
    def set_agencyName(self, agencyName): self.agencyName = agencyName
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_positiveInt(self, value):
        # Validate type positiveInt, a restriction on xsi:int.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on positiveInt' % {"value" : value} )
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='siteCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='siteCodeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='siteCodeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='siteCodeType'):
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.agencyCode is not None and 'agencyCode' not in already_processed:
            already_processed.add('agencyCode')
            outfile.write(' agencyCode=%s' % (self.gds_format_string(quote_attrib(self.agencyCode).encode(ExternalEncoding), input_name='agencyCode'), ))
        if self.siteID is not None and 'siteID' not in already_processed:
            already_processed.add('siteID')
            outfile.write(' siteID=%s' % (quote_attrib(self.siteID), ))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.agencyName is not None and 'agencyName' not in already_processed:
            already_processed.add('agencyName')
            outfile.write(' agencyName=%s' % (self.gds_format_string(quote_attrib(self.agencyName).encode(ExternalEncoding), input_name='agencyName'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='siteCodeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('agencyCode', node)
        if value is not None and 'agencyCode' not in already_processed:
            already_processed.add('agencyCode')
            self.agencyCode = value
        value = find_attr_value_('siteID', node)
        if value is not None and 'siteID' not in already_processed:
            already_processed.add('siteID')
            try:
                self.siteID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_positiveInt(self.siteID)    # validate type positiveInt
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
            self.network = ' '.join(self.network.split())
        value = find_attr_value_('agencyName', node)
        if value is not None and 'agencyName' not in already_processed:
            already_processed.add('agencyName')
            self.agencyName = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class siteCodeType


class timeZoneInfoType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, siteUsesDaylightSavingsTime=None, defaultTimeZone=None, daylightSavingsTimeZone=None):
        self.original_tagname_ = None
        self.siteUsesDaylightSavingsTime = _cast(bool, siteUsesDaylightSavingsTime)
        self.defaultTimeZone = defaultTimeZone
        self.daylightSavingsTimeZone = daylightSavingsTimeZone
    def factory(*args_, **kwargs_):
        if timeZoneInfoType.subclass:
            return timeZoneInfoType.subclass(*args_, **kwargs_)
        else:
            return timeZoneInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_defaultTimeZone(self): return self.defaultTimeZone
    def set_defaultTimeZone(self, defaultTimeZone): self.defaultTimeZone = defaultTimeZone
    def get_daylightSavingsTimeZone(self): return self.daylightSavingsTimeZone
    def set_daylightSavingsTimeZone(self, daylightSavingsTimeZone): self.daylightSavingsTimeZone = daylightSavingsTimeZone
    def get_siteUsesDaylightSavingsTime(self): return self.siteUsesDaylightSavingsTime
    def set_siteUsesDaylightSavingsTime(self, siteUsesDaylightSavingsTime): self.siteUsesDaylightSavingsTime = siteUsesDaylightSavingsTime
    def hasContent_(self):
        if (
            self.defaultTimeZone is not None or
            self.daylightSavingsTimeZone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='timeZoneInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='timeZoneInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='timeZoneInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='timeZoneInfoType'):
        if self.siteUsesDaylightSavingsTime is not None and 'siteUsesDaylightSavingsTime' not in already_processed:
            already_processed.add('siteUsesDaylightSavingsTime')
            outfile.write(' siteUsesDaylightSavingsTime="%s"' % self.gds_format_boolean(self.siteUsesDaylightSavingsTime, input_name='siteUsesDaylightSavingsTime'))
    def exportChildren(self, outfile, level, namespace_='', name_='timeZoneInfoType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.defaultTimeZone is not None:
            self.defaultTimeZone.export(outfile, level, namespace_, name_='defaultTimeZone', pretty_print=pretty_print)
        if self.daylightSavingsTimeZone is not None:
            self.daylightSavingsTimeZone.export(outfile, level, namespace_, name_='daylightSavingsTimeZone', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('siteUsesDaylightSavingsTime', node)
        if value is not None and 'siteUsesDaylightSavingsTime' not in already_processed:
            already_processed.add('siteUsesDaylightSavingsTime')
            if value in ('true', '1'):
                self.siteUsesDaylightSavingsTime = True
            elif value in ('false', '0'):
                self.siteUsesDaylightSavingsTime = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'defaultTimeZone':
            obj_ = defaultTimeZoneType.factory()
            obj_.build(child_)
            self.defaultTimeZone = obj_
            obj_.original_tagname_ = 'defaultTimeZone'
        elif nodeName_ == 'daylightSavingsTimeZone':
            obj_ = daylightSavingsTimeZoneType.factory()
            obj_.build(child_)
            self.daylightSavingsTimeZone = obj_
            obj_.original_tagname_ = 'daylightSavingsTimeZone'
# end class timeZoneInfoType


class defaultTimeZoneType(TimeZoneType):
    subclass = None
    superclass = TimeZoneType
    def __init__(self, zoneOffset=None, zoneAbbreviation=None):
        self.original_tagname_ = None
        super(defaultTimeZoneType, self).__init__(zoneOffset, zoneAbbreviation, )
    def factory(*args_, **kwargs_):
        if defaultTimeZoneType.subclass:
            return defaultTimeZoneType.subclass(*args_, **kwargs_)
        else:
            return defaultTimeZoneType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(defaultTimeZoneType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='defaultTimeZoneType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='defaultTimeZoneType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='defaultTimeZoneType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='defaultTimeZoneType'):
        super(defaultTimeZoneType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='defaultTimeZoneType')
    def exportChildren(self, outfile, level, namespace_='', name_='defaultTimeZoneType', fromsubclass_=False, pretty_print=True):
        super(defaultTimeZoneType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(defaultTimeZoneType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(defaultTimeZoneType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class defaultTimeZoneType


class daylightSavingsTimeZoneType(TimeZoneType):
    subclass = None
    superclass = TimeZoneType
    def __init__(self, zoneOffset=None, zoneAbbreviation=None):
        self.original_tagname_ = None
        super(daylightSavingsTimeZoneType, self).__init__(zoneOffset, zoneAbbreviation, )
    def factory(*args_, **kwargs_):
        if daylightSavingsTimeZoneType.subclass:
            return daylightSavingsTimeZoneType.subclass(*args_, **kwargs_)
        else:
            return daylightSavingsTimeZoneType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(daylightSavingsTimeZoneType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='daylightSavingsTimeZoneType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='daylightSavingsTimeZoneType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='daylightSavingsTimeZoneType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='daylightSavingsTimeZoneType'):
        super(daylightSavingsTimeZoneType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='daylightSavingsTimeZoneType')
    def exportChildren(self, outfile, level, namespace_='', name_='daylightSavingsTimeZoneType', fromsubclass_=False, pretty_print=True):
        super(daylightSavingsTimeZoneType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(daylightSavingsTimeZoneType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(daylightSavingsTimeZoneType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class daylightSavingsTimeZoneType


class geoLocationType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, geogLocation=None, localSiteXY=None):
        self.original_tagname_ = None
        self.geogLocation = geogLocation
        if localSiteXY is None:
            self.localSiteXY = []
        else:
            self.localSiteXY = localSiteXY
    def factory(*args_, **kwargs_):
        if geoLocationType.subclass:
            return geoLocationType.subclass(*args_, **kwargs_)
        else:
            return geoLocationType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_geogLocation(self): return self.geogLocation
    def set_geogLocation(self, geogLocation): self.geogLocation = geogLocation
    def get_localSiteXY(self): return self.localSiteXY
    def set_localSiteXY(self, localSiteXY): self.localSiteXY = localSiteXY
    def add_localSiteXY(self, value): self.localSiteXY.append(value)
    def insert_localSiteXY_at(self, index, value): self.localSiteXY.insert(index, value)
    def replace_localSiteXY_at(self, index, value): self.localSiteXY[index] = value
    def hasContent_(self):
        if (
            self.geogLocation is not None or
            self.localSiteXY
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='geoLocationType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='geoLocationType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='geoLocationType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='geoLocationType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='geoLocationType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.geogLocation is not None:
            self.geogLocation.export(outfile, level, namespace_, name_='geogLocation', pretty_print=pretty_print)
        for localSiteXY_ in self.localSiteXY:
            localSiteXY_.export(outfile, level, namespace_, name_='localSiteXY', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'geogLocation':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <geogLocation> element')
            self.geogLocation = obj_
            obj_.original_tagname_ = 'geogLocation'
        elif nodeName_ == 'localSiteXY':
            obj_ = localSiteXYType.factory()
            obj_.build(child_)
            self.localSiteXY.append(obj_)
            obj_.original_tagname_ = 'localSiteXY'
# end class geoLocationType


class localSiteXYType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, projectionInformation=None, X=None, Y=None, Z=None, note=None):
        self.original_tagname_ = None
        self.projectionInformation = _cast(None, projectionInformation)
        self.X = X
        self.Y = Y
        self.Z = Z
        if note is None:
            self.note = []
        else:
            self.note = note
    def factory(*args_, **kwargs_):
        if localSiteXYType.subclass:
            return localSiteXYType.subclass(*args_, **kwargs_)
        else:
            return localSiteXYType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_X(self): return self.X
    def set_X(self, X): self.X = X
    def get_Y(self): return self.Y
    def set_Y(self, Y): self.Y = Y
    def get_Z(self): return self.Z
    def set_Z(self, Z): self.Z = Z
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def add_note(self, value): self.note.append(value)
    def insert_note_at(self, index, value): self.note.insert(index, value)
    def replace_note_at(self, index, value): self.note[index] = value
    def get_projectionInformation(self): return self.projectionInformation
    def set_projectionInformation(self, projectionInformation): self.projectionInformation = projectionInformation
    def hasContent_(self):
        if (
            self.X is not None or
            self.Y is not None or
            self.Z is not None or
            self.note
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='localSiteXYType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='localSiteXYType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='localSiteXYType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='localSiteXYType'):
        if self.projectionInformation is not None and 'projectionInformation' not in already_processed:
            already_processed.add('projectionInformation')
            outfile.write(' projectionInformation=%s' % (self.gds_format_string(quote_attrib(self.projectionInformation).encode(ExternalEncoding), input_name='projectionInformation'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='localSiteXYType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.X is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sX>%s</%sX>%s' % (namespace_, self.gds_format_double(self.X, input_name='X'), namespace_, eol_))
        if self.Y is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sY>%s</%sY>%s' % (namespace_, self.gds_format_double(self.Y, input_name='Y'), namespace_, eol_))
        if self.Z is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sZ>%s</%sZ>%s' % (namespace_, self.gds_format_double(self.Z, input_name='Z'), namespace_, eol_))
        for note_ in self.note:
            note_.export(outfile, level, namespace_, name_='note', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('projectionInformation', node)
        if value is not None and 'projectionInformation' not in already_processed:
            already_processed.add('projectionInformation')
            self.projectionInformation = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'X':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'X')
            self.X = fval_
        elif nodeName_ == 'Y':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Y')
            self.Y = fval_
        elif nodeName_ == 'Z':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'Z')
            self.Z = fval_
        elif nodeName_ == 'note':
            obj_ = NoteType.factory()
            obj_.build(child_)
            self.note.append(obj_)
            obj_.original_tagname_ = 'note'
# end class localSiteXYType


class variableCodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, default=None, network=None, vocabulary=None, variableID=None, valueOf_=None):
        self.original_tagname_ = None
        self.default = _cast(bool, default)
        self.network = _cast(None, network)
        self.vocabulary = _cast(None, vocabulary)
        self.variableID = _cast(None, variableID)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if variableCodeType.subclass:
            return variableCodeType.subclass(*args_, **kwargs_)
        else:
            return variableCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_vocabulary(self): return self.vocabulary
    def set_vocabulary(self, vocabulary): self.vocabulary = vocabulary
    def get_variableID(self): return self.variableID
    def set_variableID(self, variableID): self.variableID = variableID
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def validate_positiveInt(self, value):
        # Validate type positiveInt, a restriction on xsi:int.
        if value is not None and Validate_simpletypes_:
            if value < 0:
                warnings_.warn('Value "%(value)s" does not match xsd minInclusive restriction on positiveInt' % {"value" : value} )
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='variableCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='variableCodeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='variableCodeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='variableCodeType'):
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.vocabulary is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            outfile.write(' vocabulary=%s' % (self.gds_format_string(quote_attrib(self.vocabulary).encode(ExternalEncoding), input_name='vocabulary'), ))
        if self.variableID is not None and 'variableID' not in already_processed:
            already_processed.add('variableID')
            outfile.write(' variableID=%s' % (quote_attrib(self.variableID), ))
    def exportChildren(self, outfile, level, namespace_='', name_='variableCodeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
            self.network = ' '.join(self.network.split())
        value = find_attr_value_('vocabulary', node)
        if value is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            self.vocabulary = value
            self.vocabulary = ' '.join(self.vocabulary.split())
        value = find_attr_value_('variableID', node)
        if value is not None and 'variableID' not in already_processed:
            already_processed.add('variableID')
            try:
                self.variableID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
            self.validate_positiveInt(self.variableID)    # validate type positiveInt
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class variableCodeType


class relatedType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, parentCode=None, relatedCode=None):
        self.original_tagname_ = None
        if parentCode is None:
            self.parentCode = []
        else:
            self.parentCode = parentCode
        if relatedCode is None:
            self.relatedCode = []
        else:
            self.relatedCode = relatedCode
    def factory(*args_, **kwargs_):
        if relatedType.subclass:
            return relatedType.subclass(*args_, **kwargs_)
        else:
            return relatedType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_parentCode(self): return self.parentCode
    def set_parentCode(self, parentCode): self.parentCode = parentCode
    def add_parentCode(self, value): self.parentCode.append(value)
    def insert_parentCode_at(self, index, value): self.parentCode.insert(index, value)
    def replace_parentCode_at(self, index, value): self.parentCode[index] = value
    def get_relatedCode(self): return self.relatedCode
    def set_relatedCode(self, relatedCode): self.relatedCode = relatedCode
    def add_relatedCode(self, value): self.relatedCode.append(value)
    def insert_relatedCode_at(self, index, value): self.relatedCode.insert(index, value)
    def replace_relatedCode_at(self, index, value): self.relatedCode[index] = value
    def hasContent_(self):
        if (
            self.parentCode or
            self.relatedCode
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='relatedType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relatedType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='relatedType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='relatedType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='relatedType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for parentCode_ in self.parentCode:
            parentCode_.export(outfile, level, namespace_, name_='parentCode', pretty_print=pretty_print)
        for relatedCode_ in self.relatedCode:
            relatedCode_.export(outfile, level, namespace_, name_='relatedCode', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'parentCode':
            obj_ = parentCodeType.factory()
            obj_.build(child_)
            self.parentCode.append(obj_)
            obj_.original_tagname_ = 'parentCode'
        elif nodeName_ == 'relatedCode':
            obj_ = relatedCodeType.factory()
            obj_.build(child_)
            self.relatedCode.append(obj_)
            obj_.original_tagname_ = 'relatedCode'
# end class relatedType


class parentCodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, default=None, network=None, vocabulary=None, valueOf_=None):
        self.original_tagname_ = None
        self.default = _cast(bool, default)
        self.network = _cast(None, network)
        self.vocabulary = _cast(None, vocabulary)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if parentCodeType.subclass:
            return parentCodeType.subclass(*args_, **kwargs_)
        else:
            return parentCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_vocabulary(self): return self.vocabulary
    def set_vocabulary(self, vocabulary): self.vocabulary = vocabulary
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='parentCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parentCodeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='parentCodeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='parentCodeType'):
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.vocabulary is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            outfile.write(' vocabulary=%s' % (self.gds_format_string(quote_attrib(self.vocabulary).encode(ExternalEncoding), input_name='vocabulary'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='parentCodeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
            self.network = ' '.join(self.network.split())
        value = find_attr_value_('vocabulary', node)
        if value is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            self.vocabulary = value
            self.vocabulary = ' '.join(self.vocabulary.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class parentCodeType


class relatedCodeType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, default=None, network=None, vocabulary=None, valueOf_=None):
        self.original_tagname_ = None
        self.default = _cast(bool, default)
        self.network = _cast(None, network)
        self.vocabulary = _cast(None, vocabulary)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if relatedCodeType.subclass:
            return relatedCodeType.subclass(*args_, **kwargs_)
        else:
            return relatedCodeType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_default(self): return self.default
    def set_default(self, default): self.default = default
    def get_network(self): return self.network
    def set_network(self, network): self.network = network
    def get_vocabulary(self): return self.vocabulary
    def set_vocabulary(self, vocabulary): self.vocabulary = vocabulary
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='relatedCodeType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='relatedCodeType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='relatedCodeType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='relatedCodeType'):
        if self.default is not None and 'default' not in already_processed:
            already_processed.add('default')
            outfile.write(' default="%s"' % self.gds_format_boolean(self.default, input_name='default'))
        if self.network is not None and 'network' not in already_processed:
            already_processed.add('network')
            outfile.write(' network=%s' % (self.gds_format_string(quote_attrib(self.network).encode(ExternalEncoding), input_name='network'), ))
        if self.vocabulary is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            outfile.write(' vocabulary=%s' % (self.gds_format_string(quote_attrib(self.vocabulary).encode(ExternalEncoding), input_name='vocabulary'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='relatedCodeType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('default', node)
        if value is not None and 'default' not in already_processed:
            already_processed.add('default')
            if value in ('true', '1'):
                self.default = True
            elif value in ('false', '0'):
                self.default = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
        value = find_attr_value_('network', node)
        if value is not None and 'network' not in already_processed:
            already_processed.add('network')
            self.network = value
            self.network = ' '.join(self.network.split())
        value = find_attr_value_('vocabulary', node)
        if value is not None and 'vocabulary' not in already_processed:
            already_processed.add('vocabulary')
            self.vocabulary = value
            self.vocabulary = ' '.join(self.vocabulary.split())
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class relatedCodeType


class timeScaleType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, isRegular=False, unit=None, timeSpacing=None, timeSupport=None):
        self.original_tagname_ = None
        self.isRegular = _cast(bool, isRegular)
        self.unit = unit
        self.timeSpacing = timeSpacing
        self.timeSupport = timeSupport
    def factory(*args_, **kwargs_):
        if timeScaleType.subclass:
            return timeScaleType.subclass(*args_, **kwargs_)
        else:
            return timeScaleType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_unit(self): return self.unit
    def set_unit(self, unit): self.unit = unit
    def get_timeSpacing(self): return self.timeSpacing
    def set_timeSpacing(self, timeSpacing): self.timeSpacing = timeSpacing
    def get_timeSupport(self): return self.timeSupport
    def set_timeSupport(self, timeSupport): self.timeSupport = timeSupport
    def get_isRegular(self): return self.isRegular
    def set_isRegular(self, isRegular): self.isRegular = isRegular
    def hasContent_(self):
        if (
            self.unit is not None or
            self.timeSpacing is not None or
            self.timeSupport is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='timeScaleType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='timeScaleType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='timeScaleType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='timeScaleType'):
        if self.isRegular and 'isRegular' not in already_processed:
            already_processed.add('isRegular')
            outfile.write(' isRegular="%s"' % self.gds_format_boolean(self.isRegular, input_name='isRegular'))
    def exportChildren(self, outfile, level, namespace_='', name_='timeScaleType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.unit is not None:
            self.unit.export(outfile, level, namespace_, name_='unit', pretty_print=pretty_print)
        if self.timeSpacing is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimeSpacing>%s</%stimeSpacing>%s' % (namespace_, self.gds_format_float(self.timeSpacing, input_name='timeSpacing'), namespace_, eol_))
        if self.timeSupport is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%stimeSupport>%s</%stimeSupport>%s' % (namespace_, self.gds_format_float(self.timeSupport, input_name='timeSupport'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('isRegular', node)
        if value is not None and 'isRegular' not in already_processed:
            already_processed.add('isRegular')
            if value in ('true', '1'):
                self.isRegular = True
            elif value in ('false', '0'):
                self.isRegular = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'unit':
            obj_ = UnitsType.factory()
            obj_.build(child_)
            self.unit = obj_
            obj_.original_tagname_ = 'unit'
        elif nodeName_ == 'timeSpacing':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'timeSpacing')
            self.timeSpacing = fval_
        elif nodeName_ == 'timeSupport':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'timeSupport')
            self.timeSupport = fval_
# end class timeScaleType


class categoriesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, category=None):
        self.original_tagname_ = None
        if category is None:
            self.category = []
        else:
            self.category = category
    def factory(*args_, **kwargs_):
        if categoriesType.subclass:
            return categoriesType.subclass(*args_, **kwargs_)
        else:
            return categoriesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def add_category(self, value): self.category.append(value)
    def insert_category_at(self, index, value): self.category.insert(index, value)
    def replace_category_at(self, index, value): self.category[index] = value
    def hasContent_(self):
        if (
            self.category
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='categoriesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='categoriesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='categoriesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='categoriesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='categoriesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for category_ in self.category:
            category_.export(outfile, level, namespace_, name_='category', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'category':
            obj_ = categoryType.factory()
            obj_.build(child_)
            self.category.append(obj_)
            obj_.original_tagname_ = 'category'
# end class categoriesType


class categoryType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, categoryID=None, dataValue=None, description=None):
        self.original_tagname_ = None
        self.categoryID = _cast(int, categoryID)
        self.dataValue = dataValue
        self.description = description
    def factory(*args_, **kwargs_):
        if categoryType.subclass:
            return categoryType.subclass(*args_, **kwargs_)
        else:
            return categoryType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dataValue(self): return self.dataValue
    def set_dataValue(self, dataValue): self.dataValue = dataValue
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_categoryID(self): return self.categoryID
    def set_categoryID(self, categoryID): self.categoryID = categoryID
    def hasContent_(self):
        if (
            self.dataValue is not None or
            self.description is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='categoryType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='categoryType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='categoryType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='categoryType'):
        if self.categoryID is not None and 'categoryID' not in already_processed:
            already_processed.add('categoryID')
            outfile.write(' categoryID="%s"' % self.gds_format_integer(self.categoryID, input_name='categoryID'))
    def exportChildren(self, outfile, level, namespace_='', name_='categoryType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.dataValue is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataValue>%s</%sdataValue>%s' % (namespace_, self.gds_format_float(self.dataValue, input_name='dataValue'), namespace_, eol_))
        if self.description is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdescription>%s</%sdescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('categoryID', node)
        if value is not None and 'categoryID' not in already_processed:
            already_processed.add('categoryID')
            try:
                self.categoryID = int(value)
            except ValueError as exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'dataValue':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'dataValue')
            self.dataValue = fval_
        elif nodeName_ == 'description':
            description_ = child_.text
            description_ = self.gds_validate_string(description_, node, 'description')
            self.description = description_
# end class categoryType


class criteriaType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, MethodCalled=None, locationParam=None, variableParam=None, timeParam=None, parameter=None):
        self.original_tagname_ = None
        self.MethodCalled = _cast(None, MethodCalled)
        self.locationParam = locationParam
        self.variableParam = variableParam
        self.timeParam = timeParam
        if parameter is None:
            self.parameter = []
        else:
            self.parameter = parameter
    def factory(*args_, **kwargs_):
        if criteriaType.subclass:
            return criteriaType.subclass(*args_, **kwargs_)
        else:
            return criteriaType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_locationParam(self): return self.locationParam
    def set_locationParam(self, locationParam): self.locationParam = locationParam
    def get_variableParam(self): return self.variableParam
    def set_variableParam(self, variableParam): self.variableParam = variableParam
    def get_timeParam(self): return self.timeParam
    def set_timeParam(self, timeParam): self.timeParam = timeParam
    def get_parameter(self): return self.parameter
    def set_parameter(self, parameter): self.parameter = parameter
    def add_parameter(self, value): self.parameter.append(value)
    def insert_parameter_at(self, index, value): self.parameter.insert(index, value)
    def replace_parameter_at(self, index, value): self.parameter[index] = value
    def get_MethodCalled(self): return self.MethodCalled
    def set_MethodCalled(self, MethodCalled): self.MethodCalled = MethodCalled
    def hasContent_(self):
        if (
            self.locationParam is not None or
            self.variableParam is not None or
            self.timeParam is not None or
            self.parameter
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='criteriaType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='criteriaType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='criteriaType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='criteriaType'):
        if self.MethodCalled is not None and 'MethodCalled' not in already_processed:
            already_processed.add('MethodCalled')
            outfile.write(' MethodCalled=%s' % (self.gds_format_string(quote_attrib(self.MethodCalled).encode(ExternalEncoding), input_name='MethodCalled'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='criteriaType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.locationParam is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%slocationParam>%s</%slocationParam>%s' % (namespace_, self.gds_format_string(quote_xml(self.locationParam).encode(ExternalEncoding), input_name='locationParam'), namespace_, eol_))
        if self.variableParam is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svariableParam>%s</%svariableParam>%s' % (namespace_, self.gds_format_string(quote_xml(self.variableParam).encode(ExternalEncoding), input_name='variableParam'), namespace_, eol_))
        if self.timeParam is not None:
            self.timeParam.export(outfile, level, namespace_, name_='timeParam', pretty_print=pretty_print)
        for parameter_ in self.parameter:
            parameter_.export(outfile, level, namespace_, name_='parameter', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('MethodCalled', node)
        if value is not None and 'MethodCalled' not in already_processed:
            already_processed.add('MethodCalled')
            self.MethodCalled = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'locationParam':
            locationParam_ = child_.text
            locationParam_ = self.gds_validate_string(locationParam_, node, 'locationParam')
            self.locationParam = locationParam_
        elif nodeName_ == 'variableParam':
            variableParam_ = child_.text
            variableParam_ = self.gds_validate_string(variableParam_, node, 'variableParam')
            self.variableParam = variableParam_
        elif nodeName_ == 'timeParam':
            obj_ = timeParamType.factory()
            obj_.build(child_)
            self.timeParam = obj_
            obj_.original_tagname_ = 'timeParam'
        elif nodeName_ == 'parameter':
            obj_ = parameterType.factory()
            obj_.build(child_)
            self.parameter.append(obj_)
            obj_.original_tagname_ = 'parameter'
# end class criteriaType


class timeParamType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, beginDateTime=None, endDateTime=None):
        self.original_tagname_ = None
        self.beginDateTime = beginDateTime
        self.endDateTime = endDateTime
    def factory(*args_, **kwargs_):
        if timeParamType.subclass:
            return timeParamType.subclass(*args_, **kwargs_)
        else:
            return timeParamType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_beginDateTime(self): return self.beginDateTime
    def set_beginDateTime(self, beginDateTime): self.beginDateTime = beginDateTime
    def get_endDateTime(self): return self.endDateTime
    def set_endDateTime(self, endDateTime): self.endDateTime = endDateTime
    def hasContent_(self):
        if (
            self.beginDateTime is not None or
            self.endDateTime is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='timeParamType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='timeParamType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='timeParamType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='timeParamType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='timeParamType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.beginDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sbeginDateTime>%s</%sbeginDateTime>%s' % (namespace_, self.gds_format_string(quote_xml(self.beginDateTime).encode(ExternalEncoding), input_name='beginDateTime'), namespace_, eol_))
        if self.endDateTime is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sendDateTime>%s</%sendDateTime>%s' % (namespace_, self.gds_format_string(quote_xml(self.endDateTime).encode(ExternalEncoding), input_name='endDateTime'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'beginDateTime':
            beginDateTime_ = child_.text
            beginDateTime_ = self.gds_validate_string(beginDateTime_, node, 'beginDateTime')
            self.beginDateTime = beginDateTime_
        elif nodeName_ == 'endDateTime':
            endDateTime_ = child_.text
            endDateTime_ = self.gds_validate_string(endDateTime_, node, 'endDateTime')
            self.endDateTime = endDateTime_
# end class timeParamType


class parameterType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, name=None, value=None):
        self.original_tagname_ = None
        self.name = _cast(None, name)
        self.value = _cast(None, value)
    def factory(*args_, **kwargs_):
        if parameterType.subclass:
            return parameterType.subclass(*args_, **kwargs_)
        else:
            return parameterType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_name(self): return self.name
    def set_name(self, name): self.name = name
    def get_value(self): return self.value
    def set_value(self, value): self.value = value
    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='parameterType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='parameterType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='parameterType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='parameterType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.add('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.add('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='parameterType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.add('name')
            self.name = value
            self.name = ' '.join(self.name.split())
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.add('value')
            self.value = value
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class parameterType


class timeZoneInfoType1(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, siteUsesDaylightSavingsTime=None, defaultTimeZone=None, daylightSavingsTimeZone=None):
        self.original_tagname_ = None
        self.siteUsesDaylightSavingsTime = _cast(bool, siteUsesDaylightSavingsTime)
        self.defaultTimeZone = defaultTimeZone
        self.daylightSavingsTimeZone = daylightSavingsTimeZone
    def factory(*args_, **kwargs_):
        if timeZoneInfoType1.subclass:
            return timeZoneInfoType1.subclass(*args_, **kwargs_)
        else:
            return timeZoneInfoType1(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_defaultTimeZone(self): return self.defaultTimeZone
    def set_defaultTimeZone(self, defaultTimeZone): self.defaultTimeZone = defaultTimeZone
    def get_daylightSavingsTimeZone(self): return self.daylightSavingsTimeZone
    def set_daylightSavingsTimeZone(self, daylightSavingsTimeZone): self.daylightSavingsTimeZone = daylightSavingsTimeZone
    def get_siteUsesDaylightSavingsTime(self): return self.siteUsesDaylightSavingsTime
    def set_siteUsesDaylightSavingsTime(self, siteUsesDaylightSavingsTime): self.siteUsesDaylightSavingsTime = siteUsesDaylightSavingsTime
    def hasContent_(self):
        if (
            self.defaultTimeZone is not None or
            self.daylightSavingsTimeZone is not None
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='timeZoneInfoType1', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='timeZoneInfoType1')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='timeZoneInfoType1', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='timeZoneInfoType1'):
        if self.siteUsesDaylightSavingsTime is not None and 'siteUsesDaylightSavingsTime' not in already_processed:
            already_processed.add('siteUsesDaylightSavingsTime')
            outfile.write(' siteUsesDaylightSavingsTime="%s"' % self.gds_format_boolean(self.siteUsesDaylightSavingsTime, input_name='siteUsesDaylightSavingsTime'))
    def exportChildren(self, outfile, level, namespace_='', name_='timeZoneInfoType1', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.defaultTimeZone is not None:
            self.defaultTimeZone.export(outfile, level, namespace_, name_='defaultTimeZone', pretty_print=pretty_print)
        if self.daylightSavingsTimeZone is not None:
            self.daylightSavingsTimeZone.export(outfile, level, namespace_, name_='daylightSavingsTimeZone', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('siteUsesDaylightSavingsTime', node)
        if value is not None and 'siteUsesDaylightSavingsTime' not in already_processed:
            already_processed.add('siteUsesDaylightSavingsTime')
            if value in ('true', '1'):
                self.siteUsesDaylightSavingsTime = True
            elif value in ('false', '0'):
                self.siteUsesDaylightSavingsTime = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'defaultTimeZone':
            obj_ = defaultTimeZoneType2.factory()
            obj_.build(child_)
            self.defaultTimeZone = obj_
            obj_.original_tagname_ = 'defaultTimeZone'
        elif nodeName_ == 'daylightSavingsTimeZone':
            obj_ = daylightSavingsTimeZoneType3.factory()
            obj_.build(child_)
            self.daylightSavingsTimeZone = obj_
            obj_.original_tagname_ = 'daylightSavingsTimeZone'
# end class timeZoneInfoType1


class defaultTimeZoneType2(TimeZoneType):
    subclass = None
    superclass = TimeZoneType
    def __init__(self, zoneOffset=None, zoneAbbreviation=None):
        self.original_tagname_ = None
        super(defaultTimeZoneType2, self).__init__(zoneOffset, zoneAbbreviation, )
    def factory(*args_, **kwargs_):
        if defaultTimeZoneType2.subclass:
            return defaultTimeZoneType2.subclass(*args_, **kwargs_)
        else:
            return defaultTimeZoneType2(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(defaultTimeZoneType2, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='defaultTimeZoneType2', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='defaultTimeZoneType2')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='defaultTimeZoneType2', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='defaultTimeZoneType2'):
        super(defaultTimeZoneType2, self).exportAttributes(outfile, level, already_processed, namespace_, name_='defaultTimeZoneType2')
    def exportChildren(self, outfile, level, namespace_='', name_='defaultTimeZoneType2', fromsubclass_=False, pretty_print=True):
        super(defaultTimeZoneType2, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(defaultTimeZoneType2, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(defaultTimeZoneType2, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class defaultTimeZoneType2


class daylightSavingsTimeZoneType3(TimeZoneType):
    subclass = None
    superclass = TimeZoneType
    def __init__(self, zoneOffset=None, zoneAbbreviation=None):
        self.original_tagname_ = None
        super(daylightSavingsTimeZoneType3, self).__init__(zoneOffset, zoneAbbreviation, )
    def factory(*args_, **kwargs_):
        if daylightSavingsTimeZoneType3.subclass:
            return daylightSavingsTimeZoneType3.subclass(*args_, **kwargs_)
        else:
            return daylightSavingsTimeZoneType3(*args_, **kwargs_)
    factory = staticmethod(factory)
    def hasContent_(self):
        if (
            super(daylightSavingsTimeZoneType3, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='daylightSavingsTimeZoneType3', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='daylightSavingsTimeZoneType3')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='daylightSavingsTimeZoneType3', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='daylightSavingsTimeZoneType3'):
        super(daylightSavingsTimeZoneType3, self).exportAttributes(outfile, level, already_processed, namespace_, name_='daylightSavingsTimeZoneType3')
    def exportChildren(self, outfile, level, namespace_='', name_='daylightSavingsTimeZoneType3', fromsubclass_=False, pretty_print=True):
        super(daylightSavingsTimeZoneType3, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(daylightSavingsTimeZoneType3, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(daylightSavingsTimeZoneType3, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class daylightSavingsTimeZoneType3


class seriesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, dataType=None, variable=None, valueCount=None, variableTimeInterval=None, valueType=None, generalCategory=None, sampleMedium=None, method=None, source=None, qualityControlLevel=None, seriesProperty=None):
        self.original_tagname_ = None
        self.dataType = dataType
        self.validate_DataTypeCodeList(self.dataType)
        self.variable = variable
        self.valueCount = valueCount
        self.variableTimeInterval = variableTimeInterval
        self.valueType = valueType
        self.validate_ValueTypeCodeList(self.valueType)
        self.generalCategory = generalCategory
        self.validate_GeneralCategoryCodeList(self.generalCategory)
        self.sampleMedium = sampleMedium
        self.validate_SampleMediumCodeList(self.sampleMedium)
        self.method = method
        self.source = source
        self.qualityControlLevel = qualityControlLevel
        if seriesProperty is None:
            self.seriesProperty = []
        else:
            self.seriesProperty = seriesProperty
    def factory(*args_, **kwargs_):
        if seriesType.subclass:
            return seriesType.subclass(*args_, **kwargs_)
        else:
            return seriesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dataType(self): return self.dataType
    def set_dataType(self, dataType): self.dataType = dataType
    def get_variable(self): return self.variable
    def set_variable(self, variable): self.variable = variable
    def get_valueCount(self): return self.valueCount
    def set_valueCount(self, valueCount): self.valueCount = valueCount
    def get_variableTimeInterval(self): return self.variableTimeInterval
    def set_variableTimeInterval(self, variableTimeInterval): self.variableTimeInterval = variableTimeInterval
    def get_valueType(self): return self.valueType
    def set_valueType(self, valueType): self.valueType = valueType
    def get_generalCategory(self): return self.generalCategory
    def set_generalCategory(self, generalCategory): self.generalCategory = generalCategory
    def get_sampleMedium(self): return self.sampleMedium
    def set_sampleMedium(self, sampleMedium): self.sampleMedium = sampleMedium
    def get_method(self): return self.method
    def set_method(self, method): self.method = method
    def get_source(self): return self.source
    def set_source(self, source): self.source = source
    def get_qualityControlLevel(self): return self.qualityControlLevel
    def set_qualityControlLevel(self, qualityControlLevel): self.qualityControlLevel = qualityControlLevel
    def get_seriesProperty(self): return self.seriesProperty
    def set_seriesProperty(self, seriesProperty): self.seriesProperty = seriesProperty
    def add_seriesProperty(self, value): self.seriesProperty.append(value)
    def insert_seriesProperty_at(self, index, value): self.seriesProperty.insert(index, value)
    def replace_seriesProperty_at(self, index, value): self.seriesProperty[index] = value
    def validate_DataTypeCodeList(self, value):
        # Validate type DataTypeCodeList, a restriction on None.
        pass
    def validate_ValueTypeCodeList(self, value):
        # Validate type ValueTypeCodeList, a restriction on None.
        pass
    def validate_GeneralCategoryCodeList(self, value):
        # Validate type GeneralCategoryCodeList, a restriction on None.
        pass
    def validate_SampleMediumCodeList(self, value):
        # Validate type SampleMediumCodeList, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.dataType is not None or
            self.variable is not None or
            self.valueCount is not None or
            self.variableTimeInterval is not None or
            self.valueType is not None or
            self.generalCategory is not None or
            self.sampleMedium is not None or
            self.method is not None or
            self.source is not None or
            self.qualityControlLevel is not None or
            self.seriesProperty
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='seriesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='seriesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='seriesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='seriesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='seriesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.dataType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataType>%s</%sdataType>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataType).encode(ExternalEncoding), input_name='dataType'), namespace_, eol_))
        if self.variable is not None:
            self.variable.export(outfile, level, namespace_, name_='variable', pretty_print=pretty_print)
        if self.valueCount is not None:
            self.valueCount.export(outfile, level, namespace_, name_='valueCount', pretty_print=pretty_print)
        if self.variableTimeInterval is not None:
            self.variableTimeInterval.export(outfile, level, namespace_, name_='variableTimeInterval', pretty_print=pretty_print)
        if self.valueType is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%svalueType>%s</%svalueType>%s' % (namespace_, self.gds_format_string(quote_xml(self.valueType).encode(ExternalEncoding), input_name='valueType'), namespace_, eol_))
        if self.generalCategory is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sgeneralCategory>%s</%sgeneralCategory>%s' % (namespace_, self.gds_format_string(quote_xml(self.generalCategory).encode(ExternalEncoding), input_name='generalCategory'), namespace_, eol_))
        if self.sampleMedium is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssampleMedium>%s</%ssampleMedium>%s' % (namespace_, self.gds_format_string(quote_xml(self.sampleMedium).encode(ExternalEncoding), input_name='sampleMedium'), namespace_, eol_))
        if self.method is not None:
            self.method.export(outfile, level, namespace_, name_='method', pretty_print=pretty_print)
        if self.source is not None:
            self.source.export(outfile, level, namespace_, name_='source', pretty_print=pretty_print)
        if self.qualityControlLevel is not None:
            self.qualityControlLevel.export(outfile, level, namespace_, name_='qualityControlLevel', pretty_print=pretty_print)
        for seriesProperty_ in self.seriesProperty:
            seriesProperty_.export(outfile, level, namespace_, name_='seriesProperty', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'dataType':
            dataType_ = child_.text
            dataType_ = self.gds_validate_string(dataType_, node, 'dataType')
            self.dataType = dataType_
            # validate type DataTypeCodeList
            self.validate_DataTypeCodeList(self.dataType)
        elif nodeName_ == 'variable':
            obj_ = VariableInfoType.factory()
            obj_.build(child_)
            self.variable = obj_
            obj_.original_tagname_ = 'variable'
        elif nodeName_ == 'valueCount':
            obj_ = valueCountType.factory()
            obj_.build(child_)
            self.valueCount = obj_
            obj_.original_tagname_ = 'valueCount'
        elif nodeName_ == 'variableTimeInterval':
            class_obj_ = self.get_class_obj_(child_, TimePeriodType)
            obj_ = class_obj_.factory()
            obj_.build(child_)
            self.variableTimeInterval = obj_
            obj_.original_tagname_ = 'variableTimeInterval'
        elif nodeName_ == 'valueType':
            valueType_ = child_.text
            valueType_ = self.gds_validate_string(valueType_, node, 'valueType')
            self.valueType = valueType_
            # validate type ValueTypeCodeList
            self.validate_ValueTypeCodeList(self.valueType)
        elif nodeName_ == 'generalCategory':
            generalCategory_ = child_.text
            generalCategory_ = self.gds_validate_string(generalCategory_, node, 'generalCategory')
            self.generalCategory = generalCategory_
            # validate type GeneralCategoryCodeList
            self.validate_GeneralCategoryCodeList(self.generalCategory)
        elif nodeName_ == 'sampleMedium':
            sampleMedium_ = child_.text
            sampleMedium_ = self.gds_validate_string(sampleMedium_, node, 'sampleMedium')
            self.sampleMedium = sampleMedium_
            # validate type SampleMediumCodeList
            self.validate_SampleMediumCodeList(self.sampleMedium)
        elif nodeName_ == 'method':
            obj_ = MethodType.factory()
            obj_.build(child_)
            self.method = obj_
            obj_.original_tagname_ = 'method'
        elif nodeName_ == 'source':
            obj_ = SourceType.factory()
            obj_.build(child_)
            self.source = obj_
            obj_.original_tagname_ = 'source'
        elif nodeName_ == 'qualityControlLevel':
            obj_ = QualityControlLevelType.factory()
            obj_.build(child_)
            self.qualityControlLevel = obj_
            obj_.original_tagname_ = 'qualityControlLevel'
        elif nodeName_ == 'seriesProperty':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.seriesProperty.append(obj_)
            obj_.original_tagname_ = 'seriesProperty'
# end class seriesType


class valueCountType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, countIsEstimated=None, valueOf_=None):
        self.original_tagname_ = None
        self.countIsEstimated = _cast(bool, countIsEstimated)
        self.valueOf_ = valueOf_
    def factory(*args_, **kwargs_):
        if valueCountType.subclass:
            return valueCountType.subclass(*args_, **kwargs_)
        else:
            return valueCountType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_countIsEstimated(self): return self.countIsEstimated
    def set_countIsEstimated(self, countIsEstimated): self.countIsEstimated = countIsEstimated
    def get_valueOf_(self): return self.valueOf_
    def set_valueOf_(self, valueOf_): self.valueOf_ = valueOf_
    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='valueCountType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='valueCountType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_='', name_='valueCountType', pretty_print=pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='valueCountType'):
        if self.countIsEstimated is not None and 'countIsEstimated' not in already_processed:
            already_processed.add('countIsEstimated')
            outfile.write(' countIsEstimated="%s"' % self.gds_format_boolean(self.countIsEstimated, input_name='countIsEstimated'))
    def exportChildren(self, outfile, level, namespace_='', name_='valueCountType', fromsubclass_=False, pretty_print=True):
        pass
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('countIsEstimated', node)
        if value is not None and 'countIsEstimated' not in already_processed:
            already_processed.add('countIsEstimated')
            if value in ('true', '1'):
                self.countIsEstimated = True
            elif value in ('false', '0'):
                self.countIsEstimated = False
            else:
                raise_parse_error(node, 'Bad boolean attribute')
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class valueCountType


class variablesType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, variable=None):
        self.original_tagname_ = None
        if variable is None:
            self.variable = []
        else:
            self.variable = variable
    def factory(*args_, **kwargs_):
        if variablesType.subclass:
            return variablesType.subclass(*args_, **kwargs_)
        else:
            return variablesType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_variable(self): return self.variable
    def set_variable(self, variable): self.variable = variable
    def add_variable(self, value): self.variable.append(value)
    def insert_variable_at(self, index, value): self.variable.insert(index, value)
    def replace_variable_at(self, index, value): self.variable[index] = value
    def hasContent_(self):
        if (
            self.variable
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='variablesType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='variablesType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='variablesType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='variablesType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='variablesType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        for variable_ in self.variable:
            variable_.export(outfile, level, namespace_, name_='variable', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'variable':
            obj_ = VariableInfoType.factory()
            obj_.build(child_)
            self.variable.append(obj_)
            obj_.original_tagname_ = 'variable'
# end class variablesType


class siteType(GeneratedsSuper):
    subclass = None
    superclass = None
    def __init__(self, siteInfo=None, seriesCatalog=None, extension=None):
        self.original_tagname_ = None
        self.siteInfo = siteInfo
        if seriesCatalog is None:
            self.seriesCatalog = []
        else:
            self.seriesCatalog = seriesCatalog
        if extension is None:
            self.extension = []
        else:
            self.extension = extension
    def factory(*args_, **kwargs_):
        if siteType.subclass:
            return siteType.subclass(*args_, **kwargs_)
        else:
            return siteType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_siteInfo(self): return self.siteInfo
    def set_siteInfo(self, siteInfo): self.siteInfo = siteInfo
    def get_seriesCatalog(self): return self.seriesCatalog
    def set_seriesCatalog(self, seriesCatalog): self.seriesCatalog = seriesCatalog
    def add_seriesCatalog(self, value): self.seriesCatalog.append(value)
    def insert_seriesCatalog_at(self, index, value): self.seriesCatalog.insert(index, value)
    def replace_seriesCatalog_at(self, index, value): self.seriesCatalog[index] = value
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def add_extension(self, value): self.extension.append(value)
    def insert_extension_at(self, index, value): self.extension.insert(index, value)
    def replace_extension_at(self, index, value): self.extension[index] = value
    def hasContent_(self):
        if (
            self.siteInfo is not None or
            self.seriesCatalog or
            self.extension
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='siteType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='siteType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='siteType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='siteType'):
        pass
    def exportChildren(self, outfile, level, namespace_='', name_='siteType', fromsubclass_=False, pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.siteInfo is not None:
            self.siteInfo.export(outfile, level, namespace_, name_='siteInfo', pretty_print=pretty_print)
        for seriesCatalog_ in self.seriesCatalog:
            seriesCatalog_.export(outfile, level, namespace_, name_='seriesCatalog', pretty_print=pretty_print)
        for extension_ in self.extension:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespace_, self.gds_format_string(quote_xml(extension_).encode(ExternalEncoding), input_name='extension'), namespace_, eol_))
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        pass
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'siteInfo':
            obj_ = SiteInfoType.factory()
            obj_.build(child_)
            self.siteInfo = obj_
            obj_.original_tagname_ = 'siteInfo'
        elif nodeName_ == 'seriesCatalog':
            obj_ = seriesCatalogType.factory()
            obj_.build(child_)
            self.seriesCatalog.append(obj_)
            obj_.original_tagname_ = 'seriesCatalog'
        elif nodeName_ == 'extension':
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, 'extension')
            self.extension.append(extension_)
# end class siteType


class DataSetInfoType(SourceInfoType):
    subclass = None
    superclass = SourceInfoType
    def __init__(self, dataSetIdentifier=None, timeZoneInfo=None, dataSetDescription=None, note=None, dataSetLocation=None, extension=None, dataSetProperty=None):
        self.original_tagname_ = None
        super(DataSetInfoType, self).__init__()
        self.dataSetIdentifier = dataSetIdentifier
        self.timeZoneInfo = timeZoneInfo
        self.dataSetDescription = dataSetDescription
        if note is None:
            self.note = []
        else:
            self.note = note
        self.dataSetLocation = dataSetLocation
        self.extension = extension
        if dataSetProperty is None:
            self.dataSetProperty = []
        else:
            self.dataSetProperty = dataSetProperty
    def factory(*args_, **kwargs_):
        if DataSetInfoType.subclass:
            return DataSetInfoType.subclass(*args_, **kwargs_)
        else:
            return DataSetInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_dataSetIdentifier(self): return self.dataSetIdentifier
    def set_dataSetIdentifier(self, dataSetIdentifier): self.dataSetIdentifier = dataSetIdentifier
    def get_timeZoneInfo(self): return self.timeZoneInfo
    def set_timeZoneInfo(self, timeZoneInfo): self.timeZoneInfo = timeZoneInfo
    def get_dataSetDescription(self): return self.dataSetDescription
    def set_dataSetDescription(self, dataSetDescription): self.dataSetDescription = dataSetDescription
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def add_note(self, value): self.note.append(value)
    def insert_note_at(self, index, value): self.note.insert(index, value)
    def replace_note_at(self, index, value): self.note[index] = value
    def get_dataSetLocation(self): return self.dataSetLocation
    def set_dataSetLocation(self, dataSetLocation): self.dataSetLocation = dataSetLocation
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def get_dataSetProperty(self): return self.dataSetProperty
    def set_dataSetProperty(self, dataSetProperty): self.dataSetProperty = dataSetProperty
    def add_dataSetProperty(self, value): self.dataSetProperty.append(value)
    def insert_dataSetProperty_at(self, index, value): self.dataSetProperty.insert(index, value)
    def replace_dataSetProperty_at(self, index, value): self.dataSetProperty[index] = value
    def hasContent_(self):
        if (
            self.dataSetIdentifier is not None or
            self.timeZoneInfo is not None or
            self.dataSetDescription is not None or
            self.note or
            self.dataSetLocation is not None or
            self.extension is not None or
            self.dataSetProperty or
            super(DataSetInfoType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='DataSetInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='DataSetInfoType')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='DataSetInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='DataSetInfoType'):
        super(DataSetInfoType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='DataSetInfoType')
    def exportChildren(self, outfile, level, namespace_='', name_='DataSetInfoType', fromsubclass_=False, pretty_print=True):
        super(DataSetInfoType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.dataSetIdentifier is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataSetIdentifier>%s</%sdataSetIdentifier>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataSetIdentifier).encode(ExternalEncoding), input_name='dataSetIdentifier'), namespace_, eol_))
        if self.timeZoneInfo is not None:
            self.timeZoneInfo.export(outfile, level, namespace_, name_='timeZoneInfo', pretty_print=pretty_print)
        if self.dataSetDescription is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sdataSetDescription>%s</%sdataSetDescription>%s' % (namespace_, self.gds_format_string(quote_xml(self.dataSetDescription).encode(ExternalEncoding), input_name='dataSetDescription'), namespace_, eol_))
        for note_ in self.note:
            note_.export(outfile, level, namespace_, name_='note', pretty_print=pretty_print)
        if self.dataSetLocation is not None:
            self.dataSetLocation.export(outfile, level, namespace_, name_='dataSetLocation', pretty_print=pretty_print)
        if self.extension is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespace_, self.gds_format_string(quote_xml(self.extension).encode(ExternalEncoding), input_name='extension'), namespace_, eol_))
        for dataSetProperty_ in self.dataSetProperty:
            dataSetProperty_.export(outfile, level, namespace_, name_='dataSetProperty', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        super(DataSetInfoType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'dataSetIdentifier':
            dataSetIdentifier_ = child_.text
            dataSetIdentifier_ = self.gds_validate_string(dataSetIdentifier_, node, 'dataSetIdentifier')
            self.dataSetIdentifier = dataSetIdentifier_
        elif nodeName_ == 'timeZoneInfo':
            obj_ = timeZoneInfoType1.factory()
            obj_.build(child_)
            self.timeZoneInfo = obj_
            obj_.original_tagname_ = 'timeZoneInfo'
        elif nodeName_ == 'dataSetDescription':
            dataSetDescription_ = child_.text
            dataSetDescription_ = self.gds_validate_string(dataSetDescription_, node, 'dataSetDescription')
            self.dataSetDescription = dataSetDescription_
        elif nodeName_ == 'note':
            obj_ = NoteType.factory()
            obj_.build(child_)
            self.note.append(obj_)
            obj_.original_tagname_ = 'note'
        elif nodeName_ == 'dataSetLocation':
            type_name_ = child_.attrib.get(
                '{http://www.w3.org/2001/XMLSchema-instance}type')
            if type_name_ is None:
                type_name_ = child_.attrib.get('type')
            if type_name_ is not None:
                type_names_ = type_name_.split(':')
                if len(type_names_) == 1:
                    type_name_ = type_names_[0]
                else:
                    type_name_ = type_names_[1]
                class_ = globals()[type_name_]
                obj_ = class_.factory()
                obj_.build(child_)
            else:
                raise NotImplementedError(
                    'Class not implemented for <dataSetLocation> element')
            self.dataSetLocation = obj_
            obj_.original_tagname_ = 'dataSetLocation'
        elif nodeName_ == 'extension':
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, 'extension')
            self.extension = extension_
        elif nodeName_ == 'dataSetProperty':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.dataSetProperty.append(obj_)
            obj_.original_tagname_ = 'dataSetProperty'
        super(DataSetInfoType, self).buildChildren(child_, node, nodeName_, True)
# end class DataSetInfoType


class SiteInfoType(SourceInfoType):
    """A sampling station is any place where data are collected."""
    subclass = None
    superclass = SourceInfoType
    def __init__(self, metadataTime=None, oid=None, siteName=None, siteCode=None, timeZoneInfo=None, geoLocation=None, elevation_m=None, verticalDatum=None, note=None, extension=None, altname=None, siteType=None, siteProperty=None):
        self.original_tagname_ = None
        super(SiteInfoType, self).__init__()
        if isinstance(metadataTime, basestring):
            initvalue_ = datetime_.datetime.strptime(metadataTime, '%Y-%m-%dT%H:%M:%S')
        else:
            initvalue_ = metadataTime
        self.metadataTime = initvalue_
        self.oid = _cast(None, oid)
        self.siteName = siteName
        if siteCode is None:
            self.siteCode = []
        else:
            self.siteCode = siteCode
        self.timeZoneInfo = timeZoneInfo
        self.geoLocation = geoLocation
        self.elevation_m = elevation_m
        self.verticalDatum = verticalDatum
        if note is None:
            self.note = []
        else:
            self.note = note
        self.extension = extension
        self.altname = altname
        if siteType is None:
            self.siteType = []
        else:
            self.siteType = siteType
        if siteProperty is None:
            self.siteProperty = []
        else:
            self.siteProperty = siteProperty
    def factory(*args_, **kwargs_):
        if SiteInfoType.subclass:
            return SiteInfoType.subclass(*args_, **kwargs_)
        else:
            return SiteInfoType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_siteName(self): return self.siteName
    def set_siteName(self, siteName): self.siteName = siteName
    def get_siteCode(self): return self.siteCode
    def set_siteCode(self, siteCode): self.siteCode = siteCode
    def add_siteCode(self, value): self.siteCode.append(value)
    def insert_siteCode_at(self, index, value): self.siteCode.insert(index, value)
    def replace_siteCode_at(self, index, value): self.siteCode[index] = value
    def get_timeZoneInfo(self): return self.timeZoneInfo
    def set_timeZoneInfo(self, timeZoneInfo): self.timeZoneInfo = timeZoneInfo
    def get_geoLocation(self): return self.geoLocation
    def set_geoLocation(self, geoLocation): self.geoLocation = geoLocation
    def get_elevation_m(self): return self.elevation_m
    def set_elevation_m(self, elevation_m): self.elevation_m = elevation_m
    def get_verticalDatum(self): return self.verticalDatum
    def set_verticalDatum(self, verticalDatum): self.verticalDatum = verticalDatum
    def get_note(self): return self.note
    def set_note(self, note): self.note = note
    def add_note(self, value): self.note.append(value)
    def insert_note_at(self, index, value): self.note.insert(index, value)
    def replace_note_at(self, index, value): self.note[index] = value
    def get_extension(self): return self.extension
    def set_extension(self, extension): self.extension = extension
    def get_altname(self): return self.altname
    def set_altname(self, altname): self.altname = altname
    def get_siteType(self): return self.siteType
    def set_siteType(self, siteType): self.siteType = siteType
    def add_siteType(self, value): self.siteType.append(value)
    def insert_siteType_at(self, index, value): self.siteType.insert(index, value)
    def replace_siteType_at(self, index, value): self.siteType[index] = value
    def get_siteProperty(self): return self.siteProperty
    def set_siteProperty(self, siteProperty): self.siteProperty = siteProperty
    def add_siteProperty(self, value): self.siteProperty.append(value)
    def insert_siteProperty_at(self, index, value): self.siteProperty.insert(index, value)
    def replace_siteProperty_at(self, index, value): self.siteProperty[index] = value
    def get_metadataTime(self): return self.metadataTime
    def set_metadataTime(self, metadataTime): self.metadataTime = metadataTime
    def get_oid(self): return self.oid
    def set_oid(self, oid): self.oid = oid
    def validate_SiteTypeCodeList(self, value):
        # Validate type SiteTypeCodeList, a restriction on None.
        pass
    def hasContent_(self):
        if (
            self.siteName is not None or
            self.siteCode or
            self.timeZoneInfo is not None or
            self.geoLocation is not None or
            self.elevation_m is not None or
            self.verticalDatum is not None or
            self.note or
            self.extension is not None or
            self.altname is not None or
            self.siteType or
            self.siteProperty or
            super(SiteInfoType, self).hasContent_()
        ):
            return True
        else:
            return False
    def export(self, outfile, level, namespace_='', name_='SiteInfoType', namespacedef_='', pretty_print=True):
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.original_tagname_ is not None:
            name_ = self.original_tagname_
        showIndent(outfile, level, pretty_print)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = set()
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='SiteInfoType')
        outfile.write(u' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
        outfile.write(u' xsi:type="SiteInfoType"')
        if self.hasContent_():
            outfile.write('>%s' % (eol_, ))
            self.exportChildren(outfile, level + 1, namespace_='', name_='SiteInfoType', pretty_print=pretty_print)
            showIndent(outfile, level, pretty_print)
            outfile.write('</%s%s>%s' % (namespace_, name_, eol_))
        else:
            outfile.write('/>%s' % (eol_, ))
    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='SiteInfoType'):
        super(SiteInfoType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='SiteInfoType')
        if self.metadataTime is not None and 'metadataTime' not in already_processed:
            already_processed.add('metadataTime')
            outfile.write(' metadataTime="%s"' % self.gds_format_datetime(self.metadataTime, input_name='metadataTime'))
        if self.oid is not None and 'oid' not in already_processed:
            already_processed.add('oid')
            outfile.write(' oid=%s' % (self.gds_format_string(quote_attrib(self.oid).encode(ExternalEncoding), input_name='oid'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='SiteInfoType', fromsubclass_=False, pretty_print=True):
        super(SiteInfoType, self).exportChildren(outfile, level, namespace_, name_, True, pretty_print=pretty_print)
        if pretty_print:
            eol_ = '\n'
        else:
            eol_ = ''
        if self.siteName is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssiteName>%s</%ssiteName>%s' % (namespace_, self.gds_format_string(quote_xml(self.siteName).encode(ExternalEncoding), input_name='siteName'), namespace_, eol_))
        for siteCode_ in self.siteCode:
            siteCode_.export(outfile, level, namespace_, name_='siteCode', pretty_print=pretty_print)
        if self.timeZoneInfo is not None:
            self.timeZoneInfo.export(outfile, level, namespace_, name_='timeZoneInfo', pretty_print=pretty_print)
        if self.geoLocation is not None:
            self.geoLocation.export(outfile, level, namespace_, name_='geoLocation', pretty_print=pretty_print)
        if self.elevation_m is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%selevation_m>%s</%selevation_m>%s' % (namespace_, self.gds_format_double(self.elevation_m, input_name='elevation_m'), namespace_, eol_))
        if self.verticalDatum is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sverticalDatum>%s</%sverticalDatum>%s' % (namespace_, self.gds_format_string(quote_xml(self.verticalDatum).encode(ExternalEncoding), input_name='verticalDatum'), namespace_, eol_))
        for note_ in self.note:
            note_.export(outfile, level, namespace_, name_='note', pretty_print=pretty_print)
        if self.extension is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%sextension>%s</%sextension>%s' % (namespace_, self.gds_format_string(quote_xml(self.extension).encode(ExternalEncoding), input_name='extension'), namespace_, eol_))
        if self.altname is not None:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%saltname>%s</%saltname>%s' % (namespace_, self.gds_format_string(quote_xml(self.altname).encode(ExternalEncoding), input_name='altname'), namespace_, eol_))
        for siteType_ in self.siteType:
            showIndent(outfile, level, pretty_print)
            outfile.write('<%ssiteType>%s</%ssiteType>%s' % (namespace_, self.gds_format_string(quote_xml(siteType_).encode(ExternalEncoding), input_name='siteType'), namespace_, eol_))
        for siteProperty_ in self.siteProperty:
            siteProperty_.export(outfile, level, namespace_, name_='siteProperty', pretty_print=pretty_print)
    def build(self, node):
        already_processed = set()
        self.buildAttributes(node, node.attrib, already_processed)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)
        return self
    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('metadataTime', node)
        if value is not None and 'metadataTime' not in already_processed:
            already_processed.add('metadataTime')
            try:
                self.metadataTime = self.gds_parse_datetime(value)
            except ValueError as exp:
                raise ValueError('Bad date-time attribute (metadataTime): %s' % exp)
        value = find_attr_value_('oid', node)
        if value is not None and 'oid' not in already_processed:
            already_processed.add('oid')
            self.oid = value
        super(SiteInfoType, self).buildAttributes(node, attrs, already_processed)
    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'siteName':
            siteName_ = child_.text
            siteName_ = self.gds_validate_string(siteName_, node, 'siteName')
            self.siteName = siteName_
        elif nodeName_ == 'siteCode':
            obj_ = siteCodeType.factory()
            obj_.build(child_)
            self.siteCode.append(obj_)
            obj_.original_tagname_ = 'siteCode'
        elif nodeName_ == 'timeZoneInfo':
            obj_ = timeZoneInfoType.factory()
            obj_.build(child_)
            self.timeZoneInfo = obj_
            obj_.original_tagname_ = 'timeZoneInfo'
        elif nodeName_ == 'geoLocation':
            obj_ = geoLocationType.factory()
            obj_.build(child_)
            self.geoLocation = obj_
            obj_.original_tagname_ = 'geoLocation'
        elif nodeName_ == 'elevation_m':
            sval_ = child_.text
            try:
                fval_ = float(sval_)
            except (TypeError, ValueError) as exp:
                raise_parse_error(child_, 'requires float or double: %s' % exp)
            fval_ = self.gds_validate_float(fval_, node, 'elevation_m')
            self.elevation_m = fval_
        elif nodeName_ == 'verticalDatum':
            verticalDatum_ = child_.text
            verticalDatum_ = self.gds_validate_string(verticalDatum_, node, 'verticalDatum')
            self.verticalDatum = verticalDatum_
        elif nodeName_ == 'note':
            obj_ = NoteType.factory()
            obj_.build(child_)
            self.note.append(obj_)
            obj_.original_tagname_ = 'note'
        elif nodeName_ == 'extension':
            extension_ = child_.text
            extension_ = self.gds_validate_string(extension_, node, 'extension')
            self.extension = extension_
        elif nodeName_ == 'altname':
            altname_ = child_.text
            altname_ = self.gds_validate_string(altname_, node, 'altname')
            self.altname = altname_
        elif nodeName_ == 'siteType':
            siteType_ = child_.text
            siteType_ = self.gds_validate_string(siteType_, node, 'siteType')
            self.siteType.append(siteType_)
            # validate type SiteTypeCodeList
            self.validate_SiteTypeCodeList(self.siteType[-1])
        elif nodeName_ == 'siteProperty':
            obj_ = PropertyType.factory()
            obj_.build(child_)
            self.siteProperty.append(obj_)
            obj_.original_tagname_ = 'siteProperty'
        super(SiteInfoType, self).buildChildren(child_, node, nodeName_, True)
# end class SiteInfoType


GDSClassesMapping = {
    'labSourceDetails': SourceType,
    'labMethod': LabMethodType,
    'series': seriesType,
    'variables': variablesType,
    'censorCode': CensorCodeType,
    'contactInformation': ContactInformationType,
    'site': siteType,
    'related': relatedType,
    'siteInfo': SiteInfoType,
    'sample': SampleType,
    'variable': VariableInfoType,
    'localSiteXY': localSiteXYType,
    'unit': UnitsType,
    'category': categoryType,
    'timeSeriesResponse': TimeSeriesResponseType,
    'seriesCatalog': seriesCatalogType,
    'seriesCatalogProperty': PropertyType,
    'timeZoneInfo': timeZoneInfoType1,
    'daylightSavingsTimeZone': daylightSavingsTimeZoneType3,
    'geogLocation': GeogLocationType,
    'parentCode': parentCodeType,
    'note': NoteType,
    'source': SourceType,
    'variableProperty': PropertyType,
    'siteCode': siteCodeType,
    'timeSeries': TimeSeriesType,
    'criteria': criteriaType,
    'units': UnitsType,
    'dataSetLocation': GeogLocationType,
    'variableCode': variableCodeType,
    'parameter': parameterType,
    'method': MethodType,
    'metadata': MetaDataType,
    'queryInfo': QueryInfoType,
    'qualifier': QualifierType,
    'variableTimeInterval': TimePeriodType,
    'variablesResponse': VariablesResponseType,
    'seriesProperty': PropertyType,
    'dataSetProperty': PropertyType,
    'offset': OffsetType,
    'coordLatLong': CoordType,
    'qualityControlLevel': QualityControlLevelType,
    'relatedCode': relatedCodeType,
    'categories': categoriesType,
    'geoLocation': geoLocationType,
    'timeParam': timeParamType,
    'timeScale': timeScaleType,
    'defaultTimeZone': defaultTimeZoneType2,
    'siteProperty': PropertyType,
    'sourceInfo': SourceInfoType,
    'value': ValueSingleVariable,
    'sitesResponse': SiteInfoResponseType,
    'valueCount': valueCountType,
    'values': TsValuesSingleVariableType,
}


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print(USAGE_TEXT)
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = GDSClassesMapping.get(tag)
    if rootClass is None:
        rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'SiteInfoType'
        rootClass = SiteInfoType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='',
            pretty_print=True)
    return rootObj


def parseEtree(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'SiteInfoType'
        rootClass = SiteInfoType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    mapping = {}
    rootElement = rootObj.to_etree(None, name_=rootTag, mapping_=mapping)
    reverse_mapping = rootObj.gds_reverse_node_mapping(mapping)
    if not silence:
        content = etree_.tostring(
            rootElement, pretty_print=True,
            xml_declaration=True, encoding="utf-8")
        sys.stdout.write(content)
        sys.stdout.write('\n')
    return rootObj, rootElement, mapping, reverse_mapping


def parseString(inString, silence=False):
    from StringIO import StringIO
    parser = None
    doc = parsexml_(StringIO(inString), parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'SiteInfoType'
        rootClass = SiteInfoType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('<?xml version="1.0" ?>\n')
        rootObj.export(
            sys.stdout, 0, name_=rootTag,
            namespacedef_='')
    return rootObj


def parseLiteral(inFileName, silence=False):
    parser = None
    doc = parsexml_(inFileName, parser)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'SiteInfoType'
        rootClass = SiteInfoType
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    if not silence:
        sys.stdout.write('#from WaterML_1_1 import *\n\n')
        sys.stdout.write('import WaterML_1_1 as model_\n\n')
        sys.stdout.write('rootObj = model_.rootClass(\n')
        rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
        sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "CensorCodeType",
    "ContactInformationType",
    "CoordType",
    "DataSetInfoType",
    "DocumentationType",
    "GeogLocationType",
    "LabMethodType",
    "LatLonBoxType",
    "LatLonPointType",
    "MetaDataType",
    "MethodType",
    "NoteType",
    "OffsetType",
    "PropertyType",
    "QualifierType",
    "QualityControlLevelType",
    "QueryInfoType",
    "SampleType",
    "SiteInfoResponseType",
    "SiteInfoType",
    "SourceInfoType",
    "SourceType",
    "TimeIntervalType",
    "TimePeriodRealTimeType",
    "TimePeriodType",
    "TimeSeriesResponseType",
    "TimeSeriesType",
    "TimeSingleType",
    "TimeZoneType",
    "TsValuesSingleVariableType",
    "UnitsType",
    "ValueSingleVariable",
    "VariableInfoType",
    "VariablesResponseType",
    "categoriesType",
    "categoryType",
    "criteriaType",
    "daylightSavingsTimeZoneType",
    "daylightSavingsTimeZoneType3",
    "defaultTimeZoneType",
    "defaultTimeZoneType2",
    "geoLocationType",
    "latLonLineString",
    "localSiteXYType",
    "option",
    "options",
    "parameterType",
    "parentCodeType",
    "relatedCodeType",
    "relatedType",
    "seriesCatalogType",
    "seriesType",
    "siteCodeType",
    "siteType",
    "timeParamType",
    "timeScaleType",
    "timeZoneInfoType",
    "timeZoneInfoType1",
    "valueCountType",
    "variableCodeType",
    "variablesType"
]
