
(function($){
	$.fn.shoppingList = function(options) {

		// Options par defaut
		var defaults = {};

		var options = $.extend(defaults, options);

		this.each(function(){

			var obj = $(this);

			// Empcher la slection des lments  la sourirs (meilleure gestion du drag & drop)
			//var _preventDefault = function(evt) { evt.preventDefault(); };
			//$("li").bind("dragstart", _preventDefault).bind("selectstart", _preventDefault);

			$("li").disableSelection();

			// Initialisation du composant "sortable"
			$(obj).sortable({
				axis: "y", // Le sortable ne s'applique que sur l'axe vertical
				containment: ".shoppingList", // Le drag ne peut sortir de l'lment qui contient la liste
//				handle: ".item", // Le drag ne peut se faire que sur l'lment .item (le texte)
				distance: 10, // Le drag ne commence qu' partir de 10px de distance de l'lment
				// Evenement appel lorsque l'lment est relach
				stop: function(event, ui){
					// Pour chaque item de liste
					$(obj).find("li").each(function(){
						// On actualise sa position
						index = parseInt($(this).index()+1);
						// On la met  jour dans la page
						$(this).find(".count").text(index);
					});
				}
			});

			// On ajoute l'lment Poubelle  notre liste
			$(obj).after("<div class='trash'>Trash</div>");
			// On ajoute un petit formulaire pour ajouter des items
			$(obj).after("<div class='add'><input class='addValue' /> <input type='button' value='+' class='addBtn' /></div>");

			// Action de la poubelle
			// Initialisation du composant Droppable
			$(".trash").droppable({
				// Lorsque l'on relache un lment sur la poubelle
				drop: function(event, ui){
					// On retire la classe "hover" associe au div .trash
					$(this).removeClass("hover");
					// On ajoute la classe "deleted" au div .trash pour signifier que l'lment a bien t supprim
					$(this).addClass("deleted");
					// On affiche un petit message "Cet lment a t supprim" en rcuprant la valeur textuelle de l'lment relach
					$.ajax({
					    url: 'rm',
					    data: {id: ui.draggable.data('item')},
					});
					$(this).text(ui.draggable.find(".item").text()+" removed !");
					// On supprimer l'lment de la page, le setTimeout est un fix pour IE (http://dev.jqueryui.com/ticket/4088)
					setTimeout(function() { ui.draggable.remove(); }, 1);

					// On retourne  l'tat originel de la poubelle aprs 2000 ms soit 2 secondes
					elt = $(this);
					setTimeout(function(){ elt.removeClass("deleted"); elt.text("Trash"); }, 2000);
				},
				// Lorsque l'on passe un lment au dessus de la poubelle
				over: function(event, ui){
					// On ajoute la classe "hover" au div .trash
					$(this).addClass("hover");
					// On cache l'lment dplac
					ui.draggable.hide();
					// On indique via un petit message si l'on veut bien supprimer cet lment
					$(this).text("Remove "+ui.draggable.find(".item").text());
					// On change le curseur
					$(this).css("cursor", "pointer");
				},
				// Lorsque l'on quitte la poubelle
				out: function(event, ui){
					// On retire la classe "hover" au div .trash
					$(this).removeClass("hover");
					// On raffiche l'lment dplac
					ui.draggable.show();
					// On remet le texte par dfaut
					$(this).text("Trash");
					// Ainsi que le curseur par dfaut
					$(this).css("cursor", "normal");
				}
			})

			/*
			* Ajouter les controles sur le bouton "ajouter"
			*
			* @Return void
			*/

			// Bouton ajouter
			$(".addBtn").click(function(){
				// Si le texte n'est pas vide
				if($(".addValue").val() != "")
				{
				    var name=$(".addValue").val();
				    $.ajax({url:"add",
				        data: {text: name},
				        dataType: "text",
				        success: function(data, status, req) {
        					// On ajoute un nouvel item  notre liste
					        $(obj).append('<li>'+name+'</li>');
					        // On ajoute les contrles  notre nouvel item
					        $(obj).find("li:last-child").data('item', data);
					        addControls($(obj).find("li:last-child"));
				        }
				    });
					// On rinitialise le champ de texte pour l'ajout
					$(".addValue").val("");
				}
			})
			// On autorise galement la validation de la saisie d'un nouvel item par pression de la touche entre
			$(".addValue").live("keyup", function(e) {
				if(e.keyCode == 13) {
					// On lance l'vnement click associ au bouton d'ajout d'item
					$(".addBtn").trigger("click");
				}
			});

			// Pour chaque lment trouv dans la liste de dpart
			$(obj).find("li").each(function(){
				// On ajoute les contrles
				addControls($(this));
			});

		});

		/*
		* Fonction qui ajoute les contrles aux items
		* @Paramtres
		*  - elt: lment courant (liste courante)
		*
		* @Return void
		*/

		function addControls(elt)
		{
            $(elt).disableSelection();
			// On ajoute en premier l'lment textuel
			$(elt).html("<span class='item'>"+$(elt).text()+"</span>");
			// Puis l'lment de position
			$(elt).prepend('<span class="count">'+parseInt($(elt).index()+1)+'</span>');
			// Puis l'lment d'action (lment achet)
			$(elt).prepend('<span class="check unchecked"></span>');

			// Au clic sur cet lment
			$(elt).find(".check").click(function(){
				// On alterne la classe de l'item (le <li>), le CSS associ fera que l'lment sera barr
				$(this).parent().toggleClass("bought");

				// Si cet lment est achet
				if($(this).parent().hasClass("bought"))
					// On modifie la classe en ajoutant la classe "checked"
					$(this).removeClass("unchecked").addClass("checked");
				// Le cas contraire
				else
					// On modifie la classe en retirant la classe "checked"
					$(this).removeClass("checked").addClass("unchecked");
			})

			// Au double clic sur le texte
			$(elt).find(".item").dblclick(function(){
				// On rcupre sa valeur
				txt = $(this).text();
				// On ajoute un champ de saisie avec la valeur
				$(this).html("<input value='"+txt+"' />");
				// On la slectionne par dfaut
				$(this).find("input").select();
			})

			// Lorsque l'on quitte la zone de saisie du texte
			$(elt).find(".item input").live("blur", function(){
				// On rcupre la valeur du champ de saisie
				txt = $(this).val();
				// On insre dans le <li> la nouvelle valeur textuelle
				$.ajax({
				url: 'edit',
				data: {id:$(this).parent().parent().data('item'), text:txt}
				});
				$(this).parent().html(txt);
			})

			// On autorise la mme action lorsque l'on valide par la touche entre
			$(elt).find(".item input").live("keyup", function(e) {
				if(e.keyCode == 13) {
					$(this).trigger("blur");
				}
			});
		}

		// On continue le chainage JQuery
		return this;
	};
})(jQuery);
