""" cgenerator
~~~~~~~~~~
The module implements container generation.
:copyright: 2016 by Alexey Voronin.
:license: GPL, see LICENSE for more details.
"""

#!/usr/bin/env

import sys
import time
import os

templates_storage = os.path.realpath(os.path.dirname(__file__)) + '/templates/'
replacements = {'<%name_upper%>': 'UINT', '<%name%>': 'uint',
                '<%name_prefix%>': 'uint', '<%simple%>': '', '<%custom%>': ''}


def add_comments_to_file(wfile, file_name):
    wfile.write('//Generated by: ' + time.strftime("%c") + '\n')
    wfile.write('//File: ' + file_name + '\n\n')


def generate_file(input_file_path, out_file_path):
    with open(input_file_path) as infile, open(out_file_path, 'w') as outfile:
        add_comments_to_file(outfile, os.path.basename(out_file_path))
        for line in infile:
            for src, target in replacements.iteritems():
                line = line.replace(src, target)
            outfile.write(line)


def generate(entity_name, output_dir, custom, types):
    set_replacements(entity_name, custom)
    if output_dir[-1] != '/' or output_dir[-1] != '\\':
        output_dir += '/'
    types_list = types.split(',')
    short_name = entity_name.replace("struct ", "")
    for type_item in types_list:
        if type_item == "list":
            generate_file(templates_storage + 'clist.c.tmp',
                          output_dir + 'clist_' + short_name + '.c')
            generate_file(templates_storage + 'clist.h.tmp',
                          output_dir + 'clist_' + short_name + '.h')
        elif type_item == "vector":
            generate_file(templates_storage + 'cvector.c.tmp',
                          output_dir + 'cvector_' + short_name + '.c')
            generate_file(templates_storage + 'cvector.h.tmp',
                          output_dir + 'cvector_' + short_name + '.h')
        else:
            print "Unkrow type: " + type_item
            sys.exit(-1)
    generate_file(templates_storage + 'ctypes.h.tmp', output_dir + 'ctypes.h')
    generate_file(templates_storage + 'entity.h.tmp',
                  output_dir + 'entity_' + short_name + '.h')
    generate_file(templates_storage + 'entity.c.tmp',
                  output_dir + 'entity_' + short_name + '.c')


def set_replacements(entity_name, custom):
    replacements['<%name%>'] = entity_name
    replacements['<%name_upper%>'] = entity_name.replace(
        "struct ", "").upper().replace(" ", "_")
    replacements['<%name_prefix%>'] = entity_name.replace(
        "struct ", "").replace(" ", "_")
    if custom == False:
        replacements['<%simple%>'] = ''
        replacements['<%custom%>'] = '//'
    else:
        replacements['<%simple%>'] = '//'
        replacements['<%custom%>'] = ''


def main():
    if len(sys.argv) == 5:
        generate(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
        print "Done."
    else:
        app_name = os.path.basename(sys.argv[0]).replace("-script", "")
        print app_name + " <type name> <output folder> <is custom> <containers>"
        print "Example 1: " + app_name + " uint ../src/ False list,vector"
        print "Example 2: " + app_name + " 'struct matrix' ./source/ True vector"


if __name__ == "__main__":
    main()
