/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers.locators;

import junit.framework.TestCase;
import org.openqa.selenium.server.browserlaunchers.locators.SingleBrowserLocator;

public class SingleBrowserLocatorUnitTest
extends TestCase {
    public void testHumanFriendlyLauncherFileNamesReturnsEmptyStringWhenThereIsNoStandardFileNames() {
        SingleBrowserLocator locator = new SingleBrowserLocator(){

            protected String[] standardlauncherFilenames() {
                return new String[0];
            }

            protected String browserName() {
                return null;
            }

            protected String seleniumBrowserName() {
                return null;
            }

            protected String browserPathOverridePropertyName() {
                return null;
            }

            protected String[] usualLauncherLocations() {
                return new String[0];
            }
        };
        SingleBrowserLocatorUnitTest.assertEquals((String)"", (String)locator.humanFriendlyLauncherFileNames());
    }

    public void testHumanFriendlyLauncherFileNamesReturnsQuotedFileNameWhenThereIsASingleFileName() {
        SingleBrowserLocator locator = new SingleBrowserLocator(){

            protected String[] standardlauncherFilenames() {
                return new String[]{"a-single-browser"};
            }

            protected String browserName() {
                return null;
            }

            protected String seleniumBrowserName() {
                return null;
            }

            protected String browserPathOverridePropertyName() {
                return null;
            }

            protected String[] usualLauncherLocations() {
                return new String[0];
            }
        };
        SingleBrowserLocatorUnitTest.assertEquals((String)"'a-single-browser'", (String)locator.humanFriendlyLauncherFileNames());
    }

    public void testHumanFriendlyLauncherFileNamesReturnsAllFileNamesOrSeperatedWhenThereIsMoreThanOneFileName() {
        SingleBrowserLocator locator = new SingleBrowserLocator(){

            protected String[] standardlauncherFilenames() {
                return new String[]{"a-browser", "another-one"};
            }

            protected String browserName() {
                return null;
            }

            protected String seleniumBrowserName() {
                return null;
            }

            protected String browserPathOverridePropertyName() {
                return null;
            }

            protected String[] usualLauncherLocations() {
                return new String[0];
            }
        };
        SingleBrowserLocatorUnitTest.assertEquals((String)"'a-browser' or 'another-one'", (String)locator.humanFriendlyLauncherFileNames());
    }
}

