/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.ArrayList;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.summary.Fit;

public class Regression
implements Fit {
    private Double m;
    private Double b;

    public Regression(Field y, Field x) {
        double[][] data = Regression.asPairs(y, x);
        int n = data[0].length;
        if (n == 0) {
            return;
        }
        double my = Regression.mean(data[0]);
        double mx = Regression.mean(data[1]);
        double sxy = 0.0;
        double sxx = 0.0;
        for (int i = 0; i < n; ++i) {
            Double yv = data[0][i];
            Double xv = data[1][i];
            sxy += (xv - mx) * (yv - my);
            sxx += (xv - mx) * (xv - mx);
        }
        if (sxx > 0.0) {
            this.m = sxy / sxx;
            this.b = my - this.m * mx;
        }
    }

    static double mean(double[] values) {
        double s = 0.0;
        for (int i = 0; i < values.length; ++i) {
            s += values[i];
        }
        return s / (double)values.length;
    }

    static double[][] asPairs(Field y, Field x) {
        ArrayList<Double> xList = new ArrayList<Double>();
        ArrayList<Double> yList = new ArrayList<Double>();
        int n = x.rowCount();
        for (int i = 0; i < n; ++i) {
            Double xv = Data.asNumeric(x.value(i));
            Double yv = Data.asNumeric(y.value(i));
            if (xv == null || yv == null) continue;
            xList.add(xv);
            yList.add(yv);
        }
        Integer[] order = Data.order(xList.toArray(new Double[xList.size()]), true);
        double[] xx = new double[order.length];
        double[] yy = new double[order.length];
        for (int i = 0; i < order.length; ++i) {
            xx[i] = (Double)xList.get(order[i]);
            yy[i] = (Double)yList.get(order[i]);
        }
        return new double[][]{yy, xx};
    }

    @Override
    public Double get(Object value) {
        return this.m == null ? null : Double.valueOf(this.m * Data.asNumeric(value) + this.b);
    }
}

