/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import org.brunel.data.Field;
import org.brunel.data.summary.DimensionField;
import org.brunel.data.summary.Fit;

public class MeasureField
extends DimensionField {
    public final String measureFunction;
    public String option;
    public Fit fit;

    public MeasureField(Field field, String rename, String measureFunction) {
        super(field, rename == null && field == null ? measureFunction : rename);
        this.measureFunction = field != null && measureFunction.equals("mean") && !field.isNumeric() ? "mode" : measureFunction;
    }

    public boolean isPercent() {
        return this.measureFunction.equals("percent");
    }

    @Override
    public String toString() {
        if (this.field != null && this.field.name.equals(this.rename)) {
            return this.label();
        }
        return this.label() + "[->" + this.rename + "]";
    }

    @Override
    public String label() {
        if (this.measureFunction.equals("sum") && this.field.name.equals("#count")) {
            return this.field.label;
        }
        if (this.measureFunction.equals("percent") && this.field.name.equals("#count")) {
            return "Percent";
        }
        String a = this.measureFunction.substring(0, 1).toUpperCase();
        String b = this.measureFunction.substring(1);
        return a + b + "(" + (this.field == null ? "" : this.field.label) + ")";
    }
}

