/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.io;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.Date;
import org.brunel.data.Data;
import org.brunel.translator.JSTranslation;

class ByteOutput {
    @JSTranslation(ignore=true)
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    @JSTranslation(ignore=true)
    static final Charset ENCODING = Charset.forName("utf-8");

    @JSTranslation(js={"this.out=[];"})
    ByteOutput() {
    }

    @JSTranslation(js={"this.out.push(b); return this"})
    public ByteOutput addByte(int b) {
        assert (b >= 0 && b <= 255);
        this.out.write(b);
        return this;
    }

    public ByteOutput addNumber(Number value) {
        if (value == null) {
            this.addByte(255);
            return this;
        }
        double d = value.doubleValue();
        int e = (int)Math.floor(d);
        if ((double)e == d && e >= 0 && e < 65536) {
            if (e <= 252) {
                return this.addByte(e);
            }
            this.addByte(253);
            this.addByte(e & 0xFF);
            this.addByte(e >> 8 & 0xFF);
            return this;
        }
        this.addByte(254);
        this.addDouble(value);
        return this;
    }

    private void addDouble(Number value) {
        if (Double.isNaN(value.doubleValue())) {
            this.addString("NaN");
        } else {
            this.addString(Data.formatNumeric(value.doubleValue(), false));
        }
    }

    public ByteOutput addDate(Date date) {
        return this.addNumber(Data.asNumeric(date));
    }

    @JSTranslation(js={"if (s==null) return this.addByte(3);    // null encoded is '03'", "for (var i = 0; i < s.length; i++) {", "  var c = s.charCodeAt(i);", "  if (c < 128)", "    this.addByte(c)", "  else if (c < 2048)", "    this.addByte((c >> 6) | 192).addByte((c & 63) | 128);", "  else", "    this.addByte((c >> 12) | 224).addByte(((c >> 6) & 63) | 128).addByte((c & 63) | 128);", "}", "return this.addByte(0);"})
    ByteOutput addString(String s) {
        if (s == null) {
            this.out.write(3);
        } else {
            for (byte i : s.getBytes(ENCODING)) {
                this.out.write(i);
            }
            this.out.write(0);
        }
        return this;
    }

    @JSTranslation(js={"return this.out;"})
    byte[] asBytes() {
        return this.out.toByteArray();
    }
}

