/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.diagram;

import java.util.ArrayList;
import java.util.HashMap;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.diagram.Edge;
import org.brunel.data.diagram.Node;

public class Graph {
    public final Node[] nodes;
    public final Edge[] links;

    public static Graph make(Dataset nodeData, String nodeID, Dataset edgeData, String fromField, String toField) {
        Field nodes = nodeData.field(nodeID);
        Field a = edgeData.field(fromField);
        Field b = edgeData.field(toField);
        return new Graph(nodes, a, b);
    }

    public Graph(Field nd, Field a, Field b) {
        HashMap<Object, Node> nodeByID = new HashMap<Object, Node>();
        ArrayList<Node> nds = new ArrayList<Node>();
        for (int i = 0; i < nd.rowCount(); ++i) {
            Object o = nd.value(i);
            if (o == null) continue;
            Node n = new Node(i, 1.0, o.toString(), null);
            n.key = o;
            nds.add(n);
            nodeByID.put(o, n);
        }
        ArrayList<Edge> lks = new ArrayList<Edge>();
        for (int i = 0; i < a.rowCount(); ++i) {
            Node s = (Node)nodeByID.get(a.value(i));
            Node t = (Node)nodeByID.get(b.value(i));
            if (s == null || t == null) continue;
            lks.add(new Edge(s, t, i));
        }
        this.nodes = nds.toArray(new Node[nds.size()]);
        this.links = lks.toArray(new Edge[lks.size()]);
    }
}

