/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.io.Serialize;
import org.brunel.data.modify.AddConstantFields;
import org.brunel.data.modify.ConvertSeries;
import org.brunel.data.modify.DataOperation;
import org.brunel.data.modify.Filter;
import org.brunel.data.modify.Sort;
import org.brunel.data.modify.Stack;
import org.brunel.data.modify.Summarize;
import org.brunel.data.modify.Transform;
import org.brunel.data.util.Informative;
import org.brunel.data.values.ColumnProvider;
import org.brunel.translator.JSTranslation;

public class Dataset
extends Informative
implements Serializable {
    public Field[] fields;
    private Map<String, Field> fieldByName;

    public static Dataset makeFromRows(Object[][] rows) {
        Field[] fields = new Field[rows[0].length];
        for (int j = 0; j < fields.length; ++j) {
            Object[] column = new Object[rows.length - 1];
            for (int i = 1; i < rows.length; ++i) {
                column[i - 1] = rows[i][j];
            }
            fields[j] = new Field(rows[0][j].toString(), null, new ColumnProvider(column));
        }
        return Dataset.make(fields);
    }

    @JSTranslation(ignore=true)
    public static Dataset make(Field[] fields) {
        return Dataset.make(fields, null);
    }

    public static Dataset make(Field[] fields, Boolean autoConvert) {
        Field selection;
        fields = Dataset.ensureUniqueNames(fields);
        Field[] augmented = new Field[fields.length + 3];
        for (int i = 0; i < fields.length; ++i) {
            augmented[i] = Boolean.FALSE.equals(autoConvert) ? fields[i] : Auto.convert(fields[i]);
        }
        int len = fields[0].rowCount();
        augmented[fields.length] = Data.makeConstantField("#count", "Count", 1.0, len);
        augmented[fields.length + 1] = Data.makeIndexingField("#row", "Row", len);
        augmented[fields.length + 2] = selection = Data.makeConstantField("#selection", "Selection", "\u2717", len);
        return new Dataset(augmented);
    }

    private static Field[] ensureUniqueNames(Field[] fields) {
        HashSet<String> cannotUse = new HashSet<String>();
        cannotUse.add("");
        Field[] result = new Field[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].name;
            if (name == null) {
                name = "";
            }
            if (!cannotUse.contains(name)) {
                result[i] = fields[i];
            } else {
                for (int k = 1; k < fields.length + 1; ++k) {
                    if (cannotUse.contains(name + "_" + k)) continue;
                    result[i] = fields[i].rename(name + "_" + k, name);
                    break;
                }
            }
            cannotUse.add(result[i].name);
        }
        return result;
    }

    private Dataset(Field[] fields) {
        this.fields = Dataset.ensureUniqueNames(fields);
        this.fieldByName = new HashMap<String, Field>();
        for (Field f : fields) {
            this.fieldByName.put(f.name.toLowerCase(), f);
        }
        for (Field f : fields) {
            this.fieldByName.put(f.name, f);
        }
    }

    public Dataset bin(String command) {
        return Transform.transform(this, command);
    }

    public Dataset removeSpecialFields() {
        ArrayList<Field> removed = new ArrayList<Field>();
        for (Field f : this.fields) {
            if (f.name.startsWith("#")) continue;
            removed.add(f);
        }
        Field[] fields1 = removed.toArray(new Field[removed.size()]);
        return this.replaceFields(fields1);
    }

    public Dataset addConstants(String command) {
        return AddConstantFields.transform(this, command);
    }

    public long expectedSize() {
        long total = this.fields.length * 56 + 56;
        for (Field f : this.fields) {
            total += f.expectedSize();
        }
        return total;
    }

    @JSTranslation(ignore=true)
    public Field field(String name) {
        return this.field(name, false);
    }

    public Field field(String name, boolean lax) {
        Field field = this.fieldByName.get(name);
        return field != null || !lax ? field : this.fieldByName.get(name.toLowerCase());
    }

    public Dataset filter(String command) {
        return Filter.transform(this, command);
    }

    public Dataset replaceFields(Field[] fields) {
        Dataset result = new Dataset(fields);
        result.copyPropertiesFrom(this);
        return result;
    }

    public int rowCount() {
        return this.fields.length == 0 ? 0 : this.fields[0].rowCount();
    }

    public String name() {
        return this.stringProperty("name");
    }

    public Dataset reduce(String command) {
        HashSet names = new HashSet();
        Collections.addAll(names, DataOperation.parts(command));
        ArrayList<Field> ff = new ArrayList<Field>();
        for (Field f : this.fields) {
            if (!f.name.startsWith("#") && !names.contains(f.name)) continue;
            ff.add(f);
        }
        return this.replaceFields(ff.toArray(new Field[ff.size()]));
    }

    public Dataset series(String command) {
        return ConvertSeries.transform(this, command);
    }

    public Dataset sort(String command) {
        return Sort.transform(this, command);
    }

    public Dataset stack(String command) {
        return Stack.transform(this, command);
    }

    public Dataset summarize(String command) {
        Dataset dataset = Summarize.transform(this, command);
        dataset.set("reduced", true);
        return dataset;
    }

    @JSTranslation(ignore=true)
    private void writeObject(ObjectOutputStream out) throws IOException {
        out.write(Serialize.serializeDataset(this));
    }

    @JSTranslation(ignore=true)
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int len;
        ByteArrayOutputStream store = new ByteArrayOutputStream();
        byte[] block = new byte[10240];
        while ((len = in.read(block)) >= 0) {
            store.write(block, 0, len);
        }
        Dataset d = (Dataset)Serialize.deserialize(store.toByteArray());
        this.fields = d.fields;
        this.fieldByName = d.fieldByName;
        this.info = new HashMap();
        this.copyPropertiesFrom(d);
    }
}

