/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.util;

import com.google.gson.Gson;
import org.brunel.action.Action;
import org.brunel.build.d3.D3Builder;
import org.brunel.build.util.BuilderOptions;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.io.CSV;
import org.brunel.model.VisItem;
import org.brunel.util.BrunelD3Result;

public class D3Integration {
    private static final Gson gson = new Gson();

    public static String createBrunelJSON(String data, String brunelSrc, int width, int height, String visId) {
        BrunelD3Result result = D3Integration.createBrunelResult(data, brunelSrc, width, height, visId);
        return gson.toJson((Object)result);
    }

    public static BrunelD3Result createBrunelResult(String data, String brunelSrc, int width, int height, String visId) {
        Dataset dataset = D3Integration.makeBrunelData(data);
        D3Builder builder = D3Integration.makeD3(dataset, brunelSrc, width, height, visId);
        BrunelD3Result result = new BrunelD3Result();
        result.css = builder.getStyleOverrides();
        result.js = builder.getVisualization().toString();
        result.controls = builder.getControls();
        return result;
    }

    public static D3Builder makeD3(Dataset data, String actionText, int width, int height, String visId) {
        try {
            BuilderOptions options = new BuilderOptions();
            options.visIdentifier = visId;
            D3Builder builder = D3Builder.make(options);
            VisItem item = D3Integration.makeVisItem(data, actionText);
            builder.build(item, width, height);
            return builder;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IllegalArgumentException("Could not execute Brunel: " + actionText, ex);
        }
    }

    private static Dataset makeBrunelData(String data) {
        if (data.isEmpty()) {
            return null;
        }
        try {
            return Dataset.make((Field[])CSV.read((String)data));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not create data as CSV from content", e);
        }
    }

    private static VisItem makeVisItem(Dataset brunel, String actionText) {
        Action action = Action.parse(actionText);
        if (brunel == null) {
            return action.apply();
        }
        return action.apply(brunel);
    }
}

