/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import org.brunel.maps.Point;

public class Rect {
    public final double x1;
    public final double y1;
    public final double x2;
    public final double y2;

    public Rect(double x1, double x2, double y1, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        assert (x2 >= x1 && y2 >= y1);
    }

    public final double area() {
        return (this.x2 - this.x1) * (this.y2 - this.y1);
    }

    public Point center() {
        return new Point(this.cx(), this.cy());
    }

    public final double cx() {
        return (this.x1 + this.x2) / 2.0;
    }

    public final double cy() {
        return (this.y1 + this.y2) / 2.0;
    }

    public final double distance(Rect o) {
        if (o.x1 + o.width() < this.x1) {
            if (o.y1 > this.y2) {
                return this.distancePtPt(o.x1 + o.width(), o.y1, this.x1, this.y2);
            }
            if (o.y2 < this.y1) {
                return this.distancePtPt(o.x1 + o.width(), o.y2, this.x1, this.y1);
            }
            return this.x1 - o.x1 - o.width();
        }
        if (o.x1 > this.x2) {
            if (o.y1 > this.y2) {
                return this.distancePtPt(o.x1, o.y1, this.x2, this.y2);
            }
            if (o.y2 < this.y1) {
                return this.distancePtPt(o.x1, o.y2, this.x2, this.y1);
            }
            return o.x1 - this.x2;
        }
        if (o.y1 > this.y2) {
            return o.y1 - this.y2;
        }
        if (o.y2 < this.y1) {
            return this.y1 - o.y2;
        }
        if (this.contains(o) || o.contains(this)) {
            double d1 = Math.min(Math.abs(this.x1 - o.x1), Math.abs(this.x2 - o.x1 - o.width()));
            double d2 = Math.min(Math.abs(this.y1 - o.y1), Math.abs(this.y2 - o.y2));
            return -Math.min(d1, d2);
        }
        return 0.0;
    }

    private double distancePtPt(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    private boolean contains(Rect o) {
        return o.x1 >= this.x1 && o.x2 <= this.x2 && o.y1 >= this.y1 && o.y2 <= this.y2;
    }

    public final double distanceTo(double px, double py) {
        if (py < this.y1) {
            if (px < this.x1) {
                return Math.sqrt((px - this.x1) * (px - this.x1) + (py - this.y1) * (py - this.y1));
            }
            if (px > this.x2) {
                return Math.sqrt((px - this.x2) * (px - this.x2) + (py - this.y1) * (py - this.y1));
            }
            return this.y1 - py;
        }
        if (py > this.y2) {
            if (px < this.x1) {
                return Math.sqrt((px - this.x1) * (px - this.x1) + (py - this.y2) * (py - this.y2));
            }
            if (px > this.x2) {
                return Math.sqrt((px - this.x2) * (px - this.x2) + (py - this.y2) * (py - this.y2));
            }
            return py - this.y2;
        }
        if (px < this.x1) {
            return this.x1 - px;
        }
        if (px > this.x2) {
            return px - this.x2;
        }
        return -Math.min(Math.min(px - this.x1, this.x2 - px), Math.min(py - this.y1, this.y2 - py));
    }

    public Rect expand(double v) {
        return new Rect(this.x1 - this.width() * v, this.x2 + this.width() * v, this.y1 - this.height() * v, this.y2 + this.height() * v);
    }

    public double width() {
        return this.x2 - this.x1;
    }

    public double height() {
        return this.y2 - this.y1;
    }

    public Rect intersection(Rect o) {
        double a1 = Math.max(this.x1, o.x1);
        double b1 = Math.max(this.y1, o.y1);
        double a2 = Math.min(this.x2, o.x2);
        double b2 = Math.min(this.y2, o.y2);
        return a2 > a1 && b2 > b1 ? new Rect(a1, a2, b1, b2) : null;
    }

    public final boolean intersects(Rect other) {
        return this.y2 >= other.y1 && this.y1 <= other.y2 && this.x2 >= other.x1 && this.x1 <= other.x2;
    }

    public Point[] makeBoundaryPoints() {
        return new Point[]{new Point(this.x1, this.y1), new Point(this.cx(), this.y1), new Point(this.x2, this.y1), new Point(this.x2, this.cy()), new Point(this.x2, this.y2), new Point(this.cx(), this.y2), new Point(this.x1, this.y2), new Point(this.x1, this.cy())};
    }

    public String toString() {
        return "[" + this.x1 + ", " + this.x2 + " : " + this.y1 + ", " + this.y2 + ")]";
    }

    public Rect union(Point p) {
        if (this.contains(p)) {
            return this;
        }
        return new Rect(Math.min(p.x, this.x1), Math.max(p.x, this.x2), Math.min(p.y, this.y1), Math.max(p.y, this.y2));
    }

    public final boolean contains(Point p) {
        return p.x >= this.x1 && p.y >= this.y1 && p.x <= this.x2 && p.y <= this.y2;
    }

    public Rect union(Rect o) {
        if (o == null || this.contains(o)) {
            return this;
        }
        if (o.contains(this)) {
            return o;
        }
        return new Rect(Math.min(this.x1, o.x1), Math.max(this.x2, o.x2), Math.min(this.y1, o.y1), Math.max(this.y2, o.y2));
    }
}

