/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import org.brunel.maps.Point;

public class Poly {
    private final Point[] points;

    public Poly(Point[] points) {
        this.points = points;
    }

    public boolean contains(Point p) {
        int intersectCountLeft = 0;
        int j = this.points.length - 1;
        int i = 0;
        while (i < this.points.length) {
            double yj = this.points[j].y;
            double yi = this.points[i].y;
            double xj = this.points[j].x;
            double xi = this.points[i].x;
            double m = (yj - yi) / (xj - xi);
            if (!Double.isNaN(m) && !(Math.abs(m) < 1.0E-6)) {
                if (Math.abs(m) > 1000000.0) {
                    double iy = p.y;
                    if ((iy > yi && iy < yj || iy > yj - 0.0 && iy < yi) && xi < p.x) {
                        if (Math.abs(iy - yi) == 0.0) {
                            if (yj > p.y) {
                                ++intersectCountLeft;
                            }
                        } else if (Math.abs(iy - yj) == 0.0) {
                            if (yi > p.y) {
                                ++intersectCountLeft;
                            }
                        } else {
                            ++intersectCountLeft;
                        }
                    }
                } else {
                    double b = yi - m * xi;
                    double ix = (p.y - b) / m;
                    if ((ix > xi && ix < xj || ix > xj && ix < xi) && ix < p.x) {
                        if (Math.abs(p.y - yi) == 0.0) {
                            if (yj > p.y) {
                                ++intersectCountLeft;
                            }
                        } else if (Math.abs(p.y - yj) == 0.0) {
                            if (yi > p.y) {
                                ++intersectCountLeft;
                            }
                        } else {
                            ++intersectCountLeft;
                        }
                    }
                }
            }
            j = i++;
        }
        return intersectCountLeft % 2 != 0;
    }
}

