/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.brunel.maps.Point;
import org.brunel.maps.Projection;
import org.brunel.maps.Rect;

public class GeoProjection {
    public static final String[] WinkelD3Function = new String[]{"function () {", "  function w(x, y) {", "    var a = Math.acos(Math.cos(y) * Math.cos(x / 2)), sinca = Math.abs(a) < 1e-6 ? 1 : Math.sin(a) / a;", "    return [Math.cos(y) * Math.sin(x / 2) / sinca + x / Math.PI, (Math.sin(y) * sinca + y) / 2];", "  }", "  return d3.geo.projection(w);", "}"};
    private static final Projection MERCATOR = new Projection.Mercator();
    private static final Projection WINKEL3 = new Projection.WinkelTripel();
    private static final String LN = "\n\t\t";
    private final String width;
    private final String height;
    private final String winkelTripleFunctionName;
    private final NumberFormat F = new DecimalFormat("#.####");

    public GeoProjection(String widthName, String heightName, String winkelTripleFunctionName) {
        this.width = widthName;
        this.height = heightName;
        this.winkelTripleFunctionName = winkelTripleFunctionName;
    }

    public String makeProjection(Rect bounds) {
        if (bounds.x1 < -100.0 && bounds.y1 > 17.0 && bounds.y2 > 35.0 && bounds.y2 < 73.0) {
            if (bounds.x1 < -120.0) {
                return this.makeAlbersUSA();
            }
            return this.makeMercator(bounds);
        }
        if (this.getMercatorDistortion(bounds) <= 1.8) {
            return this.makeMercator(bounds);
        }
        if (bounds.x2 - bounds.x1 > 180.0 && bounds.y2 - bounds.y1 > 90.0) {
            return this.makeWinkelTripel(bounds);
        }
        return this.makeAlbers(bounds);
    }

    private String makeAlbersUSA() {
        return "d3.geo.albersUsa()\n\t\t.scale(Math.min(" + this.width + "/0.96, " + this.height + "/0.48))" + LN + this.translateDefinition();
    }

    private String makeMercator(Rect b) {
        Rect ext = MERCATOR.projectedExtent(b);
        Point c = MERCATOR.inverse(ext.center());
        String center = ".center([" + this.F.format(c.x) + ", " + this.F.format(c.y) + "])";
        return "d3.geo.mercator()\n\t\t" + this.translateDefinition() + LN + this.scaleDefinition(ext) + LN + center;
    }

    private double getMercatorDistortion(Rect bounds) {
        double b;
        if (bounds.y1 < -89.0 || bounds.y2 > 89.0) {
            return 100.0;
        }
        double a = MERCATOR.getTissotArea(new Point(bounds.cx(), bounds.y1));
        return a < (b = MERCATOR.getTissotArea(new Point(bounds.cx(), bounds.y2))) / 100.0 || b < a / 100.0 ? 100.0 : Math.max(b / a, a / b);
    }

    private String makeWinkelTripel(Rect bounds) {
        Rect ext = WINKEL3.projectedExtent(bounds);
        double y = 0.0;
        double dy = 9.0E99;
        for (int i = -90; i < 90; ++i) {
            Point p = WINKEL3.transform(new Point(bounds.cx(), i));
            double dp = Math.abs(p.y - ext.cy());
            if (!(dp < dy)) continue;
            dy = dp;
            y = i;
        }
        double x = 0.0;
        double dx = 9.0E99;
        for (int i = -180; i < 180; ++i) {
            Point p = WINKEL3.transform(new Point(i, y));
            double dp = Math.abs(p.x - ext.cx());
            if (!(dp < dx)) continue;
            dx = dp;
            x = i;
        }
        String center = ".center([" + this.F.format(x) + ", " + this.F.format(y) + "])";
        return this.winkelTripleFunctionName + "()" + LN + this.translateDefinition() + LN + this.scaleDefinition(ext) + LN + center;
    }

    private String makeAlbers(Rect b) {
        double parallelA = (b.y1 + b.y2 * 5.0) / 6.0;
        double parallelB = (b.y1 * 5.0 + b.y2) / 6.0;
        double angle = -b.cx();
        Projection.Albers projection = new Projection.Albers(parallelA, parallelB, angle);
        String parallels = ".parallels([" + this.F.format(parallelA) + "," + this.F.format(parallelB) + "])";
        String rotate = ".rotate([" + this.F.format(angle) + ",0,0])";
        Rect ext = ((Projection)projection).projectedExtent(b);
        Point c = ((Projection)projection).inverse(ext.center());
        String center = ".center([0, " + this.F.format(c.y) + "])";
        return "d3.geo.albers()\n\t\t" + this.translateDefinition() + LN + center + LN + parallels + LN + this.scaleDefinition(ext) + LN + rotate;
    }

    private String translateDefinition() {
        return ".translate([" + this.width + "/2, " + this.height + "/2])";
    }

    private String scaleDefinition(Rect extent) {
        return ".scale(Math.min((" + this.width + "-4)/" + this.F.format(extent.width()) + ", (" + this.height + "-4)/" + this.F.format(extent.height()) + "))";
    }
}

