/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.brunel.maps.GeoAnalysis;
import org.brunel.maps.GeoFile;
import org.brunel.maps.GeoFileGroup;
import org.brunel.maps.Point;
import org.brunel.maps.PointCollection;
import org.brunel.maps.Rect;

public class GeoMapping {
    private final Map<Object, int[]> featureMap = new TreeMap<Object, int[]>();
    private final Set<Object> unmatched;
    private final GeoFile[] result;
    private final Map<GeoFile, List<Object>> potential;
    private GeoFileGroup best;

    public static GeoMapping createGeoMapping(PointCollection points, List<GeoFile> required, GeoAnalysis geoAnalysis) {
        HashSet<Object> unmatched = new HashSet<Object>();
        Map<GeoFile, List<Object>> map = GeoMapping.mapBoundsToFiles(points, geoAnalysis);
        return new GeoMapping(required, unmatched, map);
    }

    private static Map<GeoFile, List<Object>> mapBoundsToFiles(PointCollection points, GeoAnalysis geoAnalysis) {
        GeoFile[] geoFiles;
        HashMap<GeoFile, List<Object>> map = new HashMap<GeoFile, List<Object>>();
        if (points.isEmpty()) {
            return map;
        }
        Rect bounds = points.bounds();
        for (GeoFile f : geoFiles = geoAnalysis.geoFiles) {
            if (!bounds.intersects(f.bounds)) continue;
            ArrayList<Point> content = new ArrayList<Point>();
            for (Point p : points.convexHull()) {
                if (!f.covers(p)) continue;
                content.add(p);
            }
            if (content.isEmpty()) continue;
            map.put(f, content);
        }
        return map;
    }

    static GeoMapping createGeoMapping(Object[] names, List<GeoFile> required, GeoAnalysis geoAnalysis) {
        HashSet<Object> unmatched = new HashSet<Object>();
        Map<GeoFile, List<Object>> map = GeoMapping.mapFeaturesToFiles(names, geoAnalysis, unmatched);
        GeoMapping mapping = new GeoMapping(required, unmatched, map);
        mapping.buildFeatureMap();
        return mapping;
    }

    private static Map<GeoFile, List<Object>> mapFeaturesToFiles(Object[] names, GeoAnalysis geoAnalysis, Collection<Object> unmatched) {
        HashMap<GeoFile, List<Object>> contained = new HashMap<GeoFile, List<Object>>();
        for (Object s : names) {
            int[][] item = GeoMapping.findFeature(s, geoAnalysis.featureMap);
            if (item == null) {
                unmatched.add(s);
                continue;
            }
            for (int[] i : item) {
                GeoFile file = geoAnalysis.geoFiles[i[0]];
                ArrayList<FeatureDetail> content = (ArrayList<FeatureDetail>)contained.get(file);
                if (content == null) {
                    content = new ArrayList<FeatureDetail>();
                    contained.put(file, content);
                }
                content.add(new FeatureDetail(s, i[1]));
            }
        }
        return contained;
    }

    private void buildFeatureMap() {
        for (int i = 0; i < this.result.length; ++i) {
            List<Object> use = this.potential.get(this.result[i]);
            for (Object o : use) {
                FeatureDetail s = (FeatureDetail)o;
                this.featureMap.put(s.name, new int[]{i, s.indexWithinFile});
            }
        }
    }

    private static int[][] findFeature(Object key, Map<String, int[][]> featureMap) {
        String s = key.toString().toLowerCase();
        int[][] result = featureMap.get(s);
        if (result != null) {
            return result;
        }
        result = featureMap.get(s = GeoAnalysis.removeAccents(s));
        if (result != null) {
            return result;
        }
        s = GeoAnalysis.removePeriods(s);
        return featureMap.get(s);
    }

    private GeoMapping(List<GeoFile> required, Set<Object> unmatched, Map<GeoFile, List<Object>> potential) {
        this.potential = this.filter(potential, required);
        this.unmatched = unmatched;
        this.searchForBestSubset();
        if (required != null) {
            this.result = required.toArray(new GeoFile[required.size()]);
        } else {
            this.result = this.best.files.toArray(new GeoFile[this.best.files.size()]);
            Arrays.sort(this.result);
        }
    }

    public int fileCount() {
        return this.result.length;
    }

    public Map<Object, int[]> getFeatureMap() {
        return this.featureMap;
    }

    public GeoFile[] getFiles() {
        return this.result;
    }

    public Set<Object> getUnmatched() {
        return this.unmatched;
    }

    public Rect totalBounds() {
        Rect bounds = null;
        for (GeoFile i : this.result) {
            bounds = i.bounds.union(bounds);
        }
        return bounds;
    }

    private Map<GeoFile, List<Object>> filter(Map<GeoFile, List<Object>> desired, List<GeoFile> required) {
        if (required == null || required.isEmpty()) {
            return desired;
        }
        HashMap<GeoFile, List<Object>> filtered = new HashMap<GeoFile, List<Object>>();
        for (Map.Entry<GeoFile, List<Object>> e : desired.entrySet()) {
            if (!required.contains(e.getKey())) continue;
            filtered.put(e.getKey(), e.getValue());
        }
        return filtered;
    }

    private void searchForBestAdditions(GeoFileGroup current, List<GeoFile> possibles) {
        if (current.isBetter(this.best)) {
            this.best = current;
        }
        if (possibles.isEmpty()) {
            return;
        }
        int maxImprovement = this.potential.get(possibles.get(0)).size();
        if (current.cannotImprove(this.best, maxImprovement)) {
            return;
        }
        LinkedList<GeoFile> working = new LinkedList<GeoFile>(possibles);
        while (!working.isEmpty()) {
            GeoFile k = working.removeFirst();
            GeoFileGroup trial = current.add(k);
            if (trial == null) continue;
            this.searchForBestAdditions(trial, working);
        }
    }

    private void searchForBestSubset() {
        this.best = GeoFileGroup.makeEmpty(this.potential);
        ArrayList<GeoFile> possibles = new ArrayList<GeoFile>(this.potential.keySet());
        Collections.sort(possibles, new Comparator<GeoFile>(){

            @Override
            public int compare(GeoFile a, GeoFile b) {
                return ((List)GeoMapping.this.potential.get(b)).size() - ((List)GeoMapping.this.potential.get(a)).size();
            }
        });
        this.searchForBestAdditions(this.best, possibles);
    }

    private static class FeatureDetail {
        final Object name;
        final int indexWithinFile;

        private FeatureDetail(Object name, int indexWithinFile) {
            this.name = name;
            this.indexWithinFile = indexWithinFile;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            return this.name.equals(((FeatureDetail)o).name);
        }
    }
}

