/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import org.brunel.maps.Point;
import org.brunel.maps.Poly;
import org.brunel.maps.Rect;

class GeoFile
implements Comparable<GeoFile> {
    public final String name;
    public final double size;
    public final Rect bounds;
    private final Poly hull;

    public GeoFile(String name, String boundsString, String hullString, String sizeString) {
        this.name = name;
        this.size = Integer.parseInt(sizeString);
        String[] b = boundsString.split(",");
        this.bounds = new Rect(Double.parseDouble(b[0]), Double.parseDouble(b[1]), Double.parseDouble(b[2]), Double.parseDouble(b[3]));
        this.hull = new Poly(this.parse(hullString));
    }

    private Point[] parse(String hullString) {
        String[] parts = hullString.split(";");
        Point[] result = new Point[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            String[] p = parts[i].split(",");
            result[i] = new Point(Double.parseDouble(p[0]), Double.parseDouble(p[1]));
        }
        return result;
    }

    @Override
    public int compareTo(GeoFile o) {
        return Double.compare(o.bounds.area(), this.bounds.area());
    }

    public boolean covers(Point p) {
        return this.bounds.contains(p) && this.hull.contains(p);
    }

    public String toString() {
        return this.name;
    }
}

