/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.maps;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.brunel.action.Param;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.maps.GeoFile;
import org.brunel.maps.GeoMapping;
import org.brunel.maps.PointCollection;

public class GeoAnalysis {
    private static final Pattern PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
    private static GeoAnalysis INSTANCE;
    final Map<String, int[][]> featureMap;
    final GeoFile[] geoFiles;

    public static synchronized GeoAnalysis instance() {
        if (INSTANCE == null) {
            INSTANCE = new GeoAnalysis();
        }
        return INSTANCE;
    }

    public static void writeMapping(ScriptWriter out, GeoMapping map) {
        LinkedHashMap combined = new LinkedHashMap();
        for (GeoFile geo : map.getFiles()) {
            combined.put(geo.name, new TreeMap());
        }
        for (Map.Entry<Object, int[]> e : map.getFeatureMap().entrySet()) {
            Object dataName = e.getKey();
            int[] indices = e.getValue();
            String fileName = map.getFiles()[indices[0]].name;
            Map features = (Map)combined.get(fileName);
            features.put(dataName, indices[1]);
        }
        out.add("{").indentMore();
        GeoFile[] files = map.getFiles();
        String version = new BuilderOptions().version;
        for (int k = 0; k < files.length; ++k) {
            if (k > 0) {
                out.add(",").onNewLine();
            }
            String fileName = files[k].name;
            String source = Data.quote((String)("http://brunelvis.org/geo/" + version + "/" + fileName + ".json"));
            out.onNewLine().add(source, ":{").indentMore();
            int i = 0;
            Map features = (Map)combined.get(fileName);
            for (Map.Entry s : features.entrySet()) {
                if (i++ > 0) {
                    out.add(", ");
                }
                if (i % 5 == 0) {
                    out.onNewLine();
                }
                out.add("'").add(s.getKey()).add("':").add(s.getValue());
            }
            out.indentLess().onNewLine().add("}");
        }
        out.indentLess().onNewLine().add("}");
    }

    private GeoAnalysis() {
        try {
            String line;
            String[] fileLine;
            InputStream is = GeoAnalysis.class.getResourceAsStream("/org/brunel/maps/geoindex.txt");
            LineNumberReader rdr = new LineNumberReader(new InputStreamReader(is, "utf-8"));
            ArrayList<GeoFile> list = new ArrayList<GeoFile>();
            while ((fileLine = rdr.readLine().split("\\|")).length == 4) {
                list.add(new GeoFile(fileLine[0], fileLine[1], fileLine[2], fileLine[3]));
            }
            this.geoFiles = list.toArray(new GeoFile[list.size()]);
            this.featureMap = new HashMap<String, int[][]>();
            while ((line = rdr.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                String[] featureLine = line.split("\\|");
                String name = featureLine[0];
                int m = featureLine.length - 1;
                int[][] data = new int[m][2];
                for (int i = 0; i < m; ++i) {
                    String[] s = featureLine[i + 1].split(":");
                    data[i][0] = Integer.parseInt(s[0]);
                    data[i][1] = Integer.parseInt(s[1]);
                }
                this.featureMap.put(name.toLowerCase(), data);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<String> keys = new ArrayList<String>(this.featureMap.keySet());
        for (String s : keys) {
            String t = GeoAnalysis.removeAccents(s);
            if (!this.featureMap.containsKey(t)) {
                this.featureMap.put(t, this.featureMap.get(s));
            }
            if (this.featureMap.containsKey(t = GeoAnalysis.removePeriods(t))) continue;
            this.featureMap.put(t, this.featureMap.get(s));
        }
    }

    static String removeAccents(String s) {
        String decomposed = Normalizer.normalize(s, Normalizer.Form.NFD);
        return PATTERN.matcher(decomposed).replaceAll("");
    }

    static String removePeriods(String s) {
        if (s.length() == 5 && s.charAt(2) == '.') {
            return s;
        }
        return s.replaceAll("\\.", "");
    }

    public GeoMapping make(Object[] names, Param[] geoParameters) {
        return GeoMapping.createGeoMapping(names, this.makeRequiredFiles(geoParameters), this);
    }

    private List<GeoFile> makeRequiredFiles(Param[] params) {
        if (params.length == 0) {
            return null;
        }
        ArrayList<GeoFile> result = new ArrayList<GeoFile>();
        block0: for (String s : params[0].asString().split(",")) {
            if (s.equalsIgnoreCase("uk")) {
                s = "UnitedKingdom";
            }
            if (s.equalsIgnoreCase("usa")) {
                s = "UnitedStatesofAmerica";
            }
            for (GeoFile f : this.geoFiles) {
                if (!f.name.equalsIgnoreCase(s)) continue;
                result.add(f);
                continue block0;
            }
        }
        return result;
    }

    public GeoMapping makeForPoints(PointCollection points, Param[] geoParameters) {
        return GeoMapping.createGeoMapping(points, this.makeRequiredFiles(geoParameters), this);
    }
}

