/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.util.ModelUtil;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.maps.PointCollection;
import org.brunel.model.VisSingle;

public class PositionFields {
    public final Field[] allXFields;
    public final Field[] allYFields;
    public final String xTransform;
    public final String yTransform;
    public final boolean xCategorical;
    public final boolean yCategorical;
    private final Map<VisSingle, Field[]> x = new HashMap<VisSingle, Field[]>();
    private final Map<VisSingle, Field[]> y = new HashMap<VisSingle, Field[]>();
    private final VisSingle[] elements;

    public PositionFields(VisSingle[] elements, Dataset[] elementData) {
        this.elements = elements;
        String xTransform = null;
        String yTransform = null;
        ArrayList allX = new ArrayList();
        ArrayList allY = new ArrayList();
        for (int i = 0; i < elements.length; ++i) {
            Field[] visXFields = this.getXFields(elements[i], elementData[i]);
            Field[] visYFields = this.getYFields(elements[i], elementData[i]);
            if (xTransform == null) {
                xTransform = this.getDefinedXTransform(elements[i]);
            }
            if (yTransform == null) {
                yTransform = this.getDefinedYTransform(elements[i]);
            }
            this.x.put(elements[i], visXFields);
            this.y.put(elements[i], visYFields);
            Collections.addAll(allX, visXFields);
            Collections.addAll(allY, visYFields);
        }
        this.allXFields = allX.toArray(new Field[allX.size()]);
        this.allYFields = allY.toArray(new Field[allY.size()]);
        this.xCategorical = ModelUtil.combinationIsCategorical(this.allXFields, true);
        this.yCategorical = ModelUtil.combinationIsCategorical(this.allYFields, true);
        this.xTransform = xTransform == null ? (this.xCategorical ? "linear" : this.chooseTransform(this.allXFields)) : xTransform;
        this.yTransform = yTransform == null ? (this.yCategorical ? "linear" : this.chooseTransform(this.allYFields)) : yTransform;
    }

    public PointCollection getAllPoints() {
        PointCollection collection = new PointCollection();
        for (VisSingle v : this.elements) {
            Field[] xx = this.getX(v);
            Field[] yy = this.getY(v);
            for (Field x : xx) {
                for (Field y : yy) {
                    for (int i = 0; i < x.rowCount(); ++i) {
                        Double a = Data.asNumeric((Object)x.value(i));
                        Double b = Data.asNumeric((Object)y.value(i));
                        if (a == null || b == null) continue;
                        collection.add(a, b);
                    }
                }
            }
        }
        return collection;
    }

    private String getDefinedXTransform(VisSingle v) {
        for (Param p : v.fX) {
            if (!p.isField() || !p.hasModifiers()) continue;
            return p.firstModifier().asString();
        }
        return null;
    }

    private String getDefinedYTransform(VisSingle v) {
        for (Param p : v.fY) {
            if (!p.isField() || !p.hasModifiers()) continue;
            return p.firstModifier().asString();
        }
        if (v.fRange != null) {
            if (v.fRange[0].isField() && v.fRange[0].hasModifiers()) {
                return v.fRange[0].firstModifier().asString();
            }
            if (v.fRange[1].isField() && v.fRange[1].hasModifiers()) {
                return v.fRange[1].firstModifier().asString();
            }
        }
        return null;
    }

    public Field[] getX(VisSingle vis) {
        return this.x.get(vis);
    }

    public Field[] getY(VisSingle vis) {
        return this.y.get(vis);
    }

    private Field[] getXFields(VisSingle vis, Dataset data) {
        Field[] result = new Field[vis.fX.size()];
        for (int i = 0; i < vis.fX.size(); ++i) {
            result[i] = data.field(vis.fX.get(i).asField());
        }
        return result;
    }

    private Field[] getYFields(VisSingle vis, Dataset data) {
        if (vis.fRange != null) {
            return new Field[]{data.field(vis.fRange[0].asField()), data.field(vis.fRange[1].asField())};
        }
        if (vis.fY.isEmpty()) {
            return new Field[0];
        }
        if (vis.fY.size() > 1) {
            if (vis.stacked) {
                return new Field[]{data.field("#values$lower"), data.field("#values$upper")};
            }
            return new Field[]{data.field("#values")};
        }
        String s = vis.fY.get(0).asField();
        if (vis.stacked) {
            return new Field[]{data.field(s + "$lower"), data.field(s + "$upper")};
        }
        return new Field[]{data.field(s)};
    }

    private String chooseTransform(Field[] fields) {
        if (fields.length == 0) {
            return "linear";
        }
        String best = "linear";
        double min = Double.MAX_VALUE;
        for (Field f : fields) {
            if (f.min() == null) continue;
            Auto.setTransform((Field)f);
            String s = f.stringProperty("transform");
            if ("log".equals(s)) {
                best = "log";
            } else if ("root".equals(s) && !best.equals("log")) {
                best = "root";
            }
            if (!f.isNumeric()) continue;
            min = Math.min(min, f.min());
        }
        if ("log".equals(best) && min <= 0.0) {
            return "linear";
        }
        return best;
    }
}

