/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.d3.ElementDefinition;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.util.ElementDetails;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Treemap
extends D3Diagram {
    public Treemap(VisSingle vis, Dataset data, ScriptWriter out) {
        super(vis, data, out);
    }

    @Override
    public ElementDetails writeDataConstruction() {
        this.out.comment("Define treemap (hierarchy) data structures");
        this.makeHierarchicalTree();
        this.out.add("var treemap = d3.layout.treemap().sticky(true)").addChained("size([geom.inner_width, geom.inner_height])").addChained("sort(BrunelData.diagram_Hierarchical.compare)").addChained("value(function(d) { return d.value == null || d.value < 0 ? 0 : d.value })").addChained("padding(function(d) { if (d.depth < 2) return [14,2,2,2]; if (d.depth < 3) return [11,2,2,2];})").endStatement();
        this.out.add("function keyFunction(d) { return d.key }").endStatement();
        return ElementDetails.makeForDiagram("treemap(tree.root)", "rect", "polygon", "box", true);
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.addChained("attr('class', function(d) { return (d.children ? 'L' + d.depth : 'leaf element " + this.element.name() + "') })").addChained("attr('x', function(d) { return d.x; })").addChained("attr('y', function(d) { return d.y; })").addChained("attr('width', function(d) { return d.dx; })").addChained("style('width', function(d) { return d.dx; })").addChained("attr('height', function(d) { return d.dy; })").endStatement();
        this.labelBuilder.addTreeInternalLabels(details, "box");
        this.addAestheticsAndTooltips(details, true);
    }
}

