/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3.diagrams;

import org.brunel.build.ElementDependency;
import org.brunel.build.d3.ElementDefinition;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.util.ElementDetails;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.model.VisSingle;

class Network
extends D3Diagram {
    private final ElementDependency dependency;

    public Network(VisSingle vis, Dataset data, ElementDependency dependency, ScriptWriter out) {
        super(vis, data, out);
        this.dependency = dependency;
    }

    @Override
    public ElementDetails writeDataConstruction() {
        String nodeField = this.quoted(this.vis.fKeys.get(0).asField());
        VisSingle links = this.dependency.getEdgeElement();
        String edgeDataset = this.dependency.linkedDataReference(links);
        String a = this.quoted(links.fKeys.get(0).asField());
        String b = this.quoted(links.fKeys.get(1).asField());
        this.out.add("var graph = BrunelData.diagram_Graph.make(processed,", nodeField, ",", edgeDataset, ",", a, ",", b, ")").endStatement();
        this.out.add("for (var i in graph.nodes) { graph.nodes[i].x = 0.5 + 0.3 * Math.cos(i*Math.PI/3); graph.nodes[i].y = 0.5 + 0.3*Math.sin(i*Math.PI/3) }").endStatement();
        this.out.add("data._graph = graph").endStatement();
        return ElementDetails.makeForDiagram("graph.nodes", "circle", "point", "box", false);
    }

    @Override
    public void writeDefinition(ElementDetails details, ElementDefinition elementDef) {
        this.out.addChained("attr('cx', function(d) { return scale_x(d.x) })").addChained("attr('cy', function(d) { return scale_y(d.y) })").addChained("attr('r',", elementDef.overallSize, ")");
        this.out.endStatement();
        this.addAestheticsAndTooltips(details, true);
    }
}

