/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import org.brunel.build.ElementDependency;
import org.brunel.build.d3.D3LabelBuilder;
import org.brunel.build.d3.D3ScaleBuilder;
import org.brunel.build.d3.D3Util;
import org.brunel.build.d3.ElementDefinition;
import org.brunel.build.d3.diagrams.D3Diagram;
import org.brunel.build.util.ElementDetails;
import org.brunel.build.util.ModelUtil;
import org.brunel.build.util.PositionFields;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

class D3ElementBuilder {
    private final ScriptWriter out;
    private final VisSingle vis;
    private final Dataset data;
    private final ElementDependency dependency;
    private final PositionFields positionFields;
    private final D3ScaleBuilder scales;
    private final D3LabelBuilder labelBuilder;
    private final D3Diagram diagram;

    public D3ElementBuilder(VisSingle vis, ScriptWriter out, D3ScaleBuilder scales, PositionFields positionFields, Dataset data, ElementDependency dependency) {
        this.vis = vis;
        this.out = out;
        this.scales = scales;
        this.positionFields = positionFields;
        this.data = data;
        this.dependency = dependency;
        this.labelBuilder = new D3LabelBuilder(vis, out, data);
        this.diagram = D3Diagram.make(vis, data, out, dependency, scales.positionFields);
    }

    public void generate(int elementIndex) {
        if (this.diagram != null) {
            this.out.onNewLine().comment(new Object[]{"Data structures for a", this.vis.tDiagram, "diagram"});
        }
        ElementDetails details = this.makeDetails();
        ElementDefinition elementDef = this.buildElementDefinition();
        if (details.producesPath) {
            this.definePathsAndSplits(elementDef);
        }
        if (this.labelBuilder.needed()) {
            this.labelBuilder.defineLabeling(details, this.vis.itemsLabel, false);
        }
        this.modifyGroupStyleName();
        this.out.add("element = elements[" + elementIndex + "]").endStatement();
        this.out.add("d3Data =", details.dataSource).endStatement();
        this.out.add("selection = main.selectAll('*').data(d3Data,", this.getKeyFunction(), ")").endStatement();
        this.out.add("selection.enter().append('" + details.elementType + "')");
        this.out.add(".attr('class', ", details.classes, ")");
        if (this.diagram != null) {
            this.diagram.writeDiagramEnter();
        } else {
            this.writeCoordEnter();
        }
        if (this.diagram != null) {
            this.diagram.writePreDefinition(details, elementDef);
            this.out.add("BrunelD3.trans(selection,transitionMillis)");
            this.diagram.writeDefinition(details, elementDef);
        } else {
            this.writeCoordinateDefinition(details, elementDef);
            this.writeCoordinateLabelingAndAesthetics(details);
        }
        this.out.onNewLine().ln().add("BrunelD3.trans(selection.exit(),transitionMillis/3)");
        this.out.addChained("style('opacity', 0.5).remove()").endStatement();
    }

    private String getSize(String aestheticFunctionCall, ModelUtil.Size size, Field[] fields, String extent, String scaleName) {
        String baseAmount;
        boolean needsFunction;
        boolean bl = needsFunction = aestheticFunctionCall != null;
        if (size != null && !size.isPercent()) {
            baseAmount = "" + size.value();
        } else if (fields.length == 0) {
            baseAmount = this.vis.tDiagram != null ? "geom.default_point_size" : extent;
        } else {
            int categories = this.scales.getCategories(fields).size();
            Double granularity = this.scales.getGranularitySuitableForSizing(fields);
            if (this.vis.tDiagram != null) {
                granularity = null;
                categories = 0;
            }
            if (categories > 0) {
                String string = baseAmount = categories == 1 ? extent : extent + "/" + categories;
                if (!(size != null && size.isPercent() || this.scales.allNumeric(fields))) {
                    baseAmount = "0.9 * " + baseAmount;
                }
            } else {
                baseAmount = granularity != null ? "Math.abs( " + scaleName + "(" + granularity + ") - " + scaleName + "(0) )" : "geom.default_point_size";
            }
        }
        if (size != null && size.isPercent()) {
            baseAmount = size.value() + " * " + baseAmount;
        }
        if (needsFunction) {
            return "function(d) { return " + aestheticFunctionCall + " * " + baseAmount + "}";
        }
        return baseAmount;
    }

    public static String getOverallSize(VisSingle vis, ElementDefinition def) {
        boolean needsFunction;
        ModelUtil.Size size = ModelUtil.getElementSize(vis, "size");
        boolean bl = needsFunction = vis.fSize.size() == 1;
        if (size != null && !size.isPercent()) {
            if (needsFunction) {
                return "function(d) { return size(d) * " + size.value() + " }";
            }
            return "" + size.value();
        }
        String x = def.x.size;
        String y = def.y.size;
        if (x.equals(y)) {
            return x;
        }
        String xBody = D3ElementBuilder.stripFunction(x);
        String yBody = D3ElementBuilder.stripFunction(y);
        String content = "Math.min(" + xBody + ", " + yBody + ")";
        if (!xBody.equals(x) || !yBody.equals(y)) {
            return "function(d) { return " + content + " }";
        }
        return content;
    }

    private static String stripFunction(String item) {
        int p = item.indexOf("return");
        int q = item.lastIndexOf("}");
        if (p > 0 && q > 0) {
            return item.substring(p + 7, q).trim();
        }
        return item;
    }

    private ElementDefinition buildElementDefinition() {
        ElementDefinition e = new ElementDefinition();
        Field[] x = this.positionFields.getX(this.vis);
        Field[] y = this.positionFields.getY(this.vis);
        Field[] keys = new Field[this.vis.fKeys.size()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.data.field(this.vis.fKeys.get(i).asField());
        }
        ModelUtil.Size sizeWidth = ModelUtil.getElementSize(this.vis, "width");
        ModelUtil.Size sizeHeight = ModelUtil.getElementSize(this.vis, "height");
        if (this.scales.isGeo()) {
            if (this.vis.tDiagram != VisTypes.Diagram.map) {
                this.setGeoLocations(e, x, y, keys);
            }
            e.x.size = this.getSize(this.getSizeCall(0), sizeWidth, new Field[0], "geom.default_point_size", null);
            e.y.size = this.getSize(this.getSizeCall(1), sizeHeight, new Field[0], "geom.default_point_size", null);
        } else {
            this.setLocations(e.x, "x", x, keys, this.positionFields.xCategorical);
            this.setLocations(e.y, "y", y, keys, this.positionFields.yCategorical);
            e.x.size = this.getSize(this.getSizeCall(0), sizeWidth, x, "geom.inner_width", "scale_x");
            e.y.size = this.getSize(this.getSizeCall(1), sizeHeight, y, "geom.inner_height", "scale_y");
        }
        e.overallSize = D3ElementBuilder.getOverallSize(this.vis, e);
        return e;
    }

    private void setGeoLocations(ElementDefinition def, Field[] x, Field[] y, Field[] keys) {
        int n = x.length;
        if (y.length != n) {
            throw new IllegalStateException("X and Y dimensions do not match in geographic maps");
        }
        if (this.dependency.isEdge(this.vis)) {
            throw new IllegalStateException("Cannot handle edged dependencies in geographic maps");
        }
        if (this.dependency.isDependent(this.vis)) {
            throw new IllegalStateException("Cannot handle positional dependencies in geographic maps");
        }
        if (n == 0) {
            def.x.center = "null";
            def.y.center = "null";
        } else if (n == 1) {
            String xFunction = D3Util.writeCall(x[0]);
            String yFunction = D3Util.writeCall(y[0]);
            def.x.center = "function(d) { return projection([" + xFunction + "," + yFunction + "])[0] }";
            def.y.center = "function(d) { return projection([" + xFunction + "," + yFunction + "])[1] }";
        } else if (n == 2) {
            String xLow = D3Util.writeCall(x[0]);
            String xHigh = D3Util.writeCall(x[1]);
            if (this.isRange(x[0])) {
                xLow = xLow + ".low";
            }
            if (this.isRange(x[1])) {
                xHigh = xHigh + ".high";
            }
            String yLow = D3Util.writeCall(y[0]);
            String yHigh = D3Util.writeCall(y[1]);
            if (this.isRange(y[0])) {
                yLow = yLow + ".low";
            }
            if (this.isRange(y[1])) {
                yHigh = yHigh + ".high";
            }
            def.x.left = "function(d) { return projection([" + xLow + "," + yLow + "])[0] }";
            def.x.right = "function(d) { return projection([" + xHigh + "," + yHigh + "])[0] }";
            def.y.left = "function(d) { return projection([" + xLow + "," + yLow + "])[1] }";
            def.y.right = "function(d) { return projection([" + xHigh + "," + yHigh + "])[1] }";
        }
    }

    private String getSizeCall(int dim) {
        if (this.vis.fSize.isEmpty()) {
            return null;
        }
        if (this.vis.fSize.size() == 1) {
            return "size(d)";
        }
        return dim == 0 ? "width(d)" : "height(d)";
    }

    private void setLocations(ElementDefinition.ElementDimensionDefinition dim, String dimName, Field[] fields, Field[] keys, boolean categorical) {
        String scaleName = "scale_" + dimName;
        if (this.dependency.isEdge(this.vis)) {
            dim.left = "function(d) { return scale_" + dimName + "(d.source." + dimName + ") }";
            dim.right = "function(d) { return scale_" + dimName + "(d.target." + dimName + ") }";
        } else if (this.dependency.isDependent(this.vis)) {
            if (keys.length == 1) {
                dim.center = "function(d) { return " + scaleName + "(" + this.dependency.keyedLocation(dimName, keys[0]) + ") }";
            } else {
                dim.left = "function(d) { return " + scaleName + "(" + this.dependency.keyedLocation(dimName, keys[0]) + ") }";
                dim.right = "function(d) { return " + scaleName + "(" + this.dependency.keyedLocation(dimName, keys[1]) + ") }";
                dim.center = "function() { return " + scaleName + "(0.5) }";
            }
        } else if (fields.length == 0) {
            dim.center = "function() { return " + scaleName + "(0.5) }";
            dim.left = "function() { return " + scaleName + "(0) }";
            dim.right = "function() { return " + scaleName + "(1) }";
        } else if (fields.length == 1) {
            Field field = fields[0];
            String dataFunction = D3Util.writeCall(field);
            if (this.isRange(field)) {
                dim.center = "function(d) { return " + scaleName + "(" + dataFunction + ".extent()) }";
            } else if (field.isBinned() && !categorical) {
                dim.center = "function(d) { return " + scaleName + "(" + dataFunction + ".mid) }";
                dim.left = "function(d) { return " + scaleName + "(" + dataFunction + ".low) }";
                dim.right = "function(d) { return " + scaleName + "(" + dataFunction + ".high) }";
            } else {
                dim.center = "function(d) { return " + scaleName + "(" + dataFunction + ") }";
            }
        } else {
            String lowDataFunc = D3Util.writeCall(fields[0]);
            String highDataFunc = D3Util.writeCall(fields[1]);
            if (this.isRange(fields[0])) {
                lowDataFunc = lowDataFunc + ".low";
            }
            if (this.isRange(fields[1])) {
                highDataFunc = highDataFunc + ".high";
            }
            dim.left = "function(d) { return " + scaleName + "(" + lowDataFunc + ") }";
            dim.right = "function(d) { return " + scaleName + "(" + highDataFunc + ") }";
            dim.center = "function(d) { return " + scaleName + "( (" + highDataFunc + " + " + lowDataFunc + " )/2) }";
        }
    }

    private void modifyGroupStyleName() {
        if (this.diagram != null) {
            this.out.add("main.attr('class',", this.diagram.getStyleClasses(), ")").endStatement();
        }
    }

    private void writeCoordEnter() {
        ModelUtil.Size size = ModelUtil.getRoundRectangleRadius(this.vis);
        if (size != null) {
            this.out.addChained("attr('rx'," + size.valueInPixels(8.0) + ").attr('ry', " + size.valueInPixels(8.0) + ")").ln();
        }
        this.out.endStatement().onNewLine().ln();
    }

    private void constructSplitPath() {
        String params = "data, path";
        if (this.vis.tElement == VisTypes.Element.line || this.vis.tElement == VisTypes.Element.area) {
            params = params + ", x";
        }
        this.out.add("var splits = BrunelD3.makePathSplits(" + params + ");").ln();
    }

    private void defineEdge(String basicDef, ElementDefinition elementDef) {
        this.out.add(basicDef);
        this.out.addChained("attr('x1'," + elementDef.x.left + ")");
        this.out.addChained("attr('y1'," + elementDef.y.left + ")");
        this.out.addChained("attr('x2'," + elementDef.x.right + ")");
        this.out.addChained("attr('y2'," + elementDef.y.right + ")");
    }

    private void defineCircle(String basicDef, ElementDefinition elementDef) {
        this.out.add(basicDef);
        this.out.addChained("attr('cx'," + elementDef.x.center + ")");
        this.out.addChained("attr('cy'," + elementDef.y.center + ")");
        this.out.addChained("attr('r'," + this.halve(elementDef.overallSize) + ")");
    }

    private String halve(String sizeText) {
        String body = D3ElementBuilder.stripFunction(sizeText);
        if (body.equals(sizeText)) {
            return body + " / 2";
        }
        return "function(d) { return " + body + " / 2 }";
    }

    private void definePathsAndSplits(ElementDefinition elementDef) {
        this.defineVerticalExtentFunctions(elementDef, false);
        if (this.vis.tElement == VisTypes.Element.bar && this.vis.coords == VisTypes.Coordinates.polar) {
            this.out.add("var path = d3.svg.arc().outerRadius(geom.inner_radius).innerRadius(0)").ln();
            this.out.addChained("outerRadius(geom.inner_radius).innerRadius(0)").ln();
            if (this.vis.fRange == null && !this.vis.stacked) {
                this.out.addChained("startAngle(0).endAngle(y)");
            } else {
                this.out.addChained("startAngle(y0).endAngle(y1)");
            }
            this.out.endStatement();
            return;
        }
        this.out.add("var x =", elementDef.x.center).endStatement();
        if (this.vis.tElement == VisTypes.Element.area) {
            if (this.vis.fRange == null && !this.vis.stacked) {
                this.out.add("var path = d3.svg.area().x(x).y1(y).y0(function(d) { return scale_y(0) })");
            } else {
                this.out.add("var path = d3.svg.area().x(x).y1(y1).y0(y0)");
            }
        } else if (this.vis.tElement.producesSingleShape) {
            String yDef;
            String string = yDef = elementDef.y.right == null ? "y" : "y1";
            if (this.vis.fSize.size() == 1) {
                this.out.add("var path = BrunelD3.sizedPath().x(x).y(" + yDef + ")");
                String size = elementDef.y.size != null ? elementDef.y.size : elementDef.overallSize;
                this.out.addChained("r(" + size + ")");
            } else {
                this.out.add("var path = d3.svg.line().x(x).y(" + yDef + ")");
            }
        }
        if (this.vis.tUsing == VisTypes.Using.interpolate) {
            this.out.add(".interpolate('basis')");
        }
        this.out.endStatement();
        this.constructSplitPath();
    }

    private void defineRect(String basicDef, ElementDefinition elementDef) {
        this.defineVerticalExtentFunctions(elementDef, true);
        this.defineHorizontalExtentFunctions(elementDef, true);
        this.out.add(basicDef);
        this.defineHorizontalExtent(elementDef);
        this.defineVerticalExtent(elementDef);
    }

    private void defineBar(String basicDef, ElementDefinition elementDef) {
        if (this.vis.fRange != null || this.vis.stacked) {
            this.out.add("var y0 =", elementDef.y.left).endStatement();
            this.out.add("var y1 =", elementDef.y.right).endStatement();
            this.defineHorizontalExtentFunctions(elementDef, true);
            this.out.add(basicDef);
            this.out.addChained("attr('y', function(d) { return Math.min(y0(d), y1(d)) } )");
            this.out.addChained("attr('height', function(d) {return Math.abs(y0(d) - y1(d)) })");
        } else {
            this.out.add("var y =", elementDef.y.center).endStatement();
            this.defineHorizontalExtentFunctions(elementDef, true);
            this.out.add(basicDef);
            if (this.vis.coords == VisTypes.Coordinates.transposed) {
                this.out.addChained("attr('y', 0)").addChained("attr('height', function(d) { return Math.max(0,y(d)) })");
            } else {
                this.out.addChained("attr('y', y)").addChained("attr('height', function(d) {return Math.max(0,geom.inner_height - y(d)) }) ");
            }
        }
        this.defineHorizontalExtent(elementDef);
    }

    private void defineHorizontalExtentFunctions(ElementDefinition elementDef, boolean withWidth) {
        if (elementDef.x.left != null) {
            this.out.add("var x0 =", elementDef.x.left).endStatement();
            this.out.add("var x1 =", elementDef.x.right).endStatement();
        } else {
            this.out.add("var x =", elementDef.x.center).endStatement();
            if (withWidth) {
                this.out.add("var w =", elementDef.x.size).endStatement();
            }
        }
    }

    private void defineVerticalExtentFunctions(ElementDefinition elementDef, boolean withHeight) {
        if (elementDef.y.left != null) {
            this.out.add("var y0 =", elementDef.y.left).endStatement();
            this.out.add("var y1 =", elementDef.y.right).endStatement();
        } else {
            this.out.add("var y =", elementDef.y.center).endStatement();
            if (withHeight) {
                this.out.add("var h =", elementDef.y.size).endStatement();
            }
        }
    }

    private void defineHorizontalExtent(ElementDefinition elementDef) {
        String width;
        String left;
        if (elementDef.x.left != null) {
            left = "function(d) { return Math.min(x0(d), x1(d)) }";
            width = "function(d) { return Math.abs(x1(d) - x0(d)) }";
        } else {
            left = elementDef.x.size.startsWith("function") ? "function(d) { return x(d) - w(d)/2 }" : "function(d) { return x(d) - w/2 }";
            width = "w";
        }
        this.out.addChained("attr('x', ", left, ")");
        this.out.addChained("attr('width', ", width, ")");
        this.out.addChained("style('width', ", width, ")");
    }

    private void defineVerticalExtent(ElementDefinition elementDef) {
        String height;
        String top;
        if (elementDef.y.left != null) {
            top = "function(d) { return Math.min(y0(d), y1(d)) }";
            height = "function(d) { return Math.abs(y1(d) - y0(d)) }";
        } else {
            top = elementDef.y.size.startsWith("function") ? "function(d) { return y(d) - h(d)/2 }" : "function(d) { return y(d) - h/2 }";
            height = "h";
        }
        this.out.addChained("attr('y', ", top, ")");
        this.out.addChained("attr('height', ", height, ")");
    }

    private void defineText(String basicDef, ElementDefinition elementDef) {
        this.out.add(basicDef);
        this.out.addChained("attr('x'," + elementDef.x.center + ")");
        this.out.addChained("attr('y'," + elementDef.y.center + ")");
        this.out.addChained("attr('dy', '0.35em').text(labeling.content)");
        this.labelBuilder.addFontSizeAttribute(this.vis);
    }

    private String getKeyFunction() {
        String content = this.diagram != null ? this.diagram.getRowKey() : "d.key";
        return "function(d) { return " + content + "}";
    }

    private String getSymbol() {
        String result = ModelUtil.getElementSymbol(this.vis);
        if (result != null) {
            return result;
        }
        boolean cat = this.allShowExtent(this.positionFields.allXFields) && this.allShowExtent(this.positionFields.allYFields);
        return cat ? "rect" : "point";
    }

    private boolean allShowExtent(Field[] fields) {
        for (Field field : fields) {
            if (!field.isNumeric() || field.isBinned()) continue;
            return false;
        }
        return true;
    }

    private boolean isRange(Field field) {
        String s = field.stringProperty("summary");
        return s != null && (s.equals("iqr") || s.equals("range"));
    }

    private ElementDetails makeDetails() {
        if (this.dependency.isEdge(this.vis)) {
            String dataDef = "elements[" + this.dependency.sourceIndex + "].internal()._graph.links";
            return ElementDetails.makeForDiagram(dataDef, "line", "edge", "box", false);
        }
        if (this.diagram == null) {
            return ElementDetails.makeForCoordinates(this.vis, this.getSymbol());
        }
        return this.diagram.writeDataConstruction();
    }

    private void writeCoordinateDefinition(ElementDetails details, ElementDefinition elementDef) {
        String basicDef = "BrunelD3.trans(selection,transitionMillis)";
        if (details.splitIntoShapes) {
            this.out.add(basicDef).addChained("attr('d', function(d) { return d.path })");
        } else if (details.producesPath) {
            this.out.add(basicDef).addChained("attr('d', path)");
        } else if (this.vis.tElement == VisTypes.Element.text) {
            this.defineText(basicDef, elementDef);
        } else if (this.vis.tElement == VisTypes.Element.bar) {
            this.defineBar(basicDef, elementDef);
        } else if (this.vis.tElement == VisTypes.Element.edge) {
            this.defineEdge(basicDef, elementDef);
        } else if (details.elementType.equals("rect")) {
            this.defineRect(basicDef, elementDef);
        } else {
            this.defineCircle(basicDef, elementDef);
        }
    }

    private void writeCoordinateLabelingAndAesthetics(ElementDetails details) {
        if (!this.vis.fColor.isEmpty()) {
            this.out.addChained("style(" + details.colorAttribute + ", color)");
        }
        if (details.needsStrokeSize) {
            this.out.addChained("style('stroke-width', size)");
        }
        if (!this.vis.fOpacity.isEmpty()) {
            this.out.addChained("style('fill-opacity', opacity)").addChained("style('stroke-opacity', opacity)");
        }
        this.out.endStatement();
        this.labelBuilder.addTooltips(details);
        if (this.labelBuilder.needed() && this.vis.tElement != VisTypes.Element.text) {
            this.labelBuilder.addLabels(details);
        }
    }
}

