/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.d3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.DataTransformParameters;
import org.brunel.build.d3.D3Util;
import org.brunel.build.util.BuilderOptions;
import org.brunel.build.util.ScriptWriter;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.data.summary.FieldRowComparison;
import org.brunel.data.util.DateFormat;
import org.brunel.data.util.Range;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;

public class D3DataBuilder {
    private final VisSingle vis;
    private final ScriptWriter out;
    private final Dataset data;
    private final int datasetIndex;

    public D3DataBuilder(VisSingle vis, ScriptWriter out, Dataset data, int index) {
        this.vis = vis;
        this.out = out;
        this.data = data;
        this.datasetIndex = index;
    }

    public void writeDataManipulation(Map<String, Integer> requiredFields) {
        this.out.onNewLine().ln().add("function makeData() {").ln().indentMore();
        this.writeDataTransforms();
        this.writeHookup(requiredFields);
        this.out.indentLess().onNewLine().add("}").endStatement().ln();
    }

    public static void writeTables(VisItem main, ScriptWriter out, BuilderOptions options) {
        if (options.includeData == BuilderOptions.DataMethod.none) {
            return;
        }
        if (options.includeData == BuilderOptions.DataMethod.minimal) {
            throw new UnsupportedOperationException("Cannot make minimal data yet");
        }
        Dataset[] datasets = main.getDataSets();
        for (int d = 0; d < datasets.length; ++d) {
            Field[] fields;
            Dataset data = datasets[d];
            if (options.includeData == BuilderOptions.DataMethod.columns) {
                LinkedHashSet<Field> fieldsAsSet = new LinkedHashSet<Field>();
                D3DataBuilder.addUsedFields(main, data, fieldsAsSet);
                fields = fieldsAsSet.toArray(new Field[fieldsAsSet.size()]);
            } else {
                fields = data.fields;
            }
            if (fields.length == 0) {
                fields = new Field[]{Data.makeConstantField((String)"_dummy_", (String)"Dummy", (Object)1.0, (int)data.rowCount())};
            }
            out.onNewLine().add("var", String.format(options.dataName, d + 1), "= [").ln().indentMore();
            int numPerLine = 12 / Math.max(1, Math.max(1, fields.length));
            out.add("[");
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].name;
                if (name.startsWith("#")) continue;
                if (i > 0) {
                    out.add(", ");
                }
                out.add("'").add(name).add("'");
            }
            out.add("],");
            for (int r = 0; r < data.rowCount(); ++r) {
                if (r > 0) {
                    out.add(",");
                }
                if ((r + 1) % numPerLine == 0) {
                    out.onNewLine();
                }
                out.add(D3DataBuilder.makeRowText(fields, r));
            }
            out.indentLess().onNewLine().add("]").endStatement();
        }
    }

    private static void addUsedFields(VisItem item, Dataset data, Collection<Field> fields) {
        if (item.children() == null) {
            VisSingle vis = (VisSingle)item;
            if (vis.getDataset() != data) {
                return;
            }
            for (String f : vis.usedFields(true)) {
                Field field;
                if (f.startsWith("#") || (field = data.field(f, true)) == null) continue;
                fields.add(field);
            }
        } else {
            for (VisItem i : item.children()) {
                D3DataBuilder.addUsedFields(i, data, fields);
            }
        }
    }

    private void defineKeyFieldFunction(List<String> fields, boolean actsOnRowObject, Map<String, Integer> usedFields) {
        this.out.add("function(d) { return ");
        if (fields.isEmpty()) {
            this.out.add("'ALL'");
        } else {
            for (int i = 0; i < fields.size(); ++i) {
                String s = fields.get(i);
                if (i > 0) {
                    this.out.add("+ '|' + ");
                }
                this.out.add("f" + usedFields.get(s));
                this.out.add(actsOnRowObject ? ".value(d.row)" : ".value(d)");
            }
        }
        this.out.add(" }");
    }

    private List<String> makeKeyFields() {
        List<String> result;
        if (!this.vis.fKeys.isEmpty()) {
            return this.asFields(this.vis.fKeys);
        }
        if (this.vis.tDiagram == VisTypes.Diagram.chord) {
            result = new ArrayList<String>();
            Collections.addAll(result, this.vis.positionFields());
            Collections.addAll(result, this.vis.aestheticFields());
            if (this.suitableForKey(result)) {
                return result;
            }
        }
        if (this.vis.tDiagram == VisTypes.Diagram.tree || this.vis.tDiagram == VisTypes.Diagram.treemap || this.vis.tDiagram == VisTypes.Diagram.map) {
            return Arrays.asList(this.vis.positionFields());
        }
        if (this.vis.tElement.producesSingleShape) {
            return this.makeSplitFields();
        }
        if (this.vis.tDiagram == null) {
            result = this.asFields(this.vis.fX);
            Collections.addAll(result, this.vis.aestheticFields());
            if (this.suitableForKey(result)) {
                return result;
            }
        }
        return Collections.singletonList("#row");
    }

    private List<String> asFields(List<Param> items) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Param p : items) {
            fields.add(p.asField());
        }
        return fields;
    }

    private static String makeRowText(Field[] fields, int r) {
        StringBuilder row = new StringBuilder();
        D3Util.DateBuilder dateBuilder = new D3Util.DateBuilder();
        row.append("[");
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            Field field = fields[i];
            if (field.name.startsWith("#")) continue;
            if (i > 0) {
                row.append(", ");
            }
            if ((value = field.value(r)) == null) {
                row.append("null");
                continue;
            }
            if (value instanceof Range) {
                row.append(Data.quote((String)value.toString()));
                continue;
            }
            if (field.isDate()) {
                Date date = Data.asDate((Object)value);
                if (date == null) {
                    return null;
                }
                row.append(dateBuilder.make(date, (DateFormat)field.property("dateFormat"), false));
                continue;
            }
            if (field.isNumeric()) {
                Double d = Data.asNumeric((Object)value);
                if (d == null) {
                    return null;
                }
                row.append(d.toString());
                continue;
            }
            row.append(Data.quote((String)value.toString()));
        }
        row.append("]");
        return row.toString();
    }

    private boolean suitableForKey(List<String> result) {
        Field[] fields = new Field[result.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this.data.field(result.get(i));
        }
        FieldRowComparison rowComparison = new FieldRowComparison(fields, null, false);
        int[] order = rowComparison.makeSortedOrder(this.data.rowCount());
        for (int i = 1; i < order.length; ++i) {
            if (rowComparison.compare(Integer.valueOf(order[i]), Integer.valueOf(order[i - 1])) != 0) continue;
            return false;
        }
        return true;
    }

    private void writeDataTransforms() {
        DataTransformParameters params = (DataTransformParameters)this.data.property("parameters");
        D3Util.addTiming("Data Start", this.out);
        this.out.add("original = datasets[" + this.datasetIndex + "]").endStatement();
        this.out.add("processed = pre(original,", this.datasetIndex, ")");
        this.out.mark();
        this.writeTransform("addConstants", params.constantsCommand);
        Param param = this.vis.tInteraction.get((Object)VisTypes.Interaction.filter);
        if (param != null) {
            if ("unselected".equals(param.asString())) {
                this.writeTransform("filter", "#selection is \u2717");
            } else {
                this.writeTransform("filter", "#selection is \u2713");
            }
        }
        this.writeTransform("filter", params.filterCommand);
        this.writeTransform("bin", params.transformCommand);
        this.writeTransform("summarize", params.summaryCommand);
        if (!params.seriesCommand.isEmpty()) {
            if (params.summaryCommand.isEmpty()) {
                this.writeTransform("reduce", params.usedCommand);
            }
            this.writeTransform("series", params.seriesCommand);
        }
        this.writeTransform("sort", params.sortCommand);
        this.writeTransform("stack", params.stackCommand);
        this.out.endStatement();
        this.out.add("processed = post(processed,", this.datasetIndex, ")").endStatement();
        D3Util.addTiming("Data End", this.out);
    }

    private void writeHookup(Map<String, Integer> fieldsToIndex) {
        String fieldID;
        int fieldIndex;
        String[] fields = new String[fieldsToIndex.size()];
        for (Map.Entry<String, Integer> e : fieldsToIndex.entrySet()) {
            fields[e.getValue().intValue()] = e.getKey();
        }
        this.out.onNewLine().add("var ");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                this.out.onNewLine();
            } else {
                this.out.indentMore();
            }
            this.out.add("f" + i, "= processed.field(" + this.out.quote(fields[i]) + ")");
            if (i == fields.length - 1) {
                this.out.endStatement();
                continue;
            }
            this.out.add(",");
        }
        this.out.indentLess();
        this.out.add("var keyFunction = ");
        this.defineKeyFieldFunction(this.makeKeyFields(), false, fieldsToIndex);
        this.out.endStatement();
        this.out.add("data = {").ln().indentMore();
        for (fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
            fieldID = D3Util.canonicalFieldName(fields[fieldIndex]);
            this.out.add(fieldID, ":").at(24).add("function(d) { return f" + fieldIndex + ".value(d.row) },").ln();
        }
        for (fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
            fieldID = D3Util.canonicalFieldName(fields[fieldIndex]);
            this.out.add(fieldID + "_f", ":").at(24).add("function(d) { return f" + fieldIndex + ".valueFormatted(d.row) },").ln();
        }
        this.out.add("_split:").at(24);
        this.defineKeyFieldFunction(this.makeSplitFields(), true, fieldsToIndex);
        this.out.add(",").ln();
        this.out.add("_rows:").at(24).add("BrunelD3.makeRowsWithKeys(keyFunction, processed.rowCount())");
        if (this.vis.fKeys.size() == 1 && this.vis.fX.size() == 1 && this.vis.fY.size() == 1) {
            this.out.add(",").ln();
            String id = "f" + fieldsToIndex.get(this.vis.fKeys.get(0).asField());
            String x = "f" + fieldsToIndex.get(this.vis.fX.get(0).asField());
            String y = "f" + fieldsToIndex.get(this.vis.fY.get(0).asField());
            this.out.add("_idToPoint:").at(24).add("BrunelD3.locate(" + id, ", ", x, ",", y, ", processed.rowCount())");
        }
        this.out.onNewLine().indentLess().add("}").endStatement();
    }

    private List<String> makeSplitFields() {
        ArrayList<String> splitters = new ArrayList<String>();
        for (Param p : this.vis.fSplits) {
            splitters.add(p.asField());
        }
        for (Param p : this.vis.fColor) {
            splitters.add(p.asField());
        }
        for (Param p : this.vis.fOpacity) {
            splitters.add(p.asField());
        }
        if (this.vis.tElement != VisTypes.Element.line && this.vis.tElement != VisTypes.Element.path) {
            for (Param p : this.vis.fSize) {
                splitters.add(p.asField());
            }
        }
        return splitters;
    }

    private void writeTransform(String name, String command) {
        if (!command.isEmpty()) {
            this.out.addChained(name, "(" + this.out.quote(command) + ")");
        }
    }
}

