/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.action.parse;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Scanner;
import java.util.Set;
import org.brunel.action.Parser;
import org.brunel.action.parse.GrammarItem;

public class ParseGrammar {
    private static final ParseGrammar instance = new ParseGrammar();
    private final LinkedHashMap<String, GrammarItem> grammar;
    private final Set<String> summaryMethods = new LinkedHashSet<String>();
    private final Set<String> transformMethods = new LinkedHashSet<String>();

    public static ParseGrammar instance() {
        return instance;
    }

    public static Collection<String> getCommands() {
        return ParseGrammar.instance().grammar.keySet();
    }

    private ParseGrammar() {
        this.grammar = new LinkedHashMap();
        Scanner scanner = new Scanner(Parser.class.getResourceAsStream("brunel-tokens.txt"));
        while (scanner.hasNext()) {
            String line = scanner.nextLine().trim();
            if (line.isEmpty() || line.startsWith("#")) continue;
            String[] words = line.split("[\n\t ]+");
            this.grammar.put(words[0], new GrammarItem(words));
            if (words[1].equals("data")) {
                this.summaryMethods.add(words[0]);
            }
            if (!words[1].equals("transform")) continue;
            this.transformMethods.add(words[0]);
        }
    }

    public GrammarItem get(String command) {
        return this.grammar.get(command);
    }

    public Set<String> getSummaryMethods() {
        return this.summaryMethods;
    }

    public Set<String> getTransformMethods() {
        return this.transformMethods;
    }
}

