"""Embedded icons."""

from wx.lib.embeddedimage import PyEmbeddedImage

icon = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAAPoAAAD6CAYAAACI7Fo9AAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9sEBRIGOBeJeLgAACAA"
    "SURBVHja7J13eFP1F8Y/SZM06R50MyobZE8ZouwlCKIIsgVEQRBRFBTHT3GBAwQRmQIqQwRB"
    "poDsvfeGAgU66W528vvjtmnSJG2hLTTlvs+Tp83Nzc1d7z3ne77nvAdEiBAhQoQIESJEiBAh"
    "QoQIESJEiBAhQoQIESJEiBAhQoQIESJEiHiMIBFPwWOJSKCp1at61nIzYLJ6Wb/XArHA3axX"
    "jNX/2a+ErO+IEIku4iHDD2hsReomQHAx/VYqcBw4ZvX3AmAUL4NIdBFFBzlQx4rQTYFqj/g6"
    "q4FTWaQ/BGzK8gZEiEQXcR8IBHoBLwPNAWVhN6iQSwjyccNsBrXOjFpnQqs3Yy4ap9wMHAHW"
    "Zb2OiZdQJLoIx/AAXgD6Au2zLHnB/HhPNyqEyAnycSPYz40gXxnBvm4E+8oI8hP++nhI7dlp"
    "Bo3ejFprspBfrTWTmmniyl0dl27ruBit5VqMHp3hvp4It4H1WaTfmuUBiBCJ/lgjAHgTGJNl"
    "yfNFsK8bDauoaFRZScMqSiqFKpAU41U3msxcj9Vz6XY2+YUHQFxKgYbpqcBi4GfgnHi5RaI/"
    "bigLjANeAzzzWjEiUEYjK2KXD5KXiAO4dFvHluMZbDmewZW7uoJ8ZQcwC1gNGMRbQCR6aYQC"
    "eApoC7RDCKzJnK1co5w7L7X0plUtD0L9ZSX+4K7H6NlyQiD9+Vva/Fa/C8zJet0Rbw2R6KXB"
    "ar8EdACezs9yqxQSOjfyovfTPtSq4O6yBx2doGfL8Qw2H8vgzI08SW8AFgCfZpFfhEh0l4Ev"
    "8CLQD3gGkBbkSy+28ObdXoF4KaWl6mQcu6rhl41J7D2XZzwuE/gemAKkibeQSPSSjtHAVOC+"
    "zHGov4ytX5Qv1Sfm7A0tczYl89+pjLym9OKBz4BfAL14O+UNN/EUPHQogfnAhLzG3U7Nmc5E"
    "nciSE2QrDgT7yejcyIv29T1JzTRx7a7OUV6tJ9AFeAUhAeeseGuJFr2koDxCFLlBYTbipZTy"
    "2/hwKocpHouTdiNOz7zNyaw9mI7R5NTE/wu8ijAvL0Ik+iNDa2AFUMZ6ocxNYhre0U86qK0v"
    "EgkYjKDVm1j8Xwq/bU/FYHR8Ywf6uDFteAj1KykfmxN4IVrHpMVxXIh2Oj2XBIwCloq3m+i6"
    "Pwq8AvwFeFsvDPJ1Y8WECEn7+p4o5BIUMglKhQRPpZTmNTxoX9+T67F6bifaTyOrtWb+OZRO"
    "gLcbT7pw1P1+UMbHjV4tvFHIpBy/qsFosltFhZAOXAP4DzHLTiT6Q8Q4YHbucy2RwLThoXlO"
    "jQV4u/H8U96UD5Kz/4Iafa7UUpMZdp7JJDbZQMuaHrhJS7+DJpVIaFhZSfv6Xpy7qSU22WHG"
    "XS1gAEJ23RXxFhSJXtzDoqnA/xwNkTo28GRoR78CbahqhIIO9T05dkVDQqr9jX3+lo5DlzQ8"
    "18TrsSA7gL+XGz2b++DtIeXoFQ0G+9PiDfQHgoAtCDX1ItFFFCmCs8aJQ5ytMHlAMCF+BQ+6"
    "+3m60aOZN8kZJs46SCyJSTLQrp4nQb6yx+YkSyRQ9wklnRt6cemOnjuJDjNlmwAtgLWARiS6"
    "iKJCD2AjUN/ZCq3reDC4nd/9XyyphGdqeVApVMG+82q7KrGXW/lSxufxu6S+nm4839QbncHM"
    "8asOufwE8DxClVyySHQRhUFNYBrwBXmkr0ok8N2wEAILSMgtxzN4d34cZ6K0yNwkVAiWUzlc"
    "QYcGnlyI1nH3niHrZpfyTs8ApNLHcyJFIoFm1VWEBcjYfVaNg1m4IISy3l08hlNwItELPw7v"
    "CPyEkJZZO78vdGnkRZ9nfAr8Ax8ujudCtI4L0To2HkmnQoicKuEKfD3d6NlMCNT5ekoZ3tGf"
    "J0IVj/0FqVHOnYaVlWw/lYlWb8d2r6xx+zkEiavH6kYVcX+IRKgoawu04T7019ykEtZ+XJYK"
    "wQXPantmwg0SrQJwMjcJe6ZWKHV57kWNqDg9I3+K4Wa8w+xYEzA+6+H8WEC8Wwp2jloiRNAv"
    "AdeBuUAf7lNksUczr/siOYC3yvYSGYxmDl/SiFclv6dxsJw/3gunUWWls2v6HUJhjEj0xxgq"
    "oBtCTnoMsBt4F6jyoBsM9HFjdLeA+/6ej8r+Eh24KOaBFAR+nm7MHRNG96bezlYZj1DnXup5"
    "IBNvBwsUQG8ELbaOCLpsRfM0lcLUV4MfKCLu42H/nYQUUXCloJDLJHw5KAgPdwnLdqU6WmU4"
    "Qrlwf0pxFZxIdKFMdChCNVm54viBMd0CaFJV9WBWycve2BhM4kW7X3z4chkytWbWHnRYwt4b"
    "8EFIn80UiV760B5YCERYL5QgpJ+GBsjw9ZASnWAgOkGP6QHkjp+t7cHQDn4PvIPhAfaXyGgU"
    "m6HcLyQSmDwgCLXOxJbjGY5W6QRsBp4DUkSilx68DCzBSiq5TqQ7g9r60bquBwqZ7YSEVm8m"
    "KlbPzxuS2Hoio0A/UC5IzleDgwululqujH3wziha9AceQk0ZEsxobSx7zjk03C0RRCk7AnGl"
    "6tgf02v+BvBHNskDfdxYMDaMP96LoGNDTzuSA7jLJVQrqyDAu2Dj7EphCha9HWYXNb9flC1j"
    "/ywu7DYf9zH79BEhNKritLy3HkLwtbxIdNfGM8DM7GOvEq5g6XsRBRpD77+gZtW+/GXKake6"
    "s2hcGMF+hXeYyjqw6MF+Yp5TYeAul/DTG6HUjnRaOVgV2IPQzkokugvCV+YmWZp93BGBMhaN"
    "C3c4DraG2Qx/7kll7JxYp0IQ2WhWXcX8t8Lw8ywaMob4y+wq0sr4iDHUwsJTKWX2qDCqhDvN"
    "JiyXZdnri0R3MXirpL8ajOYwEDLMvhsW4rD9UM5Y2Myec5n0//Y2//sjgQyN88GxVAID2vgy"
    "a2QoHu5Fd1qlElDIRIteLE99Tykz3wjN6x4IArYjdKN1aTw2pkEhkzRPU5t6ZL8f0dnPqejD"
    "hWgdy3amsPVEJskZ+bcSqhAsZ/KAoGKTdXJzk2DddjzYV7ToRYWIQBlTXg1m5E8xzmZVfBHa"
    "RNUFdK56nI+NRQ/ydZuT/b+XUsqA1r4O1/vh73u8+GU0K/em5UtymZuEwe18WfVh2WLVbnPL"
    "dZXK+IoWvSjRsqYHI7v657VKdeAD0aKX/Kd229uJhiez3/d+2gcvB5HrXWcymf9v/uXKnkop"
    "L7X0ZmAb3yIJuOVPdNsxerBI9CLHiM7+nL6hZedpp/kyE4FvgXSR6CUUKnfpz9bv29R1nN16"
    "PdZ5BqREArUquNOxgRcvtvB2+KAoLljHBjzcpUUaAxCRc32/GhRMh0k3SXcci1EAWlc9vlJP"
    "9DB/WZVrd3WWYhS5TEKNco7H5r1aeLPleAYnr2sI9pVRPlhO+SAZNcq506aOx0Ox3rmRmmmy"
    "qasWA3HFBx8PKT2be7PkP4eJcWm4cC58qSd6oI/bV3eTcopAapRV4C53nKrmpZSyYGwYZjNO"
    "13nYiMtVwPJEiFxkZDGiRU2VM6K7dKZcaSe6IipO/5z1gjpP5B00c5QV9ygRn2IbEKwoqsgU"
    "s1V36jGdcuXjKtWDvWBf2cB0tcnGT69f0bU6m8TnsugVQ0WLXpw4fd2pqMdxkeglFBIJ7+de"
    "1rCKaxE9Llm06A8T6w47DarfEYleMlErNtlQ2XpBZIjc5eSQ43M1bHhCtOjFhpvxek5HOQ2s"
    "R4pEL5nW/M3cyx5U/OHRWvQc1z3YTyaKQhanNT+U5xR5PZHoJXB4joMuKY2ruF7n0Uu3c7Iu"
    "K4nWvNgQk2Rg0bY89SZa4cLy6KWV6G+ZzdgNZhu7mEVPU5ts5IorhYnj8+JCfkVLCFJTjUSi"
    "lxz4AyNzL3wi1PXG52dvajFbFVo8Tr3QHyb+PpDG7rMFkoprJRK95GAqYCfS1rq2p8sdyJlc"
    "gSEnGuUiCoE95zL53x8JBV09QyR6yUBrBEVXO3Ru5IJEt+qaGhkiL3C/NhEFw+FLat76Jdau"
    "73weuCgS/dEjGJjn6IPIELnT/PaS7rqL1rx4oNaZmfBrvKP+bE6/Aux31eMtLSmwAQjN7is6"
    "tOYNvVzugOJSjJZOqQCNqqhc9uLEJhvYc1bN8asaTkVpCPKVUSfSnUZVVLSo+WiOy2gyF0hU"
    "xAqbcWHN99JAdB9gE1DH2QqdG7ke0bccs53TbVTFNS36hiPpdhHtazF6Dl5UM3dzMi+19OHD"
    "lwORuT3cGgMvpZT/9Qti8vIEgnzd6PO0D6eitKx3nhm3w5VJ4upE90Bobu9U06tqhMIl88M3"
    "HM2J+0QEygj1d61LpdWb+XJFAn/tzVs19889qVy9q2PaayEFltIuKjzXxIt29TxRKoSHTD/g"
    "xRbeDJl21+FIypWJ4spjdHdgDYLovlP0au7tcgd2O9HAyWs5xRWt67heIPGDxXH5kjwbx65q"
    "eGXqHaLiHn65dzbJs9G4qopyQQ4NQ7IrE91VLboU+BOhTzlNq6m0KoXEfUcuGSCVQsLzT7ke"
    "0TcesXUfuzZ2raHHvM3JbD56fzNR0Ql6+k+9w4SXAlG5S9AbzGj1ZjQ6M2qdGYVMQp9nfJA+"
    "BA+/URUlt+z7qvcCjohEf7j4AqGtMW3ret7+fnhwxDcrE+1W6tb04Uo+FeW4NhvlguR5NRoo"
    "cdh9NpMf1957oO8mZxiZ8KtzfYcT1zR8NTjITkOvqNGihorV9o06BiBoxiWKrvvDwYsInU+J"
    "DJFfmPZaSITZDNtO2AdE+z7j43IHdzFaZ5Pf3rmh67jttxMNvLcg7oGaURb0AXjwoqbYj+Op"
    "6ipHnkME8C+C/LNI9GLGkwjdT3GTkrBoXHikRCLUEMcmG+zcrzy6cJRYzFx3z2Xd9i+WJ5Cm"
    "Lt4OkKeuFz/R/Tzd6NHM4ZCvAbAB8BSJXoznH/gb8ALMU14NiQ30dlOazbBwi33V0SvPut6D"
    "9/hVDdtP5XgmVSMULlPIsu1EBrvOFP80c8OHlDg0sXcZIh3r8zUH1gJKkejFs5+/A5UBnqqm"
    "2tmxgeeTADvPZHL1rm0DjWA/GW2dSDqXZHz/t60179bENay5Wmfm65XFO3Qt4+PG5IFBNK6q"
    "IkNjYtuJDFbsTi2231MpJEx9NRi5Yw3BNghNGF2mL5urBOM+BroAuMslZ38eFdok+wNHDRd6"
    "t/Qu9oBNUWP7qUyOX81xS71VUl562jViDLM3JNlk8RUVqoQrGNjGl2dqe1jm2K/e1TFiZgwx"
    "SQbcpBKeftKDsIDiuY1rlHNn+mshvDs/jkyt3ZCkIXAYmJ51f5boghdXsOhNgElZ/2t/ezdc"
    "LZdJPECIwlqTAwTd9pdaulYQzmSCaWtsrfmANr4uoSaToTHxx46UIt1msJ+MWSNDWT2pLD2b"
    "e9sk0py4piUmS77baDLz2/aUYj2+VrU8WDQujCDH3XHcgHEIyTRdRaI/OJTAoqwTSuMqygM1"
    "yrk3ysuad6jv6XJVXjP+uWcz/PBUSunf2jViDJuPZaDWFV2YvUlVFSsnRtCqluOhV4NKSpuI"
    "+JLtKQXqWV9Yy770vQiqlXUaL6kArANOAO8B5UvadSrpjJhC1ny5VELG0vciyqrcpXIQ8qW/"
    "/tN+XPjpK2VcKl30v1MZfLnC9jgGtxXcVVfAF8sTLRa2MJBIYGgHP74cGIxHHp6Mv5cb0YkG"
    "LkYLD0azWRj2yN0kxRqo81JJ6dXcGzc3CSeuaTE5nlwIBdoDY7P+KoEoSkAxTEkmeitgNiAB"
    "6Nfa9077+p5B2R9+v/oe52/p7J68o7sHuAzJb8TpeeOnGHRWpZIqhYRvh4WgUpR8tz0qVm8X"
    "QHwQ+HhI+XZoCH2f8UFSgNBKy5oeHL+m5U5izgPm4EU1iWlGnqqmKrYCGalUQuMqKtrX8+R8"
    "tI5Y5w84SZZV7wq8jRCp9wcMCB1fzCLRsx6gCGWB/gDucknqL2+GhmRHQJPSjXy4JN7uqTrq"
    "OX+eLO8aWWQanZnhP961s4YD2/jRpq5rTNMu/i+Fo1cKN69dq4I7894Kp84TBb9uMjcJ7et5"
    "su+82qaTzdkbWjYcyeCJEAXlg4qvkCnA242ezbypECznVoKexFRjfsPjygjB5BHAOwip25Wz"
    "LH4ioHlcif5j1skAYGyPAHWTqiqLX7ZyT5rdnK2Hu5QvBgaVuJZKjmA2w4eL4zl4UW2zPCJQ"
    "xrdDnU7plDj8sSPVYQfafq19ebW9H5fu6EhOd+zjusslDGjjyzdDgvHzuv/bUCGT0K6eJ3vP"
    "CZY8G6mZJtYdSud6rJ4GlZTF1nlWIhHyHF5+2od6FZUkpBqJTijQEEYBPJHlsfbLGtP3RpCT"
    "DkSI3t97HIjeCpiZ/cbXU5r8/bAQP+vpsv/9kWBzcQGef8qLDg1K/ryz0WTmwyXxDuuef3gt"
    "hCdCXCebb9G2FOJy9YZ76/kA3uoeQKUwBV0aeRGbbOTynZwhVrCvG0M7+vPNkGDa1vUs1DSo"
    "SiGlRzNvMrVmTt+w1de7ckfHyr1pmM1Qo5yiWB+e5YLkdG/qTZu6nmRoTFyL0duIeub3zACC"
    "EKbregCjgc6ADkG6qkjmLUua6XADjgJ1sxd8OSjY0L2plyW6dv6Wlpe+um33xeXvR/BkhZLt"
    "tmv1Zt6ZF0vuKjuAl1r68MkrZXAltJ54w8Z1rhym4K8PI+zIe/6WFjMQ4OVGsK8MaTEY2X3n"
    "1UxaHGf34AEhgDe0gx99n/F5KF1y79wzsOS/FP7am+Zo/v1+kAAMRtBcKFUWfQRW4o5ly8jS"
    "/tc/SGUdoJm3OcWubU6Ncu6Mes6/RJMiXWNi5KwY9p1X230W6i9jxushLjHssPZMfvj7nk1U"
    "6bthwZQtYz82DvKVEeQrw0slLVCw7UGt6vPNvLlzz8iVXJmSGp2ZfefVrN6fhlwmoVqEe7Eq"
    "2nirpLSs6cErz/pQq4I7nkop99JM+enGO4IH0BcwAbtLC9H9EXLZLfNKXw8OdrfON9YbzHy4"
    "OB5NLkG/kV39S7Q1T0o3Mnx6DCevO+7r9d2wEJdrzpChMbNwS4rFRe3a2ItB7fwe6T4pFVI6"
    "NPCkeQ0V12P1doHOTK2ZPWfVLN+dSpraxBOh8mJNSlLIJFQMVdC6jieD2vrSvr4nEYEyDCah"
    "eWYBq/wkCOrGdbP4YXR1ok8Bns1+UzvSXf1Oz0Ab8/DfyUzWHEjLNU6T8OWg4BJrDc/c0PL6"
    "TzF2+fjWgatXnnW9clp3uQSFTMKhS2pa1fLgf/2CHopbXBCE+st4obk31cspuBitIylXQFCr"
    "N3Psqobft6dy5a6OUL+HI9UV6O1G/UpKejzlzYA2vjSopKRckJxMjdmumaYDVEdo9Ljalcfo"
    "TyJkFVnO9pJ3wu06k4z6OYaduca3vVp4879+QSWOCCazkLn307okDEbHj+42dTyZNiIEF0vL"
    "t4HOYC7RQw6TCVbvT2Ph1mSiYp1LVdWq4E7/1r50auj50IUqQdCYn7Mpmf0X1Pmt+gHwlata"
    "9KVkVaYBtKrlYRjW0c/Gp0pINTJ5WaJdNPOTV4II9itZmXAxSQZGz45h9b40p+5ZnUh3fhoZ"
    "itzNhVkOJb54SCKBmuXd6fuMYEGz+9nlvixxKUa2nsjgr31paPVmKoUpHmrSUkSgELnP9pLy"
    "8OrbIBTTXHY1onfPekpZMO21EGlgLkXQFbvT2HvO1ppXL6vgzW4lKxNu89EM3vgpJk/rUT5I"
    "zvyxYS4pc+WqkEiEgF2Xxl50f8obmRtExRrs4j2ZWjOHLmn4Y0cq0YkGygY+3A45DSorqVdR"
    "ya6zmc6aS0iAWghZoy5DdAmwDCFHWHhc1fU09W/ta2cm5v9r73q90cWfWiUkCBefYuTzZQnM"
    "XJeELo8WP/5ebix8O8zl5JtLE3w8pDSv4cHgdn40ra7Cz1NKcrqJ5IycsbzRBBdu6Vi+O5XD"
    "lzX4eEipEKwotlkDa5QLktOpoRdHLqtJcDx2D0Woh7/uKmP0nsAq6wXL3o9wSN6OH93ktlVu"
    "s1QCu6ZUwM/z0T6rtHozi7elMHdzcr5zpl4qKXNGh1En0l1kWwlEVJyeXWcyuXxbx814PTfi"
    "9BaiKRVC7fu7LwQSESh7aPfWiJl3OXLZYYbsZqBTQbf1KM2KBPjEekGTqipzrQrudg+fdI3J"
    "huQgjLseNck3H8vg+9WJdvvmCOEBMmaNCqWy2OO8xCIyWE5kG99crryJNLWJYF/ZQ7Hm1nCX"
    "S5jyagi9vogmKd3OsnfMIvqmgmzrUQ4Se2KVAQcwvJOfw1N5+bb91FSLmo+ujPPcLS2Dvr/D"
    "O/NiC0TymuXd+eO9CJHkLggPdykhfg+f5NkI9nVjYu9AZx/PQGhkUmItup01r1nenWbVHTfc"
    "y63wCtC8xqNpzjd3UzIz/rlXYEnjZ2p78O3QEFQKicgaEQ+EtnU9USkkjgQ+Kmfx6IOSatFf"
    "IFdTxGEdnWdVZWptD9BLKaVexUczzl25N7XAJO/TyocZI0JFkosotAtfr6JTUY3xFECk8lEQ"
    "3c6aRwbLaVfPeQ127hzhBpWVj2T+9la8vkCuOsCY7gFM6lOmWAo4RJQ8XIjWsfFIOpfv6Jwm"
    "SD0ozGa4dEeXl1c+tSS67t2A2tYLXu3gl2d2WG6iRwY/mu6oBy6qC7TeyK7+vNbJT7z7HxP8"
    "viOFr6zkwAJ93Ojf2pe+rXyKJFfiv1MZ+Ylb5JtD/SjszVibYIOfLF/9ckOuWauIMo8mtHAg"
    "//REhnX0Y2RXf/Huf4wQFiCzkZxOTDUyfc092n54k8+XJVj07R4E8zYn8/bc2PxWy7cN7cNm"
    "TG2EShwLBrX1zVcUwN/L9nlUNvDhW3SzmXz7fg1q68vY5wPEO/8xQ5s6nrSo4cHi/1KYvzmZ"
    "9CwPNENjYvmuVJbvSqVOpDudGnlROUxBxVC500h+VJye41cFGfNjVzQFbSWtK2lEH2Pjb3hI"
    "zS+19M53sF3GR/bILfqZG1qSM5y7T32f8WF8r0Dxrn9M4S6XMLyjHy+28OZ/fySw9YRtP4dT"
    "UVpOWekoeLhLCQ+QoTcKraG1ejNqnclZ2muhLfrDdN0DETSyLOj3rK+kIJpeuXONIx6BRV/y"
    "n/NGAS+28OaD3mXEu10E/l5uTHsthPG9AvMMGGdqTVy5q+NGnJ7YZAPJGcYHJTlAfEki+muA"
    "yuoJaC5oHXaZXEQv6qhmfrgZr2fTsXSHn3Vv6s3HrwQ9soQKESUTg9r68tXgorkvvFVSPusf"
    "xH9fVeDz/kGOMkIvlxSiy4CR1gteaO4t8S+g+meZXJVs8SnGh3rR5v+b7FCwv209TyYPCHLp"
    "enIRxYcujbx4q5B9BlQKCbPfDOOF5t4E+7rRs7k33Zp6lVii9wLKWi/ofR8NBL1UUhv1koRU"
    "w0O7WHHJBtYetLfmdSsqmTIkWJwnF5EnhnX04+0eAU4te7CfjCrhCpROkqo6NPCibi7N+7L2"
    "Map8if6wolqjrN/UiXSnSvj95X0HertxJ6tjZ0Lqw7PoC7emoM9VdhoZLOenN0JKjHSSiJKN"
    "oR38CPWXMWlJPHqDmdqR7rSr58mztT0sWoHXYvT0mHzLznNsWs0+I05tmymqA86VBKJXBJ62"
    "XvAg3U4DfR4+0aNi9XY9uAO83Zj9Zugjr5wT4Vro2tiLp5/0QCIRxtx2JAmVUzVcwQWrOXep"
    "RGg/lRu59OW2AuklwXUfaP3GUymlU6P7b7RgLRf1MMboRpOZCb/G2URCVQoJs0aGOpQ0FiEi"
    "P/h4SB2SPBuvdvCzcfFb1fKwaRmdjRPXbPI5/irIbz8Miz4g95PtQYo86kS6sy1rbvLKHV2x"
    "7/QvG5M5Y9X9QyqFb4eGlBhFGxGlD10aedGihgdnb2qpGCp3qEKk0Zm5kNNc1ACsKQlEb5nl"
    "ulvwYkvvB9pQI6uWuEcuq9EbzMXWZud0lJZfNtr2Xv+oTxmXaWUswnWhVEh4qprKaZD3VJQG"
    "Y0755E6EJo35orhddxu3vWZ5d2qWezCL+GQFd0tkUq0z53ZfigwanZmJv8ZZn0zefM7/geIK"
    "IkQUFOsOpdP83SgavnWdAd/d5la842S341fv320vbqIrEbpE5ljzFt4PvDGZm4R6T+RY9X0X"
    "1EW+w0aTmXfnx9rkF/dv7cvrXR6/IhWTSejfvv1UJr9tT2HNgTT2nlNz6bYOjc4sMrMIMXtD"
    "EhN+jSM1Uwi5n7yu5d0FcQ7XPZZDdBP30cyhOF337oBFgEulkNC1ceG6nTasorSUiu4/r+at"
    "7kW3s9mtjK0bIHZr6sX7Lz5e+etmM6w5mMb0NfecBj0VMgn1KylpVl3FM7U97nuqVEQOlu1K"
    "Zea6JLvlZ29o2XUmk1a1coaL0Ql69p9XmxE0HfYBMSWB6DZue+dGXngWss+V9Tj93E0tqZkm"
    "fDyKxin5+s9E1h3KmaV4trYHkwc8XqmteoOZ4T/e5ciVvIdFOoOZgxfVHLyoZtqaezSvoeK1"
    "Tv40qqIUmXsf2H4qky9XJDj9/MwNrQ3R5/+bgslsUW6ecT+/VVyuuw/QwXpBUYxx6zyhtATg"
    "TGbYeCS9SHb2p3VJ/L4jxeaB8t2wkBLfhaSo8c3KxHxJ7gj7zqsZ/MMd+n97x2YeWIRznI7S"
    "Mn5BrMPU6mxYayXGpxit+w5uB1aUBKJ3BiyTzVUjFNQuAi1zd7mE2lbTWwu2JNsEzR5kTP71"
    "n4n8vCHHdapRzp2ZI0Mfq6y324kGpv6VyLJdqYXazolrGvp8c5s5m5LzvIEfd9yK1zPq55h8"
    "Yx1Pls+51xdtS85uDGIARt/vbxaX6/58UVtz63F6dkDidqKBDYczHCX554ukdCPvzIvj0KWc"
    "oF69ikpmvhFSrK10SwpMJth+OoM/d6ex73ymU8FLmUxG3bp1qVixIkajEYPBwKlTp4iKinK4"
    "vsFo5se199hxKoOvhwRTPkhMLrLG+VtaRs2K4V5a3klfEgk8/aSH5V5dsdtizWcCZ0sC0eVZ"
    "Fl34ATcJzzXxKrKNt6/vydxNOXPcczcn8VwTr/saS1+M1jHmlxgbocd2MBHy/AAAIABJREFU"
    "9Tz5ZkhwqbfkSelGlu5MZeWeVOIcBNs8PDzIzMwJSBoMBsLCwhg/fjxly+bUJV29epU1a9aw"
    "fPlybt26ZbedU1Fa+nxzm2mvhdCkqkpkOLDrTCbvzIt1JNvscJgaFiAjJcPEazNisrsAxZJL"
    "WLWgKI6E7dYItecANK2u4sUWRWfRg3xlbD6WYelckZRuolpZBRVD84/86g1mFm5J4YPFcTY9"
    "s/u39uWzAUEu39k0P/d85rp7TPw1ngMX1GRYFUb4+PjQv39/pk6dSmhoKLt377b57qVLl1iy"
    "ZAkGg4EGDRogk8kICAigWbNmDBs2jFq1anHs2DFSU21df63ezPrDGYT4y6hR7vHOKFy6M5UP"
    "FsehL2DhpdFo5ma8ge9XJ3ItxjLd+yZw6EF+vzju7B+txxAfvlyGvs8UbbLJvM3JTFtzz/I+"
    "2NeNPyeWzbPr5b7zar5ckWDTqFEigXdfCGRQW99Se4Nduq1jwZZkNh7JsItnNGrUiP79+9O9"
    "e3eUSiFi/uGHH7Jw4ULnlqZOHVatWoWHh22WoEajYdq0afz888/o9fbJHsM7+jGme8BjJ9Bh"
    "MJr5bvW9PBWKCoh9CJmm5pJC9CigQvabrV+UL/LOoTFJBtpPumnTK71uRSXTXwuxUaPRGczs"
    "PpPJqv1p7Dxt23JZIZPw1eBgOjbwLJU32NErGub/m8yuM7bH7e7uTq1atWjcuDHDhg0jPDzc"
    "5vMhQ4awefNmAFatWkVUVBRTpkwhJiZnyrZDhw4sWLAAqYM8zStXrjBixAjOnz9v91njqiom"
    "vRxoKc0s7Th3U8ukJfFcctBSrEN9T/q19mXpzlQ2Hc139ugO0By48aD7UtRErwucyH5To5w7"
    "f06MKJaT+Oq0uzaBNAA/TzdaPqnCw11KptbEjtOZpKvtw79+nm78+HoIDSqVrnlfsxl2nM5k"
    "3r/JnMyVIuzp6YlarcZkFQ6Xy+W8+OKLjB07lnLlygHQuXNnTp48ibe3NxcuXEAikZCamsoH"
    "H3zAqlU5jW+HDRvGZ5995nA/NBoNEydOZPny5fZBITcJA9r48kYXPwqiF+iK0OrNzFqfxMKt"
    "9rMP5YLkfPhyoKX8dMrKRBbnbe2TgVbA6cLsU1GP0V/DSs6599M+NC6mQIzJLCQc2NxgejOX"
    "bus4e1PLpds6h33K29Xz5OdRoaXKqpjMQq70ewvj+H1HCrFJOQPB8uXL06NHDw4fPow5ywUq"
    "V64ccrmc9PR0zpw5w/Lly6lYsSJVq1YlKCiItWvX0rhxY3r37m3xArp06ULFihXZvHkzZrOZ"
    "Y8eOERwcTN26de3JLJPRqVMnQkND2bZtm+V3s/f1xDUNaw+mE+ovK3WNJ09c0/D6TzFsP5Vp"
    "43G6yyWM6OzPlCHBNvGkmeuSiEt2GoHXAF2Bw4Xdr6Im+v+AyOw3418MJMi3eGbwygXJWfJf"
    "CsYCztf6e7kxeUAQb3YLKFWW5L9TGbw9N44/96TatNYtX748H330Ed9++y3nzp1j7969wo01"
    "cybff/89w4cPJzAwkJMnT5KSksI///xDeno6gwYNwt3dnYiICJo1a2bzWzVq1MBsNrN//34A"
    "Dh48SN++fe3G69bjeYVCYRfcA0Hz/N9jGRy/pqHOE0qXF/KISTLwzV+JfL0i0SbQC9C6jgcz"
    "3wilbT1PZFYB301H0/ltu9PcBSPQB6EPeqFRlCxUAE9lvwn1lz1wpVpB4KWU0qauZ4Gy4zo2"
    "9GTSy2UoqBilK+DIFQ0//H3PzkUvX748Y8aM4aWXXkIuF+awa9asmRV8lFhIKZfLGTp0KM89"
    "9xxDhgzhxIkT/PLLL8TExDBr1iwkTqJmY8eOZd++fezfv5+0tDSmTJnClClTnAwlzFSpUgWV"
    "SoVa7bgIaf95NT0nRzO4nS9DO/i5XA5DUrqRuZuSWbYr1c6DLB8kZ8JLgTZprNm4fEfHV3/m"
    "WWE6kvsoWnmYY/SWgOXR3aeVD5P6FK/W+YGLaoZNv+vwM6kUWtf2pF9rn1I1j3sxWse0NffY"
    "fdZ22CKRSHjyyScZM2YMnTp1QibLeYZnZGTQsGFDUlNTkUqlfPDBB4wcOdJmTD127FjWrl0L"
    "wBtvvMFHH33k3HrFxNC2bVuSkpJQqVScPXvWErUHMJlMrF+/nunTp3Pu3LkCH5uvp5SBbXzp"
    "19q3xBM+Q2Ni0bYUFm1LsesNqFRIGNHJn8HtHHchOntDy2sz75KS4dQd/QT4rCj3tyhN3ACg"
    "TfabMd0DKFfMWVFly8hJzTRx2koJxt/LjX7P+vL14GB6P+3zSJo9FAeiE/R8sTyRL1YkcMOq"
    "jFYul/PSSy9x5swZ4uLi+Oeff1i3bh0VK1YkMlIYRSkUCtq1a8fmzZtJS0tj165d3Lhxg7Zt"
    "2+Lm5mYZU+/atYu7d+9y5MgRqlSpQrVq1Rx7U15elC9fnnXr1lnm1itVqoTRaGT16tWMHDmS"
    "RYsWER8ff1/HqNWbOXRJw597UjEYzVQv545CVrLm4zQ6M7/vSGXcvDh2n820Ew7t2MCTn94I"
    "5ZnaHg5rJY5d1TBiRgxpaock1wJvAD8U9X4X5Vn8F2gPQruZvVMrFJsCjCP3yU0qwVMpKXWF"
    "KImpRmZvTOLPPWl2jSuefvppvvjiC27dukW/fv3shywdO/Lpp59SoYIw23n79m1eeeUVLl8W"
    "1IEbNmzI/PnzCQ4OFh4m0dG0a9eO1NRU6tWrx4YNG/Lct86dOxMVFcX69es5ePAgM2bMcJoa"
    "+yAoSRY+Kd3IHztSWboz1WFrrmplFbzXK5Cm1Zx7j/vPqxn9i9Mc92gEWfRDxbH/RcUKGcI0"
    "gGf2mPi7oSGIeHCka0ws3JLC4m3JdimTERERfPrpp3Tt2hWA33//nfHjxzsOnCgUjB07lrFj"
    "hSa2ycnJDBw4kCNHjgBQtWpV1qxZg6+vkDS0YcMGhg0bJgSLNm2iTp06Tvdx+/bt7N27lzVr"
    "1nD79m2H6wT5ulE+SG7zSs4wcvK6llNRGm7E6W2i047g4yGlSyMvuj/lTZ3Ih5thdzvRwK9b"
    "k1m1L81hy6QKwXJGPedP54Z5p2GvPZjGp78nOJwJQpCE6g3EFddxFFUwrlE2yUEYG4t4MOgM"
    "ZpbuTGXupmQ7y6FQKBg5ciSjR49GpcqxHNYka9OmDffu3ePECSGdQafTMWXKFLRaLe+//z5+"
    "fn6sWLGCESNGsGXLFi5dusSQIUNYtmwZCoWCLl26UL16dS5cuMCZM2ccEl2tVrNkyRJ+/vln"
    "YmPtW/q2rOlBhwaePFPLw2m24suthL+pmSZORWk4dV0QWrAW5MxGaqaJZbtSWbYrlQrBcro1"
    "8aJbU28iAotnRidTa2L3WTWbj6az9WSGw0q8ED8Zb3T1p2czrzy9yKg4PZOXJlgEUxzgB+A9"
    "hKo0SjrRn7EKgplb1fIQOxs8AHadyWTysgSLfr016tevz8yZM3niiSfsPrtz547l/0mTJlG9"
    "enXWrl3LhAkTSE4WCoCmT5+Op6cnb775Jkqlkrlz59KzZ0+OHz/OgQMHGDNmDD///DMSiYQy"
    "ZcpYxv82AaiMDBYtWsTs2bNJSHAsmDC4nS/vvlBwVR4fDykta3rQsqYHI7v6c/mOjtX70vjn"
    "ULrNdGE2bsTpmbkuiZ/WJ9GgkpI2dT2pHSloESoVD37bJaQa2X4qg+2nMjlwQe3M8uLv5caw"
    "jn70aeWTZwGUVm9m7uZk5v+bbDeOzz6dwHBg6cO4t4qKkOsQJvZpUElpWPxOuEyk7f2Nw7/6"
    "M9FhKqR1NVn58uX59NNP6dSpk80633zzjYXIFy9etKSmxsTEMHr0aMscOsAXX3zBkCFDLA+I"
    "jh07kpgoTPN07dqVDh06MG7cOIxGI4sWLaJ9+/akpaWxYMEC5syZQ1JSUp7HEhEoY/WksoXO"
    "VTAYzew4ncnq/WnsPpuZb327VAqVQhXUquBOrQruVApToFJIUCokKBVSlHLhf7XOzM14PTfi"
    "9NyME/5Gxem5fEeX5xDCSyllUDtfBrbxzVcpae85NZOXJzgVeASWAeOzxuW4EtFvA+Eg9Joa"
    "+3yAyN4CYvW+NKauSrQIA2ZDpVLx1ltvsXnzZo4fP27zWdu2bZk8ebIlyGY0GunXrx8Gg4GV"
    "K1farGsymRg2bBibNm0SXDiZjDVr1lC/fn0ADh06xMCBA+0qz6pXr87KlStZuHAhc+fOtfs8"
    "L7Su48G3Q4uuZVV8ipH1h9P551AaFx+ygk3dikpebO5Nx4ae+T68bsXrmbbmHpuPZThb5TRC"
    "wdfOh32fFcWVKINVf+bvh4fQob44Rs8PN+L0fPpHAocv2Y/dunXrxieffEJ4eDiNGjWycc2z"
    "4e7uzptvvsno0aNRKBSkpKRw8eJFmjRp4nBM3aNHD06fFtKlK1asyNatWy1z35cuXWLAgAGW"
    "uvLAwEDatGnDpk2bSEtLe6Dja1hZydRXg2067BQFLt/RsfZgOusPpxOXXDzD2oqhclrV8qBn"
    "M+98U6X1BjP/nczkzz2pHLykduYVJAMfAT8jZLzhikRvi9D/CYBNn5UTWxbl45Iu3JLC7I1J"
    "dlHcqlWrMnnyZFq2bGmxxpGRkRgMwg0tkUhs8sazg2+//vqrTYKMI8TGxtK5c2dLFdpXX33F"
    "oEGDLJ+np6dz6NAhlixZwu7du23EJ3KjQSUlzz/lza/bkrke49Q9RSGT8FJLH4Z29CPYt2iz"
    "Ek1mOHRJzaYj6Ry+rLHJLbgfSKVQNlBOg0pKnqquomk1FUEF2NcbcXpW7k3j7/1pDmMJ2bsJ"
    "LAAmAgmP8r4rCqKPA74D8FZJTfu/ixQbCTvz26K0fPxbPJdztZSSy+W8/fbbvPnmmzaEjYuL"
    "o169eoCQxrpixQpmz57NnDlz0OlyttGrVy9+/PFHp2mrlt8/fZpu3bqh0+moUqUKO3futDwE"
    "Zs2axZIlS9BoNE7HqN2aetH7aR+LvHNqpokJv8bZlcLaeR/yLMJ38CsQiR4E99KMHL+q4W6S"
    "gaR0E0npRvQGM1IpuEklSCUCqRUyCWH+MsoFyakQLCciUGaTf57fb+y/oGbl3jSHnpgV0oCF"
    "CNoMV0vCvVcUflW97H9qlncXSe4AmVoT09cmsXRHip02W9WqVfn444+pWbMmGRkZlvns7GBa"
    "Npo0aUJAQAAffPAB3bt357XXXrMkp/z111+UKVOGTz7JW2Wodu3afPTRR3z00Ue0adOG1NRU"
    "vvvuOxYvXoxWq3VK0oFtfRnWwc8uCOXjIWXWyFAOXVIz7e97nIpyvA2t3sxv21P4Y2cKtSOV"
    "tKihokUNFbUjlUXWXz7A24229YpuyKgzmDl/U8upqKzXdY2N9JgTXEeQYZ4PpJake7AoLPpJ"
    "oA7AkPZ+vNNTDMRZY9eZTD5flsDdXFNmUqmUli1bcvXqVcs8uFQqpUuXLowaNYq6deui1+t5"
    "4YUXOHr0KN9//z19+vTJMRlpaYwZM8YiEgHw+eefM3To0Dz3x2w2s2jRIiQSCVOnTuXevXtO"
    "1+3U0ItxPQMIDyiYPTh7Q8v6w+lsOpruUI8uN7xVUp6qrqJRZSUVQxVUDJMT4vfwJ2zikg1c"
    "i9UTFavn6l0dp6O0XIjW2WUi5oHdwDSEhofGkngfFpboCoTezHKAqa8G07mRl8hu8p4yq1Ch"
    "Ag0bNrQRcrAjWadOfP/992g0Gjp27MjSpUstVWgWq6PT8cILL3Ds2DFLgG7r1q1UqlTJ6Xb3"
    "7dvHRx995FABxmL5I915/8VA6lV8MGEOkxmOXlaz4UgG/x5Pz6t4ww4e7lKeCJXzRIicyGA5"
    "fl5ueCmleCqleCkleKqkeCmllmUFiewbTWbUOjN37xm4FqPneoyOqDg912IEcmcJL94vziH0"
    "PvuTQopCuALRbRRl1n1ajshgMRC37lA6X65IsJsyA+jfvz+ffPIJXbp0seScDxw4kLZt23Lr"
    "1i1mzJhhyTaLiIjgl19+ITIyEj8/P4fSTbGxsXTq1MnynaZNm7J6tX11461bt/jss89Yv369"
    "0/0O8ZPxdo8Aujb2KjJtN4PRzN5zajYfy+DQJTUxSUUbKZe5SbJIL8HDXYreaEarN6PRZf3V"
    "m4pSY/4YsCqL4Bdc6Z4s7OXsDywB8FRKOfBd5GMn/pfbkn23KpFF2+ylgUJCQvjuu+9o00Yo"
    "8OvQoQNnzpyhRo0abNu2zbKeRqNh5syZ/PDDD5jNZuRyOVOmTOHll192+rtHjx7lhRdesIgy"
    "/vPPPzRs2FCID2RmMmPGDGbPnu10HK5USHi1vR+vtvcrVHZZQXA70cCRy2qOXNFw5LImr6SS"
    "koBUYD+wJYvg11313ixsCLQHWdJRdSPd6dnc+7ElebrGxNg5saw9aO+qd+/end9++40aNWpY"
    "lt28eZPDhw+TkJBAdHQ0bdq0sZSMNm/enNq1a7N161Y0Gg1btmyhcuXKTstGw8PDKVOmDFu3"
    "WmY56dixI3v27KFPnz5s2bIFo9Hx0LFNHU9mvxlK6zqeBY4+FwY+HlKql3WnTR1P+rf25cUW"
    "3jxZwR1/Lzc0ejMpGUYeQa9WE3ALOJpF6sXAhwgzSkuyyJ7syvdnYa/sfOBVgIFtfHnvMes8"
    "anGLs1rsXMs1p+zj48OUKVPo3t2+7evt27fp06cPV68Ksy/169dn3rx5hIWFWdY5f/48zz//"
    "POnp6cjlcpYsWUKrVq2c7sfAgQPZuXMnv/76K9u2bWPhwoV28+7Z8Pdy48OXA+nUsGTFVLR6"
    "M1djdFy5o+PKHT1X7gr/300y5FvlVpC4G3Ap63XR6v+rCLXgpRaFJfo2ssQmvh4cXKQdWVwF"
    "By+qGTcv1i7gVLVqVbp3786hQ4fQ6/WYzWa6du1K79698fYWPJ/k5GSGDBnCwYMHAShTpgxz"
    "5szhqaeeyhnvr1vHa68J/TAiIyPZu3ev0/nyuLg4li5dyp9//sm1a9ec7nOXRl5M7B3oUtJa"
    "GRoTV2P0XLmj41qMjpQME+kaE2lZwiO5VV5y4Rdggqtb5UdJ9CtAJYA1H5V9bPS6s7F8Vypf"
    "rki0a4zQtm1brl27xvXr9kM6Ly8vBgwYwPjx41Eqleh0OsaOHcvff/8tBJdkMqZOnWozJv/0"
    "00+ZM2cOINSet27d2m67er2eb7/9llmzZjl104N93fj4lSCere1Rqq6DVm9m6PS7nLjmtBOs"
    "BmgMnHlciV6YR7oUmAK4ucslxvdeLCN9XAJxRpOZL5cnMmt9ko07KZVKef/99wkICLAUkcjl"
    "clq3bk25cuW4efMmOp2OI0eOsGHDBho3bkxYWBhdunTBYDBw8OBBTCYTW7ZsoUaNGlSpUgWA"
    "li1bsmXLFuLi4jCZTBbBiWycO3eOfv36sX79eqeu+gvNvZn5RihVI0rfw1jmJmHbyYy80mBl"
    "wLPA3whZa48dCpOXFIowj054gMzwuLQSz256l7vFsI+PD4sWLWLMmDHcvZsjWLls2TKWLFnC"
    "smXL2L59u2W8fvnyZbp27crcuXORSCRMmDCBL774QogMmUyMHDmSAwcOWKz8s88+K7iwGTmV"
    "UUajkR9//JHOnTs7nRePCJQxd0wYn/UPwktVOhMXY5IMeebcZ6EmcAQYk3XvikQvICKz/wkP"
    "lD0W9efXY/T0nXKbg7nUQqpWrcrGjRtp27YtgCU/XSKRcPPmTZv1Zs+ezfTp01GpVOj1ej75"
    "5BN++uknQGiHlF0rrtVqGTx4sKXiLDpaKF1WKASLnJKSQv/+/fn6668d9jqTSqDfs778/VE5"
    "mlUvnd1MoxP0/L49hV5fRptvFmyaLgyYDtxFSHj5BWGKuII4RneOvsAfAL1aePO/fkGl+kTt"
    "OZfJu/Pj7Fo8de7cmenTp+PllROIjI2NpUmTJhYC9u/fn88//xx39xy9s/Pnz9OvXz9LPvvk"
    "yZN59dVX0ev1vPzyyxZrrlAoaNGiBTt37sRkMjFx4kQ6derEoEGDnAoxRgTK+HpwMPVLWcsp"
    "QSVWzZ5zavaczXzgijUnuAXsQkhn3Q2ch0cx01fyiP4e8A3AyK7+jOzqX2pJvvi/FL5dlWiT"
    "YSWRSOjVqxfly5enX79+NtNiAAcOHGDYsGGWXPInn3ySOXPm2EhBnTp1ih49eqDRaJBIJOzc"
    "uZPKlSuTlJTE888/z5UrV2zNUVgYn332GW+//Tbp6Y4bVzxT24OvBgXj41E63HSjycyOU5n8"
    "tS+NgxfVDgUai8thyBrTr8p6ABhd+TwWJhjXFXgaoGsTb2qWL339r01m+GJ5Ar9sTLYJuvn4"
    "+DBnzhwuXbrE/PnzmT9/PqdPnyY8PJyICKGpZNmyZenWrRt79+4lISGB+Ph4VqxYQWRkpCXx"
    "JSQkhAoVKljSUrPz2lUqFd26dSMxMZGkpCQ0Gg3Nmzfnqaee4vPPP7cpUbVcSKmgpT/p5TLF"
    "nt32MHA70cDCrclM/DWeVfvSuBGnL3D7rSKCD9AEGASMAmogJNbcpJiFHEuaRf8JoW0Ms0aG"
    "Omw748owGM18sCieDblaPlWpUoWFCxdSsWJFunfvbpFNzkbLli15//33LSmoGRkZjB492hKF"
    "l0gkfPvtt/Tt29fyncmTJzNr1iwUCgXHjx/H39/WO8rMzGTcuHGWTiq5EejjxrevBhdbQ8uH"
    "iZPXNPy8IZm95zOLIkGmOJABbMyy9OspYeWoxUH0JVmBDP76oCzVypaeaRuNzszbc2Pt2h41"
    "aNCApUuXWhJe6tWrR1ycvRS3RCJhxIgRTJw4EblcjtlsZurUqUybNk0IlEmlzJgxg549e1rG"
    "9Nkabv/99x/Vq1fP8R+joxkyZAhnz551uK8NKyv5dmhIsQk6PCycuaFl5j9J7DmX+aCbSELI"
    "Rb9p9bqBIHOmz7LC1i8FEOjgVQlBY6FcAX5TB6xFkIjaXpLH9IWJllsUEvy8Ss+0TZraxMhZ"
    "MRy/apt8UaNGDX7//XcLydVqtUOSg1DzPXv2bHbt2sXvv/9OSEgI7733HiqViq+++gqTycRb"
    "b71laUesUqlwc3PDaDTaRNAPHDjA8OHDLSqtuTGkvR9jn/d36e40l+/omL7mHjtO3zfBoxFE"
    "Fndl/b1YxLsWgFCdWc/qVYOskuwsKIAXs16XgNnAr1kPnVJj0XeQpee+e0qFUtGpNDHVyGsz"
    "79opjVaoUIE1a9ZYWhcBXLx40ZKhJpFIeO+999i8ebOlcUI2qlWrxqpVqyzu+Lhx41i2bBkg"
    "JNOMGjWK6OhoVq5ciVQqZf/+/ZQrV45NmzYxYsQIh1Nn3io3Jg8sQ9u6rivCaTLDr1uT+XFt"
    "0v0IPFxGUHBZD1x7BLutQJiPr2f1EGgKWI+Z1MDyLNIfLA1EP551oBz6IdLle47fTjQw7Me7"
    "dmWTcrmctWvXUrduXZvl//77L4MHDwYEPbfsyrHVq1czceJEG3nkunXr8ueff+Ll5YVer7cU"
    "n+RG9+7dmT17NuvXr2fkyJEOSV69nJIfhgUVewPL4kRssoGJv8ZzKG/dNWvsRtAl/CcrIFaS"
    "oELIuusCdM5y/a05MgVBx/2RojDs9Mn+p6j0ux8VrtzVMeDb2w5ro4cNG2ZHchCmurI7mTRr"
    "1syyvGfPnmzZssUSjAM4efIkgwYNQqPRIJfLWbBgAe3bt7fZXqVKlZgwYQJr167ljTfecEjy"
    "7k958/u7YS5N8n+PZ9BzcnRBSG7MsoxNgFYIMk2mEnhI6qzg3GigMlANGIvQdLQmQieWHUAt"
    "V7XoCUCgVAqnZlZ02Rvv5HUtI2fl2auaGjVq0L59e9q1a0eDBg0sSi9//PEH7777LvPmzaNL"
    "ly423zEYDIwaNYp//vnHsuyll15i+vTpNg+A6OhodDodXbt2Zd26dbz11lsOi1KGd/Ljre6u"
    "q8eXqTXx1YpEVu/PN9U8DZiHkMF2w8VHgx4I1Z2dEWTRhyDUtrsU0TMBlUoh4fC0J1zyKhy5"
    "rOGNn+7adSvNM0ITEEC7du0YPXo0lSpVYsGCBbzwwgv4+fnZravRaOjRowenTp2yLJs7d65d"
    "UQrAihUrGDduHKZcukdSiYSJvQPp+4yPy97tp6K0vL8wLj81mcwsN/cHXGTK6gEQhFWzE1ch"
    "ehrg5ecpZc/USJc861+tSOT3HSkP9F25XM6gQYN45513bCSacyMmJobOnTtbNN0CAwM5dOiQ"
    "TTfUpUuXMn78eDuSK+RSvh4c5LKdb0wmmLMpiZ83JNuV8ubCcoReZLcQUeLG6IbCPyseLdId"
    "iBVERkbSvHlzWrZsydNPP02NGjXsuoqCUP89b948mjVrxoIFCyzdVHIjNDSUhQsXWtofJSYm"
    "2qi/LlmyhHfffdeO5N4qGb+Mct32VkaTmXfnxzJzXVJeJD+BMHPTRyR5CR+ju8slHJ3umq77"
    "23Nj2XJcKPusXr063bt3dyiVbDAYuHr1KsePH2fPnj0OA2VVqlRh3rx5lhry3Fi2bBnjxo0D"
    "hDZKv/32GwsXLmTSpEl2NeRBvnJ+eTPEZWvHjSYz4+fH8e/xjLzunUnAXEpmgK3UoTCT3+MA"
    "L6MJXu/s75Lqr1tOZHD1rkDaLl26OIyug5DJVqZMGWrVqkXz5s0xGAxER0fbWOF79+6xevVq"
    "mjZtasl3t0atWrU4d+4ciYmJzJgxg7Vr1zJp0iR7jyJEwcKxYTwRIi+NJDcBM4FewB5KUXXY"
    "Y+C6Q6bONR/K7rKcw3cmv5Qbfn5+9O3bl48//tiuYi0lJYXevXtbGirkxtSpU1m5ciUXLlzg"
    "448/tvu8TqQ7S94JIyJQVhpJngB0RBB+SBKp5zpEtzBDrXXNB7NCZh04ur+HVUhICBMmTKB2"
    "7do2y7VardO01YCAABISEnj77bft3PVWtTxYMDbcZTMM8yH5QaABVl13RbiiRde6qEWXS20I"
    "er9QKpWMGjWK5s2b2yy/e/cuEyZMsFv/zJkzDB061G6M//xT3sx4PcRly0vzIfnPCAkvYrDN"
    "1Yl+P/PQJQlyK4t++PDhB9qGRCLhlVdeITw83Gb5xo0bbRRgbt18xonzAAAPb0lEQVS6Rf/+"
    "/e0EI4Z28OOLgUEuW5iSB8kzgYEIpcw6kWquS3TLBHRSmmuKb1hb9Fu3bjmUZy7QA0MuZ/jw"
    "4TbTcCaTiSVLlgjnJymJvn372lW7DW7ny9s9XDfbzWyG9xfGOyL5FaAZWe26RLg20e9YSJKg"
    "d8mDr56rht66B9r9Ijw83M6Fv3r1Kmq1moEDB9o1VOjZzJt3erp2Z5tF21IcdYs9iVDRdUqk"
    "V6kjusElD75VLQ9UVuPiw4cPs3HjxgfeXu62xvHx8bz++uscPXrUZnnbep78r1+QSzekPBWl"
    "Zdoau97qZ4B2wD2RWiULsiIherxrWnR3uYRWtTzYfCzH9fz777/x9PTMs8eZM1SrVg2pVGqJ"
    "4B8/ftxunabVVEx9NRipC1f1pmaaeHdebO468vMIhRsJIq1Kl0W/6+quO8Cgdn52XUR///13"
    "FixYQErK/eXBu7u7O0yXzUatCu7MeD0Ehcy1y3onLY7nzj0bL+4SQpVWnEipkonCTNqGAv1A"
    "mEcf3snPJU9AiJ8MpULKvvO29dG3b99m9+7dSKVSQkNDLY0T8sLNmzfZsWOHw8+eCJWzYGwY"
    "3irXVuJZ8l8Kv223eQBeRWidfVekU+kkuifwOoDeaKZPKx9ULqoyU6+ikvO3tETF2nomBoOB"
    "8+fPs23bNqKiopBIJCiVSjw8HCveHjlyhHPnzjkcIswdE0ZEoNylb5YzN7SMXxCHVY1KVBbJ"
    "o0UqlWwUxocMsnbV5o4Oo1kN15UbztCYGL8gjl1n8hcp9PDwIDw8HIVCgdlstrxiY2NJTrbv"
    "zDvhpUD6t/Z16RslTW3ixS+juZ1ocdk1COovp0UalW6LrkaoIZYDlAuSu7SuuEImoXMjLzR6"
    "c17tdwGhRPXevXvEx8eTkJBAQkICiYmJaDT236tfScknfV07wg7w/sI4Tl63yR4cC6wTKeQa"
    "KIyvbcZqrjS3PLJLngwJvNMzgK8HB+PrWTTDkD6tfFye5GsOpLH1hE1SzFqEBh4iHgOig6By"
    "CQjaa6ZSUln8XBMvNn9WnhGd/Qulbls+SE67ep4ufS7UOjPTbefLbwOvitR5fFx3gHCgGwgB"
    "uTZ1PQjyLR0dlBVyCU2rqejVwhs3NwnxqUZSMwv2JFMqJIzsGsDXQ4JdXiF3zsZkdubELUxA"
    "D4Q5cxEuhMLehY2BQ9lvPuhdhlee9Sm1J+vyHR3/ncxg/wU18SlGEtOMpKtNSCQQHiCjell3"
    "qpVV0KuFNyF+rv/Ai0020PXTW2hyipa+QFCGEfGYEV2JIBIpA+jU0ItvhwYX+U5GxeoJ9nMr"
    "kU0idAYzRhM2qbSlBRN+jWPdIUsu+0GgJS7YSVRE4VJgQZhiuUCWOP3ec5noDWbkRZT5la4x"
    "8V7WlFeVcAVL3gnHS1WyyO7qWW7OcOaGlvWHbQpWxookd10UBWssAbk0tYn9F9RFsmNmM0xY"
    "mDOvffmOzq6FsYjiw5SVidZti1cBB8Sz8ngT/ZD1m01HM4pkx/7al2bXYfO/k5niFXsI+Pd4"
    "BsdypksNwAfiWRGJ/o8NGU9loDcUTnHGbIbF2+wzzG7G68Ur9hBiDt+tstG7W0DRtyQW4YJE"
    "v4EgNiCMq9UmuwKR+8X+C2quxdiTOtFFlWxcCX/sSLVOc80EPhXPikj0bKy1cd+PFW4sveQ/"
    "x+WhGRqT9VSPiCKG0WTOfe6nIValiUS3whrrN9tPZpKmfrA0uahYPXvOOR+Lx6WIgd/iwtYT"
    "mcQmW85vIvCNeFZEolvjKEJqpOC+a0z8svHBNPp/256COQ+jHZcsuu/Fhd9t68ynU3q7mopE"
    "Lyr3PddYr0DQ6Mz8cyhvt1+06MWD87e01pF2E7BQPCsi0fN133UGMz/8fX8agVuOZ5Chydvl"
    "Fy168eCPHTbGezOimIRIdGc8JZcIwaaj6ZyKKngHlNX70/Jd59xNrXjVihhJ6cbcyUjzxbMi"
    "Et0ZTMD7uRdO/SuxQF++nWjg8OX8p+X2nVdjEgPvRYqVe9LQ6i0nNT73MEyESPTc2Ahst15w"
    "/KrG0oM8T7//QJp1EE4HDADqAB9h1V43OcPImRuiVS8qGE1mlu2ycduXAGJmkkj0fPEeufpe"
    "//D3vdwa4DYwmwWiW+Ft4LesocBkBMkqC/acFVNhiwq5ptREt10keoFxBFhmveBmvD631bDB"
    "4ctq6wh9KrA41yrfAT9kv1l3KL3UqNk8auS6LgeAc+JZEYleUIzBqpMLwM8bkohLcRwxzxWE"
    "WwWkO/EUzmY/ONYdThOvXiGRlG7kqG1cRJxSE4l+X0gA+iME6ABIyTAxYWGcXSAtPsWYewx/"
    "2ck2DcDo7De/bEwWrXohseNUZu7rsUE8KyLR7xfbga+sFxy6pGb2hiSbsfmHi+Ny56/fymeb"
    "ywFuxIlWvbDYdtLmAXsece681KK4+wPtQuiuWS5nPK7haowOHw83Zm9Mzi0jDPAjQgcQZzgA"
    "jAAUR65oTN2beks8lVLxSt4n1Dozny1NwJjjFS0FNolnpnTiYegglUcI0AUVcP3KCP288sLr"
    "wM8ALWqqmD0qzOW10x82tp7IYOycWOtF3cmlLSBCdN3vBzeBXhRsbtZcQPdxNvAXwN5zav7Y"
    "mSJeycK57Xpgh3hWRKIXFruBkQVYLxkoaDbMMATRC6asTDQ7GAKIcAKjycxOW5mugwhqviJE"
    "ohca84AZ+azjfR/DiWTgFcBgNCF5Z16seaMoHlkgHLmsyd2MYot4VkSiFyXeBrbm8bkMCLiP"
    "7e0DBgImownJewvjzLky7EQ4gAORTZHoItGL1msEegNX8lin/H1ucykwHDCbzUgmLY5nxW5R"
    "LyEv7DhtM8xJIZeSrwiR6EWBJIQIrzM2tn2AbS5AyMbDDHy2NCG3WoqILCSmGnMLghzOegCL"
    "EIle5DgP9MUqc84KnR5wmzOxKpP96s9E5m5OFgtac8FB5d9Z8ayUfrj9v70zjY2qiuL4b7pQ"
    "ulAslKhoDEKwGkVBXMEFjUBQorgTE7cElw+4RcXEjaiQYDRuCUaiFjGSqCiIiguriVhoSgVl"
    "0QLaUlroQqFlBqbTWZ4f7lDfvJnWtra0vPn/kvly38ubl3vnP/ece+49pxe/exfgByY62k/H"
    "bJrpylnUXzCLeRMAisv8ni1/NwcvPycrtS/WbesNvi3xsWlXs9Ma+lU9I6H3JEVABnCl451+"
    "peunqH4CcoBxAHsPhFK//MUbGnZyesrwU/ol/YB/uLKRvfUxpvs82t92LCT0bmENZrX9Kltb"
    "M/DV/3jmKmAwcClAS8hK+aH0CNUNIS4tyHRtYcSOMG9Jgz2bDMBT0f4W8tF7nBeAF23memY3"
    "PPNRTDivdaFp+UYvN8+pYtPu5Pxd760P0nQkbllE8cgkoK9NbTnAZEy4p7vMycmYE28DW//d"
    "PHDvdScxc2oeGenJM7t/t8nHrMI6e1Okj1h1Iklm9GP4MHvYu9Nn/DFqwu9s/XVbsHBVIzfP"
    "qWJjmT9pBntbfEbeFklAQncTZVGxx+wAq6wPMuPt/Ty7qJ5DPveHkrfukdAldPfTCEzBhO5i"
    "+LrYy40vV/F1sbvd1d374nStbK/y0V3NDGA+EBdvu6wgkxfvyueMIel96oX9LRYHvWH8LRH8"
    "AYuMdA9nnda5cOEFM8sJx+aOagDyJQMJ3c2MxSzSjXBeyEj38PCUPO6fOJC01N7tosNHIyxc"
    "3cjidYc5GohdMR86KI1JF2Yz9ZIBnH16+6IPhizGPFrubA4B6ZKBhO52coH3MQdt4hg5tB+z"
    "78pn9PD+vfJy2/cEeGRBLXWN7ReW9HjgtvG5PDFtELlZib0xrz/C5U9WJLqUA+gwv8tJ9tBK"
    "APgCqMHktkuzXzzoDbNsg5cGb5ixI/rT7ziG4laU+HjkvVrnufE22VEZYGmRlyG5aRQkmN0r"
    "64N8lji3/nwUS5fQk4RSTL60axP5rNv3BFhe7GXo4HRGnNrz22i/L/VZswrrPOFYjQcxmXpK"
    "o771IMz24VaaWyzW/HaEkl3NXDCsP3k5/w7vN8U+iv5IGEosxNRbEzLdk4ZsTNLJu9u6YcKo"
    "LJ6fns8peWk98gLFZf7DD7yzPzNixfjOpcANgD2bYxomZDgRuAkYbX9OepqHW8cN4JbxA0jx"
    "eHi6sJbymoSL7OOADRp6CT0ZuQ94lza24mZlpDD3niFMHJPdrV+6ozKwa/qr1SdHLHJtzSsx"
    "yTX/K0/WlcDjUdF3xlKbgtI8y3RPUrZETfnrMIdjYm3osMXKzUfweODikZnd8oU1h0IHp82p"
    "To1YMa7DJ8CddOzQSSXwObAcuJqOp9deAWzTkEvoyUotsAgoAM5JdEPJTlOMYsKo7P8VhvM1"
    "R4JTZu+tDQQtexqttzD568NdeO/CqNDHduD+1VHXQEjoSUsgOkt6MSmu4mJXf+0Psn6Hn6vP"
    "y6IrFWMiFtw6t6qivilsj+d/CjyIo/x0JwgB32LKTk+i/dOA6zEJO4SLUdqVjvEGcA2OCrE2"
    "35o7X61ma0Xnk+J8srYpUFEXtIu8KLpG0B1psJYC5wOb27lnoIZXQhexM98YTKHHOOqbwtz3"
    "5j46k1u+uiHEm8sP2sfgb8xiWqAb37sKuD7qw0voErroAHWYcNb8hHZ+0OKZj+roaNWY2Yvr"
    "rWDIOhZGOxQV5IEeeO8aYCqJN8Zka1gldBFPGJgJPJfQ547ArMI6Sna2f859WZGXjX/67St4"
    "L2GO0/YUWzFbfZ2Le5kaUvejxbiu83PUHL7B+YcZjsCaLUe54tws8nNTE5r5M9+roSXU6oYf"
    "wGzS6eljo7ujs/pkW1s5pgiG0Iwu2mAhMA2Iq3Hka47w2IKauBNnAHM+PYDXH9P+TqJn9BBv"
    "Y4o2aEaX0EUnWIHZI9/gvFDdEGLektjm38oDzpLFXkzxieNFBHjIZsJnaQgldNExioHxQIXz"
    "wtIiLz/ZShR/vLbRecsHmIW448lm25+LZnQhOslQTM12y/4ZnJtqbXxjmLV67hlWSkrsNcw2"
    "294gC7P1tUzDphlddI59iXz2hsNhFq9rYsOffiKxLnuI3js5dhSzj363hk2IrnG7c1YfmJ1i"
    "XX9RjnM2L1ZXCXFi84pT7P3SPE6hv6ZuEuLExgMsc4rd8blD3STEiU8O8Hs7Qr9KXSSEOzgT"
    "s/MtkdAL1D1CuIepbQg9T10jhLv4ziFylUMSwoUUYIoaHhN6QF0ihDt53SZ0VTIVwqXkYcof"
    "yXQXwuUsiAo9pK4Qwr2Migo9oq4Qwt2sk9CFcD8XY2qzCyGEEEIIIYQQQgghhBBCCCGE6Fv8"
    "A8lYDgXl/ToGAAAAAElFTkSuQmCC")
geticonData = icon.GetData
geticonImage = icon.GetImage
geticonBitmap = icon.GetBitmap


cycle = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9oKHQIfIGIC+DIAAAln"
    "SURBVFjD3ZhZbFzVGcf/3zl39hmPx7uzeI+tENLsEETasIilpBRRqQ9pQ5Haqg9QIfHQqqjw"
    "Uom2b6hC4qGqFAVUpS1FpSFQVKAQQAQSyGaSYMdxvGfGMx6PZ7l37nLO14cZx4ntLKL0oT3S"
    "lebMPefc3/l/3/2+71zg/7W13v/qV7IO3ejAHa8zPtxFC/Ma7w0LYcSZuSYUDofMkVeO/9eB"
    "Ih3fRmnkQLXXRaH29bXhSE1vKBLZEY6Et4XC0Zsi8Xj7+aGJmtTR5wgAuh49h+F9a25c2W88"
    "h4vvP3mpb1xt4G6Xsd9X5U3cUVPXvGJHa0fnI60tTdtXrGjuqK2NIRwOoCYaxt7ce0gBMQCF"
    "4X1rEF//+K85WGMTuLplAoEubV8KhjbzgJ1/6eL7Tw5f/tyrAlVgghRpv7ezqaX1sd71X9tz"
    "89rOptraKBlSgJlYM5MQ1YcBojrVV9+64qld92yB7Sh4mqGZoZWC4sqAsfE0Pnv3tT+aIwcK"
    "i597VSCjYZtR19y9ZcXq9qfWb970UF/3ShiGYK0ZmgFmJs3V3+IKy4elz49INAxpu/AUQ1eh"
    "lNKYSmbR/+HBN8yRA7+BMErQ3o0AhUSisXNLd9/aZzdv3Xh3+6pG9jSTViAmAjODAQgSMKSE"
    "ILmsazIIqJqNGfA0Izk5kSY7tV8YoRHtWeYNKRRt29nVsrrjl5u2bry7pTkBx9U07wvMDEGC"
    "54plmkrNYa5oo5BfpDxJVK0DBoErWBBCYFVnV6OZ2/n9SG3b0YlTfxm4PlD81kSisfWn6zZt"
    "fHBlSx17igmkASYQwJbt0tCFpD4/+MVkbmpwoJS7OGaWCsNXvLFE0BAVhYjArKu3CQ11cS72"
    "brz/Qin/REvfA88kB97IXh2I6mW8oeWO7nUbd3e1t8Lx9KVXQwrimZxFp46fSI4NHPtobOCT"
    "11nZI9qzMqSsGQClBR4JZgAk2FGaDCFYQxMToDSouSWBfMfN33Ws/KH6lWtfmZk8q5YFCjSv"
    "q29e3b2nr7ejUQhipUFEDAJxZtakY4cPX5gaOvrX6eToO15h9BizKgBQ1UsvbEyAhOCpTJ4m"
    "R0bzPb09NYGgUYECIITklpWrGvLp7j3anjuEybOp+anicqBgJL6uobnlllgsTEoxKa2hNKNU"
    "dunU8ZMXk+c//XNycuRvxVT/B8wqA6AMwL0CBgCRwPjELH144E+HksdefnHo9Omk7SgCRMWE"
    "JCgUDVK0vmmbL5zYcPncy4GMYLhmZ0tryyoSAooZWldkP38h5U0N9b+XTl9808x8flwQWVU/"
    "XbblczkcefvvB5MnX/yZaZYOZsdOHUqm5jwIYlcBlqNguQwjVtci/LG7Oru6fEtNFulLBCOx"
    "bbF4DFqDiUAkgGLRptGhcxOF7NhbVm6iH4Ctmfla6YhnB98ePrn3GQCD5lwy6A/GVl84e/bW"
    "THldBwQqYYPBrmeQpsA2EWqvB4aTVygUDEebgtF4rz/gh9ZMSjPAQCqdRz514UR+dvqYspL5"
    "aylTcR/DTZ7c+wgJ3yAAs5AdzXt24TNrZqi/XFbwWECxgIYgkgYolOgmEWheYjKlUR+MxFt9"
    "hgFPa2gGNAOzBQuOmT0N1iml4V0vWbL2TADTrN35oOcF/DIlvbkzWldiEQkJEgRhGBChumYh"
    "ZPMyPsRRXyAcEUJAM6CUhmLAsjzYZm7UKU3nbzCB82Int4vpnFTmGGsCCQkIAZABISVksDbI"
    "rGNLgVhLZgGlGUoxFAPzeQsk3cbmVvVlaxx/KKr9gYCqwEgIISGkABEBQoJAxhIgYmU7Tsmy"
    "XQ+aCZqBbNGB6WhARJv98c7Ql64m29aFhS++gnw+kBAgIaoqSWin4AgoexmTuTkrPztddjSK"
    "ZReDY7M4fi4Ny2VQpGGtlIHE/ODtu18CAHzrF0M3BCRlsJ5DTTf5/D4QyUrgJAmGAMrZLMOd"
    "WaqQKmXK+ezIRHIO/eczPDlTgtaA8PsRSLTforTo69j8sB8APt7/CHrvfHrfwd/2XBfmtvt+"
    "HPBg3Ey1azYbwYpCQkqQEMwsIOzchG1ll0ZqZSWzZjH7+dhkGo6nSIjKLSEF+xIrexBsuCcY"
    "rusCgN57n/1dgep/AMC3HMT2u3YvpKNwba8jG+4TDZ1twid53lQgQapcBrn5M9mpgeklQJ7r"
    "lpxi8rBXnEmDqOJwlYv80YhP1nc/pFy1Zc2dT+8TjT1PhGobAGBZv/r4X/sBALv2/KrHVXKn"
    "V9v3gL8mbAgSRFRJH0QCKp+c0+XUB8WSVVouuXpcTp905lKng/WrdopQGFShAhmS/fWru1Uw"
    "9pyI1jUGoiF2yh5d7ZCw7fb7RVPHbWvzRXtnKdjzuGzqXm34iCuFCYMY7Fg2VC45YM2MHgUW"
    "4puxEGF9bObGxmTwzGuBuvYNvlBbAtV6BgDJgMFGsKmRhGQQUfX/S+17P/q5dKg2opWO5XJz"
    "K2dKvketWN+DVN++2h8inl+IwYAGuZnpImY+OzibPjdiGAH2PPtKINYuAJTc0uhbxbEjt/vi"
    "zd8JxiIMoopQQAVCVPq0CChTCDxsWfl2R8Y3loMbtuvEyg5/NGgIQ/L8KaC6CJtFJmf03U+s"
    "2aGDZnGueK2KUTu58WGfP7avNHK4zVjz9a1GOFRlEZdVy0utddZc83J8VRuEIeELGRA+wUSi"
    "sotL5S/glFxyBl//AvnTv5+8cGpwcVQXi8O+AsxiduijcurkC04+mVnIB/OqX3L2y+fFQol6"
    "hGv9CEQNSINAEEQgMBFQcWR2LY3yuQ+GOf3pC+ODR94FYC5O1ouBsGrbY6w9JxNZsXWHEW1q"
    "oCoALVGFrlyHq6cMBphE5aRRsTADBKsgyex/bdCbeOf55PDRV2zHzgoh+bpF/sTRF0Trpp88"
    "H2jZ+ENfMAjWGgwCCQKxhgZBKAYrtey5nGmepVL8OpYHezppuuf/cdybPfGH6dH+N4ulYhqA"
    "0nrpGkuAGnp2bSiapVpn/MiBwoQUlSBGlZCP+TwkyTFt70qFCQyC1gT2BKmyBW92vOTNjI54"
    "Fw//08oOHJgaHzgBoCCEXBZmie4kDLD2wgAarhb0LptngWQSrGwA8bZv7s2F4yFPFaYKMNMZ"
    "baWGvML4EXN29PBcZuyM45QzAMq+QIhd2/rPP8dcp8W71t3xmFWcJWJ32jLnJs1CesK2nSSA"
    "Iglps1b6K/0+dM1sbgR8yrPDAGT1FOJWo6+H//X2b6dfhpu9g2WfAAAAAElFTkSuQmCC")
getcycleData = cycle.GetData
getcycleImage = cycle.GetImage
getcycleBitmap = cycle.GetBitmap



download = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9oKHQIfCFe3UMgAAAdU"
    "SURBVFjD7ZdrjF1VFcd/a+9zzr13Xpe+pjBthbZAsaXyKBS0mFggpcEoUYypoTClNW3VECRq"
    "qA8iKlF5mRapOoW+REBEMcEYA2JrGi0RKhRKW4QODG0ZOm9m7sx9nrOXH+65t7fQ4rTBb13J"
    "yrln37X2+u/9X2uvfeCknJST8v8VGY3RLxdTbz3b5KJIKz5SO0c8KgpOEKOgNQHUMbTiETIA"
    "99/eQvPuTr74+CgBbVrRgJ9s4ro1nfxqMRMQvnT6OXM/mx4/6TLnokjKPkaMhxhrRDzBeCLW"
    "ClgR64kYDxELxqBOeffQ6/88sOfvfwhL0WPLNxU6ARxgRgPo4ZtP5bo1h9i0Mn1fsq7p2tlX"
    "LJ8YuHft7ueeRqS8GVbAswZrBWsEzxqMFTwjeMZgDXhWsAbES6h85NNkdq6j/UB3Ry4fbZ/U"
    "rUv2neWFX7tncHSU/fqrY9ZPu+DqpZd+4ft07vyjvvr8n+jseFWMsQD4thzQiwOXlRhcPG7K"
    "Y56B5ORPqqSnqW1/yOzvLbC/O/sMolfd8IuM27y8gdZ1w9XY1V3bvLIRgAeWmO+edcm1iy+9"
    "9jYyXf/RgXde42D7LhERVXWgDlVF1R1VqSgOVAG0cGCL+HVjJZzwCW1uMpw2ru7KMHSP/mZZ"
    "Q6IWTHWHNq1oYEnbMBu+nLh++kXXbLz4M9+yxljt2vsUe3c8RSE3LKqHM9UYxYhgjOIbRQQ8"
    "ATGCNYpFMKJYq1gRBKdOkInzvq19z95DaaRbegeL7mB3Zq0R+boB1/rA8JGUrV/mX918xoV/"
    "nt+6muH+g9rx0tNyzpwrkCgPImWtLsMiEiBeANbHmACxARgfrI/YADF+dfpyEQouzPPatgcY"
    "2PN7POtr72BOhobzN7e2Dd8HsGFFuuzx4FJv4aQZ856cMnO+f+iN57t6Ol48ZcHy9Qlb6oWo"
    "wOEi1piFCh0KzqGVd3U1Y2VaBQVVFEXEoo1n8o/Hf0hu4M03U4nE1HwxIpsvrlq6bvhOANn8"
    "lfTZRuwuP9UQuKj0nUzfO41X3/TQqqZ6T6LcACIS50UZgMYByu8uxloODhVaa+yrtmXAkkxj"
    "0zN44p5rXrfGv1uMWRM5lwJW3tg20mY/f0nDOtBnuzq65np+6fWPXb5s46Sps1JR5gBohLoS"
    "6kJUQ9SF4MLymMbPWA/bxvZVrR0roflBxAY6ZfbCce07/7JrSdvIFZ+bkwoRWXHNxcFjR5T9"
    "E7fNfupT1/9sQdIHolJMVExXZZVVqayc6v9aY2tQJHKHbas+gIb44z7Kzq1t+T3bf3vVDWsH"
    "t929aJakx751OKk3LE/O8WxyR6ppAgBRWFIxnhwJYrTdSNmfsgy1tGAwOMpHgYuPC5zTbKZf"
    "5nZliMLsK9evfXf2EWW/cUUdN7Zlq1M+uMS2X9l697SObWsxXuIEGqTS3pBG517OUKmHYpij"
    "EOUohlkKYY5ccYj60uTdP1n05LkAm7/RTOu93QB4ADe2ZdnQCks3V6cUYwQ/WVcu5xPYI+v5"
    "9Od66cnupxBmyZdGyIcjFMIRMoU+ZtRPlvhgdqn93VVfr/LjMJgy19YLCBL1GOufECDPCxAR"
    "BMGIqVH7voO5tvN7x5rUej5BKoWY4PjuMvE1xBhTbicoTh2unM2EURGnjvdkOwDzbgk+CJCH"
    "n6hHjDdqQMNhkVwpjwBZbBlITe9zquTDLKpK5CLDBZxW10w0cTw69dT0wJZ7B4tHjaaqeF5A"
    "IlGH2NEBKjnH1uFuxp01F0QxXhJDP05DVBwYx3DYQyg5MI7TmidOv3XVVS/4XkIPdr4x/HL7"
    "K4uAHd6x9t76fpzUowMUAB8Px7O7kKXUJPQNtxNqEUxENuqjr3AArCPwLKqWbZ2bfEPQPDN9"
    "ue458MrqF1az47JV/rEoE7HWI0ik4DgomzVxOoWudp7NJ2gYP4aB/EG6s/vIRv34SVulX53i"
    "B3W0eOexc9fzP3ruLn46/3uNbL0j8z5AAZBwijViyg1eZNSASi7i/Oap1A31sGUopFc7yDNI"
    "kPSxXvl6AlCKSnp68kJp39H/6Jb7e34OSbbekTlqlTUAyZLaQ/1dHVOSjZPRqHhcJa8oZ09I"
    "8/Y7e2HcuewrbsN4ql5gxFhRVSctwUzp26WvPnbn3rWujwTkU0DuvVdYAcYBYxbMNnMXzT/j"
    "1hmzLpgtYjhq+1A9KpxK68A5/tq3G710Cl3+yyrWYQNhbGKS9L+UGlh/+79uyb7Bi8AQ0A1k"
    "j3anbgTGAumWU5g4aYzUGznuZlZdXa5IacqylpvmLJi6sFf2kErVEbw9vfjwj7evfGt7aTeQ"
    "AfpjQHqsS35jrKnYKDpBPIJggzR1S+66aPOYc7Pnj3VnFn/X9rcf/PuhkSeBQrw7PfFX0Qd+"
    "KJo4wZXja/cC+LFv5emNOY9pi78575G9O/c9/sy9XasBG+dMFigBxVgj4cMVqVRq/KwA88bP"
    "5NSBNxmMcpRiEKUaMIUYoPuwAR3R8OMqrqipyfywRqNayk7K/5L/AoNjeF6iLGwrAAAAAElF"
    "TkSuQmCC")
getdownloadData = download.GetData
getdownloadImage = download.GetImage
getdownloadBitmap = download.GetBitmap


downloaded = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AP8A/wD/oL2nkwAAAAlwSFlzAAAN1wAADdcBQiibeAAAAAd0SU1FB9oKHREaH7dzPGMAAAtH"
    "SURBVFjDzZh7jFzVfcc/v3Mf89rZl71P27tre72xsfELsA0okFAQ4dk2qUQNuAmvJqEqCiqN"
    "qqpKRZWqbdKHmoJUWtWCtjQCK8VVVMWlhFpAZRwb27trL7UdP/Zh73t33rMz955z+sfMrtde"
    "B0T/6pV+mrkz597zme/veQc+w7HlKe+zLGf9V5Nsf+YzXYLi/9khn7Zg61MOACf+QQOwYk+T"
    "U2snd1jLLgvdoaFRG5KOJa9cZlzLkDj8LPDVf5/da+YAVj7rcOtk5fp9+/6PQD1PwO80dfL1"
    "7w1Wzh+nRYc8oQ2blze67Z0r1natXN61vLVxdWxZTbvKFKbtWGqweGnqXPr8yOnzE1PlUTGc"
    "irr8aOCH9C/8wK/BiVc/I9CWpxx6q4oArNvNvb7Hwzs23b57TdvGhmX1zcTiEaJRH8/z8VwP"
    "Yy1hEFAqlZkrlJlJT3Hu0sncsdPv/2RqOviRnmXf0LsYgJ2/pTj8srkukLME5klF797K4tW7"
    "aWnazCNdK9p+d+cNd/3Kri13xtZ0dhNL+BRNmrHsOXt67Ij0Dh9kIjtI2RRtNBqV5Y3NdLR3"
    "0rJspZ+I1G00ZHekdDpouZGZqZPMXDpiuflZh8tH7CcrdNNvwkd/B96vQU+c1fFo9OmWZe2/"
    "f/MNn2fHpjv5+cRHfHDmLTuWuSyeB64rOI6DiMJiMMagtSEIYHmiyd7e86uyqf3z9P/8CO8f"
    "e5uxyaG/L8wVXu49Tj+9mF/6Toyf/lHx013W/SgdDTXRFzpa1vz2w1/cTSJey4HevQynPrbi"
    "IJ7nolxBFIiShZtYwBqLNRAGIWGo7Yq6z8m9m75K1E3yr+++xscXet8tlovP9++lD+ChP6/l"
    "xy9klrps+5MOo8crEjZt5rGOts4Xv3L3E4zMnrb7P3qJ9NyEuJ4jrudUYBxQruA4oBxBOVKB"
    "E0AEpRRKHMkUp+gf/sCGYSgP7XqCMxf6VptI1vQ8oD4+/65JnXm7dP0YatumGD1uWbebX+5s"
    "W/F729bvao7EXA70vgrK4rhKlCsoFxxXKuYIjldVygGlQKRituoAQaG1ZiI1LI64PLD9aVLu"
    "uR3p4NJ4946aj869Vw6vKoyb98DmPXBsr2bjY6xKRNWDXW2f29i1Yi0/7X8DixFRiFIgCpSS"
    "qiKg3Io6jl8BUy5V9aprVLX0ihHXde22VffY9W07uan1IVpi676ta3OPANz73fgVhcb7YLyv"
    "ctKwkRduXLflme6u9f7g9ACDkyet67miFrmlolLlvbNYsXl3UZXHgjYGbTQttWt49os/kA0t"
    "t4mDxzK/yw6mT8RGM2dKXTv8Y++8ODe7pHWsfZSW2hp/S3Nje41VAQNDH1qllMwH7Lwr5lNB"
    "xIIYlKMqgN58HFWU1DYEgRvabuWbX/grdq59gES0Hou1yUijrKzdSEOk4zYTCb+0kBGLgXzF"
    "Hcvqmzs8z2c2O0GulBcRtSQPRcAYjbGVwhma0qIlAqIIdAnfiXJL5/08vvMPuWX1l3CUizEa"
    "a62U9RydyW2013avcmJmE8Dub9QA4C7cSnFbTSK5xlAmlZuy7hVxruQ0QqDLxLw465t30t7Q"
    "Tf/EO8yWRnAdD2OgFBSp8RvZ3n4/92/4Jt1NN1fcp0OstVhrCU1gW+LraEp0iJ9xmkDzw1dy"
    "13R7y7pYpKbWoEkXphEU1oI1FRhroRyWiXm1bGm/m1/f+h2evuWvuWv1k8RUPUFZUy6XqPWa"
    "uWP1ozyy7Q8qMFgsFq01xph5KPEkKm5Qi85EE7d/i5XzGAsKYYjF/SSh1qTzMwICi2CMtcTc"
    "JHd27+bL256ntW4NAA9ueI5McZKD519HHMWDG57jnp6nqYk0YK1FRLDWoLWuQGlDEJTJlGdI"
    "zWaYHbJzs7krjnAXTUbK9yIEYYF8MYsf9TAWlLVYI3gSY8+uF7ln0x4SkbqFzXwnxuPb/5j8"
    "XJabVt3PtpX3EHHji2Aq6oRhWDEdcmHyJIPpE0zMnSXi+3FPFZYDI1cDgYRhgHEMoKotwGJ0"
    "JWOev+9vuWPDl4lHkle8XN3UUT5fv/1vUFT62lWhZy2lUolyuYzV0Df8Hv9y+E9obexAxCXU"
    "oVaK4HoTY5CbS2O0Ie4lMWGlJxkNYhVvHvoLzo31Lel781Cu8lHKWVBFRDDGUCqVCIMQHRre"
    "Pvkar3/4XUZnz+M7UcIgIJvPFT3fm1kC5DjkimEWiyHmJa0xFqMtxoDVwuDkGV76j29x+OyB"
    "avrLgs1nz5XSIGitKZVK6MCQK2Z482ff58cnXmEiPUzMS6LDkHwxizGExoZjS3pZ6xY2Jmri"
    "G+LRmoQ2WlK5KRzlgFQrsLVMZS9xafYsyUgDHcs2IEqugrPWYowhDEOCIMCEMDJ1nn2H/5KD"
    "/7OPqcwoaKiPN1vfSchsZppULvX+ydf49yVAzZtQypOt9cnGVZ7rMTY9ah1HyXw1qgwZivH0"
    "EKOpC0TcBCvq1yEoQh0uBG4QBATlkCAIOXv5OPuPvszBgTfJFGZR1iMoa5rrVglWkcrNDOUK"
    "ubcmezmy9WswdmJRUJs0H2ai6cFiKX9rfV0DyXiSYimPW+mOYC3iCI7yODV0hFL5e+hAs2Pt"
    "fXiOj7GVAQ0rlMpznB09zoH+vXxwej/GgFgPHVpcFbU1sXqZzcxQKGaPY3kPrszZjvNcDLXT"
    "Y/yfwqDxRla4rmyNxxPJumS9TKcmLcbKQqGuhokjDpOZUc6N91EfbaY+1orRhjDQ5AoZTg0f"
    "4q2jP+DQ2QMoFGIcjLZWh5b2ZWskGo0zPnkpPzU9+4+n/pn9V81DX1kVsiEbMjAAzRsjvblC"
    "pt51ndtbW1skNGXJ5/OVcLUiC3FrBYVDpjDDwMiHNCVWkfSWUyoXOXbhv3jz8Pc5NXIUT3lY"
    "DTYEo63E3IR0d9zA8OVzZmZ24lWj7d7xPmZ2fQNGjlaBBgZgYAC2P+PR91o5bNlCXttyq8X2"
    "dK5aTao4ITq0YjQWa8VawdqqC61iLijQe/EgTTWd9A9/wP5jL3F55iKeeFhtMcZiDNZRrvSs"
    "uZFMfobxydGhbLb8pydf5+i3h13eeMx88ky96XF2NyxP7u3p6Y56vseFS2fJ5/I2KGkxen4U"
    "EURV6g1INY40YbWJYqrlQCCeiNnOtrVSk0hyovcEuXTuN1In2Td0nDnkSigseQwSB8GC38CU"
    "GzH5bC5zVzThm84VXaJckcAUrYgRUQosGAOm4g6CMCAMNNZWgV1LJObZ1uZWWb2yRwI9x+nT"
    "Z8ilC69kRuy+wUPMVOug/UXPZYJFAX5mULTWZlB54cW5oLgxXyjUNjUvl4aGRnF9B6u0xTGi"
    "XBbGV9cTXB+cqBBPRGlsXGZXtK6UZKKO0bFRLo+MFSZH8n82fca8cfkoE9ZcPdhcz2UCOAg+"
    "Fh/w/Brq227hC8kW577WjvqHm9obnERdFOUoTGgJymVKwZwNggBHefheRHwvguMKFks+O8fU"
    "aDqYupw6MXWx/G/Tp3mnMM4YUEYoYZkDylTmCrNUoYqEqtp0PV3Gpi9yISzbmXy+WNKU6sIg"
    "rC+XKrONchWu54gf8cVzXRGEcikglymSms4yNjQzOdg/+/70Gf2T0aP8Z5AnW904XGSGhSl8"
    "qUKqCukBEcAHYkAUaGrfyd2xBrY5UdqitaohWR+rjcb8qBfxvbAc6mK+VMpnivliWqeCIlOl"
    "FB9P9HEoKHIeyAFZoAiUqhZUoa4LNH8uVSi3aovBIkDMraGrvoMNfoI2J069GyGhS1IOCjat"
    "C8ykhzlTynCxCjAHFK4BmVdHL4b5RWkvi2xeMWcRpF99Xfz5/HpddYGuWrBIhfCa7+2nBfUn"
    "/RExDyfXxNpieOYDs7qJuSY+zLVqXO/4XxPXfzH++yNnAAAAAElFTkSuQmCC")
getdownloadedData = downloaded.GetData
getdownloadedImage = downloaded.GetImage
getdownloadedBitmap = downloaded.GetBitmap


error = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAACQAAAAkCAYAAADhAJiYAAAAAXNSR0IArs4c6QAAAAZiS0dE"
    "AP8A/wD/oL2nkwAAAAlwSFlzAAALEwAACxMBAJqcGAAAAAd0SU1FB9oKHREnGTT40egAAAoH"
    "SURBVFjDpZhbbBzXecd/58xlZy/cJbm8rmjKiqxb3AixCyeK6+bFNtBARuqmaYD4kosh1HAS"
    "oA8F+pY+BH1oDPehcGI3taP6UjWJBdRCgqQwZMc1mti1VANWZevCOJYsU5S45C7JvXB2Z+ac"
    "rw+7Sy0pynaaA3yYmZ2z3/md//ed28CHFAsI8I/8fuVZ4JmPUM/9sArqGr8/Addr2OfAlIKS"
    "goJA1cIlC+cFjh2A2V59+QBfHxno2Q1ODsI2DfdouG1gcnJ0eHQ0n0mlBlzPCxzHcZMoiuN2"
    "u90Mw+XK4mL9XyqVeQ2vRPDsV2C+5+ffgHt+RwH4V+C+7v0PoajhQCadvnVyx45b8oXCZGAM"
    "QRjiRhE6SdDWIkphlCL2PELfJwRqy8sX3z937r8R+ZWGf7oPWgCHgHs/KlB/D56CmxU8UCqV"
    "7hmamhoaTqXINZu41SpSrUKjgbJWADSA1opsFgoFkkKBmu9TDkOWL1+eKy8vP5fA9x6A314L"
    "Sm0Wpvs7OeKm4TY/l/tGcXz8L6ZLJQpKITMz2MuXRfu+ciYn0cUiqlhEDQzAygpUq0ilgr10"
    "CYlj0ePjSqamKLdavF8uU1lZ+WEURd/34cSXwT4NfPVaQD2Y7v2+VCbzD+Pbt996w9atqNlZ"
    "zIkToj1PuXv34t5yC/rGG9E7d6J270ZPTcGFC8iZM9iZGeTkSezx45hTp8TGsdK7dhFms5y9"
    "dIlqpXJ4td3+u6/D/wI8CRz4oGQ+CHt+HATPvLhrl8x94QtyfmREzoOdzeXk8v33S+XYMVkW"
    "kVoUST0MZWlhQSoXLsjS/LzUw1AaxkjNWll+7TWpfPGLMp/NyhzYi8PD9uJnPiMvjI3JIa0f"
    "fRK2bGzb6d0cAv69A5N34MDgyMhf7bn5ZuLXXhNbLuN+7GPKf/hhvIcewtmyBd1uowFTrzPz"
    "9NOcfPRRlk+fZnj3boJ8HlotmJxE3X47ats27PHjyi4sKKyVgZERFbbbn2q1WvUj8J9056jn"
    "e3nYXzR8fnhk5C+v274dmZvDXL6MGhwk9eSTuPv3o4MAbS1KKRzHIV5Z4beHD9NaWGD2xRdZ"
    "OXsWiWO046CMQWUy6LvvxnvqKSQIMHNzZJKE4tAQhXT6jqdgf3/urAHd2xneY34Q3DpQKpUG"
    "83nCN95AQPnf/rbSO3agXHftj0oplNZoz8PEMSKCJMmVdz0DVBCg9u7FfeghJAhU9O67FIOA"
    "gWLxjwT+lL7c1T8Hfn4lw28vTk9/dmhwkOj0acRace68E/euu1CZDFh7Vb45nkdmZASlFGhN"
    "engYN50GkSuVRFDpNM6DD6L27sXEsehqlQHXZXBoaM8TsG8tQvvpatYB+pSfy92Ydl1a58+L"
    "KhRU6lvfQg0Pb579IijHIT0+DkBqeBgvl0MBsgEIEXSphHfffaiJCZUsLJAWIZ/P7/TgcwDP"
    "9Yfse5BO5/NTnuNArYYBRbGIs28fiCDWrm+k16jWZCYmAMiVSmjfRzbW6V4linDuuAOKRYy1"
    "4icJKccZ0/CHAF/qB/Jhe3Z0dMADkkqlo9j0NLjumvwicpWhNZmuQpnJSZTnYY258r5fLRGY"
    "mIBCAQtKRRGOteggGPpn8NYltYIRPwhyWgSzugq5HHrPHtjEec+staAUwegoKNUB8n2MMVhr"
    "sV1V13XA9+G66xDHwbTbKGPwPc+6MMGGYT/seF5eAabVQjIZ9LZta6HaCGKt7SihFMHYGADp"
    "8XF0n0KbqpokqOuvRwYHMXEM1uJ5nuvA8Lrth4KU0tpFBGMMqrc56ybkul7CmjpoTboLFIyP"
    "r4Wsp84afHeE2p6fPlitlLaQWqeQwGISxzWjFCqdxjSbxGfOdBx0ATaGoadQamQEESE9Noby"
    "vHUhW1e/24n4nXcwS0vgeViliOI4VlBZB6ShaqKobkQglcI0myQzM4hS68LW31CvMZVKkSmV"
    "cHI5LGCSZA3qqnC32yTvv4+xFnFdTAdI2rCwUaFzjUqlEQF6aAgDJBcuIElyleN+IJMk4Djs"
    "+eY3cQcGMHG8abistVgR4vfew9TrGBDj+xitMa1W/CDU1gEdgGq4uFg2xsDAABYkWVoiPHq0"
    "E7JNGuipgOtS/PSncbLZq8K1Lmy+T/sXvyBZWAAg0prYmDoiJwH+GtCHuit994TxVtxqzUZa"
    "4xaLKl5Zof6DH5CUy5s3AiRRRPXkSX5z8CDzr75K3GxelXO9RI7PnCF8/nnixUV0oaDaStFc"
    "XX1H4CWARwB97/pt5IuNcvn1eq1G6oYbsCCt11+n+ZOfYFstxHHWKSVAEobMvfQSM48/zoUj"
    "R2gtLSFar1dGKUwY0njiCdpvvYWAyMAALWNo1mpnBF7prfjrth9fh9P1avWVerkcxqkU/tat"
    "SkDqjz8u7VdfxTQanSTvKWAMxlq05zGwYwduLrc2+nrAFkiWl1l9+WWaP/oRxhjR4+OqCTSb"
    "zdnEmP/6Gqw8s3GD9hxwGPgzqEmrVbDW3lTYsYP23Jwyq6sqfvNN0cWi0iMjqFQKHAexFuV5"
    "5HfvJpicZOLOO/EGB69MFUlCMj9PePQote98R0yjgUqnlSoWWVxZkaVa7WAdHvsPaD2/Eehw"
    "93oEFvdbG5o4/qwTBPnsxISKymXM0pIKX3hBpFpV7tat6GIRSZLOsHdd0lu2dBZWaxFjAIhP"
    "naL2yCPUHntMbBgq0Vp509Ms1mqyVKv9etbaQ3/jeScy1qr4Q85l2e/C3Vuz2WembroJP0n0"
    "6ttvY+t1UaC86WmCfftIffKTuDt34u/a1ZkqFhaIZ2ZIzp6l/cYbtI8dI7l0CQHR2azySiVW"
    "Wi27OD+/+FYU/e3fwxEgBsKubQrkAcEfwOifw127guC7Q1u2+MVSSUcXL9J+7z3BGKVTKXQq"
    "hfK8juVySLOJtNsQx9h2GxtFguMof2IClcuxuLBglmu1yv8kycMH4ZdNWKZzcGx0TZxNTo4O"
    "kCoD52A+mySn883mjVGzORQUi6TGxpRyXUyjQRyGYsJQJY0GplrFNBokYdgBUUp5o6PKGx8n"
    "tJbF+Xnmms0TLxvz/R/D8SasAqarUAS0r6WQVpARyAABkH0A/ngr7Ns5NHRXPp8f9YMAX2sc"
    "QKIIoqizijsOOA64Lom1RElCq91muV6/fCoMj56CYz+DN4FmF2C1q0z9g4B6u4AMkAXSAHtg"
    "2x1w25Tvf3ykUNg+mE7fkHGcgupuvHq7AkQwIjTjeGkxDN8tN5vnLhpz9qfwehnKQNIN00YY"
    "4UO+kLhdhdJd8wA1CJN/Ah/fDp8YhGnX8wLtuo52HC9JksTEcRIb06rA7Cl4+5cw04LF7pwX"
    "9cGsdpWKPtLXj41JDvgKAuk8676JNRXA0HWQfQca0ulx0ufbdp/bfUBhvyq/K9BG1VJd64Hp"
    "vhlf932fsn1J2+6CJJtB/D5A1yo9xaTP/l/l/wB3gA7/SnE2MAAAAABJRU5ErkJggg==")
geterrorData = error.GetData
geterrorImage = error.GetImage
geterrorBitmap = error.GetBitmap


from logo import retriever_logo_liberation as logo


warning = PyEmbeddedImage(
    "iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAABHNCSVQICAgIfAhkiAAAAAlw"
    "SFlzAAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoA"
    "AAqZSURBVGje1ZlpbFzXdcd/9y0z82Y4nBku5iJxEUmZskUtprJUSWDUiVF1MdKkgqRYiYso"
    "COqkS5AYiF3bDVwhUBoYbWo4QIEuyCd/aQ00cBsgTd0ABhzLa1xFce04kiWKkkhJJCVxm+3d"
    "e08/vMfhcJPVxrKYCxzMw3333Xv+5/zPuefeUSLCr3Nz+DVv3g2Z9bByihUOi/A5IAD+o5Li"
    "K02Pycx7vZS6ERSaf1g95fR+bK+/494UXhLz5jOh+cW//086yW4ek/K6plDxEXWP2zr4B4nf"
    "OpISGyJzF/HufNB3NnxwcL7EV9e3B5RSxYedk4lP/30froc99RyIRXXegZPtoPzPn5sNE6Y7"
    "/5hcXZcemH+Ie53+uzqd9m3Yc6+B44HjIxffgIY2vC33JP0Sj65PD9yv/GKrfzZ54Kk2KU9j"
    "x16P+sWCNaimPpz2bVSe2ltEwoH0ERlfVx6YK/BH7uDv5VW+B3vpTXD8WDxwPOTKaXCTuDs+"
    "kxDLX60vCh1WaeUHR7wPHErasf+O+txF5VEOoLBnXsC74z5P+cH+mQfV5nUDoFjiAW/b3kCl"
    "m7GTb4NyUK6PclxAgYpEps9CWMLbdSjpunxnXQC4eljlVSL9597OzybMuVfAGhABaxCxK8ab"
    "08/jbtvrqKDw8eKjavimA/BLfMPdeTChHBeZ/GUUtGIQE6KyrTitvXGfjYDNjcPMGP4HDwVY"
    "vntTARQfVR1OJv9ld+unfHPmKFgdiQlBDO6G23E7tqBcP/aMRcRiRp7HGdijVEP7jrmH1cdv"
    "GgCjOeJuv9cnLCOX3wGjayCc5m5UIg2Oh9OxBbEGsQasxc5PYSdP4Oz6fEbkV/PC/xvA9MOq"
    "z2ZaDrq37vHsmRdiC5sIAILTviWiDILT2odKBIiYGhAz8gJu924k190z/aDa+74D0Jq/Tmw/"
    "4Mv8BHZ6FLEaMWHE/VsGUH4CiACgHNyuHYjR2Di4bXkaM36cxPB9GW15gv3Kfd8AXPq62k5D"
    "x+/6fXc6ZuQoYgxiNGI0OC5u52BkfZEYg40oFeQgHifWoEdfxG0fwmkdLFzs4gvvGwBleCLY"
    "8emEvTqKnbsAJow8YDVO520o5UZ0WqCURAHs9Q7H4wzWaGy1iB59heTOfRmxfPvcAyq44QDG"
    "vqY+anMbd/vdH1LmzFEwGhvTR3kJvLbNIIZLl6cZGZtkZGyS8YmrIBY3347KtUeeiuOhevan"
    "OPku/I5tKcfylRsOQAzfzW7/ZNJMvI0tTmEXKGE0btd2UAJiePo/j/HQEz/goSd+wD/+64sg"
    "GkST6BuueUCMRnSZcOQoqW2fTFtRfzHyNZW/YQDO/Jn6Hae5Z4vXMaTM6CsxlyNRqQzeLZtq"
    "tGluTKK1JgxDculoHxBrcRoKuM3diI0D2mj02M9RqRyJjTs9V//fyu3rB6CUsqgnG7buCfT4"
    "z7Hl6diCIaJD/N47ENE1jrfkUuhQo0NNIZtEJIy8YA3J/mHE2ChriUF0lerpnxDcvidlRP3x"
    "mftVx3sO4J0vccBv6t3gt/Rhzr4aUWDB+g1NuM0b6oJW05ZPEuqQUIc0Zb14n4g3uSCD3zlQ"
    "y17WasJLvwCEVM8HPO3xrfcUwHOHlWdR38neflegzx/DVuYRHdZ4nOgfrss2kaKtuSRhGKK1"
    "pjmbWCwzxIA1BH13gJK6WAipnvoJweCdCYt74K0vXV+5fV0AOsb5YqJlU95vbEOffz3KOnHm"
    "cQrtePnWmnUXpKXRj3J9qGnOJsGG8buISspPkuzaGnnAVLGVOSrnf4a5eo70htt9B/7mPQFw"
    "7gEVGHG+ldvykUCfew0bVmpZR6wmNTBco029kq6yFBoShDqkNefXvTdgqmCKpLr6MfMT6Muj"
    "6LmJCMSJ50j17vIs3ifeuv/dy+13BXB1hq8GrT0pN5UlvPAm1oRYEyJG493Sg5vJLbF8PYiW"
    "XAKFkAuAcA6q01CZgPIUVGdwlCFz667FTVtAz17EzIzR0LM1ZSxP/koAfnq/ylnUI/mBXUF4"
    "9tUl1jdiSA/sXEadMBJThnCOQrJCeeYSqhIpjC4tixVLZmAnKshGFYeAFaiMvEywccjBTew4"
    "/oVrl9vXBKCqPJpp6/Yc10VP/LKWdcRokp2bcVLpqPY3ZQjnYwtfhsoVCOf4+oEhPratve5A"
    "Y+qeI1GOQ+PW3YtlE2BK04STp8n2bs0Yrl1urwng5YOqTUT9aa53KBWOvorV4aJYTaZvC4Sz"
    "kdLVWdDFiNuia8rmMz6Pf3n3MuXrQBD9Znpvw8s2YeuoVD5/jNQtfcrxUl2vfX7tcntNAI7P"
    "N7MdXa6jy4SXT2N1BRsWseVZgu4BHM+N6bCoSL2Soxdm+MvvvcRj33uJ0+NXlll+mScQckO/"
    "sYRGtlKkeukkuU1bsyL87dNrlNur3k6/8odqk0XdV+geTFTHjmHtgnNBJVKkN++IF1Zxv1om"
    "8Mg/vMSPXj0LwJsjl/n+N/fU5lg46NQ/pzt7STS1UZm6uPCG6vhbBFvuxk02FLrs3CHgn67L"
    "A9ryeL5zo0dlFj03scQymc07cVwPic+3rJDIum+cvlyb72cno6JvpfVNTQRLYejDS2hkTJXq"
    "pRPke29tsMK3X9y/stxeAeC5z6ghK849hQ19XvXCW0vOJU6QIbPptiW0WQpkkUKHfntxI/3s"
    "3f04cZVaP06WfZ9qaSNo71qSViuTp/AzORINuWToriy3V9yNPn9QPdvW1X1XY3PerY4dj90c"
    "ASjs/CiZ3sHFy6oFyii1MF3dM5w8P0slNAz1FhDq1qmtGVNJFn+r01OMPvvM4ngBL78RSbcw"
    "9saxWanQ/ZvfX7zdXuKBH+9Xu8XxPtLYvtGtTp5CcBAcrHLwsgUy3f2R5WsJT6L6v75v4f5H"
    "hIHOBrb25GILL5h1YeyyeWJJ5Ao0dPcvWbs6M46XSJHKN3kqcB5Zi0LKcdwnWzd2BbZ0BdHV"
    "+F4zknTPrbU7zoVArft0sU+punhWy4Sl3lrxfSS5/sHFe1XHA+VSvTxKoas30Eb9ybP3ZjpX"
    "ZKEfH0ztcf3kbbmODUpfOgGJhpqTAWbeOcnsudHawjVCCKx6QS8sHXeNflnWb0ONSjbU8hsC"
    "ploi6SXItrS60xNTR4BDS2LgR/v9/+ru7/lEY0szdm4ytva1F1qtfxVdV4C8nv4Va4jF8ZKI"
    "l+bM8eOl6X2fyu7b9y/Giw9b6of7vOF0NodUS6hUY3Snr1TNAvVOr7eMLOtnlfHvCp538ZZI"
    "dI4Oi7jJNLiuST79bwPs421PKeUAHqIuViqlQroxB8YgzuLGJ2oNuqg1VlZrKKzWoBtrj68l"
    "LeXgqCy6PI811jt6JXPh95VyvDiQG96eVs+4p85t2rTZTaYam6ILWZxVAvZa/1ct81CcDFfz"
    "1rWot3xFEUFMSLU4y4XTo5XJEj/8u5e1BzgKSADNrusOP/gh94sf3ujdnUok0spxpT6nr8nv"
    "96OJIGJVWA3LJ6b06994UR4vFiuvAVMqzkRpoM3zvG7f91tb0m4hSDipOvLc5KbEaBteKMqU"
    "MeZSuVweBS4CxYXk68aeCIIgCETEWyPh36wmgCildKlUKgEloAoYJSIoVV8X1Da39aL8ctbW"
    "tnARkVX/J44Brbsmqyj7v0TdPXITOG+QAAAAAElFTkSuQmCC")
getwarningData = warning.GetData
getwarningImage = warning.GetImage
getwarningBitmap = warning.GetBitmap
