/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model.utils;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.support.StandardTypeLocator;
import org.springframework.util.ClassUtils;

public class RestrictedTypeLocator
extends StandardTypeLocator {
    private final Set<String> authorizedTypes = ImmutableSet.of((Object)"String", (Object)"java.lang.String", (Object)"Integer", (Object)"java.lang.Integer", (Object)"Boolean", (Object)"java.lang.Boolean", (Object[])new String[]{"Double", "java.lang.Double", "Long", "java.lang.Long", "Float", "java.lang.Float", "Math", "java.lang.Math", "com.fasterxml.jackson.databind.ObjectMapper", "ObjectMapper", "javax.xml.parsers.DocumentBuilderFactory", "DocumentBuilderFactory", "java.io.StringReader", "StringReader", "org.xml.sax.InputSource", "InputSource", "org.json.simple.parser.JSONParser", "JSONParser", "Date", "java.util.Date", "ImmutableSet", "com.google.common.collect.ImmutableSet", "ImmutableMap", "com.google.common.collect.ImmutableMap", "ImmutableList", "com.google.common.collect.ImmutableList", "Strings", "com.google.common.base.Strings", "Joiner", "com.google.common.base.Joiner"});

    public RestrictedTypeLocator() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public RestrictedTypeLocator(ClassLoader classLoader) {
        super(classLoader);
        this.registerImport("java.lang");
        this.registerImport("com.google.common.collect");
        this.registerImport("org.codehaus.jackson.map");
        this.registerImport("javax.xml.parsers");
        this.registerImport("org.xml.sax.map");
        this.registerImport("java.io");
        this.registerImport("org.json.simple.parser");
    }

    public Class<?> findType(String typeName) throws EvaluationException {
        if (!this.authorizedTypes.contains(typeName)) {
            throw new SpelEvaluationException(SpelMessage.TYPE_NOT_FOUND, new Object[]{typeName});
        }
        return super.findType(typeName);
    }
}

