/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job.factories.spi.model;

import com.google.common.base.Strings;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.ow2.proactive.scheduler.common.Scheduler;
import org.ow2.proactive.scheduler.common.SchedulerSpaceInterface;
import org.ow2.proactive.scheduler.common.exception.JobValidationException;
import org.ow2.proactive.scheduler.common.job.JobVariable;
import org.ow2.proactive.scheduler.common.job.TaskFlowJob;
import org.ow2.proactive.scheduler.common.job.factories.spi.JobValidatorService;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.ModelValidatorContext;
import org.ow2.proactive.scheduler.common.job.factories.spi.model.validator.ModelValidator;
import org.ow2.proactive.scheduler.common.task.Task;
import org.ow2.proactive.scheduler.common.task.TaskVariable;
import org.ow2.proactive.scheduler.common.util.VariableSubstitutor;
import org.ow2.proactive.scheduler.core.properties.PASchedulerProperties;
import org.ow2.proactive.scheduler.task.SchedulerVars;

public class DefaultModelJobValidatorServiceProvider
implements JobValidatorService {
    @Override
    public void validateJob(InputStream jobInputStream) throws JobValidationException {
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job) throws JobValidationException {
        return this.validateJob(job, null, null, null);
    }

    @Override
    public TaskFlowJob validateJob(TaskFlowJob job, Scheduler scheduler, SchedulerSpaceInterface space, String sessionId) throws JobValidationException {
        ModelValidatorContext context = new ModelValidatorContext(job, scheduler, space, sessionId);
        for (JobVariable jobVariable : job.getVariables().values()) {
            this.checkVariableFormat(null, jobVariable, context);
            context.updateJobWithContext(job);
        }
        for (Task task : job.getTasks()) {
            context = new ModelValidatorContext(task, scheduler, space, sessionId);
            for (TaskVariable taskVariable : task.getVariables().values()) {
                this.checkVariableFormat(task, taskVariable, context);
                context.updateTaskWithContext(task);
            }
        }
        return job;
    }

    public void validateVariables(List<JobVariable> variableList, Map<String, Serializable> userValues, Scheduler scheduler, SchedulerSpaceInterface space) throws JobValidationException {
        if (variableList == null || variableList.isEmpty() || userValues == null || userValues.isEmpty()) {
            return;
        }
        LinkedHashSet<String> groupNames = new LinkedHashSet<String>();
        variableList.forEach(e -> {
            if (!Strings.isNullOrEmpty((String)e.getGroup())) {
                groupNames.add(e.getGroup());
            }
        });
        LinkedHashMap<String, Serializable> variableReplacement = new LinkedHashMap<String, Serializable>();
        LinkedHashMap<String, Serializable> updatedVariables = new LinkedHashMap<String, Serializable>();
        LinkedHashMap<String, String> updatedModels = new LinkedHashMap<String, String>();
        this.addGlobalVariables(variableReplacement);
        variableList.forEach(jobVariable -> {
            if (userValues.containsKey(jobVariable.getName())) {
                variableReplacement.put(jobVariable.getName(), (Serializable)userValues.get(jobVariable.getName()));
            } else {
                variableReplacement.put(jobVariable.getName(), (Serializable)((Object)jobVariable.getValue()));
            }
        });
        variableList.forEach(jobVariable -> {
            jobVariable.setValue(userValues.containsKey(jobVariable.getName()) ? VariableSubstitutor.filterAndUpdate((String)userValues.get(jobVariable.getName()), (Map<? extends Serializable, ? extends Serializable>)variableReplacement) : VariableSubstitutor.filterAndUpdate(jobVariable.getValue(), (Map<? extends Serializable, ? extends Serializable>)variableReplacement));
            updatedVariables.put(jobVariable.getName(), (Serializable)((Object)jobVariable.getValue()));
        });
        variableList.forEach(jobVariable -> {
            jobVariable.setModel(VariableSubstitutor.filterAndUpdate(jobVariable.getModel(), (Map<? extends Serializable, ? extends Serializable>)variableReplacement));
            updatedModels.put(jobVariable.getName(), jobVariable.getModel());
        });
        ModelValidatorContext context = new ModelValidatorContext(updatedVariables, updatedModels, groupNames, scheduler, space, null);
        try {
            for (JobVariable jobVariable2 : variableList) {
                this.checkVariableFormat(null, jobVariable2, context);
            }
        }
        catch (JobValidationException e2) {
            HashMap<String, String> updatedVariablesAfterValidation = new HashMap<String, String>();
            HashMap<String, String> updatedModelsAfterValidation = new HashMap<String, String>();
            HashMap<String, String> updatedDescriptions = new HashMap<String, String>();
            HashMap<String, String> updatedGroups = new HashMap<String, String>();
            HashMap<String, Boolean> updatedAdvanced = new HashMap<String, Boolean>();
            HashMap<String, Boolean> updatedHidden = new HashMap<String, Boolean>();
            for (JobVariable jobVariable3 : variableList) {
                updatedVariablesAfterValidation.put(jobVariable3.getName(), jobVariable3.getValue());
                updatedModelsAfterValidation.put(jobVariable3.getName(), jobVariable3.getModel());
                updatedDescriptions.put(jobVariable3.getName(), jobVariable3.getDescription());
                updatedGroups.put(jobVariable3.getName(), jobVariable3.getGroup());
                updatedAdvanced.put(jobVariable3.getName(), jobVariable3.isAdvanced());
                updatedHidden.put(jobVariable3.getName(), jobVariable3.isHidden());
            }
            e2.setUpdatedVariables(updatedVariablesAfterValidation);
            e2.setUpdatedModels(updatedModelsAfterValidation);
            e2.setUpdatedAdvanced(updatedAdvanced);
            e2.setUpdatedGroups(updatedGroups);
            e2.setUpdatedDescriptions(updatedDescriptions);
            e2.setUpdatedHidden(updatedHidden);
            throw e2;
        }
        context.updateJobVariablesWithContext(variableList);
    }

    private void addGlobalVariables(Map<String, Serializable> replacements) {
        replacements.put(SchedulerVars.PA_CATALOG_REST_URL.toString(), (Serializable)((Object)PASchedulerProperties.CATALOG_REST_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_SCHEDULER_REST_URL.toString(), (Serializable)((Object)PASchedulerProperties.SCHEDULER_REST_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_CLOUD_AUTOMATION_REST_URL.toString(), (Serializable)((Object)PASchedulerProperties.CLOUD_AUTOMATION_REST_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_JOB_PLANNER_REST_URL.toString(), (Serializable)((Object)PASchedulerProperties.JOB_PLANNER_REST_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_NOTIFICATION_SERVICE_REST_URL.toString(), (Serializable)((Object)PASchedulerProperties.NOTIFICATION_SERVICE_REST_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_SCHEDULER_REST_PUBLIC_URL.toString(), (Serializable)((Object)PASchedulerProperties.SCHEDULER_REST_PUBLIC_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_CATALOG_REST_PUBLIC_URL.toString(), (Serializable)((Object)PASchedulerProperties.CATALOG_REST_PUBLIC_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_CLOUD_AUTOMATION_REST_PUBLIC_URL.toString(), (Serializable)((Object)PASchedulerProperties.CLOUD_AUTOMATION_REST_PUBLIC_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_JOB_PLANNER_REST_PUBLIC_URL.toString(), (Serializable)((Object)PASchedulerProperties.JOB_PLANNER_REST_PUBLIC_URL.getValueAsString()));
        replacements.put(SchedulerVars.PA_NOTIFICATION_SERVICE_REST_PUBLIC_URL.toString(), (Serializable)((Object)PASchedulerProperties.NOTIFICATION_SERVICE_REST_PUBLIC_URL.getValueAsString()));
    }

    protected void checkVariableFormat(Task task, JobVariable variable, ModelValidatorContext context) throws JobValidationException {
        if (variable.getModel() != null && !variable.getModel().trim().isEmpty()) {
            String model = variable.getModel().trim();
            context.setVariableName(variable.getName());
            try {
                new ModelValidator(model).validate(variable.getValue(), context, variable.isHidden());
            }
            catch (Exception e) {
                throw new JobValidationException((task != null ? "Task '" + task.getName() + "': " : "") + "Variable '" + variable.getName() + "': Model " + variable.getModel() + ": " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

