# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from azure.mgmt.core import AsyncARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

from ._configuration import ManagementGroupsAPIConfiguration
from .operations import ManagementGroupsOperations
from .operations import ManagementGroupSubscriptionsOperations
from .operations import HierarchySettingsOperations
from .operations import Operations
from .operations import ManagementGroupsAPIOperationsMixin
from .operations import EntitiesOperations
from .. import models


class ManagementGroupsAPI(ManagementGroupsAPIOperationsMixin):
    """The Azure Management Groups API enables consolidation of multiple 
subscriptions/resources into an organizational hierarchy and centrally 
manage access control, policies, alerting and reporting for those resources.

    :ivar management_groups: ManagementGroupsOperations operations
    :vartype management_groups: azure.mgmt.managementgroups.aio.operations.ManagementGroupsOperations
    :ivar management_group_subscriptions: ManagementGroupSubscriptionsOperations operations
    :vartype management_group_subscriptions: azure.mgmt.managementgroups.aio.operations.ManagementGroupSubscriptionsOperations
    :ivar hierarchy_settings: HierarchySettingsOperations operations
    :vartype hierarchy_settings: azure.mgmt.managementgroups.aio.operations.HierarchySettingsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.managementgroups.aio.operations.Operations
    :ivar entities: EntitiesOperations operations
    :vartype entities: azure.mgmt.managementgroups.aio.operations.EntitiesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param skip: Number of entities to skip over when retrieving results. Passing this in will override $skipToken.
    :type skip: int
    :param top: Number of elements to return when retrieving results. Passing this in will override $skipToken.
    :type top: int
    :param skiptoken: Page continuation token is only used if a previous operation returned a partial result. 
If a previous response contains a nextLink element, the value of the nextLink element will include a token parameter that specifies a starting point to use for subsequent calls.
    :type skiptoken: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        skip: Optional[int] = None,
        top: Optional[int] = None,
        skiptoken: Optional[str] = None,
        base_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ManagementGroupsAPIConfiguration(credential, skip, top, skiptoken, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.management_groups = ManagementGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.management_group_subscriptions = ManagementGroupSubscriptionsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.hierarchy_settings = HierarchySettingsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.entities = EntitiesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "ManagementGroupsAPI":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
