/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.authentication.crypto;

import java.security.Key;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class KeyUtil {
    private static SecureRandom secureRandom;

    public static synchronized SecureRandom getSecureRandom() {
        if (secureRandom == null) {
            secureRandom = new SecureRandom();
            byte[] dummy = new byte[512];
            secureRandom.nextBytes(dummy);
        }
        return secureRandom;
    }

    public static synchronized SecretKey generateKey(String algorithm, int size) {
        KeyGenerator keyGen = null;
        try {
            keyGen = KeyGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot initialize key generator", e);
        }
        keyGen.init(size, KeyUtil.getSecureRandom());
        return keyGen.generateKey();
    }

    public static synchronized byte[] encrypt(SecretKey key, String cipherParams, byte[] message) throws KeyException {
        Cipher ciph = null;
        try {
            ciph = Cipher.getInstance(cipherParams);
            ciph.init(1, (Key)key, KeyUtil.getSecureRandom());
        }
        catch (Exception e) {
            throw new KeyException("Coult not initialize cipher", e);
        }
        byte[] res = null;
        try {
            res = ciph.doFinal(message);
        }
        catch (Exception e) {
            throw new KeyException("Could not encrypt message", e);
        }
        return res;
    }

    public static synchronized byte[] decrypt(SecretKey key, String cipherParams, byte[] message) throws KeyException {
        Cipher ciph = null;
        try {
            ciph = Cipher.getInstance(cipherParams);
            ciph.init(2, key);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new KeyException("Coult not initialize cipher", e);
        }
        byte[] res = null;
        try {
            res = ciph.doFinal(message);
        }
        catch (Exception e) {
            throw new KeyException("Could not decrypt message", e);
        }
        return res;
    }
}

