/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.NameValuePair;
import org.apache.james.mime4j.stream.RawBody;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;

public class ContentTypeFieldLenientImpl
extends AbstractField
implements ContentTypeField {
    private boolean parsed = false;
    private String mimeType = null;
    private String mediaType = null;
    private String subType = null;
    private final Map<String, String> parameters = new HashMap<String, String>();
    public static final FieldParser<ContentTypeField> PARSER = new FieldParser<ContentTypeField>(){

        @Override
        public ContentTypeField parse(Field rawField, DecodeMonitor monitor) {
            return new ContentTypeFieldLenientImpl(rawField, monitor);
        }

        public String toString() {
            return "ContentTypeFieldLenientImpl.PARSER";
        }
    };

    ContentTypeFieldLenientImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    @Override
    public String getMimeType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType;
    }

    @Override
    public String getMediaType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mediaType;
    }

    @Override
    public String getSubType() {
        if (!this.parsed) {
            this.parse();
        }
        return this.subType;
    }

    @Override
    public String getParameter(String name) {
        if (!this.parsed) {
            this.parse();
        }
        return this.parameters.get(name.toLowerCase());
    }

    @Override
    public Map<String, String> getParameters() {
        if (!this.parsed) {
            this.parse();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public boolean isMimeType(String mimeType) {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType != null && this.mimeType.equalsIgnoreCase(mimeType);
    }

    @Override
    public boolean isMultipart() {
        if (!this.parsed) {
            this.parse();
        }
        return this.mimeType != null && this.mimeType.startsWith("multipart/");
    }

    @Override
    public String getBoundary() {
        return this.getParameter("boundary");
    }

    @Override
    public String getCharset() {
        return this.getParameter("charset");
    }

    private void parse() {
        this.parsed = true;
        RawField f = this.getRawField();
        RawBody body = RawFieldParser.DEFAULT.parseRawBody(f);
        String main = body.getValue();
        String type = null;
        String subtype = null;
        if (main != null) {
            main = main.toLowerCase().trim();
            int index = main.indexOf(47);
            boolean valid = false;
            if (index != -1) {
                type = main.substring(0, index).trim();
                subtype = main.substring(index + 1).trim();
                if (type.length() > 0 && subtype.length() > 0) {
                    main = type + "/" + subtype;
                    valid = true;
                }
            }
            if (!valid) {
                if (this.monitor.isListening()) {
                    this.monitor.warn("Invalid Content-Type: " + body, "Content-Type value ignored");
                }
                main = null;
                type = null;
                subtype = null;
            }
        }
        this.mimeType = main;
        this.mediaType = type;
        this.subType = subtype;
        this.parameters.clear();
        for (NameValuePair nmp : body.getParams()) {
            String name = nmp.getName().toLowerCase(Locale.US);
            this.parameters.put(name, nmp.getValue());
        }
    }
}

